// Code generated by moq; DO NOT EDIT.
// github.com/matryer/moq

package fakes

import (
	"context"
	"sync"
	"time"

	v1 "github.com/prometheus-operator/prometheus-operator/pkg/apis/monitoring/v1"
	"github.com/rancher/norman/controller"
	"github.com/rancher/norman/objectclient"
	v11 "github.com/rancher/rancher/pkg/generated/norman/monitoring.coreos.com/v1"
	metav1 "k8s.io/apimachinery/pkg/apis/meta/v1"
	"k8s.io/apimachinery/pkg/labels"
	"k8s.io/apimachinery/pkg/watch"
	"k8s.io/client-go/tools/cache"
)

var (
	lockPrometheusRuleListerMockGet  sync.RWMutex
	lockPrometheusRuleListerMockList sync.RWMutex
)

// Ensure, that PrometheusRuleListerMock does implement v11.PrometheusRuleLister.
// If this is not the case, regenerate this file with moq.
var _ v11.PrometheusRuleLister = &PrometheusRuleListerMock{}

// PrometheusRuleListerMock is a mock implementation of v11.PrometheusRuleLister.
//
//     func TestSomethingThatUsesPrometheusRuleLister(t *testing.T) {
//
//         // make and configure a mocked v11.PrometheusRuleLister
//         mockedPrometheusRuleLister := &PrometheusRuleListerMock{
//             GetFunc: func(namespace string, name string) (*v1.PrometheusRule, error) {
// 	               panic("mock out the Get method")
//             },
//             ListFunc: func(namespace string, selector labels.Selector) ([]*v1.PrometheusRule, error) {
// 	               panic("mock out the List method")
//             },
//         }
//
//         // use mockedPrometheusRuleLister in code that requires v11.PrometheusRuleLister
//         // and then make assertions.
//
//     }
type PrometheusRuleListerMock struct {
	// GetFunc mocks the Get method.
	GetFunc func(namespace string, name string) (*v1.PrometheusRule, error)

	// ListFunc mocks the List method.
	ListFunc func(namespace string, selector labels.Selector) ([]*v1.PrometheusRule, error)

	// calls tracks calls to the methods.
	calls struct {
		// Get holds details about calls to the Get method.
		Get []struct {
			// Namespace is the namespace argument value.
			Namespace string
			// Name is the name argument value.
			Name string
		}
		// List holds details about calls to the List method.
		List []struct {
			// Namespace is the namespace argument value.
			Namespace string
			// Selector is the selector argument value.
			Selector labels.Selector
		}
	}
}

// Get calls GetFunc.
func (mock *PrometheusRuleListerMock) Get(namespace string, name string) (*v1.PrometheusRule, error) {
	if mock.GetFunc == nil {
		panic("PrometheusRuleListerMock.GetFunc: method is nil but PrometheusRuleLister.Get was just called")
	}
	callInfo := struct {
		Namespace string
		Name      string
	}{
		Namespace: namespace,
		Name:      name,
	}
	lockPrometheusRuleListerMockGet.Lock()
	mock.calls.Get = append(mock.calls.Get, callInfo)
	lockPrometheusRuleListerMockGet.Unlock()
	return mock.GetFunc(namespace, name)
}

// GetCalls gets all the calls that were made to Get.
// Check the length with:
//     len(mockedPrometheusRuleLister.GetCalls())
func (mock *PrometheusRuleListerMock) GetCalls() []struct {
	Namespace string
	Name      string
} {
	var calls []struct {
		Namespace string
		Name      string
	}
	lockPrometheusRuleListerMockGet.RLock()
	calls = mock.calls.Get
	lockPrometheusRuleListerMockGet.RUnlock()
	return calls
}

// List calls ListFunc.
func (mock *PrometheusRuleListerMock) List(namespace string, selector labels.Selector) ([]*v1.PrometheusRule, error) {
	if mock.ListFunc == nil {
		panic("PrometheusRuleListerMock.ListFunc: method is nil but PrometheusRuleLister.List was just called")
	}
	callInfo := struct {
		Namespace string
		Selector  labels.Selector
	}{
		Namespace: namespace,
		Selector:  selector,
	}
	lockPrometheusRuleListerMockList.Lock()
	mock.calls.List = append(mock.calls.List, callInfo)
	lockPrometheusRuleListerMockList.Unlock()
	return mock.ListFunc(namespace, selector)
}

// ListCalls gets all the calls that were made to List.
// Check the length with:
//     len(mockedPrometheusRuleLister.ListCalls())
func (mock *PrometheusRuleListerMock) ListCalls() []struct {
	Namespace string
	Selector  labels.Selector
} {
	var calls []struct {
		Namespace string
		Selector  labels.Selector
	}
	lockPrometheusRuleListerMockList.RLock()
	calls = mock.calls.List
	lockPrometheusRuleListerMockList.RUnlock()
	return calls
}

var (
	lockPrometheusRuleControllerMockAddClusterScopedFeatureHandler sync.RWMutex
	lockPrometheusRuleControllerMockAddClusterScopedHandler        sync.RWMutex
	lockPrometheusRuleControllerMockAddFeatureHandler              sync.RWMutex
	lockPrometheusRuleControllerMockAddHandler                     sync.RWMutex
	lockPrometheusRuleControllerMockEnqueue                        sync.RWMutex
	lockPrometheusRuleControllerMockEnqueueAfter                   sync.RWMutex
	lockPrometheusRuleControllerMockGeneric                        sync.RWMutex
	lockPrometheusRuleControllerMockInformer                       sync.RWMutex
	lockPrometheusRuleControllerMockLister                         sync.RWMutex
)

// Ensure, that PrometheusRuleControllerMock does implement v11.PrometheusRuleController.
// If this is not the case, regenerate this file with moq.
var _ v11.PrometheusRuleController = &PrometheusRuleControllerMock{}

// PrometheusRuleControllerMock is a mock implementation of v11.PrometheusRuleController.
//
//     func TestSomethingThatUsesPrometheusRuleController(t *testing.T) {
//
//         // make and configure a mocked v11.PrometheusRuleController
//         mockedPrometheusRuleController := &PrometheusRuleControllerMock{
//             AddClusterScopedFeatureHandlerFunc: func(ctx context.Context, enabled func() bool, name string, clusterName string, handler v11.PrometheusRuleHandlerFunc)  {
// 	               panic("mock out the AddClusterScopedFeatureHandler method")
//             },
//             AddClusterScopedHandlerFunc: func(ctx context.Context, name string, clusterName string, handler v11.PrometheusRuleHandlerFunc)  {
// 	               panic("mock out the AddClusterScopedHandler method")
//             },
//             AddFeatureHandlerFunc: func(ctx context.Context, enabled func() bool, name string, syncMoqParam v11.PrometheusRuleHandlerFunc)  {
// 	               panic("mock out the AddFeatureHandler method")
//             },
//             AddHandlerFunc: func(ctx context.Context, name string, handler v11.PrometheusRuleHandlerFunc)  {
// 	               panic("mock out the AddHandler method")
//             },
//             EnqueueFunc: func(namespace string, name string)  {
// 	               panic("mock out the Enqueue method")
//             },
//             EnqueueAfterFunc: func(namespace string, name string, after time.Duration)  {
// 	               panic("mock out the EnqueueAfter method")
//             },
//             GenericFunc: func() controller.GenericController {
// 	               panic("mock out the Generic method")
//             },
//             InformerFunc: func() cache.SharedIndexInformer {
// 	               panic("mock out the Informer method")
//             },
//             ListerFunc: func() v11.PrometheusRuleLister {
// 	               panic("mock out the Lister method")
//             },
//         }
//
//         // use mockedPrometheusRuleController in code that requires v11.PrometheusRuleController
//         // and then make assertions.
//
//     }
type PrometheusRuleControllerMock struct {
	// AddClusterScopedFeatureHandlerFunc mocks the AddClusterScopedFeatureHandler method.
	AddClusterScopedFeatureHandlerFunc func(ctx context.Context, enabled func() bool, name string, clusterName string, handler v11.PrometheusRuleHandlerFunc)

	// AddClusterScopedHandlerFunc mocks the AddClusterScopedHandler method.
	AddClusterScopedHandlerFunc func(ctx context.Context, name string, clusterName string, handler v11.PrometheusRuleHandlerFunc)

	// AddFeatureHandlerFunc mocks the AddFeatureHandler method.
	AddFeatureHandlerFunc func(ctx context.Context, enabled func() bool, name string, syncMoqParam v11.PrometheusRuleHandlerFunc)

	// AddHandlerFunc mocks the AddHandler method.
	AddHandlerFunc func(ctx context.Context, name string, handler v11.PrometheusRuleHandlerFunc)

	// EnqueueFunc mocks the Enqueue method.
	EnqueueFunc func(namespace string, name string)

	// EnqueueAfterFunc mocks the EnqueueAfter method.
	EnqueueAfterFunc func(namespace string, name string, after time.Duration)

	// GenericFunc mocks the Generic method.
	GenericFunc func() controller.GenericController

	// InformerFunc mocks the Informer method.
	InformerFunc func() cache.SharedIndexInformer

	// ListerFunc mocks the Lister method.
	ListerFunc func() v11.PrometheusRuleLister

	// calls tracks calls to the methods.
	calls struct {
		// AddClusterScopedFeatureHandler holds details about calls to the AddClusterScopedFeatureHandler method.
		AddClusterScopedFeatureHandler []struct {
			// Ctx is the ctx argument value.
			Ctx context.Context
			// Enabled is the enabled argument value.
			Enabled func() bool
			// Name is the name argument value.
			Name string
			// ClusterName is the clusterName argument value.
			ClusterName string
			// Handler is the handler argument value.
			Handler v11.PrometheusRuleHandlerFunc
		}
		// AddClusterScopedHandler holds details about calls to the AddClusterScopedHandler method.
		AddClusterScopedHandler []struct {
			// Ctx is the ctx argument value.
			Ctx context.Context
			// Name is the name argument value.
			Name string
			// ClusterName is the clusterName argument value.
			ClusterName string
			// Handler is the handler argument value.
			Handler v11.PrometheusRuleHandlerFunc
		}
		// AddFeatureHandler holds details about calls to the AddFeatureHandler method.
		AddFeatureHandler []struct {
			// Ctx is the ctx argument value.
			Ctx context.Context
			// Enabled is the enabled argument value.
			Enabled func() bool
			// Name is the name argument value.
			Name string
			// Sync is the sync argument value.
			Sync v11.PrometheusRuleHandlerFunc
		}
		// AddHandler holds details about calls to the AddHandler method.
		AddHandler []struct {
			// Ctx is the ctx argument value.
			Ctx context.Context
			// Name is the name argument value.
			Name string
			// Handler is the handler argument value.
			Handler v11.PrometheusRuleHandlerFunc
		}
		// Enqueue holds details about calls to the Enqueue method.
		Enqueue []struct {
			// Namespace is the namespace argument value.
			Namespace string
			// Name is the name argument value.
			Name string
		}
		// EnqueueAfter holds details about calls to the EnqueueAfter method.
		EnqueueAfter []struct {
			// Namespace is the namespace argument value.
			Namespace string
			// Name is the name argument value.
			Name string
			// After is the after argument value.
			After time.Duration
		}
		// Generic holds details about calls to the Generic method.
		Generic []struct {
		}
		// Informer holds details about calls to the Informer method.
		Informer []struct {
		}
		// Lister holds details about calls to the Lister method.
		Lister []struct {
		}
	}
}

// AddClusterScopedFeatureHandler calls AddClusterScopedFeatureHandlerFunc.
func (mock *PrometheusRuleControllerMock) AddClusterScopedFeatureHandler(ctx context.Context, enabled func() bool, name string, clusterName string, handler v11.PrometheusRuleHandlerFunc) {
	if mock.AddClusterScopedFeatureHandlerFunc == nil {
		panic("PrometheusRuleControllerMock.AddClusterScopedFeatureHandlerFunc: method is nil but PrometheusRuleController.AddClusterScopedFeatureHandler was just called")
	}
	callInfo := struct {
		Ctx         context.Context
		Enabled     func() bool
		Name        string
		ClusterName string
		Handler     v11.PrometheusRuleHandlerFunc
	}{
		Ctx:         ctx,
		Enabled:     enabled,
		Name:        name,
		ClusterName: clusterName,
		Handler:     handler,
	}
	lockPrometheusRuleControllerMockAddClusterScopedFeatureHandler.Lock()
	mock.calls.AddClusterScopedFeatureHandler = append(mock.calls.AddClusterScopedFeatureHandler, callInfo)
	lockPrometheusRuleControllerMockAddClusterScopedFeatureHandler.Unlock()
	mock.AddClusterScopedFeatureHandlerFunc(ctx, enabled, name, clusterName, handler)
}

// AddClusterScopedFeatureHandlerCalls gets all the calls that were made to AddClusterScopedFeatureHandler.
// Check the length with:
//     len(mockedPrometheusRuleController.AddClusterScopedFeatureHandlerCalls())
func (mock *PrometheusRuleControllerMock) AddClusterScopedFeatureHandlerCalls() []struct {
	Ctx         context.Context
	Enabled     func() bool
	Name        string
	ClusterName string
	Handler     v11.PrometheusRuleHandlerFunc
} {
	var calls []struct {
		Ctx         context.Context
		Enabled     func() bool
		Name        string
		ClusterName string
		Handler     v11.PrometheusRuleHandlerFunc
	}
	lockPrometheusRuleControllerMockAddClusterScopedFeatureHandler.RLock()
	calls = mock.calls.AddClusterScopedFeatureHandler
	lockPrometheusRuleControllerMockAddClusterScopedFeatureHandler.RUnlock()
	return calls
}

// AddClusterScopedHandler calls AddClusterScopedHandlerFunc.
func (mock *PrometheusRuleControllerMock) AddClusterScopedHandler(ctx context.Context, name string, clusterName string, handler v11.PrometheusRuleHandlerFunc) {
	if mock.AddClusterScopedHandlerFunc == nil {
		panic("PrometheusRuleControllerMock.AddClusterScopedHandlerFunc: method is nil but PrometheusRuleController.AddClusterScopedHandler was just called")
	}
	callInfo := struct {
		Ctx         context.Context
		Name        string
		ClusterName string
		Handler     v11.PrometheusRuleHandlerFunc
	}{
		Ctx:         ctx,
		Name:        name,
		ClusterName: clusterName,
		Handler:     handler,
	}
	lockPrometheusRuleControllerMockAddClusterScopedHandler.Lock()
	mock.calls.AddClusterScopedHandler = append(mock.calls.AddClusterScopedHandler, callInfo)
	lockPrometheusRuleControllerMockAddClusterScopedHandler.Unlock()
	mock.AddClusterScopedHandlerFunc(ctx, name, clusterName, handler)
}

// AddClusterScopedHandlerCalls gets all the calls that were made to AddClusterScopedHandler.
// Check the length with:
//     len(mockedPrometheusRuleController.AddClusterScopedHandlerCalls())
func (mock *PrometheusRuleControllerMock) AddClusterScopedHandlerCalls() []struct {
	Ctx         context.Context
	Name        string
	ClusterName string
	Handler     v11.PrometheusRuleHandlerFunc
} {
	var calls []struct {
		Ctx         context.Context
		Name        string
		ClusterName string
		Handler     v11.PrometheusRuleHandlerFunc
	}
	lockPrometheusRuleControllerMockAddClusterScopedHandler.RLock()
	calls = mock.calls.AddClusterScopedHandler
	lockPrometheusRuleControllerMockAddClusterScopedHandler.RUnlock()
	return calls
}

// AddFeatureHandler calls AddFeatureHandlerFunc.
func (mock *PrometheusRuleControllerMock) AddFeatureHandler(ctx context.Context, enabled func() bool, name string, syncMoqParam v11.PrometheusRuleHandlerFunc) {
	if mock.AddFeatureHandlerFunc == nil {
		panic("PrometheusRuleControllerMock.AddFeatureHandlerFunc: method is nil but PrometheusRuleController.AddFeatureHandler was just called")
	}
	callInfo := struct {
		Ctx     context.Context
		Enabled func() bool
		Name    string
		Sync    v11.PrometheusRuleHandlerFunc
	}{
		Ctx:     ctx,
		Enabled: enabled,
		Name:    name,
		Sync:    syncMoqParam,
	}
	lockPrometheusRuleControllerMockAddFeatureHandler.Lock()
	mock.calls.AddFeatureHandler = append(mock.calls.AddFeatureHandler, callInfo)
	lockPrometheusRuleControllerMockAddFeatureHandler.Unlock()
	mock.AddFeatureHandlerFunc(ctx, enabled, name, syncMoqParam)
}

// AddFeatureHandlerCalls gets all the calls that were made to AddFeatureHandler.
// Check the length with:
//     len(mockedPrometheusRuleController.AddFeatureHandlerCalls())
func (mock *PrometheusRuleControllerMock) AddFeatureHandlerCalls() []struct {
	Ctx     context.Context
	Enabled func() bool
	Name    string
	Sync    v11.PrometheusRuleHandlerFunc
} {
	var calls []struct {
		Ctx     context.Context
		Enabled func() bool
		Name    string
		Sync    v11.PrometheusRuleHandlerFunc
	}
	lockPrometheusRuleControllerMockAddFeatureHandler.RLock()
	calls = mock.calls.AddFeatureHandler
	lockPrometheusRuleControllerMockAddFeatureHandler.RUnlock()
	return calls
}

// AddHandler calls AddHandlerFunc.
func (mock *PrometheusRuleControllerMock) AddHandler(ctx context.Context, name string, handler v11.PrometheusRuleHandlerFunc) {
	if mock.AddHandlerFunc == nil {
		panic("PrometheusRuleControllerMock.AddHandlerFunc: method is nil but PrometheusRuleController.AddHandler was just called")
	}
	callInfo := struct {
		Ctx     context.Context
		Name    string
		Handler v11.PrometheusRuleHandlerFunc
	}{
		Ctx:     ctx,
		Name:    name,
		Handler: handler,
	}
	lockPrometheusRuleControllerMockAddHandler.Lock()
	mock.calls.AddHandler = append(mock.calls.AddHandler, callInfo)
	lockPrometheusRuleControllerMockAddHandler.Unlock()
	mock.AddHandlerFunc(ctx, name, handler)
}

// AddHandlerCalls gets all the calls that were made to AddHandler.
// Check the length with:
//     len(mockedPrometheusRuleController.AddHandlerCalls())
func (mock *PrometheusRuleControllerMock) AddHandlerCalls() []struct {
	Ctx     context.Context
	Name    string
	Handler v11.PrometheusRuleHandlerFunc
} {
	var calls []struct {
		Ctx     context.Context
		Name    string
		Handler v11.PrometheusRuleHandlerFunc
	}
	lockPrometheusRuleControllerMockAddHandler.RLock()
	calls = mock.calls.AddHandler
	lockPrometheusRuleControllerMockAddHandler.RUnlock()
	return calls
}

// Enqueue calls EnqueueFunc.
func (mock *PrometheusRuleControllerMock) Enqueue(namespace string, name string) {
	if mock.EnqueueFunc == nil {
		panic("PrometheusRuleControllerMock.EnqueueFunc: method is nil but PrometheusRuleController.Enqueue was just called")
	}
	callInfo := struct {
		Namespace string
		Name      string
	}{
		Namespace: namespace,
		Name:      name,
	}
	lockPrometheusRuleControllerMockEnqueue.Lock()
	mock.calls.Enqueue = append(mock.calls.Enqueue, callInfo)
	lockPrometheusRuleControllerMockEnqueue.Unlock()
	mock.EnqueueFunc(namespace, name)
}

// EnqueueCalls gets all the calls that were made to Enqueue.
// Check the length with:
//     len(mockedPrometheusRuleController.EnqueueCalls())
func (mock *PrometheusRuleControllerMock) EnqueueCalls() []struct {
	Namespace string
	Name      string
} {
	var calls []struct {
		Namespace string
		Name      string
	}
	lockPrometheusRuleControllerMockEnqueue.RLock()
	calls = mock.calls.Enqueue
	lockPrometheusRuleControllerMockEnqueue.RUnlock()
	return calls
}

// EnqueueAfter calls EnqueueAfterFunc.
func (mock *PrometheusRuleControllerMock) EnqueueAfter(namespace string, name string, after time.Duration) {
	if mock.EnqueueAfterFunc == nil {
		panic("PrometheusRuleControllerMock.EnqueueAfterFunc: method is nil but PrometheusRuleController.EnqueueAfter was just called")
	}
	callInfo := struct {
		Namespace string
		Name      string
		After     time.Duration
	}{
		Namespace: namespace,
		Name:      name,
		After:     after,
	}
	lockPrometheusRuleControllerMockEnqueueAfter.Lock()
	mock.calls.EnqueueAfter = append(mock.calls.EnqueueAfter, callInfo)
	lockPrometheusRuleControllerMockEnqueueAfter.Unlock()
	mock.EnqueueAfterFunc(namespace, name, after)
}

// EnqueueAfterCalls gets all the calls that were made to EnqueueAfter.
// Check the length with:
//     len(mockedPrometheusRuleController.EnqueueAfterCalls())
func (mock *PrometheusRuleControllerMock) EnqueueAfterCalls() []struct {
	Namespace string
	Name      string
	After     time.Duration
} {
	var calls []struct {
		Namespace string
		Name      string
		After     time.Duration
	}
	lockPrometheusRuleControllerMockEnqueueAfter.RLock()
	calls = mock.calls.EnqueueAfter
	lockPrometheusRuleControllerMockEnqueueAfter.RUnlock()
	return calls
}

// Generic calls GenericFunc.
func (mock *PrometheusRuleControllerMock) Generic() controller.GenericController {
	if mock.GenericFunc == nil {
		panic("PrometheusRuleControllerMock.GenericFunc: method is nil but PrometheusRuleController.Generic was just called")
	}
	callInfo := struct {
	}{}
	lockPrometheusRuleControllerMockGeneric.Lock()
	mock.calls.Generic = append(mock.calls.Generic, callInfo)
	lockPrometheusRuleControllerMockGeneric.Unlock()
	return mock.GenericFunc()
}

// GenericCalls gets all the calls that were made to Generic.
// Check the length with:
//     len(mockedPrometheusRuleController.GenericCalls())
func (mock *PrometheusRuleControllerMock) GenericCalls() []struct {
} {
	var calls []struct {
	}
	lockPrometheusRuleControllerMockGeneric.RLock()
	calls = mock.calls.Generic
	lockPrometheusRuleControllerMockGeneric.RUnlock()
	return calls
}

// Informer calls InformerFunc.
func (mock *PrometheusRuleControllerMock) Informer() cache.SharedIndexInformer {
	if mock.InformerFunc == nil {
		panic("PrometheusRuleControllerMock.InformerFunc: method is nil but PrometheusRuleController.Informer was just called")
	}
	callInfo := struct {
	}{}
	lockPrometheusRuleControllerMockInformer.Lock()
	mock.calls.Informer = append(mock.calls.Informer, callInfo)
	lockPrometheusRuleControllerMockInformer.Unlock()
	return mock.InformerFunc()
}

// InformerCalls gets all the calls that were made to Informer.
// Check the length with:
//     len(mockedPrometheusRuleController.InformerCalls())
func (mock *PrometheusRuleControllerMock) InformerCalls() []struct {
} {
	var calls []struct {
	}
	lockPrometheusRuleControllerMockInformer.RLock()
	calls = mock.calls.Informer
	lockPrometheusRuleControllerMockInformer.RUnlock()
	return calls
}

// Lister calls ListerFunc.
func (mock *PrometheusRuleControllerMock) Lister() v11.PrometheusRuleLister {
	if mock.ListerFunc == nil {
		panic("PrometheusRuleControllerMock.ListerFunc: method is nil but PrometheusRuleController.Lister was just called")
	}
	callInfo := struct {
	}{}
	lockPrometheusRuleControllerMockLister.Lock()
	mock.calls.Lister = append(mock.calls.Lister, callInfo)
	lockPrometheusRuleControllerMockLister.Unlock()
	return mock.ListerFunc()
}

// ListerCalls gets all the calls that were made to Lister.
// Check the length with:
//     len(mockedPrometheusRuleController.ListerCalls())
func (mock *PrometheusRuleControllerMock) ListerCalls() []struct {
} {
	var calls []struct {
	}
	lockPrometheusRuleControllerMockLister.RLock()
	calls = mock.calls.Lister
	lockPrometheusRuleControllerMockLister.RUnlock()
	return calls
}

var (
	lockPrometheusRuleInterfaceMockAddClusterScopedFeatureHandler   sync.RWMutex
	lockPrometheusRuleInterfaceMockAddClusterScopedFeatureLifecycle sync.RWMutex
	lockPrometheusRuleInterfaceMockAddClusterScopedHandler          sync.RWMutex
	lockPrometheusRuleInterfaceMockAddClusterScopedLifecycle        sync.RWMutex
	lockPrometheusRuleInterfaceMockAddFeatureHandler                sync.RWMutex
	lockPrometheusRuleInterfaceMockAddFeatureLifecycle              sync.RWMutex
	lockPrometheusRuleInterfaceMockAddHandler                       sync.RWMutex
	lockPrometheusRuleInterfaceMockAddLifecycle                     sync.RWMutex
	lockPrometheusRuleInterfaceMockController                       sync.RWMutex
	lockPrometheusRuleInterfaceMockCreate                           sync.RWMutex
	lockPrometheusRuleInterfaceMockDelete                           sync.RWMutex
	lockPrometheusRuleInterfaceMockDeleteCollection                 sync.RWMutex
	lockPrometheusRuleInterfaceMockDeleteNamespaced                 sync.RWMutex
	lockPrometheusRuleInterfaceMockGet                              sync.RWMutex
	lockPrometheusRuleInterfaceMockGetNamespaced                    sync.RWMutex
	lockPrometheusRuleInterfaceMockList                             sync.RWMutex
	lockPrometheusRuleInterfaceMockListNamespaced                   sync.RWMutex
	lockPrometheusRuleInterfaceMockObjectClient                     sync.RWMutex
	lockPrometheusRuleInterfaceMockUpdate                           sync.RWMutex
	lockPrometheusRuleInterfaceMockWatch                            sync.RWMutex
)

// Ensure, that PrometheusRuleInterfaceMock does implement v11.PrometheusRuleInterface.
// If this is not the case, regenerate this file with moq.
var _ v11.PrometheusRuleInterface = &PrometheusRuleInterfaceMock{}

// PrometheusRuleInterfaceMock is a mock implementation of v11.PrometheusRuleInterface.
//
//     func TestSomethingThatUsesPrometheusRuleInterface(t *testing.T) {
//
//         // make and configure a mocked v11.PrometheusRuleInterface
//         mockedPrometheusRuleInterface := &PrometheusRuleInterfaceMock{
//             AddClusterScopedFeatureHandlerFunc: func(ctx context.Context, enabled func() bool, name string, clusterName string, syncMoqParam v11.PrometheusRuleHandlerFunc)  {
// 	               panic("mock out the AddClusterScopedFeatureHandler method")
//             },
//             AddClusterScopedFeatureLifecycleFunc: func(ctx context.Context, enabled func() bool, name string, clusterName string, lifecycle v11.PrometheusRuleLifecycle)  {
// 	               panic("mock out the AddClusterScopedFeatureLifecycle method")
//             },
//             AddClusterScopedHandlerFunc: func(ctx context.Context, name string, clusterName string, syncMoqParam v11.PrometheusRuleHandlerFunc)  {
// 	               panic("mock out the AddClusterScopedHandler method")
//             },
//             AddClusterScopedLifecycleFunc: func(ctx context.Context, name string, clusterName string, lifecycle v11.PrometheusRuleLifecycle)  {
// 	               panic("mock out the AddClusterScopedLifecycle method")
//             },
//             AddFeatureHandlerFunc: func(ctx context.Context, enabled func() bool, name string, syncMoqParam v11.PrometheusRuleHandlerFunc)  {
// 	               panic("mock out the AddFeatureHandler method")
//             },
//             AddFeatureLifecycleFunc: func(ctx context.Context, enabled func() bool, name string, lifecycle v11.PrometheusRuleLifecycle)  {
// 	               panic("mock out the AddFeatureLifecycle method")
//             },
//             AddHandlerFunc: func(ctx context.Context, name string, syncMoqParam v11.PrometheusRuleHandlerFunc)  {
// 	               panic("mock out the AddHandler method")
//             },
//             AddLifecycleFunc: func(ctx context.Context, name string, lifecycle v11.PrometheusRuleLifecycle)  {
// 	               panic("mock out the AddLifecycle method")
//             },
//             ControllerFunc: func() v11.PrometheusRuleController {
// 	               panic("mock out the Controller method")
//             },
//             CreateFunc: func(in1 *v1.PrometheusRule) (*v1.PrometheusRule, error) {
// 	               panic("mock out the Create method")
//             },
//             DeleteFunc: func(name string, options *metav1.DeleteOptions) error {
// 	               panic("mock out the Delete method")
//             },
//             DeleteCollectionFunc: func(deleteOpts *metav1.DeleteOptions, listOpts metav1.ListOptions) error {
// 	               panic("mock out the DeleteCollection method")
//             },
//             DeleteNamespacedFunc: func(namespace string, name string, options *metav1.DeleteOptions) error {
// 	               panic("mock out the DeleteNamespaced method")
//             },
//             GetFunc: func(name string, opts metav1.GetOptions) (*v1.PrometheusRule, error) {
// 	               panic("mock out the Get method")
//             },
//             GetNamespacedFunc: func(namespace string, name string, opts metav1.GetOptions) (*v1.PrometheusRule, error) {
// 	               panic("mock out the GetNamespaced method")
//             },
//             ListFunc: func(opts metav1.ListOptions) (*v1.PrometheusRuleList, error) {
// 	               panic("mock out the List method")
//             },
//             ListNamespacedFunc: func(namespace string, opts metav1.ListOptions) (*v1.PrometheusRuleList, error) {
// 	               panic("mock out the ListNamespaced method")
//             },
//             ObjectClientFunc: func() *objectclient.ObjectClient {
// 	               panic("mock out the ObjectClient method")
//             },
//             UpdateFunc: func(in1 *v1.PrometheusRule) (*v1.PrometheusRule, error) {
// 	               panic("mock out the Update method")
//             },
//             WatchFunc: func(opts metav1.ListOptions) (watch.Interface, error) {
// 	               panic("mock out the Watch method")
//             },
//         }
//
//         // use mockedPrometheusRuleInterface in code that requires v11.PrometheusRuleInterface
//         // and then make assertions.
//
//     }
type PrometheusRuleInterfaceMock struct {
	// AddClusterScopedFeatureHandlerFunc mocks the AddClusterScopedFeatureHandler method.
	AddClusterScopedFeatureHandlerFunc func(ctx context.Context, enabled func() bool, name string, clusterName string, syncMoqParam v11.PrometheusRuleHandlerFunc)

	// AddClusterScopedFeatureLifecycleFunc mocks the AddClusterScopedFeatureLifecycle method.
	AddClusterScopedFeatureLifecycleFunc func(ctx context.Context, enabled func() bool, name string, clusterName string, lifecycle v11.PrometheusRuleLifecycle)

	// AddClusterScopedHandlerFunc mocks the AddClusterScopedHandler method.
	AddClusterScopedHandlerFunc func(ctx context.Context, name string, clusterName string, syncMoqParam v11.PrometheusRuleHandlerFunc)

	// AddClusterScopedLifecycleFunc mocks the AddClusterScopedLifecycle method.
	AddClusterScopedLifecycleFunc func(ctx context.Context, name string, clusterName string, lifecycle v11.PrometheusRuleLifecycle)

	// AddFeatureHandlerFunc mocks the AddFeatureHandler method.
	AddFeatureHandlerFunc func(ctx context.Context, enabled func() bool, name string, syncMoqParam v11.PrometheusRuleHandlerFunc)

	// AddFeatureLifecycleFunc mocks the AddFeatureLifecycle method.
	AddFeatureLifecycleFunc func(ctx context.Context, enabled func() bool, name string, lifecycle v11.PrometheusRuleLifecycle)

	// AddHandlerFunc mocks the AddHandler method.
	AddHandlerFunc func(ctx context.Context, name string, syncMoqParam v11.PrometheusRuleHandlerFunc)

	// AddLifecycleFunc mocks the AddLifecycle method.
	AddLifecycleFunc func(ctx context.Context, name string, lifecycle v11.PrometheusRuleLifecycle)

	// ControllerFunc mocks the Controller method.
	ControllerFunc func() v11.PrometheusRuleController

	// CreateFunc mocks the Create method.
	CreateFunc func(in1 *v1.PrometheusRule) (*v1.PrometheusRule, error)

	// DeleteFunc mocks the Delete method.
	DeleteFunc func(name string, options *metav1.DeleteOptions) error

	// DeleteCollectionFunc mocks the DeleteCollection method.
	DeleteCollectionFunc func(deleteOpts *metav1.DeleteOptions, listOpts metav1.ListOptions) error

	// DeleteNamespacedFunc mocks the DeleteNamespaced method.
	DeleteNamespacedFunc func(namespace string, name string, options *metav1.DeleteOptions) error

	// GetFunc mocks the Get method.
	GetFunc func(name string, opts metav1.GetOptions) (*v1.PrometheusRule, error)

	// GetNamespacedFunc mocks the GetNamespaced method.
	GetNamespacedFunc func(namespace string, name string, opts metav1.GetOptions) (*v1.PrometheusRule, error)

	// ListFunc mocks the List method.
	ListFunc func(opts metav1.ListOptions) (*v1.PrometheusRuleList, error)

	// ListNamespacedFunc mocks the ListNamespaced method.
	ListNamespacedFunc func(namespace string, opts metav1.ListOptions) (*v1.PrometheusRuleList, error)

	// ObjectClientFunc mocks the ObjectClient method.
	ObjectClientFunc func() *objectclient.ObjectClient

	// UpdateFunc mocks the Update method.
	UpdateFunc func(in1 *v1.PrometheusRule) (*v1.PrometheusRule, error)

	// WatchFunc mocks the Watch method.
	WatchFunc func(opts metav1.ListOptions) (watch.Interface, error)

	// calls tracks calls to the methods.
	calls struct {
		// AddClusterScopedFeatureHandler holds details about calls to the AddClusterScopedFeatureHandler method.
		AddClusterScopedFeatureHandler []struct {
			// Ctx is the ctx argument value.
			Ctx context.Context
			// Enabled is the enabled argument value.
			Enabled func() bool
			// Name is the name argument value.
			Name string
			// ClusterName is the clusterName argument value.
			ClusterName string
			// Sync is the sync argument value.
			Sync v11.PrometheusRuleHandlerFunc
		}
		// AddClusterScopedFeatureLifecycle holds details about calls to the AddClusterScopedFeatureLifecycle method.
		AddClusterScopedFeatureLifecycle []struct {
			// Ctx is the ctx argument value.
			Ctx context.Context
			// Enabled is the enabled argument value.
			Enabled func() bool
			// Name is the name argument value.
			Name string
			// ClusterName is the clusterName argument value.
			ClusterName string
			// Lifecycle is the lifecycle argument value.
			Lifecycle v11.PrometheusRuleLifecycle
		}
		// AddClusterScopedHandler holds details about calls to the AddClusterScopedHandler method.
		AddClusterScopedHandler []struct {
			// Ctx is the ctx argument value.
			Ctx context.Context
			// Name is the name argument value.
			Name string
			// ClusterName is the clusterName argument value.
			ClusterName string
			// Sync is the sync argument value.
			Sync v11.PrometheusRuleHandlerFunc
		}
		// AddClusterScopedLifecycle holds details about calls to the AddClusterScopedLifecycle method.
		AddClusterScopedLifecycle []struct {
			// Ctx is the ctx argument value.
			Ctx context.Context
			// Name is the name argument value.
			Name string
			// ClusterName is the clusterName argument value.
			ClusterName string
			// Lifecycle is the lifecycle argument value.
			Lifecycle v11.PrometheusRuleLifecycle
		}
		// AddFeatureHandler holds details about calls to the AddFeatureHandler method.
		AddFeatureHandler []struct {
			// Ctx is the ctx argument value.
			Ctx context.Context
			// Enabled is the enabled argument value.
			Enabled func() bool
			// Name is the name argument value.
			Name string
			// Sync is the sync argument value.
			Sync v11.PrometheusRuleHandlerFunc
		}
		// AddFeatureLifecycle holds details about calls to the AddFeatureLifecycle method.
		AddFeatureLifecycle []struct {
			// Ctx is the ctx argument value.
			Ctx context.Context
			// Enabled is the enabled argument value.
			Enabled func() bool
			// Name is the name argument value.
			Name string
			// Lifecycle is the lifecycle argument value.
			Lifecycle v11.PrometheusRuleLifecycle
		}
		// AddHandler holds details about calls to the AddHandler method.
		AddHandler []struct {
			// Ctx is the ctx argument value.
			Ctx context.Context
			// Name is the name argument value.
			Name string
			// Sync is the sync argument value.
			Sync v11.PrometheusRuleHandlerFunc
		}
		// AddLifecycle holds details about calls to the AddLifecycle method.
		AddLifecycle []struct {
			// Ctx is the ctx argument value.
			Ctx context.Context
			// Name is the name argument value.
			Name string
			// Lifecycle is the lifecycle argument value.
			Lifecycle v11.PrometheusRuleLifecycle
		}
		// Controller holds details about calls to the Controller method.
		Controller []struct {
		}
		// Create holds details about calls to the Create method.
		Create []struct {
			// In1 is the in1 argument value.
			In1 *v1.PrometheusRule
		}
		// Delete holds details about calls to the Delete method.
		Delete []struct {
			// Name is the name argument value.
			Name string
			// Options is the options argument value.
			Options *metav1.DeleteOptions
		}
		// DeleteCollection holds details about calls to the DeleteCollection method.
		DeleteCollection []struct {
			// DeleteOpts is the deleteOpts argument value.
			DeleteOpts *metav1.DeleteOptions
			// ListOpts is the listOpts argument value.
			ListOpts metav1.ListOptions
		}
		// DeleteNamespaced holds details about calls to the DeleteNamespaced method.
		DeleteNamespaced []struct {
			// Namespace is the namespace argument value.
			Namespace string
			// Name is the name argument value.
			Name string
			// Options is the options argument value.
			Options *metav1.DeleteOptions
		}
		// Get holds details about calls to the Get method.
		Get []struct {
			// Name is the name argument value.
			Name string
			// Opts is the opts argument value.
			Opts metav1.GetOptions
		}
		// GetNamespaced holds details about calls to the GetNamespaced method.
		GetNamespaced []struct {
			// Namespace is the namespace argument value.
			Namespace string
			// Name is the name argument value.
			Name string
			// Opts is the opts argument value.
			Opts metav1.GetOptions
		}
		// List holds details about calls to the List method.
		List []struct {
			// Opts is the opts argument value.
			Opts metav1.ListOptions
		}
		// ListNamespaced holds details about calls to the ListNamespaced method.
		ListNamespaced []struct {
			// Namespace is the namespace argument value.
			Namespace string
			// Opts is the opts argument value.
			Opts metav1.ListOptions
		}
		// ObjectClient holds details about calls to the ObjectClient method.
		ObjectClient []struct {
		}
		// Update holds details about calls to the Update method.
		Update []struct {
			// In1 is the in1 argument value.
			In1 *v1.PrometheusRule
		}
		// Watch holds details about calls to the Watch method.
		Watch []struct {
			// Opts is the opts argument value.
			Opts metav1.ListOptions
		}
	}
}

// AddClusterScopedFeatureHandler calls AddClusterScopedFeatureHandlerFunc.
func (mock *PrometheusRuleInterfaceMock) AddClusterScopedFeatureHandler(ctx context.Context, enabled func() bool, name string, clusterName string, syncMoqParam v11.PrometheusRuleHandlerFunc) {
	if mock.AddClusterScopedFeatureHandlerFunc == nil {
		panic("PrometheusRuleInterfaceMock.AddClusterScopedFeatureHandlerFunc: method is nil but PrometheusRuleInterface.AddClusterScopedFeatureHandler was just called")
	}
	callInfo := struct {
		Ctx         context.Context
		Enabled     func() bool
		Name        string
		ClusterName string
		Sync        v11.PrometheusRuleHandlerFunc
	}{
		Ctx:         ctx,
		Enabled:     enabled,
		Name:        name,
		ClusterName: clusterName,
		Sync:        syncMoqParam,
	}
	lockPrometheusRuleInterfaceMockAddClusterScopedFeatureHandler.Lock()
	mock.calls.AddClusterScopedFeatureHandler = append(mock.calls.AddClusterScopedFeatureHandler, callInfo)
	lockPrometheusRuleInterfaceMockAddClusterScopedFeatureHandler.Unlock()
	mock.AddClusterScopedFeatureHandlerFunc(ctx, enabled, name, clusterName, syncMoqParam)
}

// AddClusterScopedFeatureHandlerCalls gets all the calls that were made to AddClusterScopedFeatureHandler.
// Check the length with:
//     len(mockedPrometheusRuleInterface.AddClusterScopedFeatureHandlerCalls())
func (mock *PrometheusRuleInterfaceMock) AddClusterScopedFeatureHandlerCalls() []struct {
	Ctx         context.Context
	Enabled     func() bool
	Name        string
	ClusterName string
	Sync        v11.PrometheusRuleHandlerFunc
} {
	var calls []struct {
		Ctx         context.Context
		Enabled     func() bool
		Name        string
		ClusterName string
		Sync        v11.PrometheusRuleHandlerFunc
	}
	lockPrometheusRuleInterfaceMockAddClusterScopedFeatureHandler.RLock()
	calls = mock.calls.AddClusterScopedFeatureHandler
	lockPrometheusRuleInterfaceMockAddClusterScopedFeatureHandler.RUnlock()
	return calls
}

// AddClusterScopedFeatureLifecycle calls AddClusterScopedFeatureLifecycleFunc.
func (mock *PrometheusRuleInterfaceMock) AddClusterScopedFeatureLifecycle(ctx context.Context, enabled func() bool, name string, clusterName string, lifecycle v11.PrometheusRuleLifecycle) {
	if mock.AddClusterScopedFeatureLifecycleFunc == nil {
		panic("PrometheusRuleInterfaceMock.AddClusterScopedFeatureLifecycleFunc: method is nil but PrometheusRuleInterface.AddClusterScopedFeatureLifecycle was just called")
	}
	callInfo := struct {
		Ctx         context.Context
		Enabled     func() bool
		Name        string
		ClusterName string
		Lifecycle   v11.PrometheusRuleLifecycle
	}{
		Ctx:         ctx,
		Enabled:     enabled,
		Name:        name,
		ClusterName: clusterName,
		Lifecycle:   lifecycle,
	}
	lockPrometheusRuleInterfaceMockAddClusterScopedFeatureLifecycle.Lock()
	mock.calls.AddClusterScopedFeatureLifecycle = append(mock.calls.AddClusterScopedFeatureLifecycle, callInfo)
	lockPrometheusRuleInterfaceMockAddClusterScopedFeatureLifecycle.Unlock()
	mock.AddClusterScopedFeatureLifecycleFunc(ctx, enabled, name, clusterName, lifecycle)
}

// AddClusterScopedFeatureLifecycleCalls gets all the calls that were made to AddClusterScopedFeatureLifecycle.
// Check the length with:
//     len(mockedPrometheusRuleInterface.AddClusterScopedFeatureLifecycleCalls())
func (mock *PrometheusRuleInterfaceMock) AddClusterScopedFeatureLifecycleCalls() []struct {
	Ctx         context.Context
	Enabled     func() bool
	Name        string
	ClusterName string
	Lifecycle   v11.PrometheusRuleLifecycle
} {
	var calls []struct {
		Ctx         context.Context
		Enabled     func() bool
		Name        string
		ClusterName string
		Lifecycle   v11.PrometheusRuleLifecycle
	}
	lockPrometheusRuleInterfaceMockAddClusterScopedFeatureLifecycle.RLock()
	calls = mock.calls.AddClusterScopedFeatureLifecycle
	lockPrometheusRuleInterfaceMockAddClusterScopedFeatureLifecycle.RUnlock()
	return calls
}

// AddClusterScopedHandler calls AddClusterScopedHandlerFunc.
func (mock *PrometheusRuleInterfaceMock) AddClusterScopedHandler(ctx context.Context, name string, clusterName string, syncMoqParam v11.PrometheusRuleHandlerFunc) {
	if mock.AddClusterScopedHandlerFunc == nil {
		panic("PrometheusRuleInterfaceMock.AddClusterScopedHandlerFunc: method is nil but PrometheusRuleInterface.AddClusterScopedHandler was just called")
	}
	callInfo := struct {
		Ctx         context.Context
		Name        string
		ClusterName string
		Sync        v11.PrometheusRuleHandlerFunc
	}{
		Ctx:         ctx,
		Name:        name,
		ClusterName: clusterName,
		Sync:        syncMoqParam,
	}
	lockPrometheusRuleInterfaceMockAddClusterScopedHandler.Lock()
	mock.calls.AddClusterScopedHandler = append(mock.calls.AddClusterScopedHandler, callInfo)
	lockPrometheusRuleInterfaceMockAddClusterScopedHandler.Unlock()
	mock.AddClusterScopedHandlerFunc(ctx, name, clusterName, syncMoqParam)
}

// AddClusterScopedHandlerCalls gets all the calls that were made to AddClusterScopedHandler.
// Check the length with:
//     len(mockedPrometheusRuleInterface.AddClusterScopedHandlerCalls())
func (mock *PrometheusRuleInterfaceMock) AddClusterScopedHandlerCalls() []struct {
	Ctx         context.Context
	Name        string
	ClusterName string
	Sync        v11.PrometheusRuleHandlerFunc
} {
	var calls []struct {
		Ctx         context.Context
		Name        string
		ClusterName string
		Sync        v11.PrometheusRuleHandlerFunc
	}
	lockPrometheusRuleInterfaceMockAddClusterScopedHandler.RLock()
	calls = mock.calls.AddClusterScopedHandler
	lockPrometheusRuleInterfaceMockAddClusterScopedHandler.RUnlock()
	return calls
}

// AddClusterScopedLifecycle calls AddClusterScopedLifecycleFunc.
func (mock *PrometheusRuleInterfaceMock) AddClusterScopedLifecycle(ctx context.Context, name string, clusterName string, lifecycle v11.PrometheusRuleLifecycle) {
	if mock.AddClusterScopedLifecycleFunc == nil {
		panic("PrometheusRuleInterfaceMock.AddClusterScopedLifecycleFunc: method is nil but PrometheusRuleInterface.AddClusterScopedLifecycle was just called")
	}
	callInfo := struct {
		Ctx         context.Context
		Name        string
		ClusterName string
		Lifecycle   v11.PrometheusRuleLifecycle
	}{
		Ctx:         ctx,
		Name:        name,
		ClusterName: clusterName,
		Lifecycle:   lifecycle,
	}
	lockPrometheusRuleInterfaceMockAddClusterScopedLifecycle.Lock()
	mock.calls.AddClusterScopedLifecycle = append(mock.calls.AddClusterScopedLifecycle, callInfo)
	lockPrometheusRuleInterfaceMockAddClusterScopedLifecycle.Unlock()
	mock.AddClusterScopedLifecycleFunc(ctx, name, clusterName, lifecycle)
}

// AddClusterScopedLifecycleCalls gets all the calls that were made to AddClusterScopedLifecycle.
// Check the length with:
//     len(mockedPrometheusRuleInterface.AddClusterScopedLifecycleCalls())
func (mock *PrometheusRuleInterfaceMock) AddClusterScopedLifecycleCalls() []struct {
	Ctx         context.Context
	Name        string
	ClusterName string
	Lifecycle   v11.PrometheusRuleLifecycle
} {
	var calls []struct {
		Ctx         context.Context
		Name        string
		ClusterName string
		Lifecycle   v11.PrometheusRuleLifecycle
	}
	lockPrometheusRuleInterfaceMockAddClusterScopedLifecycle.RLock()
	calls = mock.calls.AddClusterScopedLifecycle
	lockPrometheusRuleInterfaceMockAddClusterScopedLifecycle.RUnlock()
	return calls
}

// AddFeatureHandler calls AddFeatureHandlerFunc.
func (mock *PrometheusRuleInterfaceMock) AddFeatureHandler(ctx context.Context, enabled func() bool, name string, syncMoqParam v11.PrometheusRuleHandlerFunc) {
	if mock.AddFeatureHandlerFunc == nil {
		panic("PrometheusRuleInterfaceMock.AddFeatureHandlerFunc: method is nil but PrometheusRuleInterface.AddFeatureHandler was just called")
	}
	callInfo := struct {
		Ctx     context.Context
		Enabled func() bool
		Name    string
		Sync    v11.PrometheusRuleHandlerFunc
	}{
		Ctx:     ctx,
		Enabled: enabled,
		Name:    name,
		Sync:    syncMoqParam,
	}
	lockPrometheusRuleInterfaceMockAddFeatureHandler.Lock()
	mock.calls.AddFeatureHandler = append(mock.calls.AddFeatureHandler, callInfo)
	lockPrometheusRuleInterfaceMockAddFeatureHandler.Unlock()
	mock.AddFeatureHandlerFunc(ctx, enabled, name, syncMoqParam)
}

// AddFeatureHandlerCalls gets all the calls that were made to AddFeatureHandler.
// Check the length with:
//     len(mockedPrometheusRuleInterface.AddFeatureHandlerCalls())
func (mock *PrometheusRuleInterfaceMock) AddFeatureHandlerCalls() []struct {
	Ctx     context.Context
	Enabled func() bool
	Name    string
	Sync    v11.PrometheusRuleHandlerFunc
} {
	var calls []struct {
		Ctx     context.Context
		Enabled func() bool
		Name    string
		Sync    v11.PrometheusRuleHandlerFunc
	}
	lockPrometheusRuleInterfaceMockAddFeatureHandler.RLock()
	calls = mock.calls.AddFeatureHandler
	lockPrometheusRuleInterfaceMockAddFeatureHandler.RUnlock()
	return calls
}

// AddFeatureLifecycle calls AddFeatureLifecycleFunc.
func (mock *PrometheusRuleInterfaceMock) AddFeatureLifecycle(ctx context.Context, enabled func() bool, name string, lifecycle v11.PrometheusRuleLifecycle) {
	if mock.AddFeatureLifecycleFunc == nil {
		panic("PrometheusRuleInterfaceMock.AddFeatureLifecycleFunc: method is nil but PrometheusRuleInterface.AddFeatureLifecycle was just called")
	}
	callInfo := struct {
		Ctx       context.Context
		Enabled   func() bool
		Name      string
		Lifecycle v11.PrometheusRuleLifecycle
	}{
		Ctx:       ctx,
		Enabled:   enabled,
		Name:      name,
		Lifecycle: lifecycle,
	}
	lockPrometheusRuleInterfaceMockAddFeatureLifecycle.Lock()
	mock.calls.AddFeatureLifecycle = append(mock.calls.AddFeatureLifecycle, callInfo)
	lockPrometheusRuleInterfaceMockAddFeatureLifecycle.Unlock()
	mock.AddFeatureLifecycleFunc(ctx, enabled, name, lifecycle)
}

// AddFeatureLifecycleCalls gets all the calls that were made to AddFeatureLifecycle.
// Check the length with:
//     len(mockedPrometheusRuleInterface.AddFeatureLifecycleCalls())
func (mock *PrometheusRuleInterfaceMock) AddFeatureLifecycleCalls() []struct {
	Ctx       context.Context
	Enabled   func() bool
	Name      string
	Lifecycle v11.PrometheusRuleLifecycle
} {
	var calls []struct {
		Ctx       context.Context
		Enabled   func() bool
		Name      string
		Lifecycle v11.PrometheusRuleLifecycle
	}
	lockPrometheusRuleInterfaceMockAddFeatureLifecycle.RLock()
	calls = mock.calls.AddFeatureLifecycle
	lockPrometheusRuleInterfaceMockAddFeatureLifecycle.RUnlock()
	return calls
}

// AddHandler calls AddHandlerFunc.
func (mock *PrometheusRuleInterfaceMock) AddHandler(ctx context.Context, name string, syncMoqParam v11.PrometheusRuleHandlerFunc) {
	if mock.AddHandlerFunc == nil {
		panic("PrometheusRuleInterfaceMock.AddHandlerFunc: method is nil but PrometheusRuleInterface.AddHandler was just called")
	}
	callInfo := struct {
		Ctx  context.Context
		Name string
		Sync v11.PrometheusRuleHandlerFunc
	}{
		Ctx:  ctx,
		Name: name,
		Sync: syncMoqParam,
	}
	lockPrometheusRuleInterfaceMockAddHandler.Lock()
	mock.calls.AddHandler = append(mock.calls.AddHandler, callInfo)
	lockPrometheusRuleInterfaceMockAddHandler.Unlock()
	mock.AddHandlerFunc(ctx, name, syncMoqParam)
}

// AddHandlerCalls gets all the calls that were made to AddHandler.
// Check the length with:
//     len(mockedPrometheusRuleInterface.AddHandlerCalls())
func (mock *PrometheusRuleInterfaceMock) AddHandlerCalls() []struct {
	Ctx  context.Context
	Name string
	Sync v11.PrometheusRuleHandlerFunc
} {
	var calls []struct {
		Ctx  context.Context
		Name string
		Sync v11.PrometheusRuleHandlerFunc
	}
	lockPrometheusRuleInterfaceMockAddHandler.RLock()
	calls = mock.calls.AddHandler
	lockPrometheusRuleInterfaceMockAddHandler.RUnlock()
	return calls
}

// AddLifecycle calls AddLifecycleFunc.
func (mock *PrometheusRuleInterfaceMock) AddLifecycle(ctx context.Context, name string, lifecycle v11.PrometheusRuleLifecycle) {
	if mock.AddLifecycleFunc == nil {
		panic("PrometheusRuleInterfaceMock.AddLifecycleFunc: method is nil but PrometheusRuleInterface.AddLifecycle was just called")
	}
	callInfo := struct {
		Ctx       context.Context
		Name      string
		Lifecycle v11.PrometheusRuleLifecycle
	}{
		Ctx:       ctx,
		Name:      name,
		Lifecycle: lifecycle,
	}
	lockPrometheusRuleInterfaceMockAddLifecycle.Lock()
	mock.calls.AddLifecycle = append(mock.calls.AddLifecycle, callInfo)
	lockPrometheusRuleInterfaceMockAddLifecycle.Unlock()
	mock.AddLifecycleFunc(ctx, name, lifecycle)
}

// AddLifecycleCalls gets all the calls that were made to AddLifecycle.
// Check the length with:
//     len(mockedPrometheusRuleInterface.AddLifecycleCalls())
func (mock *PrometheusRuleInterfaceMock) AddLifecycleCalls() []struct {
	Ctx       context.Context
	Name      string
	Lifecycle v11.PrometheusRuleLifecycle
} {
	var calls []struct {
		Ctx       context.Context
		Name      string
		Lifecycle v11.PrometheusRuleLifecycle
	}
	lockPrometheusRuleInterfaceMockAddLifecycle.RLock()
	calls = mock.calls.AddLifecycle
	lockPrometheusRuleInterfaceMockAddLifecycle.RUnlock()
	return calls
}

// Controller calls ControllerFunc.
func (mock *PrometheusRuleInterfaceMock) Controller() v11.PrometheusRuleController {
	if mock.ControllerFunc == nil {
		panic("PrometheusRuleInterfaceMock.ControllerFunc: method is nil but PrometheusRuleInterface.Controller was just called")
	}
	callInfo := struct {
	}{}
	lockPrometheusRuleInterfaceMockController.Lock()
	mock.calls.Controller = append(mock.calls.Controller, callInfo)
	lockPrometheusRuleInterfaceMockController.Unlock()
	return mock.ControllerFunc()
}

// ControllerCalls gets all the calls that were made to Controller.
// Check the length with:
//     len(mockedPrometheusRuleInterface.ControllerCalls())
func (mock *PrometheusRuleInterfaceMock) ControllerCalls() []struct {
} {
	var calls []struct {
	}
	lockPrometheusRuleInterfaceMockController.RLock()
	calls = mock.calls.Controller
	lockPrometheusRuleInterfaceMockController.RUnlock()
	return calls
}

// Create calls CreateFunc.
func (mock *PrometheusRuleInterfaceMock) Create(in1 *v1.PrometheusRule) (*v1.PrometheusRule, error) {
	if mock.CreateFunc == nil {
		panic("PrometheusRuleInterfaceMock.CreateFunc: method is nil but PrometheusRuleInterface.Create was just called")
	}
	callInfo := struct {
		In1 *v1.PrometheusRule
	}{
		In1: in1,
	}
	lockPrometheusRuleInterfaceMockCreate.Lock()
	mock.calls.Create = append(mock.calls.Create, callInfo)
	lockPrometheusRuleInterfaceMockCreate.Unlock()
	return mock.CreateFunc(in1)
}

// CreateCalls gets all the calls that were made to Create.
// Check the length with:
//     len(mockedPrometheusRuleInterface.CreateCalls())
func (mock *PrometheusRuleInterfaceMock) CreateCalls() []struct {
	In1 *v1.PrometheusRule
} {
	var calls []struct {
		In1 *v1.PrometheusRule
	}
	lockPrometheusRuleInterfaceMockCreate.RLock()
	calls = mock.calls.Create
	lockPrometheusRuleInterfaceMockCreate.RUnlock()
	return calls
}

// Delete calls DeleteFunc.
func (mock *PrometheusRuleInterfaceMock) Delete(name string, options *metav1.DeleteOptions) error {
	if mock.DeleteFunc == nil {
		panic("PrometheusRuleInterfaceMock.DeleteFunc: method is nil but PrometheusRuleInterface.Delete was just called")
	}
	callInfo := struct {
		Name    string
		Options *metav1.DeleteOptions
	}{
		Name:    name,
		Options: options,
	}
	lockPrometheusRuleInterfaceMockDelete.Lock()
	mock.calls.Delete = append(mock.calls.Delete, callInfo)
	lockPrometheusRuleInterfaceMockDelete.Unlock()
	return mock.DeleteFunc(name, options)
}

// DeleteCalls gets all the calls that were made to Delete.
// Check the length with:
//     len(mockedPrometheusRuleInterface.DeleteCalls())
func (mock *PrometheusRuleInterfaceMock) DeleteCalls() []struct {
	Name    string
	Options *metav1.DeleteOptions
} {
	var calls []struct {
		Name    string
		Options *metav1.DeleteOptions
	}
	lockPrometheusRuleInterfaceMockDelete.RLock()
	calls = mock.calls.Delete
	lockPrometheusRuleInterfaceMockDelete.RUnlock()
	return calls
}

// DeleteCollection calls DeleteCollectionFunc.
func (mock *PrometheusRuleInterfaceMock) DeleteCollection(deleteOpts *metav1.DeleteOptions, listOpts metav1.ListOptions) error {
	if mock.DeleteCollectionFunc == nil {
		panic("PrometheusRuleInterfaceMock.DeleteCollectionFunc: method is nil but PrometheusRuleInterface.DeleteCollection was just called")
	}
	callInfo := struct {
		DeleteOpts *metav1.DeleteOptions
		ListOpts   metav1.ListOptions
	}{
		DeleteOpts: deleteOpts,
		ListOpts:   listOpts,
	}
	lockPrometheusRuleInterfaceMockDeleteCollection.Lock()
	mock.calls.DeleteCollection = append(mock.calls.DeleteCollection, callInfo)
	lockPrometheusRuleInterfaceMockDeleteCollection.Unlock()
	return mock.DeleteCollectionFunc(deleteOpts, listOpts)
}

// DeleteCollectionCalls gets all the calls that were made to DeleteCollection.
// Check the length with:
//     len(mockedPrometheusRuleInterface.DeleteCollectionCalls())
func (mock *PrometheusRuleInterfaceMock) DeleteCollectionCalls() []struct {
	DeleteOpts *metav1.DeleteOptions
	ListOpts   metav1.ListOptions
} {
	var calls []struct {
		DeleteOpts *metav1.DeleteOptions
		ListOpts   metav1.ListOptions
	}
	lockPrometheusRuleInterfaceMockDeleteCollection.RLock()
	calls = mock.calls.DeleteCollection
	lockPrometheusRuleInterfaceMockDeleteCollection.RUnlock()
	return calls
}

// DeleteNamespaced calls DeleteNamespacedFunc.
func (mock *PrometheusRuleInterfaceMock) DeleteNamespaced(namespace string, name string, options *metav1.DeleteOptions) error {
	if mock.DeleteNamespacedFunc == nil {
		panic("PrometheusRuleInterfaceMock.DeleteNamespacedFunc: method is nil but PrometheusRuleInterface.DeleteNamespaced was just called")
	}
	callInfo := struct {
		Namespace string
		Name      string
		Options   *metav1.DeleteOptions
	}{
		Namespace: namespace,
		Name:      name,
		Options:   options,
	}
	lockPrometheusRuleInterfaceMockDeleteNamespaced.Lock()
	mock.calls.DeleteNamespaced = append(mock.calls.DeleteNamespaced, callInfo)
	lockPrometheusRuleInterfaceMockDeleteNamespaced.Unlock()
	return mock.DeleteNamespacedFunc(namespace, name, options)
}

// DeleteNamespacedCalls gets all the calls that were made to DeleteNamespaced.
// Check the length with:
//     len(mockedPrometheusRuleInterface.DeleteNamespacedCalls())
func (mock *PrometheusRuleInterfaceMock) DeleteNamespacedCalls() []struct {
	Namespace string
	Name      string
	Options   *metav1.DeleteOptions
} {
	var calls []struct {
		Namespace string
		Name      string
		Options   *metav1.DeleteOptions
	}
	lockPrometheusRuleInterfaceMockDeleteNamespaced.RLock()
	calls = mock.calls.DeleteNamespaced
	lockPrometheusRuleInterfaceMockDeleteNamespaced.RUnlock()
	return calls
}

// Get calls GetFunc.
func (mock *PrometheusRuleInterfaceMock) Get(name string, opts metav1.GetOptions) (*v1.PrometheusRule, error) {
	if mock.GetFunc == nil {
		panic("PrometheusRuleInterfaceMock.GetFunc: method is nil but PrometheusRuleInterface.Get was just called")
	}
	callInfo := struct {
		Name string
		Opts metav1.GetOptions
	}{
		Name: name,
		Opts: opts,
	}
	lockPrometheusRuleInterfaceMockGet.Lock()
	mock.calls.Get = append(mock.calls.Get, callInfo)
	lockPrometheusRuleInterfaceMockGet.Unlock()
	return mock.GetFunc(name, opts)
}

// GetCalls gets all the calls that were made to Get.
// Check the length with:
//     len(mockedPrometheusRuleInterface.GetCalls())
func (mock *PrometheusRuleInterfaceMock) GetCalls() []struct {
	Name string
	Opts metav1.GetOptions
} {
	var calls []struct {
		Name string
		Opts metav1.GetOptions
	}
	lockPrometheusRuleInterfaceMockGet.RLock()
	calls = mock.calls.Get
	lockPrometheusRuleInterfaceMockGet.RUnlock()
	return calls
}

// GetNamespaced calls GetNamespacedFunc.
func (mock *PrometheusRuleInterfaceMock) GetNamespaced(namespace string, name string, opts metav1.GetOptions) (*v1.PrometheusRule, error) {
	if mock.GetNamespacedFunc == nil {
		panic("PrometheusRuleInterfaceMock.GetNamespacedFunc: method is nil but PrometheusRuleInterface.GetNamespaced was just called")
	}
	callInfo := struct {
		Namespace string
		Name      string
		Opts      metav1.GetOptions
	}{
		Namespace: namespace,
		Name:      name,
		Opts:      opts,
	}
	lockPrometheusRuleInterfaceMockGetNamespaced.Lock()
	mock.calls.GetNamespaced = append(mock.calls.GetNamespaced, callInfo)
	lockPrometheusRuleInterfaceMockGetNamespaced.Unlock()
	return mock.GetNamespacedFunc(namespace, name, opts)
}

// GetNamespacedCalls gets all the calls that were made to GetNamespaced.
// Check the length with:
//     len(mockedPrometheusRuleInterface.GetNamespacedCalls())
func (mock *PrometheusRuleInterfaceMock) GetNamespacedCalls() []struct {
	Namespace string
	Name      string
	Opts      metav1.GetOptions
} {
	var calls []struct {
		Namespace string
		Name      string
		Opts      metav1.GetOptions
	}
	lockPrometheusRuleInterfaceMockGetNamespaced.RLock()
	calls = mock.calls.GetNamespaced
	lockPrometheusRuleInterfaceMockGetNamespaced.RUnlock()
	return calls
}

// List calls ListFunc.
func (mock *PrometheusRuleInterfaceMock) List(opts metav1.ListOptions) (*v1.PrometheusRuleList, error) {
	if mock.ListFunc == nil {
		panic("PrometheusRuleInterfaceMock.ListFunc: method is nil but PrometheusRuleInterface.List was just called")
	}
	callInfo := struct {
		Opts metav1.ListOptions
	}{
		Opts: opts,
	}
	lockPrometheusRuleInterfaceMockList.Lock()
	mock.calls.List = append(mock.calls.List, callInfo)
	lockPrometheusRuleInterfaceMockList.Unlock()
	return mock.ListFunc(opts)
}

// ListCalls gets all the calls that were made to List.
// Check the length with:
//     len(mockedPrometheusRuleInterface.ListCalls())
func (mock *PrometheusRuleInterfaceMock) ListCalls() []struct {
	Opts metav1.ListOptions
} {
	var calls []struct {
		Opts metav1.ListOptions
	}
	lockPrometheusRuleInterfaceMockList.RLock()
	calls = mock.calls.List
	lockPrometheusRuleInterfaceMockList.RUnlock()
	return calls
}

// ListNamespaced calls ListNamespacedFunc.
func (mock *PrometheusRuleInterfaceMock) ListNamespaced(namespace string, opts metav1.ListOptions) (*v1.PrometheusRuleList, error) {
	if mock.ListNamespacedFunc == nil {
		panic("PrometheusRuleInterfaceMock.ListNamespacedFunc: method is nil but PrometheusRuleInterface.ListNamespaced was just called")
	}
	callInfo := struct {
		Namespace string
		Opts      metav1.ListOptions
	}{
		Namespace: namespace,
		Opts:      opts,
	}
	lockPrometheusRuleInterfaceMockListNamespaced.Lock()
	mock.calls.ListNamespaced = append(mock.calls.ListNamespaced, callInfo)
	lockPrometheusRuleInterfaceMockListNamespaced.Unlock()
	return mock.ListNamespacedFunc(namespace, opts)
}

// ListNamespacedCalls gets all the calls that were made to ListNamespaced.
// Check the length with:
//     len(mockedPrometheusRuleInterface.ListNamespacedCalls())
func (mock *PrometheusRuleInterfaceMock) ListNamespacedCalls() []struct {
	Namespace string
	Opts      metav1.ListOptions
} {
	var calls []struct {
		Namespace string
		Opts      metav1.ListOptions
	}
	lockPrometheusRuleInterfaceMockListNamespaced.RLock()
	calls = mock.calls.ListNamespaced
	lockPrometheusRuleInterfaceMockListNamespaced.RUnlock()
	return calls
}

// ObjectClient calls ObjectClientFunc.
func (mock *PrometheusRuleInterfaceMock) ObjectClient() *objectclient.ObjectClient {
	if mock.ObjectClientFunc == nil {
		panic("PrometheusRuleInterfaceMock.ObjectClientFunc: method is nil but PrometheusRuleInterface.ObjectClient was just called")
	}
	callInfo := struct {
	}{}
	lockPrometheusRuleInterfaceMockObjectClient.Lock()
	mock.calls.ObjectClient = append(mock.calls.ObjectClient, callInfo)
	lockPrometheusRuleInterfaceMockObjectClient.Unlock()
	return mock.ObjectClientFunc()
}

// ObjectClientCalls gets all the calls that were made to ObjectClient.
// Check the length with:
//     len(mockedPrometheusRuleInterface.ObjectClientCalls())
func (mock *PrometheusRuleInterfaceMock) ObjectClientCalls() []struct {
} {
	var calls []struct {
	}
	lockPrometheusRuleInterfaceMockObjectClient.RLock()
	calls = mock.calls.ObjectClient
	lockPrometheusRuleInterfaceMockObjectClient.RUnlock()
	return calls
}

// Update calls UpdateFunc.
func (mock *PrometheusRuleInterfaceMock) Update(in1 *v1.PrometheusRule) (*v1.PrometheusRule, error) {
	if mock.UpdateFunc == nil {
		panic("PrometheusRuleInterfaceMock.UpdateFunc: method is nil but PrometheusRuleInterface.Update was just called")
	}
	callInfo := struct {
		In1 *v1.PrometheusRule
	}{
		In1: in1,
	}
	lockPrometheusRuleInterfaceMockUpdate.Lock()
	mock.calls.Update = append(mock.calls.Update, callInfo)
	lockPrometheusRuleInterfaceMockUpdate.Unlock()
	return mock.UpdateFunc(in1)
}

// UpdateCalls gets all the calls that were made to Update.
// Check the length with:
//     len(mockedPrometheusRuleInterface.UpdateCalls())
func (mock *PrometheusRuleInterfaceMock) UpdateCalls() []struct {
	In1 *v1.PrometheusRule
} {
	var calls []struct {
		In1 *v1.PrometheusRule
	}
	lockPrometheusRuleInterfaceMockUpdate.RLock()
	calls = mock.calls.Update
	lockPrometheusRuleInterfaceMockUpdate.RUnlock()
	return calls
}

// Watch calls WatchFunc.
func (mock *PrometheusRuleInterfaceMock) Watch(opts metav1.ListOptions) (watch.Interface, error) {
	if mock.WatchFunc == nil {
		panic("PrometheusRuleInterfaceMock.WatchFunc: method is nil but PrometheusRuleInterface.Watch was just called")
	}
	callInfo := struct {
		Opts metav1.ListOptions
	}{
		Opts: opts,
	}
	lockPrometheusRuleInterfaceMockWatch.Lock()
	mock.calls.Watch = append(mock.calls.Watch, callInfo)
	lockPrometheusRuleInterfaceMockWatch.Unlock()
	return mock.WatchFunc(opts)
}

// WatchCalls gets all the calls that were made to Watch.
// Check the length with:
//     len(mockedPrometheusRuleInterface.WatchCalls())
func (mock *PrometheusRuleInterfaceMock) WatchCalls() []struct {
	Opts metav1.ListOptions
} {
	var calls []struct {
		Opts metav1.ListOptions
	}
	lockPrometheusRuleInterfaceMockWatch.RLock()
	calls = mock.calls.Watch
	lockPrometheusRuleInterfaceMockWatch.RUnlock()
	return calls
}

var (
	lockPrometheusRulesGetterMockPrometheusRules sync.RWMutex
)

// Ensure, that PrometheusRulesGetterMock does implement v11.PrometheusRulesGetter.
// If this is not the case, regenerate this file with moq.
var _ v11.PrometheusRulesGetter = &PrometheusRulesGetterMock{}

// PrometheusRulesGetterMock is a mock implementation of v11.PrometheusRulesGetter.
//
//     func TestSomethingThatUsesPrometheusRulesGetter(t *testing.T) {
//
//         // make and configure a mocked v11.PrometheusRulesGetter
//         mockedPrometheusRulesGetter := &PrometheusRulesGetterMock{
//             PrometheusRulesFunc: func(namespace string) v11.PrometheusRuleInterface {
// 	               panic("mock out the PrometheusRules method")
//             },
//         }
//
//         // use mockedPrometheusRulesGetter in code that requires v11.PrometheusRulesGetter
//         // and then make assertions.
//
//     }
type PrometheusRulesGetterMock struct {
	// PrometheusRulesFunc mocks the PrometheusRules method.
	PrometheusRulesFunc func(namespace string) v11.PrometheusRuleInterface

	// calls tracks calls to the methods.
	calls struct {
		// PrometheusRules holds details about calls to the PrometheusRules method.
		PrometheusRules []struct {
			// Namespace is the namespace argument value.
			Namespace string
		}
	}
}

// PrometheusRules calls PrometheusRulesFunc.
func (mock *PrometheusRulesGetterMock) PrometheusRules(namespace string) v11.PrometheusRuleInterface {
	if mock.PrometheusRulesFunc == nil {
		panic("PrometheusRulesGetterMock.PrometheusRulesFunc: method is nil but PrometheusRulesGetter.PrometheusRules was just called")
	}
	callInfo := struct {
		Namespace string
	}{
		Namespace: namespace,
	}
	lockPrometheusRulesGetterMockPrometheusRules.Lock()
	mock.calls.PrometheusRules = append(mock.calls.PrometheusRules, callInfo)
	lockPrometheusRulesGetterMockPrometheusRules.Unlock()
	return mock.PrometheusRulesFunc(namespace)
}

// PrometheusRulesCalls gets all the calls that were made to PrometheusRules.
// Check the length with:
//     len(mockedPrometheusRulesGetter.PrometheusRulesCalls())
func (mock *PrometheusRulesGetterMock) PrometheusRulesCalls() []struct {
	Namespace string
} {
	var calls []struct {
		Namespace string
	}
	lockPrometheusRulesGetterMockPrometheusRules.RLock()
	calls = mock.calls.PrometheusRules
	lockPrometheusRulesGetterMockPrometheusRules.RUnlock()
	return calls
}
