// Code generated by moq; DO NOT EDIT.
// github.com/matryer/moq

package fakes

import (
	"context"
	"sync"
	"time"

	v1 "github.com/prometheus-operator/prometheus-operator/pkg/apis/monitoring/v1"
	"github.com/rancher/norman/controller"
	"github.com/rancher/norman/objectclient"
	v11 "github.com/rancher/rancher/pkg/generated/norman/monitoring.coreos.com/v1"
	metav1 "k8s.io/apimachinery/pkg/apis/meta/v1"
	"k8s.io/apimachinery/pkg/labels"
	"k8s.io/apimachinery/pkg/watch"
	"k8s.io/client-go/tools/cache"
)

var (
	lockServiceMonitorListerMockGet  sync.RWMutex
	lockServiceMonitorListerMockList sync.RWMutex
)

// Ensure, that ServiceMonitorListerMock does implement v11.ServiceMonitorLister.
// If this is not the case, regenerate this file with moq.
var _ v11.ServiceMonitorLister = &ServiceMonitorListerMock{}

// ServiceMonitorListerMock is a mock implementation of v11.ServiceMonitorLister.
//
//     func TestSomethingThatUsesServiceMonitorLister(t *testing.T) {
//
//         // make and configure a mocked v11.ServiceMonitorLister
//         mockedServiceMonitorLister := &ServiceMonitorListerMock{
//             GetFunc: func(namespace string, name string) (*v1.ServiceMonitor, error) {
// 	               panic("mock out the Get method")
//             },
//             ListFunc: func(namespace string, selector labels.Selector) ([]*v1.ServiceMonitor, error) {
// 	               panic("mock out the List method")
//             },
//         }
//
//         // use mockedServiceMonitorLister in code that requires v11.ServiceMonitorLister
//         // and then make assertions.
//
//     }
type ServiceMonitorListerMock struct {
	// GetFunc mocks the Get method.
	GetFunc func(namespace string, name string) (*v1.ServiceMonitor, error)

	// ListFunc mocks the List method.
	ListFunc func(namespace string, selector labels.Selector) ([]*v1.ServiceMonitor, error)

	// calls tracks calls to the methods.
	calls struct {
		// Get holds details about calls to the Get method.
		Get []struct {
			// Namespace is the namespace argument value.
			Namespace string
			// Name is the name argument value.
			Name string
		}
		// List holds details about calls to the List method.
		List []struct {
			// Namespace is the namespace argument value.
			Namespace string
			// Selector is the selector argument value.
			Selector labels.Selector
		}
	}
}

// Get calls GetFunc.
func (mock *ServiceMonitorListerMock) Get(namespace string, name string) (*v1.ServiceMonitor, error) {
	if mock.GetFunc == nil {
		panic("ServiceMonitorListerMock.GetFunc: method is nil but ServiceMonitorLister.Get was just called")
	}
	callInfo := struct {
		Namespace string
		Name      string
	}{
		Namespace: namespace,
		Name:      name,
	}
	lockServiceMonitorListerMockGet.Lock()
	mock.calls.Get = append(mock.calls.Get, callInfo)
	lockServiceMonitorListerMockGet.Unlock()
	return mock.GetFunc(namespace, name)
}

// GetCalls gets all the calls that were made to Get.
// Check the length with:
//     len(mockedServiceMonitorLister.GetCalls())
func (mock *ServiceMonitorListerMock) GetCalls() []struct {
	Namespace string
	Name      string
} {
	var calls []struct {
		Namespace string
		Name      string
	}
	lockServiceMonitorListerMockGet.RLock()
	calls = mock.calls.Get
	lockServiceMonitorListerMockGet.RUnlock()
	return calls
}

// List calls ListFunc.
func (mock *ServiceMonitorListerMock) List(namespace string, selector labels.Selector) ([]*v1.ServiceMonitor, error) {
	if mock.ListFunc == nil {
		panic("ServiceMonitorListerMock.ListFunc: method is nil but ServiceMonitorLister.List was just called")
	}
	callInfo := struct {
		Namespace string
		Selector  labels.Selector
	}{
		Namespace: namespace,
		Selector:  selector,
	}
	lockServiceMonitorListerMockList.Lock()
	mock.calls.List = append(mock.calls.List, callInfo)
	lockServiceMonitorListerMockList.Unlock()
	return mock.ListFunc(namespace, selector)
}

// ListCalls gets all the calls that were made to List.
// Check the length with:
//     len(mockedServiceMonitorLister.ListCalls())
func (mock *ServiceMonitorListerMock) ListCalls() []struct {
	Namespace string
	Selector  labels.Selector
} {
	var calls []struct {
		Namespace string
		Selector  labels.Selector
	}
	lockServiceMonitorListerMockList.RLock()
	calls = mock.calls.List
	lockServiceMonitorListerMockList.RUnlock()
	return calls
}

var (
	lockServiceMonitorControllerMockAddClusterScopedFeatureHandler sync.RWMutex
	lockServiceMonitorControllerMockAddClusterScopedHandler        sync.RWMutex
	lockServiceMonitorControllerMockAddFeatureHandler              sync.RWMutex
	lockServiceMonitorControllerMockAddHandler                     sync.RWMutex
	lockServiceMonitorControllerMockEnqueue                        sync.RWMutex
	lockServiceMonitorControllerMockEnqueueAfter                   sync.RWMutex
	lockServiceMonitorControllerMockGeneric                        sync.RWMutex
	lockServiceMonitorControllerMockInformer                       sync.RWMutex
	lockServiceMonitorControllerMockLister                         sync.RWMutex
)

// Ensure, that ServiceMonitorControllerMock does implement v11.ServiceMonitorController.
// If this is not the case, regenerate this file with moq.
var _ v11.ServiceMonitorController = &ServiceMonitorControllerMock{}

// ServiceMonitorControllerMock is a mock implementation of v11.ServiceMonitorController.
//
//     func TestSomethingThatUsesServiceMonitorController(t *testing.T) {
//
//         // make and configure a mocked v11.ServiceMonitorController
//         mockedServiceMonitorController := &ServiceMonitorControllerMock{
//             AddClusterScopedFeatureHandlerFunc: func(ctx context.Context, enabled func() bool, name string, clusterName string, handler v11.ServiceMonitorHandlerFunc)  {
// 	               panic("mock out the AddClusterScopedFeatureHandler method")
//             },
//             AddClusterScopedHandlerFunc: func(ctx context.Context, name string, clusterName string, handler v11.ServiceMonitorHandlerFunc)  {
// 	               panic("mock out the AddClusterScopedHandler method")
//             },
//             AddFeatureHandlerFunc: func(ctx context.Context, enabled func() bool, name string, syncMoqParam v11.ServiceMonitorHandlerFunc)  {
// 	               panic("mock out the AddFeatureHandler method")
//             },
//             AddHandlerFunc: func(ctx context.Context, name string, handler v11.ServiceMonitorHandlerFunc)  {
// 	               panic("mock out the AddHandler method")
//             },
//             EnqueueFunc: func(namespace string, name string)  {
// 	               panic("mock out the Enqueue method")
//             },
//             EnqueueAfterFunc: func(namespace string, name string, after time.Duration)  {
// 	               panic("mock out the EnqueueAfter method")
//             },
//             GenericFunc: func() controller.GenericController {
// 	               panic("mock out the Generic method")
//             },
//             InformerFunc: func() cache.SharedIndexInformer {
// 	               panic("mock out the Informer method")
//             },
//             ListerFunc: func() v11.ServiceMonitorLister {
// 	               panic("mock out the Lister method")
//             },
//         }
//
//         // use mockedServiceMonitorController in code that requires v11.ServiceMonitorController
//         // and then make assertions.
//
//     }
type ServiceMonitorControllerMock struct {
	// AddClusterScopedFeatureHandlerFunc mocks the AddClusterScopedFeatureHandler method.
	AddClusterScopedFeatureHandlerFunc func(ctx context.Context, enabled func() bool, name string, clusterName string, handler v11.ServiceMonitorHandlerFunc)

	// AddClusterScopedHandlerFunc mocks the AddClusterScopedHandler method.
	AddClusterScopedHandlerFunc func(ctx context.Context, name string, clusterName string, handler v11.ServiceMonitorHandlerFunc)

	// AddFeatureHandlerFunc mocks the AddFeatureHandler method.
	AddFeatureHandlerFunc func(ctx context.Context, enabled func() bool, name string, syncMoqParam v11.ServiceMonitorHandlerFunc)

	// AddHandlerFunc mocks the AddHandler method.
	AddHandlerFunc func(ctx context.Context, name string, handler v11.ServiceMonitorHandlerFunc)

	// EnqueueFunc mocks the Enqueue method.
	EnqueueFunc func(namespace string, name string)

	// EnqueueAfterFunc mocks the EnqueueAfter method.
	EnqueueAfterFunc func(namespace string, name string, after time.Duration)

	// GenericFunc mocks the Generic method.
	GenericFunc func() controller.GenericController

	// InformerFunc mocks the Informer method.
	InformerFunc func() cache.SharedIndexInformer

	// ListerFunc mocks the Lister method.
	ListerFunc func() v11.ServiceMonitorLister

	// calls tracks calls to the methods.
	calls struct {
		// AddClusterScopedFeatureHandler holds details about calls to the AddClusterScopedFeatureHandler method.
		AddClusterScopedFeatureHandler []struct {
			// Ctx is the ctx argument value.
			Ctx context.Context
			// Enabled is the enabled argument value.
			Enabled func() bool
			// Name is the name argument value.
			Name string
			// ClusterName is the clusterName argument value.
			ClusterName string
			// Handler is the handler argument value.
			Handler v11.ServiceMonitorHandlerFunc
		}
		// AddClusterScopedHandler holds details about calls to the AddClusterScopedHandler method.
		AddClusterScopedHandler []struct {
			// Ctx is the ctx argument value.
			Ctx context.Context
			// Name is the name argument value.
			Name string
			// ClusterName is the clusterName argument value.
			ClusterName string
			// Handler is the handler argument value.
			Handler v11.ServiceMonitorHandlerFunc
		}
		// AddFeatureHandler holds details about calls to the AddFeatureHandler method.
		AddFeatureHandler []struct {
			// Ctx is the ctx argument value.
			Ctx context.Context
			// Enabled is the enabled argument value.
			Enabled func() bool
			// Name is the name argument value.
			Name string
			// Sync is the sync argument value.
			Sync v11.ServiceMonitorHandlerFunc
		}
		// AddHandler holds details about calls to the AddHandler method.
		AddHandler []struct {
			// Ctx is the ctx argument value.
			Ctx context.Context
			// Name is the name argument value.
			Name string
			// Handler is the handler argument value.
			Handler v11.ServiceMonitorHandlerFunc
		}
		// Enqueue holds details about calls to the Enqueue method.
		Enqueue []struct {
			// Namespace is the namespace argument value.
			Namespace string
			// Name is the name argument value.
			Name string
		}
		// EnqueueAfter holds details about calls to the EnqueueAfter method.
		EnqueueAfter []struct {
			// Namespace is the namespace argument value.
			Namespace string
			// Name is the name argument value.
			Name string
			// After is the after argument value.
			After time.Duration
		}
		// Generic holds details about calls to the Generic method.
		Generic []struct {
		}
		// Informer holds details about calls to the Informer method.
		Informer []struct {
		}
		// Lister holds details about calls to the Lister method.
		Lister []struct {
		}
	}
}

// AddClusterScopedFeatureHandler calls AddClusterScopedFeatureHandlerFunc.
func (mock *ServiceMonitorControllerMock) AddClusterScopedFeatureHandler(ctx context.Context, enabled func() bool, name string, clusterName string, handler v11.ServiceMonitorHandlerFunc) {
	if mock.AddClusterScopedFeatureHandlerFunc == nil {
		panic("ServiceMonitorControllerMock.AddClusterScopedFeatureHandlerFunc: method is nil but ServiceMonitorController.AddClusterScopedFeatureHandler was just called")
	}
	callInfo := struct {
		Ctx         context.Context
		Enabled     func() bool
		Name        string
		ClusterName string
		Handler     v11.ServiceMonitorHandlerFunc
	}{
		Ctx:         ctx,
		Enabled:     enabled,
		Name:        name,
		ClusterName: clusterName,
		Handler:     handler,
	}
	lockServiceMonitorControllerMockAddClusterScopedFeatureHandler.Lock()
	mock.calls.AddClusterScopedFeatureHandler = append(mock.calls.AddClusterScopedFeatureHandler, callInfo)
	lockServiceMonitorControllerMockAddClusterScopedFeatureHandler.Unlock()
	mock.AddClusterScopedFeatureHandlerFunc(ctx, enabled, name, clusterName, handler)
}

// AddClusterScopedFeatureHandlerCalls gets all the calls that were made to AddClusterScopedFeatureHandler.
// Check the length with:
//     len(mockedServiceMonitorController.AddClusterScopedFeatureHandlerCalls())
func (mock *ServiceMonitorControllerMock) AddClusterScopedFeatureHandlerCalls() []struct {
	Ctx         context.Context
	Enabled     func() bool
	Name        string
	ClusterName string
	Handler     v11.ServiceMonitorHandlerFunc
} {
	var calls []struct {
		Ctx         context.Context
		Enabled     func() bool
		Name        string
		ClusterName string
		Handler     v11.ServiceMonitorHandlerFunc
	}
	lockServiceMonitorControllerMockAddClusterScopedFeatureHandler.RLock()
	calls = mock.calls.AddClusterScopedFeatureHandler
	lockServiceMonitorControllerMockAddClusterScopedFeatureHandler.RUnlock()
	return calls
}

// AddClusterScopedHandler calls AddClusterScopedHandlerFunc.
func (mock *ServiceMonitorControllerMock) AddClusterScopedHandler(ctx context.Context, name string, clusterName string, handler v11.ServiceMonitorHandlerFunc) {
	if mock.AddClusterScopedHandlerFunc == nil {
		panic("ServiceMonitorControllerMock.AddClusterScopedHandlerFunc: method is nil but ServiceMonitorController.AddClusterScopedHandler was just called")
	}
	callInfo := struct {
		Ctx         context.Context
		Name        string
		ClusterName string
		Handler     v11.ServiceMonitorHandlerFunc
	}{
		Ctx:         ctx,
		Name:        name,
		ClusterName: clusterName,
		Handler:     handler,
	}
	lockServiceMonitorControllerMockAddClusterScopedHandler.Lock()
	mock.calls.AddClusterScopedHandler = append(mock.calls.AddClusterScopedHandler, callInfo)
	lockServiceMonitorControllerMockAddClusterScopedHandler.Unlock()
	mock.AddClusterScopedHandlerFunc(ctx, name, clusterName, handler)
}

// AddClusterScopedHandlerCalls gets all the calls that were made to AddClusterScopedHandler.
// Check the length with:
//     len(mockedServiceMonitorController.AddClusterScopedHandlerCalls())
func (mock *ServiceMonitorControllerMock) AddClusterScopedHandlerCalls() []struct {
	Ctx         context.Context
	Name        string
	ClusterName string
	Handler     v11.ServiceMonitorHandlerFunc
} {
	var calls []struct {
		Ctx         context.Context
		Name        string
		ClusterName string
		Handler     v11.ServiceMonitorHandlerFunc
	}
	lockServiceMonitorControllerMockAddClusterScopedHandler.RLock()
	calls = mock.calls.AddClusterScopedHandler
	lockServiceMonitorControllerMockAddClusterScopedHandler.RUnlock()
	return calls
}

// AddFeatureHandler calls AddFeatureHandlerFunc.
func (mock *ServiceMonitorControllerMock) AddFeatureHandler(ctx context.Context, enabled func() bool, name string, syncMoqParam v11.ServiceMonitorHandlerFunc) {
	if mock.AddFeatureHandlerFunc == nil {
		panic("ServiceMonitorControllerMock.AddFeatureHandlerFunc: method is nil but ServiceMonitorController.AddFeatureHandler was just called")
	}
	callInfo := struct {
		Ctx     context.Context
		Enabled func() bool
		Name    string
		Sync    v11.ServiceMonitorHandlerFunc
	}{
		Ctx:     ctx,
		Enabled: enabled,
		Name:    name,
		Sync:    syncMoqParam,
	}
	lockServiceMonitorControllerMockAddFeatureHandler.Lock()
	mock.calls.AddFeatureHandler = append(mock.calls.AddFeatureHandler, callInfo)
	lockServiceMonitorControllerMockAddFeatureHandler.Unlock()
	mock.AddFeatureHandlerFunc(ctx, enabled, name, syncMoqParam)
}

// AddFeatureHandlerCalls gets all the calls that were made to AddFeatureHandler.
// Check the length with:
//     len(mockedServiceMonitorController.AddFeatureHandlerCalls())
func (mock *ServiceMonitorControllerMock) AddFeatureHandlerCalls() []struct {
	Ctx     context.Context
	Enabled func() bool
	Name    string
	Sync    v11.ServiceMonitorHandlerFunc
} {
	var calls []struct {
		Ctx     context.Context
		Enabled func() bool
		Name    string
		Sync    v11.ServiceMonitorHandlerFunc
	}
	lockServiceMonitorControllerMockAddFeatureHandler.RLock()
	calls = mock.calls.AddFeatureHandler
	lockServiceMonitorControllerMockAddFeatureHandler.RUnlock()
	return calls
}

// AddHandler calls AddHandlerFunc.
func (mock *ServiceMonitorControllerMock) AddHandler(ctx context.Context, name string, handler v11.ServiceMonitorHandlerFunc) {
	if mock.AddHandlerFunc == nil {
		panic("ServiceMonitorControllerMock.AddHandlerFunc: method is nil but ServiceMonitorController.AddHandler was just called")
	}
	callInfo := struct {
		Ctx     context.Context
		Name    string
		Handler v11.ServiceMonitorHandlerFunc
	}{
		Ctx:     ctx,
		Name:    name,
		Handler: handler,
	}
	lockServiceMonitorControllerMockAddHandler.Lock()
	mock.calls.AddHandler = append(mock.calls.AddHandler, callInfo)
	lockServiceMonitorControllerMockAddHandler.Unlock()
	mock.AddHandlerFunc(ctx, name, handler)
}

// AddHandlerCalls gets all the calls that were made to AddHandler.
// Check the length with:
//     len(mockedServiceMonitorController.AddHandlerCalls())
func (mock *ServiceMonitorControllerMock) AddHandlerCalls() []struct {
	Ctx     context.Context
	Name    string
	Handler v11.ServiceMonitorHandlerFunc
} {
	var calls []struct {
		Ctx     context.Context
		Name    string
		Handler v11.ServiceMonitorHandlerFunc
	}
	lockServiceMonitorControllerMockAddHandler.RLock()
	calls = mock.calls.AddHandler
	lockServiceMonitorControllerMockAddHandler.RUnlock()
	return calls
}

// Enqueue calls EnqueueFunc.
func (mock *ServiceMonitorControllerMock) Enqueue(namespace string, name string) {
	if mock.EnqueueFunc == nil {
		panic("ServiceMonitorControllerMock.EnqueueFunc: method is nil but ServiceMonitorController.Enqueue was just called")
	}
	callInfo := struct {
		Namespace string
		Name      string
	}{
		Namespace: namespace,
		Name:      name,
	}
	lockServiceMonitorControllerMockEnqueue.Lock()
	mock.calls.Enqueue = append(mock.calls.Enqueue, callInfo)
	lockServiceMonitorControllerMockEnqueue.Unlock()
	mock.EnqueueFunc(namespace, name)
}

// EnqueueCalls gets all the calls that were made to Enqueue.
// Check the length with:
//     len(mockedServiceMonitorController.EnqueueCalls())
func (mock *ServiceMonitorControllerMock) EnqueueCalls() []struct {
	Namespace string
	Name      string
} {
	var calls []struct {
		Namespace string
		Name      string
	}
	lockServiceMonitorControllerMockEnqueue.RLock()
	calls = mock.calls.Enqueue
	lockServiceMonitorControllerMockEnqueue.RUnlock()
	return calls
}

// EnqueueAfter calls EnqueueAfterFunc.
func (mock *ServiceMonitorControllerMock) EnqueueAfter(namespace string, name string, after time.Duration) {
	if mock.EnqueueAfterFunc == nil {
		panic("ServiceMonitorControllerMock.EnqueueAfterFunc: method is nil but ServiceMonitorController.EnqueueAfter was just called")
	}
	callInfo := struct {
		Namespace string
		Name      string
		After     time.Duration
	}{
		Namespace: namespace,
		Name:      name,
		After:     after,
	}
	lockServiceMonitorControllerMockEnqueueAfter.Lock()
	mock.calls.EnqueueAfter = append(mock.calls.EnqueueAfter, callInfo)
	lockServiceMonitorControllerMockEnqueueAfter.Unlock()
	mock.EnqueueAfterFunc(namespace, name, after)
}

// EnqueueAfterCalls gets all the calls that were made to EnqueueAfter.
// Check the length with:
//     len(mockedServiceMonitorController.EnqueueAfterCalls())
func (mock *ServiceMonitorControllerMock) EnqueueAfterCalls() []struct {
	Namespace string
	Name      string
	After     time.Duration
} {
	var calls []struct {
		Namespace string
		Name      string
		After     time.Duration
	}
	lockServiceMonitorControllerMockEnqueueAfter.RLock()
	calls = mock.calls.EnqueueAfter
	lockServiceMonitorControllerMockEnqueueAfter.RUnlock()
	return calls
}

// Generic calls GenericFunc.
func (mock *ServiceMonitorControllerMock) Generic() controller.GenericController {
	if mock.GenericFunc == nil {
		panic("ServiceMonitorControllerMock.GenericFunc: method is nil but ServiceMonitorController.Generic was just called")
	}
	callInfo := struct {
	}{}
	lockServiceMonitorControllerMockGeneric.Lock()
	mock.calls.Generic = append(mock.calls.Generic, callInfo)
	lockServiceMonitorControllerMockGeneric.Unlock()
	return mock.GenericFunc()
}

// GenericCalls gets all the calls that were made to Generic.
// Check the length with:
//     len(mockedServiceMonitorController.GenericCalls())
func (mock *ServiceMonitorControllerMock) GenericCalls() []struct {
} {
	var calls []struct {
	}
	lockServiceMonitorControllerMockGeneric.RLock()
	calls = mock.calls.Generic
	lockServiceMonitorControllerMockGeneric.RUnlock()
	return calls
}

// Informer calls InformerFunc.
func (mock *ServiceMonitorControllerMock) Informer() cache.SharedIndexInformer {
	if mock.InformerFunc == nil {
		panic("ServiceMonitorControllerMock.InformerFunc: method is nil but ServiceMonitorController.Informer was just called")
	}
	callInfo := struct {
	}{}
	lockServiceMonitorControllerMockInformer.Lock()
	mock.calls.Informer = append(mock.calls.Informer, callInfo)
	lockServiceMonitorControllerMockInformer.Unlock()
	return mock.InformerFunc()
}

// InformerCalls gets all the calls that were made to Informer.
// Check the length with:
//     len(mockedServiceMonitorController.InformerCalls())
func (mock *ServiceMonitorControllerMock) InformerCalls() []struct {
} {
	var calls []struct {
	}
	lockServiceMonitorControllerMockInformer.RLock()
	calls = mock.calls.Informer
	lockServiceMonitorControllerMockInformer.RUnlock()
	return calls
}

// Lister calls ListerFunc.
func (mock *ServiceMonitorControllerMock) Lister() v11.ServiceMonitorLister {
	if mock.ListerFunc == nil {
		panic("ServiceMonitorControllerMock.ListerFunc: method is nil but ServiceMonitorController.Lister was just called")
	}
	callInfo := struct {
	}{}
	lockServiceMonitorControllerMockLister.Lock()
	mock.calls.Lister = append(mock.calls.Lister, callInfo)
	lockServiceMonitorControllerMockLister.Unlock()
	return mock.ListerFunc()
}

// ListerCalls gets all the calls that were made to Lister.
// Check the length with:
//     len(mockedServiceMonitorController.ListerCalls())
func (mock *ServiceMonitorControllerMock) ListerCalls() []struct {
} {
	var calls []struct {
	}
	lockServiceMonitorControllerMockLister.RLock()
	calls = mock.calls.Lister
	lockServiceMonitorControllerMockLister.RUnlock()
	return calls
}

var (
	lockServiceMonitorInterfaceMockAddClusterScopedFeatureHandler   sync.RWMutex
	lockServiceMonitorInterfaceMockAddClusterScopedFeatureLifecycle sync.RWMutex
	lockServiceMonitorInterfaceMockAddClusterScopedHandler          sync.RWMutex
	lockServiceMonitorInterfaceMockAddClusterScopedLifecycle        sync.RWMutex
	lockServiceMonitorInterfaceMockAddFeatureHandler                sync.RWMutex
	lockServiceMonitorInterfaceMockAddFeatureLifecycle              sync.RWMutex
	lockServiceMonitorInterfaceMockAddHandler                       sync.RWMutex
	lockServiceMonitorInterfaceMockAddLifecycle                     sync.RWMutex
	lockServiceMonitorInterfaceMockController                       sync.RWMutex
	lockServiceMonitorInterfaceMockCreate                           sync.RWMutex
	lockServiceMonitorInterfaceMockDelete                           sync.RWMutex
	lockServiceMonitorInterfaceMockDeleteCollection                 sync.RWMutex
	lockServiceMonitorInterfaceMockDeleteNamespaced                 sync.RWMutex
	lockServiceMonitorInterfaceMockGet                              sync.RWMutex
	lockServiceMonitorInterfaceMockGetNamespaced                    sync.RWMutex
	lockServiceMonitorInterfaceMockList                             sync.RWMutex
	lockServiceMonitorInterfaceMockListNamespaced                   sync.RWMutex
	lockServiceMonitorInterfaceMockObjectClient                     sync.RWMutex
	lockServiceMonitorInterfaceMockUpdate                           sync.RWMutex
	lockServiceMonitorInterfaceMockWatch                            sync.RWMutex
)

// Ensure, that ServiceMonitorInterfaceMock does implement v11.ServiceMonitorInterface.
// If this is not the case, regenerate this file with moq.
var _ v11.ServiceMonitorInterface = &ServiceMonitorInterfaceMock{}

// ServiceMonitorInterfaceMock is a mock implementation of v11.ServiceMonitorInterface.
//
//     func TestSomethingThatUsesServiceMonitorInterface(t *testing.T) {
//
//         // make and configure a mocked v11.ServiceMonitorInterface
//         mockedServiceMonitorInterface := &ServiceMonitorInterfaceMock{
//             AddClusterScopedFeatureHandlerFunc: func(ctx context.Context, enabled func() bool, name string, clusterName string, syncMoqParam v11.ServiceMonitorHandlerFunc)  {
// 	               panic("mock out the AddClusterScopedFeatureHandler method")
//             },
//             AddClusterScopedFeatureLifecycleFunc: func(ctx context.Context, enabled func() bool, name string, clusterName string, lifecycle v11.ServiceMonitorLifecycle)  {
// 	               panic("mock out the AddClusterScopedFeatureLifecycle method")
//             },
//             AddClusterScopedHandlerFunc: func(ctx context.Context, name string, clusterName string, syncMoqParam v11.ServiceMonitorHandlerFunc)  {
// 	               panic("mock out the AddClusterScopedHandler method")
//             },
//             AddClusterScopedLifecycleFunc: func(ctx context.Context, name string, clusterName string, lifecycle v11.ServiceMonitorLifecycle)  {
// 	               panic("mock out the AddClusterScopedLifecycle method")
//             },
//             AddFeatureHandlerFunc: func(ctx context.Context, enabled func() bool, name string, syncMoqParam v11.ServiceMonitorHandlerFunc)  {
// 	               panic("mock out the AddFeatureHandler method")
//             },
//             AddFeatureLifecycleFunc: func(ctx context.Context, enabled func() bool, name string, lifecycle v11.ServiceMonitorLifecycle)  {
// 	               panic("mock out the AddFeatureLifecycle method")
//             },
//             AddHandlerFunc: func(ctx context.Context, name string, syncMoqParam v11.ServiceMonitorHandlerFunc)  {
// 	               panic("mock out the AddHandler method")
//             },
//             AddLifecycleFunc: func(ctx context.Context, name string, lifecycle v11.ServiceMonitorLifecycle)  {
// 	               panic("mock out the AddLifecycle method")
//             },
//             ControllerFunc: func() v11.ServiceMonitorController {
// 	               panic("mock out the Controller method")
//             },
//             CreateFunc: func(in1 *v1.ServiceMonitor) (*v1.ServiceMonitor, error) {
// 	               panic("mock out the Create method")
//             },
//             DeleteFunc: func(name string, options *metav1.DeleteOptions) error {
// 	               panic("mock out the Delete method")
//             },
//             DeleteCollectionFunc: func(deleteOpts *metav1.DeleteOptions, listOpts metav1.ListOptions) error {
// 	               panic("mock out the DeleteCollection method")
//             },
//             DeleteNamespacedFunc: func(namespace string, name string, options *metav1.DeleteOptions) error {
// 	               panic("mock out the DeleteNamespaced method")
//             },
//             GetFunc: func(name string, opts metav1.GetOptions) (*v1.ServiceMonitor, error) {
// 	               panic("mock out the Get method")
//             },
//             GetNamespacedFunc: func(namespace string, name string, opts metav1.GetOptions) (*v1.ServiceMonitor, error) {
// 	               panic("mock out the GetNamespaced method")
//             },
//             ListFunc: func(opts metav1.ListOptions) (*v1.ServiceMonitorList, error) {
// 	               panic("mock out the List method")
//             },
//             ListNamespacedFunc: func(namespace string, opts metav1.ListOptions) (*v1.ServiceMonitorList, error) {
// 	               panic("mock out the ListNamespaced method")
//             },
//             ObjectClientFunc: func() *objectclient.ObjectClient {
// 	               panic("mock out the ObjectClient method")
//             },
//             UpdateFunc: func(in1 *v1.ServiceMonitor) (*v1.ServiceMonitor, error) {
// 	               panic("mock out the Update method")
//             },
//             WatchFunc: func(opts metav1.ListOptions) (watch.Interface, error) {
// 	               panic("mock out the Watch method")
//             },
//         }
//
//         // use mockedServiceMonitorInterface in code that requires v11.ServiceMonitorInterface
//         // and then make assertions.
//
//     }
type ServiceMonitorInterfaceMock struct {
	// AddClusterScopedFeatureHandlerFunc mocks the AddClusterScopedFeatureHandler method.
	AddClusterScopedFeatureHandlerFunc func(ctx context.Context, enabled func() bool, name string, clusterName string, syncMoqParam v11.ServiceMonitorHandlerFunc)

	// AddClusterScopedFeatureLifecycleFunc mocks the AddClusterScopedFeatureLifecycle method.
	AddClusterScopedFeatureLifecycleFunc func(ctx context.Context, enabled func() bool, name string, clusterName string, lifecycle v11.ServiceMonitorLifecycle)

	// AddClusterScopedHandlerFunc mocks the AddClusterScopedHandler method.
	AddClusterScopedHandlerFunc func(ctx context.Context, name string, clusterName string, syncMoqParam v11.ServiceMonitorHandlerFunc)

	// AddClusterScopedLifecycleFunc mocks the AddClusterScopedLifecycle method.
	AddClusterScopedLifecycleFunc func(ctx context.Context, name string, clusterName string, lifecycle v11.ServiceMonitorLifecycle)

	// AddFeatureHandlerFunc mocks the AddFeatureHandler method.
	AddFeatureHandlerFunc func(ctx context.Context, enabled func() bool, name string, syncMoqParam v11.ServiceMonitorHandlerFunc)

	// AddFeatureLifecycleFunc mocks the AddFeatureLifecycle method.
	AddFeatureLifecycleFunc func(ctx context.Context, enabled func() bool, name string, lifecycle v11.ServiceMonitorLifecycle)

	// AddHandlerFunc mocks the AddHandler method.
	AddHandlerFunc func(ctx context.Context, name string, syncMoqParam v11.ServiceMonitorHandlerFunc)

	// AddLifecycleFunc mocks the AddLifecycle method.
	AddLifecycleFunc func(ctx context.Context, name string, lifecycle v11.ServiceMonitorLifecycle)

	// ControllerFunc mocks the Controller method.
	ControllerFunc func() v11.ServiceMonitorController

	// CreateFunc mocks the Create method.
	CreateFunc func(in1 *v1.ServiceMonitor) (*v1.ServiceMonitor, error)

	// DeleteFunc mocks the Delete method.
	DeleteFunc func(name string, options *metav1.DeleteOptions) error

	// DeleteCollectionFunc mocks the DeleteCollection method.
	DeleteCollectionFunc func(deleteOpts *metav1.DeleteOptions, listOpts metav1.ListOptions) error

	// DeleteNamespacedFunc mocks the DeleteNamespaced method.
	DeleteNamespacedFunc func(namespace string, name string, options *metav1.DeleteOptions) error

	// GetFunc mocks the Get method.
	GetFunc func(name string, opts metav1.GetOptions) (*v1.ServiceMonitor, error)

	// GetNamespacedFunc mocks the GetNamespaced method.
	GetNamespacedFunc func(namespace string, name string, opts metav1.GetOptions) (*v1.ServiceMonitor, error)

	// ListFunc mocks the List method.
	ListFunc func(opts metav1.ListOptions) (*v1.ServiceMonitorList, error)

	// ListNamespacedFunc mocks the ListNamespaced method.
	ListNamespacedFunc func(namespace string, opts metav1.ListOptions) (*v1.ServiceMonitorList, error)

	// ObjectClientFunc mocks the ObjectClient method.
	ObjectClientFunc func() *objectclient.ObjectClient

	// UpdateFunc mocks the Update method.
	UpdateFunc func(in1 *v1.ServiceMonitor) (*v1.ServiceMonitor, error)

	// WatchFunc mocks the Watch method.
	WatchFunc func(opts metav1.ListOptions) (watch.Interface, error)

	// calls tracks calls to the methods.
	calls struct {
		// AddClusterScopedFeatureHandler holds details about calls to the AddClusterScopedFeatureHandler method.
		AddClusterScopedFeatureHandler []struct {
			// Ctx is the ctx argument value.
			Ctx context.Context
			// Enabled is the enabled argument value.
			Enabled func() bool
			// Name is the name argument value.
			Name string
			// ClusterName is the clusterName argument value.
			ClusterName string
			// Sync is the sync argument value.
			Sync v11.ServiceMonitorHandlerFunc
		}
		// AddClusterScopedFeatureLifecycle holds details about calls to the AddClusterScopedFeatureLifecycle method.
		AddClusterScopedFeatureLifecycle []struct {
			// Ctx is the ctx argument value.
			Ctx context.Context
			// Enabled is the enabled argument value.
			Enabled func() bool
			// Name is the name argument value.
			Name string
			// ClusterName is the clusterName argument value.
			ClusterName string
			// Lifecycle is the lifecycle argument value.
			Lifecycle v11.ServiceMonitorLifecycle
		}
		// AddClusterScopedHandler holds details about calls to the AddClusterScopedHandler method.
		AddClusterScopedHandler []struct {
			// Ctx is the ctx argument value.
			Ctx context.Context
			// Name is the name argument value.
			Name string
			// ClusterName is the clusterName argument value.
			ClusterName string
			// Sync is the sync argument value.
			Sync v11.ServiceMonitorHandlerFunc
		}
		// AddClusterScopedLifecycle holds details about calls to the AddClusterScopedLifecycle method.
		AddClusterScopedLifecycle []struct {
			// Ctx is the ctx argument value.
			Ctx context.Context
			// Name is the name argument value.
			Name string
			// ClusterName is the clusterName argument value.
			ClusterName string
			// Lifecycle is the lifecycle argument value.
			Lifecycle v11.ServiceMonitorLifecycle
		}
		// AddFeatureHandler holds details about calls to the AddFeatureHandler method.
		AddFeatureHandler []struct {
			// Ctx is the ctx argument value.
			Ctx context.Context
			// Enabled is the enabled argument value.
			Enabled func() bool
			// Name is the name argument value.
			Name string
			// Sync is the sync argument value.
			Sync v11.ServiceMonitorHandlerFunc
		}
		// AddFeatureLifecycle holds details about calls to the AddFeatureLifecycle method.
		AddFeatureLifecycle []struct {
			// Ctx is the ctx argument value.
			Ctx context.Context
			// Enabled is the enabled argument value.
			Enabled func() bool
			// Name is the name argument value.
			Name string
			// Lifecycle is the lifecycle argument value.
			Lifecycle v11.ServiceMonitorLifecycle
		}
		// AddHandler holds details about calls to the AddHandler method.
		AddHandler []struct {
			// Ctx is the ctx argument value.
			Ctx context.Context
			// Name is the name argument value.
			Name string
			// Sync is the sync argument value.
			Sync v11.ServiceMonitorHandlerFunc
		}
		// AddLifecycle holds details about calls to the AddLifecycle method.
		AddLifecycle []struct {
			// Ctx is the ctx argument value.
			Ctx context.Context
			// Name is the name argument value.
			Name string
			// Lifecycle is the lifecycle argument value.
			Lifecycle v11.ServiceMonitorLifecycle
		}
		// Controller holds details about calls to the Controller method.
		Controller []struct {
		}
		// Create holds details about calls to the Create method.
		Create []struct {
			// In1 is the in1 argument value.
			In1 *v1.ServiceMonitor
		}
		// Delete holds details about calls to the Delete method.
		Delete []struct {
			// Name is the name argument value.
			Name string
			// Options is the options argument value.
			Options *metav1.DeleteOptions
		}
		// DeleteCollection holds details about calls to the DeleteCollection method.
		DeleteCollection []struct {
			// DeleteOpts is the deleteOpts argument value.
			DeleteOpts *metav1.DeleteOptions
			// ListOpts is the listOpts argument value.
			ListOpts metav1.ListOptions
		}
		// DeleteNamespaced holds details about calls to the DeleteNamespaced method.
		DeleteNamespaced []struct {
			// Namespace is the namespace argument value.
			Namespace string
			// Name is the name argument value.
			Name string
			// Options is the options argument value.
			Options *metav1.DeleteOptions
		}
		// Get holds details about calls to the Get method.
		Get []struct {
			// Name is the name argument value.
			Name string
			// Opts is the opts argument value.
			Opts metav1.GetOptions
		}
		// GetNamespaced holds details about calls to the GetNamespaced method.
		GetNamespaced []struct {
			// Namespace is the namespace argument value.
			Namespace string
			// Name is the name argument value.
			Name string
			// Opts is the opts argument value.
			Opts metav1.GetOptions
		}
		// List holds details about calls to the List method.
		List []struct {
			// Opts is the opts argument value.
			Opts metav1.ListOptions
		}
		// ListNamespaced holds details about calls to the ListNamespaced method.
		ListNamespaced []struct {
			// Namespace is the namespace argument value.
			Namespace string
			// Opts is the opts argument value.
			Opts metav1.ListOptions
		}
		// ObjectClient holds details about calls to the ObjectClient method.
		ObjectClient []struct {
		}
		// Update holds details about calls to the Update method.
		Update []struct {
			// In1 is the in1 argument value.
			In1 *v1.ServiceMonitor
		}
		// Watch holds details about calls to the Watch method.
		Watch []struct {
			// Opts is the opts argument value.
			Opts metav1.ListOptions
		}
	}
}

// AddClusterScopedFeatureHandler calls AddClusterScopedFeatureHandlerFunc.
func (mock *ServiceMonitorInterfaceMock) AddClusterScopedFeatureHandler(ctx context.Context, enabled func() bool, name string, clusterName string, syncMoqParam v11.ServiceMonitorHandlerFunc) {
	if mock.AddClusterScopedFeatureHandlerFunc == nil {
		panic("ServiceMonitorInterfaceMock.AddClusterScopedFeatureHandlerFunc: method is nil but ServiceMonitorInterface.AddClusterScopedFeatureHandler was just called")
	}
	callInfo := struct {
		Ctx         context.Context
		Enabled     func() bool
		Name        string
		ClusterName string
		Sync        v11.ServiceMonitorHandlerFunc
	}{
		Ctx:         ctx,
		Enabled:     enabled,
		Name:        name,
		ClusterName: clusterName,
		Sync:        syncMoqParam,
	}
	lockServiceMonitorInterfaceMockAddClusterScopedFeatureHandler.Lock()
	mock.calls.AddClusterScopedFeatureHandler = append(mock.calls.AddClusterScopedFeatureHandler, callInfo)
	lockServiceMonitorInterfaceMockAddClusterScopedFeatureHandler.Unlock()
	mock.AddClusterScopedFeatureHandlerFunc(ctx, enabled, name, clusterName, syncMoqParam)
}

// AddClusterScopedFeatureHandlerCalls gets all the calls that were made to AddClusterScopedFeatureHandler.
// Check the length with:
//     len(mockedServiceMonitorInterface.AddClusterScopedFeatureHandlerCalls())
func (mock *ServiceMonitorInterfaceMock) AddClusterScopedFeatureHandlerCalls() []struct {
	Ctx         context.Context
	Enabled     func() bool
	Name        string
	ClusterName string
	Sync        v11.ServiceMonitorHandlerFunc
} {
	var calls []struct {
		Ctx         context.Context
		Enabled     func() bool
		Name        string
		ClusterName string
		Sync        v11.ServiceMonitorHandlerFunc
	}
	lockServiceMonitorInterfaceMockAddClusterScopedFeatureHandler.RLock()
	calls = mock.calls.AddClusterScopedFeatureHandler
	lockServiceMonitorInterfaceMockAddClusterScopedFeatureHandler.RUnlock()
	return calls
}

// AddClusterScopedFeatureLifecycle calls AddClusterScopedFeatureLifecycleFunc.
func (mock *ServiceMonitorInterfaceMock) AddClusterScopedFeatureLifecycle(ctx context.Context, enabled func() bool, name string, clusterName string, lifecycle v11.ServiceMonitorLifecycle) {
	if mock.AddClusterScopedFeatureLifecycleFunc == nil {
		panic("ServiceMonitorInterfaceMock.AddClusterScopedFeatureLifecycleFunc: method is nil but ServiceMonitorInterface.AddClusterScopedFeatureLifecycle was just called")
	}
	callInfo := struct {
		Ctx         context.Context
		Enabled     func() bool
		Name        string
		ClusterName string
		Lifecycle   v11.ServiceMonitorLifecycle
	}{
		Ctx:         ctx,
		Enabled:     enabled,
		Name:        name,
		ClusterName: clusterName,
		Lifecycle:   lifecycle,
	}
	lockServiceMonitorInterfaceMockAddClusterScopedFeatureLifecycle.Lock()
	mock.calls.AddClusterScopedFeatureLifecycle = append(mock.calls.AddClusterScopedFeatureLifecycle, callInfo)
	lockServiceMonitorInterfaceMockAddClusterScopedFeatureLifecycle.Unlock()
	mock.AddClusterScopedFeatureLifecycleFunc(ctx, enabled, name, clusterName, lifecycle)
}

// AddClusterScopedFeatureLifecycleCalls gets all the calls that were made to AddClusterScopedFeatureLifecycle.
// Check the length with:
//     len(mockedServiceMonitorInterface.AddClusterScopedFeatureLifecycleCalls())
func (mock *ServiceMonitorInterfaceMock) AddClusterScopedFeatureLifecycleCalls() []struct {
	Ctx         context.Context
	Enabled     func() bool
	Name        string
	ClusterName string
	Lifecycle   v11.ServiceMonitorLifecycle
} {
	var calls []struct {
		Ctx         context.Context
		Enabled     func() bool
		Name        string
		ClusterName string
		Lifecycle   v11.ServiceMonitorLifecycle
	}
	lockServiceMonitorInterfaceMockAddClusterScopedFeatureLifecycle.RLock()
	calls = mock.calls.AddClusterScopedFeatureLifecycle
	lockServiceMonitorInterfaceMockAddClusterScopedFeatureLifecycle.RUnlock()
	return calls
}

// AddClusterScopedHandler calls AddClusterScopedHandlerFunc.
func (mock *ServiceMonitorInterfaceMock) AddClusterScopedHandler(ctx context.Context, name string, clusterName string, syncMoqParam v11.ServiceMonitorHandlerFunc) {
	if mock.AddClusterScopedHandlerFunc == nil {
		panic("ServiceMonitorInterfaceMock.AddClusterScopedHandlerFunc: method is nil but ServiceMonitorInterface.AddClusterScopedHandler was just called")
	}
	callInfo := struct {
		Ctx         context.Context
		Name        string
		ClusterName string
		Sync        v11.ServiceMonitorHandlerFunc
	}{
		Ctx:         ctx,
		Name:        name,
		ClusterName: clusterName,
		Sync:        syncMoqParam,
	}
	lockServiceMonitorInterfaceMockAddClusterScopedHandler.Lock()
	mock.calls.AddClusterScopedHandler = append(mock.calls.AddClusterScopedHandler, callInfo)
	lockServiceMonitorInterfaceMockAddClusterScopedHandler.Unlock()
	mock.AddClusterScopedHandlerFunc(ctx, name, clusterName, syncMoqParam)
}

// AddClusterScopedHandlerCalls gets all the calls that were made to AddClusterScopedHandler.
// Check the length with:
//     len(mockedServiceMonitorInterface.AddClusterScopedHandlerCalls())
func (mock *ServiceMonitorInterfaceMock) AddClusterScopedHandlerCalls() []struct {
	Ctx         context.Context
	Name        string
	ClusterName string
	Sync        v11.ServiceMonitorHandlerFunc
} {
	var calls []struct {
		Ctx         context.Context
		Name        string
		ClusterName string
		Sync        v11.ServiceMonitorHandlerFunc
	}
	lockServiceMonitorInterfaceMockAddClusterScopedHandler.RLock()
	calls = mock.calls.AddClusterScopedHandler
	lockServiceMonitorInterfaceMockAddClusterScopedHandler.RUnlock()
	return calls
}

// AddClusterScopedLifecycle calls AddClusterScopedLifecycleFunc.
func (mock *ServiceMonitorInterfaceMock) AddClusterScopedLifecycle(ctx context.Context, name string, clusterName string, lifecycle v11.ServiceMonitorLifecycle) {
	if mock.AddClusterScopedLifecycleFunc == nil {
		panic("ServiceMonitorInterfaceMock.AddClusterScopedLifecycleFunc: method is nil but ServiceMonitorInterface.AddClusterScopedLifecycle was just called")
	}
	callInfo := struct {
		Ctx         context.Context
		Name        string
		ClusterName string
		Lifecycle   v11.ServiceMonitorLifecycle
	}{
		Ctx:         ctx,
		Name:        name,
		ClusterName: clusterName,
		Lifecycle:   lifecycle,
	}
	lockServiceMonitorInterfaceMockAddClusterScopedLifecycle.Lock()
	mock.calls.AddClusterScopedLifecycle = append(mock.calls.AddClusterScopedLifecycle, callInfo)
	lockServiceMonitorInterfaceMockAddClusterScopedLifecycle.Unlock()
	mock.AddClusterScopedLifecycleFunc(ctx, name, clusterName, lifecycle)
}

// AddClusterScopedLifecycleCalls gets all the calls that were made to AddClusterScopedLifecycle.
// Check the length with:
//     len(mockedServiceMonitorInterface.AddClusterScopedLifecycleCalls())
func (mock *ServiceMonitorInterfaceMock) AddClusterScopedLifecycleCalls() []struct {
	Ctx         context.Context
	Name        string
	ClusterName string
	Lifecycle   v11.ServiceMonitorLifecycle
} {
	var calls []struct {
		Ctx         context.Context
		Name        string
		ClusterName string
		Lifecycle   v11.ServiceMonitorLifecycle
	}
	lockServiceMonitorInterfaceMockAddClusterScopedLifecycle.RLock()
	calls = mock.calls.AddClusterScopedLifecycle
	lockServiceMonitorInterfaceMockAddClusterScopedLifecycle.RUnlock()
	return calls
}

// AddFeatureHandler calls AddFeatureHandlerFunc.
func (mock *ServiceMonitorInterfaceMock) AddFeatureHandler(ctx context.Context, enabled func() bool, name string, syncMoqParam v11.ServiceMonitorHandlerFunc) {
	if mock.AddFeatureHandlerFunc == nil {
		panic("ServiceMonitorInterfaceMock.AddFeatureHandlerFunc: method is nil but ServiceMonitorInterface.AddFeatureHandler was just called")
	}
	callInfo := struct {
		Ctx     context.Context
		Enabled func() bool
		Name    string
		Sync    v11.ServiceMonitorHandlerFunc
	}{
		Ctx:     ctx,
		Enabled: enabled,
		Name:    name,
		Sync:    syncMoqParam,
	}
	lockServiceMonitorInterfaceMockAddFeatureHandler.Lock()
	mock.calls.AddFeatureHandler = append(mock.calls.AddFeatureHandler, callInfo)
	lockServiceMonitorInterfaceMockAddFeatureHandler.Unlock()
	mock.AddFeatureHandlerFunc(ctx, enabled, name, syncMoqParam)
}

// AddFeatureHandlerCalls gets all the calls that were made to AddFeatureHandler.
// Check the length with:
//     len(mockedServiceMonitorInterface.AddFeatureHandlerCalls())
func (mock *ServiceMonitorInterfaceMock) AddFeatureHandlerCalls() []struct {
	Ctx     context.Context
	Enabled func() bool
	Name    string
	Sync    v11.ServiceMonitorHandlerFunc
} {
	var calls []struct {
		Ctx     context.Context
		Enabled func() bool
		Name    string
		Sync    v11.ServiceMonitorHandlerFunc
	}
	lockServiceMonitorInterfaceMockAddFeatureHandler.RLock()
	calls = mock.calls.AddFeatureHandler
	lockServiceMonitorInterfaceMockAddFeatureHandler.RUnlock()
	return calls
}

// AddFeatureLifecycle calls AddFeatureLifecycleFunc.
func (mock *ServiceMonitorInterfaceMock) AddFeatureLifecycle(ctx context.Context, enabled func() bool, name string, lifecycle v11.ServiceMonitorLifecycle) {
	if mock.AddFeatureLifecycleFunc == nil {
		panic("ServiceMonitorInterfaceMock.AddFeatureLifecycleFunc: method is nil but ServiceMonitorInterface.AddFeatureLifecycle was just called")
	}
	callInfo := struct {
		Ctx       context.Context
		Enabled   func() bool
		Name      string
		Lifecycle v11.ServiceMonitorLifecycle
	}{
		Ctx:       ctx,
		Enabled:   enabled,
		Name:      name,
		Lifecycle: lifecycle,
	}
	lockServiceMonitorInterfaceMockAddFeatureLifecycle.Lock()
	mock.calls.AddFeatureLifecycle = append(mock.calls.AddFeatureLifecycle, callInfo)
	lockServiceMonitorInterfaceMockAddFeatureLifecycle.Unlock()
	mock.AddFeatureLifecycleFunc(ctx, enabled, name, lifecycle)
}

// AddFeatureLifecycleCalls gets all the calls that were made to AddFeatureLifecycle.
// Check the length with:
//     len(mockedServiceMonitorInterface.AddFeatureLifecycleCalls())
func (mock *ServiceMonitorInterfaceMock) AddFeatureLifecycleCalls() []struct {
	Ctx       context.Context
	Enabled   func() bool
	Name      string
	Lifecycle v11.ServiceMonitorLifecycle
} {
	var calls []struct {
		Ctx       context.Context
		Enabled   func() bool
		Name      string
		Lifecycle v11.ServiceMonitorLifecycle
	}
	lockServiceMonitorInterfaceMockAddFeatureLifecycle.RLock()
	calls = mock.calls.AddFeatureLifecycle
	lockServiceMonitorInterfaceMockAddFeatureLifecycle.RUnlock()
	return calls
}

// AddHandler calls AddHandlerFunc.
func (mock *ServiceMonitorInterfaceMock) AddHandler(ctx context.Context, name string, syncMoqParam v11.ServiceMonitorHandlerFunc) {
	if mock.AddHandlerFunc == nil {
		panic("ServiceMonitorInterfaceMock.AddHandlerFunc: method is nil but ServiceMonitorInterface.AddHandler was just called")
	}
	callInfo := struct {
		Ctx  context.Context
		Name string
		Sync v11.ServiceMonitorHandlerFunc
	}{
		Ctx:  ctx,
		Name: name,
		Sync: syncMoqParam,
	}
	lockServiceMonitorInterfaceMockAddHandler.Lock()
	mock.calls.AddHandler = append(mock.calls.AddHandler, callInfo)
	lockServiceMonitorInterfaceMockAddHandler.Unlock()
	mock.AddHandlerFunc(ctx, name, syncMoqParam)
}

// AddHandlerCalls gets all the calls that were made to AddHandler.
// Check the length with:
//     len(mockedServiceMonitorInterface.AddHandlerCalls())
func (mock *ServiceMonitorInterfaceMock) AddHandlerCalls() []struct {
	Ctx  context.Context
	Name string
	Sync v11.ServiceMonitorHandlerFunc
} {
	var calls []struct {
		Ctx  context.Context
		Name string
		Sync v11.ServiceMonitorHandlerFunc
	}
	lockServiceMonitorInterfaceMockAddHandler.RLock()
	calls = mock.calls.AddHandler
	lockServiceMonitorInterfaceMockAddHandler.RUnlock()
	return calls
}

// AddLifecycle calls AddLifecycleFunc.
func (mock *ServiceMonitorInterfaceMock) AddLifecycle(ctx context.Context, name string, lifecycle v11.ServiceMonitorLifecycle) {
	if mock.AddLifecycleFunc == nil {
		panic("ServiceMonitorInterfaceMock.AddLifecycleFunc: method is nil but ServiceMonitorInterface.AddLifecycle was just called")
	}
	callInfo := struct {
		Ctx       context.Context
		Name      string
		Lifecycle v11.ServiceMonitorLifecycle
	}{
		Ctx:       ctx,
		Name:      name,
		Lifecycle: lifecycle,
	}
	lockServiceMonitorInterfaceMockAddLifecycle.Lock()
	mock.calls.AddLifecycle = append(mock.calls.AddLifecycle, callInfo)
	lockServiceMonitorInterfaceMockAddLifecycle.Unlock()
	mock.AddLifecycleFunc(ctx, name, lifecycle)
}

// AddLifecycleCalls gets all the calls that were made to AddLifecycle.
// Check the length with:
//     len(mockedServiceMonitorInterface.AddLifecycleCalls())
func (mock *ServiceMonitorInterfaceMock) AddLifecycleCalls() []struct {
	Ctx       context.Context
	Name      string
	Lifecycle v11.ServiceMonitorLifecycle
} {
	var calls []struct {
		Ctx       context.Context
		Name      string
		Lifecycle v11.ServiceMonitorLifecycle
	}
	lockServiceMonitorInterfaceMockAddLifecycle.RLock()
	calls = mock.calls.AddLifecycle
	lockServiceMonitorInterfaceMockAddLifecycle.RUnlock()
	return calls
}

// Controller calls ControllerFunc.
func (mock *ServiceMonitorInterfaceMock) Controller() v11.ServiceMonitorController {
	if mock.ControllerFunc == nil {
		panic("ServiceMonitorInterfaceMock.ControllerFunc: method is nil but ServiceMonitorInterface.Controller was just called")
	}
	callInfo := struct {
	}{}
	lockServiceMonitorInterfaceMockController.Lock()
	mock.calls.Controller = append(mock.calls.Controller, callInfo)
	lockServiceMonitorInterfaceMockController.Unlock()
	return mock.ControllerFunc()
}

// ControllerCalls gets all the calls that were made to Controller.
// Check the length with:
//     len(mockedServiceMonitorInterface.ControllerCalls())
func (mock *ServiceMonitorInterfaceMock) ControllerCalls() []struct {
} {
	var calls []struct {
	}
	lockServiceMonitorInterfaceMockController.RLock()
	calls = mock.calls.Controller
	lockServiceMonitorInterfaceMockController.RUnlock()
	return calls
}

// Create calls CreateFunc.
func (mock *ServiceMonitorInterfaceMock) Create(in1 *v1.ServiceMonitor) (*v1.ServiceMonitor, error) {
	if mock.CreateFunc == nil {
		panic("ServiceMonitorInterfaceMock.CreateFunc: method is nil but ServiceMonitorInterface.Create was just called")
	}
	callInfo := struct {
		In1 *v1.ServiceMonitor
	}{
		In1: in1,
	}
	lockServiceMonitorInterfaceMockCreate.Lock()
	mock.calls.Create = append(mock.calls.Create, callInfo)
	lockServiceMonitorInterfaceMockCreate.Unlock()
	return mock.CreateFunc(in1)
}

// CreateCalls gets all the calls that were made to Create.
// Check the length with:
//     len(mockedServiceMonitorInterface.CreateCalls())
func (mock *ServiceMonitorInterfaceMock) CreateCalls() []struct {
	In1 *v1.ServiceMonitor
} {
	var calls []struct {
		In1 *v1.ServiceMonitor
	}
	lockServiceMonitorInterfaceMockCreate.RLock()
	calls = mock.calls.Create
	lockServiceMonitorInterfaceMockCreate.RUnlock()
	return calls
}

// Delete calls DeleteFunc.
func (mock *ServiceMonitorInterfaceMock) Delete(name string, options *metav1.DeleteOptions) error {
	if mock.DeleteFunc == nil {
		panic("ServiceMonitorInterfaceMock.DeleteFunc: method is nil but ServiceMonitorInterface.Delete was just called")
	}
	callInfo := struct {
		Name    string
		Options *metav1.DeleteOptions
	}{
		Name:    name,
		Options: options,
	}
	lockServiceMonitorInterfaceMockDelete.Lock()
	mock.calls.Delete = append(mock.calls.Delete, callInfo)
	lockServiceMonitorInterfaceMockDelete.Unlock()
	return mock.DeleteFunc(name, options)
}

// DeleteCalls gets all the calls that were made to Delete.
// Check the length with:
//     len(mockedServiceMonitorInterface.DeleteCalls())
func (mock *ServiceMonitorInterfaceMock) DeleteCalls() []struct {
	Name    string
	Options *metav1.DeleteOptions
} {
	var calls []struct {
		Name    string
		Options *metav1.DeleteOptions
	}
	lockServiceMonitorInterfaceMockDelete.RLock()
	calls = mock.calls.Delete
	lockServiceMonitorInterfaceMockDelete.RUnlock()
	return calls
}

// DeleteCollection calls DeleteCollectionFunc.
func (mock *ServiceMonitorInterfaceMock) DeleteCollection(deleteOpts *metav1.DeleteOptions, listOpts metav1.ListOptions) error {
	if mock.DeleteCollectionFunc == nil {
		panic("ServiceMonitorInterfaceMock.DeleteCollectionFunc: method is nil but ServiceMonitorInterface.DeleteCollection was just called")
	}
	callInfo := struct {
		DeleteOpts *metav1.DeleteOptions
		ListOpts   metav1.ListOptions
	}{
		DeleteOpts: deleteOpts,
		ListOpts:   listOpts,
	}
	lockServiceMonitorInterfaceMockDeleteCollection.Lock()
	mock.calls.DeleteCollection = append(mock.calls.DeleteCollection, callInfo)
	lockServiceMonitorInterfaceMockDeleteCollection.Unlock()
	return mock.DeleteCollectionFunc(deleteOpts, listOpts)
}

// DeleteCollectionCalls gets all the calls that were made to DeleteCollection.
// Check the length with:
//     len(mockedServiceMonitorInterface.DeleteCollectionCalls())
func (mock *ServiceMonitorInterfaceMock) DeleteCollectionCalls() []struct {
	DeleteOpts *metav1.DeleteOptions
	ListOpts   metav1.ListOptions
} {
	var calls []struct {
		DeleteOpts *metav1.DeleteOptions
		ListOpts   metav1.ListOptions
	}
	lockServiceMonitorInterfaceMockDeleteCollection.RLock()
	calls = mock.calls.DeleteCollection
	lockServiceMonitorInterfaceMockDeleteCollection.RUnlock()
	return calls
}

// DeleteNamespaced calls DeleteNamespacedFunc.
func (mock *ServiceMonitorInterfaceMock) DeleteNamespaced(namespace string, name string, options *metav1.DeleteOptions) error {
	if mock.DeleteNamespacedFunc == nil {
		panic("ServiceMonitorInterfaceMock.DeleteNamespacedFunc: method is nil but ServiceMonitorInterface.DeleteNamespaced was just called")
	}
	callInfo := struct {
		Namespace string
		Name      string
		Options   *metav1.DeleteOptions
	}{
		Namespace: namespace,
		Name:      name,
		Options:   options,
	}
	lockServiceMonitorInterfaceMockDeleteNamespaced.Lock()
	mock.calls.DeleteNamespaced = append(mock.calls.DeleteNamespaced, callInfo)
	lockServiceMonitorInterfaceMockDeleteNamespaced.Unlock()
	return mock.DeleteNamespacedFunc(namespace, name, options)
}

// DeleteNamespacedCalls gets all the calls that were made to DeleteNamespaced.
// Check the length with:
//     len(mockedServiceMonitorInterface.DeleteNamespacedCalls())
func (mock *ServiceMonitorInterfaceMock) DeleteNamespacedCalls() []struct {
	Namespace string
	Name      string
	Options   *metav1.DeleteOptions
} {
	var calls []struct {
		Namespace string
		Name      string
		Options   *metav1.DeleteOptions
	}
	lockServiceMonitorInterfaceMockDeleteNamespaced.RLock()
	calls = mock.calls.DeleteNamespaced
	lockServiceMonitorInterfaceMockDeleteNamespaced.RUnlock()
	return calls
}

// Get calls GetFunc.
func (mock *ServiceMonitorInterfaceMock) Get(name string, opts metav1.GetOptions) (*v1.ServiceMonitor, error) {
	if mock.GetFunc == nil {
		panic("ServiceMonitorInterfaceMock.GetFunc: method is nil but ServiceMonitorInterface.Get was just called")
	}
	callInfo := struct {
		Name string
		Opts metav1.GetOptions
	}{
		Name: name,
		Opts: opts,
	}
	lockServiceMonitorInterfaceMockGet.Lock()
	mock.calls.Get = append(mock.calls.Get, callInfo)
	lockServiceMonitorInterfaceMockGet.Unlock()
	return mock.GetFunc(name, opts)
}

// GetCalls gets all the calls that were made to Get.
// Check the length with:
//     len(mockedServiceMonitorInterface.GetCalls())
func (mock *ServiceMonitorInterfaceMock) GetCalls() []struct {
	Name string
	Opts metav1.GetOptions
} {
	var calls []struct {
		Name string
		Opts metav1.GetOptions
	}
	lockServiceMonitorInterfaceMockGet.RLock()
	calls = mock.calls.Get
	lockServiceMonitorInterfaceMockGet.RUnlock()
	return calls
}

// GetNamespaced calls GetNamespacedFunc.
func (mock *ServiceMonitorInterfaceMock) GetNamespaced(namespace string, name string, opts metav1.GetOptions) (*v1.ServiceMonitor, error) {
	if mock.GetNamespacedFunc == nil {
		panic("ServiceMonitorInterfaceMock.GetNamespacedFunc: method is nil but ServiceMonitorInterface.GetNamespaced was just called")
	}
	callInfo := struct {
		Namespace string
		Name      string
		Opts      metav1.GetOptions
	}{
		Namespace: namespace,
		Name:      name,
		Opts:      opts,
	}
	lockServiceMonitorInterfaceMockGetNamespaced.Lock()
	mock.calls.GetNamespaced = append(mock.calls.GetNamespaced, callInfo)
	lockServiceMonitorInterfaceMockGetNamespaced.Unlock()
	return mock.GetNamespacedFunc(namespace, name, opts)
}

// GetNamespacedCalls gets all the calls that were made to GetNamespaced.
// Check the length with:
//     len(mockedServiceMonitorInterface.GetNamespacedCalls())
func (mock *ServiceMonitorInterfaceMock) GetNamespacedCalls() []struct {
	Namespace string
	Name      string
	Opts      metav1.GetOptions
} {
	var calls []struct {
		Namespace string
		Name      string
		Opts      metav1.GetOptions
	}
	lockServiceMonitorInterfaceMockGetNamespaced.RLock()
	calls = mock.calls.GetNamespaced
	lockServiceMonitorInterfaceMockGetNamespaced.RUnlock()
	return calls
}

// List calls ListFunc.
func (mock *ServiceMonitorInterfaceMock) List(opts metav1.ListOptions) (*v1.ServiceMonitorList, error) {
	if mock.ListFunc == nil {
		panic("ServiceMonitorInterfaceMock.ListFunc: method is nil but ServiceMonitorInterface.List was just called")
	}
	callInfo := struct {
		Opts metav1.ListOptions
	}{
		Opts: opts,
	}
	lockServiceMonitorInterfaceMockList.Lock()
	mock.calls.List = append(mock.calls.List, callInfo)
	lockServiceMonitorInterfaceMockList.Unlock()
	return mock.ListFunc(opts)
}

// ListCalls gets all the calls that were made to List.
// Check the length with:
//     len(mockedServiceMonitorInterface.ListCalls())
func (mock *ServiceMonitorInterfaceMock) ListCalls() []struct {
	Opts metav1.ListOptions
} {
	var calls []struct {
		Opts metav1.ListOptions
	}
	lockServiceMonitorInterfaceMockList.RLock()
	calls = mock.calls.List
	lockServiceMonitorInterfaceMockList.RUnlock()
	return calls
}

// ListNamespaced calls ListNamespacedFunc.
func (mock *ServiceMonitorInterfaceMock) ListNamespaced(namespace string, opts metav1.ListOptions) (*v1.ServiceMonitorList, error) {
	if mock.ListNamespacedFunc == nil {
		panic("ServiceMonitorInterfaceMock.ListNamespacedFunc: method is nil but ServiceMonitorInterface.ListNamespaced was just called")
	}
	callInfo := struct {
		Namespace string
		Opts      metav1.ListOptions
	}{
		Namespace: namespace,
		Opts:      opts,
	}
	lockServiceMonitorInterfaceMockListNamespaced.Lock()
	mock.calls.ListNamespaced = append(mock.calls.ListNamespaced, callInfo)
	lockServiceMonitorInterfaceMockListNamespaced.Unlock()
	return mock.ListNamespacedFunc(namespace, opts)
}

// ListNamespacedCalls gets all the calls that were made to ListNamespaced.
// Check the length with:
//     len(mockedServiceMonitorInterface.ListNamespacedCalls())
func (mock *ServiceMonitorInterfaceMock) ListNamespacedCalls() []struct {
	Namespace string
	Opts      metav1.ListOptions
} {
	var calls []struct {
		Namespace string
		Opts      metav1.ListOptions
	}
	lockServiceMonitorInterfaceMockListNamespaced.RLock()
	calls = mock.calls.ListNamespaced
	lockServiceMonitorInterfaceMockListNamespaced.RUnlock()
	return calls
}

// ObjectClient calls ObjectClientFunc.
func (mock *ServiceMonitorInterfaceMock) ObjectClient() *objectclient.ObjectClient {
	if mock.ObjectClientFunc == nil {
		panic("ServiceMonitorInterfaceMock.ObjectClientFunc: method is nil but ServiceMonitorInterface.ObjectClient was just called")
	}
	callInfo := struct {
	}{}
	lockServiceMonitorInterfaceMockObjectClient.Lock()
	mock.calls.ObjectClient = append(mock.calls.ObjectClient, callInfo)
	lockServiceMonitorInterfaceMockObjectClient.Unlock()
	return mock.ObjectClientFunc()
}

// ObjectClientCalls gets all the calls that were made to ObjectClient.
// Check the length with:
//     len(mockedServiceMonitorInterface.ObjectClientCalls())
func (mock *ServiceMonitorInterfaceMock) ObjectClientCalls() []struct {
} {
	var calls []struct {
	}
	lockServiceMonitorInterfaceMockObjectClient.RLock()
	calls = mock.calls.ObjectClient
	lockServiceMonitorInterfaceMockObjectClient.RUnlock()
	return calls
}

// Update calls UpdateFunc.
func (mock *ServiceMonitorInterfaceMock) Update(in1 *v1.ServiceMonitor) (*v1.ServiceMonitor, error) {
	if mock.UpdateFunc == nil {
		panic("ServiceMonitorInterfaceMock.UpdateFunc: method is nil but ServiceMonitorInterface.Update was just called")
	}
	callInfo := struct {
		In1 *v1.ServiceMonitor
	}{
		In1: in1,
	}
	lockServiceMonitorInterfaceMockUpdate.Lock()
	mock.calls.Update = append(mock.calls.Update, callInfo)
	lockServiceMonitorInterfaceMockUpdate.Unlock()
	return mock.UpdateFunc(in1)
}

// UpdateCalls gets all the calls that were made to Update.
// Check the length with:
//     len(mockedServiceMonitorInterface.UpdateCalls())
func (mock *ServiceMonitorInterfaceMock) UpdateCalls() []struct {
	In1 *v1.ServiceMonitor
} {
	var calls []struct {
		In1 *v1.ServiceMonitor
	}
	lockServiceMonitorInterfaceMockUpdate.RLock()
	calls = mock.calls.Update
	lockServiceMonitorInterfaceMockUpdate.RUnlock()
	return calls
}

// Watch calls WatchFunc.
func (mock *ServiceMonitorInterfaceMock) Watch(opts metav1.ListOptions) (watch.Interface, error) {
	if mock.WatchFunc == nil {
		panic("ServiceMonitorInterfaceMock.WatchFunc: method is nil but ServiceMonitorInterface.Watch was just called")
	}
	callInfo := struct {
		Opts metav1.ListOptions
	}{
		Opts: opts,
	}
	lockServiceMonitorInterfaceMockWatch.Lock()
	mock.calls.Watch = append(mock.calls.Watch, callInfo)
	lockServiceMonitorInterfaceMockWatch.Unlock()
	return mock.WatchFunc(opts)
}

// WatchCalls gets all the calls that were made to Watch.
// Check the length with:
//     len(mockedServiceMonitorInterface.WatchCalls())
func (mock *ServiceMonitorInterfaceMock) WatchCalls() []struct {
	Opts metav1.ListOptions
} {
	var calls []struct {
		Opts metav1.ListOptions
	}
	lockServiceMonitorInterfaceMockWatch.RLock()
	calls = mock.calls.Watch
	lockServiceMonitorInterfaceMockWatch.RUnlock()
	return calls
}

var (
	lockServiceMonitorsGetterMockServiceMonitors sync.RWMutex
)

// Ensure, that ServiceMonitorsGetterMock does implement v11.ServiceMonitorsGetter.
// If this is not the case, regenerate this file with moq.
var _ v11.ServiceMonitorsGetter = &ServiceMonitorsGetterMock{}

// ServiceMonitorsGetterMock is a mock implementation of v11.ServiceMonitorsGetter.
//
//     func TestSomethingThatUsesServiceMonitorsGetter(t *testing.T) {
//
//         // make and configure a mocked v11.ServiceMonitorsGetter
//         mockedServiceMonitorsGetter := &ServiceMonitorsGetterMock{
//             ServiceMonitorsFunc: func(namespace string) v11.ServiceMonitorInterface {
// 	               panic("mock out the ServiceMonitors method")
//             },
//         }
//
//         // use mockedServiceMonitorsGetter in code that requires v11.ServiceMonitorsGetter
//         // and then make assertions.
//
//     }
type ServiceMonitorsGetterMock struct {
	// ServiceMonitorsFunc mocks the ServiceMonitors method.
	ServiceMonitorsFunc func(namespace string) v11.ServiceMonitorInterface

	// calls tracks calls to the methods.
	calls struct {
		// ServiceMonitors holds details about calls to the ServiceMonitors method.
		ServiceMonitors []struct {
			// Namespace is the namespace argument value.
			Namespace string
		}
	}
}

// ServiceMonitors calls ServiceMonitorsFunc.
func (mock *ServiceMonitorsGetterMock) ServiceMonitors(namespace string) v11.ServiceMonitorInterface {
	if mock.ServiceMonitorsFunc == nil {
		panic("ServiceMonitorsGetterMock.ServiceMonitorsFunc: method is nil but ServiceMonitorsGetter.ServiceMonitors was just called")
	}
	callInfo := struct {
		Namespace string
	}{
		Namespace: namespace,
	}
	lockServiceMonitorsGetterMockServiceMonitors.Lock()
	mock.calls.ServiceMonitors = append(mock.calls.ServiceMonitors, callInfo)
	lockServiceMonitorsGetterMockServiceMonitors.Unlock()
	return mock.ServiceMonitorsFunc(namespace)
}

// ServiceMonitorsCalls gets all the calls that were made to ServiceMonitors.
// Check the length with:
//     len(mockedServiceMonitorsGetter.ServiceMonitorsCalls())
func (mock *ServiceMonitorsGetterMock) ServiceMonitorsCalls() []struct {
	Namespace string
} {
	var calls []struct {
		Namespace string
	}
	lockServiceMonitorsGetterMockServiceMonitors.RLock()
	calls = mock.calls.ServiceMonitors
	lockServiceMonitorsGetterMockServiceMonitors.RUnlock()
	return calls
}
