// Code generated by moq; DO NOT EDIT.
// github.com/matryer/moq

package fakes

import (
	"context"
	"sync"
	"time"

	"github.com/knative/pkg/apis/istio/v1alpha3"
	"github.com/rancher/norman/controller"
	"github.com/rancher/norman/objectclient"
	v1alpha31 "github.com/rancher/rancher/pkg/generated/norman/networking.istio.io/v1alpha3"
	metav1 "k8s.io/apimachinery/pkg/apis/meta/v1"
	"k8s.io/apimachinery/pkg/labels"
	"k8s.io/apimachinery/pkg/watch"
	"k8s.io/client-go/tools/cache"
)

var (
	lockDestinationRuleListerMockGet  sync.RWMutex
	lockDestinationRuleListerMockList sync.RWMutex
)

// Ensure, that DestinationRuleListerMock does implement v1alpha31.DestinationRuleLister.
// If this is not the case, regenerate this file with moq.
var _ v1alpha31.DestinationRuleLister = &DestinationRuleListerMock{}

// DestinationRuleListerMock is a mock implementation of v1alpha31.DestinationRuleLister.
//
//     func TestSomethingThatUsesDestinationRuleLister(t *testing.T) {
//
//         // make and configure a mocked v1alpha31.DestinationRuleLister
//         mockedDestinationRuleLister := &DestinationRuleListerMock{
//             GetFunc: func(namespace string, name string) (*v1alpha3.DestinationRule, error) {
// 	               panic("mock out the Get method")
//             },
//             ListFunc: func(namespace string, selector labels.Selector) ([]*v1alpha3.DestinationRule, error) {
// 	               panic("mock out the List method")
//             },
//         }
//
//         // use mockedDestinationRuleLister in code that requires v1alpha31.DestinationRuleLister
//         // and then make assertions.
//
//     }
type DestinationRuleListerMock struct {
	// GetFunc mocks the Get method.
	GetFunc func(namespace string, name string) (*v1alpha3.DestinationRule, error)

	// ListFunc mocks the List method.
	ListFunc func(namespace string, selector labels.Selector) ([]*v1alpha3.DestinationRule, error)

	// calls tracks calls to the methods.
	calls struct {
		// Get holds details about calls to the Get method.
		Get []struct {
			// Namespace is the namespace argument value.
			Namespace string
			// Name is the name argument value.
			Name string
		}
		// List holds details about calls to the List method.
		List []struct {
			// Namespace is the namespace argument value.
			Namespace string
			// Selector is the selector argument value.
			Selector labels.Selector
		}
	}
}

// Get calls GetFunc.
func (mock *DestinationRuleListerMock) Get(namespace string, name string) (*v1alpha3.DestinationRule, error) {
	if mock.GetFunc == nil {
		panic("DestinationRuleListerMock.GetFunc: method is nil but DestinationRuleLister.Get was just called")
	}
	callInfo := struct {
		Namespace string
		Name      string
	}{
		Namespace: namespace,
		Name:      name,
	}
	lockDestinationRuleListerMockGet.Lock()
	mock.calls.Get = append(mock.calls.Get, callInfo)
	lockDestinationRuleListerMockGet.Unlock()
	return mock.GetFunc(namespace, name)
}

// GetCalls gets all the calls that were made to Get.
// Check the length with:
//     len(mockedDestinationRuleLister.GetCalls())
func (mock *DestinationRuleListerMock) GetCalls() []struct {
	Namespace string
	Name      string
} {
	var calls []struct {
		Namespace string
		Name      string
	}
	lockDestinationRuleListerMockGet.RLock()
	calls = mock.calls.Get
	lockDestinationRuleListerMockGet.RUnlock()
	return calls
}

// List calls ListFunc.
func (mock *DestinationRuleListerMock) List(namespace string, selector labels.Selector) ([]*v1alpha3.DestinationRule, error) {
	if mock.ListFunc == nil {
		panic("DestinationRuleListerMock.ListFunc: method is nil but DestinationRuleLister.List was just called")
	}
	callInfo := struct {
		Namespace string
		Selector  labels.Selector
	}{
		Namespace: namespace,
		Selector:  selector,
	}
	lockDestinationRuleListerMockList.Lock()
	mock.calls.List = append(mock.calls.List, callInfo)
	lockDestinationRuleListerMockList.Unlock()
	return mock.ListFunc(namespace, selector)
}

// ListCalls gets all the calls that were made to List.
// Check the length with:
//     len(mockedDestinationRuleLister.ListCalls())
func (mock *DestinationRuleListerMock) ListCalls() []struct {
	Namespace string
	Selector  labels.Selector
} {
	var calls []struct {
		Namespace string
		Selector  labels.Selector
	}
	lockDestinationRuleListerMockList.RLock()
	calls = mock.calls.List
	lockDestinationRuleListerMockList.RUnlock()
	return calls
}

var (
	lockDestinationRuleControllerMockAddClusterScopedFeatureHandler sync.RWMutex
	lockDestinationRuleControllerMockAddClusterScopedHandler        sync.RWMutex
	lockDestinationRuleControllerMockAddFeatureHandler              sync.RWMutex
	lockDestinationRuleControllerMockAddHandler                     sync.RWMutex
	lockDestinationRuleControllerMockEnqueue                        sync.RWMutex
	lockDestinationRuleControllerMockEnqueueAfter                   sync.RWMutex
	lockDestinationRuleControllerMockGeneric                        sync.RWMutex
	lockDestinationRuleControllerMockInformer                       sync.RWMutex
	lockDestinationRuleControllerMockLister                         sync.RWMutex
)

// Ensure, that DestinationRuleControllerMock does implement v1alpha31.DestinationRuleController.
// If this is not the case, regenerate this file with moq.
var _ v1alpha31.DestinationRuleController = &DestinationRuleControllerMock{}

// DestinationRuleControllerMock is a mock implementation of v1alpha31.DestinationRuleController.
//
//     func TestSomethingThatUsesDestinationRuleController(t *testing.T) {
//
//         // make and configure a mocked v1alpha31.DestinationRuleController
//         mockedDestinationRuleController := &DestinationRuleControllerMock{
//             AddClusterScopedFeatureHandlerFunc: func(ctx context.Context, enabled func() bool, name string, clusterName string, handler v1alpha31.DestinationRuleHandlerFunc)  {
// 	               panic("mock out the AddClusterScopedFeatureHandler method")
//             },
//             AddClusterScopedHandlerFunc: func(ctx context.Context, name string, clusterName string, handler v1alpha31.DestinationRuleHandlerFunc)  {
// 	               panic("mock out the AddClusterScopedHandler method")
//             },
//             AddFeatureHandlerFunc: func(ctx context.Context, enabled func() bool, name string, syncMoqParam v1alpha31.DestinationRuleHandlerFunc)  {
// 	               panic("mock out the AddFeatureHandler method")
//             },
//             AddHandlerFunc: func(ctx context.Context, name string, handler v1alpha31.DestinationRuleHandlerFunc)  {
// 	               panic("mock out the AddHandler method")
//             },
//             EnqueueFunc: func(namespace string, name string)  {
// 	               panic("mock out the Enqueue method")
//             },
//             EnqueueAfterFunc: func(namespace string, name string, after time.Duration)  {
// 	               panic("mock out the EnqueueAfter method")
//             },
//             GenericFunc: func() controller.GenericController {
// 	               panic("mock out the Generic method")
//             },
//             InformerFunc: func() cache.SharedIndexInformer {
// 	               panic("mock out the Informer method")
//             },
//             ListerFunc: func() v1alpha31.DestinationRuleLister {
// 	               panic("mock out the Lister method")
//             },
//         }
//
//         // use mockedDestinationRuleController in code that requires v1alpha31.DestinationRuleController
//         // and then make assertions.
//
//     }
type DestinationRuleControllerMock struct {
	// AddClusterScopedFeatureHandlerFunc mocks the AddClusterScopedFeatureHandler method.
	AddClusterScopedFeatureHandlerFunc func(ctx context.Context, enabled func() bool, name string, clusterName string, handler v1alpha31.DestinationRuleHandlerFunc)

	// AddClusterScopedHandlerFunc mocks the AddClusterScopedHandler method.
	AddClusterScopedHandlerFunc func(ctx context.Context, name string, clusterName string, handler v1alpha31.DestinationRuleHandlerFunc)

	// AddFeatureHandlerFunc mocks the AddFeatureHandler method.
	AddFeatureHandlerFunc func(ctx context.Context, enabled func() bool, name string, syncMoqParam v1alpha31.DestinationRuleHandlerFunc)

	// AddHandlerFunc mocks the AddHandler method.
	AddHandlerFunc func(ctx context.Context, name string, handler v1alpha31.DestinationRuleHandlerFunc)

	// EnqueueFunc mocks the Enqueue method.
	EnqueueFunc func(namespace string, name string)

	// EnqueueAfterFunc mocks the EnqueueAfter method.
	EnqueueAfterFunc func(namespace string, name string, after time.Duration)

	// GenericFunc mocks the Generic method.
	GenericFunc func() controller.GenericController

	// InformerFunc mocks the Informer method.
	InformerFunc func() cache.SharedIndexInformer

	// ListerFunc mocks the Lister method.
	ListerFunc func() v1alpha31.DestinationRuleLister

	// calls tracks calls to the methods.
	calls struct {
		// AddClusterScopedFeatureHandler holds details about calls to the AddClusterScopedFeatureHandler method.
		AddClusterScopedFeatureHandler []struct {
			// Ctx is the ctx argument value.
			Ctx context.Context
			// Enabled is the enabled argument value.
			Enabled func() bool
			// Name is the name argument value.
			Name string
			// ClusterName is the clusterName argument value.
			ClusterName string
			// Handler is the handler argument value.
			Handler v1alpha31.DestinationRuleHandlerFunc
		}
		// AddClusterScopedHandler holds details about calls to the AddClusterScopedHandler method.
		AddClusterScopedHandler []struct {
			// Ctx is the ctx argument value.
			Ctx context.Context
			// Name is the name argument value.
			Name string
			// ClusterName is the clusterName argument value.
			ClusterName string
			// Handler is the handler argument value.
			Handler v1alpha31.DestinationRuleHandlerFunc
		}
		// AddFeatureHandler holds details about calls to the AddFeatureHandler method.
		AddFeatureHandler []struct {
			// Ctx is the ctx argument value.
			Ctx context.Context
			// Enabled is the enabled argument value.
			Enabled func() bool
			// Name is the name argument value.
			Name string
			// Sync is the sync argument value.
			Sync v1alpha31.DestinationRuleHandlerFunc
		}
		// AddHandler holds details about calls to the AddHandler method.
		AddHandler []struct {
			// Ctx is the ctx argument value.
			Ctx context.Context
			// Name is the name argument value.
			Name string
			// Handler is the handler argument value.
			Handler v1alpha31.DestinationRuleHandlerFunc
		}
		// Enqueue holds details about calls to the Enqueue method.
		Enqueue []struct {
			// Namespace is the namespace argument value.
			Namespace string
			// Name is the name argument value.
			Name string
		}
		// EnqueueAfter holds details about calls to the EnqueueAfter method.
		EnqueueAfter []struct {
			// Namespace is the namespace argument value.
			Namespace string
			// Name is the name argument value.
			Name string
			// After is the after argument value.
			After time.Duration
		}
		// Generic holds details about calls to the Generic method.
		Generic []struct {
		}
		// Informer holds details about calls to the Informer method.
		Informer []struct {
		}
		// Lister holds details about calls to the Lister method.
		Lister []struct {
		}
	}
}

// AddClusterScopedFeatureHandler calls AddClusterScopedFeatureHandlerFunc.
func (mock *DestinationRuleControllerMock) AddClusterScopedFeatureHandler(ctx context.Context, enabled func() bool, name string, clusterName string, handler v1alpha31.DestinationRuleHandlerFunc) {
	if mock.AddClusterScopedFeatureHandlerFunc == nil {
		panic("DestinationRuleControllerMock.AddClusterScopedFeatureHandlerFunc: method is nil but DestinationRuleController.AddClusterScopedFeatureHandler was just called")
	}
	callInfo := struct {
		Ctx         context.Context
		Enabled     func() bool
		Name        string
		ClusterName string
		Handler     v1alpha31.DestinationRuleHandlerFunc
	}{
		Ctx:         ctx,
		Enabled:     enabled,
		Name:        name,
		ClusterName: clusterName,
		Handler:     handler,
	}
	lockDestinationRuleControllerMockAddClusterScopedFeatureHandler.Lock()
	mock.calls.AddClusterScopedFeatureHandler = append(mock.calls.AddClusterScopedFeatureHandler, callInfo)
	lockDestinationRuleControllerMockAddClusterScopedFeatureHandler.Unlock()
	mock.AddClusterScopedFeatureHandlerFunc(ctx, enabled, name, clusterName, handler)
}

// AddClusterScopedFeatureHandlerCalls gets all the calls that were made to AddClusterScopedFeatureHandler.
// Check the length with:
//     len(mockedDestinationRuleController.AddClusterScopedFeatureHandlerCalls())
func (mock *DestinationRuleControllerMock) AddClusterScopedFeatureHandlerCalls() []struct {
	Ctx         context.Context
	Enabled     func() bool
	Name        string
	ClusterName string
	Handler     v1alpha31.DestinationRuleHandlerFunc
} {
	var calls []struct {
		Ctx         context.Context
		Enabled     func() bool
		Name        string
		ClusterName string
		Handler     v1alpha31.DestinationRuleHandlerFunc
	}
	lockDestinationRuleControllerMockAddClusterScopedFeatureHandler.RLock()
	calls = mock.calls.AddClusterScopedFeatureHandler
	lockDestinationRuleControllerMockAddClusterScopedFeatureHandler.RUnlock()
	return calls
}

// AddClusterScopedHandler calls AddClusterScopedHandlerFunc.
func (mock *DestinationRuleControllerMock) AddClusterScopedHandler(ctx context.Context, name string, clusterName string, handler v1alpha31.DestinationRuleHandlerFunc) {
	if mock.AddClusterScopedHandlerFunc == nil {
		panic("DestinationRuleControllerMock.AddClusterScopedHandlerFunc: method is nil but DestinationRuleController.AddClusterScopedHandler was just called")
	}
	callInfo := struct {
		Ctx         context.Context
		Name        string
		ClusterName string
		Handler     v1alpha31.DestinationRuleHandlerFunc
	}{
		Ctx:         ctx,
		Name:        name,
		ClusterName: clusterName,
		Handler:     handler,
	}
	lockDestinationRuleControllerMockAddClusterScopedHandler.Lock()
	mock.calls.AddClusterScopedHandler = append(mock.calls.AddClusterScopedHandler, callInfo)
	lockDestinationRuleControllerMockAddClusterScopedHandler.Unlock()
	mock.AddClusterScopedHandlerFunc(ctx, name, clusterName, handler)
}

// AddClusterScopedHandlerCalls gets all the calls that were made to AddClusterScopedHandler.
// Check the length with:
//     len(mockedDestinationRuleController.AddClusterScopedHandlerCalls())
func (mock *DestinationRuleControllerMock) AddClusterScopedHandlerCalls() []struct {
	Ctx         context.Context
	Name        string
	ClusterName string
	Handler     v1alpha31.DestinationRuleHandlerFunc
} {
	var calls []struct {
		Ctx         context.Context
		Name        string
		ClusterName string
		Handler     v1alpha31.DestinationRuleHandlerFunc
	}
	lockDestinationRuleControllerMockAddClusterScopedHandler.RLock()
	calls = mock.calls.AddClusterScopedHandler
	lockDestinationRuleControllerMockAddClusterScopedHandler.RUnlock()
	return calls
}

// AddFeatureHandler calls AddFeatureHandlerFunc.
func (mock *DestinationRuleControllerMock) AddFeatureHandler(ctx context.Context, enabled func() bool, name string, syncMoqParam v1alpha31.DestinationRuleHandlerFunc) {
	if mock.AddFeatureHandlerFunc == nil {
		panic("DestinationRuleControllerMock.AddFeatureHandlerFunc: method is nil but DestinationRuleController.AddFeatureHandler was just called")
	}
	callInfo := struct {
		Ctx     context.Context
		Enabled func() bool
		Name    string
		Sync    v1alpha31.DestinationRuleHandlerFunc
	}{
		Ctx:     ctx,
		Enabled: enabled,
		Name:    name,
		Sync:    syncMoqParam,
	}
	lockDestinationRuleControllerMockAddFeatureHandler.Lock()
	mock.calls.AddFeatureHandler = append(mock.calls.AddFeatureHandler, callInfo)
	lockDestinationRuleControllerMockAddFeatureHandler.Unlock()
	mock.AddFeatureHandlerFunc(ctx, enabled, name, syncMoqParam)
}

// AddFeatureHandlerCalls gets all the calls that were made to AddFeatureHandler.
// Check the length with:
//     len(mockedDestinationRuleController.AddFeatureHandlerCalls())
func (mock *DestinationRuleControllerMock) AddFeatureHandlerCalls() []struct {
	Ctx     context.Context
	Enabled func() bool
	Name    string
	Sync    v1alpha31.DestinationRuleHandlerFunc
} {
	var calls []struct {
		Ctx     context.Context
		Enabled func() bool
		Name    string
		Sync    v1alpha31.DestinationRuleHandlerFunc
	}
	lockDestinationRuleControllerMockAddFeatureHandler.RLock()
	calls = mock.calls.AddFeatureHandler
	lockDestinationRuleControllerMockAddFeatureHandler.RUnlock()
	return calls
}

// AddHandler calls AddHandlerFunc.
func (mock *DestinationRuleControllerMock) AddHandler(ctx context.Context, name string, handler v1alpha31.DestinationRuleHandlerFunc) {
	if mock.AddHandlerFunc == nil {
		panic("DestinationRuleControllerMock.AddHandlerFunc: method is nil but DestinationRuleController.AddHandler was just called")
	}
	callInfo := struct {
		Ctx     context.Context
		Name    string
		Handler v1alpha31.DestinationRuleHandlerFunc
	}{
		Ctx:     ctx,
		Name:    name,
		Handler: handler,
	}
	lockDestinationRuleControllerMockAddHandler.Lock()
	mock.calls.AddHandler = append(mock.calls.AddHandler, callInfo)
	lockDestinationRuleControllerMockAddHandler.Unlock()
	mock.AddHandlerFunc(ctx, name, handler)
}

// AddHandlerCalls gets all the calls that were made to AddHandler.
// Check the length with:
//     len(mockedDestinationRuleController.AddHandlerCalls())
func (mock *DestinationRuleControllerMock) AddHandlerCalls() []struct {
	Ctx     context.Context
	Name    string
	Handler v1alpha31.DestinationRuleHandlerFunc
} {
	var calls []struct {
		Ctx     context.Context
		Name    string
		Handler v1alpha31.DestinationRuleHandlerFunc
	}
	lockDestinationRuleControllerMockAddHandler.RLock()
	calls = mock.calls.AddHandler
	lockDestinationRuleControllerMockAddHandler.RUnlock()
	return calls
}

// Enqueue calls EnqueueFunc.
func (mock *DestinationRuleControllerMock) Enqueue(namespace string, name string) {
	if mock.EnqueueFunc == nil {
		panic("DestinationRuleControllerMock.EnqueueFunc: method is nil but DestinationRuleController.Enqueue was just called")
	}
	callInfo := struct {
		Namespace string
		Name      string
	}{
		Namespace: namespace,
		Name:      name,
	}
	lockDestinationRuleControllerMockEnqueue.Lock()
	mock.calls.Enqueue = append(mock.calls.Enqueue, callInfo)
	lockDestinationRuleControllerMockEnqueue.Unlock()
	mock.EnqueueFunc(namespace, name)
}

// EnqueueCalls gets all the calls that were made to Enqueue.
// Check the length with:
//     len(mockedDestinationRuleController.EnqueueCalls())
func (mock *DestinationRuleControllerMock) EnqueueCalls() []struct {
	Namespace string
	Name      string
} {
	var calls []struct {
		Namespace string
		Name      string
	}
	lockDestinationRuleControllerMockEnqueue.RLock()
	calls = mock.calls.Enqueue
	lockDestinationRuleControllerMockEnqueue.RUnlock()
	return calls
}

// EnqueueAfter calls EnqueueAfterFunc.
func (mock *DestinationRuleControllerMock) EnqueueAfter(namespace string, name string, after time.Duration) {
	if mock.EnqueueAfterFunc == nil {
		panic("DestinationRuleControllerMock.EnqueueAfterFunc: method is nil but DestinationRuleController.EnqueueAfter was just called")
	}
	callInfo := struct {
		Namespace string
		Name      string
		After     time.Duration
	}{
		Namespace: namespace,
		Name:      name,
		After:     after,
	}
	lockDestinationRuleControllerMockEnqueueAfter.Lock()
	mock.calls.EnqueueAfter = append(mock.calls.EnqueueAfter, callInfo)
	lockDestinationRuleControllerMockEnqueueAfter.Unlock()
	mock.EnqueueAfterFunc(namespace, name, after)
}

// EnqueueAfterCalls gets all the calls that were made to EnqueueAfter.
// Check the length with:
//     len(mockedDestinationRuleController.EnqueueAfterCalls())
func (mock *DestinationRuleControllerMock) EnqueueAfterCalls() []struct {
	Namespace string
	Name      string
	After     time.Duration
} {
	var calls []struct {
		Namespace string
		Name      string
		After     time.Duration
	}
	lockDestinationRuleControllerMockEnqueueAfter.RLock()
	calls = mock.calls.EnqueueAfter
	lockDestinationRuleControllerMockEnqueueAfter.RUnlock()
	return calls
}

// Generic calls GenericFunc.
func (mock *DestinationRuleControllerMock) Generic() controller.GenericController {
	if mock.GenericFunc == nil {
		panic("DestinationRuleControllerMock.GenericFunc: method is nil but DestinationRuleController.Generic was just called")
	}
	callInfo := struct {
	}{}
	lockDestinationRuleControllerMockGeneric.Lock()
	mock.calls.Generic = append(mock.calls.Generic, callInfo)
	lockDestinationRuleControllerMockGeneric.Unlock()
	return mock.GenericFunc()
}

// GenericCalls gets all the calls that were made to Generic.
// Check the length with:
//     len(mockedDestinationRuleController.GenericCalls())
func (mock *DestinationRuleControllerMock) GenericCalls() []struct {
} {
	var calls []struct {
	}
	lockDestinationRuleControllerMockGeneric.RLock()
	calls = mock.calls.Generic
	lockDestinationRuleControllerMockGeneric.RUnlock()
	return calls
}

// Informer calls InformerFunc.
func (mock *DestinationRuleControllerMock) Informer() cache.SharedIndexInformer {
	if mock.InformerFunc == nil {
		panic("DestinationRuleControllerMock.InformerFunc: method is nil but DestinationRuleController.Informer was just called")
	}
	callInfo := struct {
	}{}
	lockDestinationRuleControllerMockInformer.Lock()
	mock.calls.Informer = append(mock.calls.Informer, callInfo)
	lockDestinationRuleControllerMockInformer.Unlock()
	return mock.InformerFunc()
}

// InformerCalls gets all the calls that were made to Informer.
// Check the length with:
//     len(mockedDestinationRuleController.InformerCalls())
func (mock *DestinationRuleControllerMock) InformerCalls() []struct {
} {
	var calls []struct {
	}
	lockDestinationRuleControllerMockInformer.RLock()
	calls = mock.calls.Informer
	lockDestinationRuleControllerMockInformer.RUnlock()
	return calls
}

// Lister calls ListerFunc.
func (mock *DestinationRuleControllerMock) Lister() v1alpha31.DestinationRuleLister {
	if mock.ListerFunc == nil {
		panic("DestinationRuleControllerMock.ListerFunc: method is nil but DestinationRuleController.Lister was just called")
	}
	callInfo := struct {
	}{}
	lockDestinationRuleControllerMockLister.Lock()
	mock.calls.Lister = append(mock.calls.Lister, callInfo)
	lockDestinationRuleControllerMockLister.Unlock()
	return mock.ListerFunc()
}

// ListerCalls gets all the calls that were made to Lister.
// Check the length with:
//     len(mockedDestinationRuleController.ListerCalls())
func (mock *DestinationRuleControllerMock) ListerCalls() []struct {
} {
	var calls []struct {
	}
	lockDestinationRuleControllerMockLister.RLock()
	calls = mock.calls.Lister
	lockDestinationRuleControllerMockLister.RUnlock()
	return calls
}

var (
	lockDestinationRuleInterfaceMockAddClusterScopedFeatureHandler   sync.RWMutex
	lockDestinationRuleInterfaceMockAddClusterScopedFeatureLifecycle sync.RWMutex
	lockDestinationRuleInterfaceMockAddClusterScopedHandler          sync.RWMutex
	lockDestinationRuleInterfaceMockAddClusterScopedLifecycle        sync.RWMutex
	lockDestinationRuleInterfaceMockAddFeatureHandler                sync.RWMutex
	lockDestinationRuleInterfaceMockAddFeatureLifecycle              sync.RWMutex
	lockDestinationRuleInterfaceMockAddHandler                       sync.RWMutex
	lockDestinationRuleInterfaceMockAddLifecycle                     sync.RWMutex
	lockDestinationRuleInterfaceMockController                       sync.RWMutex
	lockDestinationRuleInterfaceMockCreate                           sync.RWMutex
	lockDestinationRuleInterfaceMockDelete                           sync.RWMutex
	lockDestinationRuleInterfaceMockDeleteCollection                 sync.RWMutex
	lockDestinationRuleInterfaceMockDeleteNamespaced                 sync.RWMutex
	lockDestinationRuleInterfaceMockGet                              sync.RWMutex
	lockDestinationRuleInterfaceMockGetNamespaced                    sync.RWMutex
	lockDestinationRuleInterfaceMockList                             sync.RWMutex
	lockDestinationRuleInterfaceMockListNamespaced                   sync.RWMutex
	lockDestinationRuleInterfaceMockObjectClient                     sync.RWMutex
	lockDestinationRuleInterfaceMockUpdate                           sync.RWMutex
	lockDestinationRuleInterfaceMockWatch                            sync.RWMutex
)

// Ensure, that DestinationRuleInterfaceMock does implement v1alpha31.DestinationRuleInterface.
// If this is not the case, regenerate this file with moq.
var _ v1alpha31.DestinationRuleInterface = &DestinationRuleInterfaceMock{}

// DestinationRuleInterfaceMock is a mock implementation of v1alpha31.DestinationRuleInterface.
//
//     func TestSomethingThatUsesDestinationRuleInterface(t *testing.T) {
//
//         // make and configure a mocked v1alpha31.DestinationRuleInterface
//         mockedDestinationRuleInterface := &DestinationRuleInterfaceMock{
//             AddClusterScopedFeatureHandlerFunc: func(ctx context.Context, enabled func() bool, name string, clusterName string, syncMoqParam v1alpha31.DestinationRuleHandlerFunc)  {
// 	               panic("mock out the AddClusterScopedFeatureHandler method")
//             },
//             AddClusterScopedFeatureLifecycleFunc: func(ctx context.Context, enabled func() bool, name string, clusterName string, lifecycle v1alpha31.DestinationRuleLifecycle)  {
// 	               panic("mock out the AddClusterScopedFeatureLifecycle method")
//             },
//             AddClusterScopedHandlerFunc: func(ctx context.Context, name string, clusterName string, syncMoqParam v1alpha31.DestinationRuleHandlerFunc)  {
// 	               panic("mock out the AddClusterScopedHandler method")
//             },
//             AddClusterScopedLifecycleFunc: func(ctx context.Context, name string, clusterName string, lifecycle v1alpha31.DestinationRuleLifecycle)  {
// 	               panic("mock out the AddClusterScopedLifecycle method")
//             },
//             AddFeatureHandlerFunc: func(ctx context.Context, enabled func() bool, name string, syncMoqParam v1alpha31.DestinationRuleHandlerFunc)  {
// 	               panic("mock out the AddFeatureHandler method")
//             },
//             AddFeatureLifecycleFunc: func(ctx context.Context, enabled func() bool, name string, lifecycle v1alpha31.DestinationRuleLifecycle)  {
// 	               panic("mock out the AddFeatureLifecycle method")
//             },
//             AddHandlerFunc: func(ctx context.Context, name string, syncMoqParam v1alpha31.DestinationRuleHandlerFunc)  {
// 	               panic("mock out the AddHandler method")
//             },
//             AddLifecycleFunc: func(ctx context.Context, name string, lifecycle v1alpha31.DestinationRuleLifecycle)  {
// 	               panic("mock out the AddLifecycle method")
//             },
//             ControllerFunc: func() v1alpha31.DestinationRuleController {
// 	               panic("mock out the Controller method")
//             },
//             CreateFunc: func(in1 *v1alpha3.DestinationRule) (*v1alpha3.DestinationRule, error) {
// 	               panic("mock out the Create method")
//             },
//             DeleteFunc: func(name string, options *metav1.DeleteOptions) error {
// 	               panic("mock out the Delete method")
//             },
//             DeleteCollectionFunc: func(deleteOpts *metav1.DeleteOptions, listOpts metav1.ListOptions) error {
// 	               panic("mock out the DeleteCollection method")
//             },
//             DeleteNamespacedFunc: func(namespace string, name string, options *metav1.DeleteOptions) error {
// 	               panic("mock out the DeleteNamespaced method")
//             },
//             GetFunc: func(name string, opts metav1.GetOptions) (*v1alpha3.DestinationRule, error) {
// 	               panic("mock out the Get method")
//             },
//             GetNamespacedFunc: func(namespace string, name string, opts metav1.GetOptions) (*v1alpha3.DestinationRule, error) {
// 	               panic("mock out the GetNamespaced method")
//             },
//             ListFunc: func(opts metav1.ListOptions) (*v1alpha3.DestinationRuleList, error) {
// 	               panic("mock out the List method")
//             },
//             ListNamespacedFunc: func(namespace string, opts metav1.ListOptions) (*v1alpha3.DestinationRuleList, error) {
// 	               panic("mock out the ListNamespaced method")
//             },
//             ObjectClientFunc: func() *objectclient.ObjectClient {
// 	               panic("mock out the ObjectClient method")
//             },
//             UpdateFunc: func(in1 *v1alpha3.DestinationRule) (*v1alpha3.DestinationRule, error) {
// 	               panic("mock out the Update method")
//             },
//             WatchFunc: func(opts metav1.ListOptions) (watch.Interface, error) {
// 	               panic("mock out the Watch method")
//             },
//         }
//
//         // use mockedDestinationRuleInterface in code that requires v1alpha31.DestinationRuleInterface
//         // and then make assertions.
//
//     }
type DestinationRuleInterfaceMock struct {
	// AddClusterScopedFeatureHandlerFunc mocks the AddClusterScopedFeatureHandler method.
	AddClusterScopedFeatureHandlerFunc func(ctx context.Context, enabled func() bool, name string, clusterName string, syncMoqParam v1alpha31.DestinationRuleHandlerFunc)

	// AddClusterScopedFeatureLifecycleFunc mocks the AddClusterScopedFeatureLifecycle method.
	AddClusterScopedFeatureLifecycleFunc func(ctx context.Context, enabled func() bool, name string, clusterName string, lifecycle v1alpha31.DestinationRuleLifecycle)

	// AddClusterScopedHandlerFunc mocks the AddClusterScopedHandler method.
	AddClusterScopedHandlerFunc func(ctx context.Context, name string, clusterName string, syncMoqParam v1alpha31.DestinationRuleHandlerFunc)

	// AddClusterScopedLifecycleFunc mocks the AddClusterScopedLifecycle method.
	AddClusterScopedLifecycleFunc func(ctx context.Context, name string, clusterName string, lifecycle v1alpha31.DestinationRuleLifecycle)

	// AddFeatureHandlerFunc mocks the AddFeatureHandler method.
	AddFeatureHandlerFunc func(ctx context.Context, enabled func() bool, name string, syncMoqParam v1alpha31.DestinationRuleHandlerFunc)

	// AddFeatureLifecycleFunc mocks the AddFeatureLifecycle method.
	AddFeatureLifecycleFunc func(ctx context.Context, enabled func() bool, name string, lifecycle v1alpha31.DestinationRuleLifecycle)

	// AddHandlerFunc mocks the AddHandler method.
	AddHandlerFunc func(ctx context.Context, name string, syncMoqParam v1alpha31.DestinationRuleHandlerFunc)

	// AddLifecycleFunc mocks the AddLifecycle method.
	AddLifecycleFunc func(ctx context.Context, name string, lifecycle v1alpha31.DestinationRuleLifecycle)

	// ControllerFunc mocks the Controller method.
	ControllerFunc func() v1alpha31.DestinationRuleController

	// CreateFunc mocks the Create method.
	CreateFunc func(in1 *v1alpha3.DestinationRule) (*v1alpha3.DestinationRule, error)

	// DeleteFunc mocks the Delete method.
	DeleteFunc func(name string, options *metav1.DeleteOptions) error

	// DeleteCollectionFunc mocks the DeleteCollection method.
	DeleteCollectionFunc func(deleteOpts *metav1.DeleteOptions, listOpts metav1.ListOptions) error

	// DeleteNamespacedFunc mocks the DeleteNamespaced method.
	DeleteNamespacedFunc func(namespace string, name string, options *metav1.DeleteOptions) error

	// GetFunc mocks the Get method.
	GetFunc func(name string, opts metav1.GetOptions) (*v1alpha3.DestinationRule, error)

	// GetNamespacedFunc mocks the GetNamespaced method.
	GetNamespacedFunc func(namespace string, name string, opts metav1.GetOptions) (*v1alpha3.DestinationRule, error)

	// ListFunc mocks the List method.
	ListFunc func(opts metav1.ListOptions) (*v1alpha3.DestinationRuleList, error)

	// ListNamespacedFunc mocks the ListNamespaced method.
	ListNamespacedFunc func(namespace string, opts metav1.ListOptions) (*v1alpha3.DestinationRuleList, error)

	// ObjectClientFunc mocks the ObjectClient method.
	ObjectClientFunc func() *objectclient.ObjectClient

	// UpdateFunc mocks the Update method.
	UpdateFunc func(in1 *v1alpha3.DestinationRule) (*v1alpha3.DestinationRule, error)

	// WatchFunc mocks the Watch method.
	WatchFunc func(opts metav1.ListOptions) (watch.Interface, error)

	// calls tracks calls to the methods.
	calls struct {
		// AddClusterScopedFeatureHandler holds details about calls to the AddClusterScopedFeatureHandler method.
		AddClusterScopedFeatureHandler []struct {
			// Ctx is the ctx argument value.
			Ctx context.Context
			// Enabled is the enabled argument value.
			Enabled func() bool
			// Name is the name argument value.
			Name string
			// ClusterName is the clusterName argument value.
			ClusterName string
			// Sync is the sync argument value.
			Sync v1alpha31.DestinationRuleHandlerFunc
		}
		// AddClusterScopedFeatureLifecycle holds details about calls to the AddClusterScopedFeatureLifecycle method.
		AddClusterScopedFeatureLifecycle []struct {
			// Ctx is the ctx argument value.
			Ctx context.Context
			// Enabled is the enabled argument value.
			Enabled func() bool
			// Name is the name argument value.
			Name string
			// ClusterName is the clusterName argument value.
			ClusterName string
			// Lifecycle is the lifecycle argument value.
			Lifecycle v1alpha31.DestinationRuleLifecycle
		}
		// AddClusterScopedHandler holds details about calls to the AddClusterScopedHandler method.
		AddClusterScopedHandler []struct {
			// Ctx is the ctx argument value.
			Ctx context.Context
			// Name is the name argument value.
			Name string
			// ClusterName is the clusterName argument value.
			ClusterName string
			// Sync is the sync argument value.
			Sync v1alpha31.DestinationRuleHandlerFunc
		}
		// AddClusterScopedLifecycle holds details about calls to the AddClusterScopedLifecycle method.
		AddClusterScopedLifecycle []struct {
			// Ctx is the ctx argument value.
			Ctx context.Context
			// Name is the name argument value.
			Name string
			// ClusterName is the clusterName argument value.
			ClusterName string
			// Lifecycle is the lifecycle argument value.
			Lifecycle v1alpha31.DestinationRuleLifecycle
		}
		// AddFeatureHandler holds details about calls to the AddFeatureHandler method.
		AddFeatureHandler []struct {
			// Ctx is the ctx argument value.
			Ctx context.Context
			// Enabled is the enabled argument value.
			Enabled func() bool
			// Name is the name argument value.
			Name string
			// Sync is the sync argument value.
			Sync v1alpha31.DestinationRuleHandlerFunc
		}
		// AddFeatureLifecycle holds details about calls to the AddFeatureLifecycle method.
		AddFeatureLifecycle []struct {
			// Ctx is the ctx argument value.
			Ctx context.Context
			// Enabled is the enabled argument value.
			Enabled func() bool
			// Name is the name argument value.
			Name string
			// Lifecycle is the lifecycle argument value.
			Lifecycle v1alpha31.DestinationRuleLifecycle
		}
		// AddHandler holds details about calls to the AddHandler method.
		AddHandler []struct {
			// Ctx is the ctx argument value.
			Ctx context.Context
			// Name is the name argument value.
			Name string
			// Sync is the sync argument value.
			Sync v1alpha31.DestinationRuleHandlerFunc
		}
		// AddLifecycle holds details about calls to the AddLifecycle method.
		AddLifecycle []struct {
			// Ctx is the ctx argument value.
			Ctx context.Context
			// Name is the name argument value.
			Name string
			// Lifecycle is the lifecycle argument value.
			Lifecycle v1alpha31.DestinationRuleLifecycle
		}
		// Controller holds details about calls to the Controller method.
		Controller []struct {
		}
		// Create holds details about calls to the Create method.
		Create []struct {
			// In1 is the in1 argument value.
			In1 *v1alpha3.DestinationRule
		}
		// Delete holds details about calls to the Delete method.
		Delete []struct {
			// Name is the name argument value.
			Name string
			// Options is the options argument value.
			Options *metav1.DeleteOptions
		}
		// DeleteCollection holds details about calls to the DeleteCollection method.
		DeleteCollection []struct {
			// DeleteOpts is the deleteOpts argument value.
			DeleteOpts *metav1.DeleteOptions
			// ListOpts is the listOpts argument value.
			ListOpts metav1.ListOptions
		}
		// DeleteNamespaced holds details about calls to the DeleteNamespaced method.
		DeleteNamespaced []struct {
			// Namespace is the namespace argument value.
			Namespace string
			// Name is the name argument value.
			Name string
			// Options is the options argument value.
			Options *metav1.DeleteOptions
		}
		// Get holds details about calls to the Get method.
		Get []struct {
			// Name is the name argument value.
			Name string
			// Opts is the opts argument value.
			Opts metav1.GetOptions
		}
		// GetNamespaced holds details about calls to the GetNamespaced method.
		GetNamespaced []struct {
			// Namespace is the namespace argument value.
			Namespace string
			// Name is the name argument value.
			Name string
			// Opts is the opts argument value.
			Opts metav1.GetOptions
		}
		// List holds details about calls to the List method.
		List []struct {
			// Opts is the opts argument value.
			Opts metav1.ListOptions
		}
		// ListNamespaced holds details about calls to the ListNamespaced method.
		ListNamespaced []struct {
			// Namespace is the namespace argument value.
			Namespace string
			// Opts is the opts argument value.
			Opts metav1.ListOptions
		}
		// ObjectClient holds details about calls to the ObjectClient method.
		ObjectClient []struct {
		}
		// Update holds details about calls to the Update method.
		Update []struct {
			// In1 is the in1 argument value.
			In1 *v1alpha3.DestinationRule
		}
		// Watch holds details about calls to the Watch method.
		Watch []struct {
			// Opts is the opts argument value.
			Opts metav1.ListOptions
		}
	}
}

// AddClusterScopedFeatureHandler calls AddClusterScopedFeatureHandlerFunc.
func (mock *DestinationRuleInterfaceMock) AddClusterScopedFeatureHandler(ctx context.Context, enabled func() bool, name string, clusterName string, syncMoqParam v1alpha31.DestinationRuleHandlerFunc) {
	if mock.AddClusterScopedFeatureHandlerFunc == nil {
		panic("DestinationRuleInterfaceMock.AddClusterScopedFeatureHandlerFunc: method is nil but DestinationRuleInterface.AddClusterScopedFeatureHandler was just called")
	}
	callInfo := struct {
		Ctx         context.Context
		Enabled     func() bool
		Name        string
		ClusterName string
		Sync        v1alpha31.DestinationRuleHandlerFunc
	}{
		Ctx:         ctx,
		Enabled:     enabled,
		Name:        name,
		ClusterName: clusterName,
		Sync:        syncMoqParam,
	}
	lockDestinationRuleInterfaceMockAddClusterScopedFeatureHandler.Lock()
	mock.calls.AddClusterScopedFeatureHandler = append(mock.calls.AddClusterScopedFeatureHandler, callInfo)
	lockDestinationRuleInterfaceMockAddClusterScopedFeatureHandler.Unlock()
	mock.AddClusterScopedFeatureHandlerFunc(ctx, enabled, name, clusterName, syncMoqParam)
}

// AddClusterScopedFeatureHandlerCalls gets all the calls that were made to AddClusterScopedFeatureHandler.
// Check the length with:
//     len(mockedDestinationRuleInterface.AddClusterScopedFeatureHandlerCalls())
func (mock *DestinationRuleInterfaceMock) AddClusterScopedFeatureHandlerCalls() []struct {
	Ctx         context.Context
	Enabled     func() bool
	Name        string
	ClusterName string
	Sync        v1alpha31.DestinationRuleHandlerFunc
} {
	var calls []struct {
		Ctx         context.Context
		Enabled     func() bool
		Name        string
		ClusterName string
		Sync        v1alpha31.DestinationRuleHandlerFunc
	}
	lockDestinationRuleInterfaceMockAddClusterScopedFeatureHandler.RLock()
	calls = mock.calls.AddClusterScopedFeatureHandler
	lockDestinationRuleInterfaceMockAddClusterScopedFeatureHandler.RUnlock()
	return calls
}

// AddClusterScopedFeatureLifecycle calls AddClusterScopedFeatureLifecycleFunc.
func (mock *DestinationRuleInterfaceMock) AddClusterScopedFeatureLifecycle(ctx context.Context, enabled func() bool, name string, clusterName string, lifecycle v1alpha31.DestinationRuleLifecycle) {
	if mock.AddClusterScopedFeatureLifecycleFunc == nil {
		panic("DestinationRuleInterfaceMock.AddClusterScopedFeatureLifecycleFunc: method is nil but DestinationRuleInterface.AddClusterScopedFeatureLifecycle was just called")
	}
	callInfo := struct {
		Ctx         context.Context
		Enabled     func() bool
		Name        string
		ClusterName string
		Lifecycle   v1alpha31.DestinationRuleLifecycle
	}{
		Ctx:         ctx,
		Enabled:     enabled,
		Name:        name,
		ClusterName: clusterName,
		Lifecycle:   lifecycle,
	}
	lockDestinationRuleInterfaceMockAddClusterScopedFeatureLifecycle.Lock()
	mock.calls.AddClusterScopedFeatureLifecycle = append(mock.calls.AddClusterScopedFeatureLifecycle, callInfo)
	lockDestinationRuleInterfaceMockAddClusterScopedFeatureLifecycle.Unlock()
	mock.AddClusterScopedFeatureLifecycleFunc(ctx, enabled, name, clusterName, lifecycle)
}

// AddClusterScopedFeatureLifecycleCalls gets all the calls that were made to AddClusterScopedFeatureLifecycle.
// Check the length with:
//     len(mockedDestinationRuleInterface.AddClusterScopedFeatureLifecycleCalls())
func (mock *DestinationRuleInterfaceMock) AddClusterScopedFeatureLifecycleCalls() []struct {
	Ctx         context.Context
	Enabled     func() bool
	Name        string
	ClusterName string
	Lifecycle   v1alpha31.DestinationRuleLifecycle
} {
	var calls []struct {
		Ctx         context.Context
		Enabled     func() bool
		Name        string
		ClusterName string
		Lifecycle   v1alpha31.DestinationRuleLifecycle
	}
	lockDestinationRuleInterfaceMockAddClusterScopedFeatureLifecycle.RLock()
	calls = mock.calls.AddClusterScopedFeatureLifecycle
	lockDestinationRuleInterfaceMockAddClusterScopedFeatureLifecycle.RUnlock()
	return calls
}

// AddClusterScopedHandler calls AddClusterScopedHandlerFunc.
func (mock *DestinationRuleInterfaceMock) AddClusterScopedHandler(ctx context.Context, name string, clusterName string, syncMoqParam v1alpha31.DestinationRuleHandlerFunc) {
	if mock.AddClusterScopedHandlerFunc == nil {
		panic("DestinationRuleInterfaceMock.AddClusterScopedHandlerFunc: method is nil but DestinationRuleInterface.AddClusterScopedHandler was just called")
	}
	callInfo := struct {
		Ctx         context.Context
		Name        string
		ClusterName string
		Sync        v1alpha31.DestinationRuleHandlerFunc
	}{
		Ctx:         ctx,
		Name:        name,
		ClusterName: clusterName,
		Sync:        syncMoqParam,
	}
	lockDestinationRuleInterfaceMockAddClusterScopedHandler.Lock()
	mock.calls.AddClusterScopedHandler = append(mock.calls.AddClusterScopedHandler, callInfo)
	lockDestinationRuleInterfaceMockAddClusterScopedHandler.Unlock()
	mock.AddClusterScopedHandlerFunc(ctx, name, clusterName, syncMoqParam)
}

// AddClusterScopedHandlerCalls gets all the calls that were made to AddClusterScopedHandler.
// Check the length with:
//     len(mockedDestinationRuleInterface.AddClusterScopedHandlerCalls())
func (mock *DestinationRuleInterfaceMock) AddClusterScopedHandlerCalls() []struct {
	Ctx         context.Context
	Name        string
	ClusterName string
	Sync        v1alpha31.DestinationRuleHandlerFunc
} {
	var calls []struct {
		Ctx         context.Context
		Name        string
		ClusterName string
		Sync        v1alpha31.DestinationRuleHandlerFunc
	}
	lockDestinationRuleInterfaceMockAddClusterScopedHandler.RLock()
	calls = mock.calls.AddClusterScopedHandler
	lockDestinationRuleInterfaceMockAddClusterScopedHandler.RUnlock()
	return calls
}

// AddClusterScopedLifecycle calls AddClusterScopedLifecycleFunc.
func (mock *DestinationRuleInterfaceMock) AddClusterScopedLifecycle(ctx context.Context, name string, clusterName string, lifecycle v1alpha31.DestinationRuleLifecycle) {
	if mock.AddClusterScopedLifecycleFunc == nil {
		panic("DestinationRuleInterfaceMock.AddClusterScopedLifecycleFunc: method is nil but DestinationRuleInterface.AddClusterScopedLifecycle was just called")
	}
	callInfo := struct {
		Ctx         context.Context
		Name        string
		ClusterName string
		Lifecycle   v1alpha31.DestinationRuleLifecycle
	}{
		Ctx:         ctx,
		Name:        name,
		ClusterName: clusterName,
		Lifecycle:   lifecycle,
	}
	lockDestinationRuleInterfaceMockAddClusterScopedLifecycle.Lock()
	mock.calls.AddClusterScopedLifecycle = append(mock.calls.AddClusterScopedLifecycle, callInfo)
	lockDestinationRuleInterfaceMockAddClusterScopedLifecycle.Unlock()
	mock.AddClusterScopedLifecycleFunc(ctx, name, clusterName, lifecycle)
}

// AddClusterScopedLifecycleCalls gets all the calls that were made to AddClusterScopedLifecycle.
// Check the length with:
//     len(mockedDestinationRuleInterface.AddClusterScopedLifecycleCalls())
func (mock *DestinationRuleInterfaceMock) AddClusterScopedLifecycleCalls() []struct {
	Ctx         context.Context
	Name        string
	ClusterName string
	Lifecycle   v1alpha31.DestinationRuleLifecycle
} {
	var calls []struct {
		Ctx         context.Context
		Name        string
		ClusterName string
		Lifecycle   v1alpha31.DestinationRuleLifecycle
	}
	lockDestinationRuleInterfaceMockAddClusterScopedLifecycle.RLock()
	calls = mock.calls.AddClusterScopedLifecycle
	lockDestinationRuleInterfaceMockAddClusterScopedLifecycle.RUnlock()
	return calls
}

// AddFeatureHandler calls AddFeatureHandlerFunc.
func (mock *DestinationRuleInterfaceMock) AddFeatureHandler(ctx context.Context, enabled func() bool, name string, syncMoqParam v1alpha31.DestinationRuleHandlerFunc) {
	if mock.AddFeatureHandlerFunc == nil {
		panic("DestinationRuleInterfaceMock.AddFeatureHandlerFunc: method is nil but DestinationRuleInterface.AddFeatureHandler was just called")
	}
	callInfo := struct {
		Ctx     context.Context
		Enabled func() bool
		Name    string
		Sync    v1alpha31.DestinationRuleHandlerFunc
	}{
		Ctx:     ctx,
		Enabled: enabled,
		Name:    name,
		Sync:    syncMoqParam,
	}
	lockDestinationRuleInterfaceMockAddFeatureHandler.Lock()
	mock.calls.AddFeatureHandler = append(mock.calls.AddFeatureHandler, callInfo)
	lockDestinationRuleInterfaceMockAddFeatureHandler.Unlock()
	mock.AddFeatureHandlerFunc(ctx, enabled, name, syncMoqParam)
}

// AddFeatureHandlerCalls gets all the calls that were made to AddFeatureHandler.
// Check the length with:
//     len(mockedDestinationRuleInterface.AddFeatureHandlerCalls())
func (mock *DestinationRuleInterfaceMock) AddFeatureHandlerCalls() []struct {
	Ctx     context.Context
	Enabled func() bool
	Name    string
	Sync    v1alpha31.DestinationRuleHandlerFunc
} {
	var calls []struct {
		Ctx     context.Context
		Enabled func() bool
		Name    string
		Sync    v1alpha31.DestinationRuleHandlerFunc
	}
	lockDestinationRuleInterfaceMockAddFeatureHandler.RLock()
	calls = mock.calls.AddFeatureHandler
	lockDestinationRuleInterfaceMockAddFeatureHandler.RUnlock()
	return calls
}

// AddFeatureLifecycle calls AddFeatureLifecycleFunc.
func (mock *DestinationRuleInterfaceMock) AddFeatureLifecycle(ctx context.Context, enabled func() bool, name string, lifecycle v1alpha31.DestinationRuleLifecycle) {
	if mock.AddFeatureLifecycleFunc == nil {
		panic("DestinationRuleInterfaceMock.AddFeatureLifecycleFunc: method is nil but DestinationRuleInterface.AddFeatureLifecycle was just called")
	}
	callInfo := struct {
		Ctx       context.Context
		Enabled   func() bool
		Name      string
		Lifecycle v1alpha31.DestinationRuleLifecycle
	}{
		Ctx:       ctx,
		Enabled:   enabled,
		Name:      name,
		Lifecycle: lifecycle,
	}
	lockDestinationRuleInterfaceMockAddFeatureLifecycle.Lock()
	mock.calls.AddFeatureLifecycle = append(mock.calls.AddFeatureLifecycle, callInfo)
	lockDestinationRuleInterfaceMockAddFeatureLifecycle.Unlock()
	mock.AddFeatureLifecycleFunc(ctx, enabled, name, lifecycle)
}

// AddFeatureLifecycleCalls gets all the calls that were made to AddFeatureLifecycle.
// Check the length with:
//     len(mockedDestinationRuleInterface.AddFeatureLifecycleCalls())
func (mock *DestinationRuleInterfaceMock) AddFeatureLifecycleCalls() []struct {
	Ctx       context.Context
	Enabled   func() bool
	Name      string
	Lifecycle v1alpha31.DestinationRuleLifecycle
} {
	var calls []struct {
		Ctx       context.Context
		Enabled   func() bool
		Name      string
		Lifecycle v1alpha31.DestinationRuleLifecycle
	}
	lockDestinationRuleInterfaceMockAddFeatureLifecycle.RLock()
	calls = mock.calls.AddFeatureLifecycle
	lockDestinationRuleInterfaceMockAddFeatureLifecycle.RUnlock()
	return calls
}

// AddHandler calls AddHandlerFunc.
func (mock *DestinationRuleInterfaceMock) AddHandler(ctx context.Context, name string, syncMoqParam v1alpha31.DestinationRuleHandlerFunc) {
	if mock.AddHandlerFunc == nil {
		panic("DestinationRuleInterfaceMock.AddHandlerFunc: method is nil but DestinationRuleInterface.AddHandler was just called")
	}
	callInfo := struct {
		Ctx  context.Context
		Name string
		Sync v1alpha31.DestinationRuleHandlerFunc
	}{
		Ctx:  ctx,
		Name: name,
		Sync: syncMoqParam,
	}
	lockDestinationRuleInterfaceMockAddHandler.Lock()
	mock.calls.AddHandler = append(mock.calls.AddHandler, callInfo)
	lockDestinationRuleInterfaceMockAddHandler.Unlock()
	mock.AddHandlerFunc(ctx, name, syncMoqParam)
}

// AddHandlerCalls gets all the calls that were made to AddHandler.
// Check the length with:
//     len(mockedDestinationRuleInterface.AddHandlerCalls())
func (mock *DestinationRuleInterfaceMock) AddHandlerCalls() []struct {
	Ctx  context.Context
	Name string
	Sync v1alpha31.DestinationRuleHandlerFunc
} {
	var calls []struct {
		Ctx  context.Context
		Name string
		Sync v1alpha31.DestinationRuleHandlerFunc
	}
	lockDestinationRuleInterfaceMockAddHandler.RLock()
	calls = mock.calls.AddHandler
	lockDestinationRuleInterfaceMockAddHandler.RUnlock()
	return calls
}

// AddLifecycle calls AddLifecycleFunc.
func (mock *DestinationRuleInterfaceMock) AddLifecycle(ctx context.Context, name string, lifecycle v1alpha31.DestinationRuleLifecycle) {
	if mock.AddLifecycleFunc == nil {
		panic("DestinationRuleInterfaceMock.AddLifecycleFunc: method is nil but DestinationRuleInterface.AddLifecycle was just called")
	}
	callInfo := struct {
		Ctx       context.Context
		Name      string
		Lifecycle v1alpha31.DestinationRuleLifecycle
	}{
		Ctx:       ctx,
		Name:      name,
		Lifecycle: lifecycle,
	}
	lockDestinationRuleInterfaceMockAddLifecycle.Lock()
	mock.calls.AddLifecycle = append(mock.calls.AddLifecycle, callInfo)
	lockDestinationRuleInterfaceMockAddLifecycle.Unlock()
	mock.AddLifecycleFunc(ctx, name, lifecycle)
}

// AddLifecycleCalls gets all the calls that were made to AddLifecycle.
// Check the length with:
//     len(mockedDestinationRuleInterface.AddLifecycleCalls())
func (mock *DestinationRuleInterfaceMock) AddLifecycleCalls() []struct {
	Ctx       context.Context
	Name      string
	Lifecycle v1alpha31.DestinationRuleLifecycle
} {
	var calls []struct {
		Ctx       context.Context
		Name      string
		Lifecycle v1alpha31.DestinationRuleLifecycle
	}
	lockDestinationRuleInterfaceMockAddLifecycle.RLock()
	calls = mock.calls.AddLifecycle
	lockDestinationRuleInterfaceMockAddLifecycle.RUnlock()
	return calls
}

// Controller calls ControllerFunc.
func (mock *DestinationRuleInterfaceMock) Controller() v1alpha31.DestinationRuleController {
	if mock.ControllerFunc == nil {
		panic("DestinationRuleInterfaceMock.ControllerFunc: method is nil but DestinationRuleInterface.Controller was just called")
	}
	callInfo := struct {
	}{}
	lockDestinationRuleInterfaceMockController.Lock()
	mock.calls.Controller = append(mock.calls.Controller, callInfo)
	lockDestinationRuleInterfaceMockController.Unlock()
	return mock.ControllerFunc()
}

// ControllerCalls gets all the calls that were made to Controller.
// Check the length with:
//     len(mockedDestinationRuleInterface.ControllerCalls())
func (mock *DestinationRuleInterfaceMock) ControllerCalls() []struct {
} {
	var calls []struct {
	}
	lockDestinationRuleInterfaceMockController.RLock()
	calls = mock.calls.Controller
	lockDestinationRuleInterfaceMockController.RUnlock()
	return calls
}

// Create calls CreateFunc.
func (mock *DestinationRuleInterfaceMock) Create(in1 *v1alpha3.DestinationRule) (*v1alpha3.DestinationRule, error) {
	if mock.CreateFunc == nil {
		panic("DestinationRuleInterfaceMock.CreateFunc: method is nil but DestinationRuleInterface.Create was just called")
	}
	callInfo := struct {
		In1 *v1alpha3.DestinationRule
	}{
		In1: in1,
	}
	lockDestinationRuleInterfaceMockCreate.Lock()
	mock.calls.Create = append(mock.calls.Create, callInfo)
	lockDestinationRuleInterfaceMockCreate.Unlock()
	return mock.CreateFunc(in1)
}

// CreateCalls gets all the calls that were made to Create.
// Check the length with:
//     len(mockedDestinationRuleInterface.CreateCalls())
func (mock *DestinationRuleInterfaceMock) CreateCalls() []struct {
	In1 *v1alpha3.DestinationRule
} {
	var calls []struct {
		In1 *v1alpha3.DestinationRule
	}
	lockDestinationRuleInterfaceMockCreate.RLock()
	calls = mock.calls.Create
	lockDestinationRuleInterfaceMockCreate.RUnlock()
	return calls
}

// Delete calls DeleteFunc.
func (mock *DestinationRuleInterfaceMock) Delete(name string, options *metav1.DeleteOptions) error {
	if mock.DeleteFunc == nil {
		panic("DestinationRuleInterfaceMock.DeleteFunc: method is nil but DestinationRuleInterface.Delete was just called")
	}
	callInfo := struct {
		Name    string
		Options *metav1.DeleteOptions
	}{
		Name:    name,
		Options: options,
	}
	lockDestinationRuleInterfaceMockDelete.Lock()
	mock.calls.Delete = append(mock.calls.Delete, callInfo)
	lockDestinationRuleInterfaceMockDelete.Unlock()
	return mock.DeleteFunc(name, options)
}

// DeleteCalls gets all the calls that were made to Delete.
// Check the length with:
//     len(mockedDestinationRuleInterface.DeleteCalls())
func (mock *DestinationRuleInterfaceMock) DeleteCalls() []struct {
	Name    string
	Options *metav1.DeleteOptions
} {
	var calls []struct {
		Name    string
		Options *metav1.DeleteOptions
	}
	lockDestinationRuleInterfaceMockDelete.RLock()
	calls = mock.calls.Delete
	lockDestinationRuleInterfaceMockDelete.RUnlock()
	return calls
}

// DeleteCollection calls DeleteCollectionFunc.
func (mock *DestinationRuleInterfaceMock) DeleteCollection(deleteOpts *metav1.DeleteOptions, listOpts metav1.ListOptions) error {
	if mock.DeleteCollectionFunc == nil {
		panic("DestinationRuleInterfaceMock.DeleteCollectionFunc: method is nil but DestinationRuleInterface.DeleteCollection was just called")
	}
	callInfo := struct {
		DeleteOpts *metav1.DeleteOptions
		ListOpts   metav1.ListOptions
	}{
		DeleteOpts: deleteOpts,
		ListOpts:   listOpts,
	}
	lockDestinationRuleInterfaceMockDeleteCollection.Lock()
	mock.calls.DeleteCollection = append(mock.calls.DeleteCollection, callInfo)
	lockDestinationRuleInterfaceMockDeleteCollection.Unlock()
	return mock.DeleteCollectionFunc(deleteOpts, listOpts)
}

// DeleteCollectionCalls gets all the calls that were made to DeleteCollection.
// Check the length with:
//     len(mockedDestinationRuleInterface.DeleteCollectionCalls())
func (mock *DestinationRuleInterfaceMock) DeleteCollectionCalls() []struct {
	DeleteOpts *metav1.DeleteOptions
	ListOpts   metav1.ListOptions
} {
	var calls []struct {
		DeleteOpts *metav1.DeleteOptions
		ListOpts   metav1.ListOptions
	}
	lockDestinationRuleInterfaceMockDeleteCollection.RLock()
	calls = mock.calls.DeleteCollection
	lockDestinationRuleInterfaceMockDeleteCollection.RUnlock()
	return calls
}

// DeleteNamespaced calls DeleteNamespacedFunc.
func (mock *DestinationRuleInterfaceMock) DeleteNamespaced(namespace string, name string, options *metav1.DeleteOptions) error {
	if mock.DeleteNamespacedFunc == nil {
		panic("DestinationRuleInterfaceMock.DeleteNamespacedFunc: method is nil but DestinationRuleInterface.DeleteNamespaced was just called")
	}
	callInfo := struct {
		Namespace string
		Name      string
		Options   *metav1.DeleteOptions
	}{
		Namespace: namespace,
		Name:      name,
		Options:   options,
	}
	lockDestinationRuleInterfaceMockDeleteNamespaced.Lock()
	mock.calls.DeleteNamespaced = append(mock.calls.DeleteNamespaced, callInfo)
	lockDestinationRuleInterfaceMockDeleteNamespaced.Unlock()
	return mock.DeleteNamespacedFunc(namespace, name, options)
}

// DeleteNamespacedCalls gets all the calls that were made to DeleteNamespaced.
// Check the length with:
//     len(mockedDestinationRuleInterface.DeleteNamespacedCalls())
func (mock *DestinationRuleInterfaceMock) DeleteNamespacedCalls() []struct {
	Namespace string
	Name      string
	Options   *metav1.DeleteOptions
} {
	var calls []struct {
		Namespace string
		Name      string
		Options   *metav1.DeleteOptions
	}
	lockDestinationRuleInterfaceMockDeleteNamespaced.RLock()
	calls = mock.calls.DeleteNamespaced
	lockDestinationRuleInterfaceMockDeleteNamespaced.RUnlock()
	return calls
}

// Get calls GetFunc.
func (mock *DestinationRuleInterfaceMock) Get(name string, opts metav1.GetOptions) (*v1alpha3.DestinationRule, error) {
	if mock.GetFunc == nil {
		panic("DestinationRuleInterfaceMock.GetFunc: method is nil but DestinationRuleInterface.Get was just called")
	}
	callInfo := struct {
		Name string
		Opts metav1.GetOptions
	}{
		Name: name,
		Opts: opts,
	}
	lockDestinationRuleInterfaceMockGet.Lock()
	mock.calls.Get = append(mock.calls.Get, callInfo)
	lockDestinationRuleInterfaceMockGet.Unlock()
	return mock.GetFunc(name, opts)
}

// GetCalls gets all the calls that were made to Get.
// Check the length with:
//     len(mockedDestinationRuleInterface.GetCalls())
func (mock *DestinationRuleInterfaceMock) GetCalls() []struct {
	Name string
	Opts metav1.GetOptions
} {
	var calls []struct {
		Name string
		Opts metav1.GetOptions
	}
	lockDestinationRuleInterfaceMockGet.RLock()
	calls = mock.calls.Get
	lockDestinationRuleInterfaceMockGet.RUnlock()
	return calls
}

// GetNamespaced calls GetNamespacedFunc.
func (mock *DestinationRuleInterfaceMock) GetNamespaced(namespace string, name string, opts metav1.GetOptions) (*v1alpha3.DestinationRule, error) {
	if mock.GetNamespacedFunc == nil {
		panic("DestinationRuleInterfaceMock.GetNamespacedFunc: method is nil but DestinationRuleInterface.GetNamespaced was just called")
	}
	callInfo := struct {
		Namespace string
		Name      string
		Opts      metav1.GetOptions
	}{
		Namespace: namespace,
		Name:      name,
		Opts:      opts,
	}
	lockDestinationRuleInterfaceMockGetNamespaced.Lock()
	mock.calls.GetNamespaced = append(mock.calls.GetNamespaced, callInfo)
	lockDestinationRuleInterfaceMockGetNamespaced.Unlock()
	return mock.GetNamespacedFunc(namespace, name, opts)
}

// GetNamespacedCalls gets all the calls that were made to GetNamespaced.
// Check the length with:
//     len(mockedDestinationRuleInterface.GetNamespacedCalls())
func (mock *DestinationRuleInterfaceMock) GetNamespacedCalls() []struct {
	Namespace string
	Name      string
	Opts      metav1.GetOptions
} {
	var calls []struct {
		Namespace string
		Name      string
		Opts      metav1.GetOptions
	}
	lockDestinationRuleInterfaceMockGetNamespaced.RLock()
	calls = mock.calls.GetNamespaced
	lockDestinationRuleInterfaceMockGetNamespaced.RUnlock()
	return calls
}

// List calls ListFunc.
func (mock *DestinationRuleInterfaceMock) List(opts metav1.ListOptions) (*v1alpha3.DestinationRuleList, error) {
	if mock.ListFunc == nil {
		panic("DestinationRuleInterfaceMock.ListFunc: method is nil but DestinationRuleInterface.List was just called")
	}
	callInfo := struct {
		Opts metav1.ListOptions
	}{
		Opts: opts,
	}
	lockDestinationRuleInterfaceMockList.Lock()
	mock.calls.List = append(mock.calls.List, callInfo)
	lockDestinationRuleInterfaceMockList.Unlock()
	return mock.ListFunc(opts)
}

// ListCalls gets all the calls that were made to List.
// Check the length with:
//     len(mockedDestinationRuleInterface.ListCalls())
func (mock *DestinationRuleInterfaceMock) ListCalls() []struct {
	Opts metav1.ListOptions
} {
	var calls []struct {
		Opts metav1.ListOptions
	}
	lockDestinationRuleInterfaceMockList.RLock()
	calls = mock.calls.List
	lockDestinationRuleInterfaceMockList.RUnlock()
	return calls
}

// ListNamespaced calls ListNamespacedFunc.
func (mock *DestinationRuleInterfaceMock) ListNamespaced(namespace string, opts metav1.ListOptions) (*v1alpha3.DestinationRuleList, error) {
	if mock.ListNamespacedFunc == nil {
		panic("DestinationRuleInterfaceMock.ListNamespacedFunc: method is nil but DestinationRuleInterface.ListNamespaced was just called")
	}
	callInfo := struct {
		Namespace string
		Opts      metav1.ListOptions
	}{
		Namespace: namespace,
		Opts:      opts,
	}
	lockDestinationRuleInterfaceMockListNamespaced.Lock()
	mock.calls.ListNamespaced = append(mock.calls.ListNamespaced, callInfo)
	lockDestinationRuleInterfaceMockListNamespaced.Unlock()
	return mock.ListNamespacedFunc(namespace, opts)
}

// ListNamespacedCalls gets all the calls that were made to ListNamespaced.
// Check the length with:
//     len(mockedDestinationRuleInterface.ListNamespacedCalls())
func (mock *DestinationRuleInterfaceMock) ListNamespacedCalls() []struct {
	Namespace string
	Opts      metav1.ListOptions
} {
	var calls []struct {
		Namespace string
		Opts      metav1.ListOptions
	}
	lockDestinationRuleInterfaceMockListNamespaced.RLock()
	calls = mock.calls.ListNamespaced
	lockDestinationRuleInterfaceMockListNamespaced.RUnlock()
	return calls
}

// ObjectClient calls ObjectClientFunc.
func (mock *DestinationRuleInterfaceMock) ObjectClient() *objectclient.ObjectClient {
	if mock.ObjectClientFunc == nil {
		panic("DestinationRuleInterfaceMock.ObjectClientFunc: method is nil but DestinationRuleInterface.ObjectClient was just called")
	}
	callInfo := struct {
	}{}
	lockDestinationRuleInterfaceMockObjectClient.Lock()
	mock.calls.ObjectClient = append(mock.calls.ObjectClient, callInfo)
	lockDestinationRuleInterfaceMockObjectClient.Unlock()
	return mock.ObjectClientFunc()
}

// ObjectClientCalls gets all the calls that were made to ObjectClient.
// Check the length with:
//     len(mockedDestinationRuleInterface.ObjectClientCalls())
func (mock *DestinationRuleInterfaceMock) ObjectClientCalls() []struct {
} {
	var calls []struct {
	}
	lockDestinationRuleInterfaceMockObjectClient.RLock()
	calls = mock.calls.ObjectClient
	lockDestinationRuleInterfaceMockObjectClient.RUnlock()
	return calls
}

// Update calls UpdateFunc.
func (mock *DestinationRuleInterfaceMock) Update(in1 *v1alpha3.DestinationRule) (*v1alpha3.DestinationRule, error) {
	if mock.UpdateFunc == nil {
		panic("DestinationRuleInterfaceMock.UpdateFunc: method is nil but DestinationRuleInterface.Update was just called")
	}
	callInfo := struct {
		In1 *v1alpha3.DestinationRule
	}{
		In1: in1,
	}
	lockDestinationRuleInterfaceMockUpdate.Lock()
	mock.calls.Update = append(mock.calls.Update, callInfo)
	lockDestinationRuleInterfaceMockUpdate.Unlock()
	return mock.UpdateFunc(in1)
}

// UpdateCalls gets all the calls that were made to Update.
// Check the length with:
//     len(mockedDestinationRuleInterface.UpdateCalls())
func (mock *DestinationRuleInterfaceMock) UpdateCalls() []struct {
	In1 *v1alpha3.DestinationRule
} {
	var calls []struct {
		In1 *v1alpha3.DestinationRule
	}
	lockDestinationRuleInterfaceMockUpdate.RLock()
	calls = mock.calls.Update
	lockDestinationRuleInterfaceMockUpdate.RUnlock()
	return calls
}

// Watch calls WatchFunc.
func (mock *DestinationRuleInterfaceMock) Watch(opts metav1.ListOptions) (watch.Interface, error) {
	if mock.WatchFunc == nil {
		panic("DestinationRuleInterfaceMock.WatchFunc: method is nil but DestinationRuleInterface.Watch was just called")
	}
	callInfo := struct {
		Opts metav1.ListOptions
	}{
		Opts: opts,
	}
	lockDestinationRuleInterfaceMockWatch.Lock()
	mock.calls.Watch = append(mock.calls.Watch, callInfo)
	lockDestinationRuleInterfaceMockWatch.Unlock()
	return mock.WatchFunc(opts)
}

// WatchCalls gets all the calls that were made to Watch.
// Check the length with:
//     len(mockedDestinationRuleInterface.WatchCalls())
func (mock *DestinationRuleInterfaceMock) WatchCalls() []struct {
	Opts metav1.ListOptions
} {
	var calls []struct {
		Opts metav1.ListOptions
	}
	lockDestinationRuleInterfaceMockWatch.RLock()
	calls = mock.calls.Watch
	lockDestinationRuleInterfaceMockWatch.RUnlock()
	return calls
}

var (
	lockDestinationRulesGetterMockDestinationRules sync.RWMutex
)

// Ensure, that DestinationRulesGetterMock does implement v1alpha31.DestinationRulesGetter.
// If this is not the case, regenerate this file with moq.
var _ v1alpha31.DestinationRulesGetter = &DestinationRulesGetterMock{}

// DestinationRulesGetterMock is a mock implementation of v1alpha31.DestinationRulesGetter.
//
//     func TestSomethingThatUsesDestinationRulesGetter(t *testing.T) {
//
//         // make and configure a mocked v1alpha31.DestinationRulesGetter
//         mockedDestinationRulesGetter := &DestinationRulesGetterMock{
//             DestinationRulesFunc: func(namespace string) v1alpha31.DestinationRuleInterface {
// 	               panic("mock out the DestinationRules method")
//             },
//         }
//
//         // use mockedDestinationRulesGetter in code that requires v1alpha31.DestinationRulesGetter
//         // and then make assertions.
//
//     }
type DestinationRulesGetterMock struct {
	// DestinationRulesFunc mocks the DestinationRules method.
	DestinationRulesFunc func(namespace string) v1alpha31.DestinationRuleInterface

	// calls tracks calls to the methods.
	calls struct {
		// DestinationRules holds details about calls to the DestinationRules method.
		DestinationRules []struct {
			// Namespace is the namespace argument value.
			Namespace string
		}
	}
}

// DestinationRules calls DestinationRulesFunc.
func (mock *DestinationRulesGetterMock) DestinationRules(namespace string) v1alpha31.DestinationRuleInterface {
	if mock.DestinationRulesFunc == nil {
		panic("DestinationRulesGetterMock.DestinationRulesFunc: method is nil but DestinationRulesGetter.DestinationRules was just called")
	}
	callInfo := struct {
		Namespace string
	}{
		Namespace: namespace,
	}
	lockDestinationRulesGetterMockDestinationRules.Lock()
	mock.calls.DestinationRules = append(mock.calls.DestinationRules, callInfo)
	lockDestinationRulesGetterMockDestinationRules.Unlock()
	return mock.DestinationRulesFunc(namespace)
}

// DestinationRulesCalls gets all the calls that were made to DestinationRules.
// Check the length with:
//     len(mockedDestinationRulesGetter.DestinationRulesCalls())
func (mock *DestinationRulesGetterMock) DestinationRulesCalls() []struct {
	Namespace string
} {
	var calls []struct {
		Namespace string
	}
	lockDestinationRulesGetterMockDestinationRules.RLock()
	calls = mock.calls.DestinationRules
	lockDestinationRulesGetterMockDestinationRules.RUnlock()
	return calls
}
