// Code generated by moq; DO NOT EDIT.
// github.com/matryer/moq

package fakes

import (
	"context"
	"sync"
	"time"

	"github.com/knative/pkg/apis/istio/v1alpha3"
	"github.com/rancher/norman/controller"
	"github.com/rancher/norman/objectclient"
	v1alpha31 "github.com/rancher/rancher/pkg/generated/norman/networking.istio.io/v1alpha3"
	metav1 "k8s.io/apimachinery/pkg/apis/meta/v1"
	"k8s.io/apimachinery/pkg/labels"
	"k8s.io/apimachinery/pkg/watch"
	"k8s.io/client-go/tools/cache"
)

var (
	lockVirtualServiceListerMockGet  sync.RWMutex
	lockVirtualServiceListerMockList sync.RWMutex
)

// Ensure, that VirtualServiceListerMock does implement v1alpha31.VirtualServiceLister.
// If this is not the case, regenerate this file with moq.
var _ v1alpha31.VirtualServiceLister = &VirtualServiceListerMock{}

// VirtualServiceListerMock is a mock implementation of v1alpha31.VirtualServiceLister.
//
//     func TestSomethingThatUsesVirtualServiceLister(t *testing.T) {
//
//         // make and configure a mocked v1alpha31.VirtualServiceLister
//         mockedVirtualServiceLister := &VirtualServiceListerMock{
//             GetFunc: func(namespace string, name string) (*v1alpha3.VirtualService, error) {
// 	               panic("mock out the Get method")
//             },
//             ListFunc: func(namespace string, selector labels.Selector) ([]*v1alpha3.VirtualService, error) {
// 	               panic("mock out the List method")
//             },
//         }
//
//         // use mockedVirtualServiceLister in code that requires v1alpha31.VirtualServiceLister
//         // and then make assertions.
//
//     }
type VirtualServiceListerMock struct {
	// GetFunc mocks the Get method.
	GetFunc func(namespace string, name string) (*v1alpha3.VirtualService, error)

	// ListFunc mocks the List method.
	ListFunc func(namespace string, selector labels.Selector) ([]*v1alpha3.VirtualService, error)

	// calls tracks calls to the methods.
	calls struct {
		// Get holds details about calls to the Get method.
		Get []struct {
			// Namespace is the namespace argument value.
			Namespace string
			// Name is the name argument value.
			Name string
		}
		// List holds details about calls to the List method.
		List []struct {
			// Namespace is the namespace argument value.
			Namespace string
			// Selector is the selector argument value.
			Selector labels.Selector
		}
	}
}

// Get calls GetFunc.
func (mock *VirtualServiceListerMock) Get(namespace string, name string) (*v1alpha3.VirtualService, error) {
	if mock.GetFunc == nil {
		panic("VirtualServiceListerMock.GetFunc: method is nil but VirtualServiceLister.Get was just called")
	}
	callInfo := struct {
		Namespace string
		Name      string
	}{
		Namespace: namespace,
		Name:      name,
	}
	lockVirtualServiceListerMockGet.Lock()
	mock.calls.Get = append(mock.calls.Get, callInfo)
	lockVirtualServiceListerMockGet.Unlock()
	return mock.GetFunc(namespace, name)
}

// GetCalls gets all the calls that were made to Get.
// Check the length with:
//     len(mockedVirtualServiceLister.GetCalls())
func (mock *VirtualServiceListerMock) GetCalls() []struct {
	Namespace string
	Name      string
} {
	var calls []struct {
		Namespace string
		Name      string
	}
	lockVirtualServiceListerMockGet.RLock()
	calls = mock.calls.Get
	lockVirtualServiceListerMockGet.RUnlock()
	return calls
}

// List calls ListFunc.
func (mock *VirtualServiceListerMock) List(namespace string, selector labels.Selector) ([]*v1alpha3.VirtualService, error) {
	if mock.ListFunc == nil {
		panic("VirtualServiceListerMock.ListFunc: method is nil but VirtualServiceLister.List was just called")
	}
	callInfo := struct {
		Namespace string
		Selector  labels.Selector
	}{
		Namespace: namespace,
		Selector:  selector,
	}
	lockVirtualServiceListerMockList.Lock()
	mock.calls.List = append(mock.calls.List, callInfo)
	lockVirtualServiceListerMockList.Unlock()
	return mock.ListFunc(namespace, selector)
}

// ListCalls gets all the calls that were made to List.
// Check the length with:
//     len(mockedVirtualServiceLister.ListCalls())
func (mock *VirtualServiceListerMock) ListCalls() []struct {
	Namespace string
	Selector  labels.Selector
} {
	var calls []struct {
		Namespace string
		Selector  labels.Selector
	}
	lockVirtualServiceListerMockList.RLock()
	calls = mock.calls.List
	lockVirtualServiceListerMockList.RUnlock()
	return calls
}

var (
	lockVirtualServiceControllerMockAddClusterScopedFeatureHandler sync.RWMutex
	lockVirtualServiceControllerMockAddClusterScopedHandler        sync.RWMutex
	lockVirtualServiceControllerMockAddFeatureHandler              sync.RWMutex
	lockVirtualServiceControllerMockAddHandler                     sync.RWMutex
	lockVirtualServiceControllerMockEnqueue                        sync.RWMutex
	lockVirtualServiceControllerMockEnqueueAfter                   sync.RWMutex
	lockVirtualServiceControllerMockGeneric                        sync.RWMutex
	lockVirtualServiceControllerMockInformer                       sync.RWMutex
	lockVirtualServiceControllerMockLister                         sync.RWMutex
)

// Ensure, that VirtualServiceControllerMock does implement v1alpha31.VirtualServiceController.
// If this is not the case, regenerate this file with moq.
var _ v1alpha31.VirtualServiceController = &VirtualServiceControllerMock{}

// VirtualServiceControllerMock is a mock implementation of v1alpha31.VirtualServiceController.
//
//     func TestSomethingThatUsesVirtualServiceController(t *testing.T) {
//
//         // make and configure a mocked v1alpha31.VirtualServiceController
//         mockedVirtualServiceController := &VirtualServiceControllerMock{
//             AddClusterScopedFeatureHandlerFunc: func(ctx context.Context, enabled func() bool, name string, clusterName string, handler v1alpha31.VirtualServiceHandlerFunc)  {
// 	               panic("mock out the AddClusterScopedFeatureHandler method")
//             },
//             AddClusterScopedHandlerFunc: func(ctx context.Context, name string, clusterName string, handler v1alpha31.VirtualServiceHandlerFunc)  {
// 	               panic("mock out the AddClusterScopedHandler method")
//             },
//             AddFeatureHandlerFunc: func(ctx context.Context, enabled func() bool, name string, syncMoqParam v1alpha31.VirtualServiceHandlerFunc)  {
// 	               panic("mock out the AddFeatureHandler method")
//             },
//             AddHandlerFunc: func(ctx context.Context, name string, handler v1alpha31.VirtualServiceHandlerFunc)  {
// 	               panic("mock out the AddHandler method")
//             },
//             EnqueueFunc: func(namespace string, name string)  {
// 	               panic("mock out the Enqueue method")
//             },
//             EnqueueAfterFunc: func(namespace string, name string, after time.Duration)  {
// 	               panic("mock out the EnqueueAfter method")
//             },
//             GenericFunc: func() controller.GenericController {
// 	               panic("mock out the Generic method")
//             },
//             InformerFunc: func() cache.SharedIndexInformer {
// 	               panic("mock out the Informer method")
//             },
//             ListerFunc: func() v1alpha31.VirtualServiceLister {
// 	               panic("mock out the Lister method")
//             },
//         }
//
//         // use mockedVirtualServiceController in code that requires v1alpha31.VirtualServiceController
//         // and then make assertions.
//
//     }
type VirtualServiceControllerMock struct {
	// AddClusterScopedFeatureHandlerFunc mocks the AddClusterScopedFeatureHandler method.
	AddClusterScopedFeatureHandlerFunc func(ctx context.Context, enabled func() bool, name string, clusterName string, handler v1alpha31.VirtualServiceHandlerFunc)

	// AddClusterScopedHandlerFunc mocks the AddClusterScopedHandler method.
	AddClusterScopedHandlerFunc func(ctx context.Context, name string, clusterName string, handler v1alpha31.VirtualServiceHandlerFunc)

	// AddFeatureHandlerFunc mocks the AddFeatureHandler method.
	AddFeatureHandlerFunc func(ctx context.Context, enabled func() bool, name string, syncMoqParam v1alpha31.VirtualServiceHandlerFunc)

	// AddHandlerFunc mocks the AddHandler method.
	AddHandlerFunc func(ctx context.Context, name string, handler v1alpha31.VirtualServiceHandlerFunc)

	// EnqueueFunc mocks the Enqueue method.
	EnqueueFunc func(namespace string, name string)

	// EnqueueAfterFunc mocks the EnqueueAfter method.
	EnqueueAfterFunc func(namespace string, name string, after time.Duration)

	// GenericFunc mocks the Generic method.
	GenericFunc func() controller.GenericController

	// InformerFunc mocks the Informer method.
	InformerFunc func() cache.SharedIndexInformer

	// ListerFunc mocks the Lister method.
	ListerFunc func() v1alpha31.VirtualServiceLister

	// calls tracks calls to the methods.
	calls struct {
		// AddClusterScopedFeatureHandler holds details about calls to the AddClusterScopedFeatureHandler method.
		AddClusterScopedFeatureHandler []struct {
			// Ctx is the ctx argument value.
			Ctx context.Context
			// Enabled is the enabled argument value.
			Enabled func() bool
			// Name is the name argument value.
			Name string
			// ClusterName is the clusterName argument value.
			ClusterName string
			// Handler is the handler argument value.
			Handler v1alpha31.VirtualServiceHandlerFunc
		}
		// AddClusterScopedHandler holds details about calls to the AddClusterScopedHandler method.
		AddClusterScopedHandler []struct {
			// Ctx is the ctx argument value.
			Ctx context.Context
			// Name is the name argument value.
			Name string
			// ClusterName is the clusterName argument value.
			ClusterName string
			// Handler is the handler argument value.
			Handler v1alpha31.VirtualServiceHandlerFunc
		}
		// AddFeatureHandler holds details about calls to the AddFeatureHandler method.
		AddFeatureHandler []struct {
			// Ctx is the ctx argument value.
			Ctx context.Context
			// Enabled is the enabled argument value.
			Enabled func() bool
			// Name is the name argument value.
			Name string
			// Sync is the sync argument value.
			Sync v1alpha31.VirtualServiceHandlerFunc
		}
		// AddHandler holds details about calls to the AddHandler method.
		AddHandler []struct {
			// Ctx is the ctx argument value.
			Ctx context.Context
			// Name is the name argument value.
			Name string
			// Handler is the handler argument value.
			Handler v1alpha31.VirtualServiceHandlerFunc
		}
		// Enqueue holds details about calls to the Enqueue method.
		Enqueue []struct {
			// Namespace is the namespace argument value.
			Namespace string
			// Name is the name argument value.
			Name string
		}
		// EnqueueAfter holds details about calls to the EnqueueAfter method.
		EnqueueAfter []struct {
			// Namespace is the namespace argument value.
			Namespace string
			// Name is the name argument value.
			Name string
			// After is the after argument value.
			After time.Duration
		}
		// Generic holds details about calls to the Generic method.
		Generic []struct {
		}
		// Informer holds details about calls to the Informer method.
		Informer []struct {
		}
		// Lister holds details about calls to the Lister method.
		Lister []struct {
		}
	}
}

// AddClusterScopedFeatureHandler calls AddClusterScopedFeatureHandlerFunc.
func (mock *VirtualServiceControllerMock) AddClusterScopedFeatureHandler(ctx context.Context, enabled func() bool, name string, clusterName string, handler v1alpha31.VirtualServiceHandlerFunc) {
	if mock.AddClusterScopedFeatureHandlerFunc == nil {
		panic("VirtualServiceControllerMock.AddClusterScopedFeatureHandlerFunc: method is nil but VirtualServiceController.AddClusterScopedFeatureHandler was just called")
	}
	callInfo := struct {
		Ctx         context.Context
		Enabled     func() bool
		Name        string
		ClusterName string
		Handler     v1alpha31.VirtualServiceHandlerFunc
	}{
		Ctx:         ctx,
		Enabled:     enabled,
		Name:        name,
		ClusterName: clusterName,
		Handler:     handler,
	}
	lockVirtualServiceControllerMockAddClusterScopedFeatureHandler.Lock()
	mock.calls.AddClusterScopedFeatureHandler = append(mock.calls.AddClusterScopedFeatureHandler, callInfo)
	lockVirtualServiceControllerMockAddClusterScopedFeatureHandler.Unlock()
	mock.AddClusterScopedFeatureHandlerFunc(ctx, enabled, name, clusterName, handler)
}

// AddClusterScopedFeatureHandlerCalls gets all the calls that were made to AddClusterScopedFeatureHandler.
// Check the length with:
//     len(mockedVirtualServiceController.AddClusterScopedFeatureHandlerCalls())
func (mock *VirtualServiceControllerMock) AddClusterScopedFeatureHandlerCalls() []struct {
	Ctx         context.Context
	Enabled     func() bool
	Name        string
	ClusterName string
	Handler     v1alpha31.VirtualServiceHandlerFunc
} {
	var calls []struct {
		Ctx         context.Context
		Enabled     func() bool
		Name        string
		ClusterName string
		Handler     v1alpha31.VirtualServiceHandlerFunc
	}
	lockVirtualServiceControllerMockAddClusterScopedFeatureHandler.RLock()
	calls = mock.calls.AddClusterScopedFeatureHandler
	lockVirtualServiceControllerMockAddClusterScopedFeatureHandler.RUnlock()
	return calls
}

// AddClusterScopedHandler calls AddClusterScopedHandlerFunc.
func (mock *VirtualServiceControllerMock) AddClusterScopedHandler(ctx context.Context, name string, clusterName string, handler v1alpha31.VirtualServiceHandlerFunc) {
	if mock.AddClusterScopedHandlerFunc == nil {
		panic("VirtualServiceControllerMock.AddClusterScopedHandlerFunc: method is nil but VirtualServiceController.AddClusterScopedHandler was just called")
	}
	callInfo := struct {
		Ctx         context.Context
		Name        string
		ClusterName string
		Handler     v1alpha31.VirtualServiceHandlerFunc
	}{
		Ctx:         ctx,
		Name:        name,
		ClusterName: clusterName,
		Handler:     handler,
	}
	lockVirtualServiceControllerMockAddClusterScopedHandler.Lock()
	mock.calls.AddClusterScopedHandler = append(mock.calls.AddClusterScopedHandler, callInfo)
	lockVirtualServiceControllerMockAddClusterScopedHandler.Unlock()
	mock.AddClusterScopedHandlerFunc(ctx, name, clusterName, handler)
}

// AddClusterScopedHandlerCalls gets all the calls that were made to AddClusterScopedHandler.
// Check the length with:
//     len(mockedVirtualServiceController.AddClusterScopedHandlerCalls())
func (mock *VirtualServiceControllerMock) AddClusterScopedHandlerCalls() []struct {
	Ctx         context.Context
	Name        string
	ClusterName string
	Handler     v1alpha31.VirtualServiceHandlerFunc
} {
	var calls []struct {
		Ctx         context.Context
		Name        string
		ClusterName string
		Handler     v1alpha31.VirtualServiceHandlerFunc
	}
	lockVirtualServiceControllerMockAddClusterScopedHandler.RLock()
	calls = mock.calls.AddClusterScopedHandler
	lockVirtualServiceControllerMockAddClusterScopedHandler.RUnlock()
	return calls
}

// AddFeatureHandler calls AddFeatureHandlerFunc.
func (mock *VirtualServiceControllerMock) AddFeatureHandler(ctx context.Context, enabled func() bool, name string, syncMoqParam v1alpha31.VirtualServiceHandlerFunc) {
	if mock.AddFeatureHandlerFunc == nil {
		panic("VirtualServiceControllerMock.AddFeatureHandlerFunc: method is nil but VirtualServiceController.AddFeatureHandler was just called")
	}
	callInfo := struct {
		Ctx     context.Context
		Enabled func() bool
		Name    string
		Sync    v1alpha31.VirtualServiceHandlerFunc
	}{
		Ctx:     ctx,
		Enabled: enabled,
		Name:    name,
		Sync:    syncMoqParam,
	}
	lockVirtualServiceControllerMockAddFeatureHandler.Lock()
	mock.calls.AddFeatureHandler = append(mock.calls.AddFeatureHandler, callInfo)
	lockVirtualServiceControllerMockAddFeatureHandler.Unlock()
	mock.AddFeatureHandlerFunc(ctx, enabled, name, syncMoqParam)
}

// AddFeatureHandlerCalls gets all the calls that were made to AddFeatureHandler.
// Check the length with:
//     len(mockedVirtualServiceController.AddFeatureHandlerCalls())
func (mock *VirtualServiceControllerMock) AddFeatureHandlerCalls() []struct {
	Ctx     context.Context
	Enabled func() bool
	Name    string
	Sync    v1alpha31.VirtualServiceHandlerFunc
} {
	var calls []struct {
		Ctx     context.Context
		Enabled func() bool
		Name    string
		Sync    v1alpha31.VirtualServiceHandlerFunc
	}
	lockVirtualServiceControllerMockAddFeatureHandler.RLock()
	calls = mock.calls.AddFeatureHandler
	lockVirtualServiceControllerMockAddFeatureHandler.RUnlock()
	return calls
}

// AddHandler calls AddHandlerFunc.
func (mock *VirtualServiceControllerMock) AddHandler(ctx context.Context, name string, handler v1alpha31.VirtualServiceHandlerFunc) {
	if mock.AddHandlerFunc == nil {
		panic("VirtualServiceControllerMock.AddHandlerFunc: method is nil but VirtualServiceController.AddHandler was just called")
	}
	callInfo := struct {
		Ctx     context.Context
		Name    string
		Handler v1alpha31.VirtualServiceHandlerFunc
	}{
		Ctx:     ctx,
		Name:    name,
		Handler: handler,
	}
	lockVirtualServiceControllerMockAddHandler.Lock()
	mock.calls.AddHandler = append(mock.calls.AddHandler, callInfo)
	lockVirtualServiceControllerMockAddHandler.Unlock()
	mock.AddHandlerFunc(ctx, name, handler)
}

// AddHandlerCalls gets all the calls that were made to AddHandler.
// Check the length with:
//     len(mockedVirtualServiceController.AddHandlerCalls())
func (mock *VirtualServiceControllerMock) AddHandlerCalls() []struct {
	Ctx     context.Context
	Name    string
	Handler v1alpha31.VirtualServiceHandlerFunc
} {
	var calls []struct {
		Ctx     context.Context
		Name    string
		Handler v1alpha31.VirtualServiceHandlerFunc
	}
	lockVirtualServiceControllerMockAddHandler.RLock()
	calls = mock.calls.AddHandler
	lockVirtualServiceControllerMockAddHandler.RUnlock()
	return calls
}

// Enqueue calls EnqueueFunc.
func (mock *VirtualServiceControllerMock) Enqueue(namespace string, name string) {
	if mock.EnqueueFunc == nil {
		panic("VirtualServiceControllerMock.EnqueueFunc: method is nil but VirtualServiceController.Enqueue was just called")
	}
	callInfo := struct {
		Namespace string
		Name      string
	}{
		Namespace: namespace,
		Name:      name,
	}
	lockVirtualServiceControllerMockEnqueue.Lock()
	mock.calls.Enqueue = append(mock.calls.Enqueue, callInfo)
	lockVirtualServiceControllerMockEnqueue.Unlock()
	mock.EnqueueFunc(namespace, name)
}

// EnqueueCalls gets all the calls that were made to Enqueue.
// Check the length with:
//     len(mockedVirtualServiceController.EnqueueCalls())
func (mock *VirtualServiceControllerMock) EnqueueCalls() []struct {
	Namespace string
	Name      string
} {
	var calls []struct {
		Namespace string
		Name      string
	}
	lockVirtualServiceControllerMockEnqueue.RLock()
	calls = mock.calls.Enqueue
	lockVirtualServiceControllerMockEnqueue.RUnlock()
	return calls
}

// EnqueueAfter calls EnqueueAfterFunc.
func (mock *VirtualServiceControllerMock) EnqueueAfter(namespace string, name string, after time.Duration) {
	if mock.EnqueueAfterFunc == nil {
		panic("VirtualServiceControllerMock.EnqueueAfterFunc: method is nil but VirtualServiceController.EnqueueAfter was just called")
	}
	callInfo := struct {
		Namespace string
		Name      string
		After     time.Duration
	}{
		Namespace: namespace,
		Name:      name,
		After:     after,
	}
	lockVirtualServiceControllerMockEnqueueAfter.Lock()
	mock.calls.EnqueueAfter = append(mock.calls.EnqueueAfter, callInfo)
	lockVirtualServiceControllerMockEnqueueAfter.Unlock()
	mock.EnqueueAfterFunc(namespace, name, after)
}

// EnqueueAfterCalls gets all the calls that were made to EnqueueAfter.
// Check the length with:
//     len(mockedVirtualServiceController.EnqueueAfterCalls())
func (mock *VirtualServiceControllerMock) EnqueueAfterCalls() []struct {
	Namespace string
	Name      string
	After     time.Duration
} {
	var calls []struct {
		Namespace string
		Name      string
		After     time.Duration
	}
	lockVirtualServiceControllerMockEnqueueAfter.RLock()
	calls = mock.calls.EnqueueAfter
	lockVirtualServiceControllerMockEnqueueAfter.RUnlock()
	return calls
}

// Generic calls GenericFunc.
func (mock *VirtualServiceControllerMock) Generic() controller.GenericController {
	if mock.GenericFunc == nil {
		panic("VirtualServiceControllerMock.GenericFunc: method is nil but VirtualServiceController.Generic was just called")
	}
	callInfo := struct {
	}{}
	lockVirtualServiceControllerMockGeneric.Lock()
	mock.calls.Generic = append(mock.calls.Generic, callInfo)
	lockVirtualServiceControllerMockGeneric.Unlock()
	return mock.GenericFunc()
}

// GenericCalls gets all the calls that were made to Generic.
// Check the length with:
//     len(mockedVirtualServiceController.GenericCalls())
func (mock *VirtualServiceControllerMock) GenericCalls() []struct {
} {
	var calls []struct {
	}
	lockVirtualServiceControllerMockGeneric.RLock()
	calls = mock.calls.Generic
	lockVirtualServiceControllerMockGeneric.RUnlock()
	return calls
}

// Informer calls InformerFunc.
func (mock *VirtualServiceControllerMock) Informer() cache.SharedIndexInformer {
	if mock.InformerFunc == nil {
		panic("VirtualServiceControllerMock.InformerFunc: method is nil but VirtualServiceController.Informer was just called")
	}
	callInfo := struct {
	}{}
	lockVirtualServiceControllerMockInformer.Lock()
	mock.calls.Informer = append(mock.calls.Informer, callInfo)
	lockVirtualServiceControllerMockInformer.Unlock()
	return mock.InformerFunc()
}

// InformerCalls gets all the calls that were made to Informer.
// Check the length with:
//     len(mockedVirtualServiceController.InformerCalls())
func (mock *VirtualServiceControllerMock) InformerCalls() []struct {
} {
	var calls []struct {
	}
	lockVirtualServiceControllerMockInformer.RLock()
	calls = mock.calls.Informer
	lockVirtualServiceControllerMockInformer.RUnlock()
	return calls
}

// Lister calls ListerFunc.
func (mock *VirtualServiceControllerMock) Lister() v1alpha31.VirtualServiceLister {
	if mock.ListerFunc == nil {
		panic("VirtualServiceControllerMock.ListerFunc: method is nil but VirtualServiceController.Lister was just called")
	}
	callInfo := struct {
	}{}
	lockVirtualServiceControllerMockLister.Lock()
	mock.calls.Lister = append(mock.calls.Lister, callInfo)
	lockVirtualServiceControllerMockLister.Unlock()
	return mock.ListerFunc()
}

// ListerCalls gets all the calls that were made to Lister.
// Check the length with:
//     len(mockedVirtualServiceController.ListerCalls())
func (mock *VirtualServiceControllerMock) ListerCalls() []struct {
} {
	var calls []struct {
	}
	lockVirtualServiceControllerMockLister.RLock()
	calls = mock.calls.Lister
	lockVirtualServiceControllerMockLister.RUnlock()
	return calls
}

var (
	lockVirtualServiceInterfaceMockAddClusterScopedFeatureHandler   sync.RWMutex
	lockVirtualServiceInterfaceMockAddClusterScopedFeatureLifecycle sync.RWMutex
	lockVirtualServiceInterfaceMockAddClusterScopedHandler          sync.RWMutex
	lockVirtualServiceInterfaceMockAddClusterScopedLifecycle        sync.RWMutex
	lockVirtualServiceInterfaceMockAddFeatureHandler                sync.RWMutex
	lockVirtualServiceInterfaceMockAddFeatureLifecycle              sync.RWMutex
	lockVirtualServiceInterfaceMockAddHandler                       sync.RWMutex
	lockVirtualServiceInterfaceMockAddLifecycle                     sync.RWMutex
	lockVirtualServiceInterfaceMockController                       sync.RWMutex
	lockVirtualServiceInterfaceMockCreate                           sync.RWMutex
	lockVirtualServiceInterfaceMockDelete                           sync.RWMutex
	lockVirtualServiceInterfaceMockDeleteCollection                 sync.RWMutex
	lockVirtualServiceInterfaceMockDeleteNamespaced                 sync.RWMutex
	lockVirtualServiceInterfaceMockGet                              sync.RWMutex
	lockVirtualServiceInterfaceMockGetNamespaced                    sync.RWMutex
	lockVirtualServiceInterfaceMockList                             sync.RWMutex
	lockVirtualServiceInterfaceMockListNamespaced                   sync.RWMutex
	lockVirtualServiceInterfaceMockObjectClient                     sync.RWMutex
	lockVirtualServiceInterfaceMockUpdate                           sync.RWMutex
	lockVirtualServiceInterfaceMockWatch                            sync.RWMutex
)

// Ensure, that VirtualServiceInterfaceMock does implement v1alpha31.VirtualServiceInterface.
// If this is not the case, regenerate this file with moq.
var _ v1alpha31.VirtualServiceInterface = &VirtualServiceInterfaceMock{}

// VirtualServiceInterfaceMock is a mock implementation of v1alpha31.VirtualServiceInterface.
//
//     func TestSomethingThatUsesVirtualServiceInterface(t *testing.T) {
//
//         // make and configure a mocked v1alpha31.VirtualServiceInterface
//         mockedVirtualServiceInterface := &VirtualServiceInterfaceMock{
//             AddClusterScopedFeatureHandlerFunc: func(ctx context.Context, enabled func() bool, name string, clusterName string, syncMoqParam v1alpha31.VirtualServiceHandlerFunc)  {
// 	               panic("mock out the AddClusterScopedFeatureHandler method")
//             },
//             AddClusterScopedFeatureLifecycleFunc: func(ctx context.Context, enabled func() bool, name string, clusterName string, lifecycle v1alpha31.VirtualServiceLifecycle)  {
// 	               panic("mock out the AddClusterScopedFeatureLifecycle method")
//             },
//             AddClusterScopedHandlerFunc: func(ctx context.Context, name string, clusterName string, syncMoqParam v1alpha31.VirtualServiceHandlerFunc)  {
// 	               panic("mock out the AddClusterScopedHandler method")
//             },
//             AddClusterScopedLifecycleFunc: func(ctx context.Context, name string, clusterName string, lifecycle v1alpha31.VirtualServiceLifecycle)  {
// 	               panic("mock out the AddClusterScopedLifecycle method")
//             },
//             AddFeatureHandlerFunc: func(ctx context.Context, enabled func() bool, name string, syncMoqParam v1alpha31.VirtualServiceHandlerFunc)  {
// 	               panic("mock out the AddFeatureHandler method")
//             },
//             AddFeatureLifecycleFunc: func(ctx context.Context, enabled func() bool, name string, lifecycle v1alpha31.VirtualServiceLifecycle)  {
// 	               panic("mock out the AddFeatureLifecycle method")
//             },
//             AddHandlerFunc: func(ctx context.Context, name string, syncMoqParam v1alpha31.VirtualServiceHandlerFunc)  {
// 	               panic("mock out the AddHandler method")
//             },
//             AddLifecycleFunc: func(ctx context.Context, name string, lifecycle v1alpha31.VirtualServiceLifecycle)  {
// 	               panic("mock out the AddLifecycle method")
//             },
//             ControllerFunc: func() v1alpha31.VirtualServiceController {
// 	               panic("mock out the Controller method")
//             },
//             CreateFunc: func(in1 *v1alpha3.VirtualService) (*v1alpha3.VirtualService, error) {
// 	               panic("mock out the Create method")
//             },
//             DeleteFunc: func(name string, options *metav1.DeleteOptions) error {
// 	               panic("mock out the Delete method")
//             },
//             DeleteCollectionFunc: func(deleteOpts *metav1.DeleteOptions, listOpts metav1.ListOptions) error {
// 	               panic("mock out the DeleteCollection method")
//             },
//             DeleteNamespacedFunc: func(namespace string, name string, options *metav1.DeleteOptions) error {
// 	               panic("mock out the DeleteNamespaced method")
//             },
//             GetFunc: func(name string, opts metav1.GetOptions) (*v1alpha3.VirtualService, error) {
// 	               panic("mock out the Get method")
//             },
//             GetNamespacedFunc: func(namespace string, name string, opts metav1.GetOptions) (*v1alpha3.VirtualService, error) {
// 	               panic("mock out the GetNamespaced method")
//             },
//             ListFunc: func(opts metav1.ListOptions) (*v1alpha3.VirtualServiceList, error) {
// 	               panic("mock out the List method")
//             },
//             ListNamespacedFunc: func(namespace string, opts metav1.ListOptions) (*v1alpha3.VirtualServiceList, error) {
// 	               panic("mock out the ListNamespaced method")
//             },
//             ObjectClientFunc: func() *objectclient.ObjectClient {
// 	               panic("mock out the ObjectClient method")
//             },
//             UpdateFunc: func(in1 *v1alpha3.VirtualService) (*v1alpha3.VirtualService, error) {
// 	               panic("mock out the Update method")
//             },
//             WatchFunc: func(opts metav1.ListOptions) (watch.Interface, error) {
// 	               panic("mock out the Watch method")
//             },
//         }
//
//         // use mockedVirtualServiceInterface in code that requires v1alpha31.VirtualServiceInterface
//         // and then make assertions.
//
//     }
type VirtualServiceInterfaceMock struct {
	// AddClusterScopedFeatureHandlerFunc mocks the AddClusterScopedFeatureHandler method.
	AddClusterScopedFeatureHandlerFunc func(ctx context.Context, enabled func() bool, name string, clusterName string, syncMoqParam v1alpha31.VirtualServiceHandlerFunc)

	// AddClusterScopedFeatureLifecycleFunc mocks the AddClusterScopedFeatureLifecycle method.
	AddClusterScopedFeatureLifecycleFunc func(ctx context.Context, enabled func() bool, name string, clusterName string, lifecycle v1alpha31.VirtualServiceLifecycle)

	// AddClusterScopedHandlerFunc mocks the AddClusterScopedHandler method.
	AddClusterScopedHandlerFunc func(ctx context.Context, name string, clusterName string, syncMoqParam v1alpha31.VirtualServiceHandlerFunc)

	// AddClusterScopedLifecycleFunc mocks the AddClusterScopedLifecycle method.
	AddClusterScopedLifecycleFunc func(ctx context.Context, name string, clusterName string, lifecycle v1alpha31.VirtualServiceLifecycle)

	// AddFeatureHandlerFunc mocks the AddFeatureHandler method.
	AddFeatureHandlerFunc func(ctx context.Context, enabled func() bool, name string, syncMoqParam v1alpha31.VirtualServiceHandlerFunc)

	// AddFeatureLifecycleFunc mocks the AddFeatureLifecycle method.
	AddFeatureLifecycleFunc func(ctx context.Context, enabled func() bool, name string, lifecycle v1alpha31.VirtualServiceLifecycle)

	// AddHandlerFunc mocks the AddHandler method.
	AddHandlerFunc func(ctx context.Context, name string, syncMoqParam v1alpha31.VirtualServiceHandlerFunc)

	// AddLifecycleFunc mocks the AddLifecycle method.
	AddLifecycleFunc func(ctx context.Context, name string, lifecycle v1alpha31.VirtualServiceLifecycle)

	// ControllerFunc mocks the Controller method.
	ControllerFunc func() v1alpha31.VirtualServiceController

	// CreateFunc mocks the Create method.
	CreateFunc func(in1 *v1alpha3.VirtualService) (*v1alpha3.VirtualService, error)

	// DeleteFunc mocks the Delete method.
	DeleteFunc func(name string, options *metav1.DeleteOptions) error

	// DeleteCollectionFunc mocks the DeleteCollection method.
	DeleteCollectionFunc func(deleteOpts *metav1.DeleteOptions, listOpts metav1.ListOptions) error

	// DeleteNamespacedFunc mocks the DeleteNamespaced method.
	DeleteNamespacedFunc func(namespace string, name string, options *metav1.DeleteOptions) error

	// GetFunc mocks the Get method.
	GetFunc func(name string, opts metav1.GetOptions) (*v1alpha3.VirtualService, error)

	// GetNamespacedFunc mocks the GetNamespaced method.
	GetNamespacedFunc func(namespace string, name string, opts metav1.GetOptions) (*v1alpha3.VirtualService, error)

	// ListFunc mocks the List method.
	ListFunc func(opts metav1.ListOptions) (*v1alpha3.VirtualServiceList, error)

	// ListNamespacedFunc mocks the ListNamespaced method.
	ListNamespacedFunc func(namespace string, opts metav1.ListOptions) (*v1alpha3.VirtualServiceList, error)

	// ObjectClientFunc mocks the ObjectClient method.
	ObjectClientFunc func() *objectclient.ObjectClient

	// UpdateFunc mocks the Update method.
	UpdateFunc func(in1 *v1alpha3.VirtualService) (*v1alpha3.VirtualService, error)

	// WatchFunc mocks the Watch method.
	WatchFunc func(opts metav1.ListOptions) (watch.Interface, error)

	// calls tracks calls to the methods.
	calls struct {
		// AddClusterScopedFeatureHandler holds details about calls to the AddClusterScopedFeatureHandler method.
		AddClusterScopedFeatureHandler []struct {
			// Ctx is the ctx argument value.
			Ctx context.Context
			// Enabled is the enabled argument value.
			Enabled func() bool
			// Name is the name argument value.
			Name string
			// ClusterName is the clusterName argument value.
			ClusterName string
			// Sync is the sync argument value.
			Sync v1alpha31.VirtualServiceHandlerFunc
		}
		// AddClusterScopedFeatureLifecycle holds details about calls to the AddClusterScopedFeatureLifecycle method.
		AddClusterScopedFeatureLifecycle []struct {
			// Ctx is the ctx argument value.
			Ctx context.Context
			// Enabled is the enabled argument value.
			Enabled func() bool
			// Name is the name argument value.
			Name string
			// ClusterName is the clusterName argument value.
			ClusterName string
			// Lifecycle is the lifecycle argument value.
			Lifecycle v1alpha31.VirtualServiceLifecycle
		}
		// AddClusterScopedHandler holds details about calls to the AddClusterScopedHandler method.
		AddClusterScopedHandler []struct {
			// Ctx is the ctx argument value.
			Ctx context.Context
			// Name is the name argument value.
			Name string
			// ClusterName is the clusterName argument value.
			ClusterName string
			// Sync is the sync argument value.
			Sync v1alpha31.VirtualServiceHandlerFunc
		}
		// AddClusterScopedLifecycle holds details about calls to the AddClusterScopedLifecycle method.
		AddClusterScopedLifecycle []struct {
			// Ctx is the ctx argument value.
			Ctx context.Context
			// Name is the name argument value.
			Name string
			// ClusterName is the clusterName argument value.
			ClusterName string
			// Lifecycle is the lifecycle argument value.
			Lifecycle v1alpha31.VirtualServiceLifecycle
		}
		// AddFeatureHandler holds details about calls to the AddFeatureHandler method.
		AddFeatureHandler []struct {
			// Ctx is the ctx argument value.
			Ctx context.Context
			// Enabled is the enabled argument value.
			Enabled func() bool
			// Name is the name argument value.
			Name string
			// Sync is the sync argument value.
			Sync v1alpha31.VirtualServiceHandlerFunc
		}
		// AddFeatureLifecycle holds details about calls to the AddFeatureLifecycle method.
		AddFeatureLifecycle []struct {
			// Ctx is the ctx argument value.
			Ctx context.Context
			// Enabled is the enabled argument value.
			Enabled func() bool
			// Name is the name argument value.
			Name string
			// Lifecycle is the lifecycle argument value.
			Lifecycle v1alpha31.VirtualServiceLifecycle
		}
		// AddHandler holds details about calls to the AddHandler method.
		AddHandler []struct {
			// Ctx is the ctx argument value.
			Ctx context.Context
			// Name is the name argument value.
			Name string
			// Sync is the sync argument value.
			Sync v1alpha31.VirtualServiceHandlerFunc
		}
		// AddLifecycle holds details about calls to the AddLifecycle method.
		AddLifecycle []struct {
			// Ctx is the ctx argument value.
			Ctx context.Context
			// Name is the name argument value.
			Name string
			// Lifecycle is the lifecycle argument value.
			Lifecycle v1alpha31.VirtualServiceLifecycle
		}
		// Controller holds details about calls to the Controller method.
		Controller []struct {
		}
		// Create holds details about calls to the Create method.
		Create []struct {
			// In1 is the in1 argument value.
			In1 *v1alpha3.VirtualService
		}
		// Delete holds details about calls to the Delete method.
		Delete []struct {
			// Name is the name argument value.
			Name string
			// Options is the options argument value.
			Options *metav1.DeleteOptions
		}
		// DeleteCollection holds details about calls to the DeleteCollection method.
		DeleteCollection []struct {
			// DeleteOpts is the deleteOpts argument value.
			DeleteOpts *metav1.DeleteOptions
			// ListOpts is the listOpts argument value.
			ListOpts metav1.ListOptions
		}
		// DeleteNamespaced holds details about calls to the DeleteNamespaced method.
		DeleteNamespaced []struct {
			// Namespace is the namespace argument value.
			Namespace string
			// Name is the name argument value.
			Name string
			// Options is the options argument value.
			Options *metav1.DeleteOptions
		}
		// Get holds details about calls to the Get method.
		Get []struct {
			// Name is the name argument value.
			Name string
			// Opts is the opts argument value.
			Opts metav1.GetOptions
		}
		// GetNamespaced holds details about calls to the GetNamespaced method.
		GetNamespaced []struct {
			// Namespace is the namespace argument value.
			Namespace string
			// Name is the name argument value.
			Name string
			// Opts is the opts argument value.
			Opts metav1.GetOptions
		}
		// List holds details about calls to the List method.
		List []struct {
			// Opts is the opts argument value.
			Opts metav1.ListOptions
		}
		// ListNamespaced holds details about calls to the ListNamespaced method.
		ListNamespaced []struct {
			// Namespace is the namespace argument value.
			Namespace string
			// Opts is the opts argument value.
			Opts metav1.ListOptions
		}
		// ObjectClient holds details about calls to the ObjectClient method.
		ObjectClient []struct {
		}
		// Update holds details about calls to the Update method.
		Update []struct {
			// In1 is the in1 argument value.
			In1 *v1alpha3.VirtualService
		}
		// Watch holds details about calls to the Watch method.
		Watch []struct {
			// Opts is the opts argument value.
			Opts metav1.ListOptions
		}
	}
}

// AddClusterScopedFeatureHandler calls AddClusterScopedFeatureHandlerFunc.
func (mock *VirtualServiceInterfaceMock) AddClusterScopedFeatureHandler(ctx context.Context, enabled func() bool, name string, clusterName string, syncMoqParam v1alpha31.VirtualServiceHandlerFunc) {
	if mock.AddClusterScopedFeatureHandlerFunc == nil {
		panic("VirtualServiceInterfaceMock.AddClusterScopedFeatureHandlerFunc: method is nil but VirtualServiceInterface.AddClusterScopedFeatureHandler was just called")
	}
	callInfo := struct {
		Ctx         context.Context
		Enabled     func() bool
		Name        string
		ClusterName string
		Sync        v1alpha31.VirtualServiceHandlerFunc
	}{
		Ctx:         ctx,
		Enabled:     enabled,
		Name:        name,
		ClusterName: clusterName,
		Sync:        syncMoqParam,
	}
	lockVirtualServiceInterfaceMockAddClusterScopedFeatureHandler.Lock()
	mock.calls.AddClusterScopedFeatureHandler = append(mock.calls.AddClusterScopedFeatureHandler, callInfo)
	lockVirtualServiceInterfaceMockAddClusterScopedFeatureHandler.Unlock()
	mock.AddClusterScopedFeatureHandlerFunc(ctx, enabled, name, clusterName, syncMoqParam)
}

// AddClusterScopedFeatureHandlerCalls gets all the calls that were made to AddClusterScopedFeatureHandler.
// Check the length with:
//     len(mockedVirtualServiceInterface.AddClusterScopedFeatureHandlerCalls())
func (mock *VirtualServiceInterfaceMock) AddClusterScopedFeatureHandlerCalls() []struct {
	Ctx         context.Context
	Enabled     func() bool
	Name        string
	ClusterName string
	Sync        v1alpha31.VirtualServiceHandlerFunc
} {
	var calls []struct {
		Ctx         context.Context
		Enabled     func() bool
		Name        string
		ClusterName string
		Sync        v1alpha31.VirtualServiceHandlerFunc
	}
	lockVirtualServiceInterfaceMockAddClusterScopedFeatureHandler.RLock()
	calls = mock.calls.AddClusterScopedFeatureHandler
	lockVirtualServiceInterfaceMockAddClusterScopedFeatureHandler.RUnlock()
	return calls
}

// AddClusterScopedFeatureLifecycle calls AddClusterScopedFeatureLifecycleFunc.
func (mock *VirtualServiceInterfaceMock) AddClusterScopedFeatureLifecycle(ctx context.Context, enabled func() bool, name string, clusterName string, lifecycle v1alpha31.VirtualServiceLifecycle) {
	if mock.AddClusterScopedFeatureLifecycleFunc == nil {
		panic("VirtualServiceInterfaceMock.AddClusterScopedFeatureLifecycleFunc: method is nil but VirtualServiceInterface.AddClusterScopedFeatureLifecycle was just called")
	}
	callInfo := struct {
		Ctx         context.Context
		Enabled     func() bool
		Name        string
		ClusterName string
		Lifecycle   v1alpha31.VirtualServiceLifecycle
	}{
		Ctx:         ctx,
		Enabled:     enabled,
		Name:        name,
		ClusterName: clusterName,
		Lifecycle:   lifecycle,
	}
	lockVirtualServiceInterfaceMockAddClusterScopedFeatureLifecycle.Lock()
	mock.calls.AddClusterScopedFeatureLifecycle = append(mock.calls.AddClusterScopedFeatureLifecycle, callInfo)
	lockVirtualServiceInterfaceMockAddClusterScopedFeatureLifecycle.Unlock()
	mock.AddClusterScopedFeatureLifecycleFunc(ctx, enabled, name, clusterName, lifecycle)
}

// AddClusterScopedFeatureLifecycleCalls gets all the calls that were made to AddClusterScopedFeatureLifecycle.
// Check the length with:
//     len(mockedVirtualServiceInterface.AddClusterScopedFeatureLifecycleCalls())
func (mock *VirtualServiceInterfaceMock) AddClusterScopedFeatureLifecycleCalls() []struct {
	Ctx         context.Context
	Enabled     func() bool
	Name        string
	ClusterName string
	Lifecycle   v1alpha31.VirtualServiceLifecycle
} {
	var calls []struct {
		Ctx         context.Context
		Enabled     func() bool
		Name        string
		ClusterName string
		Lifecycle   v1alpha31.VirtualServiceLifecycle
	}
	lockVirtualServiceInterfaceMockAddClusterScopedFeatureLifecycle.RLock()
	calls = mock.calls.AddClusterScopedFeatureLifecycle
	lockVirtualServiceInterfaceMockAddClusterScopedFeatureLifecycle.RUnlock()
	return calls
}

// AddClusterScopedHandler calls AddClusterScopedHandlerFunc.
func (mock *VirtualServiceInterfaceMock) AddClusterScopedHandler(ctx context.Context, name string, clusterName string, syncMoqParam v1alpha31.VirtualServiceHandlerFunc) {
	if mock.AddClusterScopedHandlerFunc == nil {
		panic("VirtualServiceInterfaceMock.AddClusterScopedHandlerFunc: method is nil but VirtualServiceInterface.AddClusterScopedHandler was just called")
	}
	callInfo := struct {
		Ctx         context.Context
		Name        string
		ClusterName string
		Sync        v1alpha31.VirtualServiceHandlerFunc
	}{
		Ctx:         ctx,
		Name:        name,
		ClusterName: clusterName,
		Sync:        syncMoqParam,
	}
	lockVirtualServiceInterfaceMockAddClusterScopedHandler.Lock()
	mock.calls.AddClusterScopedHandler = append(mock.calls.AddClusterScopedHandler, callInfo)
	lockVirtualServiceInterfaceMockAddClusterScopedHandler.Unlock()
	mock.AddClusterScopedHandlerFunc(ctx, name, clusterName, syncMoqParam)
}

// AddClusterScopedHandlerCalls gets all the calls that were made to AddClusterScopedHandler.
// Check the length with:
//     len(mockedVirtualServiceInterface.AddClusterScopedHandlerCalls())
func (mock *VirtualServiceInterfaceMock) AddClusterScopedHandlerCalls() []struct {
	Ctx         context.Context
	Name        string
	ClusterName string
	Sync        v1alpha31.VirtualServiceHandlerFunc
} {
	var calls []struct {
		Ctx         context.Context
		Name        string
		ClusterName string
		Sync        v1alpha31.VirtualServiceHandlerFunc
	}
	lockVirtualServiceInterfaceMockAddClusterScopedHandler.RLock()
	calls = mock.calls.AddClusterScopedHandler
	lockVirtualServiceInterfaceMockAddClusterScopedHandler.RUnlock()
	return calls
}

// AddClusterScopedLifecycle calls AddClusterScopedLifecycleFunc.
func (mock *VirtualServiceInterfaceMock) AddClusterScopedLifecycle(ctx context.Context, name string, clusterName string, lifecycle v1alpha31.VirtualServiceLifecycle) {
	if mock.AddClusterScopedLifecycleFunc == nil {
		panic("VirtualServiceInterfaceMock.AddClusterScopedLifecycleFunc: method is nil but VirtualServiceInterface.AddClusterScopedLifecycle was just called")
	}
	callInfo := struct {
		Ctx         context.Context
		Name        string
		ClusterName string
		Lifecycle   v1alpha31.VirtualServiceLifecycle
	}{
		Ctx:         ctx,
		Name:        name,
		ClusterName: clusterName,
		Lifecycle:   lifecycle,
	}
	lockVirtualServiceInterfaceMockAddClusterScopedLifecycle.Lock()
	mock.calls.AddClusterScopedLifecycle = append(mock.calls.AddClusterScopedLifecycle, callInfo)
	lockVirtualServiceInterfaceMockAddClusterScopedLifecycle.Unlock()
	mock.AddClusterScopedLifecycleFunc(ctx, name, clusterName, lifecycle)
}

// AddClusterScopedLifecycleCalls gets all the calls that were made to AddClusterScopedLifecycle.
// Check the length with:
//     len(mockedVirtualServiceInterface.AddClusterScopedLifecycleCalls())
func (mock *VirtualServiceInterfaceMock) AddClusterScopedLifecycleCalls() []struct {
	Ctx         context.Context
	Name        string
	ClusterName string
	Lifecycle   v1alpha31.VirtualServiceLifecycle
} {
	var calls []struct {
		Ctx         context.Context
		Name        string
		ClusterName string
		Lifecycle   v1alpha31.VirtualServiceLifecycle
	}
	lockVirtualServiceInterfaceMockAddClusterScopedLifecycle.RLock()
	calls = mock.calls.AddClusterScopedLifecycle
	lockVirtualServiceInterfaceMockAddClusterScopedLifecycle.RUnlock()
	return calls
}

// AddFeatureHandler calls AddFeatureHandlerFunc.
func (mock *VirtualServiceInterfaceMock) AddFeatureHandler(ctx context.Context, enabled func() bool, name string, syncMoqParam v1alpha31.VirtualServiceHandlerFunc) {
	if mock.AddFeatureHandlerFunc == nil {
		panic("VirtualServiceInterfaceMock.AddFeatureHandlerFunc: method is nil but VirtualServiceInterface.AddFeatureHandler was just called")
	}
	callInfo := struct {
		Ctx     context.Context
		Enabled func() bool
		Name    string
		Sync    v1alpha31.VirtualServiceHandlerFunc
	}{
		Ctx:     ctx,
		Enabled: enabled,
		Name:    name,
		Sync:    syncMoqParam,
	}
	lockVirtualServiceInterfaceMockAddFeatureHandler.Lock()
	mock.calls.AddFeatureHandler = append(mock.calls.AddFeatureHandler, callInfo)
	lockVirtualServiceInterfaceMockAddFeatureHandler.Unlock()
	mock.AddFeatureHandlerFunc(ctx, enabled, name, syncMoqParam)
}

// AddFeatureHandlerCalls gets all the calls that were made to AddFeatureHandler.
// Check the length with:
//     len(mockedVirtualServiceInterface.AddFeatureHandlerCalls())
func (mock *VirtualServiceInterfaceMock) AddFeatureHandlerCalls() []struct {
	Ctx     context.Context
	Enabled func() bool
	Name    string
	Sync    v1alpha31.VirtualServiceHandlerFunc
} {
	var calls []struct {
		Ctx     context.Context
		Enabled func() bool
		Name    string
		Sync    v1alpha31.VirtualServiceHandlerFunc
	}
	lockVirtualServiceInterfaceMockAddFeatureHandler.RLock()
	calls = mock.calls.AddFeatureHandler
	lockVirtualServiceInterfaceMockAddFeatureHandler.RUnlock()
	return calls
}

// AddFeatureLifecycle calls AddFeatureLifecycleFunc.
func (mock *VirtualServiceInterfaceMock) AddFeatureLifecycle(ctx context.Context, enabled func() bool, name string, lifecycle v1alpha31.VirtualServiceLifecycle) {
	if mock.AddFeatureLifecycleFunc == nil {
		panic("VirtualServiceInterfaceMock.AddFeatureLifecycleFunc: method is nil but VirtualServiceInterface.AddFeatureLifecycle was just called")
	}
	callInfo := struct {
		Ctx       context.Context
		Enabled   func() bool
		Name      string
		Lifecycle v1alpha31.VirtualServiceLifecycle
	}{
		Ctx:       ctx,
		Enabled:   enabled,
		Name:      name,
		Lifecycle: lifecycle,
	}
	lockVirtualServiceInterfaceMockAddFeatureLifecycle.Lock()
	mock.calls.AddFeatureLifecycle = append(mock.calls.AddFeatureLifecycle, callInfo)
	lockVirtualServiceInterfaceMockAddFeatureLifecycle.Unlock()
	mock.AddFeatureLifecycleFunc(ctx, enabled, name, lifecycle)
}

// AddFeatureLifecycleCalls gets all the calls that were made to AddFeatureLifecycle.
// Check the length with:
//     len(mockedVirtualServiceInterface.AddFeatureLifecycleCalls())
func (mock *VirtualServiceInterfaceMock) AddFeatureLifecycleCalls() []struct {
	Ctx       context.Context
	Enabled   func() bool
	Name      string
	Lifecycle v1alpha31.VirtualServiceLifecycle
} {
	var calls []struct {
		Ctx       context.Context
		Enabled   func() bool
		Name      string
		Lifecycle v1alpha31.VirtualServiceLifecycle
	}
	lockVirtualServiceInterfaceMockAddFeatureLifecycle.RLock()
	calls = mock.calls.AddFeatureLifecycle
	lockVirtualServiceInterfaceMockAddFeatureLifecycle.RUnlock()
	return calls
}

// AddHandler calls AddHandlerFunc.
func (mock *VirtualServiceInterfaceMock) AddHandler(ctx context.Context, name string, syncMoqParam v1alpha31.VirtualServiceHandlerFunc) {
	if mock.AddHandlerFunc == nil {
		panic("VirtualServiceInterfaceMock.AddHandlerFunc: method is nil but VirtualServiceInterface.AddHandler was just called")
	}
	callInfo := struct {
		Ctx  context.Context
		Name string
		Sync v1alpha31.VirtualServiceHandlerFunc
	}{
		Ctx:  ctx,
		Name: name,
		Sync: syncMoqParam,
	}
	lockVirtualServiceInterfaceMockAddHandler.Lock()
	mock.calls.AddHandler = append(mock.calls.AddHandler, callInfo)
	lockVirtualServiceInterfaceMockAddHandler.Unlock()
	mock.AddHandlerFunc(ctx, name, syncMoqParam)
}

// AddHandlerCalls gets all the calls that were made to AddHandler.
// Check the length with:
//     len(mockedVirtualServiceInterface.AddHandlerCalls())
func (mock *VirtualServiceInterfaceMock) AddHandlerCalls() []struct {
	Ctx  context.Context
	Name string
	Sync v1alpha31.VirtualServiceHandlerFunc
} {
	var calls []struct {
		Ctx  context.Context
		Name string
		Sync v1alpha31.VirtualServiceHandlerFunc
	}
	lockVirtualServiceInterfaceMockAddHandler.RLock()
	calls = mock.calls.AddHandler
	lockVirtualServiceInterfaceMockAddHandler.RUnlock()
	return calls
}

// AddLifecycle calls AddLifecycleFunc.
func (mock *VirtualServiceInterfaceMock) AddLifecycle(ctx context.Context, name string, lifecycle v1alpha31.VirtualServiceLifecycle) {
	if mock.AddLifecycleFunc == nil {
		panic("VirtualServiceInterfaceMock.AddLifecycleFunc: method is nil but VirtualServiceInterface.AddLifecycle was just called")
	}
	callInfo := struct {
		Ctx       context.Context
		Name      string
		Lifecycle v1alpha31.VirtualServiceLifecycle
	}{
		Ctx:       ctx,
		Name:      name,
		Lifecycle: lifecycle,
	}
	lockVirtualServiceInterfaceMockAddLifecycle.Lock()
	mock.calls.AddLifecycle = append(mock.calls.AddLifecycle, callInfo)
	lockVirtualServiceInterfaceMockAddLifecycle.Unlock()
	mock.AddLifecycleFunc(ctx, name, lifecycle)
}

// AddLifecycleCalls gets all the calls that were made to AddLifecycle.
// Check the length with:
//     len(mockedVirtualServiceInterface.AddLifecycleCalls())
func (mock *VirtualServiceInterfaceMock) AddLifecycleCalls() []struct {
	Ctx       context.Context
	Name      string
	Lifecycle v1alpha31.VirtualServiceLifecycle
} {
	var calls []struct {
		Ctx       context.Context
		Name      string
		Lifecycle v1alpha31.VirtualServiceLifecycle
	}
	lockVirtualServiceInterfaceMockAddLifecycle.RLock()
	calls = mock.calls.AddLifecycle
	lockVirtualServiceInterfaceMockAddLifecycle.RUnlock()
	return calls
}

// Controller calls ControllerFunc.
func (mock *VirtualServiceInterfaceMock) Controller() v1alpha31.VirtualServiceController {
	if mock.ControllerFunc == nil {
		panic("VirtualServiceInterfaceMock.ControllerFunc: method is nil but VirtualServiceInterface.Controller was just called")
	}
	callInfo := struct {
	}{}
	lockVirtualServiceInterfaceMockController.Lock()
	mock.calls.Controller = append(mock.calls.Controller, callInfo)
	lockVirtualServiceInterfaceMockController.Unlock()
	return mock.ControllerFunc()
}

// ControllerCalls gets all the calls that were made to Controller.
// Check the length with:
//     len(mockedVirtualServiceInterface.ControllerCalls())
func (mock *VirtualServiceInterfaceMock) ControllerCalls() []struct {
} {
	var calls []struct {
	}
	lockVirtualServiceInterfaceMockController.RLock()
	calls = mock.calls.Controller
	lockVirtualServiceInterfaceMockController.RUnlock()
	return calls
}

// Create calls CreateFunc.
func (mock *VirtualServiceInterfaceMock) Create(in1 *v1alpha3.VirtualService) (*v1alpha3.VirtualService, error) {
	if mock.CreateFunc == nil {
		panic("VirtualServiceInterfaceMock.CreateFunc: method is nil but VirtualServiceInterface.Create was just called")
	}
	callInfo := struct {
		In1 *v1alpha3.VirtualService
	}{
		In1: in1,
	}
	lockVirtualServiceInterfaceMockCreate.Lock()
	mock.calls.Create = append(mock.calls.Create, callInfo)
	lockVirtualServiceInterfaceMockCreate.Unlock()
	return mock.CreateFunc(in1)
}

// CreateCalls gets all the calls that were made to Create.
// Check the length with:
//     len(mockedVirtualServiceInterface.CreateCalls())
func (mock *VirtualServiceInterfaceMock) CreateCalls() []struct {
	In1 *v1alpha3.VirtualService
} {
	var calls []struct {
		In1 *v1alpha3.VirtualService
	}
	lockVirtualServiceInterfaceMockCreate.RLock()
	calls = mock.calls.Create
	lockVirtualServiceInterfaceMockCreate.RUnlock()
	return calls
}

// Delete calls DeleteFunc.
func (mock *VirtualServiceInterfaceMock) Delete(name string, options *metav1.DeleteOptions) error {
	if mock.DeleteFunc == nil {
		panic("VirtualServiceInterfaceMock.DeleteFunc: method is nil but VirtualServiceInterface.Delete was just called")
	}
	callInfo := struct {
		Name    string
		Options *metav1.DeleteOptions
	}{
		Name:    name,
		Options: options,
	}
	lockVirtualServiceInterfaceMockDelete.Lock()
	mock.calls.Delete = append(mock.calls.Delete, callInfo)
	lockVirtualServiceInterfaceMockDelete.Unlock()
	return mock.DeleteFunc(name, options)
}

// DeleteCalls gets all the calls that were made to Delete.
// Check the length with:
//     len(mockedVirtualServiceInterface.DeleteCalls())
func (mock *VirtualServiceInterfaceMock) DeleteCalls() []struct {
	Name    string
	Options *metav1.DeleteOptions
} {
	var calls []struct {
		Name    string
		Options *metav1.DeleteOptions
	}
	lockVirtualServiceInterfaceMockDelete.RLock()
	calls = mock.calls.Delete
	lockVirtualServiceInterfaceMockDelete.RUnlock()
	return calls
}

// DeleteCollection calls DeleteCollectionFunc.
func (mock *VirtualServiceInterfaceMock) DeleteCollection(deleteOpts *metav1.DeleteOptions, listOpts metav1.ListOptions) error {
	if mock.DeleteCollectionFunc == nil {
		panic("VirtualServiceInterfaceMock.DeleteCollectionFunc: method is nil but VirtualServiceInterface.DeleteCollection was just called")
	}
	callInfo := struct {
		DeleteOpts *metav1.DeleteOptions
		ListOpts   metav1.ListOptions
	}{
		DeleteOpts: deleteOpts,
		ListOpts:   listOpts,
	}
	lockVirtualServiceInterfaceMockDeleteCollection.Lock()
	mock.calls.DeleteCollection = append(mock.calls.DeleteCollection, callInfo)
	lockVirtualServiceInterfaceMockDeleteCollection.Unlock()
	return mock.DeleteCollectionFunc(deleteOpts, listOpts)
}

// DeleteCollectionCalls gets all the calls that were made to DeleteCollection.
// Check the length with:
//     len(mockedVirtualServiceInterface.DeleteCollectionCalls())
func (mock *VirtualServiceInterfaceMock) DeleteCollectionCalls() []struct {
	DeleteOpts *metav1.DeleteOptions
	ListOpts   metav1.ListOptions
} {
	var calls []struct {
		DeleteOpts *metav1.DeleteOptions
		ListOpts   metav1.ListOptions
	}
	lockVirtualServiceInterfaceMockDeleteCollection.RLock()
	calls = mock.calls.DeleteCollection
	lockVirtualServiceInterfaceMockDeleteCollection.RUnlock()
	return calls
}

// DeleteNamespaced calls DeleteNamespacedFunc.
func (mock *VirtualServiceInterfaceMock) DeleteNamespaced(namespace string, name string, options *metav1.DeleteOptions) error {
	if mock.DeleteNamespacedFunc == nil {
		panic("VirtualServiceInterfaceMock.DeleteNamespacedFunc: method is nil but VirtualServiceInterface.DeleteNamespaced was just called")
	}
	callInfo := struct {
		Namespace string
		Name      string
		Options   *metav1.DeleteOptions
	}{
		Namespace: namespace,
		Name:      name,
		Options:   options,
	}
	lockVirtualServiceInterfaceMockDeleteNamespaced.Lock()
	mock.calls.DeleteNamespaced = append(mock.calls.DeleteNamespaced, callInfo)
	lockVirtualServiceInterfaceMockDeleteNamespaced.Unlock()
	return mock.DeleteNamespacedFunc(namespace, name, options)
}

// DeleteNamespacedCalls gets all the calls that were made to DeleteNamespaced.
// Check the length with:
//     len(mockedVirtualServiceInterface.DeleteNamespacedCalls())
func (mock *VirtualServiceInterfaceMock) DeleteNamespacedCalls() []struct {
	Namespace string
	Name      string
	Options   *metav1.DeleteOptions
} {
	var calls []struct {
		Namespace string
		Name      string
		Options   *metav1.DeleteOptions
	}
	lockVirtualServiceInterfaceMockDeleteNamespaced.RLock()
	calls = mock.calls.DeleteNamespaced
	lockVirtualServiceInterfaceMockDeleteNamespaced.RUnlock()
	return calls
}

// Get calls GetFunc.
func (mock *VirtualServiceInterfaceMock) Get(name string, opts metav1.GetOptions) (*v1alpha3.VirtualService, error) {
	if mock.GetFunc == nil {
		panic("VirtualServiceInterfaceMock.GetFunc: method is nil but VirtualServiceInterface.Get was just called")
	}
	callInfo := struct {
		Name string
		Opts metav1.GetOptions
	}{
		Name: name,
		Opts: opts,
	}
	lockVirtualServiceInterfaceMockGet.Lock()
	mock.calls.Get = append(mock.calls.Get, callInfo)
	lockVirtualServiceInterfaceMockGet.Unlock()
	return mock.GetFunc(name, opts)
}

// GetCalls gets all the calls that were made to Get.
// Check the length with:
//     len(mockedVirtualServiceInterface.GetCalls())
func (mock *VirtualServiceInterfaceMock) GetCalls() []struct {
	Name string
	Opts metav1.GetOptions
} {
	var calls []struct {
		Name string
		Opts metav1.GetOptions
	}
	lockVirtualServiceInterfaceMockGet.RLock()
	calls = mock.calls.Get
	lockVirtualServiceInterfaceMockGet.RUnlock()
	return calls
}

// GetNamespaced calls GetNamespacedFunc.
func (mock *VirtualServiceInterfaceMock) GetNamespaced(namespace string, name string, opts metav1.GetOptions) (*v1alpha3.VirtualService, error) {
	if mock.GetNamespacedFunc == nil {
		panic("VirtualServiceInterfaceMock.GetNamespacedFunc: method is nil but VirtualServiceInterface.GetNamespaced was just called")
	}
	callInfo := struct {
		Namespace string
		Name      string
		Opts      metav1.GetOptions
	}{
		Namespace: namespace,
		Name:      name,
		Opts:      opts,
	}
	lockVirtualServiceInterfaceMockGetNamespaced.Lock()
	mock.calls.GetNamespaced = append(mock.calls.GetNamespaced, callInfo)
	lockVirtualServiceInterfaceMockGetNamespaced.Unlock()
	return mock.GetNamespacedFunc(namespace, name, opts)
}

// GetNamespacedCalls gets all the calls that were made to GetNamespaced.
// Check the length with:
//     len(mockedVirtualServiceInterface.GetNamespacedCalls())
func (mock *VirtualServiceInterfaceMock) GetNamespacedCalls() []struct {
	Namespace string
	Name      string
	Opts      metav1.GetOptions
} {
	var calls []struct {
		Namespace string
		Name      string
		Opts      metav1.GetOptions
	}
	lockVirtualServiceInterfaceMockGetNamespaced.RLock()
	calls = mock.calls.GetNamespaced
	lockVirtualServiceInterfaceMockGetNamespaced.RUnlock()
	return calls
}

// List calls ListFunc.
func (mock *VirtualServiceInterfaceMock) List(opts metav1.ListOptions) (*v1alpha3.VirtualServiceList, error) {
	if mock.ListFunc == nil {
		panic("VirtualServiceInterfaceMock.ListFunc: method is nil but VirtualServiceInterface.List was just called")
	}
	callInfo := struct {
		Opts metav1.ListOptions
	}{
		Opts: opts,
	}
	lockVirtualServiceInterfaceMockList.Lock()
	mock.calls.List = append(mock.calls.List, callInfo)
	lockVirtualServiceInterfaceMockList.Unlock()
	return mock.ListFunc(opts)
}

// ListCalls gets all the calls that were made to List.
// Check the length with:
//     len(mockedVirtualServiceInterface.ListCalls())
func (mock *VirtualServiceInterfaceMock) ListCalls() []struct {
	Opts metav1.ListOptions
} {
	var calls []struct {
		Opts metav1.ListOptions
	}
	lockVirtualServiceInterfaceMockList.RLock()
	calls = mock.calls.List
	lockVirtualServiceInterfaceMockList.RUnlock()
	return calls
}

// ListNamespaced calls ListNamespacedFunc.
func (mock *VirtualServiceInterfaceMock) ListNamespaced(namespace string, opts metav1.ListOptions) (*v1alpha3.VirtualServiceList, error) {
	if mock.ListNamespacedFunc == nil {
		panic("VirtualServiceInterfaceMock.ListNamespacedFunc: method is nil but VirtualServiceInterface.ListNamespaced was just called")
	}
	callInfo := struct {
		Namespace string
		Opts      metav1.ListOptions
	}{
		Namespace: namespace,
		Opts:      opts,
	}
	lockVirtualServiceInterfaceMockListNamespaced.Lock()
	mock.calls.ListNamespaced = append(mock.calls.ListNamespaced, callInfo)
	lockVirtualServiceInterfaceMockListNamespaced.Unlock()
	return mock.ListNamespacedFunc(namespace, opts)
}

// ListNamespacedCalls gets all the calls that were made to ListNamespaced.
// Check the length with:
//     len(mockedVirtualServiceInterface.ListNamespacedCalls())
func (mock *VirtualServiceInterfaceMock) ListNamespacedCalls() []struct {
	Namespace string
	Opts      metav1.ListOptions
} {
	var calls []struct {
		Namespace string
		Opts      metav1.ListOptions
	}
	lockVirtualServiceInterfaceMockListNamespaced.RLock()
	calls = mock.calls.ListNamespaced
	lockVirtualServiceInterfaceMockListNamespaced.RUnlock()
	return calls
}

// ObjectClient calls ObjectClientFunc.
func (mock *VirtualServiceInterfaceMock) ObjectClient() *objectclient.ObjectClient {
	if mock.ObjectClientFunc == nil {
		panic("VirtualServiceInterfaceMock.ObjectClientFunc: method is nil but VirtualServiceInterface.ObjectClient was just called")
	}
	callInfo := struct {
	}{}
	lockVirtualServiceInterfaceMockObjectClient.Lock()
	mock.calls.ObjectClient = append(mock.calls.ObjectClient, callInfo)
	lockVirtualServiceInterfaceMockObjectClient.Unlock()
	return mock.ObjectClientFunc()
}

// ObjectClientCalls gets all the calls that were made to ObjectClient.
// Check the length with:
//     len(mockedVirtualServiceInterface.ObjectClientCalls())
func (mock *VirtualServiceInterfaceMock) ObjectClientCalls() []struct {
} {
	var calls []struct {
	}
	lockVirtualServiceInterfaceMockObjectClient.RLock()
	calls = mock.calls.ObjectClient
	lockVirtualServiceInterfaceMockObjectClient.RUnlock()
	return calls
}

// Update calls UpdateFunc.
func (mock *VirtualServiceInterfaceMock) Update(in1 *v1alpha3.VirtualService) (*v1alpha3.VirtualService, error) {
	if mock.UpdateFunc == nil {
		panic("VirtualServiceInterfaceMock.UpdateFunc: method is nil but VirtualServiceInterface.Update was just called")
	}
	callInfo := struct {
		In1 *v1alpha3.VirtualService
	}{
		In1: in1,
	}
	lockVirtualServiceInterfaceMockUpdate.Lock()
	mock.calls.Update = append(mock.calls.Update, callInfo)
	lockVirtualServiceInterfaceMockUpdate.Unlock()
	return mock.UpdateFunc(in1)
}

// UpdateCalls gets all the calls that were made to Update.
// Check the length with:
//     len(mockedVirtualServiceInterface.UpdateCalls())
func (mock *VirtualServiceInterfaceMock) UpdateCalls() []struct {
	In1 *v1alpha3.VirtualService
} {
	var calls []struct {
		In1 *v1alpha3.VirtualService
	}
	lockVirtualServiceInterfaceMockUpdate.RLock()
	calls = mock.calls.Update
	lockVirtualServiceInterfaceMockUpdate.RUnlock()
	return calls
}

// Watch calls WatchFunc.
func (mock *VirtualServiceInterfaceMock) Watch(opts metav1.ListOptions) (watch.Interface, error) {
	if mock.WatchFunc == nil {
		panic("VirtualServiceInterfaceMock.WatchFunc: method is nil but VirtualServiceInterface.Watch was just called")
	}
	callInfo := struct {
		Opts metav1.ListOptions
	}{
		Opts: opts,
	}
	lockVirtualServiceInterfaceMockWatch.Lock()
	mock.calls.Watch = append(mock.calls.Watch, callInfo)
	lockVirtualServiceInterfaceMockWatch.Unlock()
	return mock.WatchFunc(opts)
}

// WatchCalls gets all the calls that were made to Watch.
// Check the length with:
//     len(mockedVirtualServiceInterface.WatchCalls())
func (mock *VirtualServiceInterfaceMock) WatchCalls() []struct {
	Opts metav1.ListOptions
} {
	var calls []struct {
		Opts metav1.ListOptions
	}
	lockVirtualServiceInterfaceMockWatch.RLock()
	calls = mock.calls.Watch
	lockVirtualServiceInterfaceMockWatch.RUnlock()
	return calls
}

var (
	lockVirtualServicesGetterMockVirtualServices sync.RWMutex
)

// Ensure, that VirtualServicesGetterMock does implement v1alpha31.VirtualServicesGetter.
// If this is not the case, regenerate this file with moq.
var _ v1alpha31.VirtualServicesGetter = &VirtualServicesGetterMock{}

// VirtualServicesGetterMock is a mock implementation of v1alpha31.VirtualServicesGetter.
//
//     func TestSomethingThatUsesVirtualServicesGetter(t *testing.T) {
//
//         // make and configure a mocked v1alpha31.VirtualServicesGetter
//         mockedVirtualServicesGetter := &VirtualServicesGetterMock{
//             VirtualServicesFunc: func(namespace string) v1alpha31.VirtualServiceInterface {
// 	               panic("mock out the VirtualServices method")
//             },
//         }
//
//         // use mockedVirtualServicesGetter in code that requires v1alpha31.VirtualServicesGetter
//         // and then make assertions.
//
//     }
type VirtualServicesGetterMock struct {
	// VirtualServicesFunc mocks the VirtualServices method.
	VirtualServicesFunc func(namespace string) v1alpha31.VirtualServiceInterface

	// calls tracks calls to the methods.
	calls struct {
		// VirtualServices holds details about calls to the VirtualServices method.
		VirtualServices []struct {
			// Namespace is the namespace argument value.
			Namespace string
		}
	}
}

// VirtualServices calls VirtualServicesFunc.
func (mock *VirtualServicesGetterMock) VirtualServices(namespace string) v1alpha31.VirtualServiceInterface {
	if mock.VirtualServicesFunc == nil {
		panic("VirtualServicesGetterMock.VirtualServicesFunc: method is nil but VirtualServicesGetter.VirtualServices was just called")
	}
	callInfo := struct {
		Namespace string
	}{
		Namespace: namespace,
	}
	lockVirtualServicesGetterMockVirtualServices.Lock()
	mock.calls.VirtualServices = append(mock.calls.VirtualServices, callInfo)
	lockVirtualServicesGetterMockVirtualServices.Unlock()
	return mock.VirtualServicesFunc(namespace)
}

// VirtualServicesCalls gets all the calls that were made to VirtualServices.
// Check the length with:
//     len(mockedVirtualServicesGetter.VirtualServicesCalls())
func (mock *VirtualServicesGetterMock) VirtualServicesCalls() []struct {
	Namespace string
} {
	var calls []struct {
		Namespace string
	}
	lockVirtualServicesGetterMockVirtualServices.RLock()
	calls = mock.calls.VirtualServices
	lockVirtualServicesGetterMockVirtualServices.RUnlock()
	return calls
}
