// Code generated by moq; DO NOT EDIT.
// github.com/matryer/moq

package fakes

import (
	"context"
	"sync"
	"time"

	"github.com/rancher/norman/controller"
	"github.com/rancher/norman/objectclient"
	v11 "github.com/rancher/rancher/pkg/generated/norman/networking.k8s.io/v1"
	v1 "k8s.io/api/networking/v1"
	metav1 "k8s.io/apimachinery/pkg/apis/meta/v1"
	"k8s.io/apimachinery/pkg/labels"
	"k8s.io/apimachinery/pkg/watch"
	"k8s.io/client-go/tools/cache"
)

var (
	lockNetworkPolicyListerMockGet  sync.RWMutex
	lockNetworkPolicyListerMockList sync.RWMutex
)

// Ensure, that NetworkPolicyListerMock does implement v11.NetworkPolicyLister.
// If this is not the case, regenerate this file with moq.
var _ v11.NetworkPolicyLister = &NetworkPolicyListerMock{}

// NetworkPolicyListerMock is a mock implementation of v11.NetworkPolicyLister.
//
//     func TestSomethingThatUsesNetworkPolicyLister(t *testing.T) {
//
//         // make and configure a mocked v11.NetworkPolicyLister
//         mockedNetworkPolicyLister := &NetworkPolicyListerMock{
//             GetFunc: func(namespace string, name string) (*v1.NetworkPolicy, error) {
// 	               panic("mock out the Get method")
//             },
//             ListFunc: func(namespace string, selector labels.Selector) ([]*v1.NetworkPolicy, error) {
// 	               panic("mock out the List method")
//             },
//         }
//
//         // use mockedNetworkPolicyLister in code that requires v11.NetworkPolicyLister
//         // and then make assertions.
//
//     }
type NetworkPolicyListerMock struct {
	// GetFunc mocks the Get method.
	GetFunc func(namespace string, name string) (*v1.NetworkPolicy, error)

	// ListFunc mocks the List method.
	ListFunc func(namespace string, selector labels.Selector) ([]*v1.NetworkPolicy, error)

	// calls tracks calls to the methods.
	calls struct {
		// Get holds details about calls to the Get method.
		Get []struct {
			// Namespace is the namespace argument value.
			Namespace string
			// Name is the name argument value.
			Name string
		}
		// List holds details about calls to the List method.
		List []struct {
			// Namespace is the namespace argument value.
			Namespace string
			// Selector is the selector argument value.
			Selector labels.Selector
		}
	}
}

// Get calls GetFunc.
func (mock *NetworkPolicyListerMock) Get(namespace string, name string) (*v1.NetworkPolicy, error) {
	if mock.GetFunc == nil {
		panic("NetworkPolicyListerMock.GetFunc: method is nil but NetworkPolicyLister.Get was just called")
	}
	callInfo := struct {
		Namespace string
		Name      string
	}{
		Namespace: namespace,
		Name:      name,
	}
	lockNetworkPolicyListerMockGet.Lock()
	mock.calls.Get = append(mock.calls.Get, callInfo)
	lockNetworkPolicyListerMockGet.Unlock()
	return mock.GetFunc(namespace, name)
}

// GetCalls gets all the calls that were made to Get.
// Check the length with:
//     len(mockedNetworkPolicyLister.GetCalls())
func (mock *NetworkPolicyListerMock) GetCalls() []struct {
	Namespace string
	Name      string
} {
	var calls []struct {
		Namespace string
		Name      string
	}
	lockNetworkPolicyListerMockGet.RLock()
	calls = mock.calls.Get
	lockNetworkPolicyListerMockGet.RUnlock()
	return calls
}

// List calls ListFunc.
func (mock *NetworkPolicyListerMock) List(namespace string, selector labels.Selector) ([]*v1.NetworkPolicy, error) {
	if mock.ListFunc == nil {
		panic("NetworkPolicyListerMock.ListFunc: method is nil but NetworkPolicyLister.List was just called")
	}
	callInfo := struct {
		Namespace string
		Selector  labels.Selector
	}{
		Namespace: namespace,
		Selector:  selector,
	}
	lockNetworkPolicyListerMockList.Lock()
	mock.calls.List = append(mock.calls.List, callInfo)
	lockNetworkPolicyListerMockList.Unlock()
	return mock.ListFunc(namespace, selector)
}

// ListCalls gets all the calls that were made to List.
// Check the length with:
//     len(mockedNetworkPolicyLister.ListCalls())
func (mock *NetworkPolicyListerMock) ListCalls() []struct {
	Namespace string
	Selector  labels.Selector
} {
	var calls []struct {
		Namespace string
		Selector  labels.Selector
	}
	lockNetworkPolicyListerMockList.RLock()
	calls = mock.calls.List
	lockNetworkPolicyListerMockList.RUnlock()
	return calls
}

var (
	lockNetworkPolicyControllerMockAddClusterScopedFeatureHandler sync.RWMutex
	lockNetworkPolicyControllerMockAddClusterScopedHandler        sync.RWMutex
	lockNetworkPolicyControllerMockAddFeatureHandler              sync.RWMutex
	lockNetworkPolicyControllerMockAddHandler                     sync.RWMutex
	lockNetworkPolicyControllerMockEnqueue                        sync.RWMutex
	lockNetworkPolicyControllerMockEnqueueAfter                   sync.RWMutex
	lockNetworkPolicyControllerMockGeneric                        sync.RWMutex
	lockNetworkPolicyControllerMockInformer                       sync.RWMutex
	lockNetworkPolicyControllerMockLister                         sync.RWMutex
)

// Ensure, that NetworkPolicyControllerMock does implement v11.NetworkPolicyController.
// If this is not the case, regenerate this file with moq.
var _ v11.NetworkPolicyController = &NetworkPolicyControllerMock{}

// NetworkPolicyControllerMock is a mock implementation of v11.NetworkPolicyController.
//
//     func TestSomethingThatUsesNetworkPolicyController(t *testing.T) {
//
//         // make and configure a mocked v11.NetworkPolicyController
//         mockedNetworkPolicyController := &NetworkPolicyControllerMock{
//             AddClusterScopedFeatureHandlerFunc: func(ctx context.Context, enabled func() bool, name string, clusterName string, handler v11.NetworkPolicyHandlerFunc)  {
// 	               panic("mock out the AddClusterScopedFeatureHandler method")
//             },
//             AddClusterScopedHandlerFunc: func(ctx context.Context, name string, clusterName string, handler v11.NetworkPolicyHandlerFunc)  {
// 	               panic("mock out the AddClusterScopedHandler method")
//             },
//             AddFeatureHandlerFunc: func(ctx context.Context, enabled func() bool, name string, syncMoqParam v11.NetworkPolicyHandlerFunc)  {
// 	               panic("mock out the AddFeatureHandler method")
//             },
//             AddHandlerFunc: func(ctx context.Context, name string, handler v11.NetworkPolicyHandlerFunc)  {
// 	               panic("mock out the AddHandler method")
//             },
//             EnqueueFunc: func(namespace string, name string)  {
// 	               panic("mock out the Enqueue method")
//             },
//             EnqueueAfterFunc: func(namespace string, name string, after time.Duration)  {
// 	               panic("mock out the EnqueueAfter method")
//             },
//             GenericFunc: func() controller.GenericController {
// 	               panic("mock out the Generic method")
//             },
//             InformerFunc: func() cache.SharedIndexInformer {
// 	               panic("mock out the Informer method")
//             },
//             ListerFunc: func() v11.NetworkPolicyLister {
// 	               panic("mock out the Lister method")
//             },
//         }
//
//         // use mockedNetworkPolicyController in code that requires v11.NetworkPolicyController
//         // and then make assertions.
//
//     }
type NetworkPolicyControllerMock struct {
	// AddClusterScopedFeatureHandlerFunc mocks the AddClusterScopedFeatureHandler method.
	AddClusterScopedFeatureHandlerFunc func(ctx context.Context, enabled func() bool, name string, clusterName string, handler v11.NetworkPolicyHandlerFunc)

	// AddClusterScopedHandlerFunc mocks the AddClusterScopedHandler method.
	AddClusterScopedHandlerFunc func(ctx context.Context, name string, clusterName string, handler v11.NetworkPolicyHandlerFunc)

	// AddFeatureHandlerFunc mocks the AddFeatureHandler method.
	AddFeatureHandlerFunc func(ctx context.Context, enabled func() bool, name string, syncMoqParam v11.NetworkPolicyHandlerFunc)

	// AddHandlerFunc mocks the AddHandler method.
	AddHandlerFunc func(ctx context.Context, name string, handler v11.NetworkPolicyHandlerFunc)

	// EnqueueFunc mocks the Enqueue method.
	EnqueueFunc func(namespace string, name string)

	// EnqueueAfterFunc mocks the EnqueueAfter method.
	EnqueueAfterFunc func(namespace string, name string, after time.Duration)

	// GenericFunc mocks the Generic method.
	GenericFunc func() controller.GenericController

	// InformerFunc mocks the Informer method.
	InformerFunc func() cache.SharedIndexInformer

	// ListerFunc mocks the Lister method.
	ListerFunc func() v11.NetworkPolicyLister

	// calls tracks calls to the methods.
	calls struct {
		// AddClusterScopedFeatureHandler holds details about calls to the AddClusterScopedFeatureHandler method.
		AddClusterScopedFeatureHandler []struct {
			// Ctx is the ctx argument value.
			Ctx context.Context
			// Enabled is the enabled argument value.
			Enabled func() bool
			// Name is the name argument value.
			Name string
			// ClusterName is the clusterName argument value.
			ClusterName string
			// Handler is the handler argument value.
			Handler v11.NetworkPolicyHandlerFunc
		}
		// AddClusterScopedHandler holds details about calls to the AddClusterScopedHandler method.
		AddClusterScopedHandler []struct {
			// Ctx is the ctx argument value.
			Ctx context.Context
			// Name is the name argument value.
			Name string
			// ClusterName is the clusterName argument value.
			ClusterName string
			// Handler is the handler argument value.
			Handler v11.NetworkPolicyHandlerFunc
		}
		// AddFeatureHandler holds details about calls to the AddFeatureHandler method.
		AddFeatureHandler []struct {
			// Ctx is the ctx argument value.
			Ctx context.Context
			// Enabled is the enabled argument value.
			Enabled func() bool
			// Name is the name argument value.
			Name string
			// Sync is the sync argument value.
			Sync v11.NetworkPolicyHandlerFunc
		}
		// AddHandler holds details about calls to the AddHandler method.
		AddHandler []struct {
			// Ctx is the ctx argument value.
			Ctx context.Context
			// Name is the name argument value.
			Name string
			// Handler is the handler argument value.
			Handler v11.NetworkPolicyHandlerFunc
		}
		// Enqueue holds details about calls to the Enqueue method.
		Enqueue []struct {
			// Namespace is the namespace argument value.
			Namespace string
			// Name is the name argument value.
			Name string
		}
		// EnqueueAfter holds details about calls to the EnqueueAfter method.
		EnqueueAfter []struct {
			// Namespace is the namespace argument value.
			Namespace string
			// Name is the name argument value.
			Name string
			// After is the after argument value.
			After time.Duration
		}
		// Generic holds details about calls to the Generic method.
		Generic []struct {
		}
		// Informer holds details about calls to the Informer method.
		Informer []struct {
		}
		// Lister holds details about calls to the Lister method.
		Lister []struct {
		}
	}
}

// AddClusterScopedFeatureHandler calls AddClusterScopedFeatureHandlerFunc.
func (mock *NetworkPolicyControllerMock) AddClusterScopedFeatureHandler(ctx context.Context, enabled func() bool, name string, clusterName string, handler v11.NetworkPolicyHandlerFunc) {
	if mock.AddClusterScopedFeatureHandlerFunc == nil {
		panic("NetworkPolicyControllerMock.AddClusterScopedFeatureHandlerFunc: method is nil but NetworkPolicyController.AddClusterScopedFeatureHandler was just called")
	}
	callInfo := struct {
		Ctx         context.Context
		Enabled     func() bool
		Name        string
		ClusterName string
		Handler     v11.NetworkPolicyHandlerFunc
	}{
		Ctx:         ctx,
		Enabled:     enabled,
		Name:        name,
		ClusterName: clusterName,
		Handler:     handler,
	}
	lockNetworkPolicyControllerMockAddClusterScopedFeatureHandler.Lock()
	mock.calls.AddClusterScopedFeatureHandler = append(mock.calls.AddClusterScopedFeatureHandler, callInfo)
	lockNetworkPolicyControllerMockAddClusterScopedFeatureHandler.Unlock()
	mock.AddClusterScopedFeatureHandlerFunc(ctx, enabled, name, clusterName, handler)
}

// AddClusterScopedFeatureHandlerCalls gets all the calls that were made to AddClusterScopedFeatureHandler.
// Check the length with:
//     len(mockedNetworkPolicyController.AddClusterScopedFeatureHandlerCalls())
func (mock *NetworkPolicyControllerMock) AddClusterScopedFeatureHandlerCalls() []struct {
	Ctx         context.Context
	Enabled     func() bool
	Name        string
	ClusterName string
	Handler     v11.NetworkPolicyHandlerFunc
} {
	var calls []struct {
		Ctx         context.Context
		Enabled     func() bool
		Name        string
		ClusterName string
		Handler     v11.NetworkPolicyHandlerFunc
	}
	lockNetworkPolicyControllerMockAddClusterScopedFeatureHandler.RLock()
	calls = mock.calls.AddClusterScopedFeatureHandler
	lockNetworkPolicyControllerMockAddClusterScopedFeatureHandler.RUnlock()
	return calls
}

// AddClusterScopedHandler calls AddClusterScopedHandlerFunc.
func (mock *NetworkPolicyControllerMock) AddClusterScopedHandler(ctx context.Context, name string, clusterName string, handler v11.NetworkPolicyHandlerFunc) {
	if mock.AddClusterScopedHandlerFunc == nil {
		panic("NetworkPolicyControllerMock.AddClusterScopedHandlerFunc: method is nil but NetworkPolicyController.AddClusterScopedHandler was just called")
	}
	callInfo := struct {
		Ctx         context.Context
		Name        string
		ClusterName string
		Handler     v11.NetworkPolicyHandlerFunc
	}{
		Ctx:         ctx,
		Name:        name,
		ClusterName: clusterName,
		Handler:     handler,
	}
	lockNetworkPolicyControllerMockAddClusterScopedHandler.Lock()
	mock.calls.AddClusterScopedHandler = append(mock.calls.AddClusterScopedHandler, callInfo)
	lockNetworkPolicyControllerMockAddClusterScopedHandler.Unlock()
	mock.AddClusterScopedHandlerFunc(ctx, name, clusterName, handler)
}

// AddClusterScopedHandlerCalls gets all the calls that were made to AddClusterScopedHandler.
// Check the length with:
//     len(mockedNetworkPolicyController.AddClusterScopedHandlerCalls())
func (mock *NetworkPolicyControllerMock) AddClusterScopedHandlerCalls() []struct {
	Ctx         context.Context
	Name        string
	ClusterName string
	Handler     v11.NetworkPolicyHandlerFunc
} {
	var calls []struct {
		Ctx         context.Context
		Name        string
		ClusterName string
		Handler     v11.NetworkPolicyHandlerFunc
	}
	lockNetworkPolicyControllerMockAddClusterScopedHandler.RLock()
	calls = mock.calls.AddClusterScopedHandler
	lockNetworkPolicyControllerMockAddClusterScopedHandler.RUnlock()
	return calls
}

// AddFeatureHandler calls AddFeatureHandlerFunc.
func (mock *NetworkPolicyControllerMock) AddFeatureHandler(ctx context.Context, enabled func() bool, name string, syncMoqParam v11.NetworkPolicyHandlerFunc) {
	if mock.AddFeatureHandlerFunc == nil {
		panic("NetworkPolicyControllerMock.AddFeatureHandlerFunc: method is nil but NetworkPolicyController.AddFeatureHandler was just called")
	}
	callInfo := struct {
		Ctx     context.Context
		Enabled func() bool
		Name    string
		Sync    v11.NetworkPolicyHandlerFunc
	}{
		Ctx:     ctx,
		Enabled: enabled,
		Name:    name,
		Sync:    syncMoqParam,
	}
	lockNetworkPolicyControllerMockAddFeatureHandler.Lock()
	mock.calls.AddFeatureHandler = append(mock.calls.AddFeatureHandler, callInfo)
	lockNetworkPolicyControllerMockAddFeatureHandler.Unlock()
	mock.AddFeatureHandlerFunc(ctx, enabled, name, syncMoqParam)
}

// AddFeatureHandlerCalls gets all the calls that were made to AddFeatureHandler.
// Check the length with:
//     len(mockedNetworkPolicyController.AddFeatureHandlerCalls())
func (mock *NetworkPolicyControllerMock) AddFeatureHandlerCalls() []struct {
	Ctx     context.Context
	Enabled func() bool
	Name    string
	Sync    v11.NetworkPolicyHandlerFunc
} {
	var calls []struct {
		Ctx     context.Context
		Enabled func() bool
		Name    string
		Sync    v11.NetworkPolicyHandlerFunc
	}
	lockNetworkPolicyControllerMockAddFeatureHandler.RLock()
	calls = mock.calls.AddFeatureHandler
	lockNetworkPolicyControllerMockAddFeatureHandler.RUnlock()
	return calls
}

// AddHandler calls AddHandlerFunc.
func (mock *NetworkPolicyControllerMock) AddHandler(ctx context.Context, name string, handler v11.NetworkPolicyHandlerFunc) {
	if mock.AddHandlerFunc == nil {
		panic("NetworkPolicyControllerMock.AddHandlerFunc: method is nil but NetworkPolicyController.AddHandler was just called")
	}
	callInfo := struct {
		Ctx     context.Context
		Name    string
		Handler v11.NetworkPolicyHandlerFunc
	}{
		Ctx:     ctx,
		Name:    name,
		Handler: handler,
	}
	lockNetworkPolicyControllerMockAddHandler.Lock()
	mock.calls.AddHandler = append(mock.calls.AddHandler, callInfo)
	lockNetworkPolicyControllerMockAddHandler.Unlock()
	mock.AddHandlerFunc(ctx, name, handler)
}

// AddHandlerCalls gets all the calls that were made to AddHandler.
// Check the length with:
//     len(mockedNetworkPolicyController.AddHandlerCalls())
func (mock *NetworkPolicyControllerMock) AddHandlerCalls() []struct {
	Ctx     context.Context
	Name    string
	Handler v11.NetworkPolicyHandlerFunc
} {
	var calls []struct {
		Ctx     context.Context
		Name    string
		Handler v11.NetworkPolicyHandlerFunc
	}
	lockNetworkPolicyControllerMockAddHandler.RLock()
	calls = mock.calls.AddHandler
	lockNetworkPolicyControllerMockAddHandler.RUnlock()
	return calls
}

// Enqueue calls EnqueueFunc.
func (mock *NetworkPolicyControllerMock) Enqueue(namespace string, name string) {
	if mock.EnqueueFunc == nil {
		panic("NetworkPolicyControllerMock.EnqueueFunc: method is nil but NetworkPolicyController.Enqueue was just called")
	}
	callInfo := struct {
		Namespace string
		Name      string
	}{
		Namespace: namespace,
		Name:      name,
	}
	lockNetworkPolicyControllerMockEnqueue.Lock()
	mock.calls.Enqueue = append(mock.calls.Enqueue, callInfo)
	lockNetworkPolicyControllerMockEnqueue.Unlock()
	mock.EnqueueFunc(namespace, name)
}

// EnqueueCalls gets all the calls that were made to Enqueue.
// Check the length with:
//     len(mockedNetworkPolicyController.EnqueueCalls())
func (mock *NetworkPolicyControllerMock) EnqueueCalls() []struct {
	Namespace string
	Name      string
} {
	var calls []struct {
		Namespace string
		Name      string
	}
	lockNetworkPolicyControllerMockEnqueue.RLock()
	calls = mock.calls.Enqueue
	lockNetworkPolicyControllerMockEnqueue.RUnlock()
	return calls
}

// EnqueueAfter calls EnqueueAfterFunc.
func (mock *NetworkPolicyControllerMock) EnqueueAfter(namespace string, name string, after time.Duration) {
	if mock.EnqueueAfterFunc == nil {
		panic("NetworkPolicyControllerMock.EnqueueAfterFunc: method is nil but NetworkPolicyController.EnqueueAfter was just called")
	}
	callInfo := struct {
		Namespace string
		Name      string
		After     time.Duration
	}{
		Namespace: namespace,
		Name:      name,
		After:     after,
	}
	lockNetworkPolicyControllerMockEnqueueAfter.Lock()
	mock.calls.EnqueueAfter = append(mock.calls.EnqueueAfter, callInfo)
	lockNetworkPolicyControllerMockEnqueueAfter.Unlock()
	mock.EnqueueAfterFunc(namespace, name, after)
}

// EnqueueAfterCalls gets all the calls that were made to EnqueueAfter.
// Check the length with:
//     len(mockedNetworkPolicyController.EnqueueAfterCalls())
func (mock *NetworkPolicyControllerMock) EnqueueAfterCalls() []struct {
	Namespace string
	Name      string
	After     time.Duration
} {
	var calls []struct {
		Namespace string
		Name      string
		After     time.Duration
	}
	lockNetworkPolicyControllerMockEnqueueAfter.RLock()
	calls = mock.calls.EnqueueAfter
	lockNetworkPolicyControllerMockEnqueueAfter.RUnlock()
	return calls
}

// Generic calls GenericFunc.
func (mock *NetworkPolicyControllerMock) Generic() controller.GenericController {
	if mock.GenericFunc == nil {
		panic("NetworkPolicyControllerMock.GenericFunc: method is nil but NetworkPolicyController.Generic was just called")
	}
	callInfo := struct {
	}{}
	lockNetworkPolicyControllerMockGeneric.Lock()
	mock.calls.Generic = append(mock.calls.Generic, callInfo)
	lockNetworkPolicyControllerMockGeneric.Unlock()
	return mock.GenericFunc()
}

// GenericCalls gets all the calls that were made to Generic.
// Check the length with:
//     len(mockedNetworkPolicyController.GenericCalls())
func (mock *NetworkPolicyControllerMock) GenericCalls() []struct {
} {
	var calls []struct {
	}
	lockNetworkPolicyControllerMockGeneric.RLock()
	calls = mock.calls.Generic
	lockNetworkPolicyControllerMockGeneric.RUnlock()
	return calls
}

// Informer calls InformerFunc.
func (mock *NetworkPolicyControllerMock) Informer() cache.SharedIndexInformer {
	if mock.InformerFunc == nil {
		panic("NetworkPolicyControllerMock.InformerFunc: method is nil but NetworkPolicyController.Informer was just called")
	}
	callInfo := struct {
	}{}
	lockNetworkPolicyControllerMockInformer.Lock()
	mock.calls.Informer = append(mock.calls.Informer, callInfo)
	lockNetworkPolicyControllerMockInformer.Unlock()
	return mock.InformerFunc()
}

// InformerCalls gets all the calls that were made to Informer.
// Check the length with:
//     len(mockedNetworkPolicyController.InformerCalls())
func (mock *NetworkPolicyControllerMock) InformerCalls() []struct {
} {
	var calls []struct {
	}
	lockNetworkPolicyControllerMockInformer.RLock()
	calls = mock.calls.Informer
	lockNetworkPolicyControllerMockInformer.RUnlock()
	return calls
}

// Lister calls ListerFunc.
func (mock *NetworkPolicyControllerMock) Lister() v11.NetworkPolicyLister {
	if mock.ListerFunc == nil {
		panic("NetworkPolicyControllerMock.ListerFunc: method is nil but NetworkPolicyController.Lister was just called")
	}
	callInfo := struct {
	}{}
	lockNetworkPolicyControllerMockLister.Lock()
	mock.calls.Lister = append(mock.calls.Lister, callInfo)
	lockNetworkPolicyControllerMockLister.Unlock()
	return mock.ListerFunc()
}

// ListerCalls gets all the calls that were made to Lister.
// Check the length with:
//     len(mockedNetworkPolicyController.ListerCalls())
func (mock *NetworkPolicyControllerMock) ListerCalls() []struct {
} {
	var calls []struct {
	}
	lockNetworkPolicyControllerMockLister.RLock()
	calls = mock.calls.Lister
	lockNetworkPolicyControllerMockLister.RUnlock()
	return calls
}

var (
	lockNetworkPolicyInterfaceMockAddClusterScopedFeatureHandler   sync.RWMutex
	lockNetworkPolicyInterfaceMockAddClusterScopedFeatureLifecycle sync.RWMutex
	lockNetworkPolicyInterfaceMockAddClusterScopedHandler          sync.RWMutex
	lockNetworkPolicyInterfaceMockAddClusterScopedLifecycle        sync.RWMutex
	lockNetworkPolicyInterfaceMockAddFeatureHandler                sync.RWMutex
	lockNetworkPolicyInterfaceMockAddFeatureLifecycle              sync.RWMutex
	lockNetworkPolicyInterfaceMockAddHandler                       sync.RWMutex
	lockNetworkPolicyInterfaceMockAddLifecycle                     sync.RWMutex
	lockNetworkPolicyInterfaceMockController                       sync.RWMutex
	lockNetworkPolicyInterfaceMockCreate                           sync.RWMutex
	lockNetworkPolicyInterfaceMockDelete                           sync.RWMutex
	lockNetworkPolicyInterfaceMockDeleteCollection                 sync.RWMutex
	lockNetworkPolicyInterfaceMockDeleteNamespaced                 sync.RWMutex
	lockNetworkPolicyInterfaceMockGet                              sync.RWMutex
	lockNetworkPolicyInterfaceMockGetNamespaced                    sync.RWMutex
	lockNetworkPolicyInterfaceMockList                             sync.RWMutex
	lockNetworkPolicyInterfaceMockListNamespaced                   sync.RWMutex
	lockNetworkPolicyInterfaceMockObjectClient                     sync.RWMutex
	lockNetworkPolicyInterfaceMockUpdate                           sync.RWMutex
	lockNetworkPolicyInterfaceMockWatch                            sync.RWMutex
)

// Ensure, that NetworkPolicyInterfaceMock does implement v11.NetworkPolicyInterface.
// If this is not the case, regenerate this file with moq.
var _ v11.NetworkPolicyInterface = &NetworkPolicyInterfaceMock{}

// NetworkPolicyInterfaceMock is a mock implementation of v11.NetworkPolicyInterface.
//
//     func TestSomethingThatUsesNetworkPolicyInterface(t *testing.T) {
//
//         // make and configure a mocked v11.NetworkPolicyInterface
//         mockedNetworkPolicyInterface := &NetworkPolicyInterfaceMock{
//             AddClusterScopedFeatureHandlerFunc: func(ctx context.Context, enabled func() bool, name string, clusterName string, syncMoqParam v11.NetworkPolicyHandlerFunc)  {
// 	               panic("mock out the AddClusterScopedFeatureHandler method")
//             },
//             AddClusterScopedFeatureLifecycleFunc: func(ctx context.Context, enabled func() bool, name string, clusterName string, lifecycle v11.NetworkPolicyLifecycle)  {
// 	               panic("mock out the AddClusterScopedFeatureLifecycle method")
//             },
//             AddClusterScopedHandlerFunc: func(ctx context.Context, name string, clusterName string, syncMoqParam v11.NetworkPolicyHandlerFunc)  {
// 	               panic("mock out the AddClusterScopedHandler method")
//             },
//             AddClusterScopedLifecycleFunc: func(ctx context.Context, name string, clusterName string, lifecycle v11.NetworkPolicyLifecycle)  {
// 	               panic("mock out the AddClusterScopedLifecycle method")
//             },
//             AddFeatureHandlerFunc: func(ctx context.Context, enabled func() bool, name string, syncMoqParam v11.NetworkPolicyHandlerFunc)  {
// 	               panic("mock out the AddFeatureHandler method")
//             },
//             AddFeatureLifecycleFunc: func(ctx context.Context, enabled func() bool, name string, lifecycle v11.NetworkPolicyLifecycle)  {
// 	               panic("mock out the AddFeatureLifecycle method")
//             },
//             AddHandlerFunc: func(ctx context.Context, name string, syncMoqParam v11.NetworkPolicyHandlerFunc)  {
// 	               panic("mock out the AddHandler method")
//             },
//             AddLifecycleFunc: func(ctx context.Context, name string, lifecycle v11.NetworkPolicyLifecycle)  {
// 	               panic("mock out the AddLifecycle method")
//             },
//             ControllerFunc: func() v11.NetworkPolicyController {
// 	               panic("mock out the Controller method")
//             },
//             CreateFunc: func(in1 *v1.NetworkPolicy) (*v1.NetworkPolicy, error) {
// 	               panic("mock out the Create method")
//             },
//             DeleteFunc: func(name string, options *metav1.DeleteOptions) error {
// 	               panic("mock out the Delete method")
//             },
//             DeleteCollectionFunc: func(deleteOpts *metav1.DeleteOptions, listOpts metav1.ListOptions) error {
// 	               panic("mock out the DeleteCollection method")
//             },
//             DeleteNamespacedFunc: func(namespace string, name string, options *metav1.DeleteOptions) error {
// 	               panic("mock out the DeleteNamespaced method")
//             },
//             GetFunc: func(name string, opts metav1.GetOptions) (*v1.NetworkPolicy, error) {
// 	               panic("mock out the Get method")
//             },
//             GetNamespacedFunc: func(namespace string, name string, opts metav1.GetOptions) (*v1.NetworkPolicy, error) {
// 	               panic("mock out the GetNamespaced method")
//             },
//             ListFunc: func(opts metav1.ListOptions) (*v1.NetworkPolicyList, error) {
// 	               panic("mock out the List method")
//             },
//             ListNamespacedFunc: func(namespace string, opts metav1.ListOptions) (*v1.NetworkPolicyList, error) {
// 	               panic("mock out the ListNamespaced method")
//             },
//             ObjectClientFunc: func() *objectclient.ObjectClient {
// 	               panic("mock out the ObjectClient method")
//             },
//             UpdateFunc: func(in1 *v1.NetworkPolicy) (*v1.NetworkPolicy, error) {
// 	               panic("mock out the Update method")
//             },
//             WatchFunc: func(opts metav1.ListOptions) (watch.Interface, error) {
// 	               panic("mock out the Watch method")
//             },
//         }
//
//         // use mockedNetworkPolicyInterface in code that requires v11.NetworkPolicyInterface
//         // and then make assertions.
//
//     }
type NetworkPolicyInterfaceMock struct {
	// AddClusterScopedFeatureHandlerFunc mocks the AddClusterScopedFeatureHandler method.
	AddClusterScopedFeatureHandlerFunc func(ctx context.Context, enabled func() bool, name string, clusterName string, syncMoqParam v11.NetworkPolicyHandlerFunc)

	// AddClusterScopedFeatureLifecycleFunc mocks the AddClusterScopedFeatureLifecycle method.
	AddClusterScopedFeatureLifecycleFunc func(ctx context.Context, enabled func() bool, name string, clusterName string, lifecycle v11.NetworkPolicyLifecycle)

	// AddClusterScopedHandlerFunc mocks the AddClusterScopedHandler method.
	AddClusterScopedHandlerFunc func(ctx context.Context, name string, clusterName string, syncMoqParam v11.NetworkPolicyHandlerFunc)

	// AddClusterScopedLifecycleFunc mocks the AddClusterScopedLifecycle method.
	AddClusterScopedLifecycleFunc func(ctx context.Context, name string, clusterName string, lifecycle v11.NetworkPolicyLifecycle)

	// AddFeatureHandlerFunc mocks the AddFeatureHandler method.
	AddFeatureHandlerFunc func(ctx context.Context, enabled func() bool, name string, syncMoqParam v11.NetworkPolicyHandlerFunc)

	// AddFeatureLifecycleFunc mocks the AddFeatureLifecycle method.
	AddFeatureLifecycleFunc func(ctx context.Context, enabled func() bool, name string, lifecycle v11.NetworkPolicyLifecycle)

	// AddHandlerFunc mocks the AddHandler method.
	AddHandlerFunc func(ctx context.Context, name string, syncMoqParam v11.NetworkPolicyHandlerFunc)

	// AddLifecycleFunc mocks the AddLifecycle method.
	AddLifecycleFunc func(ctx context.Context, name string, lifecycle v11.NetworkPolicyLifecycle)

	// ControllerFunc mocks the Controller method.
	ControllerFunc func() v11.NetworkPolicyController

	// CreateFunc mocks the Create method.
	CreateFunc func(in1 *v1.NetworkPolicy) (*v1.NetworkPolicy, error)

	// DeleteFunc mocks the Delete method.
	DeleteFunc func(name string, options *metav1.DeleteOptions) error

	// DeleteCollectionFunc mocks the DeleteCollection method.
	DeleteCollectionFunc func(deleteOpts *metav1.DeleteOptions, listOpts metav1.ListOptions) error

	// DeleteNamespacedFunc mocks the DeleteNamespaced method.
	DeleteNamespacedFunc func(namespace string, name string, options *metav1.DeleteOptions) error

	// GetFunc mocks the Get method.
	GetFunc func(name string, opts metav1.GetOptions) (*v1.NetworkPolicy, error)

	// GetNamespacedFunc mocks the GetNamespaced method.
	GetNamespacedFunc func(namespace string, name string, opts metav1.GetOptions) (*v1.NetworkPolicy, error)

	// ListFunc mocks the List method.
	ListFunc func(opts metav1.ListOptions) (*v1.NetworkPolicyList, error)

	// ListNamespacedFunc mocks the ListNamespaced method.
	ListNamespacedFunc func(namespace string, opts metav1.ListOptions) (*v1.NetworkPolicyList, error)

	// ObjectClientFunc mocks the ObjectClient method.
	ObjectClientFunc func() *objectclient.ObjectClient

	// UpdateFunc mocks the Update method.
	UpdateFunc func(in1 *v1.NetworkPolicy) (*v1.NetworkPolicy, error)

	// WatchFunc mocks the Watch method.
	WatchFunc func(opts metav1.ListOptions) (watch.Interface, error)

	// calls tracks calls to the methods.
	calls struct {
		// AddClusterScopedFeatureHandler holds details about calls to the AddClusterScopedFeatureHandler method.
		AddClusterScopedFeatureHandler []struct {
			// Ctx is the ctx argument value.
			Ctx context.Context
			// Enabled is the enabled argument value.
			Enabled func() bool
			// Name is the name argument value.
			Name string
			// ClusterName is the clusterName argument value.
			ClusterName string
			// Sync is the sync argument value.
			Sync v11.NetworkPolicyHandlerFunc
		}
		// AddClusterScopedFeatureLifecycle holds details about calls to the AddClusterScopedFeatureLifecycle method.
		AddClusterScopedFeatureLifecycle []struct {
			// Ctx is the ctx argument value.
			Ctx context.Context
			// Enabled is the enabled argument value.
			Enabled func() bool
			// Name is the name argument value.
			Name string
			// ClusterName is the clusterName argument value.
			ClusterName string
			// Lifecycle is the lifecycle argument value.
			Lifecycle v11.NetworkPolicyLifecycle
		}
		// AddClusterScopedHandler holds details about calls to the AddClusterScopedHandler method.
		AddClusterScopedHandler []struct {
			// Ctx is the ctx argument value.
			Ctx context.Context
			// Name is the name argument value.
			Name string
			// ClusterName is the clusterName argument value.
			ClusterName string
			// Sync is the sync argument value.
			Sync v11.NetworkPolicyHandlerFunc
		}
		// AddClusterScopedLifecycle holds details about calls to the AddClusterScopedLifecycle method.
		AddClusterScopedLifecycle []struct {
			// Ctx is the ctx argument value.
			Ctx context.Context
			// Name is the name argument value.
			Name string
			// ClusterName is the clusterName argument value.
			ClusterName string
			// Lifecycle is the lifecycle argument value.
			Lifecycle v11.NetworkPolicyLifecycle
		}
		// AddFeatureHandler holds details about calls to the AddFeatureHandler method.
		AddFeatureHandler []struct {
			// Ctx is the ctx argument value.
			Ctx context.Context
			// Enabled is the enabled argument value.
			Enabled func() bool
			// Name is the name argument value.
			Name string
			// Sync is the sync argument value.
			Sync v11.NetworkPolicyHandlerFunc
		}
		// AddFeatureLifecycle holds details about calls to the AddFeatureLifecycle method.
		AddFeatureLifecycle []struct {
			// Ctx is the ctx argument value.
			Ctx context.Context
			// Enabled is the enabled argument value.
			Enabled func() bool
			// Name is the name argument value.
			Name string
			// Lifecycle is the lifecycle argument value.
			Lifecycle v11.NetworkPolicyLifecycle
		}
		// AddHandler holds details about calls to the AddHandler method.
		AddHandler []struct {
			// Ctx is the ctx argument value.
			Ctx context.Context
			// Name is the name argument value.
			Name string
			// Sync is the sync argument value.
			Sync v11.NetworkPolicyHandlerFunc
		}
		// AddLifecycle holds details about calls to the AddLifecycle method.
		AddLifecycle []struct {
			// Ctx is the ctx argument value.
			Ctx context.Context
			// Name is the name argument value.
			Name string
			// Lifecycle is the lifecycle argument value.
			Lifecycle v11.NetworkPolicyLifecycle
		}
		// Controller holds details about calls to the Controller method.
		Controller []struct {
		}
		// Create holds details about calls to the Create method.
		Create []struct {
			// In1 is the in1 argument value.
			In1 *v1.NetworkPolicy
		}
		// Delete holds details about calls to the Delete method.
		Delete []struct {
			// Name is the name argument value.
			Name string
			// Options is the options argument value.
			Options *metav1.DeleteOptions
		}
		// DeleteCollection holds details about calls to the DeleteCollection method.
		DeleteCollection []struct {
			// DeleteOpts is the deleteOpts argument value.
			DeleteOpts *metav1.DeleteOptions
			// ListOpts is the listOpts argument value.
			ListOpts metav1.ListOptions
		}
		// DeleteNamespaced holds details about calls to the DeleteNamespaced method.
		DeleteNamespaced []struct {
			// Namespace is the namespace argument value.
			Namespace string
			// Name is the name argument value.
			Name string
			// Options is the options argument value.
			Options *metav1.DeleteOptions
		}
		// Get holds details about calls to the Get method.
		Get []struct {
			// Name is the name argument value.
			Name string
			// Opts is the opts argument value.
			Opts metav1.GetOptions
		}
		// GetNamespaced holds details about calls to the GetNamespaced method.
		GetNamespaced []struct {
			// Namespace is the namespace argument value.
			Namespace string
			// Name is the name argument value.
			Name string
			// Opts is the opts argument value.
			Opts metav1.GetOptions
		}
		// List holds details about calls to the List method.
		List []struct {
			// Opts is the opts argument value.
			Opts metav1.ListOptions
		}
		// ListNamespaced holds details about calls to the ListNamespaced method.
		ListNamespaced []struct {
			// Namespace is the namespace argument value.
			Namespace string
			// Opts is the opts argument value.
			Opts metav1.ListOptions
		}
		// ObjectClient holds details about calls to the ObjectClient method.
		ObjectClient []struct {
		}
		// Update holds details about calls to the Update method.
		Update []struct {
			// In1 is the in1 argument value.
			In1 *v1.NetworkPolicy
		}
		// Watch holds details about calls to the Watch method.
		Watch []struct {
			// Opts is the opts argument value.
			Opts metav1.ListOptions
		}
	}
}

// AddClusterScopedFeatureHandler calls AddClusterScopedFeatureHandlerFunc.
func (mock *NetworkPolicyInterfaceMock) AddClusterScopedFeatureHandler(ctx context.Context, enabled func() bool, name string, clusterName string, syncMoqParam v11.NetworkPolicyHandlerFunc) {
	if mock.AddClusterScopedFeatureHandlerFunc == nil {
		panic("NetworkPolicyInterfaceMock.AddClusterScopedFeatureHandlerFunc: method is nil but NetworkPolicyInterface.AddClusterScopedFeatureHandler was just called")
	}
	callInfo := struct {
		Ctx         context.Context
		Enabled     func() bool
		Name        string
		ClusterName string
		Sync        v11.NetworkPolicyHandlerFunc
	}{
		Ctx:         ctx,
		Enabled:     enabled,
		Name:        name,
		ClusterName: clusterName,
		Sync:        syncMoqParam,
	}
	lockNetworkPolicyInterfaceMockAddClusterScopedFeatureHandler.Lock()
	mock.calls.AddClusterScopedFeatureHandler = append(mock.calls.AddClusterScopedFeatureHandler, callInfo)
	lockNetworkPolicyInterfaceMockAddClusterScopedFeatureHandler.Unlock()
	mock.AddClusterScopedFeatureHandlerFunc(ctx, enabled, name, clusterName, syncMoqParam)
}

// AddClusterScopedFeatureHandlerCalls gets all the calls that were made to AddClusterScopedFeatureHandler.
// Check the length with:
//     len(mockedNetworkPolicyInterface.AddClusterScopedFeatureHandlerCalls())
func (mock *NetworkPolicyInterfaceMock) AddClusterScopedFeatureHandlerCalls() []struct {
	Ctx         context.Context
	Enabled     func() bool
	Name        string
	ClusterName string
	Sync        v11.NetworkPolicyHandlerFunc
} {
	var calls []struct {
		Ctx         context.Context
		Enabled     func() bool
		Name        string
		ClusterName string
		Sync        v11.NetworkPolicyHandlerFunc
	}
	lockNetworkPolicyInterfaceMockAddClusterScopedFeatureHandler.RLock()
	calls = mock.calls.AddClusterScopedFeatureHandler
	lockNetworkPolicyInterfaceMockAddClusterScopedFeatureHandler.RUnlock()
	return calls
}

// AddClusterScopedFeatureLifecycle calls AddClusterScopedFeatureLifecycleFunc.
func (mock *NetworkPolicyInterfaceMock) AddClusterScopedFeatureLifecycle(ctx context.Context, enabled func() bool, name string, clusterName string, lifecycle v11.NetworkPolicyLifecycle) {
	if mock.AddClusterScopedFeatureLifecycleFunc == nil {
		panic("NetworkPolicyInterfaceMock.AddClusterScopedFeatureLifecycleFunc: method is nil but NetworkPolicyInterface.AddClusterScopedFeatureLifecycle was just called")
	}
	callInfo := struct {
		Ctx         context.Context
		Enabled     func() bool
		Name        string
		ClusterName string
		Lifecycle   v11.NetworkPolicyLifecycle
	}{
		Ctx:         ctx,
		Enabled:     enabled,
		Name:        name,
		ClusterName: clusterName,
		Lifecycle:   lifecycle,
	}
	lockNetworkPolicyInterfaceMockAddClusterScopedFeatureLifecycle.Lock()
	mock.calls.AddClusterScopedFeatureLifecycle = append(mock.calls.AddClusterScopedFeatureLifecycle, callInfo)
	lockNetworkPolicyInterfaceMockAddClusterScopedFeatureLifecycle.Unlock()
	mock.AddClusterScopedFeatureLifecycleFunc(ctx, enabled, name, clusterName, lifecycle)
}

// AddClusterScopedFeatureLifecycleCalls gets all the calls that were made to AddClusterScopedFeatureLifecycle.
// Check the length with:
//     len(mockedNetworkPolicyInterface.AddClusterScopedFeatureLifecycleCalls())
func (mock *NetworkPolicyInterfaceMock) AddClusterScopedFeatureLifecycleCalls() []struct {
	Ctx         context.Context
	Enabled     func() bool
	Name        string
	ClusterName string
	Lifecycle   v11.NetworkPolicyLifecycle
} {
	var calls []struct {
		Ctx         context.Context
		Enabled     func() bool
		Name        string
		ClusterName string
		Lifecycle   v11.NetworkPolicyLifecycle
	}
	lockNetworkPolicyInterfaceMockAddClusterScopedFeatureLifecycle.RLock()
	calls = mock.calls.AddClusterScopedFeatureLifecycle
	lockNetworkPolicyInterfaceMockAddClusterScopedFeatureLifecycle.RUnlock()
	return calls
}

// AddClusterScopedHandler calls AddClusterScopedHandlerFunc.
func (mock *NetworkPolicyInterfaceMock) AddClusterScopedHandler(ctx context.Context, name string, clusterName string, syncMoqParam v11.NetworkPolicyHandlerFunc) {
	if mock.AddClusterScopedHandlerFunc == nil {
		panic("NetworkPolicyInterfaceMock.AddClusterScopedHandlerFunc: method is nil but NetworkPolicyInterface.AddClusterScopedHandler was just called")
	}
	callInfo := struct {
		Ctx         context.Context
		Name        string
		ClusterName string
		Sync        v11.NetworkPolicyHandlerFunc
	}{
		Ctx:         ctx,
		Name:        name,
		ClusterName: clusterName,
		Sync:        syncMoqParam,
	}
	lockNetworkPolicyInterfaceMockAddClusterScopedHandler.Lock()
	mock.calls.AddClusterScopedHandler = append(mock.calls.AddClusterScopedHandler, callInfo)
	lockNetworkPolicyInterfaceMockAddClusterScopedHandler.Unlock()
	mock.AddClusterScopedHandlerFunc(ctx, name, clusterName, syncMoqParam)
}

// AddClusterScopedHandlerCalls gets all the calls that were made to AddClusterScopedHandler.
// Check the length with:
//     len(mockedNetworkPolicyInterface.AddClusterScopedHandlerCalls())
func (mock *NetworkPolicyInterfaceMock) AddClusterScopedHandlerCalls() []struct {
	Ctx         context.Context
	Name        string
	ClusterName string
	Sync        v11.NetworkPolicyHandlerFunc
} {
	var calls []struct {
		Ctx         context.Context
		Name        string
		ClusterName string
		Sync        v11.NetworkPolicyHandlerFunc
	}
	lockNetworkPolicyInterfaceMockAddClusterScopedHandler.RLock()
	calls = mock.calls.AddClusterScopedHandler
	lockNetworkPolicyInterfaceMockAddClusterScopedHandler.RUnlock()
	return calls
}

// AddClusterScopedLifecycle calls AddClusterScopedLifecycleFunc.
func (mock *NetworkPolicyInterfaceMock) AddClusterScopedLifecycle(ctx context.Context, name string, clusterName string, lifecycle v11.NetworkPolicyLifecycle) {
	if mock.AddClusterScopedLifecycleFunc == nil {
		panic("NetworkPolicyInterfaceMock.AddClusterScopedLifecycleFunc: method is nil but NetworkPolicyInterface.AddClusterScopedLifecycle was just called")
	}
	callInfo := struct {
		Ctx         context.Context
		Name        string
		ClusterName string
		Lifecycle   v11.NetworkPolicyLifecycle
	}{
		Ctx:         ctx,
		Name:        name,
		ClusterName: clusterName,
		Lifecycle:   lifecycle,
	}
	lockNetworkPolicyInterfaceMockAddClusterScopedLifecycle.Lock()
	mock.calls.AddClusterScopedLifecycle = append(mock.calls.AddClusterScopedLifecycle, callInfo)
	lockNetworkPolicyInterfaceMockAddClusterScopedLifecycle.Unlock()
	mock.AddClusterScopedLifecycleFunc(ctx, name, clusterName, lifecycle)
}

// AddClusterScopedLifecycleCalls gets all the calls that were made to AddClusterScopedLifecycle.
// Check the length with:
//     len(mockedNetworkPolicyInterface.AddClusterScopedLifecycleCalls())
func (mock *NetworkPolicyInterfaceMock) AddClusterScopedLifecycleCalls() []struct {
	Ctx         context.Context
	Name        string
	ClusterName string
	Lifecycle   v11.NetworkPolicyLifecycle
} {
	var calls []struct {
		Ctx         context.Context
		Name        string
		ClusterName string
		Lifecycle   v11.NetworkPolicyLifecycle
	}
	lockNetworkPolicyInterfaceMockAddClusterScopedLifecycle.RLock()
	calls = mock.calls.AddClusterScopedLifecycle
	lockNetworkPolicyInterfaceMockAddClusterScopedLifecycle.RUnlock()
	return calls
}

// AddFeatureHandler calls AddFeatureHandlerFunc.
func (mock *NetworkPolicyInterfaceMock) AddFeatureHandler(ctx context.Context, enabled func() bool, name string, syncMoqParam v11.NetworkPolicyHandlerFunc) {
	if mock.AddFeatureHandlerFunc == nil {
		panic("NetworkPolicyInterfaceMock.AddFeatureHandlerFunc: method is nil but NetworkPolicyInterface.AddFeatureHandler was just called")
	}
	callInfo := struct {
		Ctx     context.Context
		Enabled func() bool
		Name    string
		Sync    v11.NetworkPolicyHandlerFunc
	}{
		Ctx:     ctx,
		Enabled: enabled,
		Name:    name,
		Sync:    syncMoqParam,
	}
	lockNetworkPolicyInterfaceMockAddFeatureHandler.Lock()
	mock.calls.AddFeatureHandler = append(mock.calls.AddFeatureHandler, callInfo)
	lockNetworkPolicyInterfaceMockAddFeatureHandler.Unlock()
	mock.AddFeatureHandlerFunc(ctx, enabled, name, syncMoqParam)
}

// AddFeatureHandlerCalls gets all the calls that were made to AddFeatureHandler.
// Check the length with:
//     len(mockedNetworkPolicyInterface.AddFeatureHandlerCalls())
func (mock *NetworkPolicyInterfaceMock) AddFeatureHandlerCalls() []struct {
	Ctx     context.Context
	Enabled func() bool
	Name    string
	Sync    v11.NetworkPolicyHandlerFunc
} {
	var calls []struct {
		Ctx     context.Context
		Enabled func() bool
		Name    string
		Sync    v11.NetworkPolicyHandlerFunc
	}
	lockNetworkPolicyInterfaceMockAddFeatureHandler.RLock()
	calls = mock.calls.AddFeatureHandler
	lockNetworkPolicyInterfaceMockAddFeatureHandler.RUnlock()
	return calls
}

// AddFeatureLifecycle calls AddFeatureLifecycleFunc.
func (mock *NetworkPolicyInterfaceMock) AddFeatureLifecycle(ctx context.Context, enabled func() bool, name string, lifecycle v11.NetworkPolicyLifecycle) {
	if mock.AddFeatureLifecycleFunc == nil {
		panic("NetworkPolicyInterfaceMock.AddFeatureLifecycleFunc: method is nil but NetworkPolicyInterface.AddFeatureLifecycle was just called")
	}
	callInfo := struct {
		Ctx       context.Context
		Enabled   func() bool
		Name      string
		Lifecycle v11.NetworkPolicyLifecycle
	}{
		Ctx:       ctx,
		Enabled:   enabled,
		Name:      name,
		Lifecycle: lifecycle,
	}
	lockNetworkPolicyInterfaceMockAddFeatureLifecycle.Lock()
	mock.calls.AddFeatureLifecycle = append(mock.calls.AddFeatureLifecycle, callInfo)
	lockNetworkPolicyInterfaceMockAddFeatureLifecycle.Unlock()
	mock.AddFeatureLifecycleFunc(ctx, enabled, name, lifecycle)
}

// AddFeatureLifecycleCalls gets all the calls that were made to AddFeatureLifecycle.
// Check the length with:
//     len(mockedNetworkPolicyInterface.AddFeatureLifecycleCalls())
func (mock *NetworkPolicyInterfaceMock) AddFeatureLifecycleCalls() []struct {
	Ctx       context.Context
	Enabled   func() bool
	Name      string
	Lifecycle v11.NetworkPolicyLifecycle
} {
	var calls []struct {
		Ctx       context.Context
		Enabled   func() bool
		Name      string
		Lifecycle v11.NetworkPolicyLifecycle
	}
	lockNetworkPolicyInterfaceMockAddFeatureLifecycle.RLock()
	calls = mock.calls.AddFeatureLifecycle
	lockNetworkPolicyInterfaceMockAddFeatureLifecycle.RUnlock()
	return calls
}

// AddHandler calls AddHandlerFunc.
func (mock *NetworkPolicyInterfaceMock) AddHandler(ctx context.Context, name string, syncMoqParam v11.NetworkPolicyHandlerFunc) {
	if mock.AddHandlerFunc == nil {
		panic("NetworkPolicyInterfaceMock.AddHandlerFunc: method is nil but NetworkPolicyInterface.AddHandler was just called")
	}
	callInfo := struct {
		Ctx  context.Context
		Name string
		Sync v11.NetworkPolicyHandlerFunc
	}{
		Ctx:  ctx,
		Name: name,
		Sync: syncMoqParam,
	}
	lockNetworkPolicyInterfaceMockAddHandler.Lock()
	mock.calls.AddHandler = append(mock.calls.AddHandler, callInfo)
	lockNetworkPolicyInterfaceMockAddHandler.Unlock()
	mock.AddHandlerFunc(ctx, name, syncMoqParam)
}

// AddHandlerCalls gets all the calls that were made to AddHandler.
// Check the length with:
//     len(mockedNetworkPolicyInterface.AddHandlerCalls())
func (mock *NetworkPolicyInterfaceMock) AddHandlerCalls() []struct {
	Ctx  context.Context
	Name string
	Sync v11.NetworkPolicyHandlerFunc
} {
	var calls []struct {
		Ctx  context.Context
		Name string
		Sync v11.NetworkPolicyHandlerFunc
	}
	lockNetworkPolicyInterfaceMockAddHandler.RLock()
	calls = mock.calls.AddHandler
	lockNetworkPolicyInterfaceMockAddHandler.RUnlock()
	return calls
}

// AddLifecycle calls AddLifecycleFunc.
func (mock *NetworkPolicyInterfaceMock) AddLifecycle(ctx context.Context, name string, lifecycle v11.NetworkPolicyLifecycle) {
	if mock.AddLifecycleFunc == nil {
		panic("NetworkPolicyInterfaceMock.AddLifecycleFunc: method is nil but NetworkPolicyInterface.AddLifecycle was just called")
	}
	callInfo := struct {
		Ctx       context.Context
		Name      string
		Lifecycle v11.NetworkPolicyLifecycle
	}{
		Ctx:       ctx,
		Name:      name,
		Lifecycle: lifecycle,
	}
	lockNetworkPolicyInterfaceMockAddLifecycle.Lock()
	mock.calls.AddLifecycle = append(mock.calls.AddLifecycle, callInfo)
	lockNetworkPolicyInterfaceMockAddLifecycle.Unlock()
	mock.AddLifecycleFunc(ctx, name, lifecycle)
}

// AddLifecycleCalls gets all the calls that were made to AddLifecycle.
// Check the length with:
//     len(mockedNetworkPolicyInterface.AddLifecycleCalls())
func (mock *NetworkPolicyInterfaceMock) AddLifecycleCalls() []struct {
	Ctx       context.Context
	Name      string
	Lifecycle v11.NetworkPolicyLifecycle
} {
	var calls []struct {
		Ctx       context.Context
		Name      string
		Lifecycle v11.NetworkPolicyLifecycle
	}
	lockNetworkPolicyInterfaceMockAddLifecycle.RLock()
	calls = mock.calls.AddLifecycle
	lockNetworkPolicyInterfaceMockAddLifecycle.RUnlock()
	return calls
}

// Controller calls ControllerFunc.
func (mock *NetworkPolicyInterfaceMock) Controller() v11.NetworkPolicyController {
	if mock.ControllerFunc == nil {
		panic("NetworkPolicyInterfaceMock.ControllerFunc: method is nil but NetworkPolicyInterface.Controller was just called")
	}
	callInfo := struct {
	}{}
	lockNetworkPolicyInterfaceMockController.Lock()
	mock.calls.Controller = append(mock.calls.Controller, callInfo)
	lockNetworkPolicyInterfaceMockController.Unlock()
	return mock.ControllerFunc()
}

// ControllerCalls gets all the calls that were made to Controller.
// Check the length with:
//     len(mockedNetworkPolicyInterface.ControllerCalls())
func (mock *NetworkPolicyInterfaceMock) ControllerCalls() []struct {
} {
	var calls []struct {
	}
	lockNetworkPolicyInterfaceMockController.RLock()
	calls = mock.calls.Controller
	lockNetworkPolicyInterfaceMockController.RUnlock()
	return calls
}

// Create calls CreateFunc.
func (mock *NetworkPolicyInterfaceMock) Create(in1 *v1.NetworkPolicy) (*v1.NetworkPolicy, error) {
	if mock.CreateFunc == nil {
		panic("NetworkPolicyInterfaceMock.CreateFunc: method is nil but NetworkPolicyInterface.Create was just called")
	}
	callInfo := struct {
		In1 *v1.NetworkPolicy
	}{
		In1: in1,
	}
	lockNetworkPolicyInterfaceMockCreate.Lock()
	mock.calls.Create = append(mock.calls.Create, callInfo)
	lockNetworkPolicyInterfaceMockCreate.Unlock()
	return mock.CreateFunc(in1)
}

// CreateCalls gets all the calls that were made to Create.
// Check the length with:
//     len(mockedNetworkPolicyInterface.CreateCalls())
func (mock *NetworkPolicyInterfaceMock) CreateCalls() []struct {
	In1 *v1.NetworkPolicy
} {
	var calls []struct {
		In1 *v1.NetworkPolicy
	}
	lockNetworkPolicyInterfaceMockCreate.RLock()
	calls = mock.calls.Create
	lockNetworkPolicyInterfaceMockCreate.RUnlock()
	return calls
}

// Delete calls DeleteFunc.
func (mock *NetworkPolicyInterfaceMock) Delete(name string, options *metav1.DeleteOptions) error {
	if mock.DeleteFunc == nil {
		panic("NetworkPolicyInterfaceMock.DeleteFunc: method is nil but NetworkPolicyInterface.Delete was just called")
	}
	callInfo := struct {
		Name    string
		Options *metav1.DeleteOptions
	}{
		Name:    name,
		Options: options,
	}
	lockNetworkPolicyInterfaceMockDelete.Lock()
	mock.calls.Delete = append(mock.calls.Delete, callInfo)
	lockNetworkPolicyInterfaceMockDelete.Unlock()
	return mock.DeleteFunc(name, options)
}

// DeleteCalls gets all the calls that were made to Delete.
// Check the length with:
//     len(mockedNetworkPolicyInterface.DeleteCalls())
func (mock *NetworkPolicyInterfaceMock) DeleteCalls() []struct {
	Name    string
	Options *metav1.DeleteOptions
} {
	var calls []struct {
		Name    string
		Options *metav1.DeleteOptions
	}
	lockNetworkPolicyInterfaceMockDelete.RLock()
	calls = mock.calls.Delete
	lockNetworkPolicyInterfaceMockDelete.RUnlock()
	return calls
}

// DeleteCollection calls DeleteCollectionFunc.
func (mock *NetworkPolicyInterfaceMock) DeleteCollection(deleteOpts *metav1.DeleteOptions, listOpts metav1.ListOptions) error {
	if mock.DeleteCollectionFunc == nil {
		panic("NetworkPolicyInterfaceMock.DeleteCollectionFunc: method is nil but NetworkPolicyInterface.DeleteCollection was just called")
	}
	callInfo := struct {
		DeleteOpts *metav1.DeleteOptions
		ListOpts   metav1.ListOptions
	}{
		DeleteOpts: deleteOpts,
		ListOpts:   listOpts,
	}
	lockNetworkPolicyInterfaceMockDeleteCollection.Lock()
	mock.calls.DeleteCollection = append(mock.calls.DeleteCollection, callInfo)
	lockNetworkPolicyInterfaceMockDeleteCollection.Unlock()
	return mock.DeleteCollectionFunc(deleteOpts, listOpts)
}

// DeleteCollectionCalls gets all the calls that were made to DeleteCollection.
// Check the length with:
//     len(mockedNetworkPolicyInterface.DeleteCollectionCalls())
func (mock *NetworkPolicyInterfaceMock) DeleteCollectionCalls() []struct {
	DeleteOpts *metav1.DeleteOptions
	ListOpts   metav1.ListOptions
} {
	var calls []struct {
		DeleteOpts *metav1.DeleteOptions
		ListOpts   metav1.ListOptions
	}
	lockNetworkPolicyInterfaceMockDeleteCollection.RLock()
	calls = mock.calls.DeleteCollection
	lockNetworkPolicyInterfaceMockDeleteCollection.RUnlock()
	return calls
}

// DeleteNamespaced calls DeleteNamespacedFunc.
func (mock *NetworkPolicyInterfaceMock) DeleteNamespaced(namespace string, name string, options *metav1.DeleteOptions) error {
	if mock.DeleteNamespacedFunc == nil {
		panic("NetworkPolicyInterfaceMock.DeleteNamespacedFunc: method is nil but NetworkPolicyInterface.DeleteNamespaced was just called")
	}
	callInfo := struct {
		Namespace string
		Name      string
		Options   *metav1.DeleteOptions
	}{
		Namespace: namespace,
		Name:      name,
		Options:   options,
	}
	lockNetworkPolicyInterfaceMockDeleteNamespaced.Lock()
	mock.calls.DeleteNamespaced = append(mock.calls.DeleteNamespaced, callInfo)
	lockNetworkPolicyInterfaceMockDeleteNamespaced.Unlock()
	return mock.DeleteNamespacedFunc(namespace, name, options)
}

// DeleteNamespacedCalls gets all the calls that were made to DeleteNamespaced.
// Check the length with:
//     len(mockedNetworkPolicyInterface.DeleteNamespacedCalls())
func (mock *NetworkPolicyInterfaceMock) DeleteNamespacedCalls() []struct {
	Namespace string
	Name      string
	Options   *metav1.DeleteOptions
} {
	var calls []struct {
		Namespace string
		Name      string
		Options   *metav1.DeleteOptions
	}
	lockNetworkPolicyInterfaceMockDeleteNamespaced.RLock()
	calls = mock.calls.DeleteNamespaced
	lockNetworkPolicyInterfaceMockDeleteNamespaced.RUnlock()
	return calls
}

// Get calls GetFunc.
func (mock *NetworkPolicyInterfaceMock) Get(name string, opts metav1.GetOptions) (*v1.NetworkPolicy, error) {
	if mock.GetFunc == nil {
		panic("NetworkPolicyInterfaceMock.GetFunc: method is nil but NetworkPolicyInterface.Get was just called")
	}
	callInfo := struct {
		Name string
		Opts metav1.GetOptions
	}{
		Name: name,
		Opts: opts,
	}
	lockNetworkPolicyInterfaceMockGet.Lock()
	mock.calls.Get = append(mock.calls.Get, callInfo)
	lockNetworkPolicyInterfaceMockGet.Unlock()
	return mock.GetFunc(name, opts)
}

// GetCalls gets all the calls that were made to Get.
// Check the length with:
//     len(mockedNetworkPolicyInterface.GetCalls())
func (mock *NetworkPolicyInterfaceMock) GetCalls() []struct {
	Name string
	Opts metav1.GetOptions
} {
	var calls []struct {
		Name string
		Opts metav1.GetOptions
	}
	lockNetworkPolicyInterfaceMockGet.RLock()
	calls = mock.calls.Get
	lockNetworkPolicyInterfaceMockGet.RUnlock()
	return calls
}

// GetNamespaced calls GetNamespacedFunc.
func (mock *NetworkPolicyInterfaceMock) GetNamespaced(namespace string, name string, opts metav1.GetOptions) (*v1.NetworkPolicy, error) {
	if mock.GetNamespacedFunc == nil {
		panic("NetworkPolicyInterfaceMock.GetNamespacedFunc: method is nil but NetworkPolicyInterface.GetNamespaced was just called")
	}
	callInfo := struct {
		Namespace string
		Name      string
		Opts      metav1.GetOptions
	}{
		Namespace: namespace,
		Name:      name,
		Opts:      opts,
	}
	lockNetworkPolicyInterfaceMockGetNamespaced.Lock()
	mock.calls.GetNamespaced = append(mock.calls.GetNamespaced, callInfo)
	lockNetworkPolicyInterfaceMockGetNamespaced.Unlock()
	return mock.GetNamespacedFunc(namespace, name, opts)
}

// GetNamespacedCalls gets all the calls that were made to GetNamespaced.
// Check the length with:
//     len(mockedNetworkPolicyInterface.GetNamespacedCalls())
func (mock *NetworkPolicyInterfaceMock) GetNamespacedCalls() []struct {
	Namespace string
	Name      string
	Opts      metav1.GetOptions
} {
	var calls []struct {
		Namespace string
		Name      string
		Opts      metav1.GetOptions
	}
	lockNetworkPolicyInterfaceMockGetNamespaced.RLock()
	calls = mock.calls.GetNamespaced
	lockNetworkPolicyInterfaceMockGetNamespaced.RUnlock()
	return calls
}

// List calls ListFunc.
func (mock *NetworkPolicyInterfaceMock) List(opts metav1.ListOptions) (*v1.NetworkPolicyList, error) {
	if mock.ListFunc == nil {
		panic("NetworkPolicyInterfaceMock.ListFunc: method is nil but NetworkPolicyInterface.List was just called")
	}
	callInfo := struct {
		Opts metav1.ListOptions
	}{
		Opts: opts,
	}
	lockNetworkPolicyInterfaceMockList.Lock()
	mock.calls.List = append(mock.calls.List, callInfo)
	lockNetworkPolicyInterfaceMockList.Unlock()
	return mock.ListFunc(opts)
}

// ListCalls gets all the calls that were made to List.
// Check the length with:
//     len(mockedNetworkPolicyInterface.ListCalls())
func (mock *NetworkPolicyInterfaceMock) ListCalls() []struct {
	Opts metav1.ListOptions
} {
	var calls []struct {
		Opts metav1.ListOptions
	}
	lockNetworkPolicyInterfaceMockList.RLock()
	calls = mock.calls.List
	lockNetworkPolicyInterfaceMockList.RUnlock()
	return calls
}

// ListNamespaced calls ListNamespacedFunc.
func (mock *NetworkPolicyInterfaceMock) ListNamespaced(namespace string, opts metav1.ListOptions) (*v1.NetworkPolicyList, error) {
	if mock.ListNamespacedFunc == nil {
		panic("NetworkPolicyInterfaceMock.ListNamespacedFunc: method is nil but NetworkPolicyInterface.ListNamespaced was just called")
	}
	callInfo := struct {
		Namespace string
		Opts      metav1.ListOptions
	}{
		Namespace: namespace,
		Opts:      opts,
	}
	lockNetworkPolicyInterfaceMockListNamespaced.Lock()
	mock.calls.ListNamespaced = append(mock.calls.ListNamespaced, callInfo)
	lockNetworkPolicyInterfaceMockListNamespaced.Unlock()
	return mock.ListNamespacedFunc(namespace, opts)
}

// ListNamespacedCalls gets all the calls that were made to ListNamespaced.
// Check the length with:
//     len(mockedNetworkPolicyInterface.ListNamespacedCalls())
func (mock *NetworkPolicyInterfaceMock) ListNamespacedCalls() []struct {
	Namespace string
	Opts      metav1.ListOptions
} {
	var calls []struct {
		Namespace string
		Opts      metav1.ListOptions
	}
	lockNetworkPolicyInterfaceMockListNamespaced.RLock()
	calls = mock.calls.ListNamespaced
	lockNetworkPolicyInterfaceMockListNamespaced.RUnlock()
	return calls
}

// ObjectClient calls ObjectClientFunc.
func (mock *NetworkPolicyInterfaceMock) ObjectClient() *objectclient.ObjectClient {
	if mock.ObjectClientFunc == nil {
		panic("NetworkPolicyInterfaceMock.ObjectClientFunc: method is nil but NetworkPolicyInterface.ObjectClient was just called")
	}
	callInfo := struct {
	}{}
	lockNetworkPolicyInterfaceMockObjectClient.Lock()
	mock.calls.ObjectClient = append(mock.calls.ObjectClient, callInfo)
	lockNetworkPolicyInterfaceMockObjectClient.Unlock()
	return mock.ObjectClientFunc()
}

// ObjectClientCalls gets all the calls that were made to ObjectClient.
// Check the length with:
//     len(mockedNetworkPolicyInterface.ObjectClientCalls())
func (mock *NetworkPolicyInterfaceMock) ObjectClientCalls() []struct {
} {
	var calls []struct {
	}
	lockNetworkPolicyInterfaceMockObjectClient.RLock()
	calls = mock.calls.ObjectClient
	lockNetworkPolicyInterfaceMockObjectClient.RUnlock()
	return calls
}

// Update calls UpdateFunc.
func (mock *NetworkPolicyInterfaceMock) Update(in1 *v1.NetworkPolicy) (*v1.NetworkPolicy, error) {
	if mock.UpdateFunc == nil {
		panic("NetworkPolicyInterfaceMock.UpdateFunc: method is nil but NetworkPolicyInterface.Update was just called")
	}
	callInfo := struct {
		In1 *v1.NetworkPolicy
	}{
		In1: in1,
	}
	lockNetworkPolicyInterfaceMockUpdate.Lock()
	mock.calls.Update = append(mock.calls.Update, callInfo)
	lockNetworkPolicyInterfaceMockUpdate.Unlock()
	return mock.UpdateFunc(in1)
}

// UpdateCalls gets all the calls that were made to Update.
// Check the length with:
//     len(mockedNetworkPolicyInterface.UpdateCalls())
func (mock *NetworkPolicyInterfaceMock) UpdateCalls() []struct {
	In1 *v1.NetworkPolicy
} {
	var calls []struct {
		In1 *v1.NetworkPolicy
	}
	lockNetworkPolicyInterfaceMockUpdate.RLock()
	calls = mock.calls.Update
	lockNetworkPolicyInterfaceMockUpdate.RUnlock()
	return calls
}

// Watch calls WatchFunc.
func (mock *NetworkPolicyInterfaceMock) Watch(opts metav1.ListOptions) (watch.Interface, error) {
	if mock.WatchFunc == nil {
		panic("NetworkPolicyInterfaceMock.WatchFunc: method is nil but NetworkPolicyInterface.Watch was just called")
	}
	callInfo := struct {
		Opts metav1.ListOptions
	}{
		Opts: opts,
	}
	lockNetworkPolicyInterfaceMockWatch.Lock()
	mock.calls.Watch = append(mock.calls.Watch, callInfo)
	lockNetworkPolicyInterfaceMockWatch.Unlock()
	return mock.WatchFunc(opts)
}

// WatchCalls gets all the calls that were made to Watch.
// Check the length with:
//     len(mockedNetworkPolicyInterface.WatchCalls())
func (mock *NetworkPolicyInterfaceMock) WatchCalls() []struct {
	Opts metav1.ListOptions
} {
	var calls []struct {
		Opts metav1.ListOptions
	}
	lockNetworkPolicyInterfaceMockWatch.RLock()
	calls = mock.calls.Watch
	lockNetworkPolicyInterfaceMockWatch.RUnlock()
	return calls
}

var (
	lockNetworkPoliciesGetterMockNetworkPolicies sync.RWMutex
)

// Ensure, that NetworkPoliciesGetterMock does implement v11.NetworkPoliciesGetter.
// If this is not the case, regenerate this file with moq.
var _ v11.NetworkPoliciesGetter = &NetworkPoliciesGetterMock{}

// NetworkPoliciesGetterMock is a mock implementation of v11.NetworkPoliciesGetter.
//
//     func TestSomethingThatUsesNetworkPoliciesGetter(t *testing.T) {
//
//         // make and configure a mocked v11.NetworkPoliciesGetter
//         mockedNetworkPoliciesGetter := &NetworkPoliciesGetterMock{
//             NetworkPoliciesFunc: func(namespace string) v11.NetworkPolicyInterface {
// 	               panic("mock out the NetworkPolicies method")
//             },
//         }
//
//         // use mockedNetworkPoliciesGetter in code that requires v11.NetworkPoliciesGetter
//         // and then make assertions.
//
//     }
type NetworkPoliciesGetterMock struct {
	// NetworkPoliciesFunc mocks the NetworkPolicies method.
	NetworkPoliciesFunc func(namespace string) v11.NetworkPolicyInterface

	// calls tracks calls to the methods.
	calls struct {
		// NetworkPolicies holds details about calls to the NetworkPolicies method.
		NetworkPolicies []struct {
			// Namespace is the namespace argument value.
			Namespace string
		}
	}
}

// NetworkPolicies calls NetworkPoliciesFunc.
func (mock *NetworkPoliciesGetterMock) NetworkPolicies(namespace string) v11.NetworkPolicyInterface {
	if mock.NetworkPoliciesFunc == nil {
		panic("NetworkPoliciesGetterMock.NetworkPoliciesFunc: method is nil but NetworkPoliciesGetter.NetworkPolicies was just called")
	}
	callInfo := struct {
		Namespace string
	}{
		Namespace: namespace,
	}
	lockNetworkPoliciesGetterMockNetworkPolicies.Lock()
	mock.calls.NetworkPolicies = append(mock.calls.NetworkPolicies, callInfo)
	lockNetworkPoliciesGetterMockNetworkPolicies.Unlock()
	return mock.NetworkPoliciesFunc(namespace)
}

// NetworkPoliciesCalls gets all the calls that were made to NetworkPolicies.
// Check the length with:
//     len(mockedNetworkPoliciesGetter.NetworkPoliciesCalls())
func (mock *NetworkPoliciesGetterMock) NetworkPoliciesCalls() []struct {
	Namespace string
} {
	var calls []struct {
		Namespace string
	}
	lockNetworkPoliciesGetterMockNetworkPolicies.RLock()
	calls = mock.calls.NetworkPolicies
	lockNetworkPoliciesGetterMockNetworkPolicies.RUnlock()
	return calls
}
