// Code generated by moq; DO NOT EDIT.
// github.com/matryer/moq

package fakes

import (
	"context"
	"sync"
	"time"

	"github.com/rancher/norman/controller"
	"github.com/rancher/norman/objectclient"
	v1beta11 "github.com/rancher/rancher/pkg/generated/norman/policy/v1beta1"
	"k8s.io/api/policy/v1beta1"
	metav1 "k8s.io/apimachinery/pkg/apis/meta/v1"
	"k8s.io/apimachinery/pkg/labels"
	"k8s.io/apimachinery/pkg/watch"
	"k8s.io/client-go/tools/cache"
)

var (
	lockPodSecurityPolicyListerMockGet  sync.RWMutex
	lockPodSecurityPolicyListerMockList sync.RWMutex
)

// Ensure, that PodSecurityPolicyListerMock does implement v1beta11.PodSecurityPolicyLister.
// If this is not the case, regenerate this file with moq.
var _ v1beta11.PodSecurityPolicyLister = &PodSecurityPolicyListerMock{}

// PodSecurityPolicyListerMock is a mock implementation of v1beta11.PodSecurityPolicyLister.
//
//     func TestSomethingThatUsesPodSecurityPolicyLister(t *testing.T) {
//
//         // make and configure a mocked v1beta11.PodSecurityPolicyLister
//         mockedPodSecurityPolicyLister := &PodSecurityPolicyListerMock{
//             GetFunc: func(namespace string, name string) (*v1beta1.PodSecurityPolicy, error) {
// 	               panic("mock out the Get method")
//             },
//             ListFunc: func(namespace string, selector labels.Selector) ([]*v1beta1.PodSecurityPolicy, error) {
// 	               panic("mock out the List method")
//             },
//         }
//
//         // use mockedPodSecurityPolicyLister in code that requires v1beta11.PodSecurityPolicyLister
//         // and then make assertions.
//
//     }
type PodSecurityPolicyListerMock struct {
	// GetFunc mocks the Get method.
	GetFunc func(namespace string, name string) (*v1beta1.PodSecurityPolicy, error)

	// ListFunc mocks the List method.
	ListFunc func(namespace string, selector labels.Selector) ([]*v1beta1.PodSecurityPolicy, error)

	// calls tracks calls to the methods.
	calls struct {
		// Get holds details about calls to the Get method.
		Get []struct {
			// Namespace is the namespace argument value.
			Namespace string
			// Name is the name argument value.
			Name string
		}
		// List holds details about calls to the List method.
		List []struct {
			// Namespace is the namespace argument value.
			Namespace string
			// Selector is the selector argument value.
			Selector labels.Selector
		}
	}
}

// Get calls GetFunc.
func (mock *PodSecurityPolicyListerMock) Get(namespace string, name string) (*v1beta1.PodSecurityPolicy, error) {
	if mock.GetFunc == nil {
		panic("PodSecurityPolicyListerMock.GetFunc: method is nil but PodSecurityPolicyLister.Get was just called")
	}
	callInfo := struct {
		Namespace string
		Name      string
	}{
		Namespace: namespace,
		Name:      name,
	}
	lockPodSecurityPolicyListerMockGet.Lock()
	mock.calls.Get = append(mock.calls.Get, callInfo)
	lockPodSecurityPolicyListerMockGet.Unlock()
	return mock.GetFunc(namespace, name)
}

// GetCalls gets all the calls that were made to Get.
// Check the length with:
//     len(mockedPodSecurityPolicyLister.GetCalls())
func (mock *PodSecurityPolicyListerMock) GetCalls() []struct {
	Namespace string
	Name      string
} {
	var calls []struct {
		Namespace string
		Name      string
	}
	lockPodSecurityPolicyListerMockGet.RLock()
	calls = mock.calls.Get
	lockPodSecurityPolicyListerMockGet.RUnlock()
	return calls
}

// List calls ListFunc.
func (mock *PodSecurityPolicyListerMock) List(namespace string, selector labels.Selector) ([]*v1beta1.PodSecurityPolicy, error) {
	if mock.ListFunc == nil {
		panic("PodSecurityPolicyListerMock.ListFunc: method is nil but PodSecurityPolicyLister.List was just called")
	}
	callInfo := struct {
		Namespace string
		Selector  labels.Selector
	}{
		Namespace: namespace,
		Selector:  selector,
	}
	lockPodSecurityPolicyListerMockList.Lock()
	mock.calls.List = append(mock.calls.List, callInfo)
	lockPodSecurityPolicyListerMockList.Unlock()
	return mock.ListFunc(namespace, selector)
}

// ListCalls gets all the calls that were made to List.
// Check the length with:
//     len(mockedPodSecurityPolicyLister.ListCalls())
func (mock *PodSecurityPolicyListerMock) ListCalls() []struct {
	Namespace string
	Selector  labels.Selector
} {
	var calls []struct {
		Namespace string
		Selector  labels.Selector
	}
	lockPodSecurityPolicyListerMockList.RLock()
	calls = mock.calls.List
	lockPodSecurityPolicyListerMockList.RUnlock()
	return calls
}

var (
	lockPodSecurityPolicyControllerMockAddClusterScopedFeatureHandler sync.RWMutex
	lockPodSecurityPolicyControllerMockAddClusterScopedHandler        sync.RWMutex
	lockPodSecurityPolicyControllerMockAddFeatureHandler              sync.RWMutex
	lockPodSecurityPolicyControllerMockAddHandler                     sync.RWMutex
	lockPodSecurityPolicyControllerMockEnqueue                        sync.RWMutex
	lockPodSecurityPolicyControllerMockEnqueueAfter                   sync.RWMutex
	lockPodSecurityPolicyControllerMockGeneric                        sync.RWMutex
	lockPodSecurityPolicyControllerMockInformer                       sync.RWMutex
	lockPodSecurityPolicyControllerMockLister                         sync.RWMutex
)

// Ensure, that PodSecurityPolicyControllerMock does implement v1beta11.PodSecurityPolicyController.
// If this is not the case, regenerate this file with moq.
var _ v1beta11.PodSecurityPolicyController = &PodSecurityPolicyControllerMock{}

// PodSecurityPolicyControllerMock is a mock implementation of v1beta11.PodSecurityPolicyController.
//
//     func TestSomethingThatUsesPodSecurityPolicyController(t *testing.T) {
//
//         // make and configure a mocked v1beta11.PodSecurityPolicyController
//         mockedPodSecurityPolicyController := &PodSecurityPolicyControllerMock{
//             AddClusterScopedFeatureHandlerFunc: func(ctx context.Context, enabled func() bool, name string, clusterName string, handler v1beta11.PodSecurityPolicyHandlerFunc)  {
// 	               panic("mock out the AddClusterScopedFeatureHandler method")
//             },
//             AddClusterScopedHandlerFunc: func(ctx context.Context, name string, clusterName string, handler v1beta11.PodSecurityPolicyHandlerFunc)  {
// 	               panic("mock out the AddClusterScopedHandler method")
//             },
//             AddFeatureHandlerFunc: func(ctx context.Context, enabled func() bool, name string, syncMoqParam v1beta11.PodSecurityPolicyHandlerFunc)  {
// 	               panic("mock out the AddFeatureHandler method")
//             },
//             AddHandlerFunc: func(ctx context.Context, name string, handler v1beta11.PodSecurityPolicyHandlerFunc)  {
// 	               panic("mock out the AddHandler method")
//             },
//             EnqueueFunc: func(namespace string, name string)  {
// 	               panic("mock out the Enqueue method")
//             },
//             EnqueueAfterFunc: func(namespace string, name string, after time.Duration)  {
// 	               panic("mock out the EnqueueAfter method")
//             },
//             GenericFunc: func() controller.GenericController {
// 	               panic("mock out the Generic method")
//             },
//             InformerFunc: func() cache.SharedIndexInformer {
// 	               panic("mock out the Informer method")
//             },
//             ListerFunc: func() v1beta11.PodSecurityPolicyLister {
// 	               panic("mock out the Lister method")
//             },
//         }
//
//         // use mockedPodSecurityPolicyController in code that requires v1beta11.PodSecurityPolicyController
//         // and then make assertions.
//
//     }
type PodSecurityPolicyControllerMock struct {
	// AddClusterScopedFeatureHandlerFunc mocks the AddClusterScopedFeatureHandler method.
	AddClusterScopedFeatureHandlerFunc func(ctx context.Context, enabled func() bool, name string, clusterName string, handler v1beta11.PodSecurityPolicyHandlerFunc)

	// AddClusterScopedHandlerFunc mocks the AddClusterScopedHandler method.
	AddClusterScopedHandlerFunc func(ctx context.Context, name string, clusterName string, handler v1beta11.PodSecurityPolicyHandlerFunc)

	// AddFeatureHandlerFunc mocks the AddFeatureHandler method.
	AddFeatureHandlerFunc func(ctx context.Context, enabled func() bool, name string, syncMoqParam v1beta11.PodSecurityPolicyHandlerFunc)

	// AddHandlerFunc mocks the AddHandler method.
	AddHandlerFunc func(ctx context.Context, name string, handler v1beta11.PodSecurityPolicyHandlerFunc)

	// EnqueueFunc mocks the Enqueue method.
	EnqueueFunc func(namespace string, name string)

	// EnqueueAfterFunc mocks the EnqueueAfter method.
	EnqueueAfterFunc func(namespace string, name string, after time.Duration)

	// GenericFunc mocks the Generic method.
	GenericFunc func() controller.GenericController

	// InformerFunc mocks the Informer method.
	InformerFunc func() cache.SharedIndexInformer

	// ListerFunc mocks the Lister method.
	ListerFunc func() v1beta11.PodSecurityPolicyLister

	// calls tracks calls to the methods.
	calls struct {
		// AddClusterScopedFeatureHandler holds details about calls to the AddClusterScopedFeatureHandler method.
		AddClusterScopedFeatureHandler []struct {
			// Ctx is the ctx argument value.
			Ctx context.Context
			// Enabled is the enabled argument value.
			Enabled func() bool
			// Name is the name argument value.
			Name string
			// ClusterName is the clusterName argument value.
			ClusterName string
			// Handler is the handler argument value.
			Handler v1beta11.PodSecurityPolicyHandlerFunc
		}
		// AddClusterScopedHandler holds details about calls to the AddClusterScopedHandler method.
		AddClusterScopedHandler []struct {
			// Ctx is the ctx argument value.
			Ctx context.Context
			// Name is the name argument value.
			Name string
			// ClusterName is the clusterName argument value.
			ClusterName string
			// Handler is the handler argument value.
			Handler v1beta11.PodSecurityPolicyHandlerFunc
		}
		// AddFeatureHandler holds details about calls to the AddFeatureHandler method.
		AddFeatureHandler []struct {
			// Ctx is the ctx argument value.
			Ctx context.Context
			// Enabled is the enabled argument value.
			Enabled func() bool
			// Name is the name argument value.
			Name string
			// Sync is the sync argument value.
			Sync v1beta11.PodSecurityPolicyHandlerFunc
		}
		// AddHandler holds details about calls to the AddHandler method.
		AddHandler []struct {
			// Ctx is the ctx argument value.
			Ctx context.Context
			// Name is the name argument value.
			Name string
			// Handler is the handler argument value.
			Handler v1beta11.PodSecurityPolicyHandlerFunc
		}
		// Enqueue holds details about calls to the Enqueue method.
		Enqueue []struct {
			// Namespace is the namespace argument value.
			Namespace string
			// Name is the name argument value.
			Name string
		}
		// EnqueueAfter holds details about calls to the EnqueueAfter method.
		EnqueueAfter []struct {
			// Namespace is the namespace argument value.
			Namespace string
			// Name is the name argument value.
			Name string
			// After is the after argument value.
			After time.Duration
		}
		// Generic holds details about calls to the Generic method.
		Generic []struct {
		}
		// Informer holds details about calls to the Informer method.
		Informer []struct {
		}
		// Lister holds details about calls to the Lister method.
		Lister []struct {
		}
	}
}

// AddClusterScopedFeatureHandler calls AddClusterScopedFeatureHandlerFunc.
func (mock *PodSecurityPolicyControllerMock) AddClusterScopedFeatureHandler(ctx context.Context, enabled func() bool, name string, clusterName string, handler v1beta11.PodSecurityPolicyHandlerFunc) {
	if mock.AddClusterScopedFeatureHandlerFunc == nil {
		panic("PodSecurityPolicyControllerMock.AddClusterScopedFeatureHandlerFunc: method is nil but PodSecurityPolicyController.AddClusterScopedFeatureHandler was just called")
	}
	callInfo := struct {
		Ctx         context.Context
		Enabled     func() bool
		Name        string
		ClusterName string
		Handler     v1beta11.PodSecurityPolicyHandlerFunc
	}{
		Ctx:         ctx,
		Enabled:     enabled,
		Name:        name,
		ClusterName: clusterName,
		Handler:     handler,
	}
	lockPodSecurityPolicyControllerMockAddClusterScopedFeatureHandler.Lock()
	mock.calls.AddClusterScopedFeatureHandler = append(mock.calls.AddClusterScopedFeatureHandler, callInfo)
	lockPodSecurityPolicyControllerMockAddClusterScopedFeatureHandler.Unlock()
	mock.AddClusterScopedFeatureHandlerFunc(ctx, enabled, name, clusterName, handler)
}

// AddClusterScopedFeatureHandlerCalls gets all the calls that were made to AddClusterScopedFeatureHandler.
// Check the length with:
//     len(mockedPodSecurityPolicyController.AddClusterScopedFeatureHandlerCalls())
func (mock *PodSecurityPolicyControllerMock) AddClusterScopedFeatureHandlerCalls() []struct {
	Ctx         context.Context
	Enabled     func() bool
	Name        string
	ClusterName string
	Handler     v1beta11.PodSecurityPolicyHandlerFunc
} {
	var calls []struct {
		Ctx         context.Context
		Enabled     func() bool
		Name        string
		ClusterName string
		Handler     v1beta11.PodSecurityPolicyHandlerFunc
	}
	lockPodSecurityPolicyControllerMockAddClusterScopedFeatureHandler.RLock()
	calls = mock.calls.AddClusterScopedFeatureHandler
	lockPodSecurityPolicyControllerMockAddClusterScopedFeatureHandler.RUnlock()
	return calls
}

// AddClusterScopedHandler calls AddClusterScopedHandlerFunc.
func (mock *PodSecurityPolicyControllerMock) AddClusterScopedHandler(ctx context.Context, name string, clusterName string, handler v1beta11.PodSecurityPolicyHandlerFunc) {
	if mock.AddClusterScopedHandlerFunc == nil {
		panic("PodSecurityPolicyControllerMock.AddClusterScopedHandlerFunc: method is nil but PodSecurityPolicyController.AddClusterScopedHandler was just called")
	}
	callInfo := struct {
		Ctx         context.Context
		Name        string
		ClusterName string
		Handler     v1beta11.PodSecurityPolicyHandlerFunc
	}{
		Ctx:         ctx,
		Name:        name,
		ClusterName: clusterName,
		Handler:     handler,
	}
	lockPodSecurityPolicyControllerMockAddClusterScopedHandler.Lock()
	mock.calls.AddClusterScopedHandler = append(mock.calls.AddClusterScopedHandler, callInfo)
	lockPodSecurityPolicyControllerMockAddClusterScopedHandler.Unlock()
	mock.AddClusterScopedHandlerFunc(ctx, name, clusterName, handler)
}

// AddClusterScopedHandlerCalls gets all the calls that were made to AddClusterScopedHandler.
// Check the length with:
//     len(mockedPodSecurityPolicyController.AddClusterScopedHandlerCalls())
func (mock *PodSecurityPolicyControllerMock) AddClusterScopedHandlerCalls() []struct {
	Ctx         context.Context
	Name        string
	ClusterName string
	Handler     v1beta11.PodSecurityPolicyHandlerFunc
} {
	var calls []struct {
		Ctx         context.Context
		Name        string
		ClusterName string
		Handler     v1beta11.PodSecurityPolicyHandlerFunc
	}
	lockPodSecurityPolicyControllerMockAddClusterScopedHandler.RLock()
	calls = mock.calls.AddClusterScopedHandler
	lockPodSecurityPolicyControllerMockAddClusterScopedHandler.RUnlock()
	return calls
}

// AddFeatureHandler calls AddFeatureHandlerFunc.
func (mock *PodSecurityPolicyControllerMock) AddFeatureHandler(ctx context.Context, enabled func() bool, name string, syncMoqParam v1beta11.PodSecurityPolicyHandlerFunc) {
	if mock.AddFeatureHandlerFunc == nil {
		panic("PodSecurityPolicyControllerMock.AddFeatureHandlerFunc: method is nil but PodSecurityPolicyController.AddFeatureHandler was just called")
	}
	callInfo := struct {
		Ctx     context.Context
		Enabled func() bool
		Name    string
		Sync    v1beta11.PodSecurityPolicyHandlerFunc
	}{
		Ctx:     ctx,
		Enabled: enabled,
		Name:    name,
		Sync:    syncMoqParam,
	}
	lockPodSecurityPolicyControllerMockAddFeatureHandler.Lock()
	mock.calls.AddFeatureHandler = append(mock.calls.AddFeatureHandler, callInfo)
	lockPodSecurityPolicyControllerMockAddFeatureHandler.Unlock()
	mock.AddFeatureHandlerFunc(ctx, enabled, name, syncMoqParam)
}

// AddFeatureHandlerCalls gets all the calls that were made to AddFeatureHandler.
// Check the length with:
//     len(mockedPodSecurityPolicyController.AddFeatureHandlerCalls())
func (mock *PodSecurityPolicyControllerMock) AddFeatureHandlerCalls() []struct {
	Ctx     context.Context
	Enabled func() bool
	Name    string
	Sync    v1beta11.PodSecurityPolicyHandlerFunc
} {
	var calls []struct {
		Ctx     context.Context
		Enabled func() bool
		Name    string
		Sync    v1beta11.PodSecurityPolicyHandlerFunc
	}
	lockPodSecurityPolicyControllerMockAddFeatureHandler.RLock()
	calls = mock.calls.AddFeatureHandler
	lockPodSecurityPolicyControllerMockAddFeatureHandler.RUnlock()
	return calls
}

// AddHandler calls AddHandlerFunc.
func (mock *PodSecurityPolicyControllerMock) AddHandler(ctx context.Context, name string, handler v1beta11.PodSecurityPolicyHandlerFunc) {
	if mock.AddHandlerFunc == nil {
		panic("PodSecurityPolicyControllerMock.AddHandlerFunc: method is nil but PodSecurityPolicyController.AddHandler was just called")
	}
	callInfo := struct {
		Ctx     context.Context
		Name    string
		Handler v1beta11.PodSecurityPolicyHandlerFunc
	}{
		Ctx:     ctx,
		Name:    name,
		Handler: handler,
	}
	lockPodSecurityPolicyControllerMockAddHandler.Lock()
	mock.calls.AddHandler = append(mock.calls.AddHandler, callInfo)
	lockPodSecurityPolicyControllerMockAddHandler.Unlock()
	mock.AddHandlerFunc(ctx, name, handler)
}

// AddHandlerCalls gets all the calls that were made to AddHandler.
// Check the length with:
//     len(mockedPodSecurityPolicyController.AddHandlerCalls())
func (mock *PodSecurityPolicyControllerMock) AddHandlerCalls() []struct {
	Ctx     context.Context
	Name    string
	Handler v1beta11.PodSecurityPolicyHandlerFunc
} {
	var calls []struct {
		Ctx     context.Context
		Name    string
		Handler v1beta11.PodSecurityPolicyHandlerFunc
	}
	lockPodSecurityPolicyControllerMockAddHandler.RLock()
	calls = mock.calls.AddHandler
	lockPodSecurityPolicyControllerMockAddHandler.RUnlock()
	return calls
}

// Enqueue calls EnqueueFunc.
func (mock *PodSecurityPolicyControllerMock) Enqueue(namespace string, name string) {
	if mock.EnqueueFunc == nil {
		panic("PodSecurityPolicyControllerMock.EnqueueFunc: method is nil but PodSecurityPolicyController.Enqueue was just called")
	}
	callInfo := struct {
		Namespace string
		Name      string
	}{
		Namespace: namespace,
		Name:      name,
	}
	lockPodSecurityPolicyControllerMockEnqueue.Lock()
	mock.calls.Enqueue = append(mock.calls.Enqueue, callInfo)
	lockPodSecurityPolicyControllerMockEnqueue.Unlock()
	mock.EnqueueFunc(namespace, name)
}

// EnqueueCalls gets all the calls that were made to Enqueue.
// Check the length with:
//     len(mockedPodSecurityPolicyController.EnqueueCalls())
func (mock *PodSecurityPolicyControllerMock) EnqueueCalls() []struct {
	Namespace string
	Name      string
} {
	var calls []struct {
		Namespace string
		Name      string
	}
	lockPodSecurityPolicyControllerMockEnqueue.RLock()
	calls = mock.calls.Enqueue
	lockPodSecurityPolicyControllerMockEnqueue.RUnlock()
	return calls
}

// EnqueueAfter calls EnqueueAfterFunc.
func (mock *PodSecurityPolicyControllerMock) EnqueueAfter(namespace string, name string, after time.Duration) {
	if mock.EnqueueAfterFunc == nil {
		panic("PodSecurityPolicyControllerMock.EnqueueAfterFunc: method is nil but PodSecurityPolicyController.EnqueueAfter was just called")
	}
	callInfo := struct {
		Namespace string
		Name      string
		After     time.Duration
	}{
		Namespace: namespace,
		Name:      name,
		After:     after,
	}
	lockPodSecurityPolicyControllerMockEnqueueAfter.Lock()
	mock.calls.EnqueueAfter = append(mock.calls.EnqueueAfter, callInfo)
	lockPodSecurityPolicyControllerMockEnqueueAfter.Unlock()
	mock.EnqueueAfterFunc(namespace, name, after)
}

// EnqueueAfterCalls gets all the calls that were made to EnqueueAfter.
// Check the length with:
//     len(mockedPodSecurityPolicyController.EnqueueAfterCalls())
func (mock *PodSecurityPolicyControllerMock) EnqueueAfterCalls() []struct {
	Namespace string
	Name      string
	After     time.Duration
} {
	var calls []struct {
		Namespace string
		Name      string
		After     time.Duration
	}
	lockPodSecurityPolicyControllerMockEnqueueAfter.RLock()
	calls = mock.calls.EnqueueAfter
	lockPodSecurityPolicyControllerMockEnqueueAfter.RUnlock()
	return calls
}

// Generic calls GenericFunc.
func (mock *PodSecurityPolicyControllerMock) Generic() controller.GenericController {
	if mock.GenericFunc == nil {
		panic("PodSecurityPolicyControllerMock.GenericFunc: method is nil but PodSecurityPolicyController.Generic was just called")
	}
	callInfo := struct {
	}{}
	lockPodSecurityPolicyControllerMockGeneric.Lock()
	mock.calls.Generic = append(mock.calls.Generic, callInfo)
	lockPodSecurityPolicyControllerMockGeneric.Unlock()
	return mock.GenericFunc()
}

// GenericCalls gets all the calls that were made to Generic.
// Check the length with:
//     len(mockedPodSecurityPolicyController.GenericCalls())
func (mock *PodSecurityPolicyControllerMock) GenericCalls() []struct {
} {
	var calls []struct {
	}
	lockPodSecurityPolicyControllerMockGeneric.RLock()
	calls = mock.calls.Generic
	lockPodSecurityPolicyControllerMockGeneric.RUnlock()
	return calls
}

// Informer calls InformerFunc.
func (mock *PodSecurityPolicyControllerMock) Informer() cache.SharedIndexInformer {
	if mock.InformerFunc == nil {
		panic("PodSecurityPolicyControllerMock.InformerFunc: method is nil but PodSecurityPolicyController.Informer was just called")
	}
	callInfo := struct {
	}{}
	lockPodSecurityPolicyControllerMockInformer.Lock()
	mock.calls.Informer = append(mock.calls.Informer, callInfo)
	lockPodSecurityPolicyControllerMockInformer.Unlock()
	return mock.InformerFunc()
}

// InformerCalls gets all the calls that were made to Informer.
// Check the length with:
//     len(mockedPodSecurityPolicyController.InformerCalls())
func (mock *PodSecurityPolicyControllerMock) InformerCalls() []struct {
} {
	var calls []struct {
	}
	lockPodSecurityPolicyControllerMockInformer.RLock()
	calls = mock.calls.Informer
	lockPodSecurityPolicyControllerMockInformer.RUnlock()
	return calls
}

// Lister calls ListerFunc.
func (mock *PodSecurityPolicyControllerMock) Lister() v1beta11.PodSecurityPolicyLister {
	if mock.ListerFunc == nil {
		panic("PodSecurityPolicyControllerMock.ListerFunc: method is nil but PodSecurityPolicyController.Lister was just called")
	}
	callInfo := struct {
	}{}
	lockPodSecurityPolicyControllerMockLister.Lock()
	mock.calls.Lister = append(mock.calls.Lister, callInfo)
	lockPodSecurityPolicyControllerMockLister.Unlock()
	return mock.ListerFunc()
}

// ListerCalls gets all the calls that were made to Lister.
// Check the length with:
//     len(mockedPodSecurityPolicyController.ListerCalls())
func (mock *PodSecurityPolicyControllerMock) ListerCalls() []struct {
} {
	var calls []struct {
	}
	lockPodSecurityPolicyControllerMockLister.RLock()
	calls = mock.calls.Lister
	lockPodSecurityPolicyControllerMockLister.RUnlock()
	return calls
}

var (
	lockPodSecurityPolicyInterfaceMockAddClusterScopedFeatureHandler   sync.RWMutex
	lockPodSecurityPolicyInterfaceMockAddClusterScopedFeatureLifecycle sync.RWMutex
	lockPodSecurityPolicyInterfaceMockAddClusterScopedHandler          sync.RWMutex
	lockPodSecurityPolicyInterfaceMockAddClusterScopedLifecycle        sync.RWMutex
	lockPodSecurityPolicyInterfaceMockAddFeatureHandler                sync.RWMutex
	lockPodSecurityPolicyInterfaceMockAddFeatureLifecycle              sync.RWMutex
	lockPodSecurityPolicyInterfaceMockAddHandler                       sync.RWMutex
	lockPodSecurityPolicyInterfaceMockAddLifecycle                     sync.RWMutex
	lockPodSecurityPolicyInterfaceMockController                       sync.RWMutex
	lockPodSecurityPolicyInterfaceMockCreate                           sync.RWMutex
	lockPodSecurityPolicyInterfaceMockDelete                           sync.RWMutex
	lockPodSecurityPolicyInterfaceMockDeleteCollection                 sync.RWMutex
	lockPodSecurityPolicyInterfaceMockDeleteNamespaced                 sync.RWMutex
	lockPodSecurityPolicyInterfaceMockGet                              sync.RWMutex
	lockPodSecurityPolicyInterfaceMockGetNamespaced                    sync.RWMutex
	lockPodSecurityPolicyInterfaceMockList                             sync.RWMutex
	lockPodSecurityPolicyInterfaceMockListNamespaced                   sync.RWMutex
	lockPodSecurityPolicyInterfaceMockObjectClient                     sync.RWMutex
	lockPodSecurityPolicyInterfaceMockUpdate                           sync.RWMutex
	lockPodSecurityPolicyInterfaceMockWatch                            sync.RWMutex
)

// Ensure, that PodSecurityPolicyInterfaceMock does implement v1beta11.PodSecurityPolicyInterface.
// If this is not the case, regenerate this file with moq.
var _ v1beta11.PodSecurityPolicyInterface = &PodSecurityPolicyInterfaceMock{}

// PodSecurityPolicyInterfaceMock is a mock implementation of v1beta11.PodSecurityPolicyInterface.
//
//     func TestSomethingThatUsesPodSecurityPolicyInterface(t *testing.T) {
//
//         // make and configure a mocked v1beta11.PodSecurityPolicyInterface
//         mockedPodSecurityPolicyInterface := &PodSecurityPolicyInterfaceMock{
//             AddClusterScopedFeatureHandlerFunc: func(ctx context.Context, enabled func() bool, name string, clusterName string, syncMoqParam v1beta11.PodSecurityPolicyHandlerFunc)  {
// 	               panic("mock out the AddClusterScopedFeatureHandler method")
//             },
//             AddClusterScopedFeatureLifecycleFunc: func(ctx context.Context, enabled func() bool, name string, clusterName string, lifecycle v1beta11.PodSecurityPolicyLifecycle)  {
// 	               panic("mock out the AddClusterScopedFeatureLifecycle method")
//             },
//             AddClusterScopedHandlerFunc: func(ctx context.Context, name string, clusterName string, syncMoqParam v1beta11.PodSecurityPolicyHandlerFunc)  {
// 	               panic("mock out the AddClusterScopedHandler method")
//             },
//             AddClusterScopedLifecycleFunc: func(ctx context.Context, name string, clusterName string, lifecycle v1beta11.PodSecurityPolicyLifecycle)  {
// 	               panic("mock out the AddClusterScopedLifecycle method")
//             },
//             AddFeatureHandlerFunc: func(ctx context.Context, enabled func() bool, name string, syncMoqParam v1beta11.PodSecurityPolicyHandlerFunc)  {
// 	               panic("mock out the AddFeatureHandler method")
//             },
//             AddFeatureLifecycleFunc: func(ctx context.Context, enabled func() bool, name string, lifecycle v1beta11.PodSecurityPolicyLifecycle)  {
// 	               panic("mock out the AddFeatureLifecycle method")
//             },
//             AddHandlerFunc: func(ctx context.Context, name string, syncMoqParam v1beta11.PodSecurityPolicyHandlerFunc)  {
// 	               panic("mock out the AddHandler method")
//             },
//             AddLifecycleFunc: func(ctx context.Context, name string, lifecycle v1beta11.PodSecurityPolicyLifecycle)  {
// 	               panic("mock out the AddLifecycle method")
//             },
//             ControllerFunc: func() v1beta11.PodSecurityPolicyController {
// 	               panic("mock out the Controller method")
//             },
//             CreateFunc: func(in1 *v1beta1.PodSecurityPolicy) (*v1beta1.PodSecurityPolicy, error) {
// 	               panic("mock out the Create method")
//             },
//             DeleteFunc: func(name string, options *metav1.DeleteOptions) error {
// 	               panic("mock out the Delete method")
//             },
//             DeleteCollectionFunc: func(deleteOpts *metav1.DeleteOptions, listOpts metav1.ListOptions) error {
// 	               panic("mock out the DeleteCollection method")
//             },
//             DeleteNamespacedFunc: func(namespace string, name string, options *metav1.DeleteOptions) error {
// 	               panic("mock out the DeleteNamespaced method")
//             },
//             GetFunc: func(name string, opts metav1.GetOptions) (*v1beta1.PodSecurityPolicy, error) {
// 	               panic("mock out the Get method")
//             },
//             GetNamespacedFunc: func(namespace string, name string, opts metav1.GetOptions) (*v1beta1.PodSecurityPolicy, error) {
// 	               panic("mock out the GetNamespaced method")
//             },
//             ListFunc: func(opts metav1.ListOptions) (*v1beta1.PodSecurityPolicyList, error) {
// 	               panic("mock out the List method")
//             },
//             ListNamespacedFunc: func(namespace string, opts metav1.ListOptions) (*v1beta1.PodSecurityPolicyList, error) {
// 	               panic("mock out the ListNamespaced method")
//             },
//             ObjectClientFunc: func() *objectclient.ObjectClient {
// 	               panic("mock out the ObjectClient method")
//             },
//             UpdateFunc: func(in1 *v1beta1.PodSecurityPolicy) (*v1beta1.PodSecurityPolicy, error) {
// 	               panic("mock out the Update method")
//             },
//             WatchFunc: func(opts metav1.ListOptions) (watch.Interface, error) {
// 	               panic("mock out the Watch method")
//             },
//         }
//
//         // use mockedPodSecurityPolicyInterface in code that requires v1beta11.PodSecurityPolicyInterface
//         // and then make assertions.
//
//     }
type PodSecurityPolicyInterfaceMock struct {
	// AddClusterScopedFeatureHandlerFunc mocks the AddClusterScopedFeatureHandler method.
	AddClusterScopedFeatureHandlerFunc func(ctx context.Context, enabled func() bool, name string, clusterName string, syncMoqParam v1beta11.PodSecurityPolicyHandlerFunc)

	// AddClusterScopedFeatureLifecycleFunc mocks the AddClusterScopedFeatureLifecycle method.
	AddClusterScopedFeatureLifecycleFunc func(ctx context.Context, enabled func() bool, name string, clusterName string, lifecycle v1beta11.PodSecurityPolicyLifecycle)

	// AddClusterScopedHandlerFunc mocks the AddClusterScopedHandler method.
	AddClusterScopedHandlerFunc func(ctx context.Context, name string, clusterName string, syncMoqParam v1beta11.PodSecurityPolicyHandlerFunc)

	// AddClusterScopedLifecycleFunc mocks the AddClusterScopedLifecycle method.
	AddClusterScopedLifecycleFunc func(ctx context.Context, name string, clusterName string, lifecycle v1beta11.PodSecurityPolicyLifecycle)

	// AddFeatureHandlerFunc mocks the AddFeatureHandler method.
	AddFeatureHandlerFunc func(ctx context.Context, enabled func() bool, name string, syncMoqParam v1beta11.PodSecurityPolicyHandlerFunc)

	// AddFeatureLifecycleFunc mocks the AddFeatureLifecycle method.
	AddFeatureLifecycleFunc func(ctx context.Context, enabled func() bool, name string, lifecycle v1beta11.PodSecurityPolicyLifecycle)

	// AddHandlerFunc mocks the AddHandler method.
	AddHandlerFunc func(ctx context.Context, name string, syncMoqParam v1beta11.PodSecurityPolicyHandlerFunc)

	// AddLifecycleFunc mocks the AddLifecycle method.
	AddLifecycleFunc func(ctx context.Context, name string, lifecycle v1beta11.PodSecurityPolicyLifecycle)

	// ControllerFunc mocks the Controller method.
	ControllerFunc func() v1beta11.PodSecurityPolicyController

	// CreateFunc mocks the Create method.
	CreateFunc func(in1 *v1beta1.PodSecurityPolicy) (*v1beta1.PodSecurityPolicy, error)

	// DeleteFunc mocks the Delete method.
	DeleteFunc func(name string, options *metav1.DeleteOptions) error

	// DeleteCollectionFunc mocks the DeleteCollection method.
	DeleteCollectionFunc func(deleteOpts *metav1.DeleteOptions, listOpts metav1.ListOptions) error

	// DeleteNamespacedFunc mocks the DeleteNamespaced method.
	DeleteNamespacedFunc func(namespace string, name string, options *metav1.DeleteOptions) error

	// GetFunc mocks the Get method.
	GetFunc func(name string, opts metav1.GetOptions) (*v1beta1.PodSecurityPolicy, error)

	// GetNamespacedFunc mocks the GetNamespaced method.
	GetNamespacedFunc func(namespace string, name string, opts metav1.GetOptions) (*v1beta1.PodSecurityPolicy, error)

	// ListFunc mocks the List method.
	ListFunc func(opts metav1.ListOptions) (*v1beta1.PodSecurityPolicyList, error)

	// ListNamespacedFunc mocks the ListNamespaced method.
	ListNamespacedFunc func(namespace string, opts metav1.ListOptions) (*v1beta1.PodSecurityPolicyList, error)

	// ObjectClientFunc mocks the ObjectClient method.
	ObjectClientFunc func() *objectclient.ObjectClient

	// UpdateFunc mocks the Update method.
	UpdateFunc func(in1 *v1beta1.PodSecurityPolicy) (*v1beta1.PodSecurityPolicy, error)

	// WatchFunc mocks the Watch method.
	WatchFunc func(opts metav1.ListOptions) (watch.Interface, error)

	// calls tracks calls to the methods.
	calls struct {
		// AddClusterScopedFeatureHandler holds details about calls to the AddClusterScopedFeatureHandler method.
		AddClusterScopedFeatureHandler []struct {
			// Ctx is the ctx argument value.
			Ctx context.Context
			// Enabled is the enabled argument value.
			Enabled func() bool
			// Name is the name argument value.
			Name string
			// ClusterName is the clusterName argument value.
			ClusterName string
			// Sync is the sync argument value.
			Sync v1beta11.PodSecurityPolicyHandlerFunc
		}
		// AddClusterScopedFeatureLifecycle holds details about calls to the AddClusterScopedFeatureLifecycle method.
		AddClusterScopedFeatureLifecycle []struct {
			// Ctx is the ctx argument value.
			Ctx context.Context
			// Enabled is the enabled argument value.
			Enabled func() bool
			// Name is the name argument value.
			Name string
			// ClusterName is the clusterName argument value.
			ClusterName string
			// Lifecycle is the lifecycle argument value.
			Lifecycle v1beta11.PodSecurityPolicyLifecycle
		}
		// AddClusterScopedHandler holds details about calls to the AddClusterScopedHandler method.
		AddClusterScopedHandler []struct {
			// Ctx is the ctx argument value.
			Ctx context.Context
			// Name is the name argument value.
			Name string
			// ClusterName is the clusterName argument value.
			ClusterName string
			// Sync is the sync argument value.
			Sync v1beta11.PodSecurityPolicyHandlerFunc
		}
		// AddClusterScopedLifecycle holds details about calls to the AddClusterScopedLifecycle method.
		AddClusterScopedLifecycle []struct {
			// Ctx is the ctx argument value.
			Ctx context.Context
			// Name is the name argument value.
			Name string
			// ClusterName is the clusterName argument value.
			ClusterName string
			// Lifecycle is the lifecycle argument value.
			Lifecycle v1beta11.PodSecurityPolicyLifecycle
		}
		// AddFeatureHandler holds details about calls to the AddFeatureHandler method.
		AddFeatureHandler []struct {
			// Ctx is the ctx argument value.
			Ctx context.Context
			// Enabled is the enabled argument value.
			Enabled func() bool
			// Name is the name argument value.
			Name string
			// Sync is the sync argument value.
			Sync v1beta11.PodSecurityPolicyHandlerFunc
		}
		// AddFeatureLifecycle holds details about calls to the AddFeatureLifecycle method.
		AddFeatureLifecycle []struct {
			// Ctx is the ctx argument value.
			Ctx context.Context
			// Enabled is the enabled argument value.
			Enabled func() bool
			// Name is the name argument value.
			Name string
			// Lifecycle is the lifecycle argument value.
			Lifecycle v1beta11.PodSecurityPolicyLifecycle
		}
		// AddHandler holds details about calls to the AddHandler method.
		AddHandler []struct {
			// Ctx is the ctx argument value.
			Ctx context.Context
			// Name is the name argument value.
			Name string
			// Sync is the sync argument value.
			Sync v1beta11.PodSecurityPolicyHandlerFunc
		}
		// AddLifecycle holds details about calls to the AddLifecycle method.
		AddLifecycle []struct {
			// Ctx is the ctx argument value.
			Ctx context.Context
			// Name is the name argument value.
			Name string
			// Lifecycle is the lifecycle argument value.
			Lifecycle v1beta11.PodSecurityPolicyLifecycle
		}
		// Controller holds details about calls to the Controller method.
		Controller []struct {
		}
		// Create holds details about calls to the Create method.
		Create []struct {
			// In1 is the in1 argument value.
			In1 *v1beta1.PodSecurityPolicy
		}
		// Delete holds details about calls to the Delete method.
		Delete []struct {
			// Name is the name argument value.
			Name string
			// Options is the options argument value.
			Options *metav1.DeleteOptions
		}
		// DeleteCollection holds details about calls to the DeleteCollection method.
		DeleteCollection []struct {
			// DeleteOpts is the deleteOpts argument value.
			DeleteOpts *metav1.DeleteOptions
			// ListOpts is the listOpts argument value.
			ListOpts metav1.ListOptions
		}
		// DeleteNamespaced holds details about calls to the DeleteNamespaced method.
		DeleteNamespaced []struct {
			// Namespace is the namespace argument value.
			Namespace string
			// Name is the name argument value.
			Name string
			// Options is the options argument value.
			Options *metav1.DeleteOptions
		}
		// Get holds details about calls to the Get method.
		Get []struct {
			// Name is the name argument value.
			Name string
			// Opts is the opts argument value.
			Opts metav1.GetOptions
		}
		// GetNamespaced holds details about calls to the GetNamespaced method.
		GetNamespaced []struct {
			// Namespace is the namespace argument value.
			Namespace string
			// Name is the name argument value.
			Name string
			// Opts is the opts argument value.
			Opts metav1.GetOptions
		}
		// List holds details about calls to the List method.
		List []struct {
			// Opts is the opts argument value.
			Opts metav1.ListOptions
		}
		// ListNamespaced holds details about calls to the ListNamespaced method.
		ListNamespaced []struct {
			// Namespace is the namespace argument value.
			Namespace string
			// Opts is the opts argument value.
			Opts metav1.ListOptions
		}
		// ObjectClient holds details about calls to the ObjectClient method.
		ObjectClient []struct {
		}
		// Update holds details about calls to the Update method.
		Update []struct {
			// In1 is the in1 argument value.
			In1 *v1beta1.PodSecurityPolicy
		}
		// Watch holds details about calls to the Watch method.
		Watch []struct {
			// Opts is the opts argument value.
			Opts metav1.ListOptions
		}
	}
}

// AddClusterScopedFeatureHandler calls AddClusterScopedFeatureHandlerFunc.
func (mock *PodSecurityPolicyInterfaceMock) AddClusterScopedFeatureHandler(ctx context.Context, enabled func() bool, name string, clusterName string, syncMoqParam v1beta11.PodSecurityPolicyHandlerFunc) {
	if mock.AddClusterScopedFeatureHandlerFunc == nil {
		panic("PodSecurityPolicyInterfaceMock.AddClusterScopedFeatureHandlerFunc: method is nil but PodSecurityPolicyInterface.AddClusterScopedFeatureHandler was just called")
	}
	callInfo := struct {
		Ctx         context.Context
		Enabled     func() bool
		Name        string
		ClusterName string
		Sync        v1beta11.PodSecurityPolicyHandlerFunc
	}{
		Ctx:         ctx,
		Enabled:     enabled,
		Name:        name,
		ClusterName: clusterName,
		Sync:        syncMoqParam,
	}
	lockPodSecurityPolicyInterfaceMockAddClusterScopedFeatureHandler.Lock()
	mock.calls.AddClusterScopedFeatureHandler = append(mock.calls.AddClusterScopedFeatureHandler, callInfo)
	lockPodSecurityPolicyInterfaceMockAddClusterScopedFeatureHandler.Unlock()
	mock.AddClusterScopedFeatureHandlerFunc(ctx, enabled, name, clusterName, syncMoqParam)
}

// AddClusterScopedFeatureHandlerCalls gets all the calls that were made to AddClusterScopedFeatureHandler.
// Check the length with:
//     len(mockedPodSecurityPolicyInterface.AddClusterScopedFeatureHandlerCalls())
func (mock *PodSecurityPolicyInterfaceMock) AddClusterScopedFeatureHandlerCalls() []struct {
	Ctx         context.Context
	Enabled     func() bool
	Name        string
	ClusterName string
	Sync        v1beta11.PodSecurityPolicyHandlerFunc
} {
	var calls []struct {
		Ctx         context.Context
		Enabled     func() bool
		Name        string
		ClusterName string
		Sync        v1beta11.PodSecurityPolicyHandlerFunc
	}
	lockPodSecurityPolicyInterfaceMockAddClusterScopedFeatureHandler.RLock()
	calls = mock.calls.AddClusterScopedFeatureHandler
	lockPodSecurityPolicyInterfaceMockAddClusterScopedFeatureHandler.RUnlock()
	return calls
}

// AddClusterScopedFeatureLifecycle calls AddClusterScopedFeatureLifecycleFunc.
func (mock *PodSecurityPolicyInterfaceMock) AddClusterScopedFeatureLifecycle(ctx context.Context, enabled func() bool, name string, clusterName string, lifecycle v1beta11.PodSecurityPolicyLifecycle) {
	if mock.AddClusterScopedFeatureLifecycleFunc == nil {
		panic("PodSecurityPolicyInterfaceMock.AddClusterScopedFeatureLifecycleFunc: method is nil but PodSecurityPolicyInterface.AddClusterScopedFeatureLifecycle was just called")
	}
	callInfo := struct {
		Ctx         context.Context
		Enabled     func() bool
		Name        string
		ClusterName string
		Lifecycle   v1beta11.PodSecurityPolicyLifecycle
	}{
		Ctx:         ctx,
		Enabled:     enabled,
		Name:        name,
		ClusterName: clusterName,
		Lifecycle:   lifecycle,
	}
	lockPodSecurityPolicyInterfaceMockAddClusterScopedFeatureLifecycle.Lock()
	mock.calls.AddClusterScopedFeatureLifecycle = append(mock.calls.AddClusterScopedFeatureLifecycle, callInfo)
	lockPodSecurityPolicyInterfaceMockAddClusterScopedFeatureLifecycle.Unlock()
	mock.AddClusterScopedFeatureLifecycleFunc(ctx, enabled, name, clusterName, lifecycle)
}

// AddClusterScopedFeatureLifecycleCalls gets all the calls that were made to AddClusterScopedFeatureLifecycle.
// Check the length with:
//     len(mockedPodSecurityPolicyInterface.AddClusterScopedFeatureLifecycleCalls())
func (mock *PodSecurityPolicyInterfaceMock) AddClusterScopedFeatureLifecycleCalls() []struct {
	Ctx         context.Context
	Enabled     func() bool
	Name        string
	ClusterName string
	Lifecycle   v1beta11.PodSecurityPolicyLifecycle
} {
	var calls []struct {
		Ctx         context.Context
		Enabled     func() bool
		Name        string
		ClusterName string
		Lifecycle   v1beta11.PodSecurityPolicyLifecycle
	}
	lockPodSecurityPolicyInterfaceMockAddClusterScopedFeatureLifecycle.RLock()
	calls = mock.calls.AddClusterScopedFeatureLifecycle
	lockPodSecurityPolicyInterfaceMockAddClusterScopedFeatureLifecycle.RUnlock()
	return calls
}

// AddClusterScopedHandler calls AddClusterScopedHandlerFunc.
func (mock *PodSecurityPolicyInterfaceMock) AddClusterScopedHandler(ctx context.Context, name string, clusterName string, syncMoqParam v1beta11.PodSecurityPolicyHandlerFunc) {
	if mock.AddClusterScopedHandlerFunc == nil {
		panic("PodSecurityPolicyInterfaceMock.AddClusterScopedHandlerFunc: method is nil but PodSecurityPolicyInterface.AddClusterScopedHandler was just called")
	}
	callInfo := struct {
		Ctx         context.Context
		Name        string
		ClusterName string
		Sync        v1beta11.PodSecurityPolicyHandlerFunc
	}{
		Ctx:         ctx,
		Name:        name,
		ClusterName: clusterName,
		Sync:        syncMoqParam,
	}
	lockPodSecurityPolicyInterfaceMockAddClusterScopedHandler.Lock()
	mock.calls.AddClusterScopedHandler = append(mock.calls.AddClusterScopedHandler, callInfo)
	lockPodSecurityPolicyInterfaceMockAddClusterScopedHandler.Unlock()
	mock.AddClusterScopedHandlerFunc(ctx, name, clusterName, syncMoqParam)
}

// AddClusterScopedHandlerCalls gets all the calls that were made to AddClusterScopedHandler.
// Check the length with:
//     len(mockedPodSecurityPolicyInterface.AddClusterScopedHandlerCalls())
func (mock *PodSecurityPolicyInterfaceMock) AddClusterScopedHandlerCalls() []struct {
	Ctx         context.Context
	Name        string
	ClusterName string
	Sync        v1beta11.PodSecurityPolicyHandlerFunc
} {
	var calls []struct {
		Ctx         context.Context
		Name        string
		ClusterName string
		Sync        v1beta11.PodSecurityPolicyHandlerFunc
	}
	lockPodSecurityPolicyInterfaceMockAddClusterScopedHandler.RLock()
	calls = mock.calls.AddClusterScopedHandler
	lockPodSecurityPolicyInterfaceMockAddClusterScopedHandler.RUnlock()
	return calls
}

// AddClusterScopedLifecycle calls AddClusterScopedLifecycleFunc.
func (mock *PodSecurityPolicyInterfaceMock) AddClusterScopedLifecycle(ctx context.Context, name string, clusterName string, lifecycle v1beta11.PodSecurityPolicyLifecycle) {
	if mock.AddClusterScopedLifecycleFunc == nil {
		panic("PodSecurityPolicyInterfaceMock.AddClusterScopedLifecycleFunc: method is nil but PodSecurityPolicyInterface.AddClusterScopedLifecycle was just called")
	}
	callInfo := struct {
		Ctx         context.Context
		Name        string
		ClusterName string
		Lifecycle   v1beta11.PodSecurityPolicyLifecycle
	}{
		Ctx:         ctx,
		Name:        name,
		ClusterName: clusterName,
		Lifecycle:   lifecycle,
	}
	lockPodSecurityPolicyInterfaceMockAddClusterScopedLifecycle.Lock()
	mock.calls.AddClusterScopedLifecycle = append(mock.calls.AddClusterScopedLifecycle, callInfo)
	lockPodSecurityPolicyInterfaceMockAddClusterScopedLifecycle.Unlock()
	mock.AddClusterScopedLifecycleFunc(ctx, name, clusterName, lifecycle)
}

// AddClusterScopedLifecycleCalls gets all the calls that were made to AddClusterScopedLifecycle.
// Check the length with:
//     len(mockedPodSecurityPolicyInterface.AddClusterScopedLifecycleCalls())
func (mock *PodSecurityPolicyInterfaceMock) AddClusterScopedLifecycleCalls() []struct {
	Ctx         context.Context
	Name        string
	ClusterName string
	Lifecycle   v1beta11.PodSecurityPolicyLifecycle
} {
	var calls []struct {
		Ctx         context.Context
		Name        string
		ClusterName string
		Lifecycle   v1beta11.PodSecurityPolicyLifecycle
	}
	lockPodSecurityPolicyInterfaceMockAddClusterScopedLifecycle.RLock()
	calls = mock.calls.AddClusterScopedLifecycle
	lockPodSecurityPolicyInterfaceMockAddClusterScopedLifecycle.RUnlock()
	return calls
}

// AddFeatureHandler calls AddFeatureHandlerFunc.
func (mock *PodSecurityPolicyInterfaceMock) AddFeatureHandler(ctx context.Context, enabled func() bool, name string, syncMoqParam v1beta11.PodSecurityPolicyHandlerFunc) {
	if mock.AddFeatureHandlerFunc == nil {
		panic("PodSecurityPolicyInterfaceMock.AddFeatureHandlerFunc: method is nil but PodSecurityPolicyInterface.AddFeatureHandler was just called")
	}
	callInfo := struct {
		Ctx     context.Context
		Enabled func() bool
		Name    string
		Sync    v1beta11.PodSecurityPolicyHandlerFunc
	}{
		Ctx:     ctx,
		Enabled: enabled,
		Name:    name,
		Sync:    syncMoqParam,
	}
	lockPodSecurityPolicyInterfaceMockAddFeatureHandler.Lock()
	mock.calls.AddFeatureHandler = append(mock.calls.AddFeatureHandler, callInfo)
	lockPodSecurityPolicyInterfaceMockAddFeatureHandler.Unlock()
	mock.AddFeatureHandlerFunc(ctx, enabled, name, syncMoqParam)
}

// AddFeatureHandlerCalls gets all the calls that were made to AddFeatureHandler.
// Check the length with:
//     len(mockedPodSecurityPolicyInterface.AddFeatureHandlerCalls())
func (mock *PodSecurityPolicyInterfaceMock) AddFeatureHandlerCalls() []struct {
	Ctx     context.Context
	Enabled func() bool
	Name    string
	Sync    v1beta11.PodSecurityPolicyHandlerFunc
} {
	var calls []struct {
		Ctx     context.Context
		Enabled func() bool
		Name    string
		Sync    v1beta11.PodSecurityPolicyHandlerFunc
	}
	lockPodSecurityPolicyInterfaceMockAddFeatureHandler.RLock()
	calls = mock.calls.AddFeatureHandler
	lockPodSecurityPolicyInterfaceMockAddFeatureHandler.RUnlock()
	return calls
}

// AddFeatureLifecycle calls AddFeatureLifecycleFunc.
func (mock *PodSecurityPolicyInterfaceMock) AddFeatureLifecycle(ctx context.Context, enabled func() bool, name string, lifecycle v1beta11.PodSecurityPolicyLifecycle) {
	if mock.AddFeatureLifecycleFunc == nil {
		panic("PodSecurityPolicyInterfaceMock.AddFeatureLifecycleFunc: method is nil but PodSecurityPolicyInterface.AddFeatureLifecycle was just called")
	}
	callInfo := struct {
		Ctx       context.Context
		Enabled   func() bool
		Name      string
		Lifecycle v1beta11.PodSecurityPolicyLifecycle
	}{
		Ctx:       ctx,
		Enabled:   enabled,
		Name:      name,
		Lifecycle: lifecycle,
	}
	lockPodSecurityPolicyInterfaceMockAddFeatureLifecycle.Lock()
	mock.calls.AddFeatureLifecycle = append(mock.calls.AddFeatureLifecycle, callInfo)
	lockPodSecurityPolicyInterfaceMockAddFeatureLifecycle.Unlock()
	mock.AddFeatureLifecycleFunc(ctx, enabled, name, lifecycle)
}

// AddFeatureLifecycleCalls gets all the calls that were made to AddFeatureLifecycle.
// Check the length with:
//     len(mockedPodSecurityPolicyInterface.AddFeatureLifecycleCalls())
func (mock *PodSecurityPolicyInterfaceMock) AddFeatureLifecycleCalls() []struct {
	Ctx       context.Context
	Enabled   func() bool
	Name      string
	Lifecycle v1beta11.PodSecurityPolicyLifecycle
} {
	var calls []struct {
		Ctx       context.Context
		Enabled   func() bool
		Name      string
		Lifecycle v1beta11.PodSecurityPolicyLifecycle
	}
	lockPodSecurityPolicyInterfaceMockAddFeatureLifecycle.RLock()
	calls = mock.calls.AddFeatureLifecycle
	lockPodSecurityPolicyInterfaceMockAddFeatureLifecycle.RUnlock()
	return calls
}

// AddHandler calls AddHandlerFunc.
func (mock *PodSecurityPolicyInterfaceMock) AddHandler(ctx context.Context, name string, syncMoqParam v1beta11.PodSecurityPolicyHandlerFunc) {
	if mock.AddHandlerFunc == nil {
		panic("PodSecurityPolicyInterfaceMock.AddHandlerFunc: method is nil but PodSecurityPolicyInterface.AddHandler was just called")
	}
	callInfo := struct {
		Ctx  context.Context
		Name string
		Sync v1beta11.PodSecurityPolicyHandlerFunc
	}{
		Ctx:  ctx,
		Name: name,
		Sync: syncMoqParam,
	}
	lockPodSecurityPolicyInterfaceMockAddHandler.Lock()
	mock.calls.AddHandler = append(mock.calls.AddHandler, callInfo)
	lockPodSecurityPolicyInterfaceMockAddHandler.Unlock()
	mock.AddHandlerFunc(ctx, name, syncMoqParam)
}

// AddHandlerCalls gets all the calls that were made to AddHandler.
// Check the length with:
//     len(mockedPodSecurityPolicyInterface.AddHandlerCalls())
func (mock *PodSecurityPolicyInterfaceMock) AddHandlerCalls() []struct {
	Ctx  context.Context
	Name string
	Sync v1beta11.PodSecurityPolicyHandlerFunc
} {
	var calls []struct {
		Ctx  context.Context
		Name string
		Sync v1beta11.PodSecurityPolicyHandlerFunc
	}
	lockPodSecurityPolicyInterfaceMockAddHandler.RLock()
	calls = mock.calls.AddHandler
	lockPodSecurityPolicyInterfaceMockAddHandler.RUnlock()
	return calls
}

// AddLifecycle calls AddLifecycleFunc.
func (mock *PodSecurityPolicyInterfaceMock) AddLifecycle(ctx context.Context, name string, lifecycle v1beta11.PodSecurityPolicyLifecycle) {
	if mock.AddLifecycleFunc == nil {
		panic("PodSecurityPolicyInterfaceMock.AddLifecycleFunc: method is nil but PodSecurityPolicyInterface.AddLifecycle was just called")
	}
	callInfo := struct {
		Ctx       context.Context
		Name      string
		Lifecycle v1beta11.PodSecurityPolicyLifecycle
	}{
		Ctx:       ctx,
		Name:      name,
		Lifecycle: lifecycle,
	}
	lockPodSecurityPolicyInterfaceMockAddLifecycle.Lock()
	mock.calls.AddLifecycle = append(mock.calls.AddLifecycle, callInfo)
	lockPodSecurityPolicyInterfaceMockAddLifecycle.Unlock()
	mock.AddLifecycleFunc(ctx, name, lifecycle)
}

// AddLifecycleCalls gets all the calls that were made to AddLifecycle.
// Check the length with:
//     len(mockedPodSecurityPolicyInterface.AddLifecycleCalls())
func (mock *PodSecurityPolicyInterfaceMock) AddLifecycleCalls() []struct {
	Ctx       context.Context
	Name      string
	Lifecycle v1beta11.PodSecurityPolicyLifecycle
} {
	var calls []struct {
		Ctx       context.Context
		Name      string
		Lifecycle v1beta11.PodSecurityPolicyLifecycle
	}
	lockPodSecurityPolicyInterfaceMockAddLifecycle.RLock()
	calls = mock.calls.AddLifecycle
	lockPodSecurityPolicyInterfaceMockAddLifecycle.RUnlock()
	return calls
}

// Controller calls ControllerFunc.
func (mock *PodSecurityPolicyInterfaceMock) Controller() v1beta11.PodSecurityPolicyController {
	if mock.ControllerFunc == nil {
		panic("PodSecurityPolicyInterfaceMock.ControllerFunc: method is nil but PodSecurityPolicyInterface.Controller was just called")
	}
	callInfo := struct {
	}{}
	lockPodSecurityPolicyInterfaceMockController.Lock()
	mock.calls.Controller = append(mock.calls.Controller, callInfo)
	lockPodSecurityPolicyInterfaceMockController.Unlock()
	return mock.ControllerFunc()
}

// ControllerCalls gets all the calls that were made to Controller.
// Check the length with:
//     len(mockedPodSecurityPolicyInterface.ControllerCalls())
func (mock *PodSecurityPolicyInterfaceMock) ControllerCalls() []struct {
} {
	var calls []struct {
	}
	lockPodSecurityPolicyInterfaceMockController.RLock()
	calls = mock.calls.Controller
	lockPodSecurityPolicyInterfaceMockController.RUnlock()
	return calls
}

// Create calls CreateFunc.
func (mock *PodSecurityPolicyInterfaceMock) Create(in1 *v1beta1.PodSecurityPolicy) (*v1beta1.PodSecurityPolicy, error) {
	if mock.CreateFunc == nil {
		panic("PodSecurityPolicyInterfaceMock.CreateFunc: method is nil but PodSecurityPolicyInterface.Create was just called")
	}
	callInfo := struct {
		In1 *v1beta1.PodSecurityPolicy
	}{
		In1: in1,
	}
	lockPodSecurityPolicyInterfaceMockCreate.Lock()
	mock.calls.Create = append(mock.calls.Create, callInfo)
	lockPodSecurityPolicyInterfaceMockCreate.Unlock()
	return mock.CreateFunc(in1)
}

// CreateCalls gets all the calls that were made to Create.
// Check the length with:
//     len(mockedPodSecurityPolicyInterface.CreateCalls())
func (mock *PodSecurityPolicyInterfaceMock) CreateCalls() []struct {
	In1 *v1beta1.PodSecurityPolicy
} {
	var calls []struct {
		In1 *v1beta1.PodSecurityPolicy
	}
	lockPodSecurityPolicyInterfaceMockCreate.RLock()
	calls = mock.calls.Create
	lockPodSecurityPolicyInterfaceMockCreate.RUnlock()
	return calls
}

// Delete calls DeleteFunc.
func (mock *PodSecurityPolicyInterfaceMock) Delete(name string, options *metav1.DeleteOptions) error {
	if mock.DeleteFunc == nil {
		panic("PodSecurityPolicyInterfaceMock.DeleteFunc: method is nil but PodSecurityPolicyInterface.Delete was just called")
	}
	callInfo := struct {
		Name    string
		Options *metav1.DeleteOptions
	}{
		Name:    name,
		Options: options,
	}
	lockPodSecurityPolicyInterfaceMockDelete.Lock()
	mock.calls.Delete = append(mock.calls.Delete, callInfo)
	lockPodSecurityPolicyInterfaceMockDelete.Unlock()
	return mock.DeleteFunc(name, options)
}

// DeleteCalls gets all the calls that were made to Delete.
// Check the length with:
//     len(mockedPodSecurityPolicyInterface.DeleteCalls())
func (mock *PodSecurityPolicyInterfaceMock) DeleteCalls() []struct {
	Name    string
	Options *metav1.DeleteOptions
} {
	var calls []struct {
		Name    string
		Options *metav1.DeleteOptions
	}
	lockPodSecurityPolicyInterfaceMockDelete.RLock()
	calls = mock.calls.Delete
	lockPodSecurityPolicyInterfaceMockDelete.RUnlock()
	return calls
}

// DeleteCollection calls DeleteCollectionFunc.
func (mock *PodSecurityPolicyInterfaceMock) DeleteCollection(deleteOpts *metav1.DeleteOptions, listOpts metav1.ListOptions) error {
	if mock.DeleteCollectionFunc == nil {
		panic("PodSecurityPolicyInterfaceMock.DeleteCollectionFunc: method is nil but PodSecurityPolicyInterface.DeleteCollection was just called")
	}
	callInfo := struct {
		DeleteOpts *metav1.DeleteOptions
		ListOpts   metav1.ListOptions
	}{
		DeleteOpts: deleteOpts,
		ListOpts:   listOpts,
	}
	lockPodSecurityPolicyInterfaceMockDeleteCollection.Lock()
	mock.calls.DeleteCollection = append(mock.calls.DeleteCollection, callInfo)
	lockPodSecurityPolicyInterfaceMockDeleteCollection.Unlock()
	return mock.DeleteCollectionFunc(deleteOpts, listOpts)
}

// DeleteCollectionCalls gets all the calls that were made to DeleteCollection.
// Check the length with:
//     len(mockedPodSecurityPolicyInterface.DeleteCollectionCalls())
func (mock *PodSecurityPolicyInterfaceMock) DeleteCollectionCalls() []struct {
	DeleteOpts *metav1.DeleteOptions
	ListOpts   metav1.ListOptions
} {
	var calls []struct {
		DeleteOpts *metav1.DeleteOptions
		ListOpts   metav1.ListOptions
	}
	lockPodSecurityPolicyInterfaceMockDeleteCollection.RLock()
	calls = mock.calls.DeleteCollection
	lockPodSecurityPolicyInterfaceMockDeleteCollection.RUnlock()
	return calls
}

// DeleteNamespaced calls DeleteNamespacedFunc.
func (mock *PodSecurityPolicyInterfaceMock) DeleteNamespaced(namespace string, name string, options *metav1.DeleteOptions) error {
	if mock.DeleteNamespacedFunc == nil {
		panic("PodSecurityPolicyInterfaceMock.DeleteNamespacedFunc: method is nil but PodSecurityPolicyInterface.DeleteNamespaced was just called")
	}
	callInfo := struct {
		Namespace string
		Name      string
		Options   *metav1.DeleteOptions
	}{
		Namespace: namespace,
		Name:      name,
		Options:   options,
	}
	lockPodSecurityPolicyInterfaceMockDeleteNamespaced.Lock()
	mock.calls.DeleteNamespaced = append(mock.calls.DeleteNamespaced, callInfo)
	lockPodSecurityPolicyInterfaceMockDeleteNamespaced.Unlock()
	return mock.DeleteNamespacedFunc(namespace, name, options)
}

// DeleteNamespacedCalls gets all the calls that were made to DeleteNamespaced.
// Check the length with:
//     len(mockedPodSecurityPolicyInterface.DeleteNamespacedCalls())
func (mock *PodSecurityPolicyInterfaceMock) DeleteNamespacedCalls() []struct {
	Namespace string
	Name      string
	Options   *metav1.DeleteOptions
} {
	var calls []struct {
		Namespace string
		Name      string
		Options   *metav1.DeleteOptions
	}
	lockPodSecurityPolicyInterfaceMockDeleteNamespaced.RLock()
	calls = mock.calls.DeleteNamespaced
	lockPodSecurityPolicyInterfaceMockDeleteNamespaced.RUnlock()
	return calls
}

// Get calls GetFunc.
func (mock *PodSecurityPolicyInterfaceMock) Get(name string, opts metav1.GetOptions) (*v1beta1.PodSecurityPolicy, error) {
	if mock.GetFunc == nil {
		panic("PodSecurityPolicyInterfaceMock.GetFunc: method is nil but PodSecurityPolicyInterface.Get was just called")
	}
	callInfo := struct {
		Name string
		Opts metav1.GetOptions
	}{
		Name: name,
		Opts: opts,
	}
	lockPodSecurityPolicyInterfaceMockGet.Lock()
	mock.calls.Get = append(mock.calls.Get, callInfo)
	lockPodSecurityPolicyInterfaceMockGet.Unlock()
	return mock.GetFunc(name, opts)
}

// GetCalls gets all the calls that were made to Get.
// Check the length with:
//     len(mockedPodSecurityPolicyInterface.GetCalls())
func (mock *PodSecurityPolicyInterfaceMock) GetCalls() []struct {
	Name string
	Opts metav1.GetOptions
} {
	var calls []struct {
		Name string
		Opts metav1.GetOptions
	}
	lockPodSecurityPolicyInterfaceMockGet.RLock()
	calls = mock.calls.Get
	lockPodSecurityPolicyInterfaceMockGet.RUnlock()
	return calls
}

// GetNamespaced calls GetNamespacedFunc.
func (mock *PodSecurityPolicyInterfaceMock) GetNamespaced(namespace string, name string, opts metav1.GetOptions) (*v1beta1.PodSecurityPolicy, error) {
	if mock.GetNamespacedFunc == nil {
		panic("PodSecurityPolicyInterfaceMock.GetNamespacedFunc: method is nil but PodSecurityPolicyInterface.GetNamespaced was just called")
	}
	callInfo := struct {
		Namespace string
		Name      string
		Opts      metav1.GetOptions
	}{
		Namespace: namespace,
		Name:      name,
		Opts:      opts,
	}
	lockPodSecurityPolicyInterfaceMockGetNamespaced.Lock()
	mock.calls.GetNamespaced = append(mock.calls.GetNamespaced, callInfo)
	lockPodSecurityPolicyInterfaceMockGetNamespaced.Unlock()
	return mock.GetNamespacedFunc(namespace, name, opts)
}

// GetNamespacedCalls gets all the calls that were made to GetNamespaced.
// Check the length with:
//     len(mockedPodSecurityPolicyInterface.GetNamespacedCalls())
func (mock *PodSecurityPolicyInterfaceMock) GetNamespacedCalls() []struct {
	Namespace string
	Name      string
	Opts      metav1.GetOptions
} {
	var calls []struct {
		Namespace string
		Name      string
		Opts      metav1.GetOptions
	}
	lockPodSecurityPolicyInterfaceMockGetNamespaced.RLock()
	calls = mock.calls.GetNamespaced
	lockPodSecurityPolicyInterfaceMockGetNamespaced.RUnlock()
	return calls
}

// List calls ListFunc.
func (mock *PodSecurityPolicyInterfaceMock) List(opts metav1.ListOptions) (*v1beta1.PodSecurityPolicyList, error) {
	if mock.ListFunc == nil {
		panic("PodSecurityPolicyInterfaceMock.ListFunc: method is nil but PodSecurityPolicyInterface.List was just called")
	}
	callInfo := struct {
		Opts metav1.ListOptions
	}{
		Opts: opts,
	}
	lockPodSecurityPolicyInterfaceMockList.Lock()
	mock.calls.List = append(mock.calls.List, callInfo)
	lockPodSecurityPolicyInterfaceMockList.Unlock()
	return mock.ListFunc(opts)
}

// ListCalls gets all the calls that were made to List.
// Check the length with:
//     len(mockedPodSecurityPolicyInterface.ListCalls())
func (mock *PodSecurityPolicyInterfaceMock) ListCalls() []struct {
	Opts metav1.ListOptions
} {
	var calls []struct {
		Opts metav1.ListOptions
	}
	lockPodSecurityPolicyInterfaceMockList.RLock()
	calls = mock.calls.List
	lockPodSecurityPolicyInterfaceMockList.RUnlock()
	return calls
}

// ListNamespaced calls ListNamespacedFunc.
func (mock *PodSecurityPolicyInterfaceMock) ListNamespaced(namespace string, opts metav1.ListOptions) (*v1beta1.PodSecurityPolicyList, error) {
	if mock.ListNamespacedFunc == nil {
		panic("PodSecurityPolicyInterfaceMock.ListNamespacedFunc: method is nil but PodSecurityPolicyInterface.ListNamespaced was just called")
	}
	callInfo := struct {
		Namespace string
		Opts      metav1.ListOptions
	}{
		Namespace: namespace,
		Opts:      opts,
	}
	lockPodSecurityPolicyInterfaceMockListNamespaced.Lock()
	mock.calls.ListNamespaced = append(mock.calls.ListNamespaced, callInfo)
	lockPodSecurityPolicyInterfaceMockListNamespaced.Unlock()
	return mock.ListNamespacedFunc(namespace, opts)
}

// ListNamespacedCalls gets all the calls that were made to ListNamespaced.
// Check the length with:
//     len(mockedPodSecurityPolicyInterface.ListNamespacedCalls())
func (mock *PodSecurityPolicyInterfaceMock) ListNamespacedCalls() []struct {
	Namespace string
	Opts      metav1.ListOptions
} {
	var calls []struct {
		Namespace string
		Opts      metav1.ListOptions
	}
	lockPodSecurityPolicyInterfaceMockListNamespaced.RLock()
	calls = mock.calls.ListNamespaced
	lockPodSecurityPolicyInterfaceMockListNamespaced.RUnlock()
	return calls
}

// ObjectClient calls ObjectClientFunc.
func (mock *PodSecurityPolicyInterfaceMock) ObjectClient() *objectclient.ObjectClient {
	if mock.ObjectClientFunc == nil {
		panic("PodSecurityPolicyInterfaceMock.ObjectClientFunc: method is nil but PodSecurityPolicyInterface.ObjectClient was just called")
	}
	callInfo := struct {
	}{}
	lockPodSecurityPolicyInterfaceMockObjectClient.Lock()
	mock.calls.ObjectClient = append(mock.calls.ObjectClient, callInfo)
	lockPodSecurityPolicyInterfaceMockObjectClient.Unlock()
	return mock.ObjectClientFunc()
}

// ObjectClientCalls gets all the calls that were made to ObjectClient.
// Check the length with:
//     len(mockedPodSecurityPolicyInterface.ObjectClientCalls())
func (mock *PodSecurityPolicyInterfaceMock) ObjectClientCalls() []struct {
} {
	var calls []struct {
	}
	lockPodSecurityPolicyInterfaceMockObjectClient.RLock()
	calls = mock.calls.ObjectClient
	lockPodSecurityPolicyInterfaceMockObjectClient.RUnlock()
	return calls
}

// Update calls UpdateFunc.
func (mock *PodSecurityPolicyInterfaceMock) Update(in1 *v1beta1.PodSecurityPolicy) (*v1beta1.PodSecurityPolicy, error) {
	if mock.UpdateFunc == nil {
		panic("PodSecurityPolicyInterfaceMock.UpdateFunc: method is nil but PodSecurityPolicyInterface.Update was just called")
	}
	callInfo := struct {
		In1 *v1beta1.PodSecurityPolicy
	}{
		In1: in1,
	}
	lockPodSecurityPolicyInterfaceMockUpdate.Lock()
	mock.calls.Update = append(mock.calls.Update, callInfo)
	lockPodSecurityPolicyInterfaceMockUpdate.Unlock()
	return mock.UpdateFunc(in1)
}

// UpdateCalls gets all the calls that were made to Update.
// Check the length with:
//     len(mockedPodSecurityPolicyInterface.UpdateCalls())
func (mock *PodSecurityPolicyInterfaceMock) UpdateCalls() []struct {
	In1 *v1beta1.PodSecurityPolicy
} {
	var calls []struct {
		In1 *v1beta1.PodSecurityPolicy
	}
	lockPodSecurityPolicyInterfaceMockUpdate.RLock()
	calls = mock.calls.Update
	lockPodSecurityPolicyInterfaceMockUpdate.RUnlock()
	return calls
}

// Watch calls WatchFunc.
func (mock *PodSecurityPolicyInterfaceMock) Watch(opts metav1.ListOptions) (watch.Interface, error) {
	if mock.WatchFunc == nil {
		panic("PodSecurityPolicyInterfaceMock.WatchFunc: method is nil but PodSecurityPolicyInterface.Watch was just called")
	}
	callInfo := struct {
		Opts metav1.ListOptions
	}{
		Opts: opts,
	}
	lockPodSecurityPolicyInterfaceMockWatch.Lock()
	mock.calls.Watch = append(mock.calls.Watch, callInfo)
	lockPodSecurityPolicyInterfaceMockWatch.Unlock()
	return mock.WatchFunc(opts)
}

// WatchCalls gets all the calls that were made to Watch.
// Check the length with:
//     len(mockedPodSecurityPolicyInterface.WatchCalls())
func (mock *PodSecurityPolicyInterfaceMock) WatchCalls() []struct {
	Opts metav1.ListOptions
} {
	var calls []struct {
		Opts metav1.ListOptions
	}
	lockPodSecurityPolicyInterfaceMockWatch.RLock()
	calls = mock.calls.Watch
	lockPodSecurityPolicyInterfaceMockWatch.RUnlock()
	return calls
}

var (
	lockPodSecurityPoliciesGetterMockPodSecurityPolicies sync.RWMutex
)

// Ensure, that PodSecurityPoliciesGetterMock does implement v1beta11.PodSecurityPoliciesGetter.
// If this is not the case, regenerate this file with moq.
var _ v1beta11.PodSecurityPoliciesGetter = &PodSecurityPoliciesGetterMock{}

// PodSecurityPoliciesGetterMock is a mock implementation of v1beta11.PodSecurityPoliciesGetter.
//
//     func TestSomethingThatUsesPodSecurityPoliciesGetter(t *testing.T) {
//
//         // make and configure a mocked v1beta11.PodSecurityPoliciesGetter
//         mockedPodSecurityPoliciesGetter := &PodSecurityPoliciesGetterMock{
//             PodSecurityPoliciesFunc: func(namespace string) v1beta11.PodSecurityPolicyInterface {
// 	               panic("mock out the PodSecurityPolicies method")
//             },
//         }
//
//         // use mockedPodSecurityPoliciesGetter in code that requires v1beta11.PodSecurityPoliciesGetter
//         // and then make assertions.
//
//     }
type PodSecurityPoliciesGetterMock struct {
	// PodSecurityPoliciesFunc mocks the PodSecurityPolicies method.
	PodSecurityPoliciesFunc func(namespace string) v1beta11.PodSecurityPolicyInterface

	// calls tracks calls to the methods.
	calls struct {
		// PodSecurityPolicies holds details about calls to the PodSecurityPolicies method.
		PodSecurityPolicies []struct {
			// Namespace is the namespace argument value.
			Namespace string
		}
	}
}

// PodSecurityPolicies calls PodSecurityPoliciesFunc.
func (mock *PodSecurityPoliciesGetterMock) PodSecurityPolicies(namespace string) v1beta11.PodSecurityPolicyInterface {
	if mock.PodSecurityPoliciesFunc == nil {
		panic("PodSecurityPoliciesGetterMock.PodSecurityPoliciesFunc: method is nil but PodSecurityPoliciesGetter.PodSecurityPolicies was just called")
	}
	callInfo := struct {
		Namespace string
	}{
		Namespace: namespace,
	}
	lockPodSecurityPoliciesGetterMockPodSecurityPolicies.Lock()
	mock.calls.PodSecurityPolicies = append(mock.calls.PodSecurityPolicies, callInfo)
	lockPodSecurityPoliciesGetterMockPodSecurityPolicies.Unlock()
	return mock.PodSecurityPoliciesFunc(namespace)
}

// PodSecurityPoliciesCalls gets all the calls that were made to PodSecurityPolicies.
// Check the length with:
//     len(mockedPodSecurityPoliciesGetter.PodSecurityPoliciesCalls())
func (mock *PodSecurityPoliciesGetterMock) PodSecurityPoliciesCalls() []struct {
	Namespace string
} {
	var calls []struct {
		Namespace string
	}
	lockPodSecurityPoliciesGetterMockPodSecurityPolicies.RLock()
	calls = mock.calls.PodSecurityPolicies
	lockPodSecurityPoliciesGetterMockPodSecurityPolicies.RUnlock()
	return calls
}
