// Code generated by moq; DO NOT EDIT.
// github.com/matryer/moq

package fakes

import (
	"context"
	"sync"
	"time"

	"github.com/rancher/norman/controller"
	"github.com/rancher/norman/objectclient"
	v3 "github.com/rancher/rancher/pkg/apis/project.cattle.io/v3"
	v31 "github.com/rancher/rancher/pkg/generated/norman/project.cattle.io/v3"
	metav1 "k8s.io/apimachinery/pkg/apis/meta/v1"
	"k8s.io/apimachinery/pkg/labels"
	"k8s.io/apimachinery/pkg/watch"
	"k8s.io/client-go/tools/cache"
)

var (
	lockAppRevisionListerMockGet  sync.RWMutex
	lockAppRevisionListerMockList sync.RWMutex
)

// Ensure, that AppRevisionListerMock does implement v31.AppRevisionLister.
// If this is not the case, regenerate this file with moq.
var _ v31.AppRevisionLister = &AppRevisionListerMock{}

// AppRevisionListerMock is a mock implementation of v31.AppRevisionLister.
//
//     func TestSomethingThatUsesAppRevisionLister(t *testing.T) {
//
//         // make and configure a mocked v31.AppRevisionLister
//         mockedAppRevisionLister := &AppRevisionListerMock{
//             GetFunc: func(namespace string, name string) (*v3.AppRevision, error) {
// 	               panic("mock out the Get method")
//             },
//             ListFunc: func(namespace string, selector labels.Selector) ([]*v3.AppRevision, error) {
// 	               panic("mock out the List method")
//             },
//         }
//
//         // use mockedAppRevisionLister in code that requires v31.AppRevisionLister
//         // and then make assertions.
//
//     }
type AppRevisionListerMock struct {
	// GetFunc mocks the Get method.
	GetFunc func(namespace string, name string) (*v3.AppRevision, error)

	// ListFunc mocks the List method.
	ListFunc func(namespace string, selector labels.Selector) ([]*v3.AppRevision, error)

	// calls tracks calls to the methods.
	calls struct {
		// Get holds details about calls to the Get method.
		Get []struct {
			// Namespace is the namespace argument value.
			Namespace string
			// Name is the name argument value.
			Name string
		}
		// List holds details about calls to the List method.
		List []struct {
			// Namespace is the namespace argument value.
			Namespace string
			// Selector is the selector argument value.
			Selector labels.Selector
		}
	}
}

// Get calls GetFunc.
func (mock *AppRevisionListerMock) Get(namespace string, name string) (*v3.AppRevision, error) {
	if mock.GetFunc == nil {
		panic("AppRevisionListerMock.GetFunc: method is nil but AppRevisionLister.Get was just called")
	}
	callInfo := struct {
		Namespace string
		Name      string
	}{
		Namespace: namespace,
		Name:      name,
	}
	lockAppRevisionListerMockGet.Lock()
	mock.calls.Get = append(mock.calls.Get, callInfo)
	lockAppRevisionListerMockGet.Unlock()
	return mock.GetFunc(namespace, name)
}

// GetCalls gets all the calls that were made to Get.
// Check the length with:
//     len(mockedAppRevisionLister.GetCalls())
func (mock *AppRevisionListerMock) GetCalls() []struct {
	Namespace string
	Name      string
} {
	var calls []struct {
		Namespace string
		Name      string
	}
	lockAppRevisionListerMockGet.RLock()
	calls = mock.calls.Get
	lockAppRevisionListerMockGet.RUnlock()
	return calls
}

// List calls ListFunc.
func (mock *AppRevisionListerMock) List(namespace string, selector labels.Selector) ([]*v3.AppRevision, error) {
	if mock.ListFunc == nil {
		panic("AppRevisionListerMock.ListFunc: method is nil but AppRevisionLister.List was just called")
	}
	callInfo := struct {
		Namespace string
		Selector  labels.Selector
	}{
		Namespace: namespace,
		Selector:  selector,
	}
	lockAppRevisionListerMockList.Lock()
	mock.calls.List = append(mock.calls.List, callInfo)
	lockAppRevisionListerMockList.Unlock()
	return mock.ListFunc(namespace, selector)
}

// ListCalls gets all the calls that were made to List.
// Check the length with:
//     len(mockedAppRevisionLister.ListCalls())
func (mock *AppRevisionListerMock) ListCalls() []struct {
	Namespace string
	Selector  labels.Selector
} {
	var calls []struct {
		Namespace string
		Selector  labels.Selector
	}
	lockAppRevisionListerMockList.RLock()
	calls = mock.calls.List
	lockAppRevisionListerMockList.RUnlock()
	return calls
}

var (
	lockAppRevisionControllerMockAddClusterScopedFeatureHandler sync.RWMutex
	lockAppRevisionControllerMockAddClusterScopedHandler        sync.RWMutex
	lockAppRevisionControllerMockAddFeatureHandler              sync.RWMutex
	lockAppRevisionControllerMockAddHandler                     sync.RWMutex
	lockAppRevisionControllerMockEnqueue                        sync.RWMutex
	lockAppRevisionControllerMockEnqueueAfter                   sync.RWMutex
	lockAppRevisionControllerMockGeneric                        sync.RWMutex
	lockAppRevisionControllerMockInformer                       sync.RWMutex
	lockAppRevisionControllerMockLister                         sync.RWMutex
)

// Ensure, that AppRevisionControllerMock does implement v31.AppRevisionController.
// If this is not the case, regenerate this file with moq.
var _ v31.AppRevisionController = &AppRevisionControllerMock{}

// AppRevisionControllerMock is a mock implementation of v31.AppRevisionController.
//
//     func TestSomethingThatUsesAppRevisionController(t *testing.T) {
//
//         // make and configure a mocked v31.AppRevisionController
//         mockedAppRevisionController := &AppRevisionControllerMock{
//             AddClusterScopedFeatureHandlerFunc: func(ctx context.Context, enabled func() bool, name string, clusterName string, handler v31.AppRevisionHandlerFunc)  {
// 	               panic("mock out the AddClusterScopedFeatureHandler method")
//             },
//             AddClusterScopedHandlerFunc: func(ctx context.Context, name string, clusterName string, handler v31.AppRevisionHandlerFunc)  {
// 	               panic("mock out the AddClusterScopedHandler method")
//             },
//             AddFeatureHandlerFunc: func(ctx context.Context, enabled func() bool, name string, syncMoqParam v31.AppRevisionHandlerFunc)  {
// 	               panic("mock out the AddFeatureHandler method")
//             },
//             AddHandlerFunc: func(ctx context.Context, name string, handler v31.AppRevisionHandlerFunc)  {
// 	               panic("mock out the AddHandler method")
//             },
//             EnqueueFunc: func(namespace string, name string)  {
// 	               panic("mock out the Enqueue method")
//             },
//             EnqueueAfterFunc: func(namespace string, name string, after time.Duration)  {
// 	               panic("mock out the EnqueueAfter method")
//             },
//             GenericFunc: func() controller.GenericController {
// 	               panic("mock out the Generic method")
//             },
//             InformerFunc: func() cache.SharedIndexInformer {
// 	               panic("mock out the Informer method")
//             },
//             ListerFunc: func() v31.AppRevisionLister {
// 	               panic("mock out the Lister method")
//             },
//         }
//
//         // use mockedAppRevisionController in code that requires v31.AppRevisionController
//         // and then make assertions.
//
//     }
type AppRevisionControllerMock struct {
	// AddClusterScopedFeatureHandlerFunc mocks the AddClusterScopedFeatureHandler method.
	AddClusterScopedFeatureHandlerFunc func(ctx context.Context, enabled func() bool, name string, clusterName string, handler v31.AppRevisionHandlerFunc)

	// AddClusterScopedHandlerFunc mocks the AddClusterScopedHandler method.
	AddClusterScopedHandlerFunc func(ctx context.Context, name string, clusterName string, handler v31.AppRevisionHandlerFunc)

	// AddFeatureHandlerFunc mocks the AddFeatureHandler method.
	AddFeatureHandlerFunc func(ctx context.Context, enabled func() bool, name string, syncMoqParam v31.AppRevisionHandlerFunc)

	// AddHandlerFunc mocks the AddHandler method.
	AddHandlerFunc func(ctx context.Context, name string, handler v31.AppRevisionHandlerFunc)

	// EnqueueFunc mocks the Enqueue method.
	EnqueueFunc func(namespace string, name string)

	// EnqueueAfterFunc mocks the EnqueueAfter method.
	EnqueueAfterFunc func(namespace string, name string, after time.Duration)

	// GenericFunc mocks the Generic method.
	GenericFunc func() controller.GenericController

	// InformerFunc mocks the Informer method.
	InformerFunc func() cache.SharedIndexInformer

	// ListerFunc mocks the Lister method.
	ListerFunc func() v31.AppRevisionLister

	// calls tracks calls to the methods.
	calls struct {
		// AddClusterScopedFeatureHandler holds details about calls to the AddClusterScopedFeatureHandler method.
		AddClusterScopedFeatureHandler []struct {
			// Ctx is the ctx argument value.
			Ctx context.Context
			// Enabled is the enabled argument value.
			Enabled func() bool
			// Name is the name argument value.
			Name string
			// ClusterName is the clusterName argument value.
			ClusterName string
			// Handler is the handler argument value.
			Handler v31.AppRevisionHandlerFunc
		}
		// AddClusterScopedHandler holds details about calls to the AddClusterScopedHandler method.
		AddClusterScopedHandler []struct {
			// Ctx is the ctx argument value.
			Ctx context.Context
			// Name is the name argument value.
			Name string
			// ClusterName is the clusterName argument value.
			ClusterName string
			// Handler is the handler argument value.
			Handler v31.AppRevisionHandlerFunc
		}
		// AddFeatureHandler holds details about calls to the AddFeatureHandler method.
		AddFeatureHandler []struct {
			// Ctx is the ctx argument value.
			Ctx context.Context
			// Enabled is the enabled argument value.
			Enabled func() bool
			// Name is the name argument value.
			Name string
			// Sync is the sync argument value.
			Sync v31.AppRevisionHandlerFunc
		}
		// AddHandler holds details about calls to the AddHandler method.
		AddHandler []struct {
			// Ctx is the ctx argument value.
			Ctx context.Context
			// Name is the name argument value.
			Name string
			// Handler is the handler argument value.
			Handler v31.AppRevisionHandlerFunc
		}
		// Enqueue holds details about calls to the Enqueue method.
		Enqueue []struct {
			// Namespace is the namespace argument value.
			Namespace string
			// Name is the name argument value.
			Name string
		}
		// EnqueueAfter holds details about calls to the EnqueueAfter method.
		EnqueueAfter []struct {
			// Namespace is the namespace argument value.
			Namespace string
			// Name is the name argument value.
			Name string
			// After is the after argument value.
			After time.Duration
		}
		// Generic holds details about calls to the Generic method.
		Generic []struct {
		}
		// Informer holds details about calls to the Informer method.
		Informer []struct {
		}
		// Lister holds details about calls to the Lister method.
		Lister []struct {
		}
	}
}

// AddClusterScopedFeatureHandler calls AddClusterScopedFeatureHandlerFunc.
func (mock *AppRevisionControllerMock) AddClusterScopedFeatureHandler(ctx context.Context, enabled func() bool, name string, clusterName string, handler v31.AppRevisionHandlerFunc) {
	if mock.AddClusterScopedFeatureHandlerFunc == nil {
		panic("AppRevisionControllerMock.AddClusterScopedFeatureHandlerFunc: method is nil but AppRevisionController.AddClusterScopedFeatureHandler was just called")
	}
	callInfo := struct {
		Ctx         context.Context
		Enabled     func() bool
		Name        string
		ClusterName string
		Handler     v31.AppRevisionHandlerFunc
	}{
		Ctx:         ctx,
		Enabled:     enabled,
		Name:        name,
		ClusterName: clusterName,
		Handler:     handler,
	}
	lockAppRevisionControllerMockAddClusterScopedFeatureHandler.Lock()
	mock.calls.AddClusterScopedFeatureHandler = append(mock.calls.AddClusterScopedFeatureHandler, callInfo)
	lockAppRevisionControllerMockAddClusterScopedFeatureHandler.Unlock()
	mock.AddClusterScopedFeatureHandlerFunc(ctx, enabled, name, clusterName, handler)
}

// AddClusterScopedFeatureHandlerCalls gets all the calls that were made to AddClusterScopedFeatureHandler.
// Check the length with:
//     len(mockedAppRevisionController.AddClusterScopedFeatureHandlerCalls())
func (mock *AppRevisionControllerMock) AddClusterScopedFeatureHandlerCalls() []struct {
	Ctx         context.Context
	Enabled     func() bool
	Name        string
	ClusterName string
	Handler     v31.AppRevisionHandlerFunc
} {
	var calls []struct {
		Ctx         context.Context
		Enabled     func() bool
		Name        string
		ClusterName string
		Handler     v31.AppRevisionHandlerFunc
	}
	lockAppRevisionControllerMockAddClusterScopedFeatureHandler.RLock()
	calls = mock.calls.AddClusterScopedFeatureHandler
	lockAppRevisionControllerMockAddClusterScopedFeatureHandler.RUnlock()
	return calls
}

// AddClusterScopedHandler calls AddClusterScopedHandlerFunc.
func (mock *AppRevisionControllerMock) AddClusterScopedHandler(ctx context.Context, name string, clusterName string, handler v31.AppRevisionHandlerFunc) {
	if mock.AddClusterScopedHandlerFunc == nil {
		panic("AppRevisionControllerMock.AddClusterScopedHandlerFunc: method is nil but AppRevisionController.AddClusterScopedHandler was just called")
	}
	callInfo := struct {
		Ctx         context.Context
		Name        string
		ClusterName string
		Handler     v31.AppRevisionHandlerFunc
	}{
		Ctx:         ctx,
		Name:        name,
		ClusterName: clusterName,
		Handler:     handler,
	}
	lockAppRevisionControllerMockAddClusterScopedHandler.Lock()
	mock.calls.AddClusterScopedHandler = append(mock.calls.AddClusterScopedHandler, callInfo)
	lockAppRevisionControllerMockAddClusterScopedHandler.Unlock()
	mock.AddClusterScopedHandlerFunc(ctx, name, clusterName, handler)
}

// AddClusterScopedHandlerCalls gets all the calls that were made to AddClusterScopedHandler.
// Check the length with:
//     len(mockedAppRevisionController.AddClusterScopedHandlerCalls())
func (mock *AppRevisionControllerMock) AddClusterScopedHandlerCalls() []struct {
	Ctx         context.Context
	Name        string
	ClusterName string
	Handler     v31.AppRevisionHandlerFunc
} {
	var calls []struct {
		Ctx         context.Context
		Name        string
		ClusterName string
		Handler     v31.AppRevisionHandlerFunc
	}
	lockAppRevisionControllerMockAddClusterScopedHandler.RLock()
	calls = mock.calls.AddClusterScopedHandler
	lockAppRevisionControllerMockAddClusterScopedHandler.RUnlock()
	return calls
}

// AddFeatureHandler calls AddFeatureHandlerFunc.
func (mock *AppRevisionControllerMock) AddFeatureHandler(ctx context.Context, enabled func() bool, name string, syncMoqParam v31.AppRevisionHandlerFunc) {
	if mock.AddFeatureHandlerFunc == nil {
		panic("AppRevisionControllerMock.AddFeatureHandlerFunc: method is nil but AppRevisionController.AddFeatureHandler was just called")
	}
	callInfo := struct {
		Ctx     context.Context
		Enabled func() bool
		Name    string
		Sync    v31.AppRevisionHandlerFunc
	}{
		Ctx:     ctx,
		Enabled: enabled,
		Name:    name,
		Sync:    syncMoqParam,
	}
	lockAppRevisionControllerMockAddFeatureHandler.Lock()
	mock.calls.AddFeatureHandler = append(mock.calls.AddFeatureHandler, callInfo)
	lockAppRevisionControllerMockAddFeatureHandler.Unlock()
	mock.AddFeatureHandlerFunc(ctx, enabled, name, syncMoqParam)
}

// AddFeatureHandlerCalls gets all the calls that were made to AddFeatureHandler.
// Check the length with:
//     len(mockedAppRevisionController.AddFeatureHandlerCalls())
func (mock *AppRevisionControllerMock) AddFeatureHandlerCalls() []struct {
	Ctx     context.Context
	Enabled func() bool
	Name    string
	Sync    v31.AppRevisionHandlerFunc
} {
	var calls []struct {
		Ctx     context.Context
		Enabled func() bool
		Name    string
		Sync    v31.AppRevisionHandlerFunc
	}
	lockAppRevisionControllerMockAddFeatureHandler.RLock()
	calls = mock.calls.AddFeatureHandler
	lockAppRevisionControllerMockAddFeatureHandler.RUnlock()
	return calls
}

// AddHandler calls AddHandlerFunc.
func (mock *AppRevisionControllerMock) AddHandler(ctx context.Context, name string, handler v31.AppRevisionHandlerFunc) {
	if mock.AddHandlerFunc == nil {
		panic("AppRevisionControllerMock.AddHandlerFunc: method is nil but AppRevisionController.AddHandler was just called")
	}
	callInfo := struct {
		Ctx     context.Context
		Name    string
		Handler v31.AppRevisionHandlerFunc
	}{
		Ctx:     ctx,
		Name:    name,
		Handler: handler,
	}
	lockAppRevisionControllerMockAddHandler.Lock()
	mock.calls.AddHandler = append(mock.calls.AddHandler, callInfo)
	lockAppRevisionControllerMockAddHandler.Unlock()
	mock.AddHandlerFunc(ctx, name, handler)
}

// AddHandlerCalls gets all the calls that were made to AddHandler.
// Check the length with:
//     len(mockedAppRevisionController.AddHandlerCalls())
func (mock *AppRevisionControllerMock) AddHandlerCalls() []struct {
	Ctx     context.Context
	Name    string
	Handler v31.AppRevisionHandlerFunc
} {
	var calls []struct {
		Ctx     context.Context
		Name    string
		Handler v31.AppRevisionHandlerFunc
	}
	lockAppRevisionControllerMockAddHandler.RLock()
	calls = mock.calls.AddHandler
	lockAppRevisionControllerMockAddHandler.RUnlock()
	return calls
}

// Enqueue calls EnqueueFunc.
func (mock *AppRevisionControllerMock) Enqueue(namespace string, name string) {
	if mock.EnqueueFunc == nil {
		panic("AppRevisionControllerMock.EnqueueFunc: method is nil but AppRevisionController.Enqueue was just called")
	}
	callInfo := struct {
		Namespace string
		Name      string
	}{
		Namespace: namespace,
		Name:      name,
	}
	lockAppRevisionControllerMockEnqueue.Lock()
	mock.calls.Enqueue = append(mock.calls.Enqueue, callInfo)
	lockAppRevisionControllerMockEnqueue.Unlock()
	mock.EnqueueFunc(namespace, name)
}

// EnqueueCalls gets all the calls that were made to Enqueue.
// Check the length with:
//     len(mockedAppRevisionController.EnqueueCalls())
func (mock *AppRevisionControllerMock) EnqueueCalls() []struct {
	Namespace string
	Name      string
} {
	var calls []struct {
		Namespace string
		Name      string
	}
	lockAppRevisionControllerMockEnqueue.RLock()
	calls = mock.calls.Enqueue
	lockAppRevisionControllerMockEnqueue.RUnlock()
	return calls
}

// EnqueueAfter calls EnqueueAfterFunc.
func (mock *AppRevisionControllerMock) EnqueueAfter(namespace string, name string, after time.Duration) {
	if mock.EnqueueAfterFunc == nil {
		panic("AppRevisionControllerMock.EnqueueAfterFunc: method is nil but AppRevisionController.EnqueueAfter was just called")
	}
	callInfo := struct {
		Namespace string
		Name      string
		After     time.Duration
	}{
		Namespace: namespace,
		Name:      name,
		After:     after,
	}
	lockAppRevisionControllerMockEnqueueAfter.Lock()
	mock.calls.EnqueueAfter = append(mock.calls.EnqueueAfter, callInfo)
	lockAppRevisionControllerMockEnqueueAfter.Unlock()
	mock.EnqueueAfterFunc(namespace, name, after)
}

// EnqueueAfterCalls gets all the calls that were made to EnqueueAfter.
// Check the length with:
//     len(mockedAppRevisionController.EnqueueAfterCalls())
func (mock *AppRevisionControllerMock) EnqueueAfterCalls() []struct {
	Namespace string
	Name      string
	After     time.Duration
} {
	var calls []struct {
		Namespace string
		Name      string
		After     time.Duration
	}
	lockAppRevisionControllerMockEnqueueAfter.RLock()
	calls = mock.calls.EnqueueAfter
	lockAppRevisionControllerMockEnqueueAfter.RUnlock()
	return calls
}

// Generic calls GenericFunc.
func (mock *AppRevisionControllerMock) Generic() controller.GenericController {
	if mock.GenericFunc == nil {
		panic("AppRevisionControllerMock.GenericFunc: method is nil but AppRevisionController.Generic was just called")
	}
	callInfo := struct {
	}{}
	lockAppRevisionControllerMockGeneric.Lock()
	mock.calls.Generic = append(mock.calls.Generic, callInfo)
	lockAppRevisionControllerMockGeneric.Unlock()
	return mock.GenericFunc()
}

// GenericCalls gets all the calls that were made to Generic.
// Check the length with:
//     len(mockedAppRevisionController.GenericCalls())
func (mock *AppRevisionControllerMock) GenericCalls() []struct {
} {
	var calls []struct {
	}
	lockAppRevisionControllerMockGeneric.RLock()
	calls = mock.calls.Generic
	lockAppRevisionControllerMockGeneric.RUnlock()
	return calls
}

// Informer calls InformerFunc.
func (mock *AppRevisionControllerMock) Informer() cache.SharedIndexInformer {
	if mock.InformerFunc == nil {
		panic("AppRevisionControllerMock.InformerFunc: method is nil but AppRevisionController.Informer was just called")
	}
	callInfo := struct {
	}{}
	lockAppRevisionControllerMockInformer.Lock()
	mock.calls.Informer = append(mock.calls.Informer, callInfo)
	lockAppRevisionControllerMockInformer.Unlock()
	return mock.InformerFunc()
}

// InformerCalls gets all the calls that were made to Informer.
// Check the length with:
//     len(mockedAppRevisionController.InformerCalls())
func (mock *AppRevisionControllerMock) InformerCalls() []struct {
} {
	var calls []struct {
	}
	lockAppRevisionControllerMockInformer.RLock()
	calls = mock.calls.Informer
	lockAppRevisionControllerMockInformer.RUnlock()
	return calls
}

// Lister calls ListerFunc.
func (mock *AppRevisionControllerMock) Lister() v31.AppRevisionLister {
	if mock.ListerFunc == nil {
		panic("AppRevisionControllerMock.ListerFunc: method is nil but AppRevisionController.Lister was just called")
	}
	callInfo := struct {
	}{}
	lockAppRevisionControllerMockLister.Lock()
	mock.calls.Lister = append(mock.calls.Lister, callInfo)
	lockAppRevisionControllerMockLister.Unlock()
	return mock.ListerFunc()
}

// ListerCalls gets all the calls that were made to Lister.
// Check the length with:
//     len(mockedAppRevisionController.ListerCalls())
func (mock *AppRevisionControllerMock) ListerCalls() []struct {
} {
	var calls []struct {
	}
	lockAppRevisionControllerMockLister.RLock()
	calls = mock.calls.Lister
	lockAppRevisionControllerMockLister.RUnlock()
	return calls
}

var (
	lockAppRevisionInterfaceMockAddClusterScopedFeatureHandler   sync.RWMutex
	lockAppRevisionInterfaceMockAddClusterScopedFeatureLifecycle sync.RWMutex
	lockAppRevisionInterfaceMockAddClusterScopedHandler          sync.RWMutex
	lockAppRevisionInterfaceMockAddClusterScopedLifecycle        sync.RWMutex
	lockAppRevisionInterfaceMockAddFeatureHandler                sync.RWMutex
	lockAppRevisionInterfaceMockAddFeatureLifecycle              sync.RWMutex
	lockAppRevisionInterfaceMockAddHandler                       sync.RWMutex
	lockAppRevisionInterfaceMockAddLifecycle                     sync.RWMutex
	lockAppRevisionInterfaceMockController                       sync.RWMutex
	lockAppRevisionInterfaceMockCreate                           sync.RWMutex
	lockAppRevisionInterfaceMockDelete                           sync.RWMutex
	lockAppRevisionInterfaceMockDeleteCollection                 sync.RWMutex
	lockAppRevisionInterfaceMockDeleteNamespaced                 sync.RWMutex
	lockAppRevisionInterfaceMockGet                              sync.RWMutex
	lockAppRevisionInterfaceMockGetNamespaced                    sync.RWMutex
	lockAppRevisionInterfaceMockList                             sync.RWMutex
	lockAppRevisionInterfaceMockListNamespaced                   sync.RWMutex
	lockAppRevisionInterfaceMockObjectClient                     sync.RWMutex
	lockAppRevisionInterfaceMockUpdate                           sync.RWMutex
	lockAppRevisionInterfaceMockWatch                            sync.RWMutex
)

// Ensure, that AppRevisionInterfaceMock does implement v31.AppRevisionInterface.
// If this is not the case, regenerate this file with moq.
var _ v31.AppRevisionInterface = &AppRevisionInterfaceMock{}

// AppRevisionInterfaceMock is a mock implementation of v31.AppRevisionInterface.
//
//     func TestSomethingThatUsesAppRevisionInterface(t *testing.T) {
//
//         // make and configure a mocked v31.AppRevisionInterface
//         mockedAppRevisionInterface := &AppRevisionInterfaceMock{
//             AddClusterScopedFeatureHandlerFunc: func(ctx context.Context, enabled func() bool, name string, clusterName string, syncMoqParam v31.AppRevisionHandlerFunc)  {
// 	               panic("mock out the AddClusterScopedFeatureHandler method")
//             },
//             AddClusterScopedFeatureLifecycleFunc: func(ctx context.Context, enabled func() bool, name string, clusterName string, lifecycle v31.AppRevisionLifecycle)  {
// 	               panic("mock out the AddClusterScopedFeatureLifecycle method")
//             },
//             AddClusterScopedHandlerFunc: func(ctx context.Context, name string, clusterName string, syncMoqParam v31.AppRevisionHandlerFunc)  {
// 	               panic("mock out the AddClusterScopedHandler method")
//             },
//             AddClusterScopedLifecycleFunc: func(ctx context.Context, name string, clusterName string, lifecycle v31.AppRevisionLifecycle)  {
// 	               panic("mock out the AddClusterScopedLifecycle method")
//             },
//             AddFeatureHandlerFunc: func(ctx context.Context, enabled func() bool, name string, syncMoqParam v31.AppRevisionHandlerFunc)  {
// 	               panic("mock out the AddFeatureHandler method")
//             },
//             AddFeatureLifecycleFunc: func(ctx context.Context, enabled func() bool, name string, lifecycle v31.AppRevisionLifecycle)  {
// 	               panic("mock out the AddFeatureLifecycle method")
//             },
//             AddHandlerFunc: func(ctx context.Context, name string, syncMoqParam v31.AppRevisionHandlerFunc)  {
// 	               panic("mock out the AddHandler method")
//             },
//             AddLifecycleFunc: func(ctx context.Context, name string, lifecycle v31.AppRevisionLifecycle)  {
// 	               panic("mock out the AddLifecycle method")
//             },
//             ControllerFunc: func() v31.AppRevisionController {
// 	               panic("mock out the Controller method")
//             },
//             CreateFunc: func(in1 *v3.AppRevision) (*v3.AppRevision, error) {
// 	               panic("mock out the Create method")
//             },
//             DeleteFunc: func(name string, options *metav1.DeleteOptions) error {
// 	               panic("mock out the Delete method")
//             },
//             DeleteCollectionFunc: func(deleteOpts *metav1.DeleteOptions, listOpts metav1.ListOptions) error {
// 	               panic("mock out the DeleteCollection method")
//             },
//             DeleteNamespacedFunc: func(namespace string, name string, options *metav1.DeleteOptions) error {
// 	               panic("mock out the DeleteNamespaced method")
//             },
//             GetFunc: func(name string, opts metav1.GetOptions) (*v3.AppRevision, error) {
// 	               panic("mock out the Get method")
//             },
//             GetNamespacedFunc: func(namespace string, name string, opts metav1.GetOptions) (*v3.AppRevision, error) {
// 	               panic("mock out the GetNamespaced method")
//             },
//             ListFunc: func(opts metav1.ListOptions) (*v3.AppRevisionList, error) {
// 	               panic("mock out the List method")
//             },
//             ListNamespacedFunc: func(namespace string, opts metav1.ListOptions) (*v3.AppRevisionList, error) {
// 	               panic("mock out the ListNamespaced method")
//             },
//             ObjectClientFunc: func() *objectclient.ObjectClient {
// 	               panic("mock out the ObjectClient method")
//             },
//             UpdateFunc: func(in1 *v3.AppRevision) (*v3.AppRevision, error) {
// 	               panic("mock out the Update method")
//             },
//             WatchFunc: func(opts metav1.ListOptions) (watch.Interface, error) {
// 	               panic("mock out the Watch method")
//             },
//         }
//
//         // use mockedAppRevisionInterface in code that requires v31.AppRevisionInterface
//         // and then make assertions.
//
//     }
type AppRevisionInterfaceMock struct {
	// AddClusterScopedFeatureHandlerFunc mocks the AddClusterScopedFeatureHandler method.
	AddClusterScopedFeatureHandlerFunc func(ctx context.Context, enabled func() bool, name string, clusterName string, syncMoqParam v31.AppRevisionHandlerFunc)

	// AddClusterScopedFeatureLifecycleFunc mocks the AddClusterScopedFeatureLifecycle method.
	AddClusterScopedFeatureLifecycleFunc func(ctx context.Context, enabled func() bool, name string, clusterName string, lifecycle v31.AppRevisionLifecycle)

	// AddClusterScopedHandlerFunc mocks the AddClusterScopedHandler method.
	AddClusterScopedHandlerFunc func(ctx context.Context, name string, clusterName string, syncMoqParam v31.AppRevisionHandlerFunc)

	// AddClusterScopedLifecycleFunc mocks the AddClusterScopedLifecycle method.
	AddClusterScopedLifecycleFunc func(ctx context.Context, name string, clusterName string, lifecycle v31.AppRevisionLifecycle)

	// AddFeatureHandlerFunc mocks the AddFeatureHandler method.
	AddFeatureHandlerFunc func(ctx context.Context, enabled func() bool, name string, syncMoqParam v31.AppRevisionHandlerFunc)

	// AddFeatureLifecycleFunc mocks the AddFeatureLifecycle method.
	AddFeatureLifecycleFunc func(ctx context.Context, enabled func() bool, name string, lifecycle v31.AppRevisionLifecycle)

	// AddHandlerFunc mocks the AddHandler method.
	AddHandlerFunc func(ctx context.Context, name string, syncMoqParam v31.AppRevisionHandlerFunc)

	// AddLifecycleFunc mocks the AddLifecycle method.
	AddLifecycleFunc func(ctx context.Context, name string, lifecycle v31.AppRevisionLifecycle)

	// ControllerFunc mocks the Controller method.
	ControllerFunc func() v31.AppRevisionController

	// CreateFunc mocks the Create method.
	CreateFunc func(in1 *v3.AppRevision) (*v3.AppRevision, error)

	// DeleteFunc mocks the Delete method.
	DeleteFunc func(name string, options *metav1.DeleteOptions) error

	// DeleteCollectionFunc mocks the DeleteCollection method.
	DeleteCollectionFunc func(deleteOpts *metav1.DeleteOptions, listOpts metav1.ListOptions) error

	// DeleteNamespacedFunc mocks the DeleteNamespaced method.
	DeleteNamespacedFunc func(namespace string, name string, options *metav1.DeleteOptions) error

	// GetFunc mocks the Get method.
	GetFunc func(name string, opts metav1.GetOptions) (*v3.AppRevision, error)

	// GetNamespacedFunc mocks the GetNamespaced method.
	GetNamespacedFunc func(namespace string, name string, opts metav1.GetOptions) (*v3.AppRevision, error)

	// ListFunc mocks the List method.
	ListFunc func(opts metav1.ListOptions) (*v3.AppRevisionList, error)

	// ListNamespacedFunc mocks the ListNamespaced method.
	ListNamespacedFunc func(namespace string, opts metav1.ListOptions) (*v3.AppRevisionList, error)

	// ObjectClientFunc mocks the ObjectClient method.
	ObjectClientFunc func() *objectclient.ObjectClient

	// UpdateFunc mocks the Update method.
	UpdateFunc func(in1 *v3.AppRevision) (*v3.AppRevision, error)

	// WatchFunc mocks the Watch method.
	WatchFunc func(opts metav1.ListOptions) (watch.Interface, error)

	// calls tracks calls to the methods.
	calls struct {
		// AddClusterScopedFeatureHandler holds details about calls to the AddClusterScopedFeatureHandler method.
		AddClusterScopedFeatureHandler []struct {
			// Ctx is the ctx argument value.
			Ctx context.Context
			// Enabled is the enabled argument value.
			Enabled func() bool
			// Name is the name argument value.
			Name string
			// ClusterName is the clusterName argument value.
			ClusterName string
			// Sync is the sync argument value.
			Sync v31.AppRevisionHandlerFunc
		}
		// AddClusterScopedFeatureLifecycle holds details about calls to the AddClusterScopedFeatureLifecycle method.
		AddClusterScopedFeatureLifecycle []struct {
			// Ctx is the ctx argument value.
			Ctx context.Context
			// Enabled is the enabled argument value.
			Enabled func() bool
			// Name is the name argument value.
			Name string
			// ClusterName is the clusterName argument value.
			ClusterName string
			// Lifecycle is the lifecycle argument value.
			Lifecycle v31.AppRevisionLifecycle
		}
		// AddClusterScopedHandler holds details about calls to the AddClusterScopedHandler method.
		AddClusterScopedHandler []struct {
			// Ctx is the ctx argument value.
			Ctx context.Context
			// Name is the name argument value.
			Name string
			// ClusterName is the clusterName argument value.
			ClusterName string
			// Sync is the sync argument value.
			Sync v31.AppRevisionHandlerFunc
		}
		// AddClusterScopedLifecycle holds details about calls to the AddClusterScopedLifecycle method.
		AddClusterScopedLifecycle []struct {
			// Ctx is the ctx argument value.
			Ctx context.Context
			// Name is the name argument value.
			Name string
			// ClusterName is the clusterName argument value.
			ClusterName string
			// Lifecycle is the lifecycle argument value.
			Lifecycle v31.AppRevisionLifecycle
		}
		// AddFeatureHandler holds details about calls to the AddFeatureHandler method.
		AddFeatureHandler []struct {
			// Ctx is the ctx argument value.
			Ctx context.Context
			// Enabled is the enabled argument value.
			Enabled func() bool
			// Name is the name argument value.
			Name string
			// Sync is the sync argument value.
			Sync v31.AppRevisionHandlerFunc
		}
		// AddFeatureLifecycle holds details about calls to the AddFeatureLifecycle method.
		AddFeatureLifecycle []struct {
			// Ctx is the ctx argument value.
			Ctx context.Context
			// Enabled is the enabled argument value.
			Enabled func() bool
			// Name is the name argument value.
			Name string
			// Lifecycle is the lifecycle argument value.
			Lifecycle v31.AppRevisionLifecycle
		}
		// AddHandler holds details about calls to the AddHandler method.
		AddHandler []struct {
			// Ctx is the ctx argument value.
			Ctx context.Context
			// Name is the name argument value.
			Name string
			// Sync is the sync argument value.
			Sync v31.AppRevisionHandlerFunc
		}
		// AddLifecycle holds details about calls to the AddLifecycle method.
		AddLifecycle []struct {
			// Ctx is the ctx argument value.
			Ctx context.Context
			// Name is the name argument value.
			Name string
			// Lifecycle is the lifecycle argument value.
			Lifecycle v31.AppRevisionLifecycle
		}
		// Controller holds details about calls to the Controller method.
		Controller []struct {
		}
		// Create holds details about calls to the Create method.
		Create []struct {
			// In1 is the in1 argument value.
			In1 *v3.AppRevision
		}
		// Delete holds details about calls to the Delete method.
		Delete []struct {
			// Name is the name argument value.
			Name string
			// Options is the options argument value.
			Options *metav1.DeleteOptions
		}
		// DeleteCollection holds details about calls to the DeleteCollection method.
		DeleteCollection []struct {
			// DeleteOpts is the deleteOpts argument value.
			DeleteOpts *metav1.DeleteOptions
			// ListOpts is the listOpts argument value.
			ListOpts metav1.ListOptions
		}
		// DeleteNamespaced holds details about calls to the DeleteNamespaced method.
		DeleteNamespaced []struct {
			// Namespace is the namespace argument value.
			Namespace string
			// Name is the name argument value.
			Name string
			// Options is the options argument value.
			Options *metav1.DeleteOptions
		}
		// Get holds details about calls to the Get method.
		Get []struct {
			// Name is the name argument value.
			Name string
			// Opts is the opts argument value.
			Opts metav1.GetOptions
		}
		// GetNamespaced holds details about calls to the GetNamespaced method.
		GetNamespaced []struct {
			// Namespace is the namespace argument value.
			Namespace string
			// Name is the name argument value.
			Name string
			// Opts is the opts argument value.
			Opts metav1.GetOptions
		}
		// List holds details about calls to the List method.
		List []struct {
			// Opts is the opts argument value.
			Opts metav1.ListOptions
		}
		// ListNamespaced holds details about calls to the ListNamespaced method.
		ListNamespaced []struct {
			// Namespace is the namespace argument value.
			Namespace string
			// Opts is the opts argument value.
			Opts metav1.ListOptions
		}
		// ObjectClient holds details about calls to the ObjectClient method.
		ObjectClient []struct {
		}
		// Update holds details about calls to the Update method.
		Update []struct {
			// In1 is the in1 argument value.
			In1 *v3.AppRevision
		}
		// Watch holds details about calls to the Watch method.
		Watch []struct {
			// Opts is the opts argument value.
			Opts metav1.ListOptions
		}
	}
}

// AddClusterScopedFeatureHandler calls AddClusterScopedFeatureHandlerFunc.
func (mock *AppRevisionInterfaceMock) AddClusterScopedFeatureHandler(ctx context.Context, enabled func() bool, name string, clusterName string, syncMoqParam v31.AppRevisionHandlerFunc) {
	if mock.AddClusterScopedFeatureHandlerFunc == nil {
		panic("AppRevisionInterfaceMock.AddClusterScopedFeatureHandlerFunc: method is nil but AppRevisionInterface.AddClusterScopedFeatureHandler was just called")
	}
	callInfo := struct {
		Ctx         context.Context
		Enabled     func() bool
		Name        string
		ClusterName string
		Sync        v31.AppRevisionHandlerFunc
	}{
		Ctx:         ctx,
		Enabled:     enabled,
		Name:        name,
		ClusterName: clusterName,
		Sync:        syncMoqParam,
	}
	lockAppRevisionInterfaceMockAddClusterScopedFeatureHandler.Lock()
	mock.calls.AddClusterScopedFeatureHandler = append(mock.calls.AddClusterScopedFeatureHandler, callInfo)
	lockAppRevisionInterfaceMockAddClusterScopedFeatureHandler.Unlock()
	mock.AddClusterScopedFeatureHandlerFunc(ctx, enabled, name, clusterName, syncMoqParam)
}

// AddClusterScopedFeatureHandlerCalls gets all the calls that were made to AddClusterScopedFeatureHandler.
// Check the length with:
//     len(mockedAppRevisionInterface.AddClusterScopedFeatureHandlerCalls())
func (mock *AppRevisionInterfaceMock) AddClusterScopedFeatureHandlerCalls() []struct {
	Ctx         context.Context
	Enabled     func() bool
	Name        string
	ClusterName string
	Sync        v31.AppRevisionHandlerFunc
} {
	var calls []struct {
		Ctx         context.Context
		Enabled     func() bool
		Name        string
		ClusterName string
		Sync        v31.AppRevisionHandlerFunc
	}
	lockAppRevisionInterfaceMockAddClusterScopedFeatureHandler.RLock()
	calls = mock.calls.AddClusterScopedFeatureHandler
	lockAppRevisionInterfaceMockAddClusterScopedFeatureHandler.RUnlock()
	return calls
}

// AddClusterScopedFeatureLifecycle calls AddClusterScopedFeatureLifecycleFunc.
func (mock *AppRevisionInterfaceMock) AddClusterScopedFeatureLifecycle(ctx context.Context, enabled func() bool, name string, clusterName string, lifecycle v31.AppRevisionLifecycle) {
	if mock.AddClusterScopedFeatureLifecycleFunc == nil {
		panic("AppRevisionInterfaceMock.AddClusterScopedFeatureLifecycleFunc: method is nil but AppRevisionInterface.AddClusterScopedFeatureLifecycle was just called")
	}
	callInfo := struct {
		Ctx         context.Context
		Enabled     func() bool
		Name        string
		ClusterName string
		Lifecycle   v31.AppRevisionLifecycle
	}{
		Ctx:         ctx,
		Enabled:     enabled,
		Name:        name,
		ClusterName: clusterName,
		Lifecycle:   lifecycle,
	}
	lockAppRevisionInterfaceMockAddClusterScopedFeatureLifecycle.Lock()
	mock.calls.AddClusterScopedFeatureLifecycle = append(mock.calls.AddClusterScopedFeatureLifecycle, callInfo)
	lockAppRevisionInterfaceMockAddClusterScopedFeatureLifecycle.Unlock()
	mock.AddClusterScopedFeatureLifecycleFunc(ctx, enabled, name, clusterName, lifecycle)
}

// AddClusterScopedFeatureLifecycleCalls gets all the calls that were made to AddClusterScopedFeatureLifecycle.
// Check the length with:
//     len(mockedAppRevisionInterface.AddClusterScopedFeatureLifecycleCalls())
func (mock *AppRevisionInterfaceMock) AddClusterScopedFeatureLifecycleCalls() []struct {
	Ctx         context.Context
	Enabled     func() bool
	Name        string
	ClusterName string
	Lifecycle   v31.AppRevisionLifecycle
} {
	var calls []struct {
		Ctx         context.Context
		Enabled     func() bool
		Name        string
		ClusterName string
		Lifecycle   v31.AppRevisionLifecycle
	}
	lockAppRevisionInterfaceMockAddClusterScopedFeatureLifecycle.RLock()
	calls = mock.calls.AddClusterScopedFeatureLifecycle
	lockAppRevisionInterfaceMockAddClusterScopedFeatureLifecycle.RUnlock()
	return calls
}

// AddClusterScopedHandler calls AddClusterScopedHandlerFunc.
func (mock *AppRevisionInterfaceMock) AddClusterScopedHandler(ctx context.Context, name string, clusterName string, syncMoqParam v31.AppRevisionHandlerFunc) {
	if mock.AddClusterScopedHandlerFunc == nil {
		panic("AppRevisionInterfaceMock.AddClusterScopedHandlerFunc: method is nil but AppRevisionInterface.AddClusterScopedHandler was just called")
	}
	callInfo := struct {
		Ctx         context.Context
		Name        string
		ClusterName string
		Sync        v31.AppRevisionHandlerFunc
	}{
		Ctx:         ctx,
		Name:        name,
		ClusterName: clusterName,
		Sync:        syncMoqParam,
	}
	lockAppRevisionInterfaceMockAddClusterScopedHandler.Lock()
	mock.calls.AddClusterScopedHandler = append(mock.calls.AddClusterScopedHandler, callInfo)
	lockAppRevisionInterfaceMockAddClusterScopedHandler.Unlock()
	mock.AddClusterScopedHandlerFunc(ctx, name, clusterName, syncMoqParam)
}

// AddClusterScopedHandlerCalls gets all the calls that were made to AddClusterScopedHandler.
// Check the length with:
//     len(mockedAppRevisionInterface.AddClusterScopedHandlerCalls())
func (mock *AppRevisionInterfaceMock) AddClusterScopedHandlerCalls() []struct {
	Ctx         context.Context
	Name        string
	ClusterName string
	Sync        v31.AppRevisionHandlerFunc
} {
	var calls []struct {
		Ctx         context.Context
		Name        string
		ClusterName string
		Sync        v31.AppRevisionHandlerFunc
	}
	lockAppRevisionInterfaceMockAddClusterScopedHandler.RLock()
	calls = mock.calls.AddClusterScopedHandler
	lockAppRevisionInterfaceMockAddClusterScopedHandler.RUnlock()
	return calls
}

// AddClusterScopedLifecycle calls AddClusterScopedLifecycleFunc.
func (mock *AppRevisionInterfaceMock) AddClusterScopedLifecycle(ctx context.Context, name string, clusterName string, lifecycle v31.AppRevisionLifecycle) {
	if mock.AddClusterScopedLifecycleFunc == nil {
		panic("AppRevisionInterfaceMock.AddClusterScopedLifecycleFunc: method is nil but AppRevisionInterface.AddClusterScopedLifecycle was just called")
	}
	callInfo := struct {
		Ctx         context.Context
		Name        string
		ClusterName string
		Lifecycle   v31.AppRevisionLifecycle
	}{
		Ctx:         ctx,
		Name:        name,
		ClusterName: clusterName,
		Lifecycle:   lifecycle,
	}
	lockAppRevisionInterfaceMockAddClusterScopedLifecycle.Lock()
	mock.calls.AddClusterScopedLifecycle = append(mock.calls.AddClusterScopedLifecycle, callInfo)
	lockAppRevisionInterfaceMockAddClusterScopedLifecycle.Unlock()
	mock.AddClusterScopedLifecycleFunc(ctx, name, clusterName, lifecycle)
}

// AddClusterScopedLifecycleCalls gets all the calls that were made to AddClusterScopedLifecycle.
// Check the length with:
//     len(mockedAppRevisionInterface.AddClusterScopedLifecycleCalls())
func (mock *AppRevisionInterfaceMock) AddClusterScopedLifecycleCalls() []struct {
	Ctx         context.Context
	Name        string
	ClusterName string
	Lifecycle   v31.AppRevisionLifecycle
} {
	var calls []struct {
		Ctx         context.Context
		Name        string
		ClusterName string
		Lifecycle   v31.AppRevisionLifecycle
	}
	lockAppRevisionInterfaceMockAddClusterScopedLifecycle.RLock()
	calls = mock.calls.AddClusterScopedLifecycle
	lockAppRevisionInterfaceMockAddClusterScopedLifecycle.RUnlock()
	return calls
}

// AddFeatureHandler calls AddFeatureHandlerFunc.
func (mock *AppRevisionInterfaceMock) AddFeatureHandler(ctx context.Context, enabled func() bool, name string, syncMoqParam v31.AppRevisionHandlerFunc) {
	if mock.AddFeatureHandlerFunc == nil {
		panic("AppRevisionInterfaceMock.AddFeatureHandlerFunc: method is nil but AppRevisionInterface.AddFeatureHandler was just called")
	}
	callInfo := struct {
		Ctx     context.Context
		Enabled func() bool
		Name    string
		Sync    v31.AppRevisionHandlerFunc
	}{
		Ctx:     ctx,
		Enabled: enabled,
		Name:    name,
		Sync:    syncMoqParam,
	}
	lockAppRevisionInterfaceMockAddFeatureHandler.Lock()
	mock.calls.AddFeatureHandler = append(mock.calls.AddFeatureHandler, callInfo)
	lockAppRevisionInterfaceMockAddFeatureHandler.Unlock()
	mock.AddFeatureHandlerFunc(ctx, enabled, name, syncMoqParam)
}

// AddFeatureHandlerCalls gets all the calls that were made to AddFeatureHandler.
// Check the length with:
//     len(mockedAppRevisionInterface.AddFeatureHandlerCalls())
func (mock *AppRevisionInterfaceMock) AddFeatureHandlerCalls() []struct {
	Ctx     context.Context
	Enabled func() bool
	Name    string
	Sync    v31.AppRevisionHandlerFunc
} {
	var calls []struct {
		Ctx     context.Context
		Enabled func() bool
		Name    string
		Sync    v31.AppRevisionHandlerFunc
	}
	lockAppRevisionInterfaceMockAddFeatureHandler.RLock()
	calls = mock.calls.AddFeatureHandler
	lockAppRevisionInterfaceMockAddFeatureHandler.RUnlock()
	return calls
}

// AddFeatureLifecycle calls AddFeatureLifecycleFunc.
func (mock *AppRevisionInterfaceMock) AddFeatureLifecycle(ctx context.Context, enabled func() bool, name string, lifecycle v31.AppRevisionLifecycle) {
	if mock.AddFeatureLifecycleFunc == nil {
		panic("AppRevisionInterfaceMock.AddFeatureLifecycleFunc: method is nil but AppRevisionInterface.AddFeatureLifecycle was just called")
	}
	callInfo := struct {
		Ctx       context.Context
		Enabled   func() bool
		Name      string
		Lifecycle v31.AppRevisionLifecycle
	}{
		Ctx:       ctx,
		Enabled:   enabled,
		Name:      name,
		Lifecycle: lifecycle,
	}
	lockAppRevisionInterfaceMockAddFeatureLifecycle.Lock()
	mock.calls.AddFeatureLifecycle = append(mock.calls.AddFeatureLifecycle, callInfo)
	lockAppRevisionInterfaceMockAddFeatureLifecycle.Unlock()
	mock.AddFeatureLifecycleFunc(ctx, enabled, name, lifecycle)
}

// AddFeatureLifecycleCalls gets all the calls that were made to AddFeatureLifecycle.
// Check the length with:
//     len(mockedAppRevisionInterface.AddFeatureLifecycleCalls())
func (mock *AppRevisionInterfaceMock) AddFeatureLifecycleCalls() []struct {
	Ctx       context.Context
	Enabled   func() bool
	Name      string
	Lifecycle v31.AppRevisionLifecycle
} {
	var calls []struct {
		Ctx       context.Context
		Enabled   func() bool
		Name      string
		Lifecycle v31.AppRevisionLifecycle
	}
	lockAppRevisionInterfaceMockAddFeatureLifecycle.RLock()
	calls = mock.calls.AddFeatureLifecycle
	lockAppRevisionInterfaceMockAddFeatureLifecycle.RUnlock()
	return calls
}

// AddHandler calls AddHandlerFunc.
func (mock *AppRevisionInterfaceMock) AddHandler(ctx context.Context, name string, syncMoqParam v31.AppRevisionHandlerFunc) {
	if mock.AddHandlerFunc == nil {
		panic("AppRevisionInterfaceMock.AddHandlerFunc: method is nil but AppRevisionInterface.AddHandler was just called")
	}
	callInfo := struct {
		Ctx  context.Context
		Name string
		Sync v31.AppRevisionHandlerFunc
	}{
		Ctx:  ctx,
		Name: name,
		Sync: syncMoqParam,
	}
	lockAppRevisionInterfaceMockAddHandler.Lock()
	mock.calls.AddHandler = append(mock.calls.AddHandler, callInfo)
	lockAppRevisionInterfaceMockAddHandler.Unlock()
	mock.AddHandlerFunc(ctx, name, syncMoqParam)
}

// AddHandlerCalls gets all the calls that were made to AddHandler.
// Check the length with:
//     len(mockedAppRevisionInterface.AddHandlerCalls())
func (mock *AppRevisionInterfaceMock) AddHandlerCalls() []struct {
	Ctx  context.Context
	Name string
	Sync v31.AppRevisionHandlerFunc
} {
	var calls []struct {
		Ctx  context.Context
		Name string
		Sync v31.AppRevisionHandlerFunc
	}
	lockAppRevisionInterfaceMockAddHandler.RLock()
	calls = mock.calls.AddHandler
	lockAppRevisionInterfaceMockAddHandler.RUnlock()
	return calls
}

// AddLifecycle calls AddLifecycleFunc.
func (mock *AppRevisionInterfaceMock) AddLifecycle(ctx context.Context, name string, lifecycle v31.AppRevisionLifecycle) {
	if mock.AddLifecycleFunc == nil {
		panic("AppRevisionInterfaceMock.AddLifecycleFunc: method is nil but AppRevisionInterface.AddLifecycle was just called")
	}
	callInfo := struct {
		Ctx       context.Context
		Name      string
		Lifecycle v31.AppRevisionLifecycle
	}{
		Ctx:       ctx,
		Name:      name,
		Lifecycle: lifecycle,
	}
	lockAppRevisionInterfaceMockAddLifecycle.Lock()
	mock.calls.AddLifecycle = append(mock.calls.AddLifecycle, callInfo)
	lockAppRevisionInterfaceMockAddLifecycle.Unlock()
	mock.AddLifecycleFunc(ctx, name, lifecycle)
}

// AddLifecycleCalls gets all the calls that were made to AddLifecycle.
// Check the length with:
//     len(mockedAppRevisionInterface.AddLifecycleCalls())
func (mock *AppRevisionInterfaceMock) AddLifecycleCalls() []struct {
	Ctx       context.Context
	Name      string
	Lifecycle v31.AppRevisionLifecycle
} {
	var calls []struct {
		Ctx       context.Context
		Name      string
		Lifecycle v31.AppRevisionLifecycle
	}
	lockAppRevisionInterfaceMockAddLifecycle.RLock()
	calls = mock.calls.AddLifecycle
	lockAppRevisionInterfaceMockAddLifecycle.RUnlock()
	return calls
}

// Controller calls ControllerFunc.
func (mock *AppRevisionInterfaceMock) Controller() v31.AppRevisionController {
	if mock.ControllerFunc == nil {
		panic("AppRevisionInterfaceMock.ControllerFunc: method is nil but AppRevisionInterface.Controller was just called")
	}
	callInfo := struct {
	}{}
	lockAppRevisionInterfaceMockController.Lock()
	mock.calls.Controller = append(mock.calls.Controller, callInfo)
	lockAppRevisionInterfaceMockController.Unlock()
	return mock.ControllerFunc()
}

// ControllerCalls gets all the calls that were made to Controller.
// Check the length with:
//     len(mockedAppRevisionInterface.ControllerCalls())
func (mock *AppRevisionInterfaceMock) ControllerCalls() []struct {
} {
	var calls []struct {
	}
	lockAppRevisionInterfaceMockController.RLock()
	calls = mock.calls.Controller
	lockAppRevisionInterfaceMockController.RUnlock()
	return calls
}

// Create calls CreateFunc.
func (mock *AppRevisionInterfaceMock) Create(in1 *v3.AppRevision) (*v3.AppRevision, error) {
	if mock.CreateFunc == nil {
		panic("AppRevisionInterfaceMock.CreateFunc: method is nil but AppRevisionInterface.Create was just called")
	}
	callInfo := struct {
		In1 *v3.AppRevision
	}{
		In1: in1,
	}
	lockAppRevisionInterfaceMockCreate.Lock()
	mock.calls.Create = append(mock.calls.Create, callInfo)
	lockAppRevisionInterfaceMockCreate.Unlock()
	return mock.CreateFunc(in1)
}

// CreateCalls gets all the calls that were made to Create.
// Check the length with:
//     len(mockedAppRevisionInterface.CreateCalls())
func (mock *AppRevisionInterfaceMock) CreateCalls() []struct {
	In1 *v3.AppRevision
} {
	var calls []struct {
		In1 *v3.AppRevision
	}
	lockAppRevisionInterfaceMockCreate.RLock()
	calls = mock.calls.Create
	lockAppRevisionInterfaceMockCreate.RUnlock()
	return calls
}

// Delete calls DeleteFunc.
func (mock *AppRevisionInterfaceMock) Delete(name string, options *metav1.DeleteOptions) error {
	if mock.DeleteFunc == nil {
		panic("AppRevisionInterfaceMock.DeleteFunc: method is nil but AppRevisionInterface.Delete was just called")
	}
	callInfo := struct {
		Name    string
		Options *metav1.DeleteOptions
	}{
		Name:    name,
		Options: options,
	}
	lockAppRevisionInterfaceMockDelete.Lock()
	mock.calls.Delete = append(mock.calls.Delete, callInfo)
	lockAppRevisionInterfaceMockDelete.Unlock()
	return mock.DeleteFunc(name, options)
}

// DeleteCalls gets all the calls that were made to Delete.
// Check the length with:
//     len(mockedAppRevisionInterface.DeleteCalls())
func (mock *AppRevisionInterfaceMock) DeleteCalls() []struct {
	Name    string
	Options *metav1.DeleteOptions
} {
	var calls []struct {
		Name    string
		Options *metav1.DeleteOptions
	}
	lockAppRevisionInterfaceMockDelete.RLock()
	calls = mock.calls.Delete
	lockAppRevisionInterfaceMockDelete.RUnlock()
	return calls
}

// DeleteCollection calls DeleteCollectionFunc.
func (mock *AppRevisionInterfaceMock) DeleteCollection(deleteOpts *metav1.DeleteOptions, listOpts metav1.ListOptions) error {
	if mock.DeleteCollectionFunc == nil {
		panic("AppRevisionInterfaceMock.DeleteCollectionFunc: method is nil but AppRevisionInterface.DeleteCollection was just called")
	}
	callInfo := struct {
		DeleteOpts *metav1.DeleteOptions
		ListOpts   metav1.ListOptions
	}{
		DeleteOpts: deleteOpts,
		ListOpts:   listOpts,
	}
	lockAppRevisionInterfaceMockDeleteCollection.Lock()
	mock.calls.DeleteCollection = append(mock.calls.DeleteCollection, callInfo)
	lockAppRevisionInterfaceMockDeleteCollection.Unlock()
	return mock.DeleteCollectionFunc(deleteOpts, listOpts)
}

// DeleteCollectionCalls gets all the calls that were made to DeleteCollection.
// Check the length with:
//     len(mockedAppRevisionInterface.DeleteCollectionCalls())
func (mock *AppRevisionInterfaceMock) DeleteCollectionCalls() []struct {
	DeleteOpts *metav1.DeleteOptions
	ListOpts   metav1.ListOptions
} {
	var calls []struct {
		DeleteOpts *metav1.DeleteOptions
		ListOpts   metav1.ListOptions
	}
	lockAppRevisionInterfaceMockDeleteCollection.RLock()
	calls = mock.calls.DeleteCollection
	lockAppRevisionInterfaceMockDeleteCollection.RUnlock()
	return calls
}

// DeleteNamespaced calls DeleteNamespacedFunc.
func (mock *AppRevisionInterfaceMock) DeleteNamespaced(namespace string, name string, options *metav1.DeleteOptions) error {
	if mock.DeleteNamespacedFunc == nil {
		panic("AppRevisionInterfaceMock.DeleteNamespacedFunc: method is nil but AppRevisionInterface.DeleteNamespaced was just called")
	}
	callInfo := struct {
		Namespace string
		Name      string
		Options   *metav1.DeleteOptions
	}{
		Namespace: namespace,
		Name:      name,
		Options:   options,
	}
	lockAppRevisionInterfaceMockDeleteNamespaced.Lock()
	mock.calls.DeleteNamespaced = append(mock.calls.DeleteNamespaced, callInfo)
	lockAppRevisionInterfaceMockDeleteNamespaced.Unlock()
	return mock.DeleteNamespacedFunc(namespace, name, options)
}

// DeleteNamespacedCalls gets all the calls that were made to DeleteNamespaced.
// Check the length with:
//     len(mockedAppRevisionInterface.DeleteNamespacedCalls())
func (mock *AppRevisionInterfaceMock) DeleteNamespacedCalls() []struct {
	Namespace string
	Name      string
	Options   *metav1.DeleteOptions
} {
	var calls []struct {
		Namespace string
		Name      string
		Options   *metav1.DeleteOptions
	}
	lockAppRevisionInterfaceMockDeleteNamespaced.RLock()
	calls = mock.calls.DeleteNamespaced
	lockAppRevisionInterfaceMockDeleteNamespaced.RUnlock()
	return calls
}

// Get calls GetFunc.
func (mock *AppRevisionInterfaceMock) Get(name string, opts metav1.GetOptions) (*v3.AppRevision, error) {
	if mock.GetFunc == nil {
		panic("AppRevisionInterfaceMock.GetFunc: method is nil but AppRevisionInterface.Get was just called")
	}
	callInfo := struct {
		Name string
		Opts metav1.GetOptions
	}{
		Name: name,
		Opts: opts,
	}
	lockAppRevisionInterfaceMockGet.Lock()
	mock.calls.Get = append(mock.calls.Get, callInfo)
	lockAppRevisionInterfaceMockGet.Unlock()
	return mock.GetFunc(name, opts)
}

// GetCalls gets all the calls that were made to Get.
// Check the length with:
//     len(mockedAppRevisionInterface.GetCalls())
func (mock *AppRevisionInterfaceMock) GetCalls() []struct {
	Name string
	Opts metav1.GetOptions
} {
	var calls []struct {
		Name string
		Opts metav1.GetOptions
	}
	lockAppRevisionInterfaceMockGet.RLock()
	calls = mock.calls.Get
	lockAppRevisionInterfaceMockGet.RUnlock()
	return calls
}

// GetNamespaced calls GetNamespacedFunc.
func (mock *AppRevisionInterfaceMock) GetNamespaced(namespace string, name string, opts metav1.GetOptions) (*v3.AppRevision, error) {
	if mock.GetNamespacedFunc == nil {
		panic("AppRevisionInterfaceMock.GetNamespacedFunc: method is nil but AppRevisionInterface.GetNamespaced was just called")
	}
	callInfo := struct {
		Namespace string
		Name      string
		Opts      metav1.GetOptions
	}{
		Namespace: namespace,
		Name:      name,
		Opts:      opts,
	}
	lockAppRevisionInterfaceMockGetNamespaced.Lock()
	mock.calls.GetNamespaced = append(mock.calls.GetNamespaced, callInfo)
	lockAppRevisionInterfaceMockGetNamespaced.Unlock()
	return mock.GetNamespacedFunc(namespace, name, opts)
}

// GetNamespacedCalls gets all the calls that were made to GetNamespaced.
// Check the length with:
//     len(mockedAppRevisionInterface.GetNamespacedCalls())
func (mock *AppRevisionInterfaceMock) GetNamespacedCalls() []struct {
	Namespace string
	Name      string
	Opts      metav1.GetOptions
} {
	var calls []struct {
		Namespace string
		Name      string
		Opts      metav1.GetOptions
	}
	lockAppRevisionInterfaceMockGetNamespaced.RLock()
	calls = mock.calls.GetNamespaced
	lockAppRevisionInterfaceMockGetNamespaced.RUnlock()
	return calls
}

// List calls ListFunc.
func (mock *AppRevisionInterfaceMock) List(opts metav1.ListOptions) (*v3.AppRevisionList, error) {
	if mock.ListFunc == nil {
		panic("AppRevisionInterfaceMock.ListFunc: method is nil but AppRevisionInterface.List was just called")
	}
	callInfo := struct {
		Opts metav1.ListOptions
	}{
		Opts: opts,
	}
	lockAppRevisionInterfaceMockList.Lock()
	mock.calls.List = append(mock.calls.List, callInfo)
	lockAppRevisionInterfaceMockList.Unlock()
	return mock.ListFunc(opts)
}

// ListCalls gets all the calls that were made to List.
// Check the length with:
//     len(mockedAppRevisionInterface.ListCalls())
func (mock *AppRevisionInterfaceMock) ListCalls() []struct {
	Opts metav1.ListOptions
} {
	var calls []struct {
		Opts metav1.ListOptions
	}
	lockAppRevisionInterfaceMockList.RLock()
	calls = mock.calls.List
	lockAppRevisionInterfaceMockList.RUnlock()
	return calls
}

// ListNamespaced calls ListNamespacedFunc.
func (mock *AppRevisionInterfaceMock) ListNamespaced(namespace string, opts metav1.ListOptions) (*v3.AppRevisionList, error) {
	if mock.ListNamespacedFunc == nil {
		panic("AppRevisionInterfaceMock.ListNamespacedFunc: method is nil but AppRevisionInterface.ListNamespaced was just called")
	}
	callInfo := struct {
		Namespace string
		Opts      metav1.ListOptions
	}{
		Namespace: namespace,
		Opts:      opts,
	}
	lockAppRevisionInterfaceMockListNamespaced.Lock()
	mock.calls.ListNamespaced = append(mock.calls.ListNamespaced, callInfo)
	lockAppRevisionInterfaceMockListNamespaced.Unlock()
	return mock.ListNamespacedFunc(namespace, opts)
}

// ListNamespacedCalls gets all the calls that were made to ListNamespaced.
// Check the length with:
//     len(mockedAppRevisionInterface.ListNamespacedCalls())
func (mock *AppRevisionInterfaceMock) ListNamespacedCalls() []struct {
	Namespace string
	Opts      metav1.ListOptions
} {
	var calls []struct {
		Namespace string
		Opts      metav1.ListOptions
	}
	lockAppRevisionInterfaceMockListNamespaced.RLock()
	calls = mock.calls.ListNamespaced
	lockAppRevisionInterfaceMockListNamespaced.RUnlock()
	return calls
}

// ObjectClient calls ObjectClientFunc.
func (mock *AppRevisionInterfaceMock) ObjectClient() *objectclient.ObjectClient {
	if mock.ObjectClientFunc == nil {
		panic("AppRevisionInterfaceMock.ObjectClientFunc: method is nil but AppRevisionInterface.ObjectClient was just called")
	}
	callInfo := struct {
	}{}
	lockAppRevisionInterfaceMockObjectClient.Lock()
	mock.calls.ObjectClient = append(mock.calls.ObjectClient, callInfo)
	lockAppRevisionInterfaceMockObjectClient.Unlock()
	return mock.ObjectClientFunc()
}

// ObjectClientCalls gets all the calls that were made to ObjectClient.
// Check the length with:
//     len(mockedAppRevisionInterface.ObjectClientCalls())
func (mock *AppRevisionInterfaceMock) ObjectClientCalls() []struct {
} {
	var calls []struct {
	}
	lockAppRevisionInterfaceMockObjectClient.RLock()
	calls = mock.calls.ObjectClient
	lockAppRevisionInterfaceMockObjectClient.RUnlock()
	return calls
}

// Update calls UpdateFunc.
func (mock *AppRevisionInterfaceMock) Update(in1 *v3.AppRevision) (*v3.AppRevision, error) {
	if mock.UpdateFunc == nil {
		panic("AppRevisionInterfaceMock.UpdateFunc: method is nil but AppRevisionInterface.Update was just called")
	}
	callInfo := struct {
		In1 *v3.AppRevision
	}{
		In1: in1,
	}
	lockAppRevisionInterfaceMockUpdate.Lock()
	mock.calls.Update = append(mock.calls.Update, callInfo)
	lockAppRevisionInterfaceMockUpdate.Unlock()
	return mock.UpdateFunc(in1)
}

// UpdateCalls gets all the calls that were made to Update.
// Check the length with:
//     len(mockedAppRevisionInterface.UpdateCalls())
func (mock *AppRevisionInterfaceMock) UpdateCalls() []struct {
	In1 *v3.AppRevision
} {
	var calls []struct {
		In1 *v3.AppRevision
	}
	lockAppRevisionInterfaceMockUpdate.RLock()
	calls = mock.calls.Update
	lockAppRevisionInterfaceMockUpdate.RUnlock()
	return calls
}

// Watch calls WatchFunc.
func (mock *AppRevisionInterfaceMock) Watch(opts metav1.ListOptions) (watch.Interface, error) {
	if mock.WatchFunc == nil {
		panic("AppRevisionInterfaceMock.WatchFunc: method is nil but AppRevisionInterface.Watch was just called")
	}
	callInfo := struct {
		Opts metav1.ListOptions
	}{
		Opts: opts,
	}
	lockAppRevisionInterfaceMockWatch.Lock()
	mock.calls.Watch = append(mock.calls.Watch, callInfo)
	lockAppRevisionInterfaceMockWatch.Unlock()
	return mock.WatchFunc(opts)
}

// WatchCalls gets all the calls that were made to Watch.
// Check the length with:
//     len(mockedAppRevisionInterface.WatchCalls())
func (mock *AppRevisionInterfaceMock) WatchCalls() []struct {
	Opts metav1.ListOptions
} {
	var calls []struct {
		Opts metav1.ListOptions
	}
	lockAppRevisionInterfaceMockWatch.RLock()
	calls = mock.calls.Watch
	lockAppRevisionInterfaceMockWatch.RUnlock()
	return calls
}

var (
	lockAppRevisionsGetterMockAppRevisions sync.RWMutex
)

// Ensure, that AppRevisionsGetterMock does implement v31.AppRevisionsGetter.
// If this is not the case, regenerate this file with moq.
var _ v31.AppRevisionsGetter = &AppRevisionsGetterMock{}

// AppRevisionsGetterMock is a mock implementation of v31.AppRevisionsGetter.
//
//     func TestSomethingThatUsesAppRevisionsGetter(t *testing.T) {
//
//         // make and configure a mocked v31.AppRevisionsGetter
//         mockedAppRevisionsGetter := &AppRevisionsGetterMock{
//             AppRevisionsFunc: func(namespace string) v31.AppRevisionInterface {
// 	               panic("mock out the AppRevisions method")
//             },
//         }
//
//         // use mockedAppRevisionsGetter in code that requires v31.AppRevisionsGetter
//         // and then make assertions.
//
//     }
type AppRevisionsGetterMock struct {
	// AppRevisionsFunc mocks the AppRevisions method.
	AppRevisionsFunc func(namespace string) v31.AppRevisionInterface

	// calls tracks calls to the methods.
	calls struct {
		// AppRevisions holds details about calls to the AppRevisions method.
		AppRevisions []struct {
			// Namespace is the namespace argument value.
			Namespace string
		}
	}
}

// AppRevisions calls AppRevisionsFunc.
func (mock *AppRevisionsGetterMock) AppRevisions(namespace string) v31.AppRevisionInterface {
	if mock.AppRevisionsFunc == nil {
		panic("AppRevisionsGetterMock.AppRevisionsFunc: method is nil but AppRevisionsGetter.AppRevisions was just called")
	}
	callInfo := struct {
		Namespace string
	}{
		Namespace: namespace,
	}
	lockAppRevisionsGetterMockAppRevisions.Lock()
	mock.calls.AppRevisions = append(mock.calls.AppRevisions, callInfo)
	lockAppRevisionsGetterMockAppRevisions.Unlock()
	return mock.AppRevisionsFunc(namespace)
}

// AppRevisionsCalls gets all the calls that were made to AppRevisions.
// Check the length with:
//     len(mockedAppRevisionsGetter.AppRevisionsCalls())
func (mock *AppRevisionsGetterMock) AppRevisionsCalls() []struct {
	Namespace string
} {
	var calls []struct {
		Namespace string
	}
	lockAppRevisionsGetterMockAppRevisions.RLock()
	calls = mock.calls.AppRevisions
	lockAppRevisionsGetterMockAppRevisions.RUnlock()
	return calls
}
