// Code generated by moq; DO NOT EDIT.
// github.com/matryer/moq

package fakes

import (
	"context"
	"sync"
	"time"

	"github.com/rancher/norman/controller"
	"github.com/rancher/norman/objectclient"
	v3 "github.com/rancher/rancher/pkg/apis/project.cattle.io/v3"
	v31 "github.com/rancher/rancher/pkg/generated/norman/project.cattle.io/v3"
	metav1 "k8s.io/apimachinery/pkg/apis/meta/v1"
	"k8s.io/apimachinery/pkg/labels"
	"k8s.io/apimachinery/pkg/watch"
	"k8s.io/client-go/tools/cache"
)

var (
	lockCertificateListerMockGet  sync.RWMutex
	lockCertificateListerMockList sync.RWMutex
)

// Ensure, that CertificateListerMock does implement v31.CertificateLister.
// If this is not the case, regenerate this file with moq.
var _ v31.CertificateLister = &CertificateListerMock{}

// CertificateListerMock is a mock implementation of v31.CertificateLister.
//
//     func TestSomethingThatUsesCertificateLister(t *testing.T) {
//
//         // make and configure a mocked v31.CertificateLister
//         mockedCertificateLister := &CertificateListerMock{
//             GetFunc: func(namespace string, name string) (*v3.Certificate, error) {
// 	               panic("mock out the Get method")
//             },
//             ListFunc: func(namespace string, selector labels.Selector) ([]*v3.Certificate, error) {
// 	               panic("mock out the List method")
//             },
//         }
//
//         // use mockedCertificateLister in code that requires v31.CertificateLister
//         // and then make assertions.
//
//     }
type CertificateListerMock struct {
	// GetFunc mocks the Get method.
	GetFunc func(namespace string, name string) (*v3.Certificate, error)

	// ListFunc mocks the List method.
	ListFunc func(namespace string, selector labels.Selector) ([]*v3.Certificate, error)

	// calls tracks calls to the methods.
	calls struct {
		// Get holds details about calls to the Get method.
		Get []struct {
			// Namespace is the namespace argument value.
			Namespace string
			// Name is the name argument value.
			Name string
		}
		// List holds details about calls to the List method.
		List []struct {
			// Namespace is the namespace argument value.
			Namespace string
			// Selector is the selector argument value.
			Selector labels.Selector
		}
	}
}

// Get calls GetFunc.
func (mock *CertificateListerMock) Get(namespace string, name string) (*v3.Certificate, error) {
	if mock.GetFunc == nil {
		panic("CertificateListerMock.GetFunc: method is nil but CertificateLister.Get was just called")
	}
	callInfo := struct {
		Namespace string
		Name      string
	}{
		Namespace: namespace,
		Name:      name,
	}
	lockCertificateListerMockGet.Lock()
	mock.calls.Get = append(mock.calls.Get, callInfo)
	lockCertificateListerMockGet.Unlock()
	return mock.GetFunc(namespace, name)
}

// GetCalls gets all the calls that were made to Get.
// Check the length with:
//     len(mockedCertificateLister.GetCalls())
func (mock *CertificateListerMock) GetCalls() []struct {
	Namespace string
	Name      string
} {
	var calls []struct {
		Namespace string
		Name      string
	}
	lockCertificateListerMockGet.RLock()
	calls = mock.calls.Get
	lockCertificateListerMockGet.RUnlock()
	return calls
}

// List calls ListFunc.
func (mock *CertificateListerMock) List(namespace string, selector labels.Selector) ([]*v3.Certificate, error) {
	if mock.ListFunc == nil {
		panic("CertificateListerMock.ListFunc: method is nil but CertificateLister.List was just called")
	}
	callInfo := struct {
		Namespace string
		Selector  labels.Selector
	}{
		Namespace: namespace,
		Selector:  selector,
	}
	lockCertificateListerMockList.Lock()
	mock.calls.List = append(mock.calls.List, callInfo)
	lockCertificateListerMockList.Unlock()
	return mock.ListFunc(namespace, selector)
}

// ListCalls gets all the calls that were made to List.
// Check the length with:
//     len(mockedCertificateLister.ListCalls())
func (mock *CertificateListerMock) ListCalls() []struct {
	Namespace string
	Selector  labels.Selector
} {
	var calls []struct {
		Namespace string
		Selector  labels.Selector
	}
	lockCertificateListerMockList.RLock()
	calls = mock.calls.List
	lockCertificateListerMockList.RUnlock()
	return calls
}

var (
	lockCertificateControllerMockAddClusterScopedFeatureHandler sync.RWMutex
	lockCertificateControllerMockAddClusterScopedHandler        sync.RWMutex
	lockCertificateControllerMockAddFeatureHandler              sync.RWMutex
	lockCertificateControllerMockAddHandler                     sync.RWMutex
	lockCertificateControllerMockEnqueue                        sync.RWMutex
	lockCertificateControllerMockEnqueueAfter                   sync.RWMutex
	lockCertificateControllerMockGeneric                        sync.RWMutex
	lockCertificateControllerMockInformer                       sync.RWMutex
	lockCertificateControllerMockLister                         sync.RWMutex
)

// Ensure, that CertificateControllerMock does implement v31.CertificateController.
// If this is not the case, regenerate this file with moq.
var _ v31.CertificateController = &CertificateControllerMock{}

// CertificateControllerMock is a mock implementation of v31.CertificateController.
//
//     func TestSomethingThatUsesCertificateController(t *testing.T) {
//
//         // make and configure a mocked v31.CertificateController
//         mockedCertificateController := &CertificateControllerMock{
//             AddClusterScopedFeatureHandlerFunc: func(ctx context.Context, enabled func() bool, name string, clusterName string, handler v31.CertificateHandlerFunc)  {
// 	               panic("mock out the AddClusterScopedFeatureHandler method")
//             },
//             AddClusterScopedHandlerFunc: func(ctx context.Context, name string, clusterName string, handler v31.CertificateHandlerFunc)  {
// 	               panic("mock out the AddClusterScopedHandler method")
//             },
//             AddFeatureHandlerFunc: func(ctx context.Context, enabled func() bool, name string, syncMoqParam v31.CertificateHandlerFunc)  {
// 	               panic("mock out the AddFeatureHandler method")
//             },
//             AddHandlerFunc: func(ctx context.Context, name string, handler v31.CertificateHandlerFunc)  {
// 	               panic("mock out the AddHandler method")
//             },
//             EnqueueFunc: func(namespace string, name string)  {
// 	               panic("mock out the Enqueue method")
//             },
//             EnqueueAfterFunc: func(namespace string, name string, after time.Duration)  {
// 	               panic("mock out the EnqueueAfter method")
//             },
//             GenericFunc: func() controller.GenericController {
// 	               panic("mock out the Generic method")
//             },
//             InformerFunc: func() cache.SharedIndexInformer {
// 	               panic("mock out the Informer method")
//             },
//             ListerFunc: func() v31.CertificateLister {
// 	               panic("mock out the Lister method")
//             },
//         }
//
//         // use mockedCertificateController in code that requires v31.CertificateController
//         // and then make assertions.
//
//     }
type CertificateControllerMock struct {
	// AddClusterScopedFeatureHandlerFunc mocks the AddClusterScopedFeatureHandler method.
	AddClusterScopedFeatureHandlerFunc func(ctx context.Context, enabled func() bool, name string, clusterName string, handler v31.CertificateHandlerFunc)

	// AddClusterScopedHandlerFunc mocks the AddClusterScopedHandler method.
	AddClusterScopedHandlerFunc func(ctx context.Context, name string, clusterName string, handler v31.CertificateHandlerFunc)

	// AddFeatureHandlerFunc mocks the AddFeatureHandler method.
	AddFeatureHandlerFunc func(ctx context.Context, enabled func() bool, name string, syncMoqParam v31.CertificateHandlerFunc)

	// AddHandlerFunc mocks the AddHandler method.
	AddHandlerFunc func(ctx context.Context, name string, handler v31.CertificateHandlerFunc)

	// EnqueueFunc mocks the Enqueue method.
	EnqueueFunc func(namespace string, name string)

	// EnqueueAfterFunc mocks the EnqueueAfter method.
	EnqueueAfterFunc func(namespace string, name string, after time.Duration)

	// GenericFunc mocks the Generic method.
	GenericFunc func() controller.GenericController

	// InformerFunc mocks the Informer method.
	InformerFunc func() cache.SharedIndexInformer

	// ListerFunc mocks the Lister method.
	ListerFunc func() v31.CertificateLister

	// calls tracks calls to the methods.
	calls struct {
		// AddClusterScopedFeatureHandler holds details about calls to the AddClusterScopedFeatureHandler method.
		AddClusterScopedFeatureHandler []struct {
			// Ctx is the ctx argument value.
			Ctx context.Context
			// Enabled is the enabled argument value.
			Enabled func() bool
			// Name is the name argument value.
			Name string
			// ClusterName is the clusterName argument value.
			ClusterName string
			// Handler is the handler argument value.
			Handler v31.CertificateHandlerFunc
		}
		// AddClusterScopedHandler holds details about calls to the AddClusterScopedHandler method.
		AddClusterScopedHandler []struct {
			// Ctx is the ctx argument value.
			Ctx context.Context
			// Name is the name argument value.
			Name string
			// ClusterName is the clusterName argument value.
			ClusterName string
			// Handler is the handler argument value.
			Handler v31.CertificateHandlerFunc
		}
		// AddFeatureHandler holds details about calls to the AddFeatureHandler method.
		AddFeatureHandler []struct {
			// Ctx is the ctx argument value.
			Ctx context.Context
			// Enabled is the enabled argument value.
			Enabled func() bool
			// Name is the name argument value.
			Name string
			// Sync is the sync argument value.
			Sync v31.CertificateHandlerFunc
		}
		// AddHandler holds details about calls to the AddHandler method.
		AddHandler []struct {
			// Ctx is the ctx argument value.
			Ctx context.Context
			// Name is the name argument value.
			Name string
			// Handler is the handler argument value.
			Handler v31.CertificateHandlerFunc
		}
		// Enqueue holds details about calls to the Enqueue method.
		Enqueue []struct {
			// Namespace is the namespace argument value.
			Namespace string
			// Name is the name argument value.
			Name string
		}
		// EnqueueAfter holds details about calls to the EnqueueAfter method.
		EnqueueAfter []struct {
			// Namespace is the namespace argument value.
			Namespace string
			// Name is the name argument value.
			Name string
			// After is the after argument value.
			After time.Duration
		}
		// Generic holds details about calls to the Generic method.
		Generic []struct {
		}
		// Informer holds details about calls to the Informer method.
		Informer []struct {
		}
		// Lister holds details about calls to the Lister method.
		Lister []struct {
		}
	}
}

// AddClusterScopedFeatureHandler calls AddClusterScopedFeatureHandlerFunc.
func (mock *CertificateControllerMock) AddClusterScopedFeatureHandler(ctx context.Context, enabled func() bool, name string, clusterName string, handler v31.CertificateHandlerFunc) {
	if mock.AddClusterScopedFeatureHandlerFunc == nil {
		panic("CertificateControllerMock.AddClusterScopedFeatureHandlerFunc: method is nil but CertificateController.AddClusterScopedFeatureHandler was just called")
	}
	callInfo := struct {
		Ctx         context.Context
		Enabled     func() bool
		Name        string
		ClusterName string
		Handler     v31.CertificateHandlerFunc
	}{
		Ctx:         ctx,
		Enabled:     enabled,
		Name:        name,
		ClusterName: clusterName,
		Handler:     handler,
	}
	lockCertificateControllerMockAddClusterScopedFeatureHandler.Lock()
	mock.calls.AddClusterScopedFeatureHandler = append(mock.calls.AddClusterScopedFeatureHandler, callInfo)
	lockCertificateControllerMockAddClusterScopedFeatureHandler.Unlock()
	mock.AddClusterScopedFeatureHandlerFunc(ctx, enabled, name, clusterName, handler)
}

// AddClusterScopedFeatureHandlerCalls gets all the calls that were made to AddClusterScopedFeatureHandler.
// Check the length with:
//     len(mockedCertificateController.AddClusterScopedFeatureHandlerCalls())
func (mock *CertificateControllerMock) AddClusterScopedFeatureHandlerCalls() []struct {
	Ctx         context.Context
	Enabled     func() bool
	Name        string
	ClusterName string
	Handler     v31.CertificateHandlerFunc
} {
	var calls []struct {
		Ctx         context.Context
		Enabled     func() bool
		Name        string
		ClusterName string
		Handler     v31.CertificateHandlerFunc
	}
	lockCertificateControllerMockAddClusterScopedFeatureHandler.RLock()
	calls = mock.calls.AddClusterScopedFeatureHandler
	lockCertificateControllerMockAddClusterScopedFeatureHandler.RUnlock()
	return calls
}

// AddClusterScopedHandler calls AddClusterScopedHandlerFunc.
func (mock *CertificateControllerMock) AddClusterScopedHandler(ctx context.Context, name string, clusterName string, handler v31.CertificateHandlerFunc) {
	if mock.AddClusterScopedHandlerFunc == nil {
		panic("CertificateControllerMock.AddClusterScopedHandlerFunc: method is nil but CertificateController.AddClusterScopedHandler was just called")
	}
	callInfo := struct {
		Ctx         context.Context
		Name        string
		ClusterName string
		Handler     v31.CertificateHandlerFunc
	}{
		Ctx:         ctx,
		Name:        name,
		ClusterName: clusterName,
		Handler:     handler,
	}
	lockCertificateControllerMockAddClusterScopedHandler.Lock()
	mock.calls.AddClusterScopedHandler = append(mock.calls.AddClusterScopedHandler, callInfo)
	lockCertificateControllerMockAddClusterScopedHandler.Unlock()
	mock.AddClusterScopedHandlerFunc(ctx, name, clusterName, handler)
}

// AddClusterScopedHandlerCalls gets all the calls that were made to AddClusterScopedHandler.
// Check the length with:
//     len(mockedCertificateController.AddClusterScopedHandlerCalls())
func (mock *CertificateControllerMock) AddClusterScopedHandlerCalls() []struct {
	Ctx         context.Context
	Name        string
	ClusterName string
	Handler     v31.CertificateHandlerFunc
} {
	var calls []struct {
		Ctx         context.Context
		Name        string
		ClusterName string
		Handler     v31.CertificateHandlerFunc
	}
	lockCertificateControllerMockAddClusterScopedHandler.RLock()
	calls = mock.calls.AddClusterScopedHandler
	lockCertificateControllerMockAddClusterScopedHandler.RUnlock()
	return calls
}

// AddFeatureHandler calls AddFeatureHandlerFunc.
func (mock *CertificateControllerMock) AddFeatureHandler(ctx context.Context, enabled func() bool, name string, syncMoqParam v31.CertificateHandlerFunc) {
	if mock.AddFeatureHandlerFunc == nil {
		panic("CertificateControllerMock.AddFeatureHandlerFunc: method is nil but CertificateController.AddFeatureHandler was just called")
	}
	callInfo := struct {
		Ctx     context.Context
		Enabled func() bool
		Name    string
		Sync    v31.CertificateHandlerFunc
	}{
		Ctx:     ctx,
		Enabled: enabled,
		Name:    name,
		Sync:    syncMoqParam,
	}
	lockCertificateControllerMockAddFeatureHandler.Lock()
	mock.calls.AddFeatureHandler = append(mock.calls.AddFeatureHandler, callInfo)
	lockCertificateControllerMockAddFeatureHandler.Unlock()
	mock.AddFeatureHandlerFunc(ctx, enabled, name, syncMoqParam)
}

// AddFeatureHandlerCalls gets all the calls that were made to AddFeatureHandler.
// Check the length with:
//     len(mockedCertificateController.AddFeatureHandlerCalls())
func (mock *CertificateControllerMock) AddFeatureHandlerCalls() []struct {
	Ctx     context.Context
	Enabled func() bool
	Name    string
	Sync    v31.CertificateHandlerFunc
} {
	var calls []struct {
		Ctx     context.Context
		Enabled func() bool
		Name    string
		Sync    v31.CertificateHandlerFunc
	}
	lockCertificateControllerMockAddFeatureHandler.RLock()
	calls = mock.calls.AddFeatureHandler
	lockCertificateControllerMockAddFeatureHandler.RUnlock()
	return calls
}

// AddHandler calls AddHandlerFunc.
func (mock *CertificateControllerMock) AddHandler(ctx context.Context, name string, handler v31.CertificateHandlerFunc) {
	if mock.AddHandlerFunc == nil {
		panic("CertificateControllerMock.AddHandlerFunc: method is nil but CertificateController.AddHandler was just called")
	}
	callInfo := struct {
		Ctx     context.Context
		Name    string
		Handler v31.CertificateHandlerFunc
	}{
		Ctx:     ctx,
		Name:    name,
		Handler: handler,
	}
	lockCertificateControllerMockAddHandler.Lock()
	mock.calls.AddHandler = append(mock.calls.AddHandler, callInfo)
	lockCertificateControllerMockAddHandler.Unlock()
	mock.AddHandlerFunc(ctx, name, handler)
}

// AddHandlerCalls gets all the calls that were made to AddHandler.
// Check the length with:
//     len(mockedCertificateController.AddHandlerCalls())
func (mock *CertificateControllerMock) AddHandlerCalls() []struct {
	Ctx     context.Context
	Name    string
	Handler v31.CertificateHandlerFunc
} {
	var calls []struct {
		Ctx     context.Context
		Name    string
		Handler v31.CertificateHandlerFunc
	}
	lockCertificateControllerMockAddHandler.RLock()
	calls = mock.calls.AddHandler
	lockCertificateControllerMockAddHandler.RUnlock()
	return calls
}

// Enqueue calls EnqueueFunc.
func (mock *CertificateControllerMock) Enqueue(namespace string, name string) {
	if mock.EnqueueFunc == nil {
		panic("CertificateControllerMock.EnqueueFunc: method is nil but CertificateController.Enqueue was just called")
	}
	callInfo := struct {
		Namespace string
		Name      string
	}{
		Namespace: namespace,
		Name:      name,
	}
	lockCertificateControllerMockEnqueue.Lock()
	mock.calls.Enqueue = append(mock.calls.Enqueue, callInfo)
	lockCertificateControllerMockEnqueue.Unlock()
	mock.EnqueueFunc(namespace, name)
}

// EnqueueCalls gets all the calls that were made to Enqueue.
// Check the length with:
//     len(mockedCertificateController.EnqueueCalls())
func (mock *CertificateControllerMock) EnqueueCalls() []struct {
	Namespace string
	Name      string
} {
	var calls []struct {
		Namespace string
		Name      string
	}
	lockCertificateControllerMockEnqueue.RLock()
	calls = mock.calls.Enqueue
	lockCertificateControllerMockEnqueue.RUnlock()
	return calls
}

// EnqueueAfter calls EnqueueAfterFunc.
func (mock *CertificateControllerMock) EnqueueAfter(namespace string, name string, after time.Duration) {
	if mock.EnqueueAfterFunc == nil {
		panic("CertificateControllerMock.EnqueueAfterFunc: method is nil but CertificateController.EnqueueAfter was just called")
	}
	callInfo := struct {
		Namespace string
		Name      string
		After     time.Duration
	}{
		Namespace: namespace,
		Name:      name,
		After:     after,
	}
	lockCertificateControllerMockEnqueueAfter.Lock()
	mock.calls.EnqueueAfter = append(mock.calls.EnqueueAfter, callInfo)
	lockCertificateControllerMockEnqueueAfter.Unlock()
	mock.EnqueueAfterFunc(namespace, name, after)
}

// EnqueueAfterCalls gets all the calls that were made to EnqueueAfter.
// Check the length with:
//     len(mockedCertificateController.EnqueueAfterCalls())
func (mock *CertificateControllerMock) EnqueueAfterCalls() []struct {
	Namespace string
	Name      string
	After     time.Duration
} {
	var calls []struct {
		Namespace string
		Name      string
		After     time.Duration
	}
	lockCertificateControllerMockEnqueueAfter.RLock()
	calls = mock.calls.EnqueueAfter
	lockCertificateControllerMockEnqueueAfter.RUnlock()
	return calls
}

// Generic calls GenericFunc.
func (mock *CertificateControllerMock) Generic() controller.GenericController {
	if mock.GenericFunc == nil {
		panic("CertificateControllerMock.GenericFunc: method is nil but CertificateController.Generic was just called")
	}
	callInfo := struct {
	}{}
	lockCertificateControllerMockGeneric.Lock()
	mock.calls.Generic = append(mock.calls.Generic, callInfo)
	lockCertificateControllerMockGeneric.Unlock()
	return mock.GenericFunc()
}

// GenericCalls gets all the calls that were made to Generic.
// Check the length with:
//     len(mockedCertificateController.GenericCalls())
func (mock *CertificateControllerMock) GenericCalls() []struct {
} {
	var calls []struct {
	}
	lockCertificateControllerMockGeneric.RLock()
	calls = mock.calls.Generic
	lockCertificateControllerMockGeneric.RUnlock()
	return calls
}

// Informer calls InformerFunc.
func (mock *CertificateControllerMock) Informer() cache.SharedIndexInformer {
	if mock.InformerFunc == nil {
		panic("CertificateControllerMock.InformerFunc: method is nil but CertificateController.Informer was just called")
	}
	callInfo := struct {
	}{}
	lockCertificateControllerMockInformer.Lock()
	mock.calls.Informer = append(mock.calls.Informer, callInfo)
	lockCertificateControllerMockInformer.Unlock()
	return mock.InformerFunc()
}

// InformerCalls gets all the calls that were made to Informer.
// Check the length with:
//     len(mockedCertificateController.InformerCalls())
func (mock *CertificateControllerMock) InformerCalls() []struct {
} {
	var calls []struct {
	}
	lockCertificateControllerMockInformer.RLock()
	calls = mock.calls.Informer
	lockCertificateControllerMockInformer.RUnlock()
	return calls
}

// Lister calls ListerFunc.
func (mock *CertificateControllerMock) Lister() v31.CertificateLister {
	if mock.ListerFunc == nil {
		panic("CertificateControllerMock.ListerFunc: method is nil but CertificateController.Lister was just called")
	}
	callInfo := struct {
	}{}
	lockCertificateControllerMockLister.Lock()
	mock.calls.Lister = append(mock.calls.Lister, callInfo)
	lockCertificateControllerMockLister.Unlock()
	return mock.ListerFunc()
}

// ListerCalls gets all the calls that were made to Lister.
// Check the length with:
//     len(mockedCertificateController.ListerCalls())
func (mock *CertificateControllerMock) ListerCalls() []struct {
} {
	var calls []struct {
	}
	lockCertificateControllerMockLister.RLock()
	calls = mock.calls.Lister
	lockCertificateControllerMockLister.RUnlock()
	return calls
}

var (
	lockCertificateInterfaceMockAddClusterScopedFeatureHandler   sync.RWMutex
	lockCertificateInterfaceMockAddClusterScopedFeatureLifecycle sync.RWMutex
	lockCertificateInterfaceMockAddClusterScopedHandler          sync.RWMutex
	lockCertificateInterfaceMockAddClusterScopedLifecycle        sync.RWMutex
	lockCertificateInterfaceMockAddFeatureHandler                sync.RWMutex
	lockCertificateInterfaceMockAddFeatureLifecycle              sync.RWMutex
	lockCertificateInterfaceMockAddHandler                       sync.RWMutex
	lockCertificateInterfaceMockAddLifecycle                     sync.RWMutex
	lockCertificateInterfaceMockController                       sync.RWMutex
	lockCertificateInterfaceMockCreate                           sync.RWMutex
	lockCertificateInterfaceMockDelete                           sync.RWMutex
	lockCertificateInterfaceMockDeleteCollection                 sync.RWMutex
	lockCertificateInterfaceMockDeleteNamespaced                 sync.RWMutex
	lockCertificateInterfaceMockGet                              sync.RWMutex
	lockCertificateInterfaceMockGetNamespaced                    sync.RWMutex
	lockCertificateInterfaceMockList                             sync.RWMutex
	lockCertificateInterfaceMockListNamespaced                   sync.RWMutex
	lockCertificateInterfaceMockObjectClient                     sync.RWMutex
	lockCertificateInterfaceMockUpdate                           sync.RWMutex
	lockCertificateInterfaceMockWatch                            sync.RWMutex
)

// Ensure, that CertificateInterfaceMock does implement v31.CertificateInterface.
// If this is not the case, regenerate this file with moq.
var _ v31.CertificateInterface = &CertificateInterfaceMock{}

// CertificateInterfaceMock is a mock implementation of v31.CertificateInterface.
//
//     func TestSomethingThatUsesCertificateInterface(t *testing.T) {
//
//         // make and configure a mocked v31.CertificateInterface
//         mockedCertificateInterface := &CertificateInterfaceMock{
//             AddClusterScopedFeatureHandlerFunc: func(ctx context.Context, enabled func() bool, name string, clusterName string, syncMoqParam v31.CertificateHandlerFunc)  {
// 	               panic("mock out the AddClusterScopedFeatureHandler method")
//             },
//             AddClusterScopedFeatureLifecycleFunc: func(ctx context.Context, enabled func() bool, name string, clusterName string, lifecycle v31.CertificateLifecycle)  {
// 	               panic("mock out the AddClusterScopedFeatureLifecycle method")
//             },
//             AddClusterScopedHandlerFunc: func(ctx context.Context, name string, clusterName string, syncMoqParam v31.CertificateHandlerFunc)  {
// 	               panic("mock out the AddClusterScopedHandler method")
//             },
//             AddClusterScopedLifecycleFunc: func(ctx context.Context, name string, clusterName string, lifecycle v31.CertificateLifecycle)  {
// 	               panic("mock out the AddClusterScopedLifecycle method")
//             },
//             AddFeatureHandlerFunc: func(ctx context.Context, enabled func() bool, name string, syncMoqParam v31.CertificateHandlerFunc)  {
// 	               panic("mock out the AddFeatureHandler method")
//             },
//             AddFeatureLifecycleFunc: func(ctx context.Context, enabled func() bool, name string, lifecycle v31.CertificateLifecycle)  {
// 	               panic("mock out the AddFeatureLifecycle method")
//             },
//             AddHandlerFunc: func(ctx context.Context, name string, syncMoqParam v31.CertificateHandlerFunc)  {
// 	               panic("mock out the AddHandler method")
//             },
//             AddLifecycleFunc: func(ctx context.Context, name string, lifecycle v31.CertificateLifecycle)  {
// 	               panic("mock out the AddLifecycle method")
//             },
//             ControllerFunc: func() v31.CertificateController {
// 	               panic("mock out the Controller method")
//             },
//             CreateFunc: func(in1 *v3.Certificate) (*v3.Certificate, error) {
// 	               panic("mock out the Create method")
//             },
//             DeleteFunc: func(name string, options *metav1.DeleteOptions) error {
// 	               panic("mock out the Delete method")
//             },
//             DeleteCollectionFunc: func(deleteOpts *metav1.DeleteOptions, listOpts metav1.ListOptions) error {
// 	               panic("mock out the DeleteCollection method")
//             },
//             DeleteNamespacedFunc: func(namespace string, name string, options *metav1.DeleteOptions) error {
// 	               panic("mock out the DeleteNamespaced method")
//             },
//             GetFunc: func(name string, opts metav1.GetOptions) (*v3.Certificate, error) {
// 	               panic("mock out the Get method")
//             },
//             GetNamespacedFunc: func(namespace string, name string, opts metav1.GetOptions) (*v3.Certificate, error) {
// 	               panic("mock out the GetNamespaced method")
//             },
//             ListFunc: func(opts metav1.ListOptions) (*v3.CertificateList, error) {
// 	               panic("mock out the List method")
//             },
//             ListNamespacedFunc: func(namespace string, opts metav1.ListOptions) (*v3.CertificateList, error) {
// 	               panic("mock out the ListNamespaced method")
//             },
//             ObjectClientFunc: func() *objectclient.ObjectClient {
// 	               panic("mock out the ObjectClient method")
//             },
//             UpdateFunc: func(in1 *v3.Certificate) (*v3.Certificate, error) {
// 	               panic("mock out the Update method")
//             },
//             WatchFunc: func(opts metav1.ListOptions) (watch.Interface, error) {
// 	               panic("mock out the Watch method")
//             },
//         }
//
//         // use mockedCertificateInterface in code that requires v31.CertificateInterface
//         // and then make assertions.
//
//     }
type CertificateInterfaceMock struct {
	// AddClusterScopedFeatureHandlerFunc mocks the AddClusterScopedFeatureHandler method.
	AddClusterScopedFeatureHandlerFunc func(ctx context.Context, enabled func() bool, name string, clusterName string, syncMoqParam v31.CertificateHandlerFunc)

	// AddClusterScopedFeatureLifecycleFunc mocks the AddClusterScopedFeatureLifecycle method.
	AddClusterScopedFeatureLifecycleFunc func(ctx context.Context, enabled func() bool, name string, clusterName string, lifecycle v31.CertificateLifecycle)

	// AddClusterScopedHandlerFunc mocks the AddClusterScopedHandler method.
	AddClusterScopedHandlerFunc func(ctx context.Context, name string, clusterName string, syncMoqParam v31.CertificateHandlerFunc)

	// AddClusterScopedLifecycleFunc mocks the AddClusterScopedLifecycle method.
	AddClusterScopedLifecycleFunc func(ctx context.Context, name string, clusterName string, lifecycle v31.CertificateLifecycle)

	// AddFeatureHandlerFunc mocks the AddFeatureHandler method.
	AddFeatureHandlerFunc func(ctx context.Context, enabled func() bool, name string, syncMoqParam v31.CertificateHandlerFunc)

	// AddFeatureLifecycleFunc mocks the AddFeatureLifecycle method.
	AddFeatureLifecycleFunc func(ctx context.Context, enabled func() bool, name string, lifecycle v31.CertificateLifecycle)

	// AddHandlerFunc mocks the AddHandler method.
	AddHandlerFunc func(ctx context.Context, name string, syncMoqParam v31.CertificateHandlerFunc)

	// AddLifecycleFunc mocks the AddLifecycle method.
	AddLifecycleFunc func(ctx context.Context, name string, lifecycle v31.CertificateLifecycle)

	// ControllerFunc mocks the Controller method.
	ControllerFunc func() v31.CertificateController

	// CreateFunc mocks the Create method.
	CreateFunc func(in1 *v3.Certificate) (*v3.Certificate, error)

	// DeleteFunc mocks the Delete method.
	DeleteFunc func(name string, options *metav1.DeleteOptions) error

	// DeleteCollectionFunc mocks the DeleteCollection method.
	DeleteCollectionFunc func(deleteOpts *metav1.DeleteOptions, listOpts metav1.ListOptions) error

	// DeleteNamespacedFunc mocks the DeleteNamespaced method.
	DeleteNamespacedFunc func(namespace string, name string, options *metav1.DeleteOptions) error

	// GetFunc mocks the Get method.
	GetFunc func(name string, opts metav1.GetOptions) (*v3.Certificate, error)

	// GetNamespacedFunc mocks the GetNamespaced method.
	GetNamespacedFunc func(namespace string, name string, opts metav1.GetOptions) (*v3.Certificate, error)

	// ListFunc mocks the List method.
	ListFunc func(opts metav1.ListOptions) (*v3.CertificateList, error)

	// ListNamespacedFunc mocks the ListNamespaced method.
	ListNamespacedFunc func(namespace string, opts metav1.ListOptions) (*v3.CertificateList, error)

	// ObjectClientFunc mocks the ObjectClient method.
	ObjectClientFunc func() *objectclient.ObjectClient

	// UpdateFunc mocks the Update method.
	UpdateFunc func(in1 *v3.Certificate) (*v3.Certificate, error)

	// WatchFunc mocks the Watch method.
	WatchFunc func(opts metav1.ListOptions) (watch.Interface, error)

	// calls tracks calls to the methods.
	calls struct {
		// AddClusterScopedFeatureHandler holds details about calls to the AddClusterScopedFeatureHandler method.
		AddClusterScopedFeatureHandler []struct {
			// Ctx is the ctx argument value.
			Ctx context.Context
			// Enabled is the enabled argument value.
			Enabled func() bool
			// Name is the name argument value.
			Name string
			// ClusterName is the clusterName argument value.
			ClusterName string
			// Sync is the sync argument value.
			Sync v31.CertificateHandlerFunc
		}
		// AddClusterScopedFeatureLifecycle holds details about calls to the AddClusterScopedFeatureLifecycle method.
		AddClusterScopedFeatureLifecycle []struct {
			// Ctx is the ctx argument value.
			Ctx context.Context
			// Enabled is the enabled argument value.
			Enabled func() bool
			// Name is the name argument value.
			Name string
			// ClusterName is the clusterName argument value.
			ClusterName string
			// Lifecycle is the lifecycle argument value.
			Lifecycle v31.CertificateLifecycle
		}
		// AddClusterScopedHandler holds details about calls to the AddClusterScopedHandler method.
		AddClusterScopedHandler []struct {
			// Ctx is the ctx argument value.
			Ctx context.Context
			// Name is the name argument value.
			Name string
			// ClusterName is the clusterName argument value.
			ClusterName string
			// Sync is the sync argument value.
			Sync v31.CertificateHandlerFunc
		}
		// AddClusterScopedLifecycle holds details about calls to the AddClusterScopedLifecycle method.
		AddClusterScopedLifecycle []struct {
			// Ctx is the ctx argument value.
			Ctx context.Context
			// Name is the name argument value.
			Name string
			// ClusterName is the clusterName argument value.
			ClusterName string
			// Lifecycle is the lifecycle argument value.
			Lifecycle v31.CertificateLifecycle
		}
		// AddFeatureHandler holds details about calls to the AddFeatureHandler method.
		AddFeatureHandler []struct {
			// Ctx is the ctx argument value.
			Ctx context.Context
			// Enabled is the enabled argument value.
			Enabled func() bool
			// Name is the name argument value.
			Name string
			// Sync is the sync argument value.
			Sync v31.CertificateHandlerFunc
		}
		// AddFeatureLifecycle holds details about calls to the AddFeatureLifecycle method.
		AddFeatureLifecycle []struct {
			// Ctx is the ctx argument value.
			Ctx context.Context
			// Enabled is the enabled argument value.
			Enabled func() bool
			// Name is the name argument value.
			Name string
			// Lifecycle is the lifecycle argument value.
			Lifecycle v31.CertificateLifecycle
		}
		// AddHandler holds details about calls to the AddHandler method.
		AddHandler []struct {
			// Ctx is the ctx argument value.
			Ctx context.Context
			// Name is the name argument value.
			Name string
			// Sync is the sync argument value.
			Sync v31.CertificateHandlerFunc
		}
		// AddLifecycle holds details about calls to the AddLifecycle method.
		AddLifecycle []struct {
			// Ctx is the ctx argument value.
			Ctx context.Context
			// Name is the name argument value.
			Name string
			// Lifecycle is the lifecycle argument value.
			Lifecycle v31.CertificateLifecycle
		}
		// Controller holds details about calls to the Controller method.
		Controller []struct {
		}
		// Create holds details about calls to the Create method.
		Create []struct {
			// In1 is the in1 argument value.
			In1 *v3.Certificate
		}
		// Delete holds details about calls to the Delete method.
		Delete []struct {
			// Name is the name argument value.
			Name string
			// Options is the options argument value.
			Options *metav1.DeleteOptions
		}
		// DeleteCollection holds details about calls to the DeleteCollection method.
		DeleteCollection []struct {
			// DeleteOpts is the deleteOpts argument value.
			DeleteOpts *metav1.DeleteOptions
			// ListOpts is the listOpts argument value.
			ListOpts metav1.ListOptions
		}
		// DeleteNamespaced holds details about calls to the DeleteNamespaced method.
		DeleteNamespaced []struct {
			// Namespace is the namespace argument value.
			Namespace string
			// Name is the name argument value.
			Name string
			// Options is the options argument value.
			Options *metav1.DeleteOptions
		}
		// Get holds details about calls to the Get method.
		Get []struct {
			// Name is the name argument value.
			Name string
			// Opts is the opts argument value.
			Opts metav1.GetOptions
		}
		// GetNamespaced holds details about calls to the GetNamespaced method.
		GetNamespaced []struct {
			// Namespace is the namespace argument value.
			Namespace string
			// Name is the name argument value.
			Name string
			// Opts is the opts argument value.
			Opts metav1.GetOptions
		}
		// List holds details about calls to the List method.
		List []struct {
			// Opts is the opts argument value.
			Opts metav1.ListOptions
		}
		// ListNamespaced holds details about calls to the ListNamespaced method.
		ListNamespaced []struct {
			// Namespace is the namespace argument value.
			Namespace string
			// Opts is the opts argument value.
			Opts metav1.ListOptions
		}
		// ObjectClient holds details about calls to the ObjectClient method.
		ObjectClient []struct {
		}
		// Update holds details about calls to the Update method.
		Update []struct {
			// In1 is the in1 argument value.
			In1 *v3.Certificate
		}
		// Watch holds details about calls to the Watch method.
		Watch []struct {
			// Opts is the opts argument value.
			Opts metav1.ListOptions
		}
	}
}

// AddClusterScopedFeatureHandler calls AddClusterScopedFeatureHandlerFunc.
func (mock *CertificateInterfaceMock) AddClusterScopedFeatureHandler(ctx context.Context, enabled func() bool, name string, clusterName string, syncMoqParam v31.CertificateHandlerFunc) {
	if mock.AddClusterScopedFeatureHandlerFunc == nil {
		panic("CertificateInterfaceMock.AddClusterScopedFeatureHandlerFunc: method is nil but CertificateInterface.AddClusterScopedFeatureHandler was just called")
	}
	callInfo := struct {
		Ctx         context.Context
		Enabled     func() bool
		Name        string
		ClusterName string
		Sync        v31.CertificateHandlerFunc
	}{
		Ctx:         ctx,
		Enabled:     enabled,
		Name:        name,
		ClusterName: clusterName,
		Sync:        syncMoqParam,
	}
	lockCertificateInterfaceMockAddClusterScopedFeatureHandler.Lock()
	mock.calls.AddClusterScopedFeatureHandler = append(mock.calls.AddClusterScopedFeatureHandler, callInfo)
	lockCertificateInterfaceMockAddClusterScopedFeatureHandler.Unlock()
	mock.AddClusterScopedFeatureHandlerFunc(ctx, enabled, name, clusterName, syncMoqParam)
}

// AddClusterScopedFeatureHandlerCalls gets all the calls that were made to AddClusterScopedFeatureHandler.
// Check the length with:
//     len(mockedCertificateInterface.AddClusterScopedFeatureHandlerCalls())
func (mock *CertificateInterfaceMock) AddClusterScopedFeatureHandlerCalls() []struct {
	Ctx         context.Context
	Enabled     func() bool
	Name        string
	ClusterName string
	Sync        v31.CertificateHandlerFunc
} {
	var calls []struct {
		Ctx         context.Context
		Enabled     func() bool
		Name        string
		ClusterName string
		Sync        v31.CertificateHandlerFunc
	}
	lockCertificateInterfaceMockAddClusterScopedFeatureHandler.RLock()
	calls = mock.calls.AddClusterScopedFeatureHandler
	lockCertificateInterfaceMockAddClusterScopedFeatureHandler.RUnlock()
	return calls
}

// AddClusterScopedFeatureLifecycle calls AddClusterScopedFeatureLifecycleFunc.
func (mock *CertificateInterfaceMock) AddClusterScopedFeatureLifecycle(ctx context.Context, enabled func() bool, name string, clusterName string, lifecycle v31.CertificateLifecycle) {
	if mock.AddClusterScopedFeatureLifecycleFunc == nil {
		panic("CertificateInterfaceMock.AddClusterScopedFeatureLifecycleFunc: method is nil but CertificateInterface.AddClusterScopedFeatureLifecycle was just called")
	}
	callInfo := struct {
		Ctx         context.Context
		Enabled     func() bool
		Name        string
		ClusterName string
		Lifecycle   v31.CertificateLifecycle
	}{
		Ctx:         ctx,
		Enabled:     enabled,
		Name:        name,
		ClusterName: clusterName,
		Lifecycle:   lifecycle,
	}
	lockCertificateInterfaceMockAddClusterScopedFeatureLifecycle.Lock()
	mock.calls.AddClusterScopedFeatureLifecycle = append(mock.calls.AddClusterScopedFeatureLifecycle, callInfo)
	lockCertificateInterfaceMockAddClusterScopedFeatureLifecycle.Unlock()
	mock.AddClusterScopedFeatureLifecycleFunc(ctx, enabled, name, clusterName, lifecycle)
}

// AddClusterScopedFeatureLifecycleCalls gets all the calls that were made to AddClusterScopedFeatureLifecycle.
// Check the length with:
//     len(mockedCertificateInterface.AddClusterScopedFeatureLifecycleCalls())
func (mock *CertificateInterfaceMock) AddClusterScopedFeatureLifecycleCalls() []struct {
	Ctx         context.Context
	Enabled     func() bool
	Name        string
	ClusterName string
	Lifecycle   v31.CertificateLifecycle
} {
	var calls []struct {
		Ctx         context.Context
		Enabled     func() bool
		Name        string
		ClusterName string
		Lifecycle   v31.CertificateLifecycle
	}
	lockCertificateInterfaceMockAddClusterScopedFeatureLifecycle.RLock()
	calls = mock.calls.AddClusterScopedFeatureLifecycle
	lockCertificateInterfaceMockAddClusterScopedFeatureLifecycle.RUnlock()
	return calls
}

// AddClusterScopedHandler calls AddClusterScopedHandlerFunc.
func (mock *CertificateInterfaceMock) AddClusterScopedHandler(ctx context.Context, name string, clusterName string, syncMoqParam v31.CertificateHandlerFunc) {
	if mock.AddClusterScopedHandlerFunc == nil {
		panic("CertificateInterfaceMock.AddClusterScopedHandlerFunc: method is nil but CertificateInterface.AddClusterScopedHandler was just called")
	}
	callInfo := struct {
		Ctx         context.Context
		Name        string
		ClusterName string
		Sync        v31.CertificateHandlerFunc
	}{
		Ctx:         ctx,
		Name:        name,
		ClusterName: clusterName,
		Sync:        syncMoqParam,
	}
	lockCertificateInterfaceMockAddClusterScopedHandler.Lock()
	mock.calls.AddClusterScopedHandler = append(mock.calls.AddClusterScopedHandler, callInfo)
	lockCertificateInterfaceMockAddClusterScopedHandler.Unlock()
	mock.AddClusterScopedHandlerFunc(ctx, name, clusterName, syncMoqParam)
}

// AddClusterScopedHandlerCalls gets all the calls that were made to AddClusterScopedHandler.
// Check the length with:
//     len(mockedCertificateInterface.AddClusterScopedHandlerCalls())
func (mock *CertificateInterfaceMock) AddClusterScopedHandlerCalls() []struct {
	Ctx         context.Context
	Name        string
	ClusterName string
	Sync        v31.CertificateHandlerFunc
} {
	var calls []struct {
		Ctx         context.Context
		Name        string
		ClusterName string
		Sync        v31.CertificateHandlerFunc
	}
	lockCertificateInterfaceMockAddClusterScopedHandler.RLock()
	calls = mock.calls.AddClusterScopedHandler
	lockCertificateInterfaceMockAddClusterScopedHandler.RUnlock()
	return calls
}

// AddClusterScopedLifecycle calls AddClusterScopedLifecycleFunc.
func (mock *CertificateInterfaceMock) AddClusterScopedLifecycle(ctx context.Context, name string, clusterName string, lifecycle v31.CertificateLifecycle) {
	if mock.AddClusterScopedLifecycleFunc == nil {
		panic("CertificateInterfaceMock.AddClusterScopedLifecycleFunc: method is nil but CertificateInterface.AddClusterScopedLifecycle was just called")
	}
	callInfo := struct {
		Ctx         context.Context
		Name        string
		ClusterName string
		Lifecycle   v31.CertificateLifecycle
	}{
		Ctx:         ctx,
		Name:        name,
		ClusterName: clusterName,
		Lifecycle:   lifecycle,
	}
	lockCertificateInterfaceMockAddClusterScopedLifecycle.Lock()
	mock.calls.AddClusterScopedLifecycle = append(mock.calls.AddClusterScopedLifecycle, callInfo)
	lockCertificateInterfaceMockAddClusterScopedLifecycle.Unlock()
	mock.AddClusterScopedLifecycleFunc(ctx, name, clusterName, lifecycle)
}

// AddClusterScopedLifecycleCalls gets all the calls that were made to AddClusterScopedLifecycle.
// Check the length with:
//     len(mockedCertificateInterface.AddClusterScopedLifecycleCalls())
func (mock *CertificateInterfaceMock) AddClusterScopedLifecycleCalls() []struct {
	Ctx         context.Context
	Name        string
	ClusterName string
	Lifecycle   v31.CertificateLifecycle
} {
	var calls []struct {
		Ctx         context.Context
		Name        string
		ClusterName string
		Lifecycle   v31.CertificateLifecycle
	}
	lockCertificateInterfaceMockAddClusterScopedLifecycle.RLock()
	calls = mock.calls.AddClusterScopedLifecycle
	lockCertificateInterfaceMockAddClusterScopedLifecycle.RUnlock()
	return calls
}

// AddFeatureHandler calls AddFeatureHandlerFunc.
func (mock *CertificateInterfaceMock) AddFeatureHandler(ctx context.Context, enabled func() bool, name string, syncMoqParam v31.CertificateHandlerFunc) {
	if mock.AddFeatureHandlerFunc == nil {
		panic("CertificateInterfaceMock.AddFeatureHandlerFunc: method is nil but CertificateInterface.AddFeatureHandler was just called")
	}
	callInfo := struct {
		Ctx     context.Context
		Enabled func() bool
		Name    string
		Sync    v31.CertificateHandlerFunc
	}{
		Ctx:     ctx,
		Enabled: enabled,
		Name:    name,
		Sync:    syncMoqParam,
	}
	lockCertificateInterfaceMockAddFeatureHandler.Lock()
	mock.calls.AddFeatureHandler = append(mock.calls.AddFeatureHandler, callInfo)
	lockCertificateInterfaceMockAddFeatureHandler.Unlock()
	mock.AddFeatureHandlerFunc(ctx, enabled, name, syncMoqParam)
}

// AddFeatureHandlerCalls gets all the calls that were made to AddFeatureHandler.
// Check the length with:
//     len(mockedCertificateInterface.AddFeatureHandlerCalls())
func (mock *CertificateInterfaceMock) AddFeatureHandlerCalls() []struct {
	Ctx     context.Context
	Enabled func() bool
	Name    string
	Sync    v31.CertificateHandlerFunc
} {
	var calls []struct {
		Ctx     context.Context
		Enabled func() bool
		Name    string
		Sync    v31.CertificateHandlerFunc
	}
	lockCertificateInterfaceMockAddFeatureHandler.RLock()
	calls = mock.calls.AddFeatureHandler
	lockCertificateInterfaceMockAddFeatureHandler.RUnlock()
	return calls
}

// AddFeatureLifecycle calls AddFeatureLifecycleFunc.
func (mock *CertificateInterfaceMock) AddFeatureLifecycle(ctx context.Context, enabled func() bool, name string, lifecycle v31.CertificateLifecycle) {
	if mock.AddFeatureLifecycleFunc == nil {
		panic("CertificateInterfaceMock.AddFeatureLifecycleFunc: method is nil but CertificateInterface.AddFeatureLifecycle was just called")
	}
	callInfo := struct {
		Ctx       context.Context
		Enabled   func() bool
		Name      string
		Lifecycle v31.CertificateLifecycle
	}{
		Ctx:       ctx,
		Enabled:   enabled,
		Name:      name,
		Lifecycle: lifecycle,
	}
	lockCertificateInterfaceMockAddFeatureLifecycle.Lock()
	mock.calls.AddFeatureLifecycle = append(mock.calls.AddFeatureLifecycle, callInfo)
	lockCertificateInterfaceMockAddFeatureLifecycle.Unlock()
	mock.AddFeatureLifecycleFunc(ctx, enabled, name, lifecycle)
}

// AddFeatureLifecycleCalls gets all the calls that were made to AddFeatureLifecycle.
// Check the length with:
//     len(mockedCertificateInterface.AddFeatureLifecycleCalls())
func (mock *CertificateInterfaceMock) AddFeatureLifecycleCalls() []struct {
	Ctx       context.Context
	Enabled   func() bool
	Name      string
	Lifecycle v31.CertificateLifecycle
} {
	var calls []struct {
		Ctx       context.Context
		Enabled   func() bool
		Name      string
		Lifecycle v31.CertificateLifecycle
	}
	lockCertificateInterfaceMockAddFeatureLifecycle.RLock()
	calls = mock.calls.AddFeatureLifecycle
	lockCertificateInterfaceMockAddFeatureLifecycle.RUnlock()
	return calls
}

// AddHandler calls AddHandlerFunc.
func (mock *CertificateInterfaceMock) AddHandler(ctx context.Context, name string, syncMoqParam v31.CertificateHandlerFunc) {
	if mock.AddHandlerFunc == nil {
		panic("CertificateInterfaceMock.AddHandlerFunc: method is nil but CertificateInterface.AddHandler was just called")
	}
	callInfo := struct {
		Ctx  context.Context
		Name string
		Sync v31.CertificateHandlerFunc
	}{
		Ctx:  ctx,
		Name: name,
		Sync: syncMoqParam,
	}
	lockCertificateInterfaceMockAddHandler.Lock()
	mock.calls.AddHandler = append(mock.calls.AddHandler, callInfo)
	lockCertificateInterfaceMockAddHandler.Unlock()
	mock.AddHandlerFunc(ctx, name, syncMoqParam)
}

// AddHandlerCalls gets all the calls that were made to AddHandler.
// Check the length with:
//     len(mockedCertificateInterface.AddHandlerCalls())
func (mock *CertificateInterfaceMock) AddHandlerCalls() []struct {
	Ctx  context.Context
	Name string
	Sync v31.CertificateHandlerFunc
} {
	var calls []struct {
		Ctx  context.Context
		Name string
		Sync v31.CertificateHandlerFunc
	}
	lockCertificateInterfaceMockAddHandler.RLock()
	calls = mock.calls.AddHandler
	lockCertificateInterfaceMockAddHandler.RUnlock()
	return calls
}

// AddLifecycle calls AddLifecycleFunc.
func (mock *CertificateInterfaceMock) AddLifecycle(ctx context.Context, name string, lifecycle v31.CertificateLifecycle) {
	if mock.AddLifecycleFunc == nil {
		panic("CertificateInterfaceMock.AddLifecycleFunc: method is nil but CertificateInterface.AddLifecycle was just called")
	}
	callInfo := struct {
		Ctx       context.Context
		Name      string
		Lifecycle v31.CertificateLifecycle
	}{
		Ctx:       ctx,
		Name:      name,
		Lifecycle: lifecycle,
	}
	lockCertificateInterfaceMockAddLifecycle.Lock()
	mock.calls.AddLifecycle = append(mock.calls.AddLifecycle, callInfo)
	lockCertificateInterfaceMockAddLifecycle.Unlock()
	mock.AddLifecycleFunc(ctx, name, lifecycle)
}

// AddLifecycleCalls gets all the calls that were made to AddLifecycle.
// Check the length with:
//     len(mockedCertificateInterface.AddLifecycleCalls())
func (mock *CertificateInterfaceMock) AddLifecycleCalls() []struct {
	Ctx       context.Context
	Name      string
	Lifecycle v31.CertificateLifecycle
} {
	var calls []struct {
		Ctx       context.Context
		Name      string
		Lifecycle v31.CertificateLifecycle
	}
	lockCertificateInterfaceMockAddLifecycle.RLock()
	calls = mock.calls.AddLifecycle
	lockCertificateInterfaceMockAddLifecycle.RUnlock()
	return calls
}

// Controller calls ControllerFunc.
func (mock *CertificateInterfaceMock) Controller() v31.CertificateController {
	if mock.ControllerFunc == nil {
		panic("CertificateInterfaceMock.ControllerFunc: method is nil but CertificateInterface.Controller was just called")
	}
	callInfo := struct {
	}{}
	lockCertificateInterfaceMockController.Lock()
	mock.calls.Controller = append(mock.calls.Controller, callInfo)
	lockCertificateInterfaceMockController.Unlock()
	return mock.ControllerFunc()
}

// ControllerCalls gets all the calls that were made to Controller.
// Check the length with:
//     len(mockedCertificateInterface.ControllerCalls())
func (mock *CertificateInterfaceMock) ControllerCalls() []struct {
} {
	var calls []struct {
	}
	lockCertificateInterfaceMockController.RLock()
	calls = mock.calls.Controller
	lockCertificateInterfaceMockController.RUnlock()
	return calls
}

// Create calls CreateFunc.
func (mock *CertificateInterfaceMock) Create(in1 *v3.Certificate) (*v3.Certificate, error) {
	if mock.CreateFunc == nil {
		panic("CertificateInterfaceMock.CreateFunc: method is nil but CertificateInterface.Create was just called")
	}
	callInfo := struct {
		In1 *v3.Certificate
	}{
		In1: in1,
	}
	lockCertificateInterfaceMockCreate.Lock()
	mock.calls.Create = append(mock.calls.Create, callInfo)
	lockCertificateInterfaceMockCreate.Unlock()
	return mock.CreateFunc(in1)
}

// CreateCalls gets all the calls that were made to Create.
// Check the length with:
//     len(mockedCertificateInterface.CreateCalls())
func (mock *CertificateInterfaceMock) CreateCalls() []struct {
	In1 *v3.Certificate
} {
	var calls []struct {
		In1 *v3.Certificate
	}
	lockCertificateInterfaceMockCreate.RLock()
	calls = mock.calls.Create
	lockCertificateInterfaceMockCreate.RUnlock()
	return calls
}

// Delete calls DeleteFunc.
func (mock *CertificateInterfaceMock) Delete(name string, options *metav1.DeleteOptions) error {
	if mock.DeleteFunc == nil {
		panic("CertificateInterfaceMock.DeleteFunc: method is nil but CertificateInterface.Delete was just called")
	}
	callInfo := struct {
		Name    string
		Options *metav1.DeleteOptions
	}{
		Name:    name,
		Options: options,
	}
	lockCertificateInterfaceMockDelete.Lock()
	mock.calls.Delete = append(mock.calls.Delete, callInfo)
	lockCertificateInterfaceMockDelete.Unlock()
	return mock.DeleteFunc(name, options)
}

// DeleteCalls gets all the calls that were made to Delete.
// Check the length with:
//     len(mockedCertificateInterface.DeleteCalls())
func (mock *CertificateInterfaceMock) DeleteCalls() []struct {
	Name    string
	Options *metav1.DeleteOptions
} {
	var calls []struct {
		Name    string
		Options *metav1.DeleteOptions
	}
	lockCertificateInterfaceMockDelete.RLock()
	calls = mock.calls.Delete
	lockCertificateInterfaceMockDelete.RUnlock()
	return calls
}

// DeleteCollection calls DeleteCollectionFunc.
func (mock *CertificateInterfaceMock) DeleteCollection(deleteOpts *metav1.DeleteOptions, listOpts metav1.ListOptions) error {
	if mock.DeleteCollectionFunc == nil {
		panic("CertificateInterfaceMock.DeleteCollectionFunc: method is nil but CertificateInterface.DeleteCollection was just called")
	}
	callInfo := struct {
		DeleteOpts *metav1.DeleteOptions
		ListOpts   metav1.ListOptions
	}{
		DeleteOpts: deleteOpts,
		ListOpts:   listOpts,
	}
	lockCertificateInterfaceMockDeleteCollection.Lock()
	mock.calls.DeleteCollection = append(mock.calls.DeleteCollection, callInfo)
	lockCertificateInterfaceMockDeleteCollection.Unlock()
	return mock.DeleteCollectionFunc(deleteOpts, listOpts)
}

// DeleteCollectionCalls gets all the calls that were made to DeleteCollection.
// Check the length with:
//     len(mockedCertificateInterface.DeleteCollectionCalls())
func (mock *CertificateInterfaceMock) DeleteCollectionCalls() []struct {
	DeleteOpts *metav1.DeleteOptions
	ListOpts   metav1.ListOptions
} {
	var calls []struct {
		DeleteOpts *metav1.DeleteOptions
		ListOpts   metav1.ListOptions
	}
	lockCertificateInterfaceMockDeleteCollection.RLock()
	calls = mock.calls.DeleteCollection
	lockCertificateInterfaceMockDeleteCollection.RUnlock()
	return calls
}

// DeleteNamespaced calls DeleteNamespacedFunc.
func (mock *CertificateInterfaceMock) DeleteNamespaced(namespace string, name string, options *metav1.DeleteOptions) error {
	if mock.DeleteNamespacedFunc == nil {
		panic("CertificateInterfaceMock.DeleteNamespacedFunc: method is nil but CertificateInterface.DeleteNamespaced was just called")
	}
	callInfo := struct {
		Namespace string
		Name      string
		Options   *metav1.DeleteOptions
	}{
		Namespace: namespace,
		Name:      name,
		Options:   options,
	}
	lockCertificateInterfaceMockDeleteNamespaced.Lock()
	mock.calls.DeleteNamespaced = append(mock.calls.DeleteNamespaced, callInfo)
	lockCertificateInterfaceMockDeleteNamespaced.Unlock()
	return mock.DeleteNamespacedFunc(namespace, name, options)
}

// DeleteNamespacedCalls gets all the calls that were made to DeleteNamespaced.
// Check the length with:
//     len(mockedCertificateInterface.DeleteNamespacedCalls())
func (mock *CertificateInterfaceMock) DeleteNamespacedCalls() []struct {
	Namespace string
	Name      string
	Options   *metav1.DeleteOptions
} {
	var calls []struct {
		Namespace string
		Name      string
		Options   *metav1.DeleteOptions
	}
	lockCertificateInterfaceMockDeleteNamespaced.RLock()
	calls = mock.calls.DeleteNamespaced
	lockCertificateInterfaceMockDeleteNamespaced.RUnlock()
	return calls
}

// Get calls GetFunc.
func (mock *CertificateInterfaceMock) Get(name string, opts metav1.GetOptions) (*v3.Certificate, error) {
	if mock.GetFunc == nil {
		panic("CertificateInterfaceMock.GetFunc: method is nil but CertificateInterface.Get was just called")
	}
	callInfo := struct {
		Name string
		Opts metav1.GetOptions
	}{
		Name: name,
		Opts: opts,
	}
	lockCertificateInterfaceMockGet.Lock()
	mock.calls.Get = append(mock.calls.Get, callInfo)
	lockCertificateInterfaceMockGet.Unlock()
	return mock.GetFunc(name, opts)
}

// GetCalls gets all the calls that were made to Get.
// Check the length with:
//     len(mockedCertificateInterface.GetCalls())
func (mock *CertificateInterfaceMock) GetCalls() []struct {
	Name string
	Opts metav1.GetOptions
} {
	var calls []struct {
		Name string
		Opts metav1.GetOptions
	}
	lockCertificateInterfaceMockGet.RLock()
	calls = mock.calls.Get
	lockCertificateInterfaceMockGet.RUnlock()
	return calls
}

// GetNamespaced calls GetNamespacedFunc.
func (mock *CertificateInterfaceMock) GetNamespaced(namespace string, name string, opts metav1.GetOptions) (*v3.Certificate, error) {
	if mock.GetNamespacedFunc == nil {
		panic("CertificateInterfaceMock.GetNamespacedFunc: method is nil but CertificateInterface.GetNamespaced was just called")
	}
	callInfo := struct {
		Namespace string
		Name      string
		Opts      metav1.GetOptions
	}{
		Namespace: namespace,
		Name:      name,
		Opts:      opts,
	}
	lockCertificateInterfaceMockGetNamespaced.Lock()
	mock.calls.GetNamespaced = append(mock.calls.GetNamespaced, callInfo)
	lockCertificateInterfaceMockGetNamespaced.Unlock()
	return mock.GetNamespacedFunc(namespace, name, opts)
}

// GetNamespacedCalls gets all the calls that were made to GetNamespaced.
// Check the length with:
//     len(mockedCertificateInterface.GetNamespacedCalls())
func (mock *CertificateInterfaceMock) GetNamespacedCalls() []struct {
	Namespace string
	Name      string
	Opts      metav1.GetOptions
} {
	var calls []struct {
		Namespace string
		Name      string
		Opts      metav1.GetOptions
	}
	lockCertificateInterfaceMockGetNamespaced.RLock()
	calls = mock.calls.GetNamespaced
	lockCertificateInterfaceMockGetNamespaced.RUnlock()
	return calls
}

// List calls ListFunc.
func (mock *CertificateInterfaceMock) List(opts metav1.ListOptions) (*v3.CertificateList, error) {
	if mock.ListFunc == nil {
		panic("CertificateInterfaceMock.ListFunc: method is nil but CertificateInterface.List was just called")
	}
	callInfo := struct {
		Opts metav1.ListOptions
	}{
		Opts: opts,
	}
	lockCertificateInterfaceMockList.Lock()
	mock.calls.List = append(mock.calls.List, callInfo)
	lockCertificateInterfaceMockList.Unlock()
	return mock.ListFunc(opts)
}

// ListCalls gets all the calls that were made to List.
// Check the length with:
//     len(mockedCertificateInterface.ListCalls())
func (mock *CertificateInterfaceMock) ListCalls() []struct {
	Opts metav1.ListOptions
} {
	var calls []struct {
		Opts metav1.ListOptions
	}
	lockCertificateInterfaceMockList.RLock()
	calls = mock.calls.List
	lockCertificateInterfaceMockList.RUnlock()
	return calls
}

// ListNamespaced calls ListNamespacedFunc.
func (mock *CertificateInterfaceMock) ListNamespaced(namespace string, opts metav1.ListOptions) (*v3.CertificateList, error) {
	if mock.ListNamespacedFunc == nil {
		panic("CertificateInterfaceMock.ListNamespacedFunc: method is nil but CertificateInterface.ListNamespaced was just called")
	}
	callInfo := struct {
		Namespace string
		Opts      metav1.ListOptions
	}{
		Namespace: namespace,
		Opts:      opts,
	}
	lockCertificateInterfaceMockListNamespaced.Lock()
	mock.calls.ListNamespaced = append(mock.calls.ListNamespaced, callInfo)
	lockCertificateInterfaceMockListNamespaced.Unlock()
	return mock.ListNamespacedFunc(namespace, opts)
}

// ListNamespacedCalls gets all the calls that were made to ListNamespaced.
// Check the length with:
//     len(mockedCertificateInterface.ListNamespacedCalls())
func (mock *CertificateInterfaceMock) ListNamespacedCalls() []struct {
	Namespace string
	Opts      metav1.ListOptions
} {
	var calls []struct {
		Namespace string
		Opts      metav1.ListOptions
	}
	lockCertificateInterfaceMockListNamespaced.RLock()
	calls = mock.calls.ListNamespaced
	lockCertificateInterfaceMockListNamespaced.RUnlock()
	return calls
}

// ObjectClient calls ObjectClientFunc.
func (mock *CertificateInterfaceMock) ObjectClient() *objectclient.ObjectClient {
	if mock.ObjectClientFunc == nil {
		panic("CertificateInterfaceMock.ObjectClientFunc: method is nil but CertificateInterface.ObjectClient was just called")
	}
	callInfo := struct {
	}{}
	lockCertificateInterfaceMockObjectClient.Lock()
	mock.calls.ObjectClient = append(mock.calls.ObjectClient, callInfo)
	lockCertificateInterfaceMockObjectClient.Unlock()
	return mock.ObjectClientFunc()
}

// ObjectClientCalls gets all the calls that were made to ObjectClient.
// Check the length with:
//     len(mockedCertificateInterface.ObjectClientCalls())
func (mock *CertificateInterfaceMock) ObjectClientCalls() []struct {
} {
	var calls []struct {
	}
	lockCertificateInterfaceMockObjectClient.RLock()
	calls = mock.calls.ObjectClient
	lockCertificateInterfaceMockObjectClient.RUnlock()
	return calls
}

// Update calls UpdateFunc.
func (mock *CertificateInterfaceMock) Update(in1 *v3.Certificate) (*v3.Certificate, error) {
	if mock.UpdateFunc == nil {
		panic("CertificateInterfaceMock.UpdateFunc: method is nil but CertificateInterface.Update was just called")
	}
	callInfo := struct {
		In1 *v3.Certificate
	}{
		In1: in1,
	}
	lockCertificateInterfaceMockUpdate.Lock()
	mock.calls.Update = append(mock.calls.Update, callInfo)
	lockCertificateInterfaceMockUpdate.Unlock()
	return mock.UpdateFunc(in1)
}

// UpdateCalls gets all the calls that were made to Update.
// Check the length with:
//     len(mockedCertificateInterface.UpdateCalls())
func (mock *CertificateInterfaceMock) UpdateCalls() []struct {
	In1 *v3.Certificate
} {
	var calls []struct {
		In1 *v3.Certificate
	}
	lockCertificateInterfaceMockUpdate.RLock()
	calls = mock.calls.Update
	lockCertificateInterfaceMockUpdate.RUnlock()
	return calls
}

// Watch calls WatchFunc.
func (mock *CertificateInterfaceMock) Watch(opts metav1.ListOptions) (watch.Interface, error) {
	if mock.WatchFunc == nil {
		panic("CertificateInterfaceMock.WatchFunc: method is nil but CertificateInterface.Watch was just called")
	}
	callInfo := struct {
		Opts metav1.ListOptions
	}{
		Opts: opts,
	}
	lockCertificateInterfaceMockWatch.Lock()
	mock.calls.Watch = append(mock.calls.Watch, callInfo)
	lockCertificateInterfaceMockWatch.Unlock()
	return mock.WatchFunc(opts)
}

// WatchCalls gets all the calls that were made to Watch.
// Check the length with:
//     len(mockedCertificateInterface.WatchCalls())
func (mock *CertificateInterfaceMock) WatchCalls() []struct {
	Opts metav1.ListOptions
} {
	var calls []struct {
		Opts metav1.ListOptions
	}
	lockCertificateInterfaceMockWatch.RLock()
	calls = mock.calls.Watch
	lockCertificateInterfaceMockWatch.RUnlock()
	return calls
}

var (
	lockCertificatesGetterMockCertificates sync.RWMutex
)

// Ensure, that CertificatesGetterMock does implement v31.CertificatesGetter.
// If this is not the case, regenerate this file with moq.
var _ v31.CertificatesGetter = &CertificatesGetterMock{}

// CertificatesGetterMock is a mock implementation of v31.CertificatesGetter.
//
//     func TestSomethingThatUsesCertificatesGetter(t *testing.T) {
//
//         // make and configure a mocked v31.CertificatesGetter
//         mockedCertificatesGetter := &CertificatesGetterMock{
//             CertificatesFunc: func(namespace string) v31.CertificateInterface {
// 	               panic("mock out the Certificates method")
//             },
//         }
//
//         // use mockedCertificatesGetter in code that requires v31.CertificatesGetter
//         // and then make assertions.
//
//     }
type CertificatesGetterMock struct {
	// CertificatesFunc mocks the Certificates method.
	CertificatesFunc func(namespace string) v31.CertificateInterface

	// calls tracks calls to the methods.
	calls struct {
		// Certificates holds details about calls to the Certificates method.
		Certificates []struct {
			// Namespace is the namespace argument value.
			Namespace string
		}
	}
}

// Certificates calls CertificatesFunc.
func (mock *CertificatesGetterMock) Certificates(namespace string) v31.CertificateInterface {
	if mock.CertificatesFunc == nil {
		panic("CertificatesGetterMock.CertificatesFunc: method is nil but CertificatesGetter.Certificates was just called")
	}
	callInfo := struct {
		Namespace string
	}{
		Namespace: namespace,
	}
	lockCertificatesGetterMockCertificates.Lock()
	mock.calls.Certificates = append(mock.calls.Certificates, callInfo)
	lockCertificatesGetterMockCertificates.Unlock()
	return mock.CertificatesFunc(namespace)
}

// CertificatesCalls gets all the calls that were made to Certificates.
// Check the length with:
//     len(mockedCertificatesGetter.CertificatesCalls())
func (mock *CertificatesGetterMock) CertificatesCalls() []struct {
	Namespace string
} {
	var calls []struct {
		Namespace string
	}
	lockCertificatesGetterMockCertificates.RLock()
	calls = mock.calls.Certificates
	lockCertificatesGetterMockCertificates.RUnlock()
	return calls
}
