// Code generated by moq; DO NOT EDIT.
// github.com/matryer/moq

package fakes

import (
	"context"
	"sync"
	"time"

	"github.com/rancher/norman/controller"
	"github.com/rancher/norman/objectclient"
	v3 "github.com/rancher/rancher/pkg/apis/project.cattle.io/v3"
	v31 "github.com/rancher/rancher/pkg/generated/norman/project.cattle.io/v3"
	metav1 "k8s.io/apimachinery/pkg/apis/meta/v1"
	"k8s.io/apimachinery/pkg/labels"
	"k8s.io/apimachinery/pkg/watch"
	"k8s.io/client-go/tools/cache"
)

var (
	lockDockerCredentialListerMockGet  sync.RWMutex
	lockDockerCredentialListerMockList sync.RWMutex
)

// Ensure, that DockerCredentialListerMock does implement v31.DockerCredentialLister.
// If this is not the case, regenerate this file with moq.
var _ v31.DockerCredentialLister = &DockerCredentialListerMock{}

// DockerCredentialListerMock is a mock implementation of v31.DockerCredentialLister.
//
//     func TestSomethingThatUsesDockerCredentialLister(t *testing.T) {
//
//         // make and configure a mocked v31.DockerCredentialLister
//         mockedDockerCredentialLister := &DockerCredentialListerMock{
//             GetFunc: func(namespace string, name string) (*v3.DockerCredential, error) {
// 	               panic("mock out the Get method")
//             },
//             ListFunc: func(namespace string, selector labels.Selector) ([]*v3.DockerCredential, error) {
// 	               panic("mock out the List method")
//             },
//         }
//
//         // use mockedDockerCredentialLister in code that requires v31.DockerCredentialLister
//         // and then make assertions.
//
//     }
type DockerCredentialListerMock struct {
	// GetFunc mocks the Get method.
	GetFunc func(namespace string, name string) (*v3.DockerCredential, error)

	// ListFunc mocks the List method.
	ListFunc func(namespace string, selector labels.Selector) ([]*v3.DockerCredential, error)

	// calls tracks calls to the methods.
	calls struct {
		// Get holds details about calls to the Get method.
		Get []struct {
			// Namespace is the namespace argument value.
			Namespace string
			// Name is the name argument value.
			Name string
		}
		// List holds details about calls to the List method.
		List []struct {
			// Namespace is the namespace argument value.
			Namespace string
			// Selector is the selector argument value.
			Selector labels.Selector
		}
	}
}

// Get calls GetFunc.
func (mock *DockerCredentialListerMock) Get(namespace string, name string) (*v3.DockerCredential, error) {
	if mock.GetFunc == nil {
		panic("DockerCredentialListerMock.GetFunc: method is nil but DockerCredentialLister.Get was just called")
	}
	callInfo := struct {
		Namespace string
		Name      string
	}{
		Namespace: namespace,
		Name:      name,
	}
	lockDockerCredentialListerMockGet.Lock()
	mock.calls.Get = append(mock.calls.Get, callInfo)
	lockDockerCredentialListerMockGet.Unlock()
	return mock.GetFunc(namespace, name)
}

// GetCalls gets all the calls that were made to Get.
// Check the length with:
//     len(mockedDockerCredentialLister.GetCalls())
func (mock *DockerCredentialListerMock) GetCalls() []struct {
	Namespace string
	Name      string
} {
	var calls []struct {
		Namespace string
		Name      string
	}
	lockDockerCredentialListerMockGet.RLock()
	calls = mock.calls.Get
	lockDockerCredentialListerMockGet.RUnlock()
	return calls
}

// List calls ListFunc.
func (mock *DockerCredentialListerMock) List(namespace string, selector labels.Selector) ([]*v3.DockerCredential, error) {
	if mock.ListFunc == nil {
		panic("DockerCredentialListerMock.ListFunc: method is nil but DockerCredentialLister.List was just called")
	}
	callInfo := struct {
		Namespace string
		Selector  labels.Selector
	}{
		Namespace: namespace,
		Selector:  selector,
	}
	lockDockerCredentialListerMockList.Lock()
	mock.calls.List = append(mock.calls.List, callInfo)
	lockDockerCredentialListerMockList.Unlock()
	return mock.ListFunc(namespace, selector)
}

// ListCalls gets all the calls that were made to List.
// Check the length with:
//     len(mockedDockerCredentialLister.ListCalls())
func (mock *DockerCredentialListerMock) ListCalls() []struct {
	Namespace string
	Selector  labels.Selector
} {
	var calls []struct {
		Namespace string
		Selector  labels.Selector
	}
	lockDockerCredentialListerMockList.RLock()
	calls = mock.calls.List
	lockDockerCredentialListerMockList.RUnlock()
	return calls
}

var (
	lockDockerCredentialControllerMockAddClusterScopedFeatureHandler sync.RWMutex
	lockDockerCredentialControllerMockAddClusterScopedHandler        sync.RWMutex
	lockDockerCredentialControllerMockAddFeatureHandler              sync.RWMutex
	lockDockerCredentialControllerMockAddHandler                     sync.RWMutex
	lockDockerCredentialControllerMockEnqueue                        sync.RWMutex
	lockDockerCredentialControllerMockEnqueueAfter                   sync.RWMutex
	lockDockerCredentialControllerMockGeneric                        sync.RWMutex
	lockDockerCredentialControllerMockInformer                       sync.RWMutex
	lockDockerCredentialControllerMockLister                         sync.RWMutex
)

// Ensure, that DockerCredentialControllerMock does implement v31.DockerCredentialController.
// If this is not the case, regenerate this file with moq.
var _ v31.DockerCredentialController = &DockerCredentialControllerMock{}

// DockerCredentialControllerMock is a mock implementation of v31.DockerCredentialController.
//
//     func TestSomethingThatUsesDockerCredentialController(t *testing.T) {
//
//         // make and configure a mocked v31.DockerCredentialController
//         mockedDockerCredentialController := &DockerCredentialControllerMock{
//             AddClusterScopedFeatureHandlerFunc: func(ctx context.Context, enabled func() bool, name string, clusterName string, handler v31.DockerCredentialHandlerFunc)  {
// 	               panic("mock out the AddClusterScopedFeatureHandler method")
//             },
//             AddClusterScopedHandlerFunc: func(ctx context.Context, name string, clusterName string, handler v31.DockerCredentialHandlerFunc)  {
// 	               panic("mock out the AddClusterScopedHandler method")
//             },
//             AddFeatureHandlerFunc: func(ctx context.Context, enabled func() bool, name string, syncMoqParam v31.DockerCredentialHandlerFunc)  {
// 	               panic("mock out the AddFeatureHandler method")
//             },
//             AddHandlerFunc: func(ctx context.Context, name string, handler v31.DockerCredentialHandlerFunc)  {
// 	               panic("mock out the AddHandler method")
//             },
//             EnqueueFunc: func(namespace string, name string)  {
// 	               panic("mock out the Enqueue method")
//             },
//             EnqueueAfterFunc: func(namespace string, name string, after time.Duration)  {
// 	               panic("mock out the EnqueueAfter method")
//             },
//             GenericFunc: func() controller.GenericController {
// 	               panic("mock out the Generic method")
//             },
//             InformerFunc: func() cache.SharedIndexInformer {
// 	               panic("mock out the Informer method")
//             },
//             ListerFunc: func() v31.DockerCredentialLister {
// 	               panic("mock out the Lister method")
//             },
//         }
//
//         // use mockedDockerCredentialController in code that requires v31.DockerCredentialController
//         // and then make assertions.
//
//     }
type DockerCredentialControllerMock struct {
	// AddClusterScopedFeatureHandlerFunc mocks the AddClusterScopedFeatureHandler method.
	AddClusterScopedFeatureHandlerFunc func(ctx context.Context, enabled func() bool, name string, clusterName string, handler v31.DockerCredentialHandlerFunc)

	// AddClusterScopedHandlerFunc mocks the AddClusterScopedHandler method.
	AddClusterScopedHandlerFunc func(ctx context.Context, name string, clusterName string, handler v31.DockerCredentialHandlerFunc)

	// AddFeatureHandlerFunc mocks the AddFeatureHandler method.
	AddFeatureHandlerFunc func(ctx context.Context, enabled func() bool, name string, syncMoqParam v31.DockerCredentialHandlerFunc)

	// AddHandlerFunc mocks the AddHandler method.
	AddHandlerFunc func(ctx context.Context, name string, handler v31.DockerCredentialHandlerFunc)

	// EnqueueFunc mocks the Enqueue method.
	EnqueueFunc func(namespace string, name string)

	// EnqueueAfterFunc mocks the EnqueueAfter method.
	EnqueueAfterFunc func(namespace string, name string, after time.Duration)

	// GenericFunc mocks the Generic method.
	GenericFunc func() controller.GenericController

	// InformerFunc mocks the Informer method.
	InformerFunc func() cache.SharedIndexInformer

	// ListerFunc mocks the Lister method.
	ListerFunc func() v31.DockerCredentialLister

	// calls tracks calls to the methods.
	calls struct {
		// AddClusterScopedFeatureHandler holds details about calls to the AddClusterScopedFeatureHandler method.
		AddClusterScopedFeatureHandler []struct {
			// Ctx is the ctx argument value.
			Ctx context.Context
			// Enabled is the enabled argument value.
			Enabled func() bool
			// Name is the name argument value.
			Name string
			// ClusterName is the clusterName argument value.
			ClusterName string
			// Handler is the handler argument value.
			Handler v31.DockerCredentialHandlerFunc
		}
		// AddClusterScopedHandler holds details about calls to the AddClusterScopedHandler method.
		AddClusterScopedHandler []struct {
			// Ctx is the ctx argument value.
			Ctx context.Context
			// Name is the name argument value.
			Name string
			// ClusterName is the clusterName argument value.
			ClusterName string
			// Handler is the handler argument value.
			Handler v31.DockerCredentialHandlerFunc
		}
		// AddFeatureHandler holds details about calls to the AddFeatureHandler method.
		AddFeatureHandler []struct {
			// Ctx is the ctx argument value.
			Ctx context.Context
			// Enabled is the enabled argument value.
			Enabled func() bool
			// Name is the name argument value.
			Name string
			// Sync is the sync argument value.
			Sync v31.DockerCredentialHandlerFunc
		}
		// AddHandler holds details about calls to the AddHandler method.
		AddHandler []struct {
			// Ctx is the ctx argument value.
			Ctx context.Context
			// Name is the name argument value.
			Name string
			// Handler is the handler argument value.
			Handler v31.DockerCredentialHandlerFunc
		}
		// Enqueue holds details about calls to the Enqueue method.
		Enqueue []struct {
			// Namespace is the namespace argument value.
			Namespace string
			// Name is the name argument value.
			Name string
		}
		// EnqueueAfter holds details about calls to the EnqueueAfter method.
		EnqueueAfter []struct {
			// Namespace is the namespace argument value.
			Namespace string
			// Name is the name argument value.
			Name string
			// After is the after argument value.
			After time.Duration
		}
		// Generic holds details about calls to the Generic method.
		Generic []struct {
		}
		// Informer holds details about calls to the Informer method.
		Informer []struct {
		}
		// Lister holds details about calls to the Lister method.
		Lister []struct {
		}
	}
}

// AddClusterScopedFeatureHandler calls AddClusterScopedFeatureHandlerFunc.
func (mock *DockerCredentialControllerMock) AddClusterScopedFeatureHandler(ctx context.Context, enabled func() bool, name string, clusterName string, handler v31.DockerCredentialHandlerFunc) {
	if mock.AddClusterScopedFeatureHandlerFunc == nil {
		panic("DockerCredentialControllerMock.AddClusterScopedFeatureHandlerFunc: method is nil but DockerCredentialController.AddClusterScopedFeatureHandler was just called")
	}
	callInfo := struct {
		Ctx         context.Context
		Enabled     func() bool
		Name        string
		ClusterName string
		Handler     v31.DockerCredentialHandlerFunc
	}{
		Ctx:         ctx,
		Enabled:     enabled,
		Name:        name,
		ClusterName: clusterName,
		Handler:     handler,
	}
	lockDockerCredentialControllerMockAddClusterScopedFeatureHandler.Lock()
	mock.calls.AddClusterScopedFeatureHandler = append(mock.calls.AddClusterScopedFeatureHandler, callInfo)
	lockDockerCredentialControllerMockAddClusterScopedFeatureHandler.Unlock()
	mock.AddClusterScopedFeatureHandlerFunc(ctx, enabled, name, clusterName, handler)
}

// AddClusterScopedFeatureHandlerCalls gets all the calls that were made to AddClusterScopedFeatureHandler.
// Check the length with:
//     len(mockedDockerCredentialController.AddClusterScopedFeatureHandlerCalls())
func (mock *DockerCredentialControllerMock) AddClusterScopedFeatureHandlerCalls() []struct {
	Ctx         context.Context
	Enabled     func() bool
	Name        string
	ClusterName string
	Handler     v31.DockerCredentialHandlerFunc
} {
	var calls []struct {
		Ctx         context.Context
		Enabled     func() bool
		Name        string
		ClusterName string
		Handler     v31.DockerCredentialHandlerFunc
	}
	lockDockerCredentialControllerMockAddClusterScopedFeatureHandler.RLock()
	calls = mock.calls.AddClusterScopedFeatureHandler
	lockDockerCredentialControllerMockAddClusterScopedFeatureHandler.RUnlock()
	return calls
}

// AddClusterScopedHandler calls AddClusterScopedHandlerFunc.
func (mock *DockerCredentialControllerMock) AddClusterScopedHandler(ctx context.Context, name string, clusterName string, handler v31.DockerCredentialHandlerFunc) {
	if mock.AddClusterScopedHandlerFunc == nil {
		panic("DockerCredentialControllerMock.AddClusterScopedHandlerFunc: method is nil but DockerCredentialController.AddClusterScopedHandler was just called")
	}
	callInfo := struct {
		Ctx         context.Context
		Name        string
		ClusterName string
		Handler     v31.DockerCredentialHandlerFunc
	}{
		Ctx:         ctx,
		Name:        name,
		ClusterName: clusterName,
		Handler:     handler,
	}
	lockDockerCredentialControllerMockAddClusterScopedHandler.Lock()
	mock.calls.AddClusterScopedHandler = append(mock.calls.AddClusterScopedHandler, callInfo)
	lockDockerCredentialControllerMockAddClusterScopedHandler.Unlock()
	mock.AddClusterScopedHandlerFunc(ctx, name, clusterName, handler)
}

// AddClusterScopedHandlerCalls gets all the calls that were made to AddClusterScopedHandler.
// Check the length with:
//     len(mockedDockerCredentialController.AddClusterScopedHandlerCalls())
func (mock *DockerCredentialControllerMock) AddClusterScopedHandlerCalls() []struct {
	Ctx         context.Context
	Name        string
	ClusterName string
	Handler     v31.DockerCredentialHandlerFunc
} {
	var calls []struct {
		Ctx         context.Context
		Name        string
		ClusterName string
		Handler     v31.DockerCredentialHandlerFunc
	}
	lockDockerCredentialControllerMockAddClusterScopedHandler.RLock()
	calls = mock.calls.AddClusterScopedHandler
	lockDockerCredentialControllerMockAddClusterScopedHandler.RUnlock()
	return calls
}

// AddFeatureHandler calls AddFeatureHandlerFunc.
func (mock *DockerCredentialControllerMock) AddFeatureHandler(ctx context.Context, enabled func() bool, name string, syncMoqParam v31.DockerCredentialHandlerFunc) {
	if mock.AddFeatureHandlerFunc == nil {
		panic("DockerCredentialControllerMock.AddFeatureHandlerFunc: method is nil but DockerCredentialController.AddFeatureHandler was just called")
	}
	callInfo := struct {
		Ctx     context.Context
		Enabled func() bool
		Name    string
		Sync    v31.DockerCredentialHandlerFunc
	}{
		Ctx:     ctx,
		Enabled: enabled,
		Name:    name,
		Sync:    syncMoqParam,
	}
	lockDockerCredentialControllerMockAddFeatureHandler.Lock()
	mock.calls.AddFeatureHandler = append(mock.calls.AddFeatureHandler, callInfo)
	lockDockerCredentialControllerMockAddFeatureHandler.Unlock()
	mock.AddFeatureHandlerFunc(ctx, enabled, name, syncMoqParam)
}

// AddFeatureHandlerCalls gets all the calls that were made to AddFeatureHandler.
// Check the length with:
//     len(mockedDockerCredentialController.AddFeatureHandlerCalls())
func (mock *DockerCredentialControllerMock) AddFeatureHandlerCalls() []struct {
	Ctx     context.Context
	Enabled func() bool
	Name    string
	Sync    v31.DockerCredentialHandlerFunc
} {
	var calls []struct {
		Ctx     context.Context
		Enabled func() bool
		Name    string
		Sync    v31.DockerCredentialHandlerFunc
	}
	lockDockerCredentialControllerMockAddFeatureHandler.RLock()
	calls = mock.calls.AddFeatureHandler
	lockDockerCredentialControllerMockAddFeatureHandler.RUnlock()
	return calls
}

// AddHandler calls AddHandlerFunc.
func (mock *DockerCredentialControllerMock) AddHandler(ctx context.Context, name string, handler v31.DockerCredentialHandlerFunc) {
	if mock.AddHandlerFunc == nil {
		panic("DockerCredentialControllerMock.AddHandlerFunc: method is nil but DockerCredentialController.AddHandler was just called")
	}
	callInfo := struct {
		Ctx     context.Context
		Name    string
		Handler v31.DockerCredentialHandlerFunc
	}{
		Ctx:     ctx,
		Name:    name,
		Handler: handler,
	}
	lockDockerCredentialControllerMockAddHandler.Lock()
	mock.calls.AddHandler = append(mock.calls.AddHandler, callInfo)
	lockDockerCredentialControllerMockAddHandler.Unlock()
	mock.AddHandlerFunc(ctx, name, handler)
}

// AddHandlerCalls gets all the calls that were made to AddHandler.
// Check the length with:
//     len(mockedDockerCredentialController.AddHandlerCalls())
func (mock *DockerCredentialControllerMock) AddHandlerCalls() []struct {
	Ctx     context.Context
	Name    string
	Handler v31.DockerCredentialHandlerFunc
} {
	var calls []struct {
		Ctx     context.Context
		Name    string
		Handler v31.DockerCredentialHandlerFunc
	}
	lockDockerCredentialControllerMockAddHandler.RLock()
	calls = mock.calls.AddHandler
	lockDockerCredentialControllerMockAddHandler.RUnlock()
	return calls
}

// Enqueue calls EnqueueFunc.
func (mock *DockerCredentialControllerMock) Enqueue(namespace string, name string) {
	if mock.EnqueueFunc == nil {
		panic("DockerCredentialControllerMock.EnqueueFunc: method is nil but DockerCredentialController.Enqueue was just called")
	}
	callInfo := struct {
		Namespace string
		Name      string
	}{
		Namespace: namespace,
		Name:      name,
	}
	lockDockerCredentialControllerMockEnqueue.Lock()
	mock.calls.Enqueue = append(mock.calls.Enqueue, callInfo)
	lockDockerCredentialControllerMockEnqueue.Unlock()
	mock.EnqueueFunc(namespace, name)
}

// EnqueueCalls gets all the calls that were made to Enqueue.
// Check the length with:
//     len(mockedDockerCredentialController.EnqueueCalls())
func (mock *DockerCredentialControllerMock) EnqueueCalls() []struct {
	Namespace string
	Name      string
} {
	var calls []struct {
		Namespace string
		Name      string
	}
	lockDockerCredentialControllerMockEnqueue.RLock()
	calls = mock.calls.Enqueue
	lockDockerCredentialControllerMockEnqueue.RUnlock()
	return calls
}

// EnqueueAfter calls EnqueueAfterFunc.
func (mock *DockerCredentialControllerMock) EnqueueAfter(namespace string, name string, after time.Duration) {
	if mock.EnqueueAfterFunc == nil {
		panic("DockerCredentialControllerMock.EnqueueAfterFunc: method is nil but DockerCredentialController.EnqueueAfter was just called")
	}
	callInfo := struct {
		Namespace string
		Name      string
		After     time.Duration
	}{
		Namespace: namespace,
		Name:      name,
		After:     after,
	}
	lockDockerCredentialControllerMockEnqueueAfter.Lock()
	mock.calls.EnqueueAfter = append(mock.calls.EnqueueAfter, callInfo)
	lockDockerCredentialControllerMockEnqueueAfter.Unlock()
	mock.EnqueueAfterFunc(namespace, name, after)
}

// EnqueueAfterCalls gets all the calls that were made to EnqueueAfter.
// Check the length with:
//     len(mockedDockerCredentialController.EnqueueAfterCalls())
func (mock *DockerCredentialControllerMock) EnqueueAfterCalls() []struct {
	Namespace string
	Name      string
	After     time.Duration
} {
	var calls []struct {
		Namespace string
		Name      string
		After     time.Duration
	}
	lockDockerCredentialControllerMockEnqueueAfter.RLock()
	calls = mock.calls.EnqueueAfter
	lockDockerCredentialControllerMockEnqueueAfter.RUnlock()
	return calls
}

// Generic calls GenericFunc.
func (mock *DockerCredentialControllerMock) Generic() controller.GenericController {
	if mock.GenericFunc == nil {
		panic("DockerCredentialControllerMock.GenericFunc: method is nil but DockerCredentialController.Generic was just called")
	}
	callInfo := struct {
	}{}
	lockDockerCredentialControllerMockGeneric.Lock()
	mock.calls.Generic = append(mock.calls.Generic, callInfo)
	lockDockerCredentialControllerMockGeneric.Unlock()
	return mock.GenericFunc()
}

// GenericCalls gets all the calls that were made to Generic.
// Check the length with:
//     len(mockedDockerCredentialController.GenericCalls())
func (mock *DockerCredentialControllerMock) GenericCalls() []struct {
} {
	var calls []struct {
	}
	lockDockerCredentialControllerMockGeneric.RLock()
	calls = mock.calls.Generic
	lockDockerCredentialControllerMockGeneric.RUnlock()
	return calls
}

// Informer calls InformerFunc.
func (mock *DockerCredentialControllerMock) Informer() cache.SharedIndexInformer {
	if mock.InformerFunc == nil {
		panic("DockerCredentialControllerMock.InformerFunc: method is nil but DockerCredentialController.Informer was just called")
	}
	callInfo := struct {
	}{}
	lockDockerCredentialControllerMockInformer.Lock()
	mock.calls.Informer = append(mock.calls.Informer, callInfo)
	lockDockerCredentialControllerMockInformer.Unlock()
	return mock.InformerFunc()
}

// InformerCalls gets all the calls that were made to Informer.
// Check the length with:
//     len(mockedDockerCredentialController.InformerCalls())
func (mock *DockerCredentialControllerMock) InformerCalls() []struct {
} {
	var calls []struct {
	}
	lockDockerCredentialControllerMockInformer.RLock()
	calls = mock.calls.Informer
	lockDockerCredentialControllerMockInformer.RUnlock()
	return calls
}

// Lister calls ListerFunc.
func (mock *DockerCredentialControllerMock) Lister() v31.DockerCredentialLister {
	if mock.ListerFunc == nil {
		panic("DockerCredentialControllerMock.ListerFunc: method is nil but DockerCredentialController.Lister was just called")
	}
	callInfo := struct {
	}{}
	lockDockerCredentialControllerMockLister.Lock()
	mock.calls.Lister = append(mock.calls.Lister, callInfo)
	lockDockerCredentialControllerMockLister.Unlock()
	return mock.ListerFunc()
}

// ListerCalls gets all the calls that were made to Lister.
// Check the length with:
//     len(mockedDockerCredentialController.ListerCalls())
func (mock *DockerCredentialControllerMock) ListerCalls() []struct {
} {
	var calls []struct {
	}
	lockDockerCredentialControllerMockLister.RLock()
	calls = mock.calls.Lister
	lockDockerCredentialControllerMockLister.RUnlock()
	return calls
}

var (
	lockDockerCredentialInterfaceMockAddClusterScopedFeatureHandler   sync.RWMutex
	lockDockerCredentialInterfaceMockAddClusterScopedFeatureLifecycle sync.RWMutex
	lockDockerCredentialInterfaceMockAddClusterScopedHandler          sync.RWMutex
	lockDockerCredentialInterfaceMockAddClusterScopedLifecycle        sync.RWMutex
	lockDockerCredentialInterfaceMockAddFeatureHandler                sync.RWMutex
	lockDockerCredentialInterfaceMockAddFeatureLifecycle              sync.RWMutex
	lockDockerCredentialInterfaceMockAddHandler                       sync.RWMutex
	lockDockerCredentialInterfaceMockAddLifecycle                     sync.RWMutex
	lockDockerCredentialInterfaceMockController                       sync.RWMutex
	lockDockerCredentialInterfaceMockCreate                           sync.RWMutex
	lockDockerCredentialInterfaceMockDelete                           sync.RWMutex
	lockDockerCredentialInterfaceMockDeleteCollection                 sync.RWMutex
	lockDockerCredentialInterfaceMockDeleteNamespaced                 sync.RWMutex
	lockDockerCredentialInterfaceMockGet                              sync.RWMutex
	lockDockerCredentialInterfaceMockGetNamespaced                    sync.RWMutex
	lockDockerCredentialInterfaceMockList                             sync.RWMutex
	lockDockerCredentialInterfaceMockListNamespaced                   sync.RWMutex
	lockDockerCredentialInterfaceMockObjectClient                     sync.RWMutex
	lockDockerCredentialInterfaceMockUpdate                           sync.RWMutex
	lockDockerCredentialInterfaceMockWatch                            sync.RWMutex
)

// Ensure, that DockerCredentialInterfaceMock does implement v31.DockerCredentialInterface.
// If this is not the case, regenerate this file with moq.
var _ v31.DockerCredentialInterface = &DockerCredentialInterfaceMock{}

// DockerCredentialInterfaceMock is a mock implementation of v31.DockerCredentialInterface.
//
//     func TestSomethingThatUsesDockerCredentialInterface(t *testing.T) {
//
//         // make and configure a mocked v31.DockerCredentialInterface
//         mockedDockerCredentialInterface := &DockerCredentialInterfaceMock{
//             AddClusterScopedFeatureHandlerFunc: func(ctx context.Context, enabled func() bool, name string, clusterName string, syncMoqParam v31.DockerCredentialHandlerFunc)  {
// 	               panic("mock out the AddClusterScopedFeatureHandler method")
//             },
//             AddClusterScopedFeatureLifecycleFunc: func(ctx context.Context, enabled func() bool, name string, clusterName string, lifecycle v31.DockerCredentialLifecycle)  {
// 	               panic("mock out the AddClusterScopedFeatureLifecycle method")
//             },
//             AddClusterScopedHandlerFunc: func(ctx context.Context, name string, clusterName string, syncMoqParam v31.DockerCredentialHandlerFunc)  {
// 	               panic("mock out the AddClusterScopedHandler method")
//             },
//             AddClusterScopedLifecycleFunc: func(ctx context.Context, name string, clusterName string, lifecycle v31.DockerCredentialLifecycle)  {
// 	               panic("mock out the AddClusterScopedLifecycle method")
//             },
//             AddFeatureHandlerFunc: func(ctx context.Context, enabled func() bool, name string, syncMoqParam v31.DockerCredentialHandlerFunc)  {
// 	               panic("mock out the AddFeatureHandler method")
//             },
//             AddFeatureLifecycleFunc: func(ctx context.Context, enabled func() bool, name string, lifecycle v31.DockerCredentialLifecycle)  {
// 	               panic("mock out the AddFeatureLifecycle method")
//             },
//             AddHandlerFunc: func(ctx context.Context, name string, syncMoqParam v31.DockerCredentialHandlerFunc)  {
// 	               panic("mock out the AddHandler method")
//             },
//             AddLifecycleFunc: func(ctx context.Context, name string, lifecycle v31.DockerCredentialLifecycle)  {
// 	               panic("mock out the AddLifecycle method")
//             },
//             ControllerFunc: func() v31.DockerCredentialController {
// 	               panic("mock out the Controller method")
//             },
//             CreateFunc: func(in1 *v3.DockerCredential) (*v3.DockerCredential, error) {
// 	               panic("mock out the Create method")
//             },
//             DeleteFunc: func(name string, options *metav1.DeleteOptions) error {
// 	               panic("mock out the Delete method")
//             },
//             DeleteCollectionFunc: func(deleteOpts *metav1.DeleteOptions, listOpts metav1.ListOptions) error {
// 	               panic("mock out the DeleteCollection method")
//             },
//             DeleteNamespacedFunc: func(namespace string, name string, options *metav1.DeleteOptions) error {
// 	               panic("mock out the DeleteNamespaced method")
//             },
//             GetFunc: func(name string, opts metav1.GetOptions) (*v3.DockerCredential, error) {
// 	               panic("mock out the Get method")
//             },
//             GetNamespacedFunc: func(namespace string, name string, opts metav1.GetOptions) (*v3.DockerCredential, error) {
// 	               panic("mock out the GetNamespaced method")
//             },
//             ListFunc: func(opts metav1.ListOptions) (*v3.DockerCredentialList, error) {
// 	               panic("mock out the List method")
//             },
//             ListNamespacedFunc: func(namespace string, opts metav1.ListOptions) (*v3.DockerCredentialList, error) {
// 	               panic("mock out the ListNamespaced method")
//             },
//             ObjectClientFunc: func() *objectclient.ObjectClient {
// 	               panic("mock out the ObjectClient method")
//             },
//             UpdateFunc: func(in1 *v3.DockerCredential) (*v3.DockerCredential, error) {
// 	               panic("mock out the Update method")
//             },
//             WatchFunc: func(opts metav1.ListOptions) (watch.Interface, error) {
// 	               panic("mock out the Watch method")
//             },
//         }
//
//         // use mockedDockerCredentialInterface in code that requires v31.DockerCredentialInterface
//         // and then make assertions.
//
//     }
type DockerCredentialInterfaceMock struct {
	// AddClusterScopedFeatureHandlerFunc mocks the AddClusterScopedFeatureHandler method.
	AddClusterScopedFeatureHandlerFunc func(ctx context.Context, enabled func() bool, name string, clusterName string, syncMoqParam v31.DockerCredentialHandlerFunc)

	// AddClusterScopedFeatureLifecycleFunc mocks the AddClusterScopedFeatureLifecycle method.
	AddClusterScopedFeatureLifecycleFunc func(ctx context.Context, enabled func() bool, name string, clusterName string, lifecycle v31.DockerCredentialLifecycle)

	// AddClusterScopedHandlerFunc mocks the AddClusterScopedHandler method.
	AddClusterScopedHandlerFunc func(ctx context.Context, name string, clusterName string, syncMoqParam v31.DockerCredentialHandlerFunc)

	// AddClusterScopedLifecycleFunc mocks the AddClusterScopedLifecycle method.
	AddClusterScopedLifecycleFunc func(ctx context.Context, name string, clusterName string, lifecycle v31.DockerCredentialLifecycle)

	// AddFeatureHandlerFunc mocks the AddFeatureHandler method.
	AddFeatureHandlerFunc func(ctx context.Context, enabled func() bool, name string, syncMoqParam v31.DockerCredentialHandlerFunc)

	// AddFeatureLifecycleFunc mocks the AddFeatureLifecycle method.
	AddFeatureLifecycleFunc func(ctx context.Context, enabled func() bool, name string, lifecycle v31.DockerCredentialLifecycle)

	// AddHandlerFunc mocks the AddHandler method.
	AddHandlerFunc func(ctx context.Context, name string, syncMoqParam v31.DockerCredentialHandlerFunc)

	// AddLifecycleFunc mocks the AddLifecycle method.
	AddLifecycleFunc func(ctx context.Context, name string, lifecycle v31.DockerCredentialLifecycle)

	// ControllerFunc mocks the Controller method.
	ControllerFunc func() v31.DockerCredentialController

	// CreateFunc mocks the Create method.
	CreateFunc func(in1 *v3.DockerCredential) (*v3.DockerCredential, error)

	// DeleteFunc mocks the Delete method.
	DeleteFunc func(name string, options *metav1.DeleteOptions) error

	// DeleteCollectionFunc mocks the DeleteCollection method.
	DeleteCollectionFunc func(deleteOpts *metav1.DeleteOptions, listOpts metav1.ListOptions) error

	// DeleteNamespacedFunc mocks the DeleteNamespaced method.
	DeleteNamespacedFunc func(namespace string, name string, options *metav1.DeleteOptions) error

	// GetFunc mocks the Get method.
	GetFunc func(name string, opts metav1.GetOptions) (*v3.DockerCredential, error)

	// GetNamespacedFunc mocks the GetNamespaced method.
	GetNamespacedFunc func(namespace string, name string, opts metav1.GetOptions) (*v3.DockerCredential, error)

	// ListFunc mocks the List method.
	ListFunc func(opts metav1.ListOptions) (*v3.DockerCredentialList, error)

	// ListNamespacedFunc mocks the ListNamespaced method.
	ListNamespacedFunc func(namespace string, opts metav1.ListOptions) (*v3.DockerCredentialList, error)

	// ObjectClientFunc mocks the ObjectClient method.
	ObjectClientFunc func() *objectclient.ObjectClient

	// UpdateFunc mocks the Update method.
	UpdateFunc func(in1 *v3.DockerCredential) (*v3.DockerCredential, error)

	// WatchFunc mocks the Watch method.
	WatchFunc func(opts metav1.ListOptions) (watch.Interface, error)

	// calls tracks calls to the methods.
	calls struct {
		// AddClusterScopedFeatureHandler holds details about calls to the AddClusterScopedFeatureHandler method.
		AddClusterScopedFeatureHandler []struct {
			// Ctx is the ctx argument value.
			Ctx context.Context
			// Enabled is the enabled argument value.
			Enabled func() bool
			// Name is the name argument value.
			Name string
			// ClusterName is the clusterName argument value.
			ClusterName string
			// Sync is the sync argument value.
			Sync v31.DockerCredentialHandlerFunc
		}
		// AddClusterScopedFeatureLifecycle holds details about calls to the AddClusterScopedFeatureLifecycle method.
		AddClusterScopedFeatureLifecycle []struct {
			// Ctx is the ctx argument value.
			Ctx context.Context
			// Enabled is the enabled argument value.
			Enabled func() bool
			// Name is the name argument value.
			Name string
			// ClusterName is the clusterName argument value.
			ClusterName string
			// Lifecycle is the lifecycle argument value.
			Lifecycle v31.DockerCredentialLifecycle
		}
		// AddClusterScopedHandler holds details about calls to the AddClusterScopedHandler method.
		AddClusterScopedHandler []struct {
			// Ctx is the ctx argument value.
			Ctx context.Context
			// Name is the name argument value.
			Name string
			// ClusterName is the clusterName argument value.
			ClusterName string
			// Sync is the sync argument value.
			Sync v31.DockerCredentialHandlerFunc
		}
		// AddClusterScopedLifecycle holds details about calls to the AddClusterScopedLifecycle method.
		AddClusterScopedLifecycle []struct {
			// Ctx is the ctx argument value.
			Ctx context.Context
			// Name is the name argument value.
			Name string
			// ClusterName is the clusterName argument value.
			ClusterName string
			// Lifecycle is the lifecycle argument value.
			Lifecycle v31.DockerCredentialLifecycle
		}
		// AddFeatureHandler holds details about calls to the AddFeatureHandler method.
		AddFeatureHandler []struct {
			// Ctx is the ctx argument value.
			Ctx context.Context
			// Enabled is the enabled argument value.
			Enabled func() bool
			// Name is the name argument value.
			Name string
			// Sync is the sync argument value.
			Sync v31.DockerCredentialHandlerFunc
		}
		// AddFeatureLifecycle holds details about calls to the AddFeatureLifecycle method.
		AddFeatureLifecycle []struct {
			// Ctx is the ctx argument value.
			Ctx context.Context
			// Enabled is the enabled argument value.
			Enabled func() bool
			// Name is the name argument value.
			Name string
			// Lifecycle is the lifecycle argument value.
			Lifecycle v31.DockerCredentialLifecycle
		}
		// AddHandler holds details about calls to the AddHandler method.
		AddHandler []struct {
			// Ctx is the ctx argument value.
			Ctx context.Context
			// Name is the name argument value.
			Name string
			// Sync is the sync argument value.
			Sync v31.DockerCredentialHandlerFunc
		}
		// AddLifecycle holds details about calls to the AddLifecycle method.
		AddLifecycle []struct {
			// Ctx is the ctx argument value.
			Ctx context.Context
			// Name is the name argument value.
			Name string
			// Lifecycle is the lifecycle argument value.
			Lifecycle v31.DockerCredentialLifecycle
		}
		// Controller holds details about calls to the Controller method.
		Controller []struct {
		}
		// Create holds details about calls to the Create method.
		Create []struct {
			// In1 is the in1 argument value.
			In1 *v3.DockerCredential
		}
		// Delete holds details about calls to the Delete method.
		Delete []struct {
			// Name is the name argument value.
			Name string
			// Options is the options argument value.
			Options *metav1.DeleteOptions
		}
		// DeleteCollection holds details about calls to the DeleteCollection method.
		DeleteCollection []struct {
			// DeleteOpts is the deleteOpts argument value.
			DeleteOpts *metav1.DeleteOptions
			// ListOpts is the listOpts argument value.
			ListOpts metav1.ListOptions
		}
		// DeleteNamespaced holds details about calls to the DeleteNamespaced method.
		DeleteNamespaced []struct {
			// Namespace is the namespace argument value.
			Namespace string
			// Name is the name argument value.
			Name string
			// Options is the options argument value.
			Options *metav1.DeleteOptions
		}
		// Get holds details about calls to the Get method.
		Get []struct {
			// Name is the name argument value.
			Name string
			// Opts is the opts argument value.
			Opts metav1.GetOptions
		}
		// GetNamespaced holds details about calls to the GetNamespaced method.
		GetNamespaced []struct {
			// Namespace is the namespace argument value.
			Namespace string
			// Name is the name argument value.
			Name string
			// Opts is the opts argument value.
			Opts metav1.GetOptions
		}
		// List holds details about calls to the List method.
		List []struct {
			// Opts is the opts argument value.
			Opts metav1.ListOptions
		}
		// ListNamespaced holds details about calls to the ListNamespaced method.
		ListNamespaced []struct {
			// Namespace is the namespace argument value.
			Namespace string
			// Opts is the opts argument value.
			Opts metav1.ListOptions
		}
		// ObjectClient holds details about calls to the ObjectClient method.
		ObjectClient []struct {
		}
		// Update holds details about calls to the Update method.
		Update []struct {
			// In1 is the in1 argument value.
			In1 *v3.DockerCredential
		}
		// Watch holds details about calls to the Watch method.
		Watch []struct {
			// Opts is the opts argument value.
			Opts metav1.ListOptions
		}
	}
}

// AddClusterScopedFeatureHandler calls AddClusterScopedFeatureHandlerFunc.
func (mock *DockerCredentialInterfaceMock) AddClusterScopedFeatureHandler(ctx context.Context, enabled func() bool, name string, clusterName string, syncMoqParam v31.DockerCredentialHandlerFunc) {
	if mock.AddClusterScopedFeatureHandlerFunc == nil {
		panic("DockerCredentialInterfaceMock.AddClusterScopedFeatureHandlerFunc: method is nil but DockerCredentialInterface.AddClusterScopedFeatureHandler was just called")
	}
	callInfo := struct {
		Ctx         context.Context
		Enabled     func() bool
		Name        string
		ClusterName string
		Sync        v31.DockerCredentialHandlerFunc
	}{
		Ctx:         ctx,
		Enabled:     enabled,
		Name:        name,
		ClusterName: clusterName,
		Sync:        syncMoqParam,
	}
	lockDockerCredentialInterfaceMockAddClusterScopedFeatureHandler.Lock()
	mock.calls.AddClusterScopedFeatureHandler = append(mock.calls.AddClusterScopedFeatureHandler, callInfo)
	lockDockerCredentialInterfaceMockAddClusterScopedFeatureHandler.Unlock()
	mock.AddClusterScopedFeatureHandlerFunc(ctx, enabled, name, clusterName, syncMoqParam)
}

// AddClusterScopedFeatureHandlerCalls gets all the calls that were made to AddClusterScopedFeatureHandler.
// Check the length with:
//     len(mockedDockerCredentialInterface.AddClusterScopedFeatureHandlerCalls())
func (mock *DockerCredentialInterfaceMock) AddClusterScopedFeatureHandlerCalls() []struct {
	Ctx         context.Context
	Enabled     func() bool
	Name        string
	ClusterName string
	Sync        v31.DockerCredentialHandlerFunc
} {
	var calls []struct {
		Ctx         context.Context
		Enabled     func() bool
		Name        string
		ClusterName string
		Sync        v31.DockerCredentialHandlerFunc
	}
	lockDockerCredentialInterfaceMockAddClusterScopedFeatureHandler.RLock()
	calls = mock.calls.AddClusterScopedFeatureHandler
	lockDockerCredentialInterfaceMockAddClusterScopedFeatureHandler.RUnlock()
	return calls
}

// AddClusterScopedFeatureLifecycle calls AddClusterScopedFeatureLifecycleFunc.
func (mock *DockerCredentialInterfaceMock) AddClusterScopedFeatureLifecycle(ctx context.Context, enabled func() bool, name string, clusterName string, lifecycle v31.DockerCredentialLifecycle) {
	if mock.AddClusterScopedFeatureLifecycleFunc == nil {
		panic("DockerCredentialInterfaceMock.AddClusterScopedFeatureLifecycleFunc: method is nil but DockerCredentialInterface.AddClusterScopedFeatureLifecycle was just called")
	}
	callInfo := struct {
		Ctx         context.Context
		Enabled     func() bool
		Name        string
		ClusterName string
		Lifecycle   v31.DockerCredentialLifecycle
	}{
		Ctx:         ctx,
		Enabled:     enabled,
		Name:        name,
		ClusterName: clusterName,
		Lifecycle:   lifecycle,
	}
	lockDockerCredentialInterfaceMockAddClusterScopedFeatureLifecycle.Lock()
	mock.calls.AddClusterScopedFeatureLifecycle = append(mock.calls.AddClusterScopedFeatureLifecycle, callInfo)
	lockDockerCredentialInterfaceMockAddClusterScopedFeatureLifecycle.Unlock()
	mock.AddClusterScopedFeatureLifecycleFunc(ctx, enabled, name, clusterName, lifecycle)
}

// AddClusterScopedFeatureLifecycleCalls gets all the calls that were made to AddClusterScopedFeatureLifecycle.
// Check the length with:
//     len(mockedDockerCredentialInterface.AddClusterScopedFeatureLifecycleCalls())
func (mock *DockerCredentialInterfaceMock) AddClusterScopedFeatureLifecycleCalls() []struct {
	Ctx         context.Context
	Enabled     func() bool
	Name        string
	ClusterName string
	Lifecycle   v31.DockerCredentialLifecycle
} {
	var calls []struct {
		Ctx         context.Context
		Enabled     func() bool
		Name        string
		ClusterName string
		Lifecycle   v31.DockerCredentialLifecycle
	}
	lockDockerCredentialInterfaceMockAddClusterScopedFeatureLifecycle.RLock()
	calls = mock.calls.AddClusterScopedFeatureLifecycle
	lockDockerCredentialInterfaceMockAddClusterScopedFeatureLifecycle.RUnlock()
	return calls
}

// AddClusterScopedHandler calls AddClusterScopedHandlerFunc.
func (mock *DockerCredentialInterfaceMock) AddClusterScopedHandler(ctx context.Context, name string, clusterName string, syncMoqParam v31.DockerCredentialHandlerFunc) {
	if mock.AddClusterScopedHandlerFunc == nil {
		panic("DockerCredentialInterfaceMock.AddClusterScopedHandlerFunc: method is nil but DockerCredentialInterface.AddClusterScopedHandler was just called")
	}
	callInfo := struct {
		Ctx         context.Context
		Name        string
		ClusterName string
		Sync        v31.DockerCredentialHandlerFunc
	}{
		Ctx:         ctx,
		Name:        name,
		ClusterName: clusterName,
		Sync:        syncMoqParam,
	}
	lockDockerCredentialInterfaceMockAddClusterScopedHandler.Lock()
	mock.calls.AddClusterScopedHandler = append(mock.calls.AddClusterScopedHandler, callInfo)
	lockDockerCredentialInterfaceMockAddClusterScopedHandler.Unlock()
	mock.AddClusterScopedHandlerFunc(ctx, name, clusterName, syncMoqParam)
}

// AddClusterScopedHandlerCalls gets all the calls that were made to AddClusterScopedHandler.
// Check the length with:
//     len(mockedDockerCredentialInterface.AddClusterScopedHandlerCalls())
func (mock *DockerCredentialInterfaceMock) AddClusterScopedHandlerCalls() []struct {
	Ctx         context.Context
	Name        string
	ClusterName string
	Sync        v31.DockerCredentialHandlerFunc
} {
	var calls []struct {
		Ctx         context.Context
		Name        string
		ClusterName string
		Sync        v31.DockerCredentialHandlerFunc
	}
	lockDockerCredentialInterfaceMockAddClusterScopedHandler.RLock()
	calls = mock.calls.AddClusterScopedHandler
	lockDockerCredentialInterfaceMockAddClusterScopedHandler.RUnlock()
	return calls
}

// AddClusterScopedLifecycle calls AddClusterScopedLifecycleFunc.
func (mock *DockerCredentialInterfaceMock) AddClusterScopedLifecycle(ctx context.Context, name string, clusterName string, lifecycle v31.DockerCredentialLifecycle) {
	if mock.AddClusterScopedLifecycleFunc == nil {
		panic("DockerCredentialInterfaceMock.AddClusterScopedLifecycleFunc: method is nil but DockerCredentialInterface.AddClusterScopedLifecycle was just called")
	}
	callInfo := struct {
		Ctx         context.Context
		Name        string
		ClusterName string
		Lifecycle   v31.DockerCredentialLifecycle
	}{
		Ctx:         ctx,
		Name:        name,
		ClusterName: clusterName,
		Lifecycle:   lifecycle,
	}
	lockDockerCredentialInterfaceMockAddClusterScopedLifecycle.Lock()
	mock.calls.AddClusterScopedLifecycle = append(mock.calls.AddClusterScopedLifecycle, callInfo)
	lockDockerCredentialInterfaceMockAddClusterScopedLifecycle.Unlock()
	mock.AddClusterScopedLifecycleFunc(ctx, name, clusterName, lifecycle)
}

// AddClusterScopedLifecycleCalls gets all the calls that were made to AddClusterScopedLifecycle.
// Check the length with:
//     len(mockedDockerCredentialInterface.AddClusterScopedLifecycleCalls())
func (mock *DockerCredentialInterfaceMock) AddClusterScopedLifecycleCalls() []struct {
	Ctx         context.Context
	Name        string
	ClusterName string
	Lifecycle   v31.DockerCredentialLifecycle
} {
	var calls []struct {
		Ctx         context.Context
		Name        string
		ClusterName string
		Lifecycle   v31.DockerCredentialLifecycle
	}
	lockDockerCredentialInterfaceMockAddClusterScopedLifecycle.RLock()
	calls = mock.calls.AddClusterScopedLifecycle
	lockDockerCredentialInterfaceMockAddClusterScopedLifecycle.RUnlock()
	return calls
}

// AddFeatureHandler calls AddFeatureHandlerFunc.
func (mock *DockerCredentialInterfaceMock) AddFeatureHandler(ctx context.Context, enabled func() bool, name string, syncMoqParam v31.DockerCredentialHandlerFunc) {
	if mock.AddFeatureHandlerFunc == nil {
		panic("DockerCredentialInterfaceMock.AddFeatureHandlerFunc: method is nil but DockerCredentialInterface.AddFeatureHandler was just called")
	}
	callInfo := struct {
		Ctx     context.Context
		Enabled func() bool
		Name    string
		Sync    v31.DockerCredentialHandlerFunc
	}{
		Ctx:     ctx,
		Enabled: enabled,
		Name:    name,
		Sync:    syncMoqParam,
	}
	lockDockerCredentialInterfaceMockAddFeatureHandler.Lock()
	mock.calls.AddFeatureHandler = append(mock.calls.AddFeatureHandler, callInfo)
	lockDockerCredentialInterfaceMockAddFeatureHandler.Unlock()
	mock.AddFeatureHandlerFunc(ctx, enabled, name, syncMoqParam)
}

// AddFeatureHandlerCalls gets all the calls that were made to AddFeatureHandler.
// Check the length with:
//     len(mockedDockerCredentialInterface.AddFeatureHandlerCalls())
func (mock *DockerCredentialInterfaceMock) AddFeatureHandlerCalls() []struct {
	Ctx     context.Context
	Enabled func() bool
	Name    string
	Sync    v31.DockerCredentialHandlerFunc
} {
	var calls []struct {
		Ctx     context.Context
		Enabled func() bool
		Name    string
		Sync    v31.DockerCredentialHandlerFunc
	}
	lockDockerCredentialInterfaceMockAddFeatureHandler.RLock()
	calls = mock.calls.AddFeatureHandler
	lockDockerCredentialInterfaceMockAddFeatureHandler.RUnlock()
	return calls
}

// AddFeatureLifecycle calls AddFeatureLifecycleFunc.
func (mock *DockerCredentialInterfaceMock) AddFeatureLifecycle(ctx context.Context, enabled func() bool, name string, lifecycle v31.DockerCredentialLifecycle) {
	if mock.AddFeatureLifecycleFunc == nil {
		panic("DockerCredentialInterfaceMock.AddFeatureLifecycleFunc: method is nil but DockerCredentialInterface.AddFeatureLifecycle was just called")
	}
	callInfo := struct {
		Ctx       context.Context
		Enabled   func() bool
		Name      string
		Lifecycle v31.DockerCredentialLifecycle
	}{
		Ctx:       ctx,
		Enabled:   enabled,
		Name:      name,
		Lifecycle: lifecycle,
	}
	lockDockerCredentialInterfaceMockAddFeatureLifecycle.Lock()
	mock.calls.AddFeatureLifecycle = append(mock.calls.AddFeatureLifecycle, callInfo)
	lockDockerCredentialInterfaceMockAddFeatureLifecycle.Unlock()
	mock.AddFeatureLifecycleFunc(ctx, enabled, name, lifecycle)
}

// AddFeatureLifecycleCalls gets all the calls that were made to AddFeatureLifecycle.
// Check the length with:
//     len(mockedDockerCredentialInterface.AddFeatureLifecycleCalls())
func (mock *DockerCredentialInterfaceMock) AddFeatureLifecycleCalls() []struct {
	Ctx       context.Context
	Enabled   func() bool
	Name      string
	Lifecycle v31.DockerCredentialLifecycle
} {
	var calls []struct {
		Ctx       context.Context
		Enabled   func() bool
		Name      string
		Lifecycle v31.DockerCredentialLifecycle
	}
	lockDockerCredentialInterfaceMockAddFeatureLifecycle.RLock()
	calls = mock.calls.AddFeatureLifecycle
	lockDockerCredentialInterfaceMockAddFeatureLifecycle.RUnlock()
	return calls
}

// AddHandler calls AddHandlerFunc.
func (mock *DockerCredentialInterfaceMock) AddHandler(ctx context.Context, name string, syncMoqParam v31.DockerCredentialHandlerFunc) {
	if mock.AddHandlerFunc == nil {
		panic("DockerCredentialInterfaceMock.AddHandlerFunc: method is nil but DockerCredentialInterface.AddHandler was just called")
	}
	callInfo := struct {
		Ctx  context.Context
		Name string
		Sync v31.DockerCredentialHandlerFunc
	}{
		Ctx:  ctx,
		Name: name,
		Sync: syncMoqParam,
	}
	lockDockerCredentialInterfaceMockAddHandler.Lock()
	mock.calls.AddHandler = append(mock.calls.AddHandler, callInfo)
	lockDockerCredentialInterfaceMockAddHandler.Unlock()
	mock.AddHandlerFunc(ctx, name, syncMoqParam)
}

// AddHandlerCalls gets all the calls that were made to AddHandler.
// Check the length with:
//     len(mockedDockerCredentialInterface.AddHandlerCalls())
func (mock *DockerCredentialInterfaceMock) AddHandlerCalls() []struct {
	Ctx  context.Context
	Name string
	Sync v31.DockerCredentialHandlerFunc
} {
	var calls []struct {
		Ctx  context.Context
		Name string
		Sync v31.DockerCredentialHandlerFunc
	}
	lockDockerCredentialInterfaceMockAddHandler.RLock()
	calls = mock.calls.AddHandler
	lockDockerCredentialInterfaceMockAddHandler.RUnlock()
	return calls
}

// AddLifecycle calls AddLifecycleFunc.
func (mock *DockerCredentialInterfaceMock) AddLifecycle(ctx context.Context, name string, lifecycle v31.DockerCredentialLifecycle) {
	if mock.AddLifecycleFunc == nil {
		panic("DockerCredentialInterfaceMock.AddLifecycleFunc: method is nil but DockerCredentialInterface.AddLifecycle was just called")
	}
	callInfo := struct {
		Ctx       context.Context
		Name      string
		Lifecycle v31.DockerCredentialLifecycle
	}{
		Ctx:       ctx,
		Name:      name,
		Lifecycle: lifecycle,
	}
	lockDockerCredentialInterfaceMockAddLifecycle.Lock()
	mock.calls.AddLifecycle = append(mock.calls.AddLifecycle, callInfo)
	lockDockerCredentialInterfaceMockAddLifecycle.Unlock()
	mock.AddLifecycleFunc(ctx, name, lifecycle)
}

// AddLifecycleCalls gets all the calls that were made to AddLifecycle.
// Check the length with:
//     len(mockedDockerCredentialInterface.AddLifecycleCalls())
func (mock *DockerCredentialInterfaceMock) AddLifecycleCalls() []struct {
	Ctx       context.Context
	Name      string
	Lifecycle v31.DockerCredentialLifecycle
} {
	var calls []struct {
		Ctx       context.Context
		Name      string
		Lifecycle v31.DockerCredentialLifecycle
	}
	lockDockerCredentialInterfaceMockAddLifecycle.RLock()
	calls = mock.calls.AddLifecycle
	lockDockerCredentialInterfaceMockAddLifecycle.RUnlock()
	return calls
}

// Controller calls ControllerFunc.
func (mock *DockerCredentialInterfaceMock) Controller() v31.DockerCredentialController {
	if mock.ControllerFunc == nil {
		panic("DockerCredentialInterfaceMock.ControllerFunc: method is nil but DockerCredentialInterface.Controller was just called")
	}
	callInfo := struct {
	}{}
	lockDockerCredentialInterfaceMockController.Lock()
	mock.calls.Controller = append(mock.calls.Controller, callInfo)
	lockDockerCredentialInterfaceMockController.Unlock()
	return mock.ControllerFunc()
}

// ControllerCalls gets all the calls that were made to Controller.
// Check the length with:
//     len(mockedDockerCredentialInterface.ControllerCalls())
func (mock *DockerCredentialInterfaceMock) ControllerCalls() []struct {
} {
	var calls []struct {
	}
	lockDockerCredentialInterfaceMockController.RLock()
	calls = mock.calls.Controller
	lockDockerCredentialInterfaceMockController.RUnlock()
	return calls
}

// Create calls CreateFunc.
func (mock *DockerCredentialInterfaceMock) Create(in1 *v3.DockerCredential) (*v3.DockerCredential, error) {
	if mock.CreateFunc == nil {
		panic("DockerCredentialInterfaceMock.CreateFunc: method is nil but DockerCredentialInterface.Create was just called")
	}
	callInfo := struct {
		In1 *v3.DockerCredential
	}{
		In1: in1,
	}
	lockDockerCredentialInterfaceMockCreate.Lock()
	mock.calls.Create = append(mock.calls.Create, callInfo)
	lockDockerCredentialInterfaceMockCreate.Unlock()
	return mock.CreateFunc(in1)
}

// CreateCalls gets all the calls that were made to Create.
// Check the length with:
//     len(mockedDockerCredentialInterface.CreateCalls())
func (mock *DockerCredentialInterfaceMock) CreateCalls() []struct {
	In1 *v3.DockerCredential
} {
	var calls []struct {
		In1 *v3.DockerCredential
	}
	lockDockerCredentialInterfaceMockCreate.RLock()
	calls = mock.calls.Create
	lockDockerCredentialInterfaceMockCreate.RUnlock()
	return calls
}

// Delete calls DeleteFunc.
func (mock *DockerCredentialInterfaceMock) Delete(name string, options *metav1.DeleteOptions) error {
	if mock.DeleteFunc == nil {
		panic("DockerCredentialInterfaceMock.DeleteFunc: method is nil but DockerCredentialInterface.Delete was just called")
	}
	callInfo := struct {
		Name    string
		Options *metav1.DeleteOptions
	}{
		Name:    name,
		Options: options,
	}
	lockDockerCredentialInterfaceMockDelete.Lock()
	mock.calls.Delete = append(mock.calls.Delete, callInfo)
	lockDockerCredentialInterfaceMockDelete.Unlock()
	return mock.DeleteFunc(name, options)
}

// DeleteCalls gets all the calls that were made to Delete.
// Check the length with:
//     len(mockedDockerCredentialInterface.DeleteCalls())
func (mock *DockerCredentialInterfaceMock) DeleteCalls() []struct {
	Name    string
	Options *metav1.DeleteOptions
} {
	var calls []struct {
		Name    string
		Options *metav1.DeleteOptions
	}
	lockDockerCredentialInterfaceMockDelete.RLock()
	calls = mock.calls.Delete
	lockDockerCredentialInterfaceMockDelete.RUnlock()
	return calls
}

// DeleteCollection calls DeleteCollectionFunc.
func (mock *DockerCredentialInterfaceMock) DeleteCollection(deleteOpts *metav1.DeleteOptions, listOpts metav1.ListOptions) error {
	if mock.DeleteCollectionFunc == nil {
		panic("DockerCredentialInterfaceMock.DeleteCollectionFunc: method is nil but DockerCredentialInterface.DeleteCollection was just called")
	}
	callInfo := struct {
		DeleteOpts *metav1.DeleteOptions
		ListOpts   metav1.ListOptions
	}{
		DeleteOpts: deleteOpts,
		ListOpts:   listOpts,
	}
	lockDockerCredentialInterfaceMockDeleteCollection.Lock()
	mock.calls.DeleteCollection = append(mock.calls.DeleteCollection, callInfo)
	lockDockerCredentialInterfaceMockDeleteCollection.Unlock()
	return mock.DeleteCollectionFunc(deleteOpts, listOpts)
}

// DeleteCollectionCalls gets all the calls that were made to DeleteCollection.
// Check the length with:
//     len(mockedDockerCredentialInterface.DeleteCollectionCalls())
func (mock *DockerCredentialInterfaceMock) DeleteCollectionCalls() []struct {
	DeleteOpts *metav1.DeleteOptions
	ListOpts   metav1.ListOptions
} {
	var calls []struct {
		DeleteOpts *metav1.DeleteOptions
		ListOpts   metav1.ListOptions
	}
	lockDockerCredentialInterfaceMockDeleteCollection.RLock()
	calls = mock.calls.DeleteCollection
	lockDockerCredentialInterfaceMockDeleteCollection.RUnlock()
	return calls
}

// DeleteNamespaced calls DeleteNamespacedFunc.
func (mock *DockerCredentialInterfaceMock) DeleteNamespaced(namespace string, name string, options *metav1.DeleteOptions) error {
	if mock.DeleteNamespacedFunc == nil {
		panic("DockerCredentialInterfaceMock.DeleteNamespacedFunc: method is nil but DockerCredentialInterface.DeleteNamespaced was just called")
	}
	callInfo := struct {
		Namespace string
		Name      string
		Options   *metav1.DeleteOptions
	}{
		Namespace: namespace,
		Name:      name,
		Options:   options,
	}
	lockDockerCredentialInterfaceMockDeleteNamespaced.Lock()
	mock.calls.DeleteNamespaced = append(mock.calls.DeleteNamespaced, callInfo)
	lockDockerCredentialInterfaceMockDeleteNamespaced.Unlock()
	return mock.DeleteNamespacedFunc(namespace, name, options)
}

// DeleteNamespacedCalls gets all the calls that were made to DeleteNamespaced.
// Check the length with:
//     len(mockedDockerCredentialInterface.DeleteNamespacedCalls())
func (mock *DockerCredentialInterfaceMock) DeleteNamespacedCalls() []struct {
	Namespace string
	Name      string
	Options   *metav1.DeleteOptions
} {
	var calls []struct {
		Namespace string
		Name      string
		Options   *metav1.DeleteOptions
	}
	lockDockerCredentialInterfaceMockDeleteNamespaced.RLock()
	calls = mock.calls.DeleteNamespaced
	lockDockerCredentialInterfaceMockDeleteNamespaced.RUnlock()
	return calls
}

// Get calls GetFunc.
func (mock *DockerCredentialInterfaceMock) Get(name string, opts metav1.GetOptions) (*v3.DockerCredential, error) {
	if mock.GetFunc == nil {
		panic("DockerCredentialInterfaceMock.GetFunc: method is nil but DockerCredentialInterface.Get was just called")
	}
	callInfo := struct {
		Name string
		Opts metav1.GetOptions
	}{
		Name: name,
		Opts: opts,
	}
	lockDockerCredentialInterfaceMockGet.Lock()
	mock.calls.Get = append(mock.calls.Get, callInfo)
	lockDockerCredentialInterfaceMockGet.Unlock()
	return mock.GetFunc(name, opts)
}

// GetCalls gets all the calls that were made to Get.
// Check the length with:
//     len(mockedDockerCredentialInterface.GetCalls())
func (mock *DockerCredentialInterfaceMock) GetCalls() []struct {
	Name string
	Opts metav1.GetOptions
} {
	var calls []struct {
		Name string
		Opts metav1.GetOptions
	}
	lockDockerCredentialInterfaceMockGet.RLock()
	calls = mock.calls.Get
	lockDockerCredentialInterfaceMockGet.RUnlock()
	return calls
}

// GetNamespaced calls GetNamespacedFunc.
func (mock *DockerCredentialInterfaceMock) GetNamespaced(namespace string, name string, opts metav1.GetOptions) (*v3.DockerCredential, error) {
	if mock.GetNamespacedFunc == nil {
		panic("DockerCredentialInterfaceMock.GetNamespacedFunc: method is nil but DockerCredentialInterface.GetNamespaced was just called")
	}
	callInfo := struct {
		Namespace string
		Name      string
		Opts      metav1.GetOptions
	}{
		Namespace: namespace,
		Name:      name,
		Opts:      opts,
	}
	lockDockerCredentialInterfaceMockGetNamespaced.Lock()
	mock.calls.GetNamespaced = append(mock.calls.GetNamespaced, callInfo)
	lockDockerCredentialInterfaceMockGetNamespaced.Unlock()
	return mock.GetNamespacedFunc(namespace, name, opts)
}

// GetNamespacedCalls gets all the calls that were made to GetNamespaced.
// Check the length with:
//     len(mockedDockerCredentialInterface.GetNamespacedCalls())
func (mock *DockerCredentialInterfaceMock) GetNamespacedCalls() []struct {
	Namespace string
	Name      string
	Opts      metav1.GetOptions
} {
	var calls []struct {
		Namespace string
		Name      string
		Opts      metav1.GetOptions
	}
	lockDockerCredentialInterfaceMockGetNamespaced.RLock()
	calls = mock.calls.GetNamespaced
	lockDockerCredentialInterfaceMockGetNamespaced.RUnlock()
	return calls
}

// List calls ListFunc.
func (mock *DockerCredentialInterfaceMock) List(opts metav1.ListOptions) (*v3.DockerCredentialList, error) {
	if mock.ListFunc == nil {
		panic("DockerCredentialInterfaceMock.ListFunc: method is nil but DockerCredentialInterface.List was just called")
	}
	callInfo := struct {
		Opts metav1.ListOptions
	}{
		Opts: opts,
	}
	lockDockerCredentialInterfaceMockList.Lock()
	mock.calls.List = append(mock.calls.List, callInfo)
	lockDockerCredentialInterfaceMockList.Unlock()
	return mock.ListFunc(opts)
}

// ListCalls gets all the calls that were made to List.
// Check the length with:
//     len(mockedDockerCredentialInterface.ListCalls())
func (mock *DockerCredentialInterfaceMock) ListCalls() []struct {
	Opts metav1.ListOptions
} {
	var calls []struct {
		Opts metav1.ListOptions
	}
	lockDockerCredentialInterfaceMockList.RLock()
	calls = mock.calls.List
	lockDockerCredentialInterfaceMockList.RUnlock()
	return calls
}

// ListNamespaced calls ListNamespacedFunc.
func (mock *DockerCredentialInterfaceMock) ListNamespaced(namespace string, opts metav1.ListOptions) (*v3.DockerCredentialList, error) {
	if mock.ListNamespacedFunc == nil {
		panic("DockerCredentialInterfaceMock.ListNamespacedFunc: method is nil but DockerCredentialInterface.ListNamespaced was just called")
	}
	callInfo := struct {
		Namespace string
		Opts      metav1.ListOptions
	}{
		Namespace: namespace,
		Opts:      opts,
	}
	lockDockerCredentialInterfaceMockListNamespaced.Lock()
	mock.calls.ListNamespaced = append(mock.calls.ListNamespaced, callInfo)
	lockDockerCredentialInterfaceMockListNamespaced.Unlock()
	return mock.ListNamespacedFunc(namespace, opts)
}

// ListNamespacedCalls gets all the calls that were made to ListNamespaced.
// Check the length with:
//     len(mockedDockerCredentialInterface.ListNamespacedCalls())
func (mock *DockerCredentialInterfaceMock) ListNamespacedCalls() []struct {
	Namespace string
	Opts      metav1.ListOptions
} {
	var calls []struct {
		Namespace string
		Opts      metav1.ListOptions
	}
	lockDockerCredentialInterfaceMockListNamespaced.RLock()
	calls = mock.calls.ListNamespaced
	lockDockerCredentialInterfaceMockListNamespaced.RUnlock()
	return calls
}

// ObjectClient calls ObjectClientFunc.
func (mock *DockerCredentialInterfaceMock) ObjectClient() *objectclient.ObjectClient {
	if mock.ObjectClientFunc == nil {
		panic("DockerCredentialInterfaceMock.ObjectClientFunc: method is nil but DockerCredentialInterface.ObjectClient was just called")
	}
	callInfo := struct {
	}{}
	lockDockerCredentialInterfaceMockObjectClient.Lock()
	mock.calls.ObjectClient = append(mock.calls.ObjectClient, callInfo)
	lockDockerCredentialInterfaceMockObjectClient.Unlock()
	return mock.ObjectClientFunc()
}

// ObjectClientCalls gets all the calls that were made to ObjectClient.
// Check the length with:
//     len(mockedDockerCredentialInterface.ObjectClientCalls())
func (mock *DockerCredentialInterfaceMock) ObjectClientCalls() []struct {
} {
	var calls []struct {
	}
	lockDockerCredentialInterfaceMockObjectClient.RLock()
	calls = mock.calls.ObjectClient
	lockDockerCredentialInterfaceMockObjectClient.RUnlock()
	return calls
}

// Update calls UpdateFunc.
func (mock *DockerCredentialInterfaceMock) Update(in1 *v3.DockerCredential) (*v3.DockerCredential, error) {
	if mock.UpdateFunc == nil {
		panic("DockerCredentialInterfaceMock.UpdateFunc: method is nil but DockerCredentialInterface.Update was just called")
	}
	callInfo := struct {
		In1 *v3.DockerCredential
	}{
		In1: in1,
	}
	lockDockerCredentialInterfaceMockUpdate.Lock()
	mock.calls.Update = append(mock.calls.Update, callInfo)
	lockDockerCredentialInterfaceMockUpdate.Unlock()
	return mock.UpdateFunc(in1)
}

// UpdateCalls gets all the calls that were made to Update.
// Check the length with:
//     len(mockedDockerCredentialInterface.UpdateCalls())
func (mock *DockerCredentialInterfaceMock) UpdateCalls() []struct {
	In1 *v3.DockerCredential
} {
	var calls []struct {
		In1 *v3.DockerCredential
	}
	lockDockerCredentialInterfaceMockUpdate.RLock()
	calls = mock.calls.Update
	lockDockerCredentialInterfaceMockUpdate.RUnlock()
	return calls
}

// Watch calls WatchFunc.
func (mock *DockerCredentialInterfaceMock) Watch(opts metav1.ListOptions) (watch.Interface, error) {
	if mock.WatchFunc == nil {
		panic("DockerCredentialInterfaceMock.WatchFunc: method is nil but DockerCredentialInterface.Watch was just called")
	}
	callInfo := struct {
		Opts metav1.ListOptions
	}{
		Opts: opts,
	}
	lockDockerCredentialInterfaceMockWatch.Lock()
	mock.calls.Watch = append(mock.calls.Watch, callInfo)
	lockDockerCredentialInterfaceMockWatch.Unlock()
	return mock.WatchFunc(opts)
}

// WatchCalls gets all the calls that were made to Watch.
// Check the length with:
//     len(mockedDockerCredentialInterface.WatchCalls())
func (mock *DockerCredentialInterfaceMock) WatchCalls() []struct {
	Opts metav1.ListOptions
} {
	var calls []struct {
		Opts metav1.ListOptions
	}
	lockDockerCredentialInterfaceMockWatch.RLock()
	calls = mock.calls.Watch
	lockDockerCredentialInterfaceMockWatch.RUnlock()
	return calls
}

var (
	lockDockerCredentialsGetterMockDockerCredentials sync.RWMutex
)

// Ensure, that DockerCredentialsGetterMock does implement v31.DockerCredentialsGetter.
// If this is not the case, regenerate this file with moq.
var _ v31.DockerCredentialsGetter = &DockerCredentialsGetterMock{}

// DockerCredentialsGetterMock is a mock implementation of v31.DockerCredentialsGetter.
//
//     func TestSomethingThatUsesDockerCredentialsGetter(t *testing.T) {
//
//         // make and configure a mocked v31.DockerCredentialsGetter
//         mockedDockerCredentialsGetter := &DockerCredentialsGetterMock{
//             DockerCredentialsFunc: func(namespace string) v31.DockerCredentialInterface {
// 	               panic("mock out the DockerCredentials method")
//             },
//         }
//
//         // use mockedDockerCredentialsGetter in code that requires v31.DockerCredentialsGetter
//         // and then make assertions.
//
//     }
type DockerCredentialsGetterMock struct {
	// DockerCredentialsFunc mocks the DockerCredentials method.
	DockerCredentialsFunc func(namespace string) v31.DockerCredentialInterface

	// calls tracks calls to the methods.
	calls struct {
		// DockerCredentials holds details about calls to the DockerCredentials method.
		DockerCredentials []struct {
			// Namespace is the namespace argument value.
			Namespace string
		}
	}
}

// DockerCredentials calls DockerCredentialsFunc.
func (mock *DockerCredentialsGetterMock) DockerCredentials(namespace string) v31.DockerCredentialInterface {
	if mock.DockerCredentialsFunc == nil {
		panic("DockerCredentialsGetterMock.DockerCredentialsFunc: method is nil but DockerCredentialsGetter.DockerCredentials was just called")
	}
	callInfo := struct {
		Namespace string
	}{
		Namespace: namespace,
	}
	lockDockerCredentialsGetterMockDockerCredentials.Lock()
	mock.calls.DockerCredentials = append(mock.calls.DockerCredentials, callInfo)
	lockDockerCredentialsGetterMockDockerCredentials.Unlock()
	return mock.DockerCredentialsFunc(namespace)
}

// DockerCredentialsCalls gets all the calls that were made to DockerCredentials.
// Check the length with:
//     len(mockedDockerCredentialsGetter.DockerCredentialsCalls())
func (mock *DockerCredentialsGetterMock) DockerCredentialsCalls() []struct {
	Namespace string
} {
	var calls []struct {
		Namespace string
	}
	lockDockerCredentialsGetterMockDockerCredentials.RLock()
	calls = mock.calls.DockerCredentials
	lockDockerCredentialsGetterMockDockerCredentials.RUnlock()
	return calls
}
