// Code generated by moq; DO NOT EDIT.
// github.com/matryer/moq

package fakes

import (
	"context"
	"sync"
	"time"

	"github.com/rancher/norman/controller"
	"github.com/rancher/norman/objectclient"
	v3 "github.com/rancher/rancher/pkg/apis/project.cattle.io/v3"
	v31 "github.com/rancher/rancher/pkg/generated/norman/project.cattle.io/v3"
	metav1 "k8s.io/apimachinery/pkg/apis/meta/v1"
	"k8s.io/apimachinery/pkg/labels"
	"k8s.io/apimachinery/pkg/watch"
	"k8s.io/client-go/tools/cache"
)

var (
	lockNamespacedBasicAuthListerMockGet  sync.RWMutex
	lockNamespacedBasicAuthListerMockList sync.RWMutex
)

// Ensure, that NamespacedBasicAuthListerMock does implement v31.NamespacedBasicAuthLister.
// If this is not the case, regenerate this file with moq.
var _ v31.NamespacedBasicAuthLister = &NamespacedBasicAuthListerMock{}

// NamespacedBasicAuthListerMock is a mock implementation of v31.NamespacedBasicAuthLister.
//
//     func TestSomethingThatUsesNamespacedBasicAuthLister(t *testing.T) {
//
//         // make and configure a mocked v31.NamespacedBasicAuthLister
//         mockedNamespacedBasicAuthLister := &NamespacedBasicAuthListerMock{
//             GetFunc: func(namespace string, name string) (*v3.NamespacedBasicAuth, error) {
// 	               panic("mock out the Get method")
//             },
//             ListFunc: func(namespace string, selector labels.Selector) ([]*v3.NamespacedBasicAuth, error) {
// 	               panic("mock out the List method")
//             },
//         }
//
//         // use mockedNamespacedBasicAuthLister in code that requires v31.NamespacedBasicAuthLister
//         // and then make assertions.
//
//     }
type NamespacedBasicAuthListerMock struct {
	// GetFunc mocks the Get method.
	GetFunc func(namespace string, name string) (*v3.NamespacedBasicAuth, error)

	// ListFunc mocks the List method.
	ListFunc func(namespace string, selector labels.Selector) ([]*v3.NamespacedBasicAuth, error)

	// calls tracks calls to the methods.
	calls struct {
		// Get holds details about calls to the Get method.
		Get []struct {
			// Namespace is the namespace argument value.
			Namespace string
			// Name is the name argument value.
			Name string
		}
		// List holds details about calls to the List method.
		List []struct {
			// Namespace is the namespace argument value.
			Namespace string
			// Selector is the selector argument value.
			Selector labels.Selector
		}
	}
}

// Get calls GetFunc.
func (mock *NamespacedBasicAuthListerMock) Get(namespace string, name string) (*v3.NamespacedBasicAuth, error) {
	if mock.GetFunc == nil {
		panic("NamespacedBasicAuthListerMock.GetFunc: method is nil but NamespacedBasicAuthLister.Get was just called")
	}
	callInfo := struct {
		Namespace string
		Name      string
	}{
		Namespace: namespace,
		Name:      name,
	}
	lockNamespacedBasicAuthListerMockGet.Lock()
	mock.calls.Get = append(mock.calls.Get, callInfo)
	lockNamespacedBasicAuthListerMockGet.Unlock()
	return mock.GetFunc(namespace, name)
}

// GetCalls gets all the calls that were made to Get.
// Check the length with:
//     len(mockedNamespacedBasicAuthLister.GetCalls())
func (mock *NamespacedBasicAuthListerMock) GetCalls() []struct {
	Namespace string
	Name      string
} {
	var calls []struct {
		Namespace string
		Name      string
	}
	lockNamespacedBasicAuthListerMockGet.RLock()
	calls = mock.calls.Get
	lockNamespacedBasicAuthListerMockGet.RUnlock()
	return calls
}

// List calls ListFunc.
func (mock *NamespacedBasicAuthListerMock) List(namespace string, selector labels.Selector) ([]*v3.NamespacedBasicAuth, error) {
	if mock.ListFunc == nil {
		panic("NamespacedBasicAuthListerMock.ListFunc: method is nil but NamespacedBasicAuthLister.List was just called")
	}
	callInfo := struct {
		Namespace string
		Selector  labels.Selector
	}{
		Namespace: namespace,
		Selector:  selector,
	}
	lockNamespacedBasicAuthListerMockList.Lock()
	mock.calls.List = append(mock.calls.List, callInfo)
	lockNamespacedBasicAuthListerMockList.Unlock()
	return mock.ListFunc(namespace, selector)
}

// ListCalls gets all the calls that were made to List.
// Check the length with:
//     len(mockedNamespacedBasicAuthLister.ListCalls())
func (mock *NamespacedBasicAuthListerMock) ListCalls() []struct {
	Namespace string
	Selector  labels.Selector
} {
	var calls []struct {
		Namespace string
		Selector  labels.Selector
	}
	lockNamespacedBasicAuthListerMockList.RLock()
	calls = mock.calls.List
	lockNamespacedBasicAuthListerMockList.RUnlock()
	return calls
}

var (
	lockNamespacedBasicAuthControllerMockAddClusterScopedFeatureHandler sync.RWMutex
	lockNamespacedBasicAuthControllerMockAddClusterScopedHandler        sync.RWMutex
	lockNamespacedBasicAuthControllerMockAddFeatureHandler              sync.RWMutex
	lockNamespacedBasicAuthControllerMockAddHandler                     sync.RWMutex
	lockNamespacedBasicAuthControllerMockEnqueue                        sync.RWMutex
	lockNamespacedBasicAuthControllerMockEnqueueAfter                   sync.RWMutex
	lockNamespacedBasicAuthControllerMockGeneric                        sync.RWMutex
	lockNamespacedBasicAuthControllerMockInformer                       sync.RWMutex
	lockNamespacedBasicAuthControllerMockLister                         sync.RWMutex
)

// Ensure, that NamespacedBasicAuthControllerMock does implement v31.NamespacedBasicAuthController.
// If this is not the case, regenerate this file with moq.
var _ v31.NamespacedBasicAuthController = &NamespacedBasicAuthControllerMock{}

// NamespacedBasicAuthControllerMock is a mock implementation of v31.NamespacedBasicAuthController.
//
//     func TestSomethingThatUsesNamespacedBasicAuthController(t *testing.T) {
//
//         // make and configure a mocked v31.NamespacedBasicAuthController
//         mockedNamespacedBasicAuthController := &NamespacedBasicAuthControllerMock{
//             AddClusterScopedFeatureHandlerFunc: func(ctx context.Context, enabled func() bool, name string, clusterName string, handler v31.NamespacedBasicAuthHandlerFunc)  {
// 	               panic("mock out the AddClusterScopedFeatureHandler method")
//             },
//             AddClusterScopedHandlerFunc: func(ctx context.Context, name string, clusterName string, handler v31.NamespacedBasicAuthHandlerFunc)  {
// 	               panic("mock out the AddClusterScopedHandler method")
//             },
//             AddFeatureHandlerFunc: func(ctx context.Context, enabled func() bool, name string, syncMoqParam v31.NamespacedBasicAuthHandlerFunc)  {
// 	               panic("mock out the AddFeatureHandler method")
//             },
//             AddHandlerFunc: func(ctx context.Context, name string, handler v31.NamespacedBasicAuthHandlerFunc)  {
// 	               panic("mock out the AddHandler method")
//             },
//             EnqueueFunc: func(namespace string, name string)  {
// 	               panic("mock out the Enqueue method")
//             },
//             EnqueueAfterFunc: func(namespace string, name string, after time.Duration)  {
// 	               panic("mock out the EnqueueAfter method")
//             },
//             GenericFunc: func() controller.GenericController {
// 	               panic("mock out the Generic method")
//             },
//             InformerFunc: func() cache.SharedIndexInformer {
// 	               panic("mock out the Informer method")
//             },
//             ListerFunc: func() v31.NamespacedBasicAuthLister {
// 	               panic("mock out the Lister method")
//             },
//         }
//
//         // use mockedNamespacedBasicAuthController in code that requires v31.NamespacedBasicAuthController
//         // and then make assertions.
//
//     }
type NamespacedBasicAuthControllerMock struct {
	// AddClusterScopedFeatureHandlerFunc mocks the AddClusterScopedFeatureHandler method.
	AddClusterScopedFeatureHandlerFunc func(ctx context.Context, enabled func() bool, name string, clusterName string, handler v31.NamespacedBasicAuthHandlerFunc)

	// AddClusterScopedHandlerFunc mocks the AddClusterScopedHandler method.
	AddClusterScopedHandlerFunc func(ctx context.Context, name string, clusterName string, handler v31.NamespacedBasicAuthHandlerFunc)

	// AddFeatureHandlerFunc mocks the AddFeatureHandler method.
	AddFeatureHandlerFunc func(ctx context.Context, enabled func() bool, name string, syncMoqParam v31.NamespacedBasicAuthHandlerFunc)

	// AddHandlerFunc mocks the AddHandler method.
	AddHandlerFunc func(ctx context.Context, name string, handler v31.NamespacedBasicAuthHandlerFunc)

	// EnqueueFunc mocks the Enqueue method.
	EnqueueFunc func(namespace string, name string)

	// EnqueueAfterFunc mocks the EnqueueAfter method.
	EnqueueAfterFunc func(namespace string, name string, after time.Duration)

	// GenericFunc mocks the Generic method.
	GenericFunc func() controller.GenericController

	// InformerFunc mocks the Informer method.
	InformerFunc func() cache.SharedIndexInformer

	// ListerFunc mocks the Lister method.
	ListerFunc func() v31.NamespacedBasicAuthLister

	// calls tracks calls to the methods.
	calls struct {
		// AddClusterScopedFeatureHandler holds details about calls to the AddClusterScopedFeatureHandler method.
		AddClusterScopedFeatureHandler []struct {
			// Ctx is the ctx argument value.
			Ctx context.Context
			// Enabled is the enabled argument value.
			Enabled func() bool
			// Name is the name argument value.
			Name string
			// ClusterName is the clusterName argument value.
			ClusterName string
			// Handler is the handler argument value.
			Handler v31.NamespacedBasicAuthHandlerFunc
		}
		// AddClusterScopedHandler holds details about calls to the AddClusterScopedHandler method.
		AddClusterScopedHandler []struct {
			// Ctx is the ctx argument value.
			Ctx context.Context
			// Name is the name argument value.
			Name string
			// ClusterName is the clusterName argument value.
			ClusterName string
			// Handler is the handler argument value.
			Handler v31.NamespacedBasicAuthHandlerFunc
		}
		// AddFeatureHandler holds details about calls to the AddFeatureHandler method.
		AddFeatureHandler []struct {
			// Ctx is the ctx argument value.
			Ctx context.Context
			// Enabled is the enabled argument value.
			Enabled func() bool
			// Name is the name argument value.
			Name string
			// Sync is the sync argument value.
			Sync v31.NamespacedBasicAuthHandlerFunc
		}
		// AddHandler holds details about calls to the AddHandler method.
		AddHandler []struct {
			// Ctx is the ctx argument value.
			Ctx context.Context
			// Name is the name argument value.
			Name string
			// Handler is the handler argument value.
			Handler v31.NamespacedBasicAuthHandlerFunc
		}
		// Enqueue holds details about calls to the Enqueue method.
		Enqueue []struct {
			// Namespace is the namespace argument value.
			Namespace string
			// Name is the name argument value.
			Name string
		}
		// EnqueueAfter holds details about calls to the EnqueueAfter method.
		EnqueueAfter []struct {
			// Namespace is the namespace argument value.
			Namespace string
			// Name is the name argument value.
			Name string
			// After is the after argument value.
			After time.Duration
		}
		// Generic holds details about calls to the Generic method.
		Generic []struct {
		}
		// Informer holds details about calls to the Informer method.
		Informer []struct {
		}
		// Lister holds details about calls to the Lister method.
		Lister []struct {
		}
	}
}

// AddClusterScopedFeatureHandler calls AddClusterScopedFeatureHandlerFunc.
func (mock *NamespacedBasicAuthControllerMock) AddClusterScopedFeatureHandler(ctx context.Context, enabled func() bool, name string, clusterName string, handler v31.NamespacedBasicAuthHandlerFunc) {
	if mock.AddClusterScopedFeatureHandlerFunc == nil {
		panic("NamespacedBasicAuthControllerMock.AddClusterScopedFeatureHandlerFunc: method is nil but NamespacedBasicAuthController.AddClusterScopedFeatureHandler was just called")
	}
	callInfo := struct {
		Ctx         context.Context
		Enabled     func() bool
		Name        string
		ClusterName string
		Handler     v31.NamespacedBasicAuthHandlerFunc
	}{
		Ctx:         ctx,
		Enabled:     enabled,
		Name:        name,
		ClusterName: clusterName,
		Handler:     handler,
	}
	lockNamespacedBasicAuthControllerMockAddClusterScopedFeatureHandler.Lock()
	mock.calls.AddClusterScopedFeatureHandler = append(mock.calls.AddClusterScopedFeatureHandler, callInfo)
	lockNamespacedBasicAuthControllerMockAddClusterScopedFeatureHandler.Unlock()
	mock.AddClusterScopedFeatureHandlerFunc(ctx, enabled, name, clusterName, handler)
}

// AddClusterScopedFeatureHandlerCalls gets all the calls that were made to AddClusterScopedFeatureHandler.
// Check the length with:
//     len(mockedNamespacedBasicAuthController.AddClusterScopedFeatureHandlerCalls())
func (mock *NamespacedBasicAuthControllerMock) AddClusterScopedFeatureHandlerCalls() []struct {
	Ctx         context.Context
	Enabled     func() bool
	Name        string
	ClusterName string
	Handler     v31.NamespacedBasicAuthHandlerFunc
} {
	var calls []struct {
		Ctx         context.Context
		Enabled     func() bool
		Name        string
		ClusterName string
		Handler     v31.NamespacedBasicAuthHandlerFunc
	}
	lockNamespacedBasicAuthControllerMockAddClusterScopedFeatureHandler.RLock()
	calls = mock.calls.AddClusterScopedFeatureHandler
	lockNamespacedBasicAuthControllerMockAddClusterScopedFeatureHandler.RUnlock()
	return calls
}

// AddClusterScopedHandler calls AddClusterScopedHandlerFunc.
func (mock *NamespacedBasicAuthControllerMock) AddClusterScopedHandler(ctx context.Context, name string, clusterName string, handler v31.NamespacedBasicAuthHandlerFunc) {
	if mock.AddClusterScopedHandlerFunc == nil {
		panic("NamespacedBasicAuthControllerMock.AddClusterScopedHandlerFunc: method is nil but NamespacedBasicAuthController.AddClusterScopedHandler was just called")
	}
	callInfo := struct {
		Ctx         context.Context
		Name        string
		ClusterName string
		Handler     v31.NamespacedBasicAuthHandlerFunc
	}{
		Ctx:         ctx,
		Name:        name,
		ClusterName: clusterName,
		Handler:     handler,
	}
	lockNamespacedBasicAuthControllerMockAddClusterScopedHandler.Lock()
	mock.calls.AddClusterScopedHandler = append(mock.calls.AddClusterScopedHandler, callInfo)
	lockNamespacedBasicAuthControllerMockAddClusterScopedHandler.Unlock()
	mock.AddClusterScopedHandlerFunc(ctx, name, clusterName, handler)
}

// AddClusterScopedHandlerCalls gets all the calls that were made to AddClusterScopedHandler.
// Check the length with:
//     len(mockedNamespacedBasicAuthController.AddClusterScopedHandlerCalls())
func (mock *NamespacedBasicAuthControllerMock) AddClusterScopedHandlerCalls() []struct {
	Ctx         context.Context
	Name        string
	ClusterName string
	Handler     v31.NamespacedBasicAuthHandlerFunc
} {
	var calls []struct {
		Ctx         context.Context
		Name        string
		ClusterName string
		Handler     v31.NamespacedBasicAuthHandlerFunc
	}
	lockNamespacedBasicAuthControllerMockAddClusterScopedHandler.RLock()
	calls = mock.calls.AddClusterScopedHandler
	lockNamespacedBasicAuthControllerMockAddClusterScopedHandler.RUnlock()
	return calls
}

// AddFeatureHandler calls AddFeatureHandlerFunc.
func (mock *NamespacedBasicAuthControllerMock) AddFeatureHandler(ctx context.Context, enabled func() bool, name string, syncMoqParam v31.NamespacedBasicAuthHandlerFunc) {
	if mock.AddFeatureHandlerFunc == nil {
		panic("NamespacedBasicAuthControllerMock.AddFeatureHandlerFunc: method is nil but NamespacedBasicAuthController.AddFeatureHandler was just called")
	}
	callInfo := struct {
		Ctx     context.Context
		Enabled func() bool
		Name    string
		Sync    v31.NamespacedBasicAuthHandlerFunc
	}{
		Ctx:     ctx,
		Enabled: enabled,
		Name:    name,
		Sync:    syncMoqParam,
	}
	lockNamespacedBasicAuthControllerMockAddFeatureHandler.Lock()
	mock.calls.AddFeatureHandler = append(mock.calls.AddFeatureHandler, callInfo)
	lockNamespacedBasicAuthControllerMockAddFeatureHandler.Unlock()
	mock.AddFeatureHandlerFunc(ctx, enabled, name, syncMoqParam)
}

// AddFeatureHandlerCalls gets all the calls that were made to AddFeatureHandler.
// Check the length with:
//     len(mockedNamespacedBasicAuthController.AddFeatureHandlerCalls())
func (mock *NamespacedBasicAuthControllerMock) AddFeatureHandlerCalls() []struct {
	Ctx     context.Context
	Enabled func() bool
	Name    string
	Sync    v31.NamespacedBasicAuthHandlerFunc
} {
	var calls []struct {
		Ctx     context.Context
		Enabled func() bool
		Name    string
		Sync    v31.NamespacedBasicAuthHandlerFunc
	}
	lockNamespacedBasicAuthControllerMockAddFeatureHandler.RLock()
	calls = mock.calls.AddFeatureHandler
	lockNamespacedBasicAuthControllerMockAddFeatureHandler.RUnlock()
	return calls
}

// AddHandler calls AddHandlerFunc.
func (mock *NamespacedBasicAuthControllerMock) AddHandler(ctx context.Context, name string, handler v31.NamespacedBasicAuthHandlerFunc) {
	if mock.AddHandlerFunc == nil {
		panic("NamespacedBasicAuthControllerMock.AddHandlerFunc: method is nil but NamespacedBasicAuthController.AddHandler was just called")
	}
	callInfo := struct {
		Ctx     context.Context
		Name    string
		Handler v31.NamespacedBasicAuthHandlerFunc
	}{
		Ctx:     ctx,
		Name:    name,
		Handler: handler,
	}
	lockNamespacedBasicAuthControllerMockAddHandler.Lock()
	mock.calls.AddHandler = append(mock.calls.AddHandler, callInfo)
	lockNamespacedBasicAuthControllerMockAddHandler.Unlock()
	mock.AddHandlerFunc(ctx, name, handler)
}

// AddHandlerCalls gets all the calls that were made to AddHandler.
// Check the length with:
//     len(mockedNamespacedBasicAuthController.AddHandlerCalls())
func (mock *NamespacedBasicAuthControllerMock) AddHandlerCalls() []struct {
	Ctx     context.Context
	Name    string
	Handler v31.NamespacedBasicAuthHandlerFunc
} {
	var calls []struct {
		Ctx     context.Context
		Name    string
		Handler v31.NamespacedBasicAuthHandlerFunc
	}
	lockNamespacedBasicAuthControllerMockAddHandler.RLock()
	calls = mock.calls.AddHandler
	lockNamespacedBasicAuthControllerMockAddHandler.RUnlock()
	return calls
}

// Enqueue calls EnqueueFunc.
func (mock *NamespacedBasicAuthControllerMock) Enqueue(namespace string, name string) {
	if mock.EnqueueFunc == nil {
		panic("NamespacedBasicAuthControllerMock.EnqueueFunc: method is nil but NamespacedBasicAuthController.Enqueue was just called")
	}
	callInfo := struct {
		Namespace string
		Name      string
	}{
		Namespace: namespace,
		Name:      name,
	}
	lockNamespacedBasicAuthControllerMockEnqueue.Lock()
	mock.calls.Enqueue = append(mock.calls.Enqueue, callInfo)
	lockNamespacedBasicAuthControllerMockEnqueue.Unlock()
	mock.EnqueueFunc(namespace, name)
}

// EnqueueCalls gets all the calls that were made to Enqueue.
// Check the length with:
//     len(mockedNamespacedBasicAuthController.EnqueueCalls())
func (mock *NamespacedBasicAuthControllerMock) EnqueueCalls() []struct {
	Namespace string
	Name      string
} {
	var calls []struct {
		Namespace string
		Name      string
	}
	lockNamespacedBasicAuthControllerMockEnqueue.RLock()
	calls = mock.calls.Enqueue
	lockNamespacedBasicAuthControllerMockEnqueue.RUnlock()
	return calls
}

// EnqueueAfter calls EnqueueAfterFunc.
func (mock *NamespacedBasicAuthControllerMock) EnqueueAfter(namespace string, name string, after time.Duration) {
	if mock.EnqueueAfterFunc == nil {
		panic("NamespacedBasicAuthControllerMock.EnqueueAfterFunc: method is nil but NamespacedBasicAuthController.EnqueueAfter was just called")
	}
	callInfo := struct {
		Namespace string
		Name      string
		After     time.Duration
	}{
		Namespace: namespace,
		Name:      name,
		After:     after,
	}
	lockNamespacedBasicAuthControllerMockEnqueueAfter.Lock()
	mock.calls.EnqueueAfter = append(mock.calls.EnqueueAfter, callInfo)
	lockNamespacedBasicAuthControllerMockEnqueueAfter.Unlock()
	mock.EnqueueAfterFunc(namespace, name, after)
}

// EnqueueAfterCalls gets all the calls that were made to EnqueueAfter.
// Check the length with:
//     len(mockedNamespacedBasicAuthController.EnqueueAfterCalls())
func (mock *NamespacedBasicAuthControllerMock) EnqueueAfterCalls() []struct {
	Namespace string
	Name      string
	After     time.Duration
} {
	var calls []struct {
		Namespace string
		Name      string
		After     time.Duration
	}
	lockNamespacedBasicAuthControllerMockEnqueueAfter.RLock()
	calls = mock.calls.EnqueueAfter
	lockNamespacedBasicAuthControllerMockEnqueueAfter.RUnlock()
	return calls
}

// Generic calls GenericFunc.
func (mock *NamespacedBasicAuthControllerMock) Generic() controller.GenericController {
	if mock.GenericFunc == nil {
		panic("NamespacedBasicAuthControllerMock.GenericFunc: method is nil but NamespacedBasicAuthController.Generic was just called")
	}
	callInfo := struct {
	}{}
	lockNamespacedBasicAuthControllerMockGeneric.Lock()
	mock.calls.Generic = append(mock.calls.Generic, callInfo)
	lockNamespacedBasicAuthControllerMockGeneric.Unlock()
	return mock.GenericFunc()
}

// GenericCalls gets all the calls that were made to Generic.
// Check the length with:
//     len(mockedNamespacedBasicAuthController.GenericCalls())
func (mock *NamespacedBasicAuthControllerMock) GenericCalls() []struct {
} {
	var calls []struct {
	}
	lockNamespacedBasicAuthControllerMockGeneric.RLock()
	calls = mock.calls.Generic
	lockNamespacedBasicAuthControllerMockGeneric.RUnlock()
	return calls
}

// Informer calls InformerFunc.
func (mock *NamespacedBasicAuthControllerMock) Informer() cache.SharedIndexInformer {
	if mock.InformerFunc == nil {
		panic("NamespacedBasicAuthControllerMock.InformerFunc: method is nil but NamespacedBasicAuthController.Informer was just called")
	}
	callInfo := struct {
	}{}
	lockNamespacedBasicAuthControllerMockInformer.Lock()
	mock.calls.Informer = append(mock.calls.Informer, callInfo)
	lockNamespacedBasicAuthControllerMockInformer.Unlock()
	return mock.InformerFunc()
}

// InformerCalls gets all the calls that were made to Informer.
// Check the length with:
//     len(mockedNamespacedBasicAuthController.InformerCalls())
func (mock *NamespacedBasicAuthControllerMock) InformerCalls() []struct {
} {
	var calls []struct {
	}
	lockNamespacedBasicAuthControllerMockInformer.RLock()
	calls = mock.calls.Informer
	lockNamespacedBasicAuthControllerMockInformer.RUnlock()
	return calls
}

// Lister calls ListerFunc.
func (mock *NamespacedBasicAuthControllerMock) Lister() v31.NamespacedBasicAuthLister {
	if mock.ListerFunc == nil {
		panic("NamespacedBasicAuthControllerMock.ListerFunc: method is nil but NamespacedBasicAuthController.Lister was just called")
	}
	callInfo := struct {
	}{}
	lockNamespacedBasicAuthControllerMockLister.Lock()
	mock.calls.Lister = append(mock.calls.Lister, callInfo)
	lockNamespacedBasicAuthControllerMockLister.Unlock()
	return mock.ListerFunc()
}

// ListerCalls gets all the calls that were made to Lister.
// Check the length with:
//     len(mockedNamespacedBasicAuthController.ListerCalls())
func (mock *NamespacedBasicAuthControllerMock) ListerCalls() []struct {
} {
	var calls []struct {
	}
	lockNamespacedBasicAuthControllerMockLister.RLock()
	calls = mock.calls.Lister
	lockNamespacedBasicAuthControllerMockLister.RUnlock()
	return calls
}

var (
	lockNamespacedBasicAuthInterfaceMockAddClusterScopedFeatureHandler   sync.RWMutex
	lockNamespacedBasicAuthInterfaceMockAddClusterScopedFeatureLifecycle sync.RWMutex
	lockNamespacedBasicAuthInterfaceMockAddClusterScopedHandler          sync.RWMutex
	lockNamespacedBasicAuthInterfaceMockAddClusterScopedLifecycle        sync.RWMutex
	lockNamespacedBasicAuthInterfaceMockAddFeatureHandler                sync.RWMutex
	lockNamespacedBasicAuthInterfaceMockAddFeatureLifecycle              sync.RWMutex
	lockNamespacedBasicAuthInterfaceMockAddHandler                       sync.RWMutex
	lockNamespacedBasicAuthInterfaceMockAddLifecycle                     sync.RWMutex
	lockNamespacedBasicAuthInterfaceMockController                       sync.RWMutex
	lockNamespacedBasicAuthInterfaceMockCreate                           sync.RWMutex
	lockNamespacedBasicAuthInterfaceMockDelete                           sync.RWMutex
	lockNamespacedBasicAuthInterfaceMockDeleteCollection                 sync.RWMutex
	lockNamespacedBasicAuthInterfaceMockDeleteNamespaced                 sync.RWMutex
	lockNamespacedBasicAuthInterfaceMockGet                              sync.RWMutex
	lockNamespacedBasicAuthInterfaceMockGetNamespaced                    sync.RWMutex
	lockNamespacedBasicAuthInterfaceMockList                             sync.RWMutex
	lockNamespacedBasicAuthInterfaceMockListNamespaced                   sync.RWMutex
	lockNamespacedBasicAuthInterfaceMockObjectClient                     sync.RWMutex
	lockNamespacedBasicAuthInterfaceMockUpdate                           sync.RWMutex
	lockNamespacedBasicAuthInterfaceMockWatch                            sync.RWMutex
)

// Ensure, that NamespacedBasicAuthInterfaceMock does implement v31.NamespacedBasicAuthInterface.
// If this is not the case, regenerate this file with moq.
var _ v31.NamespacedBasicAuthInterface = &NamespacedBasicAuthInterfaceMock{}

// NamespacedBasicAuthInterfaceMock is a mock implementation of v31.NamespacedBasicAuthInterface.
//
//     func TestSomethingThatUsesNamespacedBasicAuthInterface(t *testing.T) {
//
//         // make and configure a mocked v31.NamespacedBasicAuthInterface
//         mockedNamespacedBasicAuthInterface := &NamespacedBasicAuthInterfaceMock{
//             AddClusterScopedFeatureHandlerFunc: func(ctx context.Context, enabled func() bool, name string, clusterName string, syncMoqParam v31.NamespacedBasicAuthHandlerFunc)  {
// 	               panic("mock out the AddClusterScopedFeatureHandler method")
//             },
//             AddClusterScopedFeatureLifecycleFunc: func(ctx context.Context, enabled func() bool, name string, clusterName string, lifecycle v31.NamespacedBasicAuthLifecycle)  {
// 	               panic("mock out the AddClusterScopedFeatureLifecycle method")
//             },
//             AddClusterScopedHandlerFunc: func(ctx context.Context, name string, clusterName string, syncMoqParam v31.NamespacedBasicAuthHandlerFunc)  {
// 	               panic("mock out the AddClusterScopedHandler method")
//             },
//             AddClusterScopedLifecycleFunc: func(ctx context.Context, name string, clusterName string, lifecycle v31.NamespacedBasicAuthLifecycle)  {
// 	               panic("mock out the AddClusterScopedLifecycle method")
//             },
//             AddFeatureHandlerFunc: func(ctx context.Context, enabled func() bool, name string, syncMoqParam v31.NamespacedBasicAuthHandlerFunc)  {
// 	               panic("mock out the AddFeatureHandler method")
//             },
//             AddFeatureLifecycleFunc: func(ctx context.Context, enabled func() bool, name string, lifecycle v31.NamespacedBasicAuthLifecycle)  {
// 	               panic("mock out the AddFeatureLifecycle method")
//             },
//             AddHandlerFunc: func(ctx context.Context, name string, syncMoqParam v31.NamespacedBasicAuthHandlerFunc)  {
// 	               panic("mock out the AddHandler method")
//             },
//             AddLifecycleFunc: func(ctx context.Context, name string, lifecycle v31.NamespacedBasicAuthLifecycle)  {
// 	               panic("mock out the AddLifecycle method")
//             },
//             ControllerFunc: func() v31.NamespacedBasicAuthController {
// 	               panic("mock out the Controller method")
//             },
//             CreateFunc: func(in1 *v3.NamespacedBasicAuth) (*v3.NamespacedBasicAuth, error) {
// 	               panic("mock out the Create method")
//             },
//             DeleteFunc: func(name string, options *metav1.DeleteOptions) error {
// 	               panic("mock out the Delete method")
//             },
//             DeleteCollectionFunc: func(deleteOpts *metav1.DeleteOptions, listOpts metav1.ListOptions) error {
// 	               panic("mock out the DeleteCollection method")
//             },
//             DeleteNamespacedFunc: func(namespace string, name string, options *metav1.DeleteOptions) error {
// 	               panic("mock out the DeleteNamespaced method")
//             },
//             GetFunc: func(name string, opts metav1.GetOptions) (*v3.NamespacedBasicAuth, error) {
// 	               panic("mock out the Get method")
//             },
//             GetNamespacedFunc: func(namespace string, name string, opts metav1.GetOptions) (*v3.NamespacedBasicAuth, error) {
// 	               panic("mock out the GetNamespaced method")
//             },
//             ListFunc: func(opts metav1.ListOptions) (*v3.NamespacedBasicAuthList, error) {
// 	               panic("mock out the List method")
//             },
//             ListNamespacedFunc: func(namespace string, opts metav1.ListOptions) (*v3.NamespacedBasicAuthList, error) {
// 	               panic("mock out the ListNamespaced method")
//             },
//             ObjectClientFunc: func() *objectclient.ObjectClient {
// 	               panic("mock out the ObjectClient method")
//             },
//             UpdateFunc: func(in1 *v3.NamespacedBasicAuth) (*v3.NamespacedBasicAuth, error) {
// 	               panic("mock out the Update method")
//             },
//             WatchFunc: func(opts metav1.ListOptions) (watch.Interface, error) {
// 	               panic("mock out the Watch method")
//             },
//         }
//
//         // use mockedNamespacedBasicAuthInterface in code that requires v31.NamespacedBasicAuthInterface
//         // and then make assertions.
//
//     }
type NamespacedBasicAuthInterfaceMock struct {
	// AddClusterScopedFeatureHandlerFunc mocks the AddClusterScopedFeatureHandler method.
	AddClusterScopedFeatureHandlerFunc func(ctx context.Context, enabled func() bool, name string, clusterName string, syncMoqParam v31.NamespacedBasicAuthHandlerFunc)

	// AddClusterScopedFeatureLifecycleFunc mocks the AddClusterScopedFeatureLifecycle method.
	AddClusterScopedFeatureLifecycleFunc func(ctx context.Context, enabled func() bool, name string, clusterName string, lifecycle v31.NamespacedBasicAuthLifecycle)

	// AddClusterScopedHandlerFunc mocks the AddClusterScopedHandler method.
	AddClusterScopedHandlerFunc func(ctx context.Context, name string, clusterName string, syncMoqParam v31.NamespacedBasicAuthHandlerFunc)

	// AddClusterScopedLifecycleFunc mocks the AddClusterScopedLifecycle method.
	AddClusterScopedLifecycleFunc func(ctx context.Context, name string, clusterName string, lifecycle v31.NamespacedBasicAuthLifecycle)

	// AddFeatureHandlerFunc mocks the AddFeatureHandler method.
	AddFeatureHandlerFunc func(ctx context.Context, enabled func() bool, name string, syncMoqParam v31.NamespacedBasicAuthHandlerFunc)

	// AddFeatureLifecycleFunc mocks the AddFeatureLifecycle method.
	AddFeatureLifecycleFunc func(ctx context.Context, enabled func() bool, name string, lifecycle v31.NamespacedBasicAuthLifecycle)

	// AddHandlerFunc mocks the AddHandler method.
	AddHandlerFunc func(ctx context.Context, name string, syncMoqParam v31.NamespacedBasicAuthHandlerFunc)

	// AddLifecycleFunc mocks the AddLifecycle method.
	AddLifecycleFunc func(ctx context.Context, name string, lifecycle v31.NamespacedBasicAuthLifecycle)

	// ControllerFunc mocks the Controller method.
	ControllerFunc func() v31.NamespacedBasicAuthController

	// CreateFunc mocks the Create method.
	CreateFunc func(in1 *v3.NamespacedBasicAuth) (*v3.NamespacedBasicAuth, error)

	// DeleteFunc mocks the Delete method.
	DeleteFunc func(name string, options *metav1.DeleteOptions) error

	// DeleteCollectionFunc mocks the DeleteCollection method.
	DeleteCollectionFunc func(deleteOpts *metav1.DeleteOptions, listOpts metav1.ListOptions) error

	// DeleteNamespacedFunc mocks the DeleteNamespaced method.
	DeleteNamespacedFunc func(namespace string, name string, options *metav1.DeleteOptions) error

	// GetFunc mocks the Get method.
	GetFunc func(name string, opts metav1.GetOptions) (*v3.NamespacedBasicAuth, error)

	// GetNamespacedFunc mocks the GetNamespaced method.
	GetNamespacedFunc func(namespace string, name string, opts metav1.GetOptions) (*v3.NamespacedBasicAuth, error)

	// ListFunc mocks the List method.
	ListFunc func(opts metav1.ListOptions) (*v3.NamespacedBasicAuthList, error)

	// ListNamespacedFunc mocks the ListNamespaced method.
	ListNamespacedFunc func(namespace string, opts metav1.ListOptions) (*v3.NamespacedBasicAuthList, error)

	// ObjectClientFunc mocks the ObjectClient method.
	ObjectClientFunc func() *objectclient.ObjectClient

	// UpdateFunc mocks the Update method.
	UpdateFunc func(in1 *v3.NamespacedBasicAuth) (*v3.NamespacedBasicAuth, error)

	// WatchFunc mocks the Watch method.
	WatchFunc func(opts metav1.ListOptions) (watch.Interface, error)

	// calls tracks calls to the methods.
	calls struct {
		// AddClusterScopedFeatureHandler holds details about calls to the AddClusterScopedFeatureHandler method.
		AddClusterScopedFeatureHandler []struct {
			// Ctx is the ctx argument value.
			Ctx context.Context
			// Enabled is the enabled argument value.
			Enabled func() bool
			// Name is the name argument value.
			Name string
			// ClusterName is the clusterName argument value.
			ClusterName string
			// Sync is the sync argument value.
			Sync v31.NamespacedBasicAuthHandlerFunc
		}
		// AddClusterScopedFeatureLifecycle holds details about calls to the AddClusterScopedFeatureLifecycle method.
		AddClusterScopedFeatureLifecycle []struct {
			// Ctx is the ctx argument value.
			Ctx context.Context
			// Enabled is the enabled argument value.
			Enabled func() bool
			// Name is the name argument value.
			Name string
			// ClusterName is the clusterName argument value.
			ClusterName string
			// Lifecycle is the lifecycle argument value.
			Lifecycle v31.NamespacedBasicAuthLifecycle
		}
		// AddClusterScopedHandler holds details about calls to the AddClusterScopedHandler method.
		AddClusterScopedHandler []struct {
			// Ctx is the ctx argument value.
			Ctx context.Context
			// Name is the name argument value.
			Name string
			// ClusterName is the clusterName argument value.
			ClusterName string
			// Sync is the sync argument value.
			Sync v31.NamespacedBasicAuthHandlerFunc
		}
		// AddClusterScopedLifecycle holds details about calls to the AddClusterScopedLifecycle method.
		AddClusterScopedLifecycle []struct {
			// Ctx is the ctx argument value.
			Ctx context.Context
			// Name is the name argument value.
			Name string
			// ClusterName is the clusterName argument value.
			ClusterName string
			// Lifecycle is the lifecycle argument value.
			Lifecycle v31.NamespacedBasicAuthLifecycle
		}
		// AddFeatureHandler holds details about calls to the AddFeatureHandler method.
		AddFeatureHandler []struct {
			// Ctx is the ctx argument value.
			Ctx context.Context
			// Enabled is the enabled argument value.
			Enabled func() bool
			// Name is the name argument value.
			Name string
			// Sync is the sync argument value.
			Sync v31.NamespacedBasicAuthHandlerFunc
		}
		// AddFeatureLifecycle holds details about calls to the AddFeatureLifecycle method.
		AddFeatureLifecycle []struct {
			// Ctx is the ctx argument value.
			Ctx context.Context
			// Enabled is the enabled argument value.
			Enabled func() bool
			// Name is the name argument value.
			Name string
			// Lifecycle is the lifecycle argument value.
			Lifecycle v31.NamespacedBasicAuthLifecycle
		}
		// AddHandler holds details about calls to the AddHandler method.
		AddHandler []struct {
			// Ctx is the ctx argument value.
			Ctx context.Context
			// Name is the name argument value.
			Name string
			// Sync is the sync argument value.
			Sync v31.NamespacedBasicAuthHandlerFunc
		}
		// AddLifecycle holds details about calls to the AddLifecycle method.
		AddLifecycle []struct {
			// Ctx is the ctx argument value.
			Ctx context.Context
			// Name is the name argument value.
			Name string
			// Lifecycle is the lifecycle argument value.
			Lifecycle v31.NamespacedBasicAuthLifecycle
		}
		// Controller holds details about calls to the Controller method.
		Controller []struct {
		}
		// Create holds details about calls to the Create method.
		Create []struct {
			// In1 is the in1 argument value.
			In1 *v3.NamespacedBasicAuth
		}
		// Delete holds details about calls to the Delete method.
		Delete []struct {
			// Name is the name argument value.
			Name string
			// Options is the options argument value.
			Options *metav1.DeleteOptions
		}
		// DeleteCollection holds details about calls to the DeleteCollection method.
		DeleteCollection []struct {
			// DeleteOpts is the deleteOpts argument value.
			DeleteOpts *metav1.DeleteOptions
			// ListOpts is the listOpts argument value.
			ListOpts metav1.ListOptions
		}
		// DeleteNamespaced holds details about calls to the DeleteNamespaced method.
		DeleteNamespaced []struct {
			// Namespace is the namespace argument value.
			Namespace string
			// Name is the name argument value.
			Name string
			// Options is the options argument value.
			Options *metav1.DeleteOptions
		}
		// Get holds details about calls to the Get method.
		Get []struct {
			// Name is the name argument value.
			Name string
			// Opts is the opts argument value.
			Opts metav1.GetOptions
		}
		// GetNamespaced holds details about calls to the GetNamespaced method.
		GetNamespaced []struct {
			// Namespace is the namespace argument value.
			Namespace string
			// Name is the name argument value.
			Name string
			// Opts is the opts argument value.
			Opts metav1.GetOptions
		}
		// List holds details about calls to the List method.
		List []struct {
			// Opts is the opts argument value.
			Opts metav1.ListOptions
		}
		// ListNamespaced holds details about calls to the ListNamespaced method.
		ListNamespaced []struct {
			// Namespace is the namespace argument value.
			Namespace string
			// Opts is the opts argument value.
			Opts metav1.ListOptions
		}
		// ObjectClient holds details about calls to the ObjectClient method.
		ObjectClient []struct {
		}
		// Update holds details about calls to the Update method.
		Update []struct {
			// In1 is the in1 argument value.
			In1 *v3.NamespacedBasicAuth
		}
		// Watch holds details about calls to the Watch method.
		Watch []struct {
			// Opts is the opts argument value.
			Opts metav1.ListOptions
		}
	}
}

// AddClusterScopedFeatureHandler calls AddClusterScopedFeatureHandlerFunc.
func (mock *NamespacedBasicAuthInterfaceMock) AddClusterScopedFeatureHandler(ctx context.Context, enabled func() bool, name string, clusterName string, syncMoqParam v31.NamespacedBasicAuthHandlerFunc) {
	if mock.AddClusterScopedFeatureHandlerFunc == nil {
		panic("NamespacedBasicAuthInterfaceMock.AddClusterScopedFeatureHandlerFunc: method is nil but NamespacedBasicAuthInterface.AddClusterScopedFeatureHandler was just called")
	}
	callInfo := struct {
		Ctx         context.Context
		Enabled     func() bool
		Name        string
		ClusterName string
		Sync        v31.NamespacedBasicAuthHandlerFunc
	}{
		Ctx:         ctx,
		Enabled:     enabled,
		Name:        name,
		ClusterName: clusterName,
		Sync:        syncMoqParam,
	}
	lockNamespacedBasicAuthInterfaceMockAddClusterScopedFeatureHandler.Lock()
	mock.calls.AddClusterScopedFeatureHandler = append(mock.calls.AddClusterScopedFeatureHandler, callInfo)
	lockNamespacedBasicAuthInterfaceMockAddClusterScopedFeatureHandler.Unlock()
	mock.AddClusterScopedFeatureHandlerFunc(ctx, enabled, name, clusterName, syncMoqParam)
}

// AddClusterScopedFeatureHandlerCalls gets all the calls that were made to AddClusterScopedFeatureHandler.
// Check the length with:
//     len(mockedNamespacedBasicAuthInterface.AddClusterScopedFeatureHandlerCalls())
func (mock *NamespacedBasicAuthInterfaceMock) AddClusterScopedFeatureHandlerCalls() []struct {
	Ctx         context.Context
	Enabled     func() bool
	Name        string
	ClusterName string
	Sync        v31.NamespacedBasicAuthHandlerFunc
} {
	var calls []struct {
		Ctx         context.Context
		Enabled     func() bool
		Name        string
		ClusterName string
		Sync        v31.NamespacedBasicAuthHandlerFunc
	}
	lockNamespacedBasicAuthInterfaceMockAddClusterScopedFeatureHandler.RLock()
	calls = mock.calls.AddClusterScopedFeatureHandler
	lockNamespacedBasicAuthInterfaceMockAddClusterScopedFeatureHandler.RUnlock()
	return calls
}

// AddClusterScopedFeatureLifecycle calls AddClusterScopedFeatureLifecycleFunc.
func (mock *NamespacedBasicAuthInterfaceMock) AddClusterScopedFeatureLifecycle(ctx context.Context, enabled func() bool, name string, clusterName string, lifecycle v31.NamespacedBasicAuthLifecycle) {
	if mock.AddClusterScopedFeatureLifecycleFunc == nil {
		panic("NamespacedBasicAuthInterfaceMock.AddClusterScopedFeatureLifecycleFunc: method is nil but NamespacedBasicAuthInterface.AddClusterScopedFeatureLifecycle was just called")
	}
	callInfo := struct {
		Ctx         context.Context
		Enabled     func() bool
		Name        string
		ClusterName string
		Lifecycle   v31.NamespacedBasicAuthLifecycle
	}{
		Ctx:         ctx,
		Enabled:     enabled,
		Name:        name,
		ClusterName: clusterName,
		Lifecycle:   lifecycle,
	}
	lockNamespacedBasicAuthInterfaceMockAddClusterScopedFeatureLifecycle.Lock()
	mock.calls.AddClusterScopedFeatureLifecycle = append(mock.calls.AddClusterScopedFeatureLifecycle, callInfo)
	lockNamespacedBasicAuthInterfaceMockAddClusterScopedFeatureLifecycle.Unlock()
	mock.AddClusterScopedFeatureLifecycleFunc(ctx, enabled, name, clusterName, lifecycle)
}

// AddClusterScopedFeatureLifecycleCalls gets all the calls that were made to AddClusterScopedFeatureLifecycle.
// Check the length with:
//     len(mockedNamespacedBasicAuthInterface.AddClusterScopedFeatureLifecycleCalls())
func (mock *NamespacedBasicAuthInterfaceMock) AddClusterScopedFeatureLifecycleCalls() []struct {
	Ctx         context.Context
	Enabled     func() bool
	Name        string
	ClusterName string
	Lifecycle   v31.NamespacedBasicAuthLifecycle
} {
	var calls []struct {
		Ctx         context.Context
		Enabled     func() bool
		Name        string
		ClusterName string
		Lifecycle   v31.NamespacedBasicAuthLifecycle
	}
	lockNamespacedBasicAuthInterfaceMockAddClusterScopedFeatureLifecycle.RLock()
	calls = mock.calls.AddClusterScopedFeatureLifecycle
	lockNamespacedBasicAuthInterfaceMockAddClusterScopedFeatureLifecycle.RUnlock()
	return calls
}

// AddClusterScopedHandler calls AddClusterScopedHandlerFunc.
func (mock *NamespacedBasicAuthInterfaceMock) AddClusterScopedHandler(ctx context.Context, name string, clusterName string, syncMoqParam v31.NamespacedBasicAuthHandlerFunc) {
	if mock.AddClusterScopedHandlerFunc == nil {
		panic("NamespacedBasicAuthInterfaceMock.AddClusterScopedHandlerFunc: method is nil but NamespacedBasicAuthInterface.AddClusterScopedHandler was just called")
	}
	callInfo := struct {
		Ctx         context.Context
		Name        string
		ClusterName string
		Sync        v31.NamespacedBasicAuthHandlerFunc
	}{
		Ctx:         ctx,
		Name:        name,
		ClusterName: clusterName,
		Sync:        syncMoqParam,
	}
	lockNamespacedBasicAuthInterfaceMockAddClusterScopedHandler.Lock()
	mock.calls.AddClusterScopedHandler = append(mock.calls.AddClusterScopedHandler, callInfo)
	lockNamespacedBasicAuthInterfaceMockAddClusterScopedHandler.Unlock()
	mock.AddClusterScopedHandlerFunc(ctx, name, clusterName, syncMoqParam)
}

// AddClusterScopedHandlerCalls gets all the calls that were made to AddClusterScopedHandler.
// Check the length with:
//     len(mockedNamespacedBasicAuthInterface.AddClusterScopedHandlerCalls())
func (mock *NamespacedBasicAuthInterfaceMock) AddClusterScopedHandlerCalls() []struct {
	Ctx         context.Context
	Name        string
	ClusterName string
	Sync        v31.NamespacedBasicAuthHandlerFunc
} {
	var calls []struct {
		Ctx         context.Context
		Name        string
		ClusterName string
		Sync        v31.NamespacedBasicAuthHandlerFunc
	}
	lockNamespacedBasicAuthInterfaceMockAddClusterScopedHandler.RLock()
	calls = mock.calls.AddClusterScopedHandler
	lockNamespacedBasicAuthInterfaceMockAddClusterScopedHandler.RUnlock()
	return calls
}

// AddClusterScopedLifecycle calls AddClusterScopedLifecycleFunc.
func (mock *NamespacedBasicAuthInterfaceMock) AddClusterScopedLifecycle(ctx context.Context, name string, clusterName string, lifecycle v31.NamespacedBasicAuthLifecycle) {
	if mock.AddClusterScopedLifecycleFunc == nil {
		panic("NamespacedBasicAuthInterfaceMock.AddClusterScopedLifecycleFunc: method is nil but NamespacedBasicAuthInterface.AddClusterScopedLifecycle was just called")
	}
	callInfo := struct {
		Ctx         context.Context
		Name        string
		ClusterName string
		Lifecycle   v31.NamespacedBasicAuthLifecycle
	}{
		Ctx:         ctx,
		Name:        name,
		ClusterName: clusterName,
		Lifecycle:   lifecycle,
	}
	lockNamespacedBasicAuthInterfaceMockAddClusterScopedLifecycle.Lock()
	mock.calls.AddClusterScopedLifecycle = append(mock.calls.AddClusterScopedLifecycle, callInfo)
	lockNamespacedBasicAuthInterfaceMockAddClusterScopedLifecycle.Unlock()
	mock.AddClusterScopedLifecycleFunc(ctx, name, clusterName, lifecycle)
}

// AddClusterScopedLifecycleCalls gets all the calls that were made to AddClusterScopedLifecycle.
// Check the length with:
//     len(mockedNamespacedBasicAuthInterface.AddClusterScopedLifecycleCalls())
func (mock *NamespacedBasicAuthInterfaceMock) AddClusterScopedLifecycleCalls() []struct {
	Ctx         context.Context
	Name        string
	ClusterName string
	Lifecycle   v31.NamespacedBasicAuthLifecycle
} {
	var calls []struct {
		Ctx         context.Context
		Name        string
		ClusterName string
		Lifecycle   v31.NamespacedBasicAuthLifecycle
	}
	lockNamespacedBasicAuthInterfaceMockAddClusterScopedLifecycle.RLock()
	calls = mock.calls.AddClusterScopedLifecycle
	lockNamespacedBasicAuthInterfaceMockAddClusterScopedLifecycle.RUnlock()
	return calls
}

// AddFeatureHandler calls AddFeatureHandlerFunc.
func (mock *NamespacedBasicAuthInterfaceMock) AddFeatureHandler(ctx context.Context, enabled func() bool, name string, syncMoqParam v31.NamespacedBasicAuthHandlerFunc) {
	if mock.AddFeatureHandlerFunc == nil {
		panic("NamespacedBasicAuthInterfaceMock.AddFeatureHandlerFunc: method is nil but NamespacedBasicAuthInterface.AddFeatureHandler was just called")
	}
	callInfo := struct {
		Ctx     context.Context
		Enabled func() bool
		Name    string
		Sync    v31.NamespacedBasicAuthHandlerFunc
	}{
		Ctx:     ctx,
		Enabled: enabled,
		Name:    name,
		Sync:    syncMoqParam,
	}
	lockNamespacedBasicAuthInterfaceMockAddFeatureHandler.Lock()
	mock.calls.AddFeatureHandler = append(mock.calls.AddFeatureHandler, callInfo)
	lockNamespacedBasicAuthInterfaceMockAddFeatureHandler.Unlock()
	mock.AddFeatureHandlerFunc(ctx, enabled, name, syncMoqParam)
}

// AddFeatureHandlerCalls gets all the calls that were made to AddFeatureHandler.
// Check the length with:
//     len(mockedNamespacedBasicAuthInterface.AddFeatureHandlerCalls())
func (mock *NamespacedBasicAuthInterfaceMock) AddFeatureHandlerCalls() []struct {
	Ctx     context.Context
	Enabled func() bool
	Name    string
	Sync    v31.NamespacedBasicAuthHandlerFunc
} {
	var calls []struct {
		Ctx     context.Context
		Enabled func() bool
		Name    string
		Sync    v31.NamespacedBasicAuthHandlerFunc
	}
	lockNamespacedBasicAuthInterfaceMockAddFeatureHandler.RLock()
	calls = mock.calls.AddFeatureHandler
	lockNamespacedBasicAuthInterfaceMockAddFeatureHandler.RUnlock()
	return calls
}

// AddFeatureLifecycle calls AddFeatureLifecycleFunc.
func (mock *NamespacedBasicAuthInterfaceMock) AddFeatureLifecycle(ctx context.Context, enabled func() bool, name string, lifecycle v31.NamespacedBasicAuthLifecycle) {
	if mock.AddFeatureLifecycleFunc == nil {
		panic("NamespacedBasicAuthInterfaceMock.AddFeatureLifecycleFunc: method is nil but NamespacedBasicAuthInterface.AddFeatureLifecycle was just called")
	}
	callInfo := struct {
		Ctx       context.Context
		Enabled   func() bool
		Name      string
		Lifecycle v31.NamespacedBasicAuthLifecycle
	}{
		Ctx:       ctx,
		Enabled:   enabled,
		Name:      name,
		Lifecycle: lifecycle,
	}
	lockNamespacedBasicAuthInterfaceMockAddFeatureLifecycle.Lock()
	mock.calls.AddFeatureLifecycle = append(mock.calls.AddFeatureLifecycle, callInfo)
	lockNamespacedBasicAuthInterfaceMockAddFeatureLifecycle.Unlock()
	mock.AddFeatureLifecycleFunc(ctx, enabled, name, lifecycle)
}

// AddFeatureLifecycleCalls gets all the calls that were made to AddFeatureLifecycle.
// Check the length with:
//     len(mockedNamespacedBasicAuthInterface.AddFeatureLifecycleCalls())
func (mock *NamespacedBasicAuthInterfaceMock) AddFeatureLifecycleCalls() []struct {
	Ctx       context.Context
	Enabled   func() bool
	Name      string
	Lifecycle v31.NamespacedBasicAuthLifecycle
} {
	var calls []struct {
		Ctx       context.Context
		Enabled   func() bool
		Name      string
		Lifecycle v31.NamespacedBasicAuthLifecycle
	}
	lockNamespacedBasicAuthInterfaceMockAddFeatureLifecycle.RLock()
	calls = mock.calls.AddFeatureLifecycle
	lockNamespacedBasicAuthInterfaceMockAddFeatureLifecycle.RUnlock()
	return calls
}

// AddHandler calls AddHandlerFunc.
func (mock *NamespacedBasicAuthInterfaceMock) AddHandler(ctx context.Context, name string, syncMoqParam v31.NamespacedBasicAuthHandlerFunc) {
	if mock.AddHandlerFunc == nil {
		panic("NamespacedBasicAuthInterfaceMock.AddHandlerFunc: method is nil but NamespacedBasicAuthInterface.AddHandler was just called")
	}
	callInfo := struct {
		Ctx  context.Context
		Name string
		Sync v31.NamespacedBasicAuthHandlerFunc
	}{
		Ctx:  ctx,
		Name: name,
		Sync: syncMoqParam,
	}
	lockNamespacedBasicAuthInterfaceMockAddHandler.Lock()
	mock.calls.AddHandler = append(mock.calls.AddHandler, callInfo)
	lockNamespacedBasicAuthInterfaceMockAddHandler.Unlock()
	mock.AddHandlerFunc(ctx, name, syncMoqParam)
}

// AddHandlerCalls gets all the calls that were made to AddHandler.
// Check the length with:
//     len(mockedNamespacedBasicAuthInterface.AddHandlerCalls())
func (mock *NamespacedBasicAuthInterfaceMock) AddHandlerCalls() []struct {
	Ctx  context.Context
	Name string
	Sync v31.NamespacedBasicAuthHandlerFunc
} {
	var calls []struct {
		Ctx  context.Context
		Name string
		Sync v31.NamespacedBasicAuthHandlerFunc
	}
	lockNamespacedBasicAuthInterfaceMockAddHandler.RLock()
	calls = mock.calls.AddHandler
	lockNamespacedBasicAuthInterfaceMockAddHandler.RUnlock()
	return calls
}

// AddLifecycle calls AddLifecycleFunc.
func (mock *NamespacedBasicAuthInterfaceMock) AddLifecycle(ctx context.Context, name string, lifecycle v31.NamespacedBasicAuthLifecycle) {
	if mock.AddLifecycleFunc == nil {
		panic("NamespacedBasicAuthInterfaceMock.AddLifecycleFunc: method is nil but NamespacedBasicAuthInterface.AddLifecycle was just called")
	}
	callInfo := struct {
		Ctx       context.Context
		Name      string
		Lifecycle v31.NamespacedBasicAuthLifecycle
	}{
		Ctx:       ctx,
		Name:      name,
		Lifecycle: lifecycle,
	}
	lockNamespacedBasicAuthInterfaceMockAddLifecycle.Lock()
	mock.calls.AddLifecycle = append(mock.calls.AddLifecycle, callInfo)
	lockNamespacedBasicAuthInterfaceMockAddLifecycle.Unlock()
	mock.AddLifecycleFunc(ctx, name, lifecycle)
}

// AddLifecycleCalls gets all the calls that were made to AddLifecycle.
// Check the length with:
//     len(mockedNamespacedBasicAuthInterface.AddLifecycleCalls())
func (mock *NamespacedBasicAuthInterfaceMock) AddLifecycleCalls() []struct {
	Ctx       context.Context
	Name      string
	Lifecycle v31.NamespacedBasicAuthLifecycle
} {
	var calls []struct {
		Ctx       context.Context
		Name      string
		Lifecycle v31.NamespacedBasicAuthLifecycle
	}
	lockNamespacedBasicAuthInterfaceMockAddLifecycle.RLock()
	calls = mock.calls.AddLifecycle
	lockNamespacedBasicAuthInterfaceMockAddLifecycle.RUnlock()
	return calls
}

// Controller calls ControllerFunc.
func (mock *NamespacedBasicAuthInterfaceMock) Controller() v31.NamespacedBasicAuthController {
	if mock.ControllerFunc == nil {
		panic("NamespacedBasicAuthInterfaceMock.ControllerFunc: method is nil but NamespacedBasicAuthInterface.Controller was just called")
	}
	callInfo := struct {
	}{}
	lockNamespacedBasicAuthInterfaceMockController.Lock()
	mock.calls.Controller = append(mock.calls.Controller, callInfo)
	lockNamespacedBasicAuthInterfaceMockController.Unlock()
	return mock.ControllerFunc()
}

// ControllerCalls gets all the calls that were made to Controller.
// Check the length with:
//     len(mockedNamespacedBasicAuthInterface.ControllerCalls())
func (mock *NamespacedBasicAuthInterfaceMock) ControllerCalls() []struct {
} {
	var calls []struct {
	}
	lockNamespacedBasicAuthInterfaceMockController.RLock()
	calls = mock.calls.Controller
	lockNamespacedBasicAuthInterfaceMockController.RUnlock()
	return calls
}

// Create calls CreateFunc.
func (mock *NamespacedBasicAuthInterfaceMock) Create(in1 *v3.NamespacedBasicAuth) (*v3.NamespacedBasicAuth, error) {
	if mock.CreateFunc == nil {
		panic("NamespacedBasicAuthInterfaceMock.CreateFunc: method is nil but NamespacedBasicAuthInterface.Create was just called")
	}
	callInfo := struct {
		In1 *v3.NamespacedBasicAuth
	}{
		In1: in1,
	}
	lockNamespacedBasicAuthInterfaceMockCreate.Lock()
	mock.calls.Create = append(mock.calls.Create, callInfo)
	lockNamespacedBasicAuthInterfaceMockCreate.Unlock()
	return mock.CreateFunc(in1)
}

// CreateCalls gets all the calls that were made to Create.
// Check the length with:
//     len(mockedNamespacedBasicAuthInterface.CreateCalls())
func (mock *NamespacedBasicAuthInterfaceMock) CreateCalls() []struct {
	In1 *v3.NamespacedBasicAuth
} {
	var calls []struct {
		In1 *v3.NamespacedBasicAuth
	}
	lockNamespacedBasicAuthInterfaceMockCreate.RLock()
	calls = mock.calls.Create
	lockNamespacedBasicAuthInterfaceMockCreate.RUnlock()
	return calls
}

// Delete calls DeleteFunc.
func (mock *NamespacedBasicAuthInterfaceMock) Delete(name string, options *metav1.DeleteOptions) error {
	if mock.DeleteFunc == nil {
		panic("NamespacedBasicAuthInterfaceMock.DeleteFunc: method is nil but NamespacedBasicAuthInterface.Delete was just called")
	}
	callInfo := struct {
		Name    string
		Options *metav1.DeleteOptions
	}{
		Name:    name,
		Options: options,
	}
	lockNamespacedBasicAuthInterfaceMockDelete.Lock()
	mock.calls.Delete = append(mock.calls.Delete, callInfo)
	lockNamespacedBasicAuthInterfaceMockDelete.Unlock()
	return mock.DeleteFunc(name, options)
}

// DeleteCalls gets all the calls that were made to Delete.
// Check the length with:
//     len(mockedNamespacedBasicAuthInterface.DeleteCalls())
func (mock *NamespacedBasicAuthInterfaceMock) DeleteCalls() []struct {
	Name    string
	Options *metav1.DeleteOptions
} {
	var calls []struct {
		Name    string
		Options *metav1.DeleteOptions
	}
	lockNamespacedBasicAuthInterfaceMockDelete.RLock()
	calls = mock.calls.Delete
	lockNamespacedBasicAuthInterfaceMockDelete.RUnlock()
	return calls
}

// DeleteCollection calls DeleteCollectionFunc.
func (mock *NamespacedBasicAuthInterfaceMock) DeleteCollection(deleteOpts *metav1.DeleteOptions, listOpts metav1.ListOptions) error {
	if mock.DeleteCollectionFunc == nil {
		panic("NamespacedBasicAuthInterfaceMock.DeleteCollectionFunc: method is nil but NamespacedBasicAuthInterface.DeleteCollection was just called")
	}
	callInfo := struct {
		DeleteOpts *metav1.DeleteOptions
		ListOpts   metav1.ListOptions
	}{
		DeleteOpts: deleteOpts,
		ListOpts:   listOpts,
	}
	lockNamespacedBasicAuthInterfaceMockDeleteCollection.Lock()
	mock.calls.DeleteCollection = append(mock.calls.DeleteCollection, callInfo)
	lockNamespacedBasicAuthInterfaceMockDeleteCollection.Unlock()
	return mock.DeleteCollectionFunc(deleteOpts, listOpts)
}

// DeleteCollectionCalls gets all the calls that were made to DeleteCollection.
// Check the length with:
//     len(mockedNamespacedBasicAuthInterface.DeleteCollectionCalls())
func (mock *NamespacedBasicAuthInterfaceMock) DeleteCollectionCalls() []struct {
	DeleteOpts *metav1.DeleteOptions
	ListOpts   metav1.ListOptions
} {
	var calls []struct {
		DeleteOpts *metav1.DeleteOptions
		ListOpts   metav1.ListOptions
	}
	lockNamespacedBasicAuthInterfaceMockDeleteCollection.RLock()
	calls = mock.calls.DeleteCollection
	lockNamespacedBasicAuthInterfaceMockDeleteCollection.RUnlock()
	return calls
}

// DeleteNamespaced calls DeleteNamespacedFunc.
func (mock *NamespacedBasicAuthInterfaceMock) DeleteNamespaced(namespace string, name string, options *metav1.DeleteOptions) error {
	if mock.DeleteNamespacedFunc == nil {
		panic("NamespacedBasicAuthInterfaceMock.DeleteNamespacedFunc: method is nil but NamespacedBasicAuthInterface.DeleteNamespaced was just called")
	}
	callInfo := struct {
		Namespace string
		Name      string
		Options   *metav1.DeleteOptions
	}{
		Namespace: namespace,
		Name:      name,
		Options:   options,
	}
	lockNamespacedBasicAuthInterfaceMockDeleteNamespaced.Lock()
	mock.calls.DeleteNamespaced = append(mock.calls.DeleteNamespaced, callInfo)
	lockNamespacedBasicAuthInterfaceMockDeleteNamespaced.Unlock()
	return mock.DeleteNamespacedFunc(namespace, name, options)
}

// DeleteNamespacedCalls gets all the calls that were made to DeleteNamespaced.
// Check the length with:
//     len(mockedNamespacedBasicAuthInterface.DeleteNamespacedCalls())
func (mock *NamespacedBasicAuthInterfaceMock) DeleteNamespacedCalls() []struct {
	Namespace string
	Name      string
	Options   *metav1.DeleteOptions
} {
	var calls []struct {
		Namespace string
		Name      string
		Options   *metav1.DeleteOptions
	}
	lockNamespacedBasicAuthInterfaceMockDeleteNamespaced.RLock()
	calls = mock.calls.DeleteNamespaced
	lockNamespacedBasicAuthInterfaceMockDeleteNamespaced.RUnlock()
	return calls
}

// Get calls GetFunc.
func (mock *NamespacedBasicAuthInterfaceMock) Get(name string, opts metav1.GetOptions) (*v3.NamespacedBasicAuth, error) {
	if mock.GetFunc == nil {
		panic("NamespacedBasicAuthInterfaceMock.GetFunc: method is nil but NamespacedBasicAuthInterface.Get was just called")
	}
	callInfo := struct {
		Name string
		Opts metav1.GetOptions
	}{
		Name: name,
		Opts: opts,
	}
	lockNamespacedBasicAuthInterfaceMockGet.Lock()
	mock.calls.Get = append(mock.calls.Get, callInfo)
	lockNamespacedBasicAuthInterfaceMockGet.Unlock()
	return mock.GetFunc(name, opts)
}

// GetCalls gets all the calls that were made to Get.
// Check the length with:
//     len(mockedNamespacedBasicAuthInterface.GetCalls())
func (mock *NamespacedBasicAuthInterfaceMock) GetCalls() []struct {
	Name string
	Opts metav1.GetOptions
} {
	var calls []struct {
		Name string
		Opts metav1.GetOptions
	}
	lockNamespacedBasicAuthInterfaceMockGet.RLock()
	calls = mock.calls.Get
	lockNamespacedBasicAuthInterfaceMockGet.RUnlock()
	return calls
}

// GetNamespaced calls GetNamespacedFunc.
func (mock *NamespacedBasicAuthInterfaceMock) GetNamespaced(namespace string, name string, opts metav1.GetOptions) (*v3.NamespacedBasicAuth, error) {
	if mock.GetNamespacedFunc == nil {
		panic("NamespacedBasicAuthInterfaceMock.GetNamespacedFunc: method is nil but NamespacedBasicAuthInterface.GetNamespaced was just called")
	}
	callInfo := struct {
		Namespace string
		Name      string
		Opts      metav1.GetOptions
	}{
		Namespace: namespace,
		Name:      name,
		Opts:      opts,
	}
	lockNamespacedBasicAuthInterfaceMockGetNamespaced.Lock()
	mock.calls.GetNamespaced = append(mock.calls.GetNamespaced, callInfo)
	lockNamespacedBasicAuthInterfaceMockGetNamespaced.Unlock()
	return mock.GetNamespacedFunc(namespace, name, opts)
}

// GetNamespacedCalls gets all the calls that were made to GetNamespaced.
// Check the length with:
//     len(mockedNamespacedBasicAuthInterface.GetNamespacedCalls())
func (mock *NamespacedBasicAuthInterfaceMock) GetNamespacedCalls() []struct {
	Namespace string
	Name      string
	Opts      metav1.GetOptions
} {
	var calls []struct {
		Namespace string
		Name      string
		Opts      metav1.GetOptions
	}
	lockNamespacedBasicAuthInterfaceMockGetNamespaced.RLock()
	calls = mock.calls.GetNamespaced
	lockNamespacedBasicAuthInterfaceMockGetNamespaced.RUnlock()
	return calls
}

// List calls ListFunc.
func (mock *NamespacedBasicAuthInterfaceMock) List(opts metav1.ListOptions) (*v3.NamespacedBasicAuthList, error) {
	if mock.ListFunc == nil {
		panic("NamespacedBasicAuthInterfaceMock.ListFunc: method is nil but NamespacedBasicAuthInterface.List was just called")
	}
	callInfo := struct {
		Opts metav1.ListOptions
	}{
		Opts: opts,
	}
	lockNamespacedBasicAuthInterfaceMockList.Lock()
	mock.calls.List = append(mock.calls.List, callInfo)
	lockNamespacedBasicAuthInterfaceMockList.Unlock()
	return mock.ListFunc(opts)
}

// ListCalls gets all the calls that were made to List.
// Check the length with:
//     len(mockedNamespacedBasicAuthInterface.ListCalls())
func (mock *NamespacedBasicAuthInterfaceMock) ListCalls() []struct {
	Opts metav1.ListOptions
} {
	var calls []struct {
		Opts metav1.ListOptions
	}
	lockNamespacedBasicAuthInterfaceMockList.RLock()
	calls = mock.calls.List
	lockNamespacedBasicAuthInterfaceMockList.RUnlock()
	return calls
}

// ListNamespaced calls ListNamespacedFunc.
func (mock *NamespacedBasicAuthInterfaceMock) ListNamespaced(namespace string, opts metav1.ListOptions) (*v3.NamespacedBasicAuthList, error) {
	if mock.ListNamespacedFunc == nil {
		panic("NamespacedBasicAuthInterfaceMock.ListNamespacedFunc: method is nil but NamespacedBasicAuthInterface.ListNamespaced was just called")
	}
	callInfo := struct {
		Namespace string
		Opts      metav1.ListOptions
	}{
		Namespace: namespace,
		Opts:      opts,
	}
	lockNamespacedBasicAuthInterfaceMockListNamespaced.Lock()
	mock.calls.ListNamespaced = append(mock.calls.ListNamespaced, callInfo)
	lockNamespacedBasicAuthInterfaceMockListNamespaced.Unlock()
	return mock.ListNamespacedFunc(namespace, opts)
}

// ListNamespacedCalls gets all the calls that were made to ListNamespaced.
// Check the length with:
//     len(mockedNamespacedBasicAuthInterface.ListNamespacedCalls())
func (mock *NamespacedBasicAuthInterfaceMock) ListNamespacedCalls() []struct {
	Namespace string
	Opts      metav1.ListOptions
} {
	var calls []struct {
		Namespace string
		Opts      metav1.ListOptions
	}
	lockNamespacedBasicAuthInterfaceMockListNamespaced.RLock()
	calls = mock.calls.ListNamespaced
	lockNamespacedBasicAuthInterfaceMockListNamespaced.RUnlock()
	return calls
}

// ObjectClient calls ObjectClientFunc.
func (mock *NamespacedBasicAuthInterfaceMock) ObjectClient() *objectclient.ObjectClient {
	if mock.ObjectClientFunc == nil {
		panic("NamespacedBasicAuthInterfaceMock.ObjectClientFunc: method is nil but NamespacedBasicAuthInterface.ObjectClient was just called")
	}
	callInfo := struct {
	}{}
	lockNamespacedBasicAuthInterfaceMockObjectClient.Lock()
	mock.calls.ObjectClient = append(mock.calls.ObjectClient, callInfo)
	lockNamespacedBasicAuthInterfaceMockObjectClient.Unlock()
	return mock.ObjectClientFunc()
}

// ObjectClientCalls gets all the calls that were made to ObjectClient.
// Check the length with:
//     len(mockedNamespacedBasicAuthInterface.ObjectClientCalls())
func (mock *NamespacedBasicAuthInterfaceMock) ObjectClientCalls() []struct {
} {
	var calls []struct {
	}
	lockNamespacedBasicAuthInterfaceMockObjectClient.RLock()
	calls = mock.calls.ObjectClient
	lockNamespacedBasicAuthInterfaceMockObjectClient.RUnlock()
	return calls
}

// Update calls UpdateFunc.
func (mock *NamespacedBasicAuthInterfaceMock) Update(in1 *v3.NamespacedBasicAuth) (*v3.NamespacedBasicAuth, error) {
	if mock.UpdateFunc == nil {
		panic("NamespacedBasicAuthInterfaceMock.UpdateFunc: method is nil but NamespacedBasicAuthInterface.Update was just called")
	}
	callInfo := struct {
		In1 *v3.NamespacedBasicAuth
	}{
		In1: in1,
	}
	lockNamespacedBasicAuthInterfaceMockUpdate.Lock()
	mock.calls.Update = append(mock.calls.Update, callInfo)
	lockNamespacedBasicAuthInterfaceMockUpdate.Unlock()
	return mock.UpdateFunc(in1)
}

// UpdateCalls gets all the calls that were made to Update.
// Check the length with:
//     len(mockedNamespacedBasicAuthInterface.UpdateCalls())
func (mock *NamespacedBasicAuthInterfaceMock) UpdateCalls() []struct {
	In1 *v3.NamespacedBasicAuth
} {
	var calls []struct {
		In1 *v3.NamespacedBasicAuth
	}
	lockNamespacedBasicAuthInterfaceMockUpdate.RLock()
	calls = mock.calls.Update
	lockNamespacedBasicAuthInterfaceMockUpdate.RUnlock()
	return calls
}

// Watch calls WatchFunc.
func (mock *NamespacedBasicAuthInterfaceMock) Watch(opts metav1.ListOptions) (watch.Interface, error) {
	if mock.WatchFunc == nil {
		panic("NamespacedBasicAuthInterfaceMock.WatchFunc: method is nil but NamespacedBasicAuthInterface.Watch was just called")
	}
	callInfo := struct {
		Opts metav1.ListOptions
	}{
		Opts: opts,
	}
	lockNamespacedBasicAuthInterfaceMockWatch.Lock()
	mock.calls.Watch = append(mock.calls.Watch, callInfo)
	lockNamespacedBasicAuthInterfaceMockWatch.Unlock()
	return mock.WatchFunc(opts)
}

// WatchCalls gets all the calls that were made to Watch.
// Check the length with:
//     len(mockedNamespacedBasicAuthInterface.WatchCalls())
func (mock *NamespacedBasicAuthInterfaceMock) WatchCalls() []struct {
	Opts metav1.ListOptions
} {
	var calls []struct {
		Opts metav1.ListOptions
	}
	lockNamespacedBasicAuthInterfaceMockWatch.RLock()
	calls = mock.calls.Watch
	lockNamespacedBasicAuthInterfaceMockWatch.RUnlock()
	return calls
}

var (
	lockNamespacedBasicAuthsGetterMockNamespacedBasicAuths sync.RWMutex
)

// Ensure, that NamespacedBasicAuthsGetterMock does implement v31.NamespacedBasicAuthsGetter.
// If this is not the case, regenerate this file with moq.
var _ v31.NamespacedBasicAuthsGetter = &NamespacedBasicAuthsGetterMock{}

// NamespacedBasicAuthsGetterMock is a mock implementation of v31.NamespacedBasicAuthsGetter.
//
//     func TestSomethingThatUsesNamespacedBasicAuthsGetter(t *testing.T) {
//
//         // make and configure a mocked v31.NamespacedBasicAuthsGetter
//         mockedNamespacedBasicAuthsGetter := &NamespacedBasicAuthsGetterMock{
//             NamespacedBasicAuthsFunc: func(namespace string) v31.NamespacedBasicAuthInterface {
// 	               panic("mock out the NamespacedBasicAuths method")
//             },
//         }
//
//         // use mockedNamespacedBasicAuthsGetter in code that requires v31.NamespacedBasicAuthsGetter
//         // and then make assertions.
//
//     }
type NamespacedBasicAuthsGetterMock struct {
	// NamespacedBasicAuthsFunc mocks the NamespacedBasicAuths method.
	NamespacedBasicAuthsFunc func(namespace string) v31.NamespacedBasicAuthInterface

	// calls tracks calls to the methods.
	calls struct {
		// NamespacedBasicAuths holds details about calls to the NamespacedBasicAuths method.
		NamespacedBasicAuths []struct {
			// Namespace is the namespace argument value.
			Namespace string
		}
	}
}

// NamespacedBasicAuths calls NamespacedBasicAuthsFunc.
func (mock *NamespacedBasicAuthsGetterMock) NamespacedBasicAuths(namespace string) v31.NamespacedBasicAuthInterface {
	if mock.NamespacedBasicAuthsFunc == nil {
		panic("NamespacedBasicAuthsGetterMock.NamespacedBasicAuthsFunc: method is nil but NamespacedBasicAuthsGetter.NamespacedBasicAuths was just called")
	}
	callInfo := struct {
		Namespace string
	}{
		Namespace: namespace,
	}
	lockNamespacedBasicAuthsGetterMockNamespacedBasicAuths.Lock()
	mock.calls.NamespacedBasicAuths = append(mock.calls.NamespacedBasicAuths, callInfo)
	lockNamespacedBasicAuthsGetterMockNamespacedBasicAuths.Unlock()
	return mock.NamespacedBasicAuthsFunc(namespace)
}

// NamespacedBasicAuthsCalls gets all the calls that were made to NamespacedBasicAuths.
// Check the length with:
//     len(mockedNamespacedBasicAuthsGetter.NamespacedBasicAuthsCalls())
func (mock *NamespacedBasicAuthsGetterMock) NamespacedBasicAuthsCalls() []struct {
	Namespace string
} {
	var calls []struct {
		Namespace string
	}
	lockNamespacedBasicAuthsGetterMockNamespacedBasicAuths.RLock()
	calls = mock.calls.NamespacedBasicAuths
	lockNamespacedBasicAuthsGetterMockNamespacedBasicAuths.RUnlock()
	return calls
}
