// Code generated by moq; DO NOT EDIT.
// github.com/matryer/moq

package fakes

import (
	"context"
	"sync"
	"time"

	"github.com/rancher/norman/controller"
	"github.com/rancher/norman/objectclient"
	v3 "github.com/rancher/rancher/pkg/apis/project.cattle.io/v3"
	v31 "github.com/rancher/rancher/pkg/generated/norman/project.cattle.io/v3"
	metav1 "k8s.io/apimachinery/pkg/apis/meta/v1"
	"k8s.io/apimachinery/pkg/labels"
	"k8s.io/apimachinery/pkg/watch"
	"k8s.io/client-go/tools/cache"
)

var (
	lockNamespacedDockerCredentialListerMockGet  sync.RWMutex
	lockNamespacedDockerCredentialListerMockList sync.RWMutex
)

// Ensure, that NamespacedDockerCredentialListerMock does implement v31.NamespacedDockerCredentialLister.
// If this is not the case, regenerate this file with moq.
var _ v31.NamespacedDockerCredentialLister = &NamespacedDockerCredentialListerMock{}

// NamespacedDockerCredentialListerMock is a mock implementation of v31.NamespacedDockerCredentialLister.
//
//     func TestSomethingThatUsesNamespacedDockerCredentialLister(t *testing.T) {
//
//         // make and configure a mocked v31.NamespacedDockerCredentialLister
//         mockedNamespacedDockerCredentialLister := &NamespacedDockerCredentialListerMock{
//             GetFunc: func(namespace string, name string) (*v3.NamespacedDockerCredential, error) {
// 	               panic("mock out the Get method")
//             },
//             ListFunc: func(namespace string, selector labels.Selector) ([]*v3.NamespacedDockerCredential, error) {
// 	               panic("mock out the List method")
//             },
//         }
//
//         // use mockedNamespacedDockerCredentialLister in code that requires v31.NamespacedDockerCredentialLister
//         // and then make assertions.
//
//     }
type NamespacedDockerCredentialListerMock struct {
	// GetFunc mocks the Get method.
	GetFunc func(namespace string, name string) (*v3.NamespacedDockerCredential, error)

	// ListFunc mocks the List method.
	ListFunc func(namespace string, selector labels.Selector) ([]*v3.NamespacedDockerCredential, error)

	// calls tracks calls to the methods.
	calls struct {
		// Get holds details about calls to the Get method.
		Get []struct {
			// Namespace is the namespace argument value.
			Namespace string
			// Name is the name argument value.
			Name string
		}
		// List holds details about calls to the List method.
		List []struct {
			// Namespace is the namespace argument value.
			Namespace string
			// Selector is the selector argument value.
			Selector labels.Selector
		}
	}
}

// Get calls GetFunc.
func (mock *NamespacedDockerCredentialListerMock) Get(namespace string, name string) (*v3.NamespacedDockerCredential, error) {
	if mock.GetFunc == nil {
		panic("NamespacedDockerCredentialListerMock.GetFunc: method is nil but NamespacedDockerCredentialLister.Get was just called")
	}
	callInfo := struct {
		Namespace string
		Name      string
	}{
		Namespace: namespace,
		Name:      name,
	}
	lockNamespacedDockerCredentialListerMockGet.Lock()
	mock.calls.Get = append(mock.calls.Get, callInfo)
	lockNamespacedDockerCredentialListerMockGet.Unlock()
	return mock.GetFunc(namespace, name)
}

// GetCalls gets all the calls that were made to Get.
// Check the length with:
//     len(mockedNamespacedDockerCredentialLister.GetCalls())
func (mock *NamespacedDockerCredentialListerMock) GetCalls() []struct {
	Namespace string
	Name      string
} {
	var calls []struct {
		Namespace string
		Name      string
	}
	lockNamespacedDockerCredentialListerMockGet.RLock()
	calls = mock.calls.Get
	lockNamespacedDockerCredentialListerMockGet.RUnlock()
	return calls
}

// List calls ListFunc.
func (mock *NamespacedDockerCredentialListerMock) List(namespace string, selector labels.Selector) ([]*v3.NamespacedDockerCredential, error) {
	if mock.ListFunc == nil {
		panic("NamespacedDockerCredentialListerMock.ListFunc: method is nil but NamespacedDockerCredentialLister.List was just called")
	}
	callInfo := struct {
		Namespace string
		Selector  labels.Selector
	}{
		Namespace: namespace,
		Selector:  selector,
	}
	lockNamespacedDockerCredentialListerMockList.Lock()
	mock.calls.List = append(mock.calls.List, callInfo)
	lockNamespacedDockerCredentialListerMockList.Unlock()
	return mock.ListFunc(namespace, selector)
}

// ListCalls gets all the calls that were made to List.
// Check the length with:
//     len(mockedNamespacedDockerCredentialLister.ListCalls())
func (mock *NamespacedDockerCredentialListerMock) ListCalls() []struct {
	Namespace string
	Selector  labels.Selector
} {
	var calls []struct {
		Namespace string
		Selector  labels.Selector
	}
	lockNamespacedDockerCredentialListerMockList.RLock()
	calls = mock.calls.List
	lockNamespacedDockerCredentialListerMockList.RUnlock()
	return calls
}

var (
	lockNamespacedDockerCredentialControllerMockAddClusterScopedFeatureHandler sync.RWMutex
	lockNamespacedDockerCredentialControllerMockAddClusterScopedHandler        sync.RWMutex
	lockNamespacedDockerCredentialControllerMockAddFeatureHandler              sync.RWMutex
	lockNamespacedDockerCredentialControllerMockAddHandler                     sync.RWMutex
	lockNamespacedDockerCredentialControllerMockEnqueue                        sync.RWMutex
	lockNamespacedDockerCredentialControllerMockEnqueueAfter                   sync.RWMutex
	lockNamespacedDockerCredentialControllerMockGeneric                        sync.RWMutex
	lockNamespacedDockerCredentialControllerMockInformer                       sync.RWMutex
	lockNamespacedDockerCredentialControllerMockLister                         sync.RWMutex
)

// Ensure, that NamespacedDockerCredentialControllerMock does implement v31.NamespacedDockerCredentialController.
// If this is not the case, regenerate this file with moq.
var _ v31.NamespacedDockerCredentialController = &NamespacedDockerCredentialControllerMock{}

// NamespacedDockerCredentialControllerMock is a mock implementation of v31.NamespacedDockerCredentialController.
//
//     func TestSomethingThatUsesNamespacedDockerCredentialController(t *testing.T) {
//
//         // make and configure a mocked v31.NamespacedDockerCredentialController
//         mockedNamespacedDockerCredentialController := &NamespacedDockerCredentialControllerMock{
//             AddClusterScopedFeatureHandlerFunc: func(ctx context.Context, enabled func() bool, name string, clusterName string, handler v31.NamespacedDockerCredentialHandlerFunc)  {
// 	               panic("mock out the AddClusterScopedFeatureHandler method")
//             },
//             AddClusterScopedHandlerFunc: func(ctx context.Context, name string, clusterName string, handler v31.NamespacedDockerCredentialHandlerFunc)  {
// 	               panic("mock out the AddClusterScopedHandler method")
//             },
//             AddFeatureHandlerFunc: func(ctx context.Context, enabled func() bool, name string, syncMoqParam v31.NamespacedDockerCredentialHandlerFunc)  {
// 	               panic("mock out the AddFeatureHandler method")
//             },
//             AddHandlerFunc: func(ctx context.Context, name string, handler v31.NamespacedDockerCredentialHandlerFunc)  {
// 	               panic("mock out the AddHandler method")
//             },
//             EnqueueFunc: func(namespace string, name string)  {
// 	               panic("mock out the Enqueue method")
//             },
//             EnqueueAfterFunc: func(namespace string, name string, after time.Duration)  {
// 	               panic("mock out the EnqueueAfter method")
//             },
//             GenericFunc: func() controller.GenericController {
// 	               panic("mock out the Generic method")
//             },
//             InformerFunc: func() cache.SharedIndexInformer {
// 	               panic("mock out the Informer method")
//             },
//             ListerFunc: func() v31.NamespacedDockerCredentialLister {
// 	               panic("mock out the Lister method")
//             },
//         }
//
//         // use mockedNamespacedDockerCredentialController in code that requires v31.NamespacedDockerCredentialController
//         // and then make assertions.
//
//     }
type NamespacedDockerCredentialControllerMock struct {
	// AddClusterScopedFeatureHandlerFunc mocks the AddClusterScopedFeatureHandler method.
	AddClusterScopedFeatureHandlerFunc func(ctx context.Context, enabled func() bool, name string, clusterName string, handler v31.NamespacedDockerCredentialHandlerFunc)

	// AddClusterScopedHandlerFunc mocks the AddClusterScopedHandler method.
	AddClusterScopedHandlerFunc func(ctx context.Context, name string, clusterName string, handler v31.NamespacedDockerCredentialHandlerFunc)

	// AddFeatureHandlerFunc mocks the AddFeatureHandler method.
	AddFeatureHandlerFunc func(ctx context.Context, enabled func() bool, name string, syncMoqParam v31.NamespacedDockerCredentialHandlerFunc)

	// AddHandlerFunc mocks the AddHandler method.
	AddHandlerFunc func(ctx context.Context, name string, handler v31.NamespacedDockerCredentialHandlerFunc)

	// EnqueueFunc mocks the Enqueue method.
	EnqueueFunc func(namespace string, name string)

	// EnqueueAfterFunc mocks the EnqueueAfter method.
	EnqueueAfterFunc func(namespace string, name string, after time.Duration)

	// GenericFunc mocks the Generic method.
	GenericFunc func() controller.GenericController

	// InformerFunc mocks the Informer method.
	InformerFunc func() cache.SharedIndexInformer

	// ListerFunc mocks the Lister method.
	ListerFunc func() v31.NamespacedDockerCredentialLister

	// calls tracks calls to the methods.
	calls struct {
		// AddClusterScopedFeatureHandler holds details about calls to the AddClusterScopedFeatureHandler method.
		AddClusterScopedFeatureHandler []struct {
			// Ctx is the ctx argument value.
			Ctx context.Context
			// Enabled is the enabled argument value.
			Enabled func() bool
			// Name is the name argument value.
			Name string
			// ClusterName is the clusterName argument value.
			ClusterName string
			// Handler is the handler argument value.
			Handler v31.NamespacedDockerCredentialHandlerFunc
		}
		// AddClusterScopedHandler holds details about calls to the AddClusterScopedHandler method.
		AddClusterScopedHandler []struct {
			// Ctx is the ctx argument value.
			Ctx context.Context
			// Name is the name argument value.
			Name string
			// ClusterName is the clusterName argument value.
			ClusterName string
			// Handler is the handler argument value.
			Handler v31.NamespacedDockerCredentialHandlerFunc
		}
		// AddFeatureHandler holds details about calls to the AddFeatureHandler method.
		AddFeatureHandler []struct {
			// Ctx is the ctx argument value.
			Ctx context.Context
			// Enabled is the enabled argument value.
			Enabled func() bool
			// Name is the name argument value.
			Name string
			// Sync is the sync argument value.
			Sync v31.NamespacedDockerCredentialHandlerFunc
		}
		// AddHandler holds details about calls to the AddHandler method.
		AddHandler []struct {
			// Ctx is the ctx argument value.
			Ctx context.Context
			// Name is the name argument value.
			Name string
			// Handler is the handler argument value.
			Handler v31.NamespacedDockerCredentialHandlerFunc
		}
		// Enqueue holds details about calls to the Enqueue method.
		Enqueue []struct {
			// Namespace is the namespace argument value.
			Namespace string
			// Name is the name argument value.
			Name string
		}
		// EnqueueAfter holds details about calls to the EnqueueAfter method.
		EnqueueAfter []struct {
			// Namespace is the namespace argument value.
			Namespace string
			// Name is the name argument value.
			Name string
			// After is the after argument value.
			After time.Duration
		}
		// Generic holds details about calls to the Generic method.
		Generic []struct {
		}
		// Informer holds details about calls to the Informer method.
		Informer []struct {
		}
		// Lister holds details about calls to the Lister method.
		Lister []struct {
		}
	}
}

// AddClusterScopedFeatureHandler calls AddClusterScopedFeatureHandlerFunc.
func (mock *NamespacedDockerCredentialControllerMock) AddClusterScopedFeatureHandler(ctx context.Context, enabled func() bool, name string, clusterName string, handler v31.NamespacedDockerCredentialHandlerFunc) {
	if mock.AddClusterScopedFeatureHandlerFunc == nil {
		panic("NamespacedDockerCredentialControllerMock.AddClusterScopedFeatureHandlerFunc: method is nil but NamespacedDockerCredentialController.AddClusterScopedFeatureHandler was just called")
	}
	callInfo := struct {
		Ctx         context.Context
		Enabled     func() bool
		Name        string
		ClusterName string
		Handler     v31.NamespacedDockerCredentialHandlerFunc
	}{
		Ctx:         ctx,
		Enabled:     enabled,
		Name:        name,
		ClusterName: clusterName,
		Handler:     handler,
	}
	lockNamespacedDockerCredentialControllerMockAddClusterScopedFeatureHandler.Lock()
	mock.calls.AddClusterScopedFeatureHandler = append(mock.calls.AddClusterScopedFeatureHandler, callInfo)
	lockNamespacedDockerCredentialControllerMockAddClusterScopedFeatureHandler.Unlock()
	mock.AddClusterScopedFeatureHandlerFunc(ctx, enabled, name, clusterName, handler)
}

// AddClusterScopedFeatureHandlerCalls gets all the calls that were made to AddClusterScopedFeatureHandler.
// Check the length with:
//     len(mockedNamespacedDockerCredentialController.AddClusterScopedFeatureHandlerCalls())
func (mock *NamespacedDockerCredentialControllerMock) AddClusterScopedFeatureHandlerCalls() []struct {
	Ctx         context.Context
	Enabled     func() bool
	Name        string
	ClusterName string
	Handler     v31.NamespacedDockerCredentialHandlerFunc
} {
	var calls []struct {
		Ctx         context.Context
		Enabled     func() bool
		Name        string
		ClusterName string
		Handler     v31.NamespacedDockerCredentialHandlerFunc
	}
	lockNamespacedDockerCredentialControllerMockAddClusterScopedFeatureHandler.RLock()
	calls = mock.calls.AddClusterScopedFeatureHandler
	lockNamespacedDockerCredentialControllerMockAddClusterScopedFeatureHandler.RUnlock()
	return calls
}

// AddClusterScopedHandler calls AddClusterScopedHandlerFunc.
func (mock *NamespacedDockerCredentialControllerMock) AddClusterScopedHandler(ctx context.Context, name string, clusterName string, handler v31.NamespacedDockerCredentialHandlerFunc) {
	if mock.AddClusterScopedHandlerFunc == nil {
		panic("NamespacedDockerCredentialControllerMock.AddClusterScopedHandlerFunc: method is nil but NamespacedDockerCredentialController.AddClusterScopedHandler was just called")
	}
	callInfo := struct {
		Ctx         context.Context
		Name        string
		ClusterName string
		Handler     v31.NamespacedDockerCredentialHandlerFunc
	}{
		Ctx:         ctx,
		Name:        name,
		ClusterName: clusterName,
		Handler:     handler,
	}
	lockNamespacedDockerCredentialControllerMockAddClusterScopedHandler.Lock()
	mock.calls.AddClusterScopedHandler = append(mock.calls.AddClusterScopedHandler, callInfo)
	lockNamespacedDockerCredentialControllerMockAddClusterScopedHandler.Unlock()
	mock.AddClusterScopedHandlerFunc(ctx, name, clusterName, handler)
}

// AddClusterScopedHandlerCalls gets all the calls that were made to AddClusterScopedHandler.
// Check the length with:
//     len(mockedNamespacedDockerCredentialController.AddClusterScopedHandlerCalls())
func (mock *NamespacedDockerCredentialControllerMock) AddClusterScopedHandlerCalls() []struct {
	Ctx         context.Context
	Name        string
	ClusterName string
	Handler     v31.NamespacedDockerCredentialHandlerFunc
} {
	var calls []struct {
		Ctx         context.Context
		Name        string
		ClusterName string
		Handler     v31.NamespacedDockerCredentialHandlerFunc
	}
	lockNamespacedDockerCredentialControllerMockAddClusterScopedHandler.RLock()
	calls = mock.calls.AddClusterScopedHandler
	lockNamespacedDockerCredentialControllerMockAddClusterScopedHandler.RUnlock()
	return calls
}

// AddFeatureHandler calls AddFeatureHandlerFunc.
func (mock *NamespacedDockerCredentialControllerMock) AddFeatureHandler(ctx context.Context, enabled func() bool, name string, syncMoqParam v31.NamespacedDockerCredentialHandlerFunc) {
	if mock.AddFeatureHandlerFunc == nil {
		panic("NamespacedDockerCredentialControllerMock.AddFeatureHandlerFunc: method is nil but NamespacedDockerCredentialController.AddFeatureHandler was just called")
	}
	callInfo := struct {
		Ctx     context.Context
		Enabled func() bool
		Name    string
		Sync    v31.NamespacedDockerCredentialHandlerFunc
	}{
		Ctx:     ctx,
		Enabled: enabled,
		Name:    name,
		Sync:    syncMoqParam,
	}
	lockNamespacedDockerCredentialControllerMockAddFeatureHandler.Lock()
	mock.calls.AddFeatureHandler = append(mock.calls.AddFeatureHandler, callInfo)
	lockNamespacedDockerCredentialControllerMockAddFeatureHandler.Unlock()
	mock.AddFeatureHandlerFunc(ctx, enabled, name, syncMoqParam)
}

// AddFeatureHandlerCalls gets all the calls that were made to AddFeatureHandler.
// Check the length with:
//     len(mockedNamespacedDockerCredentialController.AddFeatureHandlerCalls())
func (mock *NamespacedDockerCredentialControllerMock) AddFeatureHandlerCalls() []struct {
	Ctx     context.Context
	Enabled func() bool
	Name    string
	Sync    v31.NamespacedDockerCredentialHandlerFunc
} {
	var calls []struct {
		Ctx     context.Context
		Enabled func() bool
		Name    string
		Sync    v31.NamespacedDockerCredentialHandlerFunc
	}
	lockNamespacedDockerCredentialControllerMockAddFeatureHandler.RLock()
	calls = mock.calls.AddFeatureHandler
	lockNamespacedDockerCredentialControllerMockAddFeatureHandler.RUnlock()
	return calls
}

// AddHandler calls AddHandlerFunc.
func (mock *NamespacedDockerCredentialControllerMock) AddHandler(ctx context.Context, name string, handler v31.NamespacedDockerCredentialHandlerFunc) {
	if mock.AddHandlerFunc == nil {
		panic("NamespacedDockerCredentialControllerMock.AddHandlerFunc: method is nil but NamespacedDockerCredentialController.AddHandler was just called")
	}
	callInfo := struct {
		Ctx     context.Context
		Name    string
		Handler v31.NamespacedDockerCredentialHandlerFunc
	}{
		Ctx:     ctx,
		Name:    name,
		Handler: handler,
	}
	lockNamespacedDockerCredentialControllerMockAddHandler.Lock()
	mock.calls.AddHandler = append(mock.calls.AddHandler, callInfo)
	lockNamespacedDockerCredentialControllerMockAddHandler.Unlock()
	mock.AddHandlerFunc(ctx, name, handler)
}

// AddHandlerCalls gets all the calls that were made to AddHandler.
// Check the length with:
//     len(mockedNamespacedDockerCredentialController.AddHandlerCalls())
func (mock *NamespacedDockerCredentialControllerMock) AddHandlerCalls() []struct {
	Ctx     context.Context
	Name    string
	Handler v31.NamespacedDockerCredentialHandlerFunc
} {
	var calls []struct {
		Ctx     context.Context
		Name    string
		Handler v31.NamespacedDockerCredentialHandlerFunc
	}
	lockNamespacedDockerCredentialControllerMockAddHandler.RLock()
	calls = mock.calls.AddHandler
	lockNamespacedDockerCredentialControllerMockAddHandler.RUnlock()
	return calls
}

// Enqueue calls EnqueueFunc.
func (mock *NamespacedDockerCredentialControllerMock) Enqueue(namespace string, name string) {
	if mock.EnqueueFunc == nil {
		panic("NamespacedDockerCredentialControllerMock.EnqueueFunc: method is nil but NamespacedDockerCredentialController.Enqueue was just called")
	}
	callInfo := struct {
		Namespace string
		Name      string
	}{
		Namespace: namespace,
		Name:      name,
	}
	lockNamespacedDockerCredentialControllerMockEnqueue.Lock()
	mock.calls.Enqueue = append(mock.calls.Enqueue, callInfo)
	lockNamespacedDockerCredentialControllerMockEnqueue.Unlock()
	mock.EnqueueFunc(namespace, name)
}

// EnqueueCalls gets all the calls that were made to Enqueue.
// Check the length with:
//     len(mockedNamespacedDockerCredentialController.EnqueueCalls())
func (mock *NamespacedDockerCredentialControllerMock) EnqueueCalls() []struct {
	Namespace string
	Name      string
} {
	var calls []struct {
		Namespace string
		Name      string
	}
	lockNamespacedDockerCredentialControllerMockEnqueue.RLock()
	calls = mock.calls.Enqueue
	lockNamespacedDockerCredentialControllerMockEnqueue.RUnlock()
	return calls
}

// EnqueueAfter calls EnqueueAfterFunc.
func (mock *NamespacedDockerCredentialControllerMock) EnqueueAfter(namespace string, name string, after time.Duration) {
	if mock.EnqueueAfterFunc == nil {
		panic("NamespacedDockerCredentialControllerMock.EnqueueAfterFunc: method is nil but NamespacedDockerCredentialController.EnqueueAfter was just called")
	}
	callInfo := struct {
		Namespace string
		Name      string
		After     time.Duration
	}{
		Namespace: namespace,
		Name:      name,
		After:     after,
	}
	lockNamespacedDockerCredentialControllerMockEnqueueAfter.Lock()
	mock.calls.EnqueueAfter = append(mock.calls.EnqueueAfter, callInfo)
	lockNamespacedDockerCredentialControllerMockEnqueueAfter.Unlock()
	mock.EnqueueAfterFunc(namespace, name, after)
}

// EnqueueAfterCalls gets all the calls that were made to EnqueueAfter.
// Check the length with:
//     len(mockedNamespacedDockerCredentialController.EnqueueAfterCalls())
func (mock *NamespacedDockerCredentialControllerMock) EnqueueAfterCalls() []struct {
	Namespace string
	Name      string
	After     time.Duration
} {
	var calls []struct {
		Namespace string
		Name      string
		After     time.Duration
	}
	lockNamespacedDockerCredentialControllerMockEnqueueAfter.RLock()
	calls = mock.calls.EnqueueAfter
	lockNamespacedDockerCredentialControllerMockEnqueueAfter.RUnlock()
	return calls
}

// Generic calls GenericFunc.
func (mock *NamespacedDockerCredentialControllerMock) Generic() controller.GenericController {
	if mock.GenericFunc == nil {
		panic("NamespacedDockerCredentialControllerMock.GenericFunc: method is nil but NamespacedDockerCredentialController.Generic was just called")
	}
	callInfo := struct {
	}{}
	lockNamespacedDockerCredentialControllerMockGeneric.Lock()
	mock.calls.Generic = append(mock.calls.Generic, callInfo)
	lockNamespacedDockerCredentialControllerMockGeneric.Unlock()
	return mock.GenericFunc()
}

// GenericCalls gets all the calls that were made to Generic.
// Check the length with:
//     len(mockedNamespacedDockerCredentialController.GenericCalls())
func (mock *NamespacedDockerCredentialControllerMock) GenericCalls() []struct {
} {
	var calls []struct {
	}
	lockNamespacedDockerCredentialControllerMockGeneric.RLock()
	calls = mock.calls.Generic
	lockNamespacedDockerCredentialControllerMockGeneric.RUnlock()
	return calls
}

// Informer calls InformerFunc.
func (mock *NamespacedDockerCredentialControllerMock) Informer() cache.SharedIndexInformer {
	if mock.InformerFunc == nil {
		panic("NamespacedDockerCredentialControllerMock.InformerFunc: method is nil but NamespacedDockerCredentialController.Informer was just called")
	}
	callInfo := struct {
	}{}
	lockNamespacedDockerCredentialControllerMockInformer.Lock()
	mock.calls.Informer = append(mock.calls.Informer, callInfo)
	lockNamespacedDockerCredentialControllerMockInformer.Unlock()
	return mock.InformerFunc()
}

// InformerCalls gets all the calls that were made to Informer.
// Check the length with:
//     len(mockedNamespacedDockerCredentialController.InformerCalls())
func (mock *NamespacedDockerCredentialControllerMock) InformerCalls() []struct {
} {
	var calls []struct {
	}
	lockNamespacedDockerCredentialControllerMockInformer.RLock()
	calls = mock.calls.Informer
	lockNamespacedDockerCredentialControllerMockInformer.RUnlock()
	return calls
}

// Lister calls ListerFunc.
func (mock *NamespacedDockerCredentialControllerMock) Lister() v31.NamespacedDockerCredentialLister {
	if mock.ListerFunc == nil {
		panic("NamespacedDockerCredentialControllerMock.ListerFunc: method is nil but NamespacedDockerCredentialController.Lister was just called")
	}
	callInfo := struct {
	}{}
	lockNamespacedDockerCredentialControllerMockLister.Lock()
	mock.calls.Lister = append(mock.calls.Lister, callInfo)
	lockNamespacedDockerCredentialControllerMockLister.Unlock()
	return mock.ListerFunc()
}

// ListerCalls gets all the calls that were made to Lister.
// Check the length with:
//     len(mockedNamespacedDockerCredentialController.ListerCalls())
func (mock *NamespacedDockerCredentialControllerMock) ListerCalls() []struct {
} {
	var calls []struct {
	}
	lockNamespacedDockerCredentialControllerMockLister.RLock()
	calls = mock.calls.Lister
	lockNamespacedDockerCredentialControllerMockLister.RUnlock()
	return calls
}

var (
	lockNamespacedDockerCredentialInterfaceMockAddClusterScopedFeatureHandler   sync.RWMutex
	lockNamespacedDockerCredentialInterfaceMockAddClusterScopedFeatureLifecycle sync.RWMutex
	lockNamespacedDockerCredentialInterfaceMockAddClusterScopedHandler          sync.RWMutex
	lockNamespacedDockerCredentialInterfaceMockAddClusterScopedLifecycle        sync.RWMutex
	lockNamespacedDockerCredentialInterfaceMockAddFeatureHandler                sync.RWMutex
	lockNamespacedDockerCredentialInterfaceMockAddFeatureLifecycle              sync.RWMutex
	lockNamespacedDockerCredentialInterfaceMockAddHandler                       sync.RWMutex
	lockNamespacedDockerCredentialInterfaceMockAddLifecycle                     sync.RWMutex
	lockNamespacedDockerCredentialInterfaceMockController                       sync.RWMutex
	lockNamespacedDockerCredentialInterfaceMockCreate                           sync.RWMutex
	lockNamespacedDockerCredentialInterfaceMockDelete                           sync.RWMutex
	lockNamespacedDockerCredentialInterfaceMockDeleteCollection                 sync.RWMutex
	lockNamespacedDockerCredentialInterfaceMockDeleteNamespaced                 sync.RWMutex
	lockNamespacedDockerCredentialInterfaceMockGet                              sync.RWMutex
	lockNamespacedDockerCredentialInterfaceMockGetNamespaced                    sync.RWMutex
	lockNamespacedDockerCredentialInterfaceMockList                             sync.RWMutex
	lockNamespacedDockerCredentialInterfaceMockListNamespaced                   sync.RWMutex
	lockNamespacedDockerCredentialInterfaceMockObjectClient                     sync.RWMutex
	lockNamespacedDockerCredentialInterfaceMockUpdate                           sync.RWMutex
	lockNamespacedDockerCredentialInterfaceMockWatch                            sync.RWMutex
)

// Ensure, that NamespacedDockerCredentialInterfaceMock does implement v31.NamespacedDockerCredentialInterface.
// If this is not the case, regenerate this file with moq.
var _ v31.NamespacedDockerCredentialInterface = &NamespacedDockerCredentialInterfaceMock{}

// NamespacedDockerCredentialInterfaceMock is a mock implementation of v31.NamespacedDockerCredentialInterface.
//
//     func TestSomethingThatUsesNamespacedDockerCredentialInterface(t *testing.T) {
//
//         // make and configure a mocked v31.NamespacedDockerCredentialInterface
//         mockedNamespacedDockerCredentialInterface := &NamespacedDockerCredentialInterfaceMock{
//             AddClusterScopedFeatureHandlerFunc: func(ctx context.Context, enabled func() bool, name string, clusterName string, syncMoqParam v31.NamespacedDockerCredentialHandlerFunc)  {
// 	               panic("mock out the AddClusterScopedFeatureHandler method")
//             },
//             AddClusterScopedFeatureLifecycleFunc: func(ctx context.Context, enabled func() bool, name string, clusterName string, lifecycle v31.NamespacedDockerCredentialLifecycle)  {
// 	               panic("mock out the AddClusterScopedFeatureLifecycle method")
//             },
//             AddClusterScopedHandlerFunc: func(ctx context.Context, name string, clusterName string, syncMoqParam v31.NamespacedDockerCredentialHandlerFunc)  {
// 	               panic("mock out the AddClusterScopedHandler method")
//             },
//             AddClusterScopedLifecycleFunc: func(ctx context.Context, name string, clusterName string, lifecycle v31.NamespacedDockerCredentialLifecycle)  {
// 	               panic("mock out the AddClusterScopedLifecycle method")
//             },
//             AddFeatureHandlerFunc: func(ctx context.Context, enabled func() bool, name string, syncMoqParam v31.NamespacedDockerCredentialHandlerFunc)  {
// 	               panic("mock out the AddFeatureHandler method")
//             },
//             AddFeatureLifecycleFunc: func(ctx context.Context, enabled func() bool, name string, lifecycle v31.NamespacedDockerCredentialLifecycle)  {
// 	               panic("mock out the AddFeatureLifecycle method")
//             },
//             AddHandlerFunc: func(ctx context.Context, name string, syncMoqParam v31.NamespacedDockerCredentialHandlerFunc)  {
// 	               panic("mock out the AddHandler method")
//             },
//             AddLifecycleFunc: func(ctx context.Context, name string, lifecycle v31.NamespacedDockerCredentialLifecycle)  {
// 	               panic("mock out the AddLifecycle method")
//             },
//             ControllerFunc: func() v31.NamespacedDockerCredentialController {
// 	               panic("mock out the Controller method")
//             },
//             CreateFunc: func(in1 *v3.NamespacedDockerCredential) (*v3.NamespacedDockerCredential, error) {
// 	               panic("mock out the Create method")
//             },
//             DeleteFunc: func(name string, options *metav1.DeleteOptions) error {
// 	               panic("mock out the Delete method")
//             },
//             DeleteCollectionFunc: func(deleteOpts *metav1.DeleteOptions, listOpts metav1.ListOptions) error {
// 	               panic("mock out the DeleteCollection method")
//             },
//             DeleteNamespacedFunc: func(namespace string, name string, options *metav1.DeleteOptions) error {
// 	               panic("mock out the DeleteNamespaced method")
//             },
//             GetFunc: func(name string, opts metav1.GetOptions) (*v3.NamespacedDockerCredential, error) {
// 	               panic("mock out the Get method")
//             },
//             GetNamespacedFunc: func(namespace string, name string, opts metav1.GetOptions) (*v3.NamespacedDockerCredential, error) {
// 	               panic("mock out the GetNamespaced method")
//             },
//             ListFunc: func(opts metav1.ListOptions) (*v3.NamespacedDockerCredentialList, error) {
// 	               panic("mock out the List method")
//             },
//             ListNamespacedFunc: func(namespace string, opts metav1.ListOptions) (*v3.NamespacedDockerCredentialList, error) {
// 	               panic("mock out the ListNamespaced method")
//             },
//             ObjectClientFunc: func() *objectclient.ObjectClient {
// 	               panic("mock out the ObjectClient method")
//             },
//             UpdateFunc: func(in1 *v3.NamespacedDockerCredential) (*v3.NamespacedDockerCredential, error) {
// 	               panic("mock out the Update method")
//             },
//             WatchFunc: func(opts metav1.ListOptions) (watch.Interface, error) {
// 	               panic("mock out the Watch method")
//             },
//         }
//
//         // use mockedNamespacedDockerCredentialInterface in code that requires v31.NamespacedDockerCredentialInterface
//         // and then make assertions.
//
//     }
type NamespacedDockerCredentialInterfaceMock struct {
	// AddClusterScopedFeatureHandlerFunc mocks the AddClusterScopedFeatureHandler method.
	AddClusterScopedFeatureHandlerFunc func(ctx context.Context, enabled func() bool, name string, clusterName string, syncMoqParam v31.NamespacedDockerCredentialHandlerFunc)

	// AddClusterScopedFeatureLifecycleFunc mocks the AddClusterScopedFeatureLifecycle method.
	AddClusterScopedFeatureLifecycleFunc func(ctx context.Context, enabled func() bool, name string, clusterName string, lifecycle v31.NamespacedDockerCredentialLifecycle)

	// AddClusterScopedHandlerFunc mocks the AddClusterScopedHandler method.
	AddClusterScopedHandlerFunc func(ctx context.Context, name string, clusterName string, syncMoqParam v31.NamespacedDockerCredentialHandlerFunc)

	// AddClusterScopedLifecycleFunc mocks the AddClusterScopedLifecycle method.
	AddClusterScopedLifecycleFunc func(ctx context.Context, name string, clusterName string, lifecycle v31.NamespacedDockerCredentialLifecycle)

	// AddFeatureHandlerFunc mocks the AddFeatureHandler method.
	AddFeatureHandlerFunc func(ctx context.Context, enabled func() bool, name string, syncMoqParam v31.NamespacedDockerCredentialHandlerFunc)

	// AddFeatureLifecycleFunc mocks the AddFeatureLifecycle method.
	AddFeatureLifecycleFunc func(ctx context.Context, enabled func() bool, name string, lifecycle v31.NamespacedDockerCredentialLifecycle)

	// AddHandlerFunc mocks the AddHandler method.
	AddHandlerFunc func(ctx context.Context, name string, syncMoqParam v31.NamespacedDockerCredentialHandlerFunc)

	// AddLifecycleFunc mocks the AddLifecycle method.
	AddLifecycleFunc func(ctx context.Context, name string, lifecycle v31.NamespacedDockerCredentialLifecycle)

	// ControllerFunc mocks the Controller method.
	ControllerFunc func() v31.NamespacedDockerCredentialController

	// CreateFunc mocks the Create method.
	CreateFunc func(in1 *v3.NamespacedDockerCredential) (*v3.NamespacedDockerCredential, error)

	// DeleteFunc mocks the Delete method.
	DeleteFunc func(name string, options *metav1.DeleteOptions) error

	// DeleteCollectionFunc mocks the DeleteCollection method.
	DeleteCollectionFunc func(deleteOpts *metav1.DeleteOptions, listOpts metav1.ListOptions) error

	// DeleteNamespacedFunc mocks the DeleteNamespaced method.
	DeleteNamespacedFunc func(namespace string, name string, options *metav1.DeleteOptions) error

	// GetFunc mocks the Get method.
	GetFunc func(name string, opts metav1.GetOptions) (*v3.NamespacedDockerCredential, error)

	// GetNamespacedFunc mocks the GetNamespaced method.
	GetNamespacedFunc func(namespace string, name string, opts metav1.GetOptions) (*v3.NamespacedDockerCredential, error)

	// ListFunc mocks the List method.
	ListFunc func(opts metav1.ListOptions) (*v3.NamespacedDockerCredentialList, error)

	// ListNamespacedFunc mocks the ListNamespaced method.
	ListNamespacedFunc func(namespace string, opts metav1.ListOptions) (*v3.NamespacedDockerCredentialList, error)

	// ObjectClientFunc mocks the ObjectClient method.
	ObjectClientFunc func() *objectclient.ObjectClient

	// UpdateFunc mocks the Update method.
	UpdateFunc func(in1 *v3.NamespacedDockerCredential) (*v3.NamespacedDockerCredential, error)

	// WatchFunc mocks the Watch method.
	WatchFunc func(opts metav1.ListOptions) (watch.Interface, error)

	// calls tracks calls to the methods.
	calls struct {
		// AddClusterScopedFeatureHandler holds details about calls to the AddClusterScopedFeatureHandler method.
		AddClusterScopedFeatureHandler []struct {
			// Ctx is the ctx argument value.
			Ctx context.Context
			// Enabled is the enabled argument value.
			Enabled func() bool
			// Name is the name argument value.
			Name string
			// ClusterName is the clusterName argument value.
			ClusterName string
			// Sync is the sync argument value.
			Sync v31.NamespacedDockerCredentialHandlerFunc
		}
		// AddClusterScopedFeatureLifecycle holds details about calls to the AddClusterScopedFeatureLifecycle method.
		AddClusterScopedFeatureLifecycle []struct {
			// Ctx is the ctx argument value.
			Ctx context.Context
			// Enabled is the enabled argument value.
			Enabled func() bool
			// Name is the name argument value.
			Name string
			// ClusterName is the clusterName argument value.
			ClusterName string
			// Lifecycle is the lifecycle argument value.
			Lifecycle v31.NamespacedDockerCredentialLifecycle
		}
		// AddClusterScopedHandler holds details about calls to the AddClusterScopedHandler method.
		AddClusterScopedHandler []struct {
			// Ctx is the ctx argument value.
			Ctx context.Context
			// Name is the name argument value.
			Name string
			// ClusterName is the clusterName argument value.
			ClusterName string
			// Sync is the sync argument value.
			Sync v31.NamespacedDockerCredentialHandlerFunc
		}
		// AddClusterScopedLifecycle holds details about calls to the AddClusterScopedLifecycle method.
		AddClusterScopedLifecycle []struct {
			// Ctx is the ctx argument value.
			Ctx context.Context
			// Name is the name argument value.
			Name string
			// ClusterName is the clusterName argument value.
			ClusterName string
			// Lifecycle is the lifecycle argument value.
			Lifecycle v31.NamespacedDockerCredentialLifecycle
		}
		// AddFeatureHandler holds details about calls to the AddFeatureHandler method.
		AddFeatureHandler []struct {
			// Ctx is the ctx argument value.
			Ctx context.Context
			// Enabled is the enabled argument value.
			Enabled func() bool
			// Name is the name argument value.
			Name string
			// Sync is the sync argument value.
			Sync v31.NamespacedDockerCredentialHandlerFunc
		}
		// AddFeatureLifecycle holds details about calls to the AddFeatureLifecycle method.
		AddFeatureLifecycle []struct {
			// Ctx is the ctx argument value.
			Ctx context.Context
			// Enabled is the enabled argument value.
			Enabled func() bool
			// Name is the name argument value.
			Name string
			// Lifecycle is the lifecycle argument value.
			Lifecycle v31.NamespacedDockerCredentialLifecycle
		}
		// AddHandler holds details about calls to the AddHandler method.
		AddHandler []struct {
			// Ctx is the ctx argument value.
			Ctx context.Context
			// Name is the name argument value.
			Name string
			// Sync is the sync argument value.
			Sync v31.NamespacedDockerCredentialHandlerFunc
		}
		// AddLifecycle holds details about calls to the AddLifecycle method.
		AddLifecycle []struct {
			// Ctx is the ctx argument value.
			Ctx context.Context
			// Name is the name argument value.
			Name string
			// Lifecycle is the lifecycle argument value.
			Lifecycle v31.NamespacedDockerCredentialLifecycle
		}
		// Controller holds details about calls to the Controller method.
		Controller []struct {
		}
		// Create holds details about calls to the Create method.
		Create []struct {
			// In1 is the in1 argument value.
			In1 *v3.NamespacedDockerCredential
		}
		// Delete holds details about calls to the Delete method.
		Delete []struct {
			// Name is the name argument value.
			Name string
			// Options is the options argument value.
			Options *metav1.DeleteOptions
		}
		// DeleteCollection holds details about calls to the DeleteCollection method.
		DeleteCollection []struct {
			// DeleteOpts is the deleteOpts argument value.
			DeleteOpts *metav1.DeleteOptions
			// ListOpts is the listOpts argument value.
			ListOpts metav1.ListOptions
		}
		// DeleteNamespaced holds details about calls to the DeleteNamespaced method.
		DeleteNamespaced []struct {
			// Namespace is the namespace argument value.
			Namespace string
			// Name is the name argument value.
			Name string
			// Options is the options argument value.
			Options *metav1.DeleteOptions
		}
		// Get holds details about calls to the Get method.
		Get []struct {
			// Name is the name argument value.
			Name string
			// Opts is the opts argument value.
			Opts metav1.GetOptions
		}
		// GetNamespaced holds details about calls to the GetNamespaced method.
		GetNamespaced []struct {
			// Namespace is the namespace argument value.
			Namespace string
			// Name is the name argument value.
			Name string
			// Opts is the opts argument value.
			Opts metav1.GetOptions
		}
		// List holds details about calls to the List method.
		List []struct {
			// Opts is the opts argument value.
			Opts metav1.ListOptions
		}
		// ListNamespaced holds details about calls to the ListNamespaced method.
		ListNamespaced []struct {
			// Namespace is the namespace argument value.
			Namespace string
			// Opts is the opts argument value.
			Opts metav1.ListOptions
		}
		// ObjectClient holds details about calls to the ObjectClient method.
		ObjectClient []struct {
		}
		// Update holds details about calls to the Update method.
		Update []struct {
			// In1 is the in1 argument value.
			In1 *v3.NamespacedDockerCredential
		}
		// Watch holds details about calls to the Watch method.
		Watch []struct {
			// Opts is the opts argument value.
			Opts metav1.ListOptions
		}
	}
}

// AddClusterScopedFeatureHandler calls AddClusterScopedFeatureHandlerFunc.
func (mock *NamespacedDockerCredentialInterfaceMock) AddClusterScopedFeatureHandler(ctx context.Context, enabled func() bool, name string, clusterName string, syncMoqParam v31.NamespacedDockerCredentialHandlerFunc) {
	if mock.AddClusterScopedFeatureHandlerFunc == nil {
		panic("NamespacedDockerCredentialInterfaceMock.AddClusterScopedFeatureHandlerFunc: method is nil but NamespacedDockerCredentialInterface.AddClusterScopedFeatureHandler was just called")
	}
	callInfo := struct {
		Ctx         context.Context
		Enabled     func() bool
		Name        string
		ClusterName string
		Sync        v31.NamespacedDockerCredentialHandlerFunc
	}{
		Ctx:         ctx,
		Enabled:     enabled,
		Name:        name,
		ClusterName: clusterName,
		Sync:        syncMoqParam,
	}
	lockNamespacedDockerCredentialInterfaceMockAddClusterScopedFeatureHandler.Lock()
	mock.calls.AddClusterScopedFeatureHandler = append(mock.calls.AddClusterScopedFeatureHandler, callInfo)
	lockNamespacedDockerCredentialInterfaceMockAddClusterScopedFeatureHandler.Unlock()
	mock.AddClusterScopedFeatureHandlerFunc(ctx, enabled, name, clusterName, syncMoqParam)
}

// AddClusterScopedFeatureHandlerCalls gets all the calls that were made to AddClusterScopedFeatureHandler.
// Check the length with:
//     len(mockedNamespacedDockerCredentialInterface.AddClusterScopedFeatureHandlerCalls())
func (mock *NamespacedDockerCredentialInterfaceMock) AddClusterScopedFeatureHandlerCalls() []struct {
	Ctx         context.Context
	Enabled     func() bool
	Name        string
	ClusterName string
	Sync        v31.NamespacedDockerCredentialHandlerFunc
} {
	var calls []struct {
		Ctx         context.Context
		Enabled     func() bool
		Name        string
		ClusterName string
		Sync        v31.NamespacedDockerCredentialHandlerFunc
	}
	lockNamespacedDockerCredentialInterfaceMockAddClusterScopedFeatureHandler.RLock()
	calls = mock.calls.AddClusterScopedFeatureHandler
	lockNamespacedDockerCredentialInterfaceMockAddClusterScopedFeatureHandler.RUnlock()
	return calls
}

// AddClusterScopedFeatureLifecycle calls AddClusterScopedFeatureLifecycleFunc.
func (mock *NamespacedDockerCredentialInterfaceMock) AddClusterScopedFeatureLifecycle(ctx context.Context, enabled func() bool, name string, clusterName string, lifecycle v31.NamespacedDockerCredentialLifecycle) {
	if mock.AddClusterScopedFeatureLifecycleFunc == nil {
		panic("NamespacedDockerCredentialInterfaceMock.AddClusterScopedFeatureLifecycleFunc: method is nil but NamespacedDockerCredentialInterface.AddClusterScopedFeatureLifecycle was just called")
	}
	callInfo := struct {
		Ctx         context.Context
		Enabled     func() bool
		Name        string
		ClusterName string
		Lifecycle   v31.NamespacedDockerCredentialLifecycle
	}{
		Ctx:         ctx,
		Enabled:     enabled,
		Name:        name,
		ClusterName: clusterName,
		Lifecycle:   lifecycle,
	}
	lockNamespacedDockerCredentialInterfaceMockAddClusterScopedFeatureLifecycle.Lock()
	mock.calls.AddClusterScopedFeatureLifecycle = append(mock.calls.AddClusterScopedFeatureLifecycle, callInfo)
	lockNamespacedDockerCredentialInterfaceMockAddClusterScopedFeatureLifecycle.Unlock()
	mock.AddClusterScopedFeatureLifecycleFunc(ctx, enabled, name, clusterName, lifecycle)
}

// AddClusterScopedFeatureLifecycleCalls gets all the calls that were made to AddClusterScopedFeatureLifecycle.
// Check the length with:
//     len(mockedNamespacedDockerCredentialInterface.AddClusterScopedFeatureLifecycleCalls())
func (mock *NamespacedDockerCredentialInterfaceMock) AddClusterScopedFeatureLifecycleCalls() []struct {
	Ctx         context.Context
	Enabled     func() bool
	Name        string
	ClusterName string
	Lifecycle   v31.NamespacedDockerCredentialLifecycle
} {
	var calls []struct {
		Ctx         context.Context
		Enabled     func() bool
		Name        string
		ClusterName string
		Lifecycle   v31.NamespacedDockerCredentialLifecycle
	}
	lockNamespacedDockerCredentialInterfaceMockAddClusterScopedFeatureLifecycle.RLock()
	calls = mock.calls.AddClusterScopedFeatureLifecycle
	lockNamespacedDockerCredentialInterfaceMockAddClusterScopedFeatureLifecycle.RUnlock()
	return calls
}

// AddClusterScopedHandler calls AddClusterScopedHandlerFunc.
func (mock *NamespacedDockerCredentialInterfaceMock) AddClusterScopedHandler(ctx context.Context, name string, clusterName string, syncMoqParam v31.NamespacedDockerCredentialHandlerFunc) {
	if mock.AddClusterScopedHandlerFunc == nil {
		panic("NamespacedDockerCredentialInterfaceMock.AddClusterScopedHandlerFunc: method is nil but NamespacedDockerCredentialInterface.AddClusterScopedHandler was just called")
	}
	callInfo := struct {
		Ctx         context.Context
		Name        string
		ClusterName string
		Sync        v31.NamespacedDockerCredentialHandlerFunc
	}{
		Ctx:         ctx,
		Name:        name,
		ClusterName: clusterName,
		Sync:        syncMoqParam,
	}
	lockNamespacedDockerCredentialInterfaceMockAddClusterScopedHandler.Lock()
	mock.calls.AddClusterScopedHandler = append(mock.calls.AddClusterScopedHandler, callInfo)
	lockNamespacedDockerCredentialInterfaceMockAddClusterScopedHandler.Unlock()
	mock.AddClusterScopedHandlerFunc(ctx, name, clusterName, syncMoqParam)
}

// AddClusterScopedHandlerCalls gets all the calls that were made to AddClusterScopedHandler.
// Check the length with:
//     len(mockedNamespacedDockerCredentialInterface.AddClusterScopedHandlerCalls())
func (mock *NamespacedDockerCredentialInterfaceMock) AddClusterScopedHandlerCalls() []struct {
	Ctx         context.Context
	Name        string
	ClusterName string
	Sync        v31.NamespacedDockerCredentialHandlerFunc
} {
	var calls []struct {
		Ctx         context.Context
		Name        string
		ClusterName string
		Sync        v31.NamespacedDockerCredentialHandlerFunc
	}
	lockNamespacedDockerCredentialInterfaceMockAddClusterScopedHandler.RLock()
	calls = mock.calls.AddClusterScopedHandler
	lockNamespacedDockerCredentialInterfaceMockAddClusterScopedHandler.RUnlock()
	return calls
}

// AddClusterScopedLifecycle calls AddClusterScopedLifecycleFunc.
func (mock *NamespacedDockerCredentialInterfaceMock) AddClusterScopedLifecycle(ctx context.Context, name string, clusterName string, lifecycle v31.NamespacedDockerCredentialLifecycle) {
	if mock.AddClusterScopedLifecycleFunc == nil {
		panic("NamespacedDockerCredentialInterfaceMock.AddClusterScopedLifecycleFunc: method is nil but NamespacedDockerCredentialInterface.AddClusterScopedLifecycle was just called")
	}
	callInfo := struct {
		Ctx         context.Context
		Name        string
		ClusterName string
		Lifecycle   v31.NamespacedDockerCredentialLifecycle
	}{
		Ctx:         ctx,
		Name:        name,
		ClusterName: clusterName,
		Lifecycle:   lifecycle,
	}
	lockNamespacedDockerCredentialInterfaceMockAddClusterScopedLifecycle.Lock()
	mock.calls.AddClusterScopedLifecycle = append(mock.calls.AddClusterScopedLifecycle, callInfo)
	lockNamespacedDockerCredentialInterfaceMockAddClusterScopedLifecycle.Unlock()
	mock.AddClusterScopedLifecycleFunc(ctx, name, clusterName, lifecycle)
}

// AddClusterScopedLifecycleCalls gets all the calls that were made to AddClusterScopedLifecycle.
// Check the length with:
//     len(mockedNamespacedDockerCredentialInterface.AddClusterScopedLifecycleCalls())
func (mock *NamespacedDockerCredentialInterfaceMock) AddClusterScopedLifecycleCalls() []struct {
	Ctx         context.Context
	Name        string
	ClusterName string
	Lifecycle   v31.NamespacedDockerCredentialLifecycle
} {
	var calls []struct {
		Ctx         context.Context
		Name        string
		ClusterName string
		Lifecycle   v31.NamespacedDockerCredentialLifecycle
	}
	lockNamespacedDockerCredentialInterfaceMockAddClusterScopedLifecycle.RLock()
	calls = mock.calls.AddClusterScopedLifecycle
	lockNamespacedDockerCredentialInterfaceMockAddClusterScopedLifecycle.RUnlock()
	return calls
}

// AddFeatureHandler calls AddFeatureHandlerFunc.
func (mock *NamespacedDockerCredentialInterfaceMock) AddFeatureHandler(ctx context.Context, enabled func() bool, name string, syncMoqParam v31.NamespacedDockerCredentialHandlerFunc) {
	if mock.AddFeatureHandlerFunc == nil {
		panic("NamespacedDockerCredentialInterfaceMock.AddFeatureHandlerFunc: method is nil but NamespacedDockerCredentialInterface.AddFeatureHandler was just called")
	}
	callInfo := struct {
		Ctx     context.Context
		Enabled func() bool
		Name    string
		Sync    v31.NamespacedDockerCredentialHandlerFunc
	}{
		Ctx:     ctx,
		Enabled: enabled,
		Name:    name,
		Sync:    syncMoqParam,
	}
	lockNamespacedDockerCredentialInterfaceMockAddFeatureHandler.Lock()
	mock.calls.AddFeatureHandler = append(mock.calls.AddFeatureHandler, callInfo)
	lockNamespacedDockerCredentialInterfaceMockAddFeatureHandler.Unlock()
	mock.AddFeatureHandlerFunc(ctx, enabled, name, syncMoqParam)
}

// AddFeatureHandlerCalls gets all the calls that were made to AddFeatureHandler.
// Check the length with:
//     len(mockedNamespacedDockerCredentialInterface.AddFeatureHandlerCalls())
func (mock *NamespacedDockerCredentialInterfaceMock) AddFeatureHandlerCalls() []struct {
	Ctx     context.Context
	Enabled func() bool
	Name    string
	Sync    v31.NamespacedDockerCredentialHandlerFunc
} {
	var calls []struct {
		Ctx     context.Context
		Enabled func() bool
		Name    string
		Sync    v31.NamespacedDockerCredentialHandlerFunc
	}
	lockNamespacedDockerCredentialInterfaceMockAddFeatureHandler.RLock()
	calls = mock.calls.AddFeatureHandler
	lockNamespacedDockerCredentialInterfaceMockAddFeatureHandler.RUnlock()
	return calls
}

// AddFeatureLifecycle calls AddFeatureLifecycleFunc.
func (mock *NamespacedDockerCredentialInterfaceMock) AddFeatureLifecycle(ctx context.Context, enabled func() bool, name string, lifecycle v31.NamespacedDockerCredentialLifecycle) {
	if mock.AddFeatureLifecycleFunc == nil {
		panic("NamespacedDockerCredentialInterfaceMock.AddFeatureLifecycleFunc: method is nil but NamespacedDockerCredentialInterface.AddFeatureLifecycle was just called")
	}
	callInfo := struct {
		Ctx       context.Context
		Enabled   func() bool
		Name      string
		Lifecycle v31.NamespacedDockerCredentialLifecycle
	}{
		Ctx:       ctx,
		Enabled:   enabled,
		Name:      name,
		Lifecycle: lifecycle,
	}
	lockNamespacedDockerCredentialInterfaceMockAddFeatureLifecycle.Lock()
	mock.calls.AddFeatureLifecycle = append(mock.calls.AddFeatureLifecycle, callInfo)
	lockNamespacedDockerCredentialInterfaceMockAddFeatureLifecycle.Unlock()
	mock.AddFeatureLifecycleFunc(ctx, enabled, name, lifecycle)
}

// AddFeatureLifecycleCalls gets all the calls that were made to AddFeatureLifecycle.
// Check the length with:
//     len(mockedNamespacedDockerCredentialInterface.AddFeatureLifecycleCalls())
func (mock *NamespacedDockerCredentialInterfaceMock) AddFeatureLifecycleCalls() []struct {
	Ctx       context.Context
	Enabled   func() bool
	Name      string
	Lifecycle v31.NamespacedDockerCredentialLifecycle
} {
	var calls []struct {
		Ctx       context.Context
		Enabled   func() bool
		Name      string
		Lifecycle v31.NamespacedDockerCredentialLifecycle
	}
	lockNamespacedDockerCredentialInterfaceMockAddFeatureLifecycle.RLock()
	calls = mock.calls.AddFeatureLifecycle
	lockNamespacedDockerCredentialInterfaceMockAddFeatureLifecycle.RUnlock()
	return calls
}

// AddHandler calls AddHandlerFunc.
func (mock *NamespacedDockerCredentialInterfaceMock) AddHandler(ctx context.Context, name string, syncMoqParam v31.NamespacedDockerCredentialHandlerFunc) {
	if mock.AddHandlerFunc == nil {
		panic("NamespacedDockerCredentialInterfaceMock.AddHandlerFunc: method is nil but NamespacedDockerCredentialInterface.AddHandler was just called")
	}
	callInfo := struct {
		Ctx  context.Context
		Name string
		Sync v31.NamespacedDockerCredentialHandlerFunc
	}{
		Ctx:  ctx,
		Name: name,
		Sync: syncMoqParam,
	}
	lockNamespacedDockerCredentialInterfaceMockAddHandler.Lock()
	mock.calls.AddHandler = append(mock.calls.AddHandler, callInfo)
	lockNamespacedDockerCredentialInterfaceMockAddHandler.Unlock()
	mock.AddHandlerFunc(ctx, name, syncMoqParam)
}

// AddHandlerCalls gets all the calls that were made to AddHandler.
// Check the length with:
//     len(mockedNamespacedDockerCredentialInterface.AddHandlerCalls())
func (mock *NamespacedDockerCredentialInterfaceMock) AddHandlerCalls() []struct {
	Ctx  context.Context
	Name string
	Sync v31.NamespacedDockerCredentialHandlerFunc
} {
	var calls []struct {
		Ctx  context.Context
		Name string
		Sync v31.NamespacedDockerCredentialHandlerFunc
	}
	lockNamespacedDockerCredentialInterfaceMockAddHandler.RLock()
	calls = mock.calls.AddHandler
	lockNamespacedDockerCredentialInterfaceMockAddHandler.RUnlock()
	return calls
}

// AddLifecycle calls AddLifecycleFunc.
func (mock *NamespacedDockerCredentialInterfaceMock) AddLifecycle(ctx context.Context, name string, lifecycle v31.NamespacedDockerCredentialLifecycle) {
	if mock.AddLifecycleFunc == nil {
		panic("NamespacedDockerCredentialInterfaceMock.AddLifecycleFunc: method is nil but NamespacedDockerCredentialInterface.AddLifecycle was just called")
	}
	callInfo := struct {
		Ctx       context.Context
		Name      string
		Lifecycle v31.NamespacedDockerCredentialLifecycle
	}{
		Ctx:       ctx,
		Name:      name,
		Lifecycle: lifecycle,
	}
	lockNamespacedDockerCredentialInterfaceMockAddLifecycle.Lock()
	mock.calls.AddLifecycle = append(mock.calls.AddLifecycle, callInfo)
	lockNamespacedDockerCredentialInterfaceMockAddLifecycle.Unlock()
	mock.AddLifecycleFunc(ctx, name, lifecycle)
}

// AddLifecycleCalls gets all the calls that were made to AddLifecycle.
// Check the length with:
//     len(mockedNamespacedDockerCredentialInterface.AddLifecycleCalls())
func (mock *NamespacedDockerCredentialInterfaceMock) AddLifecycleCalls() []struct {
	Ctx       context.Context
	Name      string
	Lifecycle v31.NamespacedDockerCredentialLifecycle
} {
	var calls []struct {
		Ctx       context.Context
		Name      string
		Lifecycle v31.NamespacedDockerCredentialLifecycle
	}
	lockNamespacedDockerCredentialInterfaceMockAddLifecycle.RLock()
	calls = mock.calls.AddLifecycle
	lockNamespacedDockerCredentialInterfaceMockAddLifecycle.RUnlock()
	return calls
}

// Controller calls ControllerFunc.
func (mock *NamespacedDockerCredentialInterfaceMock) Controller() v31.NamespacedDockerCredentialController {
	if mock.ControllerFunc == nil {
		panic("NamespacedDockerCredentialInterfaceMock.ControllerFunc: method is nil but NamespacedDockerCredentialInterface.Controller was just called")
	}
	callInfo := struct {
	}{}
	lockNamespacedDockerCredentialInterfaceMockController.Lock()
	mock.calls.Controller = append(mock.calls.Controller, callInfo)
	lockNamespacedDockerCredentialInterfaceMockController.Unlock()
	return mock.ControllerFunc()
}

// ControllerCalls gets all the calls that were made to Controller.
// Check the length with:
//     len(mockedNamespacedDockerCredentialInterface.ControllerCalls())
func (mock *NamespacedDockerCredentialInterfaceMock) ControllerCalls() []struct {
} {
	var calls []struct {
	}
	lockNamespacedDockerCredentialInterfaceMockController.RLock()
	calls = mock.calls.Controller
	lockNamespacedDockerCredentialInterfaceMockController.RUnlock()
	return calls
}

// Create calls CreateFunc.
func (mock *NamespacedDockerCredentialInterfaceMock) Create(in1 *v3.NamespacedDockerCredential) (*v3.NamespacedDockerCredential, error) {
	if mock.CreateFunc == nil {
		panic("NamespacedDockerCredentialInterfaceMock.CreateFunc: method is nil but NamespacedDockerCredentialInterface.Create was just called")
	}
	callInfo := struct {
		In1 *v3.NamespacedDockerCredential
	}{
		In1: in1,
	}
	lockNamespacedDockerCredentialInterfaceMockCreate.Lock()
	mock.calls.Create = append(mock.calls.Create, callInfo)
	lockNamespacedDockerCredentialInterfaceMockCreate.Unlock()
	return mock.CreateFunc(in1)
}

// CreateCalls gets all the calls that were made to Create.
// Check the length with:
//     len(mockedNamespacedDockerCredentialInterface.CreateCalls())
func (mock *NamespacedDockerCredentialInterfaceMock) CreateCalls() []struct {
	In1 *v3.NamespacedDockerCredential
} {
	var calls []struct {
		In1 *v3.NamespacedDockerCredential
	}
	lockNamespacedDockerCredentialInterfaceMockCreate.RLock()
	calls = mock.calls.Create
	lockNamespacedDockerCredentialInterfaceMockCreate.RUnlock()
	return calls
}

// Delete calls DeleteFunc.
func (mock *NamespacedDockerCredentialInterfaceMock) Delete(name string, options *metav1.DeleteOptions) error {
	if mock.DeleteFunc == nil {
		panic("NamespacedDockerCredentialInterfaceMock.DeleteFunc: method is nil but NamespacedDockerCredentialInterface.Delete was just called")
	}
	callInfo := struct {
		Name    string
		Options *metav1.DeleteOptions
	}{
		Name:    name,
		Options: options,
	}
	lockNamespacedDockerCredentialInterfaceMockDelete.Lock()
	mock.calls.Delete = append(mock.calls.Delete, callInfo)
	lockNamespacedDockerCredentialInterfaceMockDelete.Unlock()
	return mock.DeleteFunc(name, options)
}

// DeleteCalls gets all the calls that were made to Delete.
// Check the length with:
//     len(mockedNamespacedDockerCredentialInterface.DeleteCalls())
func (mock *NamespacedDockerCredentialInterfaceMock) DeleteCalls() []struct {
	Name    string
	Options *metav1.DeleteOptions
} {
	var calls []struct {
		Name    string
		Options *metav1.DeleteOptions
	}
	lockNamespacedDockerCredentialInterfaceMockDelete.RLock()
	calls = mock.calls.Delete
	lockNamespacedDockerCredentialInterfaceMockDelete.RUnlock()
	return calls
}

// DeleteCollection calls DeleteCollectionFunc.
func (mock *NamespacedDockerCredentialInterfaceMock) DeleteCollection(deleteOpts *metav1.DeleteOptions, listOpts metav1.ListOptions) error {
	if mock.DeleteCollectionFunc == nil {
		panic("NamespacedDockerCredentialInterfaceMock.DeleteCollectionFunc: method is nil but NamespacedDockerCredentialInterface.DeleteCollection was just called")
	}
	callInfo := struct {
		DeleteOpts *metav1.DeleteOptions
		ListOpts   metav1.ListOptions
	}{
		DeleteOpts: deleteOpts,
		ListOpts:   listOpts,
	}
	lockNamespacedDockerCredentialInterfaceMockDeleteCollection.Lock()
	mock.calls.DeleteCollection = append(mock.calls.DeleteCollection, callInfo)
	lockNamespacedDockerCredentialInterfaceMockDeleteCollection.Unlock()
	return mock.DeleteCollectionFunc(deleteOpts, listOpts)
}

// DeleteCollectionCalls gets all the calls that were made to DeleteCollection.
// Check the length with:
//     len(mockedNamespacedDockerCredentialInterface.DeleteCollectionCalls())
func (mock *NamespacedDockerCredentialInterfaceMock) DeleteCollectionCalls() []struct {
	DeleteOpts *metav1.DeleteOptions
	ListOpts   metav1.ListOptions
} {
	var calls []struct {
		DeleteOpts *metav1.DeleteOptions
		ListOpts   metav1.ListOptions
	}
	lockNamespacedDockerCredentialInterfaceMockDeleteCollection.RLock()
	calls = mock.calls.DeleteCollection
	lockNamespacedDockerCredentialInterfaceMockDeleteCollection.RUnlock()
	return calls
}

// DeleteNamespaced calls DeleteNamespacedFunc.
func (mock *NamespacedDockerCredentialInterfaceMock) DeleteNamespaced(namespace string, name string, options *metav1.DeleteOptions) error {
	if mock.DeleteNamespacedFunc == nil {
		panic("NamespacedDockerCredentialInterfaceMock.DeleteNamespacedFunc: method is nil but NamespacedDockerCredentialInterface.DeleteNamespaced was just called")
	}
	callInfo := struct {
		Namespace string
		Name      string
		Options   *metav1.DeleteOptions
	}{
		Namespace: namespace,
		Name:      name,
		Options:   options,
	}
	lockNamespacedDockerCredentialInterfaceMockDeleteNamespaced.Lock()
	mock.calls.DeleteNamespaced = append(mock.calls.DeleteNamespaced, callInfo)
	lockNamespacedDockerCredentialInterfaceMockDeleteNamespaced.Unlock()
	return mock.DeleteNamespacedFunc(namespace, name, options)
}

// DeleteNamespacedCalls gets all the calls that were made to DeleteNamespaced.
// Check the length with:
//     len(mockedNamespacedDockerCredentialInterface.DeleteNamespacedCalls())
func (mock *NamespacedDockerCredentialInterfaceMock) DeleteNamespacedCalls() []struct {
	Namespace string
	Name      string
	Options   *metav1.DeleteOptions
} {
	var calls []struct {
		Namespace string
		Name      string
		Options   *metav1.DeleteOptions
	}
	lockNamespacedDockerCredentialInterfaceMockDeleteNamespaced.RLock()
	calls = mock.calls.DeleteNamespaced
	lockNamespacedDockerCredentialInterfaceMockDeleteNamespaced.RUnlock()
	return calls
}

// Get calls GetFunc.
func (mock *NamespacedDockerCredentialInterfaceMock) Get(name string, opts metav1.GetOptions) (*v3.NamespacedDockerCredential, error) {
	if mock.GetFunc == nil {
		panic("NamespacedDockerCredentialInterfaceMock.GetFunc: method is nil but NamespacedDockerCredentialInterface.Get was just called")
	}
	callInfo := struct {
		Name string
		Opts metav1.GetOptions
	}{
		Name: name,
		Opts: opts,
	}
	lockNamespacedDockerCredentialInterfaceMockGet.Lock()
	mock.calls.Get = append(mock.calls.Get, callInfo)
	lockNamespacedDockerCredentialInterfaceMockGet.Unlock()
	return mock.GetFunc(name, opts)
}

// GetCalls gets all the calls that were made to Get.
// Check the length with:
//     len(mockedNamespacedDockerCredentialInterface.GetCalls())
func (mock *NamespacedDockerCredentialInterfaceMock) GetCalls() []struct {
	Name string
	Opts metav1.GetOptions
} {
	var calls []struct {
		Name string
		Opts metav1.GetOptions
	}
	lockNamespacedDockerCredentialInterfaceMockGet.RLock()
	calls = mock.calls.Get
	lockNamespacedDockerCredentialInterfaceMockGet.RUnlock()
	return calls
}

// GetNamespaced calls GetNamespacedFunc.
func (mock *NamespacedDockerCredentialInterfaceMock) GetNamespaced(namespace string, name string, opts metav1.GetOptions) (*v3.NamespacedDockerCredential, error) {
	if mock.GetNamespacedFunc == nil {
		panic("NamespacedDockerCredentialInterfaceMock.GetNamespacedFunc: method is nil but NamespacedDockerCredentialInterface.GetNamespaced was just called")
	}
	callInfo := struct {
		Namespace string
		Name      string
		Opts      metav1.GetOptions
	}{
		Namespace: namespace,
		Name:      name,
		Opts:      opts,
	}
	lockNamespacedDockerCredentialInterfaceMockGetNamespaced.Lock()
	mock.calls.GetNamespaced = append(mock.calls.GetNamespaced, callInfo)
	lockNamespacedDockerCredentialInterfaceMockGetNamespaced.Unlock()
	return mock.GetNamespacedFunc(namespace, name, opts)
}

// GetNamespacedCalls gets all the calls that were made to GetNamespaced.
// Check the length with:
//     len(mockedNamespacedDockerCredentialInterface.GetNamespacedCalls())
func (mock *NamespacedDockerCredentialInterfaceMock) GetNamespacedCalls() []struct {
	Namespace string
	Name      string
	Opts      metav1.GetOptions
} {
	var calls []struct {
		Namespace string
		Name      string
		Opts      metav1.GetOptions
	}
	lockNamespacedDockerCredentialInterfaceMockGetNamespaced.RLock()
	calls = mock.calls.GetNamespaced
	lockNamespacedDockerCredentialInterfaceMockGetNamespaced.RUnlock()
	return calls
}

// List calls ListFunc.
func (mock *NamespacedDockerCredentialInterfaceMock) List(opts metav1.ListOptions) (*v3.NamespacedDockerCredentialList, error) {
	if mock.ListFunc == nil {
		panic("NamespacedDockerCredentialInterfaceMock.ListFunc: method is nil but NamespacedDockerCredentialInterface.List was just called")
	}
	callInfo := struct {
		Opts metav1.ListOptions
	}{
		Opts: opts,
	}
	lockNamespacedDockerCredentialInterfaceMockList.Lock()
	mock.calls.List = append(mock.calls.List, callInfo)
	lockNamespacedDockerCredentialInterfaceMockList.Unlock()
	return mock.ListFunc(opts)
}

// ListCalls gets all the calls that were made to List.
// Check the length with:
//     len(mockedNamespacedDockerCredentialInterface.ListCalls())
func (mock *NamespacedDockerCredentialInterfaceMock) ListCalls() []struct {
	Opts metav1.ListOptions
} {
	var calls []struct {
		Opts metav1.ListOptions
	}
	lockNamespacedDockerCredentialInterfaceMockList.RLock()
	calls = mock.calls.List
	lockNamespacedDockerCredentialInterfaceMockList.RUnlock()
	return calls
}

// ListNamespaced calls ListNamespacedFunc.
func (mock *NamespacedDockerCredentialInterfaceMock) ListNamespaced(namespace string, opts metav1.ListOptions) (*v3.NamespacedDockerCredentialList, error) {
	if mock.ListNamespacedFunc == nil {
		panic("NamespacedDockerCredentialInterfaceMock.ListNamespacedFunc: method is nil but NamespacedDockerCredentialInterface.ListNamespaced was just called")
	}
	callInfo := struct {
		Namespace string
		Opts      metav1.ListOptions
	}{
		Namespace: namespace,
		Opts:      opts,
	}
	lockNamespacedDockerCredentialInterfaceMockListNamespaced.Lock()
	mock.calls.ListNamespaced = append(mock.calls.ListNamespaced, callInfo)
	lockNamespacedDockerCredentialInterfaceMockListNamespaced.Unlock()
	return mock.ListNamespacedFunc(namespace, opts)
}

// ListNamespacedCalls gets all the calls that were made to ListNamespaced.
// Check the length with:
//     len(mockedNamespacedDockerCredentialInterface.ListNamespacedCalls())
func (mock *NamespacedDockerCredentialInterfaceMock) ListNamespacedCalls() []struct {
	Namespace string
	Opts      metav1.ListOptions
} {
	var calls []struct {
		Namespace string
		Opts      metav1.ListOptions
	}
	lockNamespacedDockerCredentialInterfaceMockListNamespaced.RLock()
	calls = mock.calls.ListNamespaced
	lockNamespacedDockerCredentialInterfaceMockListNamespaced.RUnlock()
	return calls
}

// ObjectClient calls ObjectClientFunc.
func (mock *NamespacedDockerCredentialInterfaceMock) ObjectClient() *objectclient.ObjectClient {
	if mock.ObjectClientFunc == nil {
		panic("NamespacedDockerCredentialInterfaceMock.ObjectClientFunc: method is nil but NamespacedDockerCredentialInterface.ObjectClient was just called")
	}
	callInfo := struct {
	}{}
	lockNamespacedDockerCredentialInterfaceMockObjectClient.Lock()
	mock.calls.ObjectClient = append(mock.calls.ObjectClient, callInfo)
	lockNamespacedDockerCredentialInterfaceMockObjectClient.Unlock()
	return mock.ObjectClientFunc()
}

// ObjectClientCalls gets all the calls that were made to ObjectClient.
// Check the length with:
//     len(mockedNamespacedDockerCredentialInterface.ObjectClientCalls())
func (mock *NamespacedDockerCredentialInterfaceMock) ObjectClientCalls() []struct {
} {
	var calls []struct {
	}
	lockNamespacedDockerCredentialInterfaceMockObjectClient.RLock()
	calls = mock.calls.ObjectClient
	lockNamespacedDockerCredentialInterfaceMockObjectClient.RUnlock()
	return calls
}

// Update calls UpdateFunc.
func (mock *NamespacedDockerCredentialInterfaceMock) Update(in1 *v3.NamespacedDockerCredential) (*v3.NamespacedDockerCredential, error) {
	if mock.UpdateFunc == nil {
		panic("NamespacedDockerCredentialInterfaceMock.UpdateFunc: method is nil but NamespacedDockerCredentialInterface.Update was just called")
	}
	callInfo := struct {
		In1 *v3.NamespacedDockerCredential
	}{
		In1: in1,
	}
	lockNamespacedDockerCredentialInterfaceMockUpdate.Lock()
	mock.calls.Update = append(mock.calls.Update, callInfo)
	lockNamespacedDockerCredentialInterfaceMockUpdate.Unlock()
	return mock.UpdateFunc(in1)
}

// UpdateCalls gets all the calls that were made to Update.
// Check the length with:
//     len(mockedNamespacedDockerCredentialInterface.UpdateCalls())
func (mock *NamespacedDockerCredentialInterfaceMock) UpdateCalls() []struct {
	In1 *v3.NamespacedDockerCredential
} {
	var calls []struct {
		In1 *v3.NamespacedDockerCredential
	}
	lockNamespacedDockerCredentialInterfaceMockUpdate.RLock()
	calls = mock.calls.Update
	lockNamespacedDockerCredentialInterfaceMockUpdate.RUnlock()
	return calls
}

// Watch calls WatchFunc.
func (mock *NamespacedDockerCredentialInterfaceMock) Watch(opts metav1.ListOptions) (watch.Interface, error) {
	if mock.WatchFunc == nil {
		panic("NamespacedDockerCredentialInterfaceMock.WatchFunc: method is nil but NamespacedDockerCredentialInterface.Watch was just called")
	}
	callInfo := struct {
		Opts metav1.ListOptions
	}{
		Opts: opts,
	}
	lockNamespacedDockerCredentialInterfaceMockWatch.Lock()
	mock.calls.Watch = append(mock.calls.Watch, callInfo)
	lockNamespacedDockerCredentialInterfaceMockWatch.Unlock()
	return mock.WatchFunc(opts)
}

// WatchCalls gets all the calls that were made to Watch.
// Check the length with:
//     len(mockedNamespacedDockerCredentialInterface.WatchCalls())
func (mock *NamespacedDockerCredentialInterfaceMock) WatchCalls() []struct {
	Opts metav1.ListOptions
} {
	var calls []struct {
		Opts metav1.ListOptions
	}
	lockNamespacedDockerCredentialInterfaceMockWatch.RLock()
	calls = mock.calls.Watch
	lockNamespacedDockerCredentialInterfaceMockWatch.RUnlock()
	return calls
}

var (
	lockNamespacedDockerCredentialsGetterMockNamespacedDockerCredentials sync.RWMutex
)

// Ensure, that NamespacedDockerCredentialsGetterMock does implement v31.NamespacedDockerCredentialsGetter.
// If this is not the case, regenerate this file with moq.
var _ v31.NamespacedDockerCredentialsGetter = &NamespacedDockerCredentialsGetterMock{}

// NamespacedDockerCredentialsGetterMock is a mock implementation of v31.NamespacedDockerCredentialsGetter.
//
//     func TestSomethingThatUsesNamespacedDockerCredentialsGetter(t *testing.T) {
//
//         // make and configure a mocked v31.NamespacedDockerCredentialsGetter
//         mockedNamespacedDockerCredentialsGetter := &NamespacedDockerCredentialsGetterMock{
//             NamespacedDockerCredentialsFunc: func(namespace string) v31.NamespacedDockerCredentialInterface {
// 	               panic("mock out the NamespacedDockerCredentials method")
//             },
//         }
//
//         // use mockedNamespacedDockerCredentialsGetter in code that requires v31.NamespacedDockerCredentialsGetter
//         // and then make assertions.
//
//     }
type NamespacedDockerCredentialsGetterMock struct {
	// NamespacedDockerCredentialsFunc mocks the NamespacedDockerCredentials method.
	NamespacedDockerCredentialsFunc func(namespace string) v31.NamespacedDockerCredentialInterface

	// calls tracks calls to the methods.
	calls struct {
		// NamespacedDockerCredentials holds details about calls to the NamespacedDockerCredentials method.
		NamespacedDockerCredentials []struct {
			// Namespace is the namespace argument value.
			Namespace string
		}
	}
}

// NamespacedDockerCredentials calls NamespacedDockerCredentialsFunc.
func (mock *NamespacedDockerCredentialsGetterMock) NamespacedDockerCredentials(namespace string) v31.NamespacedDockerCredentialInterface {
	if mock.NamespacedDockerCredentialsFunc == nil {
		panic("NamespacedDockerCredentialsGetterMock.NamespacedDockerCredentialsFunc: method is nil but NamespacedDockerCredentialsGetter.NamespacedDockerCredentials was just called")
	}
	callInfo := struct {
		Namespace string
	}{
		Namespace: namespace,
	}
	lockNamespacedDockerCredentialsGetterMockNamespacedDockerCredentials.Lock()
	mock.calls.NamespacedDockerCredentials = append(mock.calls.NamespacedDockerCredentials, callInfo)
	lockNamespacedDockerCredentialsGetterMockNamespacedDockerCredentials.Unlock()
	return mock.NamespacedDockerCredentialsFunc(namespace)
}

// NamespacedDockerCredentialsCalls gets all the calls that were made to NamespacedDockerCredentials.
// Check the length with:
//     len(mockedNamespacedDockerCredentialsGetter.NamespacedDockerCredentialsCalls())
func (mock *NamespacedDockerCredentialsGetterMock) NamespacedDockerCredentialsCalls() []struct {
	Namespace string
} {
	var calls []struct {
		Namespace string
	}
	lockNamespacedDockerCredentialsGetterMockNamespacedDockerCredentials.RLock()
	calls = mock.calls.NamespacedDockerCredentials
	lockNamespacedDockerCredentialsGetterMockNamespacedDockerCredentials.RUnlock()
	return calls
}
