// Code generated by moq; DO NOT EDIT.
// github.com/matryer/moq

package fakes

import (
	"context"
	"sync"
	"time"

	"github.com/rancher/norman/controller"
	"github.com/rancher/norman/objectclient"
	v3 "github.com/rancher/rancher/pkg/apis/project.cattle.io/v3"
	v31 "github.com/rancher/rancher/pkg/generated/norman/project.cattle.io/v3"
	metav1 "k8s.io/apimachinery/pkg/apis/meta/v1"
	"k8s.io/apimachinery/pkg/labels"
	"k8s.io/apimachinery/pkg/watch"
	"k8s.io/client-go/tools/cache"
)

var (
	lockPipelineExecutionListerMockGet  sync.RWMutex
	lockPipelineExecutionListerMockList sync.RWMutex
)

// Ensure, that PipelineExecutionListerMock does implement v31.PipelineExecutionLister.
// If this is not the case, regenerate this file with moq.
var _ v31.PipelineExecutionLister = &PipelineExecutionListerMock{}

// PipelineExecutionListerMock is a mock implementation of v31.PipelineExecutionLister.
//
//     func TestSomethingThatUsesPipelineExecutionLister(t *testing.T) {
//
//         // make and configure a mocked v31.PipelineExecutionLister
//         mockedPipelineExecutionLister := &PipelineExecutionListerMock{
//             GetFunc: func(namespace string, name string) (*v3.PipelineExecution, error) {
// 	               panic("mock out the Get method")
//             },
//             ListFunc: func(namespace string, selector labels.Selector) ([]*v3.PipelineExecution, error) {
// 	               panic("mock out the List method")
//             },
//         }
//
//         // use mockedPipelineExecutionLister in code that requires v31.PipelineExecutionLister
//         // and then make assertions.
//
//     }
type PipelineExecutionListerMock struct {
	// GetFunc mocks the Get method.
	GetFunc func(namespace string, name string) (*v3.PipelineExecution, error)

	// ListFunc mocks the List method.
	ListFunc func(namespace string, selector labels.Selector) ([]*v3.PipelineExecution, error)

	// calls tracks calls to the methods.
	calls struct {
		// Get holds details about calls to the Get method.
		Get []struct {
			// Namespace is the namespace argument value.
			Namespace string
			// Name is the name argument value.
			Name string
		}
		// List holds details about calls to the List method.
		List []struct {
			// Namespace is the namespace argument value.
			Namespace string
			// Selector is the selector argument value.
			Selector labels.Selector
		}
	}
}

// Get calls GetFunc.
func (mock *PipelineExecutionListerMock) Get(namespace string, name string) (*v3.PipelineExecution, error) {
	if mock.GetFunc == nil {
		panic("PipelineExecutionListerMock.GetFunc: method is nil but PipelineExecutionLister.Get was just called")
	}
	callInfo := struct {
		Namespace string
		Name      string
	}{
		Namespace: namespace,
		Name:      name,
	}
	lockPipelineExecutionListerMockGet.Lock()
	mock.calls.Get = append(mock.calls.Get, callInfo)
	lockPipelineExecutionListerMockGet.Unlock()
	return mock.GetFunc(namespace, name)
}

// GetCalls gets all the calls that were made to Get.
// Check the length with:
//     len(mockedPipelineExecutionLister.GetCalls())
func (mock *PipelineExecutionListerMock) GetCalls() []struct {
	Namespace string
	Name      string
} {
	var calls []struct {
		Namespace string
		Name      string
	}
	lockPipelineExecutionListerMockGet.RLock()
	calls = mock.calls.Get
	lockPipelineExecutionListerMockGet.RUnlock()
	return calls
}

// List calls ListFunc.
func (mock *PipelineExecutionListerMock) List(namespace string, selector labels.Selector) ([]*v3.PipelineExecution, error) {
	if mock.ListFunc == nil {
		panic("PipelineExecutionListerMock.ListFunc: method is nil but PipelineExecutionLister.List was just called")
	}
	callInfo := struct {
		Namespace string
		Selector  labels.Selector
	}{
		Namespace: namespace,
		Selector:  selector,
	}
	lockPipelineExecutionListerMockList.Lock()
	mock.calls.List = append(mock.calls.List, callInfo)
	lockPipelineExecutionListerMockList.Unlock()
	return mock.ListFunc(namespace, selector)
}

// ListCalls gets all the calls that were made to List.
// Check the length with:
//     len(mockedPipelineExecutionLister.ListCalls())
func (mock *PipelineExecutionListerMock) ListCalls() []struct {
	Namespace string
	Selector  labels.Selector
} {
	var calls []struct {
		Namespace string
		Selector  labels.Selector
	}
	lockPipelineExecutionListerMockList.RLock()
	calls = mock.calls.List
	lockPipelineExecutionListerMockList.RUnlock()
	return calls
}

var (
	lockPipelineExecutionControllerMockAddClusterScopedFeatureHandler sync.RWMutex
	lockPipelineExecutionControllerMockAddClusterScopedHandler        sync.RWMutex
	lockPipelineExecutionControllerMockAddFeatureHandler              sync.RWMutex
	lockPipelineExecutionControllerMockAddHandler                     sync.RWMutex
	lockPipelineExecutionControllerMockEnqueue                        sync.RWMutex
	lockPipelineExecutionControllerMockEnqueueAfter                   sync.RWMutex
	lockPipelineExecutionControllerMockGeneric                        sync.RWMutex
	lockPipelineExecutionControllerMockInformer                       sync.RWMutex
	lockPipelineExecutionControllerMockLister                         sync.RWMutex
)

// Ensure, that PipelineExecutionControllerMock does implement v31.PipelineExecutionController.
// If this is not the case, regenerate this file with moq.
var _ v31.PipelineExecutionController = &PipelineExecutionControllerMock{}

// PipelineExecutionControllerMock is a mock implementation of v31.PipelineExecutionController.
//
//     func TestSomethingThatUsesPipelineExecutionController(t *testing.T) {
//
//         // make and configure a mocked v31.PipelineExecutionController
//         mockedPipelineExecutionController := &PipelineExecutionControllerMock{
//             AddClusterScopedFeatureHandlerFunc: func(ctx context.Context, enabled func() bool, name string, clusterName string, handler v31.PipelineExecutionHandlerFunc)  {
// 	               panic("mock out the AddClusterScopedFeatureHandler method")
//             },
//             AddClusterScopedHandlerFunc: func(ctx context.Context, name string, clusterName string, handler v31.PipelineExecutionHandlerFunc)  {
// 	               panic("mock out the AddClusterScopedHandler method")
//             },
//             AddFeatureHandlerFunc: func(ctx context.Context, enabled func() bool, name string, syncMoqParam v31.PipelineExecutionHandlerFunc)  {
// 	               panic("mock out the AddFeatureHandler method")
//             },
//             AddHandlerFunc: func(ctx context.Context, name string, handler v31.PipelineExecutionHandlerFunc)  {
// 	               panic("mock out the AddHandler method")
//             },
//             EnqueueFunc: func(namespace string, name string)  {
// 	               panic("mock out the Enqueue method")
//             },
//             EnqueueAfterFunc: func(namespace string, name string, after time.Duration)  {
// 	               panic("mock out the EnqueueAfter method")
//             },
//             GenericFunc: func() controller.GenericController {
// 	               panic("mock out the Generic method")
//             },
//             InformerFunc: func() cache.SharedIndexInformer {
// 	               panic("mock out the Informer method")
//             },
//             ListerFunc: func() v31.PipelineExecutionLister {
// 	               panic("mock out the Lister method")
//             },
//         }
//
//         // use mockedPipelineExecutionController in code that requires v31.PipelineExecutionController
//         // and then make assertions.
//
//     }
type PipelineExecutionControllerMock struct {
	// AddClusterScopedFeatureHandlerFunc mocks the AddClusterScopedFeatureHandler method.
	AddClusterScopedFeatureHandlerFunc func(ctx context.Context, enabled func() bool, name string, clusterName string, handler v31.PipelineExecutionHandlerFunc)

	// AddClusterScopedHandlerFunc mocks the AddClusterScopedHandler method.
	AddClusterScopedHandlerFunc func(ctx context.Context, name string, clusterName string, handler v31.PipelineExecutionHandlerFunc)

	// AddFeatureHandlerFunc mocks the AddFeatureHandler method.
	AddFeatureHandlerFunc func(ctx context.Context, enabled func() bool, name string, syncMoqParam v31.PipelineExecutionHandlerFunc)

	// AddHandlerFunc mocks the AddHandler method.
	AddHandlerFunc func(ctx context.Context, name string, handler v31.PipelineExecutionHandlerFunc)

	// EnqueueFunc mocks the Enqueue method.
	EnqueueFunc func(namespace string, name string)

	// EnqueueAfterFunc mocks the EnqueueAfter method.
	EnqueueAfterFunc func(namespace string, name string, after time.Duration)

	// GenericFunc mocks the Generic method.
	GenericFunc func() controller.GenericController

	// InformerFunc mocks the Informer method.
	InformerFunc func() cache.SharedIndexInformer

	// ListerFunc mocks the Lister method.
	ListerFunc func() v31.PipelineExecutionLister

	// calls tracks calls to the methods.
	calls struct {
		// AddClusterScopedFeatureHandler holds details about calls to the AddClusterScopedFeatureHandler method.
		AddClusterScopedFeatureHandler []struct {
			// Ctx is the ctx argument value.
			Ctx context.Context
			// Enabled is the enabled argument value.
			Enabled func() bool
			// Name is the name argument value.
			Name string
			// ClusterName is the clusterName argument value.
			ClusterName string
			// Handler is the handler argument value.
			Handler v31.PipelineExecutionHandlerFunc
		}
		// AddClusterScopedHandler holds details about calls to the AddClusterScopedHandler method.
		AddClusterScopedHandler []struct {
			// Ctx is the ctx argument value.
			Ctx context.Context
			// Name is the name argument value.
			Name string
			// ClusterName is the clusterName argument value.
			ClusterName string
			// Handler is the handler argument value.
			Handler v31.PipelineExecutionHandlerFunc
		}
		// AddFeatureHandler holds details about calls to the AddFeatureHandler method.
		AddFeatureHandler []struct {
			// Ctx is the ctx argument value.
			Ctx context.Context
			// Enabled is the enabled argument value.
			Enabled func() bool
			// Name is the name argument value.
			Name string
			// Sync is the sync argument value.
			Sync v31.PipelineExecutionHandlerFunc
		}
		// AddHandler holds details about calls to the AddHandler method.
		AddHandler []struct {
			// Ctx is the ctx argument value.
			Ctx context.Context
			// Name is the name argument value.
			Name string
			// Handler is the handler argument value.
			Handler v31.PipelineExecutionHandlerFunc
		}
		// Enqueue holds details about calls to the Enqueue method.
		Enqueue []struct {
			// Namespace is the namespace argument value.
			Namespace string
			// Name is the name argument value.
			Name string
		}
		// EnqueueAfter holds details about calls to the EnqueueAfter method.
		EnqueueAfter []struct {
			// Namespace is the namespace argument value.
			Namespace string
			// Name is the name argument value.
			Name string
			// After is the after argument value.
			After time.Duration
		}
		// Generic holds details about calls to the Generic method.
		Generic []struct {
		}
		// Informer holds details about calls to the Informer method.
		Informer []struct {
		}
		// Lister holds details about calls to the Lister method.
		Lister []struct {
		}
	}
}

// AddClusterScopedFeatureHandler calls AddClusterScopedFeatureHandlerFunc.
func (mock *PipelineExecutionControllerMock) AddClusterScopedFeatureHandler(ctx context.Context, enabled func() bool, name string, clusterName string, handler v31.PipelineExecutionHandlerFunc) {
	if mock.AddClusterScopedFeatureHandlerFunc == nil {
		panic("PipelineExecutionControllerMock.AddClusterScopedFeatureHandlerFunc: method is nil but PipelineExecutionController.AddClusterScopedFeatureHandler was just called")
	}
	callInfo := struct {
		Ctx         context.Context
		Enabled     func() bool
		Name        string
		ClusterName string
		Handler     v31.PipelineExecutionHandlerFunc
	}{
		Ctx:         ctx,
		Enabled:     enabled,
		Name:        name,
		ClusterName: clusterName,
		Handler:     handler,
	}
	lockPipelineExecutionControllerMockAddClusterScopedFeatureHandler.Lock()
	mock.calls.AddClusterScopedFeatureHandler = append(mock.calls.AddClusterScopedFeatureHandler, callInfo)
	lockPipelineExecutionControllerMockAddClusterScopedFeatureHandler.Unlock()
	mock.AddClusterScopedFeatureHandlerFunc(ctx, enabled, name, clusterName, handler)
}

// AddClusterScopedFeatureHandlerCalls gets all the calls that were made to AddClusterScopedFeatureHandler.
// Check the length with:
//     len(mockedPipelineExecutionController.AddClusterScopedFeatureHandlerCalls())
func (mock *PipelineExecutionControllerMock) AddClusterScopedFeatureHandlerCalls() []struct {
	Ctx         context.Context
	Enabled     func() bool
	Name        string
	ClusterName string
	Handler     v31.PipelineExecutionHandlerFunc
} {
	var calls []struct {
		Ctx         context.Context
		Enabled     func() bool
		Name        string
		ClusterName string
		Handler     v31.PipelineExecutionHandlerFunc
	}
	lockPipelineExecutionControllerMockAddClusterScopedFeatureHandler.RLock()
	calls = mock.calls.AddClusterScopedFeatureHandler
	lockPipelineExecutionControllerMockAddClusterScopedFeatureHandler.RUnlock()
	return calls
}

// AddClusterScopedHandler calls AddClusterScopedHandlerFunc.
func (mock *PipelineExecutionControllerMock) AddClusterScopedHandler(ctx context.Context, name string, clusterName string, handler v31.PipelineExecutionHandlerFunc) {
	if mock.AddClusterScopedHandlerFunc == nil {
		panic("PipelineExecutionControllerMock.AddClusterScopedHandlerFunc: method is nil but PipelineExecutionController.AddClusterScopedHandler was just called")
	}
	callInfo := struct {
		Ctx         context.Context
		Name        string
		ClusterName string
		Handler     v31.PipelineExecutionHandlerFunc
	}{
		Ctx:         ctx,
		Name:        name,
		ClusterName: clusterName,
		Handler:     handler,
	}
	lockPipelineExecutionControllerMockAddClusterScopedHandler.Lock()
	mock.calls.AddClusterScopedHandler = append(mock.calls.AddClusterScopedHandler, callInfo)
	lockPipelineExecutionControllerMockAddClusterScopedHandler.Unlock()
	mock.AddClusterScopedHandlerFunc(ctx, name, clusterName, handler)
}

// AddClusterScopedHandlerCalls gets all the calls that were made to AddClusterScopedHandler.
// Check the length with:
//     len(mockedPipelineExecutionController.AddClusterScopedHandlerCalls())
func (mock *PipelineExecutionControllerMock) AddClusterScopedHandlerCalls() []struct {
	Ctx         context.Context
	Name        string
	ClusterName string
	Handler     v31.PipelineExecutionHandlerFunc
} {
	var calls []struct {
		Ctx         context.Context
		Name        string
		ClusterName string
		Handler     v31.PipelineExecutionHandlerFunc
	}
	lockPipelineExecutionControllerMockAddClusterScopedHandler.RLock()
	calls = mock.calls.AddClusterScopedHandler
	lockPipelineExecutionControllerMockAddClusterScopedHandler.RUnlock()
	return calls
}

// AddFeatureHandler calls AddFeatureHandlerFunc.
func (mock *PipelineExecutionControllerMock) AddFeatureHandler(ctx context.Context, enabled func() bool, name string, syncMoqParam v31.PipelineExecutionHandlerFunc) {
	if mock.AddFeatureHandlerFunc == nil {
		panic("PipelineExecutionControllerMock.AddFeatureHandlerFunc: method is nil but PipelineExecutionController.AddFeatureHandler was just called")
	}
	callInfo := struct {
		Ctx     context.Context
		Enabled func() bool
		Name    string
		Sync    v31.PipelineExecutionHandlerFunc
	}{
		Ctx:     ctx,
		Enabled: enabled,
		Name:    name,
		Sync:    syncMoqParam,
	}
	lockPipelineExecutionControllerMockAddFeatureHandler.Lock()
	mock.calls.AddFeatureHandler = append(mock.calls.AddFeatureHandler, callInfo)
	lockPipelineExecutionControllerMockAddFeatureHandler.Unlock()
	mock.AddFeatureHandlerFunc(ctx, enabled, name, syncMoqParam)
}

// AddFeatureHandlerCalls gets all the calls that were made to AddFeatureHandler.
// Check the length with:
//     len(mockedPipelineExecutionController.AddFeatureHandlerCalls())
func (mock *PipelineExecutionControllerMock) AddFeatureHandlerCalls() []struct {
	Ctx     context.Context
	Enabled func() bool
	Name    string
	Sync    v31.PipelineExecutionHandlerFunc
} {
	var calls []struct {
		Ctx     context.Context
		Enabled func() bool
		Name    string
		Sync    v31.PipelineExecutionHandlerFunc
	}
	lockPipelineExecutionControllerMockAddFeatureHandler.RLock()
	calls = mock.calls.AddFeatureHandler
	lockPipelineExecutionControllerMockAddFeatureHandler.RUnlock()
	return calls
}

// AddHandler calls AddHandlerFunc.
func (mock *PipelineExecutionControllerMock) AddHandler(ctx context.Context, name string, handler v31.PipelineExecutionHandlerFunc) {
	if mock.AddHandlerFunc == nil {
		panic("PipelineExecutionControllerMock.AddHandlerFunc: method is nil but PipelineExecutionController.AddHandler was just called")
	}
	callInfo := struct {
		Ctx     context.Context
		Name    string
		Handler v31.PipelineExecutionHandlerFunc
	}{
		Ctx:     ctx,
		Name:    name,
		Handler: handler,
	}
	lockPipelineExecutionControllerMockAddHandler.Lock()
	mock.calls.AddHandler = append(mock.calls.AddHandler, callInfo)
	lockPipelineExecutionControllerMockAddHandler.Unlock()
	mock.AddHandlerFunc(ctx, name, handler)
}

// AddHandlerCalls gets all the calls that were made to AddHandler.
// Check the length with:
//     len(mockedPipelineExecutionController.AddHandlerCalls())
func (mock *PipelineExecutionControllerMock) AddHandlerCalls() []struct {
	Ctx     context.Context
	Name    string
	Handler v31.PipelineExecutionHandlerFunc
} {
	var calls []struct {
		Ctx     context.Context
		Name    string
		Handler v31.PipelineExecutionHandlerFunc
	}
	lockPipelineExecutionControllerMockAddHandler.RLock()
	calls = mock.calls.AddHandler
	lockPipelineExecutionControllerMockAddHandler.RUnlock()
	return calls
}

// Enqueue calls EnqueueFunc.
func (mock *PipelineExecutionControllerMock) Enqueue(namespace string, name string) {
	if mock.EnqueueFunc == nil {
		panic("PipelineExecutionControllerMock.EnqueueFunc: method is nil but PipelineExecutionController.Enqueue was just called")
	}
	callInfo := struct {
		Namespace string
		Name      string
	}{
		Namespace: namespace,
		Name:      name,
	}
	lockPipelineExecutionControllerMockEnqueue.Lock()
	mock.calls.Enqueue = append(mock.calls.Enqueue, callInfo)
	lockPipelineExecutionControllerMockEnqueue.Unlock()
	mock.EnqueueFunc(namespace, name)
}

// EnqueueCalls gets all the calls that were made to Enqueue.
// Check the length with:
//     len(mockedPipelineExecutionController.EnqueueCalls())
func (mock *PipelineExecutionControllerMock) EnqueueCalls() []struct {
	Namespace string
	Name      string
} {
	var calls []struct {
		Namespace string
		Name      string
	}
	lockPipelineExecutionControllerMockEnqueue.RLock()
	calls = mock.calls.Enqueue
	lockPipelineExecutionControllerMockEnqueue.RUnlock()
	return calls
}

// EnqueueAfter calls EnqueueAfterFunc.
func (mock *PipelineExecutionControllerMock) EnqueueAfter(namespace string, name string, after time.Duration) {
	if mock.EnqueueAfterFunc == nil {
		panic("PipelineExecutionControllerMock.EnqueueAfterFunc: method is nil but PipelineExecutionController.EnqueueAfter was just called")
	}
	callInfo := struct {
		Namespace string
		Name      string
		After     time.Duration
	}{
		Namespace: namespace,
		Name:      name,
		After:     after,
	}
	lockPipelineExecutionControllerMockEnqueueAfter.Lock()
	mock.calls.EnqueueAfter = append(mock.calls.EnqueueAfter, callInfo)
	lockPipelineExecutionControllerMockEnqueueAfter.Unlock()
	mock.EnqueueAfterFunc(namespace, name, after)
}

// EnqueueAfterCalls gets all the calls that were made to EnqueueAfter.
// Check the length with:
//     len(mockedPipelineExecutionController.EnqueueAfterCalls())
func (mock *PipelineExecutionControllerMock) EnqueueAfterCalls() []struct {
	Namespace string
	Name      string
	After     time.Duration
} {
	var calls []struct {
		Namespace string
		Name      string
		After     time.Duration
	}
	lockPipelineExecutionControllerMockEnqueueAfter.RLock()
	calls = mock.calls.EnqueueAfter
	lockPipelineExecutionControllerMockEnqueueAfter.RUnlock()
	return calls
}

// Generic calls GenericFunc.
func (mock *PipelineExecutionControllerMock) Generic() controller.GenericController {
	if mock.GenericFunc == nil {
		panic("PipelineExecutionControllerMock.GenericFunc: method is nil but PipelineExecutionController.Generic was just called")
	}
	callInfo := struct {
	}{}
	lockPipelineExecutionControllerMockGeneric.Lock()
	mock.calls.Generic = append(mock.calls.Generic, callInfo)
	lockPipelineExecutionControllerMockGeneric.Unlock()
	return mock.GenericFunc()
}

// GenericCalls gets all the calls that were made to Generic.
// Check the length with:
//     len(mockedPipelineExecutionController.GenericCalls())
func (mock *PipelineExecutionControllerMock) GenericCalls() []struct {
} {
	var calls []struct {
	}
	lockPipelineExecutionControllerMockGeneric.RLock()
	calls = mock.calls.Generic
	lockPipelineExecutionControllerMockGeneric.RUnlock()
	return calls
}

// Informer calls InformerFunc.
func (mock *PipelineExecutionControllerMock) Informer() cache.SharedIndexInformer {
	if mock.InformerFunc == nil {
		panic("PipelineExecutionControllerMock.InformerFunc: method is nil but PipelineExecutionController.Informer was just called")
	}
	callInfo := struct {
	}{}
	lockPipelineExecutionControllerMockInformer.Lock()
	mock.calls.Informer = append(mock.calls.Informer, callInfo)
	lockPipelineExecutionControllerMockInformer.Unlock()
	return mock.InformerFunc()
}

// InformerCalls gets all the calls that were made to Informer.
// Check the length with:
//     len(mockedPipelineExecutionController.InformerCalls())
func (mock *PipelineExecutionControllerMock) InformerCalls() []struct {
} {
	var calls []struct {
	}
	lockPipelineExecutionControllerMockInformer.RLock()
	calls = mock.calls.Informer
	lockPipelineExecutionControllerMockInformer.RUnlock()
	return calls
}

// Lister calls ListerFunc.
func (mock *PipelineExecutionControllerMock) Lister() v31.PipelineExecutionLister {
	if mock.ListerFunc == nil {
		panic("PipelineExecutionControllerMock.ListerFunc: method is nil but PipelineExecutionController.Lister was just called")
	}
	callInfo := struct {
	}{}
	lockPipelineExecutionControllerMockLister.Lock()
	mock.calls.Lister = append(mock.calls.Lister, callInfo)
	lockPipelineExecutionControllerMockLister.Unlock()
	return mock.ListerFunc()
}

// ListerCalls gets all the calls that were made to Lister.
// Check the length with:
//     len(mockedPipelineExecutionController.ListerCalls())
func (mock *PipelineExecutionControllerMock) ListerCalls() []struct {
} {
	var calls []struct {
	}
	lockPipelineExecutionControllerMockLister.RLock()
	calls = mock.calls.Lister
	lockPipelineExecutionControllerMockLister.RUnlock()
	return calls
}

var (
	lockPipelineExecutionInterfaceMockAddClusterScopedFeatureHandler   sync.RWMutex
	lockPipelineExecutionInterfaceMockAddClusterScopedFeatureLifecycle sync.RWMutex
	lockPipelineExecutionInterfaceMockAddClusterScopedHandler          sync.RWMutex
	lockPipelineExecutionInterfaceMockAddClusterScopedLifecycle        sync.RWMutex
	lockPipelineExecutionInterfaceMockAddFeatureHandler                sync.RWMutex
	lockPipelineExecutionInterfaceMockAddFeatureLifecycle              sync.RWMutex
	lockPipelineExecutionInterfaceMockAddHandler                       sync.RWMutex
	lockPipelineExecutionInterfaceMockAddLifecycle                     sync.RWMutex
	lockPipelineExecutionInterfaceMockController                       sync.RWMutex
	lockPipelineExecutionInterfaceMockCreate                           sync.RWMutex
	lockPipelineExecutionInterfaceMockDelete                           sync.RWMutex
	lockPipelineExecutionInterfaceMockDeleteCollection                 sync.RWMutex
	lockPipelineExecutionInterfaceMockDeleteNamespaced                 sync.RWMutex
	lockPipelineExecutionInterfaceMockGet                              sync.RWMutex
	lockPipelineExecutionInterfaceMockGetNamespaced                    sync.RWMutex
	lockPipelineExecutionInterfaceMockList                             sync.RWMutex
	lockPipelineExecutionInterfaceMockListNamespaced                   sync.RWMutex
	lockPipelineExecutionInterfaceMockObjectClient                     sync.RWMutex
	lockPipelineExecutionInterfaceMockUpdate                           sync.RWMutex
	lockPipelineExecutionInterfaceMockWatch                            sync.RWMutex
)

// Ensure, that PipelineExecutionInterfaceMock does implement v31.PipelineExecutionInterface.
// If this is not the case, regenerate this file with moq.
var _ v31.PipelineExecutionInterface = &PipelineExecutionInterfaceMock{}

// PipelineExecutionInterfaceMock is a mock implementation of v31.PipelineExecutionInterface.
//
//     func TestSomethingThatUsesPipelineExecutionInterface(t *testing.T) {
//
//         // make and configure a mocked v31.PipelineExecutionInterface
//         mockedPipelineExecutionInterface := &PipelineExecutionInterfaceMock{
//             AddClusterScopedFeatureHandlerFunc: func(ctx context.Context, enabled func() bool, name string, clusterName string, syncMoqParam v31.PipelineExecutionHandlerFunc)  {
// 	               panic("mock out the AddClusterScopedFeatureHandler method")
//             },
//             AddClusterScopedFeatureLifecycleFunc: func(ctx context.Context, enabled func() bool, name string, clusterName string, lifecycle v31.PipelineExecutionLifecycle)  {
// 	               panic("mock out the AddClusterScopedFeatureLifecycle method")
//             },
//             AddClusterScopedHandlerFunc: func(ctx context.Context, name string, clusterName string, syncMoqParam v31.PipelineExecutionHandlerFunc)  {
// 	               panic("mock out the AddClusterScopedHandler method")
//             },
//             AddClusterScopedLifecycleFunc: func(ctx context.Context, name string, clusterName string, lifecycle v31.PipelineExecutionLifecycle)  {
// 	               panic("mock out the AddClusterScopedLifecycle method")
//             },
//             AddFeatureHandlerFunc: func(ctx context.Context, enabled func() bool, name string, syncMoqParam v31.PipelineExecutionHandlerFunc)  {
// 	               panic("mock out the AddFeatureHandler method")
//             },
//             AddFeatureLifecycleFunc: func(ctx context.Context, enabled func() bool, name string, lifecycle v31.PipelineExecutionLifecycle)  {
// 	               panic("mock out the AddFeatureLifecycle method")
//             },
//             AddHandlerFunc: func(ctx context.Context, name string, syncMoqParam v31.PipelineExecutionHandlerFunc)  {
// 	               panic("mock out the AddHandler method")
//             },
//             AddLifecycleFunc: func(ctx context.Context, name string, lifecycle v31.PipelineExecutionLifecycle)  {
// 	               panic("mock out the AddLifecycle method")
//             },
//             ControllerFunc: func() v31.PipelineExecutionController {
// 	               panic("mock out the Controller method")
//             },
//             CreateFunc: func(in1 *v3.PipelineExecution) (*v3.PipelineExecution, error) {
// 	               panic("mock out the Create method")
//             },
//             DeleteFunc: func(name string, options *metav1.DeleteOptions) error {
// 	               panic("mock out the Delete method")
//             },
//             DeleteCollectionFunc: func(deleteOpts *metav1.DeleteOptions, listOpts metav1.ListOptions) error {
// 	               panic("mock out the DeleteCollection method")
//             },
//             DeleteNamespacedFunc: func(namespace string, name string, options *metav1.DeleteOptions) error {
// 	               panic("mock out the DeleteNamespaced method")
//             },
//             GetFunc: func(name string, opts metav1.GetOptions) (*v3.PipelineExecution, error) {
// 	               panic("mock out the Get method")
//             },
//             GetNamespacedFunc: func(namespace string, name string, opts metav1.GetOptions) (*v3.PipelineExecution, error) {
// 	               panic("mock out the GetNamespaced method")
//             },
//             ListFunc: func(opts metav1.ListOptions) (*v3.PipelineExecutionList, error) {
// 	               panic("mock out the List method")
//             },
//             ListNamespacedFunc: func(namespace string, opts metav1.ListOptions) (*v3.PipelineExecutionList, error) {
// 	               panic("mock out the ListNamespaced method")
//             },
//             ObjectClientFunc: func() *objectclient.ObjectClient {
// 	               panic("mock out the ObjectClient method")
//             },
//             UpdateFunc: func(in1 *v3.PipelineExecution) (*v3.PipelineExecution, error) {
// 	               panic("mock out the Update method")
//             },
//             WatchFunc: func(opts metav1.ListOptions) (watch.Interface, error) {
// 	               panic("mock out the Watch method")
//             },
//         }
//
//         // use mockedPipelineExecutionInterface in code that requires v31.PipelineExecutionInterface
//         // and then make assertions.
//
//     }
type PipelineExecutionInterfaceMock struct {
	// AddClusterScopedFeatureHandlerFunc mocks the AddClusterScopedFeatureHandler method.
	AddClusterScopedFeatureHandlerFunc func(ctx context.Context, enabled func() bool, name string, clusterName string, syncMoqParam v31.PipelineExecutionHandlerFunc)

	// AddClusterScopedFeatureLifecycleFunc mocks the AddClusterScopedFeatureLifecycle method.
	AddClusterScopedFeatureLifecycleFunc func(ctx context.Context, enabled func() bool, name string, clusterName string, lifecycle v31.PipelineExecutionLifecycle)

	// AddClusterScopedHandlerFunc mocks the AddClusterScopedHandler method.
	AddClusterScopedHandlerFunc func(ctx context.Context, name string, clusterName string, syncMoqParam v31.PipelineExecutionHandlerFunc)

	// AddClusterScopedLifecycleFunc mocks the AddClusterScopedLifecycle method.
	AddClusterScopedLifecycleFunc func(ctx context.Context, name string, clusterName string, lifecycle v31.PipelineExecutionLifecycle)

	// AddFeatureHandlerFunc mocks the AddFeatureHandler method.
	AddFeatureHandlerFunc func(ctx context.Context, enabled func() bool, name string, syncMoqParam v31.PipelineExecutionHandlerFunc)

	// AddFeatureLifecycleFunc mocks the AddFeatureLifecycle method.
	AddFeatureLifecycleFunc func(ctx context.Context, enabled func() bool, name string, lifecycle v31.PipelineExecutionLifecycle)

	// AddHandlerFunc mocks the AddHandler method.
	AddHandlerFunc func(ctx context.Context, name string, syncMoqParam v31.PipelineExecutionHandlerFunc)

	// AddLifecycleFunc mocks the AddLifecycle method.
	AddLifecycleFunc func(ctx context.Context, name string, lifecycle v31.PipelineExecutionLifecycle)

	// ControllerFunc mocks the Controller method.
	ControllerFunc func() v31.PipelineExecutionController

	// CreateFunc mocks the Create method.
	CreateFunc func(in1 *v3.PipelineExecution) (*v3.PipelineExecution, error)

	// DeleteFunc mocks the Delete method.
	DeleteFunc func(name string, options *metav1.DeleteOptions) error

	// DeleteCollectionFunc mocks the DeleteCollection method.
	DeleteCollectionFunc func(deleteOpts *metav1.DeleteOptions, listOpts metav1.ListOptions) error

	// DeleteNamespacedFunc mocks the DeleteNamespaced method.
	DeleteNamespacedFunc func(namespace string, name string, options *metav1.DeleteOptions) error

	// GetFunc mocks the Get method.
	GetFunc func(name string, opts metav1.GetOptions) (*v3.PipelineExecution, error)

	// GetNamespacedFunc mocks the GetNamespaced method.
	GetNamespacedFunc func(namespace string, name string, opts metav1.GetOptions) (*v3.PipelineExecution, error)

	// ListFunc mocks the List method.
	ListFunc func(opts metav1.ListOptions) (*v3.PipelineExecutionList, error)

	// ListNamespacedFunc mocks the ListNamespaced method.
	ListNamespacedFunc func(namespace string, opts metav1.ListOptions) (*v3.PipelineExecutionList, error)

	// ObjectClientFunc mocks the ObjectClient method.
	ObjectClientFunc func() *objectclient.ObjectClient

	// UpdateFunc mocks the Update method.
	UpdateFunc func(in1 *v3.PipelineExecution) (*v3.PipelineExecution, error)

	// WatchFunc mocks the Watch method.
	WatchFunc func(opts metav1.ListOptions) (watch.Interface, error)

	// calls tracks calls to the methods.
	calls struct {
		// AddClusterScopedFeatureHandler holds details about calls to the AddClusterScopedFeatureHandler method.
		AddClusterScopedFeatureHandler []struct {
			// Ctx is the ctx argument value.
			Ctx context.Context
			// Enabled is the enabled argument value.
			Enabled func() bool
			// Name is the name argument value.
			Name string
			// ClusterName is the clusterName argument value.
			ClusterName string
			// Sync is the sync argument value.
			Sync v31.PipelineExecutionHandlerFunc
		}
		// AddClusterScopedFeatureLifecycle holds details about calls to the AddClusterScopedFeatureLifecycle method.
		AddClusterScopedFeatureLifecycle []struct {
			// Ctx is the ctx argument value.
			Ctx context.Context
			// Enabled is the enabled argument value.
			Enabled func() bool
			// Name is the name argument value.
			Name string
			// ClusterName is the clusterName argument value.
			ClusterName string
			// Lifecycle is the lifecycle argument value.
			Lifecycle v31.PipelineExecutionLifecycle
		}
		// AddClusterScopedHandler holds details about calls to the AddClusterScopedHandler method.
		AddClusterScopedHandler []struct {
			// Ctx is the ctx argument value.
			Ctx context.Context
			// Name is the name argument value.
			Name string
			// ClusterName is the clusterName argument value.
			ClusterName string
			// Sync is the sync argument value.
			Sync v31.PipelineExecutionHandlerFunc
		}
		// AddClusterScopedLifecycle holds details about calls to the AddClusterScopedLifecycle method.
		AddClusterScopedLifecycle []struct {
			// Ctx is the ctx argument value.
			Ctx context.Context
			// Name is the name argument value.
			Name string
			// ClusterName is the clusterName argument value.
			ClusterName string
			// Lifecycle is the lifecycle argument value.
			Lifecycle v31.PipelineExecutionLifecycle
		}
		// AddFeatureHandler holds details about calls to the AddFeatureHandler method.
		AddFeatureHandler []struct {
			// Ctx is the ctx argument value.
			Ctx context.Context
			// Enabled is the enabled argument value.
			Enabled func() bool
			// Name is the name argument value.
			Name string
			// Sync is the sync argument value.
			Sync v31.PipelineExecutionHandlerFunc
		}
		// AddFeatureLifecycle holds details about calls to the AddFeatureLifecycle method.
		AddFeatureLifecycle []struct {
			// Ctx is the ctx argument value.
			Ctx context.Context
			// Enabled is the enabled argument value.
			Enabled func() bool
			// Name is the name argument value.
			Name string
			// Lifecycle is the lifecycle argument value.
			Lifecycle v31.PipelineExecutionLifecycle
		}
		// AddHandler holds details about calls to the AddHandler method.
		AddHandler []struct {
			// Ctx is the ctx argument value.
			Ctx context.Context
			// Name is the name argument value.
			Name string
			// Sync is the sync argument value.
			Sync v31.PipelineExecutionHandlerFunc
		}
		// AddLifecycle holds details about calls to the AddLifecycle method.
		AddLifecycle []struct {
			// Ctx is the ctx argument value.
			Ctx context.Context
			// Name is the name argument value.
			Name string
			// Lifecycle is the lifecycle argument value.
			Lifecycle v31.PipelineExecutionLifecycle
		}
		// Controller holds details about calls to the Controller method.
		Controller []struct {
		}
		// Create holds details about calls to the Create method.
		Create []struct {
			// In1 is the in1 argument value.
			In1 *v3.PipelineExecution
		}
		// Delete holds details about calls to the Delete method.
		Delete []struct {
			// Name is the name argument value.
			Name string
			// Options is the options argument value.
			Options *metav1.DeleteOptions
		}
		// DeleteCollection holds details about calls to the DeleteCollection method.
		DeleteCollection []struct {
			// DeleteOpts is the deleteOpts argument value.
			DeleteOpts *metav1.DeleteOptions
			// ListOpts is the listOpts argument value.
			ListOpts metav1.ListOptions
		}
		// DeleteNamespaced holds details about calls to the DeleteNamespaced method.
		DeleteNamespaced []struct {
			// Namespace is the namespace argument value.
			Namespace string
			// Name is the name argument value.
			Name string
			// Options is the options argument value.
			Options *metav1.DeleteOptions
		}
		// Get holds details about calls to the Get method.
		Get []struct {
			// Name is the name argument value.
			Name string
			// Opts is the opts argument value.
			Opts metav1.GetOptions
		}
		// GetNamespaced holds details about calls to the GetNamespaced method.
		GetNamespaced []struct {
			// Namespace is the namespace argument value.
			Namespace string
			// Name is the name argument value.
			Name string
			// Opts is the opts argument value.
			Opts metav1.GetOptions
		}
		// List holds details about calls to the List method.
		List []struct {
			// Opts is the opts argument value.
			Opts metav1.ListOptions
		}
		// ListNamespaced holds details about calls to the ListNamespaced method.
		ListNamespaced []struct {
			// Namespace is the namespace argument value.
			Namespace string
			// Opts is the opts argument value.
			Opts metav1.ListOptions
		}
		// ObjectClient holds details about calls to the ObjectClient method.
		ObjectClient []struct {
		}
		// Update holds details about calls to the Update method.
		Update []struct {
			// In1 is the in1 argument value.
			In1 *v3.PipelineExecution
		}
		// Watch holds details about calls to the Watch method.
		Watch []struct {
			// Opts is the opts argument value.
			Opts metav1.ListOptions
		}
	}
}

// AddClusterScopedFeatureHandler calls AddClusterScopedFeatureHandlerFunc.
func (mock *PipelineExecutionInterfaceMock) AddClusterScopedFeatureHandler(ctx context.Context, enabled func() bool, name string, clusterName string, syncMoqParam v31.PipelineExecutionHandlerFunc) {
	if mock.AddClusterScopedFeatureHandlerFunc == nil {
		panic("PipelineExecutionInterfaceMock.AddClusterScopedFeatureHandlerFunc: method is nil but PipelineExecutionInterface.AddClusterScopedFeatureHandler was just called")
	}
	callInfo := struct {
		Ctx         context.Context
		Enabled     func() bool
		Name        string
		ClusterName string
		Sync        v31.PipelineExecutionHandlerFunc
	}{
		Ctx:         ctx,
		Enabled:     enabled,
		Name:        name,
		ClusterName: clusterName,
		Sync:        syncMoqParam,
	}
	lockPipelineExecutionInterfaceMockAddClusterScopedFeatureHandler.Lock()
	mock.calls.AddClusterScopedFeatureHandler = append(mock.calls.AddClusterScopedFeatureHandler, callInfo)
	lockPipelineExecutionInterfaceMockAddClusterScopedFeatureHandler.Unlock()
	mock.AddClusterScopedFeatureHandlerFunc(ctx, enabled, name, clusterName, syncMoqParam)
}

// AddClusterScopedFeatureHandlerCalls gets all the calls that were made to AddClusterScopedFeatureHandler.
// Check the length with:
//     len(mockedPipelineExecutionInterface.AddClusterScopedFeatureHandlerCalls())
func (mock *PipelineExecutionInterfaceMock) AddClusterScopedFeatureHandlerCalls() []struct {
	Ctx         context.Context
	Enabled     func() bool
	Name        string
	ClusterName string
	Sync        v31.PipelineExecutionHandlerFunc
} {
	var calls []struct {
		Ctx         context.Context
		Enabled     func() bool
		Name        string
		ClusterName string
		Sync        v31.PipelineExecutionHandlerFunc
	}
	lockPipelineExecutionInterfaceMockAddClusterScopedFeatureHandler.RLock()
	calls = mock.calls.AddClusterScopedFeatureHandler
	lockPipelineExecutionInterfaceMockAddClusterScopedFeatureHandler.RUnlock()
	return calls
}

// AddClusterScopedFeatureLifecycle calls AddClusterScopedFeatureLifecycleFunc.
func (mock *PipelineExecutionInterfaceMock) AddClusterScopedFeatureLifecycle(ctx context.Context, enabled func() bool, name string, clusterName string, lifecycle v31.PipelineExecutionLifecycle) {
	if mock.AddClusterScopedFeatureLifecycleFunc == nil {
		panic("PipelineExecutionInterfaceMock.AddClusterScopedFeatureLifecycleFunc: method is nil but PipelineExecutionInterface.AddClusterScopedFeatureLifecycle was just called")
	}
	callInfo := struct {
		Ctx         context.Context
		Enabled     func() bool
		Name        string
		ClusterName string
		Lifecycle   v31.PipelineExecutionLifecycle
	}{
		Ctx:         ctx,
		Enabled:     enabled,
		Name:        name,
		ClusterName: clusterName,
		Lifecycle:   lifecycle,
	}
	lockPipelineExecutionInterfaceMockAddClusterScopedFeatureLifecycle.Lock()
	mock.calls.AddClusterScopedFeatureLifecycle = append(mock.calls.AddClusterScopedFeatureLifecycle, callInfo)
	lockPipelineExecutionInterfaceMockAddClusterScopedFeatureLifecycle.Unlock()
	mock.AddClusterScopedFeatureLifecycleFunc(ctx, enabled, name, clusterName, lifecycle)
}

// AddClusterScopedFeatureLifecycleCalls gets all the calls that were made to AddClusterScopedFeatureLifecycle.
// Check the length with:
//     len(mockedPipelineExecutionInterface.AddClusterScopedFeatureLifecycleCalls())
func (mock *PipelineExecutionInterfaceMock) AddClusterScopedFeatureLifecycleCalls() []struct {
	Ctx         context.Context
	Enabled     func() bool
	Name        string
	ClusterName string
	Lifecycle   v31.PipelineExecutionLifecycle
} {
	var calls []struct {
		Ctx         context.Context
		Enabled     func() bool
		Name        string
		ClusterName string
		Lifecycle   v31.PipelineExecutionLifecycle
	}
	lockPipelineExecutionInterfaceMockAddClusterScopedFeatureLifecycle.RLock()
	calls = mock.calls.AddClusterScopedFeatureLifecycle
	lockPipelineExecutionInterfaceMockAddClusterScopedFeatureLifecycle.RUnlock()
	return calls
}

// AddClusterScopedHandler calls AddClusterScopedHandlerFunc.
func (mock *PipelineExecutionInterfaceMock) AddClusterScopedHandler(ctx context.Context, name string, clusterName string, syncMoqParam v31.PipelineExecutionHandlerFunc) {
	if mock.AddClusterScopedHandlerFunc == nil {
		panic("PipelineExecutionInterfaceMock.AddClusterScopedHandlerFunc: method is nil but PipelineExecutionInterface.AddClusterScopedHandler was just called")
	}
	callInfo := struct {
		Ctx         context.Context
		Name        string
		ClusterName string
		Sync        v31.PipelineExecutionHandlerFunc
	}{
		Ctx:         ctx,
		Name:        name,
		ClusterName: clusterName,
		Sync:        syncMoqParam,
	}
	lockPipelineExecutionInterfaceMockAddClusterScopedHandler.Lock()
	mock.calls.AddClusterScopedHandler = append(mock.calls.AddClusterScopedHandler, callInfo)
	lockPipelineExecutionInterfaceMockAddClusterScopedHandler.Unlock()
	mock.AddClusterScopedHandlerFunc(ctx, name, clusterName, syncMoqParam)
}

// AddClusterScopedHandlerCalls gets all the calls that were made to AddClusterScopedHandler.
// Check the length with:
//     len(mockedPipelineExecutionInterface.AddClusterScopedHandlerCalls())
func (mock *PipelineExecutionInterfaceMock) AddClusterScopedHandlerCalls() []struct {
	Ctx         context.Context
	Name        string
	ClusterName string
	Sync        v31.PipelineExecutionHandlerFunc
} {
	var calls []struct {
		Ctx         context.Context
		Name        string
		ClusterName string
		Sync        v31.PipelineExecutionHandlerFunc
	}
	lockPipelineExecutionInterfaceMockAddClusterScopedHandler.RLock()
	calls = mock.calls.AddClusterScopedHandler
	lockPipelineExecutionInterfaceMockAddClusterScopedHandler.RUnlock()
	return calls
}

// AddClusterScopedLifecycle calls AddClusterScopedLifecycleFunc.
func (mock *PipelineExecutionInterfaceMock) AddClusterScopedLifecycle(ctx context.Context, name string, clusterName string, lifecycle v31.PipelineExecutionLifecycle) {
	if mock.AddClusterScopedLifecycleFunc == nil {
		panic("PipelineExecutionInterfaceMock.AddClusterScopedLifecycleFunc: method is nil but PipelineExecutionInterface.AddClusterScopedLifecycle was just called")
	}
	callInfo := struct {
		Ctx         context.Context
		Name        string
		ClusterName string
		Lifecycle   v31.PipelineExecutionLifecycle
	}{
		Ctx:         ctx,
		Name:        name,
		ClusterName: clusterName,
		Lifecycle:   lifecycle,
	}
	lockPipelineExecutionInterfaceMockAddClusterScopedLifecycle.Lock()
	mock.calls.AddClusterScopedLifecycle = append(mock.calls.AddClusterScopedLifecycle, callInfo)
	lockPipelineExecutionInterfaceMockAddClusterScopedLifecycle.Unlock()
	mock.AddClusterScopedLifecycleFunc(ctx, name, clusterName, lifecycle)
}

// AddClusterScopedLifecycleCalls gets all the calls that were made to AddClusterScopedLifecycle.
// Check the length with:
//     len(mockedPipelineExecutionInterface.AddClusterScopedLifecycleCalls())
func (mock *PipelineExecutionInterfaceMock) AddClusterScopedLifecycleCalls() []struct {
	Ctx         context.Context
	Name        string
	ClusterName string
	Lifecycle   v31.PipelineExecutionLifecycle
} {
	var calls []struct {
		Ctx         context.Context
		Name        string
		ClusterName string
		Lifecycle   v31.PipelineExecutionLifecycle
	}
	lockPipelineExecutionInterfaceMockAddClusterScopedLifecycle.RLock()
	calls = mock.calls.AddClusterScopedLifecycle
	lockPipelineExecutionInterfaceMockAddClusterScopedLifecycle.RUnlock()
	return calls
}

// AddFeatureHandler calls AddFeatureHandlerFunc.
func (mock *PipelineExecutionInterfaceMock) AddFeatureHandler(ctx context.Context, enabled func() bool, name string, syncMoqParam v31.PipelineExecutionHandlerFunc) {
	if mock.AddFeatureHandlerFunc == nil {
		panic("PipelineExecutionInterfaceMock.AddFeatureHandlerFunc: method is nil but PipelineExecutionInterface.AddFeatureHandler was just called")
	}
	callInfo := struct {
		Ctx     context.Context
		Enabled func() bool
		Name    string
		Sync    v31.PipelineExecutionHandlerFunc
	}{
		Ctx:     ctx,
		Enabled: enabled,
		Name:    name,
		Sync:    syncMoqParam,
	}
	lockPipelineExecutionInterfaceMockAddFeatureHandler.Lock()
	mock.calls.AddFeatureHandler = append(mock.calls.AddFeatureHandler, callInfo)
	lockPipelineExecutionInterfaceMockAddFeatureHandler.Unlock()
	mock.AddFeatureHandlerFunc(ctx, enabled, name, syncMoqParam)
}

// AddFeatureHandlerCalls gets all the calls that were made to AddFeatureHandler.
// Check the length with:
//     len(mockedPipelineExecutionInterface.AddFeatureHandlerCalls())
func (mock *PipelineExecutionInterfaceMock) AddFeatureHandlerCalls() []struct {
	Ctx     context.Context
	Enabled func() bool
	Name    string
	Sync    v31.PipelineExecutionHandlerFunc
} {
	var calls []struct {
		Ctx     context.Context
		Enabled func() bool
		Name    string
		Sync    v31.PipelineExecutionHandlerFunc
	}
	lockPipelineExecutionInterfaceMockAddFeatureHandler.RLock()
	calls = mock.calls.AddFeatureHandler
	lockPipelineExecutionInterfaceMockAddFeatureHandler.RUnlock()
	return calls
}

// AddFeatureLifecycle calls AddFeatureLifecycleFunc.
func (mock *PipelineExecutionInterfaceMock) AddFeatureLifecycle(ctx context.Context, enabled func() bool, name string, lifecycle v31.PipelineExecutionLifecycle) {
	if mock.AddFeatureLifecycleFunc == nil {
		panic("PipelineExecutionInterfaceMock.AddFeatureLifecycleFunc: method is nil but PipelineExecutionInterface.AddFeatureLifecycle was just called")
	}
	callInfo := struct {
		Ctx       context.Context
		Enabled   func() bool
		Name      string
		Lifecycle v31.PipelineExecutionLifecycle
	}{
		Ctx:       ctx,
		Enabled:   enabled,
		Name:      name,
		Lifecycle: lifecycle,
	}
	lockPipelineExecutionInterfaceMockAddFeatureLifecycle.Lock()
	mock.calls.AddFeatureLifecycle = append(mock.calls.AddFeatureLifecycle, callInfo)
	lockPipelineExecutionInterfaceMockAddFeatureLifecycle.Unlock()
	mock.AddFeatureLifecycleFunc(ctx, enabled, name, lifecycle)
}

// AddFeatureLifecycleCalls gets all the calls that were made to AddFeatureLifecycle.
// Check the length with:
//     len(mockedPipelineExecutionInterface.AddFeatureLifecycleCalls())
func (mock *PipelineExecutionInterfaceMock) AddFeatureLifecycleCalls() []struct {
	Ctx       context.Context
	Enabled   func() bool
	Name      string
	Lifecycle v31.PipelineExecutionLifecycle
} {
	var calls []struct {
		Ctx       context.Context
		Enabled   func() bool
		Name      string
		Lifecycle v31.PipelineExecutionLifecycle
	}
	lockPipelineExecutionInterfaceMockAddFeatureLifecycle.RLock()
	calls = mock.calls.AddFeatureLifecycle
	lockPipelineExecutionInterfaceMockAddFeatureLifecycle.RUnlock()
	return calls
}

// AddHandler calls AddHandlerFunc.
func (mock *PipelineExecutionInterfaceMock) AddHandler(ctx context.Context, name string, syncMoqParam v31.PipelineExecutionHandlerFunc) {
	if mock.AddHandlerFunc == nil {
		panic("PipelineExecutionInterfaceMock.AddHandlerFunc: method is nil but PipelineExecutionInterface.AddHandler was just called")
	}
	callInfo := struct {
		Ctx  context.Context
		Name string
		Sync v31.PipelineExecutionHandlerFunc
	}{
		Ctx:  ctx,
		Name: name,
		Sync: syncMoqParam,
	}
	lockPipelineExecutionInterfaceMockAddHandler.Lock()
	mock.calls.AddHandler = append(mock.calls.AddHandler, callInfo)
	lockPipelineExecutionInterfaceMockAddHandler.Unlock()
	mock.AddHandlerFunc(ctx, name, syncMoqParam)
}

// AddHandlerCalls gets all the calls that were made to AddHandler.
// Check the length with:
//     len(mockedPipelineExecutionInterface.AddHandlerCalls())
func (mock *PipelineExecutionInterfaceMock) AddHandlerCalls() []struct {
	Ctx  context.Context
	Name string
	Sync v31.PipelineExecutionHandlerFunc
} {
	var calls []struct {
		Ctx  context.Context
		Name string
		Sync v31.PipelineExecutionHandlerFunc
	}
	lockPipelineExecutionInterfaceMockAddHandler.RLock()
	calls = mock.calls.AddHandler
	lockPipelineExecutionInterfaceMockAddHandler.RUnlock()
	return calls
}

// AddLifecycle calls AddLifecycleFunc.
func (mock *PipelineExecutionInterfaceMock) AddLifecycle(ctx context.Context, name string, lifecycle v31.PipelineExecutionLifecycle) {
	if mock.AddLifecycleFunc == nil {
		panic("PipelineExecutionInterfaceMock.AddLifecycleFunc: method is nil but PipelineExecutionInterface.AddLifecycle was just called")
	}
	callInfo := struct {
		Ctx       context.Context
		Name      string
		Lifecycle v31.PipelineExecutionLifecycle
	}{
		Ctx:       ctx,
		Name:      name,
		Lifecycle: lifecycle,
	}
	lockPipelineExecutionInterfaceMockAddLifecycle.Lock()
	mock.calls.AddLifecycle = append(mock.calls.AddLifecycle, callInfo)
	lockPipelineExecutionInterfaceMockAddLifecycle.Unlock()
	mock.AddLifecycleFunc(ctx, name, lifecycle)
}

// AddLifecycleCalls gets all the calls that were made to AddLifecycle.
// Check the length with:
//     len(mockedPipelineExecutionInterface.AddLifecycleCalls())
func (mock *PipelineExecutionInterfaceMock) AddLifecycleCalls() []struct {
	Ctx       context.Context
	Name      string
	Lifecycle v31.PipelineExecutionLifecycle
} {
	var calls []struct {
		Ctx       context.Context
		Name      string
		Lifecycle v31.PipelineExecutionLifecycle
	}
	lockPipelineExecutionInterfaceMockAddLifecycle.RLock()
	calls = mock.calls.AddLifecycle
	lockPipelineExecutionInterfaceMockAddLifecycle.RUnlock()
	return calls
}

// Controller calls ControllerFunc.
func (mock *PipelineExecutionInterfaceMock) Controller() v31.PipelineExecutionController {
	if mock.ControllerFunc == nil {
		panic("PipelineExecutionInterfaceMock.ControllerFunc: method is nil but PipelineExecutionInterface.Controller was just called")
	}
	callInfo := struct {
	}{}
	lockPipelineExecutionInterfaceMockController.Lock()
	mock.calls.Controller = append(mock.calls.Controller, callInfo)
	lockPipelineExecutionInterfaceMockController.Unlock()
	return mock.ControllerFunc()
}

// ControllerCalls gets all the calls that were made to Controller.
// Check the length with:
//     len(mockedPipelineExecutionInterface.ControllerCalls())
func (mock *PipelineExecutionInterfaceMock) ControllerCalls() []struct {
} {
	var calls []struct {
	}
	lockPipelineExecutionInterfaceMockController.RLock()
	calls = mock.calls.Controller
	lockPipelineExecutionInterfaceMockController.RUnlock()
	return calls
}

// Create calls CreateFunc.
func (mock *PipelineExecutionInterfaceMock) Create(in1 *v3.PipelineExecution) (*v3.PipelineExecution, error) {
	if mock.CreateFunc == nil {
		panic("PipelineExecutionInterfaceMock.CreateFunc: method is nil but PipelineExecutionInterface.Create was just called")
	}
	callInfo := struct {
		In1 *v3.PipelineExecution
	}{
		In1: in1,
	}
	lockPipelineExecutionInterfaceMockCreate.Lock()
	mock.calls.Create = append(mock.calls.Create, callInfo)
	lockPipelineExecutionInterfaceMockCreate.Unlock()
	return mock.CreateFunc(in1)
}

// CreateCalls gets all the calls that were made to Create.
// Check the length with:
//     len(mockedPipelineExecutionInterface.CreateCalls())
func (mock *PipelineExecutionInterfaceMock) CreateCalls() []struct {
	In1 *v3.PipelineExecution
} {
	var calls []struct {
		In1 *v3.PipelineExecution
	}
	lockPipelineExecutionInterfaceMockCreate.RLock()
	calls = mock.calls.Create
	lockPipelineExecutionInterfaceMockCreate.RUnlock()
	return calls
}

// Delete calls DeleteFunc.
func (mock *PipelineExecutionInterfaceMock) Delete(name string, options *metav1.DeleteOptions) error {
	if mock.DeleteFunc == nil {
		panic("PipelineExecutionInterfaceMock.DeleteFunc: method is nil but PipelineExecutionInterface.Delete was just called")
	}
	callInfo := struct {
		Name    string
		Options *metav1.DeleteOptions
	}{
		Name:    name,
		Options: options,
	}
	lockPipelineExecutionInterfaceMockDelete.Lock()
	mock.calls.Delete = append(mock.calls.Delete, callInfo)
	lockPipelineExecutionInterfaceMockDelete.Unlock()
	return mock.DeleteFunc(name, options)
}

// DeleteCalls gets all the calls that were made to Delete.
// Check the length with:
//     len(mockedPipelineExecutionInterface.DeleteCalls())
func (mock *PipelineExecutionInterfaceMock) DeleteCalls() []struct {
	Name    string
	Options *metav1.DeleteOptions
} {
	var calls []struct {
		Name    string
		Options *metav1.DeleteOptions
	}
	lockPipelineExecutionInterfaceMockDelete.RLock()
	calls = mock.calls.Delete
	lockPipelineExecutionInterfaceMockDelete.RUnlock()
	return calls
}

// DeleteCollection calls DeleteCollectionFunc.
func (mock *PipelineExecutionInterfaceMock) DeleteCollection(deleteOpts *metav1.DeleteOptions, listOpts metav1.ListOptions) error {
	if mock.DeleteCollectionFunc == nil {
		panic("PipelineExecutionInterfaceMock.DeleteCollectionFunc: method is nil but PipelineExecutionInterface.DeleteCollection was just called")
	}
	callInfo := struct {
		DeleteOpts *metav1.DeleteOptions
		ListOpts   metav1.ListOptions
	}{
		DeleteOpts: deleteOpts,
		ListOpts:   listOpts,
	}
	lockPipelineExecutionInterfaceMockDeleteCollection.Lock()
	mock.calls.DeleteCollection = append(mock.calls.DeleteCollection, callInfo)
	lockPipelineExecutionInterfaceMockDeleteCollection.Unlock()
	return mock.DeleteCollectionFunc(deleteOpts, listOpts)
}

// DeleteCollectionCalls gets all the calls that were made to DeleteCollection.
// Check the length with:
//     len(mockedPipelineExecutionInterface.DeleteCollectionCalls())
func (mock *PipelineExecutionInterfaceMock) DeleteCollectionCalls() []struct {
	DeleteOpts *metav1.DeleteOptions
	ListOpts   metav1.ListOptions
} {
	var calls []struct {
		DeleteOpts *metav1.DeleteOptions
		ListOpts   metav1.ListOptions
	}
	lockPipelineExecutionInterfaceMockDeleteCollection.RLock()
	calls = mock.calls.DeleteCollection
	lockPipelineExecutionInterfaceMockDeleteCollection.RUnlock()
	return calls
}

// DeleteNamespaced calls DeleteNamespacedFunc.
func (mock *PipelineExecutionInterfaceMock) DeleteNamespaced(namespace string, name string, options *metav1.DeleteOptions) error {
	if mock.DeleteNamespacedFunc == nil {
		panic("PipelineExecutionInterfaceMock.DeleteNamespacedFunc: method is nil but PipelineExecutionInterface.DeleteNamespaced was just called")
	}
	callInfo := struct {
		Namespace string
		Name      string
		Options   *metav1.DeleteOptions
	}{
		Namespace: namespace,
		Name:      name,
		Options:   options,
	}
	lockPipelineExecutionInterfaceMockDeleteNamespaced.Lock()
	mock.calls.DeleteNamespaced = append(mock.calls.DeleteNamespaced, callInfo)
	lockPipelineExecutionInterfaceMockDeleteNamespaced.Unlock()
	return mock.DeleteNamespacedFunc(namespace, name, options)
}

// DeleteNamespacedCalls gets all the calls that were made to DeleteNamespaced.
// Check the length with:
//     len(mockedPipelineExecutionInterface.DeleteNamespacedCalls())
func (mock *PipelineExecutionInterfaceMock) DeleteNamespacedCalls() []struct {
	Namespace string
	Name      string
	Options   *metav1.DeleteOptions
} {
	var calls []struct {
		Namespace string
		Name      string
		Options   *metav1.DeleteOptions
	}
	lockPipelineExecutionInterfaceMockDeleteNamespaced.RLock()
	calls = mock.calls.DeleteNamespaced
	lockPipelineExecutionInterfaceMockDeleteNamespaced.RUnlock()
	return calls
}

// Get calls GetFunc.
func (mock *PipelineExecutionInterfaceMock) Get(name string, opts metav1.GetOptions) (*v3.PipelineExecution, error) {
	if mock.GetFunc == nil {
		panic("PipelineExecutionInterfaceMock.GetFunc: method is nil but PipelineExecutionInterface.Get was just called")
	}
	callInfo := struct {
		Name string
		Opts metav1.GetOptions
	}{
		Name: name,
		Opts: opts,
	}
	lockPipelineExecutionInterfaceMockGet.Lock()
	mock.calls.Get = append(mock.calls.Get, callInfo)
	lockPipelineExecutionInterfaceMockGet.Unlock()
	return mock.GetFunc(name, opts)
}

// GetCalls gets all the calls that were made to Get.
// Check the length with:
//     len(mockedPipelineExecutionInterface.GetCalls())
func (mock *PipelineExecutionInterfaceMock) GetCalls() []struct {
	Name string
	Opts metav1.GetOptions
} {
	var calls []struct {
		Name string
		Opts metav1.GetOptions
	}
	lockPipelineExecutionInterfaceMockGet.RLock()
	calls = mock.calls.Get
	lockPipelineExecutionInterfaceMockGet.RUnlock()
	return calls
}

// GetNamespaced calls GetNamespacedFunc.
func (mock *PipelineExecutionInterfaceMock) GetNamespaced(namespace string, name string, opts metav1.GetOptions) (*v3.PipelineExecution, error) {
	if mock.GetNamespacedFunc == nil {
		panic("PipelineExecutionInterfaceMock.GetNamespacedFunc: method is nil but PipelineExecutionInterface.GetNamespaced was just called")
	}
	callInfo := struct {
		Namespace string
		Name      string
		Opts      metav1.GetOptions
	}{
		Namespace: namespace,
		Name:      name,
		Opts:      opts,
	}
	lockPipelineExecutionInterfaceMockGetNamespaced.Lock()
	mock.calls.GetNamespaced = append(mock.calls.GetNamespaced, callInfo)
	lockPipelineExecutionInterfaceMockGetNamespaced.Unlock()
	return mock.GetNamespacedFunc(namespace, name, opts)
}

// GetNamespacedCalls gets all the calls that were made to GetNamespaced.
// Check the length with:
//     len(mockedPipelineExecutionInterface.GetNamespacedCalls())
func (mock *PipelineExecutionInterfaceMock) GetNamespacedCalls() []struct {
	Namespace string
	Name      string
	Opts      metav1.GetOptions
} {
	var calls []struct {
		Namespace string
		Name      string
		Opts      metav1.GetOptions
	}
	lockPipelineExecutionInterfaceMockGetNamespaced.RLock()
	calls = mock.calls.GetNamespaced
	lockPipelineExecutionInterfaceMockGetNamespaced.RUnlock()
	return calls
}

// List calls ListFunc.
func (mock *PipelineExecutionInterfaceMock) List(opts metav1.ListOptions) (*v3.PipelineExecutionList, error) {
	if mock.ListFunc == nil {
		panic("PipelineExecutionInterfaceMock.ListFunc: method is nil but PipelineExecutionInterface.List was just called")
	}
	callInfo := struct {
		Opts metav1.ListOptions
	}{
		Opts: opts,
	}
	lockPipelineExecutionInterfaceMockList.Lock()
	mock.calls.List = append(mock.calls.List, callInfo)
	lockPipelineExecutionInterfaceMockList.Unlock()
	return mock.ListFunc(opts)
}

// ListCalls gets all the calls that were made to List.
// Check the length with:
//     len(mockedPipelineExecutionInterface.ListCalls())
func (mock *PipelineExecutionInterfaceMock) ListCalls() []struct {
	Opts metav1.ListOptions
} {
	var calls []struct {
		Opts metav1.ListOptions
	}
	lockPipelineExecutionInterfaceMockList.RLock()
	calls = mock.calls.List
	lockPipelineExecutionInterfaceMockList.RUnlock()
	return calls
}

// ListNamespaced calls ListNamespacedFunc.
func (mock *PipelineExecutionInterfaceMock) ListNamespaced(namespace string, opts metav1.ListOptions) (*v3.PipelineExecutionList, error) {
	if mock.ListNamespacedFunc == nil {
		panic("PipelineExecutionInterfaceMock.ListNamespacedFunc: method is nil but PipelineExecutionInterface.ListNamespaced was just called")
	}
	callInfo := struct {
		Namespace string
		Opts      metav1.ListOptions
	}{
		Namespace: namespace,
		Opts:      opts,
	}
	lockPipelineExecutionInterfaceMockListNamespaced.Lock()
	mock.calls.ListNamespaced = append(mock.calls.ListNamespaced, callInfo)
	lockPipelineExecutionInterfaceMockListNamespaced.Unlock()
	return mock.ListNamespacedFunc(namespace, opts)
}

// ListNamespacedCalls gets all the calls that were made to ListNamespaced.
// Check the length with:
//     len(mockedPipelineExecutionInterface.ListNamespacedCalls())
func (mock *PipelineExecutionInterfaceMock) ListNamespacedCalls() []struct {
	Namespace string
	Opts      metav1.ListOptions
} {
	var calls []struct {
		Namespace string
		Opts      metav1.ListOptions
	}
	lockPipelineExecutionInterfaceMockListNamespaced.RLock()
	calls = mock.calls.ListNamespaced
	lockPipelineExecutionInterfaceMockListNamespaced.RUnlock()
	return calls
}

// ObjectClient calls ObjectClientFunc.
func (mock *PipelineExecutionInterfaceMock) ObjectClient() *objectclient.ObjectClient {
	if mock.ObjectClientFunc == nil {
		panic("PipelineExecutionInterfaceMock.ObjectClientFunc: method is nil but PipelineExecutionInterface.ObjectClient was just called")
	}
	callInfo := struct {
	}{}
	lockPipelineExecutionInterfaceMockObjectClient.Lock()
	mock.calls.ObjectClient = append(mock.calls.ObjectClient, callInfo)
	lockPipelineExecutionInterfaceMockObjectClient.Unlock()
	return mock.ObjectClientFunc()
}

// ObjectClientCalls gets all the calls that were made to ObjectClient.
// Check the length with:
//     len(mockedPipelineExecutionInterface.ObjectClientCalls())
func (mock *PipelineExecutionInterfaceMock) ObjectClientCalls() []struct {
} {
	var calls []struct {
	}
	lockPipelineExecutionInterfaceMockObjectClient.RLock()
	calls = mock.calls.ObjectClient
	lockPipelineExecutionInterfaceMockObjectClient.RUnlock()
	return calls
}

// Update calls UpdateFunc.
func (mock *PipelineExecutionInterfaceMock) Update(in1 *v3.PipelineExecution) (*v3.PipelineExecution, error) {
	if mock.UpdateFunc == nil {
		panic("PipelineExecutionInterfaceMock.UpdateFunc: method is nil but PipelineExecutionInterface.Update was just called")
	}
	callInfo := struct {
		In1 *v3.PipelineExecution
	}{
		In1: in1,
	}
	lockPipelineExecutionInterfaceMockUpdate.Lock()
	mock.calls.Update = append(mock.calls.Update, callInfo)
	lockPipelineExecutionInterfaceMockUpdate.Unlock()
	return mock.UpdateFunc(in1)
}

// UpdateCalls gets all the calls that were made to Update.
// Check the length with:
//     len(mockedPipelineExecutionInterface.UpdateCalls())
func (mock *PipelineExecutionInterfaceMock) UpdateCalls() []struct {
	In1 *v3.PipelineExecution
} {
	var calls []struct {
		In1 *v3.PipelineExecution
	}
	lockPipelineExecutionInterfaceMockUpdate.RLock()
	calls = mock.calls.Update
	lockPipelineExecutionInterfaceMockUpdate.RUnlock()
	return calls
}

// Watch calls WatchFunc.
func (mock *PipelineExecutionInterfaceMock) Watch(opts metav1.ListOptions) (watch.Interface, error) {
	if mock.WatchFunc == nil {
		panic("PipelineExecutionInterfaceMock.WatchFunc: method is nil but PipelineExecutionInterface.Watch was just called")
	}
	callInfo := struct {
		Opts metav1.ListOptions
	}{
		Opts: opts,
	}
	lockPipelineExecutionInterfaceMockWatch.Lock()
	mock.calls.Watch = append(mock.calls.Watch, callInfo)
	lockPipelineExecutionInterfaceMockWatch.Unlock()
	return mock.WatchFunc(opts)
}

// WatchCalls gets all the calls that were made to Watch.
// Check the length with:
//     len(mockedPipelineExecutionInterface.WatchCalls())
func (mock *PipelineExecutionInterfaceMock) WatchCalls() []struct {
	Opts metav1.ListOptions
} {
	var calls []struct {
		Opts metav1.ListOptions
	}
	lockPipelineExecutionInterfaceMockWatch.RLock()
	calls = mock.calls.Watch
	lockPipelineExecutionInterfaceMockWatch.RUnlock()
	return calls
}

var (
	lockPipelineExecutionsGetterMockPipelineExecutions sync.RWMutex
)

// Ensure, that PipelineExecutionsGetterMock does implement v31.PipelineExecutionsGetter.
// If this is not the case, regenerate this file with moq.
var _ v31.PipelineExecutionsGetter = &PipelineExecutionsGetterMock{}

// PipelineExecutionsGetterMock is a mock implementation of v31.PipelineExecutionsGetter.
//
//     func TestSomethingThatUsesPipelineExecutionsGetter(t *testing.T) {
//
//         // make and configure a mocked v31.PipelineExecutionsGetter
//         mockedPipelineExecutionsGetter := &PipelineExecutionsGetterMock{
//             PipelineExecutionsFunc: func(namespace string) v31.PipelineExecutionInterface {
// 	               panic("mock out the PipelineExecutions method")
//             },
//         }
//
//         // use mockedPipelineExecutionsGetter in code that requires v31.PipelineExecutionsGetter
//         // and then make assertions.
//
//     }
type PipelineExecutionsGetterMock struct {
	// PipelineExecutionsFunc mocks the PipelineExecutions method.
	PipelineExecutionsFunc func(namespace string) v31.PipelineExecutionInterface

	// calls tracks calls to the methods.
	calls struct {
		// PipelineExecutions holds details about calls to the PipelineExecutions method.
		PipelineExecutions []struct {
			// Namespace is the namespace argument value.
			Namespace string
		}
	}
}

// PipelineExecutions calls PipelineExecutionsFunc.
func (mock *PipelineExecutionsGetterMock) PipelineExecutions(namespace string) v31.PipelineExecutionInterface {
	if mock.PipelineExecutionsFunc == nil {
		panic("PipelineExecutionsGetterMock.PipelineExecutionsFunc: method is nil but PipelineExecutionsGetter.PipelineExecutions was just called")
	}
	callInfo := struct {
		Namespace string
	}{
		Namespace: namespace,
	}
	lockPipelineExecutionsGetterMockPipelineExecutions.Lock()
	mock.calls.PipelineExecutions = append(mock.calls.PipelineExecutions, callInfo)
	lockPipelineExecutionsGetterMockPipelineExecutions.Unlock()
	return mock.PipelineExecutionsFunc(namespace)
}

// PipelineExecutionsCalls gets all the calls that were made to PipelineExecutions.
// Check the length with:
//     len(mockedPipelineExecutionsGetter.PipelineExecutionsCalls())
func (mock *PipelineExecutionsGetterMock) PipelineExecutionsCalls() []struct {
	Namespace string
} {
	var calls []struct {
		Namespace string
	}
	lockPipelineExecutionsGetterMockPipelineExecutions.RLock()
	calls = mock.calls.PipelineExecutions
	lockPipelineExecutionsGetterMockPipelineExecutions.RUnlock()
	return calls
}
