// Code generated by moq; DO NOT EDIT.
// github.com/matryer/moq

package fakes

import (
	"context"
	"sync"
	"time"

	"github.com/rancher/norman/controller"
	"github.com/rancher/norman/objectclient"
	v3 "github.com/rancher/rancher/pkg/apis/project.cattle.io/v3"
	v31 "github.com/rancher/rancher/pkg/generated/norman/project.cattle.io/v3"
	metav1 "k8s.io/apimachinery/pkg/apis/meta/v1"
	"k8s.io/apimachinery/pkg/labels"
	"k8s.io/apimachinery/pkg/watch"
	"k8s.io/client-go/tools/cache"
)

var (
	lockPipelineListerMockGet  sync.RWMutex
	lockPipelineListerMockList sync.RWMutex
)

// Ensure, that PipelineListerMock does implement v31.PipelineLister.
// If this is not the case, regenerate this file with moq.
var _ v31.PipelineLister = &PipelineListerMock{}

// PipelineListerMock is a mock implementation of v31.PipelineLister.
//
//     func TestSomethingThatUsesPipelineLister(t *testing.T) {
//
//         // make and configure a mocked v31.PipelineLister
//         mockedPipelineLister := &PipelineListerMock{
//             GetFunc: func(namespace string, name string) (*v3.Pipeline, error) {
// 	               panic("mock out the Get method")
//             },
//             ListFunc: func(namespace string, selector labels.Selector) ([]*v3.Pipeline, error) {
// 	               panic("mock out the List method")
//             },
//         }
//
//         // use mockedPipelineLister in code that requires v31.PipelineLister
//         // and then make assertions.
//
//     }
type PipelineListerMock struct {
	// GetFunc mocks the Get method.
	GetFunc func(namespace string, name string) (*v3.Pipeline, error)

	// ListFunc mocks the List method.
	ListFunc func(namespace string, selector labels.Selector) ([]*v3.Pipeline, error)

	// calls tracks calls to the methods.
	calls struct {
		// Get holds details about calls to the Get method.
		Get []struct {
			// Namespace is the namespace argument value.
			Namespace string
			// Name is the name argument value.
			Name string
		}
		// List holds details about calls to the List method.
		List []struct {
			// Namespace is the namespace argument value.
			Namespace string
			// Selector is the selector argument value.
			Selector labels.Selector
		}
	}
}

// Get calls GetFunc.
func (mock *PipelineListerMock) Get(namespace string, name string) (*v3.Pipeline, error) {
	if mock.GetFunc == nil {
		panic("PipelineListerMock.GetFunc: method is nil but PipelineLister.Get was just called")
	}
	callInfo := struct {
		Namespace string
		Name      string
	}{
		Namespace: namespace,
		Name:      name,
	}
	lockPipelineListerMockGet.Lock()
	mock.calls.Get = append(mock.calls.Get, callInfo)
	lockPipelineListerMockGet.Unlock()
	return mock.GetFunc(namespace, name)
}

// GetCalls gets all the calls that were made to Get.
// Check the length with:
//     len(mockedPipelineLister.GetCalls())
func (mock *PipelineListerMock) GetCalls() []struct {
	Namespace string
	Name      string
} {
	var calls []struct {
		Namespace string
		Name      string
	}
	lockPipelineListerMockGet.RLock()
	calls = mock.calls.Get
	lockPipelineListerMockGet.RUnlock()
	return calls
}

// List calls ListFunc.
func (mock *PipelineListerMock) List(namespace string, selector labels.Selector) ([]*v3.Pipeline, error) {
	if mock.ListFunc == nil {
		panic("PipelineListerMock.ListFunc: method is nil but PipelineLister.List was just called")
	}
	callInfo := struct {
		Namespace string
		Selector  labels.Selector
	}{
		Namespace: namespace,
		Selector:  selector,
	}
	lockPipelineListerMockList.Lock()
	mock.calls.List = append(mock.calls.List, callInfo)
	lockPipelineListerMockList.Unlock()
	return mock.ListFunc(namespace, selector)
}

// ListCalls gets all the calls that were made to List.
// Check the length with:
//     len(mockedPipelineLister.ListCalls())
func (mock *PipelineListerMock) ListCalls() []struct {
	Namespace string
	Selector  labels.Selector
} {
	var calls []struct {
		Namespace string
		Selector  labels.Selector
	}
	lockPipelineListerMockList.RLock()
	calls = mock.calls.List
	lockPipelineListerMockList.RUnlock()
	return calls
}

var (
	lockPipelineControllerMockAddClusterScopedFeatureHandler sync.RWMutex
	lockPipelineControllerMockAddClusterScopedHandler        sync.RWMutex
	lockPipelineControllerMockAddFeatureHandler              sync.RWMutex
	lockPipelineControllerMockAddHandler                     sync.RWMutex
	lockPipelineControllerMockEnqueue                        sync.RWMutex
	lockPipelineControllerMockEnqueueAfter                   sync.RWMutex
	lockPipelineControllerMockGeneric                        sync.RWMutex
	lockPipelineControllerMockInformer                       sync.RWMutex
	lockPipelineControllerMockLister                         sync.RWMutex
)

// Ensure, that PipelineControllerMock does implement v31.PipelineController.
// If this is not the case, regenerate this file with moq.
var _ v31.PipelineController = &PipelineControllerMock{}

// PipelineControllerMock is a mock implementation of v31.PipelineController.
//
//     func TestSomethingThatUsesPipelineController(t *testing.T) {
//
//         // make and configure a mocked v31.PipelineController
//         mockedPipelineController := &PipelineControllerMock{
//             AddClusterScopedFeatureHandlerFunc: func(ctx context.Context, enabled func() bool, name string, clusterName string, handler v31.PipelineHandlerFunc)  {
// 	               panic("mock out the AddClusterScopedFeatureHandler method")
//             },
//             AddClusterScopedHandlerFunc: func(ctx context.Context, name string, clusterName string, handler v31.PipelineHandlerFunc)  {
// 	               panic("mock out the AddClusterScopedHandler method")
//             },
//             AddFeatureHandlerFunc: func(ctx context.Context, enabled func() bool, name string, syncMoqParam v31.PipelineHandlerFunc)  {
// 	               panic("mock out the AddFeatureHandler method")
//             },
//             AddHandlerFunc: func(ctx context.Context, name string, handler v31.PipelineHandlerFunc)  {
// 	               panic("mock out the AddHandler method")
//             },
//             EnqueueFunc: func(namespace string, name string)  {
// 	               panic("mock out the Enqueue method")
//             },
//             EnqueueAfterFunc: func(namespace string, name string, after time.Duration)  {
// 	               panic("mock out the EnqueueAfter method")
//             },
//             GenericFunc: func() controller.GenericController {
// 	               panic("mock out the Generic method")
//             },
//             InformerFunc: func() cache.SharedIndexInformer {
// 	               panic("mock out the Informer method")
//             },
//             ListerFunc: func() v31.PipelineLister {
// 	               panic("mock out the Lister method")
//             },
//         }
//
//         // use mockedPipelineController in code that requires v31.PipelineController
//         // and then make assertions.
//
//     }
type PipelineControllerMock struct {
	// AddClusterScopedFeatureHandlerFunc mocks the AddClusterScopedFeatureHandler method.
	AddClusterScopedFeatureHandlerFunc func(ctx context.Context, enabled func() bool, name string, clusterName string, handler v31.PipelineHandlerFunc)

	// AddClusterScopedHandlerFunc mocks the AddClusterScopedHandler method.
	AddClusterScopedHandlerFunc func(ctx context.Context, name string, clusterName string, handler v31.PipelineHandlerFunc)

	// AddFeatureHandlerFunc mocks the AddFeatureHandler method.
	AddFeatureHandlerFunc func(ctx context.Context, enabled func() bool, name string, syncMoqParam v31.PipelineHandlerFunc)

	// AddHandlerFunc mocks the AddHandler method.
	AddHandlerFunc func(ctx context.Context, name string, handler v31.PipelineHandlerFunc)

	// EnqueueFunc mocks the Enqueue method.
	EnqueueFunc func(namespace string, name string)

	// EnqueueAfterFunc mocks the EnqueueAfter method.
	EnqueueAfterFunc func(namespace string, name string, after time.Duration)

	// GenericFunc mocks the Generic method.
	GenericFunc func() controller.GenericController

	// InformerFunc mocks the Informer method.
	InformerFunc func() cache.SharedIndexInformer

	// ListerFunc mocks the Lister method.
	ListerFunc func() v31.PipelineLister

	// calls tracks calls to the methods.
	calls struct {
		// AddClusterScopedFeatureHandler holds details about calls to the AddClusterScopedFeatureHandler method.
		AddClusterScopedFeatureHandler []struct {
			// Ctx is the ctx argument value.
			Ctx context.Context
			// Enabled is the enabled argument value.
			Enabled func() bool
			// Name is the name argument value.
			Name string
			// ClusterName is the clusterName argument value.
			ClusterName string
			// Handler is the handler argument value.
			Handler v31.PipelineHandlerFunc
		}
		// AddClusterScopedHandler holds details about calls to the AddClusterScopedHandler method.
		AddClusterScopedHandler []struct {
			// Ctx is the ctx argument value.
			Ctx context.Context
			// Name is the name argument value.
			Name string
			// ClusterName is the clusterName argument value.
			ClusterName string
			// Handler is the handler argument value.
			Handler v31.PipelineHandlerFunc
		}
		// AddFeatureHandler holds details about calls to the AddFeatureHandler method.
		AddFeatureHandler []struct {
			// Ctx is the ctx argument value.
			Ctx context.Context
			// Enabled is the enabled argument value.
			Enabled func() bool
			// Name is the name argument value.
			Name string
			// Sync is the sync argument value.
			Sync v31.PipelineHandlerFunc
		}
		// AddHandler holds details about calls to the AddHandler method.
		AddHandler []struct {
			// Ctx is the ctx argument value.
			Ctx context.Context
			// Name is the name argument value.
			Name string
			// Handler is the handler argument value.
			Handler v31.PipelineHandlerFunc
		}
		// Enqueue holds details about calls to the Enqueue method.
		Enqueue []struct {
			// Namespace is the namespace argument value.
			Namespace string
			// Name is the name argument value.
			Name string
		}
		// EnqueueAfter holds details about calls to the EnqueueAfter method.
		EnqueueAfter []struct {
			// Namespace is the namespace argument value.
			Namespace string
			// Name is the name argument value.
			Name string
			// After is the after argument value.
			After time.Duration
		}
		// Generic holds details about calls to the Generic method.
		Generic []struct {
		}
		// Informer holds details about calls to the Informer method.
		Informer []struct {
		}
		// Lister holds details about calls to the Lister method.
		Lister []struct {
		}
	}
}

// AddClusterScopedFeatureHandler calls AddClusterScopedFeatureHandlerFunc.
func (mock *PipelineControllerMock) AddClusterScopedFeatureHandler(ctx context.Context, enabled func() bool, name string, clusterName string, handler v31.PipelineHandlerFunc) {
	if mock.AddClusterScopedFeatureHandlerFunc == nil {
		panic("PipelineControllerMock.AddClusterScopedFeatureHandlerFunc: method is nil but PipelineController.AddClusterScopedFeatureHandler was just called")
	}
	callInfo := struct {
		Ctx         context.Context
		Enabled     func() bool
		Name        string
		ClusterName string
		Handler     v31.PipelineHandlerFunc
	}{
		Ctx:         ctx,
		Enabled:     enabled,
		Name:        name,
		ClusterName: clusterName,
		Handler:     handler,
	}
	lockPipelineControllerMockAddClusterScopedFeatureHandler.Lock()
	mock.calls.AddClusterScopedFeatureHandler = append(mock.calls.AddClusterScopedFeatureHandler, callInfo)
	lockPipelineControllerMockAddClusterScopedFeatureHandler.Unlock()
	mock.AddClusterScopedFeatureHandlerFunc(ctx, enabled, name, clusterName, handler)
}

// AddClusterScopedFeatureHandlerCalls gets all the calls that were made to AddClusterScopedFeatureHandler.
// Check the length with:
//     len(mockedPipelineController.AddClusterScopedFeatureHandlerCalls())
func (mock *PipelineControllerMock) AddClusterScopedFeatureHandlerCalls() []struct {
	Ctx         context.Context
	Enabled     func() bool
	Name        string
	ClusterName string
	Handler     v31.PipelineHandlerFunc
} {
	var calls []struct {
		Ctx         context.Context
		Enabled     func() bool
		Name        string
		ClusterName string
		Handler     v31.PipelineHandlerFunc
	}
	lockPipelineControllerMockAddClusterScopedFeatureHandler.RLock()
	calls = mock.calls.AddClusterScopedFeatureHandler
	lockPipelineControllerMockAddClusterScopedFeatureHandler.RUnlock()
	return calls
}

// AddClusterScopedHandler calls AddClusterScopedHandlerFunc.
func (mock *PipelineControllerMock) AddClusterScopedHandler(ctx context.Context, name string, clusterName string, handler v31.PipelineHandlerFunc) {
	if mock.AddClusterScopedHandlerFunc == nil {
		panic("PipelineControllerMock.AddClusterScopedHandlerFunc: method is nil but PipelineController.AddClusterScopedHandler was just called")
	}
	callInfo := struct {
		Ctx         context.Context
		Name        string
		ClusterName string
		Handler     v31.PipelineHandlerFunc
	}{
		Ctx:         ctx,
		Name:        name,
		ClusterName: clusterName,
		Handler:     handler,
	}
	lockPipelineControllerMockAddClusterScopedHandler.Lock()
	mock.calls.AddClusterScopedHandler = append(mock.calls.AddClusterScopedHandler, callInfo)
	lockPipelineControllerMockAddClusterScopedHandler.Unlock()
	mock.AddClusterScopedHandlerFunc(ctx, name, clusterName, handler)
}

// AddClusterScopedHandlerCalls gets all the calls that were made to AddClusterScopedHandler.
// Check the length with:
//     len(mockedPipelineController.AddClusterScopedHandlerCalls())
func (mock *PipelineControllerMock) AddClusterScopedHandlerCalls() []struct {
	Ctx         context.Context
	Name        string
	ClusterName string
	Handler     v31.PipelineHandlerFunc
} {
	var calls []struct {
		Ctx         context.Context
		Name        string
		ClusterName string
		Handler     v31.PipelineHandlerFunc
	}
	lockPipelineControllerMockAddClusterScopedHandler.RLock()
	calls = mock.calls.AddClusterScopedHandler
	lockPipelineControllerMockAddClusterScopedHandler.RUnlock()
	return calls
}

// AddFeatureHandler calls AddFeatureHandlerFunc.
func (mock *PipelineControllerMock) AddFeatureHandler(ctx context.Context, enabled func() bool, name string, syncMoqParam v31.PipelineHandlerFunc) {
	if mock.AddFeatureHandlerFunc == nil {
		panic("PipelineControllerMock.AddFeatureHandlerFunc: method is nil but PipelineController.AddFeatureHandler was just called")
	}
	callInfo := struct {
		Ctx     context.Context
		Enabled func() bool
		Name    string
		Sync    v31.PipelineHandlerFunc
	}{
		Ctx:     ctx,
		Enabled: enabled,
		Name:    name,
		Sync:    syncMoqParam,
	}
	lockPipelineControllerMockAddFeatureHandler.Lock()
	mock.calls.AddFeatureHandler = append(mock.calls.AddFeatureHandler, callInfo)
	lockPipelineControllerMockAddFeatureHandler.Unlock()
	mock.AddFeatureHandlerFunc(ctx, enabled, name, syncMoqParam)
}

// AddFeatureHandlerCalls gets all the calls that were made to AddFeatureHandler.
// Check the length with:
//     len(mockedPipelineController.AddFeatureHandlerCalls())
func (mock *PipelineControllerMock) AddFeatureHandlerCalls() []struct {
	Ctx     context.Context
	Enabled func() bool
	Name    string
	Sync    v31.PipelineHandlerFunc
} {
	var calls []struct {
		Ctx     context.Context
		Enabled func() bool
		Name    string
		Sync    v31.PipelineHandlerFunc
	}
	lockPipelineControllerMockAddFeatureHandler.RLock()
	calls = mock.calls.AddFeatureHandler
	lockPipelineControllerMockAddFeatureHandler.RUnlock()
	return calls
}

// AddHandler calls AddHandlerFunc.
func (mock *PipelineControllerMock) AddHandler(ctx context.Context, name string, handler v31.PipelineHandlerFunc) {
	if mock.AddHandlerFunc == nil {
		panic("PipelineControllerMock.AddHandlerFunc: method is nil but PipelineController.AddHandler was just called")
	}
	callInfo := struct {
		Ctx     context.Context
		Name    string
		Handler v31.PipelineHandlerFunc
	}{
		Ctx:     ctx,
		Name:    name,
		Handler: handler,
	}
	lockPipelineControllerMockAddHandler.Lock()
	mock.calls.AddHandler = append(mock.calls.AddHandler, callInfo)
	lockPipelineControllerMockAddHandler.Unlock()
	mock.AddHandlerFunc(ctx, name, handler)
}

// AddHandlerCalls gets all the calls that were made to AddHandler.
// Check the length with:
//     len(mockedPipelineController.AddHandlerCalls())
func (mock *PipelineControllerMock) AddHandlerCalls() []struct {
	Ctx     context.Context
	Name    string
	Handler v31.PipelineHandlerFunc
} {
	var calls []struct {
		Ctx     context.Context
		Name    string
		Handler v31.PipelineHandlerFunc
	}
	lockPipelineControllerMockAddHandler.RLock()
	calls = mock.calls.AddHandler
	lockPipelineControllerMockAddHandler.RUnlock()
	return calls
}

// Enqueue calls EnqueueFunc.
func (mock *PipelineControllerMock) Enqueue(namespace string, name string) {
	if mock.EnqueueFunc == nil {
		panic("PipelineControllerMock.EnqueueFunc: method is nil but PipelineController.Enqueue was just called")
	}
	callInfo := struct {
		Namespace string
		Name      string
	}{
		Namespace: namespace,
		Name:      name,
	}
	lockPipelineControllerMockEnqueue.Lock()
	mock.calls.Enqueue = append(mock.calls.Enqueue, callInfo)
	lockPipelineControllerMockEnqueue.Unlock()
	mock.EnqueueFunc(namespace, name)
}

// EnqueueCalls gets all the calls that were made to Enqueue.
// Check the length with:
//     len(mockedPipelineController.EnqueueCalls())
func (mock *PipelineControllerMock) EnqueueCalls() []struct {
	Namespace string
	Name      string
} {
	var calls []struct {
		Namespace string
		Name      string
	}
	lockPipelineControllerMockEnqueue.RLock()
	calls = mock.calls.Enqueue
	lockPipelineControllerMockEnqueue.RUnlock()
	return calls
}

// EnqueueAfter calls EnqueueAfterFunc.
func (mock *PipelineControllerMock) EnqueueAfter(namespace string, name string, after time.Duration) {
	if mock.EnqueueAfterFunc == nil {
		panic("PipelineControllerMock.EnqueueAfterFunc: method is nil but PipelineController.EnqueueAfter was just called")
	}
	callInfo := struct {
		Namespace string
		Name      string
		After     time.Duration
	}{
		Namespace: namespace,
		Name:      name,
		After:     after,
	}
	lockPipelineControllerMockEnqueueAfter.Lock()
	mock.calls.EnqueueAfter = append(mock.calls.EnqueueAfter, callInfo)
	lockPipelineControllerMockEnqueueAfter.Unlock()
	mock.EnqueueAfterFunc(namespace, name, after)
}

// EnqueueAfterCalls gets all the calls that were made to EnqueueAfter.
// Check the length with:
//     len(mockedPipelineController.EnqueueAfterCalls())
func (mock *PipelineControllerMock) EnqueueAfterCalls() []struct {
	Namespace string
	Name      string
	After     time.Duration
} {
	var calls []struct {
		Namespace string
		Name      string
		After     time.Duration
	}
	lockPipelineControllerMockEnqueueAfter.RLock()
	calls = mock.calls.EnqueueAfter
	lockPipelineControllerMockEnqueueAfter.RUnlock()
	return calls
}

// Generic calls GenericFunc.
func (mock *PipelineControllerMock) Generic() controller.GenericController {
	if mock.GenericFunc == nil {
		panic("PipelineControllerMock.GenericFunc: method is nil but PipelineController.Generic was just called")
	}
	callInfo := struct {
	}{}
	lockPipelineControllerMockGeneric.Lock()
	mock.calls.Generic = append(mock.calls.Generic, callInfo)
	lockPipelineControllerMockGeneric.Unlock()
	return mock.GenericFunc()
}

// GenericCalls gets all the calls that were made to Generic.
// Check the length with:
//     len(mockedPipelineController.GenericCalls())
func (mock *PipelineControllerMock) GenericCalls() []struct {
} {
	var calls []struct {
	}
	lockPipelineControllerMockGeneric.RLock()
	calls = mock.calls.Generic
	lockPipelineControllerMockGeneric.RUnlock()
	return calls
}

// Informer calls InformerFunc.
func (mock *PipelineControllerMock) Informer() cache.SharedIndexInformer {
	if mock.InformerFunc == nil {
		panic("PipelineControllerMock.InformerFunc: method is nil but PipelineController.Informer was just called")
	}
	callInfo := struct {
	}{}
	lockPipelineControllerMockInformer.Lock()
	mock.calls.Informer = append(mock.calls.Informer, callInfo)
	lockPipelineControllerMockInformer.Unlock()
	return mock.InformerFunc()
}

// InformerCalls gets all the calls that were made to Informer.
// Check the length with:
//     len(mockedPipelineController.InformerCalls())
func (mock *PipelineControllerMock) InformerCalls() []struct {
} {
	var calls []struct {
	}
	lockPipelineControllerMockInformer.RLock()
	calls = mock.calls.Informer
	lockPipelineControllerMockInformer.RUnlock()
	return calls
}

// Lister calls ListerFunc.
func (mock *PipelineControllerMock) Lister() v31.PipelineLister {
	if mock.ListerFunc == nil {
		panic("PipelineControllerMock.ListerFunc: method is nil but PipelineController.Lister was just called")
	}
	callInfo := struct {
	}{}
	lockPipelineControllerMockLister.Lock()
	mock.calls.Lister = append(mock.calls.Lister, callInfo)
	lockPipelineControllerMockLister.Unlock()
	return mock.ListerFunc()
}

// ListerCalls gets all the calls that were made to Lister.
// Check the length with:
//     len(mockedPipelineController.ListerCalls())
func (mock *PipelineControllerMock) ListerCalls() []struct {
} {
	var calls []struct {
	}
	lockPipelineControllerMockLister.RLock()
	calls = mock.calls.Lister
	lockPipelineControllerMockLister.RUnlock()
	return calls
}

var (
	lockPipelineInterfaceMockAddClusterScopedFeatureHandler   sync.RWMutex
	lockPipelineInterfaceMockAddClusterScopedFeatureLifecycle sync.RWMutex
	lockPipelineInterfaceMockAddClusterScopedHandler          sync.RWMutex
	lockPipelineInterfaceMockAddClusterScopedLifecycle        sync.RWMutex
	lockPipelineInterfaceMockAddFeatureHandler                sync.RWMutex
	lockPipelineInterfaceMockAddFeatureLifecycle              sync.RWMutex
	lockPipelineInterfaceMockAddHandler                       sync.RWMutex
	lockPipelineInterfaceMockAddLifecycle                     sync.RWMutex
	lockPipelineInterfaceMockController                       sync.RWMutex
	lockPipelineInterfaceMockCreate                           sync.RWMutex
	lockPipelineInterfaceMockDelete                           sync.RWMutex
	lockPipelineInterfaceMockDeleteCollection                 sync.RWMutex
	lockPipelineInterfaceMockDeleteNamespaced                 sync.RWMutex
	lockPipelineInterfaceMockGet                              sync.RWMutex
	lockPipelineInterfaceMockGetNamespaced                    sync.RWMutex
	lockPipelineInterfaceMockList                             sync.RWMutex
	lockPipelineInterfaceMockListNamespaced                   sync.RWMutex
	lockPipelineInterfaceMockObjectClient                     sync.RWMutex
	lockPipelineInterfaceMockUpdate                           sync.RWMutex
	lockPipelineInterfaceMockWatch                            sync.RWMutex
)

// Ensure, that PipelineInterfaceMock does implement v31.PipelineInterface.
// If this is not the case, regenerate this file with moq.
var _ v31.PipelineInterface = &PipelineInterfaceMock{}

// PipelineInterfaceMock is a mock implementation of v31.PipelineInterface.
//
//     func TestSomethingThatUsesPipelineInterface(t *testing.T) {
//
//         // make and configure a mocked v31.PipelineInterface
//         mockedPipelineInterface := &PipelineInterfaceMock{
//             AddClusterScopedFeatureHandlerFunc: func(ctx context.Context, enabled func() bool, name string, clusterName string, syncMoqParam v31.PipelineHandlerFunc)  {
// 	               panic("mock out the AddClusterScopedFeatureHandler method")
//             },
//             AddClusterScopedFeatureLifecycleFunc: func(ctx context.Context, enabled func() bool, name string, clusterName string, lifecycle v31.PipelineLifecycle)  {
// 	               panic("mock out the AddClusterScopedFeatureLifecycle method")
//             },
//             AddClusterScopedHandlerFunc: func(ctx context.Context, name string, clusterName string, syncMoqParam v31.PipelineHandlerFunc)  {
// 	               panic("mock out the AddClusterScopedHandler method")
//             },
//             AddClusterScopedLifecycleFunc: func(ctx context.Context, name string, clusterName string, lifecycle v31.PipelineLifecycle)  {
// 	               panic("mock out the AddClusterScopedLifecycle method")
//             },
//             AddFeatureHandlerFunc: func(ctx context.Context, enabled func() bool, name string, syncMoqParam v31.PipelineHandlerFunc)  {
// 	               panic("mock out the AddFeatureHandler method")
//             },
//             AddFeatureLifecycleFunc: func(ctx context.Context, enabled func() bool, name string, lifecycle v31.PipelineLifecycle)  {
// 	               panic("mock out the AddFeatureLifecycle method")
//             },
//             AddHandlerFunc: func(ctx context.Context, name string, syncMoqParam v31.PipelineHandlerFunc)  {
// 	               panic("mock out the AddHandler method")
//             },
//             AddLifecycleFunc: func(ctx context.Context, name string, lifecycle v31.PipelineLifecycle)  {
// 	               panic("mock out the AddLifecycle method")
//             },
//             ControllerFunc: func() v31.PipelineController {
// 	               panic("mock out the Controller method")
//             },
//             CreateFunc: func(in1 *v3.Pipeline) (*v3.Pipeline, error) {
// 	               panic("mock out the Create method")
//             },
//             DeleteFunc: func(name string, options *metav1.DeleteOptions) error {
// 	               panic("mock out the Delete method")
//             },
//             DeleteCollectionFunc: func(deleteOpts *metav1.DeleteOptions, listOpts metav1.ListOptions) error {
// 	               panic("mock out the DeleteCollection method")
//             },
//             DeleteNamespacedFunc: func(namespace string, name string, options *metav1.DeleteOptions) error {
// 	               panic("mock out the DeleteNamespaced method")
//             },
//             GetFunc: func(name string, opts metav1.GetOptions) (*v3.Pipeline, error) {
// 	               panic("mock out the Get method")
//             },
//             GetNamespacedFunc: func(namespace string, name string, opts metav1.GetOptions) (*v3.Pipeline, error) {
// 	               panic("mock out the GetNamespaced method")
//             },
//             ListFunc: func(opts metav1.ListOptions) (*v3.PipelineList, error) {
// 	               panic("mock out the List method")
//             },
//             ListNamespacedFunc: func(namespace string, opts metav1.ListOptions) (*v3.PipelineList, error) {
// 	               panic("mock out the ListNamespaced method")
//             },
//             ObjectClientFunc: func() *objectclient.ObjectClient {
// 	               panic("mock out the ObjectClient method")
//             },
//             UpdateFunc: func(in1 *v3.Pipeline) (*v3.Pipeline, error) {
// 	               panic("mock out the Update method")
//             },
//             WatchFunc: func(opts metav1.ListOptions) (watch.Interface, error) {
// 	               panic("mock out the Watch method")
//             },
//         }
//
//         // use mockedPipelineInterface in code that requires v31.PipelineInterface
//         // and then make assertions.
//
//     }
type PipelineInterfaceMock struct {
	// AddClusterScopedFeatureHandlerFunc mocks the AddClusterScopedFeatureHandler method.
	AddClusterScopedFeatureHandlerFunc func(ctx context.Context, enabled func() bool, name string, clusterName string, syncMoqParam v31.PipelineHandlerFunc)

	// AddClusterScopedFeatureLifecycleFunc mocks the AddClusterScopedFeatureLifecycle method.
	AddClusterScopedFeatureLifecycleFunc func(ctx context.Context, enabled func() bool, name string, clusterName string, lifecycle v31.PipelineLifecycle)

	// AddClusterScopedHandlerFunc mocks the AddClusterScopedHandler method.
	AddClusterScopedHandlerFunc func(ctx context.Context, name string, clusterName string, syncMoqParam v31.PipelineHandlerFunc)

	// AddClusterScopedLifecycleFunc mocks the AddClusterScopedLifecycle method.
	AddClusterScopedLifecycleFunc func(ctx context.Context, name string, clusterName string, lifecycle v31.PipelineLifecycle)

	// AddFeatureHandlerFunc mocks the AddFeatureHandler method.
	AddFeatureHandlerFunc func(ctx context.Context, enabled func() bool, name string, syncMoqParam v31.PipelineHandlerFunc)

	// AddFeatureLifecycleFunc mocks the AddFeatureLifecycle method.
	AddFeatureLifecycleFunc func(ctx context.Context, enabled func() bool, name string, lifecycle v31.PipelineLifecycle)

	// AddHandlerFunc mocks the AddHandler method.
	AddHandlerFunc func(ctx context.Context, name string, syncMoqParam v31.PipelineHandlerFunc)

	// AddLifecycleFunc mocks the AddLifecycle method.
	AddLifecycleFunc func(ctx context.Context, name string, lifecycle v31.PipelineLifecycle)

	// ControllerFunc mocks the Controller method.
	ControllerFunc func() v31.PipelineController

	// CreateFunc mocks the Create method.
	CreateFunc func(in1 *v3.Pipeline) (*v3.Pipeline, error)

	// DeleteFunc mocks the Delete method.
	DeleteFunc func(name string, options *metav1.DeleteOptions) error

	// DeleteCollectionFunc mocks the DeleteCollection method.
	DeleteCollectionFunc func(deleteOpts *metav1.DeleteOptions, listOpts metav1.ListOptions) error

	// DeleteNamespacedFunc mocks the DeleteNamespaced method.
	DeleteNamespacedFunc func(namespace string, name string, options *metav1.DeleteOptions) error

	// GetFunc mocks the Get method.
	GetFunc func(name string, opts metav1.GetOptions) (*v3.Pipeline, error)

	// GetNamespacedFunc mocks the GetNamespaced method.
	GetNamespacedFunc func(namespace string, name string, opts metav1.GetOptions) (*v3.Pipeline, error)

	// ListFunc mocks the List method.
	ListFunc func(opts metav1.ListOptions) (*v3.PipelineList, error)

	// ListNamespacedFunc mocks the ListNamespaced method.
	ListNamespacedFunc func(namespace string, opts metav1.ListOptions) (*v3.PipelineList, error)

	// ObjectClientFunc mocks the ObjectClient method.
	ObjectClientFunc func() *objectclient.ObjectClient

	// UpdateFunc mocks the Update method.
	UpdateFunc func(in1 *v3.Pipeline) (*v3.Pipeline, error)

	// WatchFunc mocks the Watch method.
	WatchFunc func(opts metav1.ListOptions) (watch.Interface, error)

	// calls tracks calls to the methods.
	calls struct {
		// AddClusterScopedFeatureHandler holds details about calls to the AddClusterScopedFeatureHandler method.
		AddClusterScopedFeatureHandler []struct {
			// Ctx is the ctx argument value.
			Ctx context.Context
			// Enabled is the enabled argument value.
			Enabled func() bool
			// Name is the name argument value.
			Name string
			// ClusterName is the clusterName argument value.
			ClusterName string
			// Sync is the sync argument value.
			Sync v31.PipelineHandlerFunc
		}
		// AddClusterScopedFeatureLifecycle holds details about calls to the AddClusterScopedFeatureLifecycle method.
		AddClusterScopedFeatureLifecycle []struct {
			// Ctx is the ctx argument value.
			Ctx context.Context
			// Enabled is the enabled argument value.
			Enabled func() bool
			// Name is the name argument value.
			Name string
			// ClusterName is the clusterName argument value.
			ClusterName string
			// Lifecycle is the lifecycle argument value.
			Lifecycle v31.PipelineLifecycle
		}
		// AddClusterScopedHandler holds details about calls to the AddClusterScopedHandler method.
		AddClusterScopedHandler []struct {
			// Ctx is the ctx argument value.
			Ctx context.Context
			// Name is the name argument value.
			Name string
			// ClusterName is the clusterName argument value.
			ClusterName string
			// Sync is the sync argument value.
			Sync v31.PipelineHandlerFunc
		}
		// AddClusterScopedLifecycle holds details about calls to the AddClusterScopedLifecycle method.
		AddClusterScopedLifecycle []struct {
			// Ctx is the ctx argument value.
			Ctx context.Context
			// Name is the name argument value.
			Name string
			// ClusterName is the clusterName argument value.
			ClusterName string
			// Lifecycle is the lifecycle argument value.
			Lifecycle v31.PipelineLifecycle
		}
		// AddFeatureHandler holds details about calls to the AddFeatureHandler method.
		AddFeatureHandler []struct {
			// Ctx is the ctx argument value.
			Ctx context.Context
			// Enabled is the enabled argument value.
			Enabled func() bool
			// Name is the name argument value.
			Name string
			// Sync is the sync argument value.
			Sync v31.PipelineHandlerFunc
		}
		// AddFeatureLifecycle holds details about calls to the AddFeatureLifecycle method.
		AddFeatureLifecycle []struct {
			// Ctx is the ctx argument value.
			Ctx context.Context
			// Enabled is the enabled argument value.
			Enabled func() bool
			// Name is the name argument value.
			Name string
			// Lifecycle is the lifecycle argument value.
			Lifecycle v31.PipelineLifecycle
		}
		// AddHandler holds details about calls to the AddHandler method.
		AddHandler []struct {
			// Ctx is the ctx argument value.
			Ctx context.Context
			// Name is the name argument value.
			Name string
			// Sync is the sync argument value.
			Sync v31.PipelineHandlerFunc
		}
		// AddLifecycle holds details about calls to the AddLifecycle method.
		AddLifecycle []struct {
			// Ctx is the ctx argument value.
			Ctx context.Context
			// Name is the name argument value.
			Name string
			// Lifecycle is the lifecycle argument value.
			Lifecycle v31.PipelineLifecycle
		}
		// Controller holds details about calls to the Controller method.
		Controller []struct {
		}
		// Create holds details about calls to the Create method.
		Create []struct {
			// In1 is the in1 argument value.
			In1 *v3.Pipeline
		}
		// Delete holds details about calls to the Delete method.
		Delete []struct {
			// Name is the name argument value.
			Name string
			// Options is the options argument value.
			Options *metav1.DeleteOptions
		}
		// DeleteCollection holds details about calls to the DeleteCollection method.
		DeleteCollection []struct {
			// DeleteOpts is the deleteOpts argument value.
			DeleteOpts *metav1.DeleteOptions
			// ListOpts is the listOpts argument value.
			ListOpts metav1.ListOptions
		}
		// DeleteNamespaced holds details about calls to the DeleteNamespaced method.
		DeleteNamespaced []struct {
			// Namespace is the namespace argument value.
			Namespace string
			// Name is the name argument value.
			Name string
			// Options is the options argument value.
			Options *metav1.DeleteOptions
		}
		// Get holds details about calls to the Get method.
		Get []struct {
			// Name is the name argument value.
			Name string
			// Opts is the opts argument value.
			Opts metav1.GetOptions
		}
		// GetNamespaced holds details about calls to the GetNamespaced method.
		GetNamespaced []struct {
			// Namespace is the namespace argument value.
			Namespace string
			// Name is the name argument value.
			Name string
			// Opts is the opts argument value.
			Opts metav1.GetOptions
		}
		// List holds details about calls to the List method.
		List []struct {
			// Opts is the opts argument value.
			Opts metav1.ListOptions
		}
		// ListNamespaced holds details about calls to the ListNamespaced method.
		ListNamespaced []struct {
			// Namespace is the namespace argument value.
			Namespace string
			// Opts is the opts argument value.
			Opts metav1.ListOptions
		}
		// ObjectClient holds details about calls to the ObjectClient method.
		ObjectClient []struct {
		}
		// Update holds details about calls to the Update method.
		Update []struct {
			// In1 is the in1 argument value.
			In1 *v3.Pipeline
		}
		// Watch holds details about calls to the Watch method.
		Watch []struct {
			// Opts is the opts argument value.
			Opts metav1.ListOptions
		}
	}
}

// AddClusterScopedFeatureHandler calls AddClusterScopedFeatureHandlerFunc.
func (mock *PipelineInterfaceMock) AddClusterScopedFeatureHandler(ctx context.Context, enabled func() bool, name string, clusterName string, syncMoqParam v31.PipelineHandlerFunc) {
	if mock.AddClusterScopedFeatureHandlerFunc == nil {
		panic("PipelineInterfaceMock.AddClusterScopedFeatureHandlerFunc: method is nil but PipelineInterface.AddClusterScopedFeatureHandler was just called")
	}
	callInfo := struct {
		Ctx         context.Context
		Enabled     func() bool
		Name        string
		ClusterName string
		Sync        v31.PipelineHandlerFunc
	}{
		Ctx:         ctx,
		Enabled:     enabled,
		Name:        name,
		ClusterName: clusterName,
		Sync:        syncMoqParam,
	}
	lockPipelineInterfaceMockAddClusterScopedFeatureHandler.Lock()
	mock.calls.AddClusterScopedFeatureHandler = append(mock.calls.AddClusterScopedFeatureHandler, callInfo)
	lockPipelineInterfaceMockAddClusterScopedFeatureHandler.Unlock()
	mock.AddClusterScopedFeatureHandlerFunc(ctx, enabled, name, clusterName, syncMoqParam)
}

// AddClusterScopedFeatureHandlerCalls gets all the calls that were made to AddClusterScopedFeatureHandler.
// Check the length with:
//     len(mockedPipelineInterface.AddClusterScopedFeatureHandlerCalls())
func (mock *PipelineInterfaceMock) AddClusterScopedFeatureHandlerCalls() []struct {
	Ctx         context.Context
	Enabled     func() bool
	Name        string
	ClusterName string
	Sync        v31.PipelineHandlerFunc
} {
	var calls []struct {
		Ctx         context.Context
		Enabled     func() bool
		Name        string
		ClusterName string
		Sync        v31.PipelineHandlerFunc
	}
	lockPipelineInterfaceMockAddClusterScopedFeatureHandler.RLock()
	calls = mock.calls.AddClusterScopedFeatureHandler
	lockPipelineInterfaceMockAddClusterScopedFeatureHandler.RUnlock()
	return calls
}

// AddClusterScopedFeatureLifecycle calls AddClusterScopedFeatureLifecycleFunc.
func (mock *PipelineInterfaceMock) AddClusterScopedFeatureLifecycle(ctx context.Context, enabled func() bool, name string, clusterName string, lifecycle v31.PipelineLifecycle) {
	if mock.AddClusterScopedFeatureLifecycleFunc == nil {
		panic("PipelineInterfaceMock.AddClusterScopedFeatureLifecycleFunc: method is nil but PipelineInterface.AddClusterScopedFeatureLifecycle was just called")
	}
	callInfo := struct {
		Ctx         context.Context
		Enabled     func() bool
		Name        string
		ClusterName string
		Lifecycle   v31.PipelineLifecycle
	}{
		Ctx:         ctx,
		Enabled:     enabled,
		Name:        name,
		ClusterName: clusterName,
		Lifecycle:   lifecycle,
	}
	lockPipelineInterfaceMockAddClusterScopedFeatureLifecycle.Lock()
	mock.calls.AddClusterScopedFeatureLifecycle = append(mock.calls.AddClusterScopedFeatureLifecycle, callInfo)
	lockPipelineInterfaceMockAddClusterScopedFeatureLifecycle.Unlock()
	mock.AddClusterScopedFeatureLifecycleFunc(ctx, enabled, name, clusterName, lifecycle)
}

// AddClusterScopedFeatureLifecycleCalls gets all the calls that were made to AddClusterScopedFeatureLifecycle.
// Check the length with:
//     len(mockedPipelineInterface.AddClusterScopedFeatureLifecycleCalls())
func (mock *PipelineInterfaceMock) AddClusterScopedFeatureLifecycleCalls() []struct {
	Ctx         context.Context
	Enabled     func() bool
	Name        string
	ClusterName string
	Lifecycle   v31.PipelineLifecycle
} {
	var calls []struct {
		Ctx         context.Context
		Enabled     func() bool
		Name        string
		ClusterName string
		Lifecycle   v31.PipelineLifecycle
	}
	lockPipelineInterfaceMockAddClusterScopedFeatureLifecycle.RLock()
	calls = mock.calls.AddClusterScopedFeatureLifecycle
	lockPipelineInterfaceMockAddClusterScopedFeatureLifecycle.RUnlock()
	return calls
}

// AddClusterScopedHandler calls AddClusterScopedHandlerFunc.
func (mock *PipelineInterfaceMock) AddClusterScopedHandler(ctx context.Context, name string, clusterName string, syncMoqParam v31.PipelineHandlerFunc) {
	if mock.AddClusterScopedHandlerFunc == nil {
		panic("PipelineInterfaceMock.AddClusterScopedHandlerFunc: method is nil but PipelineInterface.AddClusterScopedHandler was just called")
	}
	callInfo := struct {
		Ctx         context.Context
		Name        string
		ClusterName string
		Sync        v31.PipelineHandlerFunc
	}{
		Ctx:         ctx,
		Name:        name,
		ClusterName: clusterName,
		Sync:        syncMoqParam,
	}
	lockPipelineInterfaceMockAddClusterScopedHandler.Lock()
	mock.calls.AddClusterScopedHandler = append(mock.calls.AddClusterScopedHandler, callInfo)
	lockPipelineInterfaceMockAddClusterScopedHandler.Unlock()
	mock.AddClusterScopedHandlerFunc(ctx, name, clusterName, syncMoqParam)
}

// AddClusterScopedHandlerCalls gets all the calls that were made to AddClusterScopedHandler.
// Check the length with:
//     len(mockedPipelineInterface.AddClusterScopedHandlerCalls())
func (mock *PipelineInterfaceMock) AddClusterScopedHandlerCalls() []struct {
	Ctx         context.Context
	Name        string
	ClusterName string
	Sync        v31.PipelineHandlerFunc
} {
	var calls []struct {
		Ctx         context.Context
		Name        string
		ClusterName string
		Sync        v31.PipelineHandlerFunc
	}
	lockPipelineInterfaceMockAddClusterScopedHandler.RLock()
	calls = mock.calls.AddClusterScopedHandler
	lockPipelineInterfaceMockAddClusterScopedHandler.RUnlock()
	return calls
}

// AddClusterScopedLifecycle calls AddClusterScopedLifecycleFunc.
func (mock *PipelineInterfaceMock) AddClusterScopedLifecycle(ctx context.Context, name string, clusterName string, lifecycle v31.PipelineLifecycle) {
	if mock.AddClusterScopedLifecycleFunc == nil {
		panic("PipelineInterfaceMock.AddClusterScopedLifecycleFunc: method is nil but PipelineInterface.AddClusterScopedLifecycle was just called")
	}
	callInfo := struct {
		Ctx         context.Context
		Name        string
		ClusterName string
		Lifecycle   v31.PipelineLifecycle
	}{
		Ctx:         ctx,
		Name:        name,
		ClusterName: clusterName,
		Lifecycle:   lifecycle,
	}
	lockPipelineInterfaceMockAddClusterScopedLifecycle.Lock()
	mock.calls.AddClusterScopedLifecycle = append(mock.calls.AddClusterScopedLifecycle, callInfo)
	lockPipelineInterfaceMockAddClusterScopedLifecycle.Unlock()
	mock.AddClusterScopedLifecycleFunc(ctx, name, clusterName, lifecycle)
}

// AddClusterScopedLifecycleCalls gets all the calls that were made to AddClusterScopedLifecycle.
// Check the length with:
//     len(mockedPipelineInterface.AddClusterScopedLifecycleCalls())
func (mock *PipelineInterfaceMock) AddClusterScopedLifecycleCalls() []struct {
	Ctx         context.Context
	Name        string
	ClusterName string
	Lifecycle   v31.PipelineLifecycle
} {
	var calls []struct {
		Ctx         context.Context
		Name        string
		ClusterName string
		Lifecycle   v31.PipelineLifecycle
	}
	lockPipelineInterfaceMockAddClusterScopedLifecycle.RLock()
	calls = mock.calls.AddClusterScopedLifecycle
	lockPipelineInterfaceMockAddClusterScopedLifecycle.RUnlock()
	return calls
}

// AddFeatureHandler calls AddFeatureHandlerFunc.
func (mock *PipelineInterfaceMock) AddFeatureHandler(ctx context.Context, enabled func() bool, name string, syncMoqParam v31.PipelineHandlerFunc) {
	if mock.AddFeatureHandlerFunc == nil {
		panic("PipelineInterfaceMock.AddFeatureHandlerFunc: method is nil but PipelineInterface.AddFeatureHandler was just called")
	}
	callInfo := struct {
		Ctx     context.Context
		Enabled func() bool
		Name    string
		Sync    v31.PipelineHandlerFunc
	}{
		Ctx:     ctx,
		Enabled: enabled,
		Name:    name,
		Sync:    syncMoqParam,
	}
	lockPipelineInterfaceMockAddFeatureHandler.Lock()
	mock.calls.AddFeatureHandler = append(mock.calls.AddFeatureHandler, callInfo)
	lockPipelineInterfaceMockAddFeatureHandler.Unlock()
	mock.AddFeatureHandlerFunc(ctx, enabled, name, syncMoqParam)
}

// AddFeatureHandlerCalls gets all the calls that were made to AddFeatureHandler.
// Check the length with:
//     len(mockedPipelineInterface.AddFeatureHandlerCalls())
func (mock *PipelineInterfaceMock) AddFeatureHandlerCalls() []struct {
	Ctx     context.Context
	Enabled func() bool
	Name    string
	Sync    v31.PipelineHandlerFunc
} {
	var calls []struct {
		Ctx     context.Context
		Enabled func() bool
		Name    string
		Sync    v31.PipelineHandlerFunc
	}
	lockPipelineInterfaceMockAddFeatureHandler.RLock()
	calls = mock.calls.AddFeatureHandler
	lockPipelineInterfaceMockAddFeatureHandler.RUnlock()
	return calls
}

// AddFeatureLifecycle calls AddFeatureLifecycleFunc.
func (mock *PipelineInterfaceMock) AddFeatureLifecycle(ctx context.Context, enabled func() bool, name string, lifecycle v31.PipelineLifecycle) {
	if mock.AddFeatureLifecycleFunc == nil {
		panic("PipelineInterfaceMock.AddFeatureLifecycleFunc: method is nil but PipelineInterface.AddFeatureLifecycle was just called")
	}
	callInfo := struct {
		Ctx       context.Context
		Enabled   func() bool
		Name      string
		Lifecycle v31.PipelineLifecycle
	}{
		Ctx:       ctx,
		Enabled:   enabled,
		Name:      name,
		Lifecycle: lifecycle,
	}
	lockPipelineInterfaceMockAddFeatureLifecycle.Lock()
	mock.calls.AddFeatureLifecycle = append(mock.calls.AddFeatureLifecycle, callInfo)
	lockPipelineInterfaceMockAddFeatureLifecycle.Unlock()
	mock.AddFeatureLifecycleFunc(ctx, enabled, name, lifecycle)
}

// AddFeatureLifecycleCalls gets all the calls that were made to AddFeatureLifecycle.
// Check the length with:
//     len(mockedPipelineInterface.AddFeatureLifecycleCalls())
func (mock *PipelineInterfaceMock) AddFeatureLifecycleCalls() []struct {
	Ctx       context.Context
	Enabled   func() bool
	Name      string
	Lifecycle v31.PipelineLifecycle
} {
	var calls []struct {
		Ctx       context.Context
		Enabled   func() bool
		Name      string
		Lifecycle v31.PipelineLifecycle
	}
	lockPipelineInterfaceMockAddFeatureLifecycle.RLock()
	calls = mock.calls.AddFeatureLifecycle
	lockPipelineInterfaceMockAddFeatureLifecycle.RUnlock()
	return calls
}

// AddHandler calls AddHandlerFunc.
func (mock *PipelineInterfaceMock) AddHandler(ctx context.Context, name string, syncMoqParam v31.PipelineHandlerFunc) {
	if mock.AddHandlerFunc == nil {
		panic("PipelineInterfaceMock.AddHandlerFunc: method is nil but PipelineInterface.AddHandler was just called")
	}
	callInfo := struct {
		Ctx  context.Context
		Name string
		Sync v31.PipelineHandlerFunc
	}{
		Ctx:  ctx,
		Name: name,
		Sync: syncMoqParam,
	}
	lockPipelineInterfaceMockAddHandler.Lock()
	mock.calls.AddHandler = append(mock.calls.AddHandler, callInfo)
	lockPipelineInterfaceMockAddHandler.Unlock()
	mock.AddHandlerFunc(ctx, name, syncMoqParam)
}

// AddHandlerCalls gets all the calls that were made to AddHandler.
// Check the length with:
//     len(mockedPipelineInterface.AddHandlerCalls())
func (mock *PipelineInterfaceMock) AddHandlerCalls() []struct {
	Ctx  context.Context
	Name string
	Sync v31.PipelineHandlerFunc
} {
	var calls []struct {
		Ctx  context.Context
		Name string
		Sync v31.PipelineHandlerFunc
	}
	lockPipelineInterfaceMockAddHandler.RLock()
	calls = mock.calls.AddHandler
	lockPipelineInterfaceMockAddHandler.RUnlock()
	return calls
}

// AddLifecycle calls AddLifecycleFunc.
func (mock *PipelineInterfaceMock) AddLifecycle(ctx context.Context, name string, lifecycle v31.PipelineLifecycle) {
	if mock.AddLifecycleFunc == nil {
		panic("PipelineInterfaceMock.AddLifecycleFunc: method is nil but PipelineInterface.AddLifecycle was just called")
	}
	callInfo := struct {
		Ctx       context.Context
		Name      string
		Lifecycle v31.PipelineLifecycle
	}{
		Ctx:       ctx,
		Name:      name,
		Lifecycle: lifecycle,
	}
	lockPipelineInterfaceMockAddLifecycle.Lock()
	mock.calls.AddLifecycle = append(mock.calls.AddLifecycle, callInfo)
	lockPipelineInterfaceMockAddLifecycle.Unlock()
	mock.AddLifecycleFunc(ctx, name, lifecycle)
}

// AddLifecycleCalls gets all the calls that were made to AddLifecycle.
// Check the length with:
//     len(mockedPipelineInterface.AddLifecycleCalls())
func (mock *PipelineInterfaceMock) AddLifecycleCalls() []struct {
	Ctx       context.Context
	Name      string
	Lifecycle v31.PipelineLifecycle
} {
	var calls []struct {
		Ctx       context.Context
		Name      string
		Lifecycle v31.PipelineLifecycle
	}
	lockPipelineInterfaceMockAddLifecycle.RLock()
	calls = mock.calls.AddLifecycle
	lockPipelineInterfaceMockAddLifecycle.RUnlock()
	return calls
}

// Controller calls ControllerFunc.
func (mock *PipelineInterfaceMock) Controller() v31.PipelineController {
	if mock.ControllerFunc == nil {
		panic("PipelineInterfaceMock.ControllerFunc: method is nil but PipelineInterface.Controller was just called")
	}
	callInfo := struct {
	}{}
	lockPipelineInterfaceMockController.Lock()
	mock.calls.Controller = append(mock.calls.Controller, callInfo)
	lockPipelineInterfaceMockController.Unlock()
	return mock.ControllerFunc()
}

// ControllerCalls gets all the calls that were made to Controller.
// Check the length with:
//     len(mockedPipelineInterface.ControllerCalls())
func (mock *PipelineInterfaceMock) ControllerCalls() []struct {
} {
	var calls []struct {
	}
	lockPipelineInterfaceMockController.RLock()
	calls = mock.calls.Controller
	lockPipelineInterfaceMockController.RUnlock()
	return calls
}

// Create calls CreateFunc.
func (mock *PipelineInterfaceMock) Create(in1 *v3.Pipeline) (*v3.Pipeline, error) {
	if mock.CreateFunc == nil {
		panic("PipelineInterfaceMock.CreateFunc: method is nil but PipelineInterface.Create was just called")
	}
	callInfo := struct {
		In1 *v3.Pipeline
	}{
		In1: in1,
	}
	lockPipelineInterfaceMockCreate.Lock()
	mock.calls.Create = append(mock.calls.Create, callInfo)
	lockPipelineInterfaceMockCreate.Unlock()
	return mock.CreateFunc(in1)
}

// CreateCalls gets all the calls that were made to Create.
// Check the length with:
//     len(mockedPipelineInterface.CreateCalls())
func (mock *PipelineInterfaceMock) CreateCalls() []struct {
	In1 *v3.Pipeline
} {
	var calls []struct {
		In1 *v3.Pipeline
	}
	lockPipelineInterfaceMockCreate.RLock()
	calls = mock.calls.Create
	lockPipelineInterfaceMockCreate.RUnlock()
	return calls
}

// Delete calls DeleteFunc.
func (mock *PipelineInterfaceMock) Delete(name string, options *metav1.DeleteOptions) error {
	if mock.DeleteFunc == nil {
		panic("PipelineInterfaceMock.DeleteFunc: method is nil but PipelineInterface.Delete was just called")
	}
	callInfo := struct {
		Name    string
		Options *metav1.DeleteOptions
	}{
		Name:    name,
		Options: options,
	}
	lockPipelineInterfaceMockDelete.Lock()
	mock.calls.Delete = append(mock.calls.Delete, callInfo)
	lockPipelineInterfaceMockDelete.Unlock()
	return mock.DeleteFunc(name, options)
}

// DeleteCalls gets all the calls that were made to Delete.
// Check the length with:
//     len(mockedPipelineInterface.DeleteCalls())
func (mock *PipelineInterfaceMock) DeleteCalls() []struct {
	Name    string
	Options *metav1.DeleteOptions
} {
	var calls []struct {
		Name    string
		Options *metav1.DeleteOptions
	}
	lockPipelineInterfaceMockDelete.RLock()
	calls = mock.calls.Delete
	lockPipelineInterfaceMockDelete.RUnlock()
	return calls
}

// DeleteCollection calls DeleteCollectionFunc.
func (mock *PipelineInterfaceMock) DeleteCollection(deleteOpts *metav1.DeleteOptions, listOpts metav1.ListOptions) error {
	if mock.DeleteCollectionFunc == nil {
		panic("PipelineInterfaceMock.DeleteCollectionFunc: method is nil but PipelineInterface.DeleteCollection was just called")
	}
	callInfo := struct {
		DeleteOpts *metav1.DeleteOptions
		ListOpts   metav1.ListOptions
	}{
		DeleteOpts: deleteOpts,
		ListOpts:   listOpts,
	}
	lockPipelineInterfaceMockDeleteCollection.Lock()
	mock.calls.DeleteCollection = append(mock.calls.DeleteCollection, callInfo)
	lockPipelineInterfaceMockDeleteCollection.Unlock()
	return mock.DeleteCollectionFunc(deleteOpts, listOpts)
}

// DeleteCollectionCalls gets all the calls that were made to DeleteCollection.
// Check the length with:
//     len(mockedPipelineInterface.DeleteCollectionCalls())
func (mock *PipelineInterfaceMock) DeleteCollectionCalls() []struct {
	DeleteOpts *metav1.DeleteOptions
	ListOpts   metav1.ListOptions
} {
	var calls []struct {
		DeleteOpts *metav1.DeleteOptions
		ListOpts   metav1.ListOptions
	}
	lockPipelineInterfaceMockDeleteCollection.RLock()
	calls = mock.calls.DeleteCollection
	lockPipelineInterfaceMockDeleteCollection.RUnlock()
	return calls
}

// DeleteNamespaced calls DeleteNamespacedFunc.
func (mock *PipelineInterfaceMock) DeleteNamespaced(namespace string, name string, options *metav1.DeleteOptions) error {
	if mock.DeleteNamespacedFunc == nil {
		panic("PipelineInterfaceMock.DeleteNamespacedFunc: method is nil but PipelineInterface.DeleteNamespaced was just called")
	}
	callInfo := struct {
		Namespace string
		Name      string
		Options   *metav1.DeleteOptions
	}{
		Namespace: namespace,
		Name:      name,
		Options:   options,
	}
	lockPipelineInterfaceMockDeleteNamespaced.Lock()
	mock.calls.DeleteNamespaced = append(mock.calls.DeleteNamespaced, callInfo)
	lockPipelineInterfaceMockDeleteNamespaced.Unlock()
	return mock.DeleteNamespacedFunc(namespace, name, options)
}

// DeleteNamespacedCalls gets all the calls that were made to DeleteNamespaced.
// Check the length with:
//     len(mockedPipelineInterface.DeleteNamespacedCalls())
func (mock *PipelineInterfaceMock) DeleteNamespacedCalls() []struct {
	Namespace string
	Name      string
	Options   *metav1.DeleteOptions
} {
	var calls []struct {
		Namespace string
		Name      string
		Options   *metav1.DeleteOptions
	}
	lockPipelineInterfaceMockDeleteNamespaced.RLock()
	calls = mock.calls.DeleteNamespaced
	lockPipelineInterfaceMockDeleteNamespaced.RUnlock()
	return calls
}

// Get calls GetFunc.
func (mock *PipelineInterfaceMock) Get(name string, opts metav1.GetOptions) (*v3.Pipeline, error) {
	if mock.GetFunc == nil {
		panic("PipelineInterfaceMock.GetFunc: method is nil but PipelineInterface.Get was just called")
	}
	callInfo := struct {
		Name string
		Opts metav1.GetOptions
	}{
		Name: name,
		Opts: opts,
	}
	lockPipelineInterfaceMockGet.Lock()
	mock.calls.Get = append(mock.calls.Get, callInfo)
	lockPipelineInterfaceMockGet.Unlock()
	return mock.GetFunc(name, opts)
}

// GetCalls gets all the calls that were made to Get.
// Check the length with:
//     len(mockedPipelineInterface.GetCalls())
func (mock *PipelineInterfaceMock) GetCalls() []struct {
	Name string
	Opts metav1.GetOptions
} {
	var calls []struct {
		Name string
		Opts metav1.GetOptions
	}
	lockPipelineInterfaceMockGet.RLock()
	calls = mock.calls.Get
	lockPipelineInterfaceMockGet.RUnlock()
	return calls
}

// GetNamespaced calls GetNamespacedFunc.
func (mock *PipelineInterfaceMock) GetNamespaced(namespace string, name string, opts metav1.GetOptions) (*v3.Pipeline, error) {
	if mock.GetNamespacedFunc == nil {
		panic("PipelineInterfaceMock.GetNamespacedFunc: method is nil but PipelineInterface.GetNamespaced was just called")
	}
	callInfo := struct {
		Namespace string
		Name      string
		Opts      metav1.GetOptions
	}{
		Namespace: namespace,
		Name:      name,
		Opts:      opts,
	}
	lockPipelineInterfaceMockGetNamespaced.Lock()
	mock.calls.GetNamespaced = append(mock.calls.GetNamespaced, callInfo)
	lockPipelineInterfaceMockGetNamespaced.Unlock()
	return mock.GetNamespacedFunc(namespace, name, opts)
}

// GetNamespacedCalls gets all the calls that were made to GetNamespaced.
// Check the length with:
//     len(mockedPipelineInterface.GetNamespacedCalls())
func (mock *PipelineInterfaceMock) GetNamespacedCalls() []struct {
	Namespace string
	Name      string
	Opts      metav1.GetOptions
} {
	var calls []struct {
		Namespace string
		Name      string
		Opts      metav1.GetOptions
	}
	lockPipelineInterfaceMockGetNamespaced.RLock()
	calls = mock.calls.GetNamespaced
	lockPipelineInterfaceMockGetNamespaced.RUnlock()
	return calls
}

// List calls ListFunc.
func (mock *PipelineInterfaceMock) List(opts metav1.ListOptions) (*v3.PipelineList, error) {
	if mock.ListFunc == nil {
		panic("PipelineInterfaceMock.ListFunc: method is nil but PipelineInterface.List was just called")
	}
	callInfo := struct {
		Opts metav1.ListOptions
	}{
		Opts: opts,
	}
	lockPipelineInterfaceMockList.Lock()
	mock.calls.List = append(mock.calls.List, callInfo)
	lockPipelineInterfaceMockList.Unlock()
	return mock.ListFunc(opts)
}

// ListCalls gets all the calls that were made to List.
// Check the length with:
//     len(mockedPipelineInterface.ListCalls())
func (mock *PipelineInterfaceMock) ListCalls() []struct {
	Opts metav1.ListOptions
} {
	var calls []struct {
		Opts metav1.ListOptions
	}
	lockPipelineInterfaceMockList.RLock()
	calls = mock.calls.List
	lockPipelineInterfaceMockList.RUnlock()
	return calls
}

// ListNamespaced calls ListNamespacedFunc.
func (mock *PipelineInterfaceMock) ListNamespaced(namespace string, opts metav1.ListOptions) (*v3.PipelineList, error) {
	if mock.ListNamespacedFunc == nil {
		panic("PipelineInterfaceMock.ListNamespacedFunc: method is nil but PipelineInterface.ListNamespaced was just called")
	}
	callInfo := struct {
		Namespace string
		Opts      metav1.ListOptions
	}{
		Namespace: namespace,
		Opts:      opts,
	}
	lockPipelineInterfaceMockListNamespaced.Lock()
	mock.calls.ListNamespaced = append(mock.calls.ListNamespaced, callInfo)
	lockPipelineInterfaceMockListNamespaced.Unlock()
	return mock.ListNamespacedFunc(namespace, opts)
}

// ListNamespacedCalls gets all the calls that were made to ListNamespaced.
// Check the length with:
//     len(mockedPipelineInterface.ListNamespacedCalls())
func (mock *PipelineInterfaceMock) ListNamespacedCalls() []struct {
	Namespace string
	Opts      metav1.ListOptions
} {
	var calls []struct {
		Namespace string
		Opts      metav1.ListOptions
	}
	lockPipelineInterfaceMockListNamespaced.RLock()
	calls = mock.calls.ListNamespaced
	lockPipelineInterfaceMockListNamespaced.RUnlock()
	return calls
}

// ObjectClient calls ObjectClientFunc.
func (mock *PipelineInterfaceMock) ObjectClient() *objectclient.ObjectClient {
	if mock.ObjectClientFunc == nil {
		panic("PipelineInterfaceMock.ObjectClientFunc: method is nil but PipelineInterface.ObjectClient was just called")
	}
	callInfo := struct {
	}{}
	lockPipelineInterfaceMockObjectClient.Lock()
	mock.calls.ObjectClient = append(mock.calls.ObjectClient, callInfo)
	lockPipelineInterfaceMockObjectClient.Unlock()
	return mock.ObjectClientFunc()
}

// ObjectClientCalls gets all the calls that were made to ObjectClient.
// Check the length with:
//     len(mockedPipelineInterface.ObjectClientCalls())
func (mock *PipelineInterfaceMock) ObjectClientCalls() []struct {
} {
	var calls []struct {
	}
	lockPipelineInterfaceMockObjectClient.RLock()
	calls = mock.calls.ObjectClient
	lockPipelineInterfaceMockObjectClient.RUnlock()
	return calls
}

// Update calls UpdateFunc.
func (mock *PipelineInterfaceMock) Update(in1 *v3.Pipeline) (*v3.Pipeline, error) {
	if mock.UpdateFunc == nil {
		panic("PipelineInterfaceMock.UpdateFunc: method is nil but PipelineInterface.Update was just called")
	}
	callInfo := struct {
		In1 *v3.Pipeline
	}{
		In1: in1,
	}
	lockPipelineInterfaceMockUpdate.Lock()
	mock.calls.Update = append(mock.calls.Update, callInfo)
	lockPipelineInterfaceMockUpdate.Unlock()
	return mock.UpdateFunc(in1)
}

// UpdateCalls gets all the calls that were made to Update.
// Check the length with:
//     len(mockedPipelineInterface.UpdateCalls())
func (mock *PipelineInterfaceMock) UpdateCalls() []struct {
	In1 *v3.Pipeline
} {
	var calls []struct {
		In1 *v3.Pipeline
	}
	lockPipelineInterfaceMockUpdate.RLock()
	calls = mock.calls.Update
	lockPipelineInterfaceMockUpdate.RUnlock()
	return calls
}

// Watch calls WatchFunc.
func (mock *PipelineInterfaceMock) Watch(opts metav1.ListOptions) (watch.Interface, error) {
	if mock.WatchFunc == nil {
		panic("PipelineInterfaceMock.WatchFunc: method is nil but PipelineInterface.Watch was just called")
	}
	callInfo := struct {
		Opts metav1.ListOptions
	}{
		Opts: opts,
	}
	lockPipelineInterfaceMockWatch.Lock()
	mock.calls.Watch = append(mock.calls.Watch, callInfo)
	lockPipelineInterfaceMockWatch.Unlock()
	return mock.WatchFunc(opts)
}

// WatchCalls gets all the calls that were made to Watch.
// Check the length with:
//     len(mockedPipelineInterface.WatchCalls())
func (mock *PipelineInterfaceMock) WatchCalls() []struct {
	Opts metav1.ListOptions
} {
	var calls []struct {
		Opts metav1.ListOptions
	}
	lockPipelineInterfaceMockWatch.RLock()
	calls = mock.calls.Watch
	lockPipelineInterfaceMockWatch.RUnlock()
	return calls
}

var (
	lockPipelinesGetterMockPipelines sync.RWMutex
)

// Ensure, that PipelinesGetterMock does implement v31.PipelinesGetter.
// If this is not the case, regenerate this file with moq.
var _ v31.PipelinesGetter = &PipelinesGetterMock{}

// PipelinesGetterMock is a mock implementation of v31.PipelinesGetter.
//
//     func TestSomethingThatUsesPipelinesGetter(t *testing.T) {
//
//         // make and configure a mocked v31.PipelinesGetter
//         mockedPipelinesGetter := &PipelinesGetterMock{
//             PipelinesFunc: func(namespace string) v31.PipelineInterface {
// 	               panic("mock out the Pipelines method")
//             },
//         }
//
//         // use mockedPipelinesGetter in code that requires v31.PipelinesGetter
//         // and then make assertions.
//
//     }
type PipelinesGetterMock struct {
	// PipelinesFunc mocks the Pipelines method.
	PipelinesFunc func(namespace string) v31.PipelineInterface

	// calls tracks calls to the methods.
	calls struct {
		// Pipelines holds details about calls to the Pipelines method.
		Pipelines []struct {
			// Namespace is the namespace argument value.
			Namespace string
		}
	}
}

// Pipelines calls PipelinesFunc.
func (mock *PipelinesGetterMock) Pipelines(namespace string) v31.PipelineInterface {
	if mock.PipelinesFunc == nil {
		panic("PipelinesGetterMock.PipelinesFunc: method is nil but PipelinesGetter.Pipelines was just called")
	}
	callInfo := struct {
		Namespace string
	}{
		Namespace: namespace,
	}
	lockPipelinesGetterMockPipelines.Lock()
	mock.calls.Pipelines = append(mock.calls.Pipelines, callInfo)
	lockPipelinesGetterMockPipelines.Unlock()
	return mock.PipelinesFunc(namespace)
}

// PipelinesCalls gets all the calls that were made to Pipelines.
// Check the length with:
//     len(mockedPipelinesGetter.PipelinesCalls())
func (mock *PipelinesGetterMock) PipelinesCalls() []struct {
	Namespace string
} {
	var calls []struct {
		Namespace string
	}
	lockPipelinesGetterMockPipelines.RLock()
	calls = mock.calls.Pipelines
	lockPipelinesGetterMockPipelines.RUnlock()
	return calls
}
