// Code generated by moq; DO NOT EDIT.
// github.com/matryer/moq

package fakes

import (
	"context"
	"sync"
	"time"

	"github.com/rancher/norman/controller"
	"github.com/rancher/norman/objectclient"
	v3 "github.com/rancher/rancher/pkg/apis/project.cattle.io/v3"
	v31 "github.com/rancher/rancher/pkg/generated/norman/project.cattle.io/v3"
	metav1 "k8s.io/apimachinery/pkg/apis/meta/v1"
	"k8s.io/apimachinery/pkg/labels"
	"k8s.io/apimachinery/pkg/watch"
	"k8s.io/client-go/tools/cache"
)

var (
	lockPipelineSettingListerMockGet  sync.RWMutex
	lockPipelineSettingListerMockList sync.RWMutex
)

// Ensure, that PipelineSettingListerMock does implement v31.PipelineSettingLister.
// If this is not the case, regenerate this file with moq.
var _ v31.PipelineSettingLister = &PipelineSettingListerMock{}

// PipelineSettingListerMock is a mock implementation of v31.PipelineSettingLister.
//
//     func TestSomethingThatUsesPipelineSettingLister(t *testing.T) {
//
//         // make and configure a mocked v31.PipelineSettingLister
//         mockedPipelineSettingLister := &PipelineSettingListerMock{
//             GetFunc: func(namespace string, name string) (*v3.PipelineSetting, error) {
// 	               panic("mock out the Get method")
//             },
//             ListFunc: func(namespace string, selector labels.Selector) ([]*v3.PipelineSetting, error) {
// 	               panic("mock out the List method")
//             },
//         }
//
//         // use mockedPipelineSettingLister in code that requires v31.PipelineSettingLister
//         // and then make assertions.
//
//     }
type PipelineSettingListerMock struct {
	// GetFunc mocks the Get method.
	GetFunc func(namespace string, name string) (*v3.PipelineSetting, error)

	// ListFunc mocks the List method.
	ListFunc func(namespace string, selector labels.Selector) ([]*v3.PipelineSetting, error)

	// calls tracks calls to the methods.
	calls struct {
		// Get holds details about calls to the Get method.
		Get []struct {
			// Namespace is the namespace argument value.
			Namespace string
			// Name is the name argument value.
			Name string
		}
		// List holds details about calls to the List method.
		List []struct {
			// Namespace is the namespace argument value.
			Namespace string
			// Selector is the selector argument value.
			Selector labels.Selector
		}
	}
}

// Get calls GetFunc.
func (mock *PipelineSettingListerMock) Get(namespace string, name string) (*v3.PipelineSetting, error) {
	if mock.GetFunc == nil {
		panic("PipelineSettingListerMock.GetFunc: method is nil but PipelineSettingLister.Get was just called")
	}
	callInfo := struct {
		Namespace string
		Name      string
	}{
		Namespace: namespace,
		Name:      name,
	}
	lockPipelineSettingListerMockGet.Lock()
	mock.calls.Get = append(mock.calls.Get, callInfo)
	lockPipelineSettingListerMockGet.Unlock()
	return mock.GetFunc(namespace, name)
}

// GetCalls gets all the calls that were made to Get.
// Check the length with:
//     len(mockedPipelineSettingLister.GetCalls())
func (mock *PipelineSettingListerMock) GetCalls() []struct {
	Namespace string
	Name      string
} {
	var calls []struct {
		Namespace string
		Name      string
	}
	lockPipelineSettingListerMockGet.RLock()
	calls = mock.calls.Get
	lockPipelineSettingListerMockGet.RUnlock()
	return calls
}

// List calls ListFunc.
func (mock *PipelineSettingListerMock) List(namespace string, selector labels.Selector) ([]*v3.PipelineSetting, error) {
	if mock.ListFunc == nil {
		panic("PipelineSettingListerMock.ListFunc: method is nil but PipelineSettingLister.List was just called")
	}
	callInfo := struct {
		Namespace string
		Selector  labels.Selector
	}{
		Namespace: namespace,
		Selector:  selector,
	}
	lockPipelineSettingListerMockList.Lock()
	mock.calls.List = append(mock.calls.List, callInfo)
	lockPipelineSettingListerMockList.Unlock()
	return mock.ListFunc(namespace, selector)
}

// ListCalls gets all the calls that were made to List.
// Check the length with:
//     len(mockedPipelineSettingLister.ListCalls())
func (mock *PipelineSettingListerMock) ListCalls() []struct {
	Namespace string
	Selector  labels.Selector
} {
	var calls []struct {
		Namespace string
		Selector  labels.Selector
	}
	lockPipelineSettingListerMockList.RLock()
	calls = mock.calls.List
	lockPipelineSettingListerMockList.RUnlock()
	return calls
}

var (
	lockPipelineSettingControllerMockAddClusterScopedFeatureHandler sync.RWMutex
	lockPipelineSettingControllerMockAddClusterScopedHandler        sync.RWMutex
	lockPipelineSettingControllerMockAddFeatureHandler              sync.RWMutex
	lockPipelineSettingControllerMockAddHandler                     sync.RWMutex
	lockPipelineSettingControllerMockEnqueue                        sync.RWMutex
	lockPipelineSettingControllerMockEnqueueAfter                   sync.RWMutex
	lockPipelineSettingControllerMockGeneric                        sync.RWMutex
	lockPipelineSettingControllerMockInformer                       sync.RWMutex
	lockPipelineSettingControllerMockLister                         sync.RWMutex
)

// Ensure, that PipelineSettingControllerMock does implement v31.PipelineSettingController.
// If this is not the case, regenerate this file with moq.
var _ v31.PipelineSettingController = &PipelineSettingControllerMock{}

// PipelineSettingControllerMock is a mock implementation of v31.PipelineSettingController.
//
//     func TestSomethingThatUsesPipelineSettingController(t *testing.T) {
//
//         // make and configure a mocked v31.PipelineSettingController
//         mockedPipelineSettingController := &PipelineSettingControllerMock{
//             AddClusterScopedFeatureHandlerFunc: func(ctx context.Context, enabled func() bool, name string, clusterName string, handler v31.PipelineSettingHandlerFunc)  {
// 	               panic("mock out the AddClusterScopedFeatureHandler method")
//             },
//             AddClusterScopedHandlerFunc: func(ctx context.Context, name string, clusterName string, handler v31.PipelineSettingHandlerFunc)  {
// 	               panic("mock out the AddClusterScopedHandler method")
//             },
//             AddFeatureHandlerFunc: func(ctx context.Context, enabled func() bool, name string, syncMoqParam v31.PipelineSettingHandlerFunc)  {
// 	               panic("mock out the AddFeatureHandler method")
//             },
//             AddHandlerFunc: func(ctx context.Context, name string, handler v31.PipelineSettingHandlerFunc)  {
// 	               panic("mock out the AddHandler method")
//             },
//             EnqueueFunc: func(namespace string, name string)  {
// 	               panic("mock out the Enqueue method")
//             },
//             EnqueueAfterFunc: func(namespace string, name string, after time.Duration)  {
// 	               panic("mock out the EnqueueAfter method")
//             },
//             GenericFunc: func() controller.GenericController {
// 	               panic("mock out the Generic method")
//             },
//             InformerFunc: func() cache.SharedIndexInformer {
// 	               panic("mock out the Informer method")
//             },
//             ListerFunc: func() v31.PipelineSettingLister {
// 	               panic("mock out the Lister method")
//             },
//         }
//
//         // use mockedPipelineSettingController in code that requires v31.PipelineSettingController
//         // and then make assertions.
//
//     }
type PipelineSettingControllerMock struct {
	// AddClusterScopedFeatureHandlerFunc mocks the AddClusterScopedFeatureHandler method.
	AddClusterScopedFeatureHandlerFunc func(ctx context.Context, enabled func() bool, name string, clusterName string, handler v31.PipelineSettingHandlerFunc)

	// AddClusterScopedHandlerFunc mocks the AddClusterScopedHandler method.
	AddClusterScopedHandlerFunc func(ctx context.Context, name string, clusterName string, handler v31.PipelineSettingHandlerFunc)

	// AddFeatureHandlerFunc mocks the AddFeatureHandler method.
	AddFeatureHandlerFunc func(ctx context.Context, enabled func() bool, name string, syncMoqParam v31.PipelineSettingHandlerFunc)

	// AddHandlerFunc mocks the AddHandler method.
	AddHandlerFunc func(ctx context.Context, name string, handler v31.PipelineSettingHandlerFunc)

	// EnqueueFunc mocks the Enqueue method.
	EnqueueFunc func(namespace string, name string)

	// EnqueueAfterFunc mocks the EnqueueAfter method.
	EnqueueAfterFunc func(namespace string, name string, after time.Duration)

	// GenericFunc mocks the Generic method.
	GenericFunc func() controller.GenericController

	// InformerFunc mocks the Informer method.
	InformerFunc func() cache.SharedIndexInformer

	// ListerFunc mocks the Lister method.
	ListerFunc func() v31.PipelineSettingLister

	// calls tracks calls to the methods.
	calls struct {
		// AddClusterScopedFeatureHandler holds details about calls to the AddClusterScopedFeatureHandler method.
		AddClusterScopedFeatureHandler []struct {
			// Ctx is the ctx argument value.
			Ctx context.Context
			// Enabled is the enabled argument value.
			Enabled func() bool
			// Name is the name argument value.
			Name string
			// ClusterName is the clusterName argument value.
			ClusterName string
			// Handler is the handler argument value.
			Handler v31.PipelineSettingHandlerFunc
		}
		// AddClusterScopedHandler holds details about calls to the AddClusterScopedHandler method.
		AddClusterScopedHandler []struct {
			// Ctx is the ctx argument value.
			Ctx context.Context
			// Name is the name argument value.
			Name string
			// ClusterName is the clusterName argument value.
			ClusterName string
			// Handler is the handler argument value.
			Handler v31.PipelineSettingHandlerFunc
		}
		// AddFeatureHandler holds details about calls to the AddFeatureHandler method.
		AddFeatureHandler []struct {
			// Ctx is the ctx argument value.
			Ctx context.Context
			// Enabled is the enabled argument value.
			Enabled func() bool
			// Name is the name argument value.
			Name string
			// Sync is the sync argument value.
			Sync v31.PipelineSettingHandlerFunc
		}
		// AddHandler holds details about calls to the AddHandler method.
		AddHandler []struct {
			// Ctx is the ctx argument value.
			Ctx context.Context
			// Name is the name argument value.
			Name string
			// Handler is the handler argument value.
			Handler v31.PipelineSettingHandlerFunc
		}
		// Enqueue holds details about calls to the Enqueue method.
		Enqueue []struct {
			// Namespace is the namespace argument value.
			Namespace string
			// Name is the name argument value.
			Name string
		}
		// EnqueueAfter holds details about calls to the EnqueueAfter method.
		EnqueueAfter []struct {
			// Namespace is the namespace argument value.
			Namespace string
			// Name is the name argument value.
			Name string
			// After is the after argument value.
			After time.Duration
		}
		// Generic holds details about calls to the Generic method.
		Generic []struct {
		}
		// Informer holds details about calls to the Informer method.
		Informer []struct {
		}
		// Lister holds details about calls to the Lister method.
		Lister []struct {
		}
	}
}

// AddClusterScopedFeatureHandler calls AddClusterScopedFeatureHandlerFunc.
func (mock *PipelineSettingControllerMock) AddClusterScopedFeatureHandler(ctx context.Context, enabled func() bool, name string, clusterName string, handler v31.PipelineSettingHandlerFunc) {
	if mock.AddClusterScopedFeatureHandlerFunc == nil {
		panic("PipelineSettingControllerMock.AddClusterScopedFeatureHandlerFunc: method is nil but PipelineSettingController.AddClusterScopedFeatureHandler was just called")
	}
	callInfo := struct {
		Ctx         context.Context
		Enabled     func() bool
		Name        string
		ClusterName string
		Handler     v31.PipelineSettingHandlerFunc
	}{
		Ctx:         ctx,
		Enabled:     enabled,
		Name:        name,
		ClusterName: clusterName,
		Handler:     handler,
	}
	lockPipelineSettingControllerMockAddClusterScopedFeatureHandler.Lock()
	mock.calls.AddClusterScopedFeatureHandler = append(mock.calls.AddClusterScopedFeatureHandler, callInfo)
	lockPipelineSettingControllerMockAddClusterScopedFeatureHandler.Unlock()
	mock.AddClusterScopedFeatureHandlerFunc(ctx, enabled, name, clusterName, handler)
}

// AddClusterScopedFeatureHandlerCalls gets all the calls that were made to AddClusterScopedFeatureHandler.
// Check the length with:
//     len(mockedPipelineSettingController.AddClusterScopedFeatureHandlerCalls())
func (mock *PipelineSettingControllerMock) AddClusterScopedFeatureHandlerCalls() []struct {
	Ctx         context.Context
	Enabled     func() bool
	Name        string
	ClusterName string
	Handler     v31.PipelineSettingHandlerFunc
} {
	var calls []struct {
		Ctx         context.Context
		Enabled     func() bool
		Name        string
		ClusterName string
		Handler     v31.PipelineSettingHandlerFunc
	}
	lockPipelineSettingControllerMockAddClusterScopedFeatureHandler.RLock()
	calls = mock.calls.AddClusterScopedFeatureHandler
	lockPipelineSettingControllerMockAddClusterScopedFeatureHandler.RUnlock()
	return calls
}

// AddClusterScopedHandler calls AddClusterScopedHandlerFunc.
func (mock *PipelineSettingControllerMock) AddClusterScopedHandler(ctx context.Context, name string, clusterName string, handler v31.PipelineSettingHandlerFunc) {
	if mock.AddClusterScopedHandlerFunc == nil {
		panic("PipelineSettingControllerMock.AddClusterScopedHandlerFunc: method is nil but PipelineSettingController.AddClusterScopedHandler was just called")
	}
	callInfo := struct {
		Ctx         context.Context
		Name        string
		ClusterName string
		Handler     v31.PipelineSettingHandlerFunc
	}{
		Ctx:         ctx,
		Name:        name,
		ClusterName: clusterName,
		Handler:     handler,
	}
	lockPipelineSettingControllerMockAddClusterScopedHandler.Lock()
	mock.calls.AddClusterScopedHandler = append(mock.calls.AddClusterScopedHandler, callInfo)
	lockPipelineSettingControllerMockAddClusterScopedHandler.Unlock()
	mock.AddClusterScopedHandlerFunc(ctx, name, clusterName, handler)
}

// AddClusterScopedHandlerCalls gets all the calls that were made to AddClusterScopedHandler.
// Check the length with:
//     len(mockedPipelineSettingController.AddClusterScopedHandlerCalls())
func (mock *PipelineSettingControllerMock) AddClusterScopedHandlerCalls() []struct {
	Ctx         context.Context
	Name        string
	ClusterName string
	Handler     v31.PipelineSettingHandlerFunc
} {
	var calls []struct {
		Ctx         context.Context
		Name        string
		ClusterName string
		Handler     v31.PipelineSettingHandlerFunc
	}
	lockPipelineSettingControllerMockAddClusterScopedHandler.RLock()
	calls = mock.calls.AddClusterScopedHandler
	lockPipelineSettingControllerMockAddClusterScopedHandler.RUnlock()
	return calls
}

// AddFeatureHandler calls AddFeatureHandlerFunc.
func (mock *PipelineSettingControllerMock) AddFeatureHandler(ctx context.Context, enabled func() bool, name string, syncMoqParam v31.PipelineSettingHandlerFunc) {
	if mock.AddFeatureHandlerFunc == nil {
		panic("PipelineSettingControllerMock.AddFeatureHandlerFunc: method is nil but PipelineSettingController.AddFeatureHandler was just called")
	}
	callInfo := struct {
		Ctx     context.Context
		Enabled func() bool
		Name    string
		Sync    v31.PipelineSettingHandlerFunc
	}{
		Ctx:     ctx,
		Enabled: enabled,
		Name:    name,
		Sync:    syncMoqParam,
	}
	lockPipelineSettingControllerMockAddFeatureHandler.Lock()
	mock.calls.AddFeatureHandler = append(mock.calls.AddFeatureHandler, callInfo)
	lockPipelineSettingControllerMockAddFeatureHandler.Unlock()
	mock.AddFeatureHandlerFunc(ctx, enabled, name, syncMoqParam)
}

// AddFeatureHandlerCalls gets all the calls that were made to AddFeatureHandler.
// Check the length with:
//     len(mockedPipelineSettingController.AddFeatureHandlerCalls())
func (mock *PipelineSettingControllerMock) AddFeatureHandlerCalls() []struct {
	Ctx     context.Context
	Enabled func() bool
	Name    string
	Sync    v31.PipelineSettingHandlerFunc
} {
	var calls []struct {
		Ctx     context.Context
		Enabled func() bool
		Name    string
		Sync    v31.PipelineSettingHandlerFunc
	}
	lockPipelineSettingControllerMockAddFeatureHandler.RLock()
	calls = mock.calls.AddFeatureHandler
	lockPipelineSettingControllerMockAddFeatureHandler.RUnlock()
	return calls
}

// AddHandler calls AddHandlerFunc.
func (mock *PipelineSettingControllerMock) AddHandler(ctx context.Context, name string, handler v31.PipelineSettingHandlerFunc) {
	if mock.AddHandlerFunc == nil {
		panic("PipelineSettingControllerMock.AddHandlerFunc: method is nil but PipelineSettingController.AddHandler was just called")
	}
	callInfo := struct {
		Ctx     context.Context
		Name    string
		Handler v31.PipelineSettingHandlerFunc
	}{
		Ctx:     ctx,
		Name:    name,
		Handler: handler,
	}
	lockPipelineSettingControllerMockAddHandler.Lock()
	mock.calls.AddHandler = append(mock.calls.AddHandler, callInfo)
	lockPipelineSettingControllerMockAddHandler.Unlock()
	mock.AddHandlerFunc(ctx, name, handler)
}

// AddHandlerCalls gets all the calls that were made to AddHandler.
// Check the length with:
//     len(mockedPipelineSettingController.AddHandlerCalls())
func (mock *PipelineSettingControllerMock) AddHandlerCalls() []struct {
	Ctx     context.Context
	Name    string
	Handler v31.PipelineSettingHandlerFunc
} {
	var calls []struct {
		Ctx     context.Context
		Name    string
		Handler v31.PipelineSettingHandlerFunc
	}
	lockPipelineSettingControllerMockAddHandler.RLock()
	calls = mock.calls.AddHandler
	lockPipelineSettingControllerMockAddHandler.RUnlock()
	return calls
}

// Enqueue calls EnqueueFunc.
func (mock *PipelineSettingControllerMock) Enqueue(namespace string, name string) {
	if mock.EnqueueFunc == nil {
		panic("PipelineSettingControllerMock.EnqueueFunc: method is nil but PipelineSettingController.Enqueue was just called")
	}
	callInfo := struct {
		Namespace string
		Name      string
	}{
		Namespace: namespace,
		Name:      name,
	}
	lockPipelineSettingControllerMockEnqueue.Lock()
	mock.calls.Enqueue = append(mock.calls.Enqueue, callInfo)
	lockPipelineSettingControllerMockEnqueue.Unlock()
	mock.EnqueueFunc(namespace, name)
}

// EnqueueCalls gets all the calls that were made to Enqueue.
// Check the length with:
//     len(mockedPipelineSettingController.EnqueueCalls())
func (mock *PipelineSettingControllerMock) EnqueueCalls() []struct {
	Namespace string
	Name      string
} {
	var calls []struct {
		Namespace string
		Name      string
	}
	lockPipelineSettingControllerMockEnqueue.RLock()
	calls = mock.calls.Enqueue
	lockPipelineSettingControllerMockEnqueue.RUnlock()
	return calls
}

// EnqueueAfter calls EnqueueAfterFunc.
func (mock *PipelineSettingControllerMock) EnqueueAfter(namespace string, name string, after time.Duration) {
	if mock.EnqueueAfterFunc == nil {
		panic("PipelineSettingControllerMock.EnqueueAfterFunc: method is nil but PipelineSettingController.EnqueueAfter was just called")
	}
	callInfo := struct {
		Namespace string
		Name      string
		After     time.Duration
	}{
		Namespace: namespace,
		Name:      name,
		After:     after,
	}
	lockPipelineSettingControllerMockEnqueueAfter.Lock()
	mock.calls.EnqueueAfter = append(mock.calls.EnqueueAfter, callInfo)
	lockPipelineSettingControllerMockEnqueueAfter.Unlock()
	mock.EnqueueAfterFunc(namespace, name, after)
}

// EnqueueAfterCalls gets all the calls that were made to EnqueueAfter.
// Check the length with:
//     len(mockedPipelineSettingController.EnqueueAfterCalls())
func (mock *PipelineSettingControllerMock) EnqueueAfterCalls() []struct {
	Namespace string
	Name      string
	After     time.Duration
} {
	var calls []struct {
		Namespace string
		Name      string
		After     time.Duration
	}
	lockPipelineSettingControllerMockEnqueueAfter.RLock()
	calls = mock.calls.EnqueueAfter
	lockPipelineSettingControllerMockEnqueueAfter.RUnlock()
	return calls
}

// Generic calls GenericFunc.
func (mock *PipelineSettingControllerMock) Generic() controller.GenericController {
	if mock.GenericFunc == nil {
		panic("PipelineSettingControllerMock.GenericFunc: method is nil but PipelineSettingController.Generic was just called")
	}
	callInfo := struct {
	}{}
	lockPipelineSettingControllerMockGeneric.Lock()
	mock.calls.Generic = append(mock.calls.Generic, callInfo)
	lockPipelineSettingControllerMockGeneric.Unlock()
	return mock.GenericFunc()
}

// GenericCalls gets all the calls that were made to Generic.
// Check the length with:
//     len(mockedPipelineSettingController.GenericCalls())
func (mock *PipelineSettingControllerMock) GenericCalls() []struct {
} {
	var calls []struct {
	}
	lockPipelineSettingControllerMockGeneric.RLock()
	calls = mock.calls.Generic
	lockPipelineSettingControllerMockGeneric.RUnlock()
	return calls
}

// Informer calls InformerFunc.
func (mock *PipelineSettingControllerMock) Informer() cache.SharedIndexInformer {
	if mock.InformerFunc == nil {
		panic("PipelineSettingControllerMock.InformerFunc: method is nil but PipelineSettingController.Informer was just called")
	}
	callInfo := struct {
	}{}
	lockPipelineSettingControllerMockInformer.Lock()
	mock.calls.Informer = append(mock.calls.Informer, callInfo)
	lockPipelineSettingControllerMockInformer.Unlock()
	return mock.InformerFunc()
}

// InformerCalls gets all the calls that were made to Informer.
// Check the length with:
//     len(mockedPipelineSettingController.InformerCalls())
func (mock *PipelineSettingControllerMock) InformerCalls() []struct {
} {
	var calls []struct {
	}
	lockPipelineSettingControllerMockInformer.RLock()
	calls = mock.calls.Informer
	lockPipelineSettingControllerMockInformer.RUnlock()
	return calls
}

// Lister calls ListerFunc.
func (mock *PipelineSettingControllerMock) Lister() v31.PipelineSettingLister {
	if mock.ListerFunc == nil {
		panic("PipelineSettingControllerMock.ListerFunc: method is nil but PipelineSettingController.Lister was just called")
	}
	callInfo := struct {
	}{}
	lockPipelineSettingControllerMockLister.Lock()
	mock.calls.Lister = append(mock.calls.Lister, callInfo)
	lockPipelineSettingControllerMockLister.Unlock()
	return mock.ListerFunc()
}

// ListerCalls gets all the calls that were made to Lister.
// Check the length with:
//     len(mockedPipelineSettingController.ListerCalls())
func (mock *PipelineSettingControllerMock) ListerCalls() []struct {
} {
	var calls []struct {
	}
	lockPipelineSettingControllerMockLister.RLock()
	calls = mock.calls.Lister
	lockPipelineSettingControllerMockLister.RUnlock()
	return calls
}

var (
	lockPipelineSettingInterfaceMockAddClusterScopedFeatureHandler   sync.RWMutex
	lockPipelineSettingInterfaceMockAddClusterScopedFeatureLifecycle sync.RWMutex
	lockPipelineSettingInterfaceMockAddClusterScopedHandler          sync.RWMutex
	lockPipelineSettingInterfaceMockAddClusterScopedLifecycle        sync.RWMutex
	lockPipelineSettingInterfaceMockAddFeatureHandler                sync.RWMutex
	lockPipelineSettingInterfaceMockAddFeatureLifecycle              sync.RWMutex
	lockPipelineSettingInterfaceMockAddHandler                       sync.RWMutex
	lockPipelineSettingInterfaceMockAddLifecycle                     sync.RWMutex
	lockPipelineSettingInterfaceMockController                       sync.RWMutex
	lockPipelineSettingInterfaceMockCreate                           sync.RWMutex
	lockPipelineSettingInterfaceMockDelete                           sync.RWMutex
	lockPipelineSettingInterfaceMockDeleteCollection                 sync.RWMutex
	lockPipelineSettingInterfaceMockDeleteNamespaced                 sync.RWMutex
	lockPipelineSettingInterfaceMockGet                              sync.RWMutex
	lockPipelineSettingInterfaceMockGetNamespaced                    sync.RWMutex
	lockPipelineSettingInterfaceMockList                             sync.RWMutex
	lockPipelineSettingInterfaceMockListNamespaced                   sync.RWMutex
	lockPipelineSettingInterfaceMockObjectClient                     sync.RWMutex
	lockPipelineSettingInterfaceMockUpdate                           sync.RWMutex
	lockPipelineSettingInterfaceMockWatch                            sync.RWMutex
)

// Ensure, that PipelineSettingInterfaceMock does implement v31.PipelineSettingInterface.
// If this is not the case, regenerate this file with moq.
var _ v31.PipelineSettingInterface = &PipelineSettingInterfaceMock{}

// PipelineSettingInterfaceMock is a mock implementation of v31.PipelineSettingInterface.
//
//     func TestSomethingThatUsesPipelineSettingInterface(t *testing.T) {
//
//         // make and configure a mocked v31.PipelineSettingInterface
//         mockedPipelineSettingInterface := &PipelineSettingInterfaceMock{
//             AddClusterScopedFeatureHandlerFunc: func(ctx context.Context, enabled func() bool, name string, clusterName string, syncMoqParam v31.PipelineSettingHandlerFunc)  {
// 	               panic("mock out the AddClusterScopedFeatureHandler method")
//             },
//             AddClusterScopedFeatureLifecycleFunc: func(ctx context.Context, enabled func() bool, name string, clusterName string, lifecycle v31.PipelineSettingLifecycle)  {
// 	               panic("mock out the AddClusterScopedFeatureLifecycle method")
//             },
//             AddClusterScopedHandlerFunc: func(ctx context.Context, name string, clusterName string, syncMoqParam v31.PipelineSettingHandlerFunc)  {
// 	               panic("mock out the AddClusterScopedHandler method")
//             },
//             AddClusterScopedLifecycleFunc: func(ctx context.Context, name string, clusterName string, lifecycle v31.PipelineSettingLifecycle)  {
// 	               panic("mock out the AddClusterScopedLifecycle method")
//             },
//             AddFeatureHandlerFunc: func(ctx context.Context, enabled func() bool, name string, syncMoqParam v31.PipelineSettingHandlerFunc)  {
// 	               panic("mock out the AddFeatureHandler method")
//             },
//             AddFeatureLifecycleFunc: func(ctx context.Context, enabled func() bool, name string, lifecycle v31.PipelineSettingLifecycle)  {
// 	               panic("mock out the AddFeatureLifecycle method")
//             },
//             AddHandlerFunc: func(ctx context.Context, name string, syncMoqParam v31.PipelineSettingHandlerFunc)  {
// 	               panic("mock out the AddHandler method")
//             },
//             AddLifecycleFunc: func(ctx context.Context, name string, lifecycle v31.PipelineSettingLifecycle)  {
// 	               panic("mock out the AddLifecycle method")
//             },
//             ControllerFunc: func() v31.PipelineSettingController {
// 	               panic("mock out the Controller method")
//             },
//             CreateFunc: func(in1 *v3.PipelineSetting) (*v3.PipelineSetting, error) {
// 	               panic("mock out the Create method")
//             },
//             DeleteFunc: func(name string, options *metav1.DeleteOptions) error {
// 	               panic("mock out the Delete method")
//             },
//             DeleteCollectionFunc: func(deleteOpts *metav1.DeleteOptions, listOpts metav1.ListOptions) error {
// 	               panic("mock out the DeleteCollection method")
//             },
//             DeleteNamespacedFunc: func(namespace string, name string, options *metav1.DeleteOptions) error {
// 	               panic("mock out the DeleteNamespaced method")
//             },
//             GetFunc: func(name string, opts metav1.GetOptions) (*v3.PipelineSetting, error) {
// 	               panic("mock out the Get method")
//             },
//             GetNamespacedFunc: func(namespace string, name string, opts metav1.GetOptions) (*v3.PipelineSetting, error) {
// 	               panic("mock out the GetNamespaced method")
//             },
//             ListFunc: func(opts metav1.ListOptions) (*v3.PipelineSettingList, error) {
// 	               panic("mock out the List method")
//             },
//             ListNamespacedFunc: func(namespace string, opts metav1.ListOptions) (*v3.PipelineSettingList, error) {
// 	               panic("mock out the ListNamespaced method")
//             },
//             ObjectClientFunc: func() *objectclient.ObjectClient {
// 	               panic("mock out the ObjectClient method")
//             },
//             UpdateFunc: func(in1 *v3.PipelineSetting) (*v3.PipelineSetting, error) {
// 	               panic("mock out the Update method")
//             },
//             WatchFunc: func(opts metav1.ListOptions) (watch.Interface, error) {
// 	               panic("mock out the Watch method")
//             },
//         }
//
//         // use mockedPipelineSettingInterface in code that requires v31.PipelineSettingInterface
//         // and then make assertions.
//
//     }
type PipelineSettingInterfaceMock struct {
	// AddClusterScopedFeatureHandlerFunc mocks the AddClusterScopedFeatureHandler method.
	AddClusterScopedFeatureHandlerFunc func(ctx context.Context, enabled func() bool, name string, clusterName string, syncMoqParam v31.PipelineSettingHandlerFunc)

	// AddClusterScopedFeatureLifecycleFunc mocks the AddClusterScopedFeatureLifecycle method.
	AddClusterScopedFeatureLifecycleFunc func(ctx context.Context, enabled func() bool, name string, clusterName string, lifecycle v31.PipelineSettingLifecycle)

	// AddClusterScopedHandlerFunc mocks the AddClusterScopedHandler method.
	AddClusterScopedHandlerFunc func(ctx context.Context, name string, clusterName string, syncMoqParam v31.PipelineSettingHandlerFunc)

	// AddClusterScopedLifecycleFunc mocks the AddClusterScopedLifecycle method.
	AddClusterScopedLifecycleFunc func(ctx context.Context, name string, clusterName string, lifecycle v31.PipelineSettingLifecycle)

	// AddFeatureHandlerFunc mocks the AddFeatureHandler method.
	AddFeatureHandlerFunc func(ctx context.Context, enabled func() bool, name string, syncMoqParam v31.PipelineSettingHandlerFunc)

	// AddFeatureLifecycleFunc mocks the AddFeatureLifecycle method.
	AddFeatureLifecycleFunc func(ctx context.Context, enabled func() bool, name string, lifecycle v31.PipelineSettingLifecycle)

	// AddHandlerFunc mocks the AddHandler method.
	AddHandlerFunc func(ctx context.Context, name string, syncMoqParam v31.PipelineSettingHandlerFunc)

	// AddLifecycleFunc mocks the AddLifecycle method.
	AddLifecycleFunc func(ctx context.Context, name string, lifecycle v31.PipelineSettingLifecycle)

	// ControllerFunc mocks the Controller method.
	ControllerFunc func() v31.PipelineSettingController

	// CreateFunc mocks the Create method.
	CreateFunc func(in1 *v3.PipelineSetting) (*v3.PipelineSetting, error)

	// DeleteFunc mocks the Delete method.
	DeleteFunc func(name string, options *metav1.DeleteOptions) error

	// DeleteCollectionFunc mocks the DeleteCollection method.
	DeleteCollectionFunc func(deleteOpts *metav1.DeleteOptions, listOpts metav1.ListOptions) error

	// DeleteNamespacedFunc mocks the DeleteNamespaced method.
	DeleteNamespacedFunc func(namespace string, name string, options *metav1.DeleteOptions) error

	// GetFunc mocks the Get method.
	GetFunc func(name string, opts metav1.GetOptions) (*v3.PipelineSetting, error)

	// GetNamespacedFunc mocks the GetNamespaced method.
	GetNamespacedFunc func(namespace string, name string, opts metav1.GetOptions) (*v3.PipelineSetting, error)

	// ListFunc mocks the List method.
	ListFunc func(opts metav1.ListOptions) (*v3.PipelineSettingList, error)

	// ListNamespacedFunc mocks the ListNamespaced method.
	ListNamespacedFunc func(namespace string, opts metav1.ListOptions) (*v3.PipelineSettingList, error)

	// ObjectClientFunc mocks the ObjectClient method.
	ObjectClientFunc func() *objectclient.ObjectClient

	// UpdateFunc mocks the Update method.
	UpdateFunc func(in1 *v3.PipelineSetting) (*v3.PipelineSetting, error)

	// WatchFunc mocks the Watch method.
	WatchFunc func(opts metav1.ListOptions) (watch.Interface, error)

	// calls tracks calls to the methods.
	calls struct {
		// AddClusterScopedFeatureHandler holds details about calls to the AddClusterScopedFeatureHandler method.
		AddClusterScopedFeatureHandler []struct {
			// Ctx is the ctx argument value.
			Ctx context.Context
			// Enabled is the enabled argument value.
			Enabled func() bool
			// Name is the name argument value.
			Name string
			// ClusterName is the clusterName argument value.
			ClusterName string
			// Sync is the sync argument value.
			Sync v31.PipelineSettingHandlerFunc
		}
		// AddClusterScopedFeatureLifecycle holds details about calls to the AddClusterScopedFeatureLifecycle method.
		AddClusterScopedFeatureLifecycle []struct {
			// Ctx is the ctx argument value.
			Ctx context.Context
			// Enabled is the enabled argument value.
			Enabled func() bool
			// Name is the name argument value.
			Name string
			// ClusterName is the clusterName argument value.
			ClusterName string
			// Lifecycle is the lifecycle argument value.
			Lifecycle v31.PipelineSettingLifecycle
		}
		// AddClusterScopedHandler holds details about calls to the AddClusterScopedHandler method.
		AddClusterScopedHandler []struct {
			// Ctx is the ctx argument value.
			Ctx context.Context
			// Name is the name argument value.
			Name string
			// ClusterName is the clusterName argument value.
			ClusterName string
			// Sync is the sync argument value.
			Sync v31.PipelineSettingHandlerFunc
		}
		// AddClusterScopedLifecycle holds details about calls to the AddClusterScopedLifecycle method.
		AddClusterScopedLifecycle []struct {
			// Ctx is the ctx argument value.
			Ctx context.Context
			// Name is the name argument value.
			Name string
			// ClusterName is the clusterName argument value.
			ClusterName string
			// Lifecycle is the lifecycle argument value.
			Lifecycle v31.PipelineSettingLifecycle
		}
		// AddFeatureHandler holds details about calls to the AddFeatureHandler method.
		AddFeatureHandler []struct {
			// Ctx is the ctx argument value.
			Ctx context.Context
			// Enabled is the enabled argument value.
			Enabled func() bool
			// Name is the name argument value.
			Name string
			// Sync is the sync argument value.
			Sync v31.PipelineSettingHandlerFunc
		}
		// AddFeatureLifecycle holds details about calls to the AddFeatureLifecycle method.
		AddFeatureLifecycle []struct {
			// Ctx is the ctx argument value.
			Ctx context.Context
			// Enabled is the enabled argument value.
			Enabled func() bool
			// Name is the name argument value.
			Name string
			// Lifecycle is the lifecycle argument value.
			Lifecycle v31.PipelineSettingLifecycle
		}
		// AddHandler holds details about calls to the AddHandler method.
		AddHandler []struct {
			// Ctx is the ctx argument value.
			Ctx context.Context
			// Name is the name argument value.
			Name string
			// Sync is the sync argument value.
			Sync v31.PipelineSettingHandlerFunc
		}
		// AddLifecycle holds details about calls to the AddLifecycle method.
		AddLifecycle []struct {
			// Ctx is the ctx argument value.
			Ctx context.Context
			// Name is the name argument value.
			Name string
			// Lifecycle is the lifecycle argument value.
			Lifecycle v31.PipelineSettingLifecycle
		}
		// Controller holds details about calls to the Controller method.
		Controller []struct {
		}
		// Create holds details about calls to the Create method.
		Create []struct {
			// In1 is the in1 argument value.
			In1 *v3.PipelineSetting
		}
		// Delete holds details about calls to the Delete method.
		Delete []struct {
			// Name is the name argument value.
			Name string
			// Options is the options argument value.
			Options *metav1.DeleteOptions
		}
		// DeleteCollection holds details about calls to the DeleteCollection method.
		DeleteCollection []struct {
			// DeleteOpts is the deleteOpts argument value.
			DeleteOpts *metav1.DeleteOptions
			// ListOpts is the listOpts argument value.
			ListOpts metav1.ListOptions
		}
		// DeleteNamespaced holds details about calls to the DeleteNamespaced method.
		DeleteNamespaced []struct {
			// Namespace is the namespace argument value.
			Namespace string
			// Name is the name argument value.
			Name string
			// Options is the options argument value.
			Options *metav1.DeleteOptions
		}
		// Get holds details about calls to the Get method.
		Get []struct {
			// Name is the name argument value.
			Name string
			// Opts is the opts argument value.
			Opts metav1.GetOptions
		}
		// GetNamespaced holds details about calls to the GetNamespaced method.
		GetNamespaced []struct {
			// Namespace is the namespace argument value.
			Namespace string
			// Name is the name argument value.
			Name string
			// Opts is the opts argument value.
			Opts metav1.GetOptions
		}
		// List holds details about calls to the List method.
		List []struct {
			// Opts is the opts argument value.
			Opts metav1.ListOptions
		}
		// ListNamespaced holds details about calls to the ListNamespaced method.
		ListNamespaced []struct {
			// Namespace is the namespace argument value.
			Namespace string
			// Opts is the opts argument value.
			Opts metav1.ListOptions
		}
		// ObjectClient holds details about calls to the ObjectClient method.
		ObjectClient []struct {
		}
		// Update holds details about calls to the Update method.
		Update []struct {
			// In1 is the in1 argument value.
			In1 *v3.PipelineSetting
		}
		// Watch holds details about calls to the Watch method.
		Watch []struct {
			// Opts is the opts argument value.
			Opts metav1.ListOptions
		}
	}
}

// AddClusterScopedFeatureHandler calls AddClusterScopedFeatureHandlerFunc.
func (mock *PipelineSettingInterfaceMock) AddClusterScopedFeatureHandler(ctx context.Context, enabled func() bool, name string, clusterName string, syncMoqParam v31.PipelineSettingHandlerFunc) {
	if mock.AddClusterScopedFeatureHandlerFunc == nil {
		panic("PipelineSettingInterfaceMock.AddClusterScopedFeatureHandlerFunc: method is nil but PipelineSettingInterface.AddClusterScopedFeatureHandler was just called")
	}
	callInfo := struct {
		Ctx         context.Context
		Enabled     func() bool
		Name        string
		ClusterName string
		Sync        v31.PipelineSettingHandlerFunc
	}{
		Ctx:         ctx,
		Enabled:     enabled,
		Name:        name,
		ClusterName: clusterName,
		Sync:        syncMoqParam,
	}
	lockPipelineSettingInterfaceMockAddClusterScopedFeatureHandler.Lock()
	mock.calls.AddClusterScopedFeatureHandler = append(mock.calls.AddClusterScopedFeatureHandler, callInfo)
	lockPipelineSettingInterfaceMockAddClusterScopedFeatureHandler.Unlock()
	mock.AddClusterScopedFeatureHandlerFunc(ctx, enabled, name, clusterName, syncMoqParam)
}

// AddClusterScopedFeatureHandlerCalls gets all the calls that were made to AddClusterScopedFeatureHandler.
// Check the length with:
//     len(mockedPipelineSettingInterface.AddClusterScopedFeatureHandlerCalls())
func (mock *PipelineSettingInterfaceMock) AddClusterScopedFeatureHandlerCalls() []struct {
	Ctx         context.Context
	Enabled     func() bool
	Name        string
	ClusterName string
	Sync        v31.PipelineSettingHandlerFunc
} {
	var calls []struct {
		Ctx         context.Context
		Enabled     func() bool
		Name        string
		ClusterName string
		Sync        v31.PipelineSettingHandlerFunc
	}
	lockPipelineSettingInterfaceMockAddClusterScopedFeatureHandler.RLock()
	calls = mock.calls.AddClusterScopedFeatureHandler
	lockPipelineSettingInterfaceMockAddClusterScopedFeatureHandler.RUnlock()
	return calls
}

// AddClusterScopedFeatureLifecycle calls AddClusterScopedFeatureLifecycleFunc.
func (mock *PipelineSettingInterfaceMock) AddClusterScopedFeatureLifecycle(ctx context.Context, enabled func() bool, name string, clusterName string, lifecycle v31.PipelineSettingLifecycle) {
	if mock.AddClusterScopedFeatureLifecycleFunc == nil {
		panic("PipelineSettingInterfaceMock.AddClusterScopedFeatureLifecycleFunc: method is nil but PipelineSettingInterface.AddClusterScopedFeatureLifecycle was just called")
	}
	callInfo := struct {
		Ctx         context.Context
		Enabled     func() bool
		Name        string
		ClusterName string
		Lifecycle   v31.PipelineSettingLifecycle
	}{
		Ctx:         ctx,
		Enabled:     enabled,
		Name:        name,
		ClusterName: clusterName,
		Lifecycle:   lifecycle,
	}
	lockPipelineSettingInterfaceMockAddClusterScopedFeatureLifecycle.Lock()
	mock.calls.AddClusterScopedFeatureLifecycle = append(mock.calls.AddClusterScopedFeatureLifecycle, callInfo)
	lockPipelineSettingInterfaceMockAddClusterScopedFeatureLifecycle.Unlock()
	mock.AddClusterScopedFeatureLifecycleFunc(ctx, enabled, name, clusterName, lifecycle)
}

// AddClusterScopedFeatureLifecycleCalls gets all the calls that were made to AddClusterScopedFeatureLifecycle.
// Check the length with:
//     len(mockedPipelineSettingInterface.AddClusterScopedFeatureLifecycleCalls())
func (mock *PipelineSettingInterfaceMock) AddClusterScopedFeatureLifecycleCalls() []struct {
	Ctx         context.Context
	Enabled     func() bool
	Name        string
	ClusterName string
	Lifecycle   v31.PipelineSettingLifecycle
} {
	var calls []struct {
		Ctx         context.Context
		Enabled     func() bool
		Name        string
		ClusterName string
		Lifecycle   v31.PipelineSettingLifecycle
	}
	lockPipelineSettingInterfaceMockAddClusterScopedFeatureLifecycle.RLock()
	calls = mock.calls.AddClusterScopedFeatureLifecycle
	lockPipelineSettingInterfaceMockAddClusterScopedFeatureLifecycle.RUnlock()
	return calls
}

// AddClusterScopedHandler calls AddClusterScopedHandlerFunc.
func (mock *PipelineSettingInterfaceMock) AddClusterScopedHandler(ctx context.Context, name string, clusterName string, syncMoqParam v31.PipelineSettingHandlerFunc) {
	if mock.AddClusterScopedHandlerFunc == nil {
		panic("PipelineSettingInterfaceMock.AddClusterScopedHandlerFunc: method is nil but PipelineSettingInterface.AddClusterScopedHandler was just called")
	}
	callInfo := struct {
		Ctx         context.Context
		Name        string
		ClusterName string
		Sync        v31.PipelineSettingHandlerFunc
	}{
		Ctx:         ctx,
		Name:        name,
		ClusterName: clusterName,
		Sync:        syncMoqParam,
	}
	lockPipelineSettingInterfaceMockAddClusterScopedHandler.Lock()
	mock.calls.AddClusterScopedHandler = append(mock.calls.AddClusterScopedHandler, callInfo)
	lockPipelineSettingInterfaceMockAddClusterScopedHandler.Unlock()
	mock.AddClusterScopedHandlerFunc(ctx, name, clusterName, syncMoqParam)
}

// AddClusterScopedHandlerCalls gets all the calls that were made to AddClusterScopedHandler.
// Check the length with:
//     len(mockedPipelineSettingInterface.AddClusterScopedHandlerCalls())
func (mock *PipelineSettingInterfaceMock) AddClusterScopedHandlerCalls() []struct {
	Ctx         context.Context
	Name        string
	ClusterName string
	Sync        v31.PipelineSettingHandlerFunc
} {
	var calls []struct {
		Ctx         context.Context
		Name        string
		ClusterName string
		Sync        v31.PipelineSettingHandlerFunc
	}
	lockPipelineSettingInterfaceMockAddClusterScopedHandler.RLock()
	calls = mock.calls.AddClusterScopedHandler
	lockPipelineSettingInterfaceMockAddClusterScopedHandler.RUnlock()
	return calls
}

// AddClusterScopedLifecycle calls AddClusterScopedLifecycleFunc.
func (mock *PipelineSettingInterfaceMock) AddClusterScopedLifecycle(ctx context.Context, name string, clusterName string, lifecycle v31.PipelineSettingLifecycle) {
	if mock.AddClusterScopedLifecycleFunc == nil {
		panic("PipelineSettingInterfaceMock.AddClusterScopedLifecycleFunc: method is nil but PipelineSettingInterface.AddClusterScopedLifecycle was just called")
	}
	callInfo := struct {
		Ctx         context.Context
		Name        string
		ClusterName string
		Lifecycle   v31.PipelineSettingLifecycle
	}{
		Ctx:         ctx,
		Name:        name,
		ClusterName: clusterName,
		Lifecycle:   lifecycle,
	}
	lockPipelineSettingInterfaceMockAddClusterScopedLifecycle.Lock()
	mock.calls.AddClusterScopedLifecycle = append(mock.calls.AddClusterScopedLifecycle, callInfo)
	lockPipelineSettingInterfaceMockAddClusterScopedLifecycle.Unlock()
	mock.AddClusterScopedLifecycleFunc(ctx, name, clusterName, lifecycle)
}

// AddClusterScopedLifecycleCalls gets all the calls that were made to AddClusterScopedLifecycle.
// Check the length with:
//     len(mockedPipelineSettingInterface.AddClusterScopedLifecycleCalls())
func (mock *PipelineSettingInterfaceMock) AddClusterScopedLifecycleCalls() []struct {
	Ctx         context.Context
	Name        string
	ClusterName string
	Lifecycle   v31.PipelineSettingLifecycle
} {
	var calls []struct {
		Ctx         context.Context
		Name        string
		ClusterName string
		Lifecycle   v31.PipelineSettingLifecycle
	}
	lockPipelineSettingInterfaceMockAddClusterScopedLifecycle.RLock()
	calls = mock.calls.AddClusterScopedLifecycle
	lockPipelineSettingInterfaceMockAddClusterScopedLifecycle.RUnlock()
	return calls
}

// AddFeatureHandler calls AddFeatureHandlerFunc.
func (mock *PipelineSettingInterfaceMock) AddFeatureHandler(ctx context.Context, enabled func() bool, name string, syncMoqParam v31.PipelineSettingHandlerFunc) {
	if mock.AddFeatureHandlerFunc == nil {
		panic("PipelineSettingInterfaceMock.AddFeatureHandlerFunc: method is nil but PipelineSettingInterface.AddFeatureHandler was just called")
	}
	callInfo := struct {
		Ctx     context.Context
		Enabled func() bool
		Name    string
		Sync    v31.PipelineSettingHandlerFunc
	}{
		Ctx:     ctx,
		Enabled: enabled,
		Name:    name,
		Sync:    syncMoqParam,
	}
	lockPipelineSettingInterfaceMockAddFeatureHandler.Lock()
	mock.calls.AddFeatureHandler = append(mock.calls.AddFeatureHandler, callInfo)
	lockPipelineSettingInterfaceMockAddFeatureHandler.Unlock()
	mock.AddFeatureHandlerFunc(ctx, enabled, name, syncMoqParam)
}

// AddFeatureHandlerCalls gets all the calls that were made to AddFeatureHandler.
// Check the length with:
//     len(mockedPipelineSettingInterface.AddFeatureHandlerCalls())
func (mock *PipelineSettingInterfaceMock) AddFeatureHandlerCalls() []struct {
	Ctx     context.Context
	Enabled func() bool
	Name    string
	Sync    v31.PipelineSettingHandlerFunc
} {
	var calls []struct {
		Ctx     context.Context
		Enabled func() bool
		Name    string
		Sync    v31.PipelineSettingHandlerFunc
	}
	lockPipelineSettingInterfaceMockAddFeatureHandler.RLock()
	calls = mock.calls.AddFeatureHandler
	lockPipelineSettingInterfaceMockAddFeatureHandler.RUnlock()
	return calls
}

// AddFeatureLifecycle calls AddFeatureLifecycleFunc.
func (mock *PipelineSettingInterfaceMock) AddFeatureLifecycle(ctx context.Context, enabled func() bool, name string, lifecycle v31.PipelineSettingLifecycle) {
	if mock.AddFeatureLifecycleFunc == nil {
		panic("PipelineSettingInterfaceMock.AddFeatureLifecycleFunc: method is nil but PipelineSettingInterface.AddFeatureLifecycle was just called")
	}
	callInfo := struct {
		Ctx       context.Context
		Enabled   func() bool
		Name      string
		Lifecycle v31.PipelineSettingLifecycle
	}{
		Ctx:       ctx,
		Enabled:   enabled,
		Name:      name,
		Lifecycle: lifecycle,
	}
	lockPipelineSettingInterfaceMockAddFeatureLifecycle.Lock()
	mock.calls.AddFeatureLifecycle = append(mock.calls.AddFeatureLifecycle, callInfo)
	lockPipelineSettingInterfaceMockAddFeatureLifecycle.Unlock()
	mock.AddFeatureLifecycleFunc(ctx, enabled, name, lifecycle)
}

// AddFeatureLifecycleCalls gets all the calls that were made to AddFeatureLifecycle.
// Check the length with:
//     len(mockedPipelineSettingInterface.AddFeatureLifecycleCalls())
func (mock *PipelineSettingInterfaceMock) AddFeatureLifecycleCalls() []struct {
	Ctx       context.Context
	Enabled   func() bool
	Name      string
	Lifecycle v31.PipelineSettingLifecycle
} {
	var calls []struct {
		Ctx       context.Context
		Enabled   func() bool
		Name      string
		Lifecycle v31.PipelineSettingLifecycle
	}
	lockPipelineSettingInterfaceMockAddFeatureLifecycle.RLock()
	calls = mock.calls.AddFeatureLifecycle
	lockPipelineSettingInterfaceMockAddFeatureLifecycle.RUnlock()
	return calls
}

// AddHandler calls AddHandlerFunc.
func (mock *PipelineSettingInterfaceMock) AddHandler(ctx context.Context, name string, syncMoqParam v31.PipelineSettingHandlerFunc) {
	if mock.AddHandlerFunc == nil {
		panic("PipelineSettingInterfaceMock.AddHandlerFunc: method is nil but PipelineSettingInterface.AddHandler was just called")
	}
	callInfo := struct {
		Ctx  context.Context
		Name string
		Sync v31.PipelineSettingHandlerFunc
	}{
		Ctx:  ctx,
		Name: name,
		Sync: syncMoqParam,
	}
	lockPipelineSettingInterfaceMockAddHandler.Lock()
	mock.calls.AddHandler = append(mock.calls.AddHandler, callInfo)
	lockPipelineSettingInterfaceMockAddHandler.Unlock()
	mock.AddHandlerFunc(ctx, name, syncMoqParam)
}

// AddHandlerCalls gets all the calls that were made to AddHandler.
// Check the length with:
//     len(mockedPipelineSettingInterface.AddHandlerCalls())
func (mock *PipelineSettingInterfaceMock) AddHandlerCalls() []struct {
	Ctx  context.Context
	Name string
	Sync v31.PipelineSettingHandlerFunc
} {
	var calls []struct {
		Ctx  context.Context
		Name string
		Sync v31.PipelineSettingHandlerFunc
	}
	lockPipelineSettingInterfaceMockAddHandler.RLock()
	calls = mock.calls.AddHandler
	lockPipelineSettingInterfaceMockAddHandler.RUnlock()
	return calls
}

// AddLifecycle calls AddLifecycleFunc.
func (mock *PipelineSettingInterfaceMock) AddLifecycle(ctx context.Context, name string, lifecycle v31.PipelineSettingLifecycle) {
	if mock.AddLifecycleFunc == nil {
		panic("PipelineSettingInterfaceMock.AddLifecycleFunc: method is nil but PipelineSettingInterface.AddLifecycle was just called")
	}
	callInfo := struct {
		Ctx       context.Context
		Name      string
		Lifecycle v31.PipelineSettingLifecycle
	}{
		Ctx:       ctx,
		Name:      name,
		Lifecycle: lifecycle,
	}
	lockPipelineSettingInterfaceMockAddLifecycle.Lock()
	mock.calls.AddLifecycle = append(mock.calls.AddLifecycle, callInfo)
	lockPipelineSettingInterfaceMockAddLifecycle.Unlock()
	mock.AddLifecycleFunc(ctx, name, lifecycle)
}

// AddLifecycleCalls gets all the calls that were made to AddLifecycle.
// Check the length with:
//     len(mockedPipelineSettingInterface.AddLifecycleCalls())
func (mock *PipelineSettingInterfaceMock) AddLifecycleCalls() []struct {
	Ctx       context.Context
	Name      string
	Lifecycle v31.PipelineSettingLifecycle
} {
	var calls []struct {
		Ctx       context.Context
		Name      string
		Lifecycle v31.PipelineSettingLifecycle
	}
	lockPipelineSettingInterfaceMockAddLifecycle.RLock()
	calls = mock.calls.AddLifecycle
	lockPipelineSettingInterfaceMockAddLifecycle.RUnlock()
	return calls
}

// Controller calls ControllerFunc.
func (mock *PipelineSettingInterfaceMock) Controller() v31.PipelineSettingController {
	if mock.ControllerFunc == nil {
		panic("PipelineSettingInterfaceMock.ControllerFunc: method is nil but PipelineSettingInterface.Controller was just called")
	}
	callInfo := struct {
	}{}
	lockPipelineSettingInterfaceMockController.Lock()
	mock.calls.Controller = append(mock.calls.Controller, callInfo)
	lockPipelineSettingInterfaceMockController.Unlock()
	return mock.ControllerFunc()
}

// ControllerCalls gets all the calls that were made to Controller.
// Check the length with:
//     len(mockedPipelineSettingInterface.ControllerCalls())
func (mock *PipelineSettingInterfaceMock) ControllerCalls() []struct {
} {
	var calls []struct {
	}
	lockPipelineSettingInterfaceMockController.RLock()
	calls = mock.calls.Controller
	lockPipelineSettingInterfaceMockController.RUnlock()
	return calls
}

// Create calls CreateFunc.
func (mock *PipelineSettingInterfaceMock) Create(in1 *v3.PipelineSetting) (*v3.PipelineSetting, error) {
	if mock.CreateFunc == nil {
		panic("PipelineSettingInterfaceMock.CreateFunc: method is nil but PipelineSettingInterface.Create was just called")
	}
	callInfo := struct {
		In1 *v3.PipelineSetting
	}{
		In1: in1,
	}
	lockPipelineSettingInterfaceMockCreate.Lock()
	mock.calls.Create = append(mock.calls.Create, callInfo)
	lockPipelineSettingInterfaceMockCreate.Unlock()
	return mock.CreateFunc(in1)
}

// CreateCalls gets all the calls that were made to Create.
// Check the length with:
//     len(mockedPipelineSettingInterface.CreateCalls())
func (mock *PipelineSettingInterfaceMock) CreateCalls() []struct {
	In1 *v3.PipelineSetting
} {
	var calls []struct {
		In1 *v3.PipelineSetting
	}
	lockPipelineSettingInterfaceMockCreate.RLock()
	calls = mock.calls.Create
	lockPipelineSettingInterfaceMockCreate.RUnlock()
	return calls
}

// Delete calls DeleteFunc.
func (mock *PipelineSettingInterfaceMock) Delete(name string, options *metav1.DeleteOptions) error {
	if mock.DeleteFunc == nil {
		panic("PipelineSettingInterfaceMock.DeleteFunc: method is nil but PipelineSettingInterface.Delete was just called")
	}
	callInfo := struct {
		Name    string
		Options *metav1.DeleteOptions
	}{
		Name:    name,
		Options: options,
	}
	lockPipelineSettingInterfaceMockDelete.Lock()
	mock.calls.Delete = append(mock.calls.Delete, callInfo)
	lockPipelineSettingInterfaceMockDelete.Unlock()
	return mock.DeleteFunc(name, options)
}

// DeleteCalls gets all the calls that were made to Delete.
// Check the length with:
//     len(mockedPipelineSettingInterface.DeleteCalls())
func (mock *PipelineSettingInterfaceMock) DeleteCalls() []struct {
	Name    string
	Options *metav1.DeleteOptions
} {
	var calls []struct {
		Name    string
		Options *metav1.DeleteOptions
	}
	lockPipelineSettingInterfaceMockDelete.RLock()
	calls = mock.calls.Delete
	lockPipelineSettingInterfaceMockDelete.RUnlock()
	return calls
}

// DeleteCollection calls DeleteCollectionFunc.
func (mock *PipelineSettingInterfaceMock) DeleteCollection(deleteOpts *metav1.DeleteOptions, listOpts metav1.ListOptions) error {
	if mock.DeleteCollectionFunc == nil {
		panic("PipelineSettingInterfaceMock.DeleteCollectionFunc: method is nil but PipelineSettingInterface.DeleteCollection was just called")
	}
	callInfo := struct {
		DeleteOpts *metav1.DeleteOptions
		ListOpts   metav1.ListOptions
	}{
		DeleteOpts: deleteOpts,
		ListOpts:   listOpts,
	}
	lockPipelineSettingInterfaceMockDeleteCollection.Lock()
	mock.calls.DeleteCollection = append(mock.calls.DeleteCollection, callInfo)
	lockPipelineSettingInterfaceMockDeleteCollection.Unlock()
	return mock.DeleteCollectionFunc(deleteOpts, listOpts)
}

// DeleteCollectionCalls gets all the calls that were made to DeleteCollection.
// Check the length with:
//     len(mockedPipelineSettingInterface.DeleteCollectionCalls())
func (mock *PipelineSettingInterfaceMock) DeleteCollectionCalls() []struct {
	DeleteOpts *metav1.DeleteOptions
	ListOpts   metav1.ListOptions
} {
	var calls []struct {
		DeleteOpts *metav1.DeleteOptions
		ListOpts   metav1.ListOptions
	}
	lockPipelineSettingInterfaceMockDeleteCollection.RLock()
	calls = mock.calls.DeleteCollection
	lockPipelineSettingInterfaceMockDeleteCollection.RUnlock()
	return calls
}

// DeleteNamespaced calls DeleteNamespacedFunc.
func (mock *PipelineSettingInterfaceMock) DeleteNamespaced(namespace string, name string, options *metav1.DeleteOptions) error {
	if mock.DeleteNamespacedFunc == nil {
		panic("PipelineSettingInterfaceMock.DeleteNamespacedFunc: method is nil but PipelineSettingInterface.DeleteNamespaced was just called")
	}
	callInfo := struct {
		Namespace string
		Name      string
		Options   *metav1.DeleteOptions
	}{
		Namespace: namespace,
		Name:      name,
		Options:   options,
	}
	lockPipelineSettingInterfaceMockDeleteNamespaced.Lock()
	mock.calls.DeleteNamespaced = append(mock.calls.DeleteNamespaced, callInfo)
	lockPipelineSettingInterfaceMockDeleteNamespaced.Unlock()
	return mock.DeleteNamespacedFunc(namespace, name, options)
}

// DeleteNamespacedCalls gets all the calls that were made to DeleteNamespaced.
// Check the length with:
//     len(mockedPipelineSettingInterface.DeleteNamespacedCalls())
func (mock *PipelineSettingInterfaceMock) DeleteNamespacedCalls() []struct {
	Namespace string
	Name      string
	Options   *metav1.DeleteOptions
} {
	var calls []struct {
		Namespace string
		Name      string
		Options   *metav1.DeleteOptions
	}
	lockPipelineSettingInterfaceMockDeleteNamespaced.RLock()
	calls = mock.calls.DeleteNamespaced
	lockPipelineSettingInterfaceMockDeleteNamespaced.RUnlock()
	return calls
}

// Get calls GetFunc.
func (mock *PipelineSettingInterfaceMock) Get(name string, opts metav1.GetOptions) (*v3.PipelineSetting, error) {
	if mock.GetFunc == nil {
		panic("PipelineSettingInterfaceMock.GetFunc: method is nil but PipelineSettingInterface.Get was just called")
	}
	callInfo := struct {
		Name string
		Opts metav1.GetOptions
	}{
		Name: name,
		Opts: opts,
	}
	lockPipelineSettingInterfaceMockGet.Lock()
	mock.calls.Get = append(mock.calls.Get, callInfo)
	lockPipelineSettingInterfaceMockGet.Unlock()
	return mock.GetFunc(name, opts)
}

// GetCalls gets all the calls that were made to Get.
// Check the length with:
//     len(mockedPipelineSettingInterface.GetCalls())
func (mock *PipelineSettingInterfaceMock) GetCalls() []struct {
	Name string
	Opts metav1.GetOptions
} {
	var calls []struct {
		Name string
		Opts metav1.GetOptions
	}
	lockPipelineSettingInterfaceMockGet.RLock()
	calls = mock.calls.Get
	lockPipelineSettingInterfaceMockGet.RUnlock()
	return calls
}

// GetNamespaced calls GetNamespacedFunc.
func (mock *PipelineSettingInterfaceMock) GetNamespaced(namespace string, name string, opts metav1.GetOptions) (*v3.PipelineSetting, error) {
	if mock.GetNamespacedFunc == nil {
		panic("PipelineSettingInterfaceMock.GetNamespacedFunc: method is nil but PipelineSettingInterface.GetNamespaced was just called")
	}
	callInfo := struct {
		Namespace string
		Name      string
		Opts      metav1.GetOptions
	}{
		Namespace: namespace,
		Name:      name,
		Opts:      opts,
	}
	lockPipelineSettingInterfaceMockGetNamespaced.Lock()
	mock.calls.GetNamespaced = append(mock.calls.GetNamespaced, callInfo)
	lockPipelineSettingInterfaceMockGetNamespaced.Unlock()
	return mock.GetNamespacedFunc(namespace, name, opts)
}

// GetNamespacedCalls gets all the calls that were made to GetNamespaced.
// Check the length with:
//     len(mockedPipelineSettingInterface.GetNamespacedCalls())
func (mock *PipelineSettingInterfaceMock) GetNamespacedCalls() []struct {
	Namespace string
	Name      string
	Opts      metav1.GetOptions
} {
	var calls []struct {
		Namespace string
		Name      string
		Opts      metav1.GetOptions
	}
	lockPipelineSettingInterfaceMockGetNamespaced.RLock()
	calls = mock.calls.GetNamespaced
	lockPipelineSettingInterfaceMockGetNamespaced.RUnlock()
	return calls
}

// List calls ListFunc.
func (mock *PipelineSettingInterfaceMock) List(opts metav1.ListOptions) (*v3.PipelineSettingList, error) {
	if mock.ListFunc == nil {
		panic("PipelineSettingInterfaceMock.ListFunc: method is nil but PipelineSettingInterface.List was just called")
	}
	callInfo := struct {
		Opts metav1.ListOptions
	}{
		Opts: opts,
	}
	lockPipelineSettingInterfaceMockList.Lock()
	mock.calls.List = append(mock.calls.List, callInfo)
	lockPipelineSettingInterfaceMockList.Unlock()
	return mock.ListFunc(opts)
}

// ListCalls gets all the calls that were made to List.
// Check the length with:
//     len(mockedPipelineSettingInterface.ListCalls())
func (mock *PipelineSettingInterfaceMock) ListCalls() []struct {
	Opts metav1.ListOptions
} {
	var calls []struct {
		Opts metav1.ListOptions
	}
	lockPipelineSettingInterfaceMockList.RLock()
	calls = mock.calls.List
	lockPipelineSettingInterfaceMockList.RUnlock()
	return calls
}

// ListNamespaced calls ListNamespacedFunc.
func (mock *PipelineSettingInterfaceMock) ListNamespaced(namespace string, opts metav1.ListOptions) (*v3.PipelineSettingList, error) {
	if mock.ListNamespacedFunc == nil {
		panic("PipelineSettingInterfaceMock.ListNamespacedFunc: method is nil but PipelineSettingInterface.ListNamespaced was just called")
	}
	callInfo := struct {
		Namespace string
		Opts      metav1.ListOptions
	}{
		Namespace: namespace,
		Opts:      opts,
	}
	lockPipelineSettingInterfaceMockListNamespaced.Lock()
	mock.calls.ListNamespaced = append(mock.calls.ListNamespaced, callInfo)
	lockPipelineSettingInterfaceMockListNamespaced.Unlock()
	return mock.ListNamespacedFunc(namespace, opts)
}

// ListNamespacedCalls gets all the calls that were made to ListNamespaced.
// Check the length with:
//     len(mockedPipelineSettingInterface.ListNamespacedCalls())
func (mock *PipelineSettingInterfaceMock) ListNamespacedCalls() []struct {
	Namespace string
	Opts      metav1.ListOptions
} {
	var calls []struct {
		Namespace string
		Opts      metav1.ListOptions
	}
	lockPipelineSettingInterfaceMockListNamespaced.RLock()
	calls = mock.calls.ListNamespaced
	lockPipelineSettingInterfaceMockListNamespaced.RUnlock()
	return calls
}

// ObjectClient calls ObjectClientFunc.
func (mock *PipelineSettingInterfaceMock) ObjectClient() *objectclient.ObjectClient {
	if mock.ObjectClientFunc == nil {
		panic("PipelineSettingInterfaceMock.ObjectClientFunc: method is nil but PipelineSettingInterface.ObjectClient was just called")
	}
	callInfo := struct {
	}{}
	lockPipelineSettingInterfaceMockObjectClient.Lock()
	mock.calls.ObjectClient = append(mock.calls.ObjectClient, callInfo)
	lockPipelineSettingInterfaceMockObjectClient.Unlock()
	return mock.ObjectClientFunc()
}

// ObjectClientCalls gets all the calls that were made to ObjectClient.
// Check the length with:
//     len(mockedPipelineSettingInterface.ObjectClientCalls())
func (mock *PipelineSettingInterfaceMock) ObjectClientCalls() []struct {
} {
	var calls []struct {
	}
	lockPipelineSettingInterfaceMockObjectClient.RLock()
	calls = mock.calls.ObjectClient
	lockPipelineSettingInterfaceMockObjectClient.RUnlock()
	return calls
}

// Update calls UpdateFunc.
func (mock *PipelineSettingInterfaceMock) Update(in1 *v3.PipelineSetting) (*v3.PipelineSetting, error) {
	if mock.UpdateFunc == nil {
		panic("PipelineSettingInterfaceMock.UpdateFunc: method is nil but PipelineSettingInterface.Update was just called")
	}
	callInfo := struct {
		In1 *v3.PipelineSetting
	}{
		In1: in1,
	}
	lockPipelineSettingInterfaceMockUpdate.Lock()
	mock.calls.Update = append(mock.calls.Update, callInfo)
	lockPipelineSettingInterfaceMockUpdate.Unlock()
	return mock.UpdateFunc(in1)
}

// UpdateCalls gets all the calls that were made to Update.
// Check the length with:
//     len(mockedPipelineSettingInterface.UpdateCalls())
func (mock *PipelineSettingInterfaceMock) UpdateCalls() []struct {
	In1 *v3.PipelineSetting
} {
	var calls []struct {
		In1 *v3.PipelineSetting
	}
	lockPipelineSettingInterfaceMockUpdate.RLock()
	calls = mock.calls.Update
	lockPipelineSettingInterfaceMockUpdate.RUnlock()
	return calls
}

// Watch calls WatchFunc.
func (mock *PipelineSettingInterfaceMock) Watch(opts metav1.ListOptions) (watch.Interface, error) {
	if mock.WatchFunc == nil {
		panic("PipelineSettingInterfaceMock.WatchFunc: method is nil but PipelineSettingInterface.Watch was just called")
	}
	callInfo := struct {
		Opts metav1.ListOptions
	}{
		Opts: opts,
	}
	lockPipelineSettingInterfaceMockWatch.Lock()
	mock.calls.Watch = append(mock.calls.Watch, callInfo)
	lockPipelineSettingInterfaceMockWatch.Unlock()
	return mock.WatchFunc(opts)
}

// WatchCalls gets all the calls that were made to Watch.
// Check the length with:
//     len(mockedPipelineSettingInterface.WatchCalls())
func (mock *PipelineSettingInterfaceMock) WatchCalls() []struct {
	Opts metav1.ListOptions
} {
	var calls []struct {
		Opts metav1.ListOptions
	}
	lockPipelineSettingInterfaceMockWatch.RLock()
	calls = mock.calls.Watch
	lockPipelineSettingInterfaceMockWatch.RUnlock()
	return calls
}

var (
	lockPipelineSettingsGetterMockPipelineSettings sync.RWMutex
)

// Ensure, that PipelineSettingsGetterMock does implement v31.PipelineSettingsGetter.
// If this is not the case, regenerate this file with moq.
var _ v31.PipelineSettingsGetter = &PipelineSettingsGetterMock{}

// PipelineSettingsGetterMock is a mock implementation of v31.PipelineSettingsGetter.
//
//     func TestSomethingThatUsesPipelineSettingsGetter(t *testing.T) {
//
//         // make and configure a mocked v31.PipelineSettingsGetter
//         mockedPipelineSettingsGetter := &PipelineSettingsGetterMock{
//             PipelineSettingsFunc: func(namespace string) v31.PipelineSettingInterface {
// 	               panic("mock out the PipelineSettings method")
//             },
//         }
//
//         // use mockedPipelineSettingsGetter in code that requires v31.PipelineSettingsGetter
//         // and then make assertions.
//
//     }
type PipelineSettingsGetterMock struct {
	// PipelineSettingsFunc mocks the PipelineSettings method.
	PipelineSettingsFunc func(namespace string) v31.PipelineSettingInterface

	// calls tracks calls to the methods.
	calls struct {
		// PipelineSettings holds details about calls to the PipelineSettings method.
		PipelineSettings []struct {
			// Namespace is the namespace argument value.
			Namespace string
		}
	}
}

// PipelineSettings calls PipelineSettingsFunc.
func (mock *PipelineSettingsGetterMock) PipelineSettings(namespace string) v31.PipelineSettingInterface {
	if mock.PipelineSettingsFunc == nil {
		panic("PipelineSettingsGetterMock.PipelineSettingsFunc: method is nil but PipelineSettingsGetter.PipelineSettings was just called")
	}
	callInfo := struct {
		Namespace string
	}{
		Namespace: namespace,
	}
	lockPipelineSettingsGetterMockPipelineSettings.Lock()
	mock.calls.PipelineSettings = append(mock.calls.PipelineSettings, callInfo)
	lockPipelineSettingsGetterMockPipelineSettings.Unlock()
	return mock.PipelineSettingsFunc(namespace)
}

// PipelineSettingsCalls gets all the calls that were made to PipelineSettings.
// Check the length with:
//     len(mockedPipelineSettingsGetter.PipelineSettingsCalls())
func (mock *PipelineSettingsGetterMock) PipelineSettingsCalls() []struct {
	Namespace string
} {
	var calls []struct {
		Namespace string
	}
	lockPipelineSettingsGetterMockPipelineSettings.RLock()
	calls = mock.calls.PipelineSettings
	lockPipelineSettingsGetterMockPipelineSettings.RUnlock()
	return calls
}
