// Code generated by moq; DO NOT EDIT.
// github.com/matryer/moq

package fakes

import (
	"context"
	"sync"
	"time"

	"github.com/rancher/norman/controller"
	"github.com/rancher/norman/objectclient"
	v3 "github.com/rancher/rancher/pkg/apis/project.cattle.io/v3"
	v31 "github.com/rancher/rancher/pkg/generated/norman/project.cattle.io/v3"
	metav1 "k8s.io/apimachinery/pkg/apis/meta/v1"
	"k8s.io/apimachinery/pkg/labels"
	"k8s.io/apimachinery/pkg/watch"
	"k8s.io/client-go/tools/cache"
)

var (
	lockSourceCodeProviderListerMockGet  sync.RWMutex
	lockSourceCodeProviderListerMockList sync.RWMutex
)

// Ensure, that SourceCodeProviderListerMock does implement v31.SourceCodeProviderLister.
// If this is not the case, regenerate this file with moq.
var _ v31.SourceCodeProviderLister = &SourceCodeProviderListerMock{}

// SourceCodeProviderListerMock is a mock implementation of v31.SourceCodeProviderLister.
//
//     func TestSomethingThatUsesSourceCodeProviderLister(t *testing.T) {
//
//         // make and configure a mocked v31.SourceCodeProviderLister
//         mockedSourceCodeProviderLister := &SourceCodeProviderListerMock{
//             GetFunc: func(namespace string, name string) (*v3.SourceCodeProvider, error) {
// 	               panic("mock out the Get method")
//             },
//             ListFunc: func(namespace string, selector labels.Selector) ([]*v3.SourceCodeProvider, error) {
// 	               panic("mock out the List method")
//             },
//         }
//
//         // use mockedSourceCodeProviderLister in code that requires v31.SourceCodeProviderLister
//         // and then make assertions.
//
//     }
type SourceCodeProviderListerMock struct {
	// GetFunc mocks the Get method.
	GetFunc func(namespace string, name string) (*v3.SourceCodeProvider, error)

	// ListFunc mocks the List method.
	ListFunc func(namespace string, selector labels.Selector) ([]*v3.SourceCodeProvider, error)

	// calls tracks calls to the methods.
	calls struct {
		// Get holds details about calls to the Get method.
		Get []struct {
			// Namespace is the namespace argument value.
			Namespace string
			// Name is the name argument value.
			Name string
		}
		// List holds details about calls to the List method.
		List []struct {
			// Namespace is the namespace argument value.
			Namespace string
			// Selector is the selector argument value.
			Selector labels.Selector
		}
	}
}

// Get calls GetFunc.
func (mock *SourceCodeProviderListerMock) Get(namespace string, name string) (*v3.SourceCodeProvider, error) {
	if mock.GetFunc == nil {
		panic("SourceCodeProviderListerMock.GetFunc: method is nil but SourceCodeProviderLister.Get was just called")
	}
	callInfo := struct {
		Namespace string
		Name      string
	}{
		Namespace: namespace,
		Name:      name,
	}
	lockSourceCodeProviderListerMockGet.Lock()
	mock.calls.Get = append(mock.calls.Get, callInfo)
	lockSourceCodeProviderListerMockGet.Unlock()
	return mock.GetFunc(namespace, name)
}

// GetCalls gets all the calls that were made to Get.
// Check the length with:
//     len(mockedSourceCodeProviderLister.GetCalls())
func (mock *SourceCodeProviderListerMock) GetCalls() []struct {
	Namespace string
	Name      string
} {
	var calls []struct {
		Namespace string
		Name      string
	}
	lockSourceCodeProviderListerMockGet.RLock()
	calls = mock.calls.Get
	lockSourceCodeProviderListerMockGet.RUnlock()
	return calls
}

// List calls ListFunc.
func (mock *SourceCodeProviderListerMock) List(namespace string, selector labels.Selector) ([]*v3.SourceCodeProvider, error) {
	if mock.ListFunc == nil {
		panic("SourceCodeProviderListerMock.ListFunc: method is nil but SourceCodeProviderLister.List was just called")
	}
	callInfo := struct {
		Namespace string
		Selector  labels.Selector
	}{
		Namespace: namespace,
		Selector:  selector,
	}
	lockSourceCodeProviderListerMockList.Lock()
	mock.calls.List = append(mock.calls.List, callInfo)
	lockSourceCodeProviderListerMockList.Unlock()
	return mock.ListFunc(namespace, selector)
}

// ListCalls gets all the calls that were made to List.
// Check the length with:
//     len(mockedSourceCodeProviderLister.ListCalls())
func (mock *SourceCodeProviderListerMock) ListCalls() []struct {
	Namespace string
	Selector  labels.Selector
} {
	var calls []struct {
		Namespace string
		Selector  labels.Selector
	}
	lockSourceCodeProviderListerMockList.RLock()
	calls = mock.calls.List
	lockSourceCodeProviderListerMockList.RUnlock()
	return calls
}

var (
	lockSourceCodeProviderControllerMockAddClusterScopedFeatureHandler sync.RWMutex
	lockSourceCodeProviderControllerMockAddClusterScopedHandler        sync.RWMutex
	lockSourceCodeProviderControllerMockAddFeatureHandler              sync.RWMutex
	lockSourceCodeProviderControllerMockAddHandler                     sync.RWMutex
	lockSourceCodeProviderControllerMockEnqueue                        sync.RWMutex
	lockSourceCodeProviderControllerMockEnqueueAfter                   sync.RWMutex
	lockSourceCodeProviderControllerMockGeneric                        sync.RWMutex
	lockSourceCodeProviderControllerMockInformer                       sync.RWMutex
	lockSourceCodeProviderControllerMockLister                         sync.RWMutex
)

// Ensure, that SourceCodeProviderControllerMock does implement v31.SourceCodeProviderController.
// If this is not the case, regenerate this file with moq.
var _ v31.SourceCodeProviderController = &SourceCodeProviderControllerMock{}

// SourceCodeProviderControllerMock is a mock implementation of v31.SourceCodeProviderController.
//
//     func TestSomethingThatUsesSourceCodeProviderController(t *testing.T) {
//
//         // make and configure a mocked v31.SourceCodeProviderController
//         mockedSourceCodeProviderController := &SourceCodeProviderControllerMock{
//             AddClusterScopedFeatureHandlerFunc: func(ctx context.Context, enabled func() bool, name string, clusterName string, handler v31.SourceCodeProviderHandlerFunc)  {
// 	               panic("mock out the AddClusterScopedFeatureHandler method")
//             },
//             AddClusterScopedHandlerFunc: func(ctx context.Context, name string, clusterName string, handler v31.SourceCodeProviderHandlerFunc)  {
// 	               panic("mock out the AddClusterScopedHandler method")
//             },
//             AddFeatureHandlerFunc: func(ctx context.Context, enabled func() bool, name string, syncMoqParam v31.SourceCodeProviderHandlerFunc)  {
// 	               panic("mock out the AddFeatureHandler method")
//             },
//             AddHandlerFunc: func(ctx context.Context, name string, handler v31.SourceCodeProviderHandlerFunc)  {
// 	               panic("mock out the AddHandler method")
//             },
//             EnqueueFunc: func(namespace string, name string)  {
// 	               panic("mock out the Enqueue method")
//             },
//             EnqueueAfterFunc: func(namespace string, name string, after time.Duration)  {
// 	               panic("mock out the EnqueueAfter method")
//             },
//             GenericFunc: func() controller.GenericController {
// 	               panic("mock out the Generic method")
//             },
//             InformerFunc: func() cache.SharedIndexInformer {
// 	               panic("mock out the Informer method")
//             },
//             ListerFunc: func() v31.SourceCodeProviderLister {
// 	               panic("mock out the Lister method")
//             },
//         }
//
//         // use mockedSourceCodeProviderController in code that requires v31.SourceCodeProviderController
//         // and then make assertions.
//
//     }
type SourceCodeProviderControllerMock struct {
	// AddClusterScopedFeatureHandlerFunc mocks the AddClusterScopedFeatureHandler method.
	AddClusterScopedFeatureHandlerFunc func(ctx context.Context, enabled func() bool, name string, clusterName string, handler v31.SourceCodeProviderHandlerFunc)

	// AddClusterScopedHandlerFunc mocks the AddClusterScopedHandler method.
	AddClusterScopedHandlerFunc func(ctx context.Context, name string, clusterName string, handler v31.SourceCodeProviderHandlerFunc)

	// AddFeatureHandlerFunc mocks the AddFeatureHandler method.
	AddFeatureHandlerFunc func(ctx context.Context, enabled func() bool, name string, syncMoqParam v31.SourceCodeProviderHandlerFunc)

	// AddHandlerFunc mocks the AddHandler method.
	AddHandlerFunc func(ctx context.Context, name string, handler v31.SourceCodeProviderHandlerFunc)

	// EnqueueFunc mocks the Enqueue method.
	EnqueueFunc func(namespace string, name string)

	// EnqueueAfterFunc mocks the EnqueueAfter method.
	EnqueueAfterFunc func(namespace string, name string, after time.Duration)

	// GenericFunc mocks the Generic method.
	GenericFunc func() controller.GenericController

	// InformerFunc mocks the Informer method.
	InformerFunc func() cache.SharedIndexInformer

	// ListerFunc mocks the Lister method.
	ListerFunc func() v31.SourceCodeProviderLister

	// calls tracks calls to the methods.
	calls struct {
		// AddClusterScopedFeatureHandler holds details about calls to the AddClusterScopedFeatureHandler method.
		AddClusterScopedFeatureHandler []struct {
			// Ctx is the ctx argument value.
			Ctx context.Context
			// Enabled is the enabled argument value.
			Enabled func() bool
			// Name is the name argument value.
			Name string
			// ClusterName is the clusterName argument value.
			ClusterName string
			// Handler is the handler argument value.
			Handler v31.SourceCodeProviderHandlerFunc
		}
		// AddClusterScopedHandler holds details about calls to the AddClusterScopedHandler method.
		AddClusterScopedHandler []struct {
			// Ctx is the ctx argument value.
			Ctx context.Context
			// Name is the name argument value.
			Name string
			// ClusterName is the clusterName argument value.
			ClusterName string
			// Handler is the handler argument value.
			Handler v31.SourceCodeProviderHandlerFunc
		}
		// AddFeatureHandler holds details about calls to the AddFeatureHandler method.
		AddFeatureHandler []struct {
			// Ctx is the ctx argument value.
			Ctx context.Context
			// Enabled is the enabled argument value.
			Enabled func() bool
			// Name is the name argument value.
			Name string
			// Sync is the sync argument value.
			Sync v31.SourceCodeProviderHandlerFunc
		}
		// AddHandler holds details about calls to the AddHandler method.
		AddHandler []struct {
			// Ctx is the ctx argument value.
			Ctx context.Context
			// Name is the name argument value.
			Name string
			// Handler is the handler argument value.
			Handler v31.SourceCodeProviderHandlerFunc
		}
		// Enqueue holds details about calls to the Enqueue method.
		Enqueue []struct {
			// Namespace is the namespace argument value.
			Namespace string
			// Name is the name argument value.
			Name string
		}
		// EnqueueAfter holds details about calls to the EnqueueAfter method.
		EnqueueAfter []struct {
			// Namespace is the namespace argument value.
			Namespace string
			// Name is the name argument value.
			Name string
			// After is the after argument value.
			After time.Duration
		}
		// Generic holds details about calls to the Generic method.
		Generic []struct {
		}
		// Informer holds details about calls to the Informer method.
		Informer []struct {
		}
		// Lister holds details about calls to the Lister method.
		Lister []struct {
		}
	}
}

// AddClusterScopedFeatureHandler calls AddClusterScopedFeatureHandlerFunc.
func (mock *SourceCodeProviderControllerMock) AddClusterScopedFeatureHandler(ctx context.Context, enabled func() bool, name string, clusterName string, handler v31.SourceCodeProviderHandlerFunc) {
	if mock.AddClusterScopedFeatureHandlerFunc == nil {
		panic("SourceCodeProviderControllerMock.AddClusterScopedFeatureHandlerFunc: method is nil but SourceCodeProviderController.AddClusterScopedFeatureHandler was just called")
	}
	callInfo := struct {
		Ctx         context.Context
		Enabled     func() bool
		Name        string
		ClusterName string
		Handler     v31.SourceCodeProviderHandlerFunc
	}{
		Ctx:         ctx,
		Enabled:     enabled,
		Name:        name,
		ClusterName: clusterName,
		Handler:     handler,
	}
	lockSourceCodeProviderControllerMockAddClusterScopedFeatureHandler.Lock()
	mock.calls.AddClusterScopedFeatureHandler = append(mock.calls.AddClusterScopedFeatureHandler, callInfo)
	lockSourceCodeProviderControllerMockAddClusterScopedFeatureHandler.Unlock()
	mock.AddClusterScopedFeatureHandlerFunc(ctx, enabled, name, clusterName, handler)
}

// AddClusterScopedFeatureHandlerCalls gets all the calls that were made to AddClusterScopedFeatureHandler.
// Check the length with:
//     len(mockedSourceCodeProviderController.AddClusterScopedFeatureHandlerCalls())
func (mock *SourceCodeProviderControllerMock) AddClusterScopedFeatureHandlerCalls() []struct {
	Ctx         context.Context
	Enabled     func() bool
	Name        string
	ClusterName string
	Handler     v31.SourceCodeProviderHandlerFunc
} {
	var calls []struct {
		Ctx         context.Context
		Enabled     func() bool
		Name        string
		ClusterName string
		Handler     v31.SourceCodeProviderHandlerFunc
	}
	lockSourceCodeProviderControllerMockAddClusterScopedFeatureHandler.RLock()
	calls = mock.calls.AddClusterScopedFeatureHandler
	lockSourceCodeProviderControllerMockAddClusterScopedFeatureHandler.RUnlock()
	return calls
}

// AddClusterScopedHandler calls AddClusterScopedHandlerFunc.
func (mock *SourceCodeProviderControllerMock) AddClusterScopedHandler(ctx context.Context, name string, clusterName string, handler v31.SourceCodeProviderHandlerFunc) {
	if mock.AddClusterScopedHandlerFunc == nil {
		panic("SourceCodeProviderControllerMock.AddClusterScopedHandlerFunc: method is nil but SourceCodeProviderController.AddClusterScopedHandler was just called")
	}
	callInfo := struct {
		Ctx         context.Context
		Name        string
		ClusterName string
		Handler     v31.SourceCodeProviderHandlerFunc
	}{
		Ctx:         ctx,
		Name:        name,
		ClusterName: clusterName,
		Handler:     handler,
	}
	lockSourceCodeProviderControllerMockAddClusterScopedHandler.Lock()
	mock.calls.AddClusterScopedHandler = append(mock.calls.AddClusterScopedHandler, callInfo)
	lockSourceCodeProviderControllerMockAddClusterScopedHandler.Unlock()
	mock.AddClusterScopedHandlerFunc(ctx, name, clusterName, handler)
}

// AddClusterScopedHandlerCalls gets all the calls that were made to AddClusterScopedHandler.
// Check the length with:
//     len(mockedSourceCodeProviderController.AddClusterScopedHandlerCalls())
func (mock *SourceCodeProviderControllerMock) AddClusterScopedHandlerCalls() []struct {
	Ctx         context.Context
	Name        string
	ClusterName string
	Handler     v31.SourceCodeProviderHandlerFunc
} {
	var calls []struct {
		Ctx         context.Context
		Name        string
		ClusterName string
		Handler     v31.SourceCodeProviderHandlerFunc
	}
	lockSourceCodeProviderControllerMockAddClusterScopedHandler.RLock()
	calls = mock.calls.AddClusterScopedHandler
	lockSourceCodeProviderControllerMockAddClusterScopedHandler.RUnlock()
	return calls
}

// AddFeatureHandler calls AddFeatureHandlerFunc.
func (mock *SourceCodeProviderControllerMock) AddFeatureHandler(ctx context.Context, enabled func() bool, name string, syncMoqParam v31.SourceCodeProviderHandlerFunc) {
	if mock.AddFeatureHandlerFunc == nil {
		panic("SourceCodeProviderControllerMock.AddFeatureHandlerFunc: method is nil but SourceCodeProviderController.AddFeatureHandler was just called")
	}
	callInfo := struct {
		Ctx     context.Context
		Enabled func() bool
		Name    string
		Sync    v31.SourceCodeProviderHandlerFunc
	}{
		Ctx:     ctx,
		Enabled: enabled,
		Name:    name,
		Sync:    syncMoqParam,
	}
	lockSourceCodeProviderControllerMockAddFeatureHandler.Lock()
	mock.calls.AddFeatureHandler = append(mock.calls.AddFeatureHandler, callInfo)
	lockSourceCodeProviderControllerMockAddFeatureHandler.Unlock()
	mock.AddFeatureHandlerFunc(ctx, enabled, name, syncMoqParam)
}

// AddFeatureHandlerCalls gets all the calls that were made to AddFeatureHandler.
// Check the length with:
//     len(mockedSourceCodeProviderController.AddFeatureHandlerCalls())
func (mock *SourceCodeProviderControllerMock) AddFeatureHandlerCalls() []struct {
	Ctx     context.Context
	Enabled func() bool
	Name    string
	Sync    v31.SourceCodeProviderHandlerFunc
} {
	var calls []struct {
		Ctx     context.Context
		Enabled func() bool
		Name    string
		Sync    v31.SourceCodeProviderHandlerFunc
	}
	lockSourceCodeProviderControllerMockAddFeatureHandler.RLock()
	calls = mock.calls.AddFeatureHandler
	lockSourceCodeProviderControllerMockAddFeatureHandler.RUnlock()
	return calls
}

// AddHandler calls AddHandlerFunc.
func (mock *SourceCodeProviderControllerMock) AddHandler(ctx context.Context, name string, handler v31.SourceCodeProviderHandlerFunc) {
	if mock.AddHandlerFunc == nil {
		panic("SourceCodeProviderControllerMock.AddHandlerFunc: method is nil but SourceCodeProviderController.AddHandler was just called")
	}
	callInfo := struct {
		Ctx     context.Context
		Name    string
		Handler v31.SourceCodeProviderHandlerFunc
	}{
		Ctx:     ctx,
		Name:    name,
		Handler: handler,
	}
	lockSourceCodeProviderControllerMockAddHandler.Lock()
	mock.calls.AddHandler = append(mock.calls.AddHandler, callInfo)
	lockSourceCodeProviderControllerMockAddHandler.Unlock()
	mock.AddHandlerFunc(ctx, name, handler)
}

// AddHandlerCalls gets all the calls that were made to AddHandler.
// Check the length with:
//     len(mockedSourceCodeProviderController.AddHandlerCalls())
func (mock *SourceCodeProviderControllerMock) AddHandlerCalls() []struct {
	Ctx     context.Context
	Name    string
	Handler v31.SourceCodeProviderHandlerFunc
} {
	var calls []struct {
		Ctx     context.Context
		Name    string
		Handler v31.SourceCodeProviderHandlerFunc
	}
	lockSourceCodeProviderControllerMockAddHandler.RLock()
	calls = mock.calls.AddHandler
	lockSourceCodeProviderControllerMockAddHandler.RUnlock()
	return calls
}

// Enqueue calls EnqueueFunc.
func (mock *SourceCodeProviderControllerMock) Enqueue(namespace string, name string) {
	if mock.EnqueueFunc == nil {
		panic("SourceCodeProviderControllerMock.EnqueueFunc: method is nil but SourceCodeProviderController.Enqueue was just called")
	}
	callInfo := struct {
		Namespace string
		Name      string
	}{
		Namespace: namespace,
		Name:      name,
	}
	lockSourceCodeProviderControllerMockEnqueue.Lock()
	mock.calls.Enqueue = append(mock.calls.Enqueue, callInfo)
	lockSourceCodeProviderControllerMockEnqueue.Unlock()
	mock.EnqueueFunc(namespace, name)
}

// EnqueueCalls gets all the calls that were made to Enqueue.
// Check the length with:
//     len(mockedSourceCodeProviderController.EnqueueCalls())
func (mock *SourceCodeProviderControllerMock) EnqueueCalls() []struct {
	Namespace string
	Name      string
} {
	var calls []struct {
		Namespace string
		Name      string
	}
	lockSourceCodeProviderControllerMockEnqueue.RLock()
	calls = mock.calls.Enqueue
	lockSourceCodeProviderControllerMockEnqueue.RUnlock()
	return calls
}

// EnqueueAfter calls EnqueueAfterFunc.
func (mock *SourceCodeProviderControllerMock) EnqueueAfter(namespace string, name string, after time.Duration) {
	if mock.EnqueueAfterFunc == nil {
		panic("SourceCodeProviderControllerMock.EnqueueAfterFunc: method is nil but SourceCodeProviderController.EnqueueAfter was just called")
	}
	callInfo := struct {
		Namespace string
		Name      string
		After     time.Duration
	}{
		Namespace: namespace,
		Name:      name,
		After:     after,
	}
	lockSourceCodeProviderControllerMockEnqueueAfter.Lock()
	mock.calls.EnqueueAfter = append(mock.calls.EnqueueAfter, callInfo)
	lockSourceCodeProviderControllerMockEnqueueAfter.Unlock()
	mock.EnqueueAfterFunc(namespace, name, after)
}

// EnqueueAfterCalls gets all the calls that were made to EnqueueAfter.
// Check the length with:
//     len(mockedSourceCodeProviderController.EnqueueAfterCalls())
func (mock *SourceCodeProviderControllerMock) EnqueueAfterCalls() []struct {
	Namespace string
	Name      string
	After     time.Duration
} {
	var calls []struct {
		Namespace string
		Name      string
		After     time.Duration
	}
	lockSourceCodeProviderControllerMockEnqueueAfter.RLock()
	calls = mock.calls.EnqueueAfter
	lockSourceCodeProviderControllerMockEnqueueAfter.RUnlock()
	return calls
}

// Generic calls GenericFunc.
func (mock *SourceCodeProviderControllerMock) Generic() controller.GenericController {
	if mock.GenericFunc == nil {
		panic("SourceCodeProviderControllerMock.GenericFunc: method is nil but SourceCodeProviderController.Generic was just called")
	}
	callInfo := struct {
	}{}
	lockSourceCodeProviderControllerMockGeneric.Lock()
	mock.calls.Generic = append(mock.calls.Generic, callInfo)
	lockSourceCodeProviderControllerMockGeneric.Unlock()
	return mock.GenericFunc()
}

// GenericCalls gets all the calls that were made to Generic.
// Check the length with:
//     len(mockedSourceCodeProviderController.GenericCalls())
func (mock *SourceCodeProviderControllerMock) GenericCalls() []struct {
} {
	var calls []struct {
	}
	lockSourceCodeProviderControllerMockGeneric.RLock()
	calls = mock.calls.Generic
	lockSourceCodeProviderControllerMockGeneric.RUnlock()
	return calls
}

// Informer calls InformerFunc.
func (mock *SourceCodeProviderControllerMock) Informer() cache.SharedIndexInformer {
	if mock.InformerFunc == nil {
		panic("SourceCodeProviderControllerMock.InformerFunc: method is nil but SourceCodeProviderController.Informer was just called")
	}
	callInfo := struct {
	}{}
	lockSourceCodeProviderControllerMockInformer.Lock()
	mock.calls.Informer = append(mock.calls.Informer, callInfo)
	lockSourceCodeProviderControllerMockInformer.Unlock()
	return mock.InformerFunc()
}

// InformerCalls gets all the calls that were made to Informer.
// Check the length with:
//     len(mockedSourceCodeProviderController.InformerCalls())
func (mock *SourceCodeProviderControllerMock) InformerCalls() []struct {
} {
	var calls []struct {
	}
	lockSourceCodeProviderControllerMockInformer.RLock()
	calls = mock.calls.Informer
	lockSourceCodeProviderControllerMockInformer.RUnlock()
	return calls
}

// Lister calls ListerFunc.
func (mock *SourceCodeProviderControllerMock) Lister() v31.SourceCodeProviderLister {
	if mock.ListerFunc == nil {
		panic("SourceCodeProviderControllerMock.ListerFunc: method is nil but SourceCodeProviderController.Lister was just called")
	}
	callInfo := struct {
	}{}
	lockSourceCodeProviderControllerMockLister.Lock()
	mock.calls.Lister = append(mock.calls.Lister, callInfo)
	lockSourceCodeProviderControllerMockLister.Unlock()
	return mock.ListerFunc()
}

// ListerCalls gets all the calls that were made to Lister.
// Check the length with:
//     len(mockedSourceCodeProviderController.ListerCalls())
func (mock *SourceCodeProviderControllerMock) ListerCalls() []struct {
} {
	var calls []struct {
	}
	lockSourceCodeProviderControllerMockLister.RLock()
	calls = mock.calls.Lister
	lockSourceCodeProviderControllerMockLister.RUnlock()
	return calls
}

var (
	lockSourceCodeProviderInterfaceMockAddClusterScopedFeatureHandler   sync.RWMutex
	lockSourceCodeProviderInterfaceMockAddClusterScopedFeatureLifecycle sync.RWMutex
	lockSourceCodeProviderInterfaceMockAddClusterScopedHandler          sync.RWMutex
	lockSourceCodeProviderInterfaceMockAddClusterScopedLifecycle        sync.RWMutex
	lockSourceCodeProviderInterfaceMockAddFeatureHandler                sync.RWMutex
	lockSourceCodeProviderInterfaceMockAddFeatureLifecycle              sync.RWMutex
	lockSourceCodeProviderInterfaceMockAddHandler                       sync.RWMutex
	lockSourceCodeProviderInterfaceMockAddLifecycle                     sync.RWMutex
	lockSourceCodeProviderInterfaceMockController                       sync.RWMutex
	lockSourceCodeProviderInterfaceMockCreate                           sync.RWMutex
	lockSourceCodeProviderInterfaceMockDelete                           sync.RWMutex
	lockSourceCodeProviderInterfaceMockDeleteCollection                 sync.RWMutex
	lockSourceCodeProviderInterfaceMockDeleteNamespaced                 sync.RWMutex
	lockSourceCodeProviderInterfaceMockGet                              sync.RWMutex
	lockSourceCodeProviderInterfaceMockGetNamespaced                    sync.RWMutex
	lockSourceCodeProviderInterfaceMockList                             sync.RWMutex
	lockSourceCodeProviderInterfaceMockListNamespaced                   sync.RWMutex
	lockSourceCodeProviderInterfaceMockObjectClient                     sync.RWMutex
	lockSourceCodeProviderInterfaceMockUpdate                           sync.RWMutex
	lockSourceCodeProviderInterfaceMockWatch                            sync.RWMutex
)

// Ensure, that SourceCodeProviderInterfaceMock does implement v31.SourceCodeProviderInterface.
// If this is not the case, regenerate this file with moq.
var _ v31.SourceCodeProviderInterface = &SourceCodeProviderInterfaceMock{}

// SourceCodeProviderInterfaceMock is a mock implementation of v31.SourceCodeProviderInterface.
//
//     func TestSomethingThatUsesSourceCodeProviderInterface(t *testing.T) {
//
//         // make and configure a mocked v31.SourceCodeProviderInterface
//         mockedSourceCodeProviderInterface := &SourceCodeProviderInterfaceMock{
//             AddClusterScopedFeatureHandlerFunc: func(ctx context.Context, enabled func() bool, name string, clusterName string, syncMoqParam v31.SourceCodeProviderHandlerFunc)  {
// 	               panic("mock out the AddClusterScopedFeatureHandler method")
//             },
//             AddClusterScopedFeatureLifecycleFunc: func(ctx context.Context, enabled func() bool, name string, clusterName string, lifecycle v31.SourceCodeProviderLifecycle)  {
// 	               panic("mock out the AddClusterScopedFeatureLifecycle method")
//             },
//             AddClusterScopedHandlerFunc: func(ctx context.Context, name string, clusterName string, syncMoqParam v31.SourceCodeProviderHandlerFunc)  {
// 	               panic("mock out the AddClusterScopedHandler method")
//             },
//             AddClusterScopedLifecycleFunc: func(ctx context.Context, name string, clusterName string, lifecycle v31.SourceCodeProviderLifecycle)  {
// 	               panic("mock out the AddClusterScopedLifecycle method")
//             },
//             AddFeatureHandlerFunc: func(ctx context.Context, enabled func() bool, name string, syncMoqParam v31.SourceCodeProviderHandlerFunc)  {
// 	               panic("mock out the AddFeatureHandler method")
//             },
//             AddFeatureLifecycleFunc: func(ctx context.Context, enabled func() bool, name string, lifecycle v31.SourceCodeProviderLifecycle)  {
// 	               panic("mock out the AddFeatureLifecycle method")
//             },
//             AddHandlerFunc: func(ctx context.Context, name string, syncMoqParam v31.SourceCodeProviderHandlerFunc)  {
// 	               panic("mock out the AddHandler method")
//             },
//             AddLifecycleFunc: func(ctx context.Context, name string, lifecycle v31.SourceCodeProviderLifecycle)  {
// 	               panic("mock out the AddLifecycle method")
//             },
//             ControllerFunc: func() v31.SourceCodeProviderController {
// 	               panic("mock out the Controller method")
//             },
//             CreateFunc: func(in1 *v3.SourceCodeProvider) (*v3.SourceCodeProvider, error) {
// 	               panic("mock out the Create method")
//             },
//             DeleteFunc: func(name string, options *metav1.DeleteOptions) error {
// 	               panic("mock out the Delete method")
//             },
//             DeleteCollectionFunc: func(deleteOpts *metav1.DeleteOptions, listOpts metav1.ListOptions) error {
// 	               panic("mock out the DeleteCollection method")
//             },
//             DeleteNamespacedFunc: func(namespace string, name string, options *metav1.DeleteOptions) error {
// 	               panic("mock out the DeleteNamespaced method")
//             },
//             GetFunc: func(name string, opts metav1.GetOptions) (*v3.SourceCodeProvider, error) {
// 	               panic("mock out the Get method")
//             },
//             GetNamespacedFunc: func(namespace string, name string, opts metav1.GetOptions) (*v3.SourceCodeProvider, error) {
// 	               panic("mock out the GetNamespaced method")
//             },
//             ListFunc: func(opts metav1.ListOptions) (*v3.SourceCodeProviderList, error) {
// 	               panic("mock out the List method")
//             },
//             ListNamespacedFunc: func(namespace string, opts metav1.ListOptions) (*v3.SourceCodeProviderList, error) {
// 	               panic("mock out the ListNamespaced method")
//             },
//             ObjectClientFunc: func() *objectclient.ObjectClient {
// 	               panic("mock out the ObjectClient method")
//             },
//             UpdateFunc: func(in1 *v3.SourceCodeProvider) (*v3.SourceCodeProvider, error) {
// 	               panic("mock out the Update method")
//             },
//             WatchFunc: func(opts metav1.ListOptions) (watch.Interface, error) {
// 	               panic("mock out the Watch method")
//             },
//         }
//
//         // use mockedSourceCodeProviderInterface in code that requires v31.SourceCodeProviderInterface
//         // and then make assertions.
//
//     }
type SourceCodeProviderInterfaceMock struct {
	// AddClusterScopedFeatureHandlerFunc mocks the AddClusterScopedFeatureHandler method.
	AddClusterScopedFeatureHandlerFunc func(ctx context.Context, enabled func() bool, name string, clusterName string, syncMoqParam v31.SourceCodeProviderHandlerFunc)

	// AddClusterScopedFeatureLifecycleFunc mocks the AddClusterScopedFeatureLifecycle method.
	AddClusterScopedFeatureLifecycleFunc func(ctx context.Context, enabled func() bool, name string, clusterName string, lifecycle v31.SourceCodeProviderLifecycle)

	// AddClusterScopedHandlerFunc mocks the AddClusterScopedHandler method.
	AddClusterScopedHandlerFunc func(ctx context.Context, name string, clusterName string, syncMoqParam v31.SourceCodeProviderHandlerFunc)

	// AddClusterScopedLifecycleFunc mocks the AddClusterScopedLifecycle method.
	AddClusterScopedLifecycleFunc func(ctx context.Context, name string, clusterName string, lifecycle v31.SourceCodeProviderLifecycle)

	// AddFeatureHandlerFunc mocks the AddFeatureHandler method.
	AddFeatureHandlerFunc func(ctx context.Context, enabled func() bool, name string, syncMoqParam v31.SourceCodeProviderHandlerFunc)

	// AddFeatureLifecycleFunc mocks the AddFeatureLifecycle method.
	AddFeatureLifecycleFunc func(ctx context.Context, enabled func() bool, name string, lifecycle v31.SourceCodeProviderLifecycle)

	// AddHandlerFunc mocks the AddHandler method.
	AddHandlerFunc func(ctx context.Context, name string, syncMoqParam v31.SourceCodeProviderHandlerFunc)

	// AddLifecycleFunc mocks the AddLifecycle method.
	AddLifecycleFunc func(ctx context.Context, name string, lifecycle v31.SourceCodeProviderLifecycle)

	// ControllerFunc mocks the Controller method.
	ControllerFunc func() v31.SourceCodeProviderController

	// CreateFunc mocks the Create method.
	CreateFunc func(in1 *v3.SourceCodeProvider) (*v3.SourceCodeProvider, error)

	// DeleteFunc mocks the Delete method.
	DeleteFunc func(name string, options *metav1.DeleteOptions) error

	// DeleteCollectionFunc mocks the DeleteCollection method.
	DeleteCollectionFunc func(deleteOpts *metav1.DeleteOptions, listOpts metav1.ListOptions) error

	// DeleteNamespacedFunc mocks the DeleteNamespaced method.
	DeleteNamespacedFunc func(namespace string, name string, options *metav1.DeleteOptions) error

	// GetFunc mocks the Get method.
	GetFunc func(name string, opts metav1.GetOptions) (*v3.SourceCodeProvider, error)

	// GetNamespacedFunc mocks the GetNamespaced method.
	GetNamespacedFunc func(namespace string, name string, opts metav1.GetOptions) (*v3.SourceCodeProvider, error)

	// ListFunc mocks the List method.
	ListFunc func(opts metav1.ListOptions) (*v3.SourceCodeProviderList, error)

	// ListNamespacedFunc mocks the ListNamespaced method.
	ListNamespacedFunc func(namespace string, opts metav1.ListOptions) (*v3.SourceCodeProviderList, error)

	// ObjectClientFunc mocks the ObjectClient method.
	ObjectClientFunc func() *objectclient.ObjectClient

	// UpdateFunc mocks the Update method.
	UpdateFunc func(in1 *v3.SourceCodeProvider) (*v3.SourceCodeProvider, error)

	// WatchFunc mocks the Watch method.
	WatchFunc func(opts metav1.ListOptions) (watch.Interface, error)

	// calls tracks calls to the methods.
	calls struct {
		// AddClusterScopedFeatureHandler holds details about calls to the AddClusterScopedFeatureHandler method.
		AddClusterScopedFeatureHandler []struct {
			// Ctx is the ctx argument value.
			Ctx context.Context
			// Enabled is the enabled argument value.
			Enabled func() bool
			// Name is the name argument value.
			Name string
			// ClusterName is the clusterName argument value.
			ClusterName string
			// Sync is the sync argument value.
			Sync v31.SourceCodeProviderHandlerFunc
		}
		// AddClusterScopedFeatureLifecycle holds details about calls to the AddClusterScopedFeatureLifecycle method.
		AddClusterScopedFeatureLifecycle []struct {
			// Ctx is the ctx argument value.
			Ctx context.Context
			// Enabled is the enabled argument value.
			Enabled func() bool
			// Name is the name argument value.
			Name string
			// ClusterName is the clusterName argument value.
			ClusterName string
			// Lifecycle is the lifecycle argument value.
			Lifecycle v31.SourceCodeProviderLifecycle
		}
		// AddClusterScopedHandler holds details about calls to the AddClusterScopedHandler method.
		AddClusterScopedHandler []struct {
			// Ctx is the ctx argument value.
			Ctx context.Context
			// Name is the name argument value.
			Name string
			// ClusterName is the clusterName argument value.
			ClusterName string
			// Sync is the sync argument value.
			Sync v31.SourceCodeProviderHandlerFunc
		}
		// AddClusterScopedLifecycle holds details about calls to the AddClusterScopedLifecycle method.
		AddClusterScopedLifecycle []struct {
			// Ctx is the ctx argument value.
			Ctx context.Context
			// Name is the name argument value.
			Name string
			// ClusterName is the clusterName argument value.
			ClusterName string
			// Lifecycle is the lifecycle argument value.
			Lifecycle v31.SourceCodeProviderLifecycle
		}
		// AddFeatureHandler holds details about calls to the AddFeatureHandler method.
		AddFeatureHandler []struct {
			// Ctx is the ctx argument value.
			Ctx context.Context
			// Enabled is the enabled argument value.
			Enabled func() bool
			// Name is the name argument value.
			Name string
			// Sync is the sync argument value.
			Sync v31.SourceCodeProviderHandlerFunc
		}
		// AddFeatureLifecycle holds details about calls to the AddFeatureLifecycle method.
		AddFeatureLifecycle []struct {
			// Ctx is the ctx argument value.
			Ctx context.Context
			// Enabled is the enabled argument value.
			Enabled func() bool
			// Name is the name argument value.
			Name string
			// Lifecycle is the lifecycle argument value.
			Lifecycle v31.SourceCodeProviderLifecycle
		}
		// AddHandler holds details about calls to the AddHandler method.
		AddHandler []struct {
			// Ctx is the ctx argument value.
			Ctx context.Context
			// Name is the name argument value.
			Name string
			// Sync is the sync argument value.
			Sync v31.SourceCodeProviderHandlerFunc
		}
		// AddLifecycle holds details about calls to the AddLifecycle method.
		AddLifecycle []struct {
			// Ctx is the ctx argument value.
			Ctx context.Context
			// Name is the name argument value.
			Name string
			// Lifecycle is the lifecycle argument value.
			Lifecycle v31.SourceCodeProviderLifecycle
		}
		// Controller holds details about calls to the Controller method.
		Controller []struct {
		}
		// Create holds details about calls to the Create method.
		Create []struct {
			// In1 is the in1 argument value.
			In1 *v3.SourceCodeProvider
		}
		// Delete holds details about calls to the Delete method.
		Delete []struct {
			// Name is the name argument value.
			Name string
			// Options is the options argument value.
			Options *metav1.DeleteOptions
		}
		// DeleteCollection holds details about calls to the DeleteCollection method.
		DeleteCollection []struct {
			// DeleteOpts is the deleteOpts argument value.
			DeleteOpts *metav1.DeleteOptions
			// ListOpts is the listOpts argument value.
			ListOpts metav1.ListOptions
		}
		// DeleteNamespaced holds details about calls to the DeleteNamespaced method.
		DeleteNamespaced []struct {
			// Namespace is the namespace argument value.
			Namespace string
			// Name is the name argument value.
			Name string
			// Options is the options argument value.
			Options *metav1.DeleteOptions
		}
		// Get holds details about calls to the Get method.
		Get []struct {
			// Name is the name argument value.
			Name string
			// Opts is the opts argument value.
			Opts metav1.GetOptions
		}
		// GetNamespaced holds details about calls to the GetNamespaced method.
		GetNamespaced []struct {
			// Namespace is the namespace argument value.
			Namespace string
			// Name is the name argument value.
			Name string
			// Opts is the opts argument value.
			Opts metav1.GetOptions
		}
		// List holds details about calls to the List method.
		List []struct {
			// Opts is the opts argument value.
			Opts metav1.ListOptions
		}
		// ListNamespaced holds details about calls to the ListNamespaced method.
		ListNamespaced []struct {
			// Namespace is the namespace argument value.
			Namespace string
			// Opts is the opts argument value.
			Opts metav1.ListOptions
		}
		// ObjectClient holds details about calls to the ObjectClient method.
		ObjectClient []struct {
		}
		// Update holds details about calls to the Update method.
		Update []struct {
			// In1 is the in1 argument value.
			In1 *v3.SourceCodeProvider
		}
		// Watch holds details about calls to the Watch method.
		Watch []struct {
			// Opts is the opts argument value.
			Opts metav1.ListOptions
		}
	}
}

// AddClusterScopedFeatureHandler calls AddClusterScopedFeatureHandlerFunc.
func (mock *SourceCodeProviderInterfaceMock) AddClusterScopedFeatureHandler(ctx context.Context, enabled func() bool, name string, clusterName string, syncMoqParam v31.SourceCodeProviderHandlerFunc) {
	if mock.AddClusterScopedFeatureHandlerFunc == nil {
		panic("SourceCodeProviderInterfaceMock.AddClusterScopedFeatureHandlerFunc: method is nil but SourceCodeProviderInterface.AddClusterScopedFeatureHandler was just called")
	}
	callInfo := struct {
		Ctx         context.Context
		Enabled     func() bool
		Name        string
		ClusterName string
		Sync        v31.SourceCodeProviderHandlerFunc
	}{
		Ctx:         ctx,
		Enabled:     enabled,
		Name:        name,
		ClusterName: clusterName,
		Sync:        syncMoqParam,
	}
	lockSourceCodeProviderInterfaceMockAddClusterScopedFeatureHandler.Lock()
	mock.calls.AddClusterScopedFeatureHandler = append(mock.calls.AddClusterScopedFeatureHandler, callInfo)
	lockSourceCodeProviderInterfaceMockAddClusterScopedFeatureHandler.Unlock()
	mock.AddClusterScopedFeatureHandlerFunc(ctx, enabled, name, clusterName, syncMoqParam)
}

// AddClusterScopedFeatureHandlerCalls gets all the calls that were made to AddClusterScopedFeatureHandler.
// Check the length with:
//     len(mockedSourceCodeProviderInterface.AddClusterScopedFeatureHandlerCalls())
func (mock *SourceCodeProviderInterfaceMock) AddClusterScopedFeatureHandlerCalls() []struct {
	Ctx         context.Context
	Enabled     func() bool
	Name        string
	ClusterName string
	Sync        v31.SourceCodeProviderHandlerFunc
} {
	var calls []struct {
		Ctx         context.Context
		Enabled     func() bool
		Name        string
		ClusterName string
		Sync        v31.SourceCodeProviderHandlerFunc
	}
	lockSourceCodeProviderInterfaceMockAddClusterScopedFeatureHandler.RLock()
	calls = mock.calls.AddClusterScopedFeatureHandler
	lockSourceCodeProviderInterfaceMockAddClusterScopedFeatureHandler.RUnlock()
	return calls
}

// AddClusterScopedFeatureLifecycle calls AddClusterScopedFeatureLifecycleFunc.
func (mock *SourceCodeProviderInterfaceMock) AddClusterScopedFeatureLifecycle(ctx context.Context, enabled func() bool, name string, clusterName string, lifecycle v31.SourceCodeProviderLifecycle) {
	if mock.AddClusterScopedFeatureLifecycleFunc == nil {
		panic("SourceCodeProviderInterfaceMock.AddClusterScopedFeatureLifecycleFunc: method is nil but SourceCodeProviderInterface.AddClusterScopedFeatureLifecycle was just called")
	}
	callInfo := struct {
		Ctx         context.Context
		Enabled     func() bool
		Name        string
		ClusterName string
		Lifecycle   v31.SourceCodeProviderLifecycle
	}{
		Ctx:         ctx,
		Enabled:     enabled,
		Name:        name,
		ClusterName: clusterName,
		Lifecycle:   lifecycle,
	}
	lockSourceCodeProviderInterfaceMockAddClusterScopedFeatureLifecycle.Lock()
	mock.calls.AddClusterScopedFeatureLifecycle = append(mock.calls.AddClusterScopedFeatureLifecycle, callInfo)
	lockSourceCodeProviderInterfaceMockAddClusterScopedFeatureLifecycle.Unlock()
	mock.AddClusterScopedFeatureLifecycleFunc(ctx, enabled, name, clusterName, lifecycle)
}

// AddClusterScopedFeatureLifecycleCalls gets all the calls that were made to AddClusterScopedFeatureLifecycle.
// Check the length with:
//     len(mockedSourceCodeProviderInterface.AddClusterScopedFeatureLifecycleCalls())
func (mock *SourceCodeProviderInterfaceMock) AddClusterScopedFeatureLifecycleCalls() []struct {
	Ctx         context.Context
	Enabled     func() bool
	Name        string
	ClusterName string
	Lifecycle   v31.SourceCodeProviderLifecycle
} {
	var calls []struct {
		Ctx         context.Context
		Enabled     func() bool
		Name        string
		ClusterName string
		Lifecycle   v31.SourceCodeProviderLifecycle
	}
	lockSourceCodeProviderInterfaceMockAddClusterScopedFeatureLifecycle.RLock()
	calls = mock.calls.AddClusterScopedFeatureLifecycle
	lockSourceCodeProviderInterfaceMockAddClusterScopedFeatureLifecycle.RUnlock()
	return calls
}

// AddClusterScopedHandler calls AddClusterScopedHandlerFunc.
func (mock *SourceCodeProviderInterfaceMock) AddClusterScopedHandler(ctx context.Context, name string, clusterName string, syncMoqParam v31.SourceCodeProviderHandlerFunc) {
	if mock.AddClusterScopedHandlerFunc == nil {
		panic("SourceCodeProviderInterfaceMock.AddClusterScopedHandlerFunc: method is nil but SourceCodeProviderInterface.AddClusterScopedHandler was just called")
	}
	callInfo := struct {
		Ctx         context.Context
		Name        string
		ClusterName string
		Sync        v31.SourceCodeProviderHandlerFunc
	}{
		Ctx:         ctx,
		Name:        name,
		ClusterName: clusterName,
		Sync:        syncMoqParam,
	}
	lockSourceCodeProviderInterfaceMockAddClusterScopedHandler.Lock()
	mock.calls.AddClusterScopedHandler = append(mock.calls.AddClusterScopedHandler, callInfo)
	lockSourceCodeProviderInterfaceMockAddClusterScopedHandler.Unlock()
	mock.AddClusterScopedHandlerFunc(ctx, name, clusterName, syncMoqParam)
}

// AddClusterScopedHandlerCalls gets all the calls that were made to AddClusterScopedHandler.
// Check the length with:
//     len(mockedSourceCodeProviderInterface.AddClusterScopedHandlerCalls())
func (mock *SourceCodeProviderInterfaceMock) AddClusterScopedHandlerCalls() []struct {
	Ctx         context.Context
	Name        string
	ClusterName string
	Sync        v31.SourceCodeProviderHandlerFunc
} {
	var calls []struct {
		Ctx         context.Context
		Name        string
		ClusterName string
		Sync        v31.SourceCodeProviderHandlerFunc
	}
	lockSourceCodeProviderInterfaceMockAddClusterScopedHandler.RLock()
	calls = mock.calls.AddClusterScopedHandler
	lockSourceCodeProviderInterfaceMockAddClusterScopedHandler.RUnlock()
	return calls
}

// AddClusterScopedLifecycle calls AddClusterScopedLifecycleFunc.
func (mock *SourceCodeProviderInterfaceMock) AddClusterScopedLifecycle(ctx context.Context, name string, clusterName string, lifecycle v31.SourceCodeProviderLifecycle) {
	if mock.AddClusterScopedLifecycleFunc == nil {
		panic("SourceCodeProviderInterfaceMock.AddClusterScopedLifecycleFunc: method is nil but SourceCodeProviderInterface.AddClusterScopedLifecycle was just called")
	}
	callInfo := struct {
		Ctx         context.Context
		Name        string
		ClusterName string
		Lifecycle   v31.SourceCodeProviderLifecycle
	}{
		Ctx:         ctx,
		Name:        name,
		ClusterName: clusterName,
		Lifecycle:   lifecycle,
	}
	lockSourceCodeProviderInterfaceMockAddClusterScopedLifecycle.Lock()
	mock.calls.AddClusterScopedLifecycle = append(mock.calls.AddClusterScopedLifecycle, callInfo)
	lockSourceCodeProviderInterfaceMockAddClusterScopedLifecycle.Unlock()
	mock.AddClusterScopedLifecycleFunc(ctx, name, clusterName, lifecycle)
}

// AddClusterScopedLifecycleCalls gets all the calls that were made to AddClusterScopedLifecycle.
// Check the length with:
//     len(mockedSourceCodeProviderInterface.AddClusterScopedLifecycleCalls())
func (mock *SourceCodeProviderInterfaceMock) AddClusterScopedLifecycleCalls() []struct {
	Ctx         context.Context
	Name        string
	ClusterName string
	Lifecycle   v31.SourceCodeProviderLifecycle
} {
	var calls []struct {
		Ctx         context.Context
		Name        string
		ClusterName string
		Lifecycle   v31.SourceCodeProviderLifecycle
	}
	lockSourceCodeProviderInterfaceMockAddClusterScopedLifecycle.RLock()
	calls = mock.calls.AddClusterScopedLifecycle
	lockSourceCodeProviderInterfaceMockAddClusterScopedLifecycle.RUnlock()
	return calls
}

// AddFeatureHandler calls AddFeatureHandlerFunc.
func (mock *SourceCodeProviderInterfaceMock) AddFeatureHandler(ctx context.Context, enabled func() bool, name string, syncMoqParam v31.SourceCodeProviderHandlerFunc) {
	if mock.AddFeatureHandlerFunc == nil {
		panic("SourceCodeProviderInterfaceMock.AddFeatureHandlerFunc: method is nil but SourceCodeProviderInterface.AddFeatureHandler was just called")
	}
	callInfo := struct {
		Ctx     context.Context
		Enabled func() bool
		Name    string
		Sync    v31.SourceCodeProviderHandlerFunc
	}{
		Ctx:     ctx,
		Enabled: enabled,
		Name:    name,
		Sync:    syncMoqParam,
	}
	lockSourceCodeProviderInterfaceMockAddFeatureHandler.Lock()
	mock.calls.AddFeatureHandler = append(mock.calls.AddFeatureHandler, callInfo)
	lockSourceCodeProviderInterfaceMockAddFeatureHandler.Unlock()
	mock.AddFeatureHandlerFunc(ctx, enabled, name, syncMoqParam)
}

// AddFeatureHandlerCalls gets all the calls that were made to AddFeatureHandler.
// Check the length with:
//     len(mockedSourceCodeProviderInterface.AddFeatureHandlerCalls())
func (mock *SourceCodeProviderInterfaceMock) AddFeatureHandlerCalls() []struct {
	Ctx     context.Context
	Enabled func() bool
	Name    string
	Sync    v31.SourceCodeProviderHandlerFunc
} {
	var calls []struct {
		Ctx     context.Context
		Enabled func() bool
		Name    string
		Sync    v31.SourceCodeProviderHandlerFunc
	}
	lockSourceCodeProviderInterfaceMockAddFeatureHandler.RLock()
	calls = mock.calls.AddFeatureHandler
	lockSourceCodeProviderInterfaceMockAddFeatureHandler.RUnlock()
	return calls
}

// AddFeatureLifecycle calls AddFeatureLifecycleFunc.
func (mock *SourceCodeProviderInterfaceMock) AddFeatureLifecycle(ctx context.Context, enabled func() bool, name string, lifecycle v31.SourceCodeProviderLifecycle) {
	if mock.AddFeatureLifecycleFunc == nil {
		panic("SourceCodeProviderInterfaceMock.AddFeatureLifecycleFunc: method is nil but SourceCodeProviderInterface.AddFeatureLifecycle was just called")
	}
	callInfo := struct {
		Ctx       context.Context
		Enabled   func() bool
		Name      string
		Lifecycle v31.SourceCodeProviderLifecycle
	}{
		Ctx:       ctx,
		Enabled:   enabled,
		Name:      name,
		Lifecycle: lifecycle,
	}
	lockSourceCodeProviderInterfaceMockAddFeatureLifecycle.Lock()
	mock.calls.AddFeatureLifecycle = append(mock.calls.AddFeatureLifecycle, callInfo)
	lockSourceCodeProviderInterfaceMockAddFeatureLifecycle.Unlock()
	mock.AddFeatureLifecycleFunc(ctx, enabled, name, lifecycle)
}

// AddFeatureLifecycleCalls gets all the calls that were made to AddFeatureLifecycle.
// Check the length with:
//     len(mockedSourceCodeProviderInterface.AddFeatureLifecycleCalls())
func (mock *SourceCodeProviderInterfaceMock) AddFeatureLifecycleCalls() []struct {
	Ctx       context.Context
	Enabled   func() bool
	Name      string
	Lifecycle v31.SourceCodeProviderLifecycle
} {
	var calls []struct {
		Ctx       context.Context
		Enabled   func() bool
		Name      string
		Lifecycle v31.SourceCodeProviderLifecycle
	}
	lockSourceCodeProviderInterfaceMockAddFeatureLifecycle.RLock()
	calls = mock.calls.AddFeatureLifecycle
	lockSourceCodeProviderInterfaceMockAddFeatureLifecycle.RUnlock()
	return calls
}

// AddHandler calls AddHandlerFunc.
func (mock *SourceCodeProviderInterfaceMock) AddHandler(ctx context.Context, name string, syncMoqParam v31.SourceCodeProviderHandlerFunc) {
	if mock.AddHandlerFunc == nil {
		panic("SourceCodeProviderInterfaceMock.AddHandlerFunc: method is nil but SourceCodeProviderInterface.AddHandler was just called")
	}
	callInfo := struct {
		Ctx  context.Context
		Name string
		Sync v31.SourceCodeProviderHandlerFunc
	}{
		Ctx:  ctx,
		Name: name,
		Sync: syncMoqParam,
	}
	lockSourceCodeProviderInterfaceMockAddHandler.Lock()
	mock.calls.AddHandler = append(mock.calls.AddHandler, callInfo)
	lockSourceCodeProviderInterfaceMockAddHandler.Unlock()
	mock.AddHandlerFunc(ctx, name, syncMoqParam)
}

// AddHandlerCalls gets all the calls that were made to AddHandler.
// Check the length with:
//     len(mockedSourceCodeProviderInterface.AddHandlerCalls())
func (mock *SourceCodeProviderInterfaceMock) AddHandlerCalls() []struct {
	Ctx  context.Context
	Name string
	Sync v31.SourceCodeProviderHandlerFunc
} {
	var calls []struct {
		Ctx  context.Context
		Name string
		Sync v31.SourceCodeProviderHandlerFunc
	}
	lockSourceCodeProviderInterfaceMockAddHandler.RLock()
	calls = mock.calls.AddHandler
	lockSourceCodeProviderInterfaceMockAddHandler.RUnlock()
	return calls
}

// AddLifecycle calls AddLifecycleFunc.
func (mock *SourceCodeProviderInterfaceMock) AddLifecycle(ctx context.Context, name string, lifecycle v31.SourceCodeProviderLifecycle) {
	if mock.AddLifecycleFunc == nil {
		panic("SourceCodeProviderInterfaceMock.AddLifecycleFunc: method is nil but SourceCodeProviderInterface.AddLifecycle was just called")
	}
	callInfo := struct {
		Ctx       context.Context
		Name      string
		Lifecycle v31.SourceCodeProviderLifecycle
	}{
		Ctx:       ctx,
		Name:      name,
		Lifecycle: lifecycle,
	}
	lockSourceCodeProviderInterfaceMockAddLifecycle.Lock()
	mock.calls.AddLifecycle = append(mock.calls.AddLifecycle, callInfo)
	lockSourceCodeProviderInterfaceMockAddLifecycle.Unlock()
	mock.AddLifecycleFunc(ctx, name, lifecycle)
}

// AddLifecycleCalls gets all the calls that were made to AddLifecycle.
// Check the length with:
//     len(mockedSourceCodeProviderInterface.AddLifecycleCalls())
func (mock *SourceCodeProviderInterfaceMock) AddLifecycleCalls() []struct {
	Ctx       context.Context
	Name      string
	Lifecycle v31.SourceCodeProviderLifecycle
} {
	var calls []struct {
		Ctx       context.Context
		Name      string
		Lifecycle v31.SourceCodeProviderLifecycle
	}
	lockSourceCodeProviderInterfaceMockAddLifecycle.RLock()
	calls = mock.calls.AddLifecycle
	lockSourceCodeProviderInterfaceMockAddLifecycle.RUnlock()
	return calls
}

// Controller calls ControllerFunc.
func (mock *SourceCodeProviderInterfaceMock) Controller() v31.SourceCodeProviderController {
	if mock.ControllerFunc == nil {
		panic("SourceCodeProviderInterfaceMock.ControllerFunc: method is nil but SourceCodeProviderInterface.Controller was just called")
	}
	callInfo := struct {
	}{}
	lockSourceCodeProviderInterfaceMockController.Lock()
	mock.calls.Controller = append(mock.calls.Controller, callInfo)
	lockSourceCodeProviderInterfaceMockController.Unlock()
	return mock.ControllerFunc()
}

// ControllerCalls gets all the calls that were made to Controller.
// Check the length with:
//     len(mockedSourceCodeProviderInterface.ControllerCalls())
func (mock *SourceCodeProviderInterfaceMock) ControllerCalls() []struct {
} {
	var calls []struct {
	}
	lockSourceCodeProviderInterfaceMockController.RLock()
	calls = mock.calls.Controller
	lockSourceCodeProviderInterfaceMockController.RUnlock()
	return calls
}

// Create calls CreateFunc.
func (mock *SourceCodeProviderInterfaceMock) Create(in1 *v3.SourceCodeProvider) (*v3.SourceCodeProvider, error) {
	if mock.CreateFunc == nil {
		panic("SourceCodeProviderInterfaceMock.CreateFunc: method is nil but SourceCodeProviderInterface.Create was just called")
	}
	callInfo := struct {
		In1 *v3.SourceCodeProvider
	}{
		In1: in1,
	}
	lockSourceCodeProviderInterfaceMockCreate.Lock()
	mock.calls.Create = append(mock.calls.Create, callInfo)
	lockSourceCodeProviderInterfaceMockCreate.Unlock()
	return mock.CreateFunc(in1)
}

// CreateCalls gets all the calls that were made to Create.
// Check the length with:
//     len(mockedSourceCodeProviderInterface.CreateCalls())
func (mock *SourceCodeProviderInterfaceMock) CreateCalls() []struct {
	In1 *v3.SourceCodeProvider
} {
	var calls []struct {
		In1 *v3.SourceCodeProvider
	}
	lockSourceCodeProviderInterfaceMockCreate.RLock()
	calls = mock.calls.Create
	lockSourceCodeProviderInterfaceMockCreate.RUnlock()
	return calls
}

// Delete calls DeleteFunc.
func (mock *SourceCodeProviderInterfaceMock) Delete(name string, options *metav1.DeleteOptions) error {
	if mock.DeleteFunc == nil {
		panic("SourceCodeProviderInterfaceMock.DeleteFunc: method is nil but SourceCodeProviderInterface.Delete was just called")
	}
	callInfo := struct {
		Name    string
		Options *metav1.DeleteOptions
	}{
		Name:    name,
		Options: options,
	}
	lockSourceCodeProviderInterfaceMockDelete.Lock()
	mock.calls.Delete = append(mock.calls.Delete, callInfo)
	lockSourceCodeProviderInterfaceMockDelete.Unlock()
	return mock.DeleteFunc(name, options)
}

// DeleteCalls gets all the calls that were made to Delete.
// Check the length with:
//     len(mockedSourceCodeProviderInterface.DeleteCalls())
func (mock *SourceCodeProviderInterfaceMock) DeleteCalls() []struct {
	Name    string
	Options *metav1.DeleteOptions
} {
	var calls []struct {
		Name    string
		Options *metav1.DeleteOptions
	}
	lockSourceCodeProviderInterfaceMockDelete.RLock()
	calls = mock.calls.Delete
	lockSourceCodeProviderInterfaceMockDelete.RUnlock()
	return calls
}

// DeleteCollection calls DeleteCollectionFunc.
func (mock *SourceCodeProviderInterfaceMock) DeleteCollection(deleteOpts *metav1.DeleteOptions, listOpts metav1.ListOptions) error {
	if mock.DeleteCollectionFunc == nil {
		panic("SourceCodeProviderInterfaceMock.DeleteCollectionFunc: method is nil but SourceCodeProviderInterface.DeleteCollection was just called")
	}
	callInfo := struct {
		DeleteOpts *metav1.DeleteOptions
		ListOpts   metav1.ListOptions
	}{
		DeleteOpts: deleteOpts,
		ListOpts:   listOpts,
	}
	lockSourceCodeProviderInterfaceMockDeleteCollection.Lock()
	mock.calls.DeleteCollection = append(mock.calls.DeleteCollection, callInfo)
	lockSourceCodeProviderInterfaceMockDeleteCollection.Unlock()
	return mock.DeleteCollectionFunc(deleteOpts, listOpts)
}

// DeleteCollectionCalls gets all the calls that were made to DeleteCollection.
// Check the length with:
//     len(mockedSourceCodeProviderInterface.DeleteCollectionCalls())
func (mock *SourceCodeProviderInterfaceMock) DeleteCollectionCalls() []struct {
	DeleteOpts *metav1.DeleteOptions
	ListOpts   metav1.ListOptions
} {
	var calls []struct {
		DeleteOpts *metav1.DeleteOptions
		ListOpts   metav1.ListOptions
	}
	lockSourceCodeProviderInterfaceMockDeleteCollection.RLock()
	calls = mock.calls.DeleteCollection
	lockSourceCodeProviderInterfaceMockDeleteCollection.RUnlock()
	return calls
}

// DeleteNamespaced calls DeleteNamespacedFunc.
func (mock *SourceCodeProviderInterfaceMock) DeleteNamespaced(namespace string, name string, options *metav1.DeleteOptions) error {
	if mock.DeleteNamespacedFunc == nil {
		panic("SourceCodeProviderInterfaceMock.DeleteNamespacedFunc: method is nil but SourceCodeProviderInterface.DeleteNamespaced was just called")
	}
	callInfo := struct {
		Namespace string
		Name      string
		Options   *metav1.DeleteOptions
	}{
		Namespace: namespace,
		Name:      name,
		Options:   options,
	}
	lockSourceCodeProviderInterfaceMockDeleteNamespaced.Lock()
	mock.calls.DeleteNamespaced = append(mock.calls.DeleteNamespaced, callInfo)
	lockSourceCodeProviderInterfaceMockDeleteNamespaced.Unlock()
	return mock.DeleteNamespacedFunc(namespace, name, options)
}

// DeleteNamespacedCalls gets all the calls that were made to DeleteNamespaced.
// Check the length with:
//     len(mockedSourceCodeProviderInterface.DeleteNamespacedCalls())
func (mock *SourceCodeProviderInterfaceMock) DeleteNamespacedCalls() []struct {
	Namespace string
	Name      string
	Options   *metav1.DeleteOptions
} {
	var calls []struct {
		Namespace string
		Name      string
		Options   *metav1.DeleteOptions
	}
	lockSourceCodeProviderInterfaceMockDeleteNamespaced.RLock()
	calls = mock.calls.DeleteNamespaced
	lockSourceCodeProviderInterfaceMockDeleteNamespaced.RUnlock()
	return calls
}

// Get calls GetFunc.
func (mock *SourceCodeProviderInterfaceMock) Get(name string, opts metav1.GetOptions) (*v3.SourceCodeProvider, error) {
	if mock.GetFunc == nil {
		panic("SourceCodeProviderInterfaceMock.GetFunc: method is nil but SourceCodeProviderInterface.Get was just called")
	}
	callInfo := struct {
		Name string
		Opts metav1.GetOptions
	}{
		Name: name,
		Opts: opts,
	}
	lockSourceCodeProviderInterfaceMockGet.Lock()
	mock.calls.Get = append(mock.calls.Get, callInfo)
	lockSourceCodeProviderInterfaceMockGet.Unlock()
	return mock.GetFunc(name, opts)
}

// GetCalls gets all the calls that were made to Get.
// Check the length with:
//     len(mockedSourceCodeProviderInterface.GetCalls())
func (mock *SourceCodeProviderInterfaceMock) GetCalls() []struct {
	Name string
	Opts metav1.GetOptions
} {
	var calls []struct {
		Name string
		Opts metav1.GetOptions
	}
	lockSourceCodeProviderInterfaceMockGet.RLock()
	calls = mock.calls.Get
	lockSourceCodeProviderInterfaceMockGet.RUnlock()
	return calls
}

// GetNamespaced calls GetNamespacedFunc.
func (mock *SourceCodeProviderInterfaceMock) GetNamespaced(namespace string, name string, opts metav1.GetOptions) (*v3.SourceCodeProvider, error) {
	if mock.GetNamespacedFunc == nil {
		panic("SourceCodeProviderInterfaceMock.GetNamespacedFunc: method is nil but SourceCodeProviderInterface.GetNamespaced was just called")
	}
	callInfo := struct {
		Namespace string
		Name      string
		Opts      metav1.GetOptions
	}{
		Namespace: namespace,
		Name:      name,
		Opts:      opts,
	}
	lockSourceCodeProviderInterfaceMockGetNamespaced.Lock()
	mock.calls.GetNamespaced = append(mock.calls.GetNamespaced, callInfo)
	lockSourceCodeProviderInterfaceMockGetNamespaced.Unlock()
	return mock.GetNamespacedFunc(namespace, name, opts)
}

// GetNamespacedCalls gets all the calls that were made to GetNamespaced.
// Check the length with:
//     len(mockedSourceCodeProviderInterface.GetNamespacedCalls())
func (mock *SourceCodeProviderInterfaceMock) GetNamespacedCalls() []struct {
	Namespace string
	Name      string
	Opts      metav1.GetOptions
} {
	var calls []struct {
		Namespace string
		Name      string
		Opts      metav1.GetOptions
	}
	lockSourceCodeProviderInterfaceMockGetNamespaced.RLock()
	calls = mock.calls.GetNamespaced
	lockSourceCodeProviderInterfaceMockGetNamespaced.RUnlock()
	return calls
}

// List calls ListFunc.
func (mock *SourceCodeProviderInterfaceMock) List(opts metav1.ListOptions) (*v3.SourceCodeProviderList, error) {
	if mock.ListFunc == nil {
		panic("SourceCodeProviderInterfaceMock.ListFunc: method is nil but SourceCodeProviderInterface.List was just called")
	}
	callInfo := struct {
		Opts metav1.ListOptions
	}{
		Opts: opts,
	}
	lockSourceCodeProviderInterfaceMockList.Lock()
	mock.calls.List = append(mock.calls.List, callInfo)
	lockSourceCodeProviderInterfaceMockList.Unlock()
	return mock.ListFunc(opts)
}

// ListCalls gets all the calls that were made to List.
// Check the length with:
//     len(mockedSourceCodeProviderInterface.ListCalls())
func (mock *SourceCodeProviderInterfaceMock) ListCalls() []struct {
	Opts metav1.ListOptions
} {
	var calls []struct {
		Opts metav1.ListOptions
	}
	lockSourceCodeProviderInterfaceMockList.RLock()
	calls = mock.calls.List
	lockSourceCodeProviderInterfaceMockList.RUnlock()
	return calls
}

// ListNamespaced calls ListNamespacedFunc.
func (mock *SourceCodeProviderInterfaceMock) ListNamespaced(namespace string, opts metav1.ListOptions) (*v3.SourceCodeProviderList, error) {
	if mock.ListNamespacedFunc == nil {
		panic("SourceCodeProviderInterfaceMock.ListNamespacedFunc: method is nil but SourceCodeProviderInterface.ListNamespaced was just called")
	}
	callInfo := struct {
		Namespace string
		Opts      metav1.ListOptions
	}{
		Namespace: namespace,
		Opts:      opts,
	}
	lockSourceCodeProviderInterfaceMockListNamespaced.Lock()
	mock.calls.ListNamespaced = append(mock.calls.ListNamespaced, callInfo)
	lockSourceCodeProviderInterfaceMockListNamespaced.Unlock()
	return mock.ListNamespacedFunc(namespace, opts)
}

// ListNamespacedCalls gets all the calls that were made to ListNamespaced.
// Check the length with:
//     len(mockedSourceCodeProviderInterface.ListNamespacedCalls())
func (mock *SourceCodeProviderInterfaceMock) ListNamespacedCalls() []struct {
	Namespace string
	Opts      metav1.ListOptions
} {
	var calls []struct {
		Namespace string
		Opts      metav1.ListOptions
	}
	lockSourceCodeProviderInterfaceMockListNamespaced.RLock()
	calls = mock.calls.ListNamespaced
	lockSourceCodeProviderInterfaceMockListNamespaced.RUnlock()
	return calls
}

// ObjectClient calls ObjectClientFunc.
func (mock *SourceCodeProviderInterfaceMock) ObjectClient() *objectclient.ObjectClient {
	if mock.ObjectClientFunc == nil {
		panic("SourceCodeProviderInterfaceMock.ObjectClientFunc: method is nil but SourceCodeProviderInterface.ObjectClient was just called")
	}
	callInfo := struct {
	}{}
	lockSourceCodeProviderInterfaceMockObjectClient.Lock()
	mock.calls.ObjectClient = append(mock.calls.ObjectClient, callInfo)
	lockSourceCodeProviderInterfaceMockObjectClient.Unlock()
	return mock.ObjectClientFunc()
}

// ObjectClientCalls gets all the calls that were made to ObjectClient.
// Check the length with:
//     len(mockedSourceCodeProviderInterface.ObjectClientCalls())
func (mock *SourceCodeProviderInterfaceMock) ObjectClientCalls() []struct {
} {
	var calls []struct {
	}
	lockSourceCodeProviderInterfaceMockObjectClient.RLock()
	calls = mock.calls.ObjectClient
	lockSourceCodeProviderInterfaceMockObjectClient.RUnlock()
	return calls
}

// Update calls UpdateFunc.
func (mock *SourceCodeProviderInterfaceMock) Update(in1 *v3.SourceCodeProvider) (*v3.SourceCodeProvider, error) {
	if mock.UpdateFunc == nil {
		panic("SourceCodeProviderInterfaceMock.UpdateFunc: method is nil but SourceCodeProviderInterface.Update was just called")
	}
	callInfo := struct {
		In1 *v3.SourceCodeProvider
	}{
		In1: in1,
	}
	lockSourceCodeProviderInterfaceMockUpdate.Lock()
	mock.calls.Update = append(mock.calls.Update, callInfo)
	lockSourceCodeProviderInterfaceMockUpdate.Unlock()
	return mock.UpdateFunc(in1)
}

// UpdateCalls gets all the calls that were made to Update.
// Check the length with:
//     len(mockedSourceCodeProviderInterface.UpdateCalls())
func (mock *SourceCodeProviderInterfaceMock) UpdateCalls() []struct {
	In1 *v3.SourceCodeProvider
} {
	var calls []struct {
		In1 *v3.SourceCodeProvider
	}
	lockSourceCodeProviderInterfaceMockUpdate.RLock()
	calls = mock.calls.Update
	lockSourceCodeProviderInterfaceMockUpdate.RUnlock()
	return calls
}

// Watch calls WatchFunc.
func (mock *SourceCodeProviderInterfaceMock) Watch(opts metav1.ListOptions) (watch.Interface, error) {
	if mock.WatchFunc == nil {
		panic("SourceCodeProviderInterfaceMock.WatchFunc: method is nil but SourceCodeProviderInterface.Watch was just called")
	}
	callInfo := struct {
		Opts metav1.ListOptions
	}{
		Opts: opts,
	}
	lockSourceCodeProviderInterfaceMockWatch.Lock()
	mock.calls.Watch = append(mock.calls.Watch, callInfo)
	lockSourceCodeProviderInterfaceMockWatch.Unlock()
	return mock.WatchFunc(opts)
}

// WatchCalls gets all the calls that were made to Watch.
// Check the length with:
//     len(mockedSourceCodeProviderInterface.WatchCalls())
func (mock *SourceCodeProviderInterfaceMock) WatchCalls() []struct {
	Opts metav1.ListOptions
} {
	var calls []struct {
		Opts metav1.ListOptions
	}
	lockSourceCodeProviderInterfaceMockWatch.RLock()
	calls = mock.calls.Watch
	lockSourceCodeProviderInterfaceMockWatch.RUnlock()
	return calls
}

var (
	lockSourceCodeProvidersGetterMockSourceCodeProviders sync.RWMutex
)

// Ensure, that SourceCodeProvidersGetterMock does implement v31.SourceCodeProvidersGetter.
// If this is not the case, regenerate this file with moq.
var _ v31.SourceCodeProvidersGetter = &SourceCodeProvidersGetterMock{}

// SourceCodeProvidersGetterMock is a mock implementation of v31.SourceCodeProvidersGetter.
//
//     func TestSomethingThatUsesSourceCodeProvidersGetter(t *testing.T) {
//
//         // make and configure a mocked v31.SourceCodeProvidersGetter
//         mockedSourceCodeProvidersGetter := &SourceCodeProvidersGetterMock{
//             SourceCodeProvidersFunc: func(namespace string) v31.SourceCodeProviderInterface {
// 	               panic("mock out the SourceCodeProviders method")
//             },
//         }
//
//         // use mockedSourceCodeProvidersGetter in code that requires v31.SourceCodeProvidersGetter
//         // and then make assertions.
//
//     }
type SourceCodeProvidersGetterMock struct {
	// SourceCodeProvidersFunc mocks the SourceCodeProviders method.
	SourceCodeProvidersFunc func(namespace string) v31.SourceCodeProviderInterface

	// calls tracks calls to the methods.
	calls struct {
		// SourceCodeProviders holds details about calls to the SourceCodeProviders method.
		SourceCodeProviders []struct {
			// Namespace is the namespace argument value.
			Namespace string
		}
	}
}

// SourceCodeProviders calls SourceCodeProvidersFunc.
func (mock *SourceCodeProvidersGetterMock) SourceCodeProviders(namespace string) v31.SourceCodeProviderInterface {
	if mock.SourceCodeProvidersFunc == nil {
		panic("SourceCodeProvidersGetterMock.SourceCodeProvidersFunc: method is nil but SourceCodeProvidersGetter.SourceCodeProviders was just called")
	}
	callInfo := struct {
		Namespace string
	}{
		Namespace: namespace,
	}
	lockSourceCodeProvidersGetterMockSourceCodeProviders.Lock()
	mock.calls.SourceCodeProviders = append(mock.calls.SourceCodeProviders, callInfo)
	lockSourceCodeProvidersGetterMockSourceCodeProviders.Unlock()
	return mock.SourceCodeProvidersFunc(namespace)
}

// SourceCodeProvidersCalls gets all the calls that were made to SourceCodeProviders.
// Check the length with:
//     len(mockedSourceCodeProvidersGetter.SourceCodeProvidersCalls())
func (mock *SourceCodeProvidersGetterMock) SourceCodeProvidersCalls() []struct {
	Namespace string
} {
	var calls []struct {
		Namespace string
	}
	lockSourceCodeProvidersGetterMockSourceCodeProviders.RLock()
	calls = mock.calls.SourceCodeProviders
	lockSourceCodeProvidersGetterMockSourceCodeProviders.RUnlock()
	return calls
}
