// Code generated by moq; DO NOT EDIT.
// github.com/matryer/moq

package fakes

import (
	"context"
	"sync"
	"time"

	"github.com/rancher/norman/controller"
	"github.com/rancher/norman/objectclient"
	v3 "github.com/rancher/rancher/pkg/apis/project.cattle.io/v3"
	v31 "github.com/rancher/rancher/pkg/generated/norman/project.cattle.io/v3"
	metav1 "k8s.io/apimachinery/pkg/apis/meta/v1"
	"k8s.io/apimachinery/pkg/labels"
	"k8s.io/apimachinery/pkg/watch"
	"k8s.io/client-go/tools/cache"
)

var (
	lockSourceCodeRepositoryListerMockGet  sync.RWMutex
	lockSourceCodeRepositoryListerMockList sync.RWMutex
)

// Ensure, that SourceCodeRepositoryListerMock does implement v31.SourceCodeRepositoryLister.
// If this is not the case, regenerate this file with moq.
var _ v31.SourceCodeRepositoryLister = &SourceCodeRepositoryListerMock{}

// SourceCodeRepositoryListerMock is a mock implementation of v31.SourceCodeRepositoryLister.
//
//     func TestSomethingThatUsesSourceCodeRepositoryLister(t *testing.T) {
//
//         // make and configure a mocked v31.SourceCodeRepositoryLister
//         mockedSourceCodeRepositoryLister := &SourceCodeRepositoryListerMock{
//             GetFunc: func(namespace string, name string) (*v3.SourceCodeRepository, error) {
// 	               panic("mock out the Get method")
//             },
//             ListFunc: func(namespace string, selector labels.Selector) ([]*v3.SourceCodeRepository, error) {
// 	               panic("mock out the List method")
//             },
//         }
//
//         // use mockedSourceCodeRepositoryLister in code that requires v31.SourceCodeRepositoryLister
//         // and then make assertions.
//
//     }
type SourceCodeRepositoryListerMock struct {
	// GetFunc mocks the Get method.
	GetFunc func(namespace string, name string) (*v3.SourceCodeRepository, error)

	// ListFunc mocks the List method.
	ListFunc func(namespace string, selector labels.Selector) ([]*v3.SourceCodeRepository, error)

	// calls tracks calls to the methods.
	calls struct {
		// Get holds details about calls to the Get method.
		Get []struct {
			// Namespace is the namespace argument value.
			Namespace string
			// Name is the name argument value.
			Name string
		}
		// List holds details about calls to the List method.
		List []struct {
			// Namespace is the namespace argument value.
			Namespace string
			// Selector is the selector argument value.
			Selector labels.Selector
		}
	}
}

// Get calls GetFunc.
func (mock *SourceCodeRepositoryListerMock) Get(namespace string, name string) (*v3.SourceCodeRepository, error) {
	if mock.GetFunc == nil {
		panic("SourceCodeRepositoryListerMock.GetFunc: method is nil but SourceCodeRepositoryLister.Get was just called")
	}
	callInfo := struct {
		Namespace string
		Name      string
	}{
		Namespace: namespace,
		Name:      name,
	}
	lockSourceCodeRepositoryListerMockGet.Lock()
	mock.calls.Get = append(mock.calls.Get, callInfo)
	lockSourceCodeRepositoryListerMockGet.Unlock()
	return mock.GetFunc(namespace, name)
}

// GetCalls gets all the calls that were made to Get.
// Check the length with:
//     len(mockedSourceCodeRepositoryLister.GetCalls())
func (mock *SourceCodeRepositoryListerMock) GetCalls() []struct {
	Namespace string
	Name      string
} {
	var calls []struct {
		Namespace string
		Name      string
	}
	lockSourceCodeRepositoryListerMockGet.RLock()
	calls = mock.calls.Get
	lockSourceCodeRepositoryListerMockGet.RUnlock()
	return calls
}

// List calls ListFunc.
func (mock *SourceCodeRepositoryListerMock) List(namespace string, selector labels.Selector) ([]*v3.SourceCodeRepository, error) {
	if mock.ListFunc == nil {
		panic("SourceCodeRepositoryListerMock.ListFunc: method is nil but SourceCodeRepositoryLister.List was just called")
	}
	callInfo := struct {
		Namespace string
		Selector  labels.Selector
	}{
		Namespace: namespace,
		Selector:  selector,
	}
	lockSourceCodeRepositoryListerMockList.Lock()
	mock.calls.List = append(mock.calls.List, callInfo)
	lockSourceCodeRepositoryListerMockList.Unlock()
	return mock.ListFunc(namespace, selector)
}

// ListCalls gets all the calls that were made to List.
// Check the length with:
//     len(mockedSourceCodeRepositoryLister.ListCalls())
func (mock *SourceCodeRepositoryListerMock) ListCalls() []struct {
	Namespace string
	Selector  labels.Selector
} {
	var calls []struct {
		Namespace string
		Selector  labels.Selector
	}
	lockSourceCodeRepositoryListerMockList.RLock()
	calls = mock.calls.List
	lockSourceCodeRepositoryListerMockList.RUnlock()
	return calls
}

var (
	lockSourceCodeRepositoryControllerMockAddClusterScopedFeatureHandler sync.RWMutex
	lockSourceCodeRepositoryControllerMockAddClusterScopedHandler        sync.RWMutex
	lockSourceCodeRepositoryControllerMockAddFeatureHandler              sync.RWMutex
	lockSourceCodeRepositoryControllerMockAddHandler                     sync.RWMutex
	lockSourceCodeRepositoryControllerMockEnqueue                        sync.RWMutex
	lockSourceCodeRepositoryControllerMockEnqueueAfter                   sync.RWMutex
	lockSourceCodeRepositoryControllerMockGeneric                        sync.RWMutex
	lockSourceCodeRepositoryControllerMockInformer                       sync.RWMutex
	lockSourceCodeRepositoryControllerMockLister                         sync.RWMutex
)

// Ensure, that SourceCodeRepositoryControllerMock does implement v31.SourceCodeRepositoryController.
// If this is not the case, regenerate this file with moq.
var _ v31.SourceCodeRepositoryController = &SourceCodeRepositoryControllerMock{}

// SourceCodeRepositoryControllerMock is a mock implementation of v31.SourceCodeRepositoryController.
//
//     func TestSomethingThatUsesSourceCodeRepositoryController(t *testing.T) {
//
//         // make and configure a mocked v31.SourceCodeRepositoryController
//         mockedSourceCodeRepositoryController := &SourceCodeRepositoryControllerMock{
//             AddClusterScopedFeatureHandlerFunc: func(ctx context.Context, enabled func() bool, name string, clusterName string, handler v31.SourceCodeRepositoryHandlerFunc)  {
// 	               panic("mock out the AddClusterScopedFeatureHandler method")
//             },
//             AddClusterScopedHandlerFunc: func(ctx context.Context, name string, clusterName string, handler v31.SourceCodeRepositoryHandlerFunc)  {
// 	               panic("mock out the AddClusterScopedHandler method")
//             },
//             AddFeatureHandlerFunc: func(ctx context.Context, enabled func() bool, name string, syncMoqParam v31.SourceCodeRepositoryHandlerFunc)  {
// 	               panic("mock out the AddFeatureHandler method")
//             },
//             AddHandlerFunc: func(ctx context.Context, name string, handler v31.SourceCodeRepositoryHandlerFunc)  {
// 	               panic("mock out the AddHandler method")
//             },
//             EnqueueFunc: func(namespace string, name string)  {
// 	               panic("mock out the Enqueue method")
//             },
//             EnqueueAfterFunc: func(namespace string, name string, after time.Duration)  {
// 	               panic("mock out the EnqueueAfter method")
//             },
//             GenericFunc: func() controller.GenericController {
// 	               panic("mock out the Generic method")
//             },
//             InformerFunc: func() cache.SharedIndexInformer {
// 	               panic("mock out the Informer method")
//             },
//             ListerFunc: func() v31.SourceCodeRepositoryLister {
// 	               panic("mock out the Lister method")
//             },
//         }
//
//         // use mockedSourceCodeRepositoryController in code that requires v31.SourceCodeRepositoryController
//         // and then make assertions.
//
//     }
type SourceCodeRepositoryControllerMock struct {
	// AddClusterScopedFeatureHandlerFunc mocks the AddClusterScopedFeatureHandler method.
	AddClusterScopedFeatureHandlerFunc func(ctx context.Context, enabled func() bool, name string, clusterName string, handler v31.SourceCodeRepositoryHandlerFunc)

	// AddClusterScopedHandlerFunc mocks the AddClusterScopedHandler method.
	AddClusterScopedHandlerFunc func(ctx context.Context, name string, clusterName string, handler v31.SourceCodeRepositoryHandlerFunc)

	// AddFeatureHandlerFunc mocks the AddFeatureHandler method.
	AddFeatureHandlerFunc func(ctx context.Context, enabled func() bool, name string, syncMoqParam v31.SourceCodeRepositoryHandlerFunc)

	// AddHandlerFunc mocks the AddHandler method.
	AddHandlerFunc func(ctx context.Context, name string, handler v31.SourceCodeRepositoryHandlerFunc)

	// EnqueueFunc mocks the Enqueue method.
	EnqueueFunc func(namespace string, name string)

	// EnqueueAfterFunc mocks the EnqueueAfter method.
	EnqueueAfterFunc func(namespace string, name string, after time.Duration)

	// GenericFunc mocks the Generic method.
	GenericFunc func() controller.GenericController

	// InformerFunc mocks the Informer method.
	InformerFunc func() cache.SharedIndexInformer

	// ListerFunc mocks the Lister method.
	ListerFunc func() v31.SourceCodeRepositoryLister

	// calls tracks calls to the methods.
	calls struct {
		// AddClusterScopedFeatureHandler holds details about calls to the AddClusterScopedFeatureHandler method.
		AddClusterScopedFeatureHandler []struct {
			// Ctx is the ctx argument value.
			Ctx context.Context
			// Enabled is the enabled argument value.
			Enabled func() bool
			// Name is the name argument value.
			Name string
			// ClusterName is the clusterName argument value.
			ClusterName string
			// Handler is the handler argument value.
			Handler v31.SourceCodeRepositoryHandlerFunc
		}
		// AddClusterScopedHandler holds details about calls to the AddClusterScopedHandler method.
		AddClusterScopedHandler []struct {
			// Ctx is the ctx argument value.
			Ctx context.Context
			// Name is the name argument value.
			Name string
			// ClusterName is the clusterName argument value.
			ClusterName string
			// Handler is the handler argument value.
			Handler v31.SourceCodeRepositoryHandlerFunc
		}
		// AddFeatureHandler holds details about calls to the AddFeatureHandler method.
		AddFeatureHandler []struct {
			// Ctx is the ctx argument value.
			Ctx context.Context
			// Enabled is the enabled argument value.
			Enabled func() bool
			// Name is the name argument value.
			Name string
			// Sync is the sync argument value.
			Sync v31.SourceCodeRepositoryHandlerFunc
		}
		// AddHandler holds details about calls to the AddHandler method.
		AddHandler []struct {
			// Ctx is the ctx argument value.
			Ctx context.Context
			// Name is the name argument value.
			Name string
			// Handler is the handler argument value.
			Handler v31.SourceCodeRepositoryHandlerFunc
		}
		// Enqueue holds details about calls to the Enqueue method.
		Enqueue []struct {
			// Namespace is the namespace argument value.
			Namespace string
			// Name is the name argument value.
			Name string
		}
		// EnqueueAfter holds details about calls to the EnqueueAfter method.
		EnqueueAfter []struct {
			// Namespace is the namespace argument value.
			Namespace string
			// Name is the name argument value.
			Name string
			// After is the after argument value.
			After time.Duration
		}
		// Generic holds details about calls to the Generic method.
		Generic []struct {
		}
		// Informer holds details about calls to the Informer method.
		Informer []struct {
		}
		// Lister holds details about calls to the Lister method.
		Lister []struct {
		}
	}
}

// AddClusterScopedFeatureHandler calls AddClusterScopedFeatureHandlerFunc.
func (mock *SourceCodeRepositoryControllerMock) AddClusterScopedFeatureHandler(ctx context.Context, enabled func() bool, name string, clusterName string, handler v31.SourceCodeRepositoryHandlerFunc) {
	if mock.AddClusterScopedFeatureHandlerFunc == nil {
		panic("SourceCodeRepositoryControllerMock.AddClusterScopedFeatureHandlerFunc: method is nil but SourceCodeRepositoryController.AddClusterScopedFeatureHandler was just called")
	}
	callInfo := struct {
		Ctx         context.Context
		Enabled     func() bool
		Name        string
		ClusterName string
		Handler     v31.SourceCodeRepositoryHandlerFunc
	}{
		Ctx:         ctx,
		Enabled:     enabled,
		Name:        name,
		ClusterName: clusterName,
		Handler:     handler,
	}
	lockSourceCodeRepositoryControllerMockAddClusterScopedFeatureHandler.Lock()
	mock.calls.AddClusterScopedFeatureHandler = append(mock.calls.AddClusterScopedFeatureHandler, callInfo)
	lockSourceCodeRepositoryControllerMockAddClusterScopedFeatureHandler.Unlock()
	mock.AddClusterScopedFeatureHandlerFunc(ctx, enabled, name, clusterName, handler)
}

// AddClusterScopedFeatureHandlerCalls gets all the calls that were made to AddClusterScopedFeatureHandler.
// Check the length with:
//     len(mockedSourceCodeRepositoryController.AddClusterScopedFeatureHandlerCalls())
func (mock *SourceCodeRepositoryControllerMock) AddClusterScopedFeatureHandlerCalls() []struct {
	Ctx         context.Context
	Enabled     func() bool
	Name        string
	ClusterName string
	Handler     v31.SourceCodeRepositoryHandlerFunc
} {
	var calls []struct {
		Ctx         context.Context
		Enabled     func() bool
		Name        string
		ClusterName string
		Handler     v31.SourceCodeRepositoryHandlerFunc
	}
	lockSourceCodeRepositoryControllerMockAddClusterScopedFeatureHandler.RLock()
	calls = mock.calls.AddClusterScopedFeatureHandler
	lockSourceCodeRepositoryControllerMockAddClusterScopedFeatureHandler.RUnlock()
	return calls
}

// AddClusterScopedHandler calls AddClusterScopedHandlerFunc.
func (mock *SourceCodeRepositoryControllerMock) AddClusterScopedHandler(ctx context.Context, name string, clusterName string, handler v31.SourceCodeRepositoryHandlerFunc) {
	if mock.AddClusterScopedHandlerFunc == nil {
		panic("SourceCodeRepositoryControllerMock.AddClusterScopedHandlerFunc: method is nil but SourceCodeRepositoryController.AddClusterScopedHandler was just called")
	}
	callInfo := struct {
		Ctx         context.Context
		Name        string
		ClusterName string
		Handler     v31.SourceCodeRepositoryHandlerFunc
	}{
		Ctx:         ctx,
		Name:        name,
		ClusterName: clusterName,
		Handler:     handler,
	}
	lockSourceCodeRepositoryControllerMockAddClusterScopedHandler.Lock()
	mock.calls.AddClusterScopedHandler = append(mock.calls.AddClusterScopedHandler, callInfo)
	lockSourceCodeRepositoryControllerMockAddClusterScopedHandler.Unlock()
	mock.AddClusterScopedHandlerFunc(ctx, name, clusterName, handler)
}

// AddClusterScopedHandlerCalls gets all the calls that were made to AddClusterScopedHandler.
// Check the length with:
//     len(mockedSourceCodeRepositoryController.AddClusterScopedHandlerCalls())
func (mock *SourceCodeRepositoryControllerMock) AddClusterScopedHandlerCalls() []struct {
	Ctx         context.Context
	Name        string
	ClusterName string
	Handler     v31.SourceCodeRepositoryHandlerFunc
} {
	var calls []struct {
		Ctx         context.Context
		Name        string
		ClusterName string
		Handler     v31.SourceCodeRepositoryHandlerFunc
	}
	lockSourceCodeRepositoryControllerMockAddClusterScopedHandler.RLock()
	calls = mock.calls.AddClusterScopedHandler
	lockSourceCodeRepositoryControllerMockAddClusterScopedHandler.RUnlock()
	return calls
}

// AddFeatureHandler calls AddFeatureHandlerFunc.
func (mock *SourceCodeRepositoryControllerMock) AddFeatureHandler(ctx context.Context, enabled func() bool, name string, syncMoqParam v31.SourceCodeRepositoryHandlerFunc) {
	if mock.AddFeatureHandlerFunc == nil {
		panic("SourceCodeRepositoryControllerMock.AddFeatureHandlerFunc: method is nil but SourceCodeRepositoryController.AddFeatureHandler was just called")
	}
	callInfo := struct {
		Ctx     context.Context
		Enabled func() bool
		Name    string
		Sync    v31.SourceCodeRepositoryHandlerFunc
	}{
		Ctx:     ctx,
		Enabled: enabled,
		Name:    name,
		Sync:    syncMoqParam,
	}
	lockSourceCodeRepositoryControllerMockAddFeatureHandler.Lock()
	mock.calls.AddFeatureHandler = append(mock.calls.AddFeatureHandler, callInfo)
	lockSourceCodeRepositoryControllerMockAddFeatureHandler.Unlock()
	mock.AddFeatureHandlerFunc(ctx, enabled, name, syncMoqParam)
}

// AddFeatureHandlerCalls gets all the calls that were made to AddFeatureHandler.
// Check the length with:
//     len(mockedSourceCodeRepositoryController.AddFeatureHandlerCalls())
func (mock *SourceCodeRepositoryControllerMock) AddFeatureHandlerCalls() []struct {
	Ctx     context.Context
	Enabled func() bool
	Name    string
	Sync    v31.SourceCodeRepositoryHandlerFunc
} {
	var calls []struct {
		Ctx     context.Context
		Enabled func() bool
		Name    string
		Sync    v31.SourceCodeRepositoryHandlerFunc
	}
	lockSourceCodeRepositoryControllerMockAddFeatureHandler.RLock()
	calls = mock.calls.AddFeatureHandler
	lockSourceCodeRepositoryControllerMockAddFeatureHandler.RUnlock()
	return calls
}

// AddHandler calls AddHandlerFunc.
func (mock *SourceCodeRepositoryControllerMock) AddHandler(ctx context.Context, name string, handler v31.SourceCodeRepositoryHandlerFunc) {
	if mock.AddHandlerFunc == nil {
		panic("SourceCodeRepositoryControllerMock.AddHandlerFunc: method is nil but SourceCodeRepositoryController.AddHandler was just called")
	}
	callInfo := struct {
		Ctx     context.Context
		Name    string
		Handler v31.SourceCodeRepositoryHandlerFunc
	}{
		Ctx:     ctx,
		Name:    name,
		Handler: handler,
	}
	lockSourceCodeRepositoryControllerMockAddHandler.Lock()
	mock.calls.AddHandler = append(mock.calls.AddHandler, callInfo)
	lockSourceCodeRepositoryControllerMockAddHandler.Unlock()
	mock.AddHandlerFunc(ctx, name, handler)
}

// AddHandlerCalls gets all the calls that were made to AddHandler.
// Check the length with:
//     len(mockedSourceCodeRepositoryController.AddHandlerCalls())
func (mock *SourceCodeRepositoryControllerMock) AddHandlerCalls() []struct {
	Ctx     context.Context
	Name    string
	Handler v31.SourceCodeRepositoryHandlerFunc
} {
	var calls []struct {
		Ctx     context.Context
		Name    string
		Handler v31.SourceCodeRepositoryHandlerFunc
	}
	lockSourceCodeRepositoryControllerMockAddHandler.RLock()
	calls = mock.calls.AddHandler
	lockSourceCodeRepositoryControllerMockAddHandler.RUnlock()
	return calls
}

// Enqueue calls EnqueueFunc.
func (mock *SourceCodeRepositoryControllerMock) Enqueue(namespace string, name string) {
	if mock.EnqueueFunc == nil {
		panic("SourceCodeRepositoryControllerMock.EnqueueFunc: method is nil but SourceCodeRepositoryController.Enqueue was just called")
	}
	callInfo := struct {
		Namespace string
		Name      string
	}{
		Namespace: namespace,
		Name:      name,
	}
	lockSourceCodeRepositoryControllerMockEnqueue.Lock()
	mock.calls.Enqueue = append(mock.calls.Enqueue, callInfo)
	lockSourceCodeRepositoryControllerMockEnqueue.Unlock()
	mock.EnqueueFunc(namespace, name)
}

// EnqueueCalls gets all the calls that were made to Enqueue.
// Check the length with:
//     len(mockedSourceCodeRepositoryController.EnqueueCalls())
func (mock *SourceCodeRepositoryControllerMock) EnqueueCalls() []struct {
	Namespace string
	Name      string
} {
	var calls []struct {
		Namespace string
		Name      string
	}
	lockSourceCodeRepositoryControllerMockEnqueue.RLock()
	calls = mock.calls.Enqueue
	lockSourceCodeRepositoryControllerMockEnqueue.RUnlock()
	return calls
}

// EnqueueAfter calls EnqueueAfterFunc.
func (mock *SourceCodeRepositoryControllerMock) EnqueueAfter(namespace string, name string, after time.Duration) {
	if mock.EnqueueAfterFunc == nil {
		panic("SourceCodeRepositoryControllerMock.EnqueueAfterFunc: method is nil but SourceCodeRepositoryController.EnqueueAfter was just called")
	}
	callInfo := struct {
		Namespace string
		Name      string
		After     time.Duration
	}{
		Namespace: namespace,
		Name:      name,
		After:     after,
	}
	lockSourceCodeRepositoryControllerMockEnqueueAfter.Lock()
	mock.calls.EnqueueAfter = append(mock.calls.EnqueueAfter, callInfo)
	lockSourceCodeRepositoryControllerMockEnqueueAfter.Unlock()
	mock.EnqueueAfterFunc(namespace, name, after)
}

// EnqueueAfterCalls gets all the calls that were made to EnqueueAfter.
// Check the length with:
//     len(mockedSourceCodeRepositoryController.EnqueueAfterCalls())
func (mock *SourceCodeRepositoryControllerMock) EnqueueAfterCalls() []struct {
	Namespace string
	Name      string
	After     time.Duration
} {
	var calls []struct {
		Namespace string
		Name      string
		After     time.Duration
	}
	lockSourceCodeRepositoryControllerMockEnqueueAfter.RLock()
	calls = mock.calls.EnqueueAfter
	lockSourceCodeRepositoryControllerMockEnqueueAfter.RUnlock()
	return calls
}

// Generic calls GenericFunc.
func (mock *SourceCodeRepositoryControllerMock) Generic() controller.GenericController {
	if mock.GenericFunc == nil {
		panic("SourceCodeRepositoryControllerMock.GenericFunc: method is nil but SourceCodeRepositoryController.Generic was just called")
	}
	callInfo := struct {
	}{}
	lockSourceCodeRepositoryControllerMockGeneric.Lock()
	mock.calls.Generic = append(mock.calls.Generic, callInfo)
	lockSourceCodeRepositoryControllerMockGeneric.Unlock()
	return mock.GenericFunc()
}

// GenericCalls gets all the calls that were made to Generic.
// Check the length with:
//     len(mockedSourceCodeRepositoryController.GenericCalls())
func (mock *SourceCodeRepositoryControllerMock) GenericCalls() []struct {
} {
	var calls []struct {
	}
	lockSourceCodeRepositoryControllerMockGeneric.RLock()
	calls = mock.calls.Generic
	lockSourceCodeRepositoryControllerMockGeneric.RUnlock()
	return calls
}

// Informer calls InformerFunc.
func (mock *SourceCodeRepositoryControllerMock) Informer() cache.SharedIndexInformer {
	if mock.InformerFunc == nil {
		panic("SourceCodeRepositoryControllerMock.InformerFunc: method is nil but SourceCodeRepositoryController.Informer was just called")
	}
	callInfo := struct {
	}{}
	lockSourceCodeRepositoryControllerMockInformer.Lock()
	mock.calls.Informer = append(mock.calls.Informer, callInfo)
	lockSourceCodeRepositoryControllerMockInformer.Unlock()
	return mock.InformerFunc()
}

// InformerCalls gets all the calls that were made to Informer.
// Check the length with:
//     len(mockedSourceCodeRepositoryController.InformerCalls())
func (mock *SourceCodeRepositoryControllerMock) InformerCalls() []struct {
} {
	var calls []struct {
	}
	lockSourceCodeRepositoryControllerMockInformer.RLock()
	calls = mock.calls.Informer
	lockSourceCodeRepositoryControllerMockInformer.RUnlock()
	return calls
}

// Lister calls ListerFunc.
func (mock *SourceCodeRepositoryControllerMock) Lister() v31.SourceCodeRepositoryLister {
	if mock.ListerFunc == nil {
		panic("SourceCodeRepositoryControllerMock.ListerFunc: method is nil but SourceCodeRepositoryController.Lister was just called")
	}
	callInfo := struct {
	}{}
	lockSourceCodeRepositoryControllerMockLister.Lock()
	mock.calls.Lister = append(mock.calls.Lister, callInfo)
	lockSourceCodeRepositoryControllerMockLister.Unlock()
	return mock.ListerFunc()
}

// ListerCalls gets all the calls that were made to Lister.
// Check the length with:
//     len(mockedSourceCodeRepositoryController.ListerCalls())
func (mock *SourceCodeRepositoryControllerMock) ListerCalls() []struct {
} {
	var calls []struct {
	}
	lockSourceCodeRepositoryControllerMockLister.RLock()
	calls = mock.calls.Lister
	lockSourceCodeRepositoryControllerMockLister.RUnlock()
	return calls
}

var (
	lockSourceCodeRepositoryInterfaceMockAddClusterScopedFeatureHandler   sync.RWMutex
	lockSourceCodeRepositoryInterfaceMockAddClusterScopedFeatureLifecycle sync.RWMutex
	lockSourceCodeRepositoryInterfaceMockAddClusterScopedHandler          sync.RWMutex
	lockSourceCodeRepositoryInterfaceMockAddClusterScopedLifecycle        sync.RWMutex
	lockSourceCodeRepositoryInterfaceMockAddFeatureHandler                sync.RWMutex
	lockSourceCodeRepositoryInterfaceMockAddFeatureLifecycle              sync.RWMutex
	lockSourceCodeRepositoryInterfaceMockAddHandler                       sync.RWMutex
	lockSourceCodeRepositoryInterfaceMockAddLifecycle                     sync.RWMutex
	lockSourceCodeRepositoryInterfaceMockController                       sync.RWMutex
	lockSourceCodeRepositoryInterfaceMockCreate                           sync.RWMutex
	lockSourceCodeRepositoryInterfaceMockDelete                           sync.RWMutex
	lockSourceCodeRepositoryInterfaceMockDeleteCollection                 sync.RWMutex
	lockSourceCodeRepositoryInterfaceMockDeleteNamespaced                 sync.RWMutex
	lockSourceCodeRepositoryInterfaceMockGet                              sync.RWMutex
	lockSourceCodeRepositoryInterfaceMockGetNamespaced                    sync.RWMutex
	lockSourceCodeRepositoryInterfaceMockList                             sync.RWMutex
	lockSourceCodeRepositoryInterfaceMockListNamespaced                   sync.RWMutex
	lockSourceCodeRepositoryInterfaceMockObjectClient                     sync.RWMutex
	lockSourceCodeRepositoryInterfaceMockUpdate                           sync.RWMutex
	lockSourceCodeRepositoryInterfaceMockWatch                            sync.RWMutex
)

// Ensure, that SourceCodeRepositoryInterfaceMock does implement v31.SourceCodeRepositoryInterface.
// If this is not the case, regenerate this file with moq.
var _ v31.SourceCodeRepositoryInterface = &SourceCodeRepositoryInterfaceMock{}

// SourceCodeRepositoryInterfaceMock is a mock implementation of v31.SourceCodeRepositoryInterface.
//
//     func TestSomethingThatUsesSourceCodeRepositoryInterface(t *testing.T) {
//
//         // make and configure a mocked v31.SourceCodeRepositoryInterface
//         mockedSourceCodeRepositoryInterface := &SourceCodeRepositoryInterfaceMock{
//             AddClusterScopedFeatureHandlerFunc: func(ctx context.Context, enabled func() bool, name string, clusterName string, syncMoqParam v31.SourceCodeRepositoryHandlerFunc)  {
// 	               panic("mock out the AddClusterScopedFeatureHandler method")
//             },
//             AddClusterScopedFeatureLifecycleFunc: func(ctx context.Context, enabled func() bool, name string, clusterName string, lifecycle v31.SourceCodeRepositoryLifecycle)  {
// 	               panic("mock out the AddClusterScopedFeatureLifecycle method")
//             },
//             AddClusterScopedHandlerFunc: func(ctx context.Context, name string, clusterName string, syncMoqParam v31.SourceCodeRepositoryHandlerFunc)  {
// 	               panic("mock out the AddClusterScopedHandler method")
//             },
//             AddClusterScopedLifecycleFunc: func(ctx context.Context, name string, clusterName string, lifecycle v31.SourceCodeRepositoryLifecycle)  {
// 	               panic("mock out the AddClusterScopedLifecycle method")
//             },
//             AddFeatureHandlerFunc: func(ctx context.Context, enabled func() bool, name string, syncMoqParam v31.SourceCodeRepositoryHandlerFunc)  {
// 	               panic("mock out the AddFeatureHandler method")
//             },
//             AddFeatureLifecycleFunc: func(ctx context.Context, enabled func() bool, name string, lifecycle v31.SourceCodeRepositoryLifecycle)  {
// 	               panic("mock out the AddFeatureLifecycle method")
//             },
//             AddHandlerFunc: func(ctx context.Context, name string, syncMoqParam v31.SourceCodeRepositoryHandlerFunc)  {
// 	               panic("mock out the AddHandler method")
//             },
//             AddLifecycleFunc: func(ctx context.Context, name string, lifecycle v31.SourceCodeRepositoryLifecycle)  {
// 	               panic("mock out the AddLifecycle method")
//             },
//             ControllerFunc: func() v31.SourceCodeRepositoryController {
// 	               panic("mock out the Controller method")
//             },
//             CreateFunc: func(in1 *v3.SourceCodeRepository) (*v3.SourceCodeRepository, error) {
// 	               panic("mock out the Create method")
//             },
//             DeleteFunc: func(name string, options *metav1.DeleteOptions) error {
// 	               panic("mock out the Delete method")
//             },
//             DeleteCollectionFunc: func(deleteOpts *metav1.DeleteOptions, listOpts metav1.ListOptions) error {
// 	               panic("mock out the DeleteCollection method")
//             },
//             DeleteNamespacedFunc: func(namespace string, name string, options *metav1.DeleteOptions) error {
// 	               panic("mock out the DeleteNamespaced method")
//             },
//             GetFunc: func(name string, opts metav1.GetOptions) (*v3.SourceCodeRepository, error) {
// 	               panic("mock out the Get method")
//             },
//             GetNamespacedFunc: func(namespace string, name string, opts metav1.GetOptions) (*v3.SourceCodeRepository, error) {
// 	               panic("mock out the GetNamespaced method")
//             },
//             ListFunc: func(opts metav1.ListOptions) (*v3.SourceCodeRepositoryList, error) {
// 	               panic("mock out the List method")
//             },
//             ListNamespacedFunc: func(namespace string, opts metav1.ListOptions) (*v3.SourceCodeRepositoryList, error) {
// 	               panic("mock out the ListNamespaced method")
//             },
//             ObjectClientFunc: func() *objectclient.ObjectClient {
// 	               panic("mock out the ObjectClient method")
//             },
//             UpdateFunc: func(in1 *v3.SourceCodeRepository) (*v3.SourceCodeRepository, error) {
// 	               panic("mock out the Update method")
//             },
//             WatchFunc: func(opts metav1.ListOptions) (watch.Interface, error) {
// 	               panic("mock out the Watch method")
//             },
//         }
//
//         // use mockedSourceCodeRepositoryInterface in code that requires v31.SourceCodeRepositoryInterface
//         // and then make assertions.
//
//     }
type SourceCodeRepositoryInterfaceMock struct {
	// AddClusterScopedFeatureHandlerFunc mocks the AddClusterScopedFeatureHandler method.
	AddClusterScopedFeatureHandlerFunc func(ctx context.Context, enabled func() bool, name string, clusterName string, syncMoqParam v31.SourceCodeRepositoryHandlerFunc)

	// AddClusterScopedFeatureLifecycleFunc mocks the AddClusterScopedFeatureLifecycle method.
	AddClusterScopedFeatureLifecycleFunc func(ctx context.Context, enabled func() bool, name string, clusterName string, lifecycle v31.SourceCodeRepositoryLifecycle)

	// AddClusterScopedHandlerFunc mocks the AddClusterScopedHandler method.
	AddClusterScopedHandlerFunc func(ctx context.Context, name string, clusterName string, syncMoqParam v31.SourceCodeRepositoryHandlerFunc)

	// AddClusterScopedLifecycleFunc mocks the AddClusterScopedLifecycle method.
	AddClusterScopedLifecycleFunc func(ctx context.Context, name string, clusterName string, lifecycle v31.SourceCodeRepositoryLifecycle)

	// AddFeatureHandlerFunc mocks the AddFeatureHandler method.
	AddFeatureHandlerFunc func(ctx context.Context, enabled func() bool, name string, syncMoqParam v31.SourceCodeRepositoryHandlerFunc)

	// AddFeatureLifecycleFunc mocks the AddFeatureLifecycle method.
	AddFeatureLifecycleFunc func(ctx context.Context, enabled func() bool, name string, lifecycle v31.SourceCodeRepositoryLifecycle)

	// AddHandlerFunc mocks the AddHandler method.
	AddHandlerFunc func(ctx context.Context, name string, syncMoqParam v31.SourceCodeRepositoryHandlerFunc)

	// AddLifecycleFunc mocks the AddLifecycle method.
	AddLifecycleFunc func(ctx context.Context, name string, lifecycle v31.SourceCodeRepositoryLifecycle)

	// ControllerFunc mocks the Controller method.
	ControllerFunc func() v31.SourceCodeRepositoryController

	// CreateFunc mocks the Create method.
	CreateFunc func(in1 *v3.SourceCodeRepository) (*v3.SourceCodeRepository, error)

	// DeleteFunc mocks the Delete method.
	DeleteFunc func(name string, options *metav1.DeleteOptions) error

	// DeleteCollectionFunc mocks the DeleteCollection method.
	DeleteCollectionFunc func(deleteOpts *metav1.DeleteOptions, listOpts metav1.ListOptions) error

	// DeleteNamespacedFunc mocks the DeleteNamespaced method.
	DeleteNamespacedFunc func(namespace string, name string, options *metav1.DeleteOptions) error

	// GetFunc mocks the Get method.
	GetFunc func(name string, opts metav1.GetOptions) (*v3.SourceCodeRepository, error)

	// GetNamespacedFunc mocks the GetNamespaced method.
	GetNamespacedFunc func(namespace string, name string, opts metav1.GetOptions) (*v3.SourceCodeRepository, error)

	// ListFunc mocks the List method.
	ListFunc func(opts metav1.ListOptions) (*v3.SourceCodeRepositoryList, error)

	// ListNamespacedFunc mocks the ListNamespaced method.
	ListNamespacedFunc func(namespace string, opts metav1.ListOptions) (*v3.SourceCodeRepositoryList, error)

	// ObjectClientFunc mocks the ObjectClient method.
	ObjectClientFunc func() *objectclient.ObjectClient

	// UpdateFunc mocks the Update method.
	UpdateFunc func(in1 *v3.SourceCodeRepository) (*v3.SourceCodeRepository, error)

	// WatchFunc mocks the Watch method.
	WatchFunc func(opts metav1.ListOptions) (watch.Interface, error)

	// calls tracks calls to the methods.
	calls struct {
		// AddClusterScopedFeatureHandler holds details about calls to the AddClusterScopedFeatureHandler method.
		AddClusterScopedFeatureHandler []struct {
			// Ctx is the ctx argument value.
			Ctx context.Context
			// Enabled is the enabled argument value.
			Enabled func() bool
			// Name is the name argument value.
			Name string
			// ClusterName is the clusterName argument value.
			ClusterName string
			// Sync is the sync argument value.
			Sync v31.SourceCodeRepositoryHandlerFunc
		}
		// AddClusterScopedFeatureLifecycle holds details about calls to the AddClusterScopedFeatureLifecycle method.
		AddClusterScopedFeatureLifecycle []struct {
			// Ctx is the ctx argument value.
			Ctx context.Context
			// Enabled is the enabled argument value.
			Enabled func() bool
			// Name is the name argument value.
			Name string
			// ClusterName is the clusterName argument value.
			ClusterName string
			// Lifecycle is the lifecycle argument value.
			Lifecycle v31.SourceCodeRepositoryLifecycle
		}
		// AddClusterScopedHandler holds details about calls to the AddClusterScopedHandler method.
		AddClusterScopedHandler []struct {
			// Ctx is the ctx argument value.
			Ctx context.Context
			// Name is the name argument value.
			Name string
			// ClusterName is the clusterName argument value.
			ClusterName string
			// Sync is the sync argument value.
			Sync v31.SourceCodeRepositoryHandlerFunc
		}
		// AddClusterScopedLifecycle holds details about calls to the AddClusterScopedLifecycle method.
		AddClusterScopedLifecycle []struct {
			// Ctx is the ctx argument value.
			Ctx context.Context
			// Name is the name argument value.
			Name string
			// ClusterName is the clusterName argument value.
			ClusterName string
			// Lifecycle is the lifecycle argument value.
			Lifecycle v31.SourceCodeRepositoryLifecycle
		}
		// AddFeatureHandler holds details about calls to the AddFeatureHandler method.
		AddFeatureHandler []struct {
			// Ctx is the ctx argument value.
			Ctx context.Context
			// Enabled is the enabled argument value.
			Enabled func() bool
			// Name is the name argument value.
			Name string
			// Sync is the sync argument value.
			Sync v31.SourceCodeRepositoryHandlerFunc
		}
		// AddFeatureLifecycle holds details about calls to the AddFeatureLifecycle method.
		AddFeatureLifecycle []struct {
			// Ctx is the ctx argument value.
			Ctx context.Context
			// Enabled is the enabled argument value.
			Enabled func() bool
			// Name is the name argument value.
			Name string
			// Lifecycle is the lifecycle argument value.
			Lifecycle v31.SourceCodeRepositoryLifecycle
		}
		// AddHandler holds details about calls to the AddHandler method.
		AddHandler []struct {
			// Ctx is the ctx argument value.
			Ctx context.Context
			// Name is the name argument value.
			Name string
			// Sync is the sync argument value.
			Sync v31.SourceCodeRepositoryHandlerFunc
		}
		// AddLifecycle holds details about calls to the AddLifecycle method.
		AddLifecycle []struct {
			// Ctx is the ctx argument value.
			Ctx context.Context
			// Name is the name argument value.
			Name string
			// Lifecycle is the lifecycle argument value.
			Lifecycle v31.SourceCodeRepositoryLifecycle
		}
		// Controller holds details about calls to the Controller method.
		Controller []struct {
		}
		// Create holds details about calls to the Create method.
		Create []struct {
			// In1 is the in1 argument value.
			In1 *v3.SourceCodeRepository
		}
		// Delete holds details about calls to the Delete method.
		Delete []struct {
			// Name is the name argument value.
			Name string
			// Options is the options argument value.
			Options *metav1.DeleteOptions
		}
		// DeleteCollection holds details about calls to the DeleteCollection method.
		DeleteCollection []struct {
			// DeleteOpts is the deleteOpts argument value.
			DeleteOpts *metav1.DeleteOptions
			// ListOpts is the listOpts argument value.
			ListOpts metav1.ListOptions
		}
		// DeleteNamespaced holds details about calls to the DeleteNamespaced method.
		DeleteNamespaced []struct {
			// Namespace is the namespace argument value.
			Namespace string
			// Name is the name argument value.
			Name string
			// Options is the options argument value.
			Options *metav1.DeleteOptions
		}
		// Get holds details about calls to the Get method.
		Get []struct {
			// Name is the name argument value.
			Name string
			// Opts is the opts argument value.
			Opts metav1.GetOptions
		}
		// GetNamespaced holds details about calls to the GetNamespaced method.
		GetNamespaced []struct {
			// Namespace is the namespace argument value.
			Namespace string
			// Name is the name argument value.
			Name string
			// Opts is the opts argument value.
			Opts metav1.GetOptions
		}
		// List holds details about calls to the List method.
		List []struct {
			// Opts is the opts argument value.
			Opts metav1.ListOptions
		}
		// ListNamespaced holds details about calls to the ListNamespaced method.
		ListNamespaced []struct {
			// Namespace is the namespace argument value.
			Namespace string
			// Opts is the opts argument value.
			Opts metav1.ListOptions
		}
		// ObjectClient holds details about calls to the ObjectClient method.
		ObjectClient []struct {
		}
		// Update holds details about calls to the Update method.
		Update []struct {
			// In1 is the in1 argument value.
			In1 *v3.SourceCodeRepository
		}
		// Watch holds details about calls to the Watch method.
		Watch []struct {
			// Opts is the opts argument value.
			Opts metav1.ListOptions
		}
	}
}

// AddClusterScopedFeatureHandler calls AddClusterScopedFeatureHandlerFunc.
func (mock *SourceCodeRepositoryInterfaceMock) AddClusterScopedFeatureHandler(ctx context.Context, enabled func() bool, name string, clusterName string, syncMoqParam v31.SourceCodeRepositoryHandlerFunc) {
	if mock.AddClusterScopedFeatureHandlerFunc == nil {
		panic("SourceCodeRepositoryInterfaceMock.AddClusterScopedFeatureHandlerFunc: method is nil but SourceCodeRepositoryInterface.AddClusterScopedFeatureHandler was just called")
	}
	callInfo := struct {
		Ctx         context.Context
		Enabled     func() bool
		Name        string
		ClusterName string
		Sync        v31.SourceCodeRepositoryHandlerFunc
	}{
		Ctx:         ctx,
		Enabled:     enabled,
		Name:        name,
		ClusterName: clusterName,
		Sync:        syncMoqParam,
	}
	lockSourceCodeRepositoryInterfaceMockAddClusterScopedFeatureHandler.Lock()
	mock.calls.AddClusterScopedFeatureHandler = append(mock.calls.AddClusterScopedFeatureHandler, callInfo)
	lockSourceCodeRepositoryInterfaceMockAddClusterScopedFeatureHandler.Unlock()
	mock.AddClusterScopedFeatureHandlerFunc(ctx, enabled, name, clusterName, syncMoqParam)
}

// AddClusterScopedFeatureHandlerCalls gets all the calls that were made to AddClusterScopedFeatureHandler.
// Check the length with:
//     len(mockedSourceCodeRepositoryInterface.AddClusterScopedFeatureHandlerCalls())
func (mock *SourceCodeRepositoryInterfaceMock) AddClusterScopedFeatureHandlerCalls() []struct {
	Ctx         context.Context
	Enabled     func() bool
	Name        string
	ClusterName string
	Sync        v31.SourceCodeRepositoryHandlerFunc
} {
	var calls []struct {
		Ctx         context.Context
		Enabled     func() bool
		Name        string
		ClusterName string
		Sync        v31.SourceCodeRepositoryHandlerFunc
	}
	lockSourceCodeRepositoryInterfaceMockAddClusterScopedFeatureHandler.RLock()
	calls = mock.calls.AddClusterScopedFeatureHandler
	lockSourceCodeRepositoryInterfaceMockAddClusterScopedFeatureHandler.RUnlock()
	return calls
}

// AddClusterScopedFeatureLifecycle calls AddClusterScopedFeatureLifecycleFunc.
func (mock *SourceCodeRepositoryInterfaceMock) AddClusterScopedFeatureLifecycle(ctx context.Context, enabled func() bool, name string, clusterName string, lifecycle v31.SourceCodeRepositoryLifecycle) {
	if mock.AddClusterScopedFeatureLifecycleFunc == nil {
		panic("SourceCodeRepositoryInterfaceMock.AddClusterScopedFeatureLifecycleFunc: method is nil but SourceCodeRepositoryInterface.AddClusterScopedFeatureLifecycle was just called")
	}
	callInfo := struct {
		Ctx         context.Context
		Enabled     func() bool
		Name        string
		ClusterName string
		Lifecycle   v31.SourceCodeRepositoryLifecycle
	}{
		Ctx:         ctx,
		Enabled:     enabled,
		Name:        name,
		ClusterName: clusterName,
		Lifecycle:   lifecycle,
	}
	lockSourceCodeRepositoryInterfaceMockAddClusterScopedFeatureLifecycle.Lock()
	mock.calls.AddClusterScopedFeatureLifecycle = append(mock.calls.AddClusterScopedFeatureLifecycle, callInfo)
	lockSourceCodeRepositoryInterfaceMockAddClusterScopedFeatureLifecycle.Unlock()
	mock.AddClusterScopedFeatureLifecycleFunc(ctx, enabled, name, clusterName, lifecycle)
}

// AddClusterScopedFeatureLifecycleCalls gets all the calls that were made to AddClusterScopedFeatureLifecycle.
// Check the length with:
//     len(mockedSourceCodeRepositoryInterface.AddClusterScopedFeatureLifecycleCalls())
func (mock *SourceCodeRepositoryInterfaceMock) AddClusterScopedFeatureLifecycleCalls() []struct {
	Ctx         context.Context
	Enabled     func() bool
	Name        string
	ClusterName string
	Lifecycle   v31.SourceCodeRepositoryLifecycle
} {
	var calls []struct {
		Ctx         context.Context
		Enabled     func() bool
		Name        string
		ClusterName string
		Lifecycle   v31.SourceCodeRepositoryLifecycle
	}
	lockSourceCodeRepositoryInterfaceMockAddClusterScopedFeatureLifecycle.RLock()
	calls = mock.calls.AddClusterScopedFeatureLifecycle
	lockSourceCodeRepositoryInterfaceMockAddClusterScopedFeatureLifecycle.RUnlock()
	return calls
}

// AddClusterScopedHandler calls AddClusterScopedHandlerFunc.
func (mock *SourceCodeRepositoryInterfaceMock) AddClusterScopedHandler(ctx context.Context, name string, clusterName string, syncMoqParam v31.SourceCodeRepositoryHandlerFunc) {
	if mock.AddClusterScopedHandlerFunc == nil {
		panic("SourceCodeRepositoryInterfaceMock.AddClusterScopedHandlerFunc: method is nil but SourceCodeRepositoryInterface.AddClusterScopedHandler was just called")
	}
	callInfo := struct {
		Ctx         context.Context
		Name        string
		ClusterName string
		Sync        v31.SourceCodeRepositoryHandlerFunc
	}{
		Ctx:         ctx,
		Name:        name,
		ClusterName: clusterName,
		Sync:        syncMoqParam,
	}
	lockSourceCodeRepositoryInterfaceMockAddClusterScopedHandler.Lock()
	mock.calls.AddClusterScopedHandler = append(mock.calls.AddClusterScopedHandler, callInfo)
	lockSourceCodeRepositoryInterfaceMockAddClusterScopedHandler.Unlock()
	mock.AddClusterScopedHandlerFunc(ctx, name, clusterName, syncMoqParam)
}

// AddClusterScopedHandlerCalls gets all the calls that were made to AddClusterScopedHandler.
// Check the length with:
//     len(mockedSourceCodeRepositoryInterface.AddClusterScopedHandlerCalls())
func (mock *SourceCodeRepositoryInterfaceMock) AddClusterScopedHandlerCalls() []struct {
	Ctx         context.Context
	Name        string
	ClusterName string
	Sync        v31.SourceCodeRepositoryHandlerFunc
} {
	var calls []struct {
		Ctx         context.Context
		Name        string
		ClusterName string
		Sync        v31.SourceCodeRepositoryHandlerFunc
	}
	lockSourceCodeRepositoryInterfaceMockAddClusterScopedHandler.RLock()
	calls = mock.calls.AddClusterScopedHandler
	lockSourceCodeRepositoryInterfaceMockAddClusterScopedHandler.RUnlock()
	return calls
}

// AddClusterScopedLifecycle calls AddClusterScopedLifecycleFunc.
func (mock *SourceCodeRepositoryInterfaceMock) AddClusterScopedLifecycle(ctx context.Context, name string, clusterName string, lifecycle v31.SourceCodeRepositoryLifecycle) {
	if mock.AddClusterScopedLifecycleFunc == nil {
		panic("SourceCodeRepositoryInterfaceMock.AddClusterScopedLifecycleFunc: method is nil but SourceCodeRepositoryInterface.AddClusterScopedLifecycle was just called")
	}
	callInfo := struct {
		Ctx         context.Context
		Name        string
		ClusterName string
		Lifecycle   v31.SourceCodeRepositoryLifecycle
	}{
		Ctx:         ctx,
		Name:        name,
		ClusterName: clusterName,
		Lifecycle:   lifecycle,
	}
	lockSourceCodeRepositoryInterfaceMockAddClusterScopedLifecycle.Lock()
	mock.calls.AddClusterScopedLifecycle = append(mock.calls.AddClusterScopedLifecycle, callInfo)
	lockSourceCodeRepositoryInterfaceMockAddClusterScopedLifecycle.Unlock()
	mock.AddClusterScopedLifecycleFunc(ctx, name, clusterName, lifecycle)
}

// AddClusterScopedLifecycleCalls gets all the calls that were made to AddClusterScopedLifecycle.
// Check the length with:
//     len(mockedSourceCodeRepositoryInterface.AddClusterScopedLifecycleCalls())
func (mock *SourceCodeRepositoryInterfaceMock) AddClusterScopedLifecycleCalls() []struct {
	Ctx         context.Context
	Name        string
	ClusterName string
	Lifecycle   v31.SourceCodeRepositoryLifecycle
} {
	var calls []struct {
		Ctx         context.Context
		Name        string
		ClusterName string
		Lifecycle   v31.SourceCodeRepositoryLifecycle
	}
	lockSourceCodeRepositoryInterfaceMockAddClusterScopedLifecycle.RLock()
	calls = mock.calls.AddClusterScopedLifecycle
	lockSourceCodeRepositoryInterfaceMockAddClusterScopedLifecycle.RUnlock()
	return calls
}

// AddFeatureHandler calls AddFeatureHandlerFunc.
func (mock *SourceCodeRepositoryInterfaceMock) AddFeatureHandler(ctx context.Context, enabled func() bool, name string, syncMoqParam v31.SourceCodeRepositoryHandlerFunc) {
	if mock.AddFeatureHandlerFunc == nil {
		panic("SourceCodeRepositoryInterfaceMock.AddFeatureHandlerFunc: method is nil but SourceCodeRepositoryInterface.AddFeatureHandler was just called")
	}
	callInfo := struct {
		Ctx     context.Context
		Enabled func() bool
		Name    string
		Sync    v31.SourceCodeRepositoryHandlerFunc
	}{
		Ctx:     ctx,
		Enabled: enabled,
		Name:    name,
		Sync:    syncMoqParam,
	}
	lockSourceCodeRepositoryInterfaceMockAddFeatureHandler.Lock()
	mock.calls.AddFeatureHandler = append(mock.calls.AddFeatureHandler, callInfo)
	lockSourceCodeRepositoryInterfaceMockAddFeatureHandler.Unlock()
	mock.AddFeatureHandlerFunc(ctx, enabled, name, syncMoqParam)
}

// AddFeatureHandlerCalls gets all the calls that were made to AddFeatureHandler.
// Check the length with:
//     len(mockedSourceCodeRepositoryInterface.AddFeatureHandlerCalls())
func (mock *SourceCodeRepositoryInterfaceMock) AddFeatureHandlerCalls() []struct {
	Ctx     context.Context
	Enabled func() bool
	Name    string
	Sync    v31.SourceCodeRepositoryHandlerFunc
} {
	var calls []struct {
		Ctx     context.Context
		Enabled func() bool
		Name    string
		Sync    v31.SourceCodeRepositoryHandlerFunc
	}
	lockSourceCodeRepositoryInterfaceMockAddFeatureHandler.RLock()
	calls = mock.calls.AddFeatureHandler
	lockSourceCodeRepositoryInterfaceMockAddFeatureHandler.RUnlock()
	return calls
}

// AddFeatureLifecycle calls AddFeatureLifecycleFunc.
func (mock *SourceCodeRepositoryInterfaceMock) AddFeatureLifecycle(ctx context.Context, enabled func() bool, name string, lifecycle v31.SourceCodeRepositoryLifecycle) {
	if mock.AddFeatureLifecycleFunc == nil {
		panic("SourceCodeRepositoryInterfaceMock.AddFeatureLifecycleFunc: method is nil but SourceCodeRepositoryInterface.AddFeatureLifecycle was just called")
	}
	callInfo := struct {
		Ctx       context.Context
		Enabled   func() bool
		Name      string
		Lifecycle v31.SourceCodeRepositoryLifecycle
	}{
		Ctx:       ctx,
		Enabled:   enabled,
		Name:      name,
		Lifecycle: lifecycle,
	}
	lockSourceCodeRepositoryInterfaceMockAddFeatureLifecycle.Lock()
	mock.calls.AddFeatureLifecycle = append(mock.calls.AddFeatureLifecycle, callInfo)
	lockSourceCodeRepositoryInterfaceMockAddFeatureLifecycle.Unlock()
	mock.AddFeatureLifecycleFunc(ctx, enabled, name, lifecycle)
}

// AddFeatureLifecycleCalls gets all the calls that were made to AddFeatureLifecycle.
// Check the length with:
//     len(mockedSourceCodeRepositoryInterface.AddFeatureLifecycleCalls())
func (mock *SourceCodeRepositoryInterfaceMock) AddFeatureLifecycleCalls() []struct {
	Ctx       context.Context
	Enabled   func() bool
	Name      string
	Lifecycle v31.SourceCodeRepositoryLifecycle
} {
	var calls []struct {
		Ctx       context.Context
		Enabled   func() bool
		Name      string
		Lifecycle v31.SourceCodeRepositoryLifecycle
	}
	lockSourceCodeRepositoryInterfaceMockAddFeatureLifecycle.RLock()
	calls = mock.calls.AddFeatureLifecycle
	lockSourceCodeRepositoryInterfaceMockAddFeatureLifecycle.RUnlock()
	return calls
}

// AddHandler calls AddHandlerFunc.
func (mock *SourceCodeRepositoryInterfaceMock) AddHandler(ctx context.Context, name string, syncMoqParam v31.SourceCodeRepositoryHandlerFunc) {
	if mock.AddHandlerFunc == nil {
		panic("SourceCodeRepositoryInterfaceMock.AddHandlerFunc: method is nil but SourceCodeRepositoryInterface.AddHandler was just called")
	}
	callInfo := struct {
		Ctx  context.Context
		Name string
		Sync v31.SourceCodeRepositoryHandlerFunc
	}{
		Ctx:  ctx,
		Name: name,
		Sync: syncMoqParam,
	}
	lockSourceCodeRepositoryInterfaceMockAddHandler.Lock()
	mock.calls.AddHandler = append(mock.calls.AddHandler, callInfo)
	lockSourceCodeRepositoryInterfaceMockAddHandler.Unlock()
	mock.AddHandlerFunc(ctx, name, syncMoqParam)
}

// AddHandlerCalls gets all the calls that were made to AddHandler.
// Check the length with:
//     len(mockedSourceCodeRepositoryInterface.AddHandlerCalls())
func (mock *SourceCodeRepositoryInterfaceMock) AddHandlerCalls() []struct {
	Ctx  context.Context
	Name string
	Sync v31.SourceCodeRepositoryHandlerFunc
} {
	var calls []struct {
		Ctx  context.Context
		Name string
		Sync v31.SourceCodeRepositoryHandlerFunc
	}
	lockSourceCodeRepositoryInterfaceMockAddHandler.RLock()
	calls = mock.calls.AddHandler
	lockSourceCodeRepositoryInterfaceMockAddHandler.RUnlock()
	return calls
}

// AddLifecycle calls AddLifecycleFunc.
func (mock *SourceCodeRepositoryInterfaceMock) AddLifecycle(ctx context.Context, name string, lifecycle v31.SourceCodeRepositoryLifecycle) {
	if mock.AddLifecycleFunc == nil {
		panic("SourceCodeRepositoryInterfaceMock.AddLifecycleFunc: method is nil but SourceCodeRepositoryInterface.AddLifecycle was just called")
	}
	callInfo := struct {
		Ctx       context.Context
		Name      string
		Lifecycle v31.SourceCodeRepositoryLifecycle
	}{
		Ctx:       ctx,
		Name:      name,
		Lifecycle: lifecycle,
	}
	lockSourceCodeRepositoryInterfaceMockAddLifecycle.Lock()
	mock.calls.AddLifecycle = append(mock.calls.AddLifecycle, callInfo)
	lockSourceCodeRepositoryInterfaceMockAddLifecycle.Unlock()
	mock.AddLifecycleFunc(ctx, name, lifecycle)
}

// AddLifecycleCalls gets all the calls that were made to AddLifecycle.
// Check the length with:
//     len(mockedSourceCodeRepositoryInterface.AddLifecycleCalls())
func (mock *SourceCodeRepositoryInterfaceMock) AddLifecycleCalls() []struct {
	Ctx       context.Context
	Name      string
	Lifecycle v31.SourceCodeRepositoryLifecycle
} {
	var calls []struct {
		Ctx       context.Context
		Name      string
		Lifecycle v31.SourceCodeRepositoryLifecycle
	}
	lockSourceCodeRepositoryInterfaceMockAddLifecycle.RLock()
	calls = mock.calls.AddLifecycle
	lockSourceCodeRepositoryInterfaceMockAddLifecycle.RUnlock()
	return calls
}

// Controller calls ControllerFunc.
func (mock *SourceCodeRepositoryInterfaceMock) Controller() v31.SourceCodeRepositoryController {
	if mock.ControllerFunc == nil {
		panic("SourceCodeRepositoryInterfaceMock.ControllerFunc: method is nil but SourceCodeRepositoryInterface.Controller was just called")
	}
	callInfo := struct {
	}{}
	lockSourceCodeRepositoryInterfaceMockController.Lock()
	mock.calls.Controller = append(mock.calls.Controller, callInfo)
	lockSourceCodeRepositoryInterfaceMockController.Unlock()
	return mock.ControllerFunc()
}

// ControllerCalls gets all the calls that were made to Controller.
// Check the length with:
//     len(mockedSourceCodeRepositoryInterface.ControllerCalls())
func (mock *SourceCodeRepositoryInterfaceMock) ControllerCalls() []struct {
} {
	var calls []struct {
	}
	lockSourceCodeRepositoryInterfaceMockController.RLock()
	calls = mock.calls.Controller
	lockSourceCodeRepositoryInterfaceMockController.RUnlock()
	return calls
}

// Create calls CreateFunc.
func (mock *SourceCodeRepositoryInterfaceMock) Create(in1 *v3.SourceCodeRepository) (*v3.SourceCodeRepository, error) {
	if mock.CreateFunc == nil {
		panic("SourceCodeRepositoryInterfaceMock.CreateFunc: method is nil but SourceCodeRepositoryInterface.Create was just called")
	}
	callInfo := struct {
		In1 *v3.SourceCodeRepository
	}{
		In1: in1,
	}
	lockSourceCodeRepositoryInterfaceMockCreate.Lock()
	mock.calls.Create = append(mock.calls.Create, callInfo)
	lockSourceCodeRepositoryInterfaceMockCreate.Unlock()
	return mock.CreateFunc(in1)
}

// CreateCalls gets all the calls that were made to Create.
// Check the length with:
//     len(mockedSourceCodeRepositoryInterface.CreateCalls())
func (mock *SourceCodeRepositoryInterfaceMock) CreateCalls() []struct {
	In1 *v3.SourceCodeRepository
} {
	var calls []struct {
		In1 *v3.SourceCodeRepository
	}
	lockSourceCodeRepositoryInterfaceMockCreate.RLock()
	calls = mock.calls.Create
	lockSourceCodeRepositoryInterfaceMockCreate.RUnlock()
	return calls
}

// Delete calls DeleteFunc.
func (mock *SourceCodeRepositoryInterfaceMock) Delete(name string, options *metav1.DeleteOptions) error {
	if mock.DeleteFunc == nil {
		panic("SourceCodeRepositoryInterfaceMock.DeleteFunc: method is nil but SourceCodeRepositoryInterface.Delete was just called")
	}
	callInfo := struct {
		Name    string
		Options *metav1.DeleteOptions
	}{
		Name:    name,
		Options: options,
	}
	lockSourceCodeRepositoryInterfaceMockDelete.Lock()
	mock.calls.Delete = append(mock.calls.Delete, callInfo)
	lockSourceCodeRepositoryInterfaceMockDelete.Unlock()
	return mock.DeleteFunc(name, options)
}

// DeleteCalls gets all the calls that were made to Delete.
// Check the length with:
//     len(mockedSourceCodeRepositoryInterface.DeleteCalls())
func (mock *SourceCodeRepositoryInterfaceMock) DeleteCalls() []struct {
	Name    string
	Options *metav1.DeleteOptions
} {
	var calls []struct {
		Name    string
		Options *metav1.DeleteOptions
	}
	lockSourceCodeRepositoryInterfaceMockDelete.RLock()
	calls = mock.calls.Delete
	lockSourceCodeRepositoryInterfaceMockDelete.RUnlock()
	return calls
}

// DeleteCollection calls DeleteCollectionFunc.
func (mock *SourceCodeRepositoryInterfaceMock) DeleteCollection(deleteOpts *metav1.DeleteOptions, listOpts metav1.ListOptions) error {
	if mock.DeleteCollectionFunc == nil {
		panic("SourceCodeRepositoryInterfaceMock.DeleteCollectionFunc: method is nil but SourceCodeRepositoryInterface.DeleteCollection was just called")
	}
	callInfo := struct {
		DeleteOpts *metav1.DeleteOptions
		ListOpts   metav1.ListOptions
	}{
		DeleteOpts: deleteOpts,
		ListOpts:   listOpts,
	}
	lockSourceCodeRepositoryInterfaceMockDeleteCollection.Lock()
	mock.calls.DeleteCollection = append(mock.calls.DeleteCollection, callInfo)
	lockSourceCodeRepositoryInterfaceMockDeleteCollection.Unlock()
	return mock.DeleteCollectionFunc(deleteOpts, listOpts)
}

// DeleteCollectionCalls gets all the calls that were made to DeleteCollection.
// Check the length with:
//     len(mockedSourceCodeRepositoryInterface.DeleteCollectionCalls())
func (mock *SourceCodeRepositoryInterfaceMock) DeleteCollectionCalls() []struct {
	DeleteOpts *metav1.DeleteOptions
	ListOpts   metav1.ListOptions
} {
	var calls []struct {
		DeleteOpts *metav1.DeleteOptions
		ListOpts   metav1.ListOptions
	}
	lockSourceCodeRepositoryInterfaceMockDeleteCollection.RLock()
	calls = mock.calls.DeleteCollection
	lockSourceCodeRepositoryInterfaceMockDeleteCollection.RUnlock()
	return calls
}

// DeleteNamespaced calls DeleteNamespacedFunc.
func (mock *SourceCodeRepositoryInterfaceMock) DeleteNamespaced(namespace string, name string, options *metav1.DeleteOptions) error {
	if mock.DeleteNamespacedFunc == nil {
		panic("SourceCodeRepositoryInterfaceMock.DeleteNamespacedFunc: method is nil but SourceCodeRepositoryInterface.DeleteNamespaced was just called")
	}
	callInfo := struct {
		Namespace string
		Name      string
		Options   *metav1.DeleteOptions
	}{
		Namespace: namespace,
		Name:      name,
		Options:   options,
	}
	lockSourceCodeRepositoryInterfaceMockDeleteNamespaced.Lock()
	mock.calls.DeleteNamespaced = append(mock.calls.DeleteNamespaced, callInfo)
	lockSourceCodeRepositoryInterfaceMockDeleteNamespaced.Unlock()
	return mock.DeleteNamespacedFunc(namespace, name, options)
}

// DeleteNamespacedCalls gets all the calls that were made to DeleteNamespaced.
// Check the length with:
//     len(mockedSourceCodeRepositoryInterface.DeleteNamespacedCalls())
func (mock *SourceCodeRepositoryInterfaceMock) DeleteNamespacedCalls() []struct {
	Namespace string
	Name      string
	Options   *metav1.DeleteOptions
} {
	var calls []struct {
		Namespace string
		Name      string
		Options   *metav1.DeleteOptions
	}
	lockSourceCodeRepositoryInterfaceMockDeleteNamespaced.RLock()
	calls = mock.calls.DeleteNamespaced
	lockSourceCodeRepositoryInterfaceMockDeleteNamespaced.RUnlock()
	return calls
}

// Get calls GetFunc.
func (mock *SourceCodeRepositoryInterfaceMock) Get(name string, opts metav1.GetOptions) (*v3.SourceCodeRepository, error) {
	if mock.GetFunc == nil {
		panic("SourceCodeRepositoryInterfaceMock.GetFunc: method is nil but SourceCodeRepositoryInterface.Get was just called")
	}
	callInfo := struct {
		Name string
		Opts metav1.GetOptions
	}{
		Name: name,
		Opts: opts,
	}
	lockSourceCodeRepositoryInterfaceMockGet.Lock()
	mock.calls.Get = append(mock.calls.Get, callInfo)
	lockSourceCodeRepositoryInterfaceMockGet.Unlock()
	return mock.GetFunc(name, opts)
}

// GetCalls gets all the calls that were made to Get.
// Check the length with:
//     len(mockedSourceCodeRepositoryInterface.GetCalls())
func (mock *SourceCodeRepositoryInterfaceMock) GetCalls() []struct {
	Name string
	Opts metav1.GetOptions
} {
	var calls []struct {
		Name string
		Opts metav1.GetOptions
	}
	lockSourceCodeRepositoryInterfaceMockGet.RLock()
	calls = mock.calls.Get
	lockSourceCodeRepositoryInterfaceMockGet.RUnlock()
	return calls
}

// GetNamespaced calls GetNamespacedFunc.
func (mock *SourceCodeRepositoryInterfaceMock) GetNamespaced(namespace string, name string, opts metav1.GetOptions) (*v3.SourceCodeRepository, error) {
	if mock.GetNamespacedFunc == nil {
		panic("SourceCodeRepositoryInterfaceMock.GetNamespacedFunc: method is nil but SourceCodeRepositoryInterface.GetNamespaced was just called")
	}
	callInfo := struct {
		Namespace string
		Name      string
		Opts      metav1.GetOptions
	}{
		Namespace: namespace,
		Name:      name,
		Opts:      opts,
	}
	lockSourceCodeRepositoryInterfaceMockGetNamespaced.Lock()
	mock.calls.GetNamespaced = append(mock.calls.GetNamespaced, callInfo)
	lockSourceCodeRepositoryInterfaceMockGetNamespaced.Unlock()
	return mock.GetNamespacedFunc(namespace, name, opts)
}

// GetNamespacedCalls gets all the calls that were made to GetNamespaced.
// Check the length with:
//     len(mockedSourceCodeRepositoryInterface.GetNamespacedCalls())
func (mock *SourceCodeRepositoryInterfaceMock) GetNamespacedCalls() []struct {
	Namespace string
	Name      string
	Opts      metav1.GetOptions
} {
	var calls []struct {
		Namespace string
		Name      string
		Opts      metav1.GetOptions
	}
	lockSourceCodeRepositoryInterfaceMockGetNamespaced.RLock()
	calls = mock.calls.GetNamespaced
	lockSourceCodeRepositoryInterfaceMockGetNamespaced.RUnlock()
	return calls
}

// List calls ListFunc.
func (mock *SourceCodeRepositoryInterfaceMock) List(opts metav1.ListOptions) (*v3.SourceCodeRepositoryList, error) {
	if mock.ListFunc == nil {
		panic("SourceCodeRepositoryInterfaceMock.ListFunc: method is nil but SourceCodeRepositoryInterface.List was just called")
	}
	callInfo := struct {
		Opts metav1.ListOptions
	}{
		Opts: opts,
	}
	lockSourceCodeRepositoryInterfaceMockList.Lock()
	mock.calls.List = append(mock.calls.List, callInfo)
	lockSourceCodeRepositoryInterfaceMockList.Unlock()
	return mock.ListFunc(opts)
}

// ListCalls gets all the calls that were made to List.
// Check the length with:
//     len(mockedSourceCodeRepositoryInterface.ListCalls())
func (mock *SourceCodeRepositoryInterfaceMock) ListCalls() []struct {
	Opts metav1.ListOptions
} {
	var calls []struct {
		Opts metav1.ListOptions
	}
	lockSourceCodeRepositoryInterfaceMockList.RLock()
	calls = mock.calls.List
	lockSourceCodeRepositoryInterfaceMockList.RUnlock()
	return calls
}

// ListNamespaced calls ListNamespacedFunc.
func (mock *SourceCodeRepositoryInterfaceMock) ListNamespaced(namespace string, opts metav1.ListOptions) (*v3.SourceCodeRepositoryList, error) {
	if mock.ListNamespacedFunc == nil {
		panic("SourceCodeRepositoryInterfaceMock.ListNamespacedFunc: method is nil but SourceCodeRepositoryInterface.ListNamespaced was just called")
	}
	callInfo := struct {
		Namespace string
		Opts      metav1.ListOptions
	}{
		Namespace: namespace,
		Opts:      opts,
	}
	lockSourceCodeRepositoryInterfaceMockListNamespaced.Lock()
	mock.calls.ListNamespaced = append(mock.calls.ListNamespaced, callInfo)
	lockSourceCodeRepositoryInterfaceMockListNamespaced.Unlock()
	return mock.ListNamespacedFunc(namespace, opts)
}

// ListNamespacedCalls gets all the calls that were made to ListNamespaced.
// Check the length with:
//     len(mockedSourceCodeRepositoryInterface.ListNamespacedCalls())
func (mock *SourceCodeRepositoryInterfaceMock) ListNamespacedCalls() []struct {
	Namespace string
	Opts      metav1.ListOptions
} {
	var calls []struct {
		Namespace string
		Opts      metav1.ListOptions
	}
	lockSourceCodeRepositoryInterfaceMockListNamespaced.RLock()
	calls = mock.calls.ListNamespaced
	lockSourceCodeRepositoryInterfaceMockListNamespaced.RUnlock()
	return calls
}

// ObjectClient calls ObjectClientFunc.
func (mock *SourceCodeRepositoryInterfaceMock) ObjectClient() *objectclient.ObjectClient {
	if mock.ObjectClientFunc == nil {
		panic("SourceCodeRepositoryInterfaceMock.ObjectClientFunc: method is nil but SourceCodeRepositoryInterface.ObjectClient was just called")
	}
	callInfo := struct {
	}{}
	lockSourceCodeRepositoryInterfaceMockObjectClient.Lock()
	mock.calls.ObjectClient = append(mock.calls.ObjectClient, callInfo)
	lockSourceCodeRepositoryInterfaceMockObjectClient.Unlock()
	return mock.ObjectClientFunc()
}

// ObjectClientCalls gets all the calls that were made to ObjectClient.
// Check the length with:
//     len(mockedSourceCodeRepositoryInterface.ObjectClientCalls())
func (mock *SourceCodeRepositoryInterfaceMock) ObjectClientCalls() []struct {
} {
	var calls []struct {
	}
	lockSourceCodeRepositoryInterfaceMockObjectClient.RLock()
	calls = mock.calls.ObjectClient
	lockSourceCodeRepositoryInterfaceMockObjectClient.RUnlock()
	return calls
}

// Update calls UpdateFunc.
func (mock *SourceCodeRepositoryInterfaceMock) Update(in1 *v3.SourceCodeRepository) (*v3.SourceCodeRepository, error) {
	if mock.UpdateFunc == nil {
		panic("SourceCodeRepositoryInterfaceMock.UpdateFunc: method is nil but SourceCodeRepositoryInterface.Update was just called")
	}
	callInfo := struct {
		In1 *v3.SourceCodeRepository
	}{
		In1: in1,
	}
	lockSourceCodeRepositoryInterfaceMockUpdate.Lock()
	mock.calls.Update = append(mock.calls.Update, callInfo)
	lockSourceCodeRepositoryInterfaceMockUpdate.Unlock()
	return mock.UpdateFunc(in1)
}

// UpdateCalls gets all the calls that were made to Update.
// Check the length with:
//     len(mockedSourceCodeRepositoryInterface.UpdateCalls())
func (mock *SourceCodeRepositoryInterfaceMock) UpdateCalls() []struct {
	In1 *v3.SourceCodeRepository
} {
	var calls []struct {
		In1 *v3.SourceCodeRepository
	}
	lockSourceCodeRepositoryInterfaceMockUpdate.RLock()
	calls = mock.calls.Update
	lockSourceCodeRepositoryInterfaceMockUpdate.RUnlock()
	return calls
}

// Watch calls WatchFunc.
func (mock *SourceCodeRepositoryInterfaceMock) Watch(opts metav1.ListOptions) (watch.Interface, error) {
	if mock.WatchFunc == nil {
		panic("SourceCodeRepositoryInterfaceMock.WatchFunc: method is nil but SourceCodeRepositoryInterface.Watch was just called")
	}
	callInfo := struct {
		Opts metav1.ListOptions
	}{
		Opts: opts,
	}
	lockSourceCodeRepositoryInterfaceMockWatch.Lock()
	mock.calls.Watch = append(mock.calls.Watch, callInfo)
	lockSourceCodeRepositoryInterfaceMockWatch.Unlock()
	return mock.WatchFunc(opts)
}

// WatchCalls gets all the calls that were made to Watch.
// Check the length with:
//     len(mockedSourceCodeRepositoryInterface.WatchCalls())
func (mock *SourceCodeRepositoryInterfaceMock) WatchCalls() []struct {
	Opts metav1.ListOptions
} {
	var calls []struct {
		Opts metav1.ListOptions
	}
	lockSourceCodeRepositoryInterfaceMockWatch.RLock()
	calls = mock.calls.Watch
	lockSourceCodeRepositoryInterfaceMockWatch.RUnlock()
	return calls
}

var (
	lockSourceCodeRepositoriesGetterMockSourceCodeRepositories sync.RWMutex
)

// Ensure, that SourceCodeRepositoriesGetterMock does implement v31.SourceCodeRepositoriesGetter.
// If this is not the case, regenerate this file with moq.
var _ v31.SourceCodeRepositoriesGetter = &SourceCodeRepositoriesGetterMock{}

// SourceCodeRepositoriesGetterMock is a mock implementation of v31.SourceCodeRepositoriesGetter.
//
//     func TestSomethingThatUsesSourceCodeRepositoriesGetter(t *testing.T) {
//
//         // make and configure a mocked v31.SourceCodeRepositoriesGetter
//         mockedSourceCodeRepositoriesGetter := &SourceCodeRepositoriesGetterMock{
//             SourceCodeRepositoriesFunc: func(namespace string) v31.SourceCodeRepositoryInterface {
// 	               panic("mock out the SourceCodeRepositories method")
//             },
//         }
//
//         // use mockedSourceCodeRepositoriesGetter in code that requires v31.SourceCodeRepositoriesGetter
//         // and then make assertions.
//
//     }
type SourceCodeRepositoriesGetterMock struct {
	// SourceCodeRepositoriesFunc mocks the SourceCodeRepositories method.
	SourceCodeRepositoriesFunc func(namespace string) v31.SourceCodeRepositoryInterface

	// calls tracks calls to the methods.
	calls struct {
		// SourceCodeRepositories holds details about calls to the SourceCodeRepositories method.
		SourceCodeRepositories []struct {
			// Namespace is the namespace argument value.
			Namespace string
		}
	}
}

// SourceCodeRepositories calls SourceCodeRepositoriesFunc.
func (mock *SourceCodeRepositoriesGetterMock) SourceCodeRepositories(namespace string) v31.SourceCodeRepositoryInterface {
	if mock.SourceCodeRepositoriesFunc == nil {
		panic("SourceCodeRepositoriesGetterMock.SourceCodeRepositoriesFunc: method is nil but SourceCodeRepositoriesGetter.SourceCodeRepositories was just called")
	}
	callInfo := struct {
		Namespace string
	}{
		Namespace: namespace,
	}
	lockSourceCodeRepositoriesGetterMockSourceCodeRepositories.Lock()
	mock.calls.SourceCodeRepositories = append(mock.calls.SourceCodeRepositories, callInfo)
	lockSourceCodeRepositoriesGetterMockSourceCodeRepositories.Unlock()
	return mock.SourceCodeRepositoriesFunc(namespace)
}

// SourceCodeRepositoriesCalls gets all the calls that were made to SourceCodeRepositories.
// Check the length with:
//     len(mockedSourceCodeRepositoriesGetter.SourceCodeRepositoriesCalls())
func (mock *SourceCodeRepositoriesGetterMock) SourceCodeRepositoriesCalls() []struct {
	Namespace string
} {
	var calls []struct {
		Namespace string
	}
	lockSourceCodeRepositoriesGetterMockSourceCodeRepositories.RLock()
	calls = mock.calls.SourceCodeRepositories
	lockSourceCodeRepositoriesGetterMockSourceCodeRepositories.RUnlock()
	return calls
}
