// Code generated by moq; DO NOT EDIT.
// github.com/matryer/moq

package fakes

import (
	"context"
	"sync"
	"time"

	"github.com/rancher/norman/controller"
	"github.com/rancher/norman/objectclient"
	v11 "github.com/rancher/rancher/pkg/generated/norman/rbac.authorization.k8s.io/v1"
	v1 "k8s.io/api/rbac/v1"
	metav1 "k8s.io/apimachinery/pkg/apis/meta/v1"
	"k8s.io/apimachinery/pkg/labels"
	"k8s.io/apimachinery/pkg/watch"
	"k8s.io/client-go/tools/cache"
)

var (
	lockRoleBindingListerMockGet  sync.RWMutex
	lockRoleBindingListerMockList sync.RWMutex
)

// Ensure, that RoleBindingListerMock does implement v11.RoleBindingLister.
// If this is not the case, regenerate this file with moq.
var _ v11.RoleBindingLister = &RoleBindingListerMock{}

// RoleBindingListerMock is a mock implementation of v11.RoleBindingLister.
//
//     func TestSomethingThatUsesRoleBindingLister(t *testing.T) {
//
//         // make and configure a mocked v11.RoleBindingLister
//         mockedRoleBindingLister := &RoleBindingListerMock{
//             GetFunc: func(namespace string, name string) (*v1.RoleBinding, error) {
// 	               panic("mock out the Get method")
//             },
//             ListFunc: func(namespace string, selector labels.Selector) ([]*v1.RoleBinding, error) {
// 	               panic("mock out the List method")
//             },
//         }
//
//         // use mockedRoleBindingLister in code that requires v11.RoleBindingLister
//         // and then make assertions.
//
//     }
type RoleBindingListerMock struct {
	// GetFunc mocks the Get method.
	GetFunc func(namespace string, name string) (*v1.RoleBinding, error)

	// ListFunc mocks the List method.
	ListFunc func(namespace string, selector labels.Selector) ([]*v1.RoleBinding, error)

	// calls tracks calls to the methods.
	calls struct {
		// Get holds details about calls to the Get method.
		Get []struct {
			// Namespace is the namespace argument value.
			Namespace string
			// Name is the name argument value.
			Name string
		}
		// List holds details about calls to the List method.
		List []struct {
			// Namespace is the namespace argument value.
			Namespace string
			// Selector is the selector argument value.
			Selector labels.Selector
		}
	}
}

// Get calls GetFunc.
func (mock *RoleBindingListerMock) Get(namespace string, name string) (*v1.RoleBinding, error) {
	if mock.GetFunc == nil {
		panic("RoleBindingListerMock.GetFunc: method is nil but RoleBindingLister.Get was just called")
	}
	callInfo := struct {
		Namespace string
		Name      string
	}{
		Namespace: namespace,
		Name:      name,
	}
	lockRoleBindingListerMockGet.Lock()
	mock.calls.Get = append(mock.calls.Get, callInfo)
	lockRoleBindingListerMockGet.Unlock()
	return mock.GetFunc(namespace, name)
}

// GetCalls gets all the calls that were made to Get.
// Check the length with:
//     len(mockedRoleBindingLister.GetCalls())
func (mock *RoleBindingListerMock) GetCalls() []struct {
	Namespace string
	Name      string
} {
	var calls []struct {
		Namespace string
		Name      string
	}
	lockRoleBindingListerMockGet.RLock()
	calls = mock.calls.Get
	lockRoleBindingListerMockGet.RUnlock()
	return calls
}

// List calls ListFunc.
func (mock *RoleBindingListerMock) List(namespace string, selector labels.Selector) ([]*v1.RoleBinding, error) {
	if mock.ListFunc == nil {
		panic("RoleBindingListerMock.ListFunc: method is nil but RoleBindingLister.List was just called")
	}
	callInfo := struct {
		Namespace string
		Selector  labels.Selector
	}{
		Namespace: namespace,
		Selector:  selector,
	}
	lockRoleBindingListerMockList.Lock()
	mock.calls.List = append(mock.calls.List, callInfo)
	lockRoleBindingListerMockList.Unlock()
	return mock.ListFunc(namespace, selector)
}

// ListCalls gets all the calls that were made to List.
// Check the length with:
//     len(mockedRoleBindingLister.ListCalls())
func (mock *RoleBindingListerMock) ListCalls() []struct {
	Namespace string
	Selector  labels.Selector
} {
	var calls []struct {
		Namespace string
		Selector  labels.Selector
	}
	lockRoleBindingListerMockList.RLock()
	calls = mock.calls.List
	lockRoleBindingListerMockList.RUnlock()
	return calls
}

var (
	lockRoleBindingControllerMockAddClusterScopedFeatureHandler sync.RWMutex
	lockRoleBindingControllerMockAddClusterScopedHandler        sync.RWMutex
	lockRoleBindingControllerMockAddFeatureHandler              sync.RWMutex
	lockRoleBindingControllerMockAddHandler                     sync.RWMutex
	lockRoleBindingControllerMockEnqueue                        sync.RWMutex
	lockRoleBindingControllerMockEnqueueAfter                   sync.RWMutex
	lockRoleBindingControllerMockGeneric                        sync.RWMutex
	lockRoleBindingControllerMockInformer                       sync.RWMutex
	lockRoleBindingControllerMockLister                         sync.RWMutex
)

// Ensure, that RoleBindingControllerMock does implement v11.RoleBindingController.
// If this is not the case, regenerate this file with moq.
var _ v11.RoleBindingController = &RoleBindingControllerMock{}

// RoleBindingControllerMock is a mock implementation of v11.RoleBindingController.
//
//     func TestSomethingThatUsesRoleBindingController(t *testing.T) {
//
//         // make and configure a mocked v11.RoleBindingController
//         mockedRoleBindingController := &RoleBindingControllerMock{
//             AddClusterScopedFeatureHandlerFunc: func(ctx context.Context, enabled func() bool, name string, clusterName string, handler v11.RoleBindingHandlerFunc)  {
// 	               panic("mock out the AddClusterScopedFeatureHandler method")
//             },
//             AddClusterScopedHandlerFunc: func(ctx context.Context, name string, clusterName string, handler v11.RoleBindingHandlerFunc)  {
// 	               panic("mock out the AddClusterScopedHandler method")
//             },
//             AddFeatureHandlerFunc: func(ctx context.Context, enabled func() bool, name string, syncMoqParam v11.RoleBindingHandlerFunc)  {
// 	               panic("mock out the AddFeatureHandler method")
//             },
//             AddHandlerFunc: func(ctx context.Context, name string, handler v11.RoleBindingHandlerFunc)  {
// 	               panic("mock out the AddHandler method")
//             },
//             EnqueueFunc: func(namespace string, name string)  {
// 	               panic("mock out the Enqueue method")
//             },
//             EnqueueAfterFunc: func(namespace string, name string, after time.Duration)  {
// 	               panic("mock out the EnqueueAfter method")
//             },
//             GenericFunc: func() controller.GenericController {
// 	               panic("mock out the Generic method")
//             },
//             InformerFunc: func() cache.SharedIndexInformer {
// 	               panic("mock out the Informer method")
//             },
//             ListerFunc: func() v11.RoleBindingLister {
// 	               panic("mock out the Lister method")
//             },
//         }
//
//         // use mockedRoleBindingController in code that requires v11.RoleBindingController
//         // and then make assertions.
//
//     }
type RoleBindingControllerMock struct {
	// AddClusterScopedFeatureHandlerFunc mocks the AddClusterScopedFeatureHandler method.
	AddClusterScopedFeatureHandlerFunc func(ctx context.Context, enabled func() bool, name string, clusterName string, handler v11.RoleBindingHandlerFunc)

	// AddClusterScopedHandlerFunc mocks the AddClusterScopedHandler method.
	AddClusterScopedHandlerFunc func(ctx context.Context, name string, clusterName string, handler v11.RoleBindingHandlerFunc)

	// AddFeatureHandlerFunc mocks the AddFeatureHandler method.
	AddFeatureHandlerFunc func(ctx context.Context, enabled func() bool, name string, syncMoqParam v11.RoleBindingHandlerFunc)

	// AddHandlerFunc mocks the AddHandler method.
	AddHandlerFunc func(ctx context.Context, name string, handler v11.RoleBindingHandlerFunc)

	// EnqueueFunc mocks the Enqueue method.
	EnqueueFunc func(namespace string, name string)

	// EnqueueAfterFunc mocks the EnqueueAfter method.
	EnqueueAfterFunc func(namespace string, name string, after time.Duration)

	// GenericFunc mocks the Generic method.
	GenericFunc func() controller.GenericController

	// InformerFunc mocks the Informer method.
	InformerFunc func() cache.SharedIndexInformer

	// ListerFunc mocks the Lister method.
	ListerFunc func() v11.RoleBindingLister

	// calls tracks calls to the methods.
	calls struct {
		// AddClusterScopedFeatureHandler holds details about calls to the AddClusterScopedFeatureHandler method.
		AddClusterScopedFeatureHandler []struct {
			// Ctx is the ctx argument value.
			Ctx context.Context
			// Enabled is the enabled argument value.
			Enabled func() bool
			// Name is the name argument value.
			Name string
			// ClusterName is the clusterName argument value.
			ClusterName string
			// Handler is the handler argument value.
			Handler v11.RoleBindingHandlerFunc
		}
		// AddClusterScopedHandler holds details about calls to the AddClusterScopedHandler method.
		AddClusterScopedHandler []struct {
			// Ctx is the ctx argument value.
			Ctx context.Context
			// Name is the name argument value.
			Name string
			// ClusterName is the clusterName argument value.
			ClusterName string
			// Handler is the handler argument value.
			Handler v11.RoleBindingHandlerFunc
		}
		// AddFeatureHandler holds details about calls to the AddFeatureHandler method.
		AddFeatureHandler []struct {
			// Ctx is the ctx argument value.
			Ctx context.Context
			// Enabled is the enabled argument value.
			Enabled func() bool
			// Name is the name argument value.
			Name string
			// Sync is the sync argument value.
			Sync v11.RoleBindingHandlerFunc
		}
		// AddHandler holds details about calls to the AddHandler method.
		AddHandler []struct {
			// Ctx is the ctx argument value.
			Ctx context.Context
			// Name is the name argument value.
			Name string
			// Handler is the handler argument value.
			Handler v11.RoleBindingHandlerFunc
		}
		// Enqueue holds details about calls to the Enqueue method.
		Enqueue []struct {
			// Namespace is the namespace argument value.
			Namespace string
			// Name is the name argument value.
			Name string
		}
		// EnqueueAfter holds details about calls to the EnqueueAfter method.
		EnqueueAfter []struct {
			// Namespace is the namespace argument value.
			Namespace string
			// Name is the name argument value.
			Name string
			// After is the after argument value.
			After time.Duration
		}
		// Generic holds details about calls to the Generic method.
		Generic []struct {
		}
		// Informer holds details about calls to the Informer method.
		Informer []struct {
		}
		// Lister holds details about calls to the Lister method.
		Lister []struct {
		}
	}
}

// AddClusterScopedFeatureHandler calls AddClusterScopedFeatureHandlerFunc.
func (mock *RoleBindingControllerMock) AddClusterScopedFeatureHandler(ctx context.Context, enabled func() bool, name string, clusterName string, handler v11.RoleBindingHandlerFunc) {
	if mock.AddClusterScopedFeatureHandlerFunc == nil {
		panic("RoleBindingControllerMock.AddClusterScopedFeatureHandlerFunc: method is nil but RoleBindingController.AddClusterScopedFeatureHandler was just called")
	}
	callInfo := struct {
		Ctx         context.Context
		Enabled     func() bool
		Name        string
		ClusterName string
		Handler     v11.RoleBindingHandlerFunc
	}{
		Ctx:         ctx,
		Enabled:     enabled,
		Name:        name,
		ClusterName: clusterName,
		Handler:     handler,
	}
	lockRoleBindingControllerMockAddClusterScopedFeatureHandler.Lock()
	mock.calls.AddClusterScopedFeatureHandler = append(mock.calls.AddClusterScopedFeatureHandler, callInfo)
	lockRoleBindingControllerMockAddClusterScopedFeatureHandler.Unlock()
	mock.AddClusterScopedFeatureHandlerFunc(ctx, enabled, name, clusterName, handler)
}

// AddClusterScopedFeatureHandlerCalls gets all the calls that were made to AddClusterScopedFeatureHandler.
// Check the length with:
//     len(mockedRoleBindingController.AddClusterScopedFeatureHandlerCalls())
func (mock *RoleBindingControllerMock) AddClusterScopedFeatureHandlerCalls() []struct {
	Ctx         context.Context
	Enabled     func() bool
	Name        string
	ClusterName string
	Handler     v11.RoleBindingHandlerFunc
} {
	var calls []struct {
		Ctx         context.Context
		Enabled     func() bool
		Name        string
		ClusterName string
		Handler     v11.RoleBindingHandlerFunc
	}
	lockRoleBindingControllerMockAddClusterScopedFeatureHandler.RLock()
	calls = mock.calls.AddClusterScopedFeatureHandler
	lockRoleBindingControllerMockAddClusterScopedFeatureHandler.RUnlock()
	return calls
}

// AddClusterScopedHandler calls AddClusterScopedHandlerFunc.
func (mock *RoleBindingControllerMock) AddClusterScopedHandler(ctx context.Context, name string, clusterName string, handler v11.RoleBindingHandlerFunc) {
	if mock.AddClusterScopedHandlerFunc == nil {
		panic("RoleBindingControllerMock.AddClusterScopedHandlerFunc: method is nil but RoleBindingController.AddClusterScopedHandler was just called")
	}
	callInfo := struct {
		Ctx         context.Context
		Name        string
		ClusterName string
		Handler     v11.RoleBindingHandlerFunc
	}{
		Ctx:         ctx,
		Name:        name,
		ClusterName: clusterName,
		Handler:     handler,
	}
	lockRoleBindingControllerMockAddClusterScopedHandler.Lock()
	mock.calls.AddClusterScopedHandler = append(mock.calls.AddClusterScopedHandler, callInfo)
	lockRoleBindingControllerMockAddClusterScopedHandler.Unlock()
	mock.AddClusterScopedHandlerFunc(ctx, name, clusterName, handler)
}

// AddClusterScopedHandlerCalls gets all the calls that were made to AddClusterScopedHandler.
// Check the length with:
//     len(mockedRoleBindingController.AddClusterScopedHandlerCalls())
func (mock *RoleBindingControllerMock) AddClusterScopedHandlerCalls() []struct {
	Ctx         context.Context
	Name        string
	ClusterName string
	Handler     v11.RoleBindingHandlerFunc
} {
	var calls []struct {
		Ctx         context.Context
		Name        string
		ClusterName string
		Handler     v11.RoleBindingHandlerFunc
	}
	lockRoleBindingControllerMockAddClusterScopedHandler.RLock()
	calls = mock.calls.AddClusterScopedHandler
	lockRoleBindingControllerMockAddClusterScopedHandler.RUnlock()
	return calls
}

// AddFeatureHandler calls AddFeatureHandlerFunc.
func (mock *RoleBindingControllerMock) AddFeatureHandler(ctx context.Context, enabled func() bool, name string, syncMoqParam v11.RoleBindingHandlerFunc) {
	if mock.AddFeatureHandlerFunc == nil {
		panic("RoleBindingControllerMock.AddFeatureHandlerFunc: method is nil but RoleBindingController.AddFeatureHandler was just called")
	}
	callInfo := struct {
		Ctx     context.Context
		Enabled func() bool
		Name    string
		Sync    v11.RoleBindingHandlerFunc
	}{
		Ctx:     ctx,
		Enabled: enabled,
		Name:    name,
		Sync:    syncMoqParam,
	}
	lockRoleBindingControllerMockAddFeatureHandler.Lock()
	mock.calls.AddFeatureHandler = append(mock.calls.AddFeatureHandler, callInfo)
	lockRoleBindingControllerMockAddFeatureHandler.Unlock()
	mock.AddFeatureHandlerFunc(ctx, enabled, name, syncMoqParam)
}

// AddFeatureHandlerCalls gets all the calls that were made to AddFeatureHandler.
// Check the length with:
//     len(mockedRoleBindingController.AddFeatureHandlerCalls())
func (mock *RoleBindingControllerMock) AddFeatureHandlerCalls() []struct {
	Ctx     context.Context
	Enabled func() bool
	Name    string
	Sync    v11.RoleBindingHandlerFunc
} {
	var calls []struct {
		Ctx     context.Context
		Enabled func() bool
		Name    string
		Sync    v11.RoleBindingHandlerFunc
	}
	lockRoleBindingControllerMockAddFeatureHandler.RLock()
	calls = mock.calls.AddFeatureHandler
	lockRoleBindingControllerMockAddFeatureHandler.RUnlock()
	return calls
}

// AddHandler calls AddHandlerFunc.
func (mock *RoleBindingControllerMock) AddHandler(ctx context.Context, name string, handler v11.RoleBindingHandlerFunc) {
	if mock.AddHandlerFunc == nil {
		panic("RoleBindingControllerMock.AddHandlerFunc: method is nil but RoleBindingController.AddHandler was just called")
	}
	callInfo := struct {
		Ctx     context.Context
		Name    string
		Handler v11.RoleBindingHandlerFunc
	}{
		Ctx:     ctx,
		Name:    name,
		Handler: handler,
	}
	lockRoleBindingControllerMockAddHandler.Lock()
	mock.calls.AddHandler = append(mock.calls.AddHandler, callInfo)
	lockRoleBindingControllerMockAddHandler.Unlock()
	mock.AddHandlerFunc(ctx, name, handler)
}

// AddHandlerCalls gets all the calls that were made to AddHandler.
// Check the length with:
//     len(mockedRoleBindingController.AddHandlerCalls())
func (mock *RoleBindingControllerMock) AddHandlerCalls() []struct {
	Ctx     context.Context
	Name    string
	Handler v11.RoleBindingHandlerFunc
} {
	var calls []struct {
		Ctx     context.Context
		Name    string
		Handler v11.RoleBindingHandlerFunc
	}
	lockRoleBindingControllerMockAddHandler.RLock()
	calls = mock.calls.AddHandler
	lockRoleBindingControllerMockAddHandler.RUnlock()
	return calls
}

// Enqueue calls EnqueueFunc.
func (mock *RoleBindingControllerMock) Enqueue(namespace string, name string) {
	if mock.EnqueueFunc == nil {
		panic("RoleBindingControllerMock.EnqueueFunc: method is nil but RoleBindingController.Enqueue was just called")
	}
	callInfo := struct {
		Namespace string
		Name      string
	}{
		Namespace: namespace,
		Name:      name,
	}
	lockRoleBindingControllerMockEnqueue.Lock()
	mock.calls.Enqueue = append(mock.calls.Enqueue, callInfo)
	lockRoleBindingControllerMockEnqueue.Unlock()
	mock.EnqueueFunc(namespace, name)
}

// EnqueueCalls gets all the calls that were made to Enqueue.
// Check the length with:
//     len(mockedRoleBindingController.EnqueueCalls())
func (mock *RoleBindingControllerMock) EnqueueCalls() []struct {
	Namespace string
	Name      string
} {
	var calls []struct {
		Namespace string
		Name      string
	}
	lockRoleBindingControllerMockEnqueue.RLock()
	calls = mock.calls.Enqueue
	lockRoleBindingControllerMockEnqueue.RUnlock()
	return calls
}

// EnqueueAfter calls EnqueueAfterFunc.
func (mock *RoleBindingControllerMock) EnqueueAfter(namespace string, name string, after time.Duration) {
	if mock.EnqueueAfterFunc == nil {
		panic("RoleBindingControllerMock.EnqueueAfterFunc: method is nil but RoleBindingController.EnqueueAfter was just called")
	}
	callInfo := struct {
		Namespace string
		Name      string
		After     time.Duration
	}{
		Namespace: namespace,
		Name:      name,
		After:     after,
	}
	lockRoleBindingControllerMockEnqueueAfter.Lock()
	mock.calls.EnqueueAfter = append(mock.calls.EnqueueAfter, callInfo)
	lockRoleBindingControllerMockEnqueueAfter.Unlock()
	mock.EnqueueAfterFunc(namespace, name, after)
}

// EnqueueAfterCalls gets all the calls that were made to EnqueueAfter.
// Check the length with:
//     len(mockedRoleBindingController.EnqueueAfterCalls())
func (mock *RoleBindingControllerMock) EnqueueAfterCalls() []struct {
	Namespace string
	Name      string
	After     time.Duration
} {
	var calls []struct {
		Namespace string
		Name      string
		After     time.Duration
	}
	lockRoleBindingControllerMockEnqueueAfter.RLock()
	calls = mock.calls.EnqueueAfter
	lockRoleBindingControllerMockEnqueueAfter.RUnlock()
	return calls
}

// Generic calls GenericFunc.
func (mock *RoleBindingControllerMock) Generic() controller.GenericController {
	if mock.GenericFunc == nil {
		panic("RoleBindingControllerMock.GenericFunc: method is nil but RoleBindingController.Generic was just called")
	}
	callInfo := struct {
	}{}
	lockRoleBindingControllerMockGeneric.Lock()
	mock.calls.Generic = append(mock.calls.Generic, callInfo)
	lockRoleBindingControllerMockGeneric.Unlock()
	return mock.GenericFunc()
}

// GenericCalls gets all the calls that were made to Generic.
// Check the length with:
//     len(mockedRoleBindingController.GenericCalls())
func (mock *RoleBindingControllerMock) GenericCalls() []struct {
} {
	var calls []struct {
	}
	lockRoleBindingControllerMockGeneric.RLock()
	calls = mock.calls.Generic
	lockRoleBindingControllerMockGeneric.RUnlock()
	return calls
}

// Informer calls InformerFunc.
func (mock *RoleBindingControllerMock) Informer() cache.SharedIndexInformer {
	if mock.InformerFunc == nil {
		panic("RoleBindingControllerMock.InformerFunc: method is nil but RoleBindingController.Informer was just called")
	}
	callInfo := struct {
	}{}
	lockRoleBindingControllerMockInformer.Lock()
	mock.calls.Informer = append(mock.calls.Informer, callInfo)
	lockRoleBindingControllerMockInformer.Unlock()
	return mock.InformerFunc()
}

// InformerCalls gets all the calls that were made to Informer.
// Check the length with:
//     len(mockedRoleBindingController.InformerCalls())
func (mock *RoleBindingControllerMock) InformerCalls() []struct {
} {
	var calls []struct {
	}
	lockRoleBindingControllerMockInformer.RLock()
	calls = mock.calls.Informer
	lockRoleBindingControllerMockInformer.RUnlock()
	return calls
}

// Lister calls ListerFunc.
func (mock *RoleBindingControllerMock) Lister() v11.RoleBindingLister {
	if mock.ListerFunc == nil {
		panic("RoleBindingControllerMock.ListerFunc: method is nil but RoleBindingController.Lister was just called")
	}
	callInfo := struct {
	}{}
	lockRoleBindingControllerMockLister.Lock()
	mock.calls.Lister = append(mock.calls.Lister, callInfo)
	lockRoleBindingControllerMockLister.Unlock()
	return mock.ListerFunc()
}

// ListerCalls gets all the calls that were made to Lister.
// Check the length with:
//     len(mockedRoleBindingController.ListerCalls())
func (mock *RoleBindingControllerMock) ListerCalls() []struct {
} {
	var calls []struct {
	}
	lockRoleBindingControllerMockLister.RLock()
	calls = mock.calls.Lister
	lockRoleBindingControllerMockLister.RUnlock()
	return calls
}

var (
	lockRoleBindingInterfaceMockAddClusterScopedFeatureHandler   sync.RWMutex
	lockRoleBindingInterfaceMockAddClusterScopedFeatureLifecycle sync.RWMutex
	lockRoleBindingInterfaceMockAddClusterScopedHandler          sync.RWMutex
	lockRoleBindingInterfaceMockAddClusterScopedLifecycle        sync.RWMutex
	lockRoleBindingInterfaceMockAddFeatureHandler                sync.RWMutex
	lockRoleBindingInterfaceMockAddFeatureLifecycle              sync.RWMutex
	lockRoleBindingInterfaceMockAddHandler                       sync.RWMutex
	lockRoleBindingInterfaceMockAddLifecycle                     sync.RWMutex
	lockRoleBindingInterfaceMockController                       sync.RWMutex
	lockRoleBindingInterfaceMockCreate                           sync.RWMutex
	lockRoleBindingInterfaceMockDelete                           sync.RWMutex
	lockRoleBindingInterfaceMockDeleteCollection                 sync.RWMutex
	lockRoleBindingInterfaceMockDeleteNamespaced                 sync.RWMutex
	lockRoleBindingInterfaceMockGet                              sync.RWMutex
	lockRoleBindingInterfaceMockGetNamespaced                    sync.RWMutex
	lockRoleBindingInterfaceMockList                             sync.RWMutex
	lockRoleBindingInterfaceMockListNamespaced                   sync.RWMutex
	lockRoleBindingInterfaceMockObjectClient                     sync.RWMutex
	lockRoleBindingInterfaceMockUpdate                           sync.RWMutex
	lockRoleBindingInterfaceMockWatch                            sync.RWMutex
)

// Ensure, that RoleBindingInterfaceMock does implement v11.RoleBindingInterface.
// If this is not the case, regenerate this file with moq.
var _ v11.RoleBindingInterface = &RoleBindingInterfaceMock{}

// RoleBindingInterfaceMock is a mock implementation of v11.RoleBindingInterface.
//
//     func TestSomethingThatUsesRoleBindingInterface(t *testing.T) {
//
//         // make and configure a mocked v11.RoleBindingInterface
//         mockedRoleBindingInterface := &RoleBindingInterfaceMock{
//             AddClusterScopedFeatureHandlerFunc: func(ctx context.Context, enabled func() bool, name string, clusterName string, syncMoqParam v11.RoleBindingHandlerFunc)  {
// 	               panic("mock out the AddClusterScopedFeatureHandler method")
//             },
//             AddClusterScopedFeatureLifecycleFunc: func(ctx context.Context, enabled func() bool, name string, clusterName string, lifecycle v11.RoleBindingLifecycle)  {
// 	               panic("mock out the AddClusterScopedFeatureLifecycle method")
//             },
//             AddClusterScopedHandlerFunc: func(ctx context.Context, name string, clusterName string, syncMoqParam v11.RoleBindingHandlerFunc)  {
// 	               panic("mock out the AddClusterScopedHandler method")
//             },
//             AddClusterScopedLifecycleFunc: func(ctx context.Context, name string, clusterName string, lifecycle v11.RoleBindingLifecycle)  {
// 	               panic("mock out the AddClusterScopedLifecycle method")
//             },
//             AddFeatureHandlerFunc: func(ctx context.Context, enabled func() bool, name string, syncMoqParam v11.RoleBindingHandlerFunc)  {
// 	               panic("mock out the AddFeatureHandler method")
//             },
//             AddFeatureLifecycleFunc: func(ctx context.Context, enabled func() bool, name string, lifecycle v11.RoleBindingLifecycle)  {
// 	               panic("mock out the AddFeatureLifecycle method")
//             },
//             AddHandlerFunc: func(ctx context.Context, name string, syncMoqParam v11.RoleBindingHandlerFunc)  {
// 	               panic("mock out the AddHandler method")
//             },
//             AddLifecycleFunc: func(ctx context.Context, name string, lifecycle v11.RoleBindingLifecycle)  {
// 	               panic("mock out the AddLifecycle method")
//             },
//             ControllerFunc: func() v11.RoleBindingController {
// 	               panic("mock out the Controller method")
//             },
//             CreateFunc: func(in1 *v1.RoleBinding) (*v1.RoleBinding, error) {
// 	               panic("mock out the Create method")
//             },
//             DeleteFunc: func(name string, options *metav1.DeleteOptions) error {
// 	               panic("mock out the Delete method")
//             },
//             DeleteCollectionFunc: func(deleteOpts *metav1.DeleteOptions, listOpts metav1.ListOptions) error {
// 	               panic("mock out the DeleteCollection method")
//             },
//             DeleteNamespacedFunc: func(namespace string, name string, options *metav1.DeleteOptions) error {
// 	               panic("mock out the DeleteNamespaced method")
//             },
//             GetFunc: func(name string, opts metav1.GetOptions) (*v1.RoleBinding, error) {
// 	               panic("mock out the Get method")
//             },
//             GetNamespacedFunc: func(namespace string, name string, opts metav1.GetOptions) (*v1.RoleBinding, error) {
// 	               panic("mock out the GetNamespaced method")
//             },
//             ListFunc: func(opts metav1.ListOptions) (*v1.RoleBindingList, error) {
// 	               panic("mock out the List method")
//             },
//             ListNamespacedFunc: func(namespace string, opts metav1.ListOptions) (*v1.RoleBindingList, error) {
// 	               panic("mock out the ListNamespaced method")
//             },
//             ObjectClientFunc: func() *objectclient.ObjectClient {
// 	               panic("mock out the ObjectClient method")
//             },
//             UpdateFunc: func(in1 *v1.RoleBinding) (*v1.RoleBinding, error) {
// 	               panic("mock out the Update method")
//             },
//             WatchFunc: func(opts metav1.ListOptions) (watch.Interface, error) {
// 	               panic("mock out the Watch method")
//             },
//         }
//
//         // use mockedRoleBindingInterface in code that requires v11.RoleBindingInterface
//         // and then make assertions.
//
//     }
type RoleBindingInterfaceMock struct {
	// AddClusterScopedFeatureHandlerFunc mocks the AddClusterScopedFeatureHandler method.
	AddClusterScopedFeatureHandlerFunc func(ctx context.Context, enabled func() bool, name string, clusterName string, syncMoqParam v11.RoleBindingHandlerFunc)

	// AddClusterScopedFeatureLifecycleFunc mocks the AddClusterScopedFeatureLifecycle method.
	AddClusterScopedFeatureLifecycleFunc func(ctx context.Context, enabled func() bool, name string, clusterName string, lifecycle v11.RoleBindingLifecycle)

	// AddClusterScopedHandlerFunc mocks the AddClusterScopedHandler method.
	AddClusterScopedHandlerFunc func(ctx context.Context, name string, clusterName string, syncMoqParam v11.RoleBindingHandlerFunc)

	// AddClusterScopedLifecycleFunc mocks the AddClusterScopedLifecycle method.
	AddClusterScopedLifecycleFunc func(ctx context.Context, name string, clusterName string, lifecycle v11.RoleBindingLifecycle)

	// AddFeatureHandlerFunc mocks the AddFeatureHandler method.
	AddFeatureHandlerFunc func(ctx context.Context, enabled func() bool, name string, syncMoqParam v11.RoleBindingHandlerFunc)

	// AddFeatureLifecycleFunc mocks the AddFeatureLifecycle method.
	AddFeatureLifecycleFunc func(ctx context.Context, enabled func() bool, name string, lifecycle v11.RoleBindingLifecycle)

	// AddHandlerFunc mocks the AddHandler method.
	AddHandlerFunc func(ctx context.Context, name string, syncMoqParam v11.RoleBindingHandlerFunc)

	// AddLifecycleFunc mocks the AddLifecycle method.
	AddLifecycleFunc func(ctx context.Context, name string, lifecycle v11.RoleBindingLifecycle)

	// ControllerFunc mocks the Controller method.
	ControllerFunc func() v11.RoleBindingController

	// CreateFunc mocks the Create method.
	CreateFunc func(in1 *v1.RoleBinding) (*v1.RoleBinding, error)

	// DeleteFunc mocks the Delete method.
	DeleteFunc func(name string, options *metav1.DeleteOptions) error

	// DeleteCollectionFunc mocks the DeleteCollection method.
	DeleteCollectionFunc func(deleteOpts *metav1.DeleteOptions, listOpts metav1.ListOptions) error

	// DeleteNamespacedFunc mocks the DeleteNamespaced method.
	DeleteNamespacedFunc func(namespace string, name string, options *metav1.DeleteOptions) error

	// GetFunc mocks the Get method.
	GetFunc func(name string, opts metav1.GetOptions) (*v1.RoleBinding, error)

	// GetNamespacedFunc mocks the GetNamespaced method.
	GetNamespacedFunc func(namespace string, name string, opts metav1.GetOptions) (*v1.RoleBinding, error)

	// ListFunc mocks the List method.
	ListFunc func(opts metav1.ListOptions) (*v1.RoleBindingList, error)

	// ListNamespacedFunc mocks the ListNamespaced method.
	ListNamespacedFunc func(namespace string, opts metav1.ListOptions) (*v1.RoleBindingList, error)

	// ObjectClientFunc mocks the ObjectClient method.
	ObjectClientFunc func() *objectclient.ObjectClient

	// UpdateFunc mocks the Update method.
	UpdateFunc func(in1 *v1.RoleBinding) (*v1.RoleBinding, error)

	// WatchFunc mocks the Watch method.
	WatchFunc func(opts metav1.ListOptions) (watch.Interface, error)

	// calls tracks calls to the methods.
	calls struct {
		// AddClusterScopedFeatureHandler holds details about calls to the AddClusterScopedFeatureHandler method.
		AddClusterScopedFeatureHandler []struct {
			// Ctx is the ctx argument value.
			Ctx context.Context
			// Enabled is the enabled argument value.
			Enabled func() bool
			// Name is the name argument value.
			Name string
			// ClusterName is the clusterName argument value.
			ClusterName string
			// Sync is the sync argument value.
			Sync v11.RoleBindingHandlerFunc
		}
		// AddClusterScopedFeatureLifecycle holds details about calls to the AddClusterScopedFeatureLifecycle method.
		AddClusterScopedFeatureLifecycle []struct {
			// Ctx is the ctx argument value.
			Ctx context.Context
			// Enabled is the enabled argument value.
			Enabled func() bool
			// Name is the name argument value.
			Name string
			// ClusterName is the clusterName argument value.
			ClusterName string
			// Lifecycle is the lifecycle argument value.
			Lifecycle v11.RoleBindingLifecycle
		}
		// AddClusterScopedHandler holds details about calls to the AddClusterScopedHandler method.
		AddClusterScopedHandler []struct {
			// Ctx is the ctx argument value.
			Ctx context.Context
			// Name is the name argument value.
			Name string
			// ClusterName is the clusterName argument value.
			ClusterName string
			// Sync is the sync argument value.
			Sync v11.RoleBindingHandlerFunc
		}
		// AddClusterScopedLifecycle holds details about calls to the AddClusterScopedLifecycle method.
		AddClusterScopedLifecycle []struct {
			// Ctx is the ctx argument value.
			Ctx context.Context
			// Name is the name argument value.
			Name string
			// ClusterName is the clusterName argument value.
			ClusterName string
			// Lifecycle is the lifecycle argument value.
			Lifecycle v11.RoleBindingLifecycle
		}
		// AddFeatureHandler holds details about calls to the AddFeatureHandler method.
		AddFeatureHandler []struct {
			// Ctx is the ctx argument value.
			Ctx context.Context
			// Enabled is the enabled argument value.
			Enabled func() bool
			// Name is the name argument value.
			Name string
			// Sync is the sync argument value.
			Sync v11.RoleBindingHandlerFunc
		}
		// AddFeatureLifecycle holds details about calls to the AddFeatureLifecycle method.
		AddFeatureLifecycle []struct {
			// Ctx is the ctx argument value.
			Ctx context.Context
			// Enabled is the enabled argument value.
			Enabled func() bool
			// Name is the name argument value.
			Name string
			// Lifecycle is the lifecycle argument value.
			Lifecycle v11.RoleBindingLifecycle
		}
		// AddHandler holds details about calls to the AddHandler method.
		AddHandler []struct {
			// Ctx is the ctx argument value.
			Ctx context.Context
			// Name is the name argument value.
			Name string
			// Sync is the sync argument value.
			Sync v11.RoleBindingHandlerFunc
		}
		// AddLifecycle holds details about calls to the AddLifecycle method.
		AddLifecycle []struct {
			// Ctx is the ctx argument value.
			Ctx context.Context
			// Name is the name argument value.
			Name string
			// Lifecycle is the lifecycle argument value.
			Lifecycle v11.RoleBindingLifecycle
		}
		// Controller holds details about calls to the Controller method.
		Controller []struct {
		}
		// Create holds details about calls to the Create method.
		Create []struct {
			// In1 is the in1 argument value.
			In1 *v1.RoleBinding
		}
		// Delete holds details about calls to the Delete method.
		Delete []struct {
			// Name is the name argument value.
			Name string
			// Options is the options argument value.
			Options *metav1.DeleteOptions
		}
		// DeleteCollection holds details about calls to the DeleteCollection method.
		DeleteCollection []struct {
			// DeleteOpts is the deleteOpts argument value.
			DeleteOpts *metav1.DeleteOptions
			// ListOpts is the listOpts argument value.
			ListOpts metav1.ListOptions
		}
		// DeleteNamespaced holds details about calls to the DeleteNamespaced method.
		DeleteNamespaced []struct {
			// Namespace is the namespace argument value.
			Namespace string
			// Name is the name argument value.
			Name string
			// Options is the options argument value.
			Options *metav1.DeleteOptions
		}
		// Get holds details about calls to the Get method.
		Get []struct {
			// Name is the name argument value.
			Name string
			// Opts is the opts argument value.
			Opts metav1.GetOptions
		}
		// GetNamespaced holds details about calls to the GetNamespaced method.
		GetNamespaced []struct {
			// Namespace is the namespace argument value.
			Namespace string
			// Name is the name argument value.
			Name string
			// Opts is the opts argument value.
			Opts metav1.GetOptions
		}
		// List holds details about calls to the List method.
		List []struct {
			// Opts is the opts argument value.
			Opts metav1.ListOptions
		}
		// ListNamespaced holds details about calls to the ListNamespaced method.
		ListNamespaced []struct {
			// Namespace is the namespace argument value.
			Namespace string
			// Opts is the opts argument value.
			Opts metav1.ListOptions
		}
		// ObjectClient holds details about calls to the ObjectClient method.
		ObjectClient []struct {
		}
		// Update holds details about calls to the Update method.
		Update []struct {
			// In1 is the in1 argument value.
			In1 *v1.RoleBinding
		}
		// Watch holds details about calls to the Watch method.
		Watch []struct {
			// Opts is the opts argument value.
			Opts metav1.ListOptions
		}
	}
}

// AddClusterScopedFeatureHandler calls AddClusterScopedFeatureHandlerFunc.
func (mock *RoleBindingInterfaceMock) AddClusterScopedFeatureHandler(ctx context.Context, enabled func() bool, name string, clusterName string, syncMoqParam v11.RoleBindingHandlerFunc) {
	if mock.AddClusterScopedFeatureHandlerFunc == nil {
		panic("RoleBindingInterfaceMock.AddClusterScopedFeatureHandlerFunc: method is nil but RoleBindingInterface.AddClusterScopedFeatureHandler was just called")
	}
	callInfo := struct {
		Ctx         context.Context
		Enabled     func() bool
		Name        string
		ClusterName string
		Sync        v11.RoleBindingHandlerFunc
	}{
		Ctx:         ctx,
		Enabled:     enabled,
		Name:        name,
		ClusterName: clusterName,
		Sync:        syncMoqParam,
	}
	lockRoleBindingInterfaceMockAddClusterScopedFeatureHandler.Lock()
	mock.calls.AddClusterScopedFeatureHandler = append(mock.calls.AddClusterScopedFeatureHandler, callInfo)
	lockRoleBindingInterfaceMockAddClusterScopedFeatureHandler.Unlock()
	mock.AddClusterScopedFeatureHandlerFunc(ctx, enabled, name, clusterName, syncMoqParam)
}

// AddClusterScopedFeatureHandlerCalls gets all the calls that were made to AddClusterScopedFeatureHandler.
// Check the length with:
//     len(mockedRoleBindingInterface.AddClusterScopedFeatureHandlerCalls())
func (mock *RoleBindingInterfaceMock) AddClusterScopedFeatureHandlerCalls() []struct {
	Ctx         context.Context
	Enabled     func() bool
	Name        string
	ClusterName string
	Sync        v11.RoleBindingHandlerFunc
} {
	var calls []struct {
		Ctx         context.Context
		Enabled     func() bool
		Name        string
		ClusterName string
		Sync        v11.RoleBindingHandlerFunc
	}
	lockRoleBindingInterfaceMockAddClusterScopedFeatureHandler.RLock()
	calls = mock.calls.AddClusterScopedFeatureHandler
	lockRoleBindingInterfaceMockAddClusterScopedFeatureHandler.RUnlock()
	return calls
}

// AddClusterScopedFeatureLifecycle calls AddClusterScopedFeatureLifecycleFunc.
func (mock *RoleBindingInterfaceMock) AddClusterScopedFeatureLifecycle(ctx context.Context, enabled func() bool, name string, clusterName string, lifecycle v11.RoleBindingLifecycle) {
	if mock.AddClusterScopedFeatureLifecycleFunc == nil {
		panic("RoleBindingInterfaceMock.AddClusterScopedFeatureLifecycleFunc: method is nil but RoleBindingInterface.AddClusterScopedFeatureLifecycle was just called")
	}
	callInfo := struct {
		Ctx         context.Context
		Enabled     func() bool
		Name        string
		ClusterName string
		Lifecycle   v11.RoleBindingLifecycle
	}{
		Ctx:         ctx,
		Enabled:     enabled,
		Name:        name,
		ClusterName: clusterName,
		Lifecycle:   lifecycle,
	}
	lockRoleBindingInterfaceMockAddClusterScopedFeatureLifecycle.Lock()
	mock.calls.AddClusterScopedFeatureLifecycle = append(mock.calls.AddClusterScopedFeatureLifecycle, callInfo)
	lockRoleBindingInterfaceMockAddClusterScopedFeatureLifecycle.Unlock()
	mock.AddClusterScopedFeatureLifecycleFunc(ctx, enabled, name, clusterName, lifecycle)
}

// AddClusterScopedFeatureLifecycleCalls gets all the calls that were made to AddClusterScopedFeatureLifecycle.
// Check the length with:
//     len(mockedRoleBindingInterface.AddClusterScopedFeatureLifecycleCalls())
func (mock *RoleBindingInterfaceMock) AddClusterScopedFeatureLifecycleCalls() []struct {
	Ctx         context.Context
	Enabled     func() bool
	Name        string
	ClusterName string
	Lifecycle   v11.RoleBindingLifecycle
} {
	var calls []struct {
		Ctx         context.Context
		Enabled     func() bool
		Name        string
		ClusterName string
		Lifecycle   v11.RoleBindingLifecycle
	}
	lockRoleBindingInterfaceMockAddClusterScopedFeatureLifecycle.RLock()
	calls = mock.calls.AddClusterScopedFeatureLifecycle
	lockRoleBindingInterfaceMockAddClusterScopedFeatureLifecycle.RUnlock()
	return calls
}

// AddClusterScopedHandler calls AddClusterScopedHandlerFunc.
func (mock *RoleBindingInterfaceMock) AddClusterScopedHandler(ctx context.Context, name string, clusterName string, syncMoqParam v11.RoleBindingHandlerFunc) {
	if mock.AddClusterScopedHandlerFunc == nil {
		panic("RoleBindingInterfaceMock.AddClusterScopedHandlerFunc: method is nil but RoleBindingInterface.AddClusterScopedHandler was just called")
	}
	callInfo := struct {
		Ctx         context.Context
		Name        string
		ClusterName string
		Sync        v11.RoleBindingHandlerFunc
	}{
		Ctx:         ctx,
		Name:        name,
		ClusterName: clusterName,
		Sync:        syncMoqParam,
	}
	lockRoleBindingInterfaceMockAddClusterScopedHandler.Lock()
	mock.calls.AddClusterScopedHandler = append(mock.calls.AddClusterScopedHandler, callInfo)
	lockRoleBindingInterfaceMockAddClusterScopedHandler.Unlock()
	mock.AddClusterScopedHandlerFunc(ctx, name, clusterName, syncMoqParam)
}

// AddClusterScopedHandlerCalls gets all the calls that were made to AddClusterScopedHandler.
// Check the length with:
//     len(mockedRoleBindingInterface.AddClusterScopedHandlerCalls())
func (mock *RoleBindingInterfaceMock) AddClusterScopedHandlerCalls() []struct {
	Ctx         context.Context
	Name        string
	ClusterName string
	Sync        v11.RoleBindingHandlerFunc
} {
	var calls []struct {
		Ctx         context.Context
		Name        string
		ClusterName string
		Sync        v11.RoleBindingHandlerFunc
	}
	lockRoleBindingInterfaceMockAddClusterScopedHandler.RLock()
	calls = mock.calls.AddClusterScopedHandler
	lockRoleBindingInterfaceMockAddClusterScopedHandler.RUnlock()
	return calls
}

// AddClusterScopedLifecycle calls AddClusterScopedLifecycleFunc.
func (mock *RoleBindingInterfaceMock) AddClusterScopedLifecycle(ctx context.Context, name string, clusterName string, lifecycle v11.RoleBindingLifecycle) {
	if mock.AddClusterScopedLifecycleFunc == nil {
		panic("RoleBindingInterfaceMock.AddClusterScopedLifecycleFunc: method is nil but RoleBindingInterface.AddClusterScopedLifecycle was just called")
	}
	callInfo := struct {
		Ctx         context.Context
		Name        string
		ClusterName string
		Lifecycle   v11.RoleBindingLifecycle
	}{
		Ctx:         ctx,
		Name:        name,
		ClusterName: clusterName,
		Lifecycle:   lifecycle,
	}
	lockRoleBindingInterfaceMockAddClusterScopedLifecycle.Lock()
	mock.calls.AddClusterScopedLifecycle = append(mock.calls.AddClusterScopedLifecycle, callInfo)
	lockRoleBindingInterfaceMockAddClusterScopedLifecycle.Unlock()
	mock.AddClusterScopedLifecycleFunc(ctx, name, clusterName, lifecycle)
}

// AddClusterScopedLifecycleCalls gets all the calls that were made to AddClusterScopedLifecycle.
// Check the length with:
//     len(mockedRoleBindingInterface.AddClusterScopedLifecycleCalls())
func (mock *RoleBindingInterfaceMock) AddClusterScopedLifecycleCalls() []struct {
	Ctx         context.Context
	Name        string
	ClusterName string
	Lifecycle   v11.RoleBindingLifecycle
} {
	var calls []struct {
		Ctx         context.Context
		Name        string
		ClusterName string
		Lifecycle   v11.RoleBindingLifecycle
	}
	lockRoleBindingInterfaceMockAddClusterScopedLifecycle.RLock()
	calls = mock.calls.AddClusterScopedLifecycle
	lockRoleBindingInterfaceMockAddClusterScopedLifecycle.RUnlock()
	return calls
}

// AddFeatureHandler calls AddFeatureHandlerFunc.
func (mock *RoleBindingInterfaceMock) AddFeatureHandler(ctx context.Context, enabled func() bool, name string, syncMoqParam v11.RoleBindingHandlerFunc) {
	if mock.AddFeatureHandlerFunc == nil {
		panic("RoleBindingInterfaceMock.AddFeatureHandlerFunc: method is nil but RoleBindingInterface.AddFeatureHandler was just called")
	}
	callInfo := struct {
		Ctx     context.Context
		Enabled func() bool
		Name    string
		Sync    v11.RoleBindingHandlerFunc
	}{
		Ctx:     ctx,
		Enabled: enabled,
		Name:    name,
		Sync:    syncMoqParam,
	}
	lockRoleBindingInterfaceMockAddFeatureHandler.Lock()
	mock.calls.AddFeatureHandler = append(mock.calls.AddFeatureHandler, callInfo)
	lockRoleBindingInterfaceMockAddFeatureHandler.Unlock()
	mock.AddFeatureHandlerFunc(ctx, enabled, name, syncMoqParam)
}

// AddFeatureHandlerCalls gets all the calls that were made to AddFeatureHandler.
// Check the length with:
//     len(mockedRoleBindingInterface.AddFeatureHandlerCalls())
func (mock *RoleBindingInterfaceMock) AddFeatureHandlerCalls() []struct {
	Ctx     context.Context
	Enabled func() bool
	Name    string
	Sync    v11.RoleBindingHandlerFunc
} {
	var calls []struct {
		Ctx     context.Context
		Enabled func() bool
		Name    string
		Sync    v11.RoleBindingHandlerFunc
	}
	lockRoleBindingInterfaceMockAddFeatureHandler.RLock()
	calls = mock.calls.AddFeatureHandler
	lockRoleBindingInterfaceMockAddFeatureHandler.RUnlock()
	return calls
}

// AddFeatureLifecycle calls AddFeatureLifecycleFunc.
func (mock *RoleBindingInterfaceMock) AddFeatureLifecycle(ctx context.Context, enabled func() bool, name string, lifecycle v11.RoleBindingLifecycle) {
	if mock.AddFeatureLifecycleFunc == nil {
		panic("RoleBindingInterfaceMock.AddFeatureLifecycleFunc: method is nil but RoleBindingInterface.AddFeatureLifecycle was just called")
	}
	callInfo := struct {
		Ctx       context.Context
		Enabled   func() bool
		Name      string
		Lifecycle v11.RoleBindingLifecycle
	}{
		Ctx:       ctx,
		Enabled:   enabled,
		Name:      name,
		Lifecycle: lifecycle,
	}
	lockRoleBindingInterfaceMockAddFeatureLifecycle.Lock()
	mock.calls.AddFeatureLifecycle = append(mock.calls.AddFeatureLifecycle, callInfo)
	lockRoleBindingInterfaceMockAddFeatureLifecycle.Unlock()
	mock.AddFeatureLifecycleFunc(ctx, enabled, name, lifecycle)
}

// AddFeatureLifecycleCalls gets all the calls that were made to AddFeatureLifecycle.
// Check the length with:
//     len(mockedRoleBindingInterface.AddFeatureLifecycleCalls())
func (mock *RoleBindingInterfaceMock) AddFeatureLifecycleCalls() []struct {
	Ctx       context.Context
	Enabled   func() bool
	Name      string
	Lifecycle v11.RoleBindingLifecycle
} {
	var calls []struct {
		Ctx       context.Context
		Enabled   func() bool
		Name      string
		Lifecycle v11.RoleBindingLifecycle
	}
	lockRoleBindingInterfaceMockAddFeatureLifecycle.RLock()
	calls = mock.calls.AddFeatureLifecycle
	lockRoleBindingInterfaceMockAddFeatureLifecycle.RUnlock()
	return calls
}

// AddHandler calls AddHandlerFunc.
func (mock *RoleBindingInterfaceMock) AddHandler(ctx context.Context, name string, syncMoqParam v11.RoleBindingHandlerFunc) {
	if mock.AddHandlerFunc == nil {
		panic("RoleBindingInterfaceMock.AddHandlerFunc: method is nil but RoleBindingInterface.AddHandler was just called")
	}
	callInfo := struct {
		Ctx  context.Context
		Name string
		Sync v11.RoleBindingHandlerFunc
	}{
		Ctx:  ctx,
		Name: name,
		Sync: syncMoqParam,
	}
	lockRoleBindingInterfaceMockAddHandler.Lock()
	mock.calls.AddHandler = append(mock.calls.AddHandler, callInfo)
	lockRoleBindingInterfaceMockAddHandler.Unlock()
	mock.AddHandlerFunc(ctx, name, syncMoqParam)
}

// AddHandlerCalls gets all the calls that were made to AddHandler.
// Check the length with:
//     len(mockedRoleBindingInterface.AddHandlerCalls())
func (mock *RoleBindingInterfaceMock) AddHandlerCalls() []struct {
	Ctx  context.Context
	Name string
	Sync v11.RoleBindingHandlerFunc
} {
	var calls []struct {
		Ctx  context.Context
		Name string
		Sync v11.RoleBindingHandlerFunc
	}
	lockRoleBindingInterfaceMockAddHandler.RLock()
	calls = mock.calls.AddHandler
	lockRoleBindingInterfaceMockAddHandler.RUnlock()
	return calls
}

// AddLifecycle calls AddLifecycleFunc.
func (mock *RoleBindingInterfaceMock) AddLifecycle(ctx context.Context, name string, lifecycle v11.RoleBindingLifecycle) {
	if mock.AddLifecycleFunc == nil {
		panic("RoleBindingInterfaceMock.AddLifecycleFunc: method is nil but RoleBindingInterface.AddLifecycle was just called")
	}
	callInfo := struct {
		Ctx       context.Context
		Name      string
		Lifecycle v11.RoleBindingLifecycle
	}{
		Ctx:       ctx,
		Name:      name,
		Lifecycle: lifecycle,
	}
	lockRoleBindingInterfaceMockAddLifecycle.Lock()
	mock.calls.AddLifecycle = append(mock.calls.AddLifecycle, callInfo)
	lockRoleBindingInterfaceMockAddLifecycle.Unlock()
	mock.AddLifecycleFunc(ctx, name, lifecycle)
}

// AddLifecycleCalls gets all the calls that were made to AddLifecycle.
// Check the length with:
//     len(mockedRoleBindingInterface.AddLifecycleCalls())
func (mock *RoleBindingInterfaceMock) AddLifecycleCalls() []struct {
	Ctx       context.Context
	Name      string
	Lifecycle v11.RoleBindingLifecycle
} {
	var calls []struct {
		Ctx       context.Context
		Name      string
		Lifecycle v11.RoleBindingLifecycle
	}
	lockRoleBindingInterfaceMockAddLifecycle.RLock()
	calls = mock.calls.AddLifecycle
	lockRoleBindingInterfaceMockAddLifecycle.RUnlock()
	return calls
}

// Controller calls ControllerFunc.
func (mock *RoleBindingInterfaceMock) Controller() v11.RoleBindingController {
	if mock.ControllerFunc == nil {
		panic("RoleBindingInterfaceMock.ControllerFunc: method is nil but RoleBindingInterface.Controller was just called")
	}
	callInfo := struct {
	}{}
	lockRoleBindingInterfaceMockController.Lock()
	mock.calls.Controller = append(mock.calls.Controller, callInfo)
	lockRoleBindingInterfaceMockController.Unlock()
	return mock.ControllerFunc()
}

// ControllerCalls gets all the calls that were made to Controller.
// Check the length with:
//     len(mockedRoleBindingInterface.ControllerCalls())
func (mock *RoleBindingInterfaceMock) ControllerCalls() []struct {
} {
	var calls []struct {
	}
	lockRoleBindingInterfaceMockController.RLock()
	calls = mock.calls.Controller
	lockRoleBindingInterfaceMockController.RUnlock()
	return calls
}

// Create calls CreateFunc.
func (mock *RoleBindingInterfaceMock) Create(in1 *v1.RoleBinding) (*v1.RoleBinding, error) {
	if mock.CreateFunc == nil {
		panic("RoleBindingInterfaceMock.CreateFunc: method is nil but RoleBindingInterface.Create was just called")
	}
	callInfo := struct {
		In1 *v1.RoleBinding
	}{
		In1: in1,
	}
	lockRoleBindingInterfaceMockCreate.Lock()
	mock.calls.Create = append(mock.calls.Create, callInfo)
	lockRoleBindingInterfaceMockCreate.Unlock()
	return mock.CreateFunc(in1)
}

// CreateCalls gets all the calls that were made to Create.
// Check the length with:
//     len(mockedRoleBindingInterface.CreateCalls())
func (mock *RoleBindingInterfaceMock) CreateCalls() []struct {
	In1 *v1.RoleBinding
} {
	var calls []struct {
		In1 *v1.RoleBinding
	}
	lockRoleBindingInterfaceMockCreate.RLock()
	calls = mock.calls.Create
	lockRoleBindingInterfaceMockCreate.RUnlock()
	return calls
}

// Delete calls DeleteFunc.
func (mock *RoleBindingInterfaceMock) Delete(name string, options *metav1.DeleteOptions) error {
	if mock.DeleteFunc == nil {
		panic("RoleBindingInterfaceMock.DeleteFunc: method is nil but RoleBindingInterface.Delete was just called")
	}
	callInfo := struct {
		Name    string
		Options *metav1.DeleteOptions
	}{
		Name:    name,
		Options: options,
	}
	lockRoleBindingInterfaceMockDelete.Lock()
	mock.calls.Delete = append(mock.calls.Delete, callInfo)
	lockRoleBindingInterfaceMockDelete.Unlock()
	return mock.DeleteFunc(name, options)
}

// DeleteCalls gets all the calls that were made to Delete.
// Check the length with:
//     len(mockedRoleBindingInterface.DeleteCalls())
func (mock *RoleBindingInterfaceMock) DeleteCalls() []struct {
	Name    string
	Options *metav1.DeleteOptions
} {
	var calls []struct {
		Name    string
		Options *metav1.DeleteOptions
	}
	lockRoleBindingInterfaceMockDelete.RLock()
	calls = mock.calls.Delete
	lockRoleBindingInterfaceMockDelete.RUnlock()
	return calls
}

// DeleteCollection calls DeleteCollectionFunc.
func (mock *RoleBindingInterfaceMock) DeleteCollection(deleteOpts *metav1.DeleteOptions, listOpts metav1.ListOptions) error {
	if mock.DeleteCollectionFunc == nil {
		panic("RoleBindingInterfaceMock.DeleteCollectionFunc: method is nil but RoleBindingInterface.DeleteCollection was just called")
	}
	callInfo := struct {
		DeleteOpts *metav1.DeleteOptions
		ListOpts   metav1.ListOptions
	}{
		DeleteOpts: deleteOpts,
		ListOpts:   listOpts,
	}
	lockRoleBindingInterfaceMockDeleteCollection.Lock()
	mock.calls.DeleteCollection = append(mock.calls.DeleteCollection, callInfo)
	lockRoleBindingInterfaceMockDeleteCollection.Unlock()
	return mock.DeleteCollectionFunc(deleteOpts, listOpts)
}

// DeleteCollectionCalls gets all the calls that were made to DeleteCollection.
// Check the length with:
//     len(mockedRoleBindingInterface.DeleteCollectionCalls())
func (mock *RoleBindingInterfaceMock) DeleteCollectionCalls() []struct {
	DeleteOpts *metav1.DeleteOptions
	ListOpts   metav1.ListOptions
} {
	var calls []struct {
		DeleteOpts *metav1.DeleteOptions
		ListOpts   metav1.ListOptions
	}
	lockRoleBindingInterfaceMockDeleteCollection.RLock()
	calls = mock.calls.DeleteCollection
	lockRoleBindingInterfaceMockDeleteCollection.RUnlock()
	return calls
}

// DeleteNamespaced calls DeleteNamespacedFunc.
func (mock *RoleBindingInterfaceMock) DeleteNamespaced(namespace string, name string, options *metav1.DeleteOptions) error {
	if mock.DeleteNamespacedFunc == nil {
		panic("RoleBindingInterfaceMock.DeleteNamespacedFunc: method is nil but RoleBindingInterface.DeleteNamespaced was just called")
	}
	callInfo := struct {
		Namespace string
		Name      string
		Options   *metav1.DeleteOptions
	}{
		Namespace: namespace,
		Name:      name,
		Options:   options,
	}
	lockRoleBindingInterfaceMockDeleteNamespaced.Lock()
	mock.calls.DeleteNamespaced = append(mock.calls.DeleteNamespaced, callInfo)
	lockRoleBindingInterfaceMockDeleteNamespaced.Unlock()
	return mock.DeleteNamespacedFunc(namespace, name, options)
}

// DeleteNamespacedCalls gets all the calls that were made to DeleteNamespaced.
// Check the length with:
//     len(mockedRoleBindingInterface.DeleteNamespacedCalls())
func (mock *RoleBindingInterfaceMock) DeleteNamespacedCalls() []struct {
	Namespace string
	Name      string
	Options   *metav1.DeleteOptions
} {
	var calls []struct {
		Namespace string
		Name      string
		Options   *metav1.DeleteOptions
	}
	lockRoleBindingInterfaceMockDeleteNamespaced.RLock()
	calls = mock.calls.DeleteNamespaced
	lockRoleBindingInterfaceMockDeleteNamespaced.RUnlock()
	return calls
}

// Get calls GetFunc.
func (mock *RoleBindingInterfaceMock) Get(name string, opts metav1.GetOptions) (*v1.RoleBinding, error) {
	if mock.GetFunc == nil {
		panic("RoleBindingInterfaceMock.GetFunc: method is nil but RoleBindingInterface.Get was just called")
	}
	callInfo := struct {
		Name string
		Opts metav1.GetOptions
	}{
		Name: name,
		Opts: opts,
	}
	lockRoleBindingInterfaceMockGet.Lock()
	mock.calls.Get = append(mock.calls.Get, callInfo)
	lockRoleBindingInterfaceMockGet.Unlock()
	return mock.GetFunc(name, opts)
}

// GetCalls gets all the calls that were made to Get.
// Check the length with:
//     len(mockedRoleBindingInterface.GetCalls())
func (mock *RoleBindingInterfaceMock) GetCalls() []struct {
	Name string
	Opts metav1.GetOptions
} {
	var calls []struct {
		Name string
		Opts metav1.GetOptions
	}
	lockRoleBindingInterfaceMockGet.RLock()
	calls = mock.calls.Get
	lockRoleBindingInterfaceMockGet.RUnlock()
	return calls
}

// GetNamespaced calls GetNamespacedFunc.
func (mock *RoleBindingInterfaceMock) GetNamespaced(namespace string, name string, opts metav1.GetOptions) (*v1.RoleBinding, error) {
	if mock.GetNamespacedFunc == nil {
		panic("RoleBindingInterfaceMock.GetNamespacedFunc: method is nil but RoleBindingInterface.GetNamespaced was just called")
	}
	callInfo := struct {
		Namespace string
		Name      string
		Opts      metav1.GetOptions
	}{
		Namespace: namespace,
		Name:      name,
		Opts:      opts,
	}
	lockRoleBindingInterfaceMockGetNamespaced.Lock()
	mock.calls.GetNamespaced = append(mock.calls.GetNamespaced, callInfo)
	lockRoleBindingInterfaceMockGetNamespaced.Unlock()
	return mock.GetNamespacedFunc(namespace, name, opts)
}

// GetNamespacedCalls gets all the calls that were made to GetNamespaced.
// Check the length with:
//     len(mockedRoleBindingInterface.GetNamespacedCalls())
func (mock *RoleBindingInterfaceMock) GetNamespacedCalls() []struct {
	Namespace string
	Name      string
	Opts      metav1.GetOptions
} {
	var calls []struct {
		Namespace string
		Name      string
		Opts      metav1.GetOptions
	}
	lockRoleBindingInterfaceMockGetNamespaced.RLock()
	calls = mock.calls.GetNamespaced
	lockRoleBindingInterfaceMockGetNamespaced.RUnlock()
	return calls
}

// List calls ListFunc.
func (mock *RoleBindingInterfaceMock) List(opts metav1.ListOptions) (*v1.RoleBindingList, error) {
	if mock.ListFunc == nil {
		panic("RoleBindingInterfaceMock.ListFunc: method is nil but RoleBindingInterface.List was just called")
	}
	callInfo := struct {
		Opts metav1.ListOptions
	}{
		Opts: opts,
	}
	lockRoleBindingInterfaceMockList.Lock()
	mock.calls.List = append(mock.calls.List, callInfo)
	lockRoleBindingInterfaceMockList.Unlock()
	return mock.ListFunc(opts)
}

// ListCalls gets all the calls that were made to List.
// Check the length with:
//     len(mockedRoleBindingInterface.ListCalls())
func (mock *RoleBindingInterfaceMock) ListCalls() []struct {
	Opts metav1.ListOptions
} {
	var calls []struct {
		Opts metav1.ListOptions
	}
	lockRoleBindingInterfaceMockList.RLock()
	calls = mock.calls.List
	lockRoleBindingInterfaceMockList.RUnlock()
	return calls
}

// ListNamespaced calls ListNamespacedFunc.
func (mock *RoleBindingInterfaceMock) ListNamespaced(namespace string, opts metav1.ListOptions) (*v1.RoleBindingList, error) {
	if mock.ListNamespacedFunc == nil {
		panic("RoleBindingInterfaceMock.ListNamespacedFunc: method is nil but RoleBindingInterface.ListNamespaced was just called")
	}
	callInfo := struct {
		Namespace string
		Opts      metav1.ListOptions
	}{
		Namespace: namespace,
		Opts:      opts,
	}
	lockRoleBindingInterfaceMockListNamespaced.Lock()
	mock.calls.ListNamespaced = append(mock.calls.ListNamespaced, callInfo)
	lockRoleBindingInterfaceMockListNamespaced.Unlock()
	return mock.ListNamespacedFunc(namespace, opts)
}

// ListNamespacedCalls gets all the calls that were made to ListNamespaced.
// Check the length with:
//     len(mockedRoleBindingInterface.ListNamespacedCalls())
func (mock *RoleBindingInterfaceMock) ListNamespacedCalls() []struct {
	Namespace string
	Opts      metav1.ListOptions
} {
	var calls []struct {
		Namespace string
		Opts      metav1.ListOptions
	}
	lockRoleBindingInterfaceMockListNamespaced.RLock()
	calls = mock.calls.ListNamespaced
	lockRoleBindingInterfaceMockListNamespaced.RUnlock()
	return calls
}

// ObjectClient calls ObjectClientFunc.
func (mock *RoleBindingInterfaceMock) ObjectClient() *objectclient.ObjectClient {
	if mock.ObjectClientFunc == nil {
		panic("RoleBindingInterfaceMock.ObjectClientFunc: method is nil but RoleBindingInterface.ObjectClient was just called")
	}
	callInfo := struct {
	}{}
	lockRoleBindingInterfaceMockObjectClient.Lock()
	mock.calls.ObjectClient = append(mock.calls.ObjectClient, callInfo)
	lockRoleBindingInterfaceMockObjectClient.Unlock()
	return mock.ObjectClientFunc()
}

// ObjectClientCalls gets all the calls that were made to ObjectClient.
// Check the length with:
//     len(mockedRoleBindingInterface.ObjectClientCalls())
func (mock *RoleBindingInterfaceMock) ObjectClientCalls() []struct {
} {
	var calls []struct {
	}
	lockRoleBindingInterfaceMockObjectClient.RLock()
	calls = mock.calls.ObjectClient
	lockRoleBindingInterfaceMockObjectClient.RUnlock()
	return calls
}

// Update calls UpdateFunc.
func (mock *RoleBindingInterfaceMock) Update(in1 *v1.RoleBinding) (*v1.RoleBinding, error) {
	if mock.UpdateFunc == nil {
		panic("RoleBindingInterfaceMock.UpdateFunc: method is nil but RoleBindingInterface.Update was just called")
	}
	callInfo := struct {
		In1 *v1.RoleBinding
	}{
		In1: in1,
	}
	lockRoleBindingInterfaceMockUpdate.Lock()
	mock.calls.Update = append(mock.calls.Update, callInfo)
	lockRoleBindingInterfaceMockUpdate.Unlock()
	return mock.UpdateFunc(in1)
}

// UpdateCalls gets all the calls that were made to Update.
// Check the length with:
//     len(mockedRoleBindingInterface.UpdateCalls())
func (mock *RoleBindingInterfaceMock) UpdateCalls() []struct {
	In1 *v1.RoleBinding
} {
	var calls []struct {
		In1 *v1.RoleBinding
	}
	lockRoleBindingInterfaceMockUpdate.RLock()
	calls = mock.calls.Update
	lockRoleBindingInterfaceMockUpdate.RUnlock()
	return calls
}

// Watch calls WatchFunc.
func (mock *RoleBindingInterfaceMock) Watch(opts metav1.ListOptions) (watch.Interface, error) {
	if mock.WatchFunc == nil {
		panic("RoleBindingInterfaceMock.WatchFunc: method is nil but RoleBindingInterface.Watch was just called")
	}
	callInfo := struct {
		Opts metav1.ListOptions
	}{
		Opts: opts,
	}
	lockRoleBindingInterfaceMockWatch.Lock()
	mock.calls.Watch = append(mock.calls.Watch, callInfo)
	lockRoleBindingInterfaceMockWatch.Unlock()
	return mock.WatchFunc(opts)
}

// WatchCalls gets all the calls that were made to Watch.
// Check the length with:
//     len(mockedRoleBindingInterface.WatchCalls())
func (mock *RoleBindingInterfaceMock) WatchCalls() []struct {
	Opts metav1.ListOptions
} {
	var calls []struct {
		Opts metav1.ListOptions
	}
	lockRoleBindingInterfaceMockWatch.RLock()
	calls = mock.calls.Watch
	lockRoleBindingInterfaceMockWatch.RUnlock()
	return calls
}

var (
	lockRoleBindingsGetterMockRoleBindings sync.RWMutex
)

// Ensure, that RoleBindingsGetterMock does implement v11.RoleBindingsGetter.
// If this is not the case, regenerate this file with moq.
var _ v11.RoleBindingsGetter = &RoleBindingsGetterMock{}

// RoleBindingsGetterMock is a mock implementation of v11.RoleBindingsGetter.
//
//     func TestSomethingThatUsesRoleBindingsGetter(t *testing.T) {
//
//         // make and configure a mocked v11.RoleBindingsGetter
//         mockedRoleBindingsGetter := &RoleBindingsGetterMock{
//             RoleBindingsFunc: func(namespace string) v11.RoleBindingInterface {
// 	               panic("mock out the RoleBindings method")
//             },
//         }
//
//         // use mockedRoleBindingsGetter in code that requires v11.RoleBindingsGetter
//         // and then make assertions.
//
//     }
type RoleBindingsGetterMock struct {
	// RoleBindingsFunc mocks the RoleBindings method.
	RoleBindingsFunc func(namespace string) v11.RoleBindingInterface

	// calls tracks calls to the methods.
	calls struct {
		// RoleBindings holds details about calls to the RoleBindings method.
		RoleBindings []struct {
			// Namespace is the namespace argument value.
			Namespace string
		}
	}
}

// RoleBindings calls RoleBindingsFunc.
func (mock *RoleBindingsGetterMock) RoleBindings(namespace string) v11.RoleBindingInterface {
	if mock.RoleBindingsFunc == nil {
		panic("RoleBindingsGetterMock.RoleBindingsFunc: method is nil but RoleBindingsGetter.RoleBindings was just called")
	}
	callInfo := struct {
		Namespace string
	}{
		Namespace: namespace,
	}
	lockRoleBindingsGetterMockRoleBindings.Lock()
	mock.calls.RoleBindings = append(mock.calls.RoleBindings, callInfo)
	lockRoleBindingsGetterMockRoleBindings.Unlock()
	return mock.RoleBindingsFunc(namespace)
}

// RoleBindingsCalls gets all the calls that were made to RoleBindings.
// Check the length with:
//     len(mockedRoleBindingsGetter.RoleBindingsCalls())
func (mock *RoleBindingsGetterMock) RoleBindingsCalls() []struct {
	Namespace string
} {
	var calls []struct {
		Namespace string
	}
	lockRoleBindingsGetterMockRoleBindings.RLock()
	calls = mock.calls.RoleBindings
	lockRoleBindingsGetterMockRoleBindings.RUnlock()
	return calls
}
