// Code generated by moq; DO NOT EDIT.
// github.com/matryer/moq

package fakes

import (
	"context"
	"sync"
	"time"

	"github.com/rancher/norman/controller"
	"github.com/rancher/norman/objectclient"
	v11 "github.com/rancher/rancher/pkg/generated/norman/rbac.authorization.k8s.io/v1"
	v1 "k8s.io/api/rbac/v1"
	metav1 "k8s.io/apimachinery/pkg/apis/meta/v1"
	"k8s.io/apimachinery/pkg/labels"
	"k8s.io/apimachinery/pkg/watch"
	"k8s.io/client-go/tools/cache"
)

var (
	lockRoleListerMockGet  sync.RWMutex
	lockRoleListerMockList sync.RWMutex
)

// Ensure, that RoleListerMock does implement v11.RoleLister.
// If this is not the case, regenerate this file with moq.
var _ v11.RoleLister = &RoleListerMock{}

// RoleListerMock is a mock implementation of v11.RoleLister.
//
//     func TestSomethingThatUsesRoleLister(t *testing.T) {
//
//         // make and configure a mocked v11.RoleLister
//         mockedRoleLister := &RoleListerMock{
//             GetFunc: func(namespace string, name string) (*v1.Role, error) {
// 	               panic("mock out the Get method")
//             },
//             ListFunc: func(namespace string, selector labels.Selector) ([]*v1.Role, error) {
// 	               panic("mock out the List method")
//             },
//         }
//
//         // use mockedRoleLister in code that requires v11.RoleLister
//         // and then make assertions.
//
//     }
type RoleListerMock struct {
	// GetFunc mocks the Get method.
	GetFunc func(namespace string, name string) (*v1.Role, error)

	// ListFunc mocks the List method.
	ListFunc func(namespace string, selector labels.Selector) ([]*v1.Role, error)

	// calls tracks calls to the methods.
	calls struct {
		// Get holds details about calls to the Get method.
		Get []struct {
			// Namespace is the namespace argument value.
			Namespace string
			// Name is the name argument value.
			Name string
		}
		// List holds details about calls to the List method.
		List []struct {
			// Namespace is the namespace argument value.
			Namespace string
			// Selector is the selector argument value.
			Selector labels.Selector
		}
	}
}

// Get calls GetFunc.
func (mock *RoleListerMock) Get(namespace string, name string) (*v1.Role, error) {
	if mock.GetFunc == nil {
		panic("RoleListerMock.GetFunc: method is nil but RoleLister.Get was just called")
	}
	callInfo := struct {
		Namespace string
		Name      string
	}{
		Namespace: namespace,
		Name:      name,
	}
	lockRoleListerMockGet.Lock()
	mock.calls.Get = append(mock.calls.Get, callInfo)
	lockRoleListerMockGet.Unlock()
	return mock.GetFunc(namespace, name)
}

// GetCalls gets all the calls that were made to Get.
// Check the length with:
//     len(mockedRoleLister.GetCalls())
func (mock *RoleListerMock) GetCalls() []struct {
	Namespace string
	Name      string
} {
	var calls []struct {
		Namespace string
		Name      string
	}
	lockRoleListerMockGet.RLock()
	calls = mock.calls.Get
	lockRoleListerMockGet.RUnlock()
	return calls
}

// List calls ListFunc.
func (mock *RoleListerMock) List(namespace string, selector labels.Selector) ([]*v1.Role, error) {
	if mock.ListFunc == nil {
		panic("RoleListerMock.ListFunc: method is nil but RoleLister.List was just called")
	}
	callInfo := struct {
		Namespace string
		Selector  labels.Selector
	}{
		Namespace: namespace,
		Selector:  selector,
	}
	lockRoleListerMockList.Lock()
	mock.calls.List = append(mock.calls.List, callInfo)
	lockRoleListerMockList.Unlock()
	return mock.ListFunc(namespace, selector)
}

// ListCalls gets all the calls that were made to List.
// Check the length with:
//     len(mockedRoleLister.ListCalls())
func (mock *RoleListerMock) ListCalls() []struct {
	Namespace string
	Selector  labels.Selector
} {
	var calls []struct {
		Namespace string
		Selector  labels.Selector
	}
	lockRoleListerMockList.RLock()
	calls = mock.calls.List
	lockRoleListerMockList.RUnlock()
	return calls
}

var (
	lockRoleControllerMockAddClusterScopedFeatureHandler sync.RWMutex
	lockRoleControllerMockAddClusterScopedHandler        sync.RWMutex
	lockRoleControllerMockAddFeatureHandler              sync.RWMutex
	lockRoleControllerMockAddHandler                     sync.RWMutex
	lockRoleControllerMockEnqueue                        sync.RWMutex
	lockRoleControllerMockEnqueueAfter                   sync.RWMutex
	lockRoleControllerMockGeneric                        sync.RWMutex
	lockRoleControllerMockInformer                       sync.RWMutex
	lockRoleControllerMockLister                         sync.RWMutex
)

// Ensure, that RoleControllerMock does implement v11.RoleController.
// If this is not the case, regenerate this file with moq.
var _ v11.RoleController = &RoleControllerMock{}

// RoleControllerMock is a mock implementation of v11.RoleController.
//
//     func TestSomethingThatUsesRoleController(t *testing.T) {
//
//         // make and configure a mocked v11.RoleController
//         mockedRoleController := &RoleControllerMock{
//             AddClusterScopedFeatureHandlerFunc: func(ctx context.Context, enabled func() bool, name string, clusterName string, handler v11.RoleHandlerFunc)  {
// 	               panic("mock out the AddClusterScopedFeatureHandler method")
//             },
//             AddClusterScopedHandlerFunc: func(ctx context.Context, name string, clusterName string, handler v11.RoleHandlerFunc)  {
// 	               panic("mock out the AddClusterScopedHandler method")
//             },
//             AddFeatureHandlerFunc: func(ctx context.Context, enabled func() bool, name string, syncMoqParam v11.RoleHandlerFunc)  {
// 	               panic("mock out the AddFeatureHandler method")
//             },
//             AddHandlerFunc: func(ctx context.Context, name string, handler v11.RoleHandlerFunc)  {
// 	               panic("mock out the AddHandler method")
//             },
//             EnqueueFunc: func(namespace string, name string)  {
// 	               panic("mock out the Enqueue method")
//             },
//             EnqueueAfterFunc: func(namespace string, name string, after time.Duration)  {
// 	               panic("mock out the EnqueueAfter method")
//             },
//             GenericFunc: func() controller.GenericController {
// 	               panic("mock out the Generic method")
//             },
//             InformerFunc: func() cache.SharedIndexInformer {
// 	               panic("mock out the Informer method")
//             },
//             ListerFunc: func() v11.RoleLister {
// 	               panic("mock out the Lister method")
//             },
//         }
//
//         // use mockedRoleController in code that requires v11.RoleController
//         // and then make assertions.
//
//     }
type RoleControllerMock struct {
	// AddClusterScopedFeatureHandlerFunc mocks the AddClusterScopedFeatureHandler method.
	AddClusterScopedFeatureHandlerFunc func(ctx context.Context, enabled func() bool, name string, clusterName string, handler v11.RoleHandlerFunc)

	// AddClusterScopedHandlerFunc mocks the AddClusterScopedHandler method.
	AddClusterScopedHandlerFunc func(ctx context.Context, name string, clusterName string, handler v11.RoleHandlerFunc)

	// AddFeatureHandlerFunc mocks the AddFeatureHandler method.
	AddFeatureHandlerFunc func(ctx context.Context, enabled func() bool, name string, syncMoqParam v11.RoleHandlerFunc)

	// AddHandlerFunc mocks the AddHandler method.
	AddHandlerFunc func(ctx context.Context, name string, handler v11.RoleHandlerFunc)

	// EnqueueFunc mocks the Enqueue method.
	EnqueueFunc func(namespace string, name string)

	// EnqueueAfterFunc mocks the EnqueueAfter method.
	EnqueueAfterFunc func(namespace string, name string, after time.Duration)

	// GenericFunc mocks the Generic method.
	GenericFunc func() controller.GenericController

	// InformerFunc mocks the Informer method.
	InformerFunc func() cache.SharedIndexInformer

	// ListerFunc mocks the Lister method.
	ListerFunc func() v11.RoleLister

	// calls tracks calls to the methods.
	calls struct {
		// AddClusterScopedFeatureHandler holds details about calls to the AddClusterScopedFeatureHandler method.
		AddClusterScopedFeatureHandler []struct {
			// Ctx is the ctx argument value.
			Ctx context.Context
			// Enabled is the enabled argument value.
			Enabled func() bool
			// Name is the name argument value.
			Name string
			// ClusterName is the clusterName argument value.
			ClusterName string
			// Handler is the handler argument value.
			Handler v11.RoleHandlerFunc
		}
		// AddClusterScopedHandler holds details about calls to the AddClusterScopedHandler method.
		AddClusterScopedHandler []struct {
			// Ctx is the ctx argument value.
			Ctx context.Context
			// Name is the name argument value.
			Name string
			// ClusterName is the clusterName argument value.
			ClusterName string
			// Handler is the handler argument value.
			Handler v11.RoleHandlerFunc
		}
		// AddFeatureHandler holds details about calls to the AddFeatureHandler method.
		AddFeatureHandler []struct {
			// Ctx is the ctx argument value.
			Ctx context.Context
			// Enabled is the enabled argument value.
			Enabled func() bool
			// Name is the name argument value.
			Name string
			// Sync is the sync argument value.
			Sync v11.RoleHandlerFunc
		}
		// AddHandler holds details about calls to the AddHandler method.
		AddHandler []struct {
			// Ctx is the ctx argument value.
			Ctx context.Context
			// Name is the name argument value.
			Name string
			// Handler is the handler argument value.
			Handler v11.RoleHandlerFunc
		}
		// Enqueue holds details about calls to the Enqueue method.
		Enqueue []struct {
			// Namespace is the namespace argument value.
			Namespace string
			// Name is the name argument value.
			Name string
		}
		// EnqueueAfter holds details about calls to the EnqueueAfter method.
		EnqueueAfter []struct {
			// Namespace is the namespace argument value.
			Namespace string
			// Name is the name argument value.
			Name string
			// After is the after argument value.
			After time.Duration
		}
		// Generic holds details about calls to the Generic method.
		Generic []struct {
		}
		// Informer holds details about calls to the Informer method.
		Informer []struct {
		}
		// Lister holds details about calls to the Lister method.
		Lister []struct {
		}
	}
}

// AddClusterScopedFeatureHandler calls AddClusterScopedFeatureHandlerFunc.
func (mock *RoleControllerMock) AddClusterScopedFeatureHandler(ctx context.Context, enabled func() bool, name string, clusterName string, handler v11.RoleHandlerFunc) {
	if mock.AddClusterScopedFeatureHandlerFunc == nil {
		panic("RoleControllerMock.AddClusterScopedFeatureHandlerFunc: method is nil but RoleController.AddClusterScopedFeatureHandler was just called")
	}
	callInfo := struct {
		Ctx         context.Context
		Enabled     func() bool
		Name        string
		ClusterName string
		Handler     v11.RoleHandlerFunc
	}{
		Ctx:         ctx,
		Enabled:     enabled,
		Name:        name,
		ClusterName: clusterName,
		Handler:     handler,
	}
	lockRoleControllerMockAddClusterScopedFeatureHandler.Lock()
	mock.calls.AddClusterScopedFeatureHandler = append(mock.calls.AddClusterScopedFeatureHandler, callInfo)
	lockRoleControllerMockAddClusterScopedFeatureHandler.Unlock()
	mock.AddClusterScopedFeatureHandlerFunc(ctx, enabled, name, clusterName, handler)
}

// AddClusterScopedFeatureHandlerCalls gets all the calls that were made to AddClusterScopedFeatureHandler.
// Check the length with:
//     len(mockedRoleController.AddClusterScopedFeatureHandlerCalls())
func (mock *RoleControllerMock) AddClusterScopedFeatureHandlerCalls() []struct {
	Ctx         context.Context
	Enabled     func() bool
	Name        string
	ClusterName string
	Handler     v11.RoleHandlerFunc
} {
	var calls []struct {
		Ctx         context.Context
		Enabled     func() bool
		Name        string
		ClusterName string
		Handler     v11.RoleHandlerFunc
	}
	lockRoleControllerMockAddClusterScopedFeatureHandler.RLock()
	calls = mock.calls.AddClusterScopedFeatureHandler
	lockRoleControllerMockAddClusterScopedFeatureHandler.RUnlock()
	return calls
}

// AddClusterScopedHandler calls AddClusterScopedHandlerFunc.
func (mock *RoleControllerMock) AddClusterScopedHandler(ctx context.Context, name string, clusterName string, handler v11.RoleHandlerFunc) {
	if mock.AddClusterScopedHandlerFunc == nil {
		panic("RoleControllerMock.AddClusterScopedHandlerFunc: method is nil but RoleController.AddClusterScopedHandler was just called")
	}
	callInfo := struct {
		Ctx         context.Context
		Name        string
		ClusterName string
		Handler     v11.RoleHandlerFunc
	}{
		Ctx:         ctx,
		Name:        name,
		ClusterName: clusterName,
		Handler:     handler,
	}
	lockRoleControllerMockAddClusterScopedHandler.Lock()
	mock.calls.AddClusterScopedHandler = append(mock.calls.AddClusterScopedHandler, callInfo)
	lockRoleControllerMockAddClusterScopedHandler.Unlock()
	mock.AddClusterScopedHandlerFunc(ctx, name, clusterName, handler)
}

// AddClusterScopedHandlerCalls gets all the calls that were made to AddClusterScopedHandler.
// Check the length with:
//     len(mockedRoleController.AddClusterScopedHandlerCalls())
func (mock *RoleControllerMock) AddClusterScopedHandlerCalls() []struct {
	Ctx         context.Context
	Name        string
	ClusterName string
	Handler     v11.RoleHandlerFunc
} {
	var calls []struct {
		Ctx         context.Context
		Name        string
		ClusterName string
		Handler     v11.RoleHandlerFunc
	}
	lockRoleControllerMockAddClusterScopedHandler.RLock()
	calls = mock.calls.AddClusterScopedHandler
	lockRoleControllerMockAddClusterScopedHandler.RUnlock()
	return calls
}

// AddFeatureHandler calls AddFeatureHandlerFunc.
func (mock *RoleControllerMock) AddFeatureHandler(ctx context.Context, enabled func() bool, name string, syncMoqParam v11.RoleHandlerFunc) {
	if mock.AddFeatureHandlerFunc == nil {
		panic("RoleControllerMock.AddFeatureHandlerFunc: method is nil but RoleController.AddFeatureHandler was just called")
	}
	callInfo := struct {
		Ctx     context.Context
		Enabled func() bool
		Name    string
		Sync    v11.RoleHandlerFunc
	}{
		Ctx:     ctx,
		Enabled: enabled,
		Name:    name,
		Sync:    syncMoqParam,
	}
	lockRoleControllerMockAddFeatureHandler.Lock()
	mock.calls.AddFeatureHandler = append(mock.calls.AddFeatureHandler, callInfo)
	lockRoleControllerMockAddFeatureHandler.Unlock()
	mock.AddFeatureHandlerFunc(ctx, enabled, name, syncMoqParam)
}

// AddFeatureHandlerCalls gets all the calls that were made to AddFeatureHandler.
// Check the length with:
//     len(mockedRoleController.AddFeatureHandlerCalls())
func (mock *RoleControllerMock) AddFeatureHandlerCalls() []struct {
	Ctx     context.Context
	Enabled func() bool
	Name    string
	Sync    v11.RoleHandlerFunc
} {
	var calls []struct {
		Ctx     context.Context
		Enabled func() bool
		Name    string
		Sync    v11.RoleHandlerFunc
	}
	lockRoleControllerMockAddFeatureHandler.RLock()
	calls = mock.calls.AddFeatureHandler
	lockRoleControllerMockAddFeatureHandler.RUnlock()
	return calls
}

// AddHandler calls AddHandlerFunc.
func (mock *RoleControllerMock) AddHandler(ctx context.Context, name string, handler v11.RoleHandlerFunc) {
	if mock.AddHandlerFunc == nil {
		panic("RoleControllerMock.AddHandlerFunc: method is nil but RoleController.AddHandler was just called")
	}
	callInfo := struct {
		Ctx     context.Context
		Name    string
		Handler v11.RoleHandlerFunc
	}{
		Ctx:     ctx,
		Name:    name,
		Handler: handler,
	}
	lockRoleControllerMockAddHandler.Lock()
	mock.calls.AddHandler = append(mock.calls.AddHandler, callInfo)
	lockRoleControllerMockAddHandler.Unlock()
	mock.AddHandlerFunc(ctx, name, handler)
}

// AddHandlerCalls gets all the calls that were made to AddHandler.
// Check the length with:
//     len(mockedRoleController.AddHandlerCalls())
func (mock *RoleControllerMock) AddHandlerCalls() []struct {
	Ctx     context.Context
	Name    string
	Handler v11.RoleHandlerFunc
} {
	var calls []struct {
		Ctx     context.Context
		Name    string
		Handler v11.RoleHandlerFunc
	}
	lockRoleControllerMockAddHandler.RLock()
	calls = mock.calls.AddHandler
	lockRoleControllerMockAddHandler.RUnlock()
	return calls
}

// Enqueue calls EnqueueFunc.
func (mock *RoleControllerMock) Enqueue(namespace string, name string) {
	if mock.EnqueueFunc == nil {
		panic("RoleControllerMock.EnqueueFunc: method is nil but RoleController.Enqueue was just called")
	}
	callInfo := struct {
		Namespace string
		Name      string
	}{
		Namespace: namespace,
		Name:      name,
	}
	lockRoleControllerMockEnqueue.Lock()
	mock.calls.Enqueue = append(mock.calls.Enqueue, callInfo)
	lockRoleControllerMockEnqueue.Unlock()
	mock.EnqueueFunc(namespace, name)
}

// EnqueueCalls gets all the calls that were made to Enqueue.
// Check the length with:
//     len(mockedRoleController.EnqueueCalls())
func (mock *RoleControllerMock) EnqueueCalls() []struct {
	Namespace string
	Name      string
} {
	var calls []struct {
		Namespace string
		Name      string
	}
	lockRoleControllerMockEnqueue.RLock()
	calls = mock.calls.Enqueue
	lockRoleControllerMockEnqueue.RUnlock()
	return calls
}

// EnqueueAfter calls EnqueueAfterFunc.
func (mock *RoleControllerMock) EnqueueAfter(namespace string, name string, after time.Duration) {
	if mock.EnqueueAfterFunc == nil {
		panic("RoleControllerMock.EnqueueAfterFunc: method is nil but RoleController.EnqueueAfter was just called")
	}
	callInfo := struct {
		Namespace string
		Name      string
		After     time.Duration
	}{
		Namespace: namespace,
		Name:      name,
		After:     after,
	}
	lockRoleControllerMockEnqueueAfter.Lock()
	mock.calls.EnqueueAfter = append(mock.calls.EnqueueAfter, callInfo)
	lockRoleControllerMockEnqueueAfter.Unlock()
	mock.EnqueueAfterFunc(namespace, name, after)
}

// EnqueueAfterCalls gets all the calls that were made to EnqueueAfter.
// Check the length with:
//     len(mockedRoleController.EnqueueAfterCalls())
func (mock *RoleControllerMock) EnqueueAfterCalls() []struct {
	Namespace string
	Name      string
	After     time.Duration
} {
	var calls []struct {
		Namespace string
		Name      string
		After     time.Duration
	}
	lockRoleControllerMockEnqueueAfter.RLock()
	calls = mock.calls.EnqueueAfter
	lockRoleControllerMockEnqueueAfter.RUnlock()
	return calls
}

// Generic calls GenericFunc.
func (mock *RoleControllerMock) Generic() controller.GenericController {
	if mock.GenericFunc == nil {
		panic("RoleControllerMock.GenericFunc: method is nil but RoleController.Generic was just called")
	}
	callInfo := struct {
	}{}
	lockRoleControllerMockGeneric.Lock()
	mock.calls.Generic = append(mock.calls.Generic, callInfo)
	lockRoleControllerMockGeneric.Unlock()
	return mock.GenericFunc()
}

// GenericCalls gets all the calls that were made to Generic.
// Check the length with:
//     len(mockedRoleController.GenericCalls())
func (mock *RoleControllerMock) GenericCalls() []struct {
} {
	var calls []struct {
	}
	lockRoleControllerMockGeneric.RLock()
	calls = mock.calls.Generic
	lockRoleControllerMockGeneric.RUnlock()
	return calls
}

// Informer calls InformerFunc.
func (mock *RoleControllerMock) Informer() cache.SharedIndexInformer {
	if mock.InformerFunc == nil {
		panic("RoleControllerMock.InformerFunc: method is nil but RoleController.Informer was just called")
	}
	callInfo := struct {
	}{}
	lockRoleControllerMockInformer.Lock()
	mock.calls.Informer = append(mock.calls.Informer, callInfo)
	lockRoleControllerMockInformer.Unlock()
	return mock.InformerFunc()
}

// InformerCalls gets all the calls that were made to Informer.
// Check the length with:
//     len(mockedRoleController.InformerCalls())
func (mock *RoleControllerMock) InformerCalls() []struct {
} {
	var calls []struct {
	}
	lockRoleControllerMockInformer.RLock()
	calls = mock.calls.Informer
	lockRoleControllerMockInformer.RUnlock()
	return calls
}

// Lister calls ListerFunc.
func (mock *RoleControllerMock) Lister() v11.RoleLister {
	if mock.ListerFunc == nil {
		panic("RoleControllerMock.ListerFunc: method is nil but RoleController.Lister was just called")
	}
	callInfo := struct {
	}{}
	lockRoleControllerMockLister.Lock()
	mock.calls.Lister = append(mock.calls.Lister, callInfo)
	lockRoleControllerMockLister.Unlock()
	return mock.ListerFunc()
}

// ListerCalls gets all the calls that were made to Lister.
// Check the length with:
//     len(mockedRoleController.ListerCalls())
func (mock *RoleControllerMock) ListerCalls() []struct {
} {
	var calls []struct {
	}
	lockRoleControllerMockLister.RLock()
	calls = mock.calls.Lister
	lockRoleControllerMockLister.RUnlock()
	return calls
}

var (
	lockRoleInterfaceMockAddClusterScopedFeatureHandler   sync.RWMutex
	lockRoleInterfaceMockAddClusterScopedFeatureLifecycle sync.RWMutex
	lockRoleInterfaceMockAddClusterScopedHandler          sync.RWMutex
	lockRoleInterfaceMockAddClusterScopedLifecycle        sync.RWMutex
	lockRoleInterfaceMockAddFeatureHandler                sync.RWMutex
	lockRoleInterfaceMockAddFeatureLifecycle              sync.RWMutex
	lockRoleInterfaceMockAddHandler                       sync.RWMutex
	lockRoleInterfaceMockAddLifecycle                     sync.RWMutex
	lockRoleInterfaceMockController                       sync.RWMutex
	lockRoleInterfaceMockCreate                           sync.RWMutex
	lockRoleInterfaceMockDelete                           sync.RWMutex
	lockRoleInterfaceMockDeleteCollection                 sync.RWMutex
	lockRoleInterfaceMockDeleteNamespaced                 sync.RWMutex
	lockRoleInterfaceMockGet                              sync.RWMutex
	lockRoleInterfaceMockGetNamespaced                    sync.RWMutex
	lockRoleInterfaceMockList                             sync.RWMutex
	lockRoleInterfaceMockListNamespaced                   sync.RWMutex
	lockRoleInterfaceMockObjectClient                     sync.RWMutex
	lockRoleInterfaceMockUpdate                           sync.RWMutex
	lockRoleInterfaceMockWatch                            sync.RWMutex
)

// Ensure, that RoleInterfaceMock does implement v11.RoleInterface.
// If this is not the case, regenerate this file with moq.
var _ v11.RoleInterface = &RoleInterfaceMock{}

// RoleInterfaceMock is a mock implementation of v11.RoleInterface.
//
//     func TestSomethingThatUsesRoleInterface(t *testing.T) {
//
//         // make and configure a mocked v11.RoleInterface
//         mockedRoleInterface := &RoleInterfaceMock{
//             AddClusterScopedFeatureHandlerFunc: func(ctx context.Context, enabled func() bool, name string, clusterName string, syncMoqParam v11.RoleHandlerFunc)  {
// 	               panic("mock out the AddClusterScopedFeatureHandler method")
//             },
//             AddClusterScopedFeatureLifecycleFunc: func(ctx context.Context, enabled func() bool, name string, clusterName string, lifecycle v11.RoleLifecycle)  {
// 	               panic("mock out the AddClusterScopedFeatureLifecycle method")
//             },
//             AddClusterScopedHandlerFunc: func(ctx context.Context, name string, clusterName string, syncMoqParam v11.RoleHandlerFunc)  {
// 	               panic("mock out the AddClusterScopedHandler method")
//             },
//             AddClusterScopedLifecycleFunc: func(ctx context.Context, name string, clusterName string, lifecycle v11.RoleLifecycle)  {
// 	               panic("mock out the AddClusterScopedLifecycle method")
//             },
//             AddFeatureHandlerFunc: func(ctx context.Context, enabled func() bool, name string, syncMoqParam v11.RoleHandlerFunc)  {
// 	               panic("mock out the AddFeatureHandler method")
//             },
//             AddFeatureLifecycleFunc: func(ctx context.Context, enabled func() bool, name string, lifecycle v11.RoleLifecycle)  {
// 	               panic("mock out the AddFeatureLifecycle method")
//             },
//             AddHandlerFunc: func(ctx context.Context, name string, syncMoqParam v11.RoleHandlerFunc)  {
// 	               panic("mock out the AddHandler method")
//             },
//             AddLifecycleFunc: func(ctx context.Context, name string, lifecycle v11.RoleLifecycle)  {
// 	               panic("mock out the AddLifecycle method")
//             },
//             ControllerFunc: func() v11.RoleController {
// 	               panic("mock out the Controller method")
//             },
//             CreateFunc: func(in1 *v1.Role) (*v1.Role, error) {
// 	               panic("mock out the Create method")
//             },
//             DeleteFunc: func(name string, options *metav1.DeleteOptions) error {
// 	               panic("mock out the Delete method")
//             },
//             DeleteCollectionFunc: func(deleteOpts *metav1.DeleteOptions, listOpts metav1.ListOptions) error {
// 	               panic("mock out the DeleteCollection method")
//             },
//             DeleteNamespacedFunc: func(namespace string, name string, options *metav1.DeleteOptions) error {
// 	               panic("mock out the DeleteNamespaced method")
//             },
//             GetFunc: func(name string, opts metav1.GetOptions) (*v1.Role, error) {
// 	               panic("mock out the Get method")
//             },
//             GetNamespacedFunc: func(namespace string, name string, opts metav1.GetOptions) (*v1.Role, error) {
// 	               panic("mock out the GetNamespaced method")
//             },
//             ListFunc: func(opts metav1.ListOptions) (*v1.RoleList, error) {
// 	               panic("mock out the List method")
//             },
//             ListNamespacedFunc: func(namespace string, opts metav1.ListOptions) (*v1.RoleList, error) {
// 	               panic("mock out the ListNamespaced method")
//             },
//             ObjectClientFunc: func() *objectclient.ObjectClient {
// 	               panic("mock out the ObjectClient method")
//             },
//             UpdateFunc: func(in1 *v1.Role) (*v1.Role, error) {
// 	               panic("mock out the Update method")
//             },
//             WatchFunc: func(opts metav1.ListOptions) (watch.Interface, error) {
// 	               panic("mock out the Watch method")
//             },
//         }
//
//         // use mockedRoleInterface in code that requires v11.RoleInterface
//         // and then make assertions.
//
//     }
type RoleInterfaceMock struct {
	// AddClusterScopedFeatureHandlerFunc mocks the AddClusterScopedFeatureHandler method.
	AddClusterScopedFeatureHandlerFunc func(ctx context.Context, enabled func() bool, name string, clusterName string, syncMoqParam v11.RoleHandlerFunc)

	// AddClusterScopedFeatureLifecycleFunc mocks the AddClusterScopedFeatureLifecycle method.
	AddClusterScopedFeatureLifecycleFunc func(ctx context.Context, enabled func() bool, name string, clusterName string, lifecycle v11.RoleLifecycle)

	// AddClusterScopedHandlerFunc mocks the AddClusterScopedHandler method.
	AddClusterScopedHandlerFunc func(ctx context.Context, name string, clusterName string, syncMoqParam v11.RoleHandlerFunc)

	// AddClusterScopedLifecycleFunc mocks the AddClusterScopedLifecycle method.
	AddClusterScopedLifecycleFunc func(ctx context.Context, name string, clusterName string, lifecycle v11.RoleLifecycle)

	// AddFeatureHandlerFunc mocks the AddFeatureHandler method.
	AddFeatureHandlerFunc func(ctx context.Context, enabled func() bool, name string, syncMoqParam v11.RoleHandlerFunc)

	// AddFeatureLifecycleFunc mocks the AddFeatureLifecycle method.
	AddFeatureLifecycleFunc func(ctx context.Context, enabled func() bool, name string, lifecycle v11.RoleLifecycle)

	// AddHandlerFunc mocks the AddHandler method.
	AddHandlerFunc func(ctx context.Context, name string, syncMoqParam v11.RoleHandlerFunc)

	// AddLifecycleFunc mocks the AddLifecycle method.
	AddLifecycleFunc func(ctx context.Context, name string, lifecycle v11.RoleLifecycle)

	// ControllerFunc mocks the Controller method.
	ControllerFunc func() v11.RoleController

	// CreateFunc mocks the Create method.
	CreateFunc func(in1 *v1.Role) (*v1.Role, error)

	// DeleteFunc mocks the Delete method.
	DeleteFunc func(name string, options *metav1.DeleteOptions) error

	// DeleteCollectionFunc mocks the DeleteCollection method.
	DeleteCollectionFunc func(deleteOpts *metav1.DeleteOptions, listOpts metav1.ListOptions) error

	// DeleteNamespacedFunc mocks the DeleteNamespaced method.
	DeleteNamespacedFunc func(namespace string, name string, options *metav1.DeleteOptions) error

	// GetFunc mocks the Get method.
	GetFunc func(name string, opts metav1.GetOptions) (*v1.Role, error)

	// GetNamespacedFunc mocks the GetNamespaced method.
	GetNamespacedFunc func(namespace string, name string, opts metav1.GetOptions) (*v1.Role, error)

	// ListFunc mocks the List method.
	ListFunc func(opts metav1.ListOptions) (*v1.RoleList, error)

	// ListNamespacedFunc mocks the ListNamespaced method.
	ListNamespacedFunc func(namespace string, opts metav1.ListOptions) (*v1.RoleList, error)

	// ObjectClientFunc mocks the ObjectClient method.
	ObjectClientFunc func() *objectclient.ObjectClient

	// UpdateFunc mocks the Update method.
	UpdateFunc func(in1 *v1.Role) (*v1.Role, error)

	// WatchFunc mocks the Watch method.
	WatchFunc func(opts metav1.ListOptions) (watch.Interface, error)

	// calls tracks calls to the methods.
	calls struct {
		// AddClusterScopedFeatureHandler holds details about calls to the AddClusterScopedFeatureHandler method.
		AddClusterScopedFeatureHandler []struct {
			// Ctx is the ctx argument value.
			Ctx context.Context
			// Enabled is the enabled argument value.
			Enabled func() bool
			// Name is the name argument value.
			Name string
			// ClusterName is the clusterName argument value.
			ClusterName string
			// Sync is the sync argument value.
			Sync v11.RoleHandlerFunc
		}
		// AddClusterScopedFeatureLifecycle holds details about calls to the AddClusterScopedFeatureLifecycle method.
		AddClusterScopedFeatureLifecycle []struct {
			// Ctx is the ctx argument value.
			Ctx context.Context
			// Enabled is the enabled argument value.
			Enabled func() bool
			// Name is the name argument value.
			Name string
			// ClusterName is the clusterName argument value.
			ClusterName string
			// Lifecycle is the lifecycle argument value.
			Lifecycle v11.RoleLifecycle
		}
		// AddClusterScopedHandler holds details about calls to the AddClusterScopedHandler method.
		AddClusterScopedHandler []struct {
			// Ctx is the ctx argument value.
			Ctx context.Context
			// Name is the name argument value.
			Name string
			// ClusterName is the clusterName argument value.
			ClusterName string
			// Sync is the sync argument value.
			Sync v11.RoleHandlerFunc
		}
		// AddClusterScopedLifecycle holds details about calls to the AddClusterScopedLifecycle method.
		AddClusterScopedLifecycle []struct {
			// Ctx is the ctx argument value.
			Ctx context.Context
			// Name is the name argument value.
			Name string
			// ClusterName is the clusterName argument value.
			ClusterName string
			// Lifecycle is the lifecycle argument value.
			Lifecycle v11.RoleLifecycle
		}
		// AddFeatureHandler holds details about calls to the AddFeatureHandler method.
		AddFeatureHandler []struct {
			// Ctx is the ctx argument value.
			Ctx context.Context
			// Enabled is the enabled argument value.
			Enabled func() bool
			// Name is the name argument value.
			Name string
			// Sync is the sync argument value.
			Sync v11.RoleHandlerFunc
		}
		// AddFeatureLifecycle holds details about calls to the AddFeatureLifecycle method.
		AddFeatureLifecycle []struct {
			// Ctx is the ctx argument value.
			Ctx context.Context
			// Enabled is the enabled argument value.
			Enabled func() bool
			// Name is the name argument value.
			Name string
			// Lifecycle is the lifecycle argument value.
			Lifecycle v11.RoleLifecycle
		}
		// AddHandler holds details about calls to the AddHandler method.
		AddHandler []struct {
			// Ctx is the ctx argument value.
			Ctx context.Context
			// Name is the name argument value.
			Name string
			// Sync is the sync argument value.
			Sync v11.RoleHandlerFunc
		}
		// AddLifecycle holds details about calls to the AddLifecycle method.
		AddLifecycle []struct {
			// Ctx is the ctx argument value.
			Ctx context.Context
			// Name is the name argument value.
			Name string
			// Lifecycle is the lifecycle argument value.
			Lifecycle v11.RoleLifecycle
		}
		// Controller holds details about calls to the Controller method.
		Controller []struct {
		}
		// Create holds details about calls to the Create method.
		Create []struct {
			// In1 is the in1 argument value.
			In1 *v1.Role
		}
		// Delete holds details about calls to the Delete method.
		Delete []struct {
			// Name is the name argument value.
			Name string
			// Options is the options argument value.
			Options *metav1.DeleteOptions
		}
		// DeleteCollection holds details about calls to the DeleteCollection method.
		DeleteCollection []struct {
			// DeleteOpts is the deleteOpts argument value.
			DeleteOpts *metav1.DeleteOptions
			// ListOpts is the listOpts argument value.
			ListOpts metav1.ListOptions
		}
		// DeleteNamespaced holds details about calls to the DeleteNamespaced method.
		DeleteNamespaced []struct {
			// Namespace is the namespace argument value.
			Namespace string
			// Name is the name argument value.
			Name string
			// Options is the options argument value.
			Options *metav1.DeleteOptions
		}
		// Get holds details about calls to the Get method.
		Get []struct {
			// Name is the name argument value.
			Name string
			// Opts is the opts argument value.
			Opts metav1.GetOptions
		}
		// GetNamespaced holds details about calls to the GetNamespaced method.
		GetNamespaced []struct {
			// Namespace is the namespace argument value.
			Namespace string
			// Name is the name argument value.
			Name string
			// Opts is the opts argument value.
			Opts metav1.GetOptions
		}
		// List holds details about calls to the List method.
		List []struct {
			// Opts is the opts argument value.
			Opts metav1.ListOptions
		}
		// ListNamespaced holds details about calls to the ListNamespaced method.
		ListNamespaced []struct {
			// Namespace is the namespace argument value.
			Namespace string
			// Opts is the opts argument value.
			Opts metav1.ListOptions
		}
		// ObjectClient holds details about calls to the ObjectClient method.
		ObjectClient []struct {
		}
		// Update holds details about calls to the Update method.
		Update []struct {
			// In1 is the in1 argument value.
			In1 *v1.Role
		}
		// Watch holds details about calls to the Watch method.
		Watch []struct {
			// Opts is the opts argument value.
			Opts metav1.ListOptions
		}
	}
}

// AddClusterScopedFeatureHandler calls AddClusterScopedFeatureHandlerFunc.
func (mock *RoleInterfaceMock) AddClusterScopedFeatureHandler(ctx context.Context, enabled func() bool, name string, clusterName string, syncMoqParam v11.RoleHandlerFunc) {
	if mock.AddClusterScopedFeatureHandlerFunc == nil {
		panic("RoleInterfaceMock.AddClusterScopedFeatureHandlerFunc: method is nil but RoleInterface.AddClusterScopedFeatureHandler was just called")
	}
	callInfo := struct {
		Ctx         context.Context
		Enabled     func() bool
		Name        string
		ClusterName string
		Sync        v11.RoleHandlerFunc
	}{
		Ctx:         ctx,
		Enabled:     enabled,
		Name:        name,
		ClusterName: clusterName,
		Sync:        syncMoqParam,
	}
	lockRoleInterfaceMockAddClusterScopedFeatureHandler.Lock()
	mock.calls.AddClusterScopedFeatureHandler = append(mock.calls.AddClusterScopedFeatureHandler, callInfo)
	lockRoleInterfaceMockAddClusterScopedFeatureHandler.Unlock()
	mock.AddClusterScopedFeatureHandlerFunc(ctx, enabled, name, clusterName, syncMoqParam)
}

// AddClusterScopedFeatureHandlerCalls gets all the calls that were made to AddClusterScopedFeatureHandler.
// Check the length with:
//     len(mockedRoleInterface.AddClusterScopedFeatureHandlerCalls())
func (mock *RoleInterfaceMock) AddClusterScopedFeatureHandlerCalls() []struct {
	Ctx         context.Context
	Enabled     func() bool
	Name        string
	ClusterName string
	Sync        v11.RoleHandlerFunc
} {
	var calls []struct {
		Ctx         context.Context
		Enabled     func() bool
		Name        string
		ClusterName string
		Sync        v11.RoleHandlerFunc
	}
	lockRoleInterfaceMockAddClusterScopedFeatureHandler.RLock()
	calls = mock.calls.AddClusterScopedFeatureHandler
	lockRoleInterfaceMockAddClusterScopedFeatureHandler.RUnlock()
	return calls
}

// AddClusterScopedFeatureLifecycle calls AddClusterScopedFeatureLifecycleFunc.
func (mock *RoleInterfaceMock) AddClusterScopedFeatureLifecycle(ctx context.Context, enabled func() bool, name string, clusterName string, lifecycle v11.RoleLifecycle) {
	if mock.AddClusterScopedFeatureLifecycleFunc == nil {
		panic("RoleInterfaceMock.AddClusterScopedFeatureLifecycleFunc: method is nil but RoleInterface.AddClusterScopedFeatureLifecycle was just called")
	}
	callInfo := struct {
		Ctx         context.Context
		Enabled     func() bool
		Name        string
		ClusterName string
		Lifecycle   v11.RoleLifecycle
	}{
		Ctx:         ctx,
		Enabled:     enabled,
		Name:        name,
		ClusterName: clusterName,
		Lifecycle:   lifecycle,
	}
	lockRoleInterfaceMockAddClusterScopedFeatureLifecycle.Lock()
	mock.calls.AddClusterScopedFeatureLifecycle = append(mock.calls.AddClusterScopedFeatureLifecycle, callInfo)
	lockRoleInterfaceMockAddClusterScopedFeatureLifecycle.Unlock()
	mock.AddClusterScopedFeatureLifecycleFunc(ctx, enabled, name, clusterName, lifecycle)
}

// AddClusterScopedFeatureLifecycleCalls gets all the calls that were made to AddClusterScopedFeatureLifecycle.
// Check the length with:
//     len(mockedRoleInterface.AddClusterScopedFeatureLifecycleCalls())
func (mock *RoleInterfaceMock) AddClusterScopedFeatureLifecycleCalls() []struct {
	Ctx         context.Context
	Enabled     func() bool
	Name        string
	ClusterName string
	Lifecycle   v11.RoleLifecycle
} {
	var calls []struct {
		Ctx         context.Context
		Enabled     func() bool
		Name        string
		ClusterName string
		Lifecycle   v11.RoleLifecycle
	}
	lockRoleInterfaceMockAddClusterScopedFeatureLifecycle.RLock()
	calls = mock.calls.AddClusterScopedFeatureLifecycle
	lockRoleInterfaceMockAddClusterScopedFeatureLifecycle.RUnlock()
	return calls
}

// AddClusterScopedHandler calls AddClusterScopedHandlerFunc.
func (mock *RoleInterfaceMock) AddClusterScopedHandler(ctx context.Context, name string, clusterName string, syncMoqParam v11.RoleHandlerFunc) {
	if mock.AddClusterScopedHandlerFunc == nil {
		panic("RoleInterfaceMock.AddClusterScopedHandlerFunc: method is nil but RoleInterface.AddClusterScopedHandler was just called")
	}
	callInfo := struct {
		Ctx         context.Context
		Name        string
		ClusterName string
		Sync        v11.RoleHandlerFunc
	}{
		Ctx:         ctx,
		Name:        name,
		ClusterName: clusterName,
		Sync:        syncMoqParam,
	}
	lockRoleInterfaceMockAddClusterScopedHandler.Lock()
	mock.calls.AddClusterScopedHandler = append(mock.calls.AddClusterScopedHandler, callInfo)
	lockRoleInterfaceMockAddClusterScopedHandler.Unlock()
	mock.AddClusterScopedHandlerFunc(ctx, name, clusterName, syncMoqParam)
}

// AddClusterScopedHandlerCalls gets all the calls that were made to AddClusterScopedHandler.
// Check the length with:
//     len(mockedRoleInterface.AddClusterScopedHandlerCalls())
func (mock *RoleInterfaceMock) AddClusterScopedHandlerCalls() []struct {
	Ctx         context.Context
	Name        string
	ClusterName string
	Sync        v11.RoleHandlerFunc
} {
	var calls []struct {
		Ctx         context.Context
		Name        string
		ClusterName string
		Sync        v11.RoleHandlerFunc
	}
	lockRoleInterfaceMockAddClusterScopedHandler.RLock()
	calls = mock.calls.AddClusterScopedHandler
	lockRoleInterfaceMockAddClusterScopedHandler.RUnlock()
	return calls
}

// AddClusterScopedLifecycle calls AddClusterScopedLifecycleFunc.
func (mock *RoleInterfaceMock) AddClusterScopedLifecycle(ctx context.Context, name string, clusterName string, lifecycle v11.RoleLifecycle) {
	if mock.AddClusterScopedLifecycleFunc == nil {
		panic("RoleInterfaceMock.AddClusterScopedLifecycleFunc: method is nil but RoleInterface.AddClusterScopedLifecycle was just called")
	}
	callInfo := struct {
		Ctx         context.Context
		Name        string
		ClusterName string
		Lifecycle   v11.RoleLifecycle
	}{
		Ctx:         ctx,
		Name:        name,
		ClusterName: clusterName,
		Lifecycle:   lifecycle,
	}
	lockRoleInterfaceMockAddClusterScopedLifecycle.Lock()
	mock.calls.AddClusterScopedLifecycle = append(mock.calls.AddClusterScopedLifecycle, callInfo)
	lockRoleInterfaceMockAddClusterScopedLifecycle.Unlock()
	mock.AddClusterScopedLifecycleFunc(ctx, name, clusterName, lifecycle)
}

// AddClusterScopedLifecycleCalls gets all the calls that were made to AddClusterScopedLifecycle.
// Check the length with:
//     len(mockedRoleInterface.AddClusterScopedLifecycleCalls())
func (mock *RoleInterfaceMock) AddClusterScopedLifecycleCalls() []struct {
	Ctx         context.Context
	Name        string
	ClusterName string
	Lifecycle   v11.RoleLifecycle
} {
	var calls []struct {
		Ctx         context.Context
		Name        string
		ClusterName string
		Lifecycle   v11.RoleLifecycle
	}
	lockRoleInterfaceMockAddClusterScopedLifecycle.RLock()
	calls = mock.calls.AddClusterScopedLifecycle
	lockRoleInterfaceMockAddClusterScopedLifecycle.RUnlock()
	return calls
}

// AddFeatureHandler calls AddFeatureHandlerFunc.
func (mock *RoleInterfaceMock) AddFeatureHandler(ctx context.Context, enabled func() bool, name string, syncMoqParam v11.RoleHandlerFunc) {
	if mock.AddFeatureHandlerFunc == nil {
		panic("RoleInterfaceMock.AddFeatureHandlerFunc: method is nil but RoleInterface.AddFeatureHandler was just called")
	}
	callInfo := struct {
		Ctx     context.Context
		Enabled func() bool
		Name    string
		Sync    v11.RoleHandlerFunc
	}{
		Ctx:     ctx,
		Enabled: enabled,
		Name:    name,
		Sync:    syncMoqParam,
	}
	lockRoleInterfaceMockAddFeatureHandler.Lock()
	mock.calls.AddFeatureHandler = append(mock.calls.AddFeatureHandler, callInfo)
	lockRoleInterfaceMockAddFeatureHandler.Unlock()
	mock.AddFeatureHandlerFunc(ctx, enabled, name, syncMoqParam)
}

// AddFeatureHandlerCalls gets all the calls that were made to AddFeatureHandler.
// Check the length with:
//     len(mockedRoleInterface.AddFeatureHandlerCalls())
func (mock *RoleInterfaceMock) AddFeatureHandlerCalls() []struct {
	Ctx     context.Context
	Enabled func() bool
	Name    string
	Sync    v11.RoleHandlerFunc
} {
	var calls []struct {
		Ctx     context.Context
		Enabled func() bool
		Name    string
		Sync    v11.RoleHandlerFunc
	}
	lockRoleInterfaceMockAddFeatureHandler.RLock()
	calls = mock.calls.AddFeatureHandler
	lockRoleInterfaceMockAddFeatureHandler.RUnlock()
	return calls
}

// AddFeatureLifecycle calls AddFeatureLifecycleFunc.
func (mock *RoleInterfaceMock) AddFeatureLifecycle(ctx context.Context, enabled func() bool, name string, lifecycle v11.RoleLifecycle) {
	if mock.AddFeatureLifecycleFunc == nil {
		panic("RoleInterfaceMock.AddFeatureLifecycleFunc: method is nil but RoleInterface.AddFeatureLifecycle was just called")
	}
	callInfo := struct {
		Ctx       context.Context
		Enabled   func() bool
		Name      string
		Lifecycle v11.RoleLifecycle
	}{
		Ctx:       ctx,
		Enabled:   enabled,
		Name:      name,
		Lifecycle: lifecycle,
	}
	lockRoleInterfaceMockAddFeatureLifecycle.Lock()
	mock.calls.AddFeatureLifecycle = append(mock.calls.AddFeatureLifecycle, callInfo)
	lockRoleInterfaceMockAddFeatureLifecycle.Unlock()
	mock.AddFeatureLifecycleFunc(ctx, enabled, name, lifecycle)
}

// AddFeatureLifecycleCalls gets all the calls that were made to AddFeatureLifecycle.
// Check the length with:
//     len(mockedRoleInterface.AddFeatureLifecycleCalls())
func (mock *RoleInterfaceMock) AddFeatureLifecycleCalls() []struct {
	Ctx       context.Context
	Enabled   func() bool
	Name      string
	Lifecycle v11.RoleLifecycle
} {
	var calls []struct {
		Ctx       context.Context
		Enabled   func() bool
		Name      string
		Lifecycle v11.RoleLifecycle
	}
	lockRoleInterfaceMockAddFeatureLifecycle.RLock()
	calls = mock.calls.AddFeatureLifecycle
	lockRoleInterfaceMockAddFeatureLifecycle.RUnlock()
	return calls
}

// AddHandler calls AddHandlerFunc.
func (mock *RoleInterfaceMock) AddHandler(ctx context.Context, name string, syncMoqParam v11.RoleHandlerFunc) {
	if mock.AddHandlerFunc == nil {
		panic("RoleInterfaceMock.AddHandlerFunc: method is nil but RoleInterface.AddHandler was just called")
	}
	callInfo := struct {
		Ctx  context.Context
		Name string
		Sync v11.RoleHandlerFunc
	}{
		Ctx:  ctx,
		Name: name,
		Sync: syncMoqParam,
	}
	lockRoleInterfaceMockAddHandler.Lock()
	mock.calls.AddHandler = append(mock.calls.AddHandler, callInfo)
	lockRoleInterfaceMockAddHandler.Unlock()
	mock.AddHandlerFunc(ctx, name, syncMoqParam)
}

// AddHandlerCalls gets all the calls that were made to AddHandler.
// Check the length with:
//     len(mockedRoleInterface.AddHandlerCalls())
func (mock *RoleInterfaceMock) AddHandlerCalls() []struct {
	Ctx  context.Context
	Name string
	Sync v11.RoleHandlerFunc
} {
	var calls []struct {
		Ctx  context.Context
		Name string
		Sync v11.RoleHandlerFunc
	}
	lockRoleInterfaceMockAddHandler.RLock()
	calls = mock.calls.AddHandler
	lockRoleInterfaceMockAddHandler.RUnlock()
	return calls
}

// AddLifecycle calls AddLifecycleFunc.
func (mock *RoleInterfaceMock) AddLifecycle(ctx context.Context, name string, lifecycle v11.RoleLifecycle) {
	if mock.AddLifecycleFunc == nil {
		panic("RoleInterfaceMock.AddLifecycleFunc: method is nil but RoleInterface.AddLifecycle was just called")
	}
	callInfo := struct {
		Ctx       context.Context
		Name      string
		Lifecycle v11.RoleLifecycle
	}{
		Ctx:       ctx,
		Name:      name,
		Lifecycle: lifecycle,
	}
	lockRoleInterfaceMockAddLifecycle.Lock()
	mock.calls.AddLifecycle = append(mock.calls.AddLifecycle, callInfo)
	lockRoleInterfaceMockAddLifecycle.Unlock()
	mock.AddLifecycleFunc(ctx, name, lifecycle)
}

// AddLifecycleCalls gets all the calls that were made to AddLifecycle.
// Check the length with:
//     len(mockedRoleInterface.AddLifecycleCalls())
func (mock *RoleInterfaceMock) AddLifecycleCalls() []struct {
	Ctx       context.Context
	Name      string
	Lifecycle v11.RoleLifecycle
} {
	var calls []struct {
		Ctx       context.Context
		Name      string
		Lifecycle v11.RoleLifecycle
	}
	lockRoleInterfaceMockAddLifecycle.RLock()
	calls = mock.calls.AddLifecycle
	lockRoleInterfaceMockAddLifecycle.RUnlock()
	return calls
}

// Controller calls ControllerFunc.
func (mock *RoleInterfaceMock) Controller() v11.RoleController {
	if mock.ControllerFunc == nil {
		panic("RoleInterfaceMock.ControllerFunc: method is nil but RoleInterface.Controller was just called")
	}
	callInfo := struct {
	}{}
	lockRoleInterfaceMockController.Lock()
	mock.calls.Controller = append(mock.calls.Controller, callInfo)
	lockRoleInterfaceMockController.Unlock()
	return mock.ControllerFunc()
}

// ControllerCalls gets all the calls that were made to Controller.
// Check the length with:
//     len(mockedRoleInterface.ControllerCalls())
func (mock *RoleInterfaceMock) ControllerCalls() []struct {
} {
	var calls []struct {
	}
	lockRoleInterfaceMockController.RLock()
	calls = mock.calls.Controller
	lockRoleInterfaceMockController.RUnlock()
	return calls
}

// Create calls CreateFunc.
func (mock *RoleInterfaceMock) Create(in1 *v1.Role) (*v1.Role, error) {
	if mock.CreateFunc == nil {
		panic("RoleInterfaceMock.CreateFunc: method is nil but RoleInterface.Create was just called")
	}
	callInfo := struct {
		In1 *v1.Role
	}{
		In1: in1,
	}
	lockRoleInterfaceMockCreate.Lock()
	mock.calls.Create = append(mock.calls.Create, callInfo)
	lockRoleInterfaceMockCreate.Unlock()
	return mock.CreateFunc(in1)
}

// CreateCalls gets all the calls that were made to Create.
// Check the length with:
//     len(mockedRoleInterface.CreateCalls())
func (mock *RoleInterfaceMock) CreateCalls() []struct {
	In1 *v1.Role
} {
	var calls []struct {
		In1 *v1.Role
	}
	lockRoleInterfaceMockCreate.RLock()
	calls = mock.calls.Create
	lockRoleInterfaceMockCreate.RUnlock()
	return calls
}

// Delete calls DeleteFunc.
func (mock *RoleInterfaceMock) Delete(name string, options *metav1.DeleteOptions) error {
	if mock.DeleteFunc == nil {
		panic("RoleInterfaceMock.DeleteFunc: method is nil but RoleInterface.Delete was just called")
	}
	callInfo := struct {
		Name    string
		Options *metav1.DeleteOptions
	}{
		Name:    name,
		Options: options,
	}
	lockRoleInterfaceMockDelete.Lock()
	mock.calls.Delete = append(mock.calls.Delete, callInfo)
	lockRoleInterfaceMockDelete.Unlock()
	return mock.DeleteFunc(name, options)
}

// DeleteCalls gets all the calls that were made to Delete.
// Check the length with:
//     len(mockedRoleInterface.DeleteCalls())
func (mock *RoleInterfaceMock) DeleteCalls() []struct {
	Name    string
	Options *metav1.DeleteOptions
} {
	var calls []struct {
		Name    string
		Options *metav1.DeleteOptions
	}
	lockRoleInterfaceMockDelete.RLock()
	calls = mock.calls.Delete
	lockRoleInterfaceMockDelete.RUnlock()
	return calls
}

// DeleteCollection calls DeleteCollectionFunc.
func (mock *RoleInterfaceMock) DeleteCollection(deleteOpts *metav1.DeleteOptions, listOpts metav1.ListOptions) error {
	if mock.DeleteCollectionFunc == nil {
		panic("RoleInterfaceMock.DeleteCollectionFunc: method is nil but RoleInterface.DeleteCollection was just called")
	}
	callInfo := struct {
		DeleteOpts *metav1.DeleteOptions
		ListOpts   metav1.ListOptions
	}{
		DeleteOpts: deleteOpts,
		ListOpts:   listOpts,
	}
	lockRoleInterfaceMockDeleteCollection.Lock()
	mock.calls.DeleteCollection = append(mock.calls.DeleteCollection, callInfo)
	lockRoleInterfaceMockDeleteCollection.Unlock()
	return mock.DeleteCollectionFunc(deleteOpts, listOpts)
}

// DeleteCollectionCalls gets all the calls that were made to DeleteCollection.
// Check the length with:
//     len(mockedRoleInterface.DeleteCollectionCalls())
func (mock *RoleInterfaceMock) DeleteCollectionCalls() []struct {
	DeleteOpts *metav1.DeleteOptions
	ListOpts   metav1.ListOptions
} {
	var calls []struct {
		DeleteOpts *metav1.DeleteOptions
		ListOpts   metav1.ListOptions
	}
	lockRoleInterfaceMockDeleteCollection.RLock()
	calls = mock.calls.DeleteCollection
	lockRoleInterfaceMockDeleteCollection.RUnlock()
	return calls
}

// DeleteNamespaced calls DeleteNamespacedFunc.
func (mock *RoleInterfaceMock) DeleteNamespaced(namespace string, name string, options *metav1.DeleteOptions) error {
	if mock.DeleteNamespacedFunc == nil {
		panic("RoleInterfaceMock.DeleteNamespacedFunc: method is nil but RoleInterface.DeleteNamespaced was just called")
	}
	callInfo := struct {
		Namespace string
		Name      string
		Options   *metav1.DeleteOptions
	}{
		Namespace: namespace,
		Name:      name,
		Options:   options,
	}
	lockRoleInterfaceMockDeleteNamespaced.Lock()
	mock.calls.DeleteNamespaced = append(mock.calls.DeleteNamespaced, callInfo)
	lockRoleInterfaceMockDeleteNamespaced.Unlock()
	return mock.DeleteNamespacedFunc(namespace, name, options)
}

// DeleteNamespacedCalls gets all the calls that were made to DeleteNamespaced.
// Check the length with:
//     len(mockedRoleInterface.DeleteNamespacedCalls())
func (mock *RoleInterfaceMock) DeleteNamespacedCalls() []struct {
	Namespace string
	Name      string
	Options   *metav1.DeleteOptions
} {
	var calls []struct {
		Namespace string
		Name      string
		Options   *metav1.DeleteOptions
	}
	lockRoleInterfaceMockDeleteNamespaced.RLock()
	calls = mock.calls.DeleteNamespaced
	lockRoleInterfaceMockDeleteNamespaced.RUnlock()
	return calls
}

// Get calls GetFunc.
func (mock *RoleInterfaceMock) Get(name string, opts metav1.GetOptions) (*v1.Role, error) {
	if mock.GetFunc == nil {
		panic("RoleInterfaceMock.GetFunc: method is nil but RoleInterface.Get was just called")
	}
	callInfo := struct {
		Name string
		Opts metav1.GetOptions
	}{
		Name: name,
		Opts: opts,
	}
	lockRoleInterfaceMockGet.Lock()
	mock.calls.Get = append(mock.calls.Get, callInfo)
	lockRoleInterfaceMockGet.Unlock()
	return mock.GetFunc(name, opts)
}

// GetCalls gets all the calls that were made to Get.
// Check the length with:
//     len(mockedRoleInterface.GetCalls())
func (mock *RoleInterfaceMock) GetCalls() []struct {
	Name string
	Opts metav1.GetOptions
} {
	var calls []struct {
		Name string
		Opts metav1.GetOptions
	}
	lockRoleInterfaceMockGet.RLock()
	calls = mock.calls.Get
	lockRoleInterfaceMockGet.RUnlock()
	return calls
}

// GetNamespaced calls GetNamespacedFunc.
func (mock *RoleInterfaceMock) GetNamespaced(namespace string, name string, opts metav1.GetOptions) (*v1.Role, error) {
	if mock.GetNamespacedFunc == nil {
		panic("RoleInterfaceMock.GetNamespacedFunc: method is nil but RoleInterface.GetNamespaced was just called")
	}
	callInfo := struct {
		Namespace string
		Name      string
		Opts      metav1.GetOptions
	}{
		Namespace: namespace,
		Name:      name,
		Opts:      opts,
	}
	lockRoleInterfaceMockGetNamespaced.Lock()
	mock.calls.GetNamespaced = append(mock.calls.GetNamespaced, callInfo)
	lockRoleInterfaceMockGetNamespaced.Unlock()
	return mock.GetNamespacedFunc(namespace, name, opts)
}

// GetNamespacedCalls gets all the calls that were made to GetNamespaced.
// Check the length with:
//     len(mockedRoleInterface.GetNamespacedCalls())
func (mock *RoleInterfaceMock) GetNamespacedCalls() []struct {
	Namespace string
	Name      string
	Opts      metav1.GetOptions
} {
	var calls []struct {
		Namespace string
		Name      string
		Opts      metav1.GetOptions
	}
	lockRoleInterfaceMockGetNamespaced.RLock()
	calls = mock.calls.GetNamespaced
	lockRoleInterfaceMockGetNamespaced.RUnlock()
	return calls
}

// List calls ListFunc.
func (mock *RoleInterfaceMock) List(opts metav1.ListOptions) (*v1.RoleList, error) {
	if mock.ListFunc == nil {
		panic("RoleInterfaceMock.ListFunc: method is nil but RoleInterface.List was just called")
	}
	callInfo := struct {
		Opts metav1.ListOptions
	}{
		Opts: opts,
	}
	lockRoleInterfaceMockList.Lock()
	mock.calls.List = append(mock.calls.List, callInfo)
	lockRoleInterfaceMockList.Unlock()
	return mock.ListFunc(opts)
}

// ListCalls gets all the calls that were made to List.
// Check the length with:
//     len(mockedRoleInterface.ListCalls())
func (mock *RoleInterfaceMock) ListCalls() []struct {
	Opts metav1.ListOptions
} {
	var calls []struct {
		Opts metav1.ListOptions
	}
	lockRoleInterfaceMockList.RLock()
	calls = mock.calls.List
	lockRoleInterfaceMockList.RUnlock()
	return calls
}

// ListNamespaced calls ListNamespacedFunc.
func (mock *RoleInterfaceMock) ListNamespaced(namespace string, opts metav1.ListOptions) (*v1.RoleList, error) {
	if mock.ListNamespacedFunc == nil {
		panic("RoleInterfaceMock.ListNamespacedFunc: method is nil but RoleInterface.ListNamespaced was just called")
	}
	callInfo := struct {
		Namespace string
		Opts      metav1.ListOptions
	}{
		Namespace: namespace,
		Opts:      opts,
	}
	lockRoleInterfaceMockListNamespaced.Lock()
	mock.calls.ListNamespaced = append(mock.calls.ListNamespaced, callInfo)
	lockRoleInterfaceMockListNamespaced.Unlock()
	return mock.ListNamespacedFunc(namespace, opts)
}

// ListNamespacedCalls gets all the calls that were made to ListNamespaced.
// Check the length with:
//     len(mockedRoleInterface.ListNamespacedCalls())
func (mock *RoleInterfaceMock) ListNamespacedCalls() []struct {
	Namespace string
	Opts      metav1.ListOptions
} {
	var calls []struct {
		Namespace string
		Opts      metav1.ListOptions
	}
	lockRoleInterfaceMockListNamespaced.RLock()
	calls = mock.calls.ListNamespaced
	lockRoleInterfaceMockListNamespaced.RUnlock()
	return calls
}

// ObjectClient calls ObjectClientFunc.
func (mock *RoleInterfaceMock) ObjectClient() *objectclient.ObjectClient {
	if mock.ObjectClientFunc == nil {
		panic("RoleInterfaceMock.ObjectClientFunc: method is nil but RoleInterface.ObjectClient was just called")
	}
	callInfo := struct {
	}{}
	lockRoleInterfaceMockObjectClient.Lock()
	mock.calls.ObjectClient = append(mock.calls.ObjectClient, callInfo)
	lockRoleInterfaceMockObjectClient.Unlock()
	return mock.ObjectClientFunc()
}

// ObjectClientCalls gets all the calls that were made to ObjectClient.
// Check the length with:
//     len(mockedRoleInterface.ObjectClientCalls())
func (mock *RoleInterfaceMock) ObjectClientCalls() []struct {
} {
	var calls []struct {
	}
	lockRoleInterfaceMockObjectClient.RLock()
	calls = mock.calls.ObjectClient
	lockRoleInterfaceMockObjectClient.RUnlock()
	return calls
}

// Update calls UpdateFunc.
func (mock *RoleInterfaceMock) Update(in1 *v1.Role) (*v1.Role, error) {
	if mock.UpdateFunc == nil {
		panic("RoleInterfaceMock.UpdateFunc: method is nil but RoleInterface.Update was just called")
	}
	callInfo := struct {
		In1 *v1.Role
	}{
		In1: in1,
	}
	lockRoleInterfaceMockUpdate.Lock()
	mock.calls.Update = append(mock.calls.Update, callInfo)
	lockRoleInterfaceMockUpdate.Unlock()
	return mock.UpdateFunc(in1)
}

// UpdateCalls gets all the calls that were made to Update.
// Check the length with:
//     len(mockedRoleInterface.UpdateCalls())
func (mock *RoleInterfaceMock) UpdateCalls() []struct {
	In1 *v1.Role
} {
	var calls []struct {
		In1 *v1.Role
	}
	lockRoleInterfaceMockUpdate.RLock()
	calls = mock.calls.Update
	lockRoleInterfaceMockUpdate.RUnlock()
	return calls
}

// Watch calls WatchFunc.
func (mock *RoleInterfaceMock) Watch(opts metav1.ListOptions) (watch.Interface, error) {
	if mock.WatchFunc == nil {
		panic("RoleInterfaceMock.WatchFunc: method is nil but RoleInterface.Watch was just called")
	}
	callInfo := struct {
		Opts metav1.ListOptions
	}{
		Opts: opts,
	}
	lockRoleInterfaceMockWatch.Lock()
	mock.calls.Watch = append(mock.calls.Watch, callInfo)
	lockRoleInterfaceMockWatch.Unlock()
	return mock.WatchFunc(opts)
}

// WatchCalls gets all the calls that were made to Watch.
// Check the length with:
//     len(mockedRoleInterface.WatchCalls())
func (mock *RoleInterfaceMock) WatchCalls() []struct {
	Opts metav1.ListOptions
} {
	var calls []struct {
		Opts metav1.ListOptions
	}
	lockRoleInterfaceMockWatch.RLock()
	calls = mock.calls.Watch
	lockRoleInterfaceMockWatch.RUnlock()
	return calls
}

var (
	lockRolesGetterMockRoles sync.RWMutex
)

// Ensure, that RolesGetterMock does implement v11.RolesGetter.
// If this is not the case, regenerate this file with moq.
var _ v11.RolesGetter = &RolesGetterMock{}

// RolesGetterMock is a mock implementation of v11.RolesGetter.
//
//     func TestSomethingThatUsesRolesGetter(t *testing.T) {
//
//         // make and configure a mocked v11.RolesGetter
//         mockedRolesGetter := &RolesGetterMock{
//             RolesFunc: func(namespace string) v11.RoleInterface {
// 	               panic("mock out the Roles method")
//             },
//         }
//
//         // use mockedRolesGetter in code that requires v11.RolesGetter
//         // and then make assertions.
//
//     }
type RolesGetterMock struct {
	// RolesFunc mocks the Roles method.
	RolesFunc func(namespace string) v11.RoleInterface

	// calls tracks calls to the methods.
	calls struct {
		// Roles holds details about calls to the Roles method.
		Roles []struct {
			// Namespace is the namespace argument value.
			Namespace string
		}
	}
}

// Roles calls RolesFunc.
func (mock *RolesGetterMock) Roles(namespace string) v11.RoleInterface {
	if mock.RolesFunc == nil {
		panic("RolesGetterMock.RolesFunc: method is nil but RolesGetter.Roles was just called")
	}
	callInfo := struct {
		Namespace string
	}{
		Namespace: namespace,
	}
	lockRolesGetterMockRoles.Lock()
	mock.calls.Roles = append(mock.calls.Roles, callInfo)
	lockRolesGetterMockRoles.Unlock()
	return mock.RolesFunc(namespace)
}

// RolesCalls gets all the calls that were made to Roles.
// Check the length with:
//     len(mockedRolesGetter.RolesCalls())
func (mock *RolesGetterMock) RolesCalls() []struct {
	Namespace string
} {
	var calls []struct {
		Namespace string
	}
	lockRolesGetterMockRoles.RLock()
	calls = mock.calls.Roles
	lockRolesGetterMockRoles.RUnlock()
	return calls
}
