// Code generated by moq; DO NOT EDIT.
// github.com/matryer/moq

package fakes

import (
	"context"
	"sync"
	"time"

	"github.com/rancher/norman/controller"
	"github.com/rancher/norman/objectclient"
	v11 "github.com/rancher/rancher/pkg/generated/norman/storage.k8s.io/v1"
	v1 "k8s.io/api/storage/v1"
	metav1 "k8s.io/apimachinery/pkg/apis/meta/v1"
	"k8s.io/apimachinery/pkg/labels"
	"k8s.io/apimachinery/pkg/watch"
	"k8s.io/client-go/tools/cache"
)

var (
	lockStorageClassListerMockGet  sync.RWMutex
	lockStorageClassListerMockList sync.RWMutex
)

// Ensure, that StorageClassListerMock does implement v11.StorageClassLister.
// If this is not the case, regenerate this file with moq.
var _ v11.StorageClassLister = &StorageClassListerMock{}

// StorageClassListerMock is a mock implementation of v11.StorageClassLister.
//
//     func TestSomethingThatUsesStorageClassLister(t *testing.T) {
//
//         // make and configure a mocked v11.StorageClassLister
//         mockedStorageClassLister := &StorageClassListerMock{
//             GetFunc: func(namespace string, name string) (*v1.StorageClass, error) {
// 	               panic("mock out the Get method")
//             },
//             ListFunc: func(namespace string, selector labels.Selector) ([]*v1.StorageClass, error) {
// 	               panic("mock out the List method")
//             },
//         }
//
//         // use mockedStorageClassLister in code that requires v11.StorageClassLister
//         // and then make assertions.
//
//     }
type StorageClassListerMock struct {
	// GetFunc mocks the Get method.
	GetFunc func(namespace string, name string) (*v1.StorageClass, error)

	// ListFunc mocks the List method.
	ListFunc func(namespace string, selector labels.Selector) ([]*v1.StorageClass, error)

	// calls tracks calls to the methods.
	calls struct {
		// Get holds details about calls to the Get method.
		Get []struct {
			// Namespace is the namespace argument value.
			Namespace string
			// Name is the name argument value.
			Name string
		}
		// List holds details about calls to the List method.
		List []struct {
			// Namespace is the namespace argument value.
			Namespace string
			// Selector is the selector argument value.
			Selector labels.Selector
		}
	}
}

// Get calls GetFunc.
func (mock *StorageClassListerMock) Get(namespace string, name string) (*v1.StorageClass, error) {
	if mock.GetFunc == nil {
		panic("StorageClassListerMock.GetFunc: method is nil but StorageClassLister.Get was just called")
	}
	callInfo := struct {
		Namespace string
		Name      string
	}{
		Namespace: namespace,
		Name:      name,
	}
	lockStorageClassListerMockGet.Lock()
	mock.calls.Get = append(mock.calls.Get, callInfo)
	lockStorageClassListerMockGet.Unlock()
	return mock.GetFunc(namespace, name)
}

// GetCalls gets all the calls that were made to Get.
// Check the length with:
//     len(mockedStorageClassLister.GetCalls())
func (mock *StorageClassListerMock) GetCalls() []struct {
	Namespace string
	Name      string
} {
	var calls []struct {
		Namespace string
		Name      string
	}
	lockStorageClassListerMockGet.RLock()
	calls = mock.calls.Get
	lockStorageClassListerMockGet.RUnlock()
	return calls
}

// List calls ListFunc.
func (mock *StorageClassListerMock) List(namespace string, selector labels.Selector) ([]*v1.StorageClass, error) {
	if mock.ListFunc == nil {
		panic("StorageClassListerMock.ListFunc: method is nil but StorageClassLister.List was just called")
	}
	callInfo := struct {
		Namespace string
		Selector  labels.Selector
	}{
		Namespace: namespace,
		Selector:  selector,
	}
	lockStorageClassListerMockList.Lock()
	mock.calls.List = append(mock.calls.List, callInfo)
	lockStorageClassListerMockList.Unlock()
	return mock.ListFunc(namespace, selector)
}

// ListCalls gets all the calls that were made to List.
// Check the length with:
//     len(mockedStorageClassLister.ListCalls())
func (mock *StorageClassListerMock) ListCalls() []struct {
	Namespace string
	Selector  labels.Selector
} {
	var calls []struct {
		Namespace string
		Selector  labels.Selector
	}
	lockStorageClassListerMockList.RLock()
	calls = mock.calls.List
	lockStorageClassListerMockList.RUnlock()
	return calls
}

var (
	lockStorageClassControllerMockAddClusterScopedFeatureHandler sync.RWMutex
	lockStorageClassControllerMockAddClusterScopedHandler        sync.RWMutex
	lockStorageClassControllerMockAddFeatureHandler              sync.RWMutex
	lockStorageClassControllerMockAddHandler                     sync.RWMutex
	lockStorageClassControllerMockEnqueue                        sync.RWMutex
	lockStorageClassControllerMockEnqueueAfter                   sync.RWMutex
	lockStorageClassControllerMockGeneric                        sync.RWMutex
	lockStorageClassControllerMockInformer                       sync.RWMutex
	lockStorageClassControllerMockLister                         sync.RWMutex
)

// Ensure, that StorageClassControllerMock does implement v11.StorageClassController.
// If this is not the case, regenerate this file with moq.
var _ v11.StorageClassController = &StorageClassControllerMock{}

// StorageClassControllerMock is a mock implementation of v11.StorageClassController.
//
//     func TestSomethingThatUsesStorageClassController(t *testing.T) {
//
//         // make and configure a mocked v11.StorageClassController
//         mockedStorageClassController := &StorageClassControllerMock{
//             AddClusterScopedFeatureHandlerFunc: func(ctx context.Context, enabled func() bool, name string, clusterName string, handler v11.StorageClassHandlerFunc)  {
// 	               panic("mock out the AddClusterScopedFeatureHandler method")
//             },
//             AddClusterScopedHandlerFunc: func(ctx context.Context, name string, clusterName string, handler v11.StorageClassHandlerFunc)  {
// 	               panic("mock out the AddClusterScopedHandler method")
//             },
//             AddFeatureHandlerFunc: func(ctx context.Context, enabled func() bool, name string, syncMoqParam v11.StorageClassHandlerFunc)  {
// 	               panic("mock out the AddFeatureHandler method")
//             },
//             AddHandlerFunc: func(ctx context.Context, name string, handler v11.StorageClassHandlerFunc)  {
// 	               panic("mock out the AddHandler method")
//             },
//             EnqueueFunc: func(namespace string, name string)  {
// 	               panic("mock out the Enqueue method")
//             },
//             EnqueueAfterFunc: func(namespace string, name string, after time.Duration)  {
// 	               panic("mock out the EnqueueAfter method")
//             },
//             GenericFunc: func() controller.GenericController {
// 	               panic("mock out the Generic method")
//             },
//             InformerFunc: func() cache.SharedIndexInformer {
// 	               panic("mock out the Informer method")
//             },
//             ListerFunc: func() v11.StorageClassLister {
// 	               panic("mock out the Lister method")
//             },
//         }
//
//         // use mockedStorageClassController in code that requires v11.StorageClassController
//         // and then make assertions.
//
//     }
type StorageClassControllerMock struct {
	// AddClusterScopedFeatureHandlerFunc mocks the AddClusterScopedFeatureHandler method.
	AddClusterScopedFeatureHandlerFunc func(ctx context.Context, enabled func() bool, name string, clusterName string, handler v11.StorageClassHandlerFunc)

	// AddClusterScopedHandlerFunc mocks the AddClusterScopedHandler method.
	AddClusterScopedHandlerFunc func(ctx context.Context, name string, clusterName string, handler v11.StorageClassHandlerFunc)

	// AddFeatureHandlerFunc mocks the AddFeatureHandler method.
	AddFeatureHandlerFunc func(ctx context.Context, enabled func() bool, name string, syncMoqParam v11.StorageClassHandlerFunc)

	// AddHandlerFunc mocks the AddHandler method.
	AddHandlerFunc func(ctx context.Context, name string, handler v11.StorageClassHandlerFunc)

	// EnqueueFunc mocks the Enqueue method.
	EnqueueFunc func(namespace string, name string)

	// EnqueueAfterFunc mocks the EnqueueAfter method.
	EnqueueAfterFunc func(namespace string, name string, after time.Duration)

	// GenericFunc mocks the Generic method.
	GenericFunc func() controller.GenericController

	// InformerFunc mocks the Informer method.
	InformerFunc func() cache.SharedIndexInformer

	// ListerFunc mocks the Lister method.
	ListerFunc func() v11.StorageClassLister

	// calls tracks calls to the methods.
	calls struct {
		// AddClusterScopedFeatureHandler holds details about calls to the AddClusterScopedFeatureHandler method.
		AddClusterScopedFeatureHandler []struct {
			// Ctx is the ctx argument value.
			Ctx context.Context
			// Enabled is the enabled argument value.
			Enabled func() bool
			// Name is the name argument value.
			Name string
			// ClusterName is the clusterName argument value.
			ClusterName string
			// Handler is the handler argument value.
			Handler v11.StorageClassHandlerFunc
		}
		// AddClusterScopedHandler holds details about calls to the AddClusterScopedHandler method.
		AddClusterScopedHandler []struct {
			// Ctx is the ctx argument value.
			Ctx context.Context
			// Name is the name argument value.
			Name string
			// ClusterName is the clusterName argument value.
			ClusterName string
			// Handler is the handler argument value.
			Handler v11.StorageClassHandlerFunc
		}
		// AddFeatureHandler holds details about calls to the AddFeatureHandler method.
		AddFeatureHandler []struct {
			// Ctx is the ctx argument value.
			Ctx context.Context
			// Enabled is the enabled argument value.
			Enabled func() bool
			// Name is the name argument value.
			Name string
			// Sync is the sync argument value.
			Sync v11.StorageClassHandlerFunc
		}
		// AddHandler holds details about calls to the AddHandler method.
		AddHandler []struct {
			// Ctx is the ctx argument value.
			Ctx context.Context
			// Name is the name argument value.
			Name string
			// Handler is the handler argument value.
			Handler v11.StorageClassHandlerFunc
		}
		// Enqueue holds details about calls to the Enqueue method.
		Enqueue []struct {
			// Namespace is the namespace argument value.
			Namespace string
			// Name is the name argument value.
			Name string
		}
		// EnqueueAfter holds details about calls to the EnqueueAfter method.
		EnqueueAfter []struct {
			// Namespace is the namespace argument value.
			Namespace string
			// Name is the name argument value.
			Name string
			// After is the after argument value.
			After time.Duration
		}
		// Generic holds details about calls to the Generic method.
		Generic []struct {
		}
		// Informer holds details about calls to the Informer method.
		Informer []struct {
		}
		// Lister holds details about calls to the Lister method.
		Lister []struct {
		}
	}
}

// AddClusterScopedFeatureHandler calls AddClusterScopedFeatureHandlerFunc.
func (mock *StorageClassControllerMock) AddClusterScopedFeatureHandler(ctx context.Context, enabled func() bool, name string, clusterName string, handler v11.StorageClassHandlerFunc) {
	if mock.AddClusterScopedFeatureHandlerFunc == nil {
		panic("StorageClassControllerMock.AddClusterScopedFeatureHandlerFunc: method is nil but StorageClassController.AddClusterScopedFeatureHandler was just called")
	}
	callInfo := struct {
		Ctx         context.Context
		Enabled     func() bool
		Name        string
		ClusterName string
		Handler     v11.StorageClassHandlerFunc
	}{
		Ctx:         ctx,
		Enabled:     enabled,
		Name:        name,
		ClusterName: clusterName,
		Handler:     handler,
	}
	lockStorageClassControllerMockAddClusterScopedFeatureHandler.Lock()
	mock.calls.AddClusterScopedFeatureHandler = append(mock.calls.AddClusterScopedFeatureHandler, callInfo)
	lockStorageClassControllerMockAddClusterScopedFeatureHandler.Unlock()
	mock.AddClusterScopedFeatureHandlerFunc(ctx, enabled, name, clusterName, handler)
}

// AddClusterScopedFeatureHandlerCalls gets all the calls that were made to AddClusterScopedFeatureHandler.
// Check the length with:
//     len(mockedStorageClassController.AddClusterScopedFeatureHandlerCalls())
func (mock *StorageClassControllerMock) AddClusterScopedFeatureHandlerCalls() []struct {
	Ctx         context.Context
	Enabled     func() bool
	Name        string
	ClusterName string
	Handler     v11.StorageClassHandlerFunc
} {
	var calls []struct {
		Ctx         context.Context
		Enabled     func() bool
		Name        string
		ClusterName string
		Handler     v11.StorageClassHandlerFunc
	}
	lockStorageClassControllerMockAddClusterScopedFeatureHandler.RLock()
	calls = mock.calls.AddClusterScopedFeatureHandler
	lockStorageClassControllerMockAddClusterScopedFeatureHandler.RUnlock()
	return calls
}

// AddClusterScopedHandler calls AddClusterScopedHandlerFunc.
func (mock *StorageClassControllerMock) AddClusterScopedHandler(ctx context.Context, name string, clusterName string, handler v11.StorageClassHandlerFunc) {
	if mock.AddClusterScopedHandlerFunc == nil {
		panic("StorageClassControllerMock.AddClusterScopedHandlerFunc: method is nil but StorageClassController.AddClusterScopedHandler was just called")
	}
	callInfo := struct {
		Ctx         context.Context
		Name        string
		ClusterName string
		Handler     v11.StorageClassHandlerFunc
	}{
		Ctx:         ctx,
		Name:        name,
		ClusterName: clusterName,
		Handler:     handler,
	}
	lockStorageClassControllerMockAddClusterScopedHandler.Lock()
	mock.calls.AddClusterScopedHandler = append(mock.calls.AddClusterScopedHandler, callInfo)
	lockStorageClassControllerMockAddClusterScopedHandler.Unlock()
	mock.AddClusterScopedHandlerFunc(ctx, name, clusterName, handler)
}

// AddClusterScopedHandlerCalls gets all the calls that were made to AddClusterScopedHandler.
// Check the length with:
//     len(mockedStorageClassController.AddClusterScopedHandlerCalls())
func (mock *StorageClassControllerMock) AddClusterScopedHandlerCalls() []struct {
	Ctx         context.Context
	Name        string
	ClusterName string
	Handler     v11.StorageClassHandlerFunc
} {
	var calls []struct {
		Ctx         context.Context
		Name        string
		ClusterName string
		Handler     v11.StorageClassHandlerFunc
	}
	lockStorageClassControllerMockAddClusterScopedHandler.RLock()
	calls = mock.calls.AddClusterScopedHandler
	lockStorageClassControllerMockAddClusterScopedHandler.RUnlock()
	return calls
}

// AddFeatureHandler calls AddFeatureHandlerFunc.
func (mock *StorageClassControllerMock) AddFeatureHandler(ctx context.Context, enabled func() bool, name string, syncMoqParam v11.StorageClassHandlerFunc) {
	if mock.AddFeatureHandlerFunc == nil {
		panic("StorageClassControllerMock.AddFeatureHandlerFunc: method is nil but StorageClassController.AddFeatureHandler was just called")
	}
	callInfo := struct {
		Ctx     context.Context
		Enabled func() bool
		Name    string
		Sync    v11.StorageClassHandlerFunc
	}{
		Ctx:     ctx,
		Enabled: enabled,
		Name:    name,
		Sync:    syncMoqParam,
	}
	lockStorageClassControllerMockAddFeatureHandler.Lock()
	mock.calls.AddFeatureHandler = append(mock.calls.AddFeatureHandler, callInfo)
	lockStorageClassControllerMockAddFeatureHandler.Unlock()
	mock.AddFeatureHandlerFunc(ctx, enabled, name, syncMoqParam)
}

// AddFeatureHandlerCalls gets all the calls that were made to AddFeatureHandler.
// Check the length with:
//     len(mockedStorageClassController.AddFeatureHandlerCalls())
func (mock *StorageClassControllerMock) AddFeatureHandlerCalls() []struct {
	Ctx     context.Context
	Enabled func() bool
	Name    string
	Sync    v11.StorageClassHandlerFunc
} {
	var calls []struct {
		Ctx     context.Context
		Enabled func() bool
		Name    string
		Sync    v11.StorageClassHandlerFunc
	}
	lockStorageClassControllerMockAddFeatureHandler.RLock()
	calls = mock.calls.AddFeatureHandler
	lockStorageClassControllerMockAddFeatureHandler.RUnlock()
	return calls
}

// AddHandler calls AddHandlerFunc.
func (mock *StorageClassControllerMock) AddHandler(ctx context.Context, name string, handler v11.StorageClassHandlerFunc) {
	if mock.AddHandlerFunc == nil {
		panic("StorageClassControllerMock.AddHandlerFunc: method is nil but StorageClassController.AddHandler was just called")
	}
	callInfo := struct {
		Ctx     context.Context
		Name    string
		Handler v11.StorageClassHandlerFunc
	}{
		Ctx:     ctx,
		Name:    name,
		Handler: handler,
	}
	lockStorageClassControllerMockAddHandler.Lock()
	mock.calls.AddHandler = append(mock.calls.AddHandler, callInfo)
	lockStorageClassControllerMockAddHandler.Unlock()
	mock.AddHandlerFunc(ctx, name, handler)
}

// AddHandlerCalls gets all the calls that were made to AddHandler.
// Check the length with:
//     len(mockedStorageClassController.AddHandlerCalls())
func (mock *StorageClassControllerMock) AddHandlerCalls() []struct {
	Ctx     context.Context
	Name    string
	Handler v11.StorageClassHandlerFunc
} {
	var calls []struct {
		Ctx     context.Context
		Name    string
		Handler v11.StorageClassHandlerFunc
	}
	lockStorageClassControllerMockAddHandler.RLock()
	calls = mock.calls.AddHandler
	lockStorageClassControllerMockAddHandler.RUnlock()
	return calls
}

// Enqueue calls EnqueueFunc.
func (mock *StorageClassControllerMock) Enqueue(namespace string, name string) {
	if mock.EnqueueFunc == nil {
		panic("StorageClassControllerMock.EnqueueFunc: method is nil but StorageClassController.Enqueue was just called")
	}
	callInfo := struct {
		Namespace string
		Name      string
	}{
		Namespace: namespace,
		Name:      name,
	}
	lockStorageClassControllerMockEnqueue.Lock()
	mock.calls.Enqueue = append(mock.calls.Enqueue, callInfo)
	lockStorageClassControllerMockEnqueue.Unlock()
	mock.EnqueueFunc(namespace, name)
}

// EnqueueCalls gets all the calls that were made to Enqueue.
// Check the length with:
//     len(mockedStorageClassController.EnqueueCalls())
func (mock *StorageClassControllerMock) EnqueueCalls() []struct {
	Namespace string
	Name      string
} {
	var calls []struct {
		Namespace string
		Name      string
	}
	lockStorageClassControllerMockEnqueue.RLock()
	calls = mock.calls.Enqueue
	lockStorageClassControllerMockEnqueue.RUnlock()
	return calls
}

// EnqueueAfter calls EnqueueAfterFunc.
func (mock *StorageClassControllerMock) EnqueueAfter(namespace string, name string, after time.Duration) {
	if mock.EnqueueAfterFunc == nil {
		panic("StorageClassControllerMock.EnqueueAfterFunc: method is nil but StorageClassController.EnqueueAfter was just called")
	}
	callInfo := struct {
		Namespace string
		Name      string
		After     time.Duration
	}{
		Namespace: namespace,
		Name:      name,
		After:     after,
	}
	lockStorageClassControllerMockEnqueueAfter.Lock()
	mock.calls.EnqueueAfter = append(mock.calls.EnqueueAfter, callInfo)
	lockStorageClassControllerMockEnqueueAfter.Unlock()
	mock.EnqueueAfterFunc(namespace, name, after)
}

// EnqueueAfterCalls gets all the calls that were made to EnqueueAfter.
// Check the length with:
//     len(mockedStorageClassController.EnqueueAfterCalls())
func (mock *StorageClassControllerMock) EnqueueAfterCalls() []struct {
	Namespace string
	Name      string
	After     time.Duration
} {
	var calls []struct {
		Namespace string
		Name      string
		After     time.Duration
	}
	lockStorageClassControllerMockEnqueueAfter.RLock()
	calls = mock.calls.EnqueueAfter
	lockStorageClassControllerMockEnqueueAfter.RUnlock()
	return calls
}

// Generic calls GenericFunc.
func (mock *StorageClassControllerMock) Generic() controller.GenericController {
	if mock.GenericFunc == nil {
		panic("StorageClassControllerMock.GenericFunc: method is nil but StorageClassController.Generic was just called")
	}
	callInfo := struct {
	}{}
	lockStorageClassControllerMockGeneric.Lock()
	mock.calls.Generic = append(mock.calls.Generic, callInfo)
	lockStorageClassControllerMockGeneric.Unlock()
	return mock.GenericFunc()
}

// GenericCalls gets all the calls that were made to Generic.
// Check the length with:
//     len(mockedStorageClassController.GenericCalls())
func (mock *StorageClassControllerMock) GenericCalls() []struct {
} {
	var calls []struct {
	}
	lockStorageClassControllerMockGeneric.RLock()
	calls = mock.calls.Generic
	lockStorageClassControllerMockGeneric.RUnlock()
	return calls
}

// Informer calls InformerFunc.
func (mock *StorageClassControllerMock) Informer() cache.SharedIndexInformer {
	if mock.InformerFunc == nil {
		panic("StorageClassControllerMock.InformerFunc: method is nil but StorageClassController.Informer was just called")
	}
	callInfo := struct {
	}{}
	lockStorageClassControllerMockInformer.Lock()
	mock.calls.Informer = append(mock.calls.Informer, callInfo)
	lockStorageClassControllerMockInformer.Unlock()
	return mock.InformerFunc()
}

// InformerCalls gets all the calls that were made to Informer.
// Check the length with:
//     len(mockedStorageClassController.InformerCalls())
func (mock *StorageClassControllerMock) InformerCalls() []struct {
} {
	var calls []struct {
	}
	lockStorageClassControllerMockInformer.RLock()
	calls = mock.calls.Informer
	lockStorageClassControllerMockInformer.RUnlock()
	return calls
}

// Lister calls ListerFunc.
func (mock *StorageClassControllerMock) Lister() v11.StorageClassLister {
	if mock.ListerFunc == nil {
		panic("StorageClassControllerMock.ListerFunc: method is nil but StorageClassController.Lister was just called")
	}
	callInfo := struct {
	}{}
	lockStorageClassControllerMockLister.Lock()
	mock.calls.Lister = append(mock.calls.Lister, callInfo)
	lockStorageClassControllerMockLister.Unlock()
	return mock.ListerFunc()
}

// ListerCalls gets all the calls that were made to Lister.
// Check the length with:
//     len(mockedStorageClassController.ListerCalls())
func (mock *StorageClassControllerMock) ListerCalls() []struct {
} {
	var calls []struct {
	}
	lockStorageClassControllerMockLister.RLock()
	calls = mock.calls.Lister
	lockStorageClassControllerMockLister.RUnlock()
	return calls
}

var (
	lockStorageClassInterfaceMockAddClusterScopedFeatureHandler   sync.RWMutex
	lockStorageClassInterfaceMockAddClusterScopedFeatureLifecycle sync.RWMutex
	lockStorageClassInterfaceMockAddClusterScopedHandler          sync.RWMutex
	lockStorageClassInterfaceMockAddClusterScopedLifecycle        sync.RWMutex
	lockStorageClassInterfaceMockAddFeatureHandler                sync.RWMutex
	lockStorageClassInterfaceMockAddFeatureLifecycle              sync.RWMutex
	lockStorageClassInterfaceMockAddHandler                       sync.RWMutex
	lockStorageClassInterfaceMockAddLifecycle                     sync.RWMutex
	lockStorageClassInterfaceMockController                       sync.RWMutex
	lockStorageClassInterfaceMockCreate                           sync.RWMutex
	lockStorageClassInterfaceMockDelete                           sync.RWMutex
	lockStorageClassInterfaceMockDeleteCollection                 sync.RWMutex
	lockStorageClassInterfaceMockDeleteNamespaced                 sync.RWMutex
	lockStorageClassInterfaceMockGet                              sync.RWMutex
	lockStorageClassInterfaceMockGetNamespaced                    sync.RWMutex
	lockStorageClassInterfaceMockList                             sync.RWMutex
	lockStorageClassInterfaceMockListNamespaced                   sync.RWMutex
	lockStorageClassInterfaceMockObjectClient                     sync.RWMutex
	lockStorageClassInterfaceMockUpdate                           sync.RWMutex
	lockStorageClassInterfaceMockWatch                            sync.RWMutex
)

// Ensure, that StorageClassInterfaceMock does implement v11.StorageClassInterface.
// If this is not the case, regenerate this file with moq.
var _ v11.StorageClassInterface = &StorageClassInterfaceMock{}

// StorageClassInterfaceMock is a mock implementation of v11.StorageClassInterface.
//
//     func TestSomethingThatUsesStorageClassInterface(t *testing.T) {
//
//         // make and configure a mocked v11.StorageClassInterface
//         mockedStorageClassInterface := &StorageClassInterfaceMock{
//             AddClusterScopedFeatureHandlerFunc: func(ctx context.Context, enabled func() bool, name string, clusterName string, syncMoqParam v11.StorageClassHandlerFunc)  {
// 	               panic("mock out the AddClusterScopedFeatureHandler method")
//             },
//             AddClusterScopedFeatureLifecycleFunc: func(ctx context.Context, enabled func() bool, name string, clusterName string, lifecycle v11.StorageClassLifecycle)  {
// 	               panic("mock out the AddClusterScopedFeatureLifecycle method")
//             },
//             AddClusterScopedHandlerFunc: func(ctx context.Context, name string, clusterName string, syncMoqParam v11.StorageClassHandlerFunc)  {
// 	               panic("mock out the AddClusterScopedHandler method")
//             },
//             AddClusterScopedLifecycleFunc: func(ctx context.Context, name string, clusterName string, lifecycle v11.StorageClassLifecycle)  {
// 	               panic("mock out the AddClusterScopedLifecycle method")
//             },
//             AddFeatureHandlerFunc: func(ctx context.Context, enabled func() bool, name string, syncMoqParam v11.StorageClassHandlerFunc)  {
// 	               panic("mock out the AddFeatureHandler method")
//             },
//             AddFeatureLifecycleFunc: func(ctx context.Context, enabled func() bool, name string, lifecycle v11.StorageClassLifecycle)  {
// 	               panic("mock out the AddFeatureLifecycle method")
//             },
//             AddHandlerFunc: func(ctx context.Context, name string, syncMoqParam v11.StorageClassHandlerFunc)  {
// 	               panic("mock out the AddHandler method")
//             },
//             AddLifecycleFunc: func(ctx context.Context, name string, lifecycle v11.StorageClassLifecycle)  {
// 	               panic("mock out the AddLifecycle method")
//             },
//             ControllerFunc: func() v11.StorageClassController {
// 	               panic("mock out the Controller method")
//             },
//             CreateFunc: func(in1 *v1.StorageClass) (*v1.StorageClass, error) {
// 	               panic("mock out the Create method")
//             },
//             DeleteFunc: func(name string, options *metav1.DeleteOptions) error {
// 	               panic("mock out the Delete method")
//             },
//             DeleteCollectionFunc: func(deleteOpts *metav1.DeleteOptions, listOpts metav1.ListOptions) error {
// 	               panic("mock out the DeleteCollection method")
//             },
//             DeleteNamespacedFunc: func(namespace string, name string, options *metav1.DeleteOptions) error {
// 	               panic("mock out the DeleteNamespaced method")
//             },
//             GetFunc: func(name string, opts metav1.GetOptions) (*v1.StorageClass, error) {
// 	               panic("mock out the Get method")
//             },
//             GetNamespacedFunc: func(namespace string, name string, opts metav1.GetOptions) (*v1.StorageClass, error) {
// 	               panic("mock out the GetNamespaced method")
//             },
//             ListFunc: func(opts metav1.ListOptions) (*v1.StorageClassList, error) {
// 	               panic("mock out the List method")
//             },
//             ListNamespacedFunc: func(namespace string, opts metav1.ListOptions) (*v1.StorageClassList, error) {
// 	               panic("mock out the ListNamespaced method")
//             },
//             ObjectClientFunc: func() *objectclient.ObjectClient {
// 	               panic("mock out the ObjectClient method")
//             },
//             UpdateFunc: func(in1 *v1.StorageClass) (*v1.StorageClass, error) {
// 	               panic("mock out the Update method")
//             },
//             WatchFunc: func(opts metav1.ListOptions) (watch.Interface, error) {
// 	               panic("mock out the Watch method")
//             },
//         }
//
//         // use mockedStorageClassInterface in code that requires v11.StorageClassInterface
//         // and then make assertions.
//
//     }
type StorageClassInterfaceMock struct {
	// AddClusterScopedFeatureHandlerFunc mocks the AddClusterScopedFeatureHandler method.
	AddClusterScopedFeatureHandlerFunc func(ctx context.Context, enabled func() bool, name string, clusterName string, syncMoqParam v11.StorageClassHandlerFunc)

	// AddClusterScopedFeatureLifecycleFunc mocks the AddClusterScopedFeatureLifecycle method.
	AddClusterScopedFeatureLifecycleFunc func(ctx context.Context, enabled func() bool, name string, clusterName string, lifecycle v11.StorageClassLifecycle)

	// AddClusterScopedHandlerFunc mocks the AddClusterScopedHandler method.
	AddClusterScopedHandlerFunc func(ctx context.Context, name string, clusterName string, syncMoqParam v11.StorageClassHandlerFunc)

	// AddClusterScopedLifecycleFunc mocks the AddClusterScopedLifecycle method.
	AddClusterScopedLifecycleFunc func(ctx context.Context, name string, clusterName string, lifecycle v11.StorageClassLifecycle)

	// AddFeatureHandlerFunc mocks the AddFeatureHandler method.
	AddFeatureHandlerFunc func(ctx context.Context, enabled func() bool, name string, syncMoqParam v11.StorageClassHandlerFunc)

	// AddFeatureLifecycleFunc mocks the AddFeatureLifecycle method.
	AddFeatureLifecycleFunc func(ctx context.Context, enabled func() bool, name string, lifecycle v11.StorageClassLifecycle)

	// AddHandlerFunc mocks the AddHandler method.
	AddHandlerFunc func(ctx context.Context, name string, syncMoqParam v11.StorageClassHandlerFunc)

	// AddLifecycleFunc mocks the AddLifecycle method.
	AddLifecycleFunc func(ctx context.Context, name string, lifecycle v11.StorageClassLifecycle)

	// ControllerFunc mocks the Controller method.
	ControllerFunc func() v11.StorageClassController

	// CreateFunc mocks the Create method.
	CreateFunc func(in1 *v1.StorageClass) (*v1.StorageClass, error)

	// DeleteFunc mocks the Delete method.
	DeleteFunc func(name string, options *metav1.DeleteOptions) error

	// DeleteCollectionFunc mocks the DeleteCollection method.
	DeleteCollectionFunc func(deleteOpts *metav1.DeleteOptions, listOpts metav1.ListOptions) error

	// DeleteNamespacedFunc mocks the DeleteNamespaced method.
	DeleteNamespacedFunc func(namespace string, name string, options *metav1.DeleteOptions) error

	// GetFunc mocks the Get method.
	GetFunc func(name string, opts metav1.GetOptions) (*v1.StorageClass, error)

	// GetNamespacedFunc mocks the GetNamespaced method.
	GetNamespacedFunc func(namespace string, name string, opts metav1.GetOptions) (*v1.StorageClass, error)

	// ListFunc mocks the List method.
	ListFunc func(opts metav1.ListOptions) (*v1.StorageClassList, error)

	// ListNamespacedFunc mocks the ListNamespaced method.
	ListNamespacedFunc func(namespace string, opts metav1.ListOptions) (*v1.StorageClassList, error)

	// ObjectClientFunc mocks the ObjectClient method.
	ObjectClientFunc func() *objectclient.ObjectClient

	// UpdateFunc mocks the Update method.
	UpdateFunc func(in1 *v1.StorageClass) (*v1.StorageClass, error)

	// WatchFunc mocks the Watch method.
	WatchFunc func(opts metav1.ListOptions) (watch.Interface, error)

	// calls tracks calls to the methods.
	calls struct {
		// AddClusterScopedFeatureHandler holds details about calls to the AddClusterScopedFeatureHandler method.
		AddClusterScopedFeatureHandler []struct {
			// Ctx is the ctx argument value.
			Ctx context.Context
			// Enabled is the enabled argument value.
			Enabled func() bool
			// Name is the name argument value.
			Name string
			// ClusterName is the clusterName argument value.
			ClusterName string
			// Sync is the sync argument value.
			Sync v11.StorageClassHandlerFunc
		}
		// AddClusterScopedFeatureLifecycle holds details about calls to the AddClusterScopedFeatureLifecycle method.
		AddClusterScopedFeatureLifecycle []struct {
			// Ctx is the ctx argument value.
			Ctx context.Context
			// Enabled is the enabled argument value.
			Enabled func() bool
			// Name is the name argument value.
			Name string
			// ClusterName is the clusterName argument value.
			ClusterName string
			// Lifecycle is the lifecycle argument value.
			Lifecycle v11.StorageClassLifecycle
		}
		// AddClusterScopedHandler holds details about calls to the AddClusterScopedHandler method.
		AddClusterScopedHandler []struct {
			// Ctx is the ctx argument value.
			Ctx context.Context
			// Name is the name argument value.
			Name string
			// ClusterName is the clusterName argument value.
			ClusterName string
			// Sync is the sync argument value.
			Sync v11.StorageClassHandlerFunc
		}
		// AddClusterScopedLifecycle holds details about calls to the AddClusterScopedLifecycle method.
		AddClusterScopedLifecycle []struct {
			// Ctx is the ctx argument value.
			Ctx context.Context
			// Name is the name argument value.
			Name string
			// ClusterName is the clusterName argument value.
			ClusterName string
			// Lifecycle is the lifecycle argument value.
			Lifecycle v11.StorageClassLifecycle
		}
		// AddFeatureHandler holds details about calls to the AddFeatureHandler method.
		AddFeatureHandler []struct {
			// Ctx is the ctx argument value.
			Ctx context.Context
			// Enabled is the enabled argument value.
			Enabled func() bool
			// Name is the name argument value.
			Name string
			// Sync is the sync argument value.
			Sync v11.StorageClassHandlerFunc
		}
		// AddFeatureLifecycle holds details about calls to the AddFeatureLifecycle method.
		AddFeatureLifecycle []struct {
			// Ctx is the ctx argument value.
			Ctx context.Context
			// Enabled is the enabled argument value.
			Enabled func() bool
			// Name is the name argument value.
			Name string
			// Lifecycle is the lifecycle argument value.
			Lifecycle v11.StorageClassLifecycle
		}
		// AddHandler holds details about calls to the AddHandler method.
		AddHandler []struct {
			// Ctx is the ctx argument value.
			Ctx context.Context
			// Name is the name argument value.
			Name string
			// Sync is the sync argument value.
			Sync v11.StorageClassHandlerFunc
		}
		// AddLifecycle holds details about calls to the AddLifecycle method.
		AddLifecycle []struct {
			// Ctx is the ctx argument value.
			Ctx context.Context
			// Name is the name argument value.
			Name string
			// Lifecycle is the lifecycle argument value.
			Lifecycle v11.StorageClassLifecycle
		}
		// Controller holds details about calls to the Controller method.
		Controller []struct {
		}
		// Create holds details about calls to the Create method.
		Create []struct {
			// In1 is the in1 argument value.
			In1 *v1.StorageClass
		}
		// Delete holds details about calls to the Delete method.
		Delete []struct {
			// Name is the name argument value.
			Name string
			// Options is the options argument value.
			Options *metav1.DeleteOptions
		}
		// DeleteCollection holds details about calls to the DeleteCollection method.
		DeleteCollection []struct {
			// DeleteOpts is the deleteOpts argument value.
			DeleteOpts *metav1.DeleteOptions
			// ListOpts is the listOpts argument value.
			ListOpts metav1.ListOptions
		}
		// DeleteNamespaced holds details about calls to the DeleteNamespaced method.
		DeleteNamespaced []struct {
			// Namespace is the namespace argument value.
			Namespace string
			// Name is the name argument value.
			Name string
			// Options is the options argument value.
			Options *metav1.DeleteOptions
		}
		// Get holds details about calls to the Get method.
		Get []struct {
			// Name is the name argument value.
			Name string
			// Opts is the opts argument value.
			Opts metav1.GetOptions
		}
		// GetNamespaced holds details about calls to the GetNamespaced method.
		GetNamespaced []struct {
			// Namespace is the namespace argument value.
			Namespace string
			// Name is the name argument value.
			Name string
			// Opts is the opts argument value.
			Opts metav1.GetOptions
		}
		// List holds details about calls to the List method.
		List []struct {
			// Opts is the opts argument value.
			Opts metav1.ListOptions
		}
		// ListNamespaced holds details about calls to the ListNamespaced method.
		ListNamespaced []struct {
			// Namespace is the namespace argument value.
			Namespace string
			// Opts is the opts argument value.
			Opts metav1.ListOptions
		}
		// ObjectClient holds details about calls to the ObjectClient method.
		ObjectClient []struct {
		}
		// Update holds details about calls to the Update method.
		Update []struct {
			// In1 is the in1 argument value.
			In1 *v1.StorageClass
		}
		// Watch holds details about calls to the Watch method.
		Watch []struct {
			// Opts is the opts argument value.
			Opts metav1.ListOptions
		}
	}
}

// AddClusterScopedFeatureHandler calls AddClusterScopedFeatureHandlerFunc.
func (mock *StorageClassInterfaceMock) AddClusterScopedFeatureHandler(ctx context.Context, enabled func() bool, name string, clusterName string, syncMoqParam v11.StorageClassHandlerFunc) {
	if mock.AddClusterScopedFeatureHandlerFunc == nil {
		panic("StorageClassInterfaceMock.AddClusterScopedFeatureHandlerFunc: method is nil but StorageClassInterface.AddClusterScopedFeatureHandler was just called")
	}
	callInfo := struct {
		Ctx         context.Context
		Enabled     func() bool
		Name        string
		ClusterName string
		Sync        v11.StorageClassHandlerFunc
	}{
		Ctx:         ctx,
		Enabled:     enabled,
		Name:        name,
		ClusterName: clusterName,
		Sync:        syncMoqParam,
	}
	lockStorageClassInterfaceMockAddClusterScopedFeatureHandler.Lock()
	mock.calls.AddClusterScopedFeatureHandler = append(mock.calls.AddClusterScopedFeatureHandler, callInfo)
	lockStorageClassInterfaceMockAddClusterScopedFeatureHandler.Unlock()
	mock.AddClusterScopedFeatureHandlerFunc(ctx, enabled, name, clusterName, syncMoqParam)
}

// AddClusterScopedFeatureHandlerCalls gets all the calls that were made to AddClusterScopedFeatureHandler.
// Check the length with:
//     len(mockedStorageClassInterface.AddClusterScopedFeatureHandlerCalls())
func (mock *StorageClassInterfaceMock) AddClusterScopedFeatureHandlerCalls() []struct {
	Ctx         context.Context
	Enabled     func() bool
	Name        string
	ClusterName string
	Sync        v11.StorageClassHandlerFunc
} {
	var calls []struct {
		Ctx         context.Context
		Enabled     func() bool
		Name        string
		ClusterName string
		Sync        v11.StorageClassHandlerFunc
	}
	lockStorageClassInterfaceMockAddClusterScopedFeatureHandler.RLock()
	calls = mock.calls.AddClusterScopedFeatureHandler
	lockStorageClassInterfaceMockAddClusterScopedFeatureHandler.RUnlock()
	return calls
}

// AddClusterScopedFeatureLifecycle calls AddClusterScopedFeatureLifecycleFunc.
func (mock *StorageClassInterfaceMock) AddClusterScopedFeatureLifecycle(ctx context.Context, enabled func() bool, name string, clusterName string, lifecycle v11.StorageClassLifecycle) {
	if mock.AddClusterScopedFeatureLifecycleFunc == nil {
		panic("StorageClassInterfaceMock.AddClusterScopedFeatureLifecycleFunc: method is nil but StorageClassInterface.AddClusterScopedFeatureLifecycle was just called")
	}
	callInfo := struct {
		Ctx         context.Context
		Enabled     func() bool
		Name        string
		ClusterName string
		Lifecycle   v11.StorageClassLifecycle
	}{
		Ctx:         ctx,
		Enabled:     enabled,
		Name:        name,
		ClusterName: clusterName,
		Lifecycle:   lifecycle,
	}
	lockStorageClassInterfaceMockAddClusterScopedFeatureLifecycle.Lock()
	mock.calls.AddClusterScopedFeatureLifecycle = append(mock.calls.AddClusterScopedFeatureLifecycle, callInfo)
	lockStorageClassInterfaceMockAddClusterScopedFeatureLifecycle.Unlock()
	mock.AddClusterScopedFeatureLifecycleFunc(ctx, enabled, name, clusterName, lifecycle)
}

// AddClusterScopedFeatureLifecycleCalls gets all the calls that were made to AddClusterScopedFeatureLifecycle.
// Check the length with:
//     len(mockedStorageClassInterface.AddClusterScopedFeatureLifecycleCalls())
func (mock *StorageClassInterfaceMock) AddClusterScopedFeatureLifecycleCalls() []struct {
	Ctx         context.Context
	Enabled     func() bool
	Name        string
	ClusterName string
	Lifecycle   v11.StorageClassLifecycle
} {
	var calls []struct {
		Ctx         context.Context
		Enabled     func() bool
		Name        string
		ClusterName string
		Lifecycle   v11.StorageClassLifecycle
	}
	lockStorageClassInterfaceMockAddClusterScopedFeatureLifecycle.RLock()
	calls = mock.calls.AddClusterScopedFeatureLifecycle
	lockStorageClassInterfaceMockAddClusterScopedFeatureLifecycle.RUnlock()
	return calls
}

// AddClusterScopedHandler calls AddClusterScopedHandlerFunc.
func (mock *StorageClassInterfaceMock) AddClusterScopedHandler(ctx context.Context, name string, clusterName string, syncMoqParam v11.StorageClassHandlerFunc) {
	if mock.AddClusterScopedHandlerFunc == nil {
		panic("StorageClassInterfaceMock.AddClusterScopedHandlerFunc: method is nil but StorageClassInterface.AddClusterScopedHandler was just called")
	}
	callInfo := struct {
		Ctx         context.Context
		Name        string
		ClusterName string
		Sync        v11.StorageClassHandlerFunc
	}{
		Ctx:         ctx,
		Name:        name,
		ClusterName: clusterName,
		Sync:        syncMoqParam,
	}
	lockStorageClassInterfaceMockAddClusterScopedHandler.Lock()
	mock.calls.AddClusterScopedHandler = append(mock.calls.AddClusterScopedHandler, callInfo)
	lockStorageClassInterfaceMockAddClusterScopedHandler.Unlock()
	mock.AddClusterScopedHandlerFunc(ctx, name, clusterName, syncMoqParam)
}

// AddClusterScopedHandlerCalls gets all the calls that were made to AddClusterScopedHandler.
// Check the length with:
//     len(mockedStorageClassInterface.AddClusterScopedHandlerCalls())
func (mock *StorageClassInterfaceMock) AddClusterScopedHandlerCalls() []struct {
	Ctx         context.Context
	Name        string
	ClusterName string
	Sync        v11.StorageClassHandlerFunc
} {
	var calls []struct {
		Ctx         context.Context
		Name        string
		ClusterName string
		Sync        v11.StorageClassHandlerFunc
	}
	lockStorageClassInterfaceMockAddClusterScopedHandler.RLock()
	calls = mock.calls.AddClusterScopedHandler
	lockStorageClassInterfaceMockAddClusterScopedHandler.RUnlock()
	return calls
}

// AddClusterScopedLifecycle calls AddClusterScopedLifecycleFunc.
func (mock *StorageClassInterfaceMock) AddClusterScopedLifecycle(ctx context.Context, name string, clusterName string, lifecycle v11.StorageClassLifecycle) {
	if mock.AddClusterScopedLifecycleFunc == nil {
		panic("StorageClassInterfaceMock.AddClusterScopedLifecycleFunc: method is nil but StorageClassInterface.AddClusterScopedLifecycle was just called")
	}
	callInfo := struct {
		Ctx         context.Context
		Name        string
		ClusterName string
		Lifecycle   v11.StorageClassLifecycle
	}{
		Ctx:         ctx,
		Name:        name,
		ClusterName: clusterName,
		Lifecycle:   lifecycle,
	}
	lockStorageClassInterfaceMockAddClusterScopedLifecycle.Lock()
	mock.calls.AddClusterScopedLifecycle = append(mock.calls.AddClusterScopedLifecycle, callInfo)
	lockStorageClassInterfaceMockAddClusterScopedLifecycle.Unlock()
	mock.AddClusterScopedLifecycleFunc(ctx, name, clusterName, lifecycle)
}

// AddClusterScopedLifecycleCalls gets all the calls that were made to AddClusterScopedLifecycle.
// Check the length with:
//     len(mockedStorageClassInterface.AddClusterScopedLifecycleCalls())
func (mock *StorageClassInterfaceMock) AddClusterScopedLifecycleCalls() []struct {
	Ctx         context.Context
	Name        string
	ClusterName string
	Lifecycle   v11.StorageClassLifecycle
} {
	var calls []struct {
		Ctx         context.Context
		Name        string
		ClusterName string
		Lifecycle   v11.StorageClassLifecycle
	}
	lockStorageClassInterfaceMockAddClusterScopedLifecycle.RLock()
	calls = mock.calls.AddClusterScopedLifecycle
	lockStorageClassInterfaceMockAddClusterScopedLifecycle.RUnlock()
	return calls
}

// AddFeatureHandler calls AddFeatureHandlerFunc.
func (mock *StorageClassInterfaceMock) AddFeatureHandler(ctx context.Context, enabled func() bool, name string, syncMoqParam v11.StorageClassHandlerFunc) {
	if mock.AddFeatureHandlerFunc == nil {
		panic("StorageClassInterfaceMock.AddFeatureHandlerFunc: method is nil but StorageClassInterface.AddFeatureHandler was just called")
	}
	callInfo := struct {
		Ctx     context.Context
		Enabled func() bool
		Name    string
		Sync    v11.StorageClassHandlerFunc
	}{
		Ctx:     ctx,
		Enabled: enabled,
		Name:    name,
		Sync:    syncMoqParam,
	}
	lockStorageClassInterfaceMockAddFeatureHandler.Lock()
	mock.calls.AddFeatureHandler = append(mock.calls.AddFeatureHandler, callInfo)
	lockStorageClassInterfaceMockAddFeatureHandler.Unlock()
	mock.AddFeatureHandlerFunc(ctx, enabled, name, syncMoqParam)
}

// AddFeatureHandlerCalls gets all the calls that were made to AddFeatureHandler.
// Check the length with:
//     len(mockedStorageClassInterface.AddFeatureHandlerCalls())
func (mock *StorageClassInterfaceMock) AddFeatureHandlerCalls() []struct {
	Ctx     context.Context
	Enabled func() bool
	Name    string
	Sync    v11.StorageClassHandlerFunc
} {
	var calls []struct {
		Ctx     context.Context
		Enabled func() bool
		Name    string
		Sync    v11.StorageClassHandlerFunc
	}
	lockStorageClassInterfaceMockAddFeatureHandler.RLock()
	calls = mock.calls.AddFeatureHandler
	lockStorageClassInterfaceMockAddFeatureHandler.RUnlock()
	return calls
}

// AddFeatureLifecycle calls AddFeatureLifecycleFunc.
func (mock *StorageClassInterfaceMock) AddFeatureLifecycle(ctx context.Context, enabled func() bool, name string, lifecycle v11.StorageClassLifecycle) {
	if mock.AddFeatureLifecycleFunc == nil {
		panic("StorageClassInterfaceMock.AddFeatureLifecycleFunc: method is nil but StorageClassInterface.AddFeatureLifecycle was just called")
	}
	callInfo := struct {
		Ctx       context.Context
		Enabled   func() bool
		Name      string
		Lifecycle v11.StorageClassLifecycle
	}{
		Ctx:       ctx,
		Enabled:   enabled,
		Name:      name,
		Lifecycle: lifecycle,
	}
	lockStorageClassInterfaceMockAddFeatureLifecycle.Lock()
	mock.calls.AddFeatureLifecycle = append(mock.calls.AddFeatureLifecycle, callInfo)
	lockStorageClassInterfaceMockAddFeatureLifecycle.Unlock()
	mock.AddFeatureLifecycleFunc(ctx, enabled, name, lifecycle)
}

// AddFeatureLifecycleCalls gets all the calls that were made to AddFeatureLifecycle.
// Check the length with:
//     len(mockedStorageClassInterface.AddFeatureLifecycleCalls())
func (mock *StorageClassInterfaceMock) AddFeatureLifecycleCalls() []struct {
	Ctx       context.Context
	Enabled   func() bool
	Name      string
	Lifecycle v11.StorageClassLifecycle
} {
	var calls []struct {
		Ctx       context.Context
		Enabled   func() bool
		Name      string
		Lifecycle v11.StorageClassLifecycle
	}
	lockStorageClassInterfaceMockAddFeatureLifecycle.RLock()
	calls = mock.calls.AddFeatureLifecycle
	lockStorageClassInterfaceMockAddFeatureLifecycle.RUnlock()
	return calls
}

// AddHandler calls AddHandlerFunc.
func (mock *StorageClassInterfaceMock) AddHandler(ctx context.Context, name string, syncMoqParam v11.StorageClassHandlerFunc) {
	if mock.AddHandlerFunc == nil {
		panic("StorageClassInterfaceMock.AddHandlerFunc: method is nil but StorageClassInterface.AddHandler was just called")
	}
	callInfo := struct {
		Ctx  context.Context
		Name string
		Sync v11.StorageClassHandlerFunc
	}{
		Ctx:  ctx,
		Name: name,
		Sync: syncMoqParam,
	}
	lockStorageClassInterfaceMockAddHandler.Lock()
	mock.calls.AddHandler = append(mock.calls.AddHandler, callInfo)
	lockStorageClassInterfaceMockAddHandler.Unlock()
	mock.AddHandlerFunc(ctx, name, syncMoqParam)
}

// AddHandlerCalls gets all the calls that were made to AddHandler.
// Check the length with:
//     len(mockedStorageClassInterface.AddHandlerCalls())
func (mock *StorageClassInterfaceMock) AddHandlerCalls() []struct {
	Ctx  context.Context
	Name string
	Sync v11.StorageClassHandlerFunc
} {
	var calls []struct {
		Ctx  context.Context
		Name string
		Sync v11.StorageClassHandlerFunc
	}
	lockStorageClassInterfaceMockAddHandler.RLock()
	calls = mock.calls.AddHandler
	lockStorageClassInterfaceMockAddHandler.RUnlock()
	return calls
}

// AddLifecycle calls AddLifecycleFunc.
func (mock *StorageClassInterfaceMock) AddLifecycle(ctx context.Context, name string, lifecycle v11.StorageClassLifecycle) {
	if mock.AddLifecycleFunc == nil {
		panic("StorageClassInterfaceMock.AddLifecycleFunc: method is nil but StorageClassInterface.AddLifecycle was just called")
	}
	callInfo := struct {
		Ctx       context.Context
		Name      string
		Lifecycle v11.StorageClassLifecycle
	}{
		Ctx:       ctx,
		Name:      name,
		Lifecycle: lifecycle,
	}
	lockStorageClassInterfaceMockAddLifecycle.Lock()
	mock.calls.AddLifecycle = append(mock.calls.AddLifecycle, callInfo)
	lockStorageClassInterfaceMockAddLifecycle.Unlock()
	mock.AddLifecycleFunc(ctx, name, lifecycle)
}

// AddLifecycleCalls gets all the calls that were made to AddLifecycle.
// Check the length with:
//     len(mockedStorageClassInterface.AddLifecycleCalls())
func (mock *StorageClassInterfaceMock) AddLifecycleCalls() []struct {
	Ctx       context.Context
	Name      string
	Lifecycle v11.StorageClassLifecycle
} {
	var calls []struct {
		Ctx       context.Context
		Name      string
		Lifecycle v11.StorageClassLifecycle
	}
	lockStorageClassInterfaceMockAddLifecycle.RLock()
	calls = mock.calls.AddLifecycle
	lockStorageClassInterfaceMockAddLifecycle.RUnlock()
	return calls
}

// Controller calls ControllerFunc.
func (mock *StorageClassInterfaceMock) Controller() v11.StorageClassController {
	if mock.ControllerFunc == nil {
		panic("StorageClassInterfaceMock.ControllerFunc: method is nil but StorageClassInterface.Controller was just called")
	}
	callInfo := struct {
	}{}
	lockStorageClassInterfaceMockController.Lock()
	mock.calls.Controller = append(mock.calls.Controller, callInfo)
	lockStorageClassInterfaceMockController.Unlock()
	return mock.ControllerFunc()
}

// ControllerCalls gets all the calls that were made to Controller.
// Check the length with:
//     len(mockedStorageClassInterface.ControllerCalls())
func (mock *StorageClassInterfaceMock) ControllerCalls() []struct {
} {
	var calls []struct {
	}
	lockStorageClassInterfaceMockController.RLock()
	calls = mock.calls.Controller
	lockStorageClassInterfaceMockController.RUnlock()
	return calls
}

// Create calls CreateFunc.
func (mock *StorageClassInterfaceMock) Create(in1 *v1.StorageClass) (*v1.StorageClass, error) {
	if mock.CreateFunc == nil {
		panic("StorageClassInterfaceMock.CreateFunc: method is nil but StorageClassInterface.Create was just called")
	}
	callInfo := struct {
		In1 *v1.StorageClass
	}{
		In1: in1,
	}
	lockStorageClassInterfaceMockCreate.Lock()
	mock.calls.Create = append(mock.calls.Create, callInfo)
	lockStorageClassInterfaceMockCreate.Unlock()
	return mock.CreateFunc(in1)
}

// CreateCalls gets all the calls that were made to Create.
// Check the length with:
//     len(mockedStorageClassInterface.CreateCalls())
func (mock *StorageClassInterfaceMock) CreateCalls() []struct {
	In1 *v1.StorageClass
} {
	var calls []struct {
		In1 *v1.StorageClass
	}
	lockStorageClassInterfaceMockCreate.RLock()
	calls = mock.calls.Create
	lockStorageClassInterfaceMockCreate.RUnlock()
	return calls
}

// Delete calls DeleteFunc.
func (mock *StorageClassInterfaceMock) Delete(name string, options *metav1.DeleteOptions) error {
	if mock.DeleteFunc == nil {
		panic("StorageClassInterfaceMock.DeleteFunc: method is nil but StorageClassInterface.Delete was just called")
	}
	callInfo := struct {
		Name    string
		Options *metav1.DeleteOptions
	}{
		Name:    name,
		Options: options,
	}
	lockStorageClassInterfaceMockDelete.Lock()
	mock.calls.Delete = append(mock.calls.Delete, callInfo)
	lockStorageClassInterfaceMockDelete.Unlock()
	return mock.DeleteFunc(name, options)
}

// DeleteCalls gets all the calls that were made to Delete.
// Check the length with:
//     len(mockedStorageClassInterface.DeleteCalls())
func (mock *StorageClassInterfaceMock) DeleteCalls() []struct {
	Name    string
	Options *metav1.DeleteOptions
} {
	var calls []struct {
		Name    string
		Options *metav1.DeleteOptions
	}
	lockStorageClassInterfaceMockDelete.RLock()
	calls = mock.calls.Delete
	lockStorageClassInterfaceMockDelete.RUnlock()
	return calls
}

// DeleteCollection calls DeleteCollectionFunc.
func (mock *StorageClassInterfaceMock) DeleteCollection(deleteOpts *metav1.DeleteOptions, listOpts metav1.ListOptions) error {
	if mock.DeleteCollectionFunc == nil {
		panic("StorageClassInterfaceMock.DeleteCollectionFunc: method is nil but StorageClassInterface.DeleteCollection was just called")
	}
	callInfo := struct {
		DeleteOpts *metav1.DeleteOptions
		ListOpts   metav1.ListOptions
	}{
		DeleteOpts: deleteOpts,
		ListOpts:   listOpts,
	}
	lockStorageClassInterfaceMockDeleteCollection.Lock()
	mock.calls.DeleteCollection = append(mock.calls.DeleteCollection, callInfo)
	lockStorageClassInterfaceMockDeleteCollection.Unlock()
	return mock.DeleteCollectionFunc(deleteOpts, listOpts)
}

// DeleteCollectionCalls gets all the calls that were made to DeleteCollection.
// Check the length with:
//     len(mockedStorageClassInterface.DeleteCollectionCalls())
func (mock *StorageClassInterfaceMock) DeleteCollectionCalls() []struct {
	DeleteOpts *metav1.DeleteOptions
	ListOpts   metav1.ListOptions
} {
	var calls []struct {
		DeleteOpts *metav1.DeleteOptions
		ListOpts   metav1.ListOptions
	}
	lockStorageClassInterfaceMockDeleteCollection.RLock()
	calls = mock.calls.DeleteCollection
	lockStorageClassInterfaceMockDeleteCollection.RUnlock()
	return calls
}

// DeleteNamespaced calls DeleteNamespacedFunc.
func (mock *StorageClassInterfaceMock) DeleteNamespaced(namespace string, name string, options *metav1.DeleteOptions) error {
	if mock.DeleteNamespacedFunc == nil {
		panic("StorageClassInterfaceMock.DeleteNamespacedFunc: method is nil but StorageClassInterface.DeleteNamespaced was just called")
	}
	callInfo := struct {
		Namespace string
		Name      string
		Options   *metav1.DeleteOptions
	}{
		Namespace: namespace,
		Name:      name,
		Options:   options,
	}
	lockStorageClassInterfaceMockDeleteNamespaced.Lock()
	mock.calls.DeleteNamespaced = append(mock.calls.DeleteNamespaced, callInfo)
	lockStorageClassInterfaceMockDeleteNamespaced.Unlock()
	return mock.DeleteNamespacedFunc(namespace, name, options)
}

// DeleteNamespacedCalls gets all the calls that were made to DeleteNamespaced.
// Check the length with:
//     len(mockedStorageClassInterface.DeleteNamespacedCalls())
func (mock *StorageClassInterfaceMock) DeleteNamespacedCalls() []struct {
	Namespace string
	Name      string
	Options   *metav1.DeleteOptions
} {
	var calls []struct {
		Namespace string
		Name      string
		Options   *metav1.DeleteOptions
	}
	lockStorageClassInterfaceMockDeleteNamespaced.RLock()
	calls = mock.calls.DeleteNamespaced
	lockStorageClassInterfaceMockDeleteNamespaced.RUnlock()
	return calls
}

// Get calls GetFunc.
func (mock *StorageClassInterfaceMock) Get(name string, opts metav1.GetOptions) (*v1.StorageClass, error) {
	if mock.GetFunc == nil {
		panic("StorageClassInterfaceMock.GetFunc: method is nil but StorageClassInterface.Get was just called")
	}
	callInfo := struct {
		Name string
		Opts metav1.GetOptions
	}{
		Name: name,
		Opts: opts,
	}
	lockStorageClassInterfaceMockGet.Lock()
	mock.calls.Get = append(mock.calls.Get, callInfo)
	lockStorageClassInterfaceMockGet.Unlock()
	return mock.GetFunc(name, opts)
}

// GetCalls gets all the calls that were made to Get.
// Check the length with:
//     len(mockedStorageClassInterface.GetCalls())
func (mock *StorageClassInterfaceMock) GetCalls() []struct {
	Name string
	Opts metav1.GetOptions
} {
	var calls []struct {
		Name string
		Opts metav1.GetOptions
	}
	lockStorageClassInterfaceMockGet.RLock()
	calls = mock.calls.Get
	lockStorageClassInterfaceMockGet.RUnlock()
	return calls
}

// GetNamespaced calls GetNamespacedFunc.
func (mock *StorageClassInterfaceMock) GetNamespaced(namespace string, name string, opts metav1.GetOptions) (*v1.StorageClass, error) {
	if mock.GetNamespacedFunc == nil {
		panic("StorageClassInterfaceMock.GetNamespacedFunc: method is nil but StorageClassInterface.GetNamespaced was just called")
	}
	callInfo := struct {
		Namespace string
		Name      string
		Opts      metav1.GetOptions
	}{
		Namespace: namespace,
		Name:      name,
		Opts:      opts,
	}
	lockStorageClassInterfaceMockGetNamespaced.Lock()
	mock.calls.GetNamespaced = append(mock.calls.GetNamespaced, callInfo)
	lockStorageClassInterfaceMockGetNamespaced.Unlock()
	return mock.GetNamespacedFunc(namespace, name, opts)
}

// GetNamespacedCalls gets all the calls that were made to GetNamespaced.
// Check the length with:
//     len(mockedStorageClassInterface.GetNamespacedCalls())
func (mock *StorageClassInterfaceMock) GetNamespacedCalls() []struct {
	Namespace string
	Name      string
	Opts      metav1.GetOptions
} {
	var calls []struct {
		Namespace string
		Name      string
		Opts      metav1.GetOptions
	}
	lockStorageClassInterfaceMockGetNamespaced.RLock()
	calls = mock.calls.GetNamespaced
	lockStorageClassInterfaceMockGetNamespaced.RUnlock()
	return calls
}

// List calls ListFunc.
func (mock *StorageClassInterfaceMock) List(opts metav1.ListOptions) (*v1.StorageClassList, error) {
	if mock.ListFunc == nil {
		panic("StorageClassInterfaceMock.ListFunc: method is nil but StorageClassInterface.List was just called")
	}
	callInfo := struct {
		Opts metav1.ListOptions
	}{
		Opts: opts,
	}
	lockStorageClassInterfaceMockList.Lock()
	mock.calls.List = append(mock.calls.List, callInfo)
	lockStorageClassInterfaceMockList.Unlock()
	return mock.ListFunc(opts)
}

// ListCalls gets all the calls that were made to List.
// Check the length with:
//     len(mockedStorageClassInterface.ListCalls())
func (mock *StorageClassInterfaceMock) ListCalls() []struct {
	Opts metav1.ListOptions
} {
	var calls []struct {
		Opts metav1.ListOptions
	}
	lockStorageClassInterfaceMockList.RLock()
	calls = mock.calls.List
	lockStorageClassInterfaceMockList.RUnlock()
	return calls
}

// ListNamespaced calls ListNamespacedFunc.
func (mock *StorageClassInterfaceMock) ListNamespaced(namespace string, opts metav1.ListOptions) (*v1.StorageClassList, error) {
	if mock.ListNamespacedFunc == nil {
		panic("StorageClassInterfaceMock.ListNamespacedFunc: method is nil but StorageClassInterface.ListNamespaced was just called")
	}
	callInfo := struct {
		Namespace string
		Opts      metav1.ListOptions
	}{
		Namespace: namespace,
		Opts:      opts,
	}
	lockStorageClassInterfaceMockListNamespaced.Lock()
	mock.calls.ListNamespaced = append(mock.calls.ListNamespaced, callInfo)
	lockStorageClassInterfaceMockListNamespaced.Unlock()
	return mock.ListNamespacedFunc(namespace, opts)
}

// ListNamespacedCalls gets all the calls that were made to ListNamespaced.
// Check the length with:
//     len(mockedStorageClassInterface.ListNamespacedCalls())
func (mock *StorageClassInterfaceMock) ListNamespacedCalls() []struct {
	Namespace string
	Opts      metav1.ListOptions
} {
	var calls []struct {
		Namespace string
		Opts      metav1.ListOptions
	}
	lockStorageClassInterfaceMockListNamespaced.RLock()
	calls = mock.calls.ListNamespaced
	lockStorageClassInterfaceMockListNamespaced.RUnlock()
	return calls
}

// ObjectClient calls ObjectClientFunc.
func (mock *StorageClassInterfaceMock) ObjectClient() *objectclient.ObjectClient {
	if mock.ObjectClientFunc == nil {
		panic("StorageClassInterfaceMock.ObjectClientFunc: method is nil but StorageClassInterface.ObjectClient was just called")
	}
	callInfo := struct {
	}{}
	lockStorageClassInterfaceMockObjectClient.Lock()
	mock.calls.ObjectClient = append(mock.calls.ObjectClient, callInfo)
	lockStorageClassInterfaceMockObjectClient.Unlock()
	return mock.ObjectClientFunc()
}

// ObjectClientCalls gets all the calls that were made to ObjectClient.
// Check the length with:
//     len(mockedStorageClassInterface.ObjectClientCalls())
func (mock *StorageClassInterfaceMock) ObjectClientCalls() []struct {
} {
	var calls []struct {
	}
	lockStorageClassInterfaceMockObjectClient.RLock()
	calls = mock.calls.ObjectClient
	lockStorageClassInterfaceMockObjectClient.RUnlock()
	return calls
}

// Update calls UpdateFunc.
func (mock *StorageClassInterfaceMock) Update(in1 *v1.StorageClass) (*v1.StorageClass, error) {
	if mock.UpdateFunc == nil {
		panic("StorageClassInterfaceMock.UpdateFunc: method is nil but StorageClassInterface.Update was just called")
	}
	callInfo := struct {
		In1 *v1.StorageClass
	}{
		In1: in1,
	}
	lockStorageClassInterfaceMockUpdate.Lock()
	mock.calls.Update = append(mock.calls.Update, callInfo)
	lockStorageClassInterfaceMockUpdate.Unlock()
	return mock.UpdateFunc(in1)
}

// UpdateCalls gets all the calls that were made to Update.
// Check the length with:
//     len(mockedStorageClassInterface.UpdateCalls())
func (mock *StorageClassInterfaceMock) UpdateCalls() []struct {
	In1 *v1.StorageClass
} {
	var calls []struct {
		In1 *v1.StorageClass
	}
	lockStorageClassInterfaceMockUpdate.RLock()
	calls = mock.calls.Update
	lockStorageClassInterfaceMockUpdate.RUnlock()
	return calls
}

// Watch calls WatchFunc.
func (mock *StorageClassInterfaceMock) Watch(opts metav1.ListOptions) (watch.Interface, error) {
	if mock.WatchFunc == nil {
		panic("StorageClassInterfaceMock.WatchFunc: method is nil but StorageClassInterface.Watch was just called")
	}
	callInfo := struct {
		Opts metav1.ListOptions
	}{
		Opts: opts,
	}
	lockStorageClassInterfaceMockWatch.Lock()
	mock.calls.Watch = append(mock.calls.Watch, callInfo)
	lockStorageClassInterfaceMockWatch.Unlock()
	return mock.WatchFunc(opts)
}

// WatchCalls gets all the calls that were made to Watch.
// Check the length with:
//     len(mockedStorageClassInterface.WatchCalls())
func (mock *StorageClassInterfaceMock) WatchCalls() []struct {
	Opts metav1.ListOptions
} {
	var calls []struct {
		Opts metav1.ListOptions
	}
	lockStorageClassInterfaceMockWatch.RLock()
	calls = mock.calls.Watch
	lockStorageClassInterfaceMockWatch.RUnlock()
	return calls
}

var (
	lockStorageClassesGetterMockStorageClasses sync.RWMutex
)

// Ensure, that StorageClassesGetterMock does implement v11.StorageClassesGetter.
// If this is not the case, regenerate this file with moq.
var _ v11.StorageClassesGetter = &StorageClassesGetterMock{}

// StorageClassesGetterMock is a mock implementation of v11.StorageClassesGetter.
//
//     func TestSomethingThatUsesStorageClassesGetter(t *testing.T) {
//
//         // make and configure a mocked v11.StorageClassesGetter
//         mockedStorageClassesGetter := &StorageClassesGetterMock{
//             StorageClassesFunc: func(namespace string) v11.StorageClassInterface {
// 	               panic("mock out the StorageClasses method")
//             },
//         }
//
//         // use mockedStorageClassesGetter in code that requires v11.StorageClassesGetter
//         // and then make assertions.
//
//     }
type StorageClassesGetterMock struct {
	// StorageClassesFunc mocks the StorageClasses method.
	StorageClassesFunc func(namespace string) v11.StorageClassInterface

	// calls tracks calls to the methods.
	calls struct {
		// StorageClasses holds details about calls to the StorageClasses method.
		StorageClasses []struct {
			// Namespace is the namespace argument value.
			Namespace string
		}
	}
}

// StorageClasses calls StorageClassesFunc.
func (mock *StorageClassesGetterMock) StorageClasses(namespace string) v11.StorageClassInterface {
	if mock.StorageClassesFunc == nil {
		panic("StorageClassesGetterMock.StorageClassesFunc: method is nil but StorageClassesGetter.StorageClasses was just called")
	}
	callInfo := struct {
		Namespace string
	}{
		Namespace: namespace,
	}
	lockStorageClassesGetterMockStorageClasses.Lock()
	mock.calls.StorageClasses = append(mock.calls.StorageClasses, callInfo)
	lockStorageClassesGetterMockStorageClasses.Unlock()
	return mock.StorageClassesFunc(namespace)
}

// StorageClassesCalls gets all the calls that were made to StorageClasses.
// Check the length with:
//     len(mockedStorageClassesGetter.StorageClassesCalls())
func (mock *StorageClassesGetterMock) StorageClassesCalls() []struct {
	Namespace string
} {
	var calls []struct {
		Namespace string
	}
	lockStorageClassesGetterMockStorageClasses.RLock()
	calls = mock.calls.StorageClasses
	lockStorageClassesGetterMockStorageClasses.RUnlock()
	return calls
}
