package utils

const (
	PipelineNamespace              = "cattle-pipeline"
	PipelineNamespaceSuffix        = "-pipeline"
	JenkinsName                    = "jenkins"
	JenkinsAgentContainerName      = "jnlp"
	PipelineName                   = "pipeline"
	PipelineSecretName             = "pipeline-secret"
	PipelineAPIKeySecretName       = "pipeline-api-key"
	PipelineSecretUserKey          = "admin-user"
	PipelineSecretTokenKey         = "admin-token"
	PipelineSecretRegistryTokenKey = "registry-token"
	PipelineSecretAPITokenKey      = "API_TOKEN"
	PipelineSecretDefaultUser      = "admin"
	PipelineSecretDefaultToken     = "admin123"
	GitCaCertVolumeName            = "git-ca-crt"
	GitCaCertPath                  = "/home/jenkins/certs"
	RegistryName                   = "docker-registry"
	RegistryProxyName              = "registry-proxy"
	RegistryCrt                    = "client.cert"
	RegistryKey                    = "client.key"
	RegistryCACrt                  = "ca.crt"
	RegistryCAKey                  = "ca.key"
	RegistryCACrtSecretName        = "registry-ca-crt"
	RegistryCrtSecretName          = "registry-crt"
	RegistryCrtVolumeName          = "crt"
	RegistryAuthVolumeName         = "auth"
	RegistryAuthPath               = "/opt/auth/"
	RegistryCrtPath                = "/opt/crt/"
	RegistryMappingPath            = "/opt/mapping/"
	RegistryPortMappingKey         = "mappings"
	RegistryPortMappingFile        = "mappings.yaml"
	PublishSecretUserKey           = "username"
	PublishSecretPwKey             = "password"
	DockerCredentialName           = "pipeline-docker-registry"
	ProxyConfigMapName             = "proxy-mappings"
	MinioName                      = "minio"
	MinioBucketLocation            = "local"
	MinioLogBucket                 = "pipeline-logs"
	NetWorkPolicyName              = "pipeline-np"
	LabelKeyApp                    = "app"
	LabelKeyJenkins                = "jenkins"
	JenkinsMaster                  = "master"
	LabelKeyExecution              = "execution"
	DefaultRegistry                = "index.docker.io"
	LocalRegistry                  = "docker-registry"
	DefaultTag                     = "latest"
	JenkinsPort                    = 8080
	JenkinsJNLPPort                = 50000
	RegistryPort                   = 443
	MinioPort                      = 9000

	WebhookEventPush        = "push"
	WebhookEventPullRequest = "pull_request"
	WebhookEventTag         = "tag"

	TriggerTypeUser    = "user"
	TriggerTypeWebhook = "webhook"

	StateWaiting  = "Waiting"
	StateBuilding = "Building"
	StateSuccess  = "Success"
	StateFailed   = "Failed"
	StateSkipped  = "Skipped"
	StateAborted  = "Aborted"
	StateQueueing = "Queueing"
	StatePending  = "Pending"
	StateDenied   = "Denied"

	ConditionChanged = "Changed"

	PipelineFinishLabel    = "pipeline.project.cattle.io/finish"
	LocalRegistryPortLabel = "pipeline.project.cattle.io/local-registry-port"
	PipelineNamespaceLabel = "pipeline.project.cattle.io/pipeline-namespace"

	PipelineFileYml  = ".rancher-pipeline.yml"
	PipelineFileYaml = ".rancher-pipeline.yaml"

	EnvGitRepoName       = "CICD_GIT_REPO_NAME"
	EnvGitURL            = "CICD_GIT_URL"
	EnvGitCommit         = "CICD_GIT_COMMIT"
	EnvGitRef            = "CICD_GIT_REF"
	EnvGitBranch         = "CICD_GIT_BRANCH"
	EnvGitTag            = "CICD_GIT_TAG"
	EnvTriggerType       = "CICD_TRIGGER_TYPE"
	EnvEvent             = "CICD_EVENT"
	EnvExecutionID       = "CICD_EXECUTION_ID"
	EnvExecutionSequence = "CICD_EXECUTION_SEQUENCE"
	EnvPipelineID        = "CICD_PIPELINE_ID"
	EnvProjectID         = "CICD_PROJECT_ID"
	EnvClusterID         = "CICD_CLUSTER_ID"
	EnvRegistry          = "CICD_REGISTRY"
	EnvImageRepo         = "CICD_IMAGE_REPO"
	EnvLocalRegistry     = "CICD_LOCAL_REGISTRY"

	SettingExecutorQuota                = "executor-quota"
	SettingExecutorQuotaDefault         = "2"
	SettingSigningDuration              = "registry-signing-duration"
	SettingSigningDurationDefault       = "2160h"
	SettingGitCaCerts                   = "git-cacerts"
	SettingExecutorMemoryRequest        = "executor-memory-request"
	SettingExecutorMemoryRequestDefault = "10Mi"
	SettingExecutorMemoryLimit          = "executor-memory-limit"
	SettingExecutorMemoryLimitDefault   = "1Gi"
	SettingExecutorCPURequest           = "executor-cpu-request"
	SettingExecutorCPURequestDefault    = "10m"
	SettingExecutorCPULimit             = "executor-cpu-limit"
	SettingExecutorCPULimitDefault      = "1"

	PipelineToolsMemoryRequestDefault = "10Mi"
	PipelineToolsMemoryLimitDefault   = "100Mi"
	PipelineToolsCPURequestDefault    = "10m"
	PipelineToolsCPULimitDefault      = "300m"
	StepMemoryRequestDefault          = "10Mi"
	StepMemoryLimitDefault            = "1Gi"
	StepCPURequestDefault             = "10m"
	StepCPULimitDefault               = "1"

	DefaultTimeout = 60
)
