import curvejs from  '../../src/index.js'

const  { Stage, Curve, motion } = curvejs

let canvas = document.getElementById('myCanvas')
let stage = new Stage(canvas)

const rd = function() {
    return -2 + Math.random() * 2
}

var tencent =  [2,1,2,1,13,1,13,1,7,1,7,1,7,15,7,15,21,1,21,1,29,1,29,1,21,1,21,1,21,15,21,15,21,15,21,15,29,14,29,14,22,7,22,7,28,7,28,7,38,1,38,1,38,15,38,15,39,1,39,1,49,15,49,15,49,1,49,1,49,15,49,15,70,2,57,0,58,13,69,13,80,1,80,1,87,1,87,1,80,1,80,1,80,14,80,14,80,14,80,14,87,14,87,14,81,7,81,7,87,7,87,7,97,1,97,1,97,14,97,14,98,1,98,1,108,14,108,14,108,1,108,1,108,14,108,14,117,1,117,1,128,1,128,1,123,2,123,2,122,14,122,14]

   let web=[ 147, 1, 147, 1, 151, 14, 151, 14, 151, 14, 151, 14, 157, 1, 157, 1, 157, 1, 157, 1, 161, 14, 161, 14, 161, 14, 161, 14, 165, 1, 165, 1, 176, 1, 176, 1, 183, 1, 183, 1, 175, 1, 175, 1, 175, 14, 175, 14, 176, 14, 176, 14, 183, 14, 183, 14, 176, 7, 176, 7, 182, 7, 182, 7, 193, 1, 193, 1, 193, 14, 193, 14, 193, 1, 201, 0, 201, 6, 193, 7, 193, 7, 201, 7, 201, 14, 192, 14]

  let fe=[  223,1,223,1,230,1,230,1,223,1,223,1,222,15,222,15,223,8,223,8,230,9,230,9,240,1,240,1,240,15,240,15,240,1,250,1,249,8,240,8,244,8,244,8,249,15,249,15,264,1,254,1,253,13,264,14,264,1,273,1,273,14,264,14,281,1,281,1,281,15,281,15,281,1,281,1,291,14,291,14,291,14,291,14,291,1,291,1,302,1,302,1,311,1,311,1,307,2,307,2,306,15,306,15,319,9,319,9,325,9,325,9,335,1,335,1,335,14,335,14,335,14,335,14,343,14,343,14,336,7,336,7,342,7,342,7,335,1,335,1,343,1,343,1,352,1,352,1,352,14,352,14,353,1,353,1,362,14,362,14,362,14,362,14,363,1,363,1,375,1,375,1,375,14,375,14,375,1,387,0,388,14,375,14

]

let cf = [417,2,402,1,402,14,416,13,432,1,422,0,421,13,432,14,432,14,443,14,442,1,432,1,450,1,450,1,449,15,449,15,450,1,450,1,459,14,459,14,460,1,460,1,459,15,459,15,471,1,471,1,479,1,479,1,471,15,471,15,472,1,472,1,472,8,472,8,478,8,478,8,488,1,488,1,495,2,495,2,488,1,488,1,488,14,488,14,488,14,488,14,495,14,495,14,488,7,488,7,495,7,495,7,505,1,505,1,505,15,505,15,505,1,516,1,516,8,505,8,510,8,510,8,514,14,514,14,525,1,525,1,531,1,531,1,524,1,524,1,524,15,524,15,524,7,524,7,531,7,531,7,525,14,525,14,531,14,531,14,542,1,542,1,541,15,541,15,542,1,542,1,551,14,551,14,552,1,552,1,552,14,552,14,572,2,558,1,559,13,573,13,583,1,583,1,583,14,583,14,583,14,583,14,590,14,590,14,583,7,583,7,589,7,589,7,583,1,583,1,590,1,590,1]


function createCurve(arr,color){
    arr.forEach((item,index,self)=>{
        if(index%8===0){
            let curve = new Curve({
                x:10,y:100,
                color: color,
                points: [self[index],self[1+index],self[2+index],self[3+index],self[4+index],self[5+index],self[6+index],self[7+index]],
                data: [rd(), rd(), rd(), rd(), rd(), rd(), rd(), rd()],
                motion: motion.dance,
                data: {angle: 0, r:5 ,step:Math.PI / 100 }
            })

            stage.add(curve)
        }
    })
}


function tick(){
    stage.update()
    requestAnimationFrame(tick)
}

createCurve(tencent,'#00FF00')
createCurve(web,'#22CAB3')
createCurve(fe,'#FF7784')
createCurve(cf,'#D4B879')

tick()
