using System;
using System.Data;
using System.Configuration;
using System.Web;
using System.Web.Security;
using System.Web.UI;
using System.Web.UI.WebControls;
using System.Web.UI.WebControls.WebParts;
using System.Web.UI.HtmlControls;
using System.Data.SqlClient;
using System.Data.OleDb;
using System.Data.Common;
using System.Collections;
using Newtonsoft.Json;
using Newtonsoft.Json.Converters;
using System.Xml;


namespace com.sigmawidgets.sample
{
    /// <summary>
    /// Summary description for Order
    /// </summary>
    /// 
    public class OrderEntity{
        [JsonProperty("order_no")]
        public int orderNo;
        [JsonProperty("employee")]
        public string employee;
        [JsonProperty("country")]
        public string country;
        [JsonProperty("customer")]
        public string customer;
        [JsonProperty("order2005")]
        public float order2005;
        [JsonProperty("order2006")]
        public float order2006;
        [JsonProperty("order2007")]
        public float order2007;
        [JsonProperty("order2008")]
        public float order2008;
        [JsonProperty("delivery_date")]
        public string deliveryDate;

        public DateTime toDateTime() {
            DateTime ret;
            try
            {
                string[] strs = deliveryDate.Split(new string[] { "-" }, StringSplitOptions.None);
                ret = new DateTime(Convert.ToInt32(strs[0]), Convert.ToInt32(strs[1]), Convert.ToInt32(strs[2]));
            }
            catch {
                ret = new DateTime();
            }

            return ret;
        }

        public void fromDateTime(DateTime dt) {
            this.deliveryDate = dt.Year + "-" + dt.Month + "-" + dt.Day;
        }
    }

    public class OrderEntityWrapper: OrderEntity { 
        [JsonProperty("__gt_sn__")]
        public int gtSn;
        [JsonProperty("__gt_no_valid__")]
        public bool gtNoValidation;
        [JsonProperty("__gt_row_index__")]
        public int gtRowIndex;
           
           
    }

    public class Order
    {
        private const string connectionString = @"server=(local)\SQLExpress;AttachDbFileName=|DataDirectory|EmpOrders.mdf;Integrated Security=true;User Instance=true";
        private static string getSQL(int pageIndex, int recNo)
        {
            string columns = "order_no, employee, country, customer, order2005, order2006, order2007, order2008, delivery_date";
            string query = null;
            if (recNo == -1)
            {
                query = "select " + columns + " from orders order by order_no";
            }
            else
            {
                query = "SELECT " + columns + " FROM (";
                query += "SELECT ROW_NUMBER() OVER (ORDER BY order_no) AS RowNumber, " + columns + " FROM orders) AS tmp ";
                query += "WHERE RowNumber BETWEEN " + ((pageIndex - 1) * recNo + 1) + " AND " + pageIndex * recNo + " ORDER BY order_no";
            }
            return query;
        }

        
        private static SqlDataReader getOrderList(int pageIndex, int recNo) {
            string query = Order.getSQL(pageIndex, recNo);
            SqlConnection conn = new SqlConnection(connectionString);
            conn.Open();
            SqlDataReader dataReader = new SqlCommand(query, conn).ExecuteReader();
            return dataReader;
        }

        public static XmlDataDocument getOrderXml(int pageIndex, int recNo)
        {

            string query = Order.getSQL(pageIndex, recNo);
            SqlConnection conn = new SqlConnection(connectionString);
            

            //Create a DataAdapter to load data from original data source to the DataSet
            DataSet dataset = new DataSet("root");
            dataset.EnforceConstraints = false;
            SqlDataAdapter adapter = new SqlDataAdapter();
            adapter.SelectCommand = new SqlCommand(query, conn);
            conn.Open();
            adapter.Fill(dataset, "data");

            //Create a virtual XML document on top of the DataSet
            XmlDataDocument doc = new XmlDataDocument(dataset);

            return doc;
            
        }

        public static int getOrderCount()
        {
            string query = "select count(*) from orders";

            SqlConnection conn = new SqlConnection(connectionString);
            conn.Open();
            int ret = Convert.ToInt32((new SqlCommand(query, conn)).ExecuteScalar());
            return ret;

        }

        public static string[][] get2dArray(int pageIndex, int recNo){
            SqlDataReader dataReader = Order.getOrderList(pageIndex, recNo);
            ArrayList al = new ArrayList();
            if((dataReader!=null)&&(dataReader.HasRows)){
                    while (dataReader.Read())
                    {
                        string[] fields = new string[dataReader.FieldCount];
                        for (int i = 0; i < dataReader.FieldCount; ++i)
                            fields[i] = dataReader[i].ToString();
                        al.Add(fields);
                    }
                
            }
            dataReader.Close();
            string[][] arrReturn = (string[][])al.ToArray(typeof(string[]));
            return arrReturn;
        }

        public static OrderEntity[] getOrderArray(int pageIndex, int recNo) {
            SqlDataReader dataReader = Order.getOrderList(pageIndex, recNo);
            
            ArrayList al = new ArrayList();
            if ((dataReader != null) && (dataReader.HasRows))
            {
                while (dataReader.Read())
                {
                    OrderEntity eo = new OrderEntity();
                    eo.orderNo = dataReader.GetInt32(0);
                    eo.employee = dataReader.GetString(1);
                    eo.country = dataReader.GetString(2);
                    eo.customer = dataReader.GetString(3);
                    eo.order2005 = dataReader.GetFloat(4);
                    eo.order2006 = dataReader.GetFloat(5);
                    eo.order2007 = dataReader.GetFloat(6);
                    eo.order2008 = dataReader.GetFloat(7);
                    eo.fromDateTime(dataReader.GetDateTime(8));
                    al.Add(eo);
                }

            }
            dataReader.Close();
            OrderEntity[] arrReturn = (OrderEntity[])al.ToArray(typeof(OrderEntity));
            return arrReturn;
        }

        public static void DeleteOrders(OrderEntity[] oe) {
            SqlConnection conn = new SqlConnection(connectionString);
            string query = "delete from orders where order_no = @order_no";
            SqlCommand cmd = new SqlCommand(query, conn);
            SqlParameter pOrderNo = cmd.Parameters.Add("@order_no", SqlDbType.Int);
            
            try{
                conn.Open();
                for (int i = 0; i < oe.Length; i++)
                {
                    pOrderNo.Value = oe[i].orderNo;
                    cmd.ExecuteNonQuery();
                }
                
            }catch(Exception ex){
            
            }finally{
                conn.Close();
            }

        }

        public static void InsertOrders(OrderEntity[] oe)
        {
            SqlConnection conn = new SqlConnection(connectionString);
            string query = "insert into orders(employee,country,customer,order2005,order2006,order2007,order2008,delivery_date) ";
            query += "values(@employee,@country,@customer,@order2005,@order2006,@order2007,@order2008,@delivery_date)";
            SqlCommand cmd = new SqlCommand(query, conn);
            SqlParameter pEmployee = cmd.Parameters.Add("@employee", SqlDbType.VarChar, 31);
            SqlParameter pCountry = cmd.Parameters.Add("@country", SqlDbType.VarChar, 2);
            SqlParameter pCustomer = cmd.Parameters.Add("@customer", SqlDbType.VarChar, 31);
            SqlParameter pOrder2005 = cmd.Parameters.Add("@order2005", SqlDbType.Real);
            SqlParameter pOrder2006 = cmd.Parameters.Add("@order2006", SqlDbType.Real);
            SqlParameter pOrder2007 = cmd.Parameters.Add("@order2007", SqlDbType.Real);
            SqlParameter pOrder2008 = cmd.Parameters.Add("@order2008", SqlDbType.Real);
            SqlParameter pDeliveryDate = cmd.Parameters.Add("@delivery_date", SqlDbType.DateTime);

            try
            {
                conn.Open();
                for (int i = 0; i < oe.Length; i++)
                {
                    pEmployee.Value = oe[i].employee;
                    pCountry.Value = oe[i].country;
                    pCustomer.Value = oe[i].customer;
                    pOrder2005.Value = oe[i].order2005;
                    pOrder2006.Value = oe[i].order2006;
                    pOrder2007.Value = oe[i].order2007;
                    pOrder2008.Value = oe[i].order2008;
                    pDeliveryDate.Value = oe[i].toDateTime();
                    cmd.ExecuteNonQuery();
                }
            }
            catch (Exception ex)
            {

            }
            finally
            {
                conn.Close();
            }
        }

        public static void UpdateOrders(OrderEntity[] oe)
        {
            SqlConnection conn = new SqlConnection(connectionString);
            string query = "update orders set employee=@employee, country=@country, customer=@customer,";
            query += "order2005=@order2005, order2006=@order2006, order2007=@order2007, order2008=@order2008,";
            query += "delivery_date=@delivery_date where order_no = @order_no ";
            SqlCommand cmd = new SqlCommand(query, conn);
            SqlParameter pOrderNo = cmd.Parameters.Add("@order_no", SqlDbType.Int);
            SqlParameter pEmployee = cmd.Parameters.Add("@employee", SqlDbType.VarChar, 31);
            SqlParameter pCountry = cmd.Parameters.Add("@country", SqlDbType.VarChar, 2);
            SqlParameter pCustomer = cmd.Parameters.Add("@customer", SqlDbType.VarChar, 31);
            SqlParameter pOrder2005 = cmd.Parameters.Add("@order2005", SqlDbType.Real);
            SqlParameter pOrder2006 = cmd.Parameters.Add("@order2006", SqlDbType.Real);
            SqlParameter pOrder2007 = cmd.Parameters.Add("@order2007", SqlDbType.Real);
            SqlParameter pOrder2008 = cmd.Parameters.Add("@order2008", SqlDbType.Real);
            SqlParameter pDeliveryDate = cmd.Parameters.Add("@delivery_date", SqlDbType.DateTime);

            try
            {
                conn.Open();
                for (int i = 0; i < oe.Length; i++)
                {
                    pOrderNo.Value = oe[i].orderNo;
                    pEmployee.Value = oe[i].employee;
                    pCountry.Value = oe[i].country;
                    pCustomer.Value = oe[i].customer;
                    pOrder2005.Value = oe[i].order2005;
                    pOrder2006.Value = oe[i].order2006;
                    pOrder2007.Value = oe[i].order2007;
                    pOrder2008.Value = oe[i].order2008;
                    pDeliveryDate.Value = oe[i].toDateTime();
                    cmd.ExecuteNonQuery();
                }
            }
            catch (Exception ex)
            {

            }
            finally
            {
                conn.Close();
            }
        }
    }

}

