Imports System
Imports System.Data
Imports System.Configuration
Imports System.Web
Imports System.Web.Security
Imports System.Web.UI
Imports System.Web.UI.WebControls
Imports System.Web.UI.WebControls.WebParts
Imports System.Web.UI.HtmlControls
Imports System.Data.SqlClient
Imports System.Data.OleDb
Imports System.Data.Common
Imports System.Collections
Imports Newtonsoft.Json
Imports Newtonsoft.Json.Converters
Imports System.Xml
 
 
Namespace com.sigmawidgets.sample
    '/ <summary>
    '/ Summary description for Order
    '/ </summary>
    '/ 
    Public Class OrderEntity
        <JsonProperty("order_no")> _ 
        Public orderNo As Integer
        <JsonProperty("employee")> _ 
        Public employee As String
        <JsonProperty("country")> _ 
        Public counTry As String
        <JsonProperty("customer")> _ 
        Public customer As String
        <JsonProperty("order2005")> _ 
        Public order2005 As single
        <JsonProperty("order2006")> _ 
        Public order2006 As single
        <JsonProperty("order2007")> _ 
        Public order2007 As single
        <JsonProperty("order2008")> _ 
        Public order2008 As single
        <JsonProperty("delivery_date")> _ 
        Public deliveryDate As String
 
        Public Function toDateTime() As DateTime
            Dim ret As DateTime
            Try
                Dim strs As String() =  deliveryDate.Split(New String() {"-"}, StringSplitOptions.None)
                ret = New DateTime(Convert.ToInt32(strs(0)), Convert.ToInt32(strs(1)), Convert.ToInt32(strs(2)))
            Catch
                ret = New DateTime()
            End Try
 
            Return ret
        End Function
 
        Public  Sub fromDateTime(ByVal dt As DateTime)
            Me.deliveryDate = dt.Year.ToString() + "-" + dt.Month.ToString() + "-" + dt.Day.ToString()
        End Sub
    End Class
 
    Public Class OrderEntityWrapper
	 Inherits OrderEntity
        <JsonProperty("__gt_sn__")> _ 
        Public gtSn As Integer
        <JsonProperty("__gt_no_valid__")> _ 
        Public gtNoValidation As Boolean
        <JsonProperty("__gt_row_index__")> _ 
        Public gtRowIndex As Integer
 
 
    End Class
 
    Public Class Order
        Private Const connectionString As String = "server=(local)\SQLExpress;AttachDbFileName=|DataDirectory|EmpOrders.mdf;Integrated Security=true;User Instance=true"
        Private Shared Function getSQL(ByVal pageIndex As Integer, ByVal recNo As Integer) As String
            Dim columns As String =  "order_no, employee, country, customer, order2005, order2006, order2007, order2008, delivery_date" 
            Dim query As String =  Nothing 
            If recNo = -1 Then
                query = "select " + columns + " from orders order by order_no"
            Else 
                query = "SELECT " + columns + " FROM ("
                query += "SELECT ROW_NUMBER() OVER (ORDER BY order_no) AS RowNumber, " + columns + " FROM orders) AS tmp "
                query += "WHERE RowNumber BETWEEN " + ((pageIndex - 1) * recNo + 1).ToString() + " AND " + (pageIndex * recNo).ToString() + " ORDER BY order_no"
            End If
            Return query
        End Function
 
 
        Private Shared Function getOrderList(ByVal pageIndex As Integer, ByVal recNo As Integer) As SqlDataReader
            Dim query As String = Order.getSQL(pageIndex, recNo)
            Dim conn As SqlConnection = New SqlConnection(connectionString)
            conn.Open()
            Dim dataReader As SqlDataReader = New SqlCommand(query, conn).ExecuteReader()
            Return dataReader
        End Function

        Public Shared Function getOrderXml(ByVal pageIndex As Integer, ByVal recNo As Integer) As XmlDataDocument

            Dim query As String = Order.getSQL(pageIndex, recNo)
            Dim conn As SqlConnection = New SqlConnection(connectionString)


            'Create a DataAdapter to load data from original data source to the DataSet
            Dim dataset As DataSet = New DataSet("root")
            dataset.EnforceConstraints = False
            Dim adapter As SqlDataAdapter = New SqlDataAdapter()
            adapter.SelectCommand = New SqlCommand(query, conn)
            conn.Open()
            adapter.Fill(dataset, "data")

            'Create a virtual XML document on top of the DataSet
            Dim doc As XmlDataDocument = New XmlDataDocument(dataset)

            Return doc

        End Function

        Public Shared Function getOrderCount() As Integer
            Dim query As String = "select count(*) from orders"

            Dim conn As SqlConnection = New SqlConnection(connectionString)
            conn.Open()
            Dim ret As Integer = Convert.ToInt32((New SqlCommand(query, conn)).ExecuteScalar())
            Return ret

        End Function

        Public Shared Function get2dArray(ByVal pageIndex as Integer, ByVal recNo as Integer) as String()() 
            Dim dataReader As SqlDataReader = Order.getOrderList(pageIndex, recNo)
            Dim al As ArrayList = New ArrayList()
            If (dataReader IsNot Nothing) And (dataReader.HasRows) Then
                While dataReader.Read()
                    Dim fields() As String = New String(dataReader.FieldCount) {}
                    Dim i As Integer
                    For i = 0 To dataReader.FieldCount - 1 Step +1
                        fields(i) = dataReader(i).ToString()
                    Next
                    al.Add(fields)
                End While

            End If
            dataReader.Close()
            Dim arrReturn As String()() = CType(al.ToArray(GetType(String())), String()())
            Return arrReturn
        End Function

        Public Shared Function getOrderArray(ByVal pageIndex As Integer, ByVal recNo As Integer) As OrderEntity()

            Dim dataReader As SqlDataReader = Order.getOrderList(pageIndex, recNo)

            Dim al As ArrayList = New ArrayList()
            If (dataReader IsNot Nothing) And (dataReader.HasRows) Then
                While dataReader.Read()
                    Dim eo As OrderEntity = New OrderEntity()
                    eo.orderNo = dataReader.GetInt32(0)
                    eo.employee = dataReader.GetString(1)
                    eo.counTry = dataReader.GetString(2)
                    eo.customer = dataReader.GetString(3)
                    eo.order2005 = dataReader.GetFloat(4)
                    eo.order2006 = dataReader.GetFloat(5)
                    eo.order2007 = dataReader.GetFloat(6)
                    eo.order2008 = dataReader.GetFloat(7)
                    eo.fromDateTime(dataReader.GetDateTime(8))
                    al.Add(eo)
                End While

            End If
            dataReader.Close()
            Dim arrReturn() As OrderEntity = CType(al.ToArray(GetType(OrderEntity)), OrderEntity())
            Return arrReturn
        End Function

        Public Shared Function DeleteOrders(ByVal oe As OrderEntity())
            Dim conn As SqlConnection = New SqlConnection(connectionString)
            Dim query As String = "delete from orders where order_no = @order_no"
            Dim cmd As SqlCommand = New SqlCommand(query, conn)
            Dim pOrderNo As SqlParameter = cmd.Parameters.Add("@order_no", SqlDbType.Int)

            Try
                conn.Open()
                Dim i As Integer
                For i = 0 To oe.Length - 1 Step i + 1
                    pOrderNo.Value = oe(i).orderNo
                    cmd.ExecuteNonQuery()
                Next

            Catch ex As Exception

            Finally
                conn.Close()
            End Try

        End Function

        Public Shared Function InsertOrders(ByVal oe As OrderEntity())
            Dim conn As SqlConnection = New SqlConnection(connectionString)
            Dim query As String = "insert into orders(employee,country,customer,order2005,order2006,order2007,order2008,delivery_date) "
            query += "values(@employee,@country,@customer,@order2005,@order2006,@order2007,@order2008,@delivery_date)"
            Dim cmd As SqlCommand = New SqlCommand(query, conn)
            Dim pEmployee As SqlParameter = cmd.Parameters.Add("@employee", SqlDbType.VarChar, 31)
            Dim pCounTry As SqlParameter = cmd.Parameters.Add("@country", SqlDbType.VarChar, 2)
            Dim pCustomer As SqlParameter = cmd.Parameters.Add("@customer", SqlDbType.VarChar, 31)
            Dim pOrder2005 As SqlParameter = cmd.Parameters.Add("@order2005", SqlDbType.Real)
            Dim pOrder2006 As SqlParameter = cmd.Parameters.Add("@order2006", SqlDbType.Real)
            Dim pOrder2007 As SqlParameter = cmd.Parameters.Add("@order2007", SqlDbType.Real)
            Dim pOrder2008 As SqlParameter = cmd.Parameters.Add("@order2008", SqlDbType.Real)
            Dim pDeliveryDate As SqlParameter = cmd.Parameters.Add("@delivery_date", SqlDbType.DateTime)

            Try
                conn.Open()
                Dim i As Integer
                For i = 0 To oe.Length - 1 Step i + 1
                    pEmployee.Value = oe(i).employee
                    pCounTry.Value = oe(i).counTry
                    pCustomer.Value = oe(i).customer
                    pOrder2005.Value = oe(i).order2005
                    pOrder2006.Value = oe(i).order2006
                    pOrder2007.Value = oe(i).order2007
                    pOrder2008.Value = oe(i).order2008
                    pDeliveryDate.Value = oe(i).toDateTime()
                    cmd.ExecuteNonQuery()
                Next
            Catch ex As Exception

            Finally
                conn.Close()
            End Try
        End Function

        Public Shared Function UpdateOrders(ByVal oe As OrderEntity())
            Dim conn As SqlConnection = New SqlConnection(connectionString)
            Dim query As String = "update orders set employee=@employee, country=@country, customer=@customer,"
            query += "order2005=@order2005, order2006=@order2006, order2007=@order2007, order2008=@order2008,"
            query += "delivery_date=@delivery_date where order_no = @order_no "
            Dim cmd As SqlCommand = New SqlCommand(query, conn)
            Dim pOrderNo As SqlParameter = cmd.Parameters.Add("@order_no", SqlDbType.Int)
            Dim pEmployee As SqlParameter = cmd.Parameters.Add("@employee", SqlDbType.VarChar, 31)
            Dim pCounTry As SqlParameter = cmd.Parameters.Add("@country", SqlDbType.VarChar, 2)
            Dim pCustomer As SqlParameter = cmd.Parameters.Add("@customer", SqlDbType.VarChar, 31)
            Dim pOrder2005 As SqlParameter = cmd.Parameters.Add("@order2005", SqlDbType.Real)
            Dim pOrder2006 As SqlParameter = cmd.Parameters.Add("@order2006", SqlDbType.Real)
            Dim pOrder2007 As SqlParameter = cmd.Parameters.Add("@order2007", SqlDbType.Real)
            Dim pOrder2008 As SqlParameter = cmd.Parameters.Add("@order2008", SqlDbType.Real)
            Dim pDeliveryDate As SqlParameter = cmd.Parameters.Add("@delivery_date", SqlDbType.DateTime)

            Try
                conn.Open()
                Dim i As Integer
                For i = 0 To oe.Length - 1 Step i + 1
                    pOrderNo.Value = oe(i).orderNo
                    pEmployee.Value = oe(i).employee
                    pCounTry.Value = oe(i).counTry
                    pCustomer.Value = oe(i).customer
                    pOrder2005.Value = oe(i).order2005
                    pOrder2006.Value = oe(i).order2006
                    pOrder2007.Value = oe(i).order2007
                    pOrder2008.Value = oe(i).order2008
                    pDeliveryDate.Value = oe(i).toDateTime()
                    cmd.ExecuteNonQuery()
                Next
            Catch ex As Exception

            Finally
                conn.Close()
            End Try
        End Function
    End Class
 
End Namespace

