// JavaScript Document
figure = {
  // 换图
  'swap' : function() {
	clearTimeout(figure.restoreTimer);

	var next_id = $J(this).data('i'),          // 用户鼠标悬浮的图的id
		next = [],
		currents = $J('.figure-img.center');   // 所有当前显示的图

	for(var i = 0; i < currents.length; i++ ) {
	  var current = currents.eq(i),
		  // 判断当前显示的图应该从哪个方向离开
		  current_to_pos = next_id > current.data('i') ? 'bottom' : 'top',
		  // 下一张图从哪个方向进入
		  next_from_pos = current_to_pos == 'top' ? 'bottom' : 'top';

	  current.removeClass('center init').addClass(current_to_pos + ' toRemove');
	  // 插入下一张的DOM
	  next[i] = $J('<div>').addClass('figure-img ' + next_from_pos)
				.data('i', next_id)
				.css('background-image', 'url(' + $J(this).data('src') + ')')
				.insertAfter(current);
	}

	// 新DOM插入后要稍微等下再改变class，不然没有动画效果
	setTimeout(function() {
	  for(var i = 0; i < currents.length; i++)
		next[i].removeClass('top bottom').addClass('center');
	}, 10);

	// 移除老图DOM
	setTimeout(function() {
	  for(var i = 0; i < currents.length; i++)
		currents.eq(i).remove();
	}, 600);

	// 切换标题
	$J('.figure-title.active').removeClass('active');
	$J('#figure-title-' + next_id).addClass('active');
  },

  // 还原
  'restore' : function() {
	var containers = $J('.figure-img-container'),
		next = [];
	// 
	for(var i = 0; i < containers.length; i++) {
	  var self = containers.eq(i),
		  self_id = self.data('row'),
		  current = self.children('.center'),
		  current_id = current.data('i');
	  if( self_id == current_id ) {
		// 如果当前显示的图正好是默认图，只需要让它回到初始状态就可以了
		current.addClass('init');
		continue; 
	  } else {
		// 根据self_id来判断从哪个方向移走
		current.removeClass('center').addClass( (self_id > current_id ? 'bottom' : 'top') + ' toRemove' );
		// 创建默认图
		next[i] = $J('<div>').addClass('figure-img ' + (self_id > current_id ? 'top' : 'bottom'))
			.data('i', self_id)
			.css('background-image', 'url(' + $J('.figure[data-i=' + self_id + ']').data('src') + ')')
			.appendTo(self);
	  }
	}

	setTimeout(function() {
	  for(var i = 0; i < containers.length; i++)
		if( next[i] )
		  next[i].removeClass('top bottom').addClass('center init');
	}, 10);

	// 清除所有标记为toRemove的图
	// 为了防止用户鼠标快速移出.in-stock-figure又快速移入造成第二次移入时
	// 新标记为toRemove的图片也被移除的情况，在这里加个计时器，当用户鼠标
	// 移入.in-stock-figure时取消这个计时器
	figure.restoreTimer = setTimeout(function() {
	  $J('.in-stock-figure .toRemove').remove();
	}, 600);

	// 清除所有标题
	$J('.figure-title.active').removeClass('active');
  },

  // 绑定事件
  'init' : function() {
	$J('.in-stock-figure').on('mouseenter', 'a[data-i]', figure.swap)
						 .on('mouseleave', figure.restore);

	// 生成默认图
	var containers = $J('.figure-img-container');
	for(var i = 0; i < containers.length; i++) {
	  $J('<div>').addClass('figure-img center init')
				.data('i', i)
				.css('background-image', 'url(' + $J('.figure[data-i=' + (i+1) + ']').data('src') + ')')
				.appendTo(containers.eq(i));
	}

	// 生成图片标题
	var fi = $J('.in-stock-figure .figure[data-title]'),
		fb1 = $J('.figure-block-1');
	for(var i = 0; i < fi.length ; i++) {
	  $J('<p>').attr('id', 'figure-title-' + (i+1) )
			  .addClass('figure-title')
			  .text(fi.eq(i).data('title'))
			  .appendTo(fb1);
	}
  }
}
$J(document).ready(function(){
  figure.init();
});