

/* #C path:fly.simple 
Version 1.0 alpha
http://www.flyui.net
Email:flyui@hotmail.com
Copyright (c) 2009 KuiyouLi
2010-12-25
*/
window.fly || (window.fly = {});
fly.simple || (fly.simple = {});

/*	չ,չǰǷ
@target	:չĶ
@overrides:չԱ
@return	:target
*/
fly.simple.extendIf = (fly.simple.extendIf || function (target, overrides) {
    for (var i = 1; i < arguments.length; i++) {
        var a = arguments[i]
        for (var k in a)
            target[k] || (target[k] = a[k])
    }
    return target;
});

var __isIE6 = navigator.userAgent.toLowerCase().indexOf("msie 6") > -1
fly.simple.extendIf(fly.simple, {
    /*	path:fly.simple.$
    ͨidȡdom
    @id	:String/Dom domid
    @return	:Dom Dom
    */
    $: function (id) {
        return id && id.constructor == String ? document.getElementById(id) : id;
    },

    /*	չ
    @target	:չĶ
    @overrides:չԱ
    @return :target
    */
    extend: function (target, overrides) {
        for (var i = 1; i < arguments.length; i++) {
            var a = arguments[i]
            for (var k in a) target[k] = a[k]
        }
        return target;
    },
    tempDiv: document.createElement("div"),
    /* String ͼƬַ */
    emptyImg: __isIE6 ? "http://www.sencha.com/s.gif" : "data:image/gif;base64,R0lGODlhAQABAID/AMDAwAAAACH5BAEAAAAALAAAAAABAAEAAAICRAEAOw==",
    /* Boolean ǷIE6 */
    isIE6: __isIE6,
    /* Ƿ
    @obj	:ҪĶ
    @return :Boolean 
    */
    isArray: function (obj) {
        return obj instanceof Array
    },
    /* Ƿַ
    @obj	:ҪĶ
    @return :Boolean 
    */
    isStr: function (obj) {
        return obj instanceof String || typeof obj == "string"
    },
    /* ǷǺ
    @obj	:ҪĶ
    @return :Boolean 
    */
    isFun: function (obj) {
        return obj instanceof Function || typeof obj == "function"
    },
    /* Ǻ򷵻ִкķֵ򷵻ض
    @obj	:ҪĶ
    @return :Boolean 
    */
    ifFun: function (obj) {
        return this.isFun(obj) ? obj.apply(this, Array.prototype.slice.call(arguments, 1)) : obj;
    },
    /* һfalseĺ
    @return :Boolean 
    */
    falseFun: function () { return false; },
    /* ִAjaxķfly.simpleṩִAjaxʵָ÷
    @option : ִAjaxѡ
    */
    ajax: window.$ ? window.$.ajax : null,
    /*#C path:fly.simple.ajaxOption
    Ajaxѡ
    @option :Object/String/Function ִAjaxѡAjaxurlȡѡĺ
    @callback:Function AjaxĻص
    @sender :optionûurlʽĲ
    */
    ajaxOption: function (option, callback, sender) {
        var me = this
        option = fly.simple.ifFun(option, sender);
        if (option && option.constructor == String)
            this.url = option
        else
            fly.simple.extend(this, option);

        /*Ajax url*/
        this.url = fly.simple.ifFun(this.url, sender || this);

        if (this.url && this.url.constructor == String)
            this.url = fly.simple.format(this.url, sender);

        var cb = this.callback;
        var hd = 0;
        /*  #M Ajax url
        @result :String Ajaxķֵ
        */
        this.callback = this.success = this.error = this.failure = function (result) {
            if (hd)
                return;
            hd = 1;
            cb && cb.apply(this, arguments)
            callback && callback.apply(this, arguments)
        };
    },
    /* #C path:fly.simple */

    /* 
    ʽ
    ʾ
    var str=fly.simple.format("a{0}c{1}","b","d")
    ý str ڡabcd

    var obj={f1:1,f2:2}
    var str=fly.simple.format("{f1}+{f2}={0}",3,obj)
    ý str ڡ1+2=3

    @data   :String ҪʽĶĿǰַ֧
    @objs   :Object ɱ
    @return :String ʽõַ
    */
    format: function (data, objs) {
        switch (typeof (data)) {
            case "string":
                {
                    var args = arguments;
                    var o = arguments[arguments.length - 1] || this;
                    return data.replace(/\{([^\}]{1,50})\}/g, function (m, n) {
                        var v;
                        if (/^\d+$/.test(n))
                            v = args[parseInt(n) + 1]
                        else
                            v = o[n]
                        return v == null ? "" : v;
                    });
                }
        }
    },
    //    load: function (byAjax, callback, data) {
    //        byAjax ? fly.simple.ajax(new fly.simple.ajaxOption(data, callback)) : callback(data)
    //    },

    /* domָλ
    @parent :Dom dom
    @ref    :Dom/null λòο
    @dom    :Dom ҪĶ
    @where  :String beforeBeginafterEndbeforeEndafterBegin Ҫλ
    */
    insertElement: function (parent, ref, dom, where) {
        if (ref) {
            ref.insertAdjacentElement(where, dom);
        }
        else {
            parent.appendChild(dom);
        }
    },
    /* domָǰ
    @parent :Dom dom
    @ref    :Dom/null λòο
    @dom    :Dom ҪĶ
    */
    insertBefore: function (parent, ref, dom) {
        this.insertElement(parent, ref, dom, "beforeBegin")
    },
    /* domָ
    @parent :Dom dom
    @ref    :Dom/null λòο
    @dom    :Dom ҪĶ
    */
    insertAfter: function (parent, ref, dom) {
        this.insertElement(parent, ref, dom, "afterEnd")
    },
    //    fire: function (obj, e) {
    //        return obj[e] == null || obj[e].apply(obj, Array.prototype.slice.call(arguments, 2));
    //    },

    /* Ϊdom¼
    @dom    :Dom Ҫ¼Ķ
    @e      :String Ҫ󶨵¼
    @fn     :Function Ϊ¼󶨵Ļص
    */
    attachEvent: function (dom, e, fn) {
        function f(evt) {
            evt = window.event || evt;
            if (fn.call(dom, evt, dom) === false) {
                evt.cancelBubble = true
                evt.stopPropagation && evt.stopPropagation()
                evt.preventDefault && evt.preventDefault()

            }
        }
        dom.attachEvent ? dom.attachEvent("on" + e, f) : dom.addEventListener(e, f, false);
    },
    /* ΪԱ¼
    ʾ
            
    var obj={body:document.body,form:document.forms[0]};
    function callback()
    {
    alert('ص')
    }

    fly.simple.bindEvents(obj,{body:"click",form:"keydown"},callback);
    ϴΪdocument.bodyclick¼Ϊһform keydown¼

    @obj    : domԱĶ
    @events :KeyValue keyԱƣvalueΪԱ󶨵¼
    @fn     :Function Ϊ¼󶨵Ļص
    */
    bindEvents: function (obj, events, fn) {
        for (var k in events)
            obj[k] && this.attachEvent(obj[k], events[k], fn)
    },
    /* ΪaǩIE6¼
    @a    :Dom aǩ
    */
    ie6aHover: function (a) {
        if (a) {
            a.href = "javascript:";
            a.onclick = this.falseFun
        }
    },

    /* ıCSSʽ
    ʾ
    var cls=fly.simple.changeCss(document.body,"css-blue css-red","css-yellow")
     document.body Ƴ css-blue  css-red ʽ׷ css-yellow ʽ
        
    var oldCls="css-gray css-blue css-red"
    var cls=fly.simple.changeCss(oldCls,"css-blue css-red","css-yellow")
     oldCls Ƴ css-blue  css-red ʽ׷ css-yellow ʽ
    ý cls ڡcss-gray css-yellow

    ע⣺
    ÷ִƳ׷ӣͬһʽͬʱ removeCss  addCss ʱʽձ׷ӣ磺
    var oldCls="css-gray a b"
    var cls=fly.simple.changeCss(oldCls,"a b","b")
     oldCls Ƴ a  b ʽ׷ b ʽ
    ý cls  css-gray b

    @dom    :Dom/String Ҫıʽdomַ
    @removeCss  :String ҪƳʽ,ʽÿո
    @addCss :String Ҫ׷ӵʽ,ʽÿո
    @return :String ıʽ
    */
    changeCss: function (dom, removeCss, addCss) {
        var isStr = typeof (dom) == "string"
        var old = isStr ? dom : dom.className;
        var c = removeCss ? this.removeCss(old, removeCss) : old;
        c = addCss ? this.addCss(c, addCss) : c;
        !isStr && c != old && (dom.className = c)
        return c;
    },
    /* ׷CSSʽ
    @dom    :Dom/String Ҫ׷ʽdomַ
    @css  :String Ҫ׷ӵʽ,ʽÿո
    @return :String ׷Ӻʽ
    */
    addCss: function (dom, css) {
        var isStr = typeof (dom) == "string"
        var old = (isStr ? dom : dom.className).replace(/^ +| +$/g, "");
        if (old == "") {
            isStr || (dom.className = css)
            return css
        }

        var c = " " + old + " ";
        css.replace(/\S+/g, function (o) {
            if (c.indexOf(' ' + o + ' ') < 0)
                c += " " + o;
        });
        c = c.replace(/ +/g, " ").replace(/^ +| +$/g, "");
        !isStr && c != old && (dom.className = c)
        return c;
    },
    /* ƳCSSʽ
    @dom    :Dom/String ҪƳʽdomַ
    @css  :String ҪƳʽ,ʽÿո
    @return :String Ƴʽ
    */
    removeCss: function (dom, css) {
        var isStr = typeof (dom) == "string"
        var old = (isStr ? dom : dom.className).replace(/^ +| +$/g, "");
        if (old == "") return "";

        var c = " " + old.replace(/\s/g, '  ') + " ";
        css.replace(/\S+/g, function (o) {
            c = c.replace(new RegExp("\\s" + o + "\\s", "g"), " ");
        });
        c = c.replace(/ +/g, " ").replace(/^ +| +$/g, "");
        !isStr && c != old && (dom.className = c)
        return c;
    },
    /* Ƴdom
    @dom    :Dom ҪƳdom
    */
    remove: function (dom) {
        this.tempDiv.appendChild(dom);
        this.tempDiv.innerHTML = "";
    },
    /* ı亯 this ֵ
    @fn     :Function ıĺ
    @scope  :thisֵ
    @return :õĺ
    */
    scope: function (fn, scope) {
        return function () { return fn.apply(scope, arguments); }
    },
    /* һ̳
    @sun    :Class 
    @base   :Class/Object 
    @extand :KeyValue(ѡ) ͬʱչ³Ա
    */
    inherit: function (sun, base, extand) {
        var bp = base.prototype || base
        function f() { };
        f.prototype = bp;

        sun.prototype = new f();
        sun.prototype.base = new f();

        sun.baseType = base instanceof Function ? base : f;
        base instanceof Function && this.extendIf(sun, base);
        sun.prototype.constructor = sun
        extand && this.extend(sun.prototype, extand);
    },
    /* 
    @arr    :Array/KeyValue ֵ
    @fn     :Function ÿһĺ false ֹͣ
    @return :Object/undefined ;ֹͣ򷵻ص±ֹͣûзֵ
    */
    each: function (arr, fn) {
        var isFn = this.isFun(fn);
        if (this.isArray(arr)) {
            for (var i = 0; i < arr.length; i++) {
                var n = arr[i];
                if ((isFn ? fn(n) : n[fn](n)) === false) return n;
            }
        }
        else {
            for (var i in arr) {
                var n = arr[i];
                if ((isFn ? fn(n) : n[fn](n)) === false) return n;
            }
        }
    },
    _eachAll: function (item, children, fn, level, curr) {
        if (curr > level) return;
        if ((this.isFun(fn) ? fn(item, curr) : item[fn](item, curr)) === false) {
            fly.simple.__eachAllStop = item;
            return false;
        }
        curr++;
        if (curr > level) return;
        var ns = this.isFun(children) ? children(item) : item[children]
        if (ns instanceof Array)
            for (var i = 0; i < ns.length; i++)
                if (this._eachAll(ns[i], children, fn, level, curr) === false) return false;
    },
    /* ͨνṹ
    @items  :Array/Object 򵥸ڵ
    @children:String/Function ȡӽڵ㺯ָӼڵ
    @fn     :Function ÿһĺ false ֹͣ
    @level  :Int(ѡ) ĲΣ
    @return :Object/undefined ;ֹͣ򷵻ص±ֹͣĽڵ㣬ûзֵ
    */
    eachAll: function (items, children, fn, level) {
        if (level === false || level < 1) return;
        level === true && (level = 1000000)
        var me = this;
        if (this.isArray(items) ? this.each(items, function (item) {
            return me._eachAll(item, children, fn, level, 1)
        }) : this._eachAll(items, children, fn, level, 1) === false)
            return fly.simple.__eachAllStop;
    },
    /* ͨνṹ
    @items  :Array/Object ҵ򵥸ڵ
    @children:String/Function ȡӽڵ㺯ָӼڵ
    @filter :Function/Object жÿһǷҪĺֵ false ֹͣ
    @level  :Int(ѡ) ĲΣ
    @take   :Int(ѡ) ȡĽڵ
    @return :Array ҵĽڵ
    */
    queryAll: function (items, children, filter, level, take) {
        var list = []
        var fn = filter;
        if (take == null || take > -1000000 == false)
            take = 1000000000;
        var isFn = this.isFun(fn);
        filter = function (i, l) {
            if (take > list.length) {
                if (isFn ? fn(i, l) : fn) list.push(i);
            }
            else
                return false;
        }
        this.eachAll.apply(this, arguments)
        return list;
    },

    /* νṹнڵϼڵ
    @item   :ǰڵ
    @fn     :Function ڵĺ false ֹͣ
    @level  :Int(ѡ) ĲΣ
    @parent :String/Function(ѡ) ȡϼڵ㺯ָϼڵ,Ĭϡparentԡ
    @return :Object/undefined ;ֹͣ򷵻ص±ֹͣĽڵ㣬ûзֵ
    */
    eachParent: function (item, fn, level, parent) {
        level === true || level == null && (level = 1000000)
        var l = 1;
        var isFn = this.isFun(fn);
        arguments.length < 4 && (parent = "parent")
        var pIsFun = this.isFun(parent);
        while (l <= level && (item = (pIsFun?parent(item):item[parent]))) {
            if ((isFn ? fn(item, l) : item[fn](item, l)) === false)
                return item;
            l++;
        }
    },
    /* Ԫеλ
    @obj    :Ԫ
    @arr    :Array 飬ڸв
    @return :Int ҵ򷵻Ԫд0ʼ򷵻 -1
    */
    indexOf: function (obj, arr) {
        for (var i = 0; i < arr.length; i++)
            if (arr[i] == obj) return i;
        return -1;
    },

    /* #C path:fly.simple.selectionMode
        Ԫѡģʽ
    */
    /* path:fly.simple.selectionMode.none String ֹѡ*/
    /* path:fly.simple.selectionMode.multi String ѡ*/
    /* path:fly.simple.selectionMode.single String ѡ*/
    /* path:fly.simple.selectionMode.singleByLevel String ͬһڵѡ*/
    selectionMode: { none: "none", multi: "multi", single: "single", singleByLevel: "singleByLevel" },

    checkModeStyle: { multi: "check", single: "radio", singleByLevel: "radio" },

    /* #C path:fly.simple.checkStyle
    ԪCheckboxʽ
    */
    /* path:fly.simple.checkStyle.auto String Զ*/
    /* path:fly.simple.checkStyle.check String ѡ*/
    /* path:fly.simple.checkStyle.radio String ѡ*/
    checkStyle: { auto: "auto", check: "check", radio: "radio" }
});

/* #C path:fly.simple.checkMode
ԪCheckboxѡģʽ
*/
/* path:fly.simple.checkMode.none String ֹѡ*/
/* path:fly.simple.checkMode.multi String ѡ*/
/* path:fly.simple.checkMode.single String ѡ*/
/* path:fly.simple.checkMode.singleByLevel String ͬһڵѡ*/
fly.simple.checkMode = fly.simple.selectionMode


/* #C path:fly.simple.BaseItem
    ڵ
*/
fly.simple.BaseItem = function () {
    var simple = fly.simple;
    var BaseItem = function (config) {
        typeof (config) == "string" && (config = { text: config })
        simple.extend(this, config);
        this.items = [];
        var children = config && config.items || config.children;
        if (children && children.length) {
            this.leaf = false
            this.load(children)
        }

    }
    var pItem = {
        /* fly.simple.BaseList ڵ List ؼ*/
        owner: BaseItem.prototype,
        /* Boolean ڵǷڵ*/
        isRoot: false,
        /* Boolean ڵǷҶڵ*/
        leaf: true,
        /* Boolean ڵǷѡ*/
        selected: false,
        /* Function ڵ㵥ʱĴ*/
        handler: null,
        /* Boolean ڵdomǷѴ*/
        domCreated: false,
        /* ӽڵ
        @data :Array/String ͨAjaxurl
        */
        load: function (data) {
            if (!data) return false;
            var me = this
            function h(data) {
                me.items.push.apply(me.items, data);
                me.syncNodes();
                me.checkLeaf(me.items.length == 0)
            }
            simple.isArray(data) ? h(data) : this.owner.requestData(this, h)
        },
        /* Array ӽڵ*/
        items: Array.prototype,
        /* ӽڵ
        @items  :Ҫӵڵ
        */
        add: function (items) {
            this.insert.apply(this, [-1].concat(arguments));
        },
        /* ӽڵ㵽ָλ
        @index  :ӽڵλ
        @items  :Ҫڵ
        */
        insert: function (index, items) {
            this.items.splice.apply(this.items, [index < 0 ? this.items.length : Math.min(index, this.items.length), 0].concat(items))
            this.syncNodes();
            this.checkLeaf(this.items.length == 0)
        },
        /* ӽڵ*/
        createPad: function () {
            if (!this.pad || this.pad.parentNode != this.wrap) {
                this.pad || (this.pad = this.owner.createPad(this))
                this.wrap.appendChild(this.pad);
            }
        },
        syncNodes: function () {
            if (this.items.length) {
                for (var i = 0; i < this.items.length; i++) {
                    var n = this.items[i];
                    n instanceof this.constructor || (n = this.items[i] = new this.constructor(n));
                    n.parent = this;
                    this.owner.join && this.owner.join(n);
                }

                if (this.isRoot && this.owner.rootVisible == false)
                    this.eachItems(function (item) {
                        item.parent = null;
                    });

                if (this.domCreated) {
                    this.createPad();

                    for (var i = 0; i < this.items.length; i++)
                        this.items[i].renderTo(this.owner, this.pad, i);

                    if (this.firstNode != this.items[0]) {
                        this.firstNode && simple.removeCss(this.wrap, this.owner.firstNodeCss)
                        this.firstNode = this.items[0]
                        simple.addCss(this.firstNode.wrap, this.owner.firstNodeCss)
                    }

                    if (this.lastNode != this.items[this.items.length - 1]) {
                        this.lastNode && simple.removeCss(this.wrap, this.owner.lastNodeCss)
                        this.lastNode = this.items[this.items.length - 1]
                        simple.addCss(this.lastNode.wrap, this.owner.lastNodeCss)
                    }
                }
            }
            else {
                this.firstNode = this.lastNode = null;
            }
        },
        checkLeaf: function (leaf) {
            leaf = leaf == null ? this.leaf : !!leaf
            if (leaf == this.leaf) return;
            this.leaf = leaf;
            if (this.panel) {
                var pc = this.owner.parentNodeCss, lc = this.owner.leafNodeCss
                this.panel.className = simple.removeCss(this.panel.className, leaf ? pc : lc) + " " + (leaf ? lc : pc)
            }
        },
        parseIcon: function () {
            var o = this.owner;
            if (this.icon) {
                if (o.iconFormat)
                    this.icon = simple.format(o.iconFormat, this.icon, this)
            }
            else if (this.iconCss) {
                this.icon = simple.emptyImg
                this._iconCss = o.iconSizeCss
            }
        },
        checkPosition: function (container, index) {
            if (container.childNodes[index] == this.wrap || container == this.wrap) return true;
            simple.insertBefore(container, container[index], this.wrap);
        },
        markDom: function () {
            var me = this;
            var owner = me.owner;
            var all = this.panel.all || this.panel.getElementsByTagName("*");
            for (var i = 0; i < all.length; i++)
                all[i].name && (this[all[i].name] = all[i])

            if (this.iconDom && !this.icon && !this.iconCss)
                simple.remove(this.iconDom);

            if (this.href)
                this.textDom.target = this.target || owner.navTarget
            else
                this.textDom.removeAttribute("href");

            this.collapsed ? this.collapse() : this.expand();

            if (this.checkDom && this.checked)
                this.check(this.checked, false);

            if (this.isRoot) {
                owner.style && (this.wrap.style.cssText += ";" + owner.style);
                var wrapCss = this.wrap.className + " " + (owner.css || '')

                owner.checkMode != simple.checkMode.none && (wrapCss += " " + owner.checkStylePart + owner.checkStyle)
                owner.showToggle && (wrapCss += " " + owner.toggleStyleCssPart + owner.toggleStyle)
                owner.showLine && (wrapCss += " " + owner.lineCss)
                this.wrap.className = wrapCss

                this.createPad();

                this.pad.className += " " + owner.padCss + "-root" + (owner.rootVisible ? "" : " " + owner.padCss + "-root-hide")

                if (!owner.rootVisible)
                    this.panel.parentNode.removeChild(this.panel)
                else
                    this.panel.className += " " + owner.nodeCss + "-root";

                if (owner.useEffect)
                    setTimeout(function () {
                        me.wrap.className += " " + me.owner.effectCss;
                        setTimeout(function () {
                            me.owner.applyEffect()
                        }, 10)
                    });
            }
        },

        /* ֽڵ
        @owner  :fly.simple.BaseList ڵؼ
        @container:Dom ڵֵ
        @index  :Int λ
        */
        renderTo: function (owner, container, index) {
            owner.join(this);
            if (!this.domCreated) {
                if (owner.onBeforeRender && owner.onBeforeRender(this) == false) return false;
                this.parseIcon();
                this.wrap = owner.createWrap(this)
                this.panel || (this.panel = owner.createPanel(this));
                this.wrap.appendChild(this.panel);
                this.markDom()
                this.bindEvents()
                this.domCreated = true;
                this.syncNodes();
            }
            this.checkPosition(container, index);
        },
        /* Boolean Ƿ۵ */
        collapsed: true,
        /* #M ֽڵ */
        toggle: function () {
            if (this.owner.onToggle && this.owner.onToggle(this) === false) return false;
            document.selection && document.selection.empty()
            this.collapsed ? this.expand() : this.collapse();
            this.onToggled && this.onToggled(this);
            if(arguments.length)return false
        },
        /* ۵нڵ
        @ids    :Array ڵڵid
        @return :Boolean ȫ۵ true,򷵻 false
        */
        collapseAll: function (ids) {
            var same = true;
            this.eachAll(function (n) {
                n.collapse();
                n.collapsed || (same = false)
            }, ids == null ? true : ids);
            return same;
        },
        /* #M ۵ڵ */
        collapse: function () {
            if (this.owner.onCollapse && this.owner.onCollapse(this) === false) return false;
            var css = simple.changeCss(this.wrap.className, this.owner.expandCss, this.owner.collapseCss)
            if (this.wrap.className != css) {
                this.items.length && this.owner.applyEffect();
                this.wrap.className = css
            }
            this.collapsed = true;
            this.owner.onCollapsed && this.owner.onCollapsed(this);
        },
        /* չнڵ
        @ids    :Array ڵڵid
        @return :Boolean ȫչ true,򷵻 false
        */
        expandAll: function (ids) {
            var same = true;
            this.eachAll(function (n) {
                n.expand();
                n.collapsed && (same = false)
            }, ids == null ? true : ids);
            return same
        },
        /* #M չڵ */
        expand: function () {
            if (this.owner.onExpand && this.owner.onExpand(this) === false) return false;
            var css = simple.changeCss(this.wrap.className, this.owner.collapseCss, this.owner.expandCss)
            if (this.wrap.className != css) {
                this.items.length && this.owner.applyEffect();
                this.wrap.className = css
            }
            this.collapsed = false;
            if (!this.items.length && !this.leaf) {
                this.owner.requestData(this, this.load);
            }
            this.owner.onExpanded && this.owner.onExpanded(this);
        },
        /* ȡѡڵ 
        @selected   :Boolean ѡ״̬,trueȡѡнڵ,falseȡδѡнڵ
        @take       :Int(ѡ) ȡĽڵ,Ĭ
        @level      :Int(ѡ) Ĳ,Ĭ
        @includeSelf:Boolean(ѡ) ǰڵ,Ĭϲ
        @return     :Array  Ľڵ
        */
        getSelectItems: function (selected, take, level,includeSelf) {
            return simple.queryAll(includeSelf?this:this.items, "items", function (i) {
                return i.selected==selected
            },level,take)
        },
        /* ѡڵ 
        @selected   :Boolean ѡ״̬
        @allow      :Int(ѡ) ȡĽڵ,Ĭ
        @return     :Boolean/Null δִѡ񷵻 false, 򲻷ֵ
        */
        select: function (selected, allow) {
            var isToggle = typeof (selected) == "object"
            var owner = this.owner;
            selected = isToggle ? !this.selected : !!selected
            if (owner.selectionMode == simple.selectionMode.none) return false;
            if (owner.onSelect && owner.onSelect(this, selected) === false) return false;

            if (selected == false && allow !== true && owner.leastSelectionOne) {
                if (owner.selectionMode == simple.selectionMode.multi) {
                    var ns = owner.selectedNodes;
                    if (ns == null || ns.length == 0 || (ns.length == 1 && ns[0] == this))
                        return false
                }
                else
                    return false;
            }

            if (isToggle)
                owner.applyEffect();

            if (selected) {
                if (owner.selectionMode == simple.selectionMode.single)
                    owner.currentNode && owner.currentNode != this && owner.currentNode.select(false, true)
                else if (owner.selectionMode == simple.selectionMode.singleByLevel)
                    this.parent && this.parent.currentNode && this.parent.currentNode != this && this.parent.currentNode.select(false, true)
                simple.addCss(this.panel, owner.selectedCss);
                owner.currentNode = this
                this.parent && (this.parent.currentNode = this)
                simple.indexOf(this, owner.selectedNodes) < 0 && owner.selectedNodes.push(this)
            }
            else {
                simple.removeCss(this.panel, owner.selectedCss);
                this.parent && this.parent.currentNode == this && (this.parent.currentNode = null)
                owner.currentNode == this && (owner.currentNode = null)
                var i = simple.indexOf(this, owner.selectedNodes);
                i > -1 && owner.selectedNodes.splice(i, 1)
            }

            this.selected = selected;
            if (owner.keepCheckAndSelectSync && ((this.checked == true) != selected))
                this.check(selected, true)

            owner.onSelected && owner.onSelected(this);
        },
        /* #M ¼ */
        bindEvents: function () {
            var owner = this.owner
            simple.bindEvents(this, owner.toggleEvents, simple.scope(this.toggle, this))
            owner.selectionMode == simple.selectionMode.none || simple.bindEvents(this, owner.selectEvents, simple.scope(this.select, this))

            var h = this.handler || this.owner.nodeHandler
            h && simple.attachEvent(this.textDom, owner.handlerEvent, simple.scope(h, this));

            if (simple.isIE6)
                simple.ie6aHover(this.toggleDom)
        },
        /*  
        @fn   :Function ĺ
        @ids  :Array(ѡ) Ĭнڵ
        @level:Int(ѡ) Ĭ
        @return :Object/undefined ;ֹͣ򷵻ص±ֹͣĽڵ㣬ûзֵ
        */
        eachAll: function (fn, ids,level) {
            ids == null && (ids = false)
            if (ids === true || ids === false)
                return this.owner.eachAll(ids ? this : this.items, fn,level);

            ids instanceof Array || (ids = ids.split(','))
            return this.eachAll(function (n) {
                for (var i = 0; i < ids.length; i++)
                    if (ids[i] === n || n.id === ids[i])
                        return fn(n)
            });
        },
        /* ӽڵ,ӽڵ¼ڵ
        @fn   :Function ĺ
        @ids  :Array(ѡ) Ĭнڵ
        @return :Object/undefined ;ֹͣ򷵻ص±ֹͣĽڵ㣬ûзֵ
        */
        eachItems: function (fn) {
            return simple.each(this.items, fn);
        },
        /* Ƿ */
        hidden: false,
        /* #M ؽڵ */
        hide: function () {
            this.hidden = true;
            this.wrap.style.display = "none"
        },
        /* #M ʾڵ */
        show: function () {
            this.hidden = false;
            this.wrap.style.display = ""
        },
        /* ʾнڵ
        @ids    :Array ڵڵid
        @return :Boolean ȫʾ true,򷵻 false
        */
        showAll: function (ids) {
            var same = true;
            this.eachAll(function (n) {
                n.show();
                n.hidden && (same = false)
            }, ids == null ? true : ids);
            return same;
        },
        /* нڵ
        @ids    :Array ڵڵid
        @return :Boolean ȫط true,򷵻 false
        */
        hideAll: function (ids) {
            var same = true;
            this.eachAll(function (n) {
                n.hide();
                n.hidden || (same = false)
            }, ids == null ? true : ids);
            return same;
        }
    }

    simple.extend(BaseItem.prototype, pItem);
    return BaseItem;
} ();

/* #C path:fly.simple.BaseList
    бؼ
*/
fly.simple.BaseList = function () {
    var simple = fly.simple;

    var bTree = function (config) {
        simple.extend(this, config);
        config || (config = {})
        this.itemMap || (this.itemMap = {})
        this.selectedNodes = []
        this.leastSelectionOne == "auto" && (this.leastSelectionOne = this.selectionMode == simple.selectionMode.multi ? false : true)
        typeof (this.checkCascade) != "object" && (this.checkCascade = bTree.buildCascade(this.checkCascade))
        if (!config || !(config.root instanceof this.itemType)) {
            this.root = new this.itemType(simple.extend({}, this.defaults.root, typeof (config.root) == "object" ? config.root : { text: config.root }))
        }
        if (this.rootVisible == "auto")
            this.rootVisible = !!this.root.text;

        this.root.isRoot = true;
        this.join(this.root);

        (this.items || this.data) && this.load(this.items || this.data);

        this.container && this.autoRender !== false && this.renderTo(this.container)
    }

    bTree.buildCascade = function (level) {
        return {
            check: { parent: level, children: level },
            uncheck: { parent: level, children: level }
        }
    }

    var pTree = {
        /* Ĭ */
        defaults: {},
        /* Boolean/String Ƿʾڵ㣬Ĭϡauto */
        rootVisible: "auto",
        /* String ڵkeyԣĬϡid */
        itemKey: "id",
        /* KeyValue ԽڵkeyΪJson */
        itemMap: null,
        /* ӦЧ 
        @isPlay :Boolean Ƿ񲥷
        */
        applyEffect: function (isPlay) {
            if (this.useEffect && (this.effectStarted ^ isPlay != true) && this.rendered) {
                var me = this;

                var filters = me.root.wrap.filters;
                if (filters && filters.length) {
                    for (var i = 0; i < filters.length; i++) {
                        try {
                            filters[i][isPlay === true ? "Play" : "Apply"]();
                        } catch (e) {
                            if (isPlay) {
                                me.root.wrap.style.filter = "none"
                            }
                            return;
                        }
                    }
                    if (isPlay != true) {
                        clearTimeout(this.effectHandle)
                        this.effectHandle = setTimeout(function () {
                            me.applyEffect(true);
                        }, 5);
                    }

                    this.effectStarted = isPlay != true;
                }
            }
        },
        /*  
        @container :Dom 
        */
        renderTo: function (container) {
            this.container = simple.$(container || this.container || document.body);
            this.root.renderTo(this, this.container);
            this.rendered = true;
        },
        join: function (item) {
            var r = item.tree != this
            item.tree = this;
            item.owner = this;
            if (this.rootVisible || item != this.root)
                this.itemMap[item[this.itemKey]] = item;
            return r;
        },
        /* ؽڵ 
        @data :Array/String ͨAjaxurl
        */
        load: function (data) {
            this.root.load(data)
        },
        requestData: function (item, callback) {
            var me = this;
            var process = function (data) {
                try {
                    data && data.constructor == String && (data = eval("(" + data + ")"))
                }
                catch (e) {
                    data = ["ERROR:" + e.message]
                }
                me.onRequestData && (data = me.onRequestData(data))
                callback.call(item, data);
            }

            if (this.async)
                fly.simple.ajax(new simple.ajaxOption(this.async, process, item))
            else if (this.getNodes)
                process(this.getNodes(item))
        },
        createWrap: function (item) {
            !item.wrap && (item.wrap = document.createElement("div"))
            item.wrap.className = this.wrapCss + " " + (item.wrapCss || "")
            return item.wrap;
        },
        createPanel: function (item) {
            var d = document.createElement("div");

            var html = simple.format(this.textDomFormat instanceof Function ? (this.textDomFormat(item)) : this.textDomFormat, item);
            if (this.checkMode != "none" && item.checkMode != "none")
                this.checkboxPostion == "left" ? html = this.checkboxHtml + html : html += this.checkboxHtml;

            d.innerHTML = (this.showToggle ? this.toggleButtonHtml : "") + html;
            d.className = this.nodeCss + " " + (item.css || "") + " " + (item.leaf === false ? this.parentNodeCss : this.leafNodeCss)
            return d;
        },
        createPad: function (item) {
            var d = document.createElement("div");
            d.className = this.padCss + " " + (item.padCss || "")
            return d;
        },
        /* нڵ 
        @item   :fly.simple.BaseItem(ѡ) ҪĽڵ,Ĭϸڵ
        @fn     :Function ڵĺ,false ֹͣ
        @level  :Int(ѡ) ҪĲ,Ĭ
        @return :fly.simple.BaseItem/undefined ;ֹͣ򷵻ص±ֹͣĽڵ㣬ûзֵ
        */
        eachAll: function (item, fn, level) {
            if (simple.isFun(item)) {
                if (simple.isFun(fn)) {
                    item = item.call(this);
                }
                else {
                    level = fn;
                    fn = item
                    item = null;
                }
            }

            if (item == null)
                item = this.rootVisible ? this.root : this.root.items;

            return simple.eachAll(item, "items", fn, level)
        },

        /* String ڵTextHtmlģ */
        textDomFormat: '<a name="textDom" class=f-s-t-item-text href="{href}" title="{title}" id="{id}" ><img name="iconDom" class="f-s-t-item-icon {iconCss} {_iconCss}" src="{icon}" />{text}</a>',
        /* String ڵcheckboxHtml */
        checkboxHtml: '<a unselectable="on" name="checkDom" class="f-s-t-item-check" ></a>',
        /* String ڵչ۵ťHtml */
        toggleButtonHtml: '<a unselectable="on" class=f-s-t-item-toggle name=toggleDom ></a>',
        /* String checkboxλ,Ŀǰ֧"left""right" */
        checkboxPostion: "left",
        /* fly.simple.checkStyle checkbox,ĬϸcheckModeԶʶ */
        checkStyle: simple.checkStyle.auto,
        /* fly.simple.checkMode ڵ㹴ѡģʽ,Ĭϲ */
        checkMode: simple.checkMode.none,
        /* ڵ㹴ѡ
        ʾ:
        1. ñʾ
        checkCascade=0
        
        checkCascade=fallse
        
        checkCascade={
            check: { parent: 0, children: 0 },
            uncheck: { parent: 0, children: 0 }
        }
        

        2. ñʾ,ѡʱͬϼڵ¼ڵ
        checkCascade=true
        
        checkCascade={
            check: { parent: true, children: true },
            uncheck: { parent: true, children: true }
        }

        3. ñʾ,ѡʱͬ2ϼڵ¼ڵ,ȡѡʱӰϼڵ,ͬһ¼ڵ
        checkCascade={
            check: { parent: 2, children: true },
            uncheck: { parent: false, children: 1 }
        }
        */
        checkCascade: {
            check: { parent: 0, children: 0 },
            uncheck: { parent: 0, children: 0 }
        },
        /* Boolean Ƿðѡ״̬ */
        useCheckHalf: true,
        
        /* fly.simple.selectionMode ڵѡģʽ,Ĭϵѡ */
        selectionMode: simple.selectionMode.single,

        /* Boolean/String ѡһ,Ĭϸ selectionMode Զʶ */
        leastSelectionOne: "auto",
        
        /* KeyValue ڵѡ¼,key:ڵdom,value¼ */
        selectEvents: { panel: "click" },

        /* KeyValue ڵ㹴ѡ¼,key:ڵdom,value¼ */
        checkEvents: { checkDom: "click" },
        /* KeyValue ڵչ۵¼,key:ڵdom,value¼ */
        toggleEvents: { toggleDom: "click", panel: "dblclick" },
        /* Boolean ڵ㹴ѡѡ״̬һ */
        keepCheckAndSelectSync: false,
        /* String ڵ۵ťʽǰ沿 */
        toggleStyleCssPart: "f-s-tree-toggle-",
        /* String ڵѡʽ */
        selectedCss: "f-s-t-item-selected",
        /* String ڵչʽ */
        expandCss: "f-s-t-item-expand",
        /* String ڵ۵ʽ */
        collapseCss: "f-s-t-item-collapse",
        /* String ڵʽ */
        nodeCss: "f-s-t-item",
        /* String ӽڵĽڵʽ */
        parentNodeCss: "f-s-t-item-parent",
        /* String ӽڵĽڵʽ */
        leafNodeCss: "f-s-t-item-leaf",
        /* String ڵʽ */
        wrapCss: "f-s-t-item-wrap",
        /* String ӽڵʽ */
        padCss: "f-s-t-item-pad",
        /* String Чʽ */
        effectCss: "f-s-tree-effect",
        /* String ڵCheck״̬Ϊѡʽ */
        checkedCss: "f-s-t-item-checked",

        checkedHalfCss: "f-s-t-item-checked-half",
        uncheckHalfCss: "f-s-t-item-uncheck-half",
        /* String ڵCheckboxťʽǰ沿 */
        checkStylePart: "f-s-t-check-",
        /* String һӽڵʽ */
        firstNodeCss: "f-s-t-item-first",
        /* String ӽڵʽ */
        lastNodeCss: "f-s-t-item-last",
        /* String ͼСʽ */
        iconSizeCss: "f-s-icon-16",
        /* Boolean ǷЧ */
        useEffect: true,
        /* String ڵ href ʱ,ӵĿ괰,Ĭ´ */
        navTarget: '_blank',
        /* Boolean Ƿʾ۵ť */
        showToggle: true,
        /* String ۵ť*/
        toggleStyle: "arrow",
        /* Boolean Ƿʾ */
        showLine: false,
        /* String ڵʽ */
        lineCss: "f-s-t-line",
        /* String CSSʽ */
        css: '',
        /* String ڵص¼ */
        handlerEvent: 'click',
        /* Function ͨõĽڵص */
        nodeHandler: null
    }
    bTree.cloneItemMethod = function (to, methods) {
        simple.each(methods, function (m) {
            to[m] = function () {
                var fis = arguments[0] instanceof this.itemType
                var arg = Array.prototype.slice.call(arguments, fis ? 1 : 0)
                var i = fis ? arguments[0] : this.root;
                if (!fis && arg[i[m].length] == null)
                    arg[i[m].length - 1] = this.rootVisible
                return i[m].apply(i, arg);
            }
        });
    }

    /* path:fly.simple.BaseList.getSelectItems ȡѡڵ 
    @item   :fly.simple.BaseItem(ѡ) ڵ,Ĭϸڵ
    @selected   :Boolean ѡ״̬,trueȡѡнڵ,falseȡδѡнڵ
    @take       :Int(ѡ) ȡĽڵ,Ĭ
    @level      :Int(ѡ) Ĳ,Ĭ
    @return     :Array  Ľڵ   
    */

    /* path:fly.simple.BaseList.collapseAll ۵нڵ
    @item   :fly.simple.BaseItem(ѡ) ڵ,Ĭϸڵ
    @return :Boolean ȫ۵ true,򷵻 false
    */

    /* path:fly.simple.BaseList.expandAll չнڵ
    @item   :fly.simple.BaseItem(ѡ) ڵ,Ĭϸڵ
    @return :Boolean ȫչ true,򷵻 false
    */

    /* path:fly.simple.BaseList.showAll ʾнڵ
    @item   :fly.simple.BaseItem(ѡ) ڵ,Ĭϸڵ
    @return :Boolean ȫʾ true,򷵻 false
    */

    /* path:fly.simple.BaseList.hideAll нڵ
    @item   :fly.simple.BaseItem(ѡ) ڵ,Ĭϸڵ
    @return :Boolean ȫط true,򷵻 false
    */
    bTree.cloneItemMethod(pTree, ["getSelectItems", "collapseAll", "expandAll", "showAll", "hideAll"]);
    simple.extend(bTree.prototype, pTree);

    return bTree;
} ();


/* #C path:fly.simple.Tree
ؼ
@base:fly.simple.BaseList
*/
fly.simple.Tree = function () {
    var simple = fly.simple;
    var Tree = function (config) {
        simple.BaseList.apply(this, arguments);
        this.checkMode || (this.checkMode = simple.checkMode.multi);
        !this.checkMode || this.checkStyle == "auto" && (this.checkStyle = simple.checkModeStyle[this.checkMode] || simple.checkModeStyle.multi);
        simple.selectionMode[this.selectionMode] || (this.selectionMode = simple.selectionMode.single)
    }

    Tree.defaults = {
        root: { collapsed: false, wrapCss: 'f-s-tree' }
    }

    pTree = {
        defaults: Tree.defaults
    }


    var pbi = simple.BaseItem.prototype;
    /* #C path:fly.simple.Tree.Node
    ڵ
    @base:fly.simple.BaseItem
    */
    Tree.Node = function (config) {
        simple.BaseItem.apply(this, arguments);
        this.checkCascade != null && typeof (this.checkCascade) != "object" && (this.checkCascade = simple.BaseList.buildCascade(this.checkCascade))
    }

    var pNode = {
        owner: Tree.prototype,
        checked: false,
        isCheckHalf: false,
        getCheckCascade: function (check, isChildren) {
            var c = check ? "check" : "uncheck"
            var pc = isChildren ? "children" : "parent"
            cascade = this.checkCascade && this.checkCascade[c] && this.checkCascade[c][pc]
            cascade == null && (cascade = this.owner.checkCascade[c] && this.owner.checkCascade[c][pc])
            return cascade > 0 ? (cascade === true ? 1000000 : cascade) : -1
        },

        /* нڵĹѡ״̬
        @checked:Boolean ѡ״̬,true:ѡ,falseδѡ
        @ids    :Array ڵڵid
        @return :Boolean ȫΪָ״̬ true,򷵻 false
        */
        checkAll: function (checked, ids) {
            var same = true;
            this.eachAll(function (n) {
                n.check(checked, false);
                n.checked != checked && (same = false)
            }, ids == null ? true : ids);
            if (this.owner.useCheckHalf) {
                this.cascadeCheckChildren(null, true, true)
                this.setHalf();
                this.cascadeCheckParent(null, true, true)
            }
            return same;
        },
        /* ýڵĹѡ״̬
        @checked:Boolean ѡ״̬,true:ѡ,falseδѡ
        @return :Boolean/Null ñȡ򷵻false,ûзֵ
        */
        check: function (checked, cascade) {
            var me = this
            var e = checked;
            var isToggle = typeof (checked) == "object"
            var o = this.owner;
            isToggle && (checked = this.checked != true)
            if (o.onCheck && o.onCheck(this, checked) === false) return false;

            if (isToggle)
                o.applyEffect();

            this.checked = checked;
            if (cascade !== false) {
                if (o.checkMode == simple.checkMode.single) {
                    if (checked) {
                        var li = o.lastCheckItem
                        if (li && li != this) {
                            li.check(false, false)
                            if (li.parent != this.parent)
                                li.cascadeCheckParent(null, true, true)
                        }
                    }
                    this.cascadeCheckParent(null, true, true)
                }
                else if (o.checkMode == simple.checkMode.singleByLevel) {
                    if (this.parent && checked) {
                        simple.each(this.parent.items, function (n) {
                            n == me || n.check(false, false)
                        });
                    }
                    o.useCheckHalf && this.setHalf();
                    this.cascadeCheckParent(null, true, true)
                }
                else {
                    this.cascadeCheckChildren(checked, this.getCheckCascade(checked, true))
                    o.useCheckHalf && this.setHalf();
                    this.cascadeCheckParent(checked, this.getCheckCascade(checked, false))
                }
            }
            this.checked = checked
            if (checked)
                o.lastCheckItem = this
            simple.changeCss(this.panel,
                o.checkedCss + " " + o.checkHalfCss,
                checked == 0.5 ? o.checkHalfCss : (checked ? o.checkedCss : ""));

            if (o.keepCheckAndSelectSync && (this.selected != (checked == true)))
                this.select(!!checked, true)

            o.onChecked && o.onChecked(this);

            if (isToggle) return false
        },
        decideHalf: function (onlySun, check) {
            if (!this.items.length) return false
            check == null && (check = this.checked)
            var has = this.eachItems(function (n) {
                return n.checked == check && n.isCheckHalf != true;
            })
            return has ? (this.checked ? 1 : -1) : 0;
        },
        setHalf: function (half) {
            half == null && (half = this.decideHalf())
            if (half == true)
                half = this.checked ? 1 : -1;
            else if (half == false)
                half = 0;

            if (this.isCheckHalf == half) return half;
            this.isCheckHalf = half;

            var addCss = "", o = this.owner
            if (half)
                addCss = o[this.checked ? "checkedHalfCss" : "uncheckHalfCss"]
            simple.changeCss(this.panel, o.checkedHalfCss + " " + o.uncheckHalfCss, addCss);
            return half;
        },
        cascadeCheckParent: function (check, level, refreshCheckHalf) {
            var half = null;
            var o = this.owner;
            simple.eachParent(this, function (p, l) {
                if (check != null && l <= level) {
                    if (p.checked != check) {
                        if (check)
                            p.check(check, false);
                        else {
                            if (!p.decideHalf(true, check)) {
                                p.check(check, false)
                            }
                            else
                                check = true;
                        }
                    }
                }
                if (refreshCheckHalf != false && o.useCheckHalf) {
                    if (p.setHalf(half))
                        half = true;
                }
                else if (l > level) return false;
            });
        },
        cascadeCheckChildren: function (check, level, refreshCheckHalf) {
            if (!this.items.length) return
            if (check != null) {
                this.eachAll(function (item) {
                    item.check(check, false);
                }, false, level);
            }

            if (refreshCheckHalf != false && this.owner.useCheckHalf)
                this.eachAll(function (item) {
                    item.setHalf();
                }, false, level);
        },
        
        /* ȡйѡڵ 
        @checked    :Boolean ѡ״̬,trueȡѹѡڵ,falseȡδѡڵ
        @take       :Int(ѡ) ȡĽڵ,Ĭ
        @level      :Int(ѡ) Ĳ,Ĭ
        @includeSelf:Boolean(ѡ) ǰڵ,Ĭϲ
        @return     :Array  Ľڵ
        */
        getCheckItems: function (checked, take, level,includeSelf) {
            return simple.queryAll(includeSelf?this:this.items, "items", function (i) {
                return i.checked == checked
            }, level, take)
        },
        bindEvents: function () {
            pbi.bindEvents.apply(this, arguments);
            var owner = this.owner
            simple.bindEvents(this, owner.checkEvents, simple.scope(this.check, this))
            if (simple.isIE6)
                simple.ie6aHover(this.checkDom)
        }
    }
    /* #C path:fly.simple.Tree */
    /* path:fly.simple.Tree.getCheckItems ȡйѡڵ
    @item       :fly.simple.Tree.Node(ѡ) ڵ,Ĭϸڵ
    @checked    :Boolean ѡ״̬,trueȡѹѡڵ,falseȡδѡڵ
    @take       :Int(ѡ) ȡĽڵ,Ĭ
    @level      :Int(ѡ) Ĳ,Ĭ
    @return     :Array  Ľڵ
    */

    /* path:fly.simple.Tree.checkAll нڵĹѡ״̬
    @item       :fly.simple.Tree.Node(ѡ) ڵ,Ĭϸڵ
    @checked:Boolean ѡ״̬,true:ѡ,falseδѡ
    @return :Boolean ȫΪָ״̬ true,򷵻 false
    */
    simple.BaseList.cloneItemMethod(pTree, ["getCheckItems", "checkAll"]);
    simple.inherit(Tree.Node, simple.BaseItem, pNode);

    /* path:fly.simple.Tree.root fly.simple.Tree.Node ڵ*/
    pTree.root = Tree.Node.prototype;

    /* path:fly.simple.Tree.itemType Function ڵ,Ĭ:fly.simple.Tree.Node*/
    pTree.itemType = Tree.Node;
    simple.inherit(Tree, simple.BaseList, pTree);
    return Tree;
} ();
