﻿
fly.simple.Tree = function () {
    var simple = fly.simple;
    var Tree = function (config) {
        simple.BaseTree.apply(this, config);
        this.nodeType || (this.nodeType = Tree.Node);
        this.checkMode || (this.checkMode = simple.checkMode.multi);
        !this.checkMode || this.checkStyle == "auto" && (this.checkStyle = Tree.checkModeStyle[this.checkMode] || Tree.checkModeStyle.multi);
        simple.selectionMode[this.selectionMode] || (this.selectionMode = simple.selectionMode.single)
    }

    Tree.defaults = {
        root: { collapsed: false, wrapCss: 'f-s-tree' }
    }

    pTree = {
        defaults: Tree.defaults
    }
    simple.inherit(Tree, simple.BaseTree, pTree);

    var pbi = simple.BaseItem.prototype;
    Tree.Node = function (config) {
        simple.BaseItem.apply(this, arguments);
        this.checkCascade != null && typeof (this.checkCascade) != "object" && (this.checkCascade = Tree.buildCascade(this.checkCascade))
    }

    var pNode = {
        owner: Tree.prototype,
        checked: false,
        getCheckCascade: function (check, isChildren) {
            var c = check ? "check" : "uncheck"
            var pc = isChildren ? "children" : "parent"
            cascade = this.checkCascade && this.checkCascade[c] && this.checkCascade[c][pc]
            cascade == null && (cascade = this.owner.checkCascade[c] && this.owner.checkCascade[c][pc])
            return cascade > 0 ? (cascade === true ? 1000000 : cascade) : -1
        },
        checkHalfIfNoChecked: function () {
            if (this.checked == false)
                this.check(0.5, false)
        },
        checkAll: function (checked, ids) {
            this.eachAll(function (n) {
                return n.check(checked, false);
            }, ids);
        },
        check: function (checked, cascade) {
            var me = this
            var e = checked;
            var isToggle = typeof (checked) == "object"
            var owner = this.owner;
            isToggle && (checked = this.checked != true)
            if (owner.onCheck && owner.onCheck(this, checked) === false) return false;

            if (isToggle)
                this.owner.applyEffect();

            this.checked = checked;
            if (cascade !== false) {
                if (owner.checkMode == simple.checkMode.single) {
                    owner.eachAll(function (n) {
                        n != me && n.check(false, false)
                    })
                    simple.eachParentNode(this, function (n) {
                        n == me || n.check(checked == true ? 0.5 : false, false);
                    })
                }
                else if (owner.checkMode == simple.checkMode.singleByLevel) {
                    if (this.parent && checked) {
                        simple.each(this.parent.items, function (n) {
                            n == me || n.check(false, false)
                        });
                    }
                }
                else {
                    this.cascadeCheckParent(this.getCheckCascade(checked, false))
                    this.cascadeCheckChildren(this.getCheckCascade(checked, true))
                }
            }
            this.checked = checked
            simple.changeCss(this.panel,
                this.owner.checkedCss + " " + this.owner.checkHalfCss,
                checked == 0.5 ? this.owner.checkHalfCss : (checked ? this.owner.checkedCss : ""));

            if (owner.keepCheckAndSelectSync && (this.selected != (checked == true)))
                this.select(!!checked, true)

            this.owner.onChecked && this.owner.onChecked(this);
            if (isToggle) return false
        },
        decideHalf: function (checked) {
            if (checked == 0.5)
                return this.checked == true ? true : 0.5;
            if (checked == true) return checked;

            var has = simple.each(this.items, function (n) {
                return n.checked !== false ? false : 1;
            })

            return has ? 0.5 : false;
        },
        cascadeCheckParent: function (level) {
            var node = this, checked = this.checked;
            level === true && (level = 1000000)
            while ((node = node.parent) && level > 0) {
                if (node.checked === checked)
                    break;
                else {
                    var ns = node.items;
                    var is05 = false;
                    for (var i = 0; i < ns.length; i++) {
                        if (ns[i].checked != checked) {
                            if (!(ns[i] == 0.5 && check == true && level < 1)) {
                                is05 = true;
                                break;
                            }
                        }
                    }
                    var c = is05 ? 0.5 : checked
                    if (c === node.checked) break;
                    node.check(c, false)
                }
                level--;
            }
        },
        //        hasNoChildren: function (level) {
        //            if (!this.items.length) return false;
        //            var each = function (ns, l) {
        //                if (l-- < 0) return false;
        //                for (var i = 0; i < ns.length; i++)
        //                    if (ns[i].checked == false || each(ns[i].items, l) == true) return true;
        //                return false;
        //            }

        //            return each(this.items, level == null ? this.getCheckCascade(true, true) : level);
        //        },
        cascadeCheckChildren: function (level) {
            checked = this.checked;
            level === true && (level = 1000000)
            if (this.items.length && level > 0) {
                var cascade = function (ns, l) {
                    --l
                    for (var i = 0; i < ns.length; i++) {
                        l > 0 && cascade(ns[i].items, l);
                        if (ns[i].checked != checked && (checked != true || ns[i].checked != 0.5))
                            ns[i].check(checked == true && ns[i].hasNoChildren() ? 0.5 : checked, false);
                    }
                }
                cascade(this.items, level);
            }
        },
        bindEvents: function () {
            pbi.bindEvents.apply(this, arguments);
            var owner = this.owner
            simple.bindEvents(this, owner.checkEvents, simple.scope(this.check, this))
            if (simple.isIE6)
                simple.ie6aHover(this.checkDom)
        }
    }

    simple.inherit(Tree.Node, simple.BaseItem, pNode);

    simple.each(["collapseAll", "expandAll", "checkAll", "showAll", "hideAll"], function (m) {
        pTree[m] = function () {
            this.root[m].apply(this.root, arguments);
        }
    });

    Tree.prototype.root = Tree.Node.prototype;
    return Tree;
} ();
