﻿//## fly
/* #C fly Javacript脚本库
Version 1.0 alpha
http//:www.flyui.net
QQ群:80956425
Email:flyui@hotmail.com
Copyright (c) 2009 吾越乾坤
2009-11-23
*/

var ddd = new Date();
var $$contexts = [];
$$contexts.add = function (w, f) {
    $$contexts.push({ win: w, $: f });
    function d() {
        w.strat = new Date()
        for (var i = 0; i < $$contexts.length; i++) {
            if ($$contexts[i].win == w)
                $$contexts.splice(i, 1);
        }
        d = null;
        w.detachEvent && w.detachEvent("onunload", d)
        w.removeEventListener && w.removeEventListener("unload", d)
        f.destroy();
        //alert(new Date()- w.strat )
    }
    f.onUnload(d)
}

$$contexts.$ = function (win) {
    var Array = win.Array, String = win.String, Date = win.Date, Function = win.Function, doc = win.document, docE = doc.documentElement
    win.$setup = arguments.callee;
    win._$isWindow = true

    function destroy(obj) {
        if (arguments.length == 1) {
            if (obj.destroy && obj.destroy != arguments.callee)
                obj.destroy()
            else if (Array && obj instanceof Array) {
                arguments.callee.apply(false, obj);
                for (var i = obj.length - 1; i > -1; i--) {
                    obj[i] = null;
                    obj.pop();
                }
            }

            for (var k in obj) {
                var v = obj[k]
                obj[k] = null
                if (v && v.destroy)
                    v.destroy()
                v = null;
            }
        }
        else if (arguments.length == 0) {
            this.destroy = null;
            arguments.callee.call(false, this)
        }
        else {
            for (var i = 0; i < arguments.length; i++)
                arguments.callee.call(false, arguments[i])
        }

        if (this != false)
            CollectGarbage()
    }

    var fly = win.fly = function () {
        /*	path:fly.$
        查询Dom对象
        调用方式：
        fly.$("a","div")
        fly.$("a,div")
        fly("a,div")
        fly("a","div")
        $("a","div")
        $("a,div")
        [document].$("a,div")
        [div1,div2].$("a,div")
		
        @selectors:String/Dom 可变参数，任意多个选择器字符串或对象
        @return :Array 符合条件的多个Dom对象数组
        */
        var f = function (selectors) {
            var c = null;
            if (this._$isWindow || this == fly) {
                if (selectors && arguments.length == 1) {
                    if (selectors.isIEnumerable)
                        return selectors;
                    if (fly.isFun(selectors))
                        return fly.onLoad(selectors)
                    else if (!fly.isString(selectors))
                        return fly.toArray(selectors)
                }
            }
            else
                c = fly.isArray(this) ? this : (fly.likeArray(this) ? fly.toArray(this) : [doc])
            var a = (new f.ui.selector.DomQuery(c, arguments)).find();
            return a;
        }
        var config = win.flyConfig || {}
        f.version = '1.0';

        /*	path:flyConfig.addAlias
        给fly库命别名
        fly库默认别名 $，如果 给fly库指定其它别名，默认别名 $ 将被取消
        可以在 fly 库加载前用如下代码定义别名
        var flyConfig={
        alias:["myFly","jimo"]
        }
        也可以直接调用该函数定义别名
        fly.addAlias("myFly","jimo")
        经过以上定义后，便可以用别名访问fly库
        如：
        myFly.$("a,div")
        myFly("a","div")
        jimo.$("a","div")
        jimo("a,div")
			
        @alias :String 可变参数，任意多个别名
        @return :fly fly库
        */
        f.addAlias = function (alias) {
            if (fly.isArray(alias)) {
                f.each(alias, function (a) {
                    win[a] = f
                })
            }
            else
                win[alias] = f
            return f
        }

        /* #M	path:flyConfig.onLoad
        fly加载完成时执行回调函数
        可以在 fly 库加载前用如下代码定义加载完成是的回调函数
        var flyConfig={
        alias:["myFly","jimo"],
        onLoad:function(){
        alert('fly已经加载完成')
        }
        }
        */
        f.__onLoad = function () {
            $$contexts.add(win, f);
            if (config.alias)
                f.addAlias(config.alias)
            else
                win.$ = win.$ || f

            f.ifFun(config.onLoad, f, f)
        }

        f.__old = (win.fly || (config.rename ? win[config.rename] : null))
        if (f.__old) {
            for (var k in f.__old)
                f[k] = f.__old[k]
        }

        f.destroy = function () {
            this.destroy = null;
            destroy.apply(this, arguments)
            if (arguments.length == 0) {
                try {
                    destroy(Array.prototype, String.prototype, Function.prototype)
                    Array = String = Date = Function = null
                } catch (e) { }
                if (win)
                    win.fly = win.$ = doc = win.$setup = win._$isWindow = destroy = null
            }
        }
        return f
    } ();
    //#end

    /* #C path:fly */

    //##
    /*	创建命名空间
    @namespace:String 要创建的命名空间，如 fly.ui
    @return	:Namespace 创建的命名空间
    */
    fly.ns = function (namespace) {
        if (arguments.length > 1) {
            for (var i = 0; i < arguments.length; i++)
                fly.ns(arguments[i])
            return
        }
        var nss = namespace.split('.')
        var root = win
        for (var i = 0; i < nss.length; i++)
            root = root[nss[i]] || (root[nss[i]] = { destroy: destroy })
        return root
    }

    /*	创建类
    @options: 选项
    @return	:Class 创建的类
    */
    fly.Class = function (options) {
        var base = options.base
        var beforeNew = options.beforeNew
        var afterNew = options.afterNew
        var _class = options.constructor
        if (_class == Object || _class == null)
            _class = $.isFun(base) ? function () { base.apply(this, arguments) } : function () { }

        if (fly.isFun(beforeNew) || fly.isFun(afterNew))
            _class = function () {
                if (fly.isFun(beforeNew))
                    beforeNew.apply(this, arguments)
                this.constructor.apply(this, arguments)
                if (fly.isFun(afterNew))
                    afterNew.apply(this, arguments)
            }


        var _base = fly.isFun(base) ? base.prototype : (fly.isObject(base) ? base : Object.prototype)
        function f() { }
        f.prototype = _base
        _class.prototype = new f()
        _class.prototype.$base = _base;

        if (fly.isFun(base)) {
            for (var p in base) {
                if (!(p in _class))
                    _class[p] = base[p]
            }
        }

        if (options.inherit) {
            var hs = fly.isArray(options.inherit) ? options.inherit : [options.inherit]
            fly.each(hs, function (o) {
                fly.extendIf(_class.prototype, o)
            })
            delete options.inherit
        }

        delete options.beforeNew
        delete options.afterNew
        delete options.constructor
        delete options.base
        for (var k in options)
            _class.prototype[k] = options[k]

        _class.$base = fly.isFun(base) ? base : Object
        _class.prototype.constructor = _class;
        return _class
    }

    fly.ns("fly.data")
    var lib = fly.ns("fly.lib"), ui = fly.ns("fly.ui"), collection = fly.ns("fly.collection"), browser = fly.Browser || (fly.Browser = {})
    var arrP = Array.prototype
    var slice = arrP.slice
    var toStr = Object.prototype.toString
    var qp = null, dh, toFun;
    var camelCase = function (str) {
        str = str.replace(/\-\w/g, function ($1) {
            return $1.charAt(1).toUpperCase()
        })
        return str.charAt(0).toLowerCase() + str.substr(1)
    }

    with (browser) {
        var ua = browser.userAgent = navigator.userAgent.toLowerCase();
        function check(r) {
            return r.test(ua);
        }

        browser.doc = doc
        browser.isStrict = doc.compatMode == "CSS1Compat";
        browser.isFirefox = check(/firefox/)
        browser.isOpera = check(/opera/)
        browser.isChrome = check(/chrome/)
        browser.isWebKit = check(/webkit/)
        browser.isSafari = !isChrome && check(/safari/)
        browser.isSafari2 = isSafari && check(/applewebkit\/4/)
        browser.isSafari3 = isSafari && check(/version\/3/)
        browser.isSafari4 = isSafari && check(/version\/4/)
        browser.isIE = !isOpera && check(/msie/)
        browser.isIE7 = isIE && check(/msie 7/)
        browser.isIE8 = isIE && check(/msie 8/)
        browser.isIE6 = isIE && !isIE7 && !isIE8
        browser.isGecko = !isWebKit && check(/gecko/)
        browser.isGecko2 = isGecko && check(/rv:1\.8/)
        browser.isGecko3 = isGecko && check(/rv:1\.9/)
        browser.isBorderBox = isIE && !isStrict
        browser.isWindows = check(/windows|win32/)
        browser.isMac = check(/macintosh|mac os x/)
        browser.isAir = check(/adobeair/)
        browser.isLinux = check(/linux/)
        browser.isSecure = /^https/i.test(win.location.protocol);
        browser.isMoz = check(/mozilla/) && !browser.isOpera && !browser.isIE
        browser.diffAttrs =
		{
		    styleRemoveMethod: docE.style.removeProperty ? 'removeProperty' : 'removeAttribute'
		}

        browser.name = isIE6 ? "IE6" : isIE7 ? "IE7" : isIE8 ? "IE8" : isFirefox ? "FF" : isOpera ? "Opera" : isChrome ? "Chrome" : isSafari ? "Safari" : ""

        if (browser.isMoz) {
            win.Event.prototype.__defineGetter__("x", function () {
                return this.clientX + 2
            })
            win.Event.prototype.__defineGetter__("y", function () {
                return this.clientY + 2
            })
            var htmlProp = HTMLElement.prototype
            htmlProp.__defineGetter__("innerText", function () {
                return this.textContent;
            });

            htmlProp.__defineSetter__("innerText", function (text) {
                return this.textContent = text;
            });


            htmlProp.__defineGetter__("outerHTML", function () {
                var a = this.attributes, str = "<" + this.tagName, i = 0; for (; i < a.length; i++)
                    if (a[i].specified)
                        str += " " + a[i].name + '="' + a[i].value + '"';
                if (!this.canHaveChildren)
                    return str + " />";
                return str + ">" + this.innerHTML + "</" + this.tagName + ">";
            });
            htmlProp.__defineSetter__("outerHTML", function (s) {
                var r = this.ownerDocument.createRange();
                r.setStartBefore(this);
                var df = r.createContextualFragment(s);
                this.parentNode.replaceChild(df, this);
                return s;
            });
            htmlProp.__defineGetter__("canHaveChildren", function () {
                return !/^(area|base|basefont|col|frame|hr|img|br|input|isindex|link|meta|param)$/.test(this.tagName.toLowerCase());
            });

        }
    }
    //#end


    //## extend
    /*	扩展
    @target	:被扩展的对象
    @overrides:包含扩展成员的任意多个参数
    @return :target
    */
    fly.extend = function (target, overrides) {
        if (arguments === 1)
            return fly.extend(fly, target);
        var isSafety = fly.isString(this);
        var prefixLength = isSafety ? this.length : -1
        for (var i = 1; i < arguments.length; i++) {
            var item = arguments[i]
            if (item) {
                for (var key in item) {
                    if (key.charAt(0) === "$") continue;
                    if (isSafety) {
                        if (this != "" && key.substr(0, prefixLength) != this)
                            target[this + key] = item[key]
                        if (!(key in target))
                            target[key] = item[key]
                    }
                    else if (this != false || target[key] == undefined)
                        target[key] = item[key];
                }
            }
        }
        return target;
    }

    fly.quickExtend = function (target, overrides) {
        if (overrides)
            for (var key in overrides) {
                if (key.charAt(0) === "$") continue;
                var item = overrides[key];
                if (item != undefined)
                    target[key] = item;
            }
        return target;
    }

    fly.extend(fly,
	{
	    addPlugin: function (fn) {
	        $$contexts.each(function () {
	            fn(this.win, this.$);
	        })
	        return this;
	    },
	    /*	扩展时检测
	    @prefix	:String 前缀
	    @target	:被扩展的对象
	    @overrides	:包含扩展成员的任意多个参数
	    @return	:target
	    */
	    safeExtend: function (prefix, target, overrides) {
	        return fly.extend.apply(prefix, slice.call(arguments, 1))
	    },


	    /*	扩展,扩展前检测是否存在
	    @target	:被扩展的对象
	    @overrides:包含扩展成员的任意多个参数
	    @return	:target
	    */
	    extendIf: function (target, overrides) {
	        return fly.extend.apply(false, arguments);
	    },
	    /*  复制一个对象
	    @obj    :要复制的对象
	    @return :@obj的副本
	    */
	    copy: function (obj) {
	        return fly.quickExtend({}, obj);
	    },
	    /*	合并一组对象生成新对象
	    例：var all=fly.merge(obj1,obj2,obj3,....,objn)
	    @params	:Object 可变参数，要合并的多个对象
	    @return	:Object 包含多个对象成员的新对象
	    */
	    merge: function (params) {

	        return fly.extend.apply(null, [{}].concat(fly.slice(arguments, 0)))
	    },
	    /*  检查对象是否为null，为null时返回另一个对象
	    @chkObj :Object 要检测的对象
	    @replacement    :chkObj 为null时返回的值
	    */
	    nullIf: function (chkObj, replacement) {
	        return chkObj == null ? replacement : chkObj
	    },

	    /*  获取属性
	    @obj:		对象
	    @attribute:	String 属性名
	    @return	:Object 属性值
	    */
	    get: function (obj, attribute) {
	        if (fly.isString(obj)) return fly.lib.ajax.get.apply(this, arguments);

	        if (obj.attributes && attribute in obj.attributes)
	            return obj.getAttribute(attribute)
	        else
	            return obj[attribute];
	    },


	    /*  设置属性
	    @obj:		对象
	    @attribute:	String/Object 属性名或包属性名和属性值的键值对
	    @value	:	Object(可选) 值
	    @return	:obj
	    */
	    set: function (obj, attribute, value) {
	        arguments.length > 2 ? fly._set(obj, attribute, value) : fly.setBy(obj, attribute)
	        return obj
	    },
	    _set: function (o, p, v) {
	        o[p] = v;
	        //	        if (o.attributes && p in o.attributes)
	        //	            o.setAttribute(p, v)
	        //	        else o[p] = v;
	    },

	    data: function (obj, prop, value) {
	        var isObj = fly.isObject(prop)
	        if (arguments.length < 3 && !isObj)
	            return obj[prop]
	        if (isObj) {
	            for (var k in prop)
	                obj[k] = prop[k]
	        }
	        else
	            obj[prop] = value
	        return this;
	    },
	    foucsableTypeRegs: /(BUTTON|INPUT|OBJECT|SELECT|TEXTAREA)/,
	    clickableTypeRegs: /^(A|AREA)$/,
	    attrGeters: {},

	    attr: function (obj, prop, value) {
	        var isObj = fly.isObject(prop)
	        if (arguments.length < 3 && !isObj) {
	            var lProp = prop.toLowerCase()
	            if (this.isDom(obj) && this.attrGeters[lProp])
	                return this.attrGeters[lProp](obj)
	            return obj.getAttribute ? obj.getAttribute(prop) : obj[prop];
	        }
	        if (isObj) {
	            for (var k in prop)
	                obj.setAttribute ? obj.setAttribute(k, prop[k]) : obj[k] = prop[k]
	        }
	        else //obj.setAttribute ? obj.setAttribute(prop, value) : obj[prop] = value;
	            obj[prop] = value
	        return this;
	    },
	    valueGeters: {
	        option: function (box) {
	            return (box.attributes.value || {}).specified ? box.value : box.text
	        },
	        select: function (box) {
	            if (box.type === "select-one")
	                return box.selectedIndex > -1 ? fly.valueGeters.option(box.options[box.selectedIndex]) : null
	            var vs = new Array
	            for (var i = 0; i < box.options.length; i++)
	                if (box.options[i].selected)
	                    vs.push(fly.valueGeters.option(box.options[i]))
	            return vs
	        },
	        input: function (box) {
	            var t = box.type
	            if (t == "radio" || t == "checkbox")
	                return box.value == null ? "on" : box.value
	            else return box.value
	        }
	    },
	    valueSeters: {
	        select: function (box, value) {
	            var isOne = box.type === "select-one"
	            var isArray = fly.likeArray(value)
	            for (var i = 0; i < box.options.length; i++) {
	                var o = box.options[i], v = fly.valueGeters.option(o)
	                if ((o.selected = v == value || (isArray && fly.inArray(v, value))) && isOne) return
	            }
	        }
	    },
	    value: function (box, value) {
	        if (arguments.length == 1) {
	            var nodeName = box.nodeName.toLowerCase()
	            var f = fly.valueGeters[nodeName]
	            return f ? f(box) : f.value
	        }
	        else {
	            var nodeName = box.nodeName.toLowerCase()
	            var f = fly.valueSeters[nodeName]
	            var val = fly.ifFun.call(box, value, box)
	            f ? f(box, val) : f.value = val
	            return this
	        }
	    },

	    firstNotNull: function (params) {
	        var i = -1
	        while (++i < arguments.length)
	            if (arguments[i] != null)
	                return arguments[i]
	        },

	        /*  设置属性
	        @obj:		对象
	        @keyValues:	Object 包含属性名和属性值的键值对
	        @return	:obj
	        */
	        setBy: function (obj, keyValues) {
	            for (var key in keyValues)
	                fly._set(obj, key, keyValues[key])
	            return obj
	        },

	        is: function () {
	            var is = function (obj, type, typeName) {
	                return typeName ?
                        toStr.call(obj) == "[object " + typeName + "]" :
                        (obj == type ||
                            (obj == null || type == null ? false :
                                $.isFun(type) &&
                                    (obj instanceof type ||
                                        (obj.constructor == type || String(obj.constructor) == String(type))
                                    )
                                ))

	                //                return obj==type || 
	                //                (obj==null||type==null?false:
	                //                    (obj.constructor==type|| 
	                //                        (typeName?Object.prototype.toString.call(obj)=="[object "+typeName+"]":obj.constructor.toString()==type.toString() )
	                //                     )
	                //                )
	            }

	            var types = ["Date", "Number", "Boolean", "String", "Array", "Function", "Object"]
	            for (var i = 0; i < types.length; i++) {
	                (function (t) {
	                    var st = "[object " + t + "]"
	                    fly["is" + t] = function (obj) {
	                        return obj != null && toStr.call(obj) === st
	                    }
	                } (types[i]))
	            }

	            /*	检测一个值是否函数
	            @obj	:要检测的对象
	            @return	:Boolean
	            */
	            fly.isFun = fly.isFunction
	            return is;
	        } (),
	        isHtml: function () {
	            var htmlExp = /<[\w]+[\s\S]+>/
	            return function (str) {
	                return fly.isString(str) && htmlExp.test(str)
	            }
	        } (),
	        isEmpty: function (v, allowBlank) {
	            return v === null || v === undefined || ((fly.likeArray(v) && !v.length)) || (allowBlank ? false : v === '');
	        },

	        /*	像数组的对象，如 arguments、document.all
	        @obj:要检测的对象
	        @return	:Boolean
	        */
	        likeArray: function (obj) {
	            return obj && (fly.isArray(obj) || (typeof (obj.length) == 'number' && !fly.isFun(obj) && !fly.isString(obj) && !obj._$isWindow))
	        },

	        /*	是否IEnumerable对象
	        @obj:要检测的对象
	        @return	:Boolean
	        */
	        isIEnumerable: function (v) {
	            return v.isIEnumerable == true
	        },


	        /*	是否Dom对象
	        @obj:要检测的对象
	        @return	:Boolean
	        */
	        isDom: function (obj) {
	            return obj && obj.nodeType === 1 && obj.ownerDocument
	        },


	        /*  将对象转换为数组
	        @obj   :要转换的对象
	        @return	:Array
	        */
	        toArray: function (obj) {
	            if (fly.isArray(obj))
	                return obj
	            if (!fly.likeArray(obj))
	                return new Array(obj)
	            if (fly.isFun(obj.callee))
	                return slice.call(obj, 0)
	            var arr = new Array, i = obj.length
	            while (--i != -1)
	                arr[i] = obj[i]
	            return arr
	        },


	        /*  获取集合的一部分
	        @obj		:集合对象
	        @start	:Int 开始位置
	        @end	:Int(可选) 结束为置
	        @return	:Array
	        */
	        slice: function (obj, start, end) {
	            return slice.call(fly.toArray(obj), start, end == undefined ? 1000000 : end)
	        },


	        /*	遍历一个对象
	        @obj	:Array 被遍历对象
	        @fn		:Function 处理函数
	        @scope	:Object(可选) 域
	        @return	:obj
	        */
	        each: function (obj, fn, scope) {
	            if (fly.likeArray(obj))
	                for (var i = 0; i < obj.length; i++)
	                    fn.call(scope || obj[i], obj[i], i, obj)
	            else
	                for (var i in obj)
	                    fn.call(scope || obj[i], obj[i], i, obj)
	            return obj
	        },


	        /*	检测对象是否在一组数据中,例	:fly.In(3,1,2,3,4,...,n)
	        @value	:要检测的一个值
	        @params	:Object(可选) 可变参数，一组数据
	        @return	:Boolean
	        */
	        inArray: function (value, params) {
	            var arr = arguments, i = 1;
	            if (arguments.length == 2 && fly.likeArray(params))
	                arr = params, i = 0
	            for (; i < arr.length; i++)
	                if (arr[i] == value)
	                    return true
	                return false
	            },

	            /*	空函数
	            @return	:this
	            */
	            emptyFun: function () {
	                return this
	            },


	            /*	返回 false 的函数
	            @return	:false
	            */
	            falseFun: function () {
	                return false
	            },


	            /*	对传入的对象进行函数封装,封装后的函数返回 @obj
	            @obj	:如果obj是函数，则返回obj，否则放一个新的函数，该函数返回值始终是obj
	            @return	:Function
	            */
	            lambda: function (obj) {
	                return fly.isFun(obj) ? obj : function () {
	                    return obj
	                }
	            },


	            /*	如果不是函数转换为函数
	            @fun	:Object/String/Functon或字符串
	            @onlyStr:Boolean 只有fun为字符串时转换
	            @format	:String 函数格式化字符串
	            @return	:Function
	            */
	            toFun: toFun = function () {
	                var reg = /\b(if|for|with|while|do|switch|throw|return|var)\b/
	                var cache = {}
	                function attachReturn(expression, format) {
	                    if (reg.test(expression) == false && (format == null || reg.test(format) == false))
	                        expression = "return " + expression
	                    return expression
	                }

	                return function (expression, onlyStr, format) {
	                    var isStr = fly.isString(expression)
	                    if ((onlyStr == true && isStr == false) || fly.isFun(expression))
	                        return expression
	                    if (isStr == false && format == null)
	                        return function () {
	                            return expression
	                        }

	                    var key = arguments.length < 4 ? expression + (onlyStr || '') + (format || '') : ""
	                    var fn;
	                    if (key != "" && (fn = cache[key]))
	                        return fn
	                    var params, ms
	                    if (fly.isString(expression) && (ms = expression.match(/^([\s,\w$_]*)=>/))) {
	                        params = ms[1]
	                        expression = expression.replace(/^([\s,\w$]*)=>/, "")
	                        expression = attachReturn(expression, format)
	                        if (format) {
	                            var r = /\bfunction\s*\(([\s,\w$_]*)\)/;
	                            ms = r.exec(format)
	                            if (/^\s*$/.test(ms[1]))
	                                format = format.replace(r, " function(" + params + ")")
	                            else {
	                                var pStrs = params.split(',');
	                                for (var i = 0; i < pStrs.length; i++)
	                                    expression = "var " + pStrs[i] + "=arguments[" + i + "];" + expression
	                            }
	                        }
	                        else
	                            format = "function(" + params + "){{0}}"
	                    }
	                    else
	                        expression = attachReturn(expression, format)
	                    if (/\bas\b/.test(expression))
	                        expression = "var as=arguments; " + expression
	                    var args = arguments
	                    if (format)
	                        fn = eval("___f=" + format.$format(expression))
	                    else
	                        fn = eval("___f=function(x,y,z){" + expression + "}")
	                    if (key != "")
	                        cache[key] = fn
	                    return fn
	                }
	            } (),


	            /*	ifFun 假如是函数 则返回函数的执行结果
	            @obj	:Function/Object 函数或其它值
	            @params	:Object(可选) 可变参数，要传递的任意多个参数
	            @return	:Boolean
	            */
	            ifFun: function (obj, params) {
	                if (obj && fly.isFun(obj))
	                    return arguments.length > 1 ? obj.apply(this, slice.call(arguments, 1)) : obj.call(this)
	                return obj
	            },

	            /*  通过调用对象本身的 $format 方法格式化对象
	            @obj    :String/Date/Function 要格式化的对象
	            @params :Object(可选) 可变参数，要传递的任意多个参数
	            @return :String/Function  格式化后的对象
	            */
	            format: function (obj, params) {
	                return (obj.$format || obj.format).apply(obj, slice.call(arguments, 1))
	            },
	            globalEval: function (script) {
	                if (script == null || /^\s*$/.test(script))
	                    return
	                var head = doc.getElementsByTagName("head")[0] || docE
	                var dom = doc.createElement("script")
	                dom.type = "text/javascript"
	                dom.text = script
	                head.appendChild(dom, head.firstChild)
	                head.removeChild(dom)
	            }
	        })
    fly.In = fly.inArray
    //#end

    //## lib.Cache
    lib.CacheHelper = function () {
        var me = this;
        var all = {}
        this.data = function (target, key, data) {
            var id = typeof (target) == "string" ? target : fly.isObject(target) || fly.isFun(target) ? ui.DomHelper.getUniqueID(target) : target;
            var d = all[id] || (all[id] = {})
            if (data !== undefined)
                return d[key] = data;
            return d[key]
        }

        this.removeData = function (target, key) {
            var id = fly.isObject(target) || fly.isFun(target) ? ui.DomHelper.getUniqueID(target) : target;
            if (key == null)
                delete all[id]
            else all[id]
            delete myCache[key]
        }

        this.queue = function (target, key, data) {
            key += ":queue";
            var cd = me.data(target, key);
            fly.isArray(cd) ? cd.push(data) : me.data(target, key, [data]);
        }

        this.dequeue = function (target, key) {
            key += ":queue";
            var queue = this.data(target, key)
            var fn = queue.shift();

            if (fly.isFun(fn))
                fn.call(target);
        }
        this.destroy = function () {
            me.destroy = null;
            for (var k in all) {
                for (var kk in all[k])
                    all[k][kk] = null;
                all[k] = null;
            }
            all = null;
            destroy(this)
            me = null
        }
    }
    lib.Cache = new lib.CacheHelper();
    //#end

    //## Function
    /* #C 函数扩展*/
    fly.lib.Function = fly.extend(
	{
	    /*	根据条件判断是否执行
	    @predicate:Function/String/Object 用来判断是否执行的表达式、函数或其它对象 
	    @args	:Array(可选) 参数，要传递的任意多个参数
	    @return	:Function
	    */
	    where: function (predicate, params) {
	        predicate = fly.toFun(predicate, true)
	        var isFun = fly.isFun(predicate)
	        var old = this
	        var args = arguments.length > 1 ? slice.call(arguments, 1) : null;
	        return function () {
	            if (isFun ? predicate.apply(this, arguments) : predicate)
	                return old.apply(this, args || arguments)
	        }
	    },


	    /*	绑定域
	    @scope	:Object(可选) 域
	    @params	:Object(可选) 可变参数，要传递的任意多个参数
	    @return	:Function
	    */
	    bind: function (scope, params) {
	        var old = this;
	        var args = arguments.length > 1 ? slice.call(arguments, 1) : null;
	        return function () {
	            return old.apply(scope || win, args || arguments)
	        }
	    },


	    /*	格式化参数
	    如：fn.$format('@{2}','@{*}',12,"@{1,5}","@{2-6}")
	    @params:String/Object 可变参数，任意多个格式或参数
	    可以是定位参数的字符串"{1}"、"{*}"、"{2-6}"、或者任意对象
	    @return	:Function
	    */
	    format: function (params) {
	        var old = this;
	        var sendArgs = slice.call(arguments, 0)
	        var needFormat = false
	        for (var i = 0; i < arguments.length; i++)
	            if (fly.isString(arguments[i]) && /^@\{([\d\*\-\,]+)\}$/.test(arguments[i])) {
	                needFormat = true;
	                break
	            }


	        if (!needFormat) {
	            return function () {
	                return old.apply(this, sendArgs)
	            }
	        }


	        return function () {
	            var args = [].concat(sendArgs)
	            for (var i = 0; i < args.length; i++) {
	                var arg = args[i], ms;
	                if (fly.isString(arg) && (ms = arg.match(/^@\{([\d\*\-\,]+)\}$/))) {
	                    var str = ms[1]
	                    if (/^\d+$/.test(str)) {
	                        args[i] = arguments[str]
	                    }
	                    else {
	                        var as;
	                        if (str.indexOf(',') > -1) {
	                            as = eval("[arguments[" + str.replace(/^,|,$/g, '').replace(/,+/g, "],arguments[") + "]]")
	                        }
	                        else {
	                            var start = 0, end;
	                            if (str.indexOf('-') > -1) {
	                                var parts = str.split('-')
	                                start = parts[0]
	                                end = parts[1]
	                            }
	                            as = slice.call(arguments, start, (parseInt(end) + 1) || 1000)
	                        }
	                        args.splice.apply(args, [i, 1].concat(as))
	                        i += as.length - 1
	                    }
	                }
	            }
	            return old.apply(this, args)
	        }
	    },


	    /*	延迟执行
	    @millisecond:Int 延迟时间(毫秒)
	    @scope  :域
	    @params	:Object(可选) 可变参数，要传递的任意多个参数
	    @return	:Function
	    */
	    timeout: function (millisecond, scope, params) {
	        var old = this;
	        var args = arguments.length > 2 ? slice.call(arguments, 2) : null;
	        return old.handle = win.setTimeout(function () {
	            delete old.handle
	            old.apply(scope == null ? this : scope, args || arguments);
	        }, millisecond)
	    },


	    /*	清除延迟执行
	    @return	:Boolean
	    */
	    clearTimeout: function () {
	        if (this.handle) {
	            win.clearTimeout(this.handle)
	            delete this.handle
	        }
	    },


	    /*	生成延迟执行函数
	    @millisecond:Int 延迟时间(毫秒)
	    @scope  :域
	    @params:Object(可选) 可变参数，要传递的任意多个参数
	    @return	:Function
	    */
	    defer: function (millisecond, scope, params) {
	        var old = this;
	        var args = arguments.length > 2 ? slice.call(arguments, 2) : null;
	        var newF = function () {
	            var s = scope == null ? this : scope
	            args = args || arguments
	            newF.handle = old.handle = win.setTimeout(function () {
	                delete newF.handle
	                delete old.handle
	                old.apply(s, args);
	            }, millisecond)
	        }
	        return newF
	    },


	    //## onBefore
	    /*	在函数执行前执行一系列函数
	    @funs	:Function/Array<Function> 要执行的所有函数
	    @params	:Object(可选) 可变参数，要传递的任意多个参数
	    @return	:Function
	    */
	    onBefore: function (funs, params) {
	        var old = this;
	        funs = fly.toArray(funs).select(fly.toFun)
	        var args = arguments.length > 1 ? slice.call(arguments, 1) : null;
	        return function () {
	            try {
	                for (var i = 0; i < funs.length; i++)
	                    funs[i].apply(this, args || arguments)
	            }
	            catch (be) {
	                lib.Error.throwNotMessage(be, lib.Error.breakMessage)
	            }
	            return old.apply(this, arguments);
	        }
	    },


	    /*	将函数附加到对象的一个方法前执行
	    @obj		:被附加的对象
	    @methodName:String 对象被附加的方法
	    @params	:Object(可选) 可变参数，要传递的任意多个参数
	    @return	:Function
	    */
	    attachBefore: function (obj, methodName, params) {
	        if (!fly.isFun(obj[methodName]))
	            throw new Error(methodName + "不是有效的方法");
	        return obj[methodName] = obj[methodName].onBefore.apply(obj[methodName], [this].concat(slice.call(arguments, 2)))
	    },
	    //#end


	    //## onAfter
	    /*	在函数执行后执行一系列函数
	    @funs	:Function/Array<Function> 要执行的所有函数
	    @params	:Object(可选) 可变参数，要传递的任意多个参数
	    @return	:Function
	    */
	    onAfter: function (funs, params) {
	        var old = this;
	        funs = fly.toArray(funs).select(fly.toFun)
	        var args = arguments.length > 1 ? slice.call(arguments, 1) : null;
	        return function () {
	            var result = Function.result = Function.previousResult = old.apply(this, arguments);
	            try {
	                for (var i = 0; i < funs.length; i++)
	                    funs[i].apply(this, args || arguments)
	            }
	            catch (be) {
	                lib.Error.throwNotMessage(be, lib.Error.breakMessage)
	            }
	            return result;
	        }
	    },


	    /*	将函数附加到对象的一个方法后执行
	    @obj		:被附加的对象
	    @methodName:String 对象被附加的方法
	    @params	:Object(可选) 可变参数，要传递的任意多个参数
	    @return	:Function
	    */
	    attachAfter: function (obj, methodName, params) {
	        if (!fly.isFun(obj[methodName]))
	            throw new Error(methodName + "不是有效的方法");
	        return obj[methodName] = obj[methodName].onAfter.apply(obj[methodName], [this].concat(slice.call(arguments, 2)))
	    },
	    //#end


	    /*	继承
	    @base	:基类
	    @overrides:包含扩展成员的任意多个参数
	    @return	:this
	    */
	    inherit: function (base, overrides) {
	        var f = function () { }
	        f.prototype = fly.isFun(base) ? base.prototype : base
	        this.$base = fly.isFun(base) ? base : f
	        var fi = new f()
	        var myP = this.prototype;
	        this.prototype = fi;
	        fly.extend.apply(this, [this.prototype, myP].concat(slice.call(arguments, 1)))
	        this.prototype.constructor = this
	        return this
	    },


	    /*	扩展
	    @overrides:包含扩展成员的任意多个参数
	    @return	:this
	    */
	    extend: function (overrides) {
	        fly.extend.apply(this, [this.prototype].concat(slice.call(arguments, 0)))
	        return this
	    }
	}, lib.Function)
    fly.safeExtend("$", Function.prototype, lib.Function)
    //#end


    //## Date
    /*#C Data 扩展*/
    fly.lib.Date = fly.extend(
	{
	    /*	格式化日期
	    @format	:String 时间格式，默认 yyyy-MM-dd hh:mm:ss
	    @return	:String 
	    */
	    format: function (format) {
	        format = format || "yyyy-MM-dd HH:mm:ss";
	        var o =
			{
			    //年
			    "y+": this.getFullYear(),
			    //月
			    "M+": this.getMonth() + 1,
			    //日
			    "d+": this.getDate(),
			    //小时24
			    "H+": this.getHours(),
			    //小时12
			    "h+": this.getHours() % 12,
			    //分
			    "m+": this.getMinutes(),
			    //秒
			    "s+": this.getSeconds(),
			    //毫秒
			    "S+": this.getMilliseconds(),
			    //星期大写
			    "W+": "日一二三四五六".charAt(this.getDay()),
			    //星期小写
			    "w": "日123456".charAt(this.getDay())
			}

	        for (var k in o) {
	            format = format.replace(new RegExp(k, 'g'), function ($0) {
	                return o[k].toString().padLeft($0.length, '0')
	            })
	        }
	        return format;
	    }
	}, lib.Date)
    fly.safeExtend("$", Date.prototype, lib.Date)
    //#end


    //## String
    /*#C String 扩展*/
    fly.lib.String = fly.extend(
	{
	    formatReg: /\{([^{}]+)\}/g,
	    /*	格式化字符串，可以调用用最后一个参数的属性或者方法进行格式化
	    例如
	    "a{0}b{1}".format("-",5) 结果等于 "a-b5"
			
	    var option={id:123,name:"fly"};
	    "a{0}b {name}".format("-",5,option) 结果等于 "a-b fly"
			
	    var option={
	    getId:function(){
	    return 123
	    }
	    };
	    "a{0}b {getId()}".format("-",option) 结果等于 "a-b 123"
			
	    @params	:Object 可变参数，用来格式化的任意多个参数
	    @return	:String
	    */
	    format: function (params) {
	        var args = arguments
	        var lastArg = arguments[arguments.length - 1]
	        return this.replace(this.formatReg, function ($0, $1) {
	            var v = args[$1]
	            if (v == undefined && lastArg) {
	                if (/[^\w$]/.test($1))
	                    eval('v=lastArg.' + $1)
	                else
	                    v = lastArg[$1]
	            }
	            if (v == undefined)
	                return '';
	            while (fly.isFun(v))
	                v = v.call(lastArg)
	            return v
	        })
	    },


	    /*	字符串是否包含另一个字符串
	    @subStr	:要检查的子串
	    @ignoreCase:Boolean(可选) 忽略大小写,默认区分大小写
	    @return	:Boolean
	    */
	    contains: function (subStr, ignoreCase) {
	        if (subStr == null)
	            return false;


	        if (ignoreCase)
	            return this.toLowerCase().indexOf(subStr.toLowerCase()) > -1;
	        else
	            return this.indexOf(subStr) > -1;
	    },


	    /*	去掉左右空白 
	    @return	:String
	    */
	    trim: function () {
	        return this.replace(/(^\s+)|(\s+$)/g, "");
	    },
	    /*	去掉左空白 
	    @return	:String
	    */
	    trimLeft: function () {
	        return this.replace(/^\s+/g, "");
	    },

	    /*	去掉左空白 
	    @return	:String
	    */
	    trimRight: function () {
	        return this.replace(/\s+$/g, "");
	    },

	    /*	将第一个字母转换为大写
	    @return	:String
	    */
	    firstUpper: function () {
	        return this.charAt(0).toUpperCase() + this.substr(1)
	    },


	    /*	重复指定次数
	    @count	:Int 重复次数
	    @return	:String
	    */
	    repeat: function (count) {
	        var r = '';
	        while (count-- > 0)
	            r += this
	        return r
	    },


	    /*	填充左边到指定长度
	    @minLength:Int 最小长度
	    @_char	:String 用来填充不足的字符
	    @return	:String
	    */
	    padLeft: function (minLength, _char) {
	        return (_char == null ? ' ' : _char.toString()).$repeat(minLength - this.length) + this
	    },


	    /*	填充右边到指定长度
	    @minLength:最小长度
	    @_char	:String 用来填充不足的字符
	    @return	:String
	    */
	    padRight: function (minLength, _char) {
	        return this + (_char == null ? ' ' : _char.toString()).$repeat(minLength - this.length)
	    },
	    before: function (beforeStr) {
	        if (beforeStr == null) return this
	        return beforeStr + this;
	    },
	    after: function (afterStr) {
	        if (afterStr == null) return this
	        return this + afterStr;
	    },
	    camelCase: function (wordSplitChar) {
	        var str = this;
	        if (wordSplitChar && $.isString(wordSplitChar)) {
	            str = str.replace(new RegExp("\\" + wordSplitChar + "\\w", "g"), function ($1) {
	                return $1.charAt(1).toUpperCase()
	            })
	        }
	        return str.charAt(0).toLowerCase() + str.substr(1)
	    }
	}, lib.String)
    fly.safeExtend("$", String.prototype, lib.String)
    //#end


    //## fly.lib.Error
    fly.lib.Error = fly.extend(
	{
	    breakMessage: '@BREAKLOOP',
	    continueMessage: '@CONTINUE',
	    // 跳出循环	
	    breakLoop: fly.breakLoop = function () {
	        throw new Error(this.breakMessage)
	    },


	    //继续下次循环
	    continueLoop: fly.continueLoop = function () {
	        throw new Error(this.continueMessage)
	    },


	    //检测异常信息，异常信息不等时抛出异常
	    throwNotMessage: function (e, message) {
	        if (e == null || e.message != message)
	            throw e
	    },
	    error: function (msg) {
	        throw msg
	    }
	}, lib.Error)
    //#end


    //## fly.lib.Event
    /* #C path:fly.lib.Event
    事件处理器
    */
    fly.lib.EventManager = function () {
        var me = this
        this.event = null
        this.eventHash = {}
        this.stopPropagationReturnValue = false;

        this.btnMap = browser.isIE ?
		{
		    1: 0,
		    4: 1,
		    2: 2
		} : (browser.isWebKit ?
		{
		    1: 0,
		    2: 1,
		    3: 2
		} :
		{
		    0: 0,
		    1: 1,
		    2: 2
		});
        var spliceTypeName = function (eName) {
            var typeStart = eName.indexOf('.')
            var type = "";
            if (typeStart > -1) {
                type = eName.substr(typeStart + 1)
                eName = eName.substr(0, typeStart)
            }
            return { type: type, eName: eName }
        }

        //                 var ec = this.eventCls = function (e) {
        //                    this.browserEvent = e
        //                }
        //                var ps = ['altKey', 'altLeft', 'behaviorCookie', 'behaviorPart', 'bookmarks', 'boundElements', 'cancelBubble', 'clientX', 'clientY', 'contentOverflow', 'ctrlLeft', 'dataFld', 'dataTransfer', 'fromElement', 'nextPage', 'offsetX', 'offsetY', 'propertyName', 'qualifier', 'reason', 'recordset', 'repeat', 'returnValue', 'screenX', 'screenY', 'shiftKey', 'shiftLeft', 'srcElement', 'srcFilter', 'srcUrn', 'toElement', 'type', 'wheelDelta', 'x', 'y']
        //                fly.each(ps, function (p) {
        //                    ec.prototype[p] = function () {
        //                        return this.browserEvent[p]
        //                    }
        //                })
        //                var docE = doc.documentElement
        //                ec.extend({
        //                    pageXY: function () {
        //                        return { x: this.pageX(), y: this.pageY() }
        //                    },
        //                    pageX: function () {
        //                        return this.clientX() + docE.scrollLeft + doc.body.scrollLeft
        //                    },
        //                    pageY: function () {
        //                        return this.clientY() + docE.scrollTop + doc.body.scrollTop
        //                    }
        //                });
        var ps = "altKey attrChange attrName bubbles button cancelable charCode clientX clientY ctrlKey currentTarget data detail eventPhase fromElement handler keyCode layerX layerY metaKey newValue offsetX offsetY originalTarget pageX pageY prevValue relatedNode relatedTarget screenX screenY shiftKey srcElement target toElement view wheelDelta which".split(" ")
        var ec = this.eventCls = function (e) {
            this.browserEvent = e
            for (var i = 0; i < ps.length; i++)
                this[ps[i]] = e[ps[i]]
        }

        ec.extend({
            pageXY: function () {
                return { x: this.clientX + docE.scrollLeft + doc.body.scrollLeft,
                    y: this.clientY + docE.scrollTop + doc.body.scrollTop
                }
            }
        });

        //设置事件
        this.setEvent = function (e) {
            if (e == me.event || (e && e.browserEvent) || e == me.browserEvent) {
                return e;
            }
            win.$$event = fly.$$event = me.browserEvent = e;
            var evt = fly.$event = win.$event = me.$event = new this.eventCls(e)

            if (e) {
                // 鼠标键
                evt.button = e.button ? this.btnMap[e.button] : (e.which ? e.which - 1 : -1);
                if (e.type == 'click' && evt.button == -1)
                    evt.button = 0;
                // 是否按下Ctrl键
                evt.ctrlKey = e.ctrlKey || e.metaKey || false;
                //键盘按键
                evt.keyCode = e.keyCode == undefined ? e.which : e.keyCode
                // 事件源
                evt.target = e.srcElement || e.target
            }
            else {
                evt.button = -1;
                evt.shiftKey = false;
                evt.ctrlKey = false;
                evt.altKey = false;
                evt.keyCode = 0;
                evt.charCode = 0;
                evt.target = null;
            }
            return evt;
        }


        this.setEventToNull = function () {
            fly.$event = win.$event = me.event = null
            win.$$event = fly.$$event = null;
        }

        var on = function (el, eName, fn, scope, data) {
            var id = ui.DomHelper.getUniqueID(el)
            var eHash = me.eventHash[id]
            if (eHash == null) {
                me.eventHash[id] = eHash = { el: el }
            }
            var parts = spliceTypeName(eName)
            eName = parts.eName

            var hs = eHash[eName]

            if (hs == null) {
                eHash[eName] = hs = new Array()
                function h(evt) {
                    evt = evt || win.event
                    me.setEvent(evt)
                    me.fire(el, eName)
                    try {
                        me.setEventToNull(null)
                    } catch (e) { }
                    return evt.returnValue
                }

                hs.root = h;

                if (el.attachEvent)
                    el.attachEvent("on" + eName, h)
                else if (el.addEventListener)
                    el.addEventListener(eName, h, false)
                else if (!(("on" + eName) in el))
                    el["on" + eName] = h

            }
            fn = fly.toFun(fn)
            hs.unshift(
			        {
			            fn: fn,
			            scope: scope,
			            args: data,
			            type: parts.type
			        })
        }

        /*	添加事件
        @el	:Object/Array<Object> 一个或多个dom对象
        @eName	:String/Array<String> 一个或多个事件名
        @fn		:Function/Array<Function> 一个或多个处理函数
        @scope  :域
        @data	:Object(可选) 要传递的数据
        @return	:el
        */
        this.on = function (el, eName, fn, scope, data) {
            var isObj = fly.isObject(eName)
            if (arguments.length == 2 && !isObj) {
                return this.fire(el, eName);
            }
            isObj && (scope = fn)
            var dIndex = isObj ? 3 : 4
            data = arguments.length > dIndex ? slice.call(arguments, dIndex) : undefined
            if (!fly.likeArray(el) && !isObj && !fly.likeArray(eName) && !fly.likeArray(fn))
                return on(el, eName, fn, scope, data)

            var els = fly.toArray(el)
            if (isObj) {
                for (var i = 0; i < els.length; i++) {
                    var ei = els[i]
                    for (var k in eName) {
                        fn = eName[k]
                        if (fly.likeArray(fn))
                            for (var f = 0; f < fn.length; f++)
                                on(ei, k, fn[f], data)
                        else
                            on(ei, k, fn, data)
                    }
                }
            }
            else {
                var eNames = fly.toArray(eName), fns = fly.toArray(fn)
                for (var e = 0; e < els.length; e++) {
                    var ei = els[e]
                    for (var n = 0; n < eNames.length; n++) {
                        var name = eNames[n]
                        for (var f = 0; f < fns.length; f++)
                            on(ei, name, fns[f], scope, data)
                    }
                }
            }
            return this
        }

        this.bind = this.on

        /*	注销事件
        @el	:Object/Array<Object> 一个或多个dom对象
        @eName	:String/Array<String> 一个或多个事件名
        @fn		:Function/Array<Function> 一个或多个处理函数
        @return	:el
        */
        this.un = function (el, eName, fn) {
            if (fly.likeArray(el)) {
                for (var i = 0; i < el.length; i++)
                    me.un(el[i], eName, fn)
                return el
            }


            if (fly.likeArray(eName)) {
                for (var i = 0; i < eName.length; i++)
                    me.un(el, eName[i], fn)
                return el
            }
            var uid = ui.DomHelper.getUniqueID(el)
            var eHash = me.eventHash[uid]
            if (!eHash)
                return el


            function un(hs, fn, name, type) {
                if (fly.likeArray(fn)) {
                    for (var i = 0; i < fn.length; i++)
                        un(hs, fn[i], type)
                    return
                }

                if (fn != null)
                    fn = fly.toFun(fn)

                for (var i = hs.length - 1; i > -1; i--) {
                    if ((fn == null || hs[i].fn == fn) && (type === "" || type == hs[i].type)) {
                        hs[i] = null;
                        hs.splice(i, 1);
                    }
                }
                if (hs.length == 0) {
                    var el = eHash.el, root = eHash[name].root
                    if (root) {
                        el.detachEvent && el.detachEvent("on" + name, root)
                        el.removeEventListener && el.removeEventListener(name, root)
                        if (el["on" + name] == root)
                            el["on" + name] = null;
                    }
                    eHash[name] = null;
                    delete eHash[name]
                }
            }

            if (eName == null) {
                for (var en in eHash) {
                    if (en != "el")
                        un(eHash[en], fn, en, '', true)
                }
                eHash.el = null;
                me.eventHash[uid] = null
                delete me.eventHash[uid]
            }
            else {
                var parts = spliceTypeName(eName)
                var hs = eHash[parts.eName]
                if (!hs)
                    return el
                else
                    un(hs, fn, parts.eName, parts.type)
            }
            return this
        }


        /*	触发事件
        @el	:Object/Array<Object> 一个或多个dom对象
        @eName	:String/Array<String> 一个或多个事件名
        @scope  :域
        @args	:Array(可选) 可变参数，要传递的任意多个参数
        @return :el
        */
        this.fire = function (el, eName, scope, args) {
            me.stoped = false
            if (fly.likeArray(el)) {
                for (var i = 0; i < el.length; i++)
                    me.fire.apply(me, [el[i]].concat(slice.call(arguments, 1)))
                return el
            }


            if (fly.likeArray(eName)) {
                for (var i = 0; i < eName.length; i++)
                    me.fire.apply(me, [el, eName[i]].concat(slice.call(arguments, 2)))
                return el
            }


            var eHash = me.eventHash[ui.DomHelper.getUniqueID(el)]
            if (!eHash)
                return el

            var parts = spliceTypeName(eName)
            eName = parts.eName

            var hs = eHash[eName]
            if (!hs)
                return el
            var ret
            var args = arguments.length > 3 ? slice.call(arguments, 3) : null;
            for (var i = 0; i < hs.length; i++) {
                var h = hs[i]
                if (parts.type === "" || parts.type == h.type) {
                    ret = h.fn.apply(h.scope == null ? (scope == null ? el : scope) : h.scope, args || h.args || [el, me.event])
                    try {
                        if (el.nodeType) {
                            if (ret == me.stopPropagationReturnValue) {
                                lib.Event.stop()
                                break;
                            }
                            else if (me.stoped || (me.browserEvent && me.browserEvent.cancelBubble))
                                break
                        }
                        else if (ret == me.stopPropagationReturnValue)
                            break
                    } catch (e) { }
                }
            }
            return ret
        }

        /*	停止事件
        @return:Boolean false
        */
        this.stop = function () {
            var e = me.$event, be = me.browserEvent;
            me.stoped = true
            if (e) {
                e.cancelBubble = be.cancelBubble = true
                e.returnValue = be.returnValue = false
                if (be.stopPropagation)
                    be.stopPropagation()
                if (be.preventDefault)
                    be.preventDefault()
            }
            return this == me ? this : false
        }


        this.createEventFn = function (eName, fire) {
            var eName = eName.replace(/^on/i, '')
            eName = eName.charAt(0).toLowerCase() + eName.substr(1)
            return function () {
                if (arguments.length > 0)
                    return this.on.apply(this, [eName].concat(Array.prototype.slice.call(arguments, 0)))
                else if (fire)
                    return fire.call(this)
                else
                    this.fire(eName);
            }
        }

        /*	为对象注册事件
        @obj :要注册事件的对象
        @eventNames	:Array 要注册的任意多个事件名称
        @return	:@obj
        */
        this.registEvent = function (obj, eventNames) {
            var target = fly.isFun(obj) ? obj.prototype : obj
            this.eventAble(target)
            eventNames = fly.isString(eventNames) ? [eventNames] : eventNames
            for (var i = 0; i < eventNames.length; i++) {
                var e = eventNames[i];
                if (target[e] == null)
                    target[e] = this.createEventFn(e);
            }
            return this
        }

        this.eventAble = function (obj) {
            var target = fly.isFun(obj) ? obj.prototype : obj
            if (target.eventAble) return this
            if (!target.fire)
                target.fire = function () {
                    return me.fire.apply(this, [this].$addRange(arguments))
                }
            if (!target.on)
                target.on = function () {
                    return me.on.apply(this, [this].$addRange(arguments))
                }
            if (!target.un)
                target.un = function () {
                    me.un.apply(this, [this].$addRange(arguments))
                    return this
                }
            return this
        }

        this.destroy = function () {
            me.destroy = null;
            for (var k in me.eventHash)
                me.un(me.eventHash[k].el)
            destroy(me)
            me = null;
        }
    } .$inherit(lib.EventManager);

    //事件处理对象
    fly.Event = fly.lib.Event = new lib.EventManager()

    /*	绑定多个函数到 window.onload
    @fu	:Function 可变参数，要绑定的任意多个函数
    @return	:fly
    */
    fly.onLoad = function (fn, scope, data) {
        if (doc.readyState == "complete" || doc.readyState == "loaded") {
            var args = slice.call(arguments, 2);
            setTimeout(function () {
                if ($.likeArray(fn)) {
                    $.each(fn, function () {
                        this.apply(scope, args)
                    });
                }
                else
                    fn.apply(scope, args)
            });
        }
        else
            fly.Event.on.apply(fly.Event, [win, "load"].concat(arguments))
        return this
    }


    /*	绑定多个函数到 window.onload
    @fu	:Function 可变参数，要绑定的任意多个函数
    @return	:fly
    */
    fly.ready = function (fn, scope, data) {
        if (doc.readyState == "complete")
            return fly.onLoad.call(this, arguments)
        fly.initReady()
        fly.doc.on.apply(fly.doc, ["_readycomplete"].concat(arguments))
    }

    fly.initReady = function () {
        if (fly.initReady.invoked) return;
        fly.initReady.invoked = true;
        var eName = fly.Browser.isIE ? "readystatechange" : "DOMContentLoaded"
        var isReady = false, t = 0
        var fire = function () {
            if (isReady) return
            isReady = true
            clearInterval(t)
            fly.doc.un(eName)
            fly.doc.fire("_readycomplete")
            fly.doc.un("_readycomplete")
        }
        fly.doc.on(eName, function () {
            if ((/loaded|complete/).test(document.readyState))
                fire()
        })
        if (fly.Browser.isIE) {
            t = setInterval(function () {
                try {
                    docE.doScroll('left');
                    fire()
                } catch (e) { }
            }, 10);
        }
    }


    /*	绑定多个函数到	window.onunload
    @params	:Function(可选) 可变参数，要绑定的任意多个函数
    @return	:fly
    */
    fly.onUnload = function (params) {
        fly.Event.on(win, "unload", arguments)
        return fly
    }

    /*	绑定多个函数到	window.onBeforeUnload
    @params	:Function 可变参数，要绑定的任意多个函数
    @return	:fly
    */
    fly.onBeforeUnload = function (params) {
        fly.Event.on(win, "beforeunload", arguments)
        return fly
    }
    //#end

    //## fly.lib.Json
    /*#C path:fly.lib.Json
    Json工具
    */
    fly.lib.JsonUtils = function () {
        var me = this, useHasOwn = !!{}.hasOwnProperty;
        var m =
		{
		    "\b": '\\b',
		    "\t": '\\t',
		    "\n": '\\n',
		    "\f": '\\f',
		    "\r": '\\r',
		    '"': '\\"',
		    "\\": '\\\\'
		};
        var needJsonEncode = function (jsonEncode) {
            return jsonEncode === 0 || jsonEncode == null || jsonEncode > 0
        }

        var encodeString = function (s, jsonEncode) {
            s = encodeURIComponent(s)
            if (/["\\\x00-\x1f]/.test(s)) {
                return '"' + s.replace(/([\x00-\x1f\\"])/g, function (a, b) {
                    var c = m[b];
                    if (c) {
                        return c;
                    }
                    c = b.charCodeAt();
                    return "\\u00" + Math.floor(c / 16).toString(16) + (c % 16).toString(16);
                }) + '"';
            }
            if (needJsonEncode(jsonEncode))
                return '"' + s + '"';
            else return s
        };

        var encodeArray =
        /*	对集合进行编码
        @o   :Array 要编码的集合
        @jsonEncode  :Boolean 是否Json格式
        @return	:String
        */
 		this.encodeArray = function (o, jsonEncode) {
 		    var a = ["["], b,
			i,
			l = o.length, v;
 		    for (i = 0; i < l; i += 1) {
 		        v = o[i];
 		        switch (typeof v) {
 		            case "undefined":
 		            case "function":
 		            case "unknown":
 		                break;
 		            default:
 		                if (b) {
 		                    a.push(',');
 		                }
 		                a.push(v === null ? "null" : fly.Json.encode(v, jsonEncode));
 		                b = true;
 		        }
 		    }
 		    a.push("]");
 		    return a.join("");
 		};


        /*  对时间进行编码
        @o   :Date 要编码的时间对象
        @jsonEncode  :Boolean 是否Json格式,
        @return	:String
        */
        this.encodeDate = function (o, jsonEncode) {
            var t = o.$format("yyyy-MM-dd hh:mm:ss");
            return needJsonEncode(jsonEncode) ? '"' + t + '"' : t
        };


        /*  将对象编码
        @o   :要编码的对象
        @jsonEncode  :Boolean 是否Json格式,
        @return	:String
        */
        this.encode = function (o, jsonEncode) {
            var nje = fly.isNumber(jsonEncode) ? jsonEncode + 1 : jsonEncode
            if (o == null)
                return "null";
            else if (fly.likeArray(o))
                return encodeArray(o, nje);
            else if (fly.isDate(o))
                return fly.Json.encodeDate(o, jsonEncode);
            else if (fly.isString(o))
                return encodeString(o, jsonEncode);
            else if (fly.isNumber(o) || fly.isBoolean(o))
                return String(o)
            else {
                var a = ["{"], b,
				i,
				v;
                for (i in o) {
                    if (!useHasOwn || (o.hasOwnProperty && o.hasOwnProperty(i))) {
                        v = o[i];
                        switch (typeof v) {
                            case "undefined":
                            case "function":
                            case "unknown":
                                break;
                            default:
                                if (b)
                                    a.push(',');
                                a.push(me.encode(i), ":", v === null ? "null" : this.encode(v, nje));
                                b = true;
                        }
                    }
                }
                a.push("}");
                return a.join("");
            }
        };


        /*  对Json字符串解码
        @json   :要解码的Json对象	    
        @return	:String
        */
        this.decode = function (json) {
            var oJson = json;
            try {
                if (fly.isString(json))
                    return win.eval("(" + json + ")")
                return json;
            }
            catch (e) {
                if (oJson == "")
                    return ""
                win.eval(oJson)
            }
        },

        this.urlEncode = function (json, arrToParam, prefix, buf) {
            var fromSelf = !!buf
            buf = buf || []
            var isArr = fly.likeArray(json)
            var prefix = fly.isEmpty(prefix) ? "" : prefix
            if (!fly.likeArray(json) && !fly.isObject(json)) {
                var r = me.encode(json, -1)
                if (fromSelf)
                    buf.push("&", prefix, "=", r)
                return r
            }

            fly.each(json, function (val, key) {
                var v = isArr && !fromSelf ? val.value : val
                var k = prefix + encodeURIComponent(isArr ? (!fromSelf ? val.name || val.id : "") : key)
                if (arrToParam != false) {
                    if (fly.likeArray(v))
                        return fly.each(v, function () {
                            me.urlEncode(this, arrToParam, k, buf)
                        })
                    else if (fly.isObject(v))
                        return fly.each(v, function (item, key) {
                            me.urlEncode(this, arrToParam, k + "." + encodeURIComponent(key), buf)
                        })
                }
                buf.push("&", k, "=", me.encode(v, -1))
            })
            if (fromSelf) return
            if (buf.length) {
                buf.shift();
            }
            return buf.join('');
        },

        this.urlDecode = function (str, override) {
            if (fly.isEmpty(str))
                return {};

            var json = {}, kv, k, v, ov, j, ks
            fly.each(str.split('&'), function () {
                kv = this.split('=')
                k = decodeURIComponent(kv[0]);
                j = json
                ks = k.split(".");
                while (ks.length > 1) {
                    k = ks.shift()
                    j = j[k] = j[k] == null ? {} : j[k];
                }
                k = ks[0]
                v = kv[1];
                if (override || !j[k])
                    j[k] = v
                else if (fly.isArray(ov = j[k]))
                    ov[ov.length] = v
                else
                    j[k] = [ov, v]
            });
            return json;
        }


        /*	遍历每一项
        @json	:要遍历的对象
        @action	:Function 处理函数
        @params	:Object(可选) 可变参数，要传递的任意多个参数
        @return :json
        */
        this.each = function (json, action, params) {
            return qp.each.apply(json, slice.call(arguments, 1))
        }


        /*	将结果转换为数组
        @json	:要转换的数组
        @evaluator:Function/String/Object 计算值的函数
        @params	:Object(可选) 可变参数，要传递的多个参数
        @return	:Array
        */
        this.map = function (json, evaluator, params) {
            return qp.select.apply(json, slice.call(arguments, 1))
        }

        var getAccessors = {}, setAccessors = {}, propExpr = /^[\w\$]+$/
        this.getAccessor = function (expression) {
            if (fly.isString(expression)) {
                if (getAccessors[expression]) return getAccessors[expression]
                var accessor
                if (propExpr.test(expression))
                    accessor = function (o) { return o[expression] }
                else
                    accessor = new Function("__o", "with(__o){return " + expression + "}")
                return getAccessors[expression] = accessor
            }
            else if (fly.isNumber(expression))
                return function (o) { return o[expression] }
            else if (fly.isFun(expression))
                return expression;
            else return function () { return expression }
        }

        this.setAccessor = function (expression) {
            if (fly.isString(expression)) {
                if (setAccessors[expression]) return setAccessors[expression]
                var accessor
                if (propExpr.test(expression))
                    accessor = function (o, v) { o[expression] = v; }
                else
                    accessor = new Function("__o", "with(__o,__v){" + expression + "=__v}")
                return setAccessors[expression] = accessor
            }
            else if (fly.isNumber(expression))
                accessor = function (o, v) { o[expression] = v }
            else if (fly.isFun(expression))
                return expression;
        }
        this.destroy = destroy;
    } .$inherit(lib.JsonUtils);
    fly.Json = fly.lib.Json = new lib.JsonUtils()
    //#end


    //## fly.lib.Ajax
    var ajax = fly.lib.ajax = fly.ajax = function (option) {
        var helper = new ajax.Helper(option)
        if (arguments.length > 0 && fly.is(this, fly.lib.ajax) === false && helper.autoLoad != false)
            return helper.go();
        return helper;
    }

    ajax.Option = {
        url: location.href,
        type: "GET",
        dataType: "",
        async: true,
        parameterName: "par_{0}",
        dataType: undefined,
        dataFilter: undefined,
        contentType: "application/x-www-form-urlencoded",
        charset: "GB2312",
        username: undefined,
        password: undefined,
        timeout: -1,
        data: undefined
    }

    ajax.Helper = function (option) {
        this.option = fly.quickExtend({}, ajax.Option)
        this.setup(option)
    }

    ajax.Accepts = {
        xml: "application/xml, text/xml",
        html: "text/html",
        script: "text/javascript, application/javascript",
        json: "application/json, text/javascript",
        text: "text/plain",
        _default: "*/*"
    }

    ajax.Eevents = ["onStart", "onError", "onSuccess", "onComplete", "onSend", "onStop", "onReadystatechange"]
    fly.lib.Event.registEvent(ajax.Helper, ajax.Eevents);
    ajax.Helper.$extend(
 	{
 	    option: null,
 	    setup: function (option) {
 	        if (option) {
 	            for (var i = 0; i < ajax.Eevents.length; i++) {
 	                var e = ajax.Eevents[i]
 	                var le = e.charAt(2).toLowerCase() + e.substr(3)
 	                // 					if (this.option[le])
 	                // 						this.un(e,this.option[le])
 	                if (option[le])
 	                    this[e](option[le])
 	            }
 	            fly.extend(this.option, option)
 	        }
 	        return this;
 	    },
 	    get: function () {
 	        this.option.type = "GET"
 	        return this.go.apply(this, arguments)
 	    },
 	    post: function () {
 	        this.option.type = "POST"
 	        return this.go.apply(this, arguments)
 	    },
 	    go: function (url, data, callback) {
 	        var o = this.option
 	        if (arguments.length > 0) {
 	            this.url(url)
 	            if (fly.isFun(data)) {
 	                if (fly.isFun(callback))
 	                    data = data.call(this)
 	                else {
 	                    callback = data
 	                    data = undefined
 	                }
 	            }

 	            if (callback) this.onSuccess(callback)
 	            if (data) this.data(data)
 	        }

 	        var url = o.url.replace(/#.*$/, '')
 	        if (this.fire("start") === false) return this
 	        this.parseSendData()
 	        var isGet = o.type.toUpperCase() == "GET"
 	        if (isGet) {
 	            if (o.dataEncode !== "") url += (url.indexOf('?') > -1 ? "&" : "?") + o.dataEncode
 	            if (o.dataType === "script")
 	                return this.loadScript(url)
 	        }

 	        this.createConnecion();

 	        var conn = this.connection
 	        o.username != undefined ? conn.open(o.type, url, o.async, o.username, o.password) : conn.open(o.type, url, o.async);
 	        conn.setRequestHeader("Content-Type", o.contentType)
 	        conn.setRequestHeader("Charset", o.charset)
 	        if (!isGet)
 	            conn.setRequestHeader("Content-Length", o.dataEncode.length);

 	        conn.setRequestHeader("X-Requested-With", "XMLHttpRequest");
 	        conn.setRequestHeader("Accept", o.dataType && ajax.Accepts[o.dataType] ?
				ajax.Accepts[o.dataType] + ", */*" :
				ajax.Accepts._default);
 	        var c = this.createContext()
 	        conn.onreadystatechange = c.stateChange;
 	        if (this.fire("send", this, conn, o) === false) return this
 	        if (o.timeout > 0) {
 	            var startT = new Date()
 	            var h = setInterval(function () {
 	                if (c.isComplete)
 	                    clearInterval(h)
 	                else if ((new Date() - startT) >= o.timeout) {
 	                    clearInterval(h)
 	                    c.isTimeout = "timeout"
 	                    c.conn.abort()
 	                }
 	            }, 10);
 	        }

 	        conn.send(isGet ? null : o.dataEncode);
 	        if (!o.async) {
 	            c.stateChange()
 	            return this.getContent()
 	        }
 	        return this
 	    },
 	    createContext: function () {
 	        var context = { conn: this.connection, option: this.option, data: undefined, errMsg: undefined }
 	        var me = this, c = context;
 	        c.complete = function () {
 	            me.fire("complete", this, c.conn, c.option.status, c.data);
 	            me.fire("stop", this, c.conn, c.option);
 	        }

 	        c.stateChange = function () {
 	            me.fire("readystatechange", this, c.conn)
 	            if (!c.conn || c.conn.readyState === 0 || c.isTimeout === "abort") {
 	                if (!context.isComplete)
 	                    c.complete();

 	                c.isComplete = true;
 	                if (c.conn)
 	                    c.conn.onreadystatechange = fly.emptyFun;
 	            }

 	            if (!c.isComplete && c.conn && (c.conn.readyState === 4 || c.isTimeout == "timeout")) {
 	                context.isComplete = true;
 	                c.conn.onreadystatechange = fly.emptyFun;
 	                c.option.status = c.isTimeout === "timeout" ?
					    "timeout" :
					    !ajax.isSuccess(c.conn) ? "error" : "success";

 	                if (c.option.status === "success") {
 	                    try {
 	                        data = me.getContent();
 	                    } catch (ex) {
 	                        c.option.status = "parsererror";
 	                        errMsg = ex;
 	                    }
 	                }

 	                if (c.option.status === "success" || c.option.status === "notmodified")
 	                    me.fire("success", me, data, c.option.status, c.conn)
 	                else
 	                    me.fire("error", me, c.conn, c.option.status, c.errMsg)

 	                c.complete()
 	            }
 	        }
 	        return c;
 	    },
 	    loadScript: function (url) {
 	        var head = doc.getElementsByTagName("head")[0] || docE;
 	        var dom = doc.createElement("script");
 	        dom.src = url;
 	        var option = this.option
 	        if (option.charset)
 	            dom.charset = option.charset;
 	        var complete = false
 	        dom.onload = dom.onreadystatechange = function () {
 	            this.fire("readystatechange", this, dom)
 	            if (!complete && (!this.readyState || this.readyState === "loaded" || this.readyState === "complete")) {
 	                complete = true;
 	                this.fire("success", me, dom)
 	                this.fire("complete", me, dom, "success");
 	                dom.onload = dom.onreadystatechange = null;
 	                if (dom.parentNode)
 	                    dom.parentNode.removeChild(dom);
 	            }
 	        };
 	        head.appendChild(dom);
 	        return undefined;
 	    },
 	    getContent: function () {
 	        var conn = this.connection, option = this.option
 	        var dType = option.dataType || conn.getResponseHeader("content-type") || ""
 	        var isXml = /xml/i.test(dType)
 	        var data = isXml ? conn.responseXML : conn.responseText;

 	        if (isXml && data && data.documentElement && data.documentElement.nodeName === "parsererror")
 	            fly.lib.Error.error(option.status = "parsererror")

 	        if (option.dataFilter)
 	            data = option.dataFilter.call(this, data, option.dataType);

 	        if (typeof data === "string") {
 	            if (/json/i.test(dType))
 	                data = fly.lib.Json.decode(data);
 	            else if (/script/i.test(dType))
 	                fly.globalEval(data);
 	        }
 	        return data;
 	    },
 	    createConnecion: function () {
 	        if (win.XMLHttpRequest && (win.location.protocol !== "file:" || !win.ActiveXObject))
 	            this.connection = new XMLHttpRequest()
 	        else if (win.ActiveXObject)
 	            try {
 	                this.connection = new ActiveXObject("Msxml2.XMLHTTP");
 	            }
 	            catch (e) {
 	                this.connection = new ActiveXObject("Microsoft.XMLHTTP");
 	            }
 	    },
 	    parseSendData: function () {
 	        var data = this.option.data
 	        if (data == null) return this.option.dataEncode = "";
 	        var eName = this.option.jsonEncode ? "encode" : "urlEncode" ///POST/i.test(this.option.type)
 	        var buf = [];

 	        if (fly.isObject(data)) {
 	            for (var k in data)
 	                buf.push(escape(k) + "=" + escape(fly.Json[eName](data[k])))
 	        }
 	        else if (fly.likeArray(data)) {
 	            for (var i = 0; i < data.length; i++)
 	                buf.push(escape(this.option.parameterName.$format(i)) + "=" + escape(fly.Json[eName](data[i])))
 	        }

 	        return this.option.dataEncode = buf.join('&')
 	    },
 	    destroy: function () {
 	        this.destroy = null
 	        destroy(this.option)
 	        destroy(this)
 	    }
 	})


    ajax.isSuccess = function (conn) {
        try {
            var s = conn.status
            return !s && location.protocol === "file:" ||
				(s >= 200 && s < 300) ||
				s === 304 || s === 1223 || s === 0;
        } catch (e) { }

        return false;
    }

    fly.each(ajax.Option, function (o, k) {
        ajax.Helper.prototype[k] = function (value) {
            this.option[k] = value
            return this;
        }

        ajax[k] = function (value) {
            var helper = fly.is(this, ajax.Helper) ? this : new ajax.Helper()
            helper[k].apply(helper, arguments)
            return helper;
        }
    })

    fly.each(ajax.Eevents, function (eName) {
        ajax[eName] = function (fn) {
            var helper = fly.is(this, ajax.Helper) ? this : new ajax.Helper()
            helper[eName].apply(helper, arguments)
            return helper;
        }
    })

    fly.post = ajax.post = function () {
        var helper = new ajax.Helper()
        return helper.post.apply(helper, arguments)
    }

    ajax.get = function () {
        var helper = new ajax.Helper()
        return helper.get.apply(helper, arguments)
    }
    ajax.destroy = destroy
    //#end


    //## fly.Cookie
    /*#C Cookie 工具类*/
    fly.lib.Cookie = fly.Cookie = fly.extend(
	{
	    /*	设置Cookie
	    @name	:String cookie名
	    @value	:String cookie值
	    @expires:Date 过期时间
	    @path	:String 路径
	    @domain	:String 域
	    @secure	:Boolean 
	    @return	:fly.lib.Cookie
	    */
	    set: function (name, value, expires, path, domain, secure) {
	        var path = path == null ? '/' : path
	        doc.cookie = name + "=" + escape(value) + ((expires == null) ? "" : ("; expires=" + expires.toGMTString())) + ((path == null) ? "" : ("; path=" + path)) + ((domain == null) ? "" : ("; domain=" + domain)) + ((secure == true) ? "; secure" : "");
	        return fly.lib.Cookie
	    },


	    /*	获取Cookie
	    @path	:String 路径
	    @name	:String cookie名
	    @return	:String cookie 值
	    */
	    get: function (path, name) {
	        var cookie = doc.cookie
	        if (name != null) {
	            var start = cookie.search(new RegExp(path + "=", "gi"));
	            if (start < 0)
	                return
	            cookie = doc.cookie.substr(start + path.length + 1).replace(/;.*/g, "");
	        }
	        else
	            name = path
	        var start = cookie.search(new RegExp(name + "=", "gi"));
	        if (start < 0)
	            return
	        cookie = cookie.substr(start + name.length + 1).replace(/&.*/g, "");
	        return unescape(cookie);
	    },


	    /*	删除 Cookie
	    @name	:String cookie名
	    @return	:fly.lib.Cookie
	    */
	    remove: function (name) {
	        if (Cookies.get(name))
	            doc.cookie = name + "=" + "; expires=Thu, 01-Jan-70 00:00:01 GMT";
	        return fly.lib.Cookie
	    }
	}, fly.lib.Cookie)
    //#end


    //## fly.ui.Style
    /* #C path:fly.ui.Style
    CSS 工具类
    */
    fly.ui.StyleUtils = function () {
        var me = this
        this.loadCss = function (url) {
            var el = doc.createElement("link");
            el.rel = "stylesheet"
            el.type = "text/css"
            el.href = url;
            (doc.getElementsByTagName("head")[0] || docE).appendChild(el)
            return el
        }

        this.defaultSheet = function () {
            return me.sheet || (me.sheet = me.createStyleSheet())
        }

        this.createStyleSheet = function (cssText) {
            var style
            if (doc.createStyleSheet) {
                (style = doc.createStyleSheet()).cssText = cssText;
                style.cssRules = style.rules
            }
            else {
                style = doc.createElement('style');
                style.type = 'text/css';
                try {
                    style.innerHTML = cssText || "";
                } catch (e) { }
                ; (doc.getElementsByTagName("head")[0] || docE).appendChild(style)
                style = style.sheet
                style.rules = style.cssRules
            }
            return style
        }

        this.createCssRule = function (sheet, name, cssText) {
            try {
                sheet.addRule(name, cssText || " ")
            } catch (e) {
                sheet.insertRule("" + name + " { " + cssText + " }", sheet.cssRules.length);
            }
            return sheet.rules[sheet.rules.length - 1];
        }

        /*	获取元素当前样式
        @el		:Object 元素
        @return	:currentStyle
        */
        this.currentStyle = function (el) {
            return el.currentStyle || doc.defaultView.getComputedStyle(el, null)
        }

        /*	检测样式值
        @name	:String 样式名
        @value	:Object 样式值
        @return :Object 经处理过后的属性值
        */
        this.checkValue = function (name, value) {
            if ((value || value === 0) && /width|height|top|left|right|bottom|margin|padding/i.test(name)) {
                value = value.toString();
                if (value.indexOf('px') < 0)
                    value = value.replace(/[\d.]+/g, function ($1) {
                        return $1 + 'px'
                    })
            }
            return value
        }


        /*	获取元素样式
        @el		:Object 要获取样式的元素
        @name	:String 要设置的样式名
        @return	:String 属性值
        */
        this.get = function (el, name) {
            var camel = camelCase(name)
            if (me.setters[camel])
                return me.getters[camel](el, name)

            var currentStyle = me.currentStyle(el);
            var ret = currentStyle[camel] || currentStyle[name];
            if (!ret || ret == "auto") {
                if (name == "width")
                    ret = el.offsetWidth
                else if (name == "height")
                    ret = el.offsetHeight
            }
            return ret
        }

        this.num = function (el, name) {
            return Number((me.get(el, name) + " ").replace(/[^\d-\.]/g, "")) || 0
        }

        /*	设置元素样式
        @el		:Object 被设置样式的元素
        @name	:String 要设置的样式名
        @value	:Object 样式值
        @return	:fly.ui.Style
        */
        this.set = function (el, name, value) {
            var camel = camelCase(name)
            if (me.setters[camel])
                me.setters[camel](el, name, value)
            else {
                if (value == null)
                    el.style[fly.diffAttrs.styleRemoveMethod](camel)
                else
                    el.style[camel] = me.checkValue(camel, value);
            }
            return me
        }

        this.getters =
 		        {
 		            opacity: function (el, name) {
 		                var style = me.currentStyle(el)
 		                var value = 100;
 		                (el.style.filter || "").replace(/alpha\([^)]*(\d+)[^)]*\)/, function ($0, $1) {
 		                    value = parseInt($1)
 		                })
 		                return isNaN(value) ? 100 : value
 		            }
 		        }

        this.setters =
 		        {
 		            opacity: function (el, name, value) {
 		                value = parseInt(value)
 		                el.style.filter = (el.style.filter || "").replace(/alpha\([^)]*\)/, "") +
					        (isNaN(value) || isNaN == 100 ? "" : "alpha(opacity=" + value + ")");
 		            }
 		        }
        if (fly.Browser.isFirefox || fly.Browser.isOpera) {
            this.getters.backgroundPositionX = function (el, name, value) {
                return me.get(el, "backgroundPosition").replace(/\s+.+$/, '')
            }
            this.getters.backgroundPositionY = function (el, name, value) {
                return me.get(el, "backgroundPosition").replace(/^.+\s+/, '')
            }

            this.setters.backgroundPositionX = function (el, name, value) {
                me.set(el, "backgroundPosition", value + " " + me.get(el, "backgroundPositionY"))
            }
            this.setters.backgroundPositionY = function (el, name, value) {
                me.set(el, "backgroundPosition", me.get(el, "backgroundPositionX") + " " + value)
            }
        }
    } .inherit(ui.StyleUtils);

    //样式处理
    fly.Style = fly.ui.Style = new ui.StyleUtils();
    var styleHelper = fly.ui.Style
    //#end


    //## fly.ui.DomHelper
    /*#C path:fly.ui.DomHelper
    Dom 工具类
    */
    fly.ui.DomUtils = function () {
        var tempTableEl = null, emptyTags = /^(?:br|frame|hr|img|input|link|meta|range|spacer|wbr|area|param|col)$/i, tableRe = /^table|tbody|tr|td$/i, pub,
        // kill repeat to save bytes
		afterbegin = "afterbegin", afterend = "afterend", beforebegin = "beforebegin", beforeend = "beforeend", ts = '<table>', te = '</table>', tbs = ts + '<tbody>', tbe = '</tbody>' + te, trs = tbs + '<tr>', tre = '</tr>' + tbe;
        var rTagName = /<([\w:]+)/
        var onlyTag = /^<(\w+)\s*\/?>(?:<\/\1>)?$/
        var sTagWraps = {
            option: [1, "<select multiple='multiple'>", "</select>"],
            legend: [1, "<fieldset>", "</fieldset>"],
            thead: [1, "<table>", "</table>"],
            tr: [2, "<table><tbody>", "</tbody></table>"],
            td: [3, "<table><tbody><tr>", "</tr></tbody></table>"],
            col: [2, "<table><tbody></tbody><colgroup>", "</colgroup></table>"],
            area: [1, "<map>", "</map>"],
            _default: [0, "", ""]
        };

        sTagWraps.optgroup = sTagWraps.option;
        sTagWraps.tbody = sTagWraps.tfoot = sTagWraps.colgroup = sTagWraps.caption = sTagWraps.thead;
        sTagWraps.th = sTagWraps.td;


        var me = this
        me.uniqueNumber = 1

        var emptyElement = doc.createElement('div')
        var getDom = this.getDom = function (obj) {
            obj = obj.single || obj
            return obj
        }


        var getRoot = this.getRoot = function (obj) {
            return fly.is(obj, ui.Element) ? obj.root.single : (obj.single || obj)
        }


        var getInner = this.getInner = function (obj) {
            return ui.Element && fly.is(obj, ui.Element) ? obj.inner.single : (obj.single || obj)
        }

        /*	获取元素唯一ID
        @el	:Object Dom元素
        @return	:Int 元素ID
        */
        this.getUniqueID = function (el) {
            el = el == doc ? docE : el
            return el.uniqueNumber != undefined ? el.uniqueNumber : (el.uniqueNumber = "$" + me.uniqueNumber++)
        }

        /*	根据Html创建dom元素
        @html	:String html字符串
        @return	:Object/Array<Object> 创建的dom元素
        */
        this.create = function (html) {
            if (html === "" || html == null)
                return
            if (!fly.isString(html)) {
                if (!fly.isString(html = fly.ifFun(html)))
                    return html
            }
            var tag = onlyTag.exec(html);

            if (tag) {
                return new Array(doc.createElement(tag[1]));
            }
            else {
                if (!fly.isHtml(html))
                    return new Array(context.createTextNode(html));
            }

            var tw, p = emptyElement, tag = rTagName.exec(html)
            if (tag && (tw = sTagWraps[tag[1].toLowerCase()])) {
                p.innerHTML = tw[1] + html + tw[2]
                var i = 0
                while (i++ < tw[0])
                    p = p.firstChild;
            }
            else {
                p.innerHTML = html;
            }

            var ret = p.childNodes.length > 1 ? fly.toArray(p.childNodes) : new Array(p.childNodes[0])
            for (var i = p.childNodes.length - 1; i > -1; i--)
                p.removeChild(p.childNodes[i])
            return ret
        }


        /*	插入对象
        @pos	:String 插入位置(beforeBegin,afterBegin,beforeEnd,afterEnd)
        @parent	:Object 父元素
        @child	:Object/Array<Object> 子元素
        @returnDom:Boolean 是否返回dom元素
        @return	:Object/Array returnDom等于true返回dom对象，否则返回包含该元素的集合
        */
        this.doInsert = function (pos, parent, child, returnDom) {
            var result
            if (fly.likeArray(parent)) {
                for (var i = 0; i < parent.length; i++)
                    result = arguments.callee(pos, parent[i], child, returnDom)
                return result;
            }

            if (fly.likeArray(child)) {
                for (var i = 0; i < child.length; i++)
                    result = arguments.callee(pos, parent, child[i], returnDom)
                return result;
            }

            var p = getInner(parent);
            var isHtml = fly.isString(child)

            if (p.insertAdjacentElement)
                result = p[isHtml ? "insertAdjacentHTML" : "insertAdjacentElement"](pos, child)
            else {
                var child = result = isHtml ? me.create(child) : child
                if (fly.likeArray(child)) {
                    result = new Array()
                    fly.each(function (o) {
                        result.push(me.doInsert(pos, p, o))
                    })
                }
                else {
                    switch (pos.toLowerCase()) {
                        case "beforebegin":
                            p.parentNode.insertBefore(child, p);
                            break;
                        case "afterbegin":
                            p[p.firstChild ? "insertBefore" : "appendChild"](child, p.firstChild);
                            break;
                        case "beforeend":
                            p.appendChild(child);
                            break;
                        case "afterend":
                            if (p.nextSibling)
                                p.parentNode.insertBefore(child, p.nextSibling);
                            else
                                p.parentNode.appendChild(child);
                            break;
                    }
                }
            }
            return returnDom == true ? result : fly(result)
        }

        /*	构造Table HTML
        @rowCount	:Int 行数
        @colCount	:Int 列数
        @tableProperties:String <table>标签的其它属性
        @rowProperties:String <tr>标签的其它属性
        @cellProperties:String <td>标签的其它属性
        @return	:String HTML字符串
        */
        this.createTableHtml = function (rowCount, colCount, tableProperties, rowProperties, cellProperties) {
            return "<table " + (tableProperties || '') + " >" + ("<tr " + (rowProperties || '') + " >" + ("<td " + (cellProperties || '') + "></td>").$repeat(colCount) + "</tr>").$repeat(rowCount) + "</table>"
        }

        /*	构造Table
        @rowCount	:Int 行数
        @colCount	:Int 列数
        @tableProperties:String <table>标签的其它属性
        @rowProperties:String <tr>标签的其它属性
        @cellProperties:String <td>标签的其它属性
        @return	:Object HTML Table 对象
        */
        this.createTable = function (rowCount, colCount, tableProperties, rowProperties, cellProperties) {
            return me.create(me.createTableHtml(rowCount, colCount, tableProperties, rowProperties, cellProperties))
        }

        /* 在元素前插入对象
        @el	:在该元素前插入对象
        @dom:Object/Array<Object> 要插入的一个或多个Dom元素
        @returnDom:Boolean 是否返回dom元素
        @return	:Object/Array returnDom等于true返回dom对象，否则返回包含该元素的集合
        */
        this.insertBefore = function (el, dom, returnDom) {
            return me.doInsert(beforebegin, el, dom, returnDom);
        }


        /* 在元素后插入对象
        @el	:在该元素后插入对象
        @dom:Object/Array<Object> 要插入的一个或多个Dom元素
        @returnDom:Boolean 是否返回dom元素
        @return	:Object/Array returnDom等于true返回dom对象，否则返回包含该元素的集合
        */
        this.insertAfter = function (el, dom, returnDom) {
            return me.doInsert(afterend, el, dom, returnDom);
        }


        /* 在元素开始位置插入对象
        @el	:在该元素开始位置插入对象
        @dom:Object/Array<Object> 要插入的一个或多个Dom元素
        @returnDom:Boolean 是否返回dom元素
        @return	:Object/Array returnDom等于true返回dom对象，否则返回包含该元素的集合
        */
        this.insertFirst = function (el, dom, returnDom) {
            return me.doInsert(afterbegin, el, dom, returnDom);
        }



        /* 将元素附加到一个对象结尾
        @el	:在该元素结束位置插入对象
        @dom:Object/Array<Object> 要插入的一个或多个Dom元素
        @returnDom:Boolean 是否返回dom元素
        @return	:Object/Array returnDom等于true返回dom对象，否则返回包含该元素的集合
        */
        this.append = function (el, dom, returnDom) {
            return me.doInsert(beforeend, el, dom, returnDom);
        }

        /*	获取该Dom元素的子元素，不含 #text 
        @dom	:要获取子元素的Dom元素
        @return	:Array 元素的所有子元素
        */
        this.children = function (dom) {
            if (dom.children || (dom == doc ? (dom = docE).children : false))
                return dom.children
            return fly.toArray(dom.childNodes).where("o=>o.nodeType==1")
        }

        /* 将所有内容转移至另一个元素
        */
        this.moveContent = function (from, to) {
            var c;
            while (c = from.childNodes[0])
                to.appendChild(c)
            return from;
        }

        this.empty = function (el) {
            if (el) {
                var c;
                while (c = el.childNodes[0])
                    el.removeChild(c)
            }
        }

        /*	添加CSS样式
        @dom    :Element dom 元素
        @css	:String 要添加的CSS名称
        @return	:this
        */
        this.addClass = function (dom, css) {
            if (css == null || css == "") return this
            if (arguments.length == 1)
                css = dom, dom = this;
            if (dom.isIEnumerable)
                dom.$each(function (o) {
                    o.className += ' ' + css
                })
            else
                dom.className += ' ' + css
            return this
        }

        /*	移除CSS样式
        @dom    :Element dom 元素
        @css	:String 要移除的CSS名称
        @return	:this
        */
        this.removeClass = function (dom, css) {
            if (arguments.length == 1)
                css = dom, dom = this;
            function r(o) {
                if (css == null)
                    return o.className = "";
                if (this == "") return;

                var c = " " + o.className.replace(/\s+/g, ' ') + " "
                while (c.indexOf(this) > -1)
                    c = c.replace(this, " ")
                c = c.$trim().replace(/\s+/g, ' ');
                o.className = c;
            }

            var csss = (css || '').split(/\s+/g)
            for (var i = 0; i < csss.length; i++) {
                var rcss = " " + csss[i] + " ";
                if (dom.isIEnumerable) {
                    dom.$each(r, rcss)
                }
                else {
                    r.call(rcss, dom);
                }
            }
            return this
        }

        /*	是否包含某一CSS名称
        @dom    :Element dom 元素
        @css	:String 要检测的CSS名称
        @return	:this
        */
        this.hasClass = function (dom, css) {
            if (arguments.length == 1)
                css = dom, dom = this;
            if (dom.isIEnumerable)
                dom = dom.item(0)
            if (dom)
                return (" " + dom.className.replace(/\s+/g, ' ') + " ").indexOf(' ' + css + ' ') > -1
            return false
        }

        this.clone = function (el) {
            if (el.isIEnumerable) {
                var nEl = $.create();
                el.each(function () {
                    nEl.push(this.cloneNode(true))
                })
                return nEl;
            }
            return el.cloneNode();
        }

        this.toHtml = function (el) {
            if (el.isIEnumerable) {
                return el.select(me.toHtml).join("");
            }
            return el.outerHTML;
        }

        if (doc.compareDocumentPosition)
            this.contains = function (parent, child) {
                return !!(parent.compareDocumentPosition(child) & 16);
            }
        else
            this.contains = function (parent, child) {
                return parent !== child && (parent.contains ? parent.contains(child) : true);
            }

        this.focusable = function (dom) {
            var el = dom
            if (el.disabled)
                return false
            var nodeName = el.nodeName
            var tabIndex = me.tabIndex(el);
            if (!isNaN(tabIndex) || fly.foucsableTypeRegs.test(nodeName) || (fly.clickableTypeRegs.test(nodeName) && el.href))
                if ([dom]['AREA' == nodeName ? 'parents' : 'closest'](':hidden').length == 0)
                    return true
                return false
            }

            this.tabbable = function (dom) {
                var tabIndex = me.tabIndex(dom);
                return (isNaN(tabIndex) || tabIndex >= 0) && me.focusable(dom)
            }

            this.isVisible = function (dom) {
                return styleHelper.get(dom, 'visibility') !== "hidden"
            }

            this.isDisplay = function (dom) {
                return styleHelper.get(dom, 'display') !== 'none'
            }

            this.isHidden = function (dom) {
                return (dom.nodeName === 'INPUT' && dom.type === 'hidden') || !me.isDisplay(dom) || !me.isVisible(dom)
            }

            this.tabIndex = fly.attrGeters.tabindex = function (dom) {
                var node = dom.getAttributeNode("tabindex");
                if (node != null && node.specified)
                    return node.value;
                return fly.foucsableTypeRegs.test(dom.nodeName) || (fly.clickableTypeRegs.test(dom.nodeName) && dom.href) ? 0 : undefined;
            }

            this.clearSelection = function () {
                try {
                    if (document.selection)
                        document.selection.empty()
                    else
                        window.getSelection().removeAllRanges();
                } catch (e) { }
            }

        } .inherit(ui.DomUtils)
        fly.DomHelper = fly.ui.DomHelper = new ui.DomUtils()
        dh = fly.ui.DomHelper
        //#end


        //## fly.collection.IEnumerable
        /*#C path:fly.collection.IEnumerable
        用来扩展 collection 对象
        */
        fly.collection.IEnumerable = fly.fn = qp =
	{
	    allTypes: new Array(),
	    extend: function (name, fn) {
	        var memberMap = name;
	        if (fly.isString(name)) {
	            memberMap = {};
	            memberMap[name] = fn
	        }

	        fly.extend(this, memberMap)
	        if (this == qp) {
	            fly.each(qp.allTypes, function () {
	                fly.extend(this.prototype || this, memberMap)
	            });
	        }
	        return this
	    },

	    applyTo: function ($class, overrides) {
	        if (this == qp)
	            qp.allTypes.push($class)
	        fly.safeExtend("$", $class.prototype || $class, this)
	        for (var i = 1; i < arguments.length; i++)
	            fly.extend($class.prototype || $class, arguments[i])
	        $class.prototype.$type = $class
	        return this
	    },

	    /*	Class 原始类型*/
	    $type: null,

	    /*	创建新的实例
	    @arr	:Array 初始元素
	    @return	:IEnumerable IEnumerable新对象
	    */
	    $create: function (arr) {
	        return new this.$type(arr)
	    },

	    /*	Boolean fly.collection.IEnumerable标识*/
	    isIEnumerable: true,

	    /*	获取可遍历的对象
	    @obj:如果传递该参数，这获取该对象的可遍历对象，否则返回当前对象的可遍历对象
	    @return:Array
	    */
	    getItems: function (obj) {
	        if (arguments.length == 1) {
	            if (obj.getItems)
	                obj = obj.getItems()
	            return fly.toArray(obj)
	        }
	        return this.items || this
	    },

	    /*	更新长度
	    @return	:this
	    */
	    updateLength: function () {
	        if (this.items)
	            this.length = this.items.length
	        return this
	    },

	    /*	获取指定位置的项
	    @index	:Int 从0开始的索引
	    @return :Object
	    */
	    item: function (index) {
	        return this.getItems()[index]
	    },

	    //##
	    /*	生成一个新IEnumerable对象
	    @evaluator:计算值的函数
	    @scope  :域
	    @params	:Object(可选) 可变参数，要传递的任意多个参数,
	    @return	:IEnumerable
	    */
	    select: function (evaluator, scope, params) {
	        var result = new Array();
	        var items = this.getItems ? this.getItems() : this
	        var fn = fly.toFun(evaluator, true)
	        var isFun = fly.isFun(fn)
	        var as = arguments
	        var hasArg = as.length > 2
	        if (as.length > 11)
	            var args = arrP.slice.call(as, 2)
	        else if (hasArg)
	            var p2 = as[2], p3 = as[3], p4 = as[4], p5 = as[5], p6 = as[6], p7 = as[7], p8 = as[8], p9 = as[9], p10 = as[10]
	        try {
	            if (fly.likeArray(items)) {
	                for (var i = 0, len = items.length; i < len; i++) {
	                    try {
	                        var item = items[i]
	                        result.push(isFun ? (hasArg ? (args != null ? fn.apply(scope || item, [item, i, items].concat(args)) : fn.call(scope || item, item, i, items, p2, p3, p4, p5, p6, p7, p8, p9, p10)) : fn.call(scope || item, item, i, items)) : fn);
	                    }
	                    catch (ce) {
	                        lib.Error.throwNotMessage(ce, lib.Error.continueMessage)
	                    }
	                }
	            }
	            else {
	                for (var i in items) {
	                    try {
	                        var item = items[i]
	                        result.push(isFun ? (hasArg ? (args != null ? fn.apply(scope || item, [item, i, items].concat(args)) : fn.call(scope || item, item, i, items, p2, p3, p4, p5, p6, p7, p8, p9, p10)) : fn.call(scope || item, item, i, items)) : fn);
	                    }
	                    catch (ce) {
	                        lib.Error.throwNotMessage(ce, lib.Error.continueMessage)
	                    }
	                }
	            }
	        }
	        catch (be) {
	            lib.Error.throwNotMessage(be || ce, lib.Error.breakMessage)
	        }
	        return this.create ? this.create(result) : result
	    },


	    /*	从序列的开头返回指定数量的连续元素
	    @count:int 要获取的数量，可以是负整数。
	    isAssending	: Boolean 是否升序
	    @predicate	:Function/String/Object 用于测试每个元素是否满足条件的函数。
	    @params	:Object(可选) 可变参数，要传递的任意多个参数
	    @return	:IEnumerable
	    */
	    take: function (count, isAscending, predicate, params) {
	        this.___count = count
	        this.___isAsc = isAscending
	        return (this.___take || qp.___take).apply(this, arrP.slice.call(arguments, 2))
	    },
	    ___take: function (predicate, params) {
	        var items = this.getItems ? this.getItems() : this
	        var result = new Array()
	        if (items.length > 0) {
	            var count = this.___count;
	            count = count == null ? 100000000000 : (count < 0 ? this.length + count : count)
	            var isAsc = this.___isAsc;
	            var isNot = this.___isNot == true
	            var as = arguments
	            var hasArg = as.length > 1
	            if (as.length > 11)
	                var args = arrP.slice.call(as, 1)
	            else if (hasArg)
	                var p1 = as[1], p2 = as[2], p3 = as[3], p4 = as[4], p5 = as[5], p6 = as[6], p7 = as[7], p8 = as[8], p9 = as[9], p10 = as[10]
	            var fn = fly.toFun(predicate, true)
	            if (fn === undefined)
	                fn = true
	            var isFun = fly.isFun(fn)
	            try {
	                var step = isAsc != false ? 1 : -1
	                for (var i = (isAsc != false ? 0 : items.length - 1), end = (isAsc != false ? items.length : -1); i != end && result.length < count; i += step) {
	                    var item = items[i];
	                    if (isNot ^ !!(isFun ? (hasArg ? (args != null ? fn.apply(item, [item, i, items].concat(args)) : fn.call(item, item, i, items, p1, p2, p3, p4, p5, p6, p7, p8, p9, p10)) : fn.call(item, item, i, items)) : fn))
	                        result.push(item);
	                }
	            }
	            catch (be) {
	                lib.Error.throwNotMessage(be, lib.Error.breakMessage)
	            }
	        }
	        delete this.___count
	        delete this.___isAsc
	        delete this.___isNot
	        return this.create ? this.create(result) : result
	    },
	    //#end

	    //## 遍历所有项
	    /*	遍历所有项
	    @action	:Function/String/Object 处理每一项的回调函数
	    @params	:Object(可选) 可变参数，要传递的任意多个参数
	    @return	:this
	    */
	    each: function (action, scope, params) {
	        var fn = fly.toFun(action, true)
	        if (!fly.isFun(fn))
	            return this
	        var as = arguments
	        var hasArg = as.length > 1
	        if (as.length > 11)
	            var args = arrP.slice.call(as, 2)
	        else if (hasArg)
	            var p2 = as[2], p3 = as[3], p4 = as[4], p5 = as[5], p6 = as[6], p7 = as[7], p8 = as[8], p9 = as[9], p10 = as[10]

	        var items = this.getItems ? this.getItems() : this
	        try {
	            if (fly.likeArray(items)) {
	                for (var i = 0; i < items.length; i++) {
	                    var item = items[i]
	                    try {
	                        if (!hasArg)
	                            fn.call(scope || item, item, i, items)
	                        else if (args != null)
	                            fn.apply(scope || item, [item, i, items].concat(args))
	                        else
	                            fn.call(scope || item, item, i, items, p2, p3, p4, p5, p6, p7, p8, p9, p10)
	                    }
	                    catch (ce) {
	                        lib.Error.throwNotMessage(ce, lib.Error.continueMessage)
	                    }
	                }
	            }


	            else {
	                for (var i in items) {
	                    var item = items[i]
	                    try {
	                        if (!hasArg)
	                            fn.call(scope || item, item, i, items)
	                        else if (args != null)
	                            fn.apply(scope || item, [item, i, items].concat(args))
	                        else
	                            fn.call(scope || item, item, i, items, p2, p3, p4, p5, p6, p7, p8, p9, p10)
	                    }
	                    catch (ce) {
	                        lib.Error.throwNotMessage(ce, lib.Error.continueMessage)
	                    }
	                }
	            }
	        }
	        catch (be) {
	            lib.Error.throwNotMessage(be || ce, lib.Error.breakMessage)
	        }
	        return this;
	    },
	    //#end


	    /*	得到一个不重复的集合
	    comparer:Function 一个对值进行比较的相等比较器
	    @return	:IEnumerable
	    */
	    uniquelize: function (comparer) {
	        var result = new Array();
	        this.$each(function (o) {
	            if (!result.contains(o, comparer))
	                result.push(o);
	        })
	        return this.create ? this.create(result) : result
	    },

	    /*	返回不在指定集合中的元素
	    @iEnumerable :用来比较的另一个集合
	    @comparer:Function 一个对值进行比较的相等比较器
	    @return	:IEnumerable 
	    */
	    notIn: function (iEnumerable, comparer) {
	        return this.where(function (o) {
	            return iEnumerable.indexOf(o, 0, comparer) < 0
	        })
	    },


	    /*	返回两个集合的交集
	    @iEnumerable :用来求交集的另一个集合
	    @comparer:Function 一个对值进行比较的相等比较器
	    @return	:IEnumerable 连个集合的交集
	    */
	    intersect: function (iEnumerable, comparer) {
	        return this.where(function (o) {
	            return iEnumerable.indexOf(o, 0, comparer) > -1
	        })
	    },

	    /*	转换为Json
	    @keySelector	:Function 用于从每个元素中提取键的函数。
	    @valueSelector	:Function 用于从每个元素产生结果元素值的转换函数。
	    return :Json
	    */
	    toJson: function (keySelector, valueSelector) {
	        var json = {};
	        keySelector = fly.toFun(keySelector, true)
	        valueSelector = fly.toFun(valueSelector, true)
	        if (keySelector == null && valueSelector == null) {
	            var all = this.getItems()
	            arrP.push.apply({}, all)
	            return json
	        }
	        this.$each(function (item, i, all) {
	            json[keySelector == null ? i : keySelector.call(item, item, i, all)] = valueSelector == null ? item : valueSelector.call(item, item, i, all)
	        })
	        return json
	    },

	    /*	为每一项添加事件
	    @eNames	:Object/Array<Object> 一个或多个事件类型
	    @actions	:Function/Array<Function> 一个或多个回调函数
	    @data	:要传递的数据
	    @return:this
	    */
	    on: function (eNames, actions, data) {
	        fly.Event.on.apply(fly.Event, [this.getItems()].merge(arguments));
	        return this;
	    },


	    /*	为每一项卸载事件
	    eNames	:Object/Array<Object> 一个或多个事件类型
	    actions	:Function/Array<Function> 一个或多个回调函数
	    @return:this
	    */
	    un: function (eNames, actions) {
	        fly.Event.un.apply(fly.Event, [this.getItems()].merge(arguments));
	        return this;
	    },

	    /*	为每一项卸载事件
	    eNames	:Object/Array<Object> 一个或多个事件类型
	    actions	:Function/Array<Function> 一个或多个回调函数
	    @return:this
	    */
	    fire: function (eNames, params) {
	        fly.Event.fire.apply(fly.Event, [this.getItems()].merge(arguments));
	        return this;
	    },


	    //## 其他
	    /*	添加到集合后面
	    @item	:Object 要添加的新项
	    @return:this
	    */
	    add: function (item) {
	        return this.addRange(item)
	    },

	    //## 其他
	    /*	批量添加到集合后
	    @items	:Array 要添加的新项
	    @return:this
	    */
	    addRange: function (items) {
	        var all = this.getItems()
	        arrP.push.apply(all, fly.likeArray(items) ? fly.toArray(items) : arguments)
	        this.updateLength()
	        return this;
	    },


	    /*	插入
	    @index	:Int 插入的目标位置(从0开始)
	    @items	:Array(可选) 要插入的任意多个项
	    @return:this
	    */
	    insert: function (index, items) {
	        if (arguments.length > 1) {
	            var all = this.getItems()
	            arrP.splice.apply(all, [index < 0 ? all.length + index : index, 0].concat(fly.likeArray(items) ? fly.toArray(items) : arrP.slice.call(arguments, 1)))
	            this.updateLength()
	        }
	        return this;
	    },


	    /*	删除
	    @index	:Int 要删除的目标位置(从0开始)
	    @items	:Array(可选) 在该位置插入的任意多个项
	    @return:this
	    */
	    remove: function (index, items) {
	        if (arguments.length > 0) {
	            if (fly.likeArray(index)) {
	                var indexs = fly.toArray(index).uniquelize()
	                indexs.sort()
	                for (var i = indexs.length - 1; i > -1; i--)
	                    this.remove(indexs[i])
	            }
	            else {
	                var all = this.getItems()
	                index = index < 0 ? all.length + index : index
	                all[index] = null;
	                arguments.length > 1 ? arrP.splice.apply(all, [index, 1].concat(items)) : arrP.splice.call(all, index, 1)
	            }
	            this.updateLength()
	            return this;
	        }
	        else {
	            this.$each(function (o) {
	                if (o && o.parentNode)
	                    o.parentNode.removeChild(o);
	            })
	        }
	        return this;
	    },


	    /* 搜索第一个匹配项在集合中的索引
	    @value	:搜索的值
	    @startIndex:Int 开始位置
	    @endIndex   :Int 结束位置
	    @comparer:Function/String/Object 一个对值进行比较的相等比较器
	    @return	:Int 如果找到 item 的第一个匹配项，则为该项的从零开始的索引；否则为 -1。
	    */
	    indexOf: function (item, startIndex, endIndex, comparer) {
	        var all = this.getItems ? this.getItems() : this
	        comparer = comparer ? fly.toFun(comparer) : null
	        startIndex = endIndex || 0
	        endIndex = endIndex || all.length - 1
	        for (var i = startIndex; i <= endIndex; i++)
	            if (comparer == null ? all[i] == item : comparer.call(all[i], all[i], item, all))
	                return i;
	        return -1
	    },

	    /* 搜索最后一个匹配项在集合中的索引
	    @value	:搜索的值
	    @startIndex:Int 开始位置
	    @comparer:Function/String/Object 一个对值进行比较的相等比较器
	    @return	:Int 如果找到 item 的最后一个匹配项，则为该项的从零开始的索引；否则为 -1。
	    */
	    lastIndexOf: function (item, startIndex, endIndex, comparer) {
	        var all = this.getItems ? this.getItems() : this
	        comparer = comparer ? fly.toFun(comparer) : null
	        startIndex = endIndex || 0
	        endIndex = endIndex || all.length - 1
	        for (var i = endIndex; i >= startIndex; i--)
	            if (comparer == null ? all[i] == item : comparer.call(all[i], all[i], item, all))
	                return i;
	        return -1
	    },
	    /*
	    @predicate	:Function/String/Object 用于测试每个元素是否满足条件的函数。
	    */
	    findIndex: function (predicate, startIndex, endIndex, comparer) {
	        var fn = fly.toFun(predicate)
	        return this.indexOf(null, startIndex, endIndex, function (o1, o2, a) {
	            var o = fn.call(o1, o1)
	            return comparer ? comparer.call(o1, o1, o, a) : o
	        })
	    },

	    /*
	    @predicate	:Function/String/Object 用于测试每个元素是否满足条件的函数。
	    */
	    findLastIndex: function (predicate, startIndex, endIndex, comparer) {
	        var fn = fly.toFun(predicate)
	        return this.lastIndexOf(null, startIndex, endIndex, function (o1, o2, a) {
	            var o = fn.call(o1, o1)
	            return comparer ? comparer.call(o1, o1, o, a) : o
	        })
	    },


	    /* 判断值在集合中是否存在
	    @value	:搜索的值
	    @startIndex:Int 开始位置
	    @comparer:Function/String/Object 一个对值进行比较的相等比较器
	    @return	:Boolean
	    */
	    contains: function (value, startIndex, comparer) {
	        return this.indexOf(value, startIndex, comparer) > -1
	    },


	    /*	复制到新的数组
	    @index	:Int 插入目标位置(0开始)
	    @arr	:Array 复制到该数组,为空将生成新的数组
	    @return	:arr
	    */
	    copyTo: function (index, arr) {
	        arrP.splice.apply(arr || (arr = new Array()), [index, 0].concat(this.getItems()))
	        return arr;
	    },


	    /*  合并多个对象
	    @params  :Object(可选) 可变参数，任意多个对象
	    @return:this
	    */
	    merge: function (params) {
	        var all = this.getItems()
	        for (var i = 0; i < arguments.length; i++) {
	            arrP.push.apply(all, qp.getItems(arguments[i]))
	        }
	        return this
	    },


	    /*  设置对象属性
	    @properties  :Object 包含多个属性和属性值的键值对
	    @return:this
	    */
	    setAttr: function (properties) {
	        this.$each(function (o) {
	            fly.set(o, properties)
	        })
	        return this
	    },
	    //#end


	    /*	获取或设置对象的Css属性，只传递 name 参数时则，获取该属性值。
	    @name	:String 属性名或要应用到对象Css属性的键值对
	    @value	:Object(可选) Css属性值
	    @return:this
	    */
	    css: function (name, value) {
	        if (this.length == 0)
	            return this
	        if (arguments.length == 1 && fly.isString(name))
	            return styleHelper.get(this.item(0), name)

	        if (arguments.length > 1)
	            this.$each(function (o) {
	                styleHelper.set(o, name, value)
	            })
	        else
	            this.$each(function (o) {
	                for (var p in name)
	                    styleHelper.set(o, p, name[p])
	            })
	        return this
	    },

	    numCss: function (name) {
	        var v = Number((this.css(name) + " ").replace(/[^\d-\.]/g, ""))
	        return isNaN(v) ? v : 0
	    },

	    /*	获取或设置对象的属性，只传递 name 参数时则，获取该属性值。
	    @name	:String 属性名或要应用到对象属性的键值对
	    @value	:Object(可选) 属性值
	    @return	:this
	    */
	    data: function (name, value) {
	        if (arguments.length == 1 && fly.isString(name))
	            return this.length == 0 ? null : this.item(0)[name];


	        if (arguments.length > 1)
	            this.$each(function (o) {
	                this[name] = value
	            })
	        else
	            this.$each(function (o) {
	                for (var p in name)
	                    o[p] = name[p]
	            })
	        return this
	    },

	    /*	获取或设置对象的属性，只传递 name 参数时则，获取该属性值。
	    @name	:String 属性名或要应用到对象属性的键值对
	    @value	:Object(可选) 属性值
	    @return	:this
	    */
	    attr: function (name, value) {
	        if (arguments.length == 1 && fly.isString(name))
	            return this.length == 0 ? null : fly.attr(this.item(0), name);

	        if (arguments.length > 1)
	            this.$each(function (o) {
	                fly.attr(o, name, value)
	            })
	        else
	            this.$each(function (o) {
	                for (var p in name)
	                    fly.attr(o, p, name[p])
	            })
	        return this
	    },


	    /*	移除对象属性
	    @name	:String 要移除的属性名
	    @return	:this
	    */
	    removeAttr: function (name) {
	        this.each(function () {
	            if (this.removeAttribute) {
	                try {
	                    this.removeAttribute(name)
	                } catch (e) { }
	            }
	            try {
	                delete this[name]
	            } catch (e) { }
	        })
	        return this
	    },

	    values: function (values, ignoreDisabled) {
	        var boxs = this.filter(":input").merge(this.find(":input"));
	        if (values && !fly.isBoolean(values)) {
	            boxs.each(function () {
	                var k = this.name || this.id
	                if (k in values)
	                    $.value(this, values[k]);
	            })
	            return this;
	        }
	        else {
	            var vs = {}, hasSubmit
	            boxs.each(function () {
	                var k = this.name || this.id
	                var t = this.type
	                if (!k || (ignoreDisabled != false && this.disabled) || /file|undefined|reset|button/i.test(t)) return;
	                if ((/radio|checkbox/i.test(t) && !this.checked) || (t == 'submit' && hasSubmit)) return;
	                hasSubmit = hasSubmit || t == 'submit'
	                var v = fly.value(this)
	                if (values === true)
	                    vs[k] = fly.likeArray(v) ? v[v.length - 1] : v;
	                else
	                    k in vs ? (fly.isArray(vs[k]) ? vs[k].push(v) : vs[k] = [vs[k], v]) : vs[k] = v
	            })
	            return vs;
	        }
	    },

	    value: function (value) {
	        if (arguments.length == 0) {
	            var first = this.getItems()[0]
	            return first ? fly.value(first) : null
	        }

	        this.each(function (b, i) {
	            fly.value(this, value)
	            return this;
	        })
	    },

	    serialize: function () {
	        return fly.lib.Json.urlEncode(this.values())
	    },

	    /*	为每一项添加CSS样式
	    @css	:String 要添加的CSS名称
	    @return	:this
	    */
	    addClass: function (css) {
	        dh.addClass(this, css);
	        return this
	    },

	    /*	为每一项移除CSS样式
	    @css	:String 要移除的CSS名称
	    @return	:this
	    */
	    removeClass: function (css) {
	        dh.removeClass(this, css)
	        return this
	    },

	    /*	第一项是否包含某一CSS名称
	    @css	:String 要检测的CSS名称
	    @return	:this
	    */
	    hasClass: function (css) {
	        var first = this.item(0)
	        if (first)
	            return dh.hasClass(first, css)
	        return false
	    },
	    toHtml: function () {
	        return dh.toHtml(this)
	    },

	    clone: function () {
	        return dh.clone(this)
	    },

	    rect: function () {
	        var item0 = this.item(0)
	        var pos = { top: item0.offsetTop, left: item0.offsetLeft, width: item0.offsetWidth, height: item0.offsetHeight }
	        var rect = item0.getBoundingClientRect ? item0.getBoundingClientRect() : (item0.getClientRects ? item0.getClientRects() : null)
	        if (rect) {
	            pos.top = rect.top;
	            pos.left = rect.left;
	            return pos;
	        }

	        while (box = box.offsetParent) {
	            pos.top += box.offsetTop;
	            pos.left += box.offsetLeft;
	        }
	        return pos
	    },

	    pos: function () {
	        return {
	            left: parseInt(this.left()) || 0,
	            top: parseInt(this.top()) || 0,
	            bottom: parseInt(this.bottom()) || 0,
	            right: parseInt(this.right()) || 0
	        }
	    },

	    /*	获取第一项的偏移量
	    @return	:形如{left:123,top:456}
	    */
	    offset: function () {
	        var item0 = this.item(0)
	        return {
	            height: item0.offsetHeight,
	            width: item0.offsetWidth,
	            left: parseInt(this.left()) || item0.offsetLeft,
	            top: parseInt(this.top()) || item0.offsetTop,
	            bottom: parseInt(this.bottom()) || 0,
	            right: parseInt(this.right()) || 0
	        }
	    },

	    /*	获取第一项的大小
	    @return	:形如{width:123,height:456}
	    */
	    size: function () {
	        return {
	            width: parseInt(this.width()) || this.item(0).offsetWidth,
	            height: parseInt(this.height()) || this.item(0).offsetHeight
	        }
	    },

	    /*	移除焦点
	    @return	:this
	    */
	    blur: function (delay, fn) {
	        if (fly.isNumber(delay) || arguments.length == 0) {
	            return this.$each(function () {
	                var o = this
	                if (delay != null) {
	                    setTimeout(function () {
	                        if (o.blur) o.blur();
	                        if (fn) fn.call(o, o);
	                    }, delay)
	                }
	                else {
	                    if (o.blur) o.blur();
	                    if (fn) fn.call(o, o);
	                }
	            })
	        }
	        else
	            return this.on.apply(this, arrP.concat.apply(["blur"], arguments))
	    },

	    /*	设置焦点
	    @return	:this
	    */
	    focus: function (delay, fn) {
	        if (fly.isNumber(delay) || arguments.length == 0) {
	            return this.$each(function () {
	                var o = this
	                if (delay != null) {
	                    setTimeout(function () {
	                        if (o.focus) o.focus();
	                        if (fn) fn.call(o);
	                    }, delay)
	                }
	                else {
	                    if (o.focus) o.focus();
	                    if (fn) fn.call(o);
	                }
	            })
	        }
	        else
	            return this.on.apply(this, arrP.concat.apply(["focus"], arguments))
	    },

	    zIndex: function (zIndex) {
	        if (arguments.length > 0)
	            return this.css('zIndex', zIndex);

	        var el = this.first();
	        var pos;
	        var v = 0;
	        while (el.length && el[0] !== doc) {
	            pos = el.css('position');
	            if (pos == 'absolute' || pos == 'relative' || pos == 'fixed') {
	                v = parseInt(el.css('zIndex'));
	                if (!isNaN(v) && v != 0)
	                    return v;
	            }
	            el = el.parent();
	        }
	        return 0;
	    },
	    focusable: function () {
	        if (this.length == 0) return false
	        return dh.focusable(this.item(0));
	    },

	    tabbable: function () {
	        if (this.length == 0) return false
	        return dh.tabbable(this.item(0))
	    },
	    append: function (dom, returnDom) {
	        dh.append(this, dom)
	        return this
	    },
	    appendTo: function (dom, returnDom) {
	        dh.append(dom, this)
	        return this
	    },
	    empty: function (dom, returnDom) {
	        return this.$each(function (o) {
	            dh.empty(o);
	        })
	    },
	    before: function (dom) {
	        dh.insertBefore(this, dom)
	        return this
	    },
	    after: function (dom) {
	        dh.insertAfter(this, dom)
	        return this
	    },
	    insertBefore: function (dom) {
	        dh.insertBefore(dom, this)
	        return this
	    },
	    insertAfter: function (dom) {
	        dh.insertAfter(dom, this)
	        return this;
	    },

	    end: function () {
	        return this.context || new Array()
	    },
	    destroy: function () {
	        var all = this.getItems()
	        for (var i = all.length - 1; i > -1; i--) {
	            all[i] = null;
	            arrP.pop.call(all)
	        }
	        this.items = this.all = null;
	    }
	}
        //#end
    ; (function () {
        var style = docE.style;
        var getCssMethod = function (name) {
            return function (v) {
                return arguments.length > 0 ? this.css(name, v) : this.css(name)
            }
        }

        if (browser.isSafari || browser.isChrome) {
            style = doc.defaultView.getComputedStyle(docE)
            for (var i = 0; i < style.length; i++) {
                var name = camelCase(style[i])
                if (name.charAt(0) != '-' && !qp[name])
                    qp[name] = getCssMethod(name)
            }

            var style = "border,borderWidth,borderColor,borderStyle,margin,padding,font".split(',')
            for (var i = 0; i < style.length; i++)
                qp[name] = getCssMethod(name)
        }
        else {
            for (var name in style)
                if (!qp[name])
                    qp[name] = getCssMethod(name)
        }


        // Create innerHeight, innerWidth, outerHeight and outerWidth methods
        var num = ui.Style.num
        fly.each(["Height", "Width"], function (name) {
            var tl = name == "Width" ? "Left" : "Top", // top or left
			br = name == "Width" ? "Right" : "Bottom";
            // bottom or right

            // innerHeight and innerWidth
            qp["inner" + name] = function () {
                return this[name.toLowerCase()]() + num(this, "padding" + tl) + num(this, "padding" + br);
            };


            // outerHeight and outerWidth
            qp["outer" + name] = function (margin) {
                return this["inner" + name]() + num(this, "border" + tl + "Width") + num(this, "border" + br + "Width") + (margin ? num(this, "margin" + tl) + num(this, "margin" + br) : 0);
            };

            var type = name.toLowerCase();
            qp[type] = function (size) {
                var first = this.item(0);
                // Get window width or height
                if (first == win)
                // Everyone else use document.documentElement or document.body depending on Quirks vs Standards mode
                    return doc.compatMode == "CSS1Compat" && docE["client" + name] || doc.body["client" + name]

                // Get document width or height
                if (first == doc)
                // Either scroll[Width/Height] or offset[Width/Height], whichever is greater
                    return Math.max(docE["client" + name], doc.body["scroll" + name], docE["scroll" + name], doc.body["offset" + name], docE["offset" + name])

                // Get or set width or height on the element
                if (size === undefined)
                // Get width or height on the element
                    return (this.length ? ui.Style.get(this[0], type) : null)
                else
                // Set the width or height on the element (default to pixels if value is unitless)
                    return this.css(type, fly.isString(size) ? size : size + "px");
            };
        });
    })();


        //## fly.collection.IEnumerable Extend
        fly.extend(qp,
	{
	    ready: fly.ready,
	    val: qp.value,
	    /*	禁用每一项
	    @return	:this
	    */
	    disable: qp.attr.$format("disabled", true),
	    /*	启用每一项
	    @return	:this
	    */
	    enable: qp.attr.$format("disabled", false),

	    /*	隐藏每一项
	    @return	:this
	    */
	    hide: qp.css.$format("display", "none"),

	    /*	显示每一项
	    @return	:this
	    */
	    show: function () {
	        var d = this.css("display")
	        if (d == "none")
	            this.css("display", "")

	        var d = this.css("visibility")
	        if (d == "hidden")
	            this.css("visibility", "")
	        return this
	    },

	    /*	生成一个新IEnumerable对象
	    @evaluator:Function/String/Object 计算值的函数
	    @params	:Object(可选) 可变参数，要传递的任意多个参数
	    @return	:IEnumerable
	    */
	    map: qp.select,

	    /*	确定是否有满足条件的元素,如果不指定条件,将返回集合长度。
	    @predicate	:Function/String/Object 用于测试每个元素是否满足条件的函数。
	    @params	:Object(可选) 可变参数，要传递的任意多个参数
	    @return	:Boolean
	    */
	    any: function (predicate, params) {
	        if (arguments.length == 0)
	            return (this.getItems || qp.getItems).call(this).length
	        this.___count = 1
	        return (this.___take || qp.___take).apply(this, arguments).length > 0
	    },

	    /*	确定序列中的所有元素是否都满足条件,如果不指定条件,将返回所有元素。
	    @predicate	:Function/String/Object 用于测试每个元素是否满足条件的函数。
	    @params	:Object(可选) 可变参数，要传递的任意多个参数
	    @return	:Boolean
	    */
	    all: function (predicate, params) {
	        if (arguments.length == 0)
	            return (this.getItems || qp.getItems).call(this)
	        this.___count = 1
	        this.___isNot = true
	        return (this.___take || qp.___take).apply(this, arguments).length == 0
	    },


	    /*	查询
	    @predicate	:Function/String/Object 查询条件
	    @params	:Object(可选) 可变参数，要传递的任意多个参数
	    @return	:IEnumerable
	    */
	    where: function (predicate, params) {
	        return (this.___take || qp.___take).apply(this, arguments)
	    },


	    aggregate: function (seed, func) {
	        if (arguments.length == 1)
	            func = seed, seed = null
	        func = fly.toFun(func || seed);
	        this.each(function (o, i, a) {
	            seed = func.call(this, seed, o, i, a)
	        })
	        return seed;
	    },

	    sum: function (selector) {
	        var s = 0
	        if (selector != null) selector = fly.toFun(selector)
	        this.each(function (o, i, a) {
	            s += selector == null ? o : selector.apply(this, arguments)
	        })
	        return s;
	    },

	    compareOne: function (selector, resultSelector, greaterLessThanOrComparer) {
	        var c, cItem, than = greaterLessThanOrComparer
	        if (selector != null) selector = fly.toFun(selector)
	        if (resultSelector != null) resultSelector = fly.toFun(resultSelector, true)
	        if (resultSelector != null && !fly.isFun(resultSelector))
	            return resultSelector
	        var isFun = fly.isFun(than), isBool = fly.isBoolean(than), isMax = than === true, isMin = than === false
	        this.each(function (o, i, a) {
	            var v = selector == null ? o : selector.apply(this, arguments)
	            if (isBool) {
	                if (!(c === undefined || (isMax ? v > c : v < c))) return
	            }
	            else {
	                if (!(isFun ? than.apply(this, v, c, cItem) : v == than))
	                    return
	            }
	            c = v, cItem = o
	        })
	        if (c === undefined) return
	        return resultSelector == null ? cItem : resultSelector.apply(cItem, cItem, c, this);
	    },
	    max: function (selector, resultSelector) {
	        return this.compareOne(selector, resultSelector, true)
	    },

	    min: function (selector, resultSelector) {
	        return this.compareOne(selector, resultSelector, false)
	    },

	    average: function (selector) {
	        return this.sum.apply(this, arguments) / this.length
	    },

	    count: function (predicate, params) {
	        return this.where.apply(this, arguments).length
	    },
	    distinct: qp.uniquelize,

	    groupBy: function (keySelector, itemSelector) {
	        var gs = {}
	        keySelector = fly.toFun(keySelector)
	        itemSelector = fly.toFun(itemSelector)
	        this.each(function (o, i, a) {
	            var k = keySelector == null ? i : keySelector.apply(this, arguments);
	            var item = itemSelector == null ? o : itemSelector.apply(this, arguments);
	            (gs[k] || (gs[k] = new Array())).push(item)
	        })
	        return gs
	    },

	    clear: function () {
	        var all = this.getItems()
	        arrP.splice.call(all, 0, this.length)
	        this.updateLength();
	        return this
	    },

	    /*	获取第一项
	    @predicate	:Function/String/Object 查询条件
	    @params	:Object(可选) 可变参数，要传递的任意多个参数
	    @return	:Object
	    */
	    first: function (predicate, params) {
	        if (arguments.length == 0) {
	            var all = (this.getItems || qp.getItems).call(this)
	            var result = new Array()
	            if (all.length > 0)
	                result[0] = all[0]
	            return this.create ? this.create(result) : result
	        }
	        this.___count = 1
	        return (this.___take || qp.___take).apply(this, arguments)
	    },

	    /*	获取最后一项
	    @predicate	:Function/String/Object 查询条件
	    @params	:Object(可选) 可变参数，要传递的任意多个参数
	    @return	:Object
	    */
	    last: function (predicate, params) {
	        if (arguments.length == 0) {
	            var all = (this.getItems || qp.getItems).call(this)
	            var result = new Array()
	            if (all.length > 0)
	                result[0] = all[all.length - 1]
	            return this.create ? this.create(result) : result
	        }

	        this.___count = 1
	        this.___isAsc = false
	        return (this.___take || qp.___take).apply(this, arguments)
	    },

	    index: qp.indexOf,
	    lastIndex: qp.lastIndexOf,


	    //	    /*	匹配所有元素的上级元素，对应选择器 “<”			
	    //	    @layers	:Int(可选) 往上的级数，默认 1
	    //	    @return :Array<Element>
	    //	    */
	    //	    parent: function (layers) {
	    //	        return this.$("<" + (layers || 1))
	    //	    },

	    /*	匹配所有元素的子级元素，对应选择器 “>”			
	    @layers	:Int(可选) 往下的级数，默认 1
	    @return :Array<Element>
	    */
	    children: function (layers) {
	        return this.$(">" + (layers || 1))
	    },

	    /*	匹配所有元素的之后的元素，对应选择器 “+”
	    @offset	:Int(可选) 往后的偏移量，默认 1
	    @return :Array<Element>
	    */
	    next: function (offset) {
	        return this.$("+" + (layers || 1))
	    },

	    /*	匹配所有元素的之前的元素，对应选择器 “-”
	    @offset	:Int(可选) 往前的偏移量，默认 1
	    @return :Array<Element>
	    */
	    previous: function (offset) {
	        return this.$("&" + (layers || 1))
	    },

	    /*	匹配所有元素的兄弟元素，对应选择器 “~”
	    @return :Array<Element>
	    */
	    sibling: function () {
	        return this.$("~" + (layers || 1))
	    },

	    hover: function (over, out, data) {
	        if (over)
	            this.mouseenter.apply(this, [over].concat(slice.call(arguments, 1)))
	        if (out)
	            this.mouseout.apply(this, slice.call(arguments, 1))
	        return this
	    }
	});
        ; (function () {
            qp.avg = qp.average

            qp.slideUp = qp.hide
            qp.sildeDown = qp.show

            var m2m =
		{
		    minWidth: 'width',
		    minHeight: 'height'
		};
            for (var m in m2m) {
                if (!qp[m])
                    qp[m] = qp[m2m[m]]
            }
            var props = ["disabled", "id", "name", "title", "className", "text:innerText", "html:innerHTML"]
            for (var i = 0; i < props.length; i++) {
                var att = props[i].replace(/.*:/g, '')
                qp[props[i].replace(/:.*/g, '')] = function (att) {
                    return function (v) {
                        return arguments.length > 0 ? this.attr(att, v) : this.attr(att)
                    }
                } (att)
            }

            qp.bind = qp.on
            fly.Event.events = ("Blur,Focus,Load,Resize,Scroll,Unload,Click,DblClick,ContextMenu," +
		"MouseDown,MouseUp,MouseMove,MouseOver,MouseOut,MouseEnter,MouseLeave," +
		"Change,Select,SelectStart,Submit,KeyDown,KeyPress,KeyUp,Error").split(',')
            for (var i = 0; i < fly.Event.events.length; i++) {
                var e = fly.Event.events[i]
                var le = e.toLowerCase()
                var h = qp["on" + e] = function (e) {
                    return function () {
                        return this.on.apply(this, arrP.concat.apply([e], arguments))
                    }
                } (le)
                if (!qp[le])
                    qp[le] = h;
            }
        })();
        //#end

        qp.applyTo(Array, {
            item: function (index) {
                return this[index]
            },
            filter: qp.filter,
            $type: Array,
            $create: fly.toArray,
            getItems: fly.emptyFun,
            updateLength: fly.emptyFun
        })

        lib.Single = function (single) {
            this.single = this[0] = fly.likeArray(single) ? single[0] : single;
        }

        qp.applyTo(lib.Single,
    {
        length: 1,
        single: null,
        item: function (index) {
            return single
        },
        getItems: function () {
            return new Array(this.single)
        },
        updateLength: fly.emptyFun,
        destroy: function () {
            this.single = null;
            this[0] = null;
        }
    });


        fly.safeExtend("$", qp, qp);

        // 	for (var p in fly.collection.IEnumerable)
        // 		if (p.charAt(0) != "$")
        // 			fly.collection.IEnumerable["$" + p] = fly.collection.IEnumerable[p]

        // var tempObj = {}
        // for (var p in fly.collection.IEnumerable)
        // 	tempObj["$" + p] = fly.collection.IEnumerable[p]
        // for (var p in tempObj)
        // 	fly.collection.IEnumerable[p] = tempObj[p]


        //## fly.ui.Animate
        fly.ui.Animate = fly.Class(
	{
	    base: lib.Component,
	    _handle: 0,
	    /*	speed,step,start,end,achieve,target
	    */
	    constructor: function (config) {
	        fly.extend(this, config)
	        this.config = config
	        lib.Animate.baseClass.constructor.apply(this, arguments);
	    },
	    current: 0,
	    play: function () {
	        if (this.running)
	            return false;
	        var speed = this.speed || this.config.speed, speed = parseInt((lib.Animate.Speed[speed] || speed || lib.Animate.Speed.normal) / 20)
	        var start = parseInt(this.start || this.config.start || (this.getter || this.config.getter || this.achieve || this.config.achieve)(this.target, this.attr))
	        this._step = this.step || this.config.step || ((this.end || this.config.end - start) / 20)
	        this.current = start

	        if (fly.Event.fire(this, "play") == false)
	            return false
	        win.clearTimeout(this._handle)
	        this.running = true
	        if (this.attr == "opacity") {
	            var zoom = ui.Style.get(this.target, "zoom")
	            if (zoom == null || zoom == "normal")
	                ui.Style.set(this.target, "zoom", 1);
	        }
	        var me = this;
	        this._handle = win.setInterval(function () { me.go() }, speed)
	    },
	    go: function () {
	        //alert(this.current)
	        win.status = this.current
	        this.achieve.call(this, this.target, this.attr, this.current, this.data || this.config.data)
	        var end = this.end || this.config.end;
	        if (this._step > 0 ? this.current >= end : this.current <= end) {
	            fly.Event.fire(this, "end");
	            this.stop()
	            return
	        }

	        if (fly.Event.fire(this, "go") == false)
	            return false
	        this.current += this._step;
	        if (this._step > 0 ? this.current > end : this.current < end)
	            this.current = end
	    },
	    stop: function () {
	        //this.go.clearTimeout()
	        win.clearTimeout(this._handle)
	        fly.Event.fire(this, "stop")
	        this.running = false
	        if (this.callback)
	            this.callback.call(this)
	    }
	})

        fly.ui.Animate.Speed =
	{
	    slow: 300,
	    normal: 200,
	    fast: 100
	}
        //#end

        fly.ui.Effect =
	{
	    style: styleHelper.set
	}

        qp.extend(
	{
	    animate: function (prop, speed, callback) {
	        var attr, to;
	        for (var p in prop)
	            attr = p, to = parseInt(prop[attr]);

	        return qp.$each.call(this, function (o) {
	            var key = "animate " + attr + ":" + to
	            var animate = lib.Cache.data(o, key) || lib.Cache.data(o, key, new fly.ui.Animate(
				{
				    target: o,
				    achieve: fly.ui.Effect.style,
				    attr: attr,
				    getter: styleHelper.num
				}))
	            animate.speed = speed
	            animate.end = to;
	            animate.callback = callback;
	            animate.play()
	        })
	    },
	    parseFadeArgs: function (speed, callback) {
	        return fly.isObject(speed) ? speed : { speed: speed, callback: callback }
	    },
	    fadeOut: function (speed, callback) {
	        var config = this.$parseFadeArgs.apply(this, arguments);
	        return qp.$each.call(this, function (o) {
	            var animate = new fly.ui.Animate(o, fly.ui.Effect.style, fly.extend(
				{
				    start: 100,
				    end: 0
				}, config))

	            if (fly.isFun(callback))
	                animate.on("end", callback)
	            animate.on("end", function (a) {
	                this.hide()
	                this.css("opacity", 100);
	            } .bind(this))

	            animate.play()
	        })
	    },

	    fadeIn: function (speed, callback) {
	        var config = this.$parseFadeArgs.apply(this, arguments);
	        return qp.$each.call(this, function (o) {
	            this.show()
	            var animate = new fly.ui.Animate(o, fly.ui.Effect.style, fly.extend(
				{
				    start: 0,
				    end: 100
				}, config))
	            if (fly.isFun(callback))
	                animate.on("end", callback)
	            animate.play()
	        })
	    },

	    fadeTo: function (speed, to, callback) {
	        //		var length=arguments.length;
	        //		if(fly.isFun(arguments[length-1]))
	        //		{
	        //			callback=arguments[length-1]
	        //			length--;
	        //		}
	        //		if(length === 1)
	        //		{
	        //			to = speed;
	        //			speed=undefined;
	        //		}
	        var config = this.$parseFadeArgs(speed, callback);
	        config.end = to < 1 ? to * 100 : to
	        return qp.$each.call(this, function (o) {
	            var old = parseInt(ui.Style.get(this[0], "opacity"));
	            var animate = new fly.ui.Animate(o, fly.ui.Effect.style, fly.extend(
				{
				    start: old == 0 ? 0 : old || 100
				}, config));

	            if (fly.isFun(callback))
	                animate.on("end", callback)

	            if (config.end === 0)
	                animate.on("end", function () {
	                    this.hide();
	                    this.css("opacity", 100);
	                })
	            animate.play()
	        })
	    }
	});


        //## fly.ui.selector
        ; (function () {
            var eFunsCache = {}
            var nsSelector = fly.ns("fly.ui.selector")
            var hasQueryMethod = !!doc.querySelector
            var checkDiv = doc.createElement('div')
            var engine, rSelectors;
            var utils =
		{
		    propMap: { "class": "className" },
		    trimCommaReg: /^[\s\,]*\,+|\,+[\s\,]*$/g,
		    expressionInnerReg: /^\s*([\w$]+)\s*([=><*!\^\$]+)([\s\S]+)*/,
		    expressionOuterReg: /\s*(\[[^\[\]]+\])/g,
		    trimQuotationReg: /^\s*['"]?|['"]?\s*$/g,
		    trimMiddleBrackets: /^\s*\[|\]\s*$/g,
		    verySimpleReg: /[\[\]\(\)\s><+]/,
		    containsReg: /:contains\(\s*(\'[^\']*\'|\"[^\"]*\")\s*\)/g,
		    headerTags: ["h1", "h2", "h3", "h4", "h5", "h6"],
		    inputTags: ["input", "textarea", "select", "button"],
		    inputTypes: ["text", "checkbox", "radio", "image", "file", "submit", "reset", "password", "button", "hidden"],
		    relationSelectorReg: /[+\-<>~]/,
		    relationSelectorRegReplace: /([+\&<>~]+)(\d*)/g,
		    getByTagPropFilter: function (tagName, prop, value) {
		        return function (context, collector, selector) {
		            var s =
					{
					    selector: tagName, onlyFilterContext: selector.onlyFilterContext
					}
		            if (prop == null)
		                return executors.byTagName(context, collector, s)
		            var c = new nsSelector.Collector()
		            executors.byTagName(context, c, s)
		            fly.each(c.result, function (o) {
		                if (o[prop] == value)
		                    collector.result.push(o)
		            })
		        }
		    },
		    getCommonFilter: function (each) {
		        each = fly.toFun(each)
		        return function (context, collector, selector, isDesc) {
		            if (!selector.onlyFilterContext) {
		                var newCollector = new nsSelector.Collector()
		                executors.all(context, newCollector,
						{
						    onlyFilterContext: false
						})
		                context = newCollector.result
		            }
		            each(context, collector, selector)
		        }
		    },
		    getSimpleOperator: function (operator) {
		        return fly.toFun("o,left, right=>o[left] " + operator + " right")
		    }
		}

            //## Collector
            nsSelector.Collector = function (result, unique) {
                this.result = result || new Array()
                this.unique = unique;
                if (unique && this.result.length > 0)
                    this.result = this.uniquelize();
            } .extend(
		{
		    allID: ",",
		    uniquelize: function (start, end) {
		        //return
		        if (this.result.length < 2)
		            return;
		        var all = this.result
		        var i = -1, len = all.length
		        this.allID = ","
		        start = start || 0
		        end = end == null ? len : end;
		        while (++i < len) {
		            var id = all[i].uniqueNumber || ui.DomHelper.getUniqueID(all[i])
		            if (i >= start && i < end && this.allID.indexOf(',' + id + ",") > -1) {
		                all.splice(i, 1);
		                i--, len--;
		                continue
		            }
		            this.allID += id + ","
		        }

		    },
		    merge: function (arr) {
		        if (arr.length == 0)
		            return
		        this.result.length == 0 ? this.result = fly.toArray(arr) : this.result.merge(arr)
		        if (this.unique)
		            this.uniquelize();
		    },
		    push: function (dom) {
		        if (this.unique) {
		            var id = dom.uniqueNumber || ui.DomHelper.getUniqueID(dom)
		            if (this.allID.$contains(',' + id + ','))
		                return false;
		            this.allID += id + ",";
		        }
		        this.result.push(dom)
		        return true
		    },
		    contains: function (dom) {
		        if (this.unique)
		            return this.allID.$contains(',' + dom.uniqueNumber || ui.DomHelper.getUniqueID(dom) + ',')
		        return this.result.$contains(dom)
		    },
		    clear: function () {
		        this.result = new Array()
		        this.allID = ','
		    }
		}).extend(nsSelector.Collector)
            //#end

            //## Executors
            var executors =
		{
		    _all: function (dom) {
		        if (dom.all)
		            return dom.all
		        else if (dom.getElementsByTagName)
		            return dom.getElementsByTagName('*')
		        else {
		            var result = new Array();
		            (function (o, allChild) {
		                var cs = ui.DomHelper.children(o)
		                if (cs != null)
		                    for (var i = 0; i < cs.length; i++)
		                        arguments.callee(allChild.push(cs[i]), allChild)
		            })(dom, result)
		            return result
		        }
		    },
		    all: function (context, collector, selector) {
		        if (selector.onlyFilterContext)
		            return collector.merge(context)
		        for (var i = 0; i < context.length; i++)
		            collector.merge(executors._all(context[i]))
		    },
		    byId: function (context, collector, selector) {
		        var s = selector.selector
		        for (var i = 0; i < context.length; i++) {
		            var c = context[i]
		            if (selector.onlyFilterContext) {
		                if (c.id == s)
		                    collector.result.push(c)
		            }
		            else if (c.getElementById) {
		                var node = c.getElementById(s)
		                if (node)
		                    collector.result.push(node)
		            }
		            else {
		                var childs = executors._all(c)
		                var ci = -1
		                while (++ci < childs.length)
		                    if (childs[ci].id == s)
		                        return collector.result.push(childs[ci])
		            }
		        }
		    },
		    byCss: function (context, collector, selector) {
		        var s = new RegExp("\\s" + selector.selector + "\\s")
		        for (var i = 0; i < context.length; i++) {
		            var c = context[i]
		            if (selector.onlyFilterContext) {
		                if (s.test(' ' + c.className + ' '))
		                    collector.result.push(c)
		            }
		            else {
		                var childs = executors._all(c)
		                var ci = -1
		                while (++ci < childs.length)
		                    if (s.test(' ' + childs[ci].className + ' '))
		                        collector.result.push(childs[ci])
		            }
		        }
		    },
		    byName: function (context, collector, selector) {
		        var s = selector.selector
		        for (var i = 0; i < context.length; i++) {
		            var c = context[i]

		            if (selector.onlyFilterContext) {
		                if (c.name == s)
		                    collector.result.push(c)
		            }
		            else if (c.getElementsByName)
		                collector.merge(c.getElementsByName(s))
		            else {
		                var childs = executors._all(c)
		                var ci = -1
		                while (++ci < childs.length)
		                    if (childs[ci].name == s)
		                        collector.result.push(childs[ci])
		            }
		        }
		    },
		    byTagName: function (context, collector, selector) {
		        var s = selector.selector
		        if (fly.isArray(s)) {
		            for (var i = 0; i < s.length; i++)
		                arguments.callee(context, collector,
						{
						    selector: s[i], onlyFilterContext: selector.onlyFilterContext
						})
		            return
		        }

		        var s = s.toUpperCase()
		        for (var i = 0; i < context.length; i++) {
		            var c = context[i]
		            if (selector.onlyFilterContext) {
		                if (c.nodeName == s)
		                    collector.result.push(c)
		            }
		            else if (c.getElementsByTagName)
		                collector.merge(c.getElementsByTagName(s))
		            else {
		                s = s.toUpperCase()
		                var childs = executors._all(c)
		                var ci = -1
		                while (++ci < childs.length)
		                    if (childs[ci].nodeName == s)
		                        collector.result.push(childs[ci])
		            }
		        }
		    },
		    clear: function (context, collector, selector) {
		        collector.clear()
		    },
		    expression: function (context, collector, selector) {
		        var all
		        if (selector.onlyFilterContext)
		            all = context
		        else {
		            var ac = new nsSelector.Collector()
		            executors.all(context, ac, { onlyFilterContext: false })
		            all = ac.result
		        }

		        var exp = selector.selector.replace(utils.trimMiddleBrackets, '').$trim();
		        if (/^\d+$/.test(exp)) {
		            var node = all[exp]
		            if (node)
		                collector.result.push(node)
		            return
		        }

		        var option = eFunsCache[exp];
		        if (option == null) {
		            var fun
		            var match = exp.match(utils.expressionInnerReg)
		            if (match != null) {
		                var operator = match[2]
		                if (operator && (fun = nsSelector.Selectors.operators[operator])) {
		                    var left = match[1].replace(utils.trimQuotationReg, '')
		                    utils.propMap[left] && (left = utils.propMap[left])
		                    var right = match[3]
		                    try {
		                        right = eval(right)
		                    } catch (e) { }
		                }
		            }
		            if (!fly.isFun(fun))
		                fun = fly.toFun(fun || (exp.indexOf('=>') > -1 ? exp : "o=>with(o){ return " + exp + "}"))
		            option = eFunsCache[exp] =
					{
					    fun: fun, left: left,
					    right: right
					}
		        }

		        var result = new Array(), i = -1, len = all.length, current;
		        while (++i < len)
		            if (option.fun(current = all[i], option.left, option.right, i, all))
		                collector.result.push(current)
		    },
		    filter: function (context, collector, selector) {
		        var fType = selector.selector.replace(/\(.*/, ''), typeFilter
		        if (fType && (typeFilter = nsSelector.Selectors.filters[fType]) != null)
		            typeFilter(context, collector, selector)
		        else throw new Error("不支持过滤器“" + selector.selectorStr + "”")
		    },
		    children: function (context, collector, selector) {
		        var s = selector.selectorStr;
		        var deep = parseInt(selector.selector)
		        function find(dom, d) {
		            var childs = ui.DomHelper.children(dom)
		            if (d == deep)
		                collector.merge(childs)
		            else
		                for (var i = 0; i < childs.length; i++)
		                    find(childs[i], d + 1)
		        }

		        for (var i = 0; i < context.length; i++)
		            find(context[i], 1)
		    },
		    sibling: function (context, collector, selector) {
		        var s = selector.selectorStr;
		        for (var i = 0; i < context.length; i++)
		            collector.merge(ui.DomHelper.children(context[i].parentNode))
		    },
		    getCommonRelationFun: function (relation) {
		        return function (context, collector, selector) {
		            var s = selector.selectorStr;
		            var deep = parseInt(selector.selector)
		            function find(dom, d) {
		                var o = dom[relation]
		                if (o == null)
		                    return
		                if (o.nodeType != 1)
		                    find(o, d)
		                else if (d == deep)
		                    collector.result.push(o)
		                else
		                    find(o, d + 1)
		            }

		            for (var i = 0; i < context.length; i++)
		                find(context[i], 1)
		        }
		    }
		}
            //#end

            //## Selectors
            /*#C path:fly.ui.selector
            选择器
            */
            nsSelector.Selectors =
		{
		    executors: executors,
		    sTypes: new Array,
		    splitRegFormat: "\\s*([{0}]+| |[α]|[><+\\&~]+)\\s*",
		    splitReg: /\s*( )\s*/g,
		    needFollows: {},

		    //## Operators
		    operators:
			{
			    '!=': utils.getSimpleOperator("!="),
			    '^=': fly.toFun("o,left, right=>var v = o[left] ; return v && v.substr(0, right.length) == right"),
			    '$=': fly.toFun("o,left, right=>var v = o[left] ; return v && v.substr(v.length - (right.length)) == right"),
			    '*=': fly.toFun("o, left, right=>var v = o[left] ;return v && v.indexOf(right) > -1"),
			    '=': utils.getSimpleOperator("=="),
			    '==': utils.getSimpleOperator("=="),
			    '>': utils.getSimpleOperator(">"),
			    '<': utils.getSimpleOperator("<"),
			    '>=': utils.getSimpleOperator(">="),
			    '<=': utils.getSimpleOperator("<=")
			},
		    //#end

		    //## filters
		    filters:
			{
			    empty: utils.getCommonFilter("c,cr,s=>for(var i = 0; i < c.length; i ++ )if(c[i].firstChild==null)cr.result.push(c[i])"),
			    parent: utils.getCommonFilter("c,cr,s=>for(var i = 0; i < c.length; i ++ )if(c[i].firstChild!=null)cr.result.push(c[i])"),
			    enabled: utils.getCommonFilter("c,cr,s=>for(var i = 0; i < c.length; i ++ )if(c[i].disabled!=true)cr.result.push(c[i])"),
			    disabled: utils.getCommonFilter("c,cr,s=>for(var i = 0; i < c.length; i ++ )if(c[i].disabled==true)cr.result.push(c[i])"),
			    undisplay: utils.getCommonFilter("c,cr,s=>for(var i = 0; i < c.length; i ++ )if(!dh.isIsDisplay(c[i]))cr.result.push(c[i])"),
			    display: utils.getCommonFilter("c,cr,s=>for(var i = 0; i < c.length; i ++ )if(dh.isIsDisplay(c[i]))cr.result.push(c[i])"),
			    unvisible: utils.getCommonFilter("c,cr,s=>for(var i = 0; i < c.length; i ++ )if(!dh.isVisible(c[i]))cr.result.push(c[i])"),
			    visible: utils.getCommonFilter("c,cr,s=>for(var i = 0; i < c.length; i ++ )if(dh.isVisible(c[i]))cr.result.push(c[i])"),
			    hidden: utils.getCommonFilter("c,cr,s=>for(var i = 0; i < c.length; i ++ )if(dh.isHidden(c[i]))cr.result.push(c[i])"),
			    first: utils.getCommonFilter("c,cr,s=>if(c[0]!=null){cr.result.push(c[0]) ;return true}"),
			    last: utils.getCommonFilter("c,cr,s=>if(c[c.length-1]!=null){cr.result.push(c[c.length-1]);return true}", true),
			    even: utils.getCommonFilter("c,cr,s=>for(var i = 0; i < c.length; i ++ )if(i%2===0)cr.result.push(c[i])"),
			    odd: utils.getCommonFilter("c,cr,s=>for(var i = 0; i < c.length; i ++ )if(i%2!==0)cr.result.push(c[i])"),
			    "eq()": utils.getCommonFilter("c,cr,s=>var o=c[s.follow.selector]; if(o)cr.result.push(o)"),
			    "gt()": utils.getCommonFilter("c,cr,s=>for(var i = parseInt(s.follow.selector)+1; i < c.length; i ++ )cr.result.push(c[i])"),
			    "lt()": utils.getCommonFilter("c,cr,s=>for(var i = 0,end=Math.min(parseInt(s.follow.selector),c.length); i < end; i ++ )cr.result.push(c[i])"),
			    "not()": function (context, collector, selector) {
			        selector.follow.onlyFilterContext = selector.onlyFilterContext
			        var followCollector = new nsSelector.Collector()
			        selector.follow.find(context, followCollector)
			        var uids = ","
			        fly.each(followCollector.result, function (o) { uids += ui.DomHelper.getUniqueID(o) + "," })
			        utils.getCommonFilter(function (c, cr, s) {
			            for (var i = 0; i < c.length; i++)
			                if (uids.indexOf("," + ui.DomHelper.getUniqueID(c[i]) + ",") < 0) cr.result.push(c[i])
			        })(context, collector, selector)
			    },
			    "has()": function (context, collector, selector) {
			        var childC = new nsSelector.Collector()
			        executors.children(context, childC, { selector: 1 })

			        selector.follow.onlyFilterContext = selector.onlyFilterContext
			        var followCollector = new nsSelector.Collector()
			        selector.follow.find(childC.result, followCollector)

			        executors.parentNode(followCollector.result, collector, { selector: 1 })
			    },
			    "data()": utils.getCommonFilter("c,cr,s=>for(var i = 0; i < c.length; i ++ )if(fly.data(c[i],s.follow.selector)) cr.result.push(c[i])"),
			    header: utils.getByTagPropFilter(utils.headerTags),
			    input: utils.getByTagPropFilter(utils.inputTags),
			    checked: utils.getByTagPropFilter("input", "checked", true),
			    unchecked: utils.getByTagPropFilter("input", "checked", false),
			    selected: utils.getByTagPropFilter("option", "selected", true),
			    unselected: utils.getByTagPropFilter("option", "selected", false),
			    focusable: utils.getCommonFilter("c,cr,s=>for(var i = 0; i < c.length; i ++ )if(dh.focusable(c[i]))cr.result.push(c[i])"),
			    tabbable: utils.getCommonFilter("c,cr,s=>for(var i = 0; i < c.length; i ++ )if(dh.tabbable(c[i]))cr.result.push(c[i])")
			},
		    //#end

		    /*	扩展选择器
		    @selectors	:多个选择器
		    @return	:无
		    */
		    extendSelector: function (selectors) {
		        for (var s in selectors)
		            this.executors[s] = selectors[s], this.sTypes.push(s)
		        var reg = this.sTypes.join("").replace(/\s/g, "").replace(utils.relationSelectorRegReplace, '').replace('α', '')
		        this.splitReg = new RegExp(this.splitRegFormat.$format(reg), 'g')
		    },

		    /*	扩展过滤选择器
		    @filters	:多个选择器
		    @return	:无
		    */
		    extendFilter: function (filters) {
		        fly.extendIf(this.filters, filters)
		        for (var k in this.filters)
		            if (k.substr(k.length - 2) == "()") {
		                var n = k.substr(0, k.length - 2)
		                this.filters[n] = this.filters[k]
		                delete this.filters[k]
		                this.needFollows[":" + n] = this.needFollows[" :" + n] = true
		            }
		    },

		    /*	扩展表达式运算符
		    @operators:{String} 多个运算符
		    @return	:无
		    */
		    extendOperator: function (operators) {
		        fly.extend(this.operators, operators)
		    }
		}


            with (executors) {
                nsSelector.Selectors.extendSelector(
			{
			    '*': all,
			    '#': byId,
			    '.': byCss,
			    '$': byName,
			    'α': expression,
			    " ": byTagName,
			    ">": children,
			    "<": getCommonRelationFun("parentNode"),
			    "+": getCommonRelationFun("nextSibling"),
			    "&": getCommonRelationFun("previousSibling"),
			    "~": sibling,
			    ":": filter,
			    "θ": fly.emptyFun
			})
            }
            var inputFilters = {}, ti = -1, iType;
            while (iType = utils.inputTypes[++ti]) {
                inputFilters[iType] = utils.getCommonFilter("c,cr,s=>for(var i = 0; i < c.length; i ++ )if(c[i].type==='" + iType + "')cr.result.push(c[i])")
            }
            nsSelector.Selectors.extendFilter(inputFilters)

            //#end

            //## Engine
            nsSelector.Engine = engine = function (selector, parent) {
                this.parent = parent
                if (parent)
                    this.root = parent.root, this.onlyFilterContext = parent.onlyFilterContext
                else
                    this.root = this
                this.init(selector)
            } .extend(
		{
		    isSimple: true,
		    onlyFilterContext: false,
		    init: function (selector) {
		        if (fly.isString(selector)) {
		            this.selectorStr = this.selector = selector
		            this.setIsSimple(this.onlyFilterContext == false && engine.isSimple(this.selectorStr))
		            if (!this.isSimple) {
		                if (this.selector.indexOf(":") > -1) {
		                    if (this.selector.indexOf(":contains(") > -1)
		                        this.selector = this.selector.replace(utils.containsReg, function ($0, $1) {
		                            return '[innerText*="' + $1 + '"]'
		                        })
		                }
		                if (!this.parent)
		                    this.extractExpression().extractGroups()
		                this.parse()
		            }
		        }
		        else {
		            for (var k in selector)
		                this[k] = selector[k]
		            if (this.type == 'α')
		                this.selector = this.selectorStr = this.root.expressions[this.selector]
		            else if (this.type == "θ")
		                return this.init(this.root.groups[this.selector])

		            if (this.follow)
		                this.follow = new nsSelector.Engine(this.follow, this)

		            this.setIsSimple(this.onlyFilterContext == false && engine.isSimple(this.selectorStr))
		            if (!this.isSimple)
		                this.achieve = executors[this.type]
		        }
		    },
		    setIsSimple: function (isSimple) {
		        this.isSimple = isSimple
		    },
		    isVerySimple: function () {
		        if (this.verySimple != undefined)
		            return this.verySimple

		        if ((this.sequence && this.sequence.length > 0) || (this.childs && this.childs.length > 0))
		            return this.verySimple = false;
		        if (this.verySimple = !utils.verySimpleReg.test(this.selector)) {
		            this.parse()
		            this.achieve = executors[this.type]
		        }
		        return this.verySimple
		    },
		    extractExpression: function (selector) {
		        var es = this.expressions = new Array
		        this.selector = this.selector.replace(utils.expressionOuterReg, function ($0, $1) {
		            es.push($1)
		            return ($0.indexOf('[') > 0 ? ' α' : 'α') + (es.length - 1)
		        })
		        return this
		    },
		    extractGroups: function () {
		        var gs = this.groups = new Array
		        this.selector = this.selector.replace(/\(([^\)]+)\)/g, function ($0, $1) {
		            gs.push($1.$trim())
		            return 'θ' + (gs.length - 1)
		        })
		        return this
		    },
		    makeChilds: function () {
		        this.childs = new Array;
		        var ss = this.selector.split(',')
		        for (var i = 0; i < ss.length; i++)
		            if (ss[i] != "")
		                this.childs.push(new engine(ss[i], this))
		    },
		    makePath: function () {
		        var ss = new Array
		        var hasRelation;
		        if (hasRelation = utils.relationSelectorReg.test(this.selector)) {
		            this.selector = this.selector.replace(utils.relationSelectorRegReplace, function ($0, $1, $2) {
		                return $1.charAt(0) + ($2 == "" ? $1.length : parseInt($2) + $1.length - 1) + " "
		            })
		        }
		        this.selector = this.selector.$trim()
		        var contentStr = (" " + this.selector).replace(nsSelector.Selectors.splitReg, function ($0, $1) {
		            ss.push(
				    {
				        selectorStr: $0,
				        onlyFilterContext: !/^\s/.test($0),
				        type: $1
				    })
		            return "ξ"
		        })
		        ss[0].onlyFilterContext = this.onlyFilterContext
		        var contents = contentStr.substr(1).split("ξ")
		        for (var i = 0; i < contents.length; i++) {
		            var s = ss[i]
		            s.selectorStr += (s.selector = contents[i])
		            if (hasRelation && ss.length > i + 1 && utils.relationSelectorReg.test(s.type))	//w3c css规则
		                ss[i + 1].onlyFilterContext = true
		            else if (s.type == "θ" && i > 0 && s.onlyFilterContext) {
		                var prev = ss[i - 1]
		                if (nsSelector.Selectors.needFollows[prev.selectorStr] == true && prev.follow == null) {
		                    prev.follow = s
		                    ss.splice(i, 1)
		                    contents.splice(i, 1)
		                    i--
		                }
		            }
		        }

		        if (ss.length == 1)
		            this.init(ss[0]), ss = null
		        else
		            for (var i = 0; i < ss.length; i++)
		                ss[i] = new engine(ss[i], this)
		        this.sequence = ss;
		        return this
		    },
		    parse: function (selector) {
		        return this.selector.indexOf(',') > -1 ? this.makeChilds() : this.makePath()
		    },
		    findChilds: function () {
		        var sStr = ""
		        for (var i = 0; i < this.childs.length; i++) {
		            var s = this.childs[i]
		            if (hasQueryMethod && s.isSimple && this.context.isDom != false)
		                sStr += "," + s.selectorStr

		            else {
		                var subResult = new nsSelector.Collector()
		                s.find(this.context, subResult)
		                this.collector.merge(subResult.result)
		            }
		        }
		        if (sStr != "") {
		            var subResult = new nsSelector.Collector()
		            engine.queryByProtogenic(this.context, subResult, sStr.substr(1))
		            this.collector.merge(subResult.result)
		        }
		    },
		    isChilds: function (dom) {
		        for (var i = 0; i < this.childs.length; i++)
		            if (this.childs[i].is(dom, this.context))
		                return true;
		        return false
		    },
		    findPath: function () {
		        var sStr = ""
		        var subResult = new nsSelector.Collector()
		        var newContext = this.context
		        function flush() {
		            if (sStr != "") {
		                engine.queryByProtogenic(newContext, subResult, sStr.substr(1))
		                newContext = subResult.result
		                subResult.clear()
		                sStr = ""
		            }
		        }
		        for (var i = 0; i < this.sequence.length; i++) {
		            var s = this.sequence[i]
		            if (hasQueryMethod && s.isSimple && this.context.isDom != false)
		                sStr += (this.onlyFilterContext ? "" : ' ') + s.selectorStr
		            else {
		                flush()
		                s.find(newContext, subResult)
		                newContext = subResult.result
		                subResult.clear()
		            }
		        }
		        flush()
		        this.collector.merge(newContext)
		    },
		    isPath: function (dom) {
		        var el = dom;
		        for (var i = this.sequence.length - 1; i > -1; i--) {
		            var s = this.sequence[i]
		            while (true) {
		                if (el == null || el.nodeType !== 1)
		                    return false
		                var is = s.is(el, this.context)
		                if (!is) {
		                    if (el == dom)
		                        return false
		                    else
		                        el = el.parentNode;
		                }
		                else {
		                    el = el.parentNode;
		                    break;
		                }
		            }
		        }
		        return true
		    },
		    find: function (context, collector) {
		        if (this.selectorStr == "")
		            return
		        this.context = context
		        this.collector = collector
		        if (this.isSimple && context.isDom != false)
		            engine.queryByProtogenic(context, collector, this.selectorStr)
		        else if (this.childs != null && this.childs.length > 0)
		            this.findChilds()
		        else if (this.sequence != null && this.sequence.length > 0)
		            this.findPath()
		        else
		            this.achieve(context, collector, this)
		    }, filter: function (all, context, collector) {
		        for (var i = 0; i < all.length; i++) {
		            var dom = all[i]
		            if (this.is(dom, context))
		                collector.push(dom)
		        }
		    },
		    is: function (dom, context) {
		        this.context = context
		        if (this.childs != null && this.childs.length > 0)
		            return this.isChilds(dom)
		        else if (this.sequence != null && this.sequence.length > 0)
		            return this.isPath(dom);
		        else if (this.isSimple && this.isVerySimple() == false) {
		            var id = dom.id;
		            var newID = dom.id = "fly_" + Math.random();
		            var newSelector = this.selectorStr + "[id='" + newID + "']"
		            context = context || [doc]
		            for (var i = 0; i < context.length; i++) {
		                if (context[i].querySelector(newSelector))
		                    return true
		            }
		            dom.id = id;
		            return false;
		        }
		        else {
		            var _context = [{ all: [dom]}]
		            _context.isDom = false;
		            var collector = new nsSelector.Collector();
		            this.achieve(_context, collector, this)
		            return collector.result.length > 0
		        }
		    }

		}).extend(nsSelector.Engine)
            engine.utils = utils
            engine.isSimple = function (selector) {
                try {
                    return hasQueryMethod && checkDiv.querySelector(selector) != false
                }
                catch (e) {
                    return false
                }
            }

            engine.queryByProtogenic = function (context, collector, selector) {
                for (var i = 0; i < context.length; i++)
                    collector.merge(context[i].querySelectorAll(selector))
                return collector.result
            }

            engine.cache = {}
            engine.create = function (selector) {
                return engine.cache[selector] || (engine.cache[selector] = new engine(selector))
            }


            //#end

            //## DomQuery
            /*#C path:fly.ui.selector.DomQuery
            Dom对象查询类
            */
            nsSelector.DomQuery = function (context, selectors) {
                this.context = context
                this.selectors = selectors
            } .extend(
		{
		    createResult: function (arr, context) {
		        arr.context = context;
		        arr.isDomArray = true
		        return arr
		    },
		    extractSelectorStr: function () {
		        var s = this.selectorStr = ""
		        for (var i = 0; i < this.selectors.length; i++) {
		            if (fly.isFun(s = this.selectors[i]))
		                fly.onLoad(s)
		            //s = s.call(this, this)
		            if (s == null)
		                continue
		            if (!fly.isString(s))
		                this.collector.push(s)
		            else {
		                if (fly.isHtml(s))
		                    this.collector.merge(dh.create(s))
		                else
		                    this.selectorStr += (this.selectorStr == "" ? '' : ',') + s.replace(utils.trimCommaReg, '')
		            }
		        }
		        return this
		    },
		    /*	查找Dom对象
		    @return	:Array 查找到的Dom对象
		    */
		    find: function () {
		        if (this.selectors.length == 1 && this.selectors[0] && this.selectors[0].$isIEnumerable == true)
		            return this.selectors[0]
		        this.collector = new nsSelector.Collector()
		        this.extractSelectorStr()
		        if (/^\s*$/g.test(this.selectorStr) == false) {
		            this.selector = engine.create(this.selectorStr)
		            this.selector.find(this.context || [doc], this.collector)
		        }

		        this.collector.uniquelize()
		        return this.createResult(this.collector.result, this.context)
		    },
		    filter: function (all) {
		        this.extractSelectorStr()
		        this.selector = engine.create(this.selectorStr)
		        var col = new nsSelector.Collector()
		        this.selector.filter(all, all.context, col);
		        return this.createResult(col.result, this.context)
		    },
		    is: function (all) {
		        this.extractSelectorStr()
		        this.selector = engine.create(this.selectorStr)
		        for (var i = 0; i < all.length; i++)
		            if (this.selector.is(all[i], all.context))
		                return true
		            return false;
		        },

		        /*	匹配所有元素的第一个与表达式匹配的上级元素，
		        @selectors	:String(可选) 选择器
		        @return :Array<Element>
		        */
		        closest: function (all) {
		            var context = all.context, col = new nsSelector.Collector()
		            this.extractSelectorStr()
		            var uCol = new nsSelector.Collector(null, true)
		            if (this.selectors.length == 0)
		                return all;
		            this.selector = engine.create(this.selectorStr)
		            for (var i = 0; i < all.length; i++) {
		                var dom = all[i]
		                while (dom && dom.nodeType === 1 && uCol.push(dom))
		                    if (this.selector.is(dom, context)) {
		                        col.push(dom)
		                        break;
		                    }
		                    else {
		                        dom = dom.parentNode;
		                    }
		            }
		            uCol = null;
		            return this.createResult(col.result, context);
		        },

		        /*	匹配所有元素的第一个与表达式匹配的上级元素，
		        @selectors	:String(可选) 选择器
		        @return :Array<Element>
		        */
		        parent: function (all) {
		            var context = all.context, col = new nsSelector.Collector()
		            this.extractSelectorStr()
		            var uCol = new nsSelector.Collector(null, true)
		            this.selector = this.selectors.length == 0 ? null : engine.create(this.selectorStr)
		            for (var i = 0; i < all.length; i++) {
		                var dom = all[i].parentNode;
		                if (dom && dom.nodeType === 1 && uCol.push(dom) && (!this.selector || this.selector.is(dom, context)))
		                    col.push(dom)
		            }
		            uCol = null
		            return this.createResult(col.result, context);
		        },


		        /*	匹配所有元素的第一个与表达式匹配的上级元素，
		        @selectors	:String(可选) 选择器
		        @return :Array<Element>
		        */
		        parents: function (all) {
		            var context = all.context, col = new nsSelector.Collector()
		            this.extractSelectorStr()
		            var uCol = new nsSelector.Collector(null, true)
		            this.selector = this.selectors.length == 0 ? null : engine.create(this.selectorStr)
		            for (var i = 0; i < all.length; i++) {
		                var dom = all[i]
		                while ((dom = dom.parentNode) && dom.nodeType === 1 && uCol.push(dom))
		                    if (this.selector == null || this.selector.is(dom, context))
		                        col.push(dom)
		            }
		            uCol = null;
		            return this.createResult(col.result, context);
		        }

		    }).extend(nsSelector.DomQuery)
            // 		nsSelector.DomQuery.query = function(selectors) {
            // 			var c = this == win ? null : (this instanceof Array ? this : (fly.likeArray(this) ? fly.toArray(this) : [doc]))
            // 			return (new fly.ui.selector.DomQuery(c, arguments)).find()
            // 		}
            //#end		

            function extendSelectorMethod(method) {
                method = fly.isString(this) ? this : method;
                qp.extend(method, function (selectors) {
                    var q = new fly.ui.selector.DomQuery(this.context, arguments)
                    return q[method](this);
                })
            }
            fly.each(["filter", "is", "closest", "parent", "parents"], extendSelectorMethod)

            qp.extend('$', fly)
            qp.extend('find', fly)

        })();
        //#end

        fly.__onLoad()

        /*	document 对象*/
        fly.doc = fly(docE)
        fly.getBody = function () {
            /*	document.body 对象*/
            if (fly.body)
                return fly.body
            if (!doc.body)
                return null
            return fly.body = fly(doc.body)
        }
    }
    $$contexts.$(this);


    //alert(new Date()-ddd)
