/*
 * Decompiled with CFR 0.152.
 */
package org.ajaxrpc;

import java.io.IOException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.ajaxrpc.HttpContext;
import org.ajaxrpc.JSON;
import org.ajaxrpc.Loader;
import org.ajaxrpc.StringUtil;

public class AJAXRPC_Script {
    public Loader loader;

    public AJAXRPC_Script(Loader loader) {
        this.loader = loader;
    }

    public AJAXRPC_Script(String rpcPath) {
        Loader loader = null;
        try {
            loader = Loader.getInstance(rpcPath);
        }
        catch (Exception e) {
            e.printStackTrace();
            HashMap<String, Object> result = new HashMap<String, Object>();
            result.put("error", -1);
            result.put("message", "rpc config file error");
            result.put("description", e.getMessage());
            String json = JSON.encode(result);
            try {
                HttpContext.response.getWriter().write(JSON.encode(result));
            }
            catch (IOException e1) {
                e1.printStackTrace();
            }
        }
        this.loader = loader;
    }

    public String getScripts() {
        String scripts = "";
        Map kv = this.loader.classes;
        for (Map.Entry entry : kv.entrySet()) {
            scripts = String.valueOf(scripts) + this.getScript(((String)entry.getKey()).toString());
        }
        return scripts;
    }

    public String getScript(String className) {
        Map cls = (Map)this.loader.classes.get(className);
        if (cls == null) {
            return "";
        }
        Class c = (Class)cls.get("class");
        List methods = (List)cls.get("methods");
        ArrayList<String> methodNames = new ArrayList<String>();
        int i = 0;
        int l = methods.size();
        while (i < l) {
            Method method = (Method)methods.get(i);
            String methodName = method.getName();
            methodNames.add("'" + methodName + "'");
            ++i;
        }
        String scripts = "Edo.rpc.Client.regService('" + className + "', [";
        scripts = String.valueOf(scripts) + StringUtil.join(methodNames, ", ");
        scripts = String.valueOf(scripts) + "]);\n";
        return scripts;
    }
}

