/*
 * Decompiled with CFR 0.152.
 */
package org.ajaxrpc;

import java.beans.BeanInfo;
import java.beans.IntrospectionException;
import java.beans.Introspector;
import java.beans.PropertyDescriptor;
import java.lang.reflect.Array;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class Convert {
    public static Map beanClasses = new HashMap();

    public static Integer toInt(Object o) {
        if (o == null) {
            o = 0;
        }
        return Integer.parseInt(o.toString());
    }

    public static Long toLong(Object o) {
        if (o == null) {
            o = 0;
        }
        return Long.parseLong(o.toString());
    }

    public static Float toFloat(Object o) {
        if (o == null) {
            o = 0;
        }
        return Float.valueOf(Float.parseFloat(o.toString()));
    }

    public static Double toDouble(Object o) {
        if (o == null) {
            o = 0;
        }
        return Double.parseDouble(o.toString());
    }

    public static Short toShort(Object o) {
        if (o == null) {
            o = 0;
        }
        return Short.parseShort(o.toString());
    }

    public static Boolean toBoolean(Object o) {
        if (o == null) {
            o = false;
        }
        return Boolean.parseBoolean(o.toString());
    }

    public static Character toChar(Object o) {
        if (o == null) {
            o = "";
        }
        return (Character)o;
    }

    public static Object toClass(Object object, Class cls) throws Exception {
        if (object == null) {
            return null;
        }
        if (cls == Map.class) {
            return (Map)object;
        }
        if (cls == HashMap.class) {
            return (HashMap)object;
        }
        if (cls == ArrayList.class) {
            return (ArrayList)object;
        }
        if (cls == List.class) {
            return (List)object;
        }
        if (cls == Boolean.class || cls == Boolean.TYPE) {
            return Convert.toBoolean(object);
        }
        if (cls == Double.class || cls == Double.TYPE) {
            return Convert.toDouble(object);
        }
        if (cls == Float.class || cls == Float.TYPE) {
            return Convert.toFloat(object);
        }
        if (cls == Long.class || cls == Long.TYPE) {
            return Convert.toLong(object);
        }
        if (cls == Short.class || cls == Short.TYPE) {
            return Convert.toShort(object);
        }
        if (cls == Integer.class || cls == Integer.TYPE) {
            return Convert.toInt(object);
        }
        if (cls == Character.class || cls == Character.TYPE) {
            return (Character)object;
        }
        if (cls == Byte.class) {
            return (Byte)object;
        }
        if (cls == String.class) {
            return object.toString();
        }
        if (cls == Date.class) {
            return (Date)object;
        }
        if (cls == Object.class) {
            return object;
        }
        if (cls.isArray()) {
            return Convert.toArray((List)object, cls);
        }
        return Convert.toClass((Map)object, cls);
    }

    public static Object toArray(List list, Class arrayClass) throws Exception {
        Class<?> type = arrayClass.getComponentType();
        Object objs = Array.newInstance(type, list.size());
        int i = 0;
        int l = list.size();
        while (i < l) {
            Object o = Convert.toClass(list.get(i), type);
            Array.set(objs, i, o);
            ++i;
        }
        return objs;
    }

    public static Object toClass(Map jso, Class clazz) throws Exception {
        if (jso == null) {
            return null;
        }
        Object instance = null;
        try {
            instance = clazz.newInstance();
        }
        catch (Exception e) {
            throw new Exception("can't instantiate bean " + clazz.getName() + ": " + e.getMessage());
        }
        Object[] invokeArgs = new Object[1];
        for (String field : jso.keySet()) {
            Object fieldVal;
            Method setMethod = Convert.getSetMethod(clazz, field);
            if (setMethod == null) continue;
            try {
                Class<?>[] param = setMethod.getParameterTypes();
                fieldVal = Convert.toClass(jso.get(field), param[0]);
            }
            catch (Exception e) {
                throw new Exception("bean " + clazz.getName() + " " + e.getMessage());
            }
            invokeArgs[0] = fieldVal;
            try {
                setMethod.invoke(instance, invokeArgs);
            }
            catch (Throwable e) {
                if (e instanceof InvocationTargetException) {
                    e = ((InvocationTargetException)e).getTargetException();
                }
                throw new Exception("bean " + clazz.getName() + "can't invoke " + setMethod.getName() + ": " + e.getMessage());
            }
        }
        return instance;
    }

    public static Method getSetMethod(Class clazz, String field) throws IntrospectionException {
        Map beanClass = Convert.getBeanClass(clazz);
        Map writableProps = (Map)beanClass.get("writableProps");
        Method setMethod = (Method)writableProps.get(field);
        return setMethod;
    }

    public static Map getBeanClass(Class clazz) throws IntrospectionException {
        HashMap<String, Object> beanClass = (HashMap<String, Object>)beanClasses.get(clazz.toString());
        if (beanClass != null) {
            return beanClass;
        }
        beanClass = new HashMap<String, Object>();
        beanClasses.put(clazz.toString(), beanClass);
        BeanInfo beanInfo = Introspector.getBeanInfo(clazz, Object.class);
        HashMap<String, Method> readableProps = new HashMap<String, Method>();
        HashMap<String, Method> writableProps = new HashMap<String, Method>();
        PropertyDescriptor[] props = beanInfo.getPropertyDescriptors();
        int i = 0;
        while (i < props.length) {
            if (props[i].getWriteMethod() != null) {
                writableProps.put(props[i].getName(), props[i].getWriteMethod());
            }
            if (props[i].getReadMethod() != null) {
                readableProps.put(props[i].getName(), props[i].getReadMethod());
            }
            ++i;
        }
        beanClass.put("beanInfo", beanInfo);
        beanClass.put("readableProps", readableProps);
        beanClass.put("writableProps", writableProps);
        return beanClass;
    }
}

