/*
 * Decompiled with CFR 0.152.
 */
package org.ajaxrpc;

import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.ajaxrpc.Convert;
import org.ajaxrpc.Loader;

public class Invoker {
    public Map classes;
    public Loader loader;

    public Invoker(Loader loader) {
        this.loader = loader;
        this.classes = loader.classes;
    }

    public Object invoke(String className, String methodName, List params) throws Exception {
        Map cls = (Map)this.classes.get(className);
        if (cls == null) {
            throw new Exception("not match class:" + className);
        }
        Class c = (Class)cls.get("class");
        Map methodMap = this.findMethod(className, methodName, params);
        if (methodMap == null) {
            throw new Exception("not match method:" + className + "." + methodName);
        }
        Method method = (Method)methodMap.get("method");
        List args = (List)methodMap.get("args");
        return method.invoke(null, args.toArray());
    }

    public Map findMethod(String className, String methodName, List args) {
        Map cls = (Map)this.classes.get(className);
        if (cls == null) {
            return null;
        }
        List methods = (List)cls.get("methods");
        int i = 0;
        int l = methods.size();
        while (i < l) {
            Method method = (Method)methods.get(i);
            Class<?>[] parameters = method.getParameterTypes();
            if (method.getName().equals(methodName) && parameters.length == args.size()) {
                try {
                    ArrayList<Object> newArgs = new ArrayList<Object>();
                    int j = 0;
                    while (j < args.size()) {
                        newArgs.add(Convert.toClass(args.get(j), parameters[j]));
                        ++j;
                    }
                    HashMap<String, Object> ret = new HashMap<String, Object>();
                    ret.put("method", method);
                    ret.put("args", newArgs);
                    return ret;
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
            ++i;
        }
        return null;
    }
}

