/*
 * Decompiled with CFR 0.152.
 */
package org.ajaxrpc;

import java.io.File;
import java.io.Serializable;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import javax.servlet.ServletException;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;

public class Loader {
    private static Loader instance;
    public Map classes = new HashMap();

    public static synchronized Loader getInstance(String xmlPath) {
        if (instance == null) {
            instance = new Loader(xmlPath);
        }
        return instance;
    }

    public Loader() {
        this.loadRPC("rpc_config.xml");
    }

    public Loader(String xmlPath) {
        this.loadRPC(xmlPath);
    }

    public void loadRPC(String xmlPath) {
        this.classes = new HashMap();
        try {
            String path = Thread.currentThread().getContextClassLoader().getResource("").getPath().toString().split("classes")[0];
            DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
            DocumentBuilder builder = factory.newDocumentBuilder();
            Document document = builder.parse(new File(String.valueOf(path) + xmlPath));
            Element rootElement = document.getDocumentElement();
            NodeList list = rootElement.getElementsByTagName("service");
            Integer i = 0;
            while (i < list.getLength()) {
                Element element = (Element)list.item(i);
                String id = element.getAttribute("id");
                String mapping = element.getAttribute("class");
                try {
                    Class<?> c = Class.forName(mapping);
                    HashMap<String, Serializable> cls = new HashMap<String, Serializable>();
                    cls.put("class", c);
                    ArrayList<Method> methods = new ArrayList<Method>();
                    cls.put("methods", methods);
                    Method[] ms = c.getMethods();
                    int k = 0;
                    while (k < ms.length) {
                        int mod;
                        Method m = ms[k];
                        String methodName = m.getName();
                        if (m.getDeclaringClass() != Object.class && Modifier.isPublic(mod = m.getModifiers()) && Modifier.isStatic(mod)) {
                            methods.add(m);
                        }
                        ++k;
                    }
                    this.classes.put(id, cls);
                }
                catch (Exception e) {
                    e.printStackTrace();
                    throw new ServletException((Throwable)e);
                }
                i = i + 1;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }
}

