package test;

import java.sql.SQLException;
import java.text.SimpleDateFormat;
import java.util.*;

import Edo.sql.DaoFactory;
import Edo.util.*;

public class UserService {
	public static String addUser(Map user) throws SQLException{
		
		String id = Edo.util.UUID.randomUUID().toString();
		
		user.put("id", id);
        DaoFactory.getDao().insert("TEST.insertUser", user);	 
	        	
		return id;
	}
	public static void deleteUsers(List users) throws SQLException{		
		for (int i = 0, l = users.size(); i < l; i++)
        {
            Map u = (Map)users.get(i);
            DaoFactory.getDao().delete("TEST.deleteUser", u);
        } 	      
	}
	public static void updateUser(Map u) throws SQLException{		
		Map user = (Map)DaoFactory.getDao().queryForObject("TEST.getUserByID", u);
        
		//copy user's properties
        Map<String, Integer> kv = (Map<String, Integer>)u;            
        for(Map.Entry<String, Integer> entry : kv.entrySet()){                               
        	user.put(entry.getKey(),  entry.getValue());
        }   
        
        DaoFactory.getDao().delete("TEST.deleteUser", user);
        DaoFactory.getDao().insert("TEST.insertUser", user);    
	}
	public static Map getUserByID(String userID) throws SQLException{		
		Map user = (Map) DaoFactory.getDao().queryForObject("TEST.getUserByID", userID);
		return user;
	}
	public static List searchUsers(Map queryParams) throws SQLException{
		
    	int adsearch = Convert.toInt(queryParams.get("adsearch"));
        int gender = Convert.toInt(queryParams.get("gender"));
        String country = StringUtil.toString(queryParams.get("country"));                    
        String startdate = StringUtil.toString(queryParams.get("startdate"));
        String finishdate = StringUtil.toString(queryParams.get("finishdate"));                    

        String where = "";
        if (adsearch == 1)
        {
            if (gender != -1)
            {
                where += " and gender=" + gender;
            }               
            if (country != "-1")
            {
                where += " and country='" + country + "'";
            }                       
        }
        Date start = DateUtil.createDate(1960, 1, 1);
        Date finish = DateUtil.createDate(5000, 1, 1);  
         
        SimpleDateFormat sdf =   new SimpleDateFormat("yyyy-MM-dd");
        try{
        	start = sdf.parse(startdate);
        }catch(Exception ex){
        	
        }
        try{
        	finish = sdf.parse(finishdate);
        }catch(Exception ex){
        	
        }
        
        queryParams.put("key", "%" + queryParams.get("key").toString() + "%");
        queryParams.put("where",  where);
        queryParams.put("startdate", start);
        queryParams.put("finishdate", finish);
        List users = DaoFactory.getDao().queryForList("TEST.getUsers", queryParams);
        
        return users;
        
	}
	public static void save(Map usersave){
		List adds = (List)usersave.get("adds");
		List updates = (List)usersave.get("updates");
		List dels = (List)usersave.get("dels");
						
		try {
			DaoFactory.getDao().startTransaction();
								
			//新增用户
			for(int i=0,l=adds.size();i<l;i++){
				addUser((Map)adds.get(i));
			}
			//更新用户
			for(int i=0,l=updates.size();i<l;i++){
				updateUser((Map)updates.get(i));
			}		
			//删除用户
			deleteUsers(dels);			
			
			DaoFactory.getDao().commitTransaction();
		} catch (Exception e) {
			e.printStackTrace();			
		}finally{
			try {
				DaoFactory.getDao().endTransaction();
			} catch (SQLException e) {			
				e.printStackTrace();
			}
		}		
	}	
}
