﻿using System;
using System.Collections;
using IBatisNet.DataMapper;
using IBatisNet.DataAccess;

using System.Collections.Generic;

namespace Test
{
    public class UserService
    {        
        public static String addUser(Hashtable user)
        {

            String id = Guid.NewGuid().ToString();

            user["id"] = id;

            ISqlMapper sqlMap = Mapper.Instance();
            sqlMap.Insert("TEST.insertUser", user);

            return id;
        }

        public static void deleteUsers(ArrayList users)
        {
            ISqlMapper sqlMap = Mapper.Instance();
            for (int i = 0, l = users.Count; i < l; i++)
            {
                Hashtable u = (Hashtable)users[i];
                sqlMap.Delete("TEST.deleteUser", u);
            }
        }
        public static void updateUser(Hashtable u)
        {
            ISqlMapper sqlMap = Mapper.Instance();
            Hashtable user = (Hashtable)sqlMap.QueryForObject("TEST.getUserByID", u);
            foreach (DictionaryEntry kv in u)
            {
                user[kv.Key] = kv.Value;
            }
            sqlMap.Delete("TEST.deleteUser", user);
            sqlMap.Insert("TEST.insertUser", user);
        }
        public static Hashtable getUserByID(String userID)
        {
            ISqlMapper sqlMap = Mapper.Instance();
            return (Hashtable)sqlMap.QueryForObject("TEST.getUserByID", userID);
        }
        public static ArrayList searchUsers(Hashtable queryParams)
        {

            int adsearch = Convert.ToInt32(queryParams["adsearch"]);
            int gender = Convert.ToInt32(queryParams["gender"]);
            string country = Convert.ToString(queryParams["country"]);
            string startdate = Convert.ToString(queryParams["startdate"]);
            string finishdate = Convert.ToString(queryParams["finishdate"]);

            string where = "";
            if (adsearch == 1)
            {
                if (gender != -1)
                {
                    where += " and gender=" + gender;
                }
                if (country != "-1")
                {
                    where += " and country='" + country + "'";
                }
            }
            DateTime start = new DateTime(1960, 1, 1);
            try
            {
                start = Convert.ToDateTime(startdate);
            }
            catch (Exception ex)
            {
            }
            DateTime finish = new DateTime(5000, 1, 1);
            try
            {
                finish = Convert.ToDateTime(finishdate);
            }
            catch (Exception ex)
            {
            }
            queryParams["key"] = "%" + queryParams["key"] + "%";
            queryParams["where"] = where;
            queryParams["startdate"] = start;
            queryParams["finishdate"] = finish;

            return (ArrayList)Mapper.Instance().QueryForList("TEST.getUsers", queryParams);

        }
        public static void save(Hashtable usersave) 
        {            
            ArrayList adds = (ArrayList)usersave["adds"];
            ArrayList updates = (ArrayList)usersave["updates"];
            ArrayList dels = (ArrayList)usersave["dels"];

            ISqlMapper sqlMap = Mapper.Instance();
            try
            {
                sqlMap.BeginTransaction();

                //新增用户
                for (int i = 0, l = adds.Count; i < l; i++)
                {
                    addUser((Hashtable)adds[i]);
                }
                //更新用户
                for (int i = 0, l = updates.Count; i < l; i++)
                {
                    updateUser((Hashtable)updates[i]);
                }
                //删除用户
                deleteUsers(dels);

                sqlMap.CommitTransaction();
            }
            catch (Exception e)
            {
                sqlMap.RollBackTransaction();
                throw new Exception(e.Message);
            }
        }
    }
}