﻿var MapClasses = {"Edo.util.Dom":{"name":"Edo.util.Dom","class":true,"description":"Dom操作类","functions":[{"name":"addListener","function":true,"description":"监听dom事件","params":[{"type":"Element/String","name":"el","description":"目标dom元素或dom的id字符串"},{"type":"String","name":"type","description":"事件名"},{"type":"Function","name":"fn","description":"事件监听器方法"},{"type":"Object","name":"scope","description":"激发事件时的this对象"}],"return":{"type":"Boolean","description":"是否绑定成功"},"exception":true,"definedby":"Edo.util.Dom"},{"name":"removeListener","function":true,"description":"去除监听dom事件","params":[{"type":"Element/String","name":"el","description":"目标dom元素或dom的id字符串"},{"type":"String","name":"type","description":"事件名"},{"type":"Function","name":"fn","description":"事件监听器方法"},{"type":"Object","name":"scope","description":"激发事件时的this对象"}],"return":{"type":"Boolean","description":"是否绑定成功"},"exception":true,"definedby":"Edo.util.Dom"},{"name":"findListener","function":true,"description":"寻找监听dom事件","params":[{"type":"Element/String","name":"el","description":"目标dom元素或dom的id字符串"},{"type":"String","name":"type","description":"事件名"},{"type":"Function","name":"fn","description":"事件监听器方法"},{"type":"Object","name":"scope","description":"激发事件时的this对象"}],"return":{"type":"Boolean","description":"是否找到dom的监听事件"},"exception":true,"definedby":"Edo.util.Dom"},{"name":"clearEvent","function":true,"description":"清除监听dom事件","params":[{"type":"Element/String","name":"el","description":"目标dom元素或dom的id字符串"},{"type":"String","name":"type","description":"事件类型名"}],"return":{"type":"Boolean"},"exception":true,"definedby":"Edo.util.Dom"},{"name":"swallowEvent","function":true,"description":"阻止事件","params":[{"type":"Element/String","name":"el","description":"目标dom元素或dom的id字符串"},{"type":"String","name":"eventName","description":"事件名"},{"type":"Boolean","name":"preventDefault","description":"是否阻止默认行为"}],"exception":true,"definedby":"Edo.util.Dom"},{"name":"addClass","function":true,"description":"增加样式","params":[{"type":"Element/String","name":"el","description":"目标dom元素或dom的id字符串"},{"type":"String","name":"className","description":"样式类名"}],"exception":true,"definedby":"Edo.util.Dom"},{"name":"removeClass","function":true,"description":"去除样式","params":[{"type":"Element/String","name":"el","description":"目标dom元素或dom的id字符串"},{"type":"String","name":"className","description":"样式类名"}],"exception":true,"definedby":"Edo.util.Dom"},{"name":"hasClass","function":true,"description":"判断是否有样式","params":[{"type":"Element/String","name":"el","description":"目标dom元素或dom的id字符串"},{"type":"String","name":"className","description":"样式类名"}],"exception":true,"definedby":"Edo.util.Dom"},{"name":"toggleClass","function":true,"description":"替换样式","params":[{"type":"Element/String","name":"el","description":"目标dom元素或dom的id字符串"},{"type":"String","name":"className","description":"样式类名"}],"exception":true,"definedby":"Edo.util.Dom"},{"name":"replaceClass","function":true,"description":"替换样式","params":[{"type":"Element/String","name":"el","description":"目标dom元素或dom的id字符串"},{"type":"String","name":"oldCls","description":"旧样式类名"},{"type":"String","name":"newCls","description":"新样式类名"}],"exception":true,"definedby":"Edo.util.Dom"},{"name":"getStyles","function":true,"description":"获取styles属性集合","params":[{"type":"Element/String","name":"el","description":"目标dom元素或dom的id字符串"}],"return":{"type":"Object","description":"样式属性对象,如"},"exception":true,"definedby":"Edo.util.Dom"},{"name":"getStyle","function":true,"description":"获取style属性","params":[{"type":"Element/String","name":"el","description":"目标dom元素或dom的id字符串"},{"type":"String","name":"name","description":"属性名"}],"return":{"type":"String","description":"样式属性值"},"exception":true,"definedby":"Edo.util.Dom"},{"name":"setStyle","function":true,"description":"设置style属性","params":[{"type":"Element/String","name":"el","description":"目标dom元素或dom的id字符串"},{"type":"String","name":"property","description":"属性名"},{"type":"Object","name":"value","description":"属性值"}],"exception":true,"definedby":"Edo.util.Dom"},{"name":"isStyle","function":true,"description":"判断是否有style属性","params":[{"type":"Element/String","name":"el","description":"目标dom元素或dom的id字符串"},{"type":"String","name":"property","description":"属性名"},{"type":"Object","name":"value","description":"属性值"}],"return":{"type":"Boolean","description":"是否符合"},"exception":true,"definedby":"Edo.util.Dom"},{"name":"getMargins","function":true,"description":"获取dom的margin属性","params":[{"type":"Element/String","name":"el","description":"目标dom元素或dom的id字符串"}],"return":{"type":"Object","description":"返回{left:"},"exception":true,"definedby":"Edo.util.Dom"},{"name":"getBorderWidth","function":true,"description":"获取dom的边框宽度","params":[{"type":"Element/String","name":"el","description":"目标dom元素或dom的id字符串"}],"return":{"type":"Object","description":"返回{left:"},"exception":true,"definedby":"Edo.util.Dom"},{"name":"getPadding","function":true,"description":"获取dom的padding属性","params":[{"type":"Element/String","name":"el","description":"目标dom元素或dom的id字符串"}],"return":{"type":"Object","description":"返回{left:"},"exception":true,"definedby":"Edo.util.Dom"},{"name":"setWidth","function":true,"params":[{"type":"Element/String","name":"el","description":"目标dom元素或dom的id字符串"},{"type":"Number","name":"width","description":"宽度"}],"description":"设置宽度","exception":true,"definedby":"Edo.util.Dom"},{"name":"getWidth","function":true,"description":"获取宽度","params":[{"type":"Element/String","name":"el","description":"目标dom元素或dom的id字符串"}],"return":{"type":"Number","description":"高度值"},"exception":true,"definedby":"Edo.util.Dom"},{"name":"setHeight","function":true,"params":[{"type":"Element/String","name":"el","description":"目标dom元素或dom的id字符串"},{"type":"Number","name":"height","description":"高度"}],"description":"设置宽度","exception":true,"definedby":"Edo.util.Dom"},{"name":"getHeight","function":true,"description":"获取高度","params":[{"type":"Element/String","name":"el","description":"目标dom元素或dom的id字符串"}],"return":{"type":"Number","description":"高度值"},"exception":true,"definedby":"Edo.util.Dom"},{"name":"getViewWidth","function":true,"description":"获取可视区宽度","params":[{"type":"Element/String","name":"el","description":"目标dom元素或dom的id字符串"}],"return":{"type":"Number","description":"返回可视区宽度"},"exception":true,"definedby":"Edo.util.Dom"},{"name":"getViewHeight","function":true,"description":"获取可视区高度","params":[{"type":"Element/String","name":"el","description":"目标dom元素或dom的id字符串"}],"return":{"type":"Number","description":"返回可视区高度"},"exception":true,"definedby":"Edo.util.Dom"},{"name":"getViewSize","function":true,"description":"获取可视区尺寸","params":[{"type":"Element/String","name":"el","description":"目标dom元素或dom的id字符串"}],"return":{"type":"Number","description":"返回可视区尺寸"},"exception":true,"definedby":"Edo.util.Dom"},{"name":"getScrollWidth","function":true,"description":"获取滚动区宽度","params":[{"type":"Element/String","name":"el","description":"目标dom元素或dom的id字符串"}],"return":{"type":"Number","description":"返回滚动区宽度"},"exception":true,"definedby":"Edo.util.Dom"},{"name":"getScrollHeight","function":true,"description":"获取滚动区高度","params":[{"type":"Element/String","name":"el","description":"目标dom元素或dom的id字符串"}],"return":{"type":"Number","description":"返回滚动区高度"},"exception":true,"definedby":"Edo.util.Dom"},{"name":"getScrollSize","function":true,"description":"获取滚动区尺寸","params":[{"type":"Element/String","name":"el","description":"目标dom元素或dom的id字符串"}],"return":{"type":"Number","description":"返回滚动区尺寸"},"exception":true,"definedby":"Edo.util.Dom"},{"name":"getScrollSize","function":true,"description":"获得目标元素的当前滚动条偏移","params":[{"type":"Element/String","name":"el","description":"目标dom元素或dom的id字符串"}],"return":{"type":"Number","description":"返回偏移尺寸"},"exception":false},{"name":"isScrollable","function":true,"description":"判断是否有滚动尺寸","params":[{"type":"Element/String","name":"el","description":"目标dom元素或dom的id字符串"}],"return":{"type":"Boolean"},"exception":true,"definedby":"Edo.util.Dom"},{"name":"setX","function":true,"description":"设置X","params":[{"type":"Element/String","name":"el","description":"目标dom元素或dom的id字符串"},{"type":"Number","name":"x"}],"exception":true,"definedby":"Edo.util.Dom"},{"name":"setY","function":true,"description":"设置Y","params":[{"type":"Element/String","name":"el","description":"目标dom元素或dom的id字符串"},{"type":"Number","name":"y"}],"exception":true,"definedby":"Edo.util.Dom"},{"name":"setXY","function":true,"description":"设置XY","params":[{"type":"Element/String","name":"el","description":"目标dom元素或dom的id字符串"},{"type":"Number","name":"xy"}],"exception":true,"definedby":"Edo.util.Dom"},{"name":"getXY","function":true,"description":"获取XY","params":[{"type":"Element/String","name":"el","description":"目标dom元素或dom的id字符串"}],"return":{"type":"Array","description":"[x,"},"exception":true,"definedby":"Edo.util.Dom"},{"name":"setSize","function":true,"description":"设置尺寸","params":[{"type":"Element/String","name":"el","description":"目标dom元素或dom的id字符串"},{"type":"Number","name":"width"},{"type":"Number","name":"height"}],"exception":true,"definedby":"Edo.util.Dom"},{"name":"getSize","function":true,"description":"获取尺寸","params":[{"type":"Element/String","name":"el","description":"目标dom元素或dom的id字符串"}],"return":{"type":"Object","description":"{width,"},"exception":true,"definedby":"Edo.util.Dom"},{"name":"setBox","function":true,"description":"设置坐标和尺寸","params":[{"type":"Element/String","name":"el","description":"目标dom元素或dom的id字符串"},{"type":"Object","name":"box","description":"{x,"}],"exception":true,"definedby":"Edo.util.Dom"},{"name":"getBox","function":true,"description":"获取坐标和尺寸","params":[{"type":"Element/String","name":"el","description":"目标dom元素或dom的id字符串"}],"return":{"type":"Object","description":"{x,"},"exception":true,"definedby":"Edo.util.Dom"},{"name":"clearOpacity","function":true,"description":"清除透明度","params":[{"type":"Element/String","name":"el","description":"目标dom元素或dom的id字符串"}],"exception":true,"definedby":"Edo.util.Dom"},{"name":"setOpacity","function":true,"description":"设置透明度","params":[{"type":"Element/String","name":"el","description":"目标dom元素或dom的id字符串"},{"type":"Number","name":"opacity","description":"透明度值,"}],"exception":true,"definedby":"Edo.util.Dom"},{"name":"getOpacity","function":true,"description":"获取透明度","params":[{"type":"Element/String","name":"el","description":"目标dom元素或dom的id字符串"}],"return":{"type":"Number","description":"透明度值"},"exception":true,"definedby":"Edo.util.Dom"},{"name":"remove","function":true,"description":"删除元素","params":[{"type":"Element/String","name":"el","description":"目标dom元素或dom的id字符串"}],"exception":true,"definedby":"Edo.util.Dom"},{"name":"insertHtml","function":true,"description":"添加html","params":[{"type":"Element/String","name":"parentElement","description":"目标父元素"},{"type":"String","name":"html","description":"添加的html代码"},{"type":"String","name":"where","description":"添加位置:"}],"return":{"type":"Element","description":"dom元素"},"exception":true,"definedby":"Edo.util.Dom"},{"name":"insertElement","function":true,"description":"添加dom","params":[{"type":"Element/String","name":"parentElement","description":"目标父元素"},{"type":"Element","name":"el","description":"需要添加的dom"},{"type":"String","name":"where","description":"添加位置:"}],"return":{"type":"Element","description":"dom元素"},"exception":true,"definedby":"Edo.util.Dom"},{"name":"insert","function":true,"description":"添加元素","params":[{"type":"Element/String","name":"parentElement","description":"目标父元素"},{"type":"String","name":"c","description":"被添加的元素"},{"type":"String","name":"where","description":"添加位置"}],"return":{"type":"Element","description":"dom元素"},"exception":true,"definedby":"Edo.util.Dom"},{"name":"append","function":true,"description":"将指定的dom添加到目标元素内的最后","params":[{"type":"Element/String","name":"el","description":"目标dom元素或dom的id字符串"},{"type":"String","name":"c","description":"需要添加的dom"}],"return":{"type":"Element","description":"dom元素"},"exception":true,"definedby":"Edo.util.Dom"},{"name":"preend","function":true,"description":"将指定的dom添加到目标元素内的第一","params":[{"type":"Element/String","name":"parentElement","description":"目标父元素"},{"type":"String","name":"c","description":"需要添加的dom"}],"return":{"type":"Element","description":"dom元素"},"exception":true,"definedby":"Edo.util.Dom"},{"name":"after","function":true,"description":"将指定的dom添加到目标元素的后面","params":[{"type":"Element/String","name":"parentElement","description":"目标父元素"},{"type":"String","name":"c","description":"需要添加的dom"}],"return":{"type":"Element","description":"dom元素"},"exception":true,"definedby":"Edo.util.Dom"},{"name":"before","function":true,"description":"将指定的dom添加到目标元素内的前面","params":[{"type":"Element/String","name":"parentElement","description":"目标父元素"},{"type":"String","name":"c","description":"需要添加的dom"}],"exception":true,"definedby":"Edo.util.Dom"},{"name":"overwrite","function":true,"description":"覆盖增加新的dom元素","params":[{"type":"Element/String","name":"parentElement","description":"目标父元素"},{"type":"String","name":"c","description":"需要添加的dom"}],"exception":true,"definedby":"Edo.util.Dom"},{"name":"replace","function":true,"description":"替换,将name2替换到name1的位置,name1被删除","params":[{"type":"Element/String","name":"parentElement","description":"目标父元素"},{"type":"dom","name":"name2","description":"替换的dom元素"}],"exception":true,"definedby":"Edo.util.Dom"},{"name":"empty","function":true,"description":"清空","params":[{"type":"Element/String","name":"parentElement","description":"目标父元素"}],"exception":true,"definedby":"Edo.util.Dom"},{"name":"isAncestor","function":true,"description":"判断是否存在父子关系","params":[{"type":"Element/String","name":"parentElement","description":"目标父元素"},{"type":"Element","name":"el","description":"子元素"}],"return":{"type":"Boolean"},"exception":true,"definedby":"Edo.util.Dom"},{"name":"findParent","function":true,"description":"查找目标元素的指定样式的父元素","params":[{"type":"Element/String","name":"parentElement","description":"目标父元素"},{"type":"dom","name":"dom2","description":"dom元素"},{"type":"Number","name":"number","description":"查找的层级数"}],"return":{"type":"Boolean"},"exception":true,"definedby":"Edo.util.Dom"},{"name":"mask","function":true,"description":"遮罩","params":[{"type":"Element/String","name":"el","description":"目标dom元素或dom的id字符串"},{"type":"String","name":"html","description":"遮罩内容"},{"type":"String","name":"msgCls","description":"遮罩样式"}],"exception":true,"definedby":"Edo.util.Dom"},{"name":"unmask","function":true,"description":"去除遮罩","params":[{"type":"Element/String","name":"el","description":"目标dom元素或dom的id字符串"}],"exception":true,"definedby":"Edo.util.Dom"},{"name":"isMasked","function":true,"description":"判断是否存在遮罩","params":[{"type":"Element/String","name":"el","description":"目标dom元素或dom的id字符串"}],"return":{"type":"Boolean"},"exception":true,"definedby":"Edo.util.Dom"},{"name":"focus","function":true,"description":"获取焦点","params":[{"type":"Element/String","name":"el","description":"目标dom元素或dom的id字符串"}],"exception":true,"definedby":"Edo.util.Dom"},{"name":"focus","function":true,"description":"失去焦点","params":[{"type":"Element/String","name":"el","description":"目标dom元素或dom的id字符串"}],"exception":false},{"name":"selectable","function":true,"description":"设置目标元素是否可选中","params":[{"type":"Element/String","name":"el","description":"目标dom元素或dom的id字符串"},{"type":"Boolean","name":"isSelected","description":"是否可选中"}],"exception":true,"definedby":"Edo.util.Dom"},{"name":"getOuterHtml","function":true,"description":"获取目标dom内部的html","params":[{"type":"Element/String","name":"el","description":"目标dom元素或dom的id字符串"}],"return":{"type":"String","description":"元素的OuterHtml字符串"},"exception":true,"definedby":"Edo.util.Dom"},{"name":"setOuterHtml","function":true,"description":"设置目标dom内部的html","params":[{"type":"Element/String","name":"el","description":"目标dom元素或dom的id字符串"},{"type":"String","name":"value","description":"html字符串"}],"exception":true,"definedby":"Edo.util.Dom"},{"name":"hover","function":true,"description":"让dom元素具有高亮显示","params":[{"type":"Element/String","name":"el","description":"目标dom元素或dom的id字符串"},{"type":"String","name":"name1","description":"事件名"},{"type":"String","name":"name2","description":"事件名"},{"type":"Object","name":"scope","description":"激发事件时的this对象"}],"exception":true,"definedby":"Edo.util.Dom"},{"name":"hover","function":true,"description":"当鼠标移动到目标元素时,给目标元素添加样式.","params":[{"type":"Element/String","name":"el","description":"目标dom元素或dom的id字符串"},{"type":"String","name":"className","description":"样式名"}],"exception":false},{"name":"hover","function":true,"description":"当获取到目标元素焦点时,给目标元素添加样式.","params":[{"type":"Element/String","name":"el","description":"目标dom元素或dom的id字符串"},{"type":"String","name":"className","description":"样式名"}],"exception":false},{"name":"hover","function":true,"description":"当鼠标点击目标元素时,给目标元素添加样式.","params":[{"type":"Element/String","name":"el","description":"目标dom元素或dom的id字符串"},{"type":"String","name":"className","description":"样式名"}],"exception":false}],"icon":"class","showname":"Dom","namespace":"Edo.util","__id":1002,"__height":21,"__pid":1001,"__depth":2,"__nextid":1003,"__preid":null,"__index":2},"Edo.util.Observable":{"name":"Edo.util.Observable","class":true,"description":"事件基类.实现事件的add,remove,find,fire,clear等逻辑,是edo框架实现事件机制的类.<br/>\r\n<pre>\r\n    //监听click事件\r\n    cmp.addListener('click', onClick, cmp); \r\n    //删除监听\r\n    cmp.removeListener('click', onClick, cmp);\r\n    ...\r\n</pre>","functions":[{"name":"addListeners","view":"addListeners( listeners,  scope )","function":true,"description":"增加事件监听方法,别名 \"on\"","params":[{"type":"Object","name":"listeners","description":"事件配置对象:{'click':"},{"type":"Object","name":"scope","description":"激发事件时的this对象"}],"return":{"type":"Object","description":"返回组件对象自身"},"exception":true,"definedby":"Edo.util.Observable"},{"name":"removeListener","function":true,"view":"removeListener( name, fn, scope )","description":"删除事件监听方法,别名 \"un\"","params":[{"type":"String","name":"name","description":"事件名"},{"type":"Function","name":"fn","description":"事件监听器方法"},{"type":"Object","name":"scope","description":"激发事件时的this对象"}],"return":{"type":"Object","description":"返回组件对象自身"},"exception":true,"definedby":"Edo.util.Observable"},{"name":"findListener","function":true,"view":"findListener( name, fn, scope )","description":"判断是否具有制定的事件监听方法","params":[{"type":"String","name":"name","description":"事件名"},{"type":"Function","name":"fn","description":"事件监听器方法"},{"type":"Object","name":"scope","description":"激发事件时的this对象"}],"return":{"type":"Boolean"},"exception":true,"definedby":"Edo.util.Observable"},{"name":"addEvents","function":true,"view":"addEvents( arguments )","description":"增加事件","params":[{"type":"Array","name":"arguments","description":"事件名字符串数组"}],"return":{"type":"Object","description":"返回组件对象自身"},"exception":true,"definedby":"Edo.util.Observable"},{"name":"fireEvent","function":true,"view":"fireEvent( name )","description":"激发事件","params":[{"type":"String","name":"name","description":"事件名"},{"type":"Array","name":"arguments","description":"事件激发时的参数数组"}],"return":{"type":"Object"},"exception":true,"definedby":"Edo.util.Observable"},{"name":"clearEvent","function":true,"view":"clearEvent( )","description":"清除所有事件","return":{"type":"Object","description":"返回组件对象自身"},"exception":true,"definedby":"Edo.util.Observable"}],"icon":"class","showname":"Observable","namespace":"Edo.util","__id":1003,"__height":21,"__pid":1001,"__depth":2,"__nextid":1004,"__preid":1002,"__index":3,"expanded":true},"Edo.util.Ajax":{"name":"Edo.util.Ajax","class":true,"description":"数据交互组件","functions":[{"name":"request","function":true,"view":"request(config)","description":"交互数据","params":[{"type":"Object","name":"config","description":"ajax配置对象"}],"return":{"type":"Object","description":"一个ajax配置对象"}},{"name":"abort","function":true,"view":"abort( )","description":"阻止一个ajax对象的继续交互数据"}],"icon":"class","showname":"Ajax","namespace":"Edo.util","__id":1004,"__height":21,"__pid":1001,"__depth":2,"__nextid":1005,"__preid":1003,"__index":4},"Edo.util.Cookie":{"name":"Edo.util.Cookie","class":true,"description":"Cookie操作类","functions":[{"name":"get","function":true,"view":"get( key )","description":"根据key获得存储的cookie字符串","params":[{"type":"String","name":"key","description":"cookie的key字符串"}],"return":{"type":"String","description":"cookie字符串"}},{"name":"set","function":true,"view":"set( key, name )","description":"根据key获得存储的cookie字符串","params":[{"type":"String","name":"key","description":"cookie的key字符串"},{"type":"String","name":"name","description":"数据字符串"}]},{"name":"del","function":true,"view":"del( key )","description":"根据key获得存储的cookie字符串","params":[{"type":"String","name":"key","description":"cookie的key字符串"}]}],"icon":"class","showname":"Cookie","namespace":"Edo.util","__id":1005,"__height":21,"__pid":1001,"__depth":2,"__nextid":1006,"__preid":1004,"__index":5},"undefined":{"class":"Date\n *\n * The date parsing and format syntax is a subset of\n * <a href=\"http://www.php.net/date\">PHP's date() function</a>, and the formats that are\n * supported will provide results equivalent to their PHP versions.\n *\n * The following is a list of all currently supported formats:\n *<pre>\nFormat  Description                                                               Example returned values\n------  -----------------------------------------------------------------------   -----------------------\n  d     Day of the month, 2 digits with leading zeros                             01 to 31\n  D     A short textual representation of the day of the week                     Mon to Sun\n  j     Day of the month without leading zeros                                    1 to 31\n  l     A full textual representation of the day of the week                      Sunday to Saturday\n  N     ISO-8601 numeric representation of the day of the week                    1 (for Monday) through 7 (for Sunday)\n  S     English ordinal suffix for the day of the month, 2 characters             st, nd, rd or th. Works well with j\n  w     Numeric representation of the day of the week                             0 (for Sunday) to 6 (for Saturday)\n  z     The day of the year (starting from 0)                                     0 to 364 (365 in leap years)\n  W     ISO-8601 week number of year, weeks starting on Monday                    01 to 53\n  F     A full textual representation of a month, such as January or March        January to December\n  m     Numeric representation of a month, with leading zeros                     01 to 12\n  M     A short textual representation of a month                                 Jan to Dec\n  n     Numeric representation of a month, without leading zeros                  1 to 12\n  t     Number of days in the given month                                         28 to 31\n  L     Whether it's a leap year                                                  1 if it is a leap year, 0 otherwise.\n  o     ISO-8601 year number (identical to (Y), but if the ISO week number (W)    Examples: 1998 or 2004\n        belongs to the previous or next year, that year is used instead)\n  Y     A full numeric representation of a year, 4 digits                         Examples: 1999 or 2003\n  y     A two digit representation of a year                                      Examples: 99 or 03\n  a     Lowercase Ante meridiem and Post meridiem                                 am or pm\n  A     Uppercase Ante meridiem and Post meridiem                                 AM or PM\n  g     12-hour format of an hour without leading zeros                           1 to 12\n  G     24-hour format of an hour without leading zeros                           0 to 23\n  h     12-hour format of an hour with leading zeros                              01 to 12\n  H     24-hour format of an hour with leading zeros                              00 to 23\n  i     Minutes, with leading zeros                                               00 to 59\n  s     Seconds, with leading zeros                                               00 to 59\n  u     Milliseconds, with leading zeroes (arbitrary number of digits allowed)    Examples:\n                                                                                  001 (i.e. 1ms) or\n                                                                                  100 (i.e. 100ms) or\n                                                                                  999 (i.e. 999ms) or\n                                                                                  999876543210 (i.e. 999.876543210ms)\n  O     Difference to Greenwich time (GMT) in hours and minutes                   Example: +1030\n  P     Difference to Greenwich time (GMT) with colon between hours and minutes   Example: -08:00\n  T     Timezone abbreviation of the machine running the code                     Examples: EST, MDT, PDT ...\n  Z     Timezone offset in seconds (negative if west of UTC, positive if east)    -43200 to 50400\n  c     ISO 8601 date (note: milliseconds, if present, must be specified with     Examples:\n        at least 1 digit. There is no limit to how many digits the millisecond    2007-04-17T15:19:21+08:00 or\n        value may contain. see http://www.w3.org/TR/NOTE-datetime for more info)  2008-03-16T16:18:22Z or\n                                                                                  2009-02-15T17:17:23.9+01:00 or\n                                                                                  2010-01-14T18:16:24,999876543-07:00\n  U     Seconds since the Unix Epoch (January 1 1970 00:00:00 GMT)                1193432466 or -2138434463\n</pre>\n *\n * Example usage (note that you must escape format specifiers with '\\\\' to render them as character literals):\n * <pre><code>\n// Sample date:\n// 'Wed Jan 10 2007 15:05:01 GMT-0600 (Central Standard Time)'\n\nvar dt = new Date('1/10/2007 03:05:01 PM GMT-0600');\ndocument.write(dt.format('Y-m-d'));                           // 2007-01-10\ndocument.write(dt.format('F j, Y, g:i a'));                   // January 10, 2007, 3:05 pm\ndocument.write(dt.format('l, \\\\t\\\\he jS \\\\of F Y h:i:s A'));  // Wednesday, the 10th of January 2007 03:05:01 PM\n </code></pre>\n *\n * Here are some standard date/time patterns that you might find helpful.  They\n * are not part of the source of Date.js, but to use them you can simply copy this\n * block of code into any script that is included after Date.js and they will also become\n * globally available on the Date object.  Feel free to add or remove patterns as needed in your code.\n * <pre><code>\nDate.patterns = {\n    ISO8601Long:\"Y-m-d H:i:s\",\n    ISO8601Short:\"Y-m-d\",\n    ShortDate: \"n/j/Y\",\n    LongDate: \"l, F d, Y\",\n    FullDateTime: \"l, F d, Y g:i:s A\",\n    MonthDay: \"F d\",\n    ShortTime: \"g:i A\",\n    LongTime: \"g:i:s A\",\n    SortableDateTime: \"Y-m-d\\\\TH:i:s\",\n    UniversalSortableDateTime: \"Y-m-d H:i:sO\",\n    YearMonth: \"F, Y\"\n};\n</code></pre>\n *\n * Example usage:\n * <pre><code>\nvar dt = new Date();\ndocument.write(dt.format(Date.patterns.ShortDate));\n </code></pre>"},"Edo.util.Drag":{"name":"Edo.util.Drag","class":true,"description":"拖拽基类\r\n    mouse.init:    初始鼠标点击坐标\r\n    mouse.now:      当前鼠标坐标\r\n    events: start, move, stop","functions":[{"name":"onStart","function":true,"description":"拖拽开始回调函数"},{"name":"onMove","function":true,"description":"拖拽移动回调函数"},{"name":"onStop","function":true,"description":"拖拽结束回调函数"},{"name":"start","function":true,"view":"start( e )","description":"启动拖拽","params":[{"type":"DomEvent","name":"e","description":"dom事件对象"}]}],"icon":"class","showname":"Drag","namespace":"Edo.util","__id":1006,"__height":21,"__pid":1001,"__depth":2,"__nextid":1007,"__preid":1005,"__index":6},"Edo.util.Json":{"name":"Edo.util.Json","class":true,"description":"Json","functions":[{"name":"encode","function":true,"view":"encode( obj )","description":"将obj对象序列化成json字符串","params":[{"type":"Object","name":"obj","description":"对象"}]},{"name":"decode","function":true,"view":"decode( str )","description":"将str字符串反序列化成对象","params":[{"type":"String","name":"str","description":"json字符串"}]}],"icon":"class","showname":"Json","namespace":"Edo.util","__id":1007,"__height":21,"__pid":1001,"__depth":2,"__nextid":1008,"__preid":1006,"__index":7},"Edo.util.Anim":{"name":"Edo.util.Anim","class":true,"description":"动画类","icon":"class","showname":"Anim","namespace":"Edo.util","__id":1008,"__height":21,"__pid":1001,"__depth":2,"__nextid":1009,"__preid":1007,"__index":8},"Edo.util.Fx.Style":{"name":"Edo.util.Fx.Style","class":true,"description":"Style动画效果类","icon":"class","showname":"Style","namespace":"Edo.util.Fx","__id":1010,"__height":21},"Edo.util.Template":{"name":"Edo.util.Template","class":true,"description":"HTML模板生成类","functions":[{"name":"set","function":true,"view":"set( tpl )","description":"设置模板字符串","params":[{"type":"String","name":"tpl","description":"模板字符串"}]},{"name":"run","function":true,"view":"run( data )","description":"使用数据对象, 根据此模板逻辑, 生成字符串","params":[{"type":"Object","name":"data","description":"数据对象"}]}],"icon":"class","showname":"Template","namespace":"Edo.util","__id":1011,"__height":21,"__pid":1001,"__depth":2,"__nextid":null,"__preid":1009,"__index":10},"Edo.managers.SystemManager":{"name":"Edo.managers.SystemManager","class":true,"single":true,"description":"组件系统管理器","example":true,"icon":"singleton","showname":"SystemManager","namespace":"Edo.managers","__id":1013,"__height":21},"Edo.managers.DragManager":{"name":"Edo.managers.DragManager","class":true,"single":true,"description":"拖拽管理器","example":true,"functions":[{"name":"startDrag","function":true,"description":"启动拖拽器","params":[{"type":"Object","name":"config","description":"拖拽配置对象"}]},{"name":"acceptDragDrop","function":true,"description":"当一个拖拽器移动到一个组件上时, 是否进行允许投放操作"},{"name":"regDrop","function":true,"description":"注册投放区Drop对象"},{"name":"unregDrop","function":true,"description":"注销投放区Drop对象"}],"icon":"singleton","showname":"DragManager","namespace":"Edo.managers","__id":1014,"__height":21},"Edo.managers.PopupManager":{"name":"Edo.managers.PopupManager","class":true,"single":true,"description":"弹出定位管理器","example":true,"functions":[{"name":"createPopup","function":true,"description":"弹出显示组件","params":[{"type":"Object","name":"config","description":"弹出显示的配置对象"}]},{"name":"removePopup","function":true,"description":"隐藏弹出显示组件","params":[{"type":"UIComponent","name":"组件对象"}]}],"icon":"singleton","showname":"PopupManager","namespace":"Edo.managers","__id":1015,"__height":21},"Edo.managers.ResizeManager":{"name":"Edo.managers.ResizeManager","class":true,"single":true,"description":"尺寸调节管理器","example":true,"functions":[{"name":"reg","function":true,"description":"注册尺寸调节器","params":[{"type":"Object","name":"config","description":"尺寸调节配置对象"}]},{"name":"unreg","function":true,"description":"注销尺寸调节器","params":[{"type":"UIComponent","name":"组件"}]}],"icon":"singleton","showname":"ResizeManager","namespace":"Edo.managers","__id":1016,"__height":21},"Edo.managers.TipManager":{"name":"Edo.managers.TipManager","class":true,"single":true,"description":"提示信息管理器","example":true,"functions":[{"name":"reg","function":true,"description":"注册提示器","params":[{"type":"Object","name":"config","description":"提示器配置对象"}]},{"name":"unreg","function":true,"description":"注销提示器","params":[{"type":"UIComponent","name":"组件"}]}],"icon":"singleton","showname":"TipManager","namespace":"Edo.managers","__id":1017,"__height":21},"Edo.core.Component":{"name":"Edo.core.Component","class":true,"typeName":"component, cmp","extend":"Edo.util.Observable","description":"Edo组件基类,具备id属性,以及set,get,type等相关操作<br/>\r\n    <pre>    \r\n    var cmp = new Edo.core.Component();\r\n    cmp.set({\r\n        id: \"cmp1\",\r\n        type: 'cmp'\r\n        ...    \r\n    });\r\n    或\r\n    var cmp = Edo.create({\r\n        id: \"cmp1\",\r\n        type: 'cmp'\r\n        ...\r\n    });\r\n    或\r\n    var cmp = new Type();\r\n    cmp.set(...);\r\n    cmp.init();\r\n    cmp.destroy();\r\n    </pre>","events":[{"name":"init","event":true,"description":"对象创建完毕,可以使用对象的方法,事件,但是对象此时只有默认属性,没有用户输入的设置属性"},{"name":"destroy","event":true,"description":"组件销毁完毕激发"},{"name":"propertychange","event":true,"description":"属性值改变事件"}],"properties":[{"name":"id","property":true,"type":"String","readOnly":true,"description":"组件唯一标识符(所有的Edo组件都会有一个id,或显示设置,或自动生成)"}],"functions":[{"name":"get","function":true,"description":"属性索引器","params":[{"type":"String","name":"name","description":"属性名"}],"return":{"type":"Object","description":"返回属性的值"}},{"name":"set","function":true,"description":"属性设置器","params":[{"type":"String","name":"name","description":"属性名"},{"type":"Object","name":"name","description":"值"}]},{"name":"destroy","function":true,"description":"销毁组件"},{"name":"addPlugin","function":true,"description":"加入插件","params":[{"type":"Object","name":"plugin","description":"插件实例对象"}]},{"name":"removePlugin","function":true,"description":"删除插件","params":[{"type":"Object","name":"plugin","description":"插件id或插件对象"}]},{"name":"getType","function":true,"description":"获得实例对象的类型","return":{"type":"String","description":"类型名称"}},{"name":"isType","function":true,"description":"判断实例对象是否是某一个类的实例","params":[{"type":"String","name":"type","description":"类型名称"},{"type":"Boolean","name":"shallow","description":"是否从继承链追溯判断"}],"return":{"type":"Boolean"}},{"name":"getTypes","function":true,"description":"获得实例的所有类名字符串(包括父类)","return":{"type":"String","description":"类名字符串"}}],"icon":"class","showname":"Component","namespace":"Edo.core","__id":1019,"__pid":1018,"__depth":2,"__nextid":1020,"__preid":null,"__index":13,"__height":21},"Edo.core.UIComponent":{"name":"Edo.core.UIComponent","class":true,"typeName":"uicomponent, div, html","description":"Edo显示组件基类,负责界面占位和显示<br/>\r\n        生命周期:<br/>\r\n        1.init:实例化对象\r\n        2.render:对象加入dom文档\r\n        3.creation:所有事件,属性都设置完毕\r\n        4.destroy:组件销毁","extend":"Edo.core.Component","example":"1.measure:需要估量好realWidth,realHeight\r\n2.syncSize:进行onRender操作,创建,定位,尺寸完所有组件对象.\r\n重要概念:\r\n    created:    表示js组件对象是否创建完毕,当调用render方法后,肯定创建完毕!(这时候如果组件不可见,则el可能还没有,但是不影响对组件进行操作!)\r\n    el:         js组件对象创建完毕,不代表dom创建完毕.el代表dom也创建完毕!\r\n    \r\n    \r\n1.created:  js组件对象创建完毕(dom此时可能还没有渲染到页面,但是对象的方法都可以使用)\r\n2.rendered: 对象的dom元素全部创建完毕,此时可以操作对象的dom元素.\r\n3.renderresized:  创建的dom元素被渲染完毕,具备实际的尺寸.(一些根据DOM元素尺寸状态逻辑的编程,根据此尺寸进行编程)\r\n\r\n\r\n生命周期描述:\r\n1.init 初始化\r\n    new Type()\r\n    创建完一个组件对象后(没有设置属性,没有尺寸,没有el),激发init事件\r\n2.creation 创建完毕\r\n    设置好了所有属性,并且具备width, height实际尺寸值(仅在doRender之前)\r\n\r\n3.render 渲染\r\n    具备所有属性,尺寸,将组件树呈现到界面(doRender),并分配好所有组件的el,初始化完毕事件initEvents,具备el.\r\n    激发render,万事具备!\r\n    \r\n4.destroy\r\n    注销组件,解除事件,销毁此组件上的所有插件","events":[{"name":"creation","event":true,"description":"组件创建完毕.1.设置好所有\"设置属性\";2.具备尺寸和坐标; 3.没有el(需要在render之后,才有el)"},{"name":"render","event":true,"description":"组件呈现在界面上,生成了el,并具备了可视化外观."},{"name":"relayout","event":true,"description":"当组件修改了影响布局的属性时,激发此事件,调整布局\r\n如width,height,visible,text(button),border,padding(box),margin,maxWidth,maxHeight,minHeight,minWidth,defaultWidth,defaultHeight..."},{"name":"click","event":true,"description":"鼠标点击事件"},{"name":"dblclick","event":true,"description":"鼠标双击事件"},{"name":"mousedown","event":true,"description":"鼠标按下事件"},{"name":"mouseup","event":true,"description":"鼠标按起事件"},{"name":"mousemove","event":true,"description":"鼠标移动事件"},{"name":"mouseover","event":true,"description":"鼠标移上事件"},{"name":"mouseout","event":true,"description":"鼠标移开事件"},{"name":"mousewheel","event":true,"description":"滚轮事件"},{"name":"contextmenu","event":true,"description":"右键菜单事件"},{"name":"focus","event":true,"description":"组件获得焦点事件"},{"name":"blur","event":true,"description":"鼠标失去焦点事件"},{"name":"keydown","event":true,"description":true},{"name":"keyup","event":true,"description":true},{"name":"dragstart","event":true,"description":"drag 开始"},{"name":"dragmove","event":true,"description":"drag 移动中"},{"name":"dragcomplete","event":true,"description":"drag 完成"},{"name":"dropenter","event":true,"description":"第一次dropover前,判断是否可以投放drop.当调用acceptDragDrop之后,才会激发dropover,dropout,dragdrop三个事件"},{"name":"dropover","event":true,"description":"drop,有drag在上空"},{"name":"dropout","event":true,"description":"drop,有drag离开上空"},{"name":"dropmove","event":true,"description":"drop状态 移动中"},{"name":"dragdrop","event":true,"description":"组件作为投放区drop,有drag在上空,并释放鼠标,进行dragdrop操作"},{"name":"resizestart","event":true,"description":"调节尺寸开始"},{"name":"resize","event":true,"description":"调节尺寸中"},{"name":"resizecomplete","event":true,"description":"调节尺寸完毕"},{"name":"actualresize","event":true,"description":"DOM的尺寸调节"},{"name":"editstart","event":true,"description":"开始编辑时激发"},{"name":"editcomplete","event":true,"description":"结束编辑时激发"},{"name":"editcancel","event":true,"description":"撤销编辑"},{"name":"splitclick","event":true,"description":"点击split按钮时激发"},{"name":"syncsize","event":true,"description":"尺寸调节事件"}],"functions":[{"name":"createChildren","function":true,"description":"创建此组件的相关dom元素"},{"name":"creation","function":true,"description":"组件对象创建完毕.(1.所有属性设置完毕; 2.measure布局尺寸计算完毕; 3.没有el)"},{"name":"initEvents","function":true,"description":"在createChildren之后,初始化dom事件"},{"name":"render","function":true,"description":"将组件加入一个dom元素内","params":[{"type":"element","name":"dom"}]},{"name":"isDisplay","function":true,"description":"判断本组件是否可见:遍历parent"},{"name":"focus","function":true,"description":"组件获得焦点"},{"name":"blur","function":true,"description":"组件失去焦点"},{"name":"addCls","function":true,"description":"增加组件样式类","params":[{"type":"String","name":"cls"}]},{"name":"removeCls","function":true,"description":"删除组件样式类","params":[{"type":"String","name":"cls"}]},{"name":"startEdit","function":true,"description":"将组件作为一个编辑器使用,定位和调节尺寸大小,激发editstart事件","params":[{"type":"Object","name":"data","description":"初始编辑数据(初始化编辑器)"},{"type":"Number","name":"x","description":"编辑器的定位和尺寸"},{"type":"Number","name":"y"},{"type":"Number","name":"width"},{"type":"Number","name":"height"}]},{"name":"completeEdit","function":true,"description":"组件结束编辑,激发editcomplete事件"},{"name":"getEditData","function":true,"description":"获得编辑数据(用于组件作为表格/属性单元格编辑器时)"},{"name":"mask","function":true,"description":"遮罩组件","params":[{"type":"String","name":"html","description":"遮罩中的html"}]},{"name":"unmask","function":true,"description":"取消遮罩组件"},{"name":"isMasked","function":true,"description":"组件是否应用了遮罩"}],"properties":[{"name":"width","property":true,"type":"String/Number","default":"auto","description":"宽度:1)绝对设置,如 150; 2)百分比设置,如 80%; 3)自适应设置,auto"},{"name":"height","property":true,"type":"String/Number","default":"auto","description":"高度:1)绝对设置,如 150; 2)百分比设置,如 80%; 3)自适应设置,auto"},{"name":"minWidth","property":true,"type":"Number","default":"20","description":"最小宽度"},{"name":"minHeight","property":true,"type":"Number","default":"22","description":"最小高度"},{"name":"maxWidth","property":true,"type":"Number","default":"100000","description":"最大宽度"},{"name":"maxHeight","property":true,"type":"Number","default":"100000","description":"最大高度"},{"name":"defaultWidth","property":true,"type":"Number","default":"20","description":"默认宽度"},{"name":"defaultHeight","property":true,"type":"Number","default":"22","description":"默认高度"},{"name":"visible","property":true,"type":"Boolean","default":"true","description":"控制组件是否可见"},{"name":"enable","property":true,"type":"Boolean","default":"true","description":"控制组件是否可操作"},{"name":"verticalScrollPolicy","property":true,"type":"String","default":"off ( auto,on,off )","description":"组件竖向滚动条控制"},{"name":"horizontalScrollPolicy","property":true,"type":"String","default":"off ( auto,on,off )","description":"组件横向滚动条控制"},{"name":"cls","property":true,"type":"String","description":"组件样式类"},{"name":"style","property":true,"type":"String","description":"组件样式字"},{"name":"html","property":true,"type":"String","description":"组件内部html字符串"},{"name":"left","property":true,"type":"String/Number","default":"0","description":"配合absolute布局器"},{"name":"top","property":true,"type":"String/Number","default":"0","description":"配合absolute布局器"},{"name":"right","property":true,"type":"String/Number","description":"配合absolute布局器"},{"name":"bottom","property":true,"type":"String/Number","description":"配合absolute布局器"}],"icon":"class","showname":"UIComponent","namespace":"Edo.core","__id":1020,"__pid":1018,"__depth":2,"__nextid":1021,"__preid":1019,"__index":14,"__height":21},"Edo.core.Space":{"name":"Edo.core.Space","class":true,"typeName":"space","description":"在布局器中,帮助进行布局的类,占位但不显示.","extend":"Edo.core.UIComponent","example":true,"properties":[{"name":"defaultWidth","property":true,"default":"0"},{"name":"defaultHeight","property":true,"default":"0"},{"name":"minWidth","property":true,"default":"0"},{"name":"minHeight","property":true,"default":"0"}],"icon":"class","showname":"Space","namespace":"Edo.core","__id":1021,"__pid":1018,"__depth":2,"__nextid":1022,"__preid":1020,"__index":15,"__height":21},"Edo.core.Split":{"name":"Edo.core.Split","class":true,"typeName":"split","description":"竖向分隔符,一般用于toolbar的按钮分隔符","extend":"Edo.core.UIComponent","example":true,"properties":[{"name":"defaultWidth","property":true,"default":"6"},{"name":"defaultHeight","property":true,"default":"20"},{"name":"minWidth","property":true,"default":"6"}],"icon":"class","showname":"Split","namespace":"Edo.core","__id":1022,"__pid":1018,"__depth":2,"__nextid":1023,"__preid":1021,"__index":16,"__height":21},"Edo.core.HSplit":{"name":"Edo.core.HSplit","class":true,"typeName":"hsplit","description":"横向分隔符,一般用于menu的分隔符","extend":"Edo.core.Split","example":true,"properties":[{"name":"height","property":true,"default":"4"},{"name":"width","property":true,"default":"100%"},{"name":"defaultHeight","property":true,"default":"4"},{"name":"minHeight","property":true,"default":"4"}],"icon":"class","showname":"HSplit","namespace":"Edo.core","__id":1023,"__pid":1018,"__depth":2,"__nextid":1024,"__preid":1022,"__index":17,"__height":21},"Edo.core.Validator":{"name":"Edo.core.Validator","class":true,"typeName":"validator","description":"验证器,所有从Edo.controls.Control都可以应用此验证器进行验证信息提示.1)监听对象的属性变化事件;2)验证逻辑函数;3)调用对象的valid和invalid方法表达验证成功或错误","extend":"Edo.core.Component","example":true,"properties":[{"name":"error","property":true,"type":"String","description":"验证失败时的错误描述"},{"name":"target","property":true,"type":"Component","description":"验证的目标组件对象"},{"name":"property","property":true,"type":"String","description":"验证目标属性"},{"name":"valid","property":true,"type":"Function","description":"验证逻辑函数"}],"functions":[{"name":"valid","function":true,"description":"验证目标对象的属性是否通过验证器函数的验证"}],"icon":"class","showname":"Validator","namespace":"Edo.core","__id":1024,"__pid":1018,"__depth":2,"__nextid":null,"__preid":1023,"__index":18,"__height":21},"Edo.containers.Container":{"name":"Edo.containers.Container","class":true,"typeName":"container, ct","description":"容器基类","extend":"Edo.core.UIComponent","example":"collapse的时候,如果本元素小于父容器的minHeight,会有空白!这是正常的.除非把父容器的最小尺寸设置号.","events":[{"name":"childchange","event":true,"description":"容器内的子元素增删修改事件"},{"name":"toggle","event":true,"description":"容器收缩伸展事件"}],"properties":[{"name":"defaultWidth","property":true,"default":"10"},{"name":"defaultHeight","property":true,"default":"15"},{"name":"minWidth","property":true,"default":"10"},{"name":"minHeight","property":true,"default":"10"},{"name":"layout","property":true,"type":"String","default":"vertical ( vertical, horizontal, absolute, viewstack)","description":"布局器"},{"name":"enableCollapse","property":true,"type":"Boolean","default":"true","description":"是否可折叠"},{"name":"expanded","property":true,"type":"Boolean","default":"true","description":"折叠状态.默认是展开状态,expanded = true"},{"name":"collapseHeight","property":true,"type":"Boolean","default":"0","description":"收缩时的高度"},{"name":"collapseWidth","property":true,"type":"Number","default":"0","description":"收缩时的宽度"},{"name":"collapseProperty","property":true,"type":"Boolean","default":"height","description":"收缩的属性:width, height"},{"name":"horizontalGap","property":true,"type":"Number","default":"5","description":"横向间距.配合horizontal,vertical布局器"},{"name":"verticalGap","property":true,"type":"Number","default":"5","description":"竖向间距.配合horizontal,vertical布局器"},{"name":"horizontalAlign","property":true,"type":"Number","default":"left (left, center, right)","description":"横向定位.配合horizontal,vertical布局器"},{"name":"verticalAlign","property":true,"type":"String","default":"top (top, middle, bottom)","description":"竖向定位.配合horizontal,vertical布局器"},{"name":"selectedIndex","property":true,"type":"Number","default":"0","description":"选中的组件索引.配合viewstack布局器"}],"functions":[{"name":"collapse","function":true,"description":"收缩"},{"name":"expand","function":true,"description":"展开"},{"name":"toggle","function":true,"description":"伸缩方法"},{"name":"numChildren","function":true,"description":"返回容器的子元素个数","return":{"type":"Number","description":"子元素个数"}},{"name":"getChildren","function":true,"description":"返回容器的子元素集合","return":{"type":"Array","description":"子元素数组"}},{"name":"getDisplayChildren","function":true,"description":"返回容器的可视(参与布局的)子元素集合,如果子元素visible=false,或popup=true,则不会参与到容器的布局逻辑中","return":{"type":"Array","description":"被标记为可显示的子元素数组"}},{"name":"setChildren","function":true,"description":"给容器设置子元素集合","params":[{"type":"Array","name":"value","description":"子元素数组"}],"return":{"type":"Object","description":"容器自身"}},{"name":"addChild","function":true,"description":"加入子元素","params":[{"type":"UIComponent","name":"child","description":"子元素(可以是配置对象,也可以是Edo组件对象)"}],"return":{"type":"Object","description":"被加入的子元素对象"}},{"name":"addChildAt","function":true,"description":"在指定位置加入子元素","params":[{"type":"Number","name":"index"},{"type":"Object","name":"child"}],"return":{"type":"Object","description":"被加入的子元素对象"}},{"name":"getChildAt","function":true,"description":"获取指定索引位置子元素","params":[{"type":"Number","name":"index"}],"return":{"type":"Object","description":"子元素对象"}},{"name":"removeAllChildren","function":true,"description":"删除所有子元素","return":{"type":"Object","description":"被删除的子元素对象"}},{"name":"removeChild","function":true,"description":"删除子元素","params":[{"type":"Object","name":"child"}],"return":{"type":"Object","description":"被删除的子元素"}},{"name":"removeChildAt","function":true,"description":"删除指定位置子元素","params":[{"type":"Number","name":"index"}],"return":{"type":"Object","description":"子元素"}},{"name":"setChildIndex","function":true,"description":"调整子元素位置","params":[{"type":"Number","name":"index"},{"type":"Object","name":"child"}],"return":{"type":"Object","description":"容器自身"}}],"icon":"class","showname":"Container","namespace":"Edo.containers","__id":1026,"__height":21},"Edo.containers.Box":{"name":"Edo.containers.Box","class":true,"typeName":"box","description":"盒容器,实现边框border和内间距padding","extend":"Edo.containers.Container","example":true,"properties":[{"name":"border","property":true,"type":"{Array}","default":"[1,1,1,1] ( [left, top, right, bottom] )","description":"边框线宽度"},{"name":"padding","property":true,"type":"Array","default":"[1,1,1,1] ( [left, top, right, bottom] )","description":"内边距宽度"},{"name":"bodyStyle","property":true,"type":"String","description":"body的style"},{"name":"bodyCls","property":true,"type":"String","description":"body的cls"}],"icon":"class","showname":"Box","namespace":"Edo.containers","__id":1027,"__height":21},"Edo.containers.Application":{"name":"Edo.containers.Application","properties":[{"name":"defaultWidth","property":true,"default":"60"},{"name":"defaultHeight","property":true,"default":"22"},{"name":"minWidth","property":true,"default":"400"},{"name":"minHeight","property":true,"default":"200"}],"class":true,"typeName":"app","description":"自适应浏览器尺寸的顶级容器","extend":"Edo.containers.Box","icon":"class","showname":"Application","namespace":"Edo.containers","__id":1028,"__height":21},"Edo.containers.Group":{"name":"Edo.containers.Group","class":true,"typeName":"group","description":"实现圆角的容器","extend":"Edo.containers.Container","example":true,"properties":[{"name":"defaultWidth","property":true,"default":"60"},{"name":"defaultHeight","property":true,"default":"22"},{"name":"padding","property":true,"type":"{Array}","default":"[3, 2, 3, 3] ( [left, top, right, bottom] )","description":"内边距宽度(上下左右圆角尺寸)"}],"icon":"class","showname":"Group","namespace":"Edo.containers","__id":1029,"__height":21},"Edo.containers.Dialog":{"name":"Edo.containers.Dialog","class":true,"typeName":"dialog","description":true,"extend":"Edo.containers.Group","example":true,"properties":[{"name":"headerHeight","property":true,"type":"{Number}","default":"25","description":"面板头部高度"},{"name":"padding","property":true,"default":"[6, 25, 6, 6] ( [left, top, right, bottom] )"},{"name":"defaultWidth","property":true,"default":"60"},{"name":"defaultWidth","property":true,"default":"30"},{"name":"collapseWidth","property":true,"default":"28"},{"name":"collapseHeight","property":true,"default":"31"},{"name":"titleIcon","property":true,"type":"{String}","description":"标题图标"},{"name":"title","property":true,"type":"{String}","description":"标题信息"}],"icon":"class","showname":"Dialog","namespace":"Edo.containers","__id":1030,"__height":21},"Edo.containers.FieldSet":{"name":"Edo.containers.FieldSet","class":true,"typeName":"fieldset","description":true,"extend":"Edo.containers.Container","example":true,"properties":[{"name":"defaultWidth","property":true,"default":"80"},{"name":"defaultHeight","property":true,"default":"30"},{"name":"collapseHeight","property":true,"default":"18"},{"name":"legend","property":true,"type":"{String}","description":"头部文本"}],"icon":"class","showname":"FieldSet","namespace":"Edo.containers","__id":1031,"__height":21},"Edo.containers.Panel":{"name":"Edo.containers.Panel","class":true,"typeName":"panel","description":"实现header头容器","extend":"Edo.containers.Box","example":true,"properties":[{"name":"collapseHeight","property":true,"default":"26"},{"name":"collapseWidth","property":true,"default":"26"},{"name":"minHeight","property":true,"default":"22"},{"name":"headerHeight","property":true,"type":"Number","default":"25","description":"头部高度"},{"name":"title","property":true,"type":"String","description":"标题文本"},{"name":"titleIcon","property":true,"type":"String","description":"标题图标"}],"icon":"class","showname":"Panel","namespace":"Edo.containers","__id":1032,"__height":21},"Edo.containers.FormItem":{"name":"Edo.containers.FormItem","class":true,"typeName":"formitem","description":"带label左侧文本显示框的容器,提供表单布局方式","extend":"Edo.containers.Box","example":true,"properties":[{"name":"defaultHeight","property":true,"default":"22"},{"name":"minHeight","property":true,"default":"22"},{"name":"border","property":true,"default":"[0,0,0,0] ( [left, top, right, bottom] )"},{"name":"padding","property":true,"default":"[0,0,0,0] ( [left, top, right, bottom] )"},{"name":"label","property":true,"type":"{String}","description":"文本"},{"name":"labelWidth","property":true,"type":"{String}","description":"文本宽度"},{"name":"labelAlign","property":true,"type":"{String}","description":"文本偏移"},{"name":"labelCls","property":true,"type":"{String}","description":"文本cls"},{"name":"labelStyle","property":true,"type":"{String}","description":"文本style"}],"icon":"class","showname":"FormItem","namespace":"Edo.containers","__id":1033,"__height":21},"Edo.data.DataTable":{"name":"Edo.data.DataTable","class":true,"typeName":"datatable","description":"表格数据源","extend":"Edo.core.Component","example":true,"events":[{"name":"datachange","event":true,"description":"数据改变事件"}],"functions":[{"name":"load","function":true,"description":"加载数据","params":[{"type":"Array","name":"data","description":"数组形式的数据"}]},{"name":"add","function":true,"description":"增加数据","params":[{"type":"Object/Array","name":"records","description":"可以是单个对象,"}]},{"name":"insert","function":true,"description":"增加数据","params":[{"type":"Number","name":"index"},{"type":"Object/Array","name":"records","description":"可以是单个对象,"},{"type":"Boolean","name":"isArray","description":"如果records是数组,"}]},{"name":"remove","function":true,"description":"删除数据","params":[{"type":"Object","name":"record","description":"数据对象"}]},{"name":"removeAt","function":true,"description":"根据索引删除数据","params":[{"type":"Number","name":"index"}]},{"name":"updateRecord","function":true,"description":"批量更新数据对象属性值","params":[{"type":"Object","name":"record","description":"数据对象"},{"type":"Object","name":"properties","description":"{key:"}]},{"name":"update","function":true,"description":"更新数据对象属性值","params":[{"type":"Object","name":"record","description":"数据对象"},{"type":"String","name":"field","description":"属性名"},{"type":"Object","name":"value","description":"属性值"}]},{"name":"move","function":true,"description":"移动数据对象","params":[{"type":"Object","name":"record","description":"数据对象"},{"type":"Number","name":"index"}]},{"name":"clear","function":true,"description":"清楚数据"},{"name":"resetRecord","function":true,"description":"还原行数据对象,一个被修改过的行对象, 换到到修改前","params":[{"type":"Object","name":"record","description":"数据对象"}]},{"name":"resetField","function":true,"description":"还原行数据对象的某个属性","params":[{"type":"Object","name":"record","description":"数据对象"},{"type":"String","name":"field","description":"属性名"}]},{"name":"sort","function":true,"description":"排序数据","params":[{"type":"Function","name":"sortFn","description":"排序算法函数"}]},{"name":"sortField","function":true,"description":"针对某一个field行属性进行升降排序","params":[{"type":"String","name":"field","description":"属性名"},{"type":"String","name":"direction","description":"排序方向.ASC或DESC"}]},{"name":"filter","function":true,"description":"过滤数据","params":[{"type":"Function","name":"fn","description":"过滤算法函数"},{"type":"Object","name":"scope","description":"过滤函数中的this指向对象"}]},{"name":"clearFilter","function":true,"description":"清除过滤, 还原数据视图"},{"name":"isFiltered","function":true,"description":"判断数据视图是否被过滤过","return":{"type":"oolea"}},{"name":"findIndex","function":true,"description":"查找一个符合特征的对象","params":[{"type":"Object","name":"attributes","description":"{key:value}形式的特性对象"}],"return":{"type":"Number"}},{"name":"find","function":true,"description":"查找一个符合特征的对象","params":[{"type":"Object","name":"attributes","description":"{key:value}形式的特性对象"}],"return":{"type":"Object"}},{"name":"getById","function":true,"description":"根据id查找对象(从源数据)","params":[{"type":"String","name":"id","description":"row.__id"}],"return":{"type":"Object"}},{"name":"getViewById","function":true,"description":"根据id查找对象(从数据视图)","params":[{"type":"String","name":"id","description":"row.__id"}],"return":{"type":"Object"}},{"name":"getAt","function":true,"description":"根据index查找对象(从数据视图)","params":[{"type":"Number","name":"index"}],"return":{"type":"Object"}},{"name":"indexOf","function":true,"description":"根据对象查找对象的索引号","params":[{"type":"Object","name":"record"}],"return":{"type":"Number"}},{"name":"indexOfId","function":true,"description":"根据id查找对象的索引号","params":[{"type":"String","name":"id"}],"return":{"type":"Number"}},{"name":"getCount","function":true,"description":"数据视图行对象数目","return":{"type":"Number"}},{"name":"isEmpty","function":true,"description":"是否是空数据","return":{"type":"Boolean"}},{"name":"each","function":true,"description":"遍历数据视图","params":[{"type":"Function","name":"fn"},{"type":"Object","name":"scope"}]},{"name":"isModify","function":true,"description":"判断一个行数据是否被修改过","params":[{"type":"Object","name":"record"}],"return":{"type":"Boolean"}},{"name":"isFieldModify","function":true,"description":"判断一个行数据的某个属性是否被修改过","params":[{"type":"Object","name":"record"},{"type":"String","name":"field"}],"return":{"type":"Boolean"}}],"icon":"class","showname":"DataTable","namespace":"Edo.data","__id":1035,"__height":21},"Edo.data.DataTree":{"name":"Edo.data.DataTree","class":true,"typeName":"datatree","description":"树形数据源","extend":"Edo.data.DataTable","example":true,"functions":[{"name":"load","function":true,"description":"加载数据","params":[{"type":"Array/Object","name":"tree","description":"树形数据"}]},{"name":"collapse","function":true,"description":"收缩节点","params":[{"type":"Object","name":"node","description":"节点对象"},{"type":"Boolean","name":"deep","description":"是否影响子级"}]},{"name":"expand","function":true,"description":"展开节点","params":[{"type":"Object","name":"node","description":"节点对象"},{"type":"Boolean","name":"deep","description":"是否影响子级"}]},{"name":"toggle","function":true,"description":"伸展节点","params":[{"type":"Object","name":"node","description":"节点对象"},{"type":"Boolean","name":"deep","description":"是否影响子级"}]},{"name":"add","function":true,"description":"增加节点","params":[{"type":"Array","name":"nodes","description":"节点对象"},{"type":"Object","name":"parentNode","description":"父节点"}]},{"name":"insert","function":true,"description":"增加节点到索引处","params":[{"type":"Number","name":"index","description":"索引"},{"type":"Array","name":"nodes","description":"节点对象"},{"type":"Object","name":"parentNode","description":"父节点"}]},{"name":"insert","function":true,"description":"删除节点","params":[{"type":"Array","name":"node","description":"节点对象"}]},{"name":"move","function":true,"description":"移动节点","params":[{"type":"Object","name":"node","description":"节点对象"},{"type":"Object","name":"targetNode","description":"目标节点对象"},{"type":"String","name":"action","description":"如何移动插入:数字,preend,"}]},{"name":"filter","function":true,"description":"筛选过滤节点(树状方式遍历过滤)","params":[{"type":"Function","name":"fn","description":"过滤方法"},{"type":"Object","name":"scope"}]},{"name":"findParent","function":true,"description":"查找父节点","params":[{"type":"Object","name":"node","description":"节点对象"}]},{"name":"getChildAt","function":true,"description":"获得一个节点下children中index位置的节点","params":[{"type":"Object","name":"parentNode","description":"父节点对象"},{"type":"Number","name":"index"}],"return":{"type":"Object"}},{"name":"indexOfChild","function":true,"description":"获得一个节点在父节点下的索引号","params":[{"type":"Object","name":"parentNode","description":"父节点对象"},{"type":"Object","name":"node"}],"return":{"type":"Number"}},{"name":"isFirst","function":true,"description":"是否是第一个节点","params":[{"type":"Object","name":"node"}],"return":{"type":"Boolean"}},{"name":"isLast","function":true,"description":"是否是最后一个节点","params":[{"type":"Object","name":"node"}],"return":{"type":"Boolean"}},{"name":"isLeaf","function":true,"description":"是否是叶子节点(没有子节点)","params":[{"type":"Object","name":"node"}],"return":{"type":"Boolean"}},{"name":"getDepth","function":true,"description":"获得节点层次","params":[{"type":"Object","name":"node"}],"return":{"type":"Number"}},{"name":"eachChild","function":true,"description":"遍历节点下一个子级","params":[{"type":"Object","name":"node"},{"type":"Function","name":"fn"},{"type":"Object","name":"scope"}]},{"name":"iterateChildren","function":true,"description":"遍历所有层次的子节点","params":[{"type":"Object","name":"node"},{"type":"Function","name":"fn"},{"type":"Object","name":"scope"}]},{"name":"contains","function":true,"description":"是否包含子节点","params":[{"type":"Object","name":"parentNode"},{"type":"Object","name":"childNode"}]}],"icon":"class","showname":"DataTree","namespace":"Edo.data","__id":1036,"__height":21},"Edo.layouts.AbsoluteLayout":{"name":"Edo.layouts.AbsoluteLayout","class":true,"typeName":"absolute","single":true,"description":"定位布局器","example":true,"icon":"singleton","showname":"AbsoluteLayout","namespace":"Edo.layouts","__id":1038,"__height":21},"Edo.layouts.HorizontalLayout":{"name":"Edo.layouts.HorizontalLayout","class":true,"typeName":"horizontal","single":true,"description":"横向布局器","example":true,"icon":"singleton","showname":"HorizontalLayout","namespace":"Edo.layouts","__id":1039,"__height":21},"Edo.layouts.VerticalLayout":{"name":"Edo.layouts.VerticalLayout","class":true,"typeName":"vertical","single":true,"description":"竖向布局器","example":true,"icon":"singleton","showname":"VerticalLayout","namespace":"Edo.layouts","__id":1040,"__height":21},"Edo.layouts.ViewstackLayout":{"name":"Edo.layouts.ViewstackLayout","class":true,"typeName":"viewstack","single":true,"description":"单显示布局器","example":true,"icon":"singleton","showname":"ViewstackLayout","namespace":"Edo.layouts","__id":1041,"__height":21},"Edo.controls.Control":{"name":"Edo.controls.Control","class":true,"typeName":"control","description":"控件基类\r\n        1.验证: valid,invalid, showValid\r\n        2.弹出框:popupCt, popupWidth, popupWidth, popupType, enableResizePopup","extend":"Edo.core.UIComponent","example":"validate\r\n        popup","events":[{"name":"valid","event":true,"description":"验证成功事件"},{"name":"invalid","event":true,"description":"验证失败事件"},{"name":"popupshow","event":true,"description":"下拉框显示事件"},{"name":"popuphide","event":true,"description":"下拉框隐藏事件"}],"properties":[{"name":"valueField","property":true,"type":"String","description":"用于在作为编辑器使用时,获取的编辑值"},{"name":"popupWidth","property":true,"type":"Number","description":"浮动下拉框宽度"},{"name":"popupHeight","property":true,"type":"Number","description":"浮动下拉框高度"},{"name":"popupType","property":true,"type":"String","description":"浮动下拉框类型, 默认是box"},{"name":"enableResizePopup","property":true,"type":"String","description":"是否允许拖拽调节浮动下拉框, 默认是false"},{"name":"defaultWidth","property":true,"default":"100"},{"name":"minWidth","property":true,"default":"80"},{"name":"showValid","property":true,"type":"Boolean","description":"当组件应用验证器,并验证失败的时候, 是否显示错误信息, 默认是true"}],"functions":[{"name":"valid","function":true,"description":"验证通过(取消验证不通过的一些外观显示,如红色下划线等)"},{"name":"invalid","function":true,"description":"验证不通过(增加验证不通过的一些外观显示,如红色下划线等)","params":[{"type":"String","name":"msg","description":"验证错误信息字符串"}]},{"name":"showPopup","function":true,"description":"显示下拉框","params":[{"type":"Number","name":"x"},{"type":"Number","name":"y"},{"type":"Boolean","name":"modal"},{"type":"Object","name":"modalCt","description":"下拉框的定位逻辑容器"}]},{"name":"hidePopup","function":true,"description":"隐藏下拉框"}],"icon":"class","showname":"Control","namespace":"Edo.controls","__id":1043,"__height":21},"Edo.controls.Button":{"name":"Edo.controls.Button","class":true,"typeName":"button","description":"按钮","extend":"Edo.controls.Control","events":[{"name":"toggle","event":true,"description":"当enableToggle为true时,点击按钮将会激发此事件"},{"name":"arrowclick","event":true,"description":"当设置了arrowMode后,点击arrow区域,就会激发此事件"}],"properties":[{"name":"defaultWidth","property":true,"default":"16"},{"name":"defaultHeight","property":true,"default":"22"},{"name":"minWidth","property":true,"default":"16"},{"name":"minHeight","property":true,"default":"22"},{"name":"showMenu","property":true,"type":"Boolean","default":"true","description":"显示菜单"},{"name":"popupWidth","property":true,"default":"100"},{"name":"text","property":true,"type":"String","description":"按钮文本"},{"name":"icon","property":true,"type":"String","description":"按钮图标"},{"name":"iconAlign","property":true,"type":"String","description":"按钮图标位置:left,top,right,bottom"},{"name":"arrowMode","property":true,"type":"String","description":"按钮arrow模式,用于更丰富的按钮效果:menu, split, close"},{"name":"arrowAlign","property":true,"type":"String","description":"按钮arrow位置:left,top,right,bottom"},{"name":"pressed","property":true,"type":"Boolean","description":"按钮的toggle状态"},{"name":"minWidth","property":true,"default":"20"}],"icon":"class","showname":"Button","namespace":"Edo.controls","__id":1044,"__height":21},"Edo.controls.CheckBox":{"name":"Edo.controls.CheckBox","class":true,"typeName":"checkbox","description":"多选框","extend":"Edo.controls.Control","events":[{"name":"checkedchange","event":true,"description":"选中状态改变事件"}],"properties":[{"name":"text","property":true,"type":"String","description":"文本"},{"name":"checked","property":true,"type":"Boolean","description":"是否选中状态"}],"icon":"class","showname":"CheckBox","namespace":"Edo.controls","__id":1045,"__height":21},"Edo.controls.TextInput":{"name":"Edo.controls.TextInput","class":true,"typeName":"textinput, text","description":"文本输入框:单行/密码/多行","extend":"Edo.controls.Control","properties":[{"name":"defaultWidth","property":true,"default":"100"},{"name":"minWidth","property":true,"default":"20"},{"name":"text","property":true,"type":"String","description":"文本"},{"name":"readOnly","property":true,"type":"Boolean","default":"false","description":"是否只读,默认false"},{"name":"selectOnFocus","property":true,"type":"Boolean","default":"false","description":"是否在获得焦点的时候,选择文本.默认false"},{"name":"emptyText","property":true,"type":"String","description":"文本为空时的显示文本"},{"name":"emptyCls","property":true,"type":"String","default":"'e-text-empty'","description":"文本为空时的显示样式"},{"name":"withKeyUp","property":true,"type":"Boolean","default":"false","description":"文本change是否由keyup事件激发"}],"functions":[{"name":"setText","function":true,"description":"设置文本","params":[{"type":"String","name":"value"}]}],"icon":"class","showname":"TextInput","namespace":"Edo.controls","__id":1046,"__height":21},"Edo.controls.Password":{"name":"Edo.controls.Password","class":true,"typeName":"password","description":"密码输入框","extend":"Edo.controls.TextInput","icon":"class","showname":"Password","namespace":"Edo.controls","__id":1047,"__height":21},"Edo.controls.TextArea":{"name":"Edo.controls.TextArea","class":true,"typeName":"textarea","description":"多行输入框","extend":"Edo.controls.TextInput","properties":[{"name":"defaultHeight","property":true,"default":"40"}],"icon":"class","showname":"TextArea","namespace":"Edo.controls","__id":1048,"__height":21},"Edo.controls.Trigger":{"name":"Edo.controls.Trigger","class":true,"typeName":"trigger","description":"下拉弹出框","extend":"Edo.controls.TextInput","events":[{"name":"trigger","event":true,"description":"trigger图标点击事件"}],"properties":[{"name":"maxHeight","property":true,"default":"500"},{"name":"triggerPopup","property":true,"type":"Boolean","default":"false","description":"为true在按trigger图片的时候,自动显示"},{"name":"clearVisible","property":true,"type":"Boolean","description":"X号的清除图标是否显示,默认false"}],"icon":"class","showname":"Trigger","namespace":"Edo.controls","__id":1049,"__height":21},"Edo.controls.Search":{"name":"Edo.controls.Search","class":true,"typeName":"search","description":"搜索框","extend":"Edo.controls.Trigger","events":[{"name":"cleartrigger","event":true,"description":"X号的清除图标点击事件"}],"icon":"class","showname":"Search","namespace":"Edo.controls","__id":1050,"__height":21},"Edo.controls.ComboBox":{"name":"Edo.controls.ComboBox","class":true,"typeName":"combobox","description":"下拉选择框combobox","extend":"Edo.controls.Trigger","events":[{"name":"selectionchange","event":true,"description":"下拉表格选中状态改变事件"}],"properties":[{"name":"triggerPopup","property":true,"default":"true"},{"name":"displayField","property":true,"type":"String","description":"下拉表格显示字段, 默认是\"text\""},{"name":"selectedIndex","property":true,"type":"Number","description":"选中的索引"},{"name":"selectedItem","property":true,"type":"Number","description":"选中的行对象"},{"name":"data","property":true,"type":"datatable","description":"数组集合,作为下拉框显示的数据列表"}],"icon":"class","showname":"ComboBox","namespace":"Edo.controls","__id":1051,"__height":21},"Edo.controls.Radio":{"name":"Edo.controls.Radio","class":true,"typeName":"radio","description":"单选框","extend":"Edo.controls.CheckBox","icon":"class","showname":"Radio","namespace":"Edo.controls","__id":1052,"__height":21},"Edo.controls.Date":{"name":"Edo.controls.Date","class":true,"typeName":"date","description":"日期输入框","extend":"Edo.controls.Trigger","events":[{"name":"datechange","event":true,"description":"日期改变事件"}],"properties":[{"name":"enableResizePopup","property":true,"default":"false"},{"name":"valueField","property":true,"default":"date"},{"name":"popupWidth","property":true,"default":"178"},{"name":"popupHeight","property":true,"default":"auto"},{"name":"popupType","property":true,"default":"ct"},{"name":"triggerPopup","property":true,"default":"true"},{"name":"format","property":true,"type":"String","description":"格式化显示日期字符串,显示在text上"},{"name":"inputFormat","property":true,"type":"String","description":"如果输入日期字符串,则用此格式化器得到日期对象"},{"name":"date","property":true,"type":"Date","description":"日期,默认是今天"},{"name":"valueField","property":true,"default":"date"}],"icon":"class","showname":"Date","namespace":"Edo.controls","__id":1053,"__height":21},"Edo.controls.DatePicker":{"name":"Edo.controls.DatePicker","class":true,"typeName":"datepicker","description":"日期选择组件","extend":"Edo.containers.Box","events":[{"name":"beforedatechange","event":true,"description":"日期改变前事件"},{"name":"datechange","event":true,"description":"日期改变事件"},{"name":"dateselection","event":true,"description":"日期选择改变事件,由界面激发"}],"properties":[{"name":"weekStartDay","property":true,"type":"Number","description":"第一个列星期日"},{"name":"valueField","property":true,"default":"date"},{"name":"width","property":true,"default":"177"},{"name":"padding","property":true,"default":"[0,0,0,0] ( [left, top, right, bottom] )"},{"name":"verticalGap","property":true,"default":"0"},{"name":"date","property":true,"type":"Date","description":"当前选中的日期,默认是今天"},{"name":"viewDate","property":true,"type":"Date","description":"当前的视图日期"},{"name":"format","property":true,"type":"String","default":"'Y-m-d'","description":"格式化显示日期字符串"},{"name":"format","property":true,"type":"String","default":"'Y-m-d'","description":"格式化显示日期字符串"},{"name":"incrementConstant","property":true,"type":"String","default":"Date.DAY","description":"增长单位"},{"name":"alternateIncrementConstant","property":true,"type":"String","default":"Date.MONTH","description":"快速增长单位"}],"icon":"class","showname":"DatePicker","namespace":"Edo.controls","__id":1054,"__height":21},"Edo.controls.Label":{"name":"Edo.controls.Label","class":true,"typeName":"label","description":"文本显示框","extend":"Edo.controls.Control","properties":[{"name":"autoWidth","property":true,"default":"true"},{"name":"autoHeight","property":true,"default":"true"},{"name":"minWidth","property":true,"default":"20"},{"name":"text","property":true,"type":"String","description":"文本"},{"name":"forId","property":true,"type":"{String}","description":"目标组件ID"}],"icon":"class","showname":"Label","namespace":"Edo.controls","__id":1055,"__height":21},"Edo.controls.Error":{"name":"Edo.controls.Error","class":true,"typeName":"error","description":"错误显示条","extend":"Edo.controls.Control","names":{"Edo.controls.Error#error\r\n//":{"name":"error\r\n//","description":"验证错误事件\r\n//"}},"properties":[{"name":"text","property":true,"type":"String","description":"错误描述文本"},{"name":"autoWidth","property":true,"default":"true"},{"name":"autoHeight","property":true,"default":"true"},{"name":"visible","property":true,"default":"false"}],"icon":"class","showname":"Error","namespace":"Edo.controls","__id":1056,"__height":21},"Edo.controls.Slider":{"name":"Edo.controls.Slider","class":true,"typeName":"slider","description":"拖拽调节器","extend":"Edo.controls.Control","events":[{"name":"beforevaluechange","event":true,"description":"值改变前激发"},{"name":"valuechange","event":true,"description":"值改变事件"},{"name":"slidestart","event":true,"description":"开始slider拖拽调节前"},{"name":"slide","event":true,"description":"slider拖拽调节"},{"name":"slidecomplete","event":true,"description":"解除slider拖拽调节"}],"properties":[{"name":"valueField","property":true,"default":"'value'"},{"name":"value","property":true,"type":"Number","description":"值"},{"name":"minValue","property":true,"type":"Number","description":"最小值"},{"name":"maxValue","property":true,"type":"Number","description":"最大值"},{"name":"increment","property":true,"type":"Number","description":"最小增加值"},{"name":"defaultWidth","property":true,"default":"100"},{"name":"defaultHeight","property":true,"default":"22"},{"name":"minHeight","property":true,"default":"22"},{"name":"minWidth","property":true,"default":"30"},{"name":"direction","property":true,"type":"String","default":"'horizontal'  ( horizontal, vertical )","description":"横竖方位"}],"icon":"class","showname":"Slider","namespace":"Edo.controls","__id":1057,"__height":21},"Edo.controls.VSlider":{"name":"Edo.controls.VSlider","class":true,"typeName":"vslider","description":"竖向拖拽调节器","extend":"Edo.controls.Slider","properties":[{"name":"direction","property":true,"default":"'vertical'"},{"name":"minWidth","property":true,"default":"22"},{"name":"minHeight","property":true,"default":"30"},{"name":"defaultHeight","property":true,"default":"100"},{"name":"defaultWidth","property":true,"default":"22"}],"icon":"class","showname":"VSlider","namespace":"Edo.controls","__id":1058,"__height":21},"Edo.controls.Spinner":{"name":"Edo.controls.Spinner","class":true,"typeName":"spinner","description":"数值调节器","extend":"Edo.controls.Trigger","events":[{"name":"beforevaluechange","event":true,"description":"值改变前激发"},{"name":"valuechange","event":true,"description":"值改变事件"},{"name":"spin","event":true,"description":"激发spin事件,就是用户通过操作,发生了up/down的值调整"}],"properties":[{"name":"value","property":true,"type":"Number","description":"值"},{"name":"minValue","property":true,"type":"Number","description":"最小值"},{"name":"maxValue","property":true,"type":"Number","description":"最大值"},{"name":"incrementValue","property":true,"type":"Number","description":"增加值"},{"name":"alternateIncrementValue","property":true,"type":"Number","description":"快速增加值"},{"name":"alternateKey","property":true,"type":"String","description":"快速增加键,默认是\"shiftKey\""}],"icon":"class","showname":"Spinner","namespace":"Edo.controls","__id":1059,"__height":21},"Edo.controls.DateSpinner":{"name":"Edo.controls.DateSpinner","class":true,"typeName":"datespinner","description":"日期调节器","extend":"Edo.controls.Spinner","properties":[{"name":"value","property":true,"default":"new Date()"},{"name":"incrementValue","property":true,"default":"1"},{"name":"alternateIncrementValue","property":true,"default":"1"}],"icon":"class","showname":"DateSpinner","namespace":"Edo.controls","__id":1060,"__height":21},"Edo.controls.TimeSpinner":{"name":"Edo.controls.TimeSpinner","class":true,"typeName":"timespinner","description":"小时调节器","extend":"Edo.controls.DateSpinner","properties":[{"name":"format","property":true,"default":"\"H:i\""},{"name":"incrementValue","property":true,"default":"1"},{"name":"incrementConstant","property":true,"default":"Date.MINUTE"},{"name":"alternateIncrementValue","property":true,"default":"1"},{"name":"alternateIncrementConstant","property":true,"default":"Date.HOUR"}],"icon":"class","showname":"TimeSpinner","namespace":"Edo.controls","__id":1061,"__height":21},"Edo.controls.HtmlEditor":{"name":"Edo.controls.HtmlEditor","class":true,"typeName":"htmleditor","description":"Html富文本编辑器","extend":"Edo.controls.Control","icon":"class","showname":"HtmlEditor","namespace":"Edo.controls","__id":1062,"__height":21},"Edo.navigators.Navigator":{"name":"Edo.navigators.Navigator","class":true,"typeName":"navigator, nav","description":"实现导航功能","extend":"Edo.containers.Box","example":true,"properties":[{"name":"layout","property":true,"default":"'horizontal'"},{"name":"horizontalScrollPolicy","property":true,"default":"'off'"},{"name":"verticalScrollPolicy","property":true,"default":"'off'"}],"icon":"class","showname":"Navigator","namespace":"Edo.navigators","__id":1067,"__height":21},"Edo.navigators.Menu":{"name":"Edo.navigators.Menu","class":true,"typeName":"menu","description":"菜单","extend":"Edo.navigators.Navigator","properties":[{"name":"layout","property":true,"default":"'vertical'"},{"name":"minWidth","property":true,"default":"40"},{"name":"defaultWidth","property":true,"default":"100"},{"name":"verticalGap","property":true,"default":"0"},{"name":"padding","property":true,"default":"[1,1,1,1]"},{"name":"autoHide","property":true,"type":"Boolean","default":"false","description":"控制当poup时,是否自动隐藏"}],"icon":"class","showname":"Menu","namespace":"Edo.navigators","__id":1068,"__height":21},"Edo.navigators.ToggleBar":{"name":"Edo.navigators.ToggleBar","class":true,"typeName":"togglebar","description":"selectedIndex,overClickable(true时,当鼠标移动到某一按钮上,此按钮被激发fire click事件)","extend":"Edo.navigators.Navigator","events":[{"name":"beforeselectionchange","event":true,"description":"选中状态改变前事件"},{"name":"selectionchange","event":true,"description":"选中状态改变事件"}],"properties":[{"name":"selectedIndex","property":true,"type":"Number","description":"选中的index"},{"name":"selectedItem","property":true,"type":"Object","description":"选中的对象"}],"icon":"class","showname":"ToggleBar","namespace":"Edo.navigators","__id":1069,"__height":21},"Edo.navigators.TabBar":{"name":"Edo.navigators.TabBar","class":true,"typeName":"tabbar","description":"tab切换器","extend":"Edo.navigators.ToggleBar","properties":[{"name":"defaultHeight","property":true,"default":"22"},{"name":"border","property":true,"default":"[1,1,1,1]"},{"name":"padding","property":true,"default":"[5,2,5,2]"},{"name":"width","property":true,"default":"'100%'"},{"name":"verticalAlign","property":true,"default":"'bottom'"},{"name":"horizontalGap","property":true,"default":"2"},{"name":"minHeight","property":true,"default":"17"},{"name":"position","property":true,"type":"String","default":"top (left, top, right, bottom)","description":"tabbar位置"}],"icon":"class","showname":"TabBar","namespace":"Edo.navigators","__id":1070,"__height":21},"Edo.navigators.VTabBar":{"name":"Edo.navigators.VTabBar","class":true,"typeName":"vtabbar","extend":"Edo.navigators.TabBar","description":"实现竖向的tabbar","properties":[{"name":"width","property":true,"default":"'auto'"},{"name":"height","property":true,"default":"'100%'"},{"name":"verticalAlign","property":true,"default":"'top'"},{"name":"horizontalAlign","property":true,"default":"'left'"},{"name":"defaultWidth","property":true,"default":"22"},{"name":"defaultHeight","property":true,"default":"60"},{"name":"position","property":true,"default":"'left'"},{"name":"layout","property":true,"default":"'vertical'"},{"name":"padding","property":true,"default":"[2,5,2,5]"}],"icon":"class","showname":"VTabBar","namespace":"Edo.navigators","__id":1071,"__height":21},"Edo.lists.Table":{"name":"Edo.lists.Table","class":true,"typeName":"table","description":"table表格组件","extend":"Edo.controls.Control","example":true,"events":[{"name":"beforeheadermousedown","event":true,"description":"表头mousedown前事件"},{"name":"headermousedown","event":true,"description":"表头mousedown事件"},{"name":"beforeheaderclick","event":true,"description":"表头click前事件"},{"name":"headerclick","event":true,"description":"表头click事件"},{"name":"beforeheaderdblclick","event":true,"description":"表头dblclick前事件"},{"name":"headerdblclick","event":true,"description":"表头dblclick事件"},{"name":"beforebodymousedown","event":true,"description":"表身mousedown前事件"},{"name":"bodymousedown","event":true,"description":"表身mousedown事件"},{"name":"beforebodyclick","event":true,"description":"表身click前事件"},{"name":"bodyclick","event":true,"description":"表身click事件"},{"name":"beforebodydblclick","event":true,"description":"表身dblclick前事件"},{"name":"bodydblclick","event":true,"description":"表身dblclick事件"},{"name":"beforeselectionchange","event":true,"description":"行选择改变前事件"},{"name":"selectionchange","event":true,"description":"行选择改变事件"},{"name":"beforecellselectionchange","event":true,"description":"单元格选择改变前事件"},{"name":"cellselectionchange","event":true,"description":"单元格选择改变事件"},{"name":"beforecelledit","event":true,"description":"单元格编辑事件"},{"name":"celledit","event":true,"description":"单元格编辑事件"},{"name":"beforesubmitedit","event":true,"description":"单元格编辑提交事件"},{"name":"submitedit","event":true,"description":"单元格编辑提交事件"},{"name":"beforerowdragdrop","event":true,"description":"行拖拽投放前事件"},{"name":"rowdragdrop","event":true,"description":"行拖拽投放事件"},{"name":"beforecelldragdrop","event":true,"description":"单元格拖拽投放前事件"},{"name":"celldragdrop","event":true,"description":"单元格拖拽投放事件"},{"name":"beforescroll","event":true,"description":"滚动条前事件"},{"name":"scroll","event":true,"description":"滚动条事件"}],"properties":[{"name":"columns","property":true,"type":"Array","description":"列配置"},{"name":"data","property":true,"type":"datatable","description":"数据源对象"},{"name":"autoExpandColumn","property":true,"type":"String","description":"column的id.将表格的某个column自适应表格宽度"},{"name":"autoExpandColumnMin","property":true,"type":"Number","default":"50","description":"自适应列的最小宽度"},{"name":"autoExpandColumnMin","property":true,"type":"Number","default":"2000","description":"自适应列的最大宽度"},{"name":"headerVisible","property":true,"type":"Boolean","default":"true","description":"是否显示表头"},{"name":"rowHeight","property":true,"type":"Number","default":"21","description":"行高"},{"name":"columnWidth","property":true,"type":"Number","default":"100","description":"列宽"},{"name":"columnMinWidth","property":true,"type":"Number","default":"20","description":"最小列宽"},{"name":"headerHeight","property":true,"type":"Number","default":"24","description":"表头高度"},{"name":"verticalLine","property":true,"type":"Boolean","default":"true","description":"是否显示表格竖线"},{"name":"horizontalLine","property":true,"type":"Boolean","default":"true","description":"是否显示表格横线"},{"name":"verticalScrollPolicy","property":true,"type":"String","default":"auto ( auto, on, off)","description":"表格竖向滚动条"},{"name":"horizontalScrollPolicy","property":true,"type":"String","default":"auto ( auto, on, off)","description":"表格横向滚动条"},{"name":"live","property":true,"type":"Boolean","default":"false","description":"是否启用live动态服务端数据获取模式"},{"name":"minWidth","property":true,"default":"100"},{"name":"minHeight","property":true,"default":"50"},{"name":"defaultWidth","property":true,"default":"200"},{"name":"defaultHeight","property":true,"default":"100"},{"name":"enableDragDrop","property":true,"type":"Boolean","default":"false","description":"是否允许行拖拽投放"},{"name":"dragDropAction","property":true,"type":"String","default":"move. ( move copy )","description":"行拖拽操作模式"},{"name":"selectAction","property":true,"type":"String","default":"mousedown","description":"选择激发的dom事件名"},{"name":"editAction","property":true,"type":"String","default":"dblclick","description":"编辑激发的dom事件名"},{"name":"enableColumnSort","property":true,"type":"Boolean","default":"true","description":"是否允许列排序"},{"name":"enableSelect","property":true,"type":"Boolean","default":"true","description":"是否允许行选择"},{"name":"rowSelectMode","property":true,"type":"String","default":"single ( single, multi )","description":"行选择模式"},{"name":"enableCellSelect","property":true,"type":"Boolean","default":"true","description":"是否允许单元格选择"},{"name":"cellSelectMode","property":true,"type":"String","default":"single ( single, multi )","description":"单元格选择模式"}],"functions":[{"name":"getSelected","function":true,"description":"获得当前选中行","return":{"type":"Object","description":"行对象"}},{"name":"getCellSelected","function":true,"description":"获得当前选中单元格","return":{"type":"Object","description":"单元格对象"}},{"name":"getSelecteds","function":true,"description":"获得选中的行集合","return":{"type":"Array","description":"行数组"}},{"name":"getCellSelecteds","function":true,"description":"获得选中的单元格集合","return":{"type":"Array","description":"单元格数组"}},{"name":"isSelected","function":true,"description":"是否选中某行","params":[{"type":"Object/Number","name":"row","description":"行对象或行索引"}],"return":{"type":"Boolean"}},{"name":"isCellSelected","function":true,"description":"是否选中某单元格","params":[{"type":"Object/Number","name":"row","description":"行对象或行索引"},{"type":"Object/Number","name":"col","description":"列对象或列索引"}],"return":{"type":"Boolean"}},{"name":"select","function":true,"description":"选中行","params":[{"type":"Object/Number","name":"row","description":"行对象或行索引"}]},{"name":"selectRange","function":true,"description":"选中多行","params":[{"type":"Array","name":"rows","description":"行数组"}]},{"name":"selectCell","function":true,"description":"选中行","params":[{"type":"Object/Number","name":"row","description":"行对象或行索引"},{"type":"Object/Number","name":"col","description":"列对象或列索引"}]},{"name":"selectCellRange","function":true,"description":"选中多单元格","params":[{"type":"Array","name":"rcs","description":"单元格数组"}]},{"name":"deselect","function":true,"description":"取消选中行","params":[{"type":"Object/Number","name":"row","description":"行对象或行索引"}]},{"name":"deselectRange","function":true,"description":"取消选中多行","params":[{"type":"Array","name":"rows","description":"行数组"}]},{"name":"deselectCell","function":true,"description":"取消选中单元格","params":[{"type":"Object/Number","name":"row","description":"行对象或行索引"},{"type":"Object/Number","name":"col","description":"列对象或列索引"}]},{"name":"deselectCellRange","function":true,"description":"取消选中多单元格","params":[{"type":"Array","name":"rcs","description":"单元格数组"}]},{"name":"beginEdit","function":true,"description":"对指定单元格进行编辑","params":[{"type":"Object/Number","name":"row","description":"行对象或行索引"},{"type":"Object/Number","name":"col","description":"列对象或列索引"},{"type":"Object","name":"editor","description":"单元格编辑器.如果不传入,"}]},{"name":"submitEdit","function":true,"description":"提交单元格编辑器编辑结果","params":[{"type":"Object","name":"data","description":"编辑的结果数据"}]},{"name":"sortColumn","function":true,"description":"排序列","params":[{"type":"Object/Number","name":"col","description":"列对象或索引"}]}],"icon":"class","showname":"Table","namespace":"Edo.lists","__id":1073,"__height":21},"Edo.lists.Tree":{"name":"Edo.lists.Tree","class":true,"typeName":"tree","description":"树状组件","extend":"Edo.lists.Table","example":true,"events":[{"name":"beforetoggle","event":true,"description":"节点折叠前事件"},{"name":"toggle","event":true,"description":"节点折叠事件"}],"names":{"Edo.lists.Tree#data":{"name":"data","type":"datatree"}},"properties":[{"name":"treeColumn","property":true,"type":"String","description":"作为树形节点的列id"}],"icon":"class","showname":"Tree","namespace":"Edo.lists","__id":1074,"__height":21},"Edo.controls.Progress":{"name":"Edo.controls.Progress","class":true,"typeName":"progress","description":"进度条","extend":"Edo.core.UIComponent","events":[{"name":"progresschange","event":true}],"properties":[{"name":"showText","property":true,"type":"Boolean","default":"true","description":"是否显示文本"},{"name":"progress","property":true,"type":"Number","default":"0(0~100)","description":"进度值"},{"name":"text","property":true,"type":"String","description":"文本"}],"icon":"class","showname":"Progress","namespace":"Edo.controls","__id":1063,"__height":21},"Edo.controls.Module":{"name":"Edo.controls.Module","class":true,"typeName":"module","description":"模块加载器.能加载指定路径的文件,如user.xml, user.html, user.jsp等.","extend":"Edo.core.UIComponent","example":true,"events":[{"name":"load","event":true,"description":true},{"name":"unload","event":true,"description":true},{"name":"beforeunload","event":true,"description":true}],"functions":[{"name":"setHtml","function":true,"description":"(重写)不能加入任何html"},{"name":"load","function":true,"description":"加载一个指定url的文件","params":[{"type":"String","name":"src","description":"可以是edo的xml定义文件,也可以是任何一个静态或动态的网页"},{"type":"Boolean","name":"config","description":"说明src引用的是否是配置(xml,json)"}]},{"name":"unload","function":true,"description":"卸载一个当前加载的页面"}],"icon":"class","showname":"Module","namespace":"Edo.controls","__id":1064,"__height":21},"Edo.Window":{"name":"Edo.Window","class":true,"typeName":"window","description":"弹出面板类","extend":"Edo.containers.Dialog","example":true,"icon":"class","showname":"Window","namespace":"Edo","__id":1075,"__pid":1000,"__depth":1,"__nextid":1076,"__preid":1072,"__index":25,"__height":21},"Edo.MessageBox":{"name":"Edo.MessageBox","class":true,"typeName":"messagebox, msgbox","description":"弹出面板","extend":"Edo.containers.Dialog","example":true,"icon":"class","showname":"MessageBox","namespace":"Edo","__id":1076,"__pid":1000,"__depth":1,"__nextid":null,"__preid":1075,"__index":26,"__height":21},"Edo.controls.MultiSelect":{"name":"Edo.controls.MultiSelect","class":true,"typeName":"multiselect","description":"多选框","extend":"Edo.lists.Table","example":true,"icon":"class","showname":"MultiSelect","namespace":"Edo.controls","__id":1065,"__height":21}}