DROP TABLE IF EXISTS ss_admin_menu_categories;
CREATE TABLE `ss_admin_menu_categories` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `category_name` varchar(255) NOT NULL,
  `module` varchar(255) NOT NULL,
  `action` varchar(255) NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=MyISAM AUTO_INCREMENT=8 DEFAULT CHARSET=utf8;

INSERT INTO ss_admin_menu_categories(`id`,`category_name`,`module`,`action`) VALUES('1','Settings','mod_site','admin_dashboard');
INSERT INTO ss_admin_menu_categories(`id`,`category_name`,`module`,`action`) VALUES('2','Pages','mod_menu_item','admin_dashboard');
INSERT INTO ss_admin_menu_categories(`id`,`category_name`,`module`,`action`) VALUES('3','Contents','mod_article','admin_dashboard');
INSERT INTO ss_admin_menu_categories(`id`,`category_name`,`module`,`action`) VALUES('4','Layouts','mod_modules','index');
INSERT INTO ss_admin_menu_categories(`id`,`category_name`,`module`,`action`) VALUES('5','Files','mod_filemanager','admin_dashboard');
INSERT INTO ss_admin_menu_categories(`id`,`category_name`,`module`,`action`) VALUES('6','Users','mod_user','admin_dashboard');
INSERT INTO ss_admin_menu_categories(`id`,`category_name`,`module`,`action`) VALUES('7','Licenses','mod_authorization','admin_list');

DROP TABLE IF EXISTS ss_admin_menu_items;
CREATE TABLE `ss_admin_menu_items` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `module` varchar(50) NOT NULL,
  `action` varchar(50) NOT NULL,
  `text` varchar(255) DEFAULT NULL,
  `level` int(11) NOT NULL DEFAULT '1',
  `priority` int(11) NOT NULL DEFAULT '10',
  `category_id` int(11) NOT NULL,
  PRIMARY KEY (`id`),
  KEY `module` (`module`),
  KEY `priority` (`priority`)
) ENGINE=MyISAM AUTO_INCREMENT=30 DEFAULT CHARSET=utf8;

INSERT INTO ss_admin_menu_items(`id`,`module`,`action`,`text`,`level`,`priority`,`category_id`) VALUES('1','mod_article','admin_list','Articles','1','1','3');
INSERT INTO ss_admin_menu_items(`id`,`module`,`action`,`text`,`level`,`priority`,`category_id`) VALUES('3','mod_friendlink','admin_list','Hot Links','1','5','1');
INSERT INTO ss_admin_menu_items(`id`,`module`,`action`,`text`,`level`,`priority`,`category_id`) VALUES('25','mod_backup','admin_list','Data Bakup/Recovery','1','6','1');
INSERT INTO ss_admin_menu_items(`id`,`module`,`action`,`text`,`level`,`priority`,`category_id`) VALUES('6','mod_product','admin_list','Products','1','2','3');
INSERT INTO ss_admin_menu_items(`id`,`module`,`action`,`text`,`level`,`priority`,`category_id`) VALUES('8','mod_download','admin_list','Downloads','1','3','3');
INSERT INTO ss_admin_menu_items(`id`,`module`,`action`,`text`,`level`,`priority`,`category_id`) VALUES('9','mod_static','admin_list','Static Contents','2','2','2');
INSERT INTO ss_admin_menu_items(`id`,`module`,`action`,`text`,`level`,`priority`,`category_id`) VALUES('10','mod_qq','admin_list','Services','1','2','1');
INSERT INTO ss_admin_menu_items(`id`,`module`,`action`,`text`,`level`,`priority`,`category_id`) VALUES('12','mod_message','admin_list','Messages','1','4','3');
INSERT INTO ss_admin_menu_items(`id`,`module`,`action`,`text`,`level`,`priority`,`category_id`) VALUES('13','mod_menu_item','admin_list','Site Columns','1','1','2');
INSERT INTO ss_admin_menu_items(`id`,`module`,`action`,`text`,`level`,`priority`,`category_id`) VALUES('15','mod_payaccount','admin_list','Payment Accounts','2','3','1');
INSERT INTO ss_admin_menu_items(`id`,`module`,`action`,`text`,`level`,`priority`,`category_id`) VALUES('16','mod_order','admin_list','Orders','2','2','6');
INSERT INTO ss_admin_menu_items(`id`,`module`,`action`,`text`,`level`,`priority`,`category_id`) VALUES('19','mod_statistics','admin_list','Statistics','1','4','1');
INSERT INTO ss_admin_menu_items(`id`,`module`,`action`,`text`,`level`,`priority`,`category_id`) VALUES('20','mod_user','admin_list','Users','1','1','6');
INSERT INTO ss_admin_menu_items(`id`,`module`,`action`,`text`,`level`,`priority`,`category_id`) VALUES('22','mod_navigation','admin_list','Homepage Guidances','1','3','2');
INSERT INTO ss_admin_menu_items(`id`,`module`,`action`,`text`,`level`,`priority`,`category_id`) VALUES('23','mod_template','admin_list','Templates','1','4','2');
INSERT INTO ss_admin_menu_items(`id`,`module`,`action`,`text`,`level`,`priority`,`category_id`) VALUES('24','mod_site','admin_list','Web Settings','1','1','1');
INSERT INTO ss_admin_menu_items(`id`,`module`,`action`,`text`,`level`,`priority`,`category_id`) VALUES('26','mod_attachment','admin_list','Image Watermark/Thumb','1','7','1');
INSERT INTO ss_admin_menu_items(`id`,`module`,`action`,`text`,`level`,`priority`,`category_id`) VALUES('27','mod_advert','admin_list','Advert Tool','1','8','1');
INSERT INTO ss_admin_menu_items(`id`,`module`,`action`,`text`,`level`,`priority`,`category_id`) VALUES('28','mod_sitestarmaker','admin_list','Picture Tool','1','9','1');
INSERT INTO ss_admin_menu_items(`id`,`module`,`action`,`text`,`level`,`priority`,`category_id`) VALUES('29','mod_bulletin','admin_list','Bulletins','1','5','3');

DROP TABLE IF EXISTS ss_admin_shortcuts;
CREATE TABLE `ss_admin_shortcuts` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `module` varchar(50) NOT NULL,
  `action` varchar(50) NOT NULL,
  `image` varchar(255) DEFAULT NULL,
  `priority` int(11) NOT NULL DEFAULT '10',
  PRIMARY KEY (`id`),
  KEY `module` (`module`),
  KEY `priority` (`priority`)
) ENGINE=MyISAM AUTO_INCREMENT=8 DEFAULT CHARSET=utf8;

INSERT INTO ss_admin_shortcuts(`id`,`module`,`action`,`image`,`priority`) VALUES('1','mod_article','admin_add','add_article.png','1');
INSERT INTO ss_admin_shortcuts(`id`,`module`,`action`,`image`,`priority`) VALUES('2','mod_product','admin_add','add_product.png','2');
INSERT INTO ss_admin_shortcuts(`id`,`module`,`action`,`image`,`priority`) VALUES('3','mod_static','admin_add','add_static.png','3');
INSERT INTO ss_admin_shortcuts(`id`,`module`,`action`,`image`,`priority`) VALUES('4','mod_user','admin_list','manage_users.png','4');
INSERT INTO ss_admin_shortcuts(`id`,`module`,`action`,`image`,`priority`) VALUES('6','mod_site','admin_list','set_siteinfo.png','5');
INSERT INTO ss_admin_shortcuts(`id`,`module`,`action`,`image`,`priority`) VALUES('7','mod_template','admin_list','manage_tpl.png','6');

DROP TABLE IF EXISTS ss_article_categories;
CREATE TABLE `ss_article_categories` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `name` varchar(255) NOT NULL,
  `alias` varchar(255) NOT NULL,
  `article_category_id` int(11) NOT NULL DEFAULT '0',
  `i_order` int(11) NOT NULL DEFAULT '0',
  `s_locale` varchar(50) NOT NULL,
  `published` enum('0','1') NOT NULL DEFAULT '1',
  `for_roles` varchar(50) NOT NULL DEFAULT '{guest}',
  PRIMARY KEY (`id`),
  KEY `alias` (`alias`),
  KEY `article_category_id` (`article_category_id`),
  KEY `i_order` (`i_order`),
  KEY `s_locale` (`s_locale`),
  KEY `published` (`published`),
  KEY `for_roles` (`for_roles`)
) ENGINE=MyISAM AUTO_INCREMENT=10 DEFAULT CHARSET=utf8;

INSERT INTO ss_article_categories(`id`,`name`,`alias`,`article_category_id`,`i_order`,`s_locale`,`published`,`for_roles`) VALUES('1','Uncategorised','uncategorized','0','0','_ALL','0','{admin}');
INSERT INTO ss_article_categories(`id`,`name`,`alias`,`article_category_id`,`i_order`,`s_locale`,`published`,`for_roles`) VALUES('9','行业新闻','caa_zurLhBaL','0','6','zh_CN','1','{member}{admin}{guest}');
INSERT INTO ss_article_categories(`id`,`name`,`alias`,`article_category_id`,`i_order`,`s_locale`,`published`,`for_roles`) VALUES('3','公司新闻','caa_S1I6fxCQ','0','1','zh_CN','1','{member}{admin}{guest}');
INSERT INTO ss_article_categories(`id`,`name`,`alias`,`article_category_id`,`i_order`,`s_locale`,`published`,`for_roles`) VALUES('8','媒体报道','caa_QUCl42ax','0','5','zh_CN','1','{member}{admin}{guest}');

DROP TABLE IF EXISTS ss_articles;
CREATE TABLE `ss_articles` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `author` varchar(255) NOT NULL,
  `title` varchar(255) NOT NULL,
  `i_order` int(11) NOT NULL DEFAULT '0',
  `source` text,
  `tags` varchar(255) DEFAULT NULL,
  `intro` text NOT NULL,
  `content` longtext,
  `create_time` bigint(20) NOT NULL,
  `s_locale` varchar(50) NOT NULL,
  `pub_start_time` bigint(20) NOT NULL,
  `pub_end_time` bigint(20) NOT NULL,
  `published` enum('0','1') NOT NULL DEFAULT '1',
  `for_roles` varchar(50) NOT NULL DEFAULT '{guest}',
  `v_num` bigint(20) NOT NULL DEFAULT '0',
  `article_category_id` int(11) NOT NULL,
  `is_seo` enum('0','1') DEFAULT '0',
  `description` varchar(255) DEFAULT '',
  PRIMARY KEY (`id`),
  KEY `create_time` (`create_time`),
  KEY `s_locale` (`s_locale`),
  KEY `published` (`published`),
  KEY `for_roles` (`for_roles`),
  KEY `article_category_id` (`article_category_id`)
) ENGINE=MyISAM AUTO_INCREMENT=91 DEFAULT CHARSET=utf8;

INSERT INTO ss_articles(`id`,`author`,`title`,`i_order`,`source`,`tags`,`intro`,`content`,`create_time`,`s_locale`,`pub_start_time`,`pub_end_time`,`published`,`for_roles`,`v_num`,`article_category_id`,`is_seo`,`description`) VALUES('1','kangk','切尔西替补B方案收奇效 板凳厚度可让对手羡慕','0','','','切尔西替补B方案收奇效 板凳厚度可让对手羡慕\r\n','<p style=\"text-indent: 2em\">安切洛蒂是个固执的人，对桑德兰的比赛，他继续采用了442菱形中场，不过在人员配置上却有很大不同。首先是米克尔被换下，埃辛出任后腰，而德科与巴拉克进入首发阵容，最终，这套替补钻石阵容起到效果，球队打进3球，而是全部来自中场球员。</p><p style=\"text-indent: 2em\">社区盾杯和对胡尔城的比赛，巴拉克都不是首发，但他替补出场后，球队创造的机会立刻多了起来，而赛前德国人也支持教练的安排：&ldquo;决定因素不在战术，而在于球员的表现&rdquo;。</p><p style=\"text-indent: 2em\">或许是看到巴拉克的积极态度，因此在轮换时，安切洛蒂也决定让德国人首发，让他与兰帕德一起在德科身边活动。比赛开始后，<a href=\"http://data.sports.163.com/team/home/0005000DBJSF.html\"><font color=\"#1e50a2\">切尔西</font></a>也控制了局面，一度压制对手，但桑德兰在第18分钟却幸运领先。</p><p style=\"text-indent: 2em\">尽管意外失球，但看得出，切尔西这套新的中场配置，流畅度要远胜前两场，而巴拉克也获得了不少机会，第25分钟，他接到德科传球，可惜射门打偏，而第38分钟的禁区混战里，巴拉克的射门险些破门，只是在门线前被卡特<a href=\"http://data.sports.163.com/athlete/home/0005000EBJNa.html\"><font color=\"#1e50a2\">摩尔</font></a>救了出来。</p><p style=\"text-indent: 2em\">下半场安切洛蒂并没有像过去那样立刻换人，显然对今天中场的布置比较满意，而他的耐心也收到了回报，第52分钟，接到<a href=\"http://data.sports.163.com/athlete/home/0005000E0HHE.html\"><font color=\"#1e50a2\">伊万诺维奇</font></a>的角球摆渡，巴拉克在小禁区边缘扫射破门，这一次卡特摩尔尽管又站在了球门线前，但也无力阻止皮球入网。此后不久，兰帕德的点球让切尔西完成了反超，而德科则打进了精彩远射。最终，切尔西3-1完成反超。</p><p style=\"text-indent: 2em\">从本场比赛来看，切尔西也不是不能打菱形中场，关键还是人员配置，其实无边锋的中场，穆里尼奥早就玩过，但当时他没有博辛瓦和阿科尔这对边卫，此外，也没有德科这样的技术型球员，这也使得切尔西的中场过于硬朗，缺乏可以绣花的球员。</p><p style=\"text-indent: 2em\">安切洛蒂曾表示，现在球队里面有不少多面手，可以打出各种战术。就板凳厚度来讲，切尔西的中场要略强于流失C罗和阿隆索后的<a href=\"http://data.sports.163.com/team/home/0005000DBJSJ.html\"><font color=\"#1e50a2\">曼联</font></a>以及<a href=\"http://data.sports.163.com/team/home/0005000DBJSM.html\"><font color=\"#1e50a2\">利物浦</font></a>，而一旦日尔科夫与乔科尔两人复出，安切洛蒂在排兵布阵上将有更多选择。</p>','1236914315','zh_CN','-1','-1','1','{member}{admin}{guest}','7','2','0','');
INSERT INTO ss_articles(`id`,`author`,`title`,`i_order`,`source`,`tags`,`intro`,`content`,`create_time`,`s_locale`,`pub_start_time`,`pub_end_time`,`published`,`for_roles`,`v_num`,`article_category_id`,`is_seo`,`description`) VALUES('55','admin','南京南泰出让南京诺诗兰15%股份 估值约520万','11','','南京南泰出让南京诺诗兰15%股份 估值约520万','南京南泰出让南京诺诗兰15%股份 估值约520万','<p>户外资料网讯：据《南京纺织品进出口股份有限公司2010年第一季度报告》公布，旗下全资子公司南京南泰显示有限公司（以下简称&ldquo;南泰显示）对外出让南京诺诗兰户外用品有限公司（以下简称&ldquo;诺诗兰&rdquo;）15%股权。根据江苏立信永华资产评估房地产估价有限公司为南泰显示出具的立信永华评报字（2010）29号《股东部分权益价值评估报告书》，截至2009年12月31日，南泰显示拟转让的诺诗兰15%的部分股东权益价值评估值为517.85万元。</p><p>　　本次转让尚需遵循南京市国资监管部门的有关规定，在评估报告备案后，通过南京市产权交易中心公开对外挂牌出让。最终的转让价格将不低于经国资监管机构备案的资产评估值加评估基准日到挂牌起始日期间经审计确认的权益增加额之和，受让方也将通过公开征集和竞标的方式产生。在同等条件下，诺诗兰其他股东具有优先受让权。</p><p>　　<strong>南京诺诗兰户外用品有限公司发展沿革</strong></p><p>　　诺诗兰成立于2003年5月23日，原名为南京诺诗兰服饰有限公司，初始注册资本100万元，其中南泰显示出资75万元，股权占比75%，南京金斯服装有限公司出资25万元，股权占比25%。李瑞萍任公司执行董事，黄耿任总经理。</p><p>　　2004年4月8日，南泰显示将其持有的40%的股权、南京金斯服装有限公司将其持有的25%的股权转让给3位自然人李瑞萍、黄耿、谢代玉。转让后，南泰显示出资35万元、李瑞萍出资22.5万元、黄耿出资30万元、谢代玉出资12.5万元。同意李瑞萍辞去公司法人代表和执行董事职务，由黄耿出任执行董事和法人代表。</p><p>　　2007年5月28日，谢代玉将其持有的12.5%的股权转让给黄耿，并将注册资本增加至300万元，其中南泰显示出资75万元、黄耿出资150万元、李瑞萍出资22.5万元、李伟出资52.5万元。</p><p>　　2008年1月23日，黄耿将其持有的公司150万元出资额以200万元价格转让给南京边城体育用品有限公司（以下简称&ldquo;边城体育&rdquo;），同时注册资本增加至1500万元，变更后，南泰显示出资225万元、边城体育出资1200万元、李瑞萍出资22.5万元、李伟出资52.5万元。2008年4月2日，诺诗兰正式更名为南京诺诗兰户外用品有限公司。</p><p>　　2009年12月9日，李瑞萍、李伟将持有的诺诗兰所有股权全部转让给边城体育。</p>','1276685013','zh_CN','-1','-1','1','{member}{admin}{guest}','2','8','0','');
INSERT INTO ss_articles(`id`,`author`,`title`,`i_order`,`source`,`tags`,`intro`,`content`,`create_time`,`s_locale`,`pub_start_time`,`pub_end_time`,`published`,`for_roles`,`v_num`,`article_category_id`,`is_seo`,`description`) VALUES('3','kangk','魔兽虽走阿森纳火力不减 双枪变三叉戟立显成效','0','','','谷歌浏览器支持中文CN域名等新特性','<p style=\"text-indent: 2em\">上周末6-1客场轰塌太妃糖，<a href=\"http://data.sports.163.com/team/home/0005000DBJSY.html\"><font color=\"#1e50a2\">阿森纳</font></a>上下士气如虹，温格自然没有更换首发阵容的必要，所以出现在凯尔特公园的阵容比之联赛没有任何变动。不过锋线三叉戟的站位与职能，还是有些变化，范佩西出任了中锋，本特纳边路游弋，阿尔沙文位置介于中路与左翼之间，类似前场自由人。</p><p style=\"text-indent: 2em\">温格曾抱着双前锋打了近10年，博格<a href=\"http://data.sports.163.com/athlete/home/0005000EBKKe.html\"><font color=\"#1e50a2\">坎普</font></a>与<a href=\"http://data.sports.163.com/athlete/home/0005000EBKfZ.html\"><font color=\"#1e50a2\">亨利</font></a>的组合帮助他拿到无数荣誉与冠军。直到冰王子淡出首发后，教授才考虑其他选择，比如2006年靠一套451阵型打入欧冠决赛。但当时的亨利还处于巅峰状态，阿森纳不但能从侧翼寻求突破，攻坚战中也能指望法国天<a href=\"http://data.sports.163.com/athlete/home/0005000E0YTW.html\"><font color=\"#1e50a2\">王超</font></a>强的个人能力打开局面。</p><p style=\"text-indent: 2em\">如今大帝的印记早已被洗刷干净，阿尔沙文、本特纳与范佩西各司其职，亨利的职责由三个人共同分担。具体到各人，丹麦高塔此役偏居右翼，当克利希前插助攻时，他就移入禁区接应包抄，如果萨尼亚套上，本特纳也有不错的拿球能力，可以做桥过渡。</p><p style=\"text-indent: 2em\">阿德巴约离队原因包括和本特纳交恶，两人总不合拍。小魔兽离队，丹麦人仿佛连呼吸的空气都新鲜了许多，尽管许多人认为本特纳是取代阿德巴约的最佳人选，但从温格的用兵看，并不拘泥一定要竖个炮台在禁区内。本特纳杀伤力不及阿德巴约，但牵制作用一样出色，而且做球功夫更好，首轮联赛他就有进球，今天也有不错的及时转移。打右翼，也避免了与对手中卫死扛，他的身体优势也能得到发挥。</p><p style=\"text-indent: 2em\">禁区中路则让给范佩西与阿尔沙文做突击之用，这是一招好棋，温格看准了苏格兰后卫们转身缓慢、防线背后大把空档可用。荷兰飞侠与沙皇脚下技术都优于对手不止一筹，而且跑位与过人都很灵活，一对一对手都难以防范。</p><p style=\"text-indent: 2em\">阿尔沙文多次强行突破都制造了威胁，下半时一过二、一过三的镜头屡见不鲜。俄<a href=\"http://data.sports.163.com/athlete/home/0005000EBDca.html\"><font color=\"#1e50a2\">罗斯</font></a>人对抗能力很出色，一般的冲撞还拦不住他。范佩西则擅长钻营，禁区内抢点恰是其所长。与上周末客战埃弗顿局势相似，靠着三人打反击，效果远好于阵地战，只是今天未能更多破门而已。</p>','1236914587','zh_CN','-1','-1','1','{member}{admin}{guest}','0','2','0','');
INSERT INTO ss_articles(`id`,`author`,`title`,`i_order`,`source`,`tags`,`intro`,`content`,`create_time`,`s_locale`,`pub_start_time`,`pub_end_time`,`published`,`for_roles`,`v_num`,`article_category_id`,`is_seo`,`description`) VALUES('4','admin','官方确认切尔西签下新援 175万镑购得中场高塔','0','','','官方确认切尔西签下新援 175万镑购得中场高塔\r\n','<p style=\"text-indent: 2em\">马蒂奇目前效力于斯洛伐克球队科西策。该队的官网宣布，切尔西将以175万英镑签下马蒂奇，这一数字与之前英国媒体上所流传的版本出入较大，在此之前《每日电讯报》和《<a href=\"http://data.sports.163.com/team/home/0005000DBEZK.html\"><font color=\"#1e50a2\">太阳</font></a>报》等媒体普遍认为，切尔西要签下马蒂奇，至少要拿出400万英镑，但现在看来，蓝军通过谈判用更低的价格得到了这位中场天才。</p><p style=\"text-indent: 2em\">马蒂奇虽然只有20岁，却早已与英超有过接触。一年前，马蒂奇曾来到米堡试训，并最终打动了索斯盖特，但国家队的一纸调令让马蒂奇错过了米堡。一年后，切尔西这样级别的球队再次向其发出邀请，野心勃勃的马蒂奇不可能再错过。</p><p style=\"text-indent: 2em\">几天前，这位攻击性中场就曾主动披露，自己即将成为切尔西的球员。作为攻击性中场，马蒂奇拥有1.94米的身高，从类型上看，马蒂奇让人想起了早起的米克尔。如今，尼日利亚人已被几任教练改造为后腰，不知马蒂奇将在斯坦福桥拥有怎样的明天。</p><p style=\"text-indent: 2em\">切尔西之所以急于在今夏就敲定马蒂奇的转会问题，最大的原因是马蒂奇已被多支球队盯上。热那亚、<a href=\"http://data.sports.163.com/team/home/0005000DBJTc.html\"><font color=\"#1e50a2\">热刺</font></a>、桑德兰、乌迪内斯和莫斯科中央陆军都在追求马蒂奇，而切尔西能够最终胜出，与蓝军的影响力密不可分。</p><p style=\"text-indent: 2em\">从切尔西的菱形中场来看，经过锻炼后的马蒂奇几乎可以胜任中场任何位置。米克尔的转型成功也给安帅提了醒，只有20岁的马蒂奇的确有不同的可能性。作为攻击性中场，马蒂奇虽然拥有1.94米的身高，但脚下技术并不粗糙，风格类似于兰帕德。有理由相信，转会后的马蒂奇会在兰帕德的身上学到不少东西，走出属于自己的路。</p>','1236914615','zh_CN','-1','-1','1','{member}{admin}{guest}','0','2','0','');
INSERT INTO ss_articles(`id`,`author`,`title`,`i_order`,`source`,`tags`,`intro`,`content`,`create_time`,`s_locale`,`pub_start_time`,`pub_end_time`,`published`,`for_roles`,`v_num`,`article_category_id`,`is_seo`,`description`) VALUES('11','admin','微软发布报告自夸IE8 全球网站网易加载最慢','0','','','微软发布报告自夸IE8 全球网站网易加载最慢','<p>　　<strong>微软</strong>昨日为<strong>IE 8</strong>新浏览器的发布准备了一份赞美性的报告。微软昨日公布的一份报告详细讲解了<strong>浏览器</strong>基准测试与<strong>性能</strong>分析问题。其中，微软将IE8、Google Chrome 1.0、Mozilla Firefox 3.0.5分别载入全球二十五大网站的速度进行了对比，其中IE8加载速度有十二个领先，领先其他浏览器。</p><p align=\"center\"><img style=\"border-left-color: #000000; border-bottom-color: #000000; border-top-color: #000000; border-right-color: #000000\" alt=\"微软发布报告自夸IE8 全球网站网易加载最慢\" border=\"0\" src=\"http://tools.yesky.com/imagelist/2009/072/9m2otamzz1vi.jpg\" /></p><p>　　虽然IE8有进步，但是IE8 RC版本的亮相显然还是让大家有点失望。此前，微软发布了一个与IE 8浏览器不兼容的网站清单，不但多达2400家网站上榜，甚至微软自家官方网站也榜上有名。</p><p>　　有意思的是，这份表格里有六家中国网站，除了百度、搜搜两家搜索引擎之外，腾讯QQ、新浪、迅雷、网易的加载速度都相当慢，特别是网易，三大浏览器都需要15秒钟左右才能加载完毕。</p><p>　　据悉，IE 8尚处在RC阶段，但在最新泄露的Windows 7 builds 7048和7057版本中，IE 8版本号已经取消了&ldquo;RC 1&rdquo;字样，微软台湾分公司还宣布，繁体中文版IE 8将于本月20日(下周五)发布。</p>','1236917995','zh_CN','-1','-1','1','{member}{admin}{guest}','36','2','0','');
INSERT INTO ss_articles(`id`,`author`,`title`,`i_order`,`source`,`tags`,`intro`,`content`,`create_time`,`s_locale`,`pub_start_time`,`pub_end_time`,`published`,`for_roles`,`v_num`,`article_category_id`,`is_seo`,`description`) VALUES('53','admin','ARC’TERYX品牌于日前正式进驻兰州亚欧商厦','9','','ARC’TERYX品牌于日前正式进驻兰州亚欧商厦','ARC’TERYX品牌于日前正式进驻兰州亚欧商厦','<p>国际知名户外品牌ARC\'TERYX于2010年4月29日正式进入了兰州亚欧商厦。在该商场专柜中， 你不仅能亲身体验到ARC\'TERYX全系列产品所带来的在设计、面料、结构和色彩上的理念，而且还能享受轻松的购物环境。</p><p>　　从2009年开始,ARC\'TERYX不断进驻中国顶级商场,从长春专卖店,大连友谊商城,内蒙古维多利商厦,杭州大厦,杭州西湖银泰到现在的兰州亚欧商厦等；希望通过开设更加高端、专业的形象店，让更加广泛的消费群体能够全面领略ARC\'TERYX的高端科技和时尚设计。</p>','1276684958','zh_CN','-1','-1','1','{member}{admin}{guest}','2','8','0','');
INSERT INTO ss_articles(`id`,`author`,`title`,`i_order`,`source`,`tags`,`intro`,`content`,`create_time`,`s_locale`,`pub_start_time`,`pub_end_time`,`published`,`for_roles`,`v_num`,`article_category_id`,`is_seo`,`description`) VALUES('54','admin','研究显示：德国徒步市场规模接近37亿欧元','10','','研究显示：德国徒步市场规模接近37亿欧元','研究显示：德国徒步市场规模接近37亿欧元','<p>由德国徒步协会委托所做的一份研究显示，德国近4000万徒步爱好者每年的装备消费预计达37亿欧元。该研究结果基于7500份调查报告得出。</p><p>　　这份名为《徒步：一个光明未来的市场》的研究报告为当前德国徒步旅行市场状况提供了可靠的数据和事实，其中指出大约3980万德国人或者说56%受访者认为自己是&ldquo;活跃的徒步爱好者&rdquo;。</p><p>　　&ldquo;这意味着徒步是德国人当前最喜欢的户外运动形式，&rdquo;德国徒步协会主席Hans-Ulrich Rauchfuss博士说道。此外山地活动在德国也是很普及的一项户外活动，这可以从登山协会庞大的会员数目在可见一斑。</p><p>　　&ldquo;过去几十年，我们的会员人数一直保持稳步增长。2009年新增会员3.7万，增长率达4.57%，是我们有史以来增长最多的年份。&rdquo;德国登山协会新闻发言人Thomas Bucher表示。</p><p>　　虽然健行、徒步及登山活动之间一直没有清晰地界限，但非常明确的一点是&ldquo;户外活动已成为当今社会的主流。&rdquo;慕尼黑会展公司CEO Klaus Wellmann表示。</p><p>　　&ldquo;截至目前徒步爱好者一直都是Deuter的最大的目标客户群体。&rdquo;该品牌公司CEO Bernd Kullmann说道。</p><p>　　根据这份研究显示，徒步装备中最流行的是冲锋衣（92%），接下来依次是背包(80%)、徒步鞋(72%)、睡袋（62%）和徒步地图（58%）。不过无论徒步者购买何种产品，他们选择的关键标准都是质量和功能性。</p><p>　　该报告预计德国徒步爱好者每年在装备上花费人均达92欧元并因此推断出德国徒步市场规模大约达37亿欧元，但此数据不包括其他人群在户外装备上的花费。</p>','1276684985','zh_CN','-1','-1','1','{member}{admin}{guest}','1','8','0','');
INSERT INTO ss_articles(`id`,`author`,`title`,`i_order`,`source`,`tags`,`intro`,`content`,`create_time`,`s_locale`,`pub_start_time`,`pub_end_time`,`published`,`for_roles`,`v_num`,`article_category_id`,`is_seo`,`description`) VALUES('52','admin','CORA户外学校2010年5月24日将在北京白河召开','8','','CORA户外学校2010年5月24日将在北京白河召开','CORA户外学校2010年5月24日将在北京白河召开','<p><strong>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp; 只针对店员，看不见老板</strong></p><p><strong>　　只针对销售，看不见品牌</strong></p><p><strong>　　销售技巧，产品知识，装备使用，店面陈列，项目体验。</strong></p><p><strong>　　户外学校，中国户外店真正的店员培训课程。</strong></p><p>　　CORA 自2006年起已经成功举办了4届户外学校， 历年来CORA 户外学校一直秉承上述理念，让更多的一线人员参与到我们的活动中，在户外行业得到了一致的好评。</p><p>　　2010年户外学校将于24日-26日期间在北京白河举办，此次户外学校由CORA商会主办，北京安飞龙公司协办。活动内容涵盖了店面陈列技巧的现场展示，背包保养技巧及技术装备，器材使用介绍及登山着装等多项内容。着重对背包、面料，鞋、手表，服装，器材产品进行了透彻的讲解与分析。CORA将邀请多位专业的户外讲师现场精彩演绎。</p>','1276684932','zh_CN','-1','-1','1','{member}{admin}{guest}','3','8','0','');
INSERT INTO ss_articles(`id`,`author`,`title`,`i_order`,`source`,`tags`,`intro`,`content`,`create_time`,`s_locale`,`pub_start_time`,`pub_end_time`,`published`,`for_roles`,`v_num`,`article_category_id`,`is_seo`,`description`) VALUES('51','admin','万千品牌竞风流 2010年第26届体博会盛装开幕','7','','万千品牌竞风流 2010年第26届体博会盛装开幕','万千品牌竞风流 2010年第26届体博会盛装开幕','<p>由国家体育总局、中华全国体育总会、中国奥林匹克委员会、中国体育用品业联合会、中国体育科学学会主办，国家体育总局体育器材装备中心、华兴体育用品发展中心承办的2010（第26届）中国国际体育用品博览会，于2010年5月20日在北京新国际展览中心举行盛大开幕式，正式拉开了为期四天的第26届体博会的序幕。国家体育总局局长刘鹏、国家体育总局副局长杨树安，以及商务部、国家工商行政管理总局、国家知识产权局、国家质量监督检验检疫总局、国家标准化管理委员会、国家认证认可监督管理委员会等部委和相关机构领导出席了开幕仪式。出席开幕式的嘉宾还包括日本和韩国体育用品相关协会官员以及法国、波兰、阿联酋等国家驻华使馆的代表。开幕式由国家体育总局体育器材装备中心主任、中国体育用品业联合会副主席兼秘书长马继龙主持。</p><p align=\"center\">&nbsp;</p><p>　　<strong>品牌秀场&nbsp; 行业盛宴</strong></p><p>　　本届体博会启用了北京新国际展览中心全部8个展馆，展览总面积超过10万平方米，共分为运动服饰、户外运动、网羽运动、球类运动、健身运动器材、场馆设施以及运动自行车和轮滑七大展区，吸引了1000多家国内外企业参展。</p><p>　　体博会上，许多企业都把自己的最新产品拿到展台，观众既可以提前嗅到世界杯的气息，也可以感受羊城亚运会的氛围。</p><p>　　健身运动器材展区继续维持前几届展会的火爆情形，今年展览面积更是接近4万平米。英派斯、好家庭、澳瑞特、万年青、舒华等国内知名企业齐齐亮相，BH、乔山等海外和台湾地区的品牌也来同场竞技。其中，澳瑞特将在体博会上推出&ldquo;电动跑步机生理负荷测控系统&rdquo;，该系统实现了生理信息监测和运动健身的完美结合，开启了电动跑步机运动健身的全新模式，在产品的人性化方面取得了重大的突破；拥有百年历史的BH集团带来了以欧洲工业技术为支撑的新产品，并将联同BH Euro， BH NA， BH Asia共襄盛举。由南京万德游乐等十一家企业组成的室外健身器材技术联盟展区，展示了以太阳能技术为能源，以航空纳米材料、立体组</p><p>　　合式结构为新理念的健身产品，推动行业逐步实现节能减排，低碳环保的目标。</p><p>　　运动服饰展区内，国内品牌唱主角，安踏、361&deg;、回力等运动品牌高调亮相的同时，上海兴诺等运动服饰原材料商也拿出自己的高科技面料，向下游企业展示实力；值得期待的是，在温哥华冬奥会上为中国代表队取得优异成绩的冬奥明星将莅临体博会安踏展台。而其最具特色的展品当属&ldquo;彩绘战靴&rdquo;--这是安踏向申雪/赵宏博、庞清/佟健、张丹/张昊三对表现优异的双人滑选手赠送的纪念品，鼓励他们&ldquo;永不止步&rdquo;，继续挑战自我。阿迪达斯、乐途等国外品牌也在以各种方式争夺观众眼球。作为南非世界杯官方用球供应商，阿迪达斯将展出南非世界杯用球，让观众一饱眼福。</p><p>　　在最能体现环保、低碳等概念的场馆设施区，盟多、洁福、戴克斯等国际大牌引人瞩目。国内企业自然不会甘居人后，参与南非世界杯场馆建设的绿城人造草坪将与大家见面，在南非曼德拉广场所举办的世界足球节就使用了其绿园系列的四色人造草坪，这种草坪颜色深浅错落，单丝与曲草相互映衬，不仅形成良好的视觉效果，而且大大提高运动性能。</p><p>　　和场馆设施区一样，网羽区也云集了尤尼克斯、威尔逊等众多国际顶尖品牌，来自法国的著名网球品牌BABOLAT（百保力）将带来新产品Pure Drive GT，该系列的产品帮助中国女网取得了许多骄人的战绩。刚进入这个领域的李宁，携带最新研发的羽毛球系列产品亮相，而中国羽毛球男队刚刚在马来西亚横扫印尼队，蝉联汤姆斯杯，背后也有它们的功劳。</p><p>　　户外区内，日高、kingcamp、生活无限等品牌引人关注。一些中小品牌亦前景看好。另外，在户外科技体验区，将有10多家户外品牌商集中展示户外行业前端、新颖的科技产品。</p><p>　　球类区中，阿迪达斯携新开发的乒乓器材亮相让人颇为意外。传统的服装和足球制造商进军乒乓球器材制造领域，能否也能顺利挺进&ldquo;世界杯&rdquo;？</p><p>　　今年第一次亮相的运动自行车展区，也汇集了不少世界知名品牌。多数专业运动队的首选品牌，如LOOK、Carben等都将登陆体博会。</p><p>　　值得注意的是，一些体育公关公司、体育文化公司也登上了体博会的舞台。他们的出现不单给体博会增添了新看点，更透露着体博会未来的某种走势：打造中国体育产业展。</p><p>　　<strong>专业论坛 贴近行业</strong></p><p>　　体博会不单是产品展示的秀场，同时也是思想与观点碰撞的舞台，行业信息发布的平台。</p><p>　　展会期间，多场行业论坛活动，值得业界期待。</p><p>　　&ldquo;2010体育产业与体育用品业发展论坛&rdquo;，将于体博会开幕当天下午在新国展W-201会</p><p>　　议室举行。体育产业业内的官员、学者以及知名人士将就体育产业政策与发展趋势等主题展开研讨，也为中国体育用品营销与品牌发展出谋划策。</p><p>　　由中国体育用品业联合会和中国纺织品商业协会户外用品分会主办的&ldquo;2010中国户外产业论坛&rdquo;，旨在推动我国户外用品产业发展，促进户外用品市场繁荣，针对我国户外用品市场出现的问题进行经验总结、交流与探讨，搭建户外用品产业与其他成熟产业之间的桥梁。同时，&ldquo;2009年中国户外市场调研报告&rdquo;也将在论坛上首次发布。</p><p>　　与此同时，展会期间现场举办的&ldquo;健身商务交流大会&rdquo;、&ldquo;体育场馆建设与运营论坛&rdquo;、&ldquo;网络时代中国体育产业发展高峰论坛&rdquo;、&ldquo;2010年中国轮滑产业高峰论坛&rdquo;等活动，也将围绕各自领域进行学术探究和实践分析。</p><p align=\"center\">&nbsp;</p><p>　　<strong>现场活动 精彩纷呈</strong></p><p>　　丰富多彩的现场活动历来都吸引着到场观众的眼球。本届体博会上，更多蕴含体育用品文化、展示体育用品风采，集中表现体育用品魅力的现场活动，给体博会增添了诸多文化内涵。</p><p>　　&ldquo;无与伦比o2010中国国际体育珍藏品展示拍卖会&rdquo;即以此为诉求。活动主办方中国收藏家协会体育纪念品收藏委员会向各方搜集珍贵的体育藏品，在展会期间进行展示。同时主办方还将安排一场体育藏品拍卖会，以使这些珍贵的体育藏品能走进爱好者的日常生活。</p><p>　　颇受青少年喜爱的电子竞技运动，也被搬到了体博会的舞台。2010电子竞技国家集训队选拔赛中脱颖而出的选手，将有机会入选电子竞技国家集训队。各个玩家届时将各亮绝活，投入到这场没有硝烟的战场上。谁与争锋，拭目以待！</p><p>　　你方唱罢我登场。在羽毛球宝贝选拔和演示活动中，众多羽球佳丽登台献艺，柔美身段和妙曼舞姿，必将吸引无数眼球。而在国美锐动体育公园里，大家可以体验到模型飞机、攀岩、小型足球射门、模拟高尔夫球、街头投篮、桌上足球等多个流行运动项目。</p><p>　　此外，&ldquo;冰雪夏日体验&rdquo;、&ldquo;体育产业摄影展&rdquo;、&ldquo;首届北京市健身俱乐部十佳教练展示赛&rdquo;、&ldquo;国美锐动寻宝&rdquo;等活动，同样精彩。</p><p>　　<strong>引领行业趋势 助推产业发展</strong></p><p>　　从本届体博会现场看，无论是展商，还是观众和媒体，都在享受着体博会这场行业盛宴。体博会也正以自己的影响力和号召力，给中国体育用品业的发展历程打上时代的烙印。</p><p>　　自创建以来，体博会一直把&ldquo;引领行业发展，搭建交流平台&rdquo;，作为自己的使命和责任。特别是近年来，伴随着北京奥运会在我国举办，全球性经济危机爆发等和中国体育用品行业息息相关的重大事件，中国国际体育用品博览会组委会以更具前瞻性的眼光和思维，主动求变，力求将这个亚太地区乃至全球知名的体育用品博览会，打造成中国体育产业的风向标，给行业带来更多信心和机遇，引领行业朝着规模化、专业化、国际化的方向大步前进。</p><p>　　当前，宏观经济正朝着全面恢复的态势发展。我国体育用品行业正发生着深刻的变化，企业规模化效应进一步显现，行业整合的力度进一步加大。一些大的企业在逆市中上扬，同时我们还应该看到，和国民经济整体走势一样，体育用品行业的复苏也是一场拉锯战，春天的到来，仍需行业各方更加努力。</p><p>　　在这个大背景下，体博会无疑将承担着更大的行业责任。而引领行业发展的责任，正是体博会一直以来前行的动力。</p>','1276684895','zh_CN','-1','-1','1','{member}{admin}{guest}','1','8','0','');
INSERT INTO ss_articles(`id`,`author`,`title`,`i_order`,`source`,`tags`,`intro`,`content`,`create_time`,`s_locale`,`pub_start_time`,`pub_end_time`,`published`,`for_roles`,`v_num`,`article_category_id`,`is_seo`,`description`) VALUES('48','admin','国内顶级攀岩高手王清华日前签约KAILAS品牌','5','','国内顶级攀岩高手王清华日前签约KAILAS品牌','国内顶级攀岩高手王清华日前签约KAILAS品牌','<p>2010年6月，现任国家攀岩队员、国家级运动健将、国家级攀岩定线员、国家攀岩中级教练、国内顶级攀岩高手王清华与KAILAS（凯乐石）户外品牌签约，成为&ldquo;KAILAS攀登队&rdquo;的一员，携手推动中国攀登运动的发展，共同挑战新的难度，探索未知世界。</p><p align=\"center\">&nbsp;</p><p>　　王清华，1982年生人，1999年第一次接触攀岩运动，后在七大古都攀岩馆被王振华老师发现，再师从丁祥华、赵雷正式学习攀岩，如今成长为国内一流的攀岩选手。在十多年的攀岩竞技生涯中，他参加过许多国家、国际级的攀岩赛事，并取得不少优秀的成绩。在刚刚落幕的2010年全国第四届体育大会上更是取得了难度赛的第一。除了在竞技攀登上有着不错的战绩之外，王清华在自然岩壁攀登上也同样出色。曾先后完成了阳朔雷劈山难度14A的&ldquo;闪电&rdquo;线路，大榕树难度14A的&ldquo;难度表&rdquo;线路等。于2009年8月，王清华首攀了杭州可笑岩壁4年内无人完成的；难度13C、D的&ldquo;一千五百锤&rdquo;线路。2010年5月，首攀了北京白河Beginner峡谷的&ldquo;硬伤&rdquo;线路。</p><p align=\"center\">&nbsp;</p><p>　　KAILAS品牌致力于推动中国攀登运动的发展，相信人生就是一场探险，倡导国人探索未知世界。自2008年开始，KAILAS品牌已经陆续签约了国内一批在攀岩和登山领域内的顶级高手。KAILAS品牌一直以其高品质、先进、舒适、专业化的登山及户外装备，颇为户外运动爱好者青睐。希望通过携手优秀的攀岩、登山运动员，将&ldquo;挑战新的难度，探索未知世界&rdquo;的理念带给更多的热爱生活的人。</p>','1276684743','zh_CN','-1','-1','1','{member}{admin}{guest}','2','8','0','');
INSERT INTO ss_articles(`id`,`author`,`title`,`i_order`,`source`,`tags`,`intro`,`content`,`create_time`,`s_locale`,`pub_start_time`,`pub_end_time`,`published`,`for_roles`,`v_num`,`article_category_id`,`is_seo`,`description`) VALUES('49','admin','端午节进山游注意“八大纪律” 避免意外发生','6','','端午节进山游注意“八大纪律” 避免意外发生','端午节进山游注意“八大纪律” 避免意外发生','<p>在&ldquo;端午小长假&rdquo;来临之际，西安市户外运动协会提醒市民，外出户外运动旅游时做到&ldquo;八纪律&rdquo;，尤其要注意参加的户外俱乐部是否具有合法资质和是否使用了合法运营的车辆。</p><p>　　据西安市户外运动协会秘书长谢伟介绍，夏季是市民户外运动和旅游的高峰期，如遇意外，应及时向当地警方、医疗急救部门以及西安市户外救援队报告，并妥善收集、保管好相关证据（如出行合约、伤害状况照片等），以备调查确认事故原因，维护自身合法权益。</p><p>　　同时也特别提醒市民，户外运动时最好做到&ldquo;八纪律&rdquo;。</p><p>　　一是服从领队，严禁私自行动脱队，遇到危险须及时报警。二是严格执行&ldquo;撤退纪律&rdquo;。即未能在计划时间内达到预定目标，必须无条件、提前或及时原路返回或下撤。如果因客观原因无法返回或下撤，原地等待救援为第一选择。三是每人均严格执行&ldquo;物资备用原则&rdquo;，包含备用食物与水、备用衣物、备用药品与工具。四是坚决避免夜行军。五是俱乐部领队必须携带地图、指北针或GPS、对讲机、救生绳、开山刀、火具、必备药品等。六是坚决反对独自一人户外登山，应结伴出行或参加合法俱乐部组织的活动。七是不在山中采摘野果、野菜和蘑菇等食用，避免食物中毒。八是不在山中丢弃废弃物，攀折树木和花草，不干扰和破坏野生动物生活环境，做到环保出行。</p>','1276684773','zh_CN','-1','-1','1','{member}{admin}{guest}','2','8','0','');
INSERT INTO ss_articles(`id`,`author`,`title`,`i_order`,`source`,`tags`,`intro`,`content`,`create_time`,`s_locale`,`pub_start_time`,`pub_end_time`,`published`,`for_roles`,`v_num`,`article_category_id`,`is_seo`,`description`) VALUES('50','admin','第17届欧洲户外展7月中旬开幕 热点提前关注','4','','第17届欧洲户外展7月中旬开幕 热点提前关注','第17届欧洲户外展7月中旬开幕 热点提前关注','<p><strong>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp; 突破性</strong>：来自39个国家和地区的860家展商将携1000多个品牌参展<br />　　<strong>全球性</strong>：国际参展商比例接近80%<br />　　<strong>高端性</strong>：全球各达产业巨头将聚集菲德烈斯哈芬<br />　　<strong>颁奖礼</strong>：第五届户外产业大奖<br />　<strong>　学习交流</strong>：户外产业会议<br />　　<strong>主题</strong>：商业驱动力&ldquo;基本需求&rdquo;<br />　　<strong>活动</strong>：多种户外活动形式如走扁带、攀岩、攀塔和攀索道等<br />　　<strong>热点</strong>：跑道上的户外服装秀<br />　　<strong>竞技比赛</strong>：攀岩与越野跑<br />　　<strong>庆祝活动</strong>：新理念的户外晚会</p><p>　　德国时间2010年7月15日至18日期间，第17届欧洲户外展将在菲德烈斯哈芬市康士坦茨湖边再次举行-新的参展商数量记录，最优的展馆规划，广泛的户外会议活动将推动本次展会进入一个新的纪元，全球户外行业也将再次聚焦菲德烈斯哈芬。</p><p align=\"center\">&nbsp;</p><p>　　技术过载、城市化，希望回归最原始价值这一切意味着越来越多的人群渴望逃离城市，回归乡野，感受伟大的户外生活。而户外行业如何从这一趋势中获益？也许你会在全球最大的户外行业盛会--欧洲户外展中寻找到答案。本次展会上，来自全球39个国家的860家展商（数据截止5月底）将1000多个品牌的最新产品呈献给广大户外爱好者，为您勾画出户外产品的未来流行趋势。</p><p>　　&ldquo;2010欧洲户外展的国际性和参展商数都超过以往。户外产业的主流业务在美洲和亚洲愈发普及，那里的大量市场玩家也越来越关注这个展会，视它为他们的年度产业盛事。今年的欧洲户外展将一如既往聚焦新品。各公司将携1000个品牌的最新产品在公众面前亮相，其中大多数仅在这个展会上展出。&rdquo;欧洲户外产业协会主席David Udberg在展前准备会议上表示。本届展会除了更多的参展商外，更将有来自全球多个国家的900名记者来到菲德烈斯哈芬全方位报道此次展会，让更多人了解此次展会。</p><p>　　本届欧洲户外展的主题--商业驱动力的&ldquo;基本需求&rdquo;显示了户外产业如何才能更有效地从当前的户外繁荣中获益，并对各户外活动动因进行研讨。</p><p>&nbsp;&nbsp; 2009年的第16界欧洲户外展共有来自38个国家的810名展商参展，分布于12个展厅，面积达8.5万平方米,展商人数和展会面积都比上年都有增加（08年展商总数为787家，展会面积达7.5万平方米）,90个国家的19，300名贸易观众参观了展览.</p><p>　　创始于1994年的European OutDoor Trade Fair（欧洲户外用品展览会）每年都在德国举办，主要展品范围有运动服、露营/攀岩/登山装备、背包、睡袋、帐篷、布料、鞋子、水上运动的裝备以及配件等，是欧洲户外行业最高水平的专业用品展览会，也是全球最具影响力的顶级专业户外用品展览会之一。</p>','1276684813','zh_CN','-1','-1','1','{member}{admin}{guest}','2','8','0','');
INSERT INTO ss_articles(`id`,`author`,`title`,`i_order`,`source`,`tags`,`intro`,`content`,`create_time`,`s_locale`,`pub_start_time`,`pub_end_time`,`published`,`for_roles`,`v_num`,`article_category_id`,`is_seo`,`description`) VALUES('47','admin','玩皮划艇漂流落水 重庆小伙水陆并进狂追救人','3','','玩皮划艇漂流落水 重庆小伙水陆并进狂追救人','玩皮划艇漂流落水 重庆小伙水陆并进狂追救人','<p>&ldquo;水流太急了！幸亏河边喝茶的市民及时下水援救&hellip;&hellip;&rdquo;昨日下午5时许，站在波涛滚滚的河边，目击游客说。昨日下午3时许，郫县唐昌镇TC漂流生态旅游俱乐部一只皮划艇翻了，船上人员全部落水。事发后，目击群众纷纷伸出援手，将溺水者营救上岸。</p><p>　　<strong>400元玩漂流</strong></p><p>　　<strong>皮划艇翻了</strong></p><p>　　昨日下午5时许，记者在位于郫县唐昌镇的郫县第二人民医院找到其中9名落水者。据悉，共有11名落水者，包括3名水手，伤势较轻的两个漂流人员已出院。据落水者李女士讲，他们共计20余人结伴到唐昌游玩。说起当时落水情景，李女士仍心有余悸。昨天下午3时许，4个妈妈带上4名孩子，花400元去玩漂流。4个孩子中，最大的8岁多，最小的4岁多。水手给他们每个人套上救生衣就出发了。</p><p>　　皮划艇漂流了2公里左右，河水变得汹涌起来。李女士告诉记者，当时她向水手提出把船靠岸，但划皮划艇的大爷回答：&ldquo;我们长期在这里漂流，熟得很，绝对没有问题。&rdquo;</p><p>　　过了一会，皮划艇漂到一个地势较低的地方，落差足足有1米多。&ldquo;船腾空再落下时就翻了，所有人都摔进水里。&rdquo;落水后，虽然李女士并不会游泳，但她还是紧紧抓着4岁大的女儿，奋力把她往水面上托。&ldquo;救生衣让我勉强浮着，我和女儿都喝了不少水，想喊救命却叫不出来。&rdquo;</p><p>　　李女士不知道自己和女儿漂了多远，感觉快坚持不住时，一名小伙子游了过来，将母女俩拖到岸边。随后，母女俩被救护车送到医院。</p><p>　　<strong>一路狂奔</strong></p><p>　　<strong>重庆小伙救下母女俩</strong></p><p>　　翻船时，在漂流俱乐部玩耍的李文成正在跟同事聊天，他们是郫县名香居家具厂的职工。听到呼救声，他赶紧跑到河边，看到有几个人穿着救生衣在河水中挣扎。李文成二话不说就脱下衣服和长裤，跳到河里，紧接着又有两名男子跳下河救人。</p><p>　　很快，李文成游到一对母女身边。当时，年轻的妈妈死死地拉着孩子。李文成游过去后，将妇女拽住往岸边游。有几次快要靠拢了，又被冲开了。李文成喝了两口水，呛得快支撑不住了。所幸下游有个弯角，水流缓下来。岸上的人找来竹竿，将3人拉上岸。接着，其他两名同事也救起两名妇女。上岸后，同事们还驾车赶到下游，借用机动船搜寻溺水者。</p><p>　　与李文成一起下水救人的男子，其中一人叫姚亮，今年22岁，与父亲一起从重庆到成都来打工。救人后，他因呛水被送到医院治疗。姚亮说：&ldquo;我看到从上游漂下来几个人，虽然穿着救生衣，但明显已经没什么力气，其中还有抱着小孩的。&rdquo;看到有人跳下河救人，他也跟着跳了下去，朝抱着小孩的李女士游去。&ldquo;但是河水很深很急，我游了一截，发现追不上。就上岸，从陆地上追。&rdquo;姚亮一口气跑了几百米，冲到李女士前面跳下河，这才抓住李女士母女俩，把她们拉上岸。</p><p>　　11个落水者，有一个妇女不幸溺水身亡。4个小孩平安无恙，可谓是不幸中的万幸。</p><p>　　事故地点是柏条河上游距离唐昌镇北桥约1公里处。</p><p>　　昨天下午6时，郫县及唐昌镇相关人员介入调查此事。在病房，调查人员向出租皮划艇的老板询问事情发生经过，他也是三个水手之一。该男子说，他经营皮划艇漂流多年，他告诉记者：&ldquo;那个地方地势发生了改变。虽然我们之前晓得，但这几天一直下雨，河水上涨很厉害，就没注意。&rdquo;</p><p>　　事发后，漂流生态旅游俱乐部已暂停对外营业。</p>','1276684707','zh_CN','-1','-1','1','{member}{admin}{guest}','2','8','0','');
INSERT INTO ss_articles(`id`,`author`,`title`,`i_order`,`source`,`tags`,`intro`,`content`,`create_time`,`s_locale`,`pub_start_time`,`pub_end_time`,`published`,`for_roles`,`v_num`,`article_category_id`,`is_seo`,`description`) VALUES('45','admin','匈牙利寻亲队已扎营山腰 高海拔难退老人与狗','1','','匈牙利寻亲队已扎营山腰 高海拔难退老人与狗','匈牙利寻亲队已扎营山腰 高海拔难退老人与狗','<p>昨日上午，针对4名去年失踪的匈牙利登山队员的搜寻工作仍在进行中。连日的大雾和阴雨天气给搜寻工作带来巨大的困难，截至昨晚6时许，匈方8名搜寻队员虽经多次寻找，仍未在冰崩部位发现任何失踪者痕迹或遗物。由于不适应人中峰的高原气候，一名匈方老人和搜救犬FANTA暂时撤回了山脚下的大本营处。</p><p>　　清晨7时许，中方高山联络官、省登协登山运动家李宗利钻出设在河口的大本营帐篷，此时人中峰的蓝天上布满点点繁星。为了把握难得的上行搜寻时机。李宗利立即动身，向着山间前行。</p><p>　　穿过高原蕨类区和仍在落石的泥石流带后，中午12点，李宗利抵达了海拔3900米处，匈牙利搜寻队设置的前进营地（ABC）。前进营地位于冰川下方的一个较为平坦的泥石旁，这里只是人中峰冰川中心抵达的一处落石堆，仅是地势较为平坦。去年11月，本报记者曾在当地发现过4名失踪匈牙利队员曾用过的一个饮水袋和一些没有来得及清理的生活垃圾。</p><p>　　此时，不小的山间平地设置起了4顶高山帐篷。自从12日，8名匈方寻亲队员上山以后，就一直驻扎在此。</p><p>　　&ldquo;虽然我们进行过多次搜寻，但由于气候不好，还没有发现任何失踪者的痕迹。&rdquo;匈方领队、该国登山家Mecslaszlo和另外一名队员，在前几日的搜寻过程中，便已多次上行至海拔4700米的冰壁处进行搜寻，可截至昨日搜寻工作收效甚微。</p><p>　　此时的人中峰正值雨季，天气变化极快。下午3时许，山间又开始起雾并下起绵绵细雨。为了保持与外界的联系，李宗利开始按原路返回。此时山路上的碎石十分滑，李宗利多次险些摔倒。</p><p>　　而昨日，一名匈方老人和搜救犬FANTA也返回到海拔3200米的大本营，进行休整。李宗利告诉记者，由于海拔高，而且气候一直阴湿，搜救犬FANTA难以发挥水平，因此才被带了下来。</p><p>　　李宗利表示，目前的气候并不适宜搜寻工作，因而进展缓慢，后续的搜救工作可能还会持续一周的时间。</p>','1276684634','zh_CN','-1','-1','1','{member}{admin}{guest}','3','8','0','');
INSERT INTO ss_articles(`id`,`author`,`title`,`i_order`,`source`,`tags`,`intro`,`content`,`create_time`,`s_locale`,`pub_start_time`,`pub_end_time`,`published`,`for_roles`,`v_num`,`article_category_id`,`is_seo`,`description`) VALUES('46','admin','铁力市迎来今夏漂流开门红 首漂接待两千余人','2','','铁力市迎来今夏漂流开门红 首漂接待两千余人','铁力市迎来今夏漂流开门红 首漂接待两千余人','<p>&ldquo;这里的山山水水真是太美了，我都来过三次了，今年又跟朋友来这里参加首漂，感觉铁力旅游真是一年比一年好&rdquo;，在铁力市映山湖生态园景区，刚刚漂流上岸哈尔滨游客张毅，成为铁力市今夏漂流的第一批游客，他作为来过铁力漂流多次的游客，对铁力旅游的发展啧啧赞叹。</p><p>　　6月14日，铁力市正式启动今夏漂流旅游。铁力市针对今年气候特点，提早对市场进行促销开发，随着气温升高，在黑龙江省十大黄金漂流线路之首、国际自然水域漂流大赛举办地&mdash;&mdash;铁力依吉密河，及时启动今夏漂流旅游，由于准备充分，市场开发到位，在首漂当天，就迎来哈尔滨、长春、大庆、绥化等地游客2200余人，依吉密河，这条小兴安岭脚下的黄金水道再次沸腾，实现了首漂开门红。</p><p>　　经过几年的开发建设，铁力市漂流已经成为省内外闻名的旅游品牌，&ldquo;到铁力漂流，向快乐出发&rdquo;已经在全国旅游业界叫响，&ldquo;龙江第一漂&rdquo;的美誉不自觉地在广大游客中口耳相传。今年铁力市又加大旅游基础设施建设投入，推进铁力旅游提档升级，让游人常来常新，实现&ldquo;一年一个样，三年大变样&rdquo;。在铁力市委市政府的引导下，各景区景点也加大投入力度，按照铁力市旅游发展整体规划，高标准、高质量、高品位地对景区景点进行深度开发。&ldquo;我们不能让游客来了就是漂流后吃点喝点就拉倒，不能玩个一天两天就没什么玩的了，要深度开发，要一天有一天的乐趣，两天有两天的项目，三天有三天的内容，四天有四天的体验，五天有五天的感叹，真正使游客达到流连忘返，今年我们铁力的映山湖生态园投入300余万元整体扩建、透龙山庄投入20余万元新建的100亩的小兴安岭百花园(全部为自然生长野花)，还有卧龙山庄、日月峡滑雪场等景区景点都给人以耳目一新的感觉，也实现了我们铁力旅游的整体提档升级，还有映山湖生态园刚开始建设的四星级旅游接待中心和即将完工投入使用的高档度假别墅，建成后可以接待500人的大型会议，再加上桃山、朗乡等其他景区的新建项目，明年我们铁力旅游一定又上一个大台阶&rdquo;，铁力市旅游局长祖立柱，对铁力市旅游建设如数家珍。</p><p>　　日益完善旅游产品使铁力旅游在省内外的竞争力不断提升，继铁力市获得中国优秀旅游城市、中国特色魅力城市、中国县级城市旅游竞争力20强、中国县域旅游品牌百强县之后，2009年铁力又荣获&ldquo;中国最佳生态旅游目的地&rdquo;，2010年4月被国际旅游营销协会评为&ldquo;最值得向世界推荐的旅游城市&rdquo;等荣誉称号。</p>','1276684682','zh_CN','-1','-1','1','{member}{admin}{guest}','1','8','0','');
INSERT INTO ss_articles(`id`,`author`,`title`,`i_order`,`source`,`tags`,`intro`,`content`,`create_time`,`s_locale`,`pub_start_time`,`pub_end_time`,`published`,`for_roles`,`v_num`,`article_category_id`,`is_seo`,`description`) VALUES('56','admin','奥索卡获2010十大体育用品经销商零售管理奖','12','','奥索卡获2010十大体育用品经销商零售管理奖','奥索卡获2010十大体育用品经销商零售管理奖','<p>近日，中国体育用品经销商大会暨2010年度十大体育用品最具创新产品发布仪式在北京电视台演播大厅隆重举行，中国奥委会副主席屠铭德先生、鹏润投资董事长兼总裁、国美锐动董事长黄秀虹女士等领导出席了活动盛典活动，来自全国各地的几十家企业代表及200多位经销商参加了本次大会。</p><p align=\"center\"><strong><br />OZARK GEAR（奥索卡）品牌总经理刘平格女士</strong></p><p>　　OZARK GERA（奥索卡）品牌总经理刘平格女士应邀参与了此次盛会，并荣获&ldquo;2010年度十大体育用品经销商零售管理奖&rdquo;，同时OZARK GERA（奥索卡）&ldquo;超轻夹克&rdquo; 也荣获 &ldquo;2010年度中国体育用品十大最具创新产品&rdquo;殊荣。</p>','1276685053','zh_CN','-1','-1','1','{member}{admin}{guest}','1','8','0','');
INSERT INTO ss_articles(`id`,`author`,`title`,`i_order`,`source`,`tags`,`intro`,`content`,`create_time`,`s_locale`,`pub_start_time`,`pub_end_time`,`published`,`for_roles`,`v_num`,`article_category_id`,`is_seo`,`description`) VALUES('57','admin','早一日明确战略定位 就能早一日确立竞争先手','13','','早一日明确战略定位 就能早一日确立竞争先手','早一日明确战略定位 就能早一日确立竞争先手','<p>定位因竞争而生。没有竞争就无需战略定价，无需业务聚集，无需资源配称。有竞争才需定位，才有竞争的胜出。户外用品市场是一个初为启动的市场。从品牌数量到竞争程度，到市场规模和消费者认识以及需求都是较有草根般味道，企业能自觉进行战略定位的简直是凤毛麟角。企业大多是随大流，大品牌怎么做或外国品牌怎么做就怎么做。缺乏独立思考和个性。产品众人一面，品牌缺乏个性，销售方式唯一不同仅是价格上略有不同。</p><p>　　在产品时代，在竞争蒙昧未开时，所有品类形态与初始的户外大致是一样的。然而随着消费者认识和需求的升温，大量流动和产业资本涌入户外，原有平静逐步被竞争所取代，产业升级，营销升级，激烈竞争逐步拉开了序幕。接踵而来是弱者被淘汰，快鱼食慢鱼，在这场残酷血醒到来之时，谁及早先行战略定位，及早进入竞争角色，谁就会在这场血醒里首先变成了游得最快的鱼。</p><p>　　企业定位、品牌写作虽不能确保你一定可以成功。成功与否，还取决战略定位选择正确与否，执行力实施的成效如何。战略定位与否的差别在于：有定位战略的企业有成功的机会，没有定位的企业连成功的可能性都没有。当环境不发生重大变化时，有定位者会战胜&ldquo;没有定位者&rdquo;；当环境发生重大变化时，有定位更具抗击变化的能力。</p><p>　　定位的作用在于在竞争局势之下，集中资源牢牢占据决定整体胜负的关键位置，取得竞争领先。在竞争充分的市场，这个位置就是消费者的头脑。在消费者头脑中占领位置，形成购买联想制阀，获得销售和溢价优势价值点。定位的过程是一个资源组织和业务配称的组织过程，与拍脑门、找点子有着云泥之别高低之别。有清晰化的定位，才形成营销资源有力聚集，才有资源产出优化，才拥有更大市场份额和更高利润。</p><p>　　成功的战略定位可以让企业在行业内取得一部分优势，即使是次之亦能独占一隅。那些有明确定位的企业往往能够让消费者选择时成为首选，而没有明确定位的，只能是跟随着领先企业去模仿，让领先更加领先，优势更具。</p><p>　　定位战略最核心是&ldquo;集中&rdquo;和&ldquo;专业&rdquo;原则。集中到你可以成为第一的焦点上，形成与其它企业区隔，让消费者第一时间联想到你，选择你。万科是经过抛弃同样有利润的电子贸易、音像出版、零售超市，集中在房地产、住宅，才有全国房地产的领导者地位。懂得集中，就首先懂得战略性的放弃。有放弃才能集中，才有成功的可能。</p><p>　　对于户外行业很多企业总是认为：抓住大品类，才有大市场，才有大销售。于是服装、鞋品、装备只要户外范畴有的总恨不得都造成完备的。全品类多品种，往往让让消费者心智模糊，难以记忆，于是亦无法顺档购买，逐步形成多而不精，大而不强的监介。从消费者心智空间出发，愈为清晰、特点鲜明的专业品牌，消费者就愈为会在购买时成为首先联想、记忆的对象。这就是定位之功。当有产生购买登山野营炊具时总会第一顺当想到火枫；当自驾出游要购买装备时首先是想到KingCamp；如果是要到野外野餐时想到的是悠度。这就是专业聚集的回报。</p><p>　　放弃那些与你聚焦在市场空间、发展空间有所冲突，有所相违的业务，令焦点更集中，成为比别人更优秀，你才能与别人竞争中脱颖而出。早一天制定，早一天实行，你就会早一天脱颖而出！</p>','1276685076','zh_CN','-1','-1','1','{member}{admin}{guest}','1','8','0','');
INSERT INTO ss_articles(`id`,`author`,`title`,`i_order`,`source`,`tags`,`intro`,`content`,`create_time`,`s_locale`,`pub_start_time`,`pub_end_time`,`published`,`for_roles`,`v_num`,`article_category_id`,`is_seo`,`description`) VALUES('58','admin','KROCEUS入选2010年纺织服装行业十大新锐品牌','14','','KROCEUS入选2010年纺织服装行业十大新锐品牌','KROCEUS入选2010年纺织服装行业十大新锐品牌','<p>中国新势力-2010年度中国纺织服装行业十大评选&rdquo;拉开大幕，此次&ldquo;十大评选&rdquo;将选出十大风云人物、十大新锐品牌、十大卓越网商，最终获奖者将参加钓鱼台国宾馆的现场颁奖典礼，此次入选&ldquo;十大新锐品牌&rdquo;的是：上海嘉麟杰运动用品有限公司。</p><p>　　<strong>入选理由：</strong></p><p>　　上海嘉麟杰运动用品有限公司近年来一直致力于品牌活动的推广， 公司于2009年在国际针织博览会上将其酝酿多久的KROCEUS品牌在针织展上亮相。让品牌在行业内专家面前接受初步检验，在展会期间，KROCEUS进行了主题为&ldquo;KROCEUS，多彩户外，精彩生活&rdquo;动态秀，通过挑战世界、品味自由、释放心灵三个板块对KROCEUS品牌进行全方位的诠释。</p><p>　　2009年8月Kroceus与世界顶级功能面料生产商Polartec达成战略合作协议。Kroceus将陆续推出系列Polartec面料服饰，成为国内市场上唯一全线覆盖Polartec底层、中层、外层的品牌商。Polartec是世界上最大的能提供底层、中层、外层全系列户外功能面料的公司。它的产品覆盖民用、工业用、军用等各个领域。其中Polartec的抓绒面料是同等克重下最保暖的抓绒产品，也是深受世界各户外品牌和户外玩家欢迎的抓绒面料。近年来Polartec还推出了Highloft（Thermal Pro系列），软壳（Windbloc，Powershell系列），防火面料（FR系列）等领先科技的功能面料。</p><p>　　除了在中国市场推出使用Polartec面料的全系列户外服装外，Kroceus还将与Polartec一起加大中国的市场推广力度，扩大影响力，为中国的户外爱好者和消费者提供高品质的顶级户外装备。上海嘉麟杰运动用品有限公司还荣获2008-2009年度中国针织行业竞争力10强企业。</p><p>　　<strong>公司简介：</strong></p><p>　　上海嘉麟杰运动用品有限公司系上海嘉麟杰纺织品股份有限公司全资子公司。依托母公司在羊毛、涤纶、尼龙等功能性面料的研发、设计、生产方面的竞争优势，同时聘请专业的海外设计团队，公司创立KROCEUS自由品牌，其核心价值：设计、科技和责任、2008年公司成功支持&ldquo;可可西里科考活动&rdquo;；在北京时尚文化阵地798D-PARK为中国国际时装周奉献一场简约时尚、富于变化、勇于创新的美丽诺羊毛服装视觉盛宴。公司的经营宗旨：为消费者提供质优、高性价比的商品和专业服务，引导消费者时尚的生活方式，让人们走出去，放松一下心情，力争在五年内实现&ldquo;成为中国比较受欢迎的户外运动品牌&rdquo;的目标。</p>','1276685097','zh_CN','-1','-1','1','{member}{admin}{guest}','2','8','0','');
INSERT INTO ss_articles(`id`,`author`,`title`,`i_order`,`source`,`tags`,`intro`,`content`,`create_time`,`s_locale`,`pub_start_time`,`pub_end_time`,`published`,`for_roles`,`v_num`,`article_category_id`,`is_seo`,`description`) VALUES('59','admin','展示Patagonia新品 CORA订货会即将在京开幕','1','','展示Patagonia新品 CORA订货会即将在京开幕','展示Patagonia新品 CORA订货会即将在京开幕','<p>2010年6月21日-6月22日，CORA订货会将在北京奥莱攀岩馆举办Patagonia2011年春夏新品订货会。此次订货会将邀请30多家经销商亲临现场。</p><p>　　美国环保产品、世界户外服装领军品牌Patagonia，是全球功能与生活方式服饰设计及营销的全球领导者。30多年来，Patagonia公司一直致力于生产和开发环境意识型和创新式户外功能型产品。</p><p>　　此次订货会将会将会有包括冲锋衣等技术外套，休闲服等生活系列，防晒系列，背包附配件等多个系列现场展示，简洁大方的又兼具强大功能的服装设计将会让你耳目一新，同时配有现场模特的精彩表演将会把整个订货会推向顶峰。</p><p>　　Patagonia户外鞋将首次亮相于CORA 订货会，四大系列鞋将会现场展示，这是CORA 商会首次引进Patagonia户外鞋系列。功能，经典是此次订货会的又一大主题。整个订货会将会不断呈现出精彩纷呈的产品类型及节目。</p>','1276685120','zh_CN','-1','-1','1','{member}{admin}{guest}','0','2','0','');
INSERT INTO ss_articles(`id`,`author`,`title`,`i_order`,`source`,`tags`,`intro`,`content`,`create_time`,`s_locale`,`pub_start_time`,`pub_end_time`,`published`,`for_roles`,`v_num`,`article_category_id`,`is_seo`,`description`) VALUES('60','admin','服装网购品牌凡客诚品宣布进军运动服装市场','2','','服装网购品牌凡客诚品宣布进军运动服装市场','服装网购品牌凡客诚品宣布进军运动服装市场','<p>服装网购品牌凡客诚品（VANCL）10日对外宣布，将正式进军运动服装市场，首次发布的运动产品主要涵盖世界杯主题T恤、网球裙、短裤等服饰，预计大规模户外运动产品将会在今年九月份大批量入市。</p><p>　　近年来，随着野营、钓鱼、登山等户外运动的兴起，与之相关的服饰装备等用品也逐渐成为商家掘金的新焦点。业内人士预测，中国的&ldquo;大户外&rdquo;市场正呈直线上升趋势，&ldquo;大户外&rdquo;概念在中国所蕴藏的市场将会超过100亿元。</p><p>　　据正望咨询的调研数据，服装是网购市场中占比最高的种类。同时，户外运动市场在服装服饰网购中占比超过三成。此番凡客诚品借世界杯之际悄然切入户外运动市场，被视为一次重大的产品种类布局，将对Columbia等洋品牌带来巨大冲击。</p><p>　　据介绍，中国是世界最大的户外运动用品生产中心，世界上百分之六十的背包、鞋、户外服装和配件都来自中国。但大部分国内企业仍面临面料研发水平低，款式设计师短缺等困境，只能做贴牌生产赚取廉价的劳动收益。</p>','1276685159','zh_CN','-1','-1','1','{member}{admin}{guest}','0','2','0','');
INSERT INTO ss_articles(`id`,`author`,`title`,`i_order`,`source`,`tags`,`intro`,`content`,`create_time`,`s_locale`,`pub_start_time`,`pub_end_time`,`published`,`for_roles`,`v_num`,`article_category_id`,`is_seo`,`description`) VALUES('61','admin','服装网购品牌凡客诚品宣布进军运动服装市场','3','','服装网购品牌凡客诚品宣布进军运动服装市场','服装网购品牌凡客诚品宣布进军运动服装市场','<p>服装网购品牌凡客诚品（VANCL）10日对外宣布，将正式进军运动服装市场，首次发布的运动产品主要涵盖世界杯主题T恤、网球裙、短裤等服饰，预计大规模户外运动产品将会在今年九月份大批量入市。</p><p>　　近年来，随着野营、钓鱼、登山等户外运动的兴起，与之相关的服饰装备等用品也逐渐成为商家掘金的新焦点。业内人士预测，中国的&ldquo;大户外&rdquo;市场正呈直线上升趋势，&ldquo;大户外&rdquo;概念在中国所蕴藏的市场将会超过100亿元。</p><p>　　据正望咨询的调研数据，服装是网购市场中占比最高的种类。同时，户外运动市场在服装服饰网购中占比超过三成。此番凡客诚品借世界杯之际悄然切入户外运动市场，被视为一次重大的产品种类布局，将对Columbia等洋品牌带来巨大冲击。</p><p>　　据介绍，中国是世界最大的户外运动用品生产中心，世界上百分之六十的背包、鞋、户外服装和配件都来自中国。但大部分国内企业仍面临面料研发水平低，款式设计师短缺等困境，只能做贴牌生产赚取廉价的劳动收益。</p>','1276685218','zh_CN','-1','-1','1','{member}{admin}{guest}','0','2','0','');
INSERT INTO ss_articles(`id`,`author`,`title`,`i_order`,`source`,`tags`,`intro`,`content`,`create_time`,`s_locale`,`pub_start_time`,`pub_end_time`,`published`,`for_roles`,`v_num`,`article_category_id`,`is_seo`,`description`) VALUES('62','admin','探路者新总部探营续：品牌样板店和研发中心','4','','探路者新总部探营续：品牌样板店和研发中心','探路者新总部探营续：品牌样板店和研发中心','<p>近日，户外资料网小编受邀走访了位于北京市海淀区知春路6号锦秋国际大厦的探路者公司的新总部，之前大家已经浏览了户外行业首家上市公司总部的风采，现在再让我们走进探路者品牌的样板店和研发中心去看一看。</p><p>　　首先我们来到探路者的样板店中，这是探路者于2009年伴随新品牌识别VI系统推出的第五代店面，产品陈列布局与品牌形象展示都有很大提升。</p>','1276685741','zh_CN','-1','-1','1','{member}{admin}{guest}','0','2','0','');
INSERT INTO ss_articles(`id`,`author`,`title`,`i_order`,`source`,`tags`,`intro`,`content`,`create_time`,`s_locale`,`pub_start_time`,`pub_end_time`,`published`,`for_roles`,`v_num`,`article_category_id`,`is_seo`,`description`) VALUES('63','admin','探路者新总部探营续：品牌样板店和研发中心','1','','探路者新总部探营续：品牌样板店和研发中心','探路者新总部探营续：品牌样板店和研发中心','<p><font size=\"4\">&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp; 近日，户外资料网小编受邀走访了位于北京市海淀区知春路6号锦秋国际大厦的探路者公司的新总部，之前大家已经浏览了户外行业首家上市公司总部的风采，现在再让我们走进探路者品牌的样板店和研发中心去看一看。</font></p><p><font size=\"4\">　　首先我们来到探路者的样板店中，这是探路者于2009年伴随新品牌识别VI系统推出的第五代店面，产品陈列布局与品牌形象展示都有很大提升。</font></p>','1276685779','zh_CN','-1','-1','1','{member}{admin}{guest}','1','9','0','');
INSERT INTO ss_articles(`id`,`author`,`title`,`i_order`,`source`,`tags`,`intro`,`content`,`create_time`,`s_locale`,`pub_start_time`,`pub_end_time`,`published`,`for_roles`,`v_num`,`article_category_id`,`is_seo`,`description`) VALUES('64','admin','行程2010公里 20个人要将骑行进行到底','2','','行程2010公里 20个人要将骑行进行到底','行程2010公里 20个人要将骑行进行到底','<p>20天的时间可以干什么？2010公里又有多远？有这样一群人给你一个特别的答案。</p><p>　　遥远的南半球，世界杯正在如火如荼地进行，但这个夏天，不是所有的人都围绕着足球转。昨日，商丘至周口的一条国道上，一支身穿黄色衣服骑行的队伍格外引人注目。他们正是参加环河南单车骑行活动的车友们。这已经是他们骑行的第二天了，不过这才是&ldquo;万里长征第一步&rdquo;，因为他们要在20天的时间内骑行2010公里，完成环行河南的壮举。据悉，这次活动是由广大车友发起，他们旨在通过这次骑行，号召大家低碳出行。</p><p>　　历时20天、行程2010公里这20个人要将骑行进行到底</p><p>　　在10日的发车仪式上，河南省体育局局长韩时英亲临郑州黄河路捷安特生活馆，为活动揭幕。</p><p>　　比起真正骑行的队伍，送行的队伍可谓浩浩荡荡。他们主要分为两部分：专业队和业余队。专业队是由河南省专业车手组成的15人队伍，由全国自行车冠军领衔；业余队自然由自行车爱好者组成。他们都是来为20位勇士壮行的。这20个人要在20天的时间内完成绕河南一圈的壮举，骑行距离为2010公里。</p><p>　　活动举行的时候，吸引了不少群众前来观看。在车手做骑行前的热身体操时，群众跃跃欲试，也跟着车手们扭腰动胯。中国是自行车大国，但自行车运动却是冷门项目。不过那天的活动，丝毫体会不到冷门运动的尴尬。活动热热闹闹，与广大群众形成了很好的互动。</p><p>　　53岁的老林要骑完全程有人说他像环法冠军康塔多</p><p>　　在送行的队伍中，有两位老人格外显眼。一位是72岁的韩老先生，一位是63岁的郭老先生。也许是经常运动的缘故，这两位老人显得倍儿精神，看上去顶多50岁。韩老先生介绍，在老年骑协里，韩老先生绝不属于高龄的，他们当中最年长的已经80多岁了。</p><p>　　河南捷安特有限公司老总林建明，是这次要完成20天骑行的车手之一，也是队伍的主心骨。他今年53岁，人精瘦精瘦的。一位来参加活动的专业车手评判说，他的线条绝对是擅长爬坡的&ldquo;山地型&rdquo;，和两届环法冠军康塔多很像。老林参加过多次长途的骑行活动，祖国大江南北都留下了他的车印。这次在河南的骑行，却是他人生第一次。谈起这次骑行，老林略显紧张地表示：&ldquo;十分兴奋和期待。&rdquo;</p><p>　　看了上述3位的经历，不要以为骑车是老年人的运动，队伍的主力还是青壮年。在完成20天骑行的队伍中，最小的骑车手赵松林只有19岁，但已有两年骑龄了。对骑行的痴迷，占据了他大部分业余时间。</p>','1276685876','zh_CN','-1','-1','1','{member}{admin}{guest}','2','9','0','');
INSERT INTO ss_articles(`id`,`author`,`title`,`i_order`,`source`,`tags`,`intro`,`content`,`create_time`,`s_locale`,`pub_start_time`,`pub_end_time`,`published`,`for_roles`,`v_num`,`article_category_id`,`is_seo`,`description`) VALUES('65','admin','小伙与队友不辞辛劳骑车周游列国宣传亚运会','3','','小伙与队友不辞辛劳骑车周游列国宣传亚运会','小伙与队友不辞辛劳骑车周游列国宣传亚运会','<p>晌午，地处热带的马来西亚，柏油路面热得可以轻易烤熟一块面包。</p><p>　　23岁的广东潮汕小伙子王卫，正带领着7位队友，骑着自行车，从巴株巴辖前往马六甲。马六甲这个小城，正是郑和7次下西洋5次到访的地方。</p><p>　　王卫此行肩负着一个任务&mdash;&mdash;&mdash;骑自行车穿越东南亚6国宣传亚运。这是一次民间自发活动，经费自筹。</p><p>　　骑着骑着，领队王卫发现走错了路。本来是要走国道的，沿路有商铺饭馆供歇息。而此时的快速路上，只有望不到头的丛林。正午的太阳炙热，队员们已经连续骑行7个小时，体能消耗严重，携带的水和食物都吃光了。</p><p>　　远处的路旁有一个村庄，抱着希望，他们进了村。村里很多人被这群不速之客吸引，纷纷围了上来，七嘴八舌地说着马来语。这时，人群中走出一位美丽的女孩，这里只有她懂英文，终于能够交流了。</p><p>　　女孩热情地把8个陌生的中国客人请到家里。在有伊斯兰独特建筑风格的房子里，队员们和女孩的父母弟妹一起席地而坐，彼此以各种肢体语言沟通。女孩的妈妈端来了鲜榨芒果汁，加冰的，还有一大盘面粉做的甜点，招待客人。</p><p>　　王卫将芒果汁一饮而尽，痛快！他拿出了由时任广州市长张广宁亲笔签名的邀请信，男主人愉快地用马来语写下了对广州亚运的祝福。</p><p>　　两个小时的欢乐时光过去了，与好客的马来人家道别后，王卫又带领着队员出发&hellip;&hellip;历时83天，他们在去年底完成了东南亚6国的骑行之旅。</p><p>　　王卫的骑行之梦始于高中时代。他的家在潮汕农村，年少的他渴望到外面的世界去。让儿子搭飞机、坐火车外出旅游，父母无法承担，王卫就萌发了骑自行车游遍天下的念头。</p><p>　　大学期间，王卫周一到周五学习，周六日做兼职攒钱，寒暑假骑车出游。2006年暑假，王卫第一次出省游，孤身从广州出发，一路北上，经过长沙、武汉、石家庄，到达北京，再沿着海岸线，南下回到家乡，整整骑了一个月。5年里，王卫骑行了5万公里，获得了&ldquo;中国首位环国骑行大学生&rdquo;的吉尼斯纪录。</p><p>　　现在，王卫和队员正身在湖南，进行亚运志愿信使&ldquo;骑行中国&rdquo;之旅。他们计划到达北端的黑龙江漠河镇、西面的珠峰大本营等地，继续沿途宣传亚运。</p><p>　　对未来的骑行之路，王卫有一个宏大的计划：以10年时间骑遍全世界！</p>','1276685907','zh_CN','-1','-1','1','{member}{admin}{guest}','1','9','0','');
INSERT INTO ss_articles(`id`,`author`,`title`,`i_order`,`source`,`tags`,`intro`,`content`,`create_time`,`s_locale`,`pub_start_time`,`pub_end_time`,`published`,`for_roles`,`v_num`,`article_category_id`,`is_seo`,`description`) VALUES('66','admin','要去九华山旅游 智障女上了火车 乘警帮寻找','4','','要去九华山旅游 智障女上了火车 乘警帮寻找','要去九华山旅游 智障女上了火车 乘警帮寻找','<p>6月13日凌晨，在汉口开往泰州的K382次旅客列车上，乘警突然接到武汉公安局打来的电话，说该市一名二十出头的智障少女可能在列车上，欲去九华山旅游，因其患有智障，请求乘警进行查找并妥善照料。</p><p>　　钱警长迅速与列车长高建华带人分头查找，当日正值端午小长假前夕，列车超员严重，两人一节车厢一节车厢地仔细查找，见到年龄相仿的女乘客就上前询问，经过近一个多小时、数百次询问，终在2号车厢找到这个女孩。原来，女孩患有智障，日前在家中电视上看到风景秀美的九华山即嚷着要其家人带她前去游玩。家人无暇带她出来游玩，她就一个人乘车出来了。当日上午女孩的家人从武汉赶到南京接回了女孩。</p>','1276685932','zh_CN','-1','-1','1','{member}{admin}{guest}','1','9','0','');
INSERT INTO ss_articles(`id`,`author`,`title`,`i_order`,`source`,`tags`,`intro`,`content`,`create_time`,`s_locale`,`pub_start_time`,`pub_end_time`,`published`,`for_roles`,`v_num`,`article_category_id`,`is_seo`,`description`) VALUES('67','admin','首届大学生黄河源徒步挑战赛将在青海拉开序幕','5','','首届大学生黄河源徒步挑战赛将在青海拉开序幕','首届大学生黄河源徒步挑战赛将在青海拉开序幕','<p>近日，由青海省体育局、国际市民体育联盟中国总部主办的首届大学生黄河源徒步挑战赛暨&ldquo;情系玉树，再探中华母亲河源头&rdquo;大会近日在京召开新闻发布会。据悉，大会组委会拟组织30余名大学生参与本次徒步活动。</p><p>　　很久以来，当代大学生被冠以&ldquo;垮掉的一代&rdquo;称谓，批评大学生意志力薄弱、缺乏进取心、拜金、缺乏责任感等等等等的报道随处可见。这就是真实的大学生，还是我们的报道以偏概全。</p><p>　　本次活动的秘书长、北京每日徒步运动中心金主任接受采访时表示，他并不认可之前媒体对于大学生的众多批评。金主任表示，大学是我们心灵的一片净土，大学生是公益事业的热心人和积极参与者，更是未来社会的中流砥柱；我们的大学生也是蓬勃的一代，充满朝气的一代，本次&ldquo;情系玉树，再探黄河源&rdquo;活动增加&ldquo;首届大学生黄河源徒步挑战赛&rdquo;就是要把我们大学生积极向上、勇于挑战自我、热衷公益事业并以此为己任的一面展现给大家。</p><p>　　本次活动的主要目的地黄河源位于青海省玛多县境内，平均海拔4200米，属高寒草原气候，因而本次活动也具备一定的挑战性。据悉，本次活动承办者之一北京每日徒步运动中心在组织高原徒步方面具有丰富的经验，是我国最早从事徒步事业的单位，在行业内部享有良好的声誉。同时参与此项活动的还有青海省登山协会、北京奥索卡体育用品有限公司、戈尔工业品贸易（上海）有限公司。</p><p>　　笔者在发布会现场还了解到，本次活动由《中国青年报》、北京高校联盟等单位支持，目前仍在火热报名中，活动时间为7月25日至8月1日，具体行程为：西宁--海南州--玉树--玛多县--鄂陵湖渔场--措日尕则寺--牛头碑--共和--西宁，沿途还将探访唐蕃古道、观看民俗表演、参加黄河源藏汉联谊会等。</p>','1276685953','zh_CN','-1','-1','1','{member}{admin}{guest}','2','9','0','');
INSERT INTO ss_articles(`id`,`author`,`title`,`i_order`,`source`,`tags`,`intro`,`content`,`create_time`,`s_locale`,`pub_start_time`,`pub_end_time`,`published`,`for_roles`,`v_num`,`article_category_id`,`is_seo`,`description`) VALUES('68','admin','珠峰大本营设6个垃圾收集池 定期清运旅游垃圾','6','','珠峰大本营设6个垃圾收集池 定期清运旅游垃圾','珠峰大本营设6个垃圾收集池 定期清运旅游垃圾','<p>据《2009年西藏自治区环境状况公报》显示，西藏全区工业固体废物主要为采矿弃碴，生活垃圾和建筑垃圾是主要的城市垃圾。针对珠穆朗玛峰地区产生的垃圾，珠峰登山大本营设置了6个垃圾收集池，收集登山者和旅游人员产生的垃圾，并定期清运。</p>','1276685977','zh_CN','-1','-1','1','{member}{admin}{guest}','1','9','0','');
INSERT INTO ss_articles(`id`,`author`,`title`,`i_order`,`source`,`tags`,`intro`,`content`,`create_time`,`s_locale`,`pub_start_time`,`pub_end_time`,`published`,`for_roles`,`v_num`,`article_category_id`,`is_seo`,`description`) VALUES('69','admin','蓬溪老年骑游队3年已骑游四川省内近10个市州','7','','蓬溪老年骑游队3年已骑游四川省内近10个市州','蓬溪老年骑游队3年已骑游四川省内近10个市州','<p><strong>3年骑游省内近10个市州</strong></p><p>　　在蓬溪县内聚集着一群喜爱自行车骑游运动的老年人，他们踏着自行车游遍了省内多个市县的山山水水。这支成立已3年的老年自行车骑游队，目前共有成员10余人，年龄最大的有72岁，最小的也是年过半百。3年来，蓬溪老年骑游队成员们骑行了省内的近10个市州，自贡、绵阳、广元等地名胜古迹都留下了老人们的足迹，队员个人行程累计最短达3000公里，最长达10000公里。</p><p>　　<strong>不爱麻将爱骑游</strong></p><p>　　谈起车队，老人们都很兴奋。有的老人忍不住上前拉住记者，要细细说道这自行车骑游的好处。年龄最大的蒋电老人乐呵呵地说，自己不爱打麻将，也不爱坐茶馆，就喜欢和朋友一起骑游祖国的山山水水。&ldquo;特别是去年10月至今，我们先后3次到重灾区北川的感受很深刻。&rdquo;蒋老激动地告诉记者，以前都是从电视上短暂的画面了解灾后重建，真正切身实地去看时，真的被灾后重建的速度、质量所震撼了。去了3次，每次都有新变化，看到来自全国各地的人都在支援灾区建设，很受鼓舞、很感动。</p><p>　　<strong>骑游让&ldquo;老病号&rdquo;健康</strong></p><p>　　60多岁的杨通荣曾是多年的&ldquo;老病号&rdquo;，做过胃癌手术，加入车队至今，已参加了多次骑游，感觉身体很好。杨老告诉记者，参加骑游队就是要将不畏艰苦、坚持不懈、积极乐观的精神传扬给更多人。由于全是老年人组建的骑游队，骑游队每次出行都会引来大家的关注，上来询问究竟，甚至不少人竖起大拇指啧啧称赞：&ldquo;蓬溪人了不起！&rdquo;&ldquo;遂宁人了不起！&rdquo;这让老年骑游队队员们很自豪。</p><p>　　<strong>骑游队每年突出一目标</strong></p><p>　　队里的骨干申文锦常挂在嘴边的一句话就是：&ldquo;团队就是一个整体，每次出去，每个队员心里都会装着其他队员。&rdquo;车队活动不仅给个人带来了和谐与乐趣，也给家庭带来了和睦与欢乐。如有的队员每次在车队外出活动时不会给老伴或家里人打招呼。其他队员们知晓这一情况后，总会加以劝导。现在队员们每次出去都会以电话、短信的形式向家里人报平安。</p><p>　　车队活动健康而不失特色。退休干部夏老告诉记者，每次出行都有目标，去年突出&ldquo;灾后重建&rdquo;大家去了北川。今年5月，提出红色之旅，大家就去了广元剑阁。&ldquo;以前上班时，很少锻炼，亲自四处感受祖国山水的机会是少之又少，如今退休了参加骑游队，不仅弥补了曾经的遗憾，还开阔了眼界，陶冶了情操，增长了知识，最重要的是强身健体。&rdquo;说起骑游，夏老激动地告诉记者。</p><p>　　每次出行，老年骑游队都会精心设计路线、周密安排行程，还制定了紧急预案。骑游队行程主要以短途为主，短时当天返回，长时达11天。</p>','1276686016','zh_CN','-1','-1','1','{member}{admin}{guest}','1','9','0','');
INSERT INTO ss_articles(`id`,`author`,`title`,`i_order`,`source`,`tags`,`intro`,`content`,`create_time`,`s_locale`,`pub_start_time`,`pub_end_time`,`published`,`for_roles`,`v_num`,`article_category_id`,`is_seo`,`description`) VALUES('70','admin','河源驴友发现罕见古冰川遗址 多部门出动保护','8','','河源驴友发现罕见古冰川遗址 多部门出动保护','河源驴友发现罕见古冰川遗址 多部门出动保护','<p>位于河源市境内的桂山、东源县曾田镇石古大王两处大规模的石臼群被专家证实为冰臼，在结束为期两天的实地考察后，中国地质科学院韩同林与陈尚平教授昨天得出上述结论。</p><p>　　据介绍，冰臼是古冰川遗址。这一奇观是河源市民程云辉和李晓棠在4月下旬旅游时发现的。</p><p>　　随后，在程云辉和李晓棠的指引下，韩同林和陈尚平教授分别在两地的河滩里，进行了长时间的考察。韩同林教授介绍，根据这些石河坡度较大、海拔较高及岩石的特点，结合多年来他对古冰川遗址的研究，可以判断这个河滩上大大小小的&ldquo;石臼&rdquo;是两三百万年前由于冰川作用所形成的冰臼群。虽然在广东其他地方发现了冰臼，但目前河源发现这么大规模的冰臼群还是罕见。</p><p>　　韩同林说，冰臼的发现，将为研究河源的古环境的变迁、古迹考证等方面提供了有力证据，对地质研究和旅游资源的开发都具有很高的价值。他希望河源保护好这难得的自然地质资源，禁止对其进行开采。</p><p>　　<strong>■　驴友讲述 一次旅行发现&ldquo;冰臼&rdquo;奇观</strong></p><p>　　昨天，河源市民程云辉和李晓棠向记者讲述了发现冰臼的经历。</p><p>　　<strong>&ldquo;石臼&rdquo;还是&ldquo;冰臼&rdquo;　专家莫衷一是</strong></p><p>　　4月下旬的一个周六，痴情山水的程云辉先生与李晓棠小姐带着亲友，去景色优美的七礤四级电站桂山附近游玩。</p><p>　　已多次造访的李晓棠招呼同伴，&ldquo;走！我带你去看一种奇特景观。&rdquo;来到桂山附近的一条小溪边，李小姐指着对岸的一面岩石道：&ldquo;就是那里！&rdquo;岩石布满了大大小小的坑，石质细腻，里面盛着清水。&ldquo;冰臼？应该不是吧！听说以前南方不存在冰川。&rdquo;程先生道。</p><p>　　随后，他们决定在附近继续寻找类似景观。但因连日雨水，山洪暴涨，无法渡过山溪，不能前去仔细察看，只好商定择日再访。</p><p>　　五一期间，程云辉与李晓棠多次到桂山附近寻找类似的景观，拍了大量的照片。通过网上收集的信息再次详细比照，他们越来越相信，那些大小不一，数量众多，口径小里面大，底圆壁滑的&ldquo;石臼&rdquo;，应该是很有价值的&ldquo;冰臼&rdquo;。</p><p>　　5月16日，河源市博物馆馆长、文化局副局长黄东带领3位专家前往考察了桂山的&ldquo;石臼&rdquo;奇特景观。因各种因素专家们并没有得出具体的鉴定结果。</p><p>　　程云辉与李晓棠并没有就此作罢，为了寻找更多的类似景观，他们近十次前往桂山附近山谷查找。途中，他们听人介绍，某日有几个小伙伴在新丰江水库罗坑溪谷附近挖树根时，同伴掉到&ldquo;水缸&rdquo;里出不来。他们便前往观看，发现该处有巨大&ldquo;石臼&rdquo;。</p><p>　　在曾田镇，他们步行十多公里到达石古大王，也发现极其壮观的&ldquo;石臼&rdquo;群。并且，在玩黄腊石集中的市区大同</p><p>　　路一间奇石馆打听到康禾陈坑有个叫&ldquo;碓椿石&rdquo;的地方，他们前往发现了花岗岩石上巨大的&ldquo;石臼&rdquo;。此外，高塘俗称&ldquo;三只瓮&rdquo;的地方，也发现了类似的&ldquo;石臼&rdquo;。</p><p>　　<strong>&ldquo;冰臼之父&rdquo;一锤定音</strong></p><p>　　在收集了大量的资料后，他们通过河源市有关部门，邀请有&ldquo;冰臼之父&rdquo;之称的韩同林教授前来鉴定。他们把大量的资料，寄给了在北京</p><p>　　工作的韩同林。韩教授看到资料后，初步确定为&ldquo;冰臼&rdquo;。现在，通过韩同林教授的实地考察，有了鉴定结果。</p><p>　　程先生向记者表示，现在谜底揭开了，他们的心情也久久不能平静。通过寻找的过程，他们不仅学到了知识，发现的过程更让他们乐在其中。</p><p>　　<strong>多部门出动保护冰臼</strong></p><p>　　&ldquo;冰臼的发现，无疑给我市青山绿水增加了更多具有研究价值的内涵，将成为很有特色的旅游资源&rdquo;。昨日，河源市旅游局副局长杨友平表示，旅游局等部门将前往冰臼群所在地考察，做好对其的保护工作，防止不当的毁坏和开采发生。在条件成熟的情况下，将进行旅游开发，推动当地旅游业的发展。</p><p>　　河源市文化局副局长、市博物馆馆长黄东在考察现场听到专家的鉴定结果后兴奋不已。其表示，冰臼是河源的又一重大发现，丰富了该市的考古研究资源。如果将河源的恐龙文化游的开发和冰臼群的开发结合，将大大提升当地旅游品牌的力量。</p><p>　　<strong>■　名词解释</strong></p><p>　　冰臼，是指冰川融水携带冰碎屑、岩屑物质，沿冰川裂隙自上而下以滴水穿石的方式对下覆基岩进行强烈冲击和研磨作用形成似我国古代用于舂米的石臼，称之为冰臼。是古冰川运动存在的有力证据。</p>','1276686040','zh_CN','-1','-1','1','{member}{admin}{guest}','2','9','0','');
INSERT INTO ss_articles(`id`,`author`,`title`,`i_order`,`source`,`tags`,`intro`,`content`,`create_time`,`s_locale`,`pub_start_time`,`pub_end_time`,`published`,`for_roles`,`v_num`,`article_category_id`,`is_seo`,`description`) VALUES('71','admin','游艇、体育旅游类“潮专业”已进入海南高校','9','','游艇、体育旅游类“潮专业”已进入海南高校','游艇、体育旅游类“潮专业”已进入海南高校','<p>随着国际旅游岛的建设，游艇、高尔夫球、体育旅游等成为海南新兴热门行业。此间高校顺势推出&ldquo;游艇&rdquo;&ldquo;高尔夫&rdquo;&ldquo;体育旅游&rdquo;等&ldquo;潮专业&rdquo;，吸引向往海南岛的考生。</p><p>　　记者从海南职业技术学院了解到，该校交通与信息学院今年按&ldquo;游艇邮轮运营与管理&rdquo;方向专招一个班级。目标是培养能从事国内外游艇邮轮服务、运营与管理的应用型和复合型人才。</p><p>　　游艇业是海南建国际旅游岛重点发展的新兴旅游业态之一，面对琼州海峡的海口将是海南岛北部的游艇集聚地之一。海口计划建600个游艇泊位，其中海口湾美源国际游艇会设计游艇泊位300个。</p><p>　　海职院交通与信息学院游艇邮轮运营与管理专业教研室主任何江认为，目前海南发展游艇业缺乏游艇技术管理人才，其中包括船进出调度指挥、游艇养护人员、游艇驾驶员、游艇安全管理人员等。&ldquo;游艇邮轮运营与管理&rdquo;专业的设置十分符合市场需求，发展潜力也非常大。</p><p>　　在大学生就业难的当下，该学院副院长赵中文副教授表示：企业和市场的需求，是游艇邮轮专业开设的决定因素。这个专业将为美源集团股份有限公司定向培养人才，专业师资也将从海口港、海口海事局和著名游艇邮轮公司等聘请。学生入学第一年在校学习游艇邮轮运营与管理方向的基础知识；预计在明年下半年，就将在海口美源游艇基地实习，直接为地方经济服务。</p><p>　　记者走访海南师范大学，得知该校体育学院社会体育专业今年新设&ldquo;体育旅游与运动康复方向&rdquo; ，招收60名四年制本科生。</p><p>　　该校体育学院夏敏慧院长告诉记者，作为第三产业重要组成的体育旅游业，将以其巨大的产业规模为社会提供大量的就业机会。&ldquo;环海南岛国际公路自行车赛&rdquo;、&ldquo;中国铁人赛&rdquo;、&ldquo;世界沙滩排球巡回赛&rdquo;、&ldquo;全国公路自行车挑战赛&rdquo;等已成为海南省具有国际影响的体育品牌赛事，国际旅游岛的建设更给体育旅游带来了广阔的市场空间。她说，&ldquo;体育旅游与运动康复&rdquo;方向的设置正满足了这种发展的需求，该专业的毕业生将在旅游景点、宾馆、旅行社和户外运动俱乐部等企事业单位从事旅游体育技能指导、经营管理、旅游市场开发、旅行社管理及运动健身与运动康复指导等工作。</p><p>　　另悉，海南师范大学正在为明年招收&ldquo;高尔夫球本科班&rdquo;做准备。</p><p>　　为了令体育旅游教学科研与国际接轨，海南师范大学与国际知名院校的交流越来越密切，记者得知，来自美国德克萨斯大学体育管理系系主任Chalip先生，13日就将以&ldquo;协调体育与旅游目的地资源促进体育旅游发展&rdquo; 为题在该校进行一个报告会。</p>','1276686065','zh_CN','-1','-1','1','{member}{admin}{guest}','1','9','0','');
INSERT INTO ss_articles(`id`,`author`,`title`,`i_order`,`source`,`tags`,`intro`,`content`,`create_time`,`s_locale`,`pub_start_time`,`pub_end_time`,`published`,`for_roles`,`v_num`,`article_category_id`,`is_seo`,`description`) VALUES('72','admin','湖北首届自然水域漂流挑战赛将举行 800人参赛','10','','湖北首届自然水域漂流挑战赛将举行 800人参赛','湖北首届自然水域漂流挑战赛将举行 800人参赛','<p>湖北省体育局水上运动管理中心11日举行新闻发布会称，首届湖北省自然水域漂流挑战赛将于7月10日在宜昌青龙峡漂流风景区举行。</p><p>　　据介绍，赛事组委会经过五个多月的筹备，组织相关专家调研考察湖北省内十大漂流景区，从体育运动休闲和比赛的角度考量，最终选择了山清水秀、河道宽阔、水流湍急、水量适宜，充满诗情画意、妙趣横生的青龙峡。</p><p>　　本次漂流挑战赛分设专业组和业余组，每组五人，并至少要有一位女性运动员。专业组设6．5公里竞速赛，由湖北省水上运动管理中心、各市州水上专业运动队、体育院校和漂流专业机构组成的20余只队伍120余人参与角逐。业余组设置6．5公里休闲漂流赛，由来自各市州漂流协会、俱乐部和旅行社等800余人同台竞技。</p><p>　　据悉，举办本次挑战赛是为了推动宜昌打造中国漂流之都，实现体育元素、文化元素和旅游元素的有机融合，推动体育旅游产业的发展，丰富鄂西生态旅游的内涵，让漂流运动为宜昌的经济和体育旅游事业发展做出积极贡献。</p>','1276686085','zh_CN','-1','-1','1','{member}{admin}{guest}','2','9','0','');
INSERT INTO ss_articles(`id`,`author`,`title`,`i_order`,`source`,`tags`,`intro`,`content`,`create_time`,`s_locale`,`pub_start_time`,`pub_end_time`,`published`,`for_roles`,`v_num`,`article_category_id`,`is_seo`,`description`) VALUES('73','admin','广元苍王峡风景区日前推出大型户外野餐活动','11','','广元苍王峡风景区日前推出大型户外野餐活动','广元苍王峡风景区日前推出大型户外野餐活动','<p>据悉，位于广元旺苍县的苍王峡地质生态风景区在五一开业大酬宾后，再度推出大手笔让利活动。活动期间，景区对有专业领队带领的驴友执行8折门票优惠。苍王峡景区还将在景区标志景点&mdash;&mdash;潜龙十八潭举办大型户外野餐活动：全家总动员，我为野餐狂。</p><p>　　届时，游客可以在潜龙十八潭：观美景，品美食，追忆幼时美好时光。小朋友们可以在父母的带领下领略神奇的地质奇观，到潜龙十八潭的洞穴内经历小小的探险。景区还为每一个家庭精心准备了野餐垫、野餐篮、野餐帐篷等户外活动设施。野餐节期间，游客朋友们将享受到景区提供的特惠家庭套票：买两张成人票即送一张儿童票。野餐节期间，景区组织了专业的户外俱乐部带领游客体验攀岩、溯溪等一系列户外运动。当然，苍王峡的奇山、异石、飞瀑、碧潭一定也会让你大饱眼福。</p>','1276686107','zh_CN','-1','-1','1','{member}{admin}{guest}','3','9','0','');
INSERT INTO ss_articles(`id`,`author`,`title`,`i_order`,`source`,`tags`,`intro`,`content`,`create_time`,`s_locale`,`pub_start_time`,`pub_end_time`,`published`,`for_roles`,`v_num`,`article_category_id`,`is_seo`,`description`) VALUES('74','admin','巴黎华人徒步健身俱乐部获法华工商联会赠帽','12','','巴黎华人徒步健身俱乐部获法华工商联会赠帽','巴黎华人徒步健身俱乐部获法华工商联会赠帽','<p>据法国媒体报道，法国法华工商联合会郑世凡副会长向&ldquo;巴黎华人徒步健身俱乐部&rdquo;赠送&ldquo;徒步帽&rdquo;的仪式6月6日上午在欧洲时报文化中心举行。</p><p>　　巴黎华人徒步健身俱乐部成立于2005年10月，除暑期外，坚持每月一次活动。自虎年新春起，在广大会员的强烈要求下，增至一个月两次活动。五年期间，巴黎的大街小巷、周边的森林湖泊、宁静的山谷城堡、美丽的小径花园，无不留下会员们的足迹。</p><p>　　2009年开始，徒步运动在巴黎市区蓬勃兴起，法国有1500万人投入了这一老少皆宜的运动。关注健康，享受生活也成为侨界的共识。相同的爱好增进相互的了解，徒步活动在中法民众之间搭起了友谊之桥。</p><p>　　相比起经常&ldquo;武装到牙齿&rdquo;的法国徒步队，华人徒步俱乐部的装备相对简陋。当得知俱乐部打算添置百顶徒步帽时，法国法华工商联合会的郑世凡主动提供赞助，慷慨赠予200顶帽子。</p><p>　　仪式结束后，郑世凡副会长偕夫人与华人徒步俱乐部的成员一起参加徒步活动，度过轻松的一天。</p>','1276686149','zh_CN','-1','-1','1','{member}{admin}{guest}','1','9','0','');
INSERT INTO ss_articles(`id`,`author`,`title`,`i_order`,`source`,`tags`,`intro`,`content`,`create_time`,`s_locale`,`pub_start_time`,`pub_end_time`,`published`,`for_roles`,`v_num`,`article_category_id`,`is_seo`,`description`) VALUES('75','admin','2009年日本登山事故的遇难者人数创历史新高','13','','2009年日本登山事故的遇难者人数创历史新高','2009年日本登山事故的遇难者人数创历史新高','<p>6月8日，日本警视厅宣布：与去年统计相比，日本2009年登山事故中的死者人数又增加了36人，为317人。这是自1961年（昭和36年）开始统计以来，死亡人数最多的一年。</p><p>　　2009年，日本共发生了1676起登山事故，遇难者达2085人，创历史新高。其中，90%的罹难者为40岁以上的中老年人。在诸多事故中，比较典型的例子是，大家往往会把登山当做了一种休闲运动来进行，但在登山的途中，有的中老年人经常会因为采摘野菜或其他原因中途走开，于是事故就发生了。于是在夏天登山季节来临之前，警察厅就提前提醒大家：&ldquo;在登山之前，一定要认真计划，并带足装备。&ldquo;希望大家一定要按照提醒，谨慎出行。</p><p>　　如果从不同年龄段来看，在众多遇难者中，65岁～69岁的人占得比例最大，为14.4%。55岁以上的中老年人占到了60%。在远足、滑雪、浅谷登山等途中遇难的登山者占到了66.9%；在&ldquo;采摘野菜&middot;蘑菇&rdquo;等途中的遇难人数也占到了23.0%；在遇难原因中，最多的是因为&ldquo;迷路&rdquo;，占到了43.5%，其次是&ldquo;滑落&rdquo;，为15.6%，再次是&ldquo;跌倒&rdquo;，占到了12.4.%。</p><p>　　在过去10年中，登山事故在逐年增加。与2000年相比，日本去年的登山事故增加了461起，遇难人数则增加了591人。</p>','1276686170','zh_CN','-1','-1','1','{member}{admin}{guest}','2','9','0','');
INSERT INTO ss_articles(`id`,`author`,`title`,`i_order`,`source`,`tags`,`intro`,`content`,`create_time`,`s_locale`,`pub_start_time`,`pub_end_time`,`published`,`for_roles`,`v_num`,`article_category_id`,`is_seo`,`description`) VALUES('76','admin','欧美再发两起跳伞事故 一组生还一组不幸遇难','14','','欧美再发两起跳伞事故 一组生还一组不幸遇难','欧美再发两起跳伞事故 一组生还一组不幸遇难','<p>跳伞从来都是一项有挑战有风险的运动，意外随时可能发生，以下就是近期来自美国和英国的两则关于跳伞事故的报道：</p><p align=\"center\">&nbsp;</p><p>　　<strong>美国：54岁跳伞者高空遇险砸向地面 教练当气垫救人</strong></p><p>　　据英国媒体4日报道，美国德州提格市54岁妇女谢丽&middot;戴格特决定用跳伞这一特殊方式庆祝生日，这也是她首次跳伞。但谢丽做梦没有想到的是，当44岁跳伞教练戴夫&middot;哈特索科和她捆绑在一起跳出机舱之后，他们身上的降落伞竟无法正常地打开，导致二人像秤砣一样从4000米高空旋转着砸向地面！令人感动的是，在落地的一瞬间，跳伞教练戴夫竟不顾个人安危，让自己的身体首先撞击地面充当&ldquo;人肉气垫&rdquo;，让谢丽着陆时压在自己身上。最终，谢丽奇迹般地毫发无损，然而戴夫却因此折断脊椎导致全身瘫痪。日前，当跳伞教练戴夫舍己救人的事迹曝光后，立即在美国传为佳话。</p><p align=\"center\">&nbsp;</p><p>　　<strong>英国： 两名跳伞者遭遇降落伞互相纠缠 双双坠地身亡</strong></p><p>　　英国两名经验丰富的跳伞者在高空中遭遇降落伞互相纠缠，最终双双坠地身亡。</p><p>　　据英国媒体今晨报道，当地时间4日15时30分，31岁的埃玛和65岁的布赖恩乘坐飞机从英国诺丁汉郡兰加尔机场起飞，到达4000米的高空。</p><p>　　两人背着降落伞跳出飞机，和其余4位同伴手拉手完成组合自由跳伞动作后，各自打开降落伞分开降落。</p><p>　　此时，埃玛和布赖恩不小心碰到，他们的降落伞立刻互相缠绕在一起。两人想尽办法分开，但没有成功。随后埃玛尝试打开后备伞，但祸不单行，她又被后备伞缠住身体。两人最终坠地身亡。</p>','1276686208','zh_CN','-1','-1','1','{member}{admin}{guest}','2','9','0','');
INSERT INTO ss_articles(`id`,`author`,`title`,`i_order`,`source`,`tags`,`intro`,`content`,`create_time`,`s_locale`,`pub_start_time`,`pub_end_time`,`published`,`for_roles`,`v_num`,`article_category_id`,`is_seo`,`description`) VALUES('77','admin','驴友出行必读篇：户外生存必了解的50技巧','1','','驴友出行必读篇：户外生存必了解的50技巧','驴友出行必读篇：户外生存必了解的50技巧','<p>谈到户外活动，知识就是快乐。快乐地学习吧。<br />　　<br />　　<strong>准备出发</strong></p><p><strong>　</strong>　技巧1：如何挑选<br />　　把你所有计划要带的东西收集起来，把它们放在一个房间里，然后想象它们都装在你的包里。哇，这时可以执行第一条：凡是不知道该不该带的东西都别带。这样你的包会变得更紧凑。</p><p>　　技巧2：如何装包<br />　　轻的装备放在下面，重的放在上面。因为任何人在走路时都会向前微倾，这样就把重量<br />　　集中在你的臀部而不是你的肩膀上。在底部可以放你的睡袋（睡袋有睡袋套，也可以用塑料把它包起来，这样万一你掉在水里或你的独木舟进水就可以防止被浸湿）。然后是当天你不用的衣服：内衣和袜子，鸭绒衣等。接着是你的睡垫，应该放在里面而不是绑在外面。然后是你的帐篷和防雨布。然后是野炊用品：炉子，油，壶子，杯子和匙子，滤水器和急救包。然后――在*近顶端的地方――你的食品。恶劣天气的衣服放在最上面。最后拉紧口袋绳子。</p><p>　　技巧3：让包又薄又高<br />　　而不是又矮又厚。这就是那些背包带的用处――扎紧它们，用膝盖来压紧它们（当<br />　　然不要弄坏了里面的东西）装包</p><p>　　技巧4：避免悬摆的物件<br />　　当你走路，这些东西的摆动会耗费你的体力。那哪些附在你腰带和肩带上的可爱的小<br />　　包呢？其实它们是沉重的累赘。当你需要防晒霜和胶卷时，花不了你多少时间把它们从你的背包上层口袋中取出来。唯一的例外是辣椒水喷洒剂。它应该在你触手可得的地方。</p><p><strong>　　</strong>技巧5：把你所有的食品都放在防水包里<br />　　当你在晚上把你的补剂藏在远离动物的地方时，你用不着到处乱找这些零碎的东西。至于午饭和小吃，分别用塑料包好放在食品袋里，这样在休息时可以轻易拿出来。</p><p><strong>　</strong>　技巧6：把你的水壶放在包里<br />　　不要吊在屁股上，会被太阳晒热的。</p><p><strong>　</strong>　技巧7：防虫剂<br />　　喷洒一些在你的劲后和你身上一些暴露的地方。在蚊虫肆虐的季节，还可以喷一些在你的袜子上和裤子的根部上，因为这些小虫虫会从一些长得比较矮的植物上而不是从树上爬到你身上来。喷洒一些到你的手背上而不是手掌上，然后擦在脸上。听上去蛮怪的，因为这样可以让害虫远离你的眼睛。还要在你的帽檐的下边喷洒一些。</p><p>　　<strong>抵达</strong></p><p>　　技巧8：放松点从但是要有节奏<br />　　开始时慢点，让自己的身体慢慢热起来，然后找出你自己的行走速度。</p><p>　　技巧9：早点抵达<br />　　不管你去哪，应该在中午时到，并在其它人陆续抵达前及时地找到露营地点。你有足够的时间来支撑帐篷，并在入睡前晒干睡袋。你可以小憩一会儿，随便走走，四处探探，或者手拿一杯茶，好好欣赏一下眼前宜人的风光。</p><p><strong>　　</strong>技巧10：让大家在一起</p><p>　<strong>　</strong>技巧11：当你感到疲惫时，你同时也又饿又渴<br />　　所以在你休息时，你也要补充食品和水分（当然要开开心心）。不要在你的身体出现不适反应时才这样做。</p><p>　　<strong>三急</strong></p><p><strong>　</strong>　技巧12：晚上不要喝茶<br />　　不管是不是含咖啡因，大多数茶会让你晚上爬起来撒尿。</p><p>　　技巧13：使用尿壶</p><p>　　技巧14：用有拉链的袋子装使用过的纸张<br />　　人有三急，最好把你的排泄物用旧纸张包起来，并装在有拉链的袋子里，然后在下一个垃圾处理地点（生火点或者简易茅坑）把它们倒出来，而不是就地掩埋。动物喜欢挖人类的粪便（啊，嗯，唔）并把纸张弄得到处都是。</p><p>　　技巧15：是不是真的要篝火<br />　　我不大生。而且在野外最好不要生篝火。因为如果我们不生火，这些木材足够供养一些有机生物，而它们又是在生物链中一些更高级别生物的食品。点一堆火你得收集木材，生火，把自己熏得眼泪水直流，最后浑身一股烟味去睡觉。但是如果你又冷又湿，这就有必要生一堆火了。或者当有重要的事情要当晚讨论时，大家可以围火而坐。（待续）</p><p>　　技巧16：有GPS？<br />　　你在哪？走了多远？你走了多快？路过了什么地方？何时天黑？类似的问题GPS比指南针有用。</p><p>　　技巧17：哪里买地图？<br />　　大的书店和专业的书店，还有可以在网上查找</p><p>　　技巧18：很多地图没有详细的细节。<br />　　这时就要*GPS了来确定你精确的位置了。而且以后还可以借给朋友用。</p><p>　　技巧19：检查数据<br />　　当你的GPS接受了一份地图，别忘记设置这份地图。</p><p>　　技巧20：扔了熊铃<br />　　熊可以在比你认为的更远的距离的里听到铃声。尽量多用喊叫而不是不停的铃声。</p><p>　　技巧21：隐性眼镜<br />　　以前在旅行时我总是戴眼镜，得忍受眼镜框，摩擦和雾气。现在不用了，有可以长达三个月的不用更换的隐性眼镜。</p><p>　　技巧22：你不需要的<br />　　牙膏（但是你需要牙刷和丝线。）<br />　　一块肥皂（一点洗洁精也可以）<br />　　一块毛巾（风干的就可以了）<br />　　折叠饭盒和镜子</p>','1276686324','zh_CN','-1','-1','1','{member}{admin}{guest}','1','3','0','');
INSERT INTO ss_articles(`id`,`author`,`title`,`i_order`,`source`,`tags`,`intro`,`content`,`create_time`,`s_locale`,`pub_start_time`,`pub_end_time`,`published`,`for_roles`,`v_num`,`article_category_id`,`is_seo`,`description`) VALUES('78','admin','借东风不是神话 用户外气象谚语看天象知天气','2','','借东风不是神话 用户外气象谚语看天象知天气','借东风不是神话 用户外气象谚语看天象知天气','<p><strong>1、看太阳</strong></p><p>　　日落西山一点红，半夜起来搭帐篷<br />　　日晕三更雨，月晕午时风<br />　　早看青山，晚看日落。<br />　　乌云接日头，天亮闹稠稠<br />　　日头出得早，天气难得好。<br />　　日返红，雨落没蟹洞。<br />　　红日雨，白日风，明星月朗大晴空。<br />　　太阳裂嘴笑，晒得老猫叫。（云中露日）<br />　　太阳中午现，三日不见面。<br />　　日落胭脂红，无雨便是风。<br />　　日落黄澄澄，明日刮大风。<br />　　日落西山满天红，不是雨便是风。<br />　　东方太阳白，就要有风发。<br />　　爬墙出日头，要发西北风。<br />　　日出太阳黄，午后风必狂。<br />　　日月有风圈，无雨也风颠。<br />　　日落三条箭,隔日雨就现。<br />　　日出挂红，当天就晴。<br />　　日落灰色，次日有风。<br />　　日出血红天气热，中午转冷有西货。（冰雹）<br />　　日出东方红，近期不雨也有风。<br />　　日出黑云生，不雨也刮风，<br />　　日出云夹日，变天不过三五日。</p><p><strong>　　2、看月亮</strong></p><p>　　月亮周围有圆圈，刮风就在明后天。<br />　　月亮撑红伞，大雨在眼前。<br />　　月亮撑黄伞，小雨一两天。<br />　　月亮撑黑伞，多半是晴天。<br />　　月打洞，落雨像闸水冲(月亮周围有圈云)。<br />　　月亮长毛，大水冲成潮(月亮周围有高层云)。</p>','1276686348','zh_CN','-1','-1','1','{member}{admin}{guest}','2','3','0','');
INSERT INTO ss_articles(`id`,`author`,`title`,`i_order`,`source`,`tags`,`intro`,`content`,`create_time`,`s_locale`,`pub_start_time`,`pub_end_time`,`published`,`for_roles`,`v_num`,`article_category_id`,`is_seo`,`description`) VALUES('79','admin','健康始于足下 夏季暴走注意事项与新方式','3','','健康始于足下 夏季暴走注意事项与新方式','健康始于足下 夏季暴走注意事项与新方式','<p><strong>暴走，是一种高强度又简单易行的户外运动方式。</strong></p><p>　　据了解&ldquo;暴走&rdquo;源于美国，风靡欧美，流行于韩国，日本，香港等地，是一种新时尚，新运动，目前世界上暴走一族大约有七千万人。所谓暴走，指的是选定一条路线，沿着路线徒步或驾车行走，时间由一日到数日不等。暴走其实也是极限运动的一种，它挑战着人们的心理素质和身体素质，但暴走又不像登山野外探险等极限运动那样需要投入较大的经济代价去购买设施，它的最低限度只需要一双好鞋和一瓶水，外加几块面包就可以成行了。暴走族所去的地方一般交通不发达，处于待开发或者半开发状态，风景很有特色，对人的体质、意志和知识储备都有相当的考验。尤其在夏季，天气炎热，温度高，湿度大，这一定程度上增加了暴走的难度。在这里小编给大家介绍一些夏季暴走中应该注意的常识，请诸喜欢暴走的朋友结合自己的身体情况，予以注意。</p><p>　　1 暴走当天早饭必须吃好，适当饮水</p><p>　　2 暴走时，服装必须宽松，腰带不要系的过紧，衣服质量以吸汗，速干为好，颜色以浅色调为好</p><p>　　3 暴走时，不要穿凉鞋，避免意外受伤</p><p>　　4 暴走时，尽量不要捂的太严，不利于呼吸和皮肤排汗，带宽檐的遮阳帽就可以，可以适当的晒晒太阳</p><p>　　5 暴走时，女同胞不要擦，噴，芳香的化妆品，因为所有化妆品都是化学成分组成，天气炎热时，人的皮肤毛孔都是开放的，不利于排汗。阳光的作用有的人容易发生过敏反应，同时也容易遭到小生物的袭击</p><p>　　6 暴走时，速度不能过快，心率以每分钟不超过120次为宜</p><p>　　7 暴走时，注意调整好呼吸，尽量不在行走时说话</p><p>　　8 暴走时，听从领队的指挥，不要掉单，以免发生意外</p><p>　　9 暴走途中休息时，尽量不坐下，休息时间也不可过长，适量喝水，忌一下子喝进大量的水，增加心脏负荷</p><p>　　10 天气炎热时排汗较多，可以自己调整水的电解质平衡，我的做法是，1000毫升的水，加入一羹匙糖，用手指捏一小撮盐（我买的是不含碘的盐）</p><p>　　11 终点休息时，不要一下子就坐下，等呼吸，心率平稳了，再坐下休息，休息时，最好脱下鞋，松开腰带</p><p>　　12 休息后，再次出发时，忌一下子就起立</p><p>　　13 暴走途中，适当举起双手，呈10点10分状，锻炼上肢，缓解颈椎痛</p><p>　<strong>　暴走花样大翻新</strong></p><p>　　大步走：后腿用力蹬，前腿往前抬，两腿肌肉用力就大了许多，步幅自然地加大了。</p><p>　　10时10分走：两手侧举到表针中的10时10分位置上，保持动作可以有效锻炼颈部肌肉，缓解颈椎痛。</p><p>　　数着数走：在走的时候心里数着四个数，1、2、3慢吸，4快呼，这样可使氧和肺泡之间的红血球氧及二氧化碳交换的几率加大，使全身充氧。</p><p>　　扭着走：扭着身体走会搅动内脏，相当于对肠胃进行了良好按摩，可增强排便功能，防止便秘。</p><p>　　弹着走：每走一步，十个脚趾头都要用力，特别是大脚趾，把人要&ldquo;弹起来&rdquo;。对平日穿高跟鞋易引起的脚部疾病，如脚趾痛、踝关节问题有改善作用。</p><p>　　倒着走：可以强化腰腿肌肉，增强平衡，比正走耗氧多</p>','1276686367','zh_CN','-1','-1','1','{member}{admin}{guest}','3','3','0','');
INSERT INTO ss_articles(`id`,`author`,`title`,`i_order`,`source`,`tags`,`intro`,`content`,`create_time`,`s_locale`,`pub_start_time`,`pub_end_time`,`published`,`for_roles`,`v_num`,`article_category_id`,`is_seo`,`description`) VALUES('80','admin','经验分享：驴行山野节省体能的几种方法','4','','经验分享：驴行山野节省体能的几种方法','经验分享：驴行山野节省体能的几种方法','<p>最近与驴友们登山，途中发现许多驴友不善于节省体能，在极为疲乏的时候，一方面无力上行，一方面还在无谓地浪费体力，现就个人的经验，与大家交流下。</p><p><strong>　　1、少说话。</strong></p><p>　　说话耗费的体力是非常大的，说话需要调动口腔肌、咽喉肌、肺肌等多处肌肉组织，需要从心脏调用血液来供应这些肌肉运动之需，更严重的是，说话消耗的氧气数量是非常巨大的，我们说话的时候，几乎所有肺部吸入的氧气都被用来供应说话，血液中的氧含量迅速下降。如果是大声吆喝、连续说话，耗费体能的更巨大的。所以，驴途中尽量少说话，是节省体能的一个重要方法。</p><p>　　另外，少说话，多观察，多体会，是成熟驴友的标志之一。是一个有品位的驴的好品质。一些沿途滔滔不绝，废话连篇的驴友，是很惹人烦的，同时，听别人在耳边不停地聒噪，也非常浪费体力，并且导致心情不好。所以，不是必要的话，尽量不要多说，免得害人害己。</p><p><strong>　　2、减少坐下休息的次数</strong></p><p>　　很多驴友在上坡的时候，一感到疲劳，就忙不跌地一屁股坐下。想走的时候，本来就十分疲劳的双腿，还要消耗很多能量来把整个身体和背包支撑起来。其实，休息的办法有多种，没有必要全身坐下：</p><p>　　一是选择树干斜靠一下，减轻双腿承负，缓解压力。</p><p>　　二是选择较高的地方坐下，最好坐在与臀部高度差较小的斜坡、石块上来休息，起身走的时候不用耗费很多体力来抬起全身。</p><p>　　三是使用驴行专用休息法（俺秋水命名）：双手扶膝盖部位支持上身，弯曲上身成平衡桥，背部水平，让背包平稳地放在背上，双腿略弯曲，面向上坡方向，放松躯干，可以让双肩减轻负重感，使脊柱缓解自上而下的压力，迅速缓解疲劳，恢复体力。启动的时候，不要迅速抬起上身，而是在向上行的过程中，慢慢恢复躯干到正常位置。</p><p>　　四是尽量深呼吸，放慢步伐，慢到感觉不吃力为止，把休息分散到每一步当中，减少休息的次数。</p><p>　　五是如果坐下休息，尽量在走到前方是平缓道路的地方坐下，而不要在休息之后立即进入拔高的地方休息。否则休息之后，心肺和肌肉都处于平静状态，突然需要巨大体能，会引发危险不说，还更浪费体能。</p><p>　　六是小步，略拖着脚走。小步可节省部分体力，而上山的时候，不把脚抬很高，略微有点拖地，只要不影响行走和安全就行，这样可以节省体力，这些小地方都留心一下，养成习惯，就能节省很多体力。</p><p>　　七是上高台的时候，可用手帮着把腿抬上去，然后用手按膝部上升身体。山中有很多道路，突然会需要攀上一个高石台，这个时候如果非常疲劳了，就不要来完全使用腿部的力量上升身体，因为腿在上山的过程种一直没有停止使用，肌肉在极度疲劳的时候会有些痉挛，不灵便，所以上下肢进行搭配是最好的，可节省很多体力，又保证安全。</p><p><strong>　　3、深呼吸的方法</strong></p><p>　　很多驴友在上坡的时候呼吸短促浅粗，没有规律，这样会越来越疲劳。上山的时候，要保持步履和呼吸适当的节奏，有意地去控制达到习惯的状态。负重陡坡尽量一步一呼一步一吸，疲劳的时候加深呼吸，有意略微减缓节奏，使体能随呼吸分布均匀。急促的呼吸是对肺肌运动的浪费。同样的运动量却不能吸收足够的氧气，这是驴友应该注意的。</p><p>　　好的步履和呼吸节奏，可以坚持数小时徒步而不用停下休息，并且不感到疲劳。</p><p><strong>　　4、上山时尽量把重心降低</strong></p><p>　　从物理学角度很好理解，重心低，不仅步子稳，也会节省体力。比如个子小的人，就比个子高的人登山节省体力。上身略微前倾到一个适合的角度，让重力帮忙你登山。如果是陡坡，最好手脚并用，这样会非常轻松，前面的斜坡刚好弥补手臂的长度，使人可以和兽一样四肢行走，这是非常节省体能的方法之一。有装备的可使用手杖来达到这一效果。</p>','1276686392','zh_CN','-1','-1','1','{member}{admin}{guest}','1','3','0','');
INSERT INTO ss_articles(`id`,`author`,`title`,`i_order`,`source`,`tags`,`intro`,`content`,`create_time`,`s_locale`,`pub_start_time`,`pub_end_time`,`published`,`for_roles`,`v_num`,`article_category_id`,`is_seo`,`description`) VALUES('81','admin','体验野外生活　如何学会在大自然中求生','5','','体验野外生活　如何学会在大自然中求生','体验野外生活　如何学会在大自然中求生','<p>一、体验野外生活　　　<br />　　生活在都市里一格格的房间，仿若被关在方型的甲虫，有时想到野外去旅行。野外有香味扑鼻的花草、树木；悦耳动听的鸟鸣；飘荡蓝空的云；清澄的溪水；我们多希望接触这些东西，离开喧扰的人声，到没有天花板的野外，尽情享受大自然。</p><p>　　二、学生求生技术　　　<br />　　大都市的建筑物，总使我偿有压迫感。而野外空旷，能够让我们逍遥地自由活动。做任何事，可以随心所欲，自已动手。虽然野外没有自来水、天然气，但这就是野外生活特有的情趣。请各位亲自去体验，学习野外求生的技术。</p><p>　　三、对自己的行动负责　　　<br />　　衩次过野外生活，各位如果只凭自己的意思行动，常会遇到一些困难，也会有失败。但是多次经验后，就能应付任何事。发生任何事故，都要自己处理，自己负责。野外生活就是训练各位这种能力。</p><p>　<strong>　大自然的智慧</strong></p><p>　　一、培养观察自然的眼光　　　<br />　　在野外求生存，最重要就是培养观察自然的眼光。人类与动、植物求生的本能都是一样。自然界动、植物虽然彼此间没有共同沟通的语言，但是彼此关系密切。如果我们仔细观察，就能理解其他生物，平等对待他们，而不会去伤害他们。</p><p>　　二、不要破坏自然界平衡的状态　　　<br />　　大自然中动植物彼此保持很微妙的平衡。一块狭小的空地，表面看起来没有生物生存，实际上生物正在那活跃着。接触大自然时，不要破坏这种平衡，不乱折花木杯乱捕鸟兽。享受大自然，就应遵守规则。</p><p>　　三、恢复自然界原有的风貌才离开　　　<br />　　有时我们看到人们离开野外后，留下肮脏的垃圾，阴暗处的空罐头、堆积的塑料袋，吃剩的鱼肉汤肴，不堪入目。因此不要忘记，保存自然原有的风貌，处理掉垃圾，将临时厕所掩埋好，把不能燃烧的塑料袋带走。后来的人才能享受干净的大自然。</p><p><strong>　　拟定计划</strong></p><p>　　一、依目的不同选择地点　　<br />　　我们到野外的目的，因人而异。有的去钓鱼；有的想至深山里，呼吸新鲜空气；胡的想品尝山菜野味。无论目的是什么，出发前一定要做好准备，阅览有关报导，如书报活动介绍，跟朋友讨论，汲取别人的经验。</p><p>　　二、与伙伴讨论　　<br />　　购买地图，决定地点后，大家计划几天的行程，携带物品、使用工具、食品&hellip;&hellip;等等这些，都有不少需要讨论。成功的讨论会，关系着里外生活乐趣与否。</p><p>　　三、分配工作　　<br />　　决定露营，一切食衣住行，都要搬到期里外，准备工作不容易，需要大家分工合作。分配工作，决定某人负责食品（准备食品、掌管炊事），某人负责工具（清点帐篷、小炉子等事），某人管会计（办理交通费、食品费、杂费登记），还要决定领导人（负责任，有担当任务能力）。并把这些事项做一个计划表。</p>','1276686429','zh_CN','-1','-1','1','{member}{admin}{guest}','2','3','0','');
INSERT INTO ss_articles(`id`,`author`,`title`,`i_order`,`source`,`tags`,`intro`,`content`,`create_time`,`s_locale`,`pub_start_time`,`pub_end_time`,`published`,`for_roles`,`v_num`,`article_category_id`,`is_seo`,`description`) VALUES('82','admin','耐力跑培训越野运动损伤及防治:损伤的预防','6','','耐力跑培训越野运动损伤及防治:损伤的预防','耐力跑培训越野运动损伤及防治:损伤的预防','<p>越野运动因场地复杂、路线多变而具有一定的运动伤害风险，应根据其项目特点进行全面预防。预防的主要手段包括运动前的热身、补液、防晒和合理衣着等；运动中主要注意针对不同地形路况的不同跑跳方法和保护、树林中奔跑的自我保护、运动中的补液等；运动后的预防则应加强放松运动、营养和休息，并防止感染。通过对越野运动中运动损伤的预防将有利于提高越野运动的训练效果和比赛成绩，从而推动该项运动的普及和发展。</p><p><strong>　　越野运动损伤的预防</strong></p><p>　　运动员平时应加强锻炼以保持良好的体能，许多损伤都发生在机体疲劳时，所以保持体能对预防损伤非常重要。</p><p>　　运动前要进行全面的热身，特别应包括大量的伸展运动。</p><p>　　运动前2小时即可开始补液，使机体在运动前有良好的水合状态，以防脱水。</p><p>　　可在踝关节和膝关节处佩戴关节护围，以增加固定和支持关节，防止损伤。</p><p>　　穿着长袖长裤，以防皮肤伤害。</p><p>　　穿着合适的鞋和全棉厚底袜。鞋的选择应当舒适和有良好的弹性，不要穿新鞋参加比赛。</p><p>　　全身要涂抹SPF 30以上的防晒霜以防皮肤晒伤。</p><p>　<strong>　越野运动损伤的运动中预防</strong></p><p>　　要仔细观察地图以挑选适合自己体能和技能的最适路线。在树木密集、地形复杂的路段，即使在路上跑可能距离会增远，但如果有路就应在路上跑进，而不要越野。因地形复杂，在跑进过程中容易迷失方向，既耽误时间，又容易对身体造成伤害。但如果两点之间地形较平坦、树木不多，则应以直接越野为最佳路线，以节省体力和时间。对于有陡坎、大水塘或难攀登的高地，则要分析整个地形，尽量避开这些不能通过的地段，提前做好绕行准备，避免受伤。</p><p>　　科学的跑跳：越野运动大部分时间都在奔跑或跳跃中，科学地跑跳有利于运动损伤的预防。越野跑同其他长跑项目一样，既要维持一定的跑速，又要具有加速的能力。所以奔跑过程中要注意身体各部分动作的协调配合，并按选择的路线合理分配体力，奔跑速度不宜过快。</p><p>　　树林中奔跑注意保护：树林中奔跑要注意不要被树枝、树叶或藤蔓刮伤，特别要注意保护眼睛，可用单手或两手随时护住脸部。</p><p>　　定时补液，少量多次：运动中应每隔15~20min补充150-200ml的运动饮料。不要为了省时而放弃补液，通过运动饮料补充适当的糖和电解质有利于更持久的运动能力。</p><p>　　受伤后要立即停止运动，及时呼救。带伤跑只能使伤情加重，应迅速进行伤后处理和就地呼救。所有的软组织损伤应立即制动、压迫局部和抬高患肢。如有可能，就近采用溪水进行冷敷。随身带上呼救的口哨，通常呼救哨声是连续6声，每隔1秒1声，然后暂停等候回应。如无回应，再重复吹哨呼救。及时获救并得到医学处理是良好预后的保证。</p>','1276686768','zh_CN','-1','-1','1','{member}{admin}{guest}','1','3','0','');
INSERT INTO ss_articles(`id`,`author`,`title`,`i_order`,`source`,`tags`,`intro`,`content`,`create_time`,`s_locale`,`pub_start_time`,`pub_end_time`,`published`,`for_roles`,`v_num`,`article_category_id`,`is_seo`,`description`) VALUES('83','admin','耐力跑培训越野运动损伤及防治：损伤类型','7','','耐力跑培训越野运动损伤及防治：损伤类型','耐力跑培训越野运动损伤及防治：损伤类型','<p>　<strong>越野跑易发生的损伤类型</strong>　　</p><p>　　越野运动的场地错综复杂，线路变化多端，运动员要在陌生的野外不断地奔跑，持续时间长，并需要及时的判断信息、选择路线，所以越野运动中存在着一定的危险性，并有运动伤害的风险。</p><p>　　由于越野跑是在野外进行，其运动项目的特点使运动损伤的发生与其他项目相比也有所不同。常见的运动损伤包括软组织损伤、骨折、皮肤伤害和感染等。</p><p>　　在越野运动的急性损伤中，足部损伤最多见。一项对42名优秀越野运动员一年的调查发现，在73例新伤中踝关节损伤占37%，所占比例最高。另一项对优秀女子越野运动员的流行病学调查也显示，越野运动中踝关节损伤最为普遍，占43%，膝关节损伤占16%。越野运动中，无论比赛的方式如何，无论运动员的水平高低，下肢尤其是踝关节、膝关节的损伤最为多见，应重点保护。</p><p>　　除了踝、膝关节的扭伤外，越野运动中还常有肌肉拉伤、滑囊炎的发生。此外，越野中的运动伤害还包括因长时间跑步引起的腹部不适，因跌倒撞在岩石或树上引起的擦伤、挫伤或撞伤，因树枝或藤条等刮在脸上引起的眼部戳伤、皮肤磨损、割伤或擦伤，还有因过度日晒引起的中暑、晒伤等。</p>','1276686793','zh_CN','-1','-1','1','{member}{admin}{guest}','1','3','0','');
INSERT INTO ss_articles(`id`,`author`,`title`,`i_order`,`source`,`tags`,`intro`,`content`,`create_time`,`s_locale`,`pub_start_time`,`pub_end_time`,`published`,`for_roles`,`v_num`,`article_category_id`,`is_seo`,`description`) VALUES('84','admin','美国研究显示长期旅行超六个月易患寄生虫病','8','','美国研究显示长期旅行超六个月易患寄生虫病','美国研究显示长期旅行超六个月易患寄生虫病','<p>全球旅行超过6个月，这听起来像是一个理想的休假计划，但根据美国一份研究显示，这可能对身心健康造成严重危害。</p><p>　　这项研究对1996年到2008年近3万名患病旅行者的相关数据进行了分析，他们都曾访问过国际旅游医学会全球监测网(GeoSentinel)的门诊，这些门诊遍布6大洲，专门负责旅游医药。</p><p>　　来自该监测网和美国马萨诸塞州Mount Auburn医院(MAH)的研究人员发现，旅行时间超过6个月伴随有健康风险，最常见的是产生心理问题或由寄生虫引起的疾病，而这通常不会发生在短期旅行者身上。</p><p>　　MAH医院研究者Lin H. Chen在声明中称，之前几乎没有研究基于旅行时间，对旅行者所患的疾病种类和原因进行比较。</p><p>　　研究调查分析了4,039名行程超越6个月的旅行者，以及24,807名行程短于1个月的人。</p><p>　　长期旅行者明显比短期旅行者更容易患上各种疾病，包括慢性疲劳、慢性腹泻、疟疾及肠易激综合症。前者也更容易患上利什曼原虫病(leishmaniasis)以及血吸虫病(schistosomiasis)。</p><p>　　研究者称，长期旅行者中出现的很多感染可以通过疫苗、食物和水的预防以及避免接触土壤和淡水等方法来进行预防。这份研究结果发布在《新兴传染病》(Emerging Infectious Diseases)期刊上。</p><p>　　长期旅行者明显更容易出现各种心理问题，例如抑郁、压力和疲劳等。</p>','1276686824','zh_CN','-1','-1','1','{member}{admin}{guest}','3','3','0','');
INSERT INTO ss_articles(`id`,`author`,`title`,`i_order`,`source`,`tags`,`intro`,`content`,`create_time`,`s_locale`,`pub_start_time`,`pub_end_time`,`published`,`for_roles`,`v_num`,`article_category_id`,`is_seo`,`description`) VALUES('85','admin','出行选天时地利 我国不同地区的最佳旅游时间','9','','出行选天时地利 我国不同地区的最佳旅游时间','出行选天时地利 我国不同地区的最佳旅游时间','<p>一般而言，一个地区的气候存在着相对稳定的年内变化。如海南岛的气候长夏无冬，昆明的气候四季如春，西安的气候四季分明，哈尔滨的气候长冬短夏，人们往往根据这种气候的年内变化，将其划分为不同的气候类型。我国东部地区纵跨四个热量带，南部差异显著，在东部城市旅游气候舒适性评价中，我们也借鉴了这种分类方法。根据各城市气候舒适度的年内变化，采用聚类分析方法，将城市旅游气候舒适性划分为3个类型，并以最舒适季节命名该类型，具体如下： <br />　　 <br />　　(1)夏适型气候，是指夏季温凉舒适，冬季寒冷不舒适的气候类型。主要分布在我国北部高纬度地区，即北纬40.6&deg;以北的省区和城市，包括哈尔滨、长春、延边、沈阳、承德、大连，这5 个城市冬季寒冷，综合气候舒适度低，夏季气候舒适凉爽，适宜于旅游活动，是夏季避暑的最佳去处，每年5-9 月是旅游最佳时期，舒适期多为6 个月，不舒适期较长。 <br />　　 <br />　　(2)春秋舒适型，指春秋季气候适宜，冬季寒冷、夏季炎热的气候类型。主要分布在北纬24.5～39.8&deg;的广大地区，包括北京、天津、石家庄、济南、青岛、连云港、南京、苏州、上海、杭州、温州、福州、厦门等14 个城市，这些城市冬季较寒冷，夏季较炎热，气候舒适度较低，较不适宜旅游；春秋季舒适度高，且持续时间较长，适宜旅游活动。舒适期多在4-6 月和9-0 月，不舒适期多在1-2 月和12 月，舒适期一般为5-6 个月，不舒适期较短，尤其南京至厦门各城市，全年无不舒适期。 <br />　　 <br />　　(3)冬适型气候，指冬季气候舒适，夏季闷热的气候类型。主要分布在我国的南亚热带和热带地区，即北纬18.1～23.4&deg;之间，包括汕头、广州、深圳、珠海、湛江、海口、三亚等城市，这7 个城市冬季气候温暖，舒适度高，是冬季旅游的好去处；夏季气候闷热，舒适度低，较不适宜旅游。舒适期多在1-4 月和11-12 月，较不舒适期多在6-9 月，除珠海、海口和三亚之外，其他各城市均无不舒适期。舒适期一般为6 个月，最长可达8 个月。三亚常夏无冬，夏半年气候炎热，舒适期更短为4 个月。</p>','1276709043','zh_CN','-1','-1','1','{member}{admin}{guest}','2','3','0','');
INSERT INTO ss_articles(`id`,`author`,`title`,`i_order`,`source`,`tags`,`intro`,`content`,`create_time`,`s_locale`,`pub_start_time`,`pub_end_time`,`published`,`for_roles`,`v_num`,`article_category_id`,`is_seo`,`description`) VALUES('86','admin','夏季参加户外运动注意事项 ：防晒至关重要','10','','夏季参加户外运动注意事项 ：防晒至关重要','夏季参加户外运动注意事项 ：防晒至关重要','<p><strong>1、防晒</strong></p><p>　　夏季进行海岸线穿越或者是登山，阳光相当强烈，务必要注意防晒。一般来说，队伍在早晨出发，到达出发地点已经是将近中午，队伍前进时间不长，已经是正午时分。这个时候的气温最高，骄阳似火，阳光中的紫外线特别强烈，皮肤长时间暴露在烈日下，会造成1~2度的灼伤，并会发生中暑现象。紫外线还可以透过皮肤、骨骼，辐射到脑膜、视网膜，使大脑和眼球受到损伤。</p><p>　　应对措施：高温天气下应尽量避免走海岸线和山脊上的防火带。参加一般的活动一定要带上太阳帽、墨镜、防晒霜、毛巾，穿长袖上衣，并带上十滴水、人丹、藿香正气丸、清凉油等防暑药品。</p><p><strong>　　2、饮水</strong></p><p>　　夏季户外运动出汗多，必须及时补充水分，但如果饮水方式不对，会引发不良的后果。很多饮料广告中的模特，在运动中或休息时，往往拿起一瓶饮料一饮而尽，看起来很解渴，实际上从运动生理学的角度上来说，是非常有害的。运动中和运动后大量饮水，会给血液循环系统、消化系统，特别是给心脏增加负担，造成更加疲劳。大量饮水的结果只会是出汗更多，导致盐分进一步流失，引发痉挛、抽筋。</p><p>　　应对措施：少量多次，每次喝水只喝几口，喝水的次数频繁一些，不要依赖口渴的感觉作为补充水分的依据，不渴的时候也要补充水分，让水分均衡地补充。不要一次大量饮水，但不是控制补充水分，如果水分大量流失得不到补充，严重的会引发肾衰竭。</p><p>　　一般来说，南宁周边夏季一天的活动（5-8个小时），至少需要2-3升以上的饮用水，高温情况下甚至需要6升水。建议携带量：600毫升的瓶装水4支以上，550毫升的运动饮料（葡萄适或佳的乐）1支以上，榨菜50克。也可以自己调配运动饮料，配方：绿茶或红茶若干（袋装的2小包）、果珍等水果味粉状冲饮料若干、葡萄糖若干、食用盐少许（可选项，医用的生理盐最佳）。</p><p>　<strong>　3、热病（热衰竭、中暑）</strong></p><p>　　夏季参加户外运动，由于气温高，运动量大，身体内的热量积累的比散发的多，如果不注意防范，就很容易发生热病，热病轻微的为热衰竭，严重的就是热中风（也就是中暑）。在高温天气下运动，人的身体为了降低体温，皮肤的血管会膨胀，而且会因大量排汗而导致失水现象的发生，循环到脑部以及其他重要部位的血液会降低到不正常的程度。结果会发生以下症状：脉搏加快、皮肤湿冷、眩晕、虚弱、恶心，这就是热衰竭。如果不及时处理降温，体内的温度进一步积累而使身体的关键器官温度上升到危险的地步，就会出现紧急症状：脉搏极快、虚弱、头疼、心理状态改变（意识模糊或是无法配合，慢慢陷入昏迷）、皮肤热烫而泛潮红，这说明已经发生中暑，如果不及时处理，会有生命危险。</p><p>　　应对措施：由于活动中为了防晒和防止身体被茅草、荆棘拉伤，行军中需要戴帽子、穿长衣长裤，但这样就带了散热的问题。为帮助体温散发，在阳光下行走时，可以用水把帽子浸湿；在阳光照射不到的地方行走时，把帽子去掉；休息的时候，尽量把背包放下来，把上衣领口纽扣解开一些；休息的地点最好是太阳晒不到和通风的地方。</p><p>　　行军途中要注意节奏，一次行走不宜超过一个小时，高温情况下30分钟左右休息一次，根据具体情况休息5至15分钟，以免脉搏过快、体温过高和大量出汗引发中暑。另外，一路上必须要注意补充水、盐份和电解质，带齐防暑药品。</p><p>　　如果肌肉发生抽筋，马上找地方休息，在抽筋的部位按摩，慢慢地将抽筋部位的肌肉舒缓伸展开来，最重要的是及时补充水分和电解质。</p><p>　　当出现热衰竭以后，必须马上休息，最好是找一个阴凉的地方，把患者的双脚抬高，头部稍微放低，立即补充水分和电解质以及流质的东西，服下十滴水、人丹、藿香正气丸等防暑药品。</p><p>　　当出现热中风（中暑）现象，必须马上处理。患者可能会因为意识模糊而无法合作，必须把患者扶到阴凉的地方，采用蒸汽冷却法，把水均匀地洒到患者的身上、头上，并不断吹风，（最好有冰块，用毛巾包起来放在头上、身上降温）。等到身体温度恢复到正常体温，就不必再降温了。不过要继续观察患者的温度和身体状况，因为体温有可能会再度升高而需要再次实施降温。如果患者的呕吐反射能力和吞咽能力没有问题，可以给患者喝冰凉的流质物体，补充水分和电解质以及流质的东西，服下十滴水、人丹、藿香正气丸等防暑药品。</p><p>　　一般来说，大部分的热衰竭患者，经过处理恢复正常以后，基本上可以继续完成后续的活动。严重的中暑患者，除非恢复的很好，建议找人陪伴让患者退出活动。</p><p><strong>　　4、热伤风</strong></p><p>　　夏季在高温下运动，人体内部产热快，皮肤的毛细血管大量扩张，以利于身体散热。如果遭遇到过冷刺激，会使体表已经开放的毛孔突然关闭，造成身体内脏器官功能紊乱，大脑体温调节失常，导致生病，通常会发生&ldquo;热伤风&rdquo;，也就是夏季感冒，甚至会导致更严重的疾病。</p><p>　　应对措施：夏季行军途中，大汗淋漓的情况下，如果有山泉水、溪流、池塘等，或者是途经海边，千万不能贪图一时凉快而立即跳下去洗凉水澡。即使活动结束，到达目的地以后，也要等身体温度降下来以后再洗凉水澡。活动结束以后，如果大家返程的车辆是空调车或者在空调房里，务必不能打开空调直接对着身体吹，最好是打开车窗户用自然风降温，等身体温度降下来以后再开空调。</p><p>　　<strong>5、冷饮</strong></p><p>　　夏季参加户外活动，如果有冰镇饮料吃，是一件很享受的事，但活动中或者是活动结束以后，不能马上大量吃冷饮。冷饮不仅降低了胃的温度，而且也冲淡了胃液，使胃的生理机能受损，轻则引起消化不良、腹泻等，重则导致急性胃炎。</p><p>　　应对措施：少量摄入冷饮对降温有利，但不能过量，要根据具体情况具体对待。大家出发前带的冰冻饮料等，要少量多次地饮用。活动结束以后，要等身体温度大幅度降下来以后，才喝冰冻的饮料或啤酒等。</p><p>　　<strong>6、衣服</strong></p><p>　　夏季户外运动大量出汗，衣服很快就湿透了，很多人到达目的地以后，往往任凭衣服湿着，企图靠自己的体温把衣服烤干。这样做是极其有害的，长此以往，会引发风湿或关节炎等疾病。</p><p>　　应对措施：参加活动前，在背包里带上一套备换的贴身干衣服（特别是上衣）和一件外套，到了目的地以后，即刻把湿衣服换下来。活动途中休息的时候，在风很大的情况下，如果休息的时间较长，要及时穿上外套，否则风会把身体的热量大量带走，人的身体冷热交替，很容易引发疾病。</p><p>　　为方便汗水挥发和散热，去户外活动的外衣最好买化纤成分的快干服装，最佳的是快干并防紫外线的衣服，裤腿最好可以拆卸下来。</p>','1276709287','zh_CN','-1','-1','1','{member}{admin}{guest}','1','3','0','');
INSERT INTO ss_articles(`id`,`author`,`title`,`i_order`,`source`,`tags`,`intro`,`content`,`create_time`,`s_locale`,`pub_start_time`,`pub_end_time`,`published`,`for_roles`,`v_num`,`article_category_id`,`is_seo`,`description`) VALUES('87','admin','出行常识：如何在野外判断方向和选择路径','11','','出行常识：如何在野外判断方向和选择路径','出行常识：如何在野外判断方向和选择路径','<p>在野外活动，诸如地质考察、登山、徒步旅行、探险、旅游等，为防止迷路，正确地判定所在位置和方向，必须掌握定位和侧向方法。在自然界，某些动物具有辨别方向的本能，如鸽子，人类的某些成员也具备这种能力，但绝大多数人不具备，或者只有这种潜能，因此野外确定方向主要依靠经验和工具。</p><p>　　野外判定方向和位置的方法有许多，这里介绍几种常见的方法。</p><p>　　<strong>利用罗盘（指北针）</strong></p><p>　　把罗盘或指北针水平放置使气泡居中，此时磁针静止后，其标有&ldquo;N&rdquo;的黑一端所指的便是北方。除了测出正北方向外，罗盘或指北针还可以测出某一目标的具体方位，方法是开罗盘将照准器对准目标，或将刻度盘上的0刻度对准目标，使目标、0刻度和磁中点在同一直线上，罗盘水平静止后，N端所指的刻度便是测量点至目标的方位，如磁针N端指向36&deg;。则目标在测量位置的北偏东36&deg;。</p><p>　　利用罗盘或指北针辨别方向虽然简单快捷，但需要注意：1、尽量保持水平；2、不要离磁性物质太近；3、勿将磁针的S端误作北方，造180&deg;的方向误差；4、掌握活动地区的磁偏角进行校正。</p><p>　　<strong>利用太阳</strong></p><p>　　在晴朗的白昼，根据日出、日落就可以很方便地知道东方和西方，也就可判断方，但只能是大致的估计，较准确的测定有下列几种方法：1、手表测向&ldquo;时数折半对太阳，12指的是北方&rdquo;，一般在上午9时至下午4时之间可以很快地辨别出方向，用时间的一半所指的方向对向太阳，12时刻度就是北方，如下午14:40的时间，其一半为7:20，把时针对向太阳，那么12指的就是北方，或者是把表平置，时针指向太阳，时针与12时刻度平分线的反向延伸方向就是北方；或者置手表，将一根小棍垂直立在手表中央转动手表，使小棍的影子与时针重合，时针与12时刻度之间的平分线即是北方。</p><p>　　必须注意：（1）判定方向时，手表应平置；（2）在南、北纬20&deg;30&prime;之间地区的中午前后不宜使用，即以标准时的经线为准，每向东15&deg;加1小时，向西15&deg;减1小时。2、日影测向为晴天，在地上竖立一木棍，木棍的影子随太阳位置的变化而移动，这些影在中午最短，其末端的连线是一条直线，该直线的垂直线为南北方向。在一张50&times;50cm的绘图纸上绘制一系列同心圆，同心圆的半径以1cm递增，钉在平板上并水平固定好，将一根12-15cm长的细钢针或针状物垂直插在圆心上。当太阳位置变化时，影子的端点总会与同心圆相交，标绘出这些点，然后把同一个圆上的两点直线相连，把这些直线的中点与圆心相连，这条连线就是南北方向线，圆弧顶的方向为北方。</p><p>　　<strong>夜间星体</strong></p><p>　　当夜晚时，可根据北极星和南十字星来判断方向。</p><p>　　1、北极星：北极星位于正北天空，其出露高度角相当于当地纬度，据此可以很快找到北极星。通常根据北斗七星（大熊星座）或W星（仙后星座）确定。北斗星为七颗较亮的星，形状象一把勺子，将勺头两颗&beta;向&alpha;连线并延伸约5倍处便是北极星。当看不到北斗星时，可根据W星，即仙后星座寻找北极星。仙后星座由五颗较亮的星组成，形状象&ldquo;W&rdquo;字母，字母的开口方向约开口宽度的两倍距离处是北极星。</p><p>　　2、南十字星：在北纬23&deg;30&prime;以南地区，夜间有时可见南十字星，由四颗较亮的星组成，形同&ldquo;十&rdquo;字，在其右下方，由&gamma;向&alpha;两星连线长度的四倍半处（无星）为正南方向。</p><p>　　<strong>地物和植物特征</strong></p><p>　　有时野外的一些地物和植物生长特征是良好的方向标志，增加这方面的知识可以帮助你快速地辨别方向。</p><p>　　1、地物特征：</p><p>　　a.房屋：一般门向南开，我国北方尤其如此；</p><p>　　b.庙宇：通常也是向南开门，尤其庙宇群中的主体建筑；</p><p>　　c.突出地物：向北一侧基部较潮湿并可能生长低矮的苔藓植物。</p><p>　　2、植物生长特征：</p><p>　　a.一般阴坡，即北侧山坡，低矮的蕨类和藤本植物比阳面更加发育。</p><p>　　b.单个植物的向阳面枝叶较茂盛，向北的阴地树干则可能生长苔藓。</p><p>　　c.我国北方的许多树木树干的断面可见清晰的年轮，向南一侧的年轮较为疏稀，向北一侧则年轮较紧密。</p>','1276709318','zh_CN','-1','-1','1','{member}{admin}{guest}','3','3','0','');
INSERT INTO ss_articles(`id`,`author`,`title`,`i_order`,`source`,`tags`,`intro`,`content`,`create_time`,`s_locale`,`pub_start_time`,`pub_end_time`,`published`,`for_roles`,`v_num`,`article_category_id`,`is_seo`,`description`) VALUES('88','admin','细节不可小视 35条必须记住的户外旅游常识','12','','细节不可小视 35条必须记住的户外旅游常识','细节不可小视 35条必须记住的户外旅游常识','<p>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp; 1、尽量不要在没有固定的岩石上，站立着弯腰伸手去拉下面和你体重相当的的人；要身体向后，手的拉力尽量贴近腿的蹬力作用线，或者身后有粗树或人手可以固定自己；或用段绳索。</p><p>　　2、尽量不要两个人手握手，从下往上拉人；要彼此手握对方的手腕。</p><p>　　3、尽量不要借助枯枝或杂草或直径小于自己拇指粗细的树枝等的拉力攀岩；只能够借助大于自己拇指粗细的有根基树枝的拉力攀爬。</p><p>　　4、尽量不要借助小于自己手腕粗细的树枝做单杠，吊拉弯曲树枝来上升或下降，容易折断；要采用大于手腕粗细的树枝，或者尽量贴近受力树枝根部（靠主干处）。</p><p>　　5、尽量不要借助高于自己头部的并且不能判断是否坚固的岩石攀登，把自己的生命吊挂在不了解的岩石上是极其危险的；应该先三点固定，用一个肢体的力量去验证后再行动。</p><p>　　6、尽量不要在攀爬碎石多、冰雪多、易滑落的山坡时，相邻队员的距离太近；要留出比平时多2个人的间距，以防下面的人被砸伤。</p><p>　　7、尽量不要在易滑的山坡下山时间距太小；要等到前面的人安全到底后，后面的人才可以下山；有条件的话，前面的人可以为后面的人作一下保护。</p><p>　　8、尽量不要让自己的登山鞋底上有泥沙、植物叶子、水、雪等降低摩擦系数的物质；已经有了这些物质，你在攀登巨大山石时，你最多只能攀登的原来斜坡的三分之二的坡度，不然你的脚上会打滑。</p><p>　　9、尽量不要在疲劳而且背负较重行李的较陡的山坡上休息时，过急地直腰后仰休息；如果疲惫，最好停下脚步别直腰，转身后背靠山体，直腰休息。避免后仰滚下山去。</p><p>　　10、尽量不要在钻丛林时前后离得太近，回弹的荆棘容易刺伤你的双眼；低头用帽檐遮挡，或者用登山杖等防护双眼。</p><p>　　11、尽量不要在钻丛林或石林时，只知道低头弯腰，结果头过去了，包和臀部过不去；要下蹲，弯腰，低头，伸双臂，向前爬行；然后前视，待臀部通过后，才可以抬头，直腰，站立。</p><p>　　12、尽量不要脚踩被草覆盖，看不清下面虚实的羊肠小道；要争取跨越过去或者绕过去；否则，你可能掉下山坡或深坑里。</p><p>　　13、尽量不要在夏秋季节做开路人，除非你会打草惊蛇，或者你很警觉很善于发现道路上的蛇并有办法对付它。</p><p>　　14、尽量不要独自上山，如果上了，就要时常地做好路标；实在不行退回来。</p><p>　　15、尽量不要给110等打电话，因为他们对山的了解远不如经常爬山的驴友们。你可以给他们打电话。如果没有电话也不要惊慌失措。在山里面，春夏秋三个季节里，正常人一宿不睡觉不吃饭，冻不死也饿不死。你只要沿着一个峡谷，顺流而下。</p><p>　　16、尽量不要长时间、连续地向下蹦，除非你经常做这种运动；如果你参加了这种活动，建议你尽量采用悬吊式下蹦，或者是用登山杖支撑下部后悬挂身体下蹦，降低了高度，减少冲击，避免膝关节伤害。一天下来你可能比同路人少跳了三分之一。</p><p>　　17、尽量不要在大雨过后，徒步涉水过水位超过裆部的河水。水火无情，这和你游泳的水平无关。如果非过不可而且没有绳索等过河装备，要尽量选择河宽水缓水较浅、河底较平缓的地方，寻找一块大石头抱在怀中，逆流小弓步，不抬脚，贴河底，缓挪步过河。</p><p>　　18、尽量不要在下雷雨爬山时，开手机或拨打手机；上帝会叫你去他那里。</p><p>　　19、尽量不要在雨后爬或经过泥石混合的地质构造地段。</p><p>　　20、尽量不要使用比自己小拇指还细的普通绳索来垂直吊拉自己；只能作为辅助吊拉使用。</p><p>　　21、尽量不要攀爬自己感到犹豫不决的岩石，要舍得；如果非爬不可，必须想好我万一失手的应急对策并且不后悔时，才可以攀登。</p><p>　　22、尽量不要在冰雪天下山时，独自向山下滑行；最好两人一组10米左右的绳索，上面的人拉绳释放另一人下山；然后上面的人，自行下滑，下面的人作保护，用绳索拉住他，不让他冲下山；轮流交替，互相保护。</p><p>　　23、尽量不要一边爬山一边看景；你很可能失足又失身。</p><p>　　24、尽量不要一心跟着头驴赶路；你要15分钟左右停下几秒钟回头环顾四周，寻找参考系，多记路。别丢了都不知道回家。</p><p>　　25、尽量不要在爬山的时候，与别人和自己较劲；面对你自己无能的对危险和困难，要敢于说&ldquo;我不行，我得绕着走&rdquo;。</p><p>　　26、尽量不要在爬山爬得满身大汗的时候，突然跳进水里去游泳；也不要迎着风口，图凉快。</p><p>　　27、尽量不要钻你不熟悉山洞，尤其是出口少的山洞而且没有靠得住的朋友给你守门；俗语说狡兔还三窟，何况人呢？记住安全第一。</p><p>　　28、尽量不要负重下山时跑步，惯性可能让你冲到山下，受伤。</p><p>　　29、尽量不要因胆小而在陡坡上，采用两脚靠近小碎步，正面下山坡；这样非常容易后仰摔倒，然后坐滑梯冲下山，危险。你可以采用侧身，深蹲，侧压腿（侧弓步）式，挪步下山；这样安全又快捷。</p><p>　　30、尽量不要在爬山过程中，两腿发抖或眼前发晕或呼吸艰难的时候，继续坚持爬山；应该立刻通报领队，或者告诉身边的朋友。</p><p>　　31、尽量不要在山上用火，尤其是明火；除非你想把自己也当烤全羊。</p><p>　　32、尽量不要在山上乱丢垃圾，除非你想爬垃圾山。</p><p>　　33、尽量不要走在队伍的首或尾，最好集合时，主动要动领队的手机号码。</p><p>　　34、尽量不要在活动过程中，怨天尤人，因为没有人逼你或者骗你或者求你来参加这种民间的、非盈利的有风险的活动。</p><p>　　35、尽量不要在活动中过分依赖别人，多交流多请教，多自立多观察，多帮助多谅解。</p>','1276709360','zh_CN','-1','-1','1','{member}{admin}{guest}','3','3','0','');
INSERT INTO ss_articles(`id`,`author`,`title`,`i_order`,`source`,`tags`,`intro`,`content`,`create_time`,`s_locale`,`pub_start_time`,`pub_end_time`,`published`,`for_roles`,`v_num`,`article_category_id`,`is_seo`,`description`) VALUES('89','admin','黑皮肤也要防晒 防晒认清SPF和PA之含义','13','','黑皮肤也要防晒 防晒认清SPF和PA之含义','黑皮肤也要防晒 防晒认清SPF和PA之含义','<p>在户外活动中防晒非常重要的自己保护措施，令许多&ldquo;驴友&rdquo;感到困惑：防晒品上标有防晒指数SPF和PA，不知自己该如何选择。</p><p>　　<strong>购买：</strong></p><p>　　适合自己就是好的</p><p>　　河南中医学院一附院皮肤科专家余冰副教授说，SPF分别是防光系数和长波紫外线防护等级的英文缩写，是国际通用标准。客观地说，防晒指数的高低能够反映出防晒产品对紫外线防护能力的大小。这两个数值越高，防晒效果越好。然而需要注意的是，防护系数越高，防晒品的致敏性就越高，容易引起接触性皮炎，出现涂抹部位的丘疹、瘙痒等。</p><p>　　通常防晒品的最低防晒指数为SPF2-6，中等防晒指数为6-8，SPF12-20范围内的产品为高强防晒品，SPF值在20-30之间的产品为超高强防晒品。</p><p>　　关于如何选购适合自己使用的防晒品，推荐以下三个标准。以室内工作为主的人，宜选用SPF10左右、PA＋的防晒品；室外工作者建议使用SPF20左右、PA＋＋的防晒品；烈日下活动及进行海水浴时，宜使用耐水性好的防晒品，SPF30左右、PA＋＋＋的制品。当然，防护系数高的防晒品对日光性皮炎有较好的防治作用，对雀斑、黄褐斑有防止色素加深的作用。</p><p>　　<strong>误区：</strong></p><p>　　黑皮肤无须防晒</p><p>　　很多人由于开始不注意防晒，皮肤变黑，认为再涂防晒霜已经没有用了。专家提醒您，当皮肤有变黑、干燥、脱皮和缺水的现象时，就表示肌肤已经被晒伤了，这时更需要防晒品的呵护，同时配合使用一些晒后修护类产品。</p><p>　　夏季的皮肤科门诊，经常见到一些患有日光性皮炎、日光性荨麻疹的病人前来诉苦。他们说，防晒霜对他们无效，用了等于没用。专家认为，不是防晒霜没用，而是他们使用的剂量不够。</p><p>　　许多人认为，只要使用防晒化妆品，就可以防光了。其实这是一个误区，防晒用品的防光效果与它的实际涂布量密切相关。防晒品测定方法中规定的涂布量是每平方厘米２毫克，而实际调查发现，大多数人的使用量仅为０．５毫克，即仅用了１／４的量。当涂布量减半时，其防光效果就下降５０％～６０％。这就是许多人涂了防晒霜照样被晒黑、晒伤的原因。</p><p>　　<strong>建议</strong>：</p><p>　　随身带一瓶防晒乳</p><p>　　为了使防晒用品真正起到防晒作用，专家建议，涂抹时要注意用够量。为了使皮肤有充足的吸收时间，要在出门前半小时使用。由于防晒品吸收紫外线有一定的饱和度，户外活动者要随身带一瓶防晒乳，每隔两小时重复涂抹一次。不光是面部，手臂、颈部等裸露处均要涂抹，眼睛周围也要涂上专用的防晒眼霜。若面部或眼睛被晒伤，应及时用冰水或冰黄瓜冷敷。</p><p>　　最后强调一下，防晒化妆品不只是年轻人的专利。由于紫外线可使皮肤胶原分解，促使皮肤老化，产生皱纹，所以，对于中老年人来说，选择保湿防晒的化妆品更重要。</p>','1276709415','zh_CN','-1','-1','1','{member}{admin}{guest}','7','3','0','');
INSERT INTO ss_articles(`id`,`author`,`title`,`i_order`,`source`,`tags`,`intro`,`content`,`create_time`,`s_locale`,`pub_start_time`,`pub_end_time`,`published`,`for_roles`,`v_num`,`article_category_id`,`is_seo`,`description`) VALUES('90','admin','户外急救：两根竹子一根绳就地取材学做担架','14','','户外急救：两根竹子一根绳就地取材学做担架','户外急救：两根竹子一根绳就地取材学做担架','<p>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp; 昨日上午11点半，人民公园门口围着一群身穿橘黄色马甲的人，他们是成都市综合应急志愿者服务队的部分成员，在学习一些面对突发事故时的抢救措施。</p><p>　　一名山地救援队的人员正教大家怎么使用担架。</p><p>　　&ldquo;在户外运动中有人受伤，或者遇到突发事故，搬运伤员需要准备合适的担架。&rdquo;救援人员说完，就演示起来。</p><p><br />　　他拿起两根长约2米多的竹子，并排相隔30厘米放好，然后拿起一根20米长的绳子，开始在两根竹子上绕着打结，但不是牢固固定，绳子放得比较松散。</p><p>　　等缠绕完20多个结后，救援人员开始给每个结点做固定。&ldquo;这样能保证各段绳子用力均衡。&rdquo;他说。</p><p>　　不到十分钟，担架做成了。除了竹子，门板、木头也可以拿来用，只要足够结实，就能撑起伤员。</p><p>　　除了11个成员队，还有市民队，他们通过报名组织起来，有比较丰富的户外知识，而且乐意做志愿工作。平时这些队员会做一些交通协管、维护秩序等志愿工作。</p>','1276709460','zh_CN','-1','-1','1','{member}{admin}{guest}','11','3','0','');

DROP TABLE IF EXISTS ss_background_musics;
CREATE TABLE `ss_background_musics` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `music_path` varchar(255) NOT NULL,
  `play` int(11) NOT NULL DEFAULT '1',
  `music_name` varchar(255) NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;


DROP TABLE IF EXISTS ss_backups;
CREATE TABLE `ss_backups` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `create_time` bigint(20) NOT NULL,
  `file_name` varchar(255) NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=MyISAM AUTO_INCREMENT=9 DEFAULT CHARSET=utf8;

INSERT INTO ss_backups(`id`,`create_time`,`file_name`) VALUES('1','1276687191','D:\\wwwroot\\yundong10a1\\wwwroot/sql/backup/1.sql');
INSERT INTO ss_backups(`id`,`create_time`,`file_name`) VALUES('2','1276709974','D:\\wwwroot\\yundong10a1\\wwwroot/sql/backup/2.sql');
INSERT INTO ss_backups(`id`,`create_time`,`file_name`) VALUES('3','1277224747','D:\\wwwroot\\yundong10a1\\wwwroot/sql/backup/3.sql');
INSERT INTO ss_backups(`id`,`create_time`,`file_name`) VALUES('4','1277267759','D:\\wwwroot\\yundong10a1\\wwwroot/sql/backup/backup_20100623123508.sql');
INSERT INTO ss_backups(`id`,`create_time`,`file_name`) VALUES('5','1277920609','D:\\wwwroot\\yundong10a1\\wwwroot/sql/backup/backup_20100701015645.sql');
INSERT INTO ss_backups(`id`,`create_time`,`file_name`) VALUES('6','1277921385','D:\\wwwroot\\yundong10a1\\wwwroot/sql/backup/1.sql');
INSERT INTO ss_backups(`id`,`create_time`,`file_name`) VALUES('7','1277921491','D:\\wwwroot\\yundong10a1\\wwwroot/sql/backup/22.sql');
INSERT INTO ss_backups(`id`,`create_time`,`file_name`) VALUES('8','1277922450','D:\\wwwroot\\yundong10a1\\wwwroot/sql/backup/backup_20100701022728.sql');

DROP TABLE IF EXISTS ss_bulletins;
CREATE TABLE `ss_bulletins` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `title` varchar(255) NOT NULL,
  `content` text,
  `create_time` bigint(20) NOT NULL,
  `s_locale` varchar(50) NOT NULL,
  `pub_start_time` bigint(20) NOT NULL,
  `pub_end_time` bigint(20) NOT NULL,
  `published` enum('0','1') NOT NULL DEFAULT '1',
  `for_roles` varchar(50) NOT NULL DEFAULT '{guest}',
  PRIMARY KEY (`id`),
  KEY `title` (`title`),
  KEY `create_time` (`create_time`),
  KEY `s_locale` (`s_locale`),
  KEY `pub_start_time` (`pub_start_time`),
  KEY `pub_end_time` (`pub_end_time`),
  KEY `published` (`published`),
  KEY `for_roles` (`for_roles`),
  FULLTEXT KEY `content` (`content`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;


DROP TABLE IF EXISTS ss_delivery_addresses;
CREATE TABLE `ss_delivery_addresses` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `reciever_name` varchar(255) NOT NULL,
  `prov_id` varchar(6) NOT NULL,
  `city_id` varchar(6) NOT NULL,
  `dist_id` varchar(6) NOT NULL,
  `detailed_addr` text NOT NULL,
  `postal` varchar(6) NOT NULL,
  `phone` varchar(24) DEFAULT NULL,
  `user_id` int(11) NOT NULL,
  PRIMARY KEY (`id`),
  KEY `user_id` (`user_id`),
  KEY `prov_id` (`prov_id`),
  KEY `city_id` (`city_id`),
  KEY `dist_id` (`dist_id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;


DROP TABLE IF EXISTS ss_delivery_methods;
CREATE TABLE `ss_delivery_methods` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  PRIMARY KEY (`id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;


DROP TABLE IF EXISTS ss_download_categories;
CREATE TABLE `ss_download_categories` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `name` varchar(255) NOT NULL,
  `alias` varchar(255) NOT NULL,
  `i_order` int(11) NOT NULL DEFAULT '0',
  `s_locale` varchar(50) NOT NULL,
  `published` enum('0','1') NOT NULL DEFAULT '1',
  `for_roles` varchar(50) NOT NULL DEFAULT '{guest}',
  PRIMARY KEY (`id`),
  KEY `alias` (`alias`),
  KEY `i_order` (`i_order`),
  KEY `s_locale` (`s_locale`),
  KEY `published` (`published`),
  KEY `for_roles` (`for_roles`)
) ENGINE=MyISAM AUTO_INCREMENT=8 DEFAULT CHARSET=utf8;

INSERT INTO ss_download_categories(`id`,`name`,`alias`,`i_order`,`s_locale`,`published`,`for_roles`) VALUES('1','Uncategorised','uncategorized','0','_ALL','0','{admin}');
INSERT INTO ss_download_categories(`id`,`name`,`alias`,`i_order`,`s_locale`,`published`,`for_roles`) VALUES('7','easySite 下载','cad_Gm5U2bEh','0','zh_CN','1','{member}{admin}{guest}');

DROP TABLE IF EXISTS ss_downloads;
CREATE TABLE `ss_downloads` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `name` varchar(255) NOT NULL,
  `description` varchar(255) DEFAULT NULL,
  `create_time` bigint(20) NOT NULL,
  `pub_start_time` bigint(20) NOT NULL,
  `pub_end_time` bigint(20) NOT NULL,
  `s_locale` varchar(50) NOT NULL,
  `published` enum('0','1') NOT NULL DEFAULT '1',
  `for_roles` varchar(50) NOT NULL DEFAULT '{guest}',
  `download_category_id` int(11) NOT NULL,
  PRIMARY KEY (`id`),
  KEY `create_time` (`create_time`),
  KEY `s_locale` (`s_locale`),
  KEY `published` (`published`),
  KEY `for_roles` (`for_roles`),
  KEY `download_category_id` (`download_category_id`),
  FULLTEXT KEY `description` (`description`)
) ENGINE=MyISAM AUTO_INCREMENT=7 DEFAULT CHARSET=utf8;

INSERT INTO ss_downloads(`id`,`name`,`description`,`create_time`,`pub_start_time`,`pub_end_time`,`s_locale`,`published`,`for_roles`,`download_category_id`) VALUES('1','','','0','0','0','','1','{guest}','0');
INSERT INTO ss_downloads(`id`,`name`,`description`,`create_time`,`pub_start_time`,`pub_end_time`,`s_locale`,`published`,`for_roles`,`download_category_id`) VALUES('5','pic01.gif','最新下载','1265179044','-1','-1','zh_CN','1','{member}{admin}{guest}','0');
INSERT INTO ss_downloads(`id`,`name`,`description`,`create_time`,`pub_start_time`,`pub_end_time`,`s_locale`,`published`,`for_roles`,`download_category_id`) VALUES('6','aaa.jpg','最新下载2','1265187770','-1','-1','zh_CN','1','{member}{admin}{guest}','0');

DROP TABLE IF EXISTS ss_emails;
CREATE TABLE `ss_emails` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `title` varchar(100) NOT NULL,
  `content` text NOT NULL,
  `user_id` int(6) NOT NULL,
  `user_name` varchar(30) NOT NULL,
  `is_mail` tinyint(1) NOT NULL,
  `send_id` int(6) NOT NULL,
  `is_read` tinyint(1) NOT NULL,
  `is_ok` tinyint(1) NOT NULL DEFAULT '1',
  `create_time` varchar(20) NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=MyISAM AUTO_INCREMENT=42 DEFAULT CHARSET=utf8;


DROP TABLE IF EXISTS ss_friendlinks;
CREATE TABLE `ss_friendlinks` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `fl_name` varchar(50) DEFAULT NULL,
  `fl_img` varchar(50) DEFAULT NULL,
  `fl_addr` varchar(255) DEFAULT NULL,
  `s_locale` varchar(50) NOT NULL,
  `create_time` bigint(20) NOT NULL,
  `for_roles` varchar(50) NOT NULL DEFAULT '{guest}',
  `published` enum('0','1') NOT NULL DEFAULT '1',
  `fl_type` char(1) NOT NULL DEFAULT '1',
  PRIMARY KEY (`id`),
  KEY `for_roles` (`for_roles`),
  KEY `s_locale` (`s_locale`),
  KEY `published` (`published`),
  KEY `create_time` (`create_time`)
) ENGINE=MyISAM AUTO_INCREMENT=3 DEFAULT CHARSET=utf8;

INSERT INTO ss_friendlinks(`id`,`fl_name`,`fl_img`,`fl_addr`,`s_locale`,`create_time`,`for_roles`,`published`,`fl_type`) VALUES('1','cz128.com','cndns.gif','http://www.cz128.com','zh_CN','1265177355','{member}{admin}{guest}','1','1');
INSERT INTO ss_friendlinks(`id`,`fl_name`,`fl_img`,`fl_addr`,`s_locale`,`create_time`,`for_roles`,`published`,`fl_type`) VALUES('2','cz128.com','sitestar.gif','http://www.cz128.com/','zh_CN','1265177378','{member}{admin}{guest}','1','1');

DROP TABLE IF EXISTS ss_languages;
CREATE TABLE `ss_languages` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `name` varchar(50) NOT NULL,
  `locale` varchar(50) NOT NULL,
  `published` enum('0','1') NOT NULL DEFAULT '1',
  PRIMARY KEY (`id`),
  UNIQUE KEY `locale` (`locale`)
) ENGINE=MyISAM AUTO_INCREMENT=3 DEFAULT CHARSET=utf8;

INSERT INTO ss_languages(`id`,`name`,`locale`,`published`) VALUES('2','简体中文','zh_CN','1');

DROP TABLE IF EXISTS ss_marquees;
CREATE TABLE `ss_marquees` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `module_id` int(11) NOT NULL DEFAULT '0' COMMENT '模块id',
  `marquee_type` enum('text','pic','picText') NOT NULL DEFAULT 'pic' COMMENT '走马灯类型',
  `title` varchar(255) NOT NULL,
  `pic` varchar(255) NOT NULL,
  `flag` enum('1','2','3') NOT NULL DEFAULT '1' COMMENT '1自定义2是库',
  `link` varchar(255) NOT NULL COMMENT '链接地址',
  PRIMARY KEY (`id`)
) ENGINE=MyISAM AUTO_INCREMENT=113 DEFAULT CHARSET=utf8;

INSERT INTO ss_marquees(`id`,`module_id`,`marquee_type`,`title`,`pic`,`flag`,`link`) VALUES('1','172','pic','户外冲锋衣服','upload/image/f8oHF6lK.jpg','2','1');
INSERT INTO ss_marquees(`id`,`module_id`,`marquee_type`,`title`,`pic`,`flag`,`link`) VALUES('2','172','pic','户外防护服装','upload/image/sVSGNYuR.jpg','2','2');
INSERT INTO ss_marquees(`id`,`module_id`,`marquee_type`,`title`,`pic`,`flag`,`link`) VALUES('3','172','pic','户外裤冲锋裤登山裤','upload/image/Cq7t3XuA.jpg','2','3');
INSERT INTO ss_marquees(`id`,`module_id`,`marquee_type`,`title`,`pic`,`flag`,`link`) VALUES('4','172','pic','丛林户外帽子','upload/image/brzWd0Vn.jpg','2','4');
INSERT INTO ss_marquees(`id`,`module_id`,`marquee_type`,`title`,`pic`,`flag`,`link`) VALUES('5','172','pic','防紫外線戶外帽','upload/image/KnpB0yRK.jpg','2','5');
INSERT INTO ss_marquees(`id`,`module_id`,`marquee_type`,`title`,`pic`,`flag`,`link`) VALUES('6','172','pic','网布透气户外鞋','upload/image/ISGqgS28.jpg','2','6');
INSERT INTO ss_marquees(`id`,`module_id`,`marquee_type`,`title`,`pic`,`flag`,`link`) VALUES('7','172','pic','头层牛皮 户外鞋','upload/image/AOJxBVq6.jpg','2','7');
INSERT INTO ss_marquees(`id`,`module_id`,`marquee_type`,`title`,`pic`,`flag`,`link`) VALUES('8','172','pic','登山徒步鞋','upload/image/IpK0F4Hs.jpg','2','8');
INSERT INTO ss_marquees(`id`,`module_id`,`marquee_type`,`title`,`pic`,`flag`,`link`) VALUES('9','172','pic','户外帐篷SY','upload/image/X6wabvgg.jpg','2','9');
INSERT INTO ss_marquees(`id`,`module_id`,`marquee_type`,`title`,`pic`,`flag`,`link`) VALUES('10','172','pic','铝杆帐篷','upload/image/ue0NbPSS.jpg','2','10');
INSERT INTO ss_marquees(`id`,`module_id`,`marquee_type`,`title`,`pic`,`flag`,`link`) VALUES('11','172','pic','多人帐篷','upload/image/owkRnqSg.jpg','2','11');
INSERT INTO ss_marquees(`id`,`module_id`,`marquee_type`,`title`,`pic`,`flag`,`link`) VALUES('12','172','pic','双层帐篷','upload/image/q6gp28gq.jpg','2','12');
INSERT INTO ss_marquees(`id`,`module_id`,`marquee_type`,`title`,`pic`,`flag`,`link`) VALUES('13','172','pic','双人睡袋','upload/image/VIcAiU1J.jpg','2','13');
INSERT INTO ss_marquees(`id`,`module_id`,`marquee_type`,`title`,`pic`,`flag`,`link`) VALUES('14','172','pic','春夏单人迷彩睡袋','upload/image/SltSNcZX.jpg','2','14');
INSERT INTO ss_marquees(`id`,`module_id`,`marquee_type`,`title`,`pic`,`flag`,`link`) VALUES('15','172','pic','戴帽式睡袋','upload/image/8jVxUVd0.jpg','2','15');
INSERT INTO ss_marquees(`id`,`module_id`,`marquee_type`,`title`,`pic`,`flag`,`link`) VALUES('16','172','pic','超轻夏季睡袋','upload/image/Mz3Y4VOm.jpg','2','16');
INSERT INTO ss_marquees(`id`,`module_id`,`marquee_type`,`title`,`pic`,`flag`,`link`) VALUES('17','172','pic','背包','upload/image/LMXWyZQs.jpg','2','17');
INSERT INTO ss_marquees(`id`,`module_id`,`marquee_type`,`title`,`pic`,`flag`,`link`) VALUES('18','172','pic','登山包','upload/image/EHHBAh3N.jpg','2','18');
INSERT INTO ss_marquees(`id`,`module_id`,`marquee_type`,`title`,`pic`,`flag`,`link`) VALUES('19','172','pic','登山包KA','upload/image/fVg1tl08.jpg','2','19');
INSERT INTO ss_marquees(`id`,`module_id`,`marquee_type`,`title`,`pic`,`flag`,`link`) VALUES('20','172','pic','双肩户外旅行包','upload/image/Pc6hlC3l.jpg','2','20');
INSERT INTO ss_marquees(`id`,`module_id`,`marquee_type`,`title`,`pic`,`flag`,`link`) VALUES('21','172','pic','户外旅行包','upload/image/lEfTOIN2.jpg','2','21');
INSERT INTO ss_marquees(`id`,`module_id`,`marquee_type`,`title`,`pic`,`flag`,`link`) VALUES('22','172','pic','户外休闲旅行包','upload/image/fXGrLjSU.jpg','2','22');
INSERT INTO ss_marquees(`id`,`module_id`,`marquee_type`,`title`,`pic`,`flag`,`link`) VALUES('23','172','pic','手提双肩多功能包','upload/image/KMCjdwA3.jpg','2','23');
INSERT INTO ss_marquees(`id`,`module_id`,`marquee_type`,`title`,`pic`,`flag`,`link`) VALUES('24','172','pic','军用迷彩包','upload/image/MLaKXXiB.jpg','2','24');
INSERT INTO ss_marquees(`id`,`module_id`,`marquee_type`,`title`,`pic`,`flag`,`link`) VALUES('25','172','pic','防风野营气炉','upload/image/tjJqJ4yl.jpg','2','25');
INSERT INTO ss_marquees(`id`,`module_id`,`marquee_type`,`title`,`pic`,`flag`,`link`) VALUES('26','172','pic','便携式可拆卸炉头','upload/image/u5FzpLhN.jpg','2','26');
INSERT INTO ss_marquees(`id`,`module_id`,`marquee_type`,`title`,`pic`,`flag`,`link`) VALUES('27','172','pic','德式饭盒','upload/image/WAnmsmK1.jpg','2','27');
INSERT INTO ss_marquees(`id`,`module_id`,`marquee_type`,`title`,`pic`,`flag`,`link`) VALUES('28','172','pic','户外套锅','upload/image/e9t2EkqX.jpg','2','28');
INSERT INTO ss_marquees(`id`,`module_id`,`marquee_type`,`title`,`pic`,`flag`,`link`) VALUES('29','172','pic','野营气炉','upload/image/Nj29uhIX.jpg','2','29');
INSERT INTO ss_marquees(`id`,`module_id`,`marquee_type`,`title`,`pic`,`flag`,`link`) VALUES('30','172','pic','压盖式压力锅','upload/image/Ly8InvLW.jpg','2','30');
INSERT INTO ss_marquees(`id`,`module_id`,`marquee_type`,`title`,`pic`,`flag`,`link`) VALUES('31','172','pic','野炊烧烤炉','upload/image/mmliR6v5.jpg','2','31');
INSERT INTO ss_marquees(`id`,`module_id`,`marquee_type`,`title`,`pic`,`flag`,`link`) VALUES('32','172','pic','野营水壶','upload/image/HWxfzPlC.jpg','2','32');
INSERT INTO ss_marquees(`id`,`module_id`,`marquee_type`,`title`,`pic`,`flag`,`link`) VALUES('33','172','pic','7LED头灯','upload/image/zcUfewJd.jpg','2','33');
INSERT INTO ss_marquees(`id`,`module_id`,`marquee_type`,`title`,`pic`,`flag`,`link`) VALUES('34','172','pic','6LED帐篷灯','upload/image/Tn1KJmOs.jpg','2','34');
INSERT INTO ss_marquees(`id`,`module_id`,`marquee_type`,`title`,`pic`,`flag`,`link`) VALUES('35','172','pic','小号营地灯','upload/image/idvK2W2W.jpg','2','35');
INSERT INTO ss_marquees(`id`,`module_id`,`marquee_type`,`title`,`pic`,`flag`,`link`) VALUES('36','172','pic','户外超亮LED节能灯','upload/image/P4i9IWSA.jpg','2','36');
INSERT INTO ss_marquees(`id`,`module_id`,`marquee_type`,`title`,`pic`,`flag`,`link`) VALUES('37','172','pic','7LED野营灯','upload/image/aX36H59A.jpg','2','37');
INSERT INTO ss_marquees(`id`,`module_id`,`marquee_type`,`title`,`pic`,`flag`,`link`) VALUES('38','172','pic','48头LED帐篷灯','upload/image/mquFQmu4.jpg','2','38');
INSERT INTO ss_marquees(`id`,`module_id`,`marquee_type`,`title`,`pic`,`flag`,`link`) VALUES('39','172','pic','防水强光手电筒','upload/image/CJ95KOnw.jpg','2','39');
INSERT INTO ss_marquees(`id`,`module_id`,`marquee_type`,`title`,`pic`,`flag`,`link`) VALUES('40','172','pic','15流明手电','upload/image/o7egukA7.jpg','2','40');
INSERT INTO ss_marquees(`id`,`module_id`,`marquee_type`,`title`,`pic`,`flag`,`link`) VALUES('41','172','pic','大号折叠桶','upload/image/1UFcTwct.jpg','2','41');
INSERT INTO ss_marquees(`id`,`module_id`,`marquee_type`,`title`,`pic`,`flag`,`link`) VALUES('42','172','pic','伸缩六折杯','upload/image/q1lkMM1v.jpg','2','42');
INSERT INTO ss_marquees(`id`,`module_id`,`marquee_type`,`title`,`pic`,`flag`,`link`) VALUES('43','172','pic','TPU专业水袋','upload/image/MTOM4Txv.jpg','2','43');
INSERT INTO ss_marquees(`id`,`module_id`,`marquee_type`,`title`,`pic`,`flag`,`link`) VALUES('44','172','pic','制冷水杯水壶户外','upload/image/M2oXpK3U.jpg','2','44');
INSERT INTO ss_marquees(`id`,`module_id`,`marquee_type`,`title`,`pic`,`flag`,`link`) VALUES('45','172','pic','户外伸缩水壶','upload/image/4H84GiU1.jpg','2','45');
INSERT INTO ss_marquees(`id`,`module_id`,`marquee_type`,`title`,`pic`,`flag`,`link`) VALUES('46','172','pic','休闲船','upload/image/WsXaVM6c.jpg','2','46');
INSERT INTO ss_marquees(`id`,`module_id`,`marquee_type`,`title`,`pic`,`flag`,`link`) VALUES('47','172','pic','气垫船','upload/image/BJDdsb4O.jpg','2','47');
INSERT INTO ss_marquees(`id`,`module_id`,`marquee_type`,`title`,`pic`,`flag`,`link`) VALUES('48','172','pic','超高防水鞋','upload/image/K8D3UZbw.jpg','2','48');
INSERT INTO ss_marquees(`id`,`module_id`,`marquee_type`,`title`,`pic`,`flag`,`link`) VALUES('112','179','pic','军用迷彩包','upload/image/MLaKXXiB.jpg','2','24');
INSERT INTO ss_marquees(`id`,`module_id`,`marquee_type`,`title`,`pic`,`flag`,`link`) VALUES('111','179','pic','手提双肩多功能包','upload/image/KMCjdwA3.jpg','2','23');
INSERT INTO ss_marquees(`id`,`module_id`,`marquee_type`,`title`,`pic`,`flag`,`link`) VALUES('110','179','pic','户外休闲旅行包','upload/image/fXGrLjSU.jpg','2','22');
INSERT INTO ss_marquees(`id`,`module_id`,`marquee_type`,`title`,`pic`,`flag`,`link`) VALUES('109','179','pic','户外旅行包','upload/image/lEfTOIN2.jpg','2','21');
INSERT INTO ss_marquees(`id`,`module_id`,`marquee_type`,`title`,`pic`,`flag`,`link`) VALUES('108','179','pic','双肩户外旅行包','upload/image/Pc6hlC3l.jpg','2','20');
INSERT INTO ss_marquees(`id`,`module_id`,`marquee_type`,`title`,`pic`,`flag`,`link`) VALUES('107','179','pic','登山包KA','upload/image/fVg1tl08.jpg','2','19');
INSERT INTO ss_marquees(`id`,`module_id`,`marquee_type`,`title`,`pic`,`flag`,`link`) VALUES('106','179','pic','登山包','upload/image/EHHBAh3N.jpg','2','18');
INSERT INTO ss_marquees(`id`,`module_id`,`marquee_type`,`title`,`pic`,`flag`,`link`) VALUES('105','179','pic','背包','upload/image/LMXWyZQs.jpg','2','17');
INSERT INTO ss_marquees(`id`,`module_id`,`marquee_type`,`title`,`pic`,`flag`,`link`) VALUES('104','179','pic','超轻夏季睡袋','upload/image/Mz3Y4VOm.jpg','2','16');
INSERT INTO ss_marquees(`id`,`module_id`,`marquee_type`,`title`,`pic`,`flag`,`link`) VALUES('103','179','pic','戴帽式睡袋','upload/image/8jVxUVd0.jpg','2','15');
INSERT INTO ss_marquees(`id`,`module_id`,`marquee_type`,`title`,`pic`,`flag`,`link`) VALUES('102','179','pic','春夏单人迷彩睡袋','upload/image/SltSNcZX.jpg','2','14');
INSERT INTO ss_marquees(`id`,`module_id`,`marquee_type`,`title`,`pic`,`flag`,`link`) VALUES('101','179','pic','双人睡袋','upload/image/VIcAiU1J.jpg','2','13');
INSERT INTO ss_marquees(`id`,`module_id`,`marquee_type`,`title`,`pic`,`flag`,`link`) VALUES('100','179','pic','双层帐篷','upload/image/q6gp28gq.jpg','2','12');
INSERT INTO ss_marquees(`id`,`module_id`,`marquee_type`,`title`,`pic`,`flag`,`link`) VALUES('99','179','pic','多人帐篷','upload/image/owkRnqSg.jpg','2','11');
INSERT INTO ss_marquees(`id`,`module_id`,`marquee_type`,`title`,`pic`,`flag`,`link`) VALUES('98','179','pic','铝杆帐篷','upload/image/ue0NbPSS.jpg','2','10');
INSERT INTO ss_marquees(`id`,`module_id`,`marquee_type`,`title`,`pic`,`flag`,`link`) VALUES('97','179','pic','户外帐篷SY','upload/image/X6wabvgg.jpg','2','9');

DROP TABLE IF EXISTS ss_menu_items;
CREATE TABLE `ss_menu_items` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `name` varchar(255) NOT NULL,
  `link` varchar(255) NOT NULL DEFAULT '#',
  `mi_category` varchar(50) NOT NULL DEFAULT 'outer_url',
  `link_type` varchar(50) NOT NULL DEFAULT '',
  `selected_content` varchar(255) NOT NULL DEFAULT '',
  `menu_item_id` int(11) NOT NULL DEFAULT '0',
  `i_order` int(11) NOT NULL DEFAULT '0',
  `s_locale` varchar(50) NOT NULL,
  `published` varchar(20) NOT NULL DEFAULT '1',
  `for_roles` varchar(50) NOT NULL DEFAULT '{guest}',
  `menu_id` int(11) NOT NULL DEFAULT '0',
  `layout` varchar(100) NOT NULL DEFAULT 'default',
  `meta_key` text,
  `meta_desc` text,
  `title` varchar(100) DEFAULT '',
  PRIMARY KEY (`id`),
  KEY `menu_item_id` (`menu_item_id`),
  KEY `i_order` (`i_order`),
  KEY `s_locale` (`s_locale`),
  KEY `for_roles` (`for_roles`),
  KEY `mi_category` (`mi_category`),
  KEY `published` (`published`),
  KEY `menu_id` (`menu_id`),
  KEY `name` (`name`)
) ENGINE=MyISAM AUTO_INCREMENT=71 DEFAULT CHARSET=utf8;

INSERT INTO ss_menu_items(`id`,`name`,`link`,`mi_category`,`link_type`,`selected_content`,`menu_item_id`,`i_order`,`s_locale`,`published`,`for_roles`,`menu_id`,`layout`,`meta_key`,`meta_desc`,`title`) VALUES('43','公司招聘','_m=mod_static&_a=view&sc_id=5','static','static|1|自定义页面','自定义页面 - 招聘','0','6','zh_CN','1','{member}{admin}{guest}','0','default','','','');
INSERT INTO ss_menu_items(`id`,`name`,`link`,`mi_category`,`link_type`,`selected_content`,`menu_item_id`,`i_order`,`s_locale`,`published`,`for_roles`,`menu_id`,`layout`,`meta_key`,`meta_desc`,`title`) VALUES('40','联系我们','_m=mod_static&_a=view&sc_id=1','contact_info','contact_info|0|联系我们','联系我们','0','8','zh_CN','1','{member}{admin}{guest}','0','default','','','');
INSERT INTO ss_menu_items(`id`,`name`,`link`,`mi_category`,`link_type`,`selected_content`,`menu_item_id`,`i_order`,`s_locale`,`published`,`for_roles`,`menu_id`,`layout`,`meta_key`,`meta_desc`,`title`) VALUES('41','用户留言','_m=mod_message&_a=form','message','message|0|留言','留言','0','9','zh_CN','1','{member}{admin}{guest}','0','default','','','');
INSERT INTO ss_menu_items(`id`,`name`,`link`,`mi_category`,`link_type`,`selected_content`,`menu_item_id`,`i_order`,`s_locale`,`published`,`for_roles`,`menu_id`,`layout`,`meta_key`,`meta_desc`,`title`) VALUES('39','产品中心','_m=mod_product&_a=prdlist','product_list','product_list|1|产品列表','产品列表 - 所有产品','0','4','zh_CN','1','{member}{admin}{guest}','0','default','','','');
INSERT INTO ss_menu_items(`id`,`name`,`link`,`mi_category`,`link_type`,`selected_content`,`menu_item_id`,`i_order`,`s_locale`,`published`,`for_roles`,`menu_id`,`layout`,`meta_key`,`meta_desc`,`title`) VALUES('36','首页','_m=frontpage&_a=index','frontpage','frontpage|0|首页','首页','0','1','zh_CN','1','{member}{admin}{guest}','0','default','','','');
INSERT INTO ss_menu_items(`id`,`name`,`link`,`mi_category`,`link_type`,`selected_content`,`menu_item_id`,`i_order`,`s_locale`,`published`,`for_roles`,`menu_id`,`layout`,`meta_key`,`meta_desc`,`title`) VALUES('37','公司介绍','_m=mod_static&_a=view&sc_id=2','company_info','company_info|0|公司介绍','公司介绍','0','2','zh_CN','1','{member}{admin}{guest}','0','default','','','');
INSERT INTO ss_menu_items(`id`,`name`,`link`,`mi_category`,`link_type`,`selected_content`,`menu_item_id`,`i_order`,`s_locale`,`published`,`for_roles`,`menu_id`,`layout`,`meta_key`,`meta_desc`,`title`) VALUES('38','新闻中心','_m=mod_article&_a=fullist','article_list','article_list|1|文章列表','文章列表 - 所有文章','0','3','zh_CN','1','{member}{admin}{guest}','0','default','','','');
INSERT INTO ss_menu_items(`id`,`name`,`link`,`mi_category`,`link_type`,`selected_content`,`menu_item_id`,`i_order`,`s_locale`,`published`,`for_roles`,`menu_id`,`layout`,`meta_key`,`meta_desc`,`title`) VALUES('44','户外知识','_m=mod_static&_a=view&sc_id=6','static','static|1|自定义页面','自定义页面 - 户外知识','0','7','zh_CN','1','{member}{admin}{guest}','0','default','','','');
INSERT INTO ss_menu_items(`id`,`name`,`link`,`mi_category`,`link_type`,`selected_content`,`menu_item_id`,`i_order`,`s_locale`,`published`,`for_roles`,`menu_id`,`layout`,`meta_key`,`meta_desc`,`title`) VALUES('45','衣服鞋帽','_m=mod_product&_a=prdlist','product_list','product_list|1|产品列表','产品列表 - 衣服鞋帽','39','1','zh_CN','1','{member}{admin}{guest}','0','default','','','');
INSERT INTO ss_menu_items(`id`,`name`,`link`,`mi_category`,`link_type`,`selected_content`,`menu_item_id`,`i_order`,`s_locale`,`published`,`for_roles`,`menu_id`,`layout`,`meta_key`,`meta_desc`,`title`) VALUES('46','鞋帽','_m=mod_product&_a=prdlist&cap_id=66','product_list','product_list|1|产品列表','产品列表 - 鞋帽','45','1','zh_CN','1','{member}{admin}{guest}','0','default','','','');
INSERT INTO ss_menu_items(`id`,`name`,`link`,`mi_category`,`link_type`,`selected_content`,`menu_item_id`,`i_order`,`s_locale`,`published`,`for_roles`,`menu_id`,`layout`,`meta_key`,`meta_desc`,`title`) VALUES('47','衣物','_m=mod_product&_a=prdlist&cap_id=65','product_list','product_list|1|产品列表','产品列表 - 衣物','45','2','zh_CN','1','{member}{admin}{guest}','0','default','','','');
INSERT INTO ss_menu_items(`id`,`name`,`link`,`mi_category`,`link_type`,`selected_content`,`menu_item_id`,`i_order`,`s_locale`,`published`,`for_roles`,`menu_id`,`layout`,`meta_key`,`meta_desc`,`title`) VALUES('48','帐篷睡袋','_m=mod_product&_a=prdlist&cap_id=4','product_list','product_list|1|产品列表','产品列表 - 帐篷睡袋','39','2','zh_CN','1','{member}{admin}{guest}','0','default','','','');
INSERT INTO ss_menu_items(`id`,`name`,`link`,`mi_category`,`link_type`,`selected_content`,`menu_item_id`,`i_order`,`s_locale`,`published`,`for_roles`,`menu_id`,`layout`,`meta_key`,`meta_desc`,`title`) VALUES('49','帐篷','_m=mod_product&_a=prdlist&cap_id=68','product_list','product_list|1|产品列表','产品列表 - 帐篷','48','1','zh_CN','1','{member}{admin}{guest}','0','default','','','');
INSERT INTO ss_menu_items(`id`,`name`,`link`,`mi_category`,`link_type`,`selected_content`,`menu_item_id`,`i_order`,`s_locale`,`published`,`for_roles`,`menu_id`,`layout`,`meta_key`,`meta_desc`,`title`) VALUES('50','睡袋','_m=mod_product&_a=prdlist&cap_id=67','product_list','product_list|1|产品列表','产品列表 - 睡袋','48','2','zh_CN','1','{member}{admin}{guest}','0','default','','','');
INSERT INTO ss_menu_items(`id`,`name`,`link`,`mi_category`,`link_type`,`selected_content`,`menu_item_id`,`i_order`,`s_locale`,`published`,`for_roles`,`menu_id`,`layout`,`meta_key`,`meta_desc`,`title`) VALUES('51','背包','_m=mod_product&_a=prdlist&cap_id=3','product_list','product_list|1|产品列表','产品列表 - 背包','39','3','zh_CN','1','{member}{admin}{guest}','0','default','','','');
INSERT INTO ss_menu_items(`id`,`name`,`link`,`mi_category`,`link_type`,`selected_content`,`menu_item_id`,`i_order`,`s_locale`,`published`,`for_roles`,`menu_id`,`layout`,`meta_key`,`meta_desc`,`title`) VALUES('55','公司新闻','_m=mod_article&_a=fullist&caa_id=3','article_list','article_list|1|文章列表','文章列表 - 公司新闻','38','1','zh_CN','1','{member}{admin}{guest}','0','default','','','');
INSERT INTO ss_menu_items(`id`,`name`,`link`,`mi_category`,`link_type`,`selected_content`,`menu_item_id`,`i_order`,`s_locale`,`published`,`for_roles`,`menu_id`,`layout`,`meta_key`,`meta_desc`,`title`) VALUES('56','行业动态','_m=mod_article&_a=fullist&caa_id=9','article_list','article_list|1|文章列表','文章列表 - 行业新闻','38','2','zh_CN','1','{member}{admin}{guest}','0','default','','','');
INSERT INTO ss_menu_items(`id`,`name`,`link`,`mi_category`,`link_type`,`selected_content`,`menu_item_id`,`i_order`,`s_locale`,`published`,`for_roles`,`menu_id`,`layout`,`meta_key`,`meta_desc`,`title`) VALUES('57','媒体报道','_m=mod_article&_a=fullist&caa_id=8','article_list','article_list|1|文章列表','文章列表 - 媒体报道','38','3','zh_CN','1','{member}{admin}{guest}','0','default','','','');
INSERT INTO ss_menu_items(`id`,`name`,`link`,`mi_category`,`link_type`,`selected_content`,`menu_item_id`,`i_order`,`s_locale`,`published`,`for_roles`,`menu_id`,`layout`,`meta_key`,`meta_desc`,`title`) VALUES('58','大号','_m=mod_product&_a=prdlist&cap_id=69','product_list','product_list|1|产品列表','产品列表 - 大号','51','1','zh_CN','1','{member}{admin}{guest}','0','default','','','');
INSERT INTO ss_menu_items(`id`,`name`,`link`,`mi_category`,`link_type`,`selected_content`,`menu_item_id`,`i_order`,`s_locale`,`published`,`for_roles`,`menu_id`,`layout`,`meta_key`,`meta_desc`,`title`) VALUES('59','小号','_m=mod_product&_a=prdlist&cap_id=70','product_list','product_list|1|产品列表','产品列表 - 小号','51','2','zh_CN','1','{member}{admin}{guest}','0','default','','','');
INSERT INTO ss_menu_items(`id`,`name`,`link`,`mi_category`,`link_type`,`selected_content`,`menu_item_id`,`i_order`,`s_locale`,`published`,`for_roles`,`menu_id`,`layout`,`meta_key`,`meta_desc`,`title`) VALUES('62','炊具','_m=mod_product&_a=prdlist&cap_id=5','product_list','product_list|1|产品列表','产品列表 - 炊具','39','4','zh_CN','1','{member}{admin}{guest}','0','default','','','');
INSERT INTO ss_menu_items(`id`,`name`,`link`,`mi_category`,`link_type`,`selected_content`,`menu_item_id`,`i_order`,`s_locale`,`published`,`for_roles`,`menu_id`,`layout`,`meta_key`,`meta_desc`,`title`) VALUES('63','便携','_m=mod_product&_a=prdlist&cap_id=71','product_list','product_list|1|产品列表','产品列表 - A','62','1','zh_CN','1','{member}{admin}{guest}','0','default','','','');
INSERT INTO ss_menu_items(`id`,`name`,`link`,`mi_category`,`link_type`,`selected_content`,`menu_item_id`,`i_order`,`s_locale`,`published`,`for_roles`,`menu_id`,`layout`,`meta_key`,`meta_desc`,`title`) VALUES('64','折叠','_m=mod_product&_a=prdlist&cap_id=72','product_list','product_list|1|产品列表','产品列表 - B','62','2','zh_CN','1','{member}{admin}{guest}','0','default','','','');
INSERT INTO ss_menu_items(`id`,`name`,`link`,`mi_category`,`link_type`,`selected_content`,`menu_item_id`,`i_order`,`s_locale`,`published`,`for_roles`,`menu_id`,`layout`,`meta_key`,`meta_desc`,`title`) VALUES('65','灯具','_m=mod_product&_a=prdlist&cap_id=6','product_list','product_list|1|产品列表','产品列表 - 灯具','39','5','zh_CN','1','{member}{admin}{guest}','0','default','','','');
INSERT INTO ss_menu_items(`id`,`name`,`link`,`mi_category`,`link_type`,`selected_content`,`menu_item_id`,`i_order`,`s_locale`,`published`,`for_roles`,`menu_id`,`layout`,`meta_key`,`meta_desc`,`title`) VALUES('66',' 水具','_m=mod_product&_a=prdlist&cap_id=7','product_list','product_list|1|产品列表','产品列表 - 水具','39','6','zh_CN','1','{member}{admin}{guest}','0','default','','','');
INSERT INTO ss_menu_items(`id`,`name`,`link`,`mi_category`,`link_type`,`selected_content`,`menu_item_id`,`i_order`,`s_locale`,`published`,`for_roles`,`menu_id`,`layout`,`meta_key`,`meta_desc`,`title`) VALUES('67','室内','_m=mod_product&_a=prdlist&cap_id=73','product_list','product_list|1|产品列表','产品列表 - A','65','1','zh_CN','1','{member}{admin}{guest}','0','default','','','');
INSERT INTO ss_menu_items(`id`,`name`,`link`,`mi_category`,`link_type`,`selected_content`,`menu_item_id`,`i_order`,`s_locale`,`published`,`for_roles`,`menu_id`,`layout`,`meta_key`,`meta_desc`,`title`) VALUES('68','室外','_m=mod_product&_a=prdlist&cap_id=74','product_list','product_list|1|产品列表','产品列表 - B','65','2','zh_CN','1','{member}{admin}{guest}','0','default','','','');
INSERT INTO ss_menu_items(`id`,`name`,`link`,`mi_category`,`link_type`,`selected_content`,`menu_item_id`,`i_order`,`s_locale`,`published`,`for_roles`,`menu_id`,`layout`,`meta_key`,`meta_desc`,`title`) VALUES('69','饮用','_m=mod_product&_a=prdlist&cap_id=75','product_list','product_list|1|产品列表','产品列表 - A','66','1','zh_CN','1','{member}{admin}{guest}','0','default','','','');
INSERT INTO ss_menu_items(`id`,`name`,`link`,`mi_category`,`link_type`,`selected_content`,`menu_item_id`,`i_order`,`s_locale`,`published`,`for_roles`,`menu_id`,`layout`,`meta_key`,`meta_desc`,`title`) VALUES('70','工具','_m=mod_product&_a=prdlist&cap_id=76','product_list','product_list|1|产品列表','产品列表 - B','66','2','zh_CN','1','{member}{admin}{guest}','0','default','','','');

DROP TABLE IF EXISTS ss_menus;
CREATE TABLE `ss_menus` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `name` varchar(255) NOT NULL,
  `s_locale` varchar(50) NOT NULL,
  `published` enum('0','1') NOT NULL DEFAULT '1',
  `for_roles` varchar(50) NOT NULL DEFAULT '{guest}',
  PRIMARY KEY (`id`),
  KEY `name` (`name`),
  KEY `s_locale` (`s_locale`),
  KEY `published` (`published`),
  KEY `for_roles` (`for_roles`)
) ENGINE=MyISAM AUTO_INCREMENT=2 DEFAULT CHARSET=utf8;

INSERT INTO ss_menus(`id`,`name`,`s_locale`,`published`,`for_roles`) VALUES('1','菜单','zh_CN','1','{member}{admin}{guest}');

DROP TABLE IF EXISTS ss_messages;
CREATE TABLE `ss_messages` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `username` varchar(255) NOT NULL,
  `email` varchar(255) NOT NULL,
  `tele` varchar(20) NOT NULL,
  `message` text NOT NULL,
  `create_time` bigint(20) NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=MyISAM AUTO_INCREMENT=2 DEFAULT CHARSET=utf8;

INSERT INTO ss_messages(`id`,`username`,`email`,`tele`,`message`,`create_time`) VALUES('1','11','11@11.com','1111','111','1277824811');

DROP TABLE IF EXISTS ss_module_blocks;
CREATE TABLE `ss_module_blocks` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `module` varchar(50) NOT NULL,
  `action` varchar(50) NOT NULL,
  `alias` varchar(50) NOT NULL,
  `title` varchar(255) DEFAULT NULL,
  `show_title` enum('0','1') NOT NULL DEFAULT '1',
  `s_pos` varchar(50) NOT NULL,
  `s_param` longtext,
  `s_locale` varchar(50) NOT NULL,
  `s_query_hash` char(40) NOT NULL,
  `i_order` int(11) NOT NULL DEFAULT '0',
  `published` enum('0','1') NOT NULL DEFAULT '1',
  `for_roles` varchar(50) NOT NULL DEFAULT '{guest}',
  `s_token` varchar(40) DEFAULT NULL,
  `perpage_show` varchar(40) DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `s_pos` (`s_pos`),
  KEY `s_locale` (`s_locale`),
  KEY `s_query_hash` (`s_query_hash`),
  KEY `i_order` (`i_order`),
  KEY `published` (`published`),
  KEY `for_roles` (`for_roles`)
) ENGINE=MyISAM AUTO_INCREMENT=1285 DEFAULT CHARSET=utf8;

INSERT INTO ss_module_blocks(`id`,`module`,`action`,`alias`,`title`,`show_title`,`s_pos`,`s_param`,`s_locale`,`s_query_hash`,`i_order`,`published`,`for_roles`,`s_token`,`perpage_show`) VALUES('91','mod_media','show_image','mb_logo','','0','logo','a:4:{s:7:\"img_src\";s:21:\"upload/image/logo.png\";s:8:\"img_desc\";s:0:\"\";s:9:\"img_width\";s:0:\"\";s:10:\"img_height\";s:0:\"\";}','zh_CN','_ALL','0','1','{member}{admin}{guest}','','');
INSERT INTO ss_module_blocks(`id`,`module`,`action`,`alias`,`title`,`show_title`,`s_pos`,`s_param`,`s_locale`,`s_query_hash`,`i_order`,`published`,`for_roles`,`s_token`,`perpage_show`) VALUES('174','mod_product','newprd','mb_YjJ6ZpUh','最新产品','1','right','a:6:{s:9:\"slide_num\";s:1:\"1\";s:14:\"slide_temp_num\";s:1:\"1\";s:15:\"prd_newlst_size\";s:1:\"4\";s:17:\"prd_newlst_cap_id\";s:1:\"4\";s:12:\"prd_newlst_d\";s:1:\"4\";s:16:\"prd_newlst_price\";s:0:\"\";}','zh_CN','44f01ceb6551c666f3a79d8189dfad01ff566907','2','1','{member}{admin}{guest}','','');
INSERT INTO ss_module_blocks(`id`,`module`,`action`,`alias`,`title`,`show_title`,`s_pos`,`s_param`,`s_locale`,`s_query_hash`,`i_order`,`published`,`for_roles`,`s_token`,`perpage_show`) VALUES('248','mod_static','company_intro','mb_tVRdunHi','公司介绍','1','right','a:3:{s:9:\"slide_num\";s:1:\"1\";s:14:\"slide_temp_num\";s:1:\"1\";s:16:\"cpy_intro_number\";s:3:\"500\";}','zh_CN','44f01ceb6551c666f3a79d8189dfad01ff566907','1','1','{member}{admin}{guest}','index','');
INSERT INTO ss_module_blocks(`id`,`module`,`action`,`alias`,`title`,`show_title`,`s_pos`,`s_param`,`s_locale`,`s_query_hash`,`i_order`,`published`,`for_roles`,`s_token`,`perpage_show`) VALUES('171','mod_category_p','category_p_menu','mb_In6CJe1l','产品分类','1','left','a:4:{s:9:\"slide_num\";s:1:\"1\";s:14:\"slide_temp_num\";s:1:\"1\";s:21:\"product_category_type\";s:5:\"slide\";s:21:\"product_category_list\";s:13:\"0,2,4,3,5,6,7\";}','zh_CN','_ALL','0','1','{member}{admin}{guest}','','');
INSERT INTO ss_module_blocks(`id`,`module`,`action`,`alias`,`title`,`show_title`,`s_pos`,`s_param`,`s_locale`,`s_query_hash`,`i_order`,`published`,`for_roles`,`s_token`,`perpage_show`) VALUES('94','mod_menu','topmenu','mb_56YrvV58','','0','nav','a:1:{s:6:\"menuid\";s:1:\"0\";}','zh_CN','_ALL','0','1','{member}{admin}{guest}','','');
INSERT INTO ss_module_blocks(`id`,`module`,`action`,`alias`,`title`,`show_title`,`s_pos`,`s_param`,`s_locale`,`s_query_hash`,`i_order`,`published`,`for_roles`,`s_token`,`perpage_show`) VALUES('92','mod_media','show_flash','mb_banner','','0','banner','a:1:{s:4:\"_all\";a:8:{s:8:\"img_desc\";s:0:\"\";s:9:\"img_width\";s:3:\"960\";s:9:\"flv_width\";s:3:\"960\";s:10:\"img_height\";s:3:\"324\";s:10:\"flv_height\";s:3:\"324\";s:6:\"islink\";s:2:\"no\";s:7:\"flv_src\";s:25:\"upload/flash/4wgoJCpp.swf\";s:6:\"action\";s:10:\"show_flash\";}}','zh_CN','_ALL','0','1','{member}{admin}{guest}','','');
INSERT INTO ss_module_blocks(`id`,`module`,`action`,`alias`,`title`,`show_title`,`s_pos`,`s_param`,`s_locale`,`s_query_hash`,`i_order`,`published`,`for_roles`,`s_token`,`perpage_show`) VALUES('158','mod_message','form','mb_7gJLeI3V','','0','right','','zh_CN','fb0693e250ed63d84606403f56bad48ae61188df','-1','1','{member}{admin}{guest}','','');
INSERT INTO ss_module_blocks(`id`,`module`,`action`,`alias`,`title`,`show_title`,`s_pos`,`s_param`,`s_locale`,`s_query_hash`,`i_order`,`published`,`for_roles`,`s_token`,`perpage_show`) VALUES('156','mod_message','form','mb_XDSyOalJ','','0','right','','zh_CN','fb0693e250ed63d84606403f56bad48ae61188df','-1','1','{member}{admin}{guest}','','');
INSERT INTO ss_module_blocks(`id`,`module`,`action`,`alias`,`title`,`show_title`,`s_pos`,`s_param`,`s_locale`,`s_query_hash`,`i_order`,`published`,`for_roles`,`s_token`,`perpage_show`) VALUES('155','mod_message','form','mb_4XTk4uZr','留言','1','right','','zh_CN','fb0693e250ed63d84606403f56bad48ae61188df','-1','1','{member}{admin}{guest}','','');
INSERT INTO ss_module_blocks(`id`,`module`,`action`,`alias`,`title`,`show_title`,`s_pos`,`s_param`,`s_locale`,`s_query_hash`,`i_order`,`published`,`for_roles`,`s_token`,`perpage_show`) VALUES('154','mod_message','form','mb_ArIxOO86','留言','1','right','','zh_CN','fb0693e250ed63d84606403f56bad48ae61188df','-1','1','{member}{admin}{guest}','','');
INSERT INTO ss_module_blocks(`id`,`module`,`action`,`alias`,`title`,`show_title`,`s_pos`,`s_param`,`s_locale`,`s_query_hash`,`i_order`,`published`,`for_roles`,`s_token`,`perpage_show`) VALUES('126','mod_friendlink','friendlink','mb_XPc0eUzv','友情连接','1','left','a:2:{s:15:\"friendlink_size\";s:1:\"2\";s:7:\"fl_type\";s:1:\"1\";}','zh_CN','_ALL','2','1','{member}{admin}{guest}','','');
INSERT INTO ss_module_blocks(`id`,`module`,`action`,`alias`,`title`,`show_title`,`s_pos`,`s_param`,`s_locale`,`s_query_hash`,`i_order`,`published`,`for_roles`,`s_token`,`perpage_show`) VALUES('129','mod_auth','loginform','mb_MaiJKrL5','用户登录','1','left','','zh_CN','b9effdcffea7f566d776ed967e20d666bcb4d386','-1','1','{member}{admin}{guest}','','');
INSERT INTO ss_module_blocks(`id`,`module`,`action`,`alias`,`title`,`show_title`,`s_pos`,`s_param`,`s_locale`,`s_query_hash`,`i_order`,`published`,`for_roles`,`s_token`,`perpage_show`) VALUES('173','mod_qq','qqlist','mb_FgVX3ene','在线客服','1','left','a:4:{s:9:\"slide_num\";s:1:\"1\";s:14:\"slide_temp_num\";s:1:\"1\";s:15:\"qq_show_account\";s:1:\"1\";s:12:\"qq_show_name\";s:1:\"1\";}','zh_CN','44f01ceb6551c666f3a79d8189dfad01ff566907','3','1','{member}{admin}{guest}','','');
INSERT INTO ss_module_blocks(`id`,`module`,`action`,`alias`,`title`,`show_title`,`s_pos`,`s_param`,`s_locale`,`s_query_hash`,`i_order`,`published`,`for_roles`,`s_token`,`perpage_show`) VALUES('163','mod_static','custom_html','mb_foot','','0','footer','a:1:{s:4:\"html\";s:181:\"Copyright © 2009-2011,www.cz128.com,All rights reserved<br />\r\n乌托邦网络版权所有 © 您的网站名称 未经许可 严禁复制 建议使用1024X768分辨率浏览本站\";}','zh_CN','_ALL','0','1','{member}{admin}{guest}','','');
INSERT INTO ss_module_blocks(`id`,`module`,`action`,`alias`,`title`,`show_title`,`s_pos`,`s_param`,`s_locale`,`s_query_hash`,`i_order`,`published`,`for_roles`,`s_token`,`perpage_show`) VALUES('179','mod_marquee','marquee','mb_tIZF72oN','','0','right','a:9:{s:9:\"slide_num\";s:1:\"1\";s:14:\"slide_temp_num\";s:1:\"1\";s:13:\"marquee_speed\";s:4:\"slow\";s:13:\"marquee_class\";s:3:\"pic\";s:12:\"mar_direc_id\";s:4:\"left\";s:13:\"marquee_data1\";s:1:\"1\";s:12:\"marquee_data\";s:0:\"\";s:10:\"mar_prd_id\";s:15:\"4,67,68,3,69,70\";s:14:\"mar_article_id\";s:7:\"0,3,8,9\";}','zh_CN','44f01ceb6551c666f3a79d8189dfad01ff566907','0','1','{member}{admin}{guest}','','');
INSERT INTO ss_module_blocks(`id`,`module`,`action`,`alias`,`title`,`show_title`,`s_pos`,`s_param`,`s_locale`,`s_query_hash`,`i_order`,`published`,`for_roles`,`s_token`,`perpage_show`) VALUES('180','mod_article','recentshort','mb_pBC3u7D0','公司新闻','1','left','a:4:{s:9:\"slide_num\";s:1:\"1\";s:14:\"slide_temp_num\";s:1:\"1\";s:19:\"article_reclst_size\";s:1:\"2\";s:16:\"article_category\";s:1:\"3\";}','zh_CN','44f01ceb6551c666f3a79d8189dfad01ff566907','1','1','{member}{admin}{guest}','','');
INSERT INTO ss_module_blocks(`id`,`module`,`action`,`alias`,`title`,`show_title`,`s_pos`,`s_param`,`s_locale`,`s_query_hash`,`i_order`,`published`,`for_roles`,`s_token`,`perpage_show`) VALUES('1284','mod_static','custom_html','mb_foot','','1','footer','a:1:{s:4:\"html\";s:320:\"Power by <a href=\'http://www.sitestar.cn/\' target=\'_blank\' title=\'建站之星(sitestar)网站建设系统\' style=\'display:inline;\'>建站之星</a>|<a href=\'http://www.cndns.com/\' target=\'_blank\' title=\'域名注册|域名申请|域名尽在“美橙互联”\' style=\'display:inline;\'>美橙互联</a>&nbsp;版权所有\";}','zh_CN','_ALL','0','1','{member}{admin}{guest}','','');

DROP TABLE IF EXISTS ss_navigations;
CREATE TABLE `ss_navigations` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `navigation` varchar(255) NOT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `navigation` (`navigation`)
) ENGINE=MyISAM AUTO_INCREMENT=4 DEFAULT CHARSET=utf8;


DROP TABLE IF EXISTS ss_online_orders;
CREATE TABLE `ss_online_orders` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `oid` varchar(255) NOT NULL,
  `user_id` int(11) NOT NULL,
  `reciever_name` varchar(255) DEFAULT NULL,
  `prov_id` varchar(6) DEFAULT NULL,
  `city_id` varchar(6) DEFAULT NULL,
  `dist_id` varchar(6) DEFAULT NULL,
  `detailed_addr` text,
  `postal` varchar(6) DEFAULT NULL,
  `phone` varchar(24) DEFAULT NULL,
  `delivery_fee` decimal(16,2) NOT NULL DEFAULT '0.00',
  `total_price` decimal(16,2) NOT NULL DEFAULT '0.00',
  `discount_price` decimal(16,2) NOT NULL DEFAULT '0.00',
  `total_amount` decimal(16,2) NOT NULL DEFAULT '0.00',
  `message` text,
  `order_time` bigint(20) NOT NULL,
  `order_status` enum('1','2','3','100','101') NOT NULL DEFAULT '1',
  `anonymous_passwd` char(40) DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `oid` (`oid`),
  KEY `user_id` (`user_id`),
  KEY `order_time` (`order_time`),
  KEY `order_status` (`order_status`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;


DROP TABLE IF EXISTS ss_online_qqs;
CREATE TABLE `ss_online_qqs` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `account` varchar(255) NOT NULL,
  `category` enum('0','1','2','3','4','5','6') DEFAULT NULL,
  `published` enum('0','1') NOT NULL DEFAULT '1',
  `qqname` varchar(255) NOT NULL,
  `s_locale` varchar(50) NOT NULL DEFAULT 'zh_CN',
  PRIMARY KEY (`id`)
) ENGINE=MyISAM AUTO_INCREMENT=3 DEFAULT CHARSET=utf8;

INSERT INTO ss_online_qqs(`id`,`account`,`category`,`published`,`qqname`,`s_locale`) VALUES('1','122812289','0','1','在线客服','zh_CN');
INSERT INTO ss_online_qqs(`id`,`account`,`category`,`published`,`qqname`,`s_locale`) VALUES('2','122812289','0','1','在线客服','zh_CN');

DROP TABLE IF EXISTS ss_onlinepay_histories;
CREATE TABLE `ss_onlinepay_histories` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `user_id` int(11) NOT NULL,
  `outer_oid` varchar(255) NOT NULL,
  `payment_provider_id` int(11) NOT NULL,
  `send_time` bigint(20) NOT NULL,
  `return_time` bigint(20) NOT NULL,
  `finished` enum('0','1') NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`),
  KEY `user_id` (`user_id`),
  KEY `outer_oid` (`outer_oid`),
  KEY `payment_provider_id` (`payment_provider_id`),
  KEY `send_time` (`send_time`),
  KEY `return_time` (`return_time`),
  KEY `finished` (`finished`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;


DROP TABLE IF EXISTS ss_order_products;
CREATE TABLE `ss_order_products` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `product_id` int(11) NOT NULL,
  `online_order_id` int(11) NOT NULL,
  `product_name` varchar(255) NOT NULL,
  `product_thumb` varchar(255) DEFAULT NULL,
  `price` decimal(16,2) NOT NULL DEFAULT '0.00',
  `amount` int(11) NOT NULL DEFAULT '1',
  PRIMARY KEY (`id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;


DROP TABLE IF EXISTS ss_parameters;
CREATE TABLE `ss_parameters` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `key` varchar(50) NOT NULL,
  `val` text,
  PRIMARY KEY (`id`),
  KEY `key` (`key`)
) ENGINE=MyISAM AUTO_INCREMENT=93 DEFAULT CHARSET=utf8;

INSERT INTO ss_parameters(`id`,`key`,`val`) VALUES('1','DEFAULT_MODULE','frontpage');
INSERT INTO ss_parameters(`id`,`key`,`val`) VALUES('2','DEFAULT_ACTION','index');
INSERT INTO ss_parameters(`id`,`key`,`val`) VALUES('4','USE_SMTP','0');
INSERT INTO ss_parameters(`id`,`key`,`val`) VALUES('8','MAIL_CHARSET','utf-8');
INSERT INTO ss_parameters(`id`,`key`,`val`) VALUES('9','ENABLE_SMTP_DEBUG','0');
INSERT INTO ss_parameters(`id`,`key`,`val`) VALUES('10','MAGIC_QUOTES_GPC_ON','0');
INSERT INTO ss_parameters(`id`,`key`,`val`) VALUES('11','PAGE_SIZE','16');
INSERT INTO ss_parameters(`id`,`key`,`val`) VALUES('12','PAGE_404','404.html');
INSERT INTO ss_parameters(`id`,`key`,`val`) VALUES('13','DB_SESSION','0');
INSERT INTO ss_parameters(`id`,`key`,`val`) VALUES('14','DEFAULT_LOCALE','zh_CN');
INSERT INTO ss_parameters(`id`,`key`,`val`) VALUES('15','LOCALE_CHARSET','UTF-8');
INSERT INTO ss_parameters(`id`,`key`,`val`) VALUES('16','AUTO_LOCALE','0');
INSERT INTO ss_parameters(`id`,`key`,`val`) VALUES('17','PIC_ALLOW_EXT','gif|jpg|png|bmp');
INSERT INTO ss_parameters(`id`,`key`,`val`) VALUES('18','FILE_ALLOW_EXT','doc|xls|ppt|zip|gz|rar|pdf|gif|jpg|png|bmp');
INSERT INTO ss_parameters(`id`,`key`,`val`) VALUES('19','SITE_OFFLINE','0');
INSERT INTO ss_parameters(`id`,`key`,`val`) VALUES('20','SITE_OFFLINE_MSG','网站正在维护中，请稍候访问！谢谢！');
INSERT INTO ss_parameters(`id`,`key`,`val`) VALUES('26','USER_STEP','1');
INSERT INTO ss_parameters(`id`,`key`,`val`) VALUES('28','SITE_COUNTER_NUM','808');
INSERT INTO ss_parameters(`id`,`key`,`val`) VALUES('27','SITE_COUNTER','0');
INSERT INTO ss_parameters(`id`,`key`,`val`) VALUES('25','SVC_TPL','http://template.sitestar.cn/sitestar22/');
INSERT INTO ss_parameters(`id`,`key`,`val`) VALUES('30','EZSITE_LEVEL','2');
INSERT INTO ss_parameters(`id`,`key`,`val`) VALUES('31','ALLOWED_MOD','frontpage,mod_article,mod_auth,mod_cart,mod_category_a,mod_category_p,mod_counter,mod_download,mod_download_category,mod_friendlink,mod_lang,mod_media,mod_menu,mod_message,mod_navigation,mod_offline,mod_onlinepay,mod_order,mod_product,mod_qq,mod_static,mod_template,mod_tool,mod_user,mod_menu_item,mod_modules,mod_param,mod_payaccount,mod_site,mod_news,mod_statistics,mod_database,mod_filemanager,mod_backup,mod_wizard,mod_about,mod_marquee,mod_attachment,mod_advert,mod_sitestarmaker,mod_bulletin,mod_page,mod_content,mod_roles,mod_category_d,mod_bshare,mod_user_field,mod_third_account,mod_email,');
INSERT INTO ss_parameters(`id`,`key`,`val`) VALUES('33','SITE_LOGIN_VCODE','1');
INSERT INTO ss_parameters(`id`,`key`,`val`) VALUES('35','SYSVER','sitestar_v2.6');
INSERT INTO ss_parameters(`id`,`key`,`val`) VALUES('36','SITE_HAOSH','');
INSERT INTO ss_parameters(`id`,`key`,`val`) VALUES('37','COPYRIGHT','');
INSERT INTO ss_parameters(`id`,`key`,`val`) VALUES('29','EZSITE_S','83d5de05e4d9a6537a97bd6c70768db71a93596dca73880d42552c84b403786d');
INSERT INTO ss_parameters(`id`,`key`,`val`) VALUES('38','DEFAULT_TPL_ID','0');
INSERT INTO ss_parameters(`id`,`key`,`val`) VALUES('39','MUSIC_ALLOW_EXT','mp3|wma');
INSERT INTO ss_parameters(`id`,`key`,`val`) VALUES('40','SERVICE53','');
INSERT INTO ss_parameters(`id`,`key`,`val`) VALUES('41','EZSITE_UID','cndns');
INSERT INTO ss_parameters(`id`,`key`,`val`) VALUES('42','DEFAULT_NAV','0');
INSERT INTO ss_parameters(`id`,`key`,`val`) VALUES('43','BANNER_ISLINK','no');
INSERT INTO ss_parameters(`id`,`key`,`val`) VALUES('44','BANNER_LINK_ADDR','#');
INSERT INTO ss_parameters(`id`,`key`,`val`) VALUES('47','WEB_ICP','沪ICP备XXXXXX号');
INSERT INTO ss_parameters(`id`,`key`,`val`) VALUES('48','MOD_REWRITE','1');
INSERT INTO ss_parameters(`id`,`key`,`val`) VALUES('49','THUMB_STATUS','2');
INSERT INTO ss_parameters(`id`,`key`,`val`) VALUES('50','THUMB_QUALITY','75');
INSERT INTO ss_parameters(`id`,`key`,`val`) VALUES('51','THUMB_WIDTH','400');
INSERT INTO ss_parameters(`id`,`key`,`val`) VALUES('52','THUMB_HEIGHT','300');
INSERT INTO ss_parameters(`id`,`key`,`val`) VALUES('53','WATERMARK_STATUS','0');
INSERT INTO ss_parameters(`id`,`key`,`val`) VALUES('54','WATERMARK_MIN_WIDTH','400');
INSERT INTO ss_parameters(`id`,`key`,`val`) VALUES('55','WATERMARK_MIN_HEIGHT','300');
INSERT INTO ss_parameters(`id`,`key`,`val`) VALUES('56','WATERMARK_TYPE','2');
INSERT INTO ss_parameters(`id`,`key`,`val`) VALUES('57','WATERMARK_QUALITY','75');
INSERT INTO ss_parameters(`id`,`key`,`val`) VALUES('58','WATERMARK_TEXT','水印文字');
INSERT INTO ss_parameters(`id`,`key`,`val`) VALUES('59','WATERMARK_TEXT_SIZE','24');
INSERT INTO ss_parameters(`id`,`key`,`val`) VALUES('60','WATERMARK_TEXT_ANGLE','0');
INSERT INTO ss_parameters(`id`,`key`,`val`) VALUES('61','WATERMARK_TEXT_COLOR','#000000');
INSERT INTO ss_parameters(`id`,`key`,`val`) VALUES('62','WATERMARK_TEXT_SHADOWX','1');
INSERT INTO ss_parameters(`id`,`key`,`val`) VALUES('63','WATERMARK_TEXT_SHADOWY','1');
INSERT INTO ss_parameters(`id`,`key`,`val`) VALUES('64','WATERMARK_TEXT_SHADOW_COLOR','#000000');
INSERT INTO ss_parameters(`id`,`key`,`val`) VALUES('65','WATERMARK_PNG','images/watermark.png');
INSERT INTO ss_parameters(`id`,`key`,`val`) VALUES('66','ADVERT_STATUS','0');
INSERT INTO ss_parameters(`id`,`key`,`val`) VALUES('67','ADVERT_THEME','');
INSERT INTO ss_parameters(`id`,`key`,`val`) VALUES('68','ADVERT_TEXT','');
INSERT INTO ss_parameters(`id`,`key`,`val`) VALUES('69','ADVERT_TEXT_SIZE','32');
INSERT INTO ss_parameters(`id`,`key`,`val`) VALUES('70','ADVERT_TEXT_COLOR','#000000');
INSERT INTO ss_parameters(`id`,`key`,`val`) VALUES('71','ADVERT_URL','http://www.example.com');
INSERT INTO ss_parameters(`id`,`key`,`val`) VALUES('72','ADVERT_RTHEME','');
INSERT INTO ss_parameters(`id`,`key`,`val`) VALUES('73','ADVERT_RTEXT','');
INSERT INTO ss_parameters(`id`,`key`,`val`) VALUES('74','ADVERT_RTEXT_SIZE','32');
INSERT INTO ss_parameters(`id`,`key`,`val`) VALUES('75','ADVERT_RTEXT_COLOR','#000000');
INSERT INTO ss_parameters(`id`,`key`,`val`) VALUES('76','ADVERT_RURL','http://www.example.com');
INSERT INTO ss_parameters(`id`,`key`,`val`) VALUES('77','TABLE_CACHE','1');
INSERT INTO ss_parameters(`id`,`key`,`val`) VALUES('78','EXCHANGE_SWITCH','1');
INSERT INTO ss_parameters(`id`,`key`,`val`) VALUES('79','QQ_ONLINE','0');
INSERT INTO ss_parameters(`id`,`key`,`val`) VALUES('80','QQ_ONLINE_TITLE','');
INSERT INTO ss_parameters(`id`,`key`,`val`) VALUES('81','QQ_ONLINE_POS','left');
INSERT INTO ss_parameters(`id`,`key`,`val`) VALUES('82','ADVERT_LTARGET','_blank');
INSERT INTO ss_parameters(`id`,`key`,`val`) VALUES('83','ADVERT_RTARGET','_blank');
INSERT INTO ss_parameters(`id`,`key`,`val`) VALUES('84','LICENCE_TIME','1382544000');
INSERT INTO ss_parameters(`id`,`key`,`val`) VALUES('85','LICENCE_CHECK_SUM','fc94e3303a6a6075a97083bc51da8ffd');
INSERT INTO ss_parameters(`id`,`key`,`val`) VALUES('86','ERR_LOG','');
INSERT INTO ss_parameters(`id`,`key`,`val`) VALUES('87','MEMBER_VERIFY','0');
INSERT INTO ss_parameters(`id`,`key`,`val`) VALUES('88','CURRENCY','zh_CN,CNY');
INSERT INTO ss_parameters(`id`,`key`,`val`) VALUES('89','CURRENCY_SIGN','zh_CN,￥');
INSERT INTO ss_parameters(`id`,`key`,`val`) VALUES('90','BACKGROUND_INFO','');
INSERT INTO ss_parameters(`id`,`key`,`val`) VALUES('91','DEFAULT_TPL','jixie-110118-a16');
INSERT INTO ss_parameters(`id`,`key`,`val`) VALUES('92','VERIFY_META','a:1:{s:5:\"zh_CN\";s:0:\"\";}');

DROP TABLE IF EXISTS ss_payment_accounts;
CREATE TABLE `ss_payment_accounts` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `payment_provider_id` int(11) NOT NULL,
  `seller_site_url` varchar(255) DEFAULT NULL,
  `seller_account` varchar(255) DEFAULT NULL,
  `partner_id` varchar(255) NOT NULL,
  `partner_key` varchar(255) NOT NULL,
  `enabled` enum('0','1') NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`)
) ENGINE=MyISAM AUTO_INCREMENT=10 DEFAULT CHARSET=utf8;

INSERT INTO ss_payment_accounts(`id`,`payment_provider_id`,`seller_site_url`,`seller_account`,`partner_id`,`partner_key`,`enabled`) VALUES('1','1','','','','','');
INSERT INTO ss_payment_accounts(`id`,`payment_provider_id`,`seller_site_url`,`seller_account`,`partner_id`,`partner_key`,`enabled`) VALUES('2','2','','','','','');
INSERT INTO ss_payment_accounts(`id`,`payment_provider_id`,`seller_site_url`,`seller_account`,`partner_id`,`partner_key`,`enabled`) VALUES('6','6','','','','','');
INSERT INTO ss_payment_accounts(`id`,`payment_provider_id`,`seller_site_url`,`seller_account`,`partner_id`,`partner_key`,`enabled`) VALUES('7','7','','','','','');
INSERT INTO ss_payment_accounts(`id`,`payment_provider_id`,`seller_site_url`,`seller_account`,`partner_id`,`partner_key`,`enabled`) VALUES('8','8','','','','','');
INSERT INTO ss_payment_accounts(`id`,`payment_provider_id`,`seller_site_url`,`seller_account`,`partner_id`,`partner_key`,`enabled`) VALUES('9','9','','','','','');
INSERT INTO ss_payment_accounts(`id`,`payment_provider_id`,`seller_site_url`,`seller_account`,`partner_id`,`partner_key`,`enabled`) VALUES('3','3','','','','','');
INSERT INTO ss_payment_accounts(`id`,`payment_provider_id`,`seller_site_url`,`seller_account`,`partner_id`,`partner_key`,`enabled`) VALUES('4','4','','','','','');
INSERT INTO ss_payment_accounts(`id`,`payment_provider_id`,`seller_site_url`,`seller_account`,`partner_id`,`partner_key`,`enabled`) VALUES('5','5','','','','','');

DROP TABLE IF EXISTS ss_payment_providers;
CREATE TABLE `ss_payment_providers` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `name` varchar(255) NOT NULL,
  `disp_name` varchar(255) NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=MyISAM AUTO_INCREMENT=10 DEFAULT CHARSET=utf8;

INSERT INTO ss_payment_providers(`id`,`name`,`disp_name`) VALUES('1','alipay','支付宝');
INSERT INTO ss_payment_providers(`id`,`name`,`disp_name`) VALUES('2','99bill','快钱');
INSERT INTO ss_payment_providers(`id`,`name`,`disp_name`) VALUES('6','alipaymed','支付宝中介担保');
INSERT INTO ss_payment_providers(`id`,`name`,`disp_name`) VALUES('7','alipayimd','支付宝即时到账');
INSERT INTO ss_payment_providers(`id`,`name`,`disp_name`) VALUES('8','paypalen','PayPal(外卡帐号)');
INSERT INTO ss_payment_providers(`id`,`name`,`disp_name`) VALUES('9','moneybookers','MONEYBOOKERS');
INSERT INTO ss_payment_providers(`id`,`name`,`disp_name`) VALUES('3','paypal','中国贝宝');
INSERT INTO ss_payment_providers(`id`,`name`,`disp_name`) VALUES('4','tencentmed','财付通中介担保');
INSERT INTO ss_payment_providers(`id`,`name`,`disp_name`) VALUES('5','tencentimd','财付通立即到账');

DROP TABLE IF EXISTS ss_product_categories;
CREATE TABLE `ss_product_categories` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `name` varchar(255) NOT NULL,
  `alias` varchar(255) NOT NULL,
  `product_category_id` int(11) NOT NULL DEFAULT '0',
  `i_order` int(11) NOT NULL DEFAULT '0',
  `s_locale` varchar(50) NOT NULL,
  `published` enum('0','1') NOT NULL DEFAULT '1',
  `for_roles` varchar(50) NOT NULL DEFAULT '{guest}',
  PRIMARY KEY (`id`),
  KEY `alias` (`alias`),
  KEY `product_category_id` (`product_category_id`),
  KEY `i_order` (`i_order`),
  KEY `s_locale` (`s_locale`),
  KEY `published` (`published`),
  KEY `for_roles` (`for_roles`)
) ENGINE=MyISAM AUTO_INCREMENT=77 DEFAULT CHARSET=utf8;

INSERT INTO ss_product_categories(`id`,`name`,`alias`,`product_category_id`,`i_order`,`s_locale`,`published`,`for_roles`) VALUES('1','衣服鞋帽','cap_0lLfUJtm','0','1','zh_CN','1','{member}{admin}{guest}');
INSERT INTO ss_product_categories(`id`,`name`,`alias`,`product_category_id`,`i_order`,`s_locale`,`published`,`for_roles`) VALUES('2','衣服鞋帽','cap_hN8U1GkM','0','2','zh_CN','1','{member}{admin}{guest}');
INSERT INTO ss_product_categories(`id`,`name`,`alias`,`product_category_id`,`i_order`,`s_locale`,`published`,`for_roles`) VALUES('3','背包','cap_mAO02WUl','0','4','zh_CN','1','{member}{admin}{guest}');
INSERT INTO ss_product_categories(`id`,`name`,`alias`,`product_category_id`,`i_order`,`s_locale`,`published`,`for_roles`) VALUES('4','帐篷睡袋','cap_wha3c08f','0','3','zh_CN','1','{member}{admin}{guest}');
INSERT INTO ss_product_categories(`id`,`name`,`alias`,`product_category_id`,`i_order`,`s_locale`,`published`,`for_roles`) VALUES('5','炊具','cap_gGwq02Gq','0','5','zh_CN','1','{member}{admin}{guest}');
INSERT INTO ss_product_categories(`id`,`name`,`alias`,`product_category_id`,`i_order`,`s_locale`,`published`,`for_roles`) VALUES('6','灯具','cap_Cp7T1pvG','0','6','zh_CN','1','{member}{admin}{guest}');
INSERT INTO ss_product_categories(`id`,`name`,`alias`,`product_category_id`,`i_order`,`s_locale`,`published`,`for_roles`) VALUES('7','水具','cap_tQaB8Q9r','0','7','zh_CN','1','{member}{admin}{guest}');
INSERT INTO ss_product_categories(`id`,`name`,`alias`,`product_category_id`,`i_order`,`s_locale`,`published`,`for_roles`) VALUES('9','户外防护服装','cap_e4Bv0MN8','-1','1','zh_CN','1','{member}{admin}{guest}');
INSERT INTO ss_product_categories(`id`,`name`,`alias`,`product_category_id`,`i_order`,`s_locale`,`published`,`for_roles`) VALUES('11','户外冲锋衣服','cap_ioyK0FA3','8','1','zh_CN','1','{member}{admin}{guest}');
INSERT INTO ss_product_categories(`id`,`name`,`alias`,`product_category_id`,`i_order`,`s_locale`,`published`,`for_roles`) VALUES('66','鞋帽','cap_U3NXl7FZ','2','1','zh_CN','1','{member}{admin}{guest}');
INSERT INTO ss_product_categories(`id`,`name`,`alias`,`product_category_id`,`i_order`,`s_locale`,`published`,`for_roles`) VALUES('68','帐篷','cap_ypXfyt4S','4','2','zh_CN','1','{member}{admin}{guest}');
INSERT INTO ss_product_categories(`id`,`name`,`alias`,`product_category_id`,`i_order`,`s_locale`,`published`,`for_roles`) VALUES('67','睡袋','cap_z197F8mL','4','1','zh_CN','1','{member}{admin}{guest}');
INSERT INTO ss_product_categories(`id`,`name`,`alias`,`product_category_id`,`i_order`,`s_locale`,`published`,`for_roles`) VALUES('65','衣物','cap_i1Qr3chB','2','1','zh_CN','1','{member}{admin}{guest}');
INSERT INTO ss_product_categories(`id`,`name`,`alias`,`product_category_id`,`i_order`,`s_locale`,`published`,`for_roles`) VALUES('76','工具','cap_dQAhgbpm','7','2','zh_CN','1','{member}{admin}{guest}');
INSERT INTO ss_product_categories(`id`,`name`,`alias`,`product_category_id`,`i_order`,`s_locale`,`published`,`for_roles`) VALUES('75','饮用','cap_BOZaqVt4','7','1','zh_CN','1','{member}{admin}{guest}');
INSERT INTO ss_product_categories(`id`,`name`,`alias`,`product_category_id`,`i_order`,`s_locale`,`published`,`for_roles`) VALUES('74','室内类','cap_HpzKIBjE','6','2','zh_CN','1','{member}{admin}{guest}');
INSERT INTO ss_product_categories(`id`,`name`,`alias`,`product_category_id`,`i_order`,`s_locale`,`published`,`for_roles`) VALUES('73','室外类','cap_x4hu1I9m','6','1','zh_CN','1','{member}{admin}{guest}');
INSERT INTO ss_product_categories(`id`,`name`,`alias`,`product_category_id`,`i_order`,`s_locale`,`published`,`for_roles`) VALUES('72','烹饪类','cap_7fil1hSu','5','2','zh_CN','1','{member}{admin}{guest}');
INSERT INTO ss_product_categories(`id`,`name`,`alias`,`product_category_id`,`i_order`,`s_locale`,`published`,`for_roles`) VALUES('71','饮水类','cap_0d7Bru6r','5','1','zh_CN','1','{member}{admin}{guest}');
INSERT INTO ss_product_categories(`id`,`name`,`alias`,`product_category_id`,`i_order`,`s_locale`,`published`,`for_roles`) VALUES('70','小号','cap_D9y0T0V2','3','2','zh_CN','1','{member}{admin}{guest}');
INSERT INTO ss_product_categories(`id`,`name`,`alias`,`product_category_id`,`i_order`,`s_locale`,`published`,`for_roles`) VALUES('69','大号','cap_Sr6z6Giy','3','1','zh_CN','1','{member}{admin}{guest}');

DROP TABLE IF EXISTS ss_product_pics;
CREATE TABLE `ss_product_pics` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `product_id` int(11) NOT NULL,
  `pic` varchar(255) COLLATE utf8_unicode_ci NOT NULL,
  PRIMARY KEY (`id`),
  KEY `product_id` (`product_id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;


DROP TABLE IF EXISTS ss_products;
CREATE TABLE `ss_products` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `name` varchar(255) NOT NULL,
  `i_order` int(11) NOT NULL DEFAULT '0',
  `feature_img` varchar(255) DEFAULT NULL,
  `feature_smallimg` varchar(255) DEFAULT NULL,
  `introduction` text NOT NULL,
  `description` longtext,
  `price` decimal(16,2) NOT NULL DEFAULT '0.00',
  `discount_price` decimal(16,2) NOT NULL DEFAULT '0.00',
  `delivery_fee` decimal(16,2) NOT NULL DEFAULT '0.00',
  `online_orderable` enum('0','1') NOT NULL DEFAULT '1',
  `recommended` enum('0','1') NOT NULL DEFAULT '0',
  `create_time` bigint(20) NOT NULL,
  `product_category_id` int(11) NOT NULL DEFAULT '0',
  `s_locale` varchar(50) NOT NULL,
  `pub_start_time` bigint(20) NOT NULL,
  `pub_end_time` bigint(20) NOT NULL,
  `published` enum('0','1') NOT NULL DEFAULT '1',
  `for_roles` varchar(50) NOT NULL DEFAULT '{guest}',
  `is_seo` enum('0','1') DEFAULT '0',
  `meta_key` text,
  `meta_desc` text,
  PRIMARY KEY (`id`),
  KEY `name` (`name`),
  KEY `recommended` (`recommended`),
  KEY `create_time` (`create_time`),
  KEY `product_category_id` (`product_category_id`),
  KEY `s_locale` (`s_locale`),
  KEY `pub_start_time` (`pub_start_time`),
  KEY `pub_end_time` (`pub_end_time`),
  KEY `published` (`published`),
  KEY `for_roles` (`for_roles`),
  FULLTEXT KEY `description` (`description`)
) ENGINE=MyISAM AUTO_INCREMENT=49 DEFAULT CHARSET=utf8;

INSERT INTO ss_products(`id`,`name`,`i_order`,`feature_img`,`feature_smallimg`,`introduction`,`description`,`price`,`discount_price`,`delivery_fee`,`online_orderable`,`recommended`,`create_time`,`product_category_id`,`s_locale`,`pub_start_time`,`pub_end_time`,`published`,`for_roles`,`is_seo`,`meta_key`,`meta_desc`) VALUES('1','户外冲锋衣服','1','upload/image/mark_f8oHF6lK.jpg','upload/image/f8oHF6lK.jpg','户外冲锋衣服','<p align=\"left\"><font size=\"4\"><img height=\"600\" alt=\"\" width=\"600\" src=\"/admin/fckeditor/upload/../../../upload/image/12(5).jpg\" />&nbsp;&nbsp;&nbsp;</font></p>\r\n<p align=\"left\"><font size=\"4\">冲锋衣不仅可以去专业登山,户外活动.还可以配合旅游,野营,外出聚餐等等.都是最最合适的装备.不仅如此,就算穿着去上班也是一件豪华的外套.<br />\r\n</font></p>\r\n<p align=\"left\"><font size=\"4\">材质：Gore-Tex Xcr，防水、防风，透气性能良好。<br />\r\n</font></p>\r\n<p align=\"left\"><font size=\"4\">特殊设计：网格防撕Polyster ,内部抓绒设计,腰部采用高性能尼龙松紧带，两侧大拉链可全拉开，不脱鞋也可穿上。 带可拆卸式背带，方便腰围调整和穿脱！膝部裤型设计符合人体工体学,方便运动和穿用，适用于专业级的登山,山地行走。</font></p>','100.00','1.00','0.00','1','1','1276776964','65','zh_CN','-1','-1','1','{member}{admin}{guest}','0','','');
INSERT INTO ss_products(`id`,`name`,`i_order`,`feature_img`,`feature_smallimg`,`introduction`,`description`,`price`,`discount_price`,`delivery_fee`,`online_orderable`,`recommended`,`create_time`,`product_category_id`,`s_locale`,`pub_start_time`,`pub_end_time`,`published`,`for_roles`,`is_seo`,`meta_key`,`meta_desc`) VALUES('2','户外防护服装','2','upload/image/mark_sVSGNYuR.jpg','upload/image/sVSGNYuR.jpg','空调衣服，冷暖双制服，防热服，户外防护服装\r\n\r\n','<p><img height=\"600\" alt=\"\" width=\"600\" src=\"/admin/fckeditor/upload/../../../upload/image/12(4).jpg\" /><br />\r\n<font size=\"4\">&nbsp;可制冷，可制热，一物多用，如冷暖双制空调，随心所欲。冬天可保暖，夏日可降温，制冷热时间长，深受各类用户的喜爱。&nbsp;<br />\r\n&nbsp;</font></p>\r\n<p><font size=\"4\">*抵御热辐射的铠甲，防护高温伤害的盾牌，降低人体温度最有效、最经济及最简便的途径。<br />\r\n</font></p>\r\n<p><font size=\"4\">*马夹式外观，可内穿外穿。涤棉布，可洗刷，可长期舒适穿用。马甲中的蓄能袋可反复冷冻（加热），保冷热时间长，效果显著。贴体温度适中，冷热可调，对人体无刺激无伤害。物理原理，绝无污染。蓄能袋与马甲分体，轻便、方便、灵活。</font></p>','100.00','99.00','0.00','1','1','1276777312','65','zh_CN','-1','-1','1','{member}{admin}{guest}','0','','');
INSERT INTO ss_products(`id`,`name`,`i_order`,`feature_img`,`feature_smallimg`,`introduction`,`description`,`price`,`discount_price`,`delivery_fee`,`online_orderable`,`recommended`,`create_time`,`product_category_id`,`s_locale`,`pub_start_time`,`pub_end_time`,`published`,`for_roles`,`is_seo`,`meta_key`,`meta_desc`) VALUES('3','户外裤冲锋裤登山裤','3','upload/image/mark_Cq7t3XuA.jpg','upload/image/Cq7t3XuA.jpg','户外裤冲锋裤登山裤\r\n\r\n','<p align=\"center\"><img height=\"562\" alt=\"\" width=\"429\" src=\"/admin/fckeditor/upload/../../../upload/image/12(3).jpg\" /></p>\r\n<p align=\"left\">&nbsp;</p>\r\n<p align=\"left\"><font size=\"4\">1.裤型立体栽剪更适体;</font></p>\r\n<p align=\"left\"><font size=\"4\">2.多袋工装设计，潮流户外;</font></p>\r\n<p align=\"left\"><font size=\"4\">3.高强度;</font></p>\r\n<p align=\"left\"><font size=\"4\">4,杜邦专业面料</font></p>\r\n<p align=\"left\"><font size=\"4\">性能:防泼水，耐磨; 透气</font></p>\r\n<p align=\"left\"><font size=\"4\">用途:户外，运动;</font></p>','100.00','99.00','0.00','1','1','1276777885','65','zh_CN','-1','-1','1','{member}{admin}{guest}','0','','');
INSERT INTO ss_products(`id`,`name`,`i_order`,`feature_img`,`feature_smallimg`,`introduction`,`description`,`price`,`discount_price`,`delivery_fee`,`online_orderable`,`recommended`,`create_time`,`product_category_id`,`s_locale`,`pub_start_time`,`pub_end_time`,`published`,`for_roles`,`is_seo`,`meta_key`,`meta_desc`) VALUES('4','丛林户外帽子','4','upload/image/mark_brzWd0Vn.jpg','upload/image/brzWd0Vn.jpg','丛林户外帽子\r\n','<p align=\"center\"><img height=\"310\" alt=\"\" width=\"310\" src=\"/admin/fckeditor/upload/../../../upload/image/12(2).jpg\" /></p>\r\n<p><font size=\"4\">颜色：红色、深蓝、卡其、灰色、军绿，粉红</font></p>\r\n<p><font size=\"4\">特色：360度方位设计保护防晒，防蚊虫设计，</font></p>\r\n<p><font size=\"4\">在顶有透气排汗的网面设计，帽的脖子保护侧盖和正面的保护面盖可以根据实际的户外环境随意增加和拆除，帽的固定绳带也可以随意装卸，帽子的后面可以弹力+快速扣人工调节帽子的大小头围</font></p>\r\n<p><font size=\"4\">正面的面盖的口鼻部位有专门的网面设计，方面呼吸和透气哦，特别合适户外松林等地的保护和安全</font></p>','100.00','1.00','0.00','1','1','1276778015','65','zh_CN','-1','-1','1','{member}{admin}{guest}','0','','');
INSERT INTO ss_products(`id`,`name`,`i_order`,`feature_img`,`feature_smallimg`,`introduction`,`description`,`price`,`discount_price`,`delivery_fee`,`online_orderable`,`recommended`,`create_time`,`product_category_id`,`s_locale`,`pub_start_time`,`pub_end_time`,`published`,`for_roles`,`is_seo`,`meta_key`,`meta_desc`) VALUES('5','防紫外線戶外帽','1','upload/image/mark_KnpB0yRK.jpg','upload/image/KnpB0yRK.jpg','防紫外線戶外帽\r\n','<p align=\"center\"><img height=\"310\" alt=\"\" width=\"310\" src=\"/admin/fckeditor/upload/../../../upload/image/12(1).jpg\" /></p>\r\n<p><br />\r\n<font size=\"4\">全新款式帽子，專為女生而設計，容易配襯服裝，高貴優雅！<br />\r\n特點：Sun Dancer 戶外活動帽子設計有特闊大後散式遮陽布 (19cm長)，適合女生配戴，配襯衣服，高貴優雅：旅遊、野外活動、沙漠、園藝、釣魚、戶外工作等。<br />\r\n帽子顏色： Cream 灰白色、African Violet 紫色、Periwinkle 藍色</font></p>\r\n<p>&nbsp;</p>\r\n<p>&nbsp;</p>','100.00','99.00','0.00','1','1','1276778230','66','zh_CN','-1','-1','1','{member}{admin}{guest}','0','','');
INSERT INTO ss_products(`id`,`name`,`i_order`,`feature_img`,`feature_smallimg`,`introduction`,`description`,`price`,`discount_price`,`delivery_fee`,`online_orderable`,`recommended`,`create_time`,`product_category_id`,`s_locale`,`pub_start_time`,`pub_end_time`,`published`,`for_roles`,`is_seo`,`meta_key`,`meta_desc`) VALUES('6','网布透气户外鞋','2','upload/image/mark_ISGqgS28.jpg','upload/image/ISGqgS28.jpg','网布透气户外鞋\r\n','<p align=\"center\"><img height=\"307\" alt=\"\" width=\"563\" src=\"/admin/fckeditor/upload/../../../upload/image/12.jpg\" /></p>\r\n<p>&nbsp;<br />\r\n<font size=\"4\">【 材质】：透气薄膜&middot;耐磨的人造面料鞋面、带有X-2垫片的超轻双密度压模EVA中底，提供有效缓冲、创新的ESS前足Snake Plate，既能免受石块擦伤，又不影响灵活性</font></p>\r\n<p><font size=\"4\">【特点】：配有透气孔，可提高透气性，宽边和规则鞋带鞋孔可根据个人喜好自由调整、增大鞋的防滑性能、TPU承托板提供最佳支持和稳固性防护性强</font></p>\r\n<p><font size=\"4\">【尺码】：（标准码）</font></p>','100.00','1.00','0.00','1','1','1276778623','66','zh_CN','-1','-1','1','{member}{admin}{guest}','0','','');
INSERT INTO ss_products(`id`,`name`,`i_order`,`feature_img`,`feature_smallimg`,`introduction`,`description`,`price`,`discount_price`,`delivery_fee`,`online_orderable`,`recommended`,`create_time`,`product_category_id`,`s_locale`,`pub_start_time`,`pub_end_time`,`published`,`for_roles`,`is_seo`,`meta_key`,`meta_desc`) VALUES('7','头层牛皮 户外鞋','3','upload/image/mark_AOJxBVq6.jpg','upload/image/AOJxBVq6.jpg','头层牛皮 户外鞋\r\n','<p align=\"center\"><img height=\"482\" alt=\"\" width=\"496\" src=\"/admin/fckeditor/upload/../../../upload/image/mark(5).jpg\" /></p>\r\n<p align=\"left\"><font size=\"4\">鞋面：采用上等头层牛皮，质量强硬.更显档次。<br />\r\n内里：四面弹网布，柔软舒适，速干。<br />\r\n鞋底：PU+橡胶组成，PU比MD更贵，超级柔软，减震，防臭，透气。<br />\r\n用途:沙滩鞋,涉水鞋，钓鱼鞋，夏季徒步鞋</font></p>','100.00','1.00','0.00','1','1','1276778802','66','zh_CN','-1','-1','1','{member}{admin}{guest}','0','','');
INSERT INTO ss_products(`id`,`name`,`i_order`,`feature_img`,`feature_smallimg`,`introduction`,`description`,`price`,`discount_price`,`delivery_fee`,`online_orderable`,`recommended`,`create_time`,`product_category_id`,`s_locale`,`pub_start_time`,`pub_end_time`,`published`,`for_roles`,`is_seo`,`meta_key`,`meta_desc`) VALUES('8','登山徒步鞋','4','upload/image/mark_IpK0F4Hs.jpg','upload/image/IpK0F4Hs.jpg','登山鞋 休闲鞋 户外鞋 徒步鞋\r\n','<p><font size=\"4\">【面料】：采用头层反绒牛皮<br />\r\n【大底】：橡胶发泡，比橡胶底更轻、软、防滑、耐磨；穿着更舒适，绝不塔底！<br />\r\n【内里】：猪皮内里，透气、凉快---很适合夏天穿</font></p>\r\n<p><img height=\"419\" alt=\"\" width=\"650\" src=\"/admin/fckeditor/upload/../../../upload/image/mark(4).jpg\" /></p>','100.00','1.00','0.00','1','1','1276778960','66','zh_CN','-1','-1','1','{member}{admin}{guest}','0','','');
INSERT INTO ss_products(`id`,`name`,`i_order`,`feature_img`,`feature_smallimg`,`introduction`,`description`,`price`,`discount_price`,`delivery_fee`,`online_orderable`,`recommended`,`create_time`,`product_category_id`,`s_locale`,`pub_start_time`,`pub_end_time`,`published`,`for_roles`,`is_seo`,`meta_key`,`meta_desc`) VALUES('9','户外帐篷SY','1','upload/image/mark_X6wabvgg.jpg','upload/image/X6wabvgg.jpg','户外帐篷SY','<p align=\"left\"><font color=\"#000000\" size=\"3\">【商品规格】200(长)X200(宽)X135(高)CM</font></p>\r\n<p align=\"left\"><font color=\"#000000\"><font size=\"3\">【</font><font size=\"3\">商品材料】外帐:防水防风防紫外线银胶布,防水PU1000MM以上;内帐:透气绦丝布;底帐:120D牛津布,防水PU1500MM以上;帐杆:高强度7.9MM纤维杆</font></font></p>\r\n<p align=\"left\"><font color=\"#000000\" size=\"3\">【商品结构】双层,一门一后窗(产品后续生产可能会有变动,按实物为主),门和窗处另有一层白纱,可防虫,通风.</font></p>\r\n<p align=\"left\"><font color=\"#000000\" size=\"3\">【商品配件】帐布一套(包括底帐),帐杆一付,地钉一付，防风绳一付,手拎袋一只.(不用另购配件,内已配齐)</font></p>\r\n<p align=\"left\"><font color=\"#000000\" size=\"3\">【商品特点】空间较大,结构稳定,通风性能好,适用面广,可户外露营,公园小憩,阳台乘凉，也可在家里使用哦！不用时卷好收于随帐篷附带的手拎袋中，体积只有10X60CM左右,可拎,可挎,非常方便.</font></p>','100.00','1.00','0.00','1','1','1276779207','68','zh_CN','-1','-1','1','{member}{admin}{guest}','0','','');
INSERT INTO ss_products(`id`,`name`,`i_order`,`feature_img`,`feature_smallimg`,`introduction`,`description`,`price`,`discount_price`,`delivery_fee`,`online_orderable`,`recommended`,`create_time`,`product_category_id`,`s_locale`,`pub_start_time`,`pub_end_time`,`published`,`for_roles`,`is_seo`,`meta_key`,`meta_desc`) VALUES('10','铝杆帐篷','2','upload/image/mark_ue0NbPSS.jpg','upload/image/ue0NbPSS.jpg','铝杆帐篷','<p><font size=\"3\">【品名】：双层6人压胶六角帐篷 </font></p>\r\n<p><font size=\"3\">【规格】:2.4米*2.4米*1.45米 </font></p>\r\n<p><font size=\"3\">【外帐】：190T涤丝纺 ，防水2000MM（中到大雨），线脚PU压胶 </font></p>\r\n<p><font size=\"3\">【内帐】：透气尼龙布内置防蚊虫纱门,内帐可单独使用 </font></p>\r\n<p><font size=\"3\">【底部】：210D牛津布，更耐磨 防水10000MM，（接线处压胶处理】</font></p>\r\n<p><font size=\"3\">【帐杆】：高强度玻璃杆子 </font></p>\r\n<p><font size=\"3\">【配件】：地钉6根 </font></p>\r\n<p><font size=\"3\">【重量】：3.5KG </font></p>\r\n<p><font size=\"3\">【特点】：防水性强，接线处压胶处理（中到大雨防水），四面通风对流</font></p>','100.00','1.00','0.00','1','1','1277217875','68','zh_CN','-1','-1','1','{member}{admin}{guest}','0','','');
INSERT INTO ss_products(`id`,`name`,`i_order`,`feature_img`,`feature_smallimg`,`introduction`,`description`,`price`,`discount_price`,`delivery_fee`,`online_orderable`,`recommended`,`create_time`,`product_category_id`,`s_locale`,`pub_start_time`,`pub_end_time`,`published`,`for_roles`,`is_seo`,`meta_key`,`meta_desc`) VALUES('11','多人帐篷','3','upload/image/mark_owkRnqSg.jpg','upload/image/owkRnqSg.jpg','多人帐篷','<p><font size=\"3\">【尺寸】：长460（230+230）X宽305X高210cm </font></p>\r\n<p>&nbsp;</p>\r\n<p><font size=\"3\">【产品描述】： 三房设计双层8-10人帐篷。外帐整件压PU防水胶条，大外帐包到底，</font></p>\r\n<p><font size=\"3\">增强防雨`防风保暖性能。外帐可拿掉，内帐可单独使用，前后门设计，更透风更明</font></p>\r\n<p><font size=\"3\">亮，进出更方便。前门配有2根度锌铁管，把门盖如图撑起来，厅就立刻变大，变高，</font></p>\r\n<p><font size=\"3\">变长。侧面、后面各有2个窗。 内帐采用防蚊虫网沙，此设计即透风又防水还保暖，</font></p>\r\n<p><font size=\"3\">在帐篷 内休息会让你感觉非常舒适。</font></p>','100.00','1.00','0.00','1','1','1277217973','68','zh_CN','-1','-1','1','{member}{admin}{guest}','0','','');
INSERT INTO ss_products(`id`,`name`,`i_order`,`feature_img`,`feature_smallimg`,`introduction`,`description`,`price`,`discount_price`,`delivery_fee`,`online_orderable`,`recommended`,`create_time`,`product_category_id`,`s_locale`,`pub_start_time`,`pub_end_time`,`published`,`for_roles`,`is_seo`,`meta_key`,`meta_desc`) VALUES('12','双层帐篷','4','upload/image/mark_q6gp28gq.jpg','upload/image/q6gp28gq.jpg','双层帐篷','<p><font size=\"3\">1、双层，有效防止结露现象。 </font></p>\r\n<p>&nbsp;</p>\r\n<p><font size=\"3\">2、内帐两侧全网纱，双开门，透气性超好。 </font></p>\r\n<p>&nbsp;</p>\r\n<p><font size=\"3\">3、侧边大窗户，以增加空气流通。 </font></p>\r\n<p>&nbsp;</p>\r\n<p><font size=\"3\">4、内帐设计有帐篷门储藏袋看起来更加简洁，内篷两侧均有储物袋可放手机皮夹钥匙等各种物品。</font></p>\r\n<p>&nbsp;</p>\r\n<p><font size=\"3\">5、内帐顶部有可挂照明灯的吊环。 </font></p>\r\n<p>&nbsp;</p>\r\n<p><font size=\"3\">6、外帐后延伸空间，可放背包等装备。前延伸空间铺有地席，可供玩耍，煮饭以及就餐等。 </font></p>\r\n<p>&nbsp;</p>\r\n<p><font size=\"3\">7、20支地钉，8条防风绳加强帐篷的稳固，令您野外无惧风雨。 包装附件：外帐1个、内帐1个、前厅地席1张、尼龙包装袋1个、支撑杆（玻璃纤维3根，前门铁杆2根）、地钉20支、防风绳8条、说明组装图1份</font></p>','100.00','1.00','0.00','1','1','1277218091','68','zh_CN','-1','-1','1','{member}{admin}{guest}','0','','');
INSERT INTO ss_products(`id`,`name`,`i_order`,`feature_img`,`feature_smallimg`,`introduction`,`description`,`price`,`discount_price`,`delivery_fee`,`online_orderable`,`recommended`,`create_time`,`product_category_id`,`s_locale`,`pub_start_time`,`pub_end_time`,`published`,`for_roles`,`is_seo`,`meta_key`,`meta_desc`) VALUES('13','双人睡袋','1','upload/image/mark_VIcAiU1J.jpg','upload/image/VIcAiU1J.jpg','双人睡袋','<p><font size=\"3\">尺寸:（190+40）*75CM </font></p>\r\n<p>&nbsp;</p>\r\n<p><font size=\"3\">面料:210T格子涤沦(防泼水)压光</font></p>\r\n<p>&nbsp;</p>\r\n<p><font size=\"3\">里料:240T春亚纺防泼水压光填充:2*175/平方米 </font></p>\r\n<p>&nbsp;</p>\r\n<p><font size=\"3\">七孔棉温标: -15℃ 0℃ +15℃(极限温度-15摄氏度) 配置:有领围/挡风墙/内袋,领围拉链一侧有防咬带包装:210D牛筋压缩袋</font></p>\r\n<p>&nbsp;</p>\r\n<p><font size=\"3\">重量:1.85KG</font></p>','100.00','1.00','0.00','1','1','1277218256','67','zh_CN','-1','-1','1','{member}{admin}{guest}','0','','');
INSERT INTO ss_products(`id`,`name`,`i_order`,`feature_img`,`feature_smallimg`,`introduction`,`description`,`price`,`discount_price`,`delivery_fee`,`online_orderable`,`recommended`,`create_time`,`product_category_id`,`s_locale`,`pub_start_time`,`pub_end_time`,`published`,`for_roles`,`is_seo`,`meta_key`,`meta_desc`) VALUES('14','春夏单人迷彩睡袋','2','upload/image/mark_SltSNcZX.jpg','upload/image/SltSNcZX.jpg','春夏单人迷彩睡袋','<p align=\"center\"><font size=\"4\"><img height=\"310\" alt=\"\" width=\"310\" src=\"/admin/fckeditor/upload/../../../upload/image/12(7).jpg\" /></font></p>\r\n<p><br />\r\n<font size=\"3\">面料: 弄龙&nbsp;<br />\r\n里料: 棉&nbsp;<br />\r\n填充物: 无 温标: 0-20℃&nbsp;<br />\r\n极限温标: 10<br />\r\n总重量: 1.21kg<br />\r\n货号: SY-066<br />\r\n睡袋分类: 棉睡袋&nbsp;<br />\r\n睡袋款式: 信封式&nbsp;<br />\r\n睡袋温标分类: 春秋睡袋 舒适温标: [高于15℃]<br />\r\n产地: 中国&nbsp;<br />\r\n颜色: 浅灰色&nbsp;<br />\r\n尺码: 均码&nbsp;<br />\r\n户外项目: 露营</font></p>','100.00','1.00','0.00','1','1','1277218381','67','zh_CN','-1','-1','1','{member}{admin}{guest}','0','','');
INSERT INTO ss_products(`id`,`name`,`i_order`,`feature_img`,`feature_smallimg`,`introduction`,`description`,`price`,`discount_price`,`delivery_fee`,`online_orderable`,`recommended`,`create_time`,`product_category_id`,`s_locale`,`pub_start_time`,`pub_end_time`,`published`,`for_roles`,`is_seo`,`meta_key`,`meta_desc`) VALUES('15','戴帽式睡袋','3','upload/image/mark_8jVxUVd0.jpg','upload/image/8jVxUVd0.jpg','戴帽式睡袋','<p align=\"center\"><font size=\"4\"><img height=\"310\" alt=\"\" width=\"310\" src=\"/admin/fckeditor/upload/../../../upload/image/mark_8jVxUVd0(1).jpg\" /></font></p>\r\n<p><br />\r\n<font size=\"4\">规格: （190+30）*75cm&nbsp;<br />\r\n重量：1.35kg 面料: 190T涤丝纺涂层防泼水里料: 190T春亚纺&nbsp;<br />\r\n填充: 250G/M2中空棉&nbsp;<br />\r\n温标: 0℃~+8℃~+15℃&nbsp;<br />\r\n颜色：蓝拼灰，橙拼灰&nbsp;<br />\r\n外袋：牛津布压缩袋</font></p>','180.00','1.00','0.00','1','1','1277218448','67','zh_CN','-1','-1','1','{member}{admin}{guest}','0','','');
INSERT INTO ss_products(`id`,`name`,`i_order`,`feature_img`,`feature_smallimg`,`introduction`,`description`,`price`,`discount_price`,`delivery_fee`,`online_orderable`,`recommended`,`create_time`,`product_category_id`,`s_locale`,`pub_start_time`,`pub_end_time`,`published`,`for_roles`,`is_seo`,`meta_key`,`meta_desc`) VALUES('16','超轻夏季睡袋','4','upload/image/mark_Mz3Y4VOm.jpg','upload/image/Mz3Y4VOm.jpg','超轻夏季睡袋','<p align=\"left\"><font size=\"4\">&nbsp;<img height=\"245\" width=\"600\" alt=\"\" src=\"/admin/fckeditor/upload/../../../upload/image/12(6).jpg\" /><br />\r\n&nbsp;【尺寸】:(180+30)X75 CM (长度+帽高,肩宽底宽一样)&nbsp;<br />\r\n&nbsp;【面料】:190T透气涤纶布<br />\r\n&nbsp;【里料】:190T 柔软处理透气涤纶布<br />\r\n&nbsp;【中棉】: 200g/平方 涤纶中空棉<br />\r\n&nbsp;【包装】:面料布收缩包,可挎肩.&nbsp;<br />\r\n&nbsp;【包装好的体积】:高37cm X 直径17cm<br />\r\n&nbsp;【温度】适宜温度15-25度,极限温度: 10度左右.&nbsp;<br />\r\n&nbsp;【总重量】:1KG 【使用范围】：户外露营、办公午休、旅馆旅行、午夜值<br />\r\n&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp; 班、家用被子。</font></p>','200.00','180.00','0.00','1','1','1277218628','67','zh_CN','-1','-1','1','{member}{admin}{guest}','0','','');
INSERT INTO ss_products(`id`,`name`,`i_order`,`feature_img`,`feature_smallimg`,`introduction`,`description`,`price`,`discount_price`,`delivery_fee`,`online_orderable`,`recommended`,`create_time`,`product_category_id`,`s_locale`,`pub_start_time`,`pub_end_time`,`published`,`for_roles`,`is_seo`,`meta_key`,`meta_desc`) VALUES('17','背包','1','upload/image/mark_LMXWyZQs.jpg','upload/image/LMXWyZQs.jpg','背包','<p><font size=\"4\">【尺寸】底长30cm 底厚18cm 高50cm(35L） </font></p>\r\n<p>&nbsp;</p>\r\n<p><font size=\"4\">【质地】100%高级进口杜邦防水尼龙(高强度降落伞面料) </font></p>\r\n<p>&nbsp;</p>\r\n<p><font size=\"4\">【颜色】五个颜色（暗红 桔色 草绿 藏青 黑色 ） </font></p>\r\n<p>&nbsp;</p>\r\n<p><font size=\"4\">【背负】：北脸独家专业背负系统，特殊设计的分力板、可调整背包分布重心的束带系统以及腰带，都让这一款背包成为一种高质量的象征。 </font></p>\r\n<p>&nbsp;</p>\r\n<p><font size=\"4\">【肩带】：宽达6.5厘米的宽带，配合顶级泡棉的使用，可以使肩膀长时间不累，同时还具有透湿、排汗的效果。 </font></p>\r\n<p>&nbsp;</p>\r\n<p><font size=\"4\">【面料】：采用600D的抗撕裂弹道尼龙精工制作而成，面料具有防刮、防水、抗撕裂的功能。</font></p>','100.00','1.00','0.00','1','1','1277218787','69','zh_CN','-1','-1','1','{member}{admin}{guest}','0','','');
INSERT INTO ss_products(`id`,`name`,`i_order`,`feature_img`,`feature_smallimg`,`introduction`,`description`,`price`,`discount_price`,`delivery_fee`,`online_orderable`,`recommended`,`create_time`,`product_category_id`,`s_locale`,`pub_start_time`,`pub_end_time`,`published`,`for_roles`,`is_seo`,`meta_key`,`meta_desc`) VALUES('18','登山包','2','upload/image/mark_EHHBAh3N.jpg','upload/image/EHHBAh3N.jpg','登山包','<p><font size=\"4\">材料：防水尼龙 </font></p>\r\n<p>&nbsp;</p>\r\n<p><font size=\"4\">尺寸:宽35CM 高50CM 厚25CM </font></p>\r\n<p>&nbsp;</p>\r\n<p><font size=\"4\">BH：6033</font></p>','100.00','1.00','0.00','1','1','1277218854','69','zh_CN','-1','-1','1','{member}{admin}{guest}','0','','');
INSERT INTO ss_products(`id`,`name`,`i_order`,`feature_img`,`feature_smallimg`,`introduction`,`description`,`price`,`discount_price`,`delivery_fee`,`online_orderable`,`recommended`,`create_time`,`product_category_id`,`s_locale`,`pub_start_time`,`pub_end_time`,`published`,`for_roles`,`is_seo`,`meta_key`,`meta_desc`) VALUES('19','登山包KA','3','upload/image/mark_fVg1tl08.jpg','upload/image/fVg1tl08.jpg','登山包KA','<p><font size=\"4\">尺 寸：70+10 </font></p>\r\n<p>&nbsp;</p>\r\n<p><font size=\"4\">颜 色：大红/橙色/宝兰/天兰</font></p>\r\n<p>&nbsp;</p>\r\n<p><font size=\"4\">气泵式可调节背负系统高度可调整到最理想的位置，适合各种背长。快速简单调节背包的重心到最佳位置依据人体工程学原理设计和裁剪的预成型肩带特制的高弹海绵和高透气网纱奇妙组合使用中产生气压泵效应，带给你最佳的透气并且能最好最舒适地传递重量</font></p>','100.00','1.00','0.00','1','1','1277218911','69','zh_CN','-1','-1','1','{member}{admin}{guest}','0','','');
INSERT INTO ss_products(`id`,`name`,`i_order`,`feature_img`,`feature_smallimg`,`introduction`,`description`,`price`,`discount_price`,`delivery_fee`,`online_orderable`,`recommended`,`create_time`,`product_category_id`,`s_locale`,`pub_start_time`,`pub_end_time`,`published`,`for_roles`,`is_seo`,`meta_key`,`meta_desc`) VALUES('20','双肩户外旅行包','4','upload/image/mark_Pc6hlC3l.jpg','upload/image/Pc6hlC3l.jpg','双肩户外旅行包','<p><font size=\"4\">规格：宽28高85厚25（厘米） </font></p>\r\n<p>&nbsp;</p>\r\n<p><font size=\"4\">容量: 70升 估算 </font></p>\r\n<p>&nbsp;</p>\r\n<p><font size=\"4\">重量：1.8公斤左右 </font></p>\r\n<p>&nbsp;</p>\r\n<p><font size=\"4\">颜色：蓝色 红色&nbsp; </font></p>\r\n<p>&nbsp;</p>\r\n<p><font size=\"4\">用料：高档防水尼龙材料600D，表面防水、防撕裂。</font></p>','100.00','1.00','0.00','1','1','1277219050','69','zh_CN','-1','-1','1','{member}{admin}{guest}','0','','');
INSERT INTO ss_products(`id`,`name`,`i_order`,`feature_img`,`feature_smallimg`,`introduction`,`description`,`price`,`discount_price`,`delivery_fee`,`online_orderable`,`recommended`,`create_time`,`product_category_id`,`s_locale`,`pub_start_time`,`pub_end_time`,`published`,`for_roles`,`is_seo`,`meta_key`,`meta_desc`) VALUES('21','户外旅行包','5','upload/image/mark_lEfTOIN2.jpg','upload/image/lEfTOIN2.jpg','户外旅行包','<p><font size=\"4\">1. 面料：450D平纹牛津布。PU：1000MM </font></p>\r\n<p><font size=\"4\">2. 扣件为定牌扣件。 </font></p>\r\n<p><font size=\"4\">3. 背包织带为高强度PP尼龙织带。</font></p>\r\n<p><font size=\"4\">4. 背负系统为可调节系统,通过勾绒带调节,间隔大通风就好,间隔小,则稳定性及重量的控制较好。 </font></p>\r\n<p><font size=\"4\">5. 拉链为定牌拉链 </font></p>\r\n<p><font size=\"4\">6. 后背为透气网眼。</font></p>\r\n<p><font size=\"4\">7. 背包自带防雨罩。 </font></p>\r\n<p><font size=\"4\">8. 胸扣为哨式,紧急情况下是求救方式之一 </font></p>\r\n<p><font size=\"4\">9. 颜色：红色、兰色、绿色</font></p>','100.00','1.00','0.00','1','1','1277219309','70','zh_CN','-1','-1','1','{member}{admin}{guest}','0','','');
INSERT INTO ss_products(`id`,`name`,`i_order`,`feature_img`,`feature_smallimg`,`introduction`,`description`,`price`,`discount_price`,`delivery_fee`,`online_orderable`,`recommended`,`create_time`,`product_category_id`,`s_locale`,`pub_start_time`,`pub_end_time`,`published`,`for_roles`,`is_seo`,`meta_key`,`meta_desc`) VALUES('22','户外休闲旅行包','6','upload/image/mark_fXGrLjSU.jpg','upload/image/fXGrLjSU.jpg','户外休闲旅行包 ','<p><font size=\"4\">【材料】：帆布/牛皮</font></p>\r\n<p><font size=\"4\">【颜色】：啡色、深灰色</font></p>\r\n<p><font size=\"4\">【产地】：中国</font></p>\r\n<p><font size=\"4\">【品质】：一等品</font></p>\r\n<p><font size=\"4\">【重量】：0.73KG </font></p>\r\n<p><font size=\"4\">【内部结构】：1个拉链夹层袋，1个内拉链袋，1个手机袋，1个证件袋</font></p>\r\n<p><font size=\"4\">【尺寸】：包体约为宽：34cm（以产品最宽处测量），高：49cm，厚：15cm，肩带长约：80cm（可调节）</font></p>','100.00','1.00','0.00','1','1','1277219510','70','zh_CN','-1','-1','1','{member}{admin}{guest}','0','','');
INSERT INTO ss_products(`id`,`name`,`i_order`,`feature_img`,`feature_smallimg`,`introduction`,`description`,`price`,`discount_price`,`delivery_fee`,`online_orderable`,`recommended`,`create_time`,`product_category_id`,`s_locale`,`pub_start_time`,`pub_end_time`,`published`,`for_roles`,`is_seo`,`meta_key`,`meta_desc`) VALUES('23','手提双肩多功能包','7','upload/image/mark_KMCjdwA3.jpg','upload/image/KMCjdwA3.jpg','手提双肩多功能包','<p><font size=\"4\">外拉链袋：2个 ，其中一个大袋子内有夹层右侧网袋：1个主袋：拉链封口大袋，背带上方有一个用魔术贴上的袋面，可以放下来隐藏背带左边有一个提把手 产品评价 隐藏式盖头设计，背包，手提旅行袋变换使用，一包顶二包功能，大容量尺寸容下更多行李物品，洗水工艺处理牛仔布，防水，配优质皮革，高档耐看，时尚。</font></p>','100.00','1.00','0.00','1','1','1277219661','70','zh_CN','-1','-1','1','{member}{admin}{guest}','0','','');
INSERT INTO ss_products(`id`,`name`,`i_order`,`feature_img`,`feature_smallimg`,`introduction`,`description`,`price`,`discount_price`,`delivery_fee`,`online_orderable`,`recommended`,`create_time`,`product_category_id`,`s_locale`,`pub_start_time`,`pub_end_time`,`published`,`for_roles`,`is_seo`,`meta_key`,`meta_desc`) VALUES('24','军用迷彩包','8','upload/image/mark_MLaKXXiB.jpg','upload/image/MLaKXXiB.jpg','军用迷彩色户外双肩背包','<p><font size=\"4\">规格：70*35*30 </font></p>\r\n<p><font size=\"4\">容量：70L </font></p>\r\n<p><font size=\"4\">PVC防水面料 内衬防雨绸 双层保护 绝对防水 防雨内置钢架 防扩 防震背部双层海绵垫腰部有类似腰带宽厚的网格海绵</font></p>','100.00','1.00','0.00','1','1','1277219807','70','zh_CN','-1','-1','1','{member}{admin}{guest}','0','','');
INSERT INTO ss_products(`id`,`name`,`i_order`,`feature_img`,`feature_smallimg`,`introduction`,`description`,`price`,`discount_price`,`delivery_fee`,`online_orderable`,`recommended`,`create_time`,`product_category_id`,`s_locale`,`pub_start_time`,`pub_end_time`,`published`,`for_roles`,`is_seo`,`meta_key`,`meta_desc`) VALUES('25','防风野营气炉','1','upload/image/mark_tjJqJ4yl.jpg','upload/image/tjJqJ4yl.jpg','防风野营气炉','<p><font size=\"4\">尺寸包装：12*15厘米 炉高10厘米，防风页打开最大；21厘米直径 防风页可自由调节高矮大小 </font></p>\r\n<p><font size=\"4\">重量：0.579公斤 净重：0.46公斤</font></p>\r\n<p><font size=\"4\">耗气量：100g/hr,烧开1升水只须3分钟！</font></p>\r\n<p><font size=\"4\">功率：4000BTU </font></p>\r\n<p><font size=\"4\">燃气：丁烷气 </font></p>\r\n<p><font size=\"4\">特点：</font></p>\r\n<p><font size=\"4\">1.挡风板可象莲花般打开或收起，设计巧妙，有防风、集热的效果；</font></p>\r\n<p><font size=\"4\">2.撑脚，挡风板可收缩，收起后装在一个黑色的尼龙包包内；</font></p>\r\n<p><font size=\"4\">3.接上气罐，打开气阀，按一下，电子点火，安全省事；</font></p>\r\n<p><font size=\"4\">4.4000BTU的功率，火头大的不得了，煎、炒、炸、烤、煮、炖样样精通</font></p>','100.00','1.00','0.00','1','1','1277219916','71','zh_CN','-1','-1','1','{member}{admin}{guest}','0','','');
INSERT INTO ss_products(`id`,`name`,`i_order`,`feature_img`,`feature_smallimg`,`introduction`,`description`,`price`,`discount_price`,`delivery_fee`,`online_orderable`,`recommended`,`create_time`,`product_category_id`,`s_locale`,`pub_start_time`,`pub_end_time`,`published`,`for_roles`,`is_seo`,`meta_key`,`meta_desc`) VALUES('26','便携式可拆卸炉头','2','upload/image/mark_u5FzpLhN.jpg','upload/image/u5FzpLhN.jpg','便携式可拆卸炉头','<p><font size=\"4\">[规格]大小：100&times;60&times;110mm </font></p>\r\n<p><font size=\"4\">[重量]240g </font></p>\r\n<p><font size=\"4\">[特点]设计简单而坚固，做工精细，自带电打火装置，炉头可以很简单的折叠和拆卸，方便携带，分火盘较大，燃烧充分，火力均匀，在使用扁气罐情况下，随输出功率的不同，可以燃烧2至4小时不等，性价比较高。</font><font size=\"4\">使用气罐可以直接接扁气罐，另购转换头可以使用长气罐。</font></p>\r\n<p><font size=\"4\">[液化气消耗量]80g/h</font></p>','100.00','1.00','0.00','1','1','1277219993','71','zh_CN','-1','-1','1','{member}{admin}{guest}','0','','');
INSERT INTO ss_products(`id`,`name`,`i_order`,`feature_img`,`feature_smallimg`,`introduction`,`description`,`price`,`discount_price`,`delivery_fee`,`online_orderable`,`recommended`,`create_time`,`product_category_id`,`s_locale`,`pub_start_time`,`pub_end_time`,`published`,`for_roles`,`is_seo`,`meta_key`,`meta_desc`) VALUES('27','德式饭盒','3','upload/image/mark_WAnmsmK1.jpg','upload/image/WAnmsmK1.jpg','德式饭盒','<p><font size=\"4\">多功能德式饭盒 适用于野营 野炊 徒步 钓鱼 炊具 具备烧煎煮等功能。 饭盒高约17CM，高16.5CM。 采用进口铝材，高级硬质铝氧化，耐高温、特别耐磨擦</font></p>','100.00','1.00','0.00','1','1','1277220069','71','zh_CN','-1','-1','1','{member}{admin}{guest}','0','','');
INSERT INTO ss_products(`id`,`name`,`i_order`,`feature_img`,`feature_smallimg`,`introduction`,`description`,`price`,`discount_price`,`delivery_fee`,`online_orderable`,`recommended`,`create_time`,`product_category_id`,`s_locale`,`pub_start_time`,`pub_end_time`,`published`,`for_roles`,`is_seo`,`meta_key`,`meta_desc`) VALUES('28','户外套锅','4','upload/image/mark_e9t2EkqX.jpg','upload/image/e9t2EkqX.jpg','户外套锅','<p><font size=\"3\">产品特点：铝制不沾锅。防锈抗摔，体积小，重量轻，易清洗，野营最佳选择！</font></p>\r\n<p><font size=\"3\">&nbsp;[产品重量]:2KG</font></p>\r\n<p><font size=\"3\">&nbsp;[详细说明]： 七人全家福豪华套锅 </font></p>\r\n<p><font size=\"3\">颜色：黑灰 </font></p>\r\n<p><font size=\"3\">材质：优质铝合金 </font></p>\r\n<p><font size=\"3\">盒子尺寸：155*210*210mm </font></p>\r\n<p><font size=\"3\">重量：2KG 综述，适合5-7人使用，包括一个大锅，一个中锅，一个小锅，一个大的煎锅，两个菜盘，5个饭碗，一个汤勺，和一个饭勺。锅采用进口铝材，塑料碗，塑料勺子，塑料菜盘都采用的是PP材料。</font></p>','100.00','1.00','0.00','1','1','1277220205','71','zh_CN','-1','-1','1','{member}{admin}{guest}','0','','');
INSERT INTO ss_products(`id`,`name`,`i_order`,`feature_img`,`feature_smallimg`,`introduction`,`description`,`price`,`discount_price`,`delivery_fee`,`online_orderable`,`recommended`,`create_time`,`product_category_id`,`s_locale`,`pub_start_time`,`pub_end_time`,`published`,`for_roles`,`is_seo`,`meta_key`,`meta_desc`) VALUES('29','野营气炉','5','upload/image/mark_Nj29uhIX.jpg','upload/image/Nj29uhIX.jpg','野营气炉','<p><font size=\"4\">*规格：&Phi;129&times;85mm(&Phi;61.5&times;98mm) </font></p>\r\n<p><font size=\"4\">*净重：142g </font></p>\r\n<p><font size=\"4\">*额定速率：2800w </font></p>\r\n<p><font size=\"4\">*点火方式：压电自动打火</font></p>','100.00','1.00','0.00','1','1','1277220317','72','zh_CN','-1','-1','1','{member}{admin}{guest}','0','','');
INSERT INTO ss_products(`id`,`name`,`i_order`,`feature_img`,`feature_smallimg`,`introduction`,`description`,`price`,`discount_price`,`delivery_fee`,`online_orderable`,`recommended`,`create_time`,`product_category_id`,`s_locale`,`pub_start_time`,`pub_end_time`,`published`,`for_roles`,`is_seo`,`meta_key`,`meta_desc`) VALUES('30','压盖式压力锅','6','upload/image/mark_Ly8InvLW.jpg','upload/image/Ly8InvLW.jpg','压盖式压力锅','<p><font size=\"4\">（1）安全可靠，不存在炸锅危险</font></p>\r\n<p><font size=\"4\">（2）设计科学，高雅美观，使用方便 </font></p>\r\n<p><font size=\"4\">（3）开 合盖安全性，破坏压力均符合国家标准 </font></p>\r\n<p><font size=\"4\">（4）结构合理，减少摩擦，延长密封圈使用寿命，节省开支 净重：1.51KG 容量：3L</font></p>','100.00','1.00','0.00','1','1','1277220772','72','zh_CN','-1','-1','1','{member}{admin}{guest}','0','','');
INSERT INTO ss_products(`id`,`name`,`i_order`,`feature_img`,`feature_smallimg`,`introduction`,`description`,`price`,`discount_price`,`delivery_fee`,`online_orderable`,`recommended`,`create_time`,`product_category_id`,`s_locale`,`pub_start_time`,`pub_end_time`,`published`,`for_roles`,`is_seo`,`meta_key`,`meta_desc`) VALUES('31','野炊烧烤炉','7','upload/image/mark_mmliR6v5.jpg','upload/image/mmliR6v5.jpg','野炊烧烤炉','<p>&nbsp;</p>\r\n<p align=\"center\"><font size=\"4\"><img height=\"310\" width=\"310\" alt=\"\" src=\"/admin/fckeditor/upload/../../../upload/image/mark(3).jpg\" /></font></p>\r\n<p><font size=\"4\">烧烤参数：适合2～4人使用净重:2.5KG&nbsp;<br />\r\n商品特点：采用耐高温烘漆技术，烤网镀铬，干净卫生。烧烤网用铁丝加镀锡材质制成，不生锈、并有把手设计，让你烧烤更得心应手。可两人同时烧烤，前面各有一个可放置食品的三层架子！</font></p>','100.00','99.00','0.00','1','1','1277220848','72','zh_CN','-1','-1','1','{member}{admin}{guest}','0','','');
INSERT INTO ss_products(`id`,`name`,`i_order`,`feature_img`,`feature_smallimg`,`introduction`,`description`,`price`,`discount_price`,`delivery_fee`,`online_orderable`,`recommended`,`create_time`,`product_category_id`,`s_locale`,`pub_start_time`,`pub_end_time`,`published`,`for_roles`,`is_seo`,`meta_key`,`meta_desc`) VALUES('32','野营水壶','8','upload/image/mark_HWxfzPlC.jpg','upload/image/HWxfzPlC.jpg','野营水壶','<p>&nbsp;</p>\r\n<p><font size=\"4\">&nbsp;</font></p>\r\n<p align=\"center\"><img height=\"278\" alt=\"\" width=\"310\" src=\"/admin/fckeditor/upload/../../../upload/image/mark(2).jpg\" /></p>\r\n<p><br />\r\n<font size=\"3\">铝合金制造，壶体内外均采用高级硬质氧化处理，耐磨擦，可折叠式把手，手感舒适。室内室外都宜使用。布袋包装。&nbsp;产品规格：0.8L</font></p>','100.00','1.00','0.00','1','1','1277220982','72','zh_CN','-1','-1','1','{member}{admin}{guest}','0','','');
INSERT INTO ss_products(`id`,`name`,`i_order`,`feature_img`,`feature_smallimg`,`introduction`,`description`,`price`,`discount_price`,`delivery_fee`,`online_orderable`,`recommended`,`create_time`,`product_category_id`,`s_locale`,`pub_start_time`,`pub_end_time`,`published`,`for_roles`,`is_seo`,`meta_key`,`meta_desc`) VALUES('33','7LED头灯','1','upload/image/mark_zcUfewJd.jpg','upload/image/zcUfewJd.jpg','7LED头灯','<p>&nbsp;</p>\r\n<p align=\"center\"><font size=\"4\"><img height=\"242\" width=\"310\" alt=\"\" src=\"/admin/fckeditor/upload/../../../upload/image/mark(1).jpg\" /></font></p>\r\n<p><font size=\"4\">电池： 3节AAA 7号电池<br />\r\n包装： 单只吸塑密封包装<br />\r\n颜色： 银白色材质： 高强度ABS工程塑料外壳<br />\r\n灯头： 7个白光+2红光+1<br />\r\n镭射长度： 80mm&nbsp;<br />\r\n头宽： 42.5 mm&nbsp;<br />\r\n灯头可以90度调节，头带可以随意调节大小。&nbsp;三种制式开关:有亮 3头\\7头\\1镭射+2红光 四种 按一下：亮3灯按二下：亮7灯按三下：亮1镭射 按四下:亮2红光</font></p>','100.00','1.00','0.00','1','1','1277221128','73','zh_CN','-1','-1','1','{member}{admin}{guest}','0','','');
INSERT INTO ss_products(`id`,`name`,`i_order`,`feature_img`,`feature_smallimg`,`introduction`,`description`,`price`,`discount_price`,`delivery_fee`,`online_orderable`,`recommended`,`create_time`,`product_category_id`,`s_locale`,`pub_start_time`,`pub_end_time`,`published`,`for_roles`,`is_seo`,`meta_key`,`meta_desc`) VALUES('34','6LED帐篷灯','2','upload/image/mark_Tn1KJmOs.jpg','upload/image/Tn1KJmOs.jpg','6LED帐篷灯','<p><font size=\"4\">&nbsp;</font></p>\r\n<p align=\"center\"><img height=\"310\" width=\"208\" alt=\"\" src=\"/admin/fckeditor/upload/../../../upload/image/mark.jpg\" /></p>\r\n<p><br />\r\n&nbsp;1、产品尺寸：高度：10厘米；宽度：5厘米。重量：90克<br />\r\n&nbsp;2、超级明亮的6粒LED组成，发白光。&nbsp;<br />\r\n&nbsp;3、10万个小时<br />\r\n&nbsp;4、这种台灯能照亮10平方米地面<br />\r\n&nbsp;5、3节7号电池<br />\r\n&nbsp;6、材料：高级工程塑料<br />\r\n&nbsp;7、开关：顶部按弹开关。<br />\r\n&nbsp;8. 外面彩盒包装, 送人和销售非常适合.</p>','100.00','1.00','0.00','1','1','1277221194','73','zh_CN','-1','-1','1','{member}{admin}{guest}','0','','');
INSERT INTO ss_products(`id`,`name`,`i_order`,`feature_img`,`feature_smallimg`,`introduction`,`description`,`price`,`discount_price`,`delivery_fee`,`online_orderable`,`recommended`,`create_time`,`product_category_id`,`s_locale`,`pub_start_time`,`pub_end_time`,`published`,`for_roles`,`is_seo`,`meta_key`,`meta_desc`) VALUES('35','小号营地灯','3','upload/image/mark_idvK2W2W.jpg','upload/image/idvK2W2W.jpg','小号营地灯','<p><font size=\"4\">&nbsp;</font></p>\r\n<p align=\"center\"><img height=\"571\" width=\"316\" alt=\"\" src=\"/admin/fckeditor/upload/../../../upload/image/mark_M2oXpK3U(10).jpg\" /></p>\r\n<p><br />\r\n&nbsp;1 9PCS LED 白光<br />\r\n&nbsp;2 灯体附有不锈钢装饰片 金属拎手带挂钩 佩带指南针<br />\r\n&nbsp;3 使用4pcs AA电池（5号）电池<br />\r\n&nbsp;4 材料ABS + ps 灯罩<br />\r\n&nbsp;5 产品尺码 直径：7.4CM*16.8CM 6 彩盒包装<br />\r\n&nbsp;7 重量：0.7kg/pcs 8 彩盒尺寸：9*9*17.6</p>','100.00','1.00','0.00','1','1','1277221294','73','zh_CN','-1','-1','1','{member}{admin}{guest}','0','','');
INSERT INTO ss_products(`id`,`name`,`i_order`,`feature_img`,`feature_smallimg`,`introduction`,`description`,`price`,`discount_price`,`delivery_fee`,`online_orderable`,`recommended`,`create_time`,`product_category_id`,`s_locale`,`pub_start_time`,`pub_end_time`,`published`,`for_roles`,`is_seo`,`meta_key`,`meta_desc`) VALUES('36','户外超亮LED节能灯','4','upload/image/mark_P4i9IWSA.jpg','upload/image/P4i9IWSA.jpg','户外超亮LED节能灯','<p>&nbsp;</p>\r\n<p align=\"center\"><img height=\"310\" alt=\"\" width=\"310\" src=\"/admin/fckeditor/upload/../../../upload/image/mark_M2oXpK3U(9).jpg\" /></p>\r\n<p>&nbsp;</p>\r\n<p><font size=\"3\"><font size=\"4\">1、产品尺寸：20.5CM*11.5CM*11.5CM <br />\r\n2、超级明亮的16+5+3 LED二级灯管 3、10万个小时<br />\r\n4、这种台灯能照亮20平方米地面 <br />\r\n5、3节五号电池<br />\r\n6、材料：高级工程塑料 <br />\r\n7、开关：按弹开关。<br />\r\n&nbsp;</font></font></p>','100.00','1.00','0.00','1','1','1277221431','73','zh_CN','-1','-1','1','{member}{admin}{guest}','0','','');
INSERT INTO ss_products(`id`,`name`,`i_order`,`feature_img`,`feature_smallimg`,`introduction`,`description`,`price`,`discount_price`,`delivery_fee`,`online_orderable`,`recommended`,`create_time`,`product_category_id`,`s_locale`,`pub_start_time`,`pub_end_time`,`published`,`for_roles`,`is_seo`,`meta_key`,`meta_desc`) VALUES('37','7LED野营灯','5','upload/image/mark_aX36H59A.jpg','upload/image/aX36H59A.jpg','7LED野营灯','<p align=\"center\"><font size=\"4\"><img height=\"263\" alt=\"\" width=\"522\" src=\"/admin/fckeditor/upload/../../../upload/image/mark_M2oXpK3U(8).jpg\" /></font><font size=\"4\">&middot;</font></p>\r\n<p align=\"center\"><font size=\"4\">电源形式：4AA电池</font></p>\r\n<p align=\"left\"><br />\r\n&middot;外观颜色：上部黄色下部银灰色外加黑色包胶&nbsp;<br />\r\n&middot;光源形式：7超亮LED&nbsp;</p>','100.00','1.00','0.00','1','1','1277221509','74','zh_CN','-1','-1','1','{member}{admin}{guest}','0','','');
INSERT INTO ss_products(`id`,`name`,`i_order`,`feature_img`,`feature_smallimg`,`introduction`,`description`,`price`,`discount_price`,`delivery_fee`,`online_orderable`,`recommended`,`create_time`,`product_category_id`,`s_locale`,`pub_start_time`,`pub_end_time`,`published`,`for_roles`,`is_seo`,`meta_key`,`meta_desc`) VALUES('38','48头LED帐篷灯','6','upload/image/mark_mquFQmu4.jpg','upload/image/mquFQmu4.jpg','48头LED帐篷灯','<p>&nbsp;</p>\r\n<p align=\"center\"><font size=\"4\"><img height=\"250\" width=\"250\" alt=\"\" src=\"/admin/fckeditor/upload/../../../upload/image/mark_M2oXpK3U(6).jpg\" /></font></p>\r\n<p><font size=\"4\">帐篷 灯 48头&nbsp;<br />\r\n1 48PCS LED 白光&nbsp;<br />\r\n2&nbsp;材质：ABS +塑料&nbsp;<br />\r\n3产品尺寸：14.6直径*2.7厚度&nbsp;<br />\r\n4包装方式：单个入吸塑包装&nbsp;<br />\r\n</font><font size=\"4\">5电池型号：4PCS &ldquo;AA&rdquo;电池 可持续使用30小时以上&nbsp;<br />\r\n6 箱规： 46*48*70 7 外观颜色：银色</font></p>','100.00','1.00','0.00','1','1','1277221588','74','zh_CN','-1','-1','1','{member}{admin}{guest}','0','','');
INSERT INTO ss_products(`id`,`name`,`i_order`,`feature_img`,`feature_smallimg`,`introduction`,`description`,`price`,`discount_price`,`delivery_fee`,`online_orderable`,`recommended`,`create_time`,`product_category_id`,`s_locale`,`pub_start_time`,`pub_end_time`,`published`,`for_roles`,`is_seo`,`meta_key`,`meta_desc`) VALUES('39','防水强光手电筒','7','upload/image/mark_CJ95KOnw.jpg','upload/image/CJ95KOnw.jpg','防水强光手电筒','<p>&nbsp;</p>\r\n<p align=\"center\"><font size=\"4\"><img height=\"222\" width=\"310\" alt=\"\" src=\"/admin/fckeditor/upload/../../../upload/image/mark_M2oXpK3U(5).jpg\" /></font></p>\r\n<p><font size=\"4\">使用3节AA 7号规格电池！外壳选用优质铝合金材料精加工，表面阳极氧化处理。 防滑刻槽造型。具有强度高，手感好，防滑等优点。 改进型后按钮式开关,单手可操作，使用更方便。 防雨设计，带防水胶圈。</font></p>','100.00','1.00','0.00','1','1','1277221708','74','zh_CN','-1','-1','1','{member}{admin}{guest}','0','','');
INSERT INTO ss_products(`id`,`name`,`i_order`,`feature_img`,`feature_smallimg`,`introduction`,`description`,`price`,`discount_price`,`delivery_fee`,`online_orderable`,`recommended`,`create_time`,`product_category_id`,`s_locale`,`pub_start_time`,`pub_end_time`,`published`,`for_roles`,`is_seo`,`meta_key`,`meta_desc`) VALUES('40','15流明手电','8','upload/image/mark_o7egukA7.jpg','upload/image/o7egukA7.jpg','15流明手电','<p><font size=\"4\">光度: 灯泡(包括): 15流明<br />\r\n</font><font size=\"4\">使用时间: 90分钟<br />\r\n电池(包括): 1 个123A 锂电&nbsp;<br />\r\n采用防刮, 耐热镜片 表面经军规第三級加硬电镀处理</font></p>\r\n<p align=\"center\"><font size=\"4\"><img height=\"228\" alt=\"\" width=\"310\" src=\"/admin/fckeditor/upload/../../../upload/image/mark_o7egukA7(1).jpg\" /></font></p>','100.00','1.00','0.00','1','1','1277222439','74','zh_CN','-1','-1','1','{member}{admin}{guest}','0','','');
INSERT INTO ss_products(`id`,`name`,`i_order`,`feature_img`,`feature_smallimg`,`introduction`,`description`,`price`,`discount_price`,`delivery_fee`,`online_orderable`,`recommended`,`create_time`,`product_category_id`,`s_locale`,`pub_start_time`,`pub_end_time`,`published`,`for_roles`,`is_seo`,`meta_key`,`meta_desc`) VALUES('41','大号折叠桶','1','upload/image/mark_1UFcTwct.jpg','upload/image/1UFcTwct.jpg','大号折叠桶','<p align=\"center\"><font size=\"4\"><img height=\"310\" width=\"310\" alt=\"\" src=\"/admin/fckeditor/upload/../../../upload/image/mark_M2oXpK3U(4).jpg\" /></font></p>\r\n<p><br />\r\n25直径毛重量：200克 颜色：绿色和橙色材质：采用PVC进口软材料</p>','100.00','1.00','0.00','1','1','1277222894','75','zh_CN','-1','-1','1','{member}{admin}{guest}','0','','');
INSERT INTO ss_products(`id`,`name`,`i_order`,`feature_img`,`feature_smallimg`,`introduction`,`description`,`price`,`discount_price`,`delivery_fee`,`online_orderable`,`recommended`,`create_time`,`product_category_id`,`s_locale`,`pub_start_time`,`pub_end_time`,`published`,`for_roles`,`is_seo`,`meta_key`,`meta_desc`) VALUES('42','伸缩六折杯','2','upload/image/mark_q1lkMM1v.jpg','upload/image/q1lkMM1v.jpg','伸缩六折杯','<p>&nbsp;</p>\r\n<p align=\"center\"><font size=\"4\"><img height=\"272\" width=\"310\" alt=\"\" src=\"/admin/fckeditor/upload/../../../upload/image/mark_M2oXpK3U(3).jpg\" /></font></p>\r\n<p><br />\r\n材料: 不锈钢 重量: 0.2 户外项目: 露营 登山 徒步 自驾游 旅游 ...</p>','100.00','1.00','0.00','1','1','1277223030','75','zh_CN','-1','-1','1','{member}{admin}{guest}','0','','');
INSERT INTO ss_products(`id`,`name`,`i_order`,`feature_img`,`feature_smallimg`,`introduction`,`description`,`price`,`discount_price`,`delivery_fee`,`online_orderable`,`recommended`,`create_time`,`product_category_id`,`s_locale`,`pub_start_time`,`pub_end_time`,`published`,`for_roles`,`is_seo`,`meta_key`,`meta_desc`) VALUES('43','TPU专业水袋','3','upload/image/mark_MTOM4Txv.jpg','upload/image/MTOM4Txv.jpg','TPU专业水袋','<p align=\"left\">&nbsp;</p>\r\n<p align=\"center\"><font size=\"3\"><img height=\"220\" width=\"199\" alt=\"\" src=\"/admin/fckeditor/upload/../../../upload/image/mark_M2oXpK3U(2).jpg\" /></font></p>\r\n<p align=\"left\"><font size=\"3\"><br />\r\n【规格】:2L<br />\r\n【颜色】:浅蓝<br />\r\n【说明】：袋体的前后层都以透明TPU制成，造型设计清爽澄明，PVC吸水管标准长度100cm，蓝色矽胶吸嘴及美国专利止水开关。水袋各部分材质皆符合FDA and NSF食品级标准，无味无毒性，通过欧洲EN71不含重金属及毒性测试。特点及适用范围：适用于一般慢跑，骑自行车，爬山及水上运动。在剧烈运动及高耗氧性运动时，可随时补充水份。 吸管的设计可使饮水时解放双手，方便持续运动，骑车、行军、或侦防等。</font></p>','100.00','1.00','0.00','1','1','1277223198','75','zh_CN','-1','-1','1','{member}{admin}{guest}','0','','');
INSERT INTO ss_products(`id`,`name`,`i_order`,`feature_img`,`feature_smallimg`,`introduction`,`description`,`price`,`discount_price`,`delivery_fee`,`online_orderable`,`recommended`,`create_time`,`product_category_id`,`s_locale`,`pub_start_time`,`pub_end_time`,`published`,`for_roles`,`is_seo`,`meta_key`,`meta_desc`) VALUES('44','制冷水杯水壶户外','4','upload/image/mark_M2oXpK3U.jpg','upload/image/M2oXpK3U.jpg','制冷水杯水壶户外\r\n 材质：采进口防碎型聚碳酸脂(PC)材质，具有耐腐蚀、耐磨、强度高的特性，聚碳酸酯PC壶体/食用级PP材质\r\n尺寸：高24公分/底部直径6.5公分\r\n容量：700ml \r\n耐冷/热温度：-20℃~100度℃','<p align=\"center\"><img height=\"310\" alt=\"\" width=\"310\" src=\"/admin/fckeditor/upload/../../../upload/image/mark_M2oXpK3U(1).jpg\" /></p>\r\n<p align=\"left\">制冷水杯水壶户外<br />\r\n&nbsp;材质：采进口防碎型聚碳酸脂(PC)材质，具有耐腐蚀、耐磨、强度高的特性，聚碳酸酯PC壶体/食用级PP材质<br />\r\n尺寸：高24公分/底部直径6.5公分<br />\r\n容量：700ml <br />\r\n耐冷/热温度：-20℃~100度℃</p>','100.00','1.00','0.00','1','1','1277223617','75','zh_CN','-1','-1','1','{member}{admin}{guest}','0','','');
INSERT INTO ss_products(`id`,`name`,`i_order`,`feature_img`,`feature_smallimg`,`introduction`,`description`,`price`,`discount_price`,`delivery_fee`,`online_orderable`,`recommended`,`create_time`,`product_category_id`,`s_locale`,`pub_start_time`,`pub_end_time`,`published`,`for_roles`,`is_seo`,`meta_key`,`meta_desc`) VALUES('45','户外伸缩水壶','5','upload/image/mark_4H84GiU1.jpg','upload/image/4H84GiU1.jpg','户外伸缩水壶','<p><font size=\"4\">全新ＰＥ材料，韧性好．折叠后体积小，重量轻，是户外的理想盛水容器</font></p>\r\n<p align=\"center\"><font size=\"4\"><img height=\"257\" width=\"253\" alt=\"\" src=\"/admin/fckeditor/upload/../../../upload/image/mark_4H84GiU1(1).jpg\" /></font></p>','100.00','1.00','0.00','1','1','1277223737','76','zh_CN','-1','-1','1','{member}{admin}{guest}','0','','');
INSERT INTO ss_products(`id`,`name`,`i_order`,`feature_img`,`feature_smallimg`,`introduction`,`description`,`price`,`discount_price`,`delivery_fee`,`online_orderable`,`recommended`,`create_time`,`product_category_id`,`s_locale`,`pub_start_time`,`pub_end_time`,`published`,`for_roles`,`is_seo`,`meta_key`,`meta_desc`) VALUES('46','休闲船','6','upload/image/mark_WsXaVM6c.jpg','upload/image/WsXaVM6c.jpg','休闲船\r\n放气尺寸：248X140CM(98”X55”) \r\n材料厚度：0.75MM \r\n气室：3+2 \r\n载人数： 2+1 \r\n承重：240KG \r\n马达最大功率：4hp　2.9kw \r\n马达最大重量：25kgs\r\n泵：40CM　 \r\n手拉泵浆：132CM\r\n外箱体积：0.147立方米　\r\n毛重：23.5kg\r\n充气尺寸：248X130X33CM(98”X51”X13”) ','<p align=\"center\"><font size=\"4\"><img height=\"310\" alt=\"\" width=\"180\" src=\"/admin/fckeditor/upload/../../../upload/image/mark_WsXaVM6c(1).jpg\" /></font></p>\r\n<p align=\"center\">&nbsp;</p>\r\n<p>\r\n<p>&nbsp;</p>\r\n</p>\r\n<p align=\"left\"><br />\r\n<font size=\"3\">休闲船<br />\r\n放气尺寸：248X140CM(98&rdquo;X55&rdquo;) <br />\r\n材料厚度：0.75MM <br />\r\n气室：3+2 <br />\r\n载人数： 2+1 <br />\r\n承重：240KG <br />\r\n马达最大功率：4hp　2.9kw <br />\r\n马达最大重量：25kgs<br />\r\n泵：40CM　 <br />\r\n手拉泵浆：132CM<br />\r\n外箱体积：0.147立方米　<br />\r\n毛重：23.5kg<br />\r\n充气尺寸：248X130X33CM(98&rdquo;X51&rdquo;X13&rdquo;) </font></p>','100.00','1.00','0.00','1','1','1277223944','76','zh_CN','-1','-1','1','{member}{admin}{guest}','0','','');
INSERT INTO ss_products(`id`,`name`,`i_order`,`feature_img`,`feature_smallimg`,`introduction`,`description`,`price`,`discount_price`,`delivery_fee`,`online_orderable`,`recommended`,`create_time`,`product_category_id`,`s_locale`,`pub_start_time`,`pub_end_time`,`published`,`for_roles`,`is_seo`,`meta_key`,`meta_desc`) VALUES('47','气垫船','7','upload/image/mark_BJDdsb4O.jpg','upload/image/BJDdsb4O.jpg','气垫船','<p><font size=\"4\">1、全部采用进口专用气艇布料，气密性、耐磨性极好。 2、采用进口气阀，方便、安全、可靠。 3、所有粘接部位全部采用进口胶水粘接，剥离强度以及耐高温、耐水解、抗紫外线等性能均大大优于国产胶水，即使在阳光暴晒下，气艇连接部位牢固性能得到充分保证。</font></p>\r\n<p><font size=\"4\">&nbsp;</font></p>\r\n<p align=\"center\"><img height=\"233\" width=\"310\" alt=\"\" src=\"/admin/fckeditor/upload/../../../upload/image/mark_BJDdsb4O(1).jpg\" /></p>','100.00','1.00','0.00','1','1','1277224190','76','zh_CN','-1','-1','1','{member}{admin}{guest}','0','','');
INSERT INTO ss_products(`id`,`name`,`i_order`,`feature_img`,`feature_smallimg`,`introduction`,`description`,`price`,`discount_price`,`delivery_fee`,`online_orderable`,`recommended`,`create_time`,`product_category_id`,`s_locale`,`pub_start_time`,`pub_end_time`,`published`,`for_roles`,`is_seo`,`meta_key`,`meta_desc`) VALUES('48','超高防水鞋','8','upload/image/mark_K8D3UZbw.jpg','upload/image/K8D3UZbw.jpg','超高防水鞋','<p><font size=\"4\">材质: 高密度耐磨橡胶&nbsp; 筒高：83厘米筒围：60-40厘米</font></p>\r\n<p align=\"center\"><font size=\"4\"><img height=\"533\" width=\"463\" alt=\"\" src=\"/admin/fckeditor/upload/../../../upload/image/mark_K8D3UZbw(1).jpg\" /></font></p>','100.00','1.00','0.00','1','1','1277224706','76','zh_CN','-1','-1','1','{member}{admin}{guest}','0','','');

DROP TABLE IF EXISTS ss_roles;
CREATE TABLE `ss_roles` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `name` varchar(20) NOT NULL,
  `desc` varchar(255) NOT NULL,
  `permission` text,
  PRIMARY KEY (`id`),
  UNIQUE KEY `name` (`name`)
) ENGINE=MyISAM AUTO_INCREMENT=4 DEFAULT CHARSET=utf8;

INSERT INTO ss_roles(`id`,`name`,`desc`,`permission`) VALUES('1','guest','Guest','');
INSERT INTO ss_roles(`id`,`name`,`desc`,`permission`) VALUES('2','member','Member','');
INSERT INTO ss_roles(`id`,`name`,`desc`,`permission`) VALUES('3','admin','Admin','');

DROP TABLE IF EXISTS ss_site_infos;
CREATE TABLE `ss_site_infos` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `site_name` varchar(255) DEFAULT NULL,
  `keywords` varchar(255) DEFAULT NULL,
  `description` text,
  `s_locale` varchar(50) NOT NULL,
  PRIMARY KEY (`id`),
  KEY `s_locale` (`s_locale`)
) ENGINE=MyISAM AUTO_INCREMENT=2 DEFAULT CHARSET=utf8;

INSERT INTO ss_site_infos(`id`,`site_name`,`keywords`,`description`,`s_locale`) VALUES('1','建站专家--乌托邦网络wophp','xx户外用品有限公司','xx户外用品有限公司','zh_CN');

DROP TABLE IF EXISTS ss_static_contents;
CREATE TABLE `ss_static_contents` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `title` varchar(255) NOT NULL,
  `content` longtext,
  `create_time` bigint(20) NOT NULL,
  `s_locale` varchar(50) NOT NULL,
  `published` enum('0','1') NOT NULL DEFAULT '1',
  `for_roles` varchar(50) NOT NULL DEFAULT '{guest}',
  PRIMARY KEY (`id`),
  KEY `title` (`title`),
  KEY `create_time` (`create_time`),
  KEY `s_locale` (`s_locale`),
  KEY `published` (`published`),
  KEY `for_roles` (`for_roles`),
  FULLTEXT KEY `content` (`content`)
) ENGINE=MyISAM AUTO_INCREMENT=7 DEFAULT CHARSET=utf8;

INSERT INTO ss_static_contents(`id`,`title`,`content`,`create_time`,`s_locale`,`published`,`for_roles`) VALUES('1','联系我们','<p><font size=\"3\">地址：中国&middot;xx省xx市</font></p>\r\n<p><font size=\"3\">电话： 086-111-1111111</font></p>\r\n<p><font size=\"3\">传真： 086-111-1111111</font></p>\r\n<p><font size=\"3\">公司主页：www.xxxx.com</font></p>','1289274279','zh_CN','1','{member}{admin}{guest}');
INSERT INTO ss_static_contents(`id`,`title`,`content`,`create_time`,`s_locale`,`published`,`for_roles`) VALUES('6','户外知识','<p><font size=\"3\">什么是户外</font></p><p><font size=\"3\">&nbsp;&nbsp;&nbsp; 户外泛指，走出家门，就叫户外，户外活动也就是走出家门的活动，不过我们指的户外是狭义的户外，就是户外登山、露营、穿越、攀岩、蹦极、漂流、冲浪、滑翔、滑水、攀冰、定向、远足、滑雪、潜水、滑草、高山速降自行车、越野山地车、热气球、溯溪、拓展、飞行滑索等，现在你应该明白一些了吧，接着再详细的讲一讲户外：</font></p><p><font size=\"3\">&nbsp;&nbsp;&nbsp; 户外主要有以下特点</font></p><p><font size=\"3\">&nbsp;&nbsp;&nbsp; 户外多数带有探险性，属于极限和亚极限运动，有很大的挑战性和刺激性。拥抱自然，挑战自我，能够培养个人的毅力、团队之间合作精神，提高野外生存能力，深受青年人的欢迎。户外运动越来越吸引了人们的目光，日益成为关注的焦点。另外，由于我国地理条件的得天独厚，拥有良好的广大自然资源，也为户外运动提供了一个广阔的空间。</font></p><p><font size=\"3\">&nbsp;&nbsp;&nbsp; 户外需要什么装备</font></p><p><font size=\"3\">&nbsp;&nbsp;&nbsp; 户外离不开装备器材。一般来说，户外的装备可分为两个方面，一是基本装备，如帐篷、背包、睡袋、服装、鞋、吹具、地图、指北针、头灯（含备用灯泡与电池）、备用粮食、备用衣物、太阳眼镜、刀、火种、急救箱等。二是不同运动需要的专业性很强装备，如探险队的卫星定位器、登冰山用的冰抓、登山的登山索、滑雪运动的滑雪板、潜水运动的潜水器材等。</font></p><p>&nbsp;</p>','1277269671','zh_CN','0','{member}{admin}{guest}');
INSERT INTO ss_static_contents(`id`,`title`,`content`,`create_time`,`s_locale`,`published`,`for_roles`) VALUES('2','公司简介','<p>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp; xx户外用品有限公司成立于2000年1月，系中资企业，公司位于xx省xx市，专业从事体育用品生产营销推广，户外服装、登山鞋、徒步鞋、滑板运动鞋等。&nbsp;&nbsp;&nbsp; </p>\r\n<p>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp; 公司本着以&ldquo;质量第一、信誉至上、开拓创新、与时俱进&rdquo;的经营理念，不断引进高素质的管理人才，不断挖潜改革，根据市场需求和流行趋势，不断推出适销对路的化纤涤纶布、格子布新面料，以高品位的质量、优良的信誉深受广大客户的青睐，其出口业务发展迅速，出口率达百分之五十以上，产品远销新加坡、菲律宾、马来西亚及港、澳、台等地区。</p>\r\n<p>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp; 公司坚持吸取先进企业管理经验和采用现代企业管理方法，实行岗位责任制，进行绩效考核。公司大量吸收高素质的管理人才加盟，使管理人员队伍保持专业化、知识化、年轻化、公司保持创业时艰苦奋斗的优良作风，坚持把管理人员与企业融为一体，发扬团队精神，坚持科技创新，以人为本，以质量求生存.</p>','1297410341','zh_CN','1','{member}{admin}{guest}');
INSERT INTO ss_static_contents(`id`,`title`,`content`,`create_time`,`s_locale`,`published`,`for_roles`) VALUES('5','招聘','<p><font size=\"3\">招聘职位：品管员（QC）&nbsp; <br />发布时间：&nbsp; 2010-06-08&nbsp;&nbsp;&nbsp; <br />截至日期：&nbsp; 2010-12-15&nbsp; <br />招聘人数：&nbsp; 10人&nbsp; <br />职&nbsp;&nbsp;&nbsp; 责：&nbsp; 负责验货，协助车间控制，预防品质问题 <br />任职要求：&nbsp; 中专以上学历，男女不限，25-45岁，3年以上休闲、运动或户外品牌同职位经验&nbsp;<br />&nbsp;</font></p><p><font size=\"3\">招聘职位：跟单员&nbsp; <br />发布时间：&nbsp; 2010-06-08&nbsp;&nbsp;&nbsp; <br />截至日期：&nbsp; 2010-12-15&nbsp; <br />招聘人数：&nbsp; 10人&nbsp; <br />职&nbsp;&nbsp;&nbsp; 责：&nbsp; 负责生产进度和品质跟踪工作 <br />任职要求：&nbsp; 中专以上学历，熟悉梭针织面料，1年以上休闲、运动或户外品牌同职位经验</font></p>','1277268940','zh_CN','0','{member}{admin}{guest}');

DROP TABLE IF EXISTS ss_template_categories;
CREATE TABLE `ss_template_categories` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `category` varchar(50) NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=MyISAM AUTO_INCREMENT=2 DEFAULT CHARSET=utf8;


DROP TABLE IF EXISTS ss_templates;
CREATE TABLE `ss_templates` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `template` varchar(50) NOT NULL,
  `template_category_id` int(11) NOT NULL,
  PRIMARY KEY (`id`),
  KEY `template_category_id` (`template_category_id`)
) ENGINE=MyISAM AUTO_INCREMENT=4 DEFAULT CHARSET=utf8;

INSERT INTO ss_templates(`id`,`template`,`template_category_id`) VALUES('1','fitness_sports_jackie_1204_2','999');
INSERT INTO ss_templates(`id`,`template`,`template_category_id`) VALUES('2','jackie_swim_2','999');
INSERT INTO ss_templates(`id`,`template`,`template_category_id`) VALUES('3','fitness_sports_jackie_1204_2','999');

DROP TABLE IF EXISTS ss_third_accounts;
CREATE TABLE `ss_third_accounts` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `account_type` varchar(50) NOT NULL,
  `appid` varchar(100) NOT NULL DEFAULT '',
  `appsecret` varchar(100) NOT NULL DEFAULT '',
  `active` smallint(6) NOT NULL DEFAULT '0',
  `options` text,
  PRIMARY KEY (`id`),
  UNIQUE KEY `account_type` (`account_type`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;


DROP TABLE IF EXISTS ss_transactions;
CREATE TABLE `ss_transactions` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `amount` decimal(16,2) NOT NULL DEFAULT '0.00',
  `type` enum('1','2') NOT NULL DEFAULT '1',
  `memo` text,
  `action_time` bigint(20) NOT NULL,
  `user_id` int(11) NOT NULL,
  PRIMARY KEY (`id`),
  KEY `user_id` (`user_id`),
  KEY `action_time` (`action_time`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;


DROP TABLE IF EXISTS ss_user_extends;
CREATE TABLE `ss_user_extends` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `total_saving` decimal(16,2) NOT NULL DEFAULT '0.00',
  `total_payment` decimal(16,2) NOT NULL DEFAULT '0.00',
  `balance` decimal(16,2) NOT NULL DEFAULT '0.00',
  `user_id` int(11) NOT NULL,
  PRIMARY KEY (`id`),
  KEY `user_id` (`user_id`)
) ENGINE=MyISAM AUTO_INCREMENT=3 DEFAULT CHARSET=utf8;

INSERT INTO ss_user_extends(`id`,`total_saving`,`total_payment`,`balance`,`user_id`) VALUES('1','0.00','0.00','0.00','1');
INSERT INTO ss_user_extends(`id`,`total_saving`,`total_payment`,`balance`,`user_id`) VALUES('2','0.00','0.00','0.00','0');

DROP TABLE IF EXISTS ss_user_fields;
CREATE TABLE `ss_user_fields` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `field_type` int(11) NOT NULL,
  `showinlist` enum('0','1') NOT NULL DEFAULT '0',
  `required` enum('0','1') NOT NULL DEFAULT '0',
  `i_order` int(11) NOT NULL,
  `label` text NOT NULL,
  `options` text,
  PRIMARY KEY (`id`),
  KEY `i_order` (`i_order`),
  KEY `list_with_order` (`showinlist`,`i_order`)
) ENGINE=MyISAM AUTO_INCREMENT=11 DEFAULT CHARSET=utf8;

INSERT INTO ss_user_fields(`id`,`field_type`,`showinlist`,`required`,`i_order`,`label`,`options`) VALUES('1','0','1','0','1','full_name','');
INSERT INTO ss_user_fields(`id`,`field_type`,`showinlist`,`required`,`i_order`,`label`,`options`) VALUES('2','0','0','0','3','nickname','');
INSERT INTO ss_user_fields(`id`,`field_type`,`showinlist`,`required`,`i_order`,`label`,`options`) VALUES('3','0','0','0','7','country','');
INSERT INTO ss_user_fields(`id`,`field_type`,`showinlist`,`required`,`i_order`,`label`,`options`) VALUES('4','0','0','0','8','city','');
INSERT INTO ss_user_fields(`id`,`field_type`,`showinlist`,`required`,`i_order`,`label`,`options`) VALUES('5','0','0','0','5','birthday','');
INSERT INTO ss_user_fields(`id`,`field_type`,`showinlist`,`required`,`i_order`,`label`,`options`) VALUES('6','0','0','0','9','addr1','');
INSERT INTO ss_user_fields(`id`,`field_type`,`showinlist`,`required`,`i_order`,`label`,`options`) VALUES('7','0','0','0','10','zipcode','');
INSERT INTO ss_user_fields(`id`,`field_type`,`showinlist`,`required`,`i_order`,`label`,`options`) VALUES('8','0','1','0','2','mobile','');
INSERT INTO ss_user_fields(`id`,`field_type`,`showinlist`,`required`,`i_order`,`label`,`options`) VALUES('9','0','0','0','4','gender','');
INSERT INTO ss_user_fields(`id`,`field_type`,`showinlist`,`required`,`i_order`,`label`,`options`) VALUES('10','0','0','0','6','telphone','');

DROP TABLE IF EXISTS ss_user_oauths;
CREATE TABLE `ss_user_oauths` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `user_id` int(11) NOT NULL,
  `auth_type` varchar(50) NOT NULL,
  `auth_key` varchar(200) NOT NULL,
  `access_code` varchar(200) NOT NULL DEFAULT '',
  `nickname` varchar(200) NOT NULL DEFAULT '',
  `options` text,
  PRIMARY KEY (`id`),
  UNIQUE KEY `auth_type` (`auth_type`,`auth_key`),
  KEY `user_id` (`user_id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;


DROP TABLE IF EXISTS ss_users;
CREATE TABLE `ss_users` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `login` varchar(25) NOT NULL,
  `passwd` char(40) NOT NULL,
  `full_name` varchar(50) DEFAULT NULL,
  `email` varchar(255) NOT NULL,
  `lastlog_time` bigint(20) DEFAULT NULL,
  `lastlog_ip` varchar(15) DEFAULT NULL,
  `rstpwdreq_time` bigint(20) DEFAULT NULL,
  `rstpwdreq_rkey` char(128) DEFAULT NULL,
  `active` enum('0','1') NOT NULL DEFAULT '1',
  `s_role` varchar(255) NOT NULL DEFAULT '{guest}',
  `wizard` enum('0','1') DEFAULT '1',
  `mobile` varchar(32) DEFAULT NULL,
  `member_verify` enum('0','1') DEFAULT '1',
  `nickname` varchar(50) DEFAULT NULL,
  `gender` enum('F','M') DEFAULT NULL,
  `birthday` date DEFAULT NULL,
  `country` varchar(100) DEFAULT NULL,
  `city` varchar(100) DEFAULT NULL,
  `addr1` varchar(255) DEFAULT NULL,
  `addr2` varchar(255) DEFAULT NULL,
  `zipcode` varchar(20) DEFAULT NULL,
  `telphone` varchar(50) DEFAULT NULL,
  `params` longtext,
  PRIMARY KEY (`id`),
  UNIQUE KEY `login` (`login`),
  UNIQUE KEY `email` (`email`),
  KEY `passwd` (`passwd`),
  KEY `active` (`active`)
) ENGINE=MyISAM AUTO_INCREMENT=2 DEFAULT CHARSET=utf8;

INSERT INTO ss_users(`id`,`login`,`passwd`,`full_name`,`email`,`lastlog_time`,`lastlog_ip`,`rstpwdreq_time`,`rstpwdreq_rkey`,`active`,`s_role`,`wizard`,`mobile`,`member_verify`,`nickname`,`gender`,`birthday`,`country`,`city`,`addr1`,`addr2`,`zipcode`,`telphone`,`params`) VALUES('1','admin','d033e22ae348aeb5660fc2140aec35850c4da997','','admin@admin.com','1382545059','127.0.0.1','0','','1','{admin}','1','','1','','','','','','','','','','');

