<?php
/**
* Smarty Internal Plugin Templateparser
*
* This is the template parser.
* It is generated from the internal.templateparser.y file
* @package Smarty
* @subpackage Compiler
* @author Uwe Tews
*/

/**
 * This can be used to store both the string representation of
 * a token, and any useful meta-data associated with the token.
 *
 * meta-data should be stored as an array
 */
class TP_yyToken implements ArrayAccess
{
    public $string = '';
    public $metadata = array();

    function __construct($s, $m = array())
    {
        if ($s instanceof TP_yyToken) {
            $this->string = $s->string;
            $this->metadata = $s->metadata;
        } else {
            $this->string = (string) $s;
            if ($m instanceof TP_yyToken) {
                $this->metadata = $m->metadata;
            } elseif (is_array($m)) {
                $this->metadata = $m;
            }
        }
    }

    function __toString()
    {
        return $this->_string;
    }

    function offsetExists($offset)
    {
        return isset($this->metadata[$offset]);
    }

    function offsetGet($offset)
    {
        return $this->metadata[$offset];
    }

    function offsetSet($offset, $value)
    {
        if ($offset === null) {
            if (isset($value[0])) {
                $x = ($value instanceof TP_yyToken) ?
                    $value->metadata : $value;
                $this->metadata = array_merge($this->metadata, $x);
                return;
            }
            $offset = count($this->metadata);
        }
        if ($value === null) {
            return;
        }
        if ($value instanceof TP_yyToken) {
            if ($value->metadata) {
                $this->metadata[$offset] = $value->metadata;
            }
        } elseif ($value) {
            $this->metadata[$offset] = $value;
        }
    }

    function offsetUnset($offset)
    {
        unset($this->metadata[$offset]);
    }
}

/** The following structure represents a single element of the
 * parser's stack.  Information stored includes:
 *
 *   +  The state number for the parser at this level of the stack.
 *
 *   +  The value of the token stored at this level of the stack.
 *      (In other words, the "major" token.)
 *
 *   +  The semantic value stored at this level of the stack.  This is
 *      the information used by the action routines in the grammar.
 *      It is sometimes called the "minor" token.
 */
class TP_yyStackEntry
{
    public $stateno;       /* The state-number */
    public $major;         /* The major token value.  This is the code
                     ** number for the token at this stack level */
    public $minor; /* The user-supplied minor token value.  This
                     ** is the value of the token  */
};

// code external to the class is included here

// declare_class is output here
#line 12 "smarty_internal_templateparser.y"
class Smarty_Internal_Templateparser#line 109 "smarty_internal_templateparser.php"
{
/* First off, code is included which follows the "include_class" declaration
** in the input file. */
#line 14 "smarty_internal_templateparser.y"

    // states whether the parse was successful or not
    public $successful = true;
    public $retvalue = 0;
    private $lex;
    private $internalError = false;

    function __construct($lex, $compiler) {
        // set instance object
        self::instance($this); 
        $this->lex = $lex;
        $this->compiler = $compiler;
        $this->smarty = $this->compiler->smarty;
        $this->template = $this->compiler->template;
        if ($this->template->security && isset($this->smarty->security_handler)) {
              $this->sec_obj = $this->smarty->security_policy;
        } else {
              $this->sec_obj = $this->smarty;
        }
        $this->cacher = $this->template->cacher_object; 
        $this->compiler->has_variable_string = false;
				$this->compiler->prefix_code = array();
				$this->prefix_number = 0;
    }
    public static function &instance($new_instance = null)
    {
        static $instance = null;
        if (isset($new_instance) && is_object($new_instance))
            $instance = $new_instance;
        return $instance;
    }
    
#line 147 "smarty_internal_templateparser.php"

/* Next is all token values, as class constants
*/
/* 
** These constants (all generated automatically by the parser generator)
** specify the various kinds of tokens (terminals) that the parser
** understands. 
**
** Each symbol here is a terminal symbol in the grammar.
*/
    const TP_COMMENT                        =  1;
    const TP_PHP                            =  2;
    const TP_OTHER                          =  3;
    const TP_SHORTTAGEND                    =  4;
    const TP_SHORTTAGSTART                  =  5;
    const TP_XML                            =  6;
    const TP_LDEL                           =  7;
    const TP_RDEL                           =  8;
    const TP_EQUAL                          =  9;
    const TP_ID                             = 10;
    const TP_PTR                            = 11;
    const TP_SPACE                          = 12;
    const TP_SEMICOLON                      = 13;
    const TP_DOLLAR                         = 14;
    const TP_INCDEC                         = 15;
    const TP_AS                             = 16;
    const TP_APTR                           = 17;
    const TP_LDELSLASH                      = 18;
    const TP_INTEGER                        = 19;
    const TP_COMMA                          = 20;
    const TP_COLON                          = 21;
    const TP_UNIMATH                        = 22;
    const TP_OPENP                          = 23;
    const TP_CLOSEP                         = 24;
    const TP_QMARK                          = 25;
    const TP_MATH                           = 26;
    const TP_ANDSYM                         = 27;
    const TP_TYPECAST                       = 28;
    const TP_DOT                            = 29;
    const TP_BOOLEAN                        = 30;
    const TP_NULL                           = 31;
    const TP_SINGLEQUOTESTRING              = 32;
    const TP_QUOTE                          = 33;
    const TP_DOUBLECOLON                    = 34;
    const TP_AT                             = 35;
    const TP_HATCH                          = 36;
    const TP_OPENB                          = 37;
    const TP_CLOSEB                         = 38;
    const TP_VERT                           = 39;
    const TP_NOT                            = 40;
    const TP_ISIN                           = 41;
    const TP_ISDIVBY                        = 42;
    const TP_ISNOTDIVBY                     = 43;
    const TP_ISEVEN                         = 44;
    const TP_ISNOTEVEN                      = 45;
    const TP_ISEVENBY                       = 46;
    const TP_ISNOTEVENBY                    = 47;
    const TP_ISODD                          = 48;
    const TP_ISNOTODD                       = 49;
    const TP_ISODDBY                        = 50;
    const TP_ISNOTODDBY                     = 51;
    const TP_INSTANCEOF                     = 52;
    const TP_EQUALS                         = 53;
    const TP_NOTEQUALS                      = 54;
    const TP_GREATERTHAN                    = 55;
    const TP_LESSTHAN                       = 56;
    const TP_GREATEREQUAL                   = 57;
    const TP_LESSEQUAL                      = 58;
    const TP_IDENTITY                       = 59;
    const TP_NONEIDENTITY                   = 60;
    const TP_MOD                            = 61;
    const TP_LAND                           = 62;
    const TP_LOR                            = 63;
    const TP_LXOR                           = 64;
    const TP_BACKTICK                       = 65;
    const TP_DOLLARID                       = 66;
    const YY_NO_ACTION = 493;
    const YY_ACCEPT_ACTION = 492;
    const YY_ERROR_ACTION = 491;

/* Next are that tables used to determine what action to take based on the
** current state and lookahead token.  These tables are used to implement
** functions that take a state number and lookahead value and return an
** action integer.  
**
** Suppose the action integer is N.  Then the action is determined as
** follows
**
**   0 <= N < self::YYNSTATE                              Shift N.  That is,
**                                                        push the lookahead
**                                                        token onto the stack
**                                                        and goto state N.
**
**   self::YYNSTATE <= N < self::YYNSTATE+self::YYNRULE   Reduce by rule N-YYNSTATE.
**
**   N == self::YYNSTATE+self::YYNRULE                    A syntax error has occurred.
**
**   N == self::YYNSTATE+self::YYNRULE+1                  The parser accepts its
**                                                        input. (and concludes parsing)
**
**   N == self::YYNSTATE+self::YYNRULE+2                  No such action.  Denotes unused
**                                                        slots in the yy_action[] table.
**
** The action table is constructed as a single large static array $yy_action.
** Given state S and lookahead X, the action is computed as
**
**      self::$yy_action[self::$yy_shift_ofst[S] + X ]
**
** If the index value self::$yy_shift_ofst[S]+X is out of range or if the value
** self::$yy_lookahead[self::$yy_shift_ofst[S]+X] is not equal to X or if
** self::$yy_shift_ofst[S] is equal to self::YY_SHIFT_USE_DFLT, it means that
** the action is not in the table and that self::$yy_default[S] should be used instead.  
**
** The formula above is for computing the action when the lookahead is
** a terminal symbol.  If the lookahead is a non-terminal (as occurs after
** a reduce action) then the static $yy_reduce_ofst array is used in place of
** the static $yy_shift_ofst array and self::YY_REDUCE_USE_DFLT is used in place of
** self::YY_SHIFT_USE_DFLT.
**
** The following are the tables generated in this section:
**
**  self::$yy_action        A single table containing all actions.
**  self::$yy_lookahead     A table containing the lookahead for each entry in
**                          yy_action.  Used to detect hash collisions.
**  self::$yy_shift_ofst    For each state, the offset into self::$yy_action for
**                          shifting terminals.
**  self::$yy_reduce_ofst   For each state, the offset into self::$yy_action for
**                          shifting non-terminals after a reduce.
**  self::$yy_default       Default action for each state.
*/
    const YY_SZ_ACTTAB = 1436;
static public $yy_action = array(
 /*     0 */    19,  111,   26,  164,   23,  319,   35,   73,   17,  117,
 /*    10 */   322,  194,  198,   77,  126,   42,    3,  492,   63,  224,
 /*    20 */   222,   59,  293,  323,  302,  318,   47,  166,  234,   51,
 /*    30 */    13,   19,  306,    4,  158,   51,  300,  299,   77,  314,
 /*    40 */   195,  236,  194,  198,   81,  156,   42,   36,  250,   81,
 /*    50 */   106,   45,   59,  290,  323,  302,  318,   47,  303,   37,
 /*    60 */    51,   13,  256,   19,  259,  240,  157,  312,  214,  259,
 /*    70 */    78,  161,   18,  203,  194,  160,  190,  128,   42,    3,
 /*    80 */    77,  237,  173,  194,   59,   34,  323,  302,  318,   47,
 /*    90 */   155,  234,   51,   13,   19,  306,    4,  164,  228,  300,
 /*   100 */   299,   73,   51,  166,  236,  194,  198,  306,  176,   42,
 /*   110 */    36,  300,  299,   26,  305,   59,  319,  323,  302,  318,
 /*   120 */    47,  166,  321,   51,   13,   19,  161,  269,  164,  255,
 /*   130 */    56,  212,   73,  314,  195,  239,  194,  198,   81,  161,
 /*   140 */    42,    2,   26,  225,   43,  319,   59,  247,  323,  302,
 /*   150 */   318,   47,  303,  289,   51,   13,  114,   26,  259,   28,
 /*   160 */   319,    8,    7,  280,  282,   12,   10,  304,  281,   11,
 /*   170 */     5,    8,    7,  280,  282,   12,   10,  304,  281,   11,
 /*   180 */     5,  278,  283,  284,  145,  192,  362,   15,   31,  112,
 /*   190 */   362,  278,  283,  284,  229,  208,  241,  242,  205,  252,
 /*   200 */    19,   21,  136,  234,   26,  207,   28,  319,  199,  172,
 /*   210 */   161,  194,  118,    8,    7,  280,  282,   12,   10,  304,
 /*   220 */   281,   11,    5,    8,    7,  280,  282,   12,   10,  304,
 /*   230 */   281,   11,    5,  278,  283,  284,   20,  166,   44,   19,
 /*   240 */    44,   21,  163,  278,  283,  284,   77,  187,  298,  243,
 /*   250 */   194,  198,  118,  161,   42,   36,  249,  123,   45,  277,
 /*   260 */    59,   24,  323,  302,  318,   47,   37,   21,   51,   13,
 /*   270 */    19,  234,  286,  165,  166,  183,    1,   77,  118,  310,
 /*   280 */   161,  194,  198,  161,  236,   42,   36,   21,  125,   39,
 /*   290 */   296,   59,  153,  323,  302,  318,   47,  154,  118,   51,
 /*   300 */    13,   19,  234,  166,   46,  226,  258,  358,   73,   81,
 /*   310 */   166,  161,  194,  198,  255,  142,   42,    2,  233,  124,
 /*   320 */   260,  166,   59,  153,  323,  302,  318,   47,  166,  259,
 /*   330 */    51,   13,   19,  234,  309,  159,  103,  139,  161,   73,
 /*   340 */   314,  195,  260,  194,  198,   81,  121,   42,   36,   26,
 /*   350 */   151,  295,  319,   59,  221,  323,  302,  318,   47,  303,
 /*   360 */   234,   51,   13,   19,  147,  259,  165,   21,  120,  109,
 /*   370 */    77,  138,  152,  150,  194,  198,  311,  192,  118,   36,
 /*   380 */   161,  197,  234,  234,   59,  297,  323,  302,  318,   47,
 /*   390 */   191,  214,   51,   13,   81,   18,    8,    7,  280,  282,
 /*   400 */    12,   10,  304,  281,   11,    5,  194,   27,  181,  274,
 /*   410 */   196,  219,   81,  161,  259,   33,  278,  283,  284,  314,
 /*   420 */   195,  218,   62,   22,   81,  255,  316,   88,  174,  170,
 /*   430 */   161,   64,  259,  169,  184,  360,  102,  166,  303,  360,
 /*   440 */    29,  254,  314,  195,  259,   81,  217,   81,   16,  279,
 /*   450 */   223,  222,   19,   56,  212,  165,  268,  273,  235,   77,
 /*   460 */    77,  303,  161,  194,  198,  259,  270,  259,   36,   26,
 /*   470 */   294,  129,  319,   59,  320,  323,  302,  318,   47,  186,
 /*   480 */   178,   51,   51,   19,  200,  262,  167,  266,  277,  161,
 /*   490 */    77,  161,  285,   49,  194,  198,  161,   26,  193,   36,
 /*   500 */   202,  153,  108,  166,   59,   40,  323,  302,  318,   47,
 /*   510 */    53,   26,   51,  166,  319,   40,  234,  267,  261,  263,
 /*   520 */   264,  265,  275,  276,  287,  288,   25,  267,  261,  263,
 /*   530 */   264,  265,  275,  276,  287,  288,  314,  195,  227,   62,
 /*   540 */    30,   81,  141,  219,   86,   38,  161,  260,  211,   67,
 /*   550 */   189,  307,   77,  102,  137,  303,   65,  201,  166,  260,
 /*   560 */   140,  259,  314,  195,  295,   62,  279,   81,  232,  230,
 /*   570 */    96,  295,   52,  166,   51,  131,  189,  307,  220,  102,
 /*   580 */   105,  303,   66,  100,  166,  314,  195,  259,   62,  234,
 /*   590 */    81,   99,  279,   92,  171,  295,  101,  295,  295,  189,
 /*   600 */   307,  317,  102,  166,  303,   40,  295,  177,  320,  153,
 /*   610 */   259,  295,    9,   57,   15,  279,  251,  267,  261,  263,
 /*   620 */   264,  265,  275,  276,  287,  288,  199,  314,  195,   31,
 /*   630 */    62,  209,   81,   26,  301,   91,  319,  175,  179,  315,
 /*   640 */    58,  189,  307,  182,  102,  291,  303,   75,  314,  195,
 /*   650 */   248,   62,  259,   81,   79,  213,   93,  279,  210,   22,
 /*   660 */   206,  257,  189,  307,   43,  102,   76,  303,  215,   80,
 /*   670 */   216,  314,  195,  259,   62,  292,   81,  246,  279,   90,
 /*   680 */    72,   32,  185,  245,   70,  189,  307,    6,  102,  244,
 /*   690 */   303,  233,  314,  195,  127,   62,  259,   81,   41,  161,
 /*   700 */    89,  279,   44,   84,   74,  320,  189,  307,  236,  102,
 /*   710 */    39,  303,  253,  314,  195,  308,   62,  259,   81,   50,
 /*   720 */    14,   95,  279,  276,  276,  276,  276,  189,  307,  276,
 /*   730 */   102,  276,  303,  276,  314,  195,  276,   62,  259,   81,
 /*   740 */   276,  276,   94,  279,  276,  276,  276,  276,  189,  307,
 /*   750 */   276,  102,  276,  303,  276,  276,  276,  314,  195,  259,
 /*   760 */    61,  276,   81,  276,  279,   87,  276,  276,  276,  276,
 /*   770 */   276,  189,  307,  276,  102,  276,  303,  276,  314,  195,
 /*   780 */   276,  115,  259,   81,  276,  276,  276,  279,  276,  276,
 /*   790 */   276,  276,  238,  307,  276,  102,  276,  303,  276,  314,
 /*   800 */   195,  276,   60,  259,   81,  276,  276,   85,  276,  276,
 /*   810 */   276,  168,  272,  189,  307,  276,  102,  276,  303,  276,
 /*   820 */   314,  195,  276,  115,  259,   81,  276,  276,  276,  279,
 /*   830 */   276,  276,  276,  276,  238,  307,  276,  102,  276,  303,
 /*   840 */   276,  276,  276,  314,  195,  259,  110,  276,   81,  276,
 /*   850 */   276,  276,  276,  276,  271,  276,  276,  238,  307,  276,
 /*   860 */   102,  276,  303,  276,  276,  204,  276,  276,  259,  314,
 /*   870 */    68,  276,   48,   83,   71,  276,  314,  195,  276,  110,
 /*   880 */   276,   81,  276,  238,  307,  276,  102,  276,  303,  276,
 /*   890 */   238,  307,  276,  102,  259,  303,  276,  276,  188,  276,
 /*   900 */   276,  259,  276,  276,  276,  276,  314,   69,  276,   54,
 /*   910 */    83,   71,  276,  276,  276,  276,  276,  276,  276,  276,
 /*   920 */   238,  307,  276,  102,  276,  303,  276,  276,  276,  314,
 /*   930 */   195,  259,   55,   82,   81,  276,  276,  276,  276,  276,
 /*   940 */   276,  276,  276,  238,  307,  276,  102,  276,  303,  276,
 /*   950 */   276,  276,  276,  276,  259,  314,  195,  276,  110,  276,
 /*   960 */    81,  276,  276,  276,  276,  276,  276,  276,  276,  238,
 /*   970 */   307,  276,  102,  276,  303,  276,  276,  180,  314,  195,
 /*   980 */   259,  149,  231,   81,  276,  276,  276,  276,  276,  276,
 /*   990 */   276,  276,  162,  307,  276,  102,  276,  303,  276,  276,
 /*  1000 */   276,  314,  195,  259,  110,  276,   81,  276,  276,  276,
 /*  1010 */   276,  276,  276,  276,  276,  238,  307,  276,  102,  276,
 /*  1020 */   303,  276,  276,  313,  276,  276,  259,  314,  195,  276,
 /*  1030 */   135,  276,   81,  276,  276,  276,  276,  276,  276,  276,
 /*  1040 */   276,  238,  307,  276,  102,  276,  303,  276,  276,  276,
 /*  1050 */   314,  195,  259,  107,  276,   81,  276,  276,  276,  276,
 /*  1060 */   276,  276,  276,  276,  238,  307,  276,  102,  276,  303,
 /*  1070 */   276,  276,  276,  314,  195,  259,  144,  276,   81,  276,
 /*  1080 */   276,  276,  276,  276,  276,  276,  276,  238,  307,  276,
 /*  1090 */   102,  276,  303,  276,  276,  276,  276,  276,  259,  314,
 /*  1100 */   195,  276,  113,  276,   81,  276,  276,  276,  276,  276,
 /*  1110 */   276,  276,  276,  238,  307,  276,  102,  276,  303,  276,
 /*  1120 */   276,  276,  314,  195,  259,  122,  276,   81,  276,  276,
 /*  1130 */   276,  276,  276,  276,  276,  276,  238,  307,  276,  102,
 /*  1140 */   276,  303,  276,  276,  276,  314,  195,  259,  134,  276,
 /*  1150 */    81,  276,  276,  276,  276,  276,  276,  276,  276,  238,
 /*  1160 */   307,  276,  102,  276,  303,  276,  276,  276,  276,  276,
 /*  1170 */   259,  314,  195,  276,  143,  276,   81,  276,  276,  276,
 /*  1180 */   276,  276,  276,  276,  276,  238,  307,  276,  102,  276,
 /*  1190 */   303,  276,  276,  276,  314,  195,  259,  132,  276,   81,
 /*  1200 */   276,  276,  276,  276,  276,  276,  276,  276,  238,  307,
 /*  1210 */   276,  102,  276,  303,  276,  276,  276,  314,  195,  259,
 /*  1220 */   146,  276,   81,  276,  276,  276,  276,  276,  276,  276,
 /*  1230 */   276,  238,  307,  276,  102,  276,  303,  276,  276,  276,
 /*  1240 */   276,  276,  259,  314,  195,  276,  148,  276,   81,  276,
 /*  1250 */   276,  276,  276,  276,  276,  276,  276,  238,  307,  276,
 /*  1260 */   102,  276,  303,  276,  276,  276,  314,  195,  259,  130,
 /*  1270 */   276,   81,  276,  276,  276,  276,  276,  276,  276,  276,
 /*  1280 */   238,  307,  276,  102,  276,  303,  276,  276,  276,  314,
 /*  1290 */   195,  259,  116,  276,   81,  276,  276,  276,  276,  276,
 /*  1300 */   276,  276,  276,  238,  307,  276,  102,  276,  303,  276,
 /*  1310 */   276,  276,  276,  276,  259,  314,  195,  276,  133,  276,
 /*  1320 */    81,  276,  276,  276,  276,  276,  276,  276,  276,  238,
 /*  1330 */   307,  276,  102,  276,  303,  276,  276,  276,  314,  195,
 /*  1340 */   259,  119,  276,   81,  276,  276,  276,  276,  276,  276,
 /*  1350 */   276,  276,  238,  307,  276,  102,  276,  303,  276,  276,
 /*  1360 */   276,  314,  195,  259,  276,  276,   81,  276,  276,  276,
 /*  1370 */   276,  276,  276,  276,  276,  238,  307,  276,   98,  276,
 /*  1380 */   303,  276,  276,  276,  276,  276,  259,  314,  195,  276,
 /*  1390 */   276,  276,   81,  276,  276,  276,  276,  276,  276,  276,
 /*  1400 */   276,  238,  307,  276,   97,  276,  303,  276,  276,  276,
 /*  1410 */   314,  195,  259,  276,  276,   81,  276,  276,  276,  276,
 /*  1420 */   276,  276,  276,  276,  238,  307,  276,  104,  276,  303,
 /*  1430 */   276,  276,  276,  276,  276,  259,
    );
    static public $yy_lookahead = array(
 /*     0 */     7,   95,    7,   10,    9,   10,    7,   14,   20,   10,
 /*    10 */    15,   18,   19,   14,   73,   22,   23,   68,   69,   70,
 /*    20 */    71,   28,   10,   30,   31,   32,   33,   39,   87,   36,
 /*    30 */    37,    7,   22,   40,   10,   36,   26,   27,   14,   71,
 /*    40 */    72,  100,   18,   19,   76,   72,   22,   23,   38,   76,
 /*    50 */    95,   29,   28,   85,   30,   31,   32,   33,   90,   37,
 /*    60 */    36,   37,   38,    7,   96,   92,   10,    8,    3,   96,
 /*    70 */    14,   12,    7,   10,   18,   19,   10,   73,   22,   23,
 /*    80 */    14,    8,   19,   18,   28,   21,   30,   31,   32,   33,
 /*    90 */     8,   87,   36,   37,    7,   22,   40,   10,   33,   26,
 /*   100 */    27,   14,   36,   39,  100,   18,   19,   22,   16,   22,
 /*   110 */    23,   26,   27,    7,    8,   28,   10,   30,   31,   32,
 /*   120 */    33,   39,    8,   36,   37,    7,   12,    8,   10,   15,
 /*   130 */    65,   66,   14,   71,   72,    8,   18,   19,   76,   12,
 /*   140 */    22,   23,    7,    8,   52,   10,   28,   85,   30,   31,
 /*   150 */    32,   33,   90,   24,   36,   37,   95,    7,   96,    9,
 /*   160 */    10,   42,   43,   44,   45,   46,   47,   48,   49,   50,
 /*   170 */    51,   42,   43,   44,   45,   46,   47,   48,   49,   50,
 /*   180 */    51,   62,   63,   64,   13,   35,    8,    9,    9,   73,
 /*   190 */    12,   62,   63,   64,    1,    2,    3,    4,    5,    6,
 /*   200 */     7,   23,   78,   87,    7,   24,    9,   10,   29,   11,
 /*   210 */    12,   18,   34,   42,   43,   44,   45,   46,   47,   48,
 /*   220 */    49,   50,   51,   42,   43,   44,   45,   46,   47,   48,
 /*   230 */    49,   50,   51,   62,   63,   64,    9,   39,   11,    7,
 /*   240 */    11,   23,   10,   62,   63,   64,   14,   29,   10,    8,
 /*   250 */    18,   19,   34,   12,   22,   23,   38,   73,   29,   24,
 /*   260 */    28,   17,   30,   31,   32,   33,   37,   23,   36,   37,
 /*   270 */     7,   87,    8,   10,   39,   11,   12,   14,   34,    8,
 /*   280 */    12,   18,   19,   12,  100,   22,   23,   23,   73,   21,
 /*   290 */     8,   28,   77,   30,   31,   32,   33,    8,   34,   36,
 /*   300 */    37,    7,   87,   39,   10,   72,   19,    8,   14,   76,
 /*   310 */    39,   12,   18,   19,   15,   94,   22,   23,   97,   73,
 /*   320 */    99,   39,   28,   77,   30,   31,   32,   33,   39,   96,
 /*   330 */    36,   37,    7,   87,    8,   10,   83,   94,   12,   14,
 /*   340 */    71,   72,   99,   18,   19,   76,   73,   22,   23,    7,
 /*   350 */    77,   98,   10,   28,   85,   30,   31,   32,   33,   90,
 /*   360 */    87,   36,   37,    7,   13,   96,   10,   23,   73,   73,
 /*   370 */    14,   20,   77,   77,   18,   19,    8,   35,   34,   23,
 /*   380 */    12,   21,   87,   87,   28,   10,   30,   31,   32,   33,
 /*   390 */    72,    3,   36,   37,   76,    7,   42,   43,   44,   45,
 /*   400 */    46,   47,   48,   49,   50,   51,   18,    7,   72,    8,
 /*   410 */    35,   71,   76,   12,   96,   17,   62,   63,   64,   71,
 /*   420 */    72,   33,   74,   23,   76,   15,    8,   79,   80,   81,
 /*   430 */    12,   91,   96,   85,   86,    8,   88,   39,   90,   12,
 /*   440 */    25,   72,   71,   72,   96,   76,  106,   76,   20,  101,
 /*   450 */    70,   71,    7,   65,   66,   10,   85,   86,    8,   14,
 /*   460 */    14,   90,   12,   18,   19,   96,   38,   96,   23,    7,
 /*   470 */     8,   95,   10,   28,   98,   30,   31,   32,   33,   17,
 /*   480 */    10,   36,   36,    7,   14,    8,   10,    8,   24,   12,
 /*   490 */    14,   12,    8,   10,   18,   19,   12,    7,   24,   23,
 /*   500 */    10,   77,   73,   39,   28,   41,   30,   31,   32,   33,
 /*   510 */    78,    7,   36,   39,   10,   41,   87,   53,   54,   55,
 /*   520 */    56,   57,   58,   59,   60,   61,  102,   53,   54,   55,
 /*   530 */    56,   57,   58,   59,   60,   61,   71,   72,   10,   74,
 /*   540 */    21,   76,   94,   71,   79,    7,   12,   99,   10,   83,
 /*   550 */    85,   86,   14,   88,   94,   90,   83,   19,   39,   99,
 /*   560 */    10,   96,   71,   72,   98,   74,  101,   76,   30,   31,
 /*   570 */    79,   98,   78,   39,   36,   73,   85,   86,  106,   88,
 /*   580 */    83,   90,   83,   83,   39,   71,   72,   96,   74,   87,
 /*   590 */    76,   83,  101,   79,   84,   98,   83,   98,   98,   85,
 /*   600 */    86,   12,   88,   39,   90,   41,   98,   82,   98,   77,
 /*   610 */    96,   98,   82,   78,    9,  101,   10,   53,   54,   55,
 /*   620 */    56,   57,   58,   59,   60,   61,   29,   71,   72,    9,
 /*   630 */    74,    3,   76,    7,    8,   79,   10,   10,   16,    8,
 /*   640 */    10,   85,   86,   17,   88,    8,   90,   14,   71,   72,
 /*   650 */     4,   74,   96,   76,   14,    8,   79,  101,   65,   23,
 /*   660 */     3,   38,   85,   86,   52,   88,   14,   90,   36,   24,
 /*   670 */    36,   71,   72,   96,   74,   24,   76,   24,  101,   79,
 /*   680 */    14,   25,   10,    4,   14,   85,   86,  103,   88,   87,
 /*   690 */    90,   97,   71,   72,   95,   74,   96,   76,   89,   12,
 /*   700 */    79,  101,   11,   92,   14,   98,   85,   86,  100,   88,
 /*   710 */    21,   90,   99,   71,   72,   80,   74,   96,   76,   95,
 /*   720 */    23,   79,  101,  107,  107,  107,  107,   85,   86,  107,
 /*   730 */    88,  107,   90,  107,   71,   72,  107,   74,   96,   76,
 /*   740 */   107,  107,   79,  101,  107,  107,  107,  107,   85,   86,
 /*   750 */   107,   88,  107,   90,  107,  107,  107,   71,   72,   96,
 /*   760 */    74,  107,   76,  107,  101,   79,  107,  107,  107,  107,
 /*   770 */   107,   85,   86,  107,   88,  107,   90,  107,   71,   72,
 /*   780 */   107,   74,   96,   76,  107,  107,  107,  101,  107,  107,
 /*   790 */   107,  107,   85,   86,  107,   88,  107,   90,  107,   71,
 /*   800 */    72,  107,   74,   96,   76,  107,  107,   79,  107,  107,
 /*   810 */   107,  104,  105,   85,   86,  107,   88,  107,   90,  107,
 /*   820 */    71,   72,  107,   74,   96,   76,  107,  107,  107,  101,
 /*   830 */   107,  107,  107,  107,   85,   86,  107,   88,  107,   90,
 /*   840 */   107,  107,  107,   71,   72,   96,   74,  107,   76,  107,
 /*   850 */   107,  107,  107,  107,  105,  107,  107,   85,   86,  107,
 /*   860 */    88,  107,   90,  107,  107,   93,  107,  107,   96,   71,
 /*   870 */    72,  107,   74,   75,   76,  107,   71,   72,  107,   74,
 /*   880 */   107,   76,  107,   85,   86,  107,   88,  107,   90,  107,
 /*   890 */    85,   86,  107,   88,   96,   90,  107,  107,   93,  107,
 /*   900 */   107,   96,  107,  107,  107,  107,   71,   72,  107,   74,
 /*   910 */    75,   76,  107,  107,  107,  107,  107,  107,  107,  107,
 /*   920 */    85,   86,  107,   88,  107,   90,  107,  107,  107,   71,
 /*   930 */    72,   96,   74,   75,   76,  107,  107,  107,  107,  107,
 /*   940 */   107,  107,  107,   85,   86,  107,   88,  107,   90,  107,
 /*   950 */   107,  107,  107,  107,   96,   71,   72,  107,   74,  107,
 /*   960 */    76,  107,  107,  107,  107,  107,  107,  107,  107,   85,
 /*   970 */    86,  107,   88,  107,   90,  107,  107,   93,   71,   72,
 /*   980 */    96,   74,   75,   76,  107,  107,  107,  107,  107,  107,
 /*   990 */   107,  107,   85,   86,  107,   88,  107,   90,  107,  107,
 /*  1000 */   107,   71,   72,   96,   74,  107,   76,  107,  107,  107,
 /*  1010 */   107,  107,  107,  107,  107,   85,   86,  107,   88,  107,
 /*  1020 */    90,  107,  107,   93,  107,  107,   96,   71,   72,  107,
 /*  1030 */    74,  107,   76,  107,  107,  107,  107,  107,  107,  107,
 /*  1040 */   107,   85,   86,  107,   88,  107,   90,  107,  107,  107,
 /*  1050 */    71,   72,   96,   74,  107,   76,  107,  107,  107,  107,
 /*  1060 */   107,  107,  107,  107,   85,   86,  107,   88,  107,   90,
 /*  1070 */   107,  107,  107,   71,   72,   96,   74,  107,   76,  107,
 /*  1080 */   107,  107,  107,  107,  107,  107,  107,   85,   86,  107,
 /*  1090 */    88,  107,   90,  107,  107,  107,  107,  107,   96,   71,
 /*  1100 */    72,  107,   74,  107,   76,  107,  107,  107,  107,  107,
 /*  1110 */   107,  107,  107,   85,   86,  107,   88,  107,   90,  107,
 /*  1120 */   107,  107,   71,   72,   96,   74,  107,   76,  107,  107,
 /*  1130 */   107,  107,  107,  107,  107,  107,   85,   86,  107,   88,
 /*  1140 */   107,   90,  107,  107,  107,   71,   72,   96,   74,  107,
 /*  1150 */    76,  107,  107,  107,  107,  107,  107,  107,  107,   85,
 /*  1160 */    86,  107,   88,  107,   90,  107,  107,  107,  107,  107,
 /*  1170 */    96,   71,   72,  107,   74,  107,   76,  107,  107,  107,
 /*  1180 */   107,  107,  107,  107,  107,   85,   86,  107,   88,  107,
 /*  1190 */    90,  107,  107,  107,   71,   72,   96,   74,  107,   76,
 /*  1200 */   107,  107,  107,  107,  107,  107,  107,  107,   85,   86,
 /*  1210 */   107,   88,  107,   90,  107,  107,  107,   71,   72,   96,
 /*  1220 */    74,  107,   76,  107,  107,  107,  107,  107,  107,  107,
 /*  1230 */   107,   85,   86,  107,   88,  107,   90,  107,  107,  107,
 /*  1240 */   107,  107,   96,   71,   72,  107,   74,  107,   76,  107,
 /*  1250 */   107,  107,  107,  107,  107,  107,  107,   85,   86,  107,
 /*  1260 */    88,  107,   90,  107,  107,  107,   71,   72,   96,   74,
 /*  1270 */   107,   76,  107,  107,  107,  107,  107,  107,  107,  107,
 /*  1280 */    85,   86,  107,   88,  107,   90,  107,  107,  107,   71,
 /*  1290 */    72,   96,   74,  107,   76,  107,  107,  107,  107,  107,
 /*  1300 */   107,  107,  107,   85,   86,  107,   88,  107,   90,  107,
 /*  1310 */   107,  107,  107,  107,   96,   71,   72,  107,   74,  107,
 /*  1320 */    76,  107,  107,  107,  107,  107,  107,  107,  107,   85,
 /*  1330 */    86,  107,   88,  107,   90,  107,  107,  107,   71,   72,
 /*  1340 */    96,   74,  107,   76,  107,  107,  107,  107,  107,  107,
 /*  1350 */   107,  107,   85,   86,  107,   88,  107,   90,  107,  107,
 /*  1360 */   107,   71,   72,   96,  107,  107,   76,  107,  107,  107,
 /*  1370 */   107,  107,  107,  107,  107,   85,   86,  107,   88,  107,
 /*  1380 */    90,  107,  107,  107,  107,  107,   96,   71,   72,  107,
 /*  1390 */   107,  107,   76,  107,  107,  107,  107,  107,  107,  107,
 /*  1400 */   107,   85,   86,  107,   88,  107,   90,  107,  107,  107,
 /*  1410 */    71,   72,   96,  107,  107,   76,  107,  107,  107,  107,
 /*  1420 */   107,  107,  107,  107,   85,   86,  107,   88,  107,   90,
 /*  1430 */   107,  107,  107,  107,  107,   96,
);
    const YY_SHIFT_USE_DFLT = -13;
    const YY_SHIFT_MAX = 209;
    static public $yy_shift_ofst = array(
 /*     0 */   193,   56,   -7,   -7,   -7,   -7,   -7,   -7,   -7,   -7,
 /*    10 */    -7,   -7,   -7,  325,   87,  118,  325,   87,  294,  294,
 /*    20 */   118,   87,   87,   87,   87,   87,   87,   87,   87,   87,
 /*    30 */    87,   87,   87,   87,   87,   87,   87,   24,  263,  232,
 /*    40 */   356,  445,  445,  476,   -1,  538,  264,  388,  271,  198,
 /*    50 */   229,   66,  268,  268,  534,  534,  446,  268,  534,  446,
 /*    60 */   474,  464,  564,  193,   65,   -5,  150,  342,  114,  299,
 /*    70 */   504,  227,  504,  490,  504,  504,  504,  504,  490,  504,
 /*    80 */   691,  691,  687,  687,  691,  181,  171,  129,  119,  354,
 /*    90 */   354,  354,  354,  354,  354,  354,  354,   10,   73,  462,
 /*   100 */   626,  135,   85,  106,   85,  197,   22,   82,   59,  127,
 /*   110 */   -12,   22,  241,  519,   22,  398,  289,  400,  470,   64,
 /*   120 */   484,  479,  282,  401,  368,  418,  477,   22,  450,   22,
 /*   130 */   235,  326,  545,  545,  545,  545,  689,  691,  690,  691,
 /*   140 */   697,  691,  691,  545,  545,  589,  545,  589,  545,  545,
 /*   150 */   -13,  -13,  -13,  -13,  -13,  -13,  -13,  178,  218,  244,
 /*   160 */   179,   63,  427,  344,  344,  344,  375,  344,  428,   92,
 /*   170 */   351,  631,  627,  620,  637,  647,  633,  670,  636,  652,
 /*   180 */   645,  593,  640,  630,  622,  623,  666,  672,  653,  612,
 /*   190 */   632,  634,  606,  415,  483,  410,  238,   12,  597,  287,
 /*   200 */   550,  528,  360,  605,  651,  657,  679,  656,  628,  646,
);
    const YY_REDUCE_USE_DFLT = -95;
    const YY_REDUCE_MAX = 156;
    static public $yy_reduce_ofst = array(
 /*     0 */   -51,  348,  728,  686,  491,  514,  600,  556,  577,  465,
 /*    10 */   621,  663,  642,  707,  884,  907,  749,  930,  798,  835,
 /*    20 */   858,  772,  805, 1100, 1123, 1074, 1051,  979, 1002, 1028,
 /*    30 */  1146, 1172, 1267,  956, 1244, 1218, 1195, 1316, 1290, 1339,
 /*    40 */   371,  269,   62,  -32,  -27,  233,  295,  340,  215,  296,
 /*    50 */   221,  318,  -59,  184,  215,  246,  336,    4,  273,  369,
 /*    60 */   424,  424,  424,  380,  472,  510,  376,  376,  116,  116,
 /*    70 */   473,  243,  253,  466,  497,  508,  500,  466,  499,  513,
 /*    80 */   448,  243,  429,  502,  460,  584,  584,  584,  584,  584,
 /*    90 */   584,  584,  584,  584,  584,  584,  584,  609,  609,  607,
 /*   100 */   607,  607,  609,  607,  609,  607,  594,  532,  602,  602,
 /*   110 */   532,  594,  602,  532,  594,  532,  532,  599,  611,  532,
 /*   120 */   602,  602,  532,  602,  602,  602,  602,  594,  602,  594,
 /*   130 */   532,  602,  532,  532,  532,  532,  608,  613,  635,  613,
 /*   140 */   624,  613,  613,  532,  532,  525,  532,  530,  532,  532,
 /*   150 */   535,  494,  432,  124,   61,  -45,  -94,
);
    static public $yyExpectedTokens = array(
        /* 0 */ array(1, 2, 3, 4, 5, 6, 7, 18, ),
        /* 1 */ array(7, 10, 14, 18, 19, 22, 23, 28, 30, 31, 32, 33, 36, 37, 40, ),
        /* 2 */ array(7, 10, 14, 18, 19, 22, 23, 28, 30, 31, 32, 33, 36, 37, 40, ),
        /* 3 */ array(7, 10, 14, 18, 19, 22, 23, 28, 30, 31, 32, 33, 36, 37, 40, ),
        /* 4 */ array(7, 10, 14, 18, 19, 22, 23, 28, 30, 31, 32, 33, 36, 37, 40, ),
        /* 5 */ array(7, 10, 14, 18, 19, 22, 23, 28, 30, 31, 32, 33, 36, 37, 40, ),
        /* 6 */ array(7, 10, 14, 18, 19, 22, 23, 28, 30, 31, 32, 33, 36, 37, 40, ),
        /* 7 */ array(7, 10, 14, 18, 19, 22, 23, 28, 30, 31, 32, 33, 36, 37, 40, ),
        /* 8 */ array(7, 10, 14, 18, 19, 22, 23, 28, 30, 31, 32, 33, 36, 37, 40, ),
        /* 9 */ array(7, 10, 14, 18, 19, 22, 23, 28, 30, 31, 32, 33, 36, 37, 40, ),
        /* 10 */ array(7, 10, 14, 18, 19, 22, 23, 28, 30, 31, 32, 33, 36, 37, 40, ),
        /* 11 */ array(7, 10, 14, 18, 19, 22, 23, 28, 30, 31, 32, 33, 36, 37, 40, ),
        /* 12 */ array(7, 10, 14, 18, 19, 22, 23, 28, 30, 31, 32, 33, 36, 37, 40, ),
        /* 13 */ array(7, 10, 14, 18, 19, 22, 23, 28, 30, 31, 32, 33, 36, 37, ),
        /* 14 */ array(7, 10, 14, 18, 19, 22, 23, 28, 30, 31, 32, 33, 36, 37, ),
        /* 15 */ array(7, 10, 14, 18, 19, 22, 23, 28, 30, 31, 32, 33, 36, 37, ),
        /* 16 */ array(7, 10, 14, 18, 19, 22, 23, 28, 30, 31, 32, 33, 36, 37, ),
        /* 17 */ array(7, 10, 14, 18, 19, 22, 23, 28, 30, 31, 32, 33, 36, 37, ),
        /* 18 */ array(7, 10, 14, 18, 19, 22, 23, 28, 30, 31, 32, 33, 36, 37, ),
        /* 19 */ array(7, 10, 14, 18, 19, 22, 23, 28, 30, 31, 32, 33, 36, 37, ),
        /* 20 */ array(7, 10, 14, 18, 19, 22, 23, 28, 30, 31, 32, 33, 36, 37, ),
        /* 21 */ array(7, 10, 14, 18, 19, 22, 23, 28, 30, 31, 32, 33, 36, 37, ),
        /* 22 */ array(7, 10, 14, 18, 19, 22, 23, 28, 30, 31, 32, 33, 36, 37, ),
        /* 23 */ array(7, 10, 14, 18, 19, 22, 23, 28, 30, 31, 32, 33, 36, 37, ),
        /* 24 */ array(7, 10, 14, 18, 19, 22, 23, 28, 30, 31, 32, 33, 36, 37, ),
        /* 25 */ array(7, 10, 14, 18, 19, 22, 23, 28, 30, 31, 32, 33, 36, 37, ),
        /* 26 */ array(7, 10, 14, 18, 19, 22, 23, 28, 30, 31, 32, 33, 36, 37, ),
        /* 27 */ array(7, 10, 14, 18, 19, 22, 23, 28, 30, 31, 32, 33, 36, 37, ),
        /* 28 */ array(7, 10, 14, 18, 19, 22, 23, 28, 30, 31, 32, 33, 36, 37, ),
        /* 29 */ array(7, 10, 14, 18, 19, 22, 23, 28, 30, 31, 32, 33, 36, 37, ),
        /* 30 */ array(7, 10, 14, 18, 19, 22, 23, 28, 30, 31, 32, 33, 36, 37, ),
        /* 31 */ array(7, 10, 14, 18, 19, 22, 23, 28, 30, 31, 32, 33, 36, 37, ),
        /* 32 */ array(7, 10, 14, 18, 19, 22, 23, 28, 30, 31, 32, 33, 36, 37, ),
        /* 33 */ array(7, 10, 14, 18, 19, 22, 23, 28, 30, 31, 32, 33, 36, 37, ),
        /* 34 */ array(7, 10, 14, 18, 19, 22, 23, 28, 30, 31, 32, 33, 36, 37, ),
        /* 35 */ array(7, 10, 14, 18, 19, 22, 23, 28, 30, 31, 32, 33, 36, 37, ),
        /* 36 */ array(7, 10, 14, 18, 19, 22, 23, 28, 30, 31, 32, 33, 36, 37, ),
        /* 37 */ array(7, 10, 14, 18, 19, 22, 23, 28, 30, 31, 32, 33, 36, 37, 38, ),
        /* 38 */ array(7, 10, 14, 18, 19, 22, 23, 28, 30, 31, 32, 33, 36, 37, ),
        /* 39 */ array(7, 10, 14, 18, 19, 22, 23, 28, 30, 31, 32, 33, 36, 37, ),
        /* 40 */ array(7, 10, 14, 18, 19, 23, 28, 30, 31, 32, 33, 36, 37, ),
        /* 41 */ array(7, 10, 14, 18, 19, 23, 28, 30, 31, 32, 33, 36, ),
        /* 42 */ array(7, 10, 14, 18, 19, 23, 28, 30, 31, 32, 33, 36, ),
        /* 43 */ array(7, 10, 14, 18, 19, 23, 28, 30, 31, 32, 33, 36, ),
        /* 44 */ array(7, 10, 14, 36, ),
        /* 45 */ array(7, 10, 14, 19, 30, 31, 36, ),
        /* 46 */ array(8, 11, 12, 23, 34, 39, ),
        /* 47 */ array(3, 7, 18, 33, 65, 66, ),
        /* 48 */ array(8, 12, 39, ),
        /* 49 */ array(11, 12, 39, ),
        /* 50 */ array(11, 29, 37, ),
        /* 51 */ array(10, 14, 36, ),
        /* 52 */ array(12, 21, ),
        /* 53 */ array(12, 21, ),
        /* 54 */ array(12, 39, ),
        /* 55 */ array(12, 39, ),
        /* 56 */ array(14, 36, ),
        /* 57 */ array(12, 21, ),
        /* 58 */ array(12, 39, ),
        /* 59 */ array(14, 36, ),
        /* 60 */ array(24, 39, 41, 53, 54, 55, 56, 57, 58, 59, 60, 61, ),
        /* 61 */ array(24, 39, 41, 53, 54, 55, 56, 57, 58, 59, 60, 61, ),
        /* 62 */ array(39, 41, 53, 54, 55, 56, 57, 58, 59, 60, 61, ),
        /* 63 */ array(1, 2, 3, 4, 5, 6, 7, 18, ),
        /* 64 */ array(3, 7, 18, 33, 65, 66, ),
        /* 65 */ array(7, 9, 10, 15, ),
        /* 66 */ array(7, 9, 10, 35, ),
        /* 67 */ array(7, 10, 35, ),
        /* 68 */ array(8, 12, 15, ),
        /* 69 */ array(8, 12, 15, ),
        /* 70 */ array(7, 10, ),
        /* 71 */ array(9, 11, ),
        /* 72 */ array(7, 10, ),
        /* 73 */ array(7, 10, ),
        /* 74 */ array(7, 10, ),
        /* 75 */ array(7, 10, ),
        /* 76 */ array(7, 10, ),
        /* 77 */ array(7, 10, ),
        /* 78 */ array(7, 10, ),
        /* 79 */ array(7, 10, ),
        /* 80 */ array(11, ),
        /* 81 */ array(11, ),
        /* 82 */ array(12, ),
        /* 83 */ array(12, ),
        /* 84 */ array(11, ),
        /* 85 */ array(24, 42, 43, 44, 45, 46, 47, 48, 49, 50, 51, 62, 63, 64, ),
        /* 86 */ array(13, 42, 43, 44, 45, 46, 47, 48, 49, 50, 51, 62, 63, 64, ),
        /* 87 */ array(24, 42, 43, 44, 45, 46, 47, 48, 49, 50, 51, 62, 63, 64, ),
        /* 88 */ array(8, 42, 43, 44, 45, 46, 47, 48, 49, 50, 51, 62, 63, 64, ),
        /* 89 */ array(42, 43, 44, 45, 46, 47, 48, 49, 50, 51, 62, 63, 64, ),
        /* 90 */ array(42, 43, 44, 45, 46, 47, 48, 49, 50, 51, 62, 63, 64, ),
        /* 91 */ array(42, 43, 44, 45, 46, 47, 48, 49, 50, 51, 62, 63, 64, ),
        /* 92 */ array(42, 43, 44, 45, 46, 47, 48, 49, 50, 51, 62, 63, 64, ),
        /* 93 */ array(42, 43, 44, 45, 46, 47, 48, 49, 50, 51, 62, 63, 64, ),
        /* 94 */ array(42, 43, 44, 45, 46, 47, 48, 49, 50, 51, 62, 63, 64, ),
        /* 95 */ array(42, 43, 44, 45, 46, 47, 48, 49, 50, 51, 62, 63, 64, ),
        /* 96 */ array(42, 43, 44, 45, 46, 47, 48, 49, 50, 51, 62, 63, 64, ),
        /* 97 */ array(22, 26, 27, 38, ),
        /* 98 */ array(8, 22, 26, 27, ),
        /* 99 */ array(7, 8, 10, 17, ),
        /* 100 */ array(7, 8, 10, 17, ),
        /* 101 */ array(7, 8, 10, ),
        /* 102 */ array(22, 26, 27, ),
        /* 103 */ array(7, 8, 10, ),
        /* 104 */ array(22, 26, 27, ),
        /* 105 */ array(7, 9, 10, ),
        /* 106 */ array(29, 37, ),
        /* 107 */ array(8, 39, ),
        /* 108 */ array(8, 12, ),
        /* 109 */ array(8, 12, ),
        /* 110 */ array(20, 39, ),
        /* 111 */ array(29, 37, ),
        /* 112 */ array(8, 12, ),
        /* 113 */ array(21, 39, ),
        /* 114 */ array(29, 37, ),
        /* 115 */ array(17, 39, ),
        /* 116 */ array(8, 39, ),
        /* 117 */ array(7, 23, ),
        /* 118 */ array(10, 14, ),
        /* 119 */ array(21, 39, ),
        /* 120 */ array(8, 12, ),
        /* 121 */ array(8, 12, ),
        /* 122 */ array(8, 39, ),
        /* 123 */ array(8, 12, ),
        /* 124 */ array(8, 12, ),
        /* 125 */ array(8, 12, ),
        /* 126 */ array(8, 12, ),
        /* 127 */ array(29, 37, ),
        /* 128 */ array(8, 12, ),
        /* 129 */ array(29, 37, ),
        /* 130 */ array(24, 39, ),
        /* 131 */ array(8, 12, ),
        /* 132 */ array(39, ),
        /* 133 */ array(39, ),
        /* 134 */ array(39, ),
        /* 135 */ array(39, ),
        /* 136 */ array(21, ),
        /* 137 */ array(11, ),
        /* 138 */ array(14, ),
        /* 139 */ array(11, ),
        /* 140 */ array(23, ),
        /* 141 */ array(11, ),
        /* 142 */ array(11, ),
        /* 143 */ array(39, ),
        /* 144 */ array(39, ),
        /* 145 */ array(12, ),
        /* 146 */ array(39, ),
        /* 147 */ array(12, ),
        /* 148 */ array(39, ),
        /* 149 */ array(39, ),
        /* 150 */ array(),
        /* 151 */ array(),
        /* 152 */ array(),
        /* 153 */ array(),
        /* 154 */ array(),
        /* 155 */ array(),
        /* 156 */ array(),
        /* 157 */ array(8, 9, 12, 23, 34, ),
        /* 158 */ array(23, 29, 34, 38, ),
        /* 159 */ array(17, 23, 34, ),
        /* 160 */ array(9, 29, ),
        /* 161 */ array(10, 19, ),
        /* 162 */ array(8, 12, ),
        /* 163 */ array(23, 34, ),
        /* 164 */ array(23, 34, ),
        /* 165 */ array(23, 34, ),
        /* 166 */ array(10, 35, ),
        /* 167 */ array(23, 34, ),
        /* 168 */ array(20, 38, ),
        /* 169 */ array(16, 52, ),
        /* 170 */ array(13, 20, ),
        /* 171 */ array(8, ),
        /* 172 */ array(10, ),
        /* 173 */ array(9, ),
        /* 174 */ array(8, ),
        /* 175 */ array(8, ),
        /* 176 */ array(14, ),
        /* 177 */ array(14, ),
        /* 178 */ array(23, ),
        /* 179 */ array(14, ),
        /* 180 */ array(24, ),
        /* 181 */ array(65, ),
        /* 182 */ array(14, ),
        /* 183 */ array(10, ),
        /* 184 */ array(16, ),
        /* 185 */ array(38, ),
        /* 186 */ array(14, ),
        /* 187 */ array(10, ),
        /* 188 */ array(24, ),
        /* 189 */ array(52, ),
        /* 190 */ array(36, ),
        /* 191 */ array(36, ),
        /* 192 */ array(10, ),
        /* 193 */ array(25, ),
        /* 194 */ array(10, ),
        /* 195 */ array(15, ),
        /* 196 */ array(10, ),
        /* 197 */ array(10, ),
        /* 198 */ array(29, ),
        /* 199 */ array(19, ),
        /* 200 */ array(10, ),
        /* 201 */ array(10, ),
        /* 202 */ array(21, ),
        /* 203 */ array(9, ),
        /* 204 */ array(24, ),
        /* 205 */ array(3, ),
        /* 206 */ array(4, ),
        /* 207 */ array(25, ),
        /* 208 */ array(3, ),
        /* 209 */ array(4, ),
        /* 210 */ array(),
        /* 211 */ array(),
        /* 212 */ array(),
        /* 213 */ array(),
        /* 214 */ array(),
        /* 215 */ array(),
        /* 216 */ array(),
        /* 217 */ array(),
        /* 218 */ array(),
        /* 219 */ array(),
        /* 220 */ array(),
        /* 221 */ array(),
        /* 222 */ array(),
        /* 223 */ array(),
        /* 224 */ array(),
        /* 225 */ array(),
        /* 226 */ array(),
        /* 227 */ array(),
        /* 228 */ array(),
        /* 229 */ array(),
        /* 230 */ array(),
        /* 231 */ array(),
        /* 232 */ array(),
        /* 233 */ array(),
        /* 234 */ array(),
        /* 235 */ array(),
        /* 236 */ array(),
        /* 237 */ array(),
        /* 238 */ array(),
        /* 239 */ array(),
        /* 240 */ array(),
        /* 241 */ array(),
        /* 242 */ array(),
        /* 243 */ array(),
        /* 244 */ array(),
        /* 245 */ array(),
        /* 246 */ array(),
        /* 247 */ array(),
        /* 248 */ array(),
        /* 249 */ array(),
        /* 250 */ array(),
        /* 251 */ array(),
        /* 252 */ array(),
        /* 253 */ array(),
        /* 254 */ array(),
        /* 255 */ array(),
        /* 256 */ array(),
        /* 257 */ array(),
        /* 258 */ array(),
        /* 259 */ array(),
        /* 260 */ array(),
        /* 261 */ array(),
        /* 262 */ array(),
        /* 263 */ array(),
        /* 264 */ array(),
        /* 265 */ array(),
        /* 266 */ array(),
        /* 267 */ array(),
        /* 268 */ array(),
        /* 269 */ array(),
        /* 270 */ array(),
        /* 271 */ array(),
        /* 272 */ array(),
        /* 273 */ array(),
        /* 274 */ array(),
        /* 275 */ array(),
        /* 276 */ array(),
        /* 277 */ array(),
        /* 278 */ array(),
        /* 279 */ array(),
        /* 280 */ array(),
        /* 281 */ array(),
        /* 282 */ array(),
        /* 283 */ array(),
        /* 284 */ array(),
        /* 285 */ array(),
        /* 286 */ array(),
        /* 287 */ array(),
        /* 288 */ array(),
        /* 289 */ array(),
        /* 290 */ array(),
        /* 291 */ array(),
        /* 292 */ array(),
        /* 293 */ array(),
        /* 294 */ array(),
        /* 295 */ array(),
        /* 296 */ array(),
        /* 297 */ array(),
        /* 298 */ array(),
        /* 299 */ array(),
        /* 300 */ array(),
        /* 301 */ array(),
        /* 302 */ array(),
        /* 303 */ array(),
        /* 304 */ array(),
        /* 305 */ array(),
        /* 306 */ array(),
        /* 307 */ array(),
        /* 308 */ array(),
        /* 309 */ array(),
        /* 310 */ array(),
        /* 311 */ array(),
        /* 312 */ array(),
        /* 313 */ array(),
        /* 314 */ array(),
        /* 315 */ array(),
        /* 316 */ array(),
        /* 317 */ array(),
        /* 318 */ array(),
        /* 319 */ array(),
        /* 320 */ array(),
        /* 321 */ array(),
        /* 322 */ array(),
        /* 323 */ array(),
);
    static public $yy_default = array(
 /*     0 */   491,  491,  491,  491,  491,  491,  491,  491,  491,  491,
 /*    10 */   491,  491,  491,  477,  435,  491,  491,  435,  491,  491,
 /*    20 */   491,  435,  435,  491,  491,  491,  491,  491,  491,  491,
 /*    30 */   491,  491,  491,  491,  491,  491,  491,  491,  491,  491,
 /*    40 */   491,  491,  491,  491,  491,  491,  491,  491,  491,  358,
 /*    50 */   397,  491,  358,  358,  358,  358,  491,  358,  358,  491,
 /*    60 */   445,  445,  445,  324,  491,  491,  407,  407,  380,  380,
 /*    70 */   491,  400,  491,  491,  491,  491,  491,  491,  491,  491,
 /*    80 */   393,  400,  358,  358,  392,  491,  491,  491,  491,  455,
 /*    90 */   449,  451,  459,  450,  458,  454,  443,  491,  491,  491,
 /*   100 */   491,  491,  368,  491,  440,  491,  429,  491,  491,  491,
 /*   110 */   434,  427,  491,  491,  428,  480,  491,  407,  491,  491,
 /*   120 */   491,  491,  491,  491,  491,  491,  491,  426,  491,  405,
 /*   130 */   491,  491,  479,  375,  446,  478,  370,  394,  491,  423,
 /*   140 */   407,  395,  398,  347,  366,  490,  376,  490,  363,  359,
 /*   150 */   439,  439,  439,  439,  407,  407,  407,  367,  491,  367,
 /*   160 */   383,  491,  371,  441,  367,  491,  491,  460,  491,  371,
 /*   170 */   491,  491,  491,  491,  364,  491,  491,  491,  396,  491,
 /*   180 */   491,  491,  491,  491,  374,  491,  491,  491,  491,  371,
 /*   190 */   491,  491,  491,  388,  491,  380,  491,  491,  383,  491,
 /*   200 */   491,  411,  421,  362,  491,  491,  491,  491,  491,  491,
 /*   210 */   483,  408,  484,  355,  488,  403,  404,  482,  391,  487,
 /*   220 */   481,  373,  327,  326,  325,  352,  413,  412,  390,  328,
 /*   230 */   410,  361,  409,  406,  357,  354,  438,  414,  371,  353,
 /*   240 */   430,  333,  332,  334,  356,  330,  432,  372,  329,  415,
 /*   250 */   417,  401,  331,  425,  381,  382,  418,  416,  384,  402,
 /*   260 */   424,  463,  343,  464,  465,  466,  341,  462,  448,  344,
 /*   270 */   474,  476,  475,  447,  342,  467,  468,  388,  471,  442,
 /*   280 */   452,  457,  453,  472,  473,  339,  340,  469,  470,  444,
 /*   290 */   461,  345,  431,  369,  349,  419,  422,  437,  436,  379,
 /*   300 */   378,  351,  386,  387,  456,  350,  377,  374,  365,  336,
 /*   310 */   486,  337,  338,  433,  399,  346,  335,  489,  389,  421,
 /*   320 */   420,  485,  348,  385,
);
/* The next thing included is series of defines which control
** various aspects of the generated parser.
**    self::YYNOCODE      is a number which corresponds
**                        to no legal terminal or nonterminal number.  This
**                        number is used to fill in empty slots of the hash 
**                        table.
**    self::YYFALLBACK    If defined, this indicates that one or more tokens
**                        have fall-back values which should be used if the
**                        original value of the token will not parse.
**    self::YYSTACKDEPTH  is the maximum depth of the parser's stack.
**    self::YYNSTATE      the combined number of states.
**    self::YYNRULE       the number of rules in the grammar
**    self::YYERRORSYMBOL is the code number of the error symbol.  If not
**                        defined, then do no error processing.
*/
    const YYNOCODE = 108;
    const YYSTACKDEPTH = 100;
    const YYNSTATE = 324;
    const YYNRULE = 167;
    const YYERRORSYMBOL = 67;
    const YYERRSYMDT = 'yy0';
    const YYFALLBACK = 0;
    /** The next table maps tokens into fallback tokens.  If a construct
     * like the following:
     * 
     *      %fallback ID X Y Z.
     *
     * appears in the grammer, then ID becomes a fallback token for X, Y,
     * and Z.  Whenever one of the tokens X, Y, or Z is input to the parser
     * but it does not parse, the type of the token is changed to ID and
     * the parse is retried before an error is thrown.
     */
    static public $yyFallback = array(
    );
    /**
     * Turn parser tracing on by giving a stream to which to write the trace
     * and a prompt to preface each trace message.  Tracing is turned off
     * by making either argument NULL 
     *
     * Inputs:
     * 
     * - A stream resource to which trace output should be written.
     *   If NULL, then tracing is turned off.
     * - A prefix string written at the beginning of every
     *   line of trace output.  If NULL, then tracing is
     *   turned off.
     *
     * Outputs:
     * 
     * - None.
     * @param resource
     * @param string
     */
    static function Trace($TraceFILE, $zTracePrompt)
    {
        if (!$TraceFILE) {
            $zTracePrompt = 0;
        } elseif (!$zTracePrompt) {
            $TraceFILE = 0;
        }
        self::$yyTraceFILE = $TraceFILE;
        self::$yyTracePrompt = $zTracePrompt;
    }

    /**
     * Output debug information to output (php://output stream)
     */
    static function PrintTrace()
    {
        self::$yyTraceFILE = fopen('php://output', 'w');
        self::$yyTracePrompt = '<br>';
    }

    /**
     * @var resource|0
     */
    static public $yyTraceFILE;
    /**
     * String to prepend to debug output
     * @var string|0
     */
    static public $yyTracePrompt;
    /**
     * @var int
     */
    public $yyidx;                    /* Index of top element in stack */
    /**
     * @var int
     */
    public $yyerrcnt;                 /* Shifts left before out of the error */
    /**
     * @var array
     */
    public $yystack = array();  /* The parser's stack */

    /**
     * For tracing shifts, the names of all terminals and nonterminals
     * are required.  The following table supplies these names
     * @var array
     */
    public $yyTokenName = array( 
  '$',             'COMMENT',       'PHP',           'OTHER',       
  'SHORTTAGEND',   'SHORTTAGSTART',  'XML',           'LDEL',        
  'RDEL',          'EQUAL',         'ID',            'PTR',         
  'SPACE',         'SEMICOLON',     'DOLLAR',        'INCDEC',      
  'AS',            'APTR',          'LDELSLASH',     'INTEGER',     
  'COMMA',         'COLON',         'UNIMATH',       'OPENP',       
  'CLOSEP',        'QMARK',         'MATH',          'ANDSYM',      
  'TYPECAST',      'DOT',           'BOOLEAN',       'NULL',        
  'SINGLEQUOTESTRING',  'QUOTE',         'DOUBLECOLON',   'AT',          
  'HATCH',         'OPENB',         'CLOSEB',        'VERT',        
  'NOT',           'ISIN',          'ISDIVBY',       'ISNOTDIVBY',  
  'ISEVEN',        'ISNOTEVEN',     'ISEVENBY',      'ISNOTEVENBY', 
  'ISODD',         'ISNOTODD',      'ISODDBY',       'ISNOTODDBY',  
  'INSTANCEOF',    'EQUALS',        'NOTEQUALS',     'GREATERTHAN', 
  'LESSTHAN',      'GREATEREQUAL',  'LESSEQUAL',     'IDENTITY',    
  'NONEIDENTITY',  'MOD',           'LAND',          'LOR',         
  'LXOR',          'BACKTICK',      'DOLLARID',      'error',       
  'start',         'template',      'template_element',  'smartytag',   
  'variable',      'attributes',    'expr',          'ternary',     
  'varindexed',    'modifier',      'modparameters',  'ifexprs',     
  'statement',     'statements',    'optspace',      'varvar',      
  'foraction',     'value',         'array',         'attribute',   
  'exprs',         'math',          'function',      'doublequoted',
  'method',        'params',        'objectchain',   'arrayindex',  
  'object',        'indexdef',      'varvarele',     'objectelement',
  'modparameter',  'ifexpr',        'ifcond',        'lop',         
  'arrayelements',  'arrayelement',  'doublequotedcontent',
    );

    /**
     * For tracing reduce actions, the names of all rules are required.
     * @var array
     */
    static public $yyRuleName = array(
 /*   0 */ "start ::= template",
 /*   1 */ "template ::= template_element",
 /*   2 */ "template ::= template template_element",
 /*   3 */ "template_element ::= smartytag",
 /*   4 */ "template_element ::= COMMENT",
 /*   5 */ "template_element ::= PHP OTHER SHORTTAGEND",
 /*   6 */ "template_element ::= SHORTTAGSTART OTHER SHORTTAGEND",
 /*   7 */ "template_element ::= XML",
 /*   8 */ "template_element ::= SHORTTAGEND",
 /*   9 */ "template_element ::= OTHER",
 /*  10 */ "smartytag ::= LDEL variable attributes RDEL",
 /*  11 */ "smartytag ::= LDEL expr attributes RDEL",
 /*  12 */ "smartytag ::= LDEL ternary attributes RDEL",
 /*  13 */ "smartytag ::= LDEL varindexed EQUAL expr attributes RDEL",
 /*  14 */ "smartytag ::= LDEL varindexed EQUAL ternary attributes RDEL",
 /*  15 */ "smartytag ::= LDEL ID attributes RDEL",
 /*  16 */ "smartytag ::= LDEL ID RDEL",
 /*  17 */ "smartytag ::= LDEL ID PTR ID attributes RDEL",
 /*  18 */ "smartytag ::= LDEL ID modifier modparameters attributes RDEL",
 /*  19 */ "smartytag ::= LDEL ID PTR ID modifier modparameters attributes RDEL",
 /*  20 */ "smartytag ::= LDEL ID SPACE ifexprs RDEL",
 /*  21 */ "smartytag ::= LDEL ID SPACE statement RDEL",
 /*  22 */ "smartytag ::= LDEL ID SPACE statements SEMICOLON optspace ifexprs SEMICOLON optspace DOLLAR varvar foraction RDEL",
 /*  23 */ "foraction ::= EQUAL expr",
 /*  24 */ "foraction ::= INCDEC",
 /*  25 */ "smartytag ::= LDEL ID SPACE value AS DOLLAR varvar RDEL",
 /*  26 */ "smartytag ::= LDEL ID SPACE value AS DOLLAR varvar APTR DOLLAR varvar RDEL",
 /*  27 */ "smartytag ::= LDEL ID SPACE array AS DOLLAR varvar RDEL",
 /*  28 */ "smartytag ::= LDEL ID SPACE array AS DOLLAR varvar APTR DOLLAR varvar RDEL",
 /*  29 */ "smartytag ::= LDELSLASH ID attributes RDEL",
 /*  30 */ "smartytag ::= LDELSLASH ID modifier modparameters attributes RDEL",
 /*  31 */ "smartytag ::= LDELSLASH ID PTR ID RDEL",
 /*  32 */ "attributes ::= attributes attribute",
 /*  33 */ "attributes ::= attribute",
 /*  34 */ "attributes ::=",
 /*  35 */ "attribute ::= SPACE ID EQUAL expr",
 /*  36 */ "attribute ::= SPACE ID EQUAL value",
 /*  37 */ "attribute ::= SPACE ID EQUAL ternary",
 /*  38 */ "attribute ::= SPACE ID",
 /*  39 */ "attribute ::= SPACE INTEGER EQUAL expr",
 /*  40 */ "statements ::= statement",
 /*  41 */ "statements ::= statements COMMA statement",
 /*  42 */ "statement ::= DOLLAR varvar EQUAL expr",
 /*  43 */ "expr ::= ID",
 /*  44 */ "expr ::= exprs",
 /*  45 */ "expr ::= DOLLAR ID COLON ID",
 /*  46 */ "expr ::= expr modifier modparameters",
 /*  47 */ "exprs ::= value",
 /*  48 */ "exprs ::= UNIMATH value",
 /*  49 */ "exprs ::= exprs math value",
 /*  50 */ "exprs ::= array",
 /*  51 */ "ternary ::= OPENP ifexprs CLOSEP QMARK expr COLON expr",
 /*  52 */ "ternary ::= OPENP expr CLOSEP QMARK expr COLON expr",
 /*  53 */ "math ::= UNIMATH",
 /*  54 */ "math ::= MATH",
 /*  55 */ "math ::= ANDSYM",
 /*  56 */ "value ::= variable",
 /*  57 */ "value ::= TYPECAST variable",
 /*  58 */ "value ::= variable INCDEC",
 /*  59 */ "value ::= INTEGER",
 /*  60 */ "value ::= INTEGER DOT INTEGER",
 /*  61 */ "value ::= BOOLEAN",
 /*  62 */ "value ::= NULL",
 /*  63 */ "value ::= function",
 /*  64 */ "value ::= OPENP expr CLOSEP",
 /*  65 */ "value ::= SINGLEQUOTESTRING",
 /*  66 */ "value ::= QUOTE doublequoted QUOTE",
 /*  67 */ "value ::= QUOTE QUOTE",
 /*  68 */ "value ::= ID DOUBLECOLON method",
 /*  69 */ "value ::= ID DOUBLECOLON DOLLAR ID OPENP params CLOSEP",
 /*  70 */ "value ::= ID DOUBLECOLON method objectchain",
 /*  71 */ "value ::= ID DOUBLECOLON DOLLAR ID OPENP params CLOSEP objectchain",
 /*  72 */ "value ::= ID DOUBLECOLON ID",
 /*  73 */ "value ::= ID DOUBLECOLON DOLLAR ID arrayindex",
 /*  74 */ "value ::= ID DOUBLECOLON DOLLAR ID arrayindex objectchain",
 /*  75 */ "value ::= smartytag",
 /*  76 */ "variable ::= varindexed",
 /*  77 */ "variable ::= DOLLAR varvar AT ID",
 /*  78 */ "variable ::= object",
 /*  79 */ "variable ::= HATCH ID HATCH",
 /*  80 */ "variable ::= HATCH variable HATCH",
 /*  81 */ "varindexed ::= DOLLAR varvar arrayindex",
 /*  82 */ "arrayindex ::= arrayindex indexdef",
 /*  83 */ "arrayindex ::=",
 /*  84 */ "indexdef ::= DOT ID",
 /*  85 */ "indexdef ::= DOT BOOLEAN",
 /*  86 */ "indexdef ::= DOT NULL",
 /*  87 */ "indexdef ::= DOT INTEGER",
 /*  88 */ "indexdef ::= DOT INTEGER ID",
 /*  89 */ "indexdef ::= DOT variable",
 /*  90 */ "indexdef ::= DOT LDEL exprs RDEL",
 /*  91 */ "indexdef ::= OPENB ID CLOSEB",
 /*  92 */ "indexdef ::= OPENB ID DOT ID CLOSEB",
 /*  93 */ "indexdef ::= OPENB exprs CLOSEB",
 /*  94 */ "indexdef ::= OPENB CLOSEB",
 /*  95 */ "varvar ::= varvarele",
 /*  96 */ "varvar ::= varvar varvarele",
 /*  97 */ "varvarele ::= ID",
 /*  98 */ "varvarele ::= LDEL expr RDEL",
 /*  99 */ "object ::= varindexed objectchain",
 /* 100 */ "objectchain ::= objectelement",
 /* 101 */ "objectchain ::= objectchain objectelement",
 /* 102 */ "objectelement ::= PTR ID arrayindex",
 /* 103 */ "objectelement ::= PTR variable arrayindex",
 /* 104 */ "objectelement ::= PTR LDEL expr RDEL arrayindex",
 /* 105 */ "objectelement ::= PTR ID LDEL expr RDEL arrayindex",
 /* 106 */ "objectelement ::= PTR method",
 /* 107 */ "function ::= ID OPENP params CLOSEP",
 /* 108 */ "method ::= ID OPENP params CLOSEP",
 /* 109 */ "params ::= expr COMMA params",
 /* 110 */ "params ::= expr",
 /* 111 */ "params ::=",
 /* 112 */ "modifier ::= VERT AT ID",
 /* 113 */ "modifier ::= VERT ID",
 /* 114 */ "modparameters ::= modparameters modparameter",
 /* 115 */ "modparameters ::=",
 /* 116 */ "modparameter ::= COLON exprs",
 /* 117 */ "modparameter ::= COLON ID",
 /* 118 */ "ifexprs ::= ifexpr",
 /* 119 */ "ifexprs ::= NOT ifexprs",
 /* 120 */ "ifexprs ::= OPENP ifexprs CLOSEP",
 /* 121 */ "ifexpr ::= expr",
 /* 122 */ "ifexpr ::= expr ifcond expr",
 /* 123 */ "ifexpr ::= expr ISIN array",
 /* 124 */ "ifexpr ::= expr ISIN value",
 /* 125 */ "ifexpr ::= ifexprs lop ifexprs",
 /* 126 */ "ifexpr ::= ifexprs ISDIVBY ifexprs",
 /* 127 */ "ifexpr ::= ifexprs ISNOTDIVBY ifexprs",
 /* 128 */ "ifexpr ::= ifexprs ISEVEN",
 /* 129 */ "ifexpr ::= ifexprs ISNOTEVEN",
 /* 130 */ "ifexpr ::= ifexprs ISEVENBY ifexprs",
 /* 131 */ "ifexpr ::= ifexprs ISNOTEVENBY ifexprs",
 /* 132 */ "ifexpr ::= ifexprs ISODD",
 /* 133 */ "ifexpr ::= ifexprs ISNOTODD",
 /* 134 */ "ifexpr ::= ifexprs ISODDBY ifexprs",
 /* 135 */ "ifexpr ::= ifexprs ISNOTODDBY ifexprs",
 /* 136 */ "ifexpr ::= value INSTANCEOF ID",
 /* 137 */ "ifexpr ::= value INSTANCEOF value",
 /* 138 */ "ifcond ::= EQUALS",
 /* 139 */ "ifcond ::= NOTEQUALS",
 /* 140 */ "ifcond ::= GREATERTHAN",
 /* 141 */ "ifcond ::= LESSTHAN",
 /* 142 */ "ifcond ::= GREATEREQUAL",
 /* 143 */ "ifcond ::= LESSEQUAL",
 /* 144 */ "ifcond ::= IDENTITY",
 /* 145 */ "ifcond ::= NONEIDENTITY",
 /* 146 */ "ifcond ::= MOD",
 /* 147 */ "lop ::= LAND",
 /* 148 */ "lop ::= LOR",
 /* 149 */ "lop ::= LXOR",
 /* 150 */ "array ::= OPENB arrayelements CLOSEB",
 /* 151 */ "arrayelements ::= arrayelement",
 /* 152 */ "arrayelements ::= arrayelements COMMA arrayelement",
 /* 153 */ "arrayelements ::=",
 /* 154 */ "arrayelement ::= expr APTR expr",
 /* 155 */ "arrayelement ::= ID APTR expr",
 /* 156 */ "arrayelement ::= expr",
 /* 157 */ "doublequoted ::= doublequoted doublequotedcontent",
 /* 158 */ "doublequoted ::= doublequotedcontent",
 /* 159 */ "doublequotedcontent ::= BACKTICK variable BACKTICK",
 /* 160 */ "doublequotedcontent ::= DOLLARID",
 /* 161 */ "doublequotedcontent ::= LDEL variable RDEL",
 /* 162 */ "doublequotedcontent ::= LDEL expr RDEL",
 /* 163 */ "doublequotedcontent ::= smartytag",
 /* 164 */ "doublequotedcontent ::= OTHER",
 /* 165 */ "optspace ::= SPACE",
 /* 166 */ "optspace ::=",
    );

    /**
     * This function returns the symbolic name associated with a token
     * value.
     * @param int
     * @return string
     */
    function tokenName($tokenType)
    {
        if ($tokenType === 0) {
            return 'End of Input';
        }
        if ($tokenType > 0 && $tokenType < count($this->yyTokenName)) {
            return $this->yyTokenName[$tokenType];
        } else {
            return "Unknown";
        }
    }

    /**
     * The following function deletes the value associated with a
     * symbol.  The symbol can be either a terminal or nonterminal.
     * @param int the symbol code
     * @param mixed the symbol's value
     */
    static function yy_destructor($yymajor, $yypminor)
    {
        switch ($yymajor) {
        /* Here is inserted the actions which take place when a
        ** terminal or non-terminal is destroyed.  This can happen
        ** when the symbol is popped from the stack during a
        ** reduce or during error processing or when a parser is 
        ** being destroyed before it is finished parsing.
        **
        ** Note: during a reduce, the only symbols destroyed are those
        ** which appear on the RHS of the rule, but which are not used
        ** inside the C code.
        */
            default:  break;   /* If no destructor action specified: do nothing */
        }
    }

    /**
     * Pop the parser's stack once.
     *
     * If there is a destructor routine associated with the token which
     * is popped from the stack, then call it.
     *
     * Return the major token number for the symbol popped.
     * @param TP_yyParser
     * @return int
     */
    function yy_pop_parser_stack()
    {
        if (!count($this->yystack)) {
            return;
        }
        $yytos = array_pop($this->yystack);
        if (self::$yyTraceFILE && $this->yyidx >= 0) {
            fwrite(self::$yyTraceFILE,
                self::$yyTracePrompt . 'Popping ' . $this->yyTokenName[$yytos->major] .
                    "\n");
        }
        $yymajor = $yytos->major;
        self::yy_destructor($yymajor, $yytos->minor);
        $this->yyidx--;
        return $yymajor;
    }

    /**
     * Deallocate and destroy a parser.  Destructors are all called for
     * all stack elements before shutting the parser down.
     */
    function __destruct()
    {
        while ($this->yyidx >= 0) {
            $this->yy_pop_parser_stack();
        }
        if (is_resource(self::$yyTraceFILE)) {
            fclose(self::$yyTraceFILE);
        }
    }

    /**
     * Based on the current state and parser stack, get a list of all
     * possible lookahead tokens
     * @param int
     * @return array
     */
    function yy_get_expected_tokens($token)
    {
        $state = $this->yystack[$this->yyidx]->stateno;
        $expected = self::$yyExpectedTokens[$state];
        if (in_array($token, self::$yyExpectedTokens[$state], true)) {
            return $expected;
        }
        $stack = $this->yystack;
        $yyidx = $this->yyidx;
        do {
            $yyact = $this->yy_find_shift_action($token);
            if ($yyact >= self::YYNSTATE && $yyact < self::YYNSTATE + self::YYNRULE) {
                // reduce action
                $done = 0;
                do {
                    if ($done++ == 100) {
                        $this->yyidx = $yyidx;
                        $this->yystack = $stack;
                        // too much recursion prevents proper detection
                        // so give up
                        return array_unique($expected);
                    }
                    $yyruleno = $yyact - self::YYNSTATE;
                    $this->yyidx -= self::$yyRuleInfo[$yyruleno]['rhs'];
                    $nextstate = $this->yy_find_reduce_action(
                        $this->yystack[$this->yyidx]->stateno,
                        self::$yyRuleInfo[$yyruleno]['lhs']);
                    if (isset(self::$yyExpectedTokens[$nextstate])) {
                        $expected += self::$yyExpectedTokens[$nextstate];
                            if (in_array($token,
                                  self::$yyExpectedTokens[$nextstate], true)) {
                            $this->yyidx = $yyidx;
                            $this->yystack = $stack;
                            return array_unique($expected);
                        }
                    }
                    if ($nextstate < self::YYNSTATE) {
                        // we need to shift a non-terminal
                        $this->yyidx++;
                        $x = new TP_yyStackEntry;
                        $x->stateno = $nextstate;
                        $x->major = self::$yyRuleInfo[$yyruleno]['lhs'];
                        $this->yystack[$this->yyidx] = $x;
                        continue 2;
                    } elseif ($nextstate == self::YYNSTATE + self::YYNRULE + 1) {
                        $this->yyidx = $yyidx;
                        $this->yystack = $stack;
                        // the last token was just ignored, we can't accept
                        // by ignoring input, this is in essence ignoring a
                        // syntax error!
                        return array_unique($expected);
                    } elseif ($nextstate === self::YY_NO_ACTION) {
                        $this->yyidx = $yyidx;
                        $this->yystack = $stack;
                        // input accepted, but not shifted (I guess)
                        return $expected;
                    } else {
                        $yyact = $nextstate;
                    }
                } while (true);
            }
            break;
        } while (true);
        return array_unique($expected);
    }

    /**
     * Based on the parser state and current parser stack, determine whether
     * the lookahead token is possible.
     * 
     * The parser will convert the token value to an error token if not.  This
     * catches some unusual edge cases where the parser would fail.
     * @param int
     * @return bool
     */
    function yy_is_expected_token($token)
    {
        if ($token === 0) {
            return true; // 0 is not part of this
        }
        $state = $this->yystack[$this->yyidx]->stateno;
        if (in_array($token, self::$yyExpectedTokens[$state], true)) {
            return true;
        }
        $stack = $this->yystack;
        $yyidx = $this->yyidx;
        do {
            $yyact = $this->yy_find_shift_action($token);
            if ($yyact >= self::YYNSTATE && $yyact < self::YYNSTATE + self::YYNRULE) {
                // reduce action
                $done = 0;
                do {
                    if ($done++ == 100) {
                        $this->yyidx = $yyidx;
                        $this->yystack = $stack;
                        // too much recursion prevents proper detection
                        // so give up
                        return true;
                    }
                    $yyruleno = $yyact - self::YYNSTATE;
                    $this->yyidx -= self::$yyRuleInfo[$yyruleno]['rhs'];
                    $nextstate = $this->yy_find_reduce_action(
                        $this->yystack[$this->yyidx]->stateno,
                        self::$yyRuleInfo[$yyruleno]['lhs']);
                    if (isset(self::$yyExpectedTokens[$nextstate]) &&
                          in_array($token, self::$yyExpectedTokens[$nextstate], true)) {
                        $this->yyidx = $yyidx;
                        $this->yystack = $stack;
                        return true;
                    }
                    if ($nextstate < self::YYNSTATE) {
                        // we need to shift a non-terminal
                        $this->yyidx++;
                        $x = new TP_yyStackEntry;
                        $x->stateno = $nextstate;
                        $x->major = self::$yyRuleInfo[$yyruleno]['lhs'];
                        $this->yystack[$this->yyidx] = $x;
                        continue 2;
                    } elseif ($nextstate == self::YYNSTATE + self::YYNRULE + 1) {
                        $this->yyidx = $yyidx;
                        $this->yystack = $stack;
                        if (!$token) {
                            // end of input: this is valid
                            return true;
                        }
                        // the last token was just ignored, we can't accept
                        // by ignoring input, this is in essence ignoring a
                        // syntax error!
                        return false;
                    } elseif ($nextstate === self::YY_NO_ACTION) {
                        $this->yyidx = $yyidx;
                        $this->yystack = $stack;
                        // input accepted, but not shifted (I guess)
                        return true;
                    } else {
                        $yyact = $nextstate;
                    }
                } while (true);
            }
            break;
        } while (true);
        $this->yyidx = $yyidx;
        $this->yystack = $stack;
        return true;
    }

    /**
     * Find the appropriate action for a parser given the terminal
     * look-ahead token iLookAhead.
     *
     * If the look-ahead token is YYNOCODE, then check to see if the action is
     * independent of the look-ahead.  If it is, return the action, otherwise
     * return YY_NO_ACTION.
     * @param int The look-ahead token
     */
    function yy_find_shift_action($iLookAhead)
    {
        $stateno = $this->yystack[$this->yyidx]->stateno;
     
        /* if ($this->yyidx < 0) return self::YY_NO_ACTION;  */
        if (!isset(self::$yy_shift_ofst[$stateno])) {
            // no shift actions
            return self::$yy_default[$stateno];
        }
        $i = self::$yy_shift_ofst[$stateno];
        if ($i === self::YY_SHIFT_USE_DFLT) {
            return self::$yy_default[$stateno];
        }
        if ($iLookAhead == self::YYNOCODE) {
            return self::YY_NO_ACTION;
        }
        $i += $iLookAhead;
        if ($i < 0 || $i >= self::YY_SZ_ACTTAB ||
              self::$yy_lookahead[$i] != $iLookAhead) {
            if (count(self::$yyFallback) && $iLookAhead < count(self::$yyFallback)
                   && ($iFallback = self::$yyFallback[$iLookAhead]) != 0) {
                if (self::$yyTraceFILE) {
                    fwrite(self::$yyTraceFILE, self::$yyTracePrompt . "FALLBACK " .
                        $this->yyTokenName[$iLookAhead] . " => " .
                        $this->yyTokenName[$iFallback] . "\n");
                }
                return $this->yy_find_shift_action($iFallback);
            }
            return self::$yy_default[$stateno];
        } else {
            return self::$yy_action[$i];
        }
    }

    /**
     * Find the appropriate action for a parser given the non-terminal
     * look-ahead token $iLookAhead.
     *
     * If the look-ahead token is self::YYNOCODE, then check to see if the action is
     * independent of the look-ahead.  If it is, return the action, otherwise
     * return self::YY_NO_ACTION.
     * @param int Current state number
     * @param int The look-ahead token
     */
    function yy_find_reduce_action($stateno, $iLookAhead)
    {
        /* $stateno = $this->yystack[$this->yyidx]->stateno; */

        if (!isset(self::$yy_reduce_ofst[$stateno])) {
            return self::$yy_default[$stateno];
        }
        $i = self::$yy_reduce_ofst[$stateno];
        if ($i == self::YY_REDUCE_USE_DFLT) {
            return self::$yy_default[$stateno];
        }
        if ($iLookAhead == self::YYNOCODE) {
            return self::YY_NO_ACTION;
        }
        $i += $iLookAhead;
        if ($i < 0 || $i >= self::YY_SZ_ACTTAB ||
              self::$yy_lookahead[$i] != $iLookAhead) {
            return self::$yy_default[$stateno];
        } else {
            return self::$yy_action[$i];
        }
    }

    /**
     * Perform a shift action.
     * @param int The new state to shift in
     * @param int The major token to shift in
     * @param mixed the minor token to shift in
     */
    function yy_shift($yyNewState, $yyMajor, $yypMinor)
    {
        $this->yyidx++;
        if ($this->yyidx >= self::YYSTACKDEPTH) {
            $this->yyidx--;
            if (self::$yyTraceFILE) {
                fprintf(self::$yyTraceFILE, "%sStack Overflow!\n", self::$yyTracePrompt);
            }
            while ($this->yyidx >= 0) {
                $this->yy_pop_parser_stack();
            }
            /* Here code is inserted which will execute if the parser
            ** stack ever overflows */
            return;
        }
        $yytos = new TP_yyStackEntry;
        $yytos->stateno = $yyNewState;
        $yytos->major = $yyMajor;
        $yytos->minor = $yypMinor;
        array_push($this->yystack, $yytos);
        if (self::$yyTraceFILE && $this->yyidx > 0) {
            fprintf(self::$yyTraceFILE, "%sShift %d\n", self::$yyTracePrompt,
                $yyNewState);
            fprintf(self::$yyTraceFILE, "%sStack:", self::$yyTracePrompt);
            for($i = 1; $i <= $this->yyidx; $i++) {
                fprintf(self::$yyTraceFILE, " %s",
                    $this->yyTokenName[$this->yystack[$i]->major]);
            }
            fwrite(self::$yyTraceFILE,"\n");
        }
    }

    /**
     * The following table contains information about every rule that
     * is used during the reduce.
     *
     * <pre>
     * array(
     *  array(
     *   int $lhs;         Symbol on the left-hand side of the rule
     *   int $nrhs;     Number of right-hand side symbols in the rule
     *  ),...
     * );
     * </pre>
     */
    static public $yyRuleInfo = array(
  array( 'lhs' => 68, 'rhs' => 1 ),
  array( 'lhs' => 69, 'rhs' => 1 ),
  array( 'lhs' => 69, 'rhs' => 2 ),
  array( 'lhs' => 70, 'rhs' => 1 ),
  array( 'lhs' => 70, 'rhs' => 1 ),
  array( 'lhs' => 70, 'rhs' => 3 ),
  array( 'lhs' => 70, 'rhs' => 3 ),
  array( 'lhs' => 70, 'rhs' => 1 ),
  array( 'lhs' => 70, 'rhs' => 1 ),
  array( 'lhs' => 70, 'rhs' => 1 ),
  array( 'lhs' => 71, 'rhs' => 4 ),
  array( 'lhs' => 71, 'rhs' => 4 ),
  array( 'lhs' => 71, 'rhs' => 4 ),
  array( 'lhs' => 71, 'rhs' => 6 ),
  array( 'lhs' => 71, 'rhs' => 6 ),
  array( 'lhs' => 71, 'rhs' => 4 ),
  array( 'lhs' => 71, 'rhs' => 3 ),
  array( 'lhs' => 71, 'rhs' => 6 ),
  array( 'lhs' => 71, 'rhs' => 6 ),
  array( 'lhs' => 71, 'rhs' => 8 ),
  array( 'lhs' => 71, 'rhs' => 5 ),
  array( 'lhs' => 71, 'rhs' => 5 ),
  array( 'lhs' => 71, 'rhs' => 13 ),
  array( 'lhs' => 84, 'rhs' => 2 ),
  array( 'lhs' => 84, 'rhs' => 1 ),
  array( 'lhs' => 71, 'rhs' => 8 ),
  array( 'lhs' => 71, 'rhs' => 11 ),
  array( 'lhs' => 71, 'rhs' => 8 ),
  array( 'lhs' => 71, 'rhs' => 11 ),
  array( 'lhs' => 71, 'rhs' => 4 ),
  array( 'lhs' => 71, 'rhs' => 6 ),
  array( 'lhs' => 71, 'rhs' => 5 ),
  array( 'lhs' => 73, 'rhs' => 2 ),
  array( 'lhs' => 73, 'rhs' => 1 ),
  array( 'lhs' => 73, 'rhs' => 0 ),
  array( 'lhs' => 87, 'rhs' => 4 ),
  array( 'lhs' => 87, 'rhs' => 4 ),
  array( 'lhs' => 87, 'rhs' => 4 ),
  array( 'lhs' => 87, 'rhs' => 2 ),
  array( 'lhs' => 87, 'rhs' => 4 ),
  array( 'lhs' => 81, 'rhs' => 1 ),
  array( 'lhs' => 81, 'rhs' => 3 ),
  array( 'lhs' => 80, 'rhs' => 4 ),
  array( 'lhs' => 74, 'rhs' => 1 ),
  array( 'lhs' => 74, 'rhs' => 1 ),
  array( 'lhs' => 74, 'rhs' => 4 ),
  array( 'lhs' => 74, 'rhs' => 3 ),
  array( 'lhs' => 88, 'rhs' => 1 ),
  array( 'lhs' => 88, 'rhs' => 2 ),
  array( 'lhs' => 88, 'rhs' => 3 ),
  array( 'lhs' => 88, 'rhs' => 1 ),
  array( 'lhs' => 75, 'rhs' => 7 ),
  array( 'lhs' => 75, 'rhs' => 7 ),
  array( 'lhs' => 89, 'rhs' => 1 ),
  array( 'lhs' => 89, 'rhs' => 1 ),
  array( 'lhs' => 89, 'rhs' => 1 ),
  array( 'lhs' => 85, 'rhs' => 1 ),
  array( 'lhs' => 85, 'rhs' => 2 ),
  array( 'lhs' => 85, 'rhs' => 2 ),
  array( 'lhs' => 85, 'rhs' => 1 ),
  array( 'lhs' => 85, 'rhs' => 3 ),
  array( 'lhs' => 85, 'rhs' => 1 ),
  array( 'lhs' => 85, 'rhs' => 1 ),
  array( 'lhs' => 85, 'rhs' => 1 ),
  array( 'lhs' => 85, 'rhs' => 3 ),
  array( 'lhs' => 85, 'rhs' => 1 ),
  array( 'lhs' => 85, 'rhs' => 3 ),
  array( 'lhs' => 85, 'rhs' => 2 ),
  array( 'lhs' => 85, 'rhs' => 3 ),
  array( 'lhs' => 85, 'rhs' => 7 ),
  array( 'lhs' => 85, 'rhs' => 4 ),
  array( 'lhs' => 85, 'rhs' => 8 ),
  array( 'lhs' => 85, 'rhs' => 3 ),
  array( 'lhs' => 85, 'rhs' => 5 ),
  array( 'lhs' => 85, 'rhs' => 6 ),
  array( 'lhs' => 85, 'rhs' => 1 ),
  array( 'lhs' => 72, 'rhs' => 1 ),
  array( 'lhs' => 72, 'rhs' => 4 ),
  array( 'lhs' => 72, 'rhs' => 1 ),
  array( 'lhs' => 72, 'rhs' => 3 ),
  array( 'lhs' => 72, 'rhs' => 3 ),
  array( 'lhs' => 76, 'rhs' => 3 ),
  array( 'lhs' => 95, 'rhs' => 2 ),
  array( 'lhs' => 95, 'rhs' => 0 ),
  array( 'lhs' => 97, 'rhs' => 2 ),
  array( 'lhs' => 97, 'rhs' => 2 ),
  array( 'lhs' => 97, 'rhs' => 2 ),
  array( 'lhs' => 97, 'rhs' => 2 ),
  array( 'lhs' => 97, 'rhs' => 3 ),
  array( 'lhs' => 97, 'rhs' => 2 ),
  array( 'lhs' => 97, 'rhs' => 4 ),
  array( 'lhs' => 97, 'rhs' => 3 ),
  array( 'lhs' => 97, 'rhs' => 5 ),
  array( 'lhs' => 97, 'rhs' => 3 ),
  array( 'lhs' => 97, 'rhs' => 2 ),
  array( 'lhs' => 83, 'rhs' => 1 ),
  array( 'lhs' => 83, 'rhs' => 2 ),
  array( 'lhs' => 98, 'rhs' => 1 ),
  array( 'lhs' => 98, 'rhs' => 3 ),
  array( 'lhs' => 96, 'rhs' => 2 ),
  array( 'lhs' => 94, 'rhs' => 1 ),
  array( 'lhs' => 94, 'rhs' => 2 ),
  array( 'lhs' => 99, 'rhs' => 3 ),
  array( 'lhs' => 99, 'rhs' => 3 ),
  array( 'lhs' => 99, 'rhs' => 5 ),
  array( 'lhs' => 99, 'rhs' => 6 ),
  array( 'lhs' => 99, 'rhs' => 2 ),
  array( 'lhs' => 90, 'rhs' => 4 ),
  array( 'lhs' => 92, 'rhs' => 4 ),
  array( 'lhs' => 93, 'rhs' => 3 ),
  array( 'lhs' => 93, 'rhs' => 1 ),
  array( 'lhs' => 93, 'rhs' => 0 ),
  array( 'lhs' => 77, 'rhs' => 3 ),
  array( 'lhs' => 77, 'rhs' => 2 ),
  array( 'lhs' => 78, 'rhs' => 2 ),
  array( 'lhs' => 78, 'rhs' => 0 ),
  array( 'lhs' => 100, 'rhs' => 2 ),
  array( 'lhs' => 100, 'rhs' => 2 ),
  array( 'lhs' => 79, 'rhs' => 1 ),
  array( 'lhs' => 79, 'rhs' => 2 ),
  array( 'lhs' => 79, 'rhs' => 3 ),
  array( 'lhs' => 101, 'rhs' => 1 ),
  array( 'lhs' => 101, 'rhs' => 3 ),
  array( 'lhs' => 101, 'rhs' => 3 ),
  array( 'lhs' => 101, 'rhs' => 3 ),
  array( 'lhs' => 101, 'rhs' => 3 ),
  array( 'lhs' => 101, 'rhs' => 3 ),
  array( 'lhs' => 101, 'rhs' => 3 ),
  array( 'lhs' => 101, 'rhs' => 2 ),
  array( 'lhs' => 101, 'rhs' => 2 ),
  array( 'lhs' => 101, 'rhs' => 3 ),
  array( 'lhs' => 101, 'rhs' => 3 ),
  array( 'lhs' => 101, 'rhs' => 2 ),
  array( 'lhs' => 101, 'rhs' => 2 ),
  array( 'lhs' => 101, 'rhs' => 3 ),
  array( 'lhs' => 101, 'rhs' => 3 ),
  array( 'lhs' => 101, 'rhs' => 3 ),
  array( 'lhs' => 101, 'rhs' => 3 ),
  array( 'lhs' => 102, 'rhs' => 1 ),
  array( 'lhs' => 102, 'rhs' => 1 ),
  array( 'lhs' => 102, 'rhs' => 1 ),
  array( 'lhs' => 102, 'rhs' => 1 ),
  array( 'lhs' => 102, 'rhs' => 1 ),
  array( 'lhs' => 102, 'rhs' => 1 ),
  array( 'lhs' => 102, 'rhs' => 1 ),
  array( 'lhs' => 102, 'rhs' => 1 ),
  array( 'lhs' => 102, 'rhs' => 1 ),
  array( 'lhs' => 103, 'rhs' => 1 ),
  array( 'lhs' => 103, 'rhs' => 1 ),
  array( 'lhs' => 103, 'rhs' => 1 ),
  array( 'lhs' => 86, 'rhs' => 3 ),
  array( 'lhs' => 104, 'rhs' => 1 ),
  array( 'lhs' => 104, 'rhs' => 3 ),
  array( 'lhs' => 104, 'rhs' => 0 ),
  array( 'lhs' => 105, 'rhs' => 3 ),
  array( 'lhs' => 105, 'rhs' => 3 ),
  array( 'lhs' => 105, 'rhs' => 1 ),
  array( 'lhs' => 91, 'rhs' => 2 ),
  array( 'lhs' => 91, 'rhs' => 1 ),
  array( 'lhs' => 106, 'rhs' => 3 ),
  array( 'lhs' => 106, 'rhs' => 1 ),
  array( 'lhs' => 106, 'rhs' => 3 ),
  array( 'lhs' => 106, 'rhs' => 3 ),
  array( 'lhs' => 106, 'rhs' => 1 ),
  array( 'lhs' => 106, 'rhs' => 1 ),
  array( 'lhs' => 82, 'rhs' => 1 ),
  array( 'lhs' => 82, 'rhs' => 0 ),
    );

    /**
     * The following table contains a mapping of reduce action to method name
     * that handles the reduction.
     * 
     * If a rule is not set, it has no handler.
     */
    static public $yyReduceMap = array(
        0 => 0,
        47 => 0,
        56 => 0,
        59 => 0,
        61 => 0,
        62 => 0,
        63 => 0,
        65 => 0,
        78 => 0,
        151 => 0,
        1 => 1,
        44 => 1,
        50 => 1,
        53 => 1,
        54 => 1,
        95 => 1,
        118 => 1,
        158 => 1,
        164 => 1,
        165 => 1,
        2 => 2,
        114 => 2,
        3 => 3,
        4 => 4,
        5 => 5,
        6 => 6,
        7 => 7,
        8 => 8,
        9 => 9,
        10 => 10,
        11 => 10,
        12 => 10,
        13 => 13,
        14 => 13,
        15 => 15,
        16 => 16,
        17 => 17,
        18 => 18,
        19 => 19,
        20 => 20,
        21 => 21,
        22 => 22,
        23 => 23,
        24 => 24,
        33 => 24,
        110 => 24,
        156 => 24,
        25 => 25,
        26 => 26,
        27 => 27,
        28 => 28,
        29 => 29,
        30 => 30,
        31 => 31,
        32 => 32,
        34 => 34,
        35 => 35,
        36 => 35,
        37 => 35,
        39 => 35,
        38 => 38,
        40 => 40,
        41 => 41,
        42 => 42,
        43 => 43,
        45 => 45,
        46 => 46,
        48 => 48,
        57 => 48,
        58 => 48,
        49 => 49,
        51 => 51,
        52 => 51,
        55 => 55,
        60 => 60,
        64 => 64,
        66 => 66,
        67 => 67,
        68 => 68,
        69 => 69,
        70 => 70,
        71 => 71,
        72 => 72,
        73 => 73,
        74 => 74,
        75 => 75,
        76 => 76,
        77 => 77,
        79 => 79,
        80 => 80,
        81 => 81,
        82 => 82,
        157 => 82,
        83 => 83,
        115 => 83,
        84 => 84,
        85 => 84,
        86 => 84,
        87 => 87,
        88 => 88,
        89 => 89,
        90 => 90,
        93 => 90,
        91 => 91,
        92 => 92,
        94 => 94,
        166 => 94,
        96 => 96,
        97 => 97,
        98 => 98,
        120 => 98,
        99 => 99,
        100 => 100,
        101 => 101,
        102 => 102,
        103 => 103,
        104 => 104,
        105 => 105,
        106 => 106,
        107 => 107,
        108 => 108,
        109 => 109,
        111 => 111,
        112 => 112,
        113 => 113,
        116 => 116,
        117 => 117,
        119 => 119,
        121 => 121,
        122 => 122,
        125 => 122,
        136 => 122,
        123 => 123,
        124 => 124,
        126 => 126,
        127 => 127,
        128 => 128,
        133 => 128,
        129 => 129,
        132 => 129,
        130 => 130,
        135 => 130,
        131 => 131,
        134 => 131,
        137 => 137,
        138 => 138,
        139 => 139,
        140 => 140,
        141 => 141,
        142 => 142,
        143 => 143,
        144 => 144,
        145 => 145,
        146 => 146,
        147 => 147,
        148 => 148,
        149 => 149,
        150 => 150,
        152 => 152,
        153 => 153,
        154 => 154,
        155 => 155,
        159 => 159,
        161 => 159,
        160 => 160,
        162 => 162,
        163 => 163,
    );
    /* Beginning here are the reduction cases.  A typical example
    ** follows:
    **  #line <lineno> <grammarfile>
    **   function yy_r0($yymsp){ ... }           // User supplied code
    **  #line <lineno> <thisfile>
    */
#line 79 "smarty_internal_templateparser.y"
    function yy_r0(){ $this->_retvalue = $this->yystack[$this->yyidx + 0]->minor;     }
#line 1997 "smarty_internal_templateparser.php"
#line 85 "smarty_internal_templateparser.y"
    function yy_r1(){$this->_retvalue = $this->yystack[$this->yyidx + 0]->minor;    }
#line 2000 "smarty_internal_templateparser.php"
#line 87 "smarty_internal_templateparser.y"
    function yy_r2(){ $this->_retvalue = $this->yystack[$this->yyidx + -1]->minor.$this->yystack[$this->yyidx + 0]->minor;    }
#line 2003 "smarty_internal_templateparser.php"
#line 93 "smarty_internal_templateparser.y"
    function yy_r3(){
                                          if ($this->compiler->has_code) {
                                            $tmp =''; foreach ($this->compiler->prefix_code as $code) {$tmp.=$code;} $this->compiler->prefix_code=array();
                                            $this->_retvalue = $this->cacher->processNocacheCode($tmp.$this->yystack[$this->yyidx + 0]->minor, $this->compiler,true);
                                         } else { $this->_retvalue = $this->yystack[$this->yyidx + 0]->minor;}  $this->compiler->has_variable_string = false;    }
#line 2010 "smarty_internal_templateparser.php"
#line 100 "smarty_internal_templateparser.y"
    function yy_r4(){ $this->_retvalue = '';    }
#line 2013 "smarty_internal_templateparser.php"
#line 105 "smarty_internal_templateparser.y"
    function yy_r5(){if ($this->sec_obj->php_handling == SMARTY_PHP_PASSTHRU) {
                                       $this->_retvalue = $this->cacher->processNocacheCode("<?php echo htmlspecialchars('<?php".str_replace("'","\'",$this->yystack[$this->yyidx + -1]->minor)."?>', ENT_QUOTES);?>\n", $this->compiler, false);
                                      } elseif ($this->sec_obj->php_handling == SMARTY_PHP_QUOTE) {
                                       $this->_retvalue = $this->cacher->processNocacheCode(htmlspecialchars('<?php'.$this->yystack[$this->yyidx + -1]->minor.'?>', ENT_QUOTES), $this->compiler, false);
                                      }elseif ($this->sec_obj->php_handling == SMARTY_PHP_ALLOW) {
                                       $this->_retvalue = $this->cacher->processNocacheCode('<?php'.$this->yystack[$this->yyidx + -1]->minor.'?>', $this->compiler, true);
                                      }elseif ($this->sec_obj->php_handling == SMARTY_PHP_REMOVE) {
                                       $this->_retvalue = '';
                                      }
                                         }
#line 2025 "smarty_internal_templateparser.php"
#line 116 "smarty_internal_templateparser.y"
    function yy_r6(){ 
                                      if ($this->sec_obj->php_handling == SMARTY_PHP_PASSTHRU || $this->sec_obj->php_handling == SMARTY_PHP_ALLOW) {
                                       $this->_retvalue = $this->cacher->processNocacheCode("<?php echo '<?=".$this->yystack[$this->yyidx + -1]->minor."?>'?>\n", $this->compiler, false);
                                      } elseif ($this->sec_obj->php_handling == SMARTY_PHP_QUOTE) {
                                       $this->_retvalue = $this->cacher->processNocacheCode(htmlspecialchars('<?='.$this->yystack[$this->yyidx + -1]->minor.'?>', ENT_QUOTES), $this->compiler, false);
                                      }elseif ($this->sec_obj == SMARTY_PHP_REMOVE) {
                                       $this->_retvalue = '';
                                      }
                                         }
#line 2036 "smarty_internal_templateparser.php"
#line 127 "smarty_internal_templateparser.y"
    function yy_r7(){ $this->compiler->tag_nocache = true; $this->_retvalue = $this->cacher->processNocacheCode("<?php echo '<?xml';?>", $this->compiler, true);    }
#line 2039 "smarty_internal_templateparser.php"
#line 128 "smarty_internal_templateparser.y"
    function yy_r8(){$this->compiler->tag_nocache = true; $this->_retvalue = $this->cacher->processNocacheCode("<?php echo '?>';?>\n", $this->compiler, true);    }
#line 2042 "smarty_internal_templateparser.php"
#line 130 "smarty_internal_templateparser.y"
    function yy_r9(){$this->_retvalue = $this->cacher->processNocacheCode($this->yystack[$this->yyidx + 0]->minor, $this->compiler,false);    }
#line 2045 "smarty_internal_templateparser.php"
#line 137 "smarty_internal_templateparser.y"
    function yy_r10(){ $this->_retvalue = $this->compiler->compileTag('print_expression',array_merge(array('value'=>$this->yystack[$this->yyidx + -2]->minor),$this->yystack[$this->yyidx + -1]->minor));    }
#line 2048 "smarty_internal_templateparser.php"
#line 147 "smarty_internal_templateparser.y"
    function yy_r13(){ $this->_retvalue = $this->compiler->compileTag('assign',array_merge(array('value'=>$this->yystack[$this->yyidx + -2]->minor),$this->yystack[$this->yyidx + -4]->minor,$this->yystack[$this->yyidx + -1]->minor));    }
#line 2051 "smarty_internal_templateparser.php"
#line 150 "smarty_internal_templateparser.y"
    function yy_r15(){ $this->_retvalue = $this->compiler->compileTag($this->yystack[$this->yyidx + -2]->minor,$this->yystack[$this->yyidx + -1]->minor);    }
#line 2054 "smarty_internal_templateparser.php"
#line 151 "smarty_internal_templateparser.y"
    function yy_r16(){ $this->_retvalue = $this->compiler->compileTag($this->yystack[$this->yyidx + -1]->minor,array());    }
#line 2057 "smarty_internal_templateparser.php"
#line 153 "smarty_internal_templateparser.y"
    function yy_r17(){ $this->_retvalue = $this->compiler->compileTag($this->yystack[$this->yyidx + -4]->minor,array_merge(array('object_methode'=>$this->yystack[$this->yyidx + -2]->minor),$this->yystack[$this->yyidx + -1]->minor));    }
#line 2060 "smarty_internal_templateparser.php"
#line 155 "smarty_internal_templateparser.y"
    function yy_r18(){  $this->_retvalue = '<?php ob_start();?>'.$this->compiler->compileTag($this->yystack[$this->yyidx + -4]->minor,$this->yystack[$this->yyidx + -1]->minor).'<?php echo ';
															                                   if ($this->smarty->plugin_handler->loadSmartyPlugin($this->yystack[$this->yyidx + -3]->minor[0],'modifier')) {
                                                                      $this->_retvalue .= "\$_smarty_tpl->smarty->plugin_handler->executeModifier('".$this->yystack[$this->yyidx + -3]->minor[0] . "',array(ob_get_clean()" . $this->yystack[$this->yyidx + -2]->minor. "),".$this->yystack[$this->yyidx + -3]->minor[1].");?>";
                                                                 } else {
                                                                   if (is_callable($this->yystack[$this->yyidx + -3]->minor[0])) {
																					                            if (!$this->template->security || $this->smarty->security_handler->isTrustedModifier($this->yystack[$this->yyidx + -3]->minor[0], $this->compiler)) {
                                                                         $this->_retvalue .= "\$_smarty_tpl->smarty->plugin_handler->executeModifier('".$this->yystack[$this->yyidx + -3]->minor[0] . "',array(ob_get_clean()" . $this->yystack[$this->yyidx + -2]->minor. "),".$this->yystack[$this->yyidx + -3]->minor[1].");?>";
																					                            }
																					                         } else {
                                                                      $this->compiler->trigger_template_error ("unknown modifier \"" . $this->yystack[$this->yyidx + -3]->minor[0] . "\"");
                                                                 }
                                                              }
                                                                        }
#line 2075 "smarty_internal_templateparser.php"
#line 169 "smarty_internal_templateparser.y"
    function yy_r19(){  $this->_retvalue = '<?php ob_start();?>'.$this->compiler->compileTag($this->yystack[$this->yyidx + -6]->minor,array_merge(array('object_methode'=>$this->yystack[$this->yyidx + -4]->minor),$this->yystack[$this->yyidx + -1]->minor)).'<?php echo ';
															                                   if ($this->smarty->plugin_handler->loadSmartyPlugin($this->yystack[$this->yyidx + -3]->minor[0],'modifier')) {
                                                                      $this->_retvalue .= "\$_smarty_tpl->smarty->plugin_handler->executeModifier('".$this->yystack[$this->yyidx + -3]->minor[0] . "',array(ob_get_clean()" . $this->yystack[$this->yyidx + -2]->minor. "),".$this->yystack[$this->yyidx + -3]->minor[1].");?>";
                                                                 } else {
                                                                   if (is_callable($this->yystack[$this->yyidx + -3]->minor[0])) {
																					                            if (!$this->template->security || $this->smarty->security_handler->isTrustedModifier($this->yystack[$this->yyidx + -3]->minor[0], $this->compiler)) {
                                                                         $this->_retvalue .= "\$_smarty_tpl->smarty->plugin_handler->executeModifier('".$this->yystack[$this->yyidx + -3]->minor[0] . "',array(ob_get_clean()" . $this->yystack[$this->yyidx + -2]->minor. "),".$this->yystack[$this->yyidx + -3]->minor[1].");?>";
																					                            }
																					                         } else {
                                                                      $this->compiler->trigger_template_error ("unknown modifier \"" . $this->yystack[$this->yyidx + -3]->minor[0] . "\"");
                                                                 }
                                                              }
                                                                        }
#line 2090 "smarty_internal_templateparser.php"
#line 183 "smarty_internal_templateparser.y"
    function yy_r20(){if (!in_array($this->yystack[$this->yyidx + -3]->minor,array('if','elseif','while'))) {
                                                            $this->compiler->trigger_template_error ("wrong syntax for tag \"" . $this->yystack[$this->yyidx + -3]->minor . "\""); 
                                                            }
                                                            $this->_retvalue = $this->compiler->compileTag($this->yystack[$this->yyidx + -3]->minor,array('if condition'=>$this->yystack[$this->yyidx + -1]->minor));    }
#line 2096 "smarty_internal_templateparser.php"
#line 187 "smarty_internal_templateparser.y"
    function yy_r21(){ if (!in_array($this->yystack[$this->yyidx + -3]->minor,array('if','elseif','while'))) {
                                                            $this->compiler->trigger_template_error ("wrong syntax for tag \"" . $this->yystack[$this->yyidx + -3]->minor . "\""); 
                                                            }
                                                            $this->_retvalue = $this->compiler->compileTag($this->yystack[$this->yyidx + -3]->minor,array('if condition'=>$this->yystack[$this->yyidx + -1]->minor));    }
#line 2102 "smarty_internal_templateparser.php"
#line 192 "smarty_internal_templateparser.y"
    function yy_r22(){
                                                            if ($this->yystack[$this->yyidx + -11]->minor != 'for') {
                                                               $this->compiler->trigger_template_error ("wrong syntax for tag \"" . $this->yystack[$this->yyidx + -11]->minor . "\""); 
                                                            }
                                                             $this->_retvalue = $this->compiler->compileTag($this->yystack[$this->yyidx + -11]->minor,array('start'=>$this->yystack[$this->yyidx + -9]->minor,'ifexp'=>$this->yystack[$this->yyidx + -6]->minor,'varloop'=>$this->yystack[$this->yyidx + -2]->minor,'loop'=>$this->yystack[$this->yyidx + -1]->minor));    }
#line 2109 "smarty_internal_templateparser.php"
#line 197 "smarty_internal_templateparser.y"
    function yy_r23(){ $this->_retvalue = '='.$this->yystack[$this->yyidx + 0]->minor;    }
#line 2112 "smarty_internal_templateparser.php"
#line 198 "smarty_internal_templateparser.y"
    function yy_r24(){ $this->_retvalue = $this->yystack[$this->yyidx + 0]->minor;    }
#line 2115 "smarty_internal_templateparser.php"
#line 200 "smarty_internal_templateparser.y"
    function yy_r25(){
                                                            if ($this->yystack[$this->yyidx + -6]->minor != 'foreach') {
                                                               $this->compiler->trigger_template_error ("wrong syntax for tag \"" . $this->yystack[$this->yyidx + -6]->minor . "\""); 
                                                            }
                                                            $this->_retvalue = $this->compiler->compileTag($this->yystack[$this->yyidx + -6]->minor,array('from'=>$this->yystack[$this->yyidx + -4]->minor,'item'=>$this->yystack[$this->yyidx + -1]->minor));    }
#line 2122 "smarty_internal_templateparser.php"
#line 205 "smarty_internal_templateparser.y"
    function yy_r26(){
                                                            if ($this->yystack[$this->yyidx + -9]->minor != 'foreach') {
                                                               $this->compiler->trigger_template_error ("wrong syntax for tag \"" . $this->yystack[$this->yyidx + -9]->minor . "\""); 
                                                            }
                                                            $this->_retvalue = $this->compiler->compileTag($this->yystack[$this->yyidx + -9]->minor,array('from'=>$this->yystack[$this->yyidx + -7]->minor,'item'=>$this->yystack[$this->yyidx + -1]->minor,'key'=>$this->yystack[$this->yyidx + -4]->minor));    }
#line 2129 "smarty_internal_templateparser.php"
#line 210 "smarty_internal_templateparser.y"
    function yy_r27(){ 
                                                            if ($this->yystack[$this->yyidx + -6]->minor != 'foreach') {
                                                               $this->compiler->trigger_template_error ("wrong syntax for tag \"" . $this->yystack[$this->yyidx + -6]->minor . "\""); 
                                                            }
                                                            $this->_retvalue = $this->compiler->compileTag($this->yystack[$this->yyidx + -6]->minor,array('from'=>$this->yystack[$this->yyidx + -4]->minor,'item'=>$this->yystack[$this->yyidx + -1]->minor));    }
#line 2136 "smarty_internal_templateparser.php"
#line 215 "smarty_internal_templateparser.y"
    function yy_r28(){ 
                                                            if ($this->yystack[$this->yyidx + -9]->minor != 'foreach') {
                                                               $this->compiler->trigger_template_error ("wrong syntax for tag \"" . $this->yystack[$this->yyidx + -9]->minor . "\""); 
                                                            }
                                                            $this->_retvalue = $this->compiler->compileTag($this->yystack[$this->yyidx + -9]->minor,array('from'=>$this->yystack[$this->yyidx + -7]->minor,'item'=>$this->yystack[$this->yyidx + -1]->minor,'key'=>$this->yystack[$this->yyidx + -4]->minor));    }
#line 2143 "smarty_internal_templateparser.php"
#line 222 "smarty_internal_templateparser.y"
    function yy_r29(){ $this->_retvalue = $this->compiler->compileTag($this->yystack[$this->yyidx + -2]->minor.'close',$this->yystack[$this->yyidx + -1]->minor);    }
#line 2146 "smarty_internal_templateparser.php"
#line 223 "smarty_internal_templateparser.y"
    function yy_r30(){  $this->_retvalue = '<?php ob_start();?>'.$this->compiler->compileTag($this->yystack[$this->yyidx + -4]->minor.'close',$this->yystack[$this->yyidx + -1]->minor).'<?php echo ';
															                                   if ($this->smarty->plugin_handler->loadSmartyPlugin($this->yystack[$this->yyidx + -3]->minor[0],'modifier')) {
                                                                      $this->_retvalue .= "\$_smarty_tpl->smarty->plugin_handler->executeModifier('".$this->yystack[$this->yyidx + -3]->minor[0] . "',array(ob_get_clean()" . $this->yystack[$this->yyidx + -2]->minor. "),".$this->yystack[$this->yyidx + -3]->minor[1].");?>";
                                                                 } else {
                                                                   if (is_callable($this->yystack[$this->yyidx + -3]->minor[0])) {
																					                            if (!$this->template->security || $this->smarty->security_handler->isTrustedModifier($this->yystack[$this->yyidx + -3]->minor[0], $this->compiler)) {
                                                                         $this->_retvalue .= "\$_smarty_tpl->smarty->plugin_handler->executeModifier('".$this->yystack[$this->yyidx + -3]->minor[0] . "',array(ob_get_clean()" . $this->yystack[$this->yyidx + -2]->minor. "),".$this->yystack[$this->yyidx + -3]->minor[1].");?>";
																					                            }
																					                         } else {
                                                                      $this->compiler->trigger_template_error ("unknown modifier \"" . $this->yystack[$this->yyidx + -3]->minor[0] . "\"");
                                                                 }
                                                              }
                                                                        }
#line 2161 "smarty_internal_templateparser.php"
#line 237 "smarty_internal_templateparser.y"
    function yy_r31(){  $this->_retvalue = $this->compiler->compileTag($this->yystack[$this->yyidx + -3]->minor.'close',array('object_methode'=>$this->yystack[$this->yyidx + -1]->minor));    }
#line 2164 "smarty_internal_templateparser.php"
#line 244 "smarty_internal_templateparser.y"
    function yy_r32(){ $this->_retvalue = array_merge($this->yystack[$this->yyidx + -1]->minor,$this->yystack[$this->yyidx + 0]->minor);    }
#line 2167 "smarty_internal_templateparser.php"
#line 248 "smarty_internal_templateparser.y"
    function yy_r34(){ $this->_retvalue = array();    }
#line 2170 "smarty_internal_templateparser.php"
#line 251 "smarty_internal_templateparser.y"
    function yy_r35(){ $this->_retvalue = array($this->yystack[$this->yyidx + -2]->minor=>$this->yystack[$this->yyidx + 0]->minor);    }
#line 2173 "smarty_internal_templateparser.php"
#line 254 "smarty_internal_templateparser.y"
    function yy_r38(){ $this->_retvalue = array($this->yystack[$this->yyidx + 0]->minor=>'true');    }
#line 2176 "smarty_internal_templateparser.php"
#line 261 "smarty_internal_templateparser.y"
    function yy_r40(){ $this->_retvalue = array($this->yystack[$this->yyidx + 0]->minor);    }
#line 2179 "smarty_internal_templateparser.php"
#line 262 "smarty_internal_templateparser.y"
    function yy_r41(){ $this->yystack[$this->yyidx + -2]->minor[]=$this->yystack[$this->yyidx + 0]->minor; $this->_retvalue = $this->yystack[$this->yyidx + -2]->minor;    }
#line 2182 "smarty_internal_templateparser.php"
#line 264 "smarty_internal_templateparser.y"
    function yy_r42(){ $this->_retvalue = array('var' => $this->yystack[$this->yyidx + -2]->minor, 'value'=>$this->yystack[$this->yyidx + 0]->minor);    }
#line 2185 "smarty_internal_templateparser.php"
#line 270 "smarty_internal_templateparser.y"
    function yy_r43(){ $this->_retvalue = '\''.$this->yystack[$this->yyidx + 0]->minor.'\'';     }
#line 2188 "smarty_internal_templateparser.php"
#line 273 "smarty_internal_templateparser.y"
    function yy_r45(){$this->_retvalue = '$_smarty_tpl->getStreamVariable(\''. $this->yystack[$this->yyidx + -2]->minor .'://'. $this->yystack[$this->yyidx + 0]->minor . '\')';    }
#line 2191 "smarty_internal_templateparser.php"
#line 274 "smarty_internal_templateparser.y"
    function yy_r46(){            
                                                            if ($this->smarty->plugin_handler->loadSmartyPlugin($this->yystack[$this->yyidx + -1]->minor[0],'modifier')) {
                                                                      $this->_retvalue = "\$_smarty_tpl->smarty->plugin_handler->executeModifier('".$this->yystack[$this->yyidx + -1]->minor[0] . "',array(". $this->yystack[$this->yyidx + -2]->minor . $this->yystack[$this->yyidx + 0]->minor. "),".$this->yystack[$this->yyidx + -1]->minor[1].")";
                                                                 } else {
                                                                   if (is_callable($this->yystack[$this->yyidx + -1]->minor[0])) {
																					                            if (!$this->template->security || $this->smarty->security_handler->isTrustedModifier($this->yystack[$this->yyidx + -1]->minor[0], $this->compiler)) {
                                                                         $this->_retvalue = "\$_smarty_tpl->smarty->plugin_handler->executeModifier('".$this->yystack[$this->yyidx + -1]->minor[0] . "',array(". $this->yystack[$this->yyidx + -2]->minor . $this->yystack[$this->yyidx + 0]->minor. "),".$this->yystack[$this->yyidx + -1]->minor[1].")";
																					                            }
																					                         } else {
                                                                      $this->compiler->trigger_template_error ("unknown modifier \"" . $this->yystack[$this->yyidx + -1]->minor[0] . "\"");
                                                                 }
                                                              }
                                                                }
#line 2206 "smarty_internal_templateparser.php"
#line 291 "smarty_internal_templateparser.y"
    function yy_r48(){ $this->_retvalue = $this->yystack[$this->yyidx + -1]->minor.$this->yystack[$this->yyidx + 0]->minor;     }
#line 2209 "smarty_internal_templateparser.php"
#line 293 "smarty_internal_templateparser.y"
    function yy_r49(){ $this->_retvalue = $this->yystack[$this->yyidx + -2]->minor . $this->yystack[$this->yyidx + -1]->minor . $this->yystack[$this->yyidx + 0]->minor;     }
#line 2212 "smarty_internal_templateparser.php"
#line 300 "smarty_internal_templateparser.y"
    function yy_r51(){ $this->_retvalue = $this->yystack[$this->yyidx + -5]->minor.' ? '.$this->yystack[$this->yyidx + -2]->minor.' : '.$this->yystack[$this->yyidx + 0]->minor;    }
#line 2215 "smarty_internal_templateparser.php"
#line 314 "smarty_internal_templateparser.y"
    function yy_r55(){$this->_retvalue = ' & ';    }
#line 2218 "smarty_internal_templateparser.php"
#line 322 "smarty_internal_templateparser.y"
    function yy_r60(){ $this->_retvalue = $this->yystack[$this->yyidx + -2]->minor.'.'.$this->yystack[$this->yyidx + 0]->minor;     }
#line 2221 "smarty_internal_templateparser.php"
#line 330 "smarty_internal_templateparser.y"
    function yy_r64(){ $this->_retvalue = "(". $this->yystack[$this->yyidx + -1]->minor .")";     }
#line 2224 "smarty_internal_templateparser.php"
#line 334 "smarty_internal_templateparser.y"
    function yy_r66(){ $this->_retvalue = str_replace(array('."".','"".','.""'),array('.','',''),'"'.$this->yystack[$this->yyidx + -1]->minor.'"');     }
#line 2227 "smarty_internal_templateparser.php"
#line 335 "smarty_internal_templateparser.y"
    function yy_r67(){ $this->_retvalue = "''";     }
#line 2230 "smarty_internal_templateparser.php"
#line 337 "smarty_internal_templateparser.y"
    function yy_r68(){ $this->_retvalue = $this->yystack[$this->yyidx + -2]->minor.'::'.$this->yystack[$this->yyidx + 0]->minor;     }
#line 2233 "smarty_internal_templateparser.php"
#line 338 "smarty_internal_templateparser.y"
    function yy_r69(){ $this->prefix_number++; $this->compiler->prefix_code[] = '<?php $_tmp'.$this->prefix_number.'=$_smarty_tpl->getVariable(\''. $this->yystack[$this->yyidx + -3]->minor .'\')->value;?>'; $this->_retvalue = $this->yystack[$this->yyidx + -6]->minor.'::$_tmp'.$this->prefix_number.'('. $this->yystack[$this->yyidx + -1]->minor .')';     }
#line 2236 "smarty_internal_templateparser.php"
#line 340 "smarty_internal_templateparser.y"
    function yy_r70(){ $this->_retvalue = $this->yystack[$this->yyidx + -3]->minor.'::'.$this->yystack[$this->yyidx + -1]->minor.$this->yystack[$this->yyidx + 0]->minor;     }
#line 2239 "smarty_internal_templateparser.php"
#line 341 "smarty_internal_templateparser.y"
    function yy_r71(){ $this->prefix_number++; $this->compiler->prefix_code[] = '<?php $_tmp'.$this->prefix_number.'=$_smarty_tpl->getVariable(\''. $this->yystack[$this->yyidx + -4]->minor .'\')->value;?>'; $this->_retvalue = $this->yystack[$this->yyidx + -7]->minor.'::$_tmp'.$this->prefix_number.'('. $this->yystack[$this->yyidx + -2]->minor .')'.$this->yystack[$this->yyidx + 0]->minor;     }
#line 2242 "smarty_internal_templateparser.php"
#line 343 "smarty_internal_templateparser.y"
    function yy_r72(){ $this->_retvalue = $this->yystack[$this->yyidx + -2]->minor.'::'.$this->yystack[$this->yyidx + 0]->minor;    }
#line 2245 "smarty_internal_templateparser.php"
#line 345 "smarty_internal_templateparser.y"
    function yy_r73(){ $this->_retvalue = $this->yystack[$this->yyidx + -4]->minor.'::$'.$this->yystack[$this->yyidx + -1]->minor.$this->yystack[$this->yyidx + 0]->minor;    }
#line 2248 "smarty_internal_templateparser.php"
#line 347 "smarty_internal_templateparser.y"
    function yy_r74(){ $this->_retvalue = $this->yystack[$this->yyidx + -5]->minor.'::$'.$this->yystack[$this->yyidx + -2]->minor.$this->yystack[$this->yyidx + -1]->minor.$this->yystack[$this->yyidx + 0]->minor;    }
#line 2251 "smarty_internal_templateparser.php"
#line 349 "smarty_internal_templateparser.y"
    function yy_r75(){ $this->prefix_number++; $this->compiler->prefix_code[] = '<?php ob_start();?>'.$this->yystack[$this->yyidx + 0]->minor.'<?php $_tmp'.$this->prefix_number.'=ob_get_clean();?>'; $this->_retvalue = '$_tmp'.$this->prefix_number;     }
#line 2254 "smarty_internal_templateparser.php"
#line 358 "smarty_internal_templateparser.y"
    function yy_r76(){if ($this->yystack[$this->yyidx + 0]->minor['var'] == '\'smarty\'') { $this->_retvalue =  $this->compiler->compileTag('special_smarty_variable',$this->yystack[$this->yyidx + 0]->minor['index']);} else {
                                                         $this->_retvalue = '$_smarty_tpl->getVariable('. $this->yystack[$this->yyidx + 0]->minor['var'] .')->value'.$this->yystack[$this->yyidx + 0]->minor['index']; $this->compiler->tag_nocache=$this->compiler->tag_nocache|$this->template->getVariable(trim($this->yystack[$this->yyidx + 0]->minor['var'],"'"))->nocache;}    }
#line 2258 "smarty_internal_templateparser.php"
#line 361 "smarty_internal_templateparser.y"
    function yy_r77(){ $this->_retvalue = '$_smarty_tpl->getVariable('. $this->yystack[$this->yyidx + -2]->minor .')->'.$this->yystack[$this->yyidx + 0]->minor; $this->compiler->tag_nocache=$this->compiler->tag_nocache|$this->template->getVariable(trim($this->yystack[$this->yyidx + -2]->minor,"'"))->nocache;    }
#line 2261 "smarty_internal_templateparser.php"
#line 365 "smarty_internal_templateparser.y"
    function yy_r79(){$this->_retvalue = '$_smarty_tpl->getConfigVariable(\''. $this->yystack[$this->yyidx + -1]->minor .'\')';    }
#line 2264 "smarty_internal_templateparser.php"
#line 366 "smarty_internal_templateparser.y"
    function yy_r80(){$this->_retvalue = '$_smarty_tpl->getConfigVariable('. $this->yystack[$this->yyidx + -1]->minor .')';    }
#line 2267 "smarty_internal_templateparser.php"
#line 369 "smarty_internal_templateparser.y"
    function yy_r81(){$this->_retvalue = array('var'=>$this->yystack[$this->yyidx + -1]->minor, 'index'=>$this->yystack[$this->yyidx + 0]->minor);    }
#line 2270 "smarty_internal_templateparser.php"
#line 375 "smarty_internal_templateparser.y"
    function yy_r82(){$this->_retvalue = $this->yystack[$this->yyidx + -1]->minor.$this->yystack[$this->yyidx + 0]->minor;    }
#line 2273 "smarty_internal_templateparser.php"
#line 377 "smarty_internal_templateparser.y"
    function yy_r83(){return;    }
#line 2276 "smarty_internal_templateparser.php"
#line 381 "smarty_internal_templateparser.y"
    function yy_r84(){ $this->_retvalue = "['". $this->yystack[$this->yyidx + 0]->minor ."']";    }
#line 2279 "smarty_internal_templateparser.php"
#line 384 "smarty_internal_templateparser.y"
    function yy_r87(){ $this->_retvalue = "[". $this->yystack[$this->yyidx + 0]->minor ."]";    }
#line 2282 "smarty_internal_templateparser.php"
#line 385 "smarty_internal_templateparser.y"
    function yy_r88(){ $this->_retvalue = "['". $this->yystack[$this->yyidx + -1]->minor . $this->yystack[$this->yyidx + 0]->minor ."']";    }
#line 2285 "smarty_internal_templateparser.php"
#line 386 "smarty_internal_templateparser.y"
    function yy_r89(){ $this->_retvalue = "[".$this->yystack[$this->yyidx + 0]->minor."]";    }
#line 2288 "smarty_internal_templateparser.php"
#line 387 "smarty_internal_templateparser.y"
    function yy_r90(){ $this->_retvalue = "[". $this->yystack[$this->yyidx + -1]->minor ."]";    }
#line 2291 "smarty_internal_templateparser.php"
#line 389 "smarty_internal_templateparser.y"
    function yy_r91(){ $this->_retvalue = '['.$this->compiler->compileTag('special_smarty_variable','[\'section\'][\''.$this->yystack[$this->yyidx + -1]->minor.'\'][\'index\']').']';    }
#line 2294 "smarty_internal_templateparser.php"
#line 390 "smarty_internal_templateparser.y"
    function yy_r92(){ $this->_retvalue = '['.$this->compiler->compileTag('special_smarty_variable','[\'section\'][\''.$this->yystack[$this->yyidx + -3]->minor.'\'][\''.$this->yystack[$this->yyidx + -1]->minor.'\']').']';    }
#line 2297 "smarty_internal_templateparser.php"
#line 394 "smarty_internal_templateparser.y"
    function yy_r94(){$this->_retvalue = '';    }
#line 2300 "smarty_internal_templateparser.php"
#line 402 "smarty_internal_templateparser.y"
    function yy_r96(){$this->_retvalue = $this->yystack[$this->yyidx + -1]->minor.'.'.$this->yystack[$this->yyidx + 0]->minor;    }
#line 2303 "smarty_internal_templateparser.php"
#line 404 "smarty_internal_templateparser.y"
    function yy_r97(){$this->_retvalue = '\''.$this->yystack[$this->yyidx + 0]->minor.'\'';    }
#line 2306 "smarty_internal_templateparser.php"
#line 406 "smarty_internal_templateparser.y"
    function yy_r98(){$this->_retvalue = '('.$this->yystack[$this->yyidx + -1]->minor.')';    }
#line 2309 "smarty_internal_templateparser.php"
#line 411 "smarty_internal_templateparser.y"
    function yy_r99(){ if ($this->yystack[$this->yyidx + -1]->minor['var'] == '\'smarty\'') { $this->_retvalue =  $this->compiler->compileTag('special_smarty_variable',$this->yystack[$this->yyidx + -1]->minor['index']).$this->yystack[$this->yyidx + 0]->minor;} else {
                                                         $this->_retvalue = '$_smarty_tpl->getVariable('. $this->yystack[$this->yyidx + -1]->minor['var'] .')->value'.$this->yystack[$this->yyidx + -1]->minor['index'].$this->yystack[$this->yyidx + 0]->minor; $this->compiler->tag_nocache=$this->compiler->tag_nocache|$this->template->getVariable(trim($this->yystack[$this->yyidx + -1]->minor['var'],"'"))->nocache;}    }
#line 2313 "smarty_internal_templateparser.php"
#line 414 "smarty_internal_templateparser.y"
    function yy_r100(){$this->_retvalue  = $this->yystack[$this->yyidx + 0]->minor;     }
#line 2316 "smarty_internal_templateparser.php"
#line 416 "smarty_internal_templateparser.y"
    function yy_r101(){$this->_retvalue  = $this->yystack[$this->yyidx + -1]->minor.$this->yystack[$this->yyidx + 0]->minor;     }
#line 2319 "smarty_internal_templateparser.php"
#line 418 "smarty_internal_templateparser.y"
    function yy_r102(){ $this->_retvalue = '->'.$this->yystack[$this->yyidx + -1]->minor.$this->yystack[$this->yyidx + 0]->minor;    }
#line 2322 "smarty_internal_templateparser.php"
#line 419 "smarty_internal_templateparser.y"
    function yy_r103(){ $this->_retvalue = '->{'.$this->yystack[$this->yyidx + -1]->minor.$this->yystack[$this->yyidx + 0]->minor.'}';    }
#line 2325 "smarty_internal_templateparser.php"
#line 420 "smarty_internal_templateparser.y"
    function yy_r104(){ $this->_retvalue = '->{'.$this->yystack[$this->yyidx + -2]->minor.$this->yystack[$this->yyidx + 0]->minor.'}';    }
#line 2328 "smarty_internal_templateparser.php"
#line 421 "smarty_internal_templateparser.y"
    function yy_r105(){ $this->_retvalue = '->{\''.$this->yystack[$this->yyidx + -4]->minor.'\'.'.$this->yystack[$this->yyidx + -2]->minor.$this->yystack[$this->yyidx + 0]->minor.'}';    }
#line 2331 "smarty_internal_templateparser.php"
#line 423 "smarty_internal_templateparser.y"
    function yy_r106(){ $this->_retvalue = '->'.$this->yystack[$this->yyidx + 0]->minor;    }
#line 2334 "smarty_internal_templateparser.php"
#line 429 "smarty_internal_templateparser.y"
    function yy_r107(){if (!$this->template->security || $this->smarty->security_handler->isTrustedPhpFunction($this->yystack[$this->yyidx + -3]->minor, $this->compiler)) {
																					            if ($this->yystack[$this->yyidx + -3]->minor == 'isset' || $this->yystack[$this->yyidx + -3]->minor == 'empty' || $this->yystack[$this->yyidx + -3]->minor == 'array' || is_callable($this->yystack[$this->yyidx + -3]->minor)) {
																					                $this->_retvalue = $this->yystack[$this->yyidx + -3]->minor . "(". $this->yystack[$this->yyidx + -1]->minor .")";
																					            } else {
                                                       $this->compiler->trigger_template_error ("unknown function \"" . $this->yystack[$this->yyidx + -3]->minor . "\"");
                                                      }
                                                    }    }
#line 2343 "smarty_internal_templateparser.php"
#line 440 "smarty_internal_templateparser.y"
    function yy_r108(){ $this->_retvalue = $this->yystack[$this->yyidx + -3]->minor . "(". $this->yystack[$this->yyidx + -1]->minor .")";    }
#line 2346 "smarty_internal_templateparser.php"
#line 444 "smarty_internal_templateparser.y"
    function yy_r109(){ $this->_retvalue = $this->yystack[$this->yyidx + -2]->minor.",".$this->yystack[$this->yyidx + 0]->minor;    }
#line 2349 "smarty_internal_templateparser.php"
#line 448 "smarty_internal_templateparser.y"
    function yy_r111(){ return;    }
#line 2352 "smarty_internal_templateparser.php"
#line 453 "smarty_internal_templateparser.y"
    function yy_r112(){ $this->_retvalue =  array($this->yystack[$this->yyidx + 0]->minor,'false');    }
#line 2355 "smarty_internal_templateparser.php"
#line 454 "smarty_internal_templateparser.y"
    function yy_r113(){ $this->_retvalue =  array($this->yystack[$this->yyidx + 0]->minor,'true');    }
#line 2358 "smarty_internal_templateparser.php"
#line 470 "smarty_internal_templateparser.y"
    function yy_r116(){$this->_retvalue = ','.$this->yystack[$this->yyidx + 0]->minor;    }
#line 2361 "smarty_internal_templateparser.php"
#line 471 "smarty_internal_templateparser.y"
    function yy_r117(){$this->_retvalue = ',\''.$this->yystack[$this->yyidx + 0]->minor.'\'';    }
#line 2364 "smarty_internal_templateparser.php"
#line 478 "smarty_internal_templateparser.y"
    function yy_r119(){$this->_retvalue = '!'.$this->yystack[$this->yyidx + 0]->minor;    }
#line 2367 "smarty_internal_templateparser.php"
#line 483 "smarty_internal_templateparser.y"
    function yy_r121(){$this->_retvalue =$this->yystack[$this->yyidx + 0]->minor;    }
#line 2370 "smarty_internal_templateparser.php"
#line 485 "smarty_internal_templateparser.y"
    function yy_r122(){$this->_retvalue = $this->yystack[$this->yyidx + -2]->minor.$this->yystack[$this->yyidx + -1]->minor.$this->yystack[$this->yyidx + 0]->minor;    }
#line 2373 "smarty_internal_templateparser.php"
#line 486 "smarty_internal_templateparser.y"
    function yy_r123(){$this->_retvalue = 'in_array('.$this->yystack[$this->yyidx + -2]->minor.','.$this->yystack[$this->yyidx + 0]->minor.')';    }
#line 2376 "smarty_internal_templateparser.php"
#line 487 "smarty_internal_templateparser.y"
    function yy_r124(){$this->_retvalue = 'in_array('.$this->yystack[$this->yyidx + -2]->minor.',(array)'.$this->yystack[$this->yyidx + 0]->minor.')';    }
#line 2379 "smarty_internal_templateparser.php"
#line 489 "smarty_internal_templateparser.y"
    function yy_r126(){$this->_retvalue = '!('.$this->yystack[$this->yyidx + -2]->minor.' % '.$this->yystack[$this->yyidx + 0]->minor.')';    }
#line 2382 "smarty_internal_templateparser.php"
#line 490 "smarty_internal_templateparser.y"
    function yy_r127(){$this->_retvalue = '('.$this->yystack[$this->yyidx + -2]->minor.' % '.$this->yystack[$this->yyidx + 0]->minor.')';    }
#line 2385 "smarty_internal_templateparser.php"
#line 491 "smarty_internal_templateparser.y"
    function yy_r128(){$this->_retvalue = '!(1 & '.$this->yystack[$this->yyidx + -1]->minor.')';    }
#line 2388 "smarty_internal_templateparser.php"
#line 492 "smarty_internal_templateparser.y"
    function yy_r129(){$this->_retvalue = '(1 & '.$this->yystack[$this->yyidx + -1]->minor.')';    }
#line 2391 "smarty_internal_templateparser.php"
#line 493 "smarty_internal_templateparser.y"
    function yy_r130(){$this->_retvalue = '!(1 & '.$this->yystack[$this->yyidx + -2]->minor.' / '.$this->yystack[$this->yyidx + 0]->minor.')';    }
#line 2394 "smarty_internal_templateparser.php"
#line 494 "smarty_internal_templateparser.y"
    function yy_r131(){$this->_retvalue = '(1 & '.$this->yystack[$this->yyidx + -2]->minor.' / '.$this->yystack[$this->yyidx + 0]->minor.')';    }
#line 2397 "smarty_internal_templateparser.php"
#line 500 "smarty_internal_templateparser.y"
    function yy_r137(){$this->prefix_number++; $this->compiler->prefix_code[] = '<?php $_tmp'.$this->prefix_number.'='.$this->yystack[$this->yyidx + 0]->minor.';?>'; $this->_retvalue = $this->yystack[$this->yyidx + -2]->minor.$this->yystack[$this->yyidx + -1]->minor.'$_tmp'.$this->prefix_number;    }
#line 2400 "smarty_internal_templateparser.php"
#line 502 "smarty_internal_templateparser.y"
    function yy_r138(){$this->_retvalue = '==';    }
#line 2403 "smarty_internal_templateparser.php"
#line 503 "smarty_internal_templateparser.y"
    function yy_r139(){$this->_retvalue = '!=';    }
#line 2406 "smarty_internal_templateparser.php"
#line 504 "smarty_internal_templateparser.y"
    function yy_r140(){$this->_retvalue = '>';    }
#line 2409 "smarty_internal_templateparser.php"
#line 505 "smarty_internal_templateparser.y"
    function yy_r141(){$this->_retvalue = '<';    }
#line 2412 "smarty_internal_templateparser.php"
#line 506 "smarty_internal_templateparser.y"
    function yy_r142(){$this->_retvalue = '>=';    }
#line 2415 "smarty_internal_templateparser.php"
#line 507 "smarty_internal_templateparser.y"
    function yy_r143(){$this->_retvalue = '<=';    }
#line 2418 "smarty_internal_templateparser.php"
#line 508 "smarty_internal_templateparser.y"
    function yy_r144(){$this->_retvalue = '===';    }
#line 2421 "smarty_internal_templateparser.php"
#line 509 "smarty_internal_templateparser.y"
    function yy_r145(){$this->_retvalue = '!==';    }
#line 2424 "smarty_internal_templateparser.php"
#line 510 "smarty_internal_templateparser.y"
    function yy_r146(){$this->_retvalue = '%';    }
#line 2427 "smarty_internal_templateparser.php"
#line 512 "smarty_internal_templateparser.y"
    function yy_r147(){$this->_retvalue = '&&';    }
#line 2430 "smarty_internal_templateparser.php"
#line 513 "smarty_internal_templateparser.y"
    function yy_r148(){$this->_retvalue = '||';    }
#line 2433 "smarty_internal_templateparser.php"
#line 514 "smarty_internal_templateparser.y"
    function yy_r149(){$this->_retvalue = ' XOR ';    }
#line 2436 "smarty_internal_templateparser.php"
#line 519 "smarty_internal_templateparser.y"
    function yy_r150(){ $this->_retvalue = 'array('.$this->yystack[$this->yyidx + -1]->minor.')';    }
#line 2439 "smarty_internal_templateparser.php"
#line 521 "smarty_internal_templateparser.y"
    function yy_r152(){ $this->_retvalue = $this->yystack[$this->yyidx + -2]->minor.','.$this->yystack[$this->yyidx + 0]->minor;     }
#line 2442 "smarty_internal_templateparser.php"
#line 522 "smarty_internal_templateparser.y"
    function yy_r153(){ return;     }
#line 2445 "smarty_internal_templateparser.php"
#line 523 "smarty_internal_templateparser.y"
    function yy_r154(){ $this->_retvalue = $this->yystack[$this->yyidx + -2]->minor.'=>'.$this->yystack[$this->yyidx + 0]->minor;    }
#line 2448 "smarty_internal_templateparser.php"
#line 524 "smarty_internal_templateparser.y"
    function yy_r155(){ $this->_retvalue = '\''.$this->yystack[$this->yyidx + -2]->minor.'\'=>'.$this->yystack[$this->yyidx + 0]->minor;    }
#line 2451 "smarty_internal_templateparser.php"
#line 533 "smarty_internal_templateparser.y"
    function yy_r159(){$this->_retvalue = '".'.$this->yystack[$this->yyidx + -1]->minor.'."'; $this->compiler->has_variable_string = true;    }
#line 2454 "smarty_internal_templateparser.php"
#line 534 "smarty_internal_templateparser.y"
    function yy_r160(){$this->_retvalue = '".'.'$_smarty_tpl->getVariable(\''. substr($this->yystack[$this->yyidx + 0]->minor,1) .'\')->value'.'."'; $this->compiler->tag_nocache=$this->compiler->tag_nocache|$this->template->getVariable(trim($this->yystack[$this->yyidx + 0]->minor,"'"))->nocache; $this->compiler->has_variable_string = true;    }
#line 2457 "smarty_internal_templateparser.php"
#line 536 "smarty_internal_templateparser.y"
    function yy_r162(){ $this->_retvalue = '".('.$this->yystack[$this->yyidx + -1]->minor.')."'; $this->compiler->has_variable_string = true;    }
#line 2460 "smarty_internal_templateparser.php"
#line 537 "smarty_internal_templateparser.y"
    function yy_r163(){ $this->prefix_number++; $this->compiler->prefix_code[] = '<?php ob_start();?>'.$this->yystack[$this->yyidx + 0]->minor.'<?php $_tmp'.$this->prefix_number.'=ob_get_clean();?>'; $this->_retvalue = '".$_tmp'.$this->prefix_number.'."'; $this->compiler->has_variable_string = true;    }
#line 2463 "smarty_internal_templateparser.php"

    /**
     * placeholder for the left hand side in a reduce operation.
     * 
     * For a parser with a rule like this:
     * <pre>
     * rule(A) ::= B. { A = 1; }
     * </pre>
     * 
     * The parser will translate to something like:
     * 
     * <code>
     * function yy_r0(){$this->_retvalue = 1;}
     * </code>
     */
    private $_retvalue;

    /**
     * Perform a reduce action and the shift that must immediately
     * follow the reduce.
     * 
     * For a rule such as:
     * 
     * <pre>
     * A ::= B blah C. { dosomething(); }
     * </pre>
     * 
     * This function will first call the action, if any, ("dosomething();" in our
     * example), and then it will pop three states from the stack,
     * one for each entry on the right-hand side of the expression
     * (B, blah, and C in our example rule), and then push the result of the action
     * back on to the stack with the resulting state reduced to (as described in the .out
     * file)
     * @param int Number of the rule by which to reduce
     */
    function yy_reduce($yyruleno)
    {
        //int $yygoto;                     /* The next state */
        //int $yyact;                      /* The next action */
        //mixed $yygotominor;        /* The LHS of the rule reduced */
        //TP_yyStackEntry $yymsp;            /* The top of the parser's stack */
        //int $yysize;                     /* Amount to pop the stack */
        $yymsp = $this->yystack[$this->yyidx];
        if (self::$yyTraceFILE && $yyruleno >= 0 
              && $yyruleno < count(self::$yyRuleName)) {
            fprintf(self::$yyTraceFILE, "%sReduce (%d) [%s].\n",
                self::$yyTracePrompt, $yyruleno,
                self::$yyRuleName[$yyruleno]);
        }

        $this->_retvalue = $yy_lefthand_side = null;
        if (array_key_exists($yyruleno, self::$yyReduceMap)) {
            // call the action
            $this->_retvalue = null;
            $this->{'yy_r' . self::$yyReduceMap[$yyruleno]}();
            $yy_lefthand_side = $this->_retvalue;
        }
        $yygoto = self::$yyRuleInfo[$yyruleno]['lhs'];
        $yysize = self::$yyRuleInfo[$yyruleno]['rhs'];
        $this->yyidx -= $yysize;
        for($i = $yysize; $i; $i--) {
            // pop all of the right-hand side parameters
            array_pop($this->yystack);
        }
        $yyact = $this->yy_find_reduce_action($this->yystack[$this->yyidx]->stateno, $yygoto);
        if ($yyact < self::YYNSTATE) {
            /* If we are not debugging and the reduce action popped at least
            ** one element off the stack, then we can push the new element back
            ** onto the stack here, and skip the stack overflow test in yy_shift().
            ** That gives a significant speed improvement. */
            if (!self::$yyTraceFILE && $yysize) {
                $this->yyidx++;
                $x = new TP_yyStackEntry;
                $x->stateno = $yyact;
                $x->major = $yygoto;
                $x->minor = $yy_lefthand_side;
                $this->yystack[$this->yyidx] = $x;
            } else {
                $this->yy_shift($yyact, $yygoto, $yy_lefthand_side);
            }
        } elseif ($yyact == self::YYNSTATE + self::YYNRULE + 1) {
            $this->yy_accept();
        }
    }

    /**
     * The following code executes when the parse fails
     * 
     * Code from %parse_fail is inserted here
     */
    function yy_parse_failed()
    {
        if (self::$yyTraceFILE) {
            fprintf(self::$yyTraceFILE, "%sFail!\n", self::$yyTracePrompt);
        }
        while ($this->yyidx >= 0) {
            $this->yy_pop_parser_stack();
        }
        /* Here code is inserted which will be executed whenever the
        ** parser fails */
    }

    /**
     * The following code executes when a syntax error first occurs.
     * 
     * %syntax_error code is inserted here
     * @param int The major type of the error token
     * @param mixed The minor type of the error token
     */
    function yy_syntax_error($yymajor, $TOKEN)
    {
#line 60 "smarty_internal_templateparser.y"

    $this->internalError = true;
    $this->yymajor = $yymajor;
    $this->compiler->trigger_template_error();
#line 2581 "smarty_internal_templateparser.php"
    }

    /**
     * The following is executed when the parser accepts
     * 
     * %parse_accept code is inserted here
     */
    function yy_accept()
    {
        if (self::$yyTraceFILE) {
            fprintf(self::$yyTraceFILE, "%sAccept!\n", self::$yyTracePrompt);
        }
        while ($this->yyidx >= 0) {
            $stack = $this->yy_pop_parser_stack();
        }
        /* Here code is inserted which will be executed whenever the
        ** parser accepts */
#line 52 "smarty_internal_templateparser.y"

    $this->successful = !$this->internalError;
    $this->internalError = false;
    $this->retvalue = $this->_retvalue;
    //echo $this->retvalue."\n\n";
#line 2606 "smarty_internal_templateparser.php"
    }

    /**
     * The main parser program.
     * 
     * The first argument is the major token number.  The second is
     * the token value string as scanned from the input.
     *
     * @param int the token number
     * @param mixed the token value
     * @param mixed any extra arguments that should be passed to handlers
     */
    function doParse($yymajor, $yytokenvalue)
    {
//        $yyact;            /* The parser action. */
//        $yyendofinput;     /* True if we are at the end of input */
        $yyerrorhit = 0;   /* True if yymajor has invoked an error */
        
        /* (re)initialize the parser, if necessary */
        if ($this->yyidx === null || $this->yyidx < 0) {
            /* if ($yymajor == 0) return; // not sure why this was here... */
            $this->yyidx = 0;
            $this->yyerrcnt = -1;
            $x = new TP_yyStackEntry;
            $x->stateno = 0;
            $x->major = 0;
            $this->yystack = array();
            array_push($this->yystack, $x);
        }
        $yyendofinput = ($yymajor==0);
        
        if (self::$yyTraceFILE) {
            fprintf(self::$yyTraceFILE, "%sInput %s\n",
                self::$yyTracePrompt, $this->yyTokenName[$yymajor]);
        }
        
        do {
            $yyact = $this->yy_find_shift_action($yymajor);
            if ($yymajor < self::YYERRORSYMBOL &&
                  !$this->yy_is_expected_token($yymajor)) {
                // force a syntax error
                $yyact = self::YY_ERROR_ACTION;
            }
            if ($yyact < self::YYNSTATE) {
                $this->yy_shift($yyact, $yymajor, $yytokenvalue);
                $this->yyerrcnt--;
                if ($yyendofinput && $this->yyidx >= 0) {
                    $yymajor = 0;
                } else {
                    $yymajor = self::YYNOCODE;
                }
            } elseif ($yyact < self::YYNSTATE + self::YYNRULE) {
                $this->yy_reduce($yyact - self::YYNSTATE);
            } elseif ($yyact == self::YY_ERROR_ACTION) {
                if (self::$yyTraceFILE) {
                    fprintf(self::$yyTraceFILE, "%sSyntax Error!\n",
                        self::$yyTracePrompt);
                }
                if (self::YYERRORSYMBOL) {
                    /* A syntax error has occurred.
                    ** The response to an error depends upon whether or not the
                    ** grammar defines an error token "ERROR".  
                    **
                    ** This is what we do if the grammar does define ERROR:
                    **
                    **  * Call the %syntax_error function.
                    **
                    **  * Begin popping the stack until we enter a state where
                    **    it is legal to shift the error symbol, then shift
                    **    the error symbol.
                    **
                    **  * Set the error count to three.
                    **
                    **  * Begin accepting and shifting new tokens.  No new error
                    **    processing will occur until three tokens have been
                    **    shifted successfully.
                    **
                    */
                    if ($this->yyerrcnt < 0) {
                        $this->yy_syntax_error($yymajor, $yytokenvalue);
                    }
                    $yymx = $this->yystack[$this->yyidx]->major;
                    if ($yymx == self::YYERRORSYMBOL || $yyerrorhit ){
                        if (self::$yyTraceFILE) {
                            fprintf(self::$yyTraceFILE, "%sDiscard input token %s\n",
                                self::$yyTracePrompt, $this->yyTokenName[$yymajor]);
                        }
                        $this->yy_destructor($yymajor, $yytokenvalue);
                        $yymajor = self::YYNOCODE;
                    } else {
                        while ($this->yyidx >= 0 &&
                                 $yymx != self::YYERRORSYMBOL &&
        ($yyact = $this->yy_find_shift_action(self::YYERRORSYMBOL)) >= self::YYNSTATE
                              ){
                            $this->yy_pop_parser_stack();
                        }
                        if ($this->yyidx < 0 || $yymajor==0) {
                            $this->yy_destructor($yymajor, $yytokenvalue);
                            $this->yy_parse_failed();
                            $yymajor = self::YYNOCODE;
                        } elseif ($yymx != self::YYERRORSYMBOL) {
                            $u2 = 0;
                            $this->yy_shift($yyact, self::YYERRORSYMBOL, $u2);
                        }
                    }
                    $this->yyerrcnt = 3;
                    $yyerrorhit = 1;
                } else {
                    /* YYERRORSYMBOL is not defined */
                    /* This is what we do if the grammar does not define ERROR:
                    **
                    **  * Report an error message, and throw away the input token.
                    **
                    **  * If the input token is $, then fail the parse.
                    **
                    ** As before, subsequent error messages are suppressed until
                    ** three input tokens have been successfully shifted.
                    */
                    if ($this->yyerrcnt <= 0) {
                        $this->yy_syntax_error($yymajor, $yytokenvalue);
                    }
                    $this->yyerrcnt = 3;
                    $this->yy_destructor($yymajor, $yytokenvalue);
                    if ($yyendofinput) {
                        $this->yy_parse_failed();
                    }
                    $yymajor = self::YYNOCODE;
                }
            } else {
                $this->yy_accept();
                $yymajor = self::YYNOCODE;
            }            
        } while ($yymajor != self::YYNOCODE && $this->yyidx >= 0);
    }
}
?>
