<?php
//登录类
class admin
{
	private $aid = 0;			//管理员ID
	private $auserid = '';		//管理员登录名
	private $aname = '';		//管理员真名
	private $rights_menu = '';	//权限值
	private $info = array();	//管理员信息
	private $db = '';			//数据库OBJ
	private $cookie = '';		//cookieOBJ
	private $session = '';		//cookieOBJ
	private $page = '';			//cookieOBJ
	
	//初始化
    public function __construct()
    {
        if(! $this->db){
			global $db;
			$this->db = $db;
        }
        if(! $this->cookie){
			global $cookie;
			$this->cookie = $cookie;
        }
        if(! $this->session){
			global $session;
			$this->session = $session;
        }
		// 从数据库查询用户数据
        if(! $this->aid)
        {
        	$this->aid = $this->cookie->get_cookie('a_id');
        	if(! $this->aid){
				$this->aid = $this->session->get_session('a_id');
        	}
        }
        if($this->aid){
	        
	        $admin_data = $this->get_one($this->aid);
			
	        if (empty($admin_data))
	        {
	            $this->aid = 0;
	            $this->auserid = '';
	        }
	        else
	        {
	            $this->aid = $admin_data['a_id'];
	            $this->aname = $admin_data['a_name'];
	            $this->auserid = $admin_data['a_userid'];
				$this->rights_menu = $admin_data['g_rights_menu'];
	            // 个人信息赋值
	            $this->info = $admin_data;
	        }
        }
	}
	
	public function admin()
	{
		$this->__construct();
	}
	
	//取到当前管理员基本信息
	public function get_info($vname)
	{
		if($this->info[$vname]){
			return $this->info[$vname];
		}
		else{
			return false;
		}
	}
	
	//取到单独一条管理员基本信息
	public function get_one($aid)
	{
		$sql_select = "SELECT * FROM zjh_admin INNER JOIN zjh_admin_group ON zjh_admin.a_groupId = zjh_admin_group.g_id WHERE zjh_admin.a_id = $aid";
		
		$total = $this->db->get_rows($sql_select);
		if($total == 1){
			return $this->db->fetch_one_array($sql_select);
		}
		else{
			return false;
		}
	}
	
	//登录
	public function admin_login($username, $password)
	{
		if($username == ''){
			$code = 10001;
			$msg = '用户名不能为空';
		}
		else if($password == ''){
			$code = 10002;
			$msg = '用户名不能为空';
		}
		else{
			$password = md5($password);
			$sql_select = "SELECT * FROM zjh_admin WHERE a_userid = '$username' AND a_password = '$password'";
			$total = $this->db->get_rows($sql_select);
			if($total == 1){
				$base_info = $this->db->fetch_one_array($sql_select);
				$this->cookie->set_cookie('a_id', $base_info['a_id']);
				if(! $this->cookie->get_cookie('a_id')){
					$this->session->set_session('a_id', $base_info['a_id']);
				}
				$this->aid = $base_info['a_id'];
				$this->info = $base_info;
				/*
				$this->aname = $base_info['a_name'];
				$this->rights_menu = $base_info['g_rights_menu'];
				*/
				unset($base_info);
				$code = 0;
				$msg = 'ok';
			}
			else{
				$code = 10003;
				$msg = '用户密码不存在';
			}
		}
		return array('code' => $code, 'msg' => $msg);
	}
	
	//检查管理员唯一
	public function check_userid($userid){
		$sql_select = "SELECT * FROM zjh_admin WHERE a_userid = '$userid'";
		$total = $this->db->get_rows($sql_select);
		if($total > 0){
			return false;
		}
		else{
			return true;
		}
	}
	
	//检查登录
	public function is_login()
	{
		if($this->aid && $this->aid == $this->info['a_id'] && $this->aid == $this->cookie->get_cookie('a_id')){
			return $this->aid;
		}
		else{
			return false;
		}
	}
	
	//更新管理员
	public function up_admin($a_id, $a_password, $a_name, $a_groupId, $a_description)
	{
		$sql_up = "UPDATE zjh_admin SET 
		a_name = '$a_name', 
		a_groupId = $a_groupId, ";
		if($a_password){
			$a_password = md5($a_password);
			$sql_up .= "a_password = '$a_password', ";
		}
		$sql_up .= "a_description = '$a_description' WHERE a_id = $a_id";
		if($this->db->query($sql_up)){
			$code = 0;
			$msg = '成功更新管理员';
		}
		else{
			$code = 10006;
			$msg = '更新管理员保存失败';
		}
		return array('code' => $code, 'msg' => $msg);
	}
	
	//添加管理员
	public function add_admin($a_userid, $a_password, $a_name, $a_groupId, $a_description)
	{
		$a_id = '';
		if($a_userid && $a_password && $a_name && $a_groupId){
			$a_password = md5($a_password);
			$sql_add = "INSERT INTO zjh_admin(a_userid,a_name,a_password,a_groupId,a_description)VALUES('$a_userid','$a_name','$a_password',$a_groupId,'$a_description')";
			$this->db->query($sql_add);
			$a_id = $this->db->get_insert_id();
			if($a_id){
				$code = 0;
				$msg = '管理员添加成功';
			}
			else{
				$code = 10005;
				$msg = '添加管理员保存失败';
			}
		}
		else{
			$code = 10004;
			$msg = '添加管理员参数不整齐';
		}
		return array('code' => $code, 'msg' => $msg, 'a_id' => $a_id);
	}
	
	//删除管理员
	public function del_admin($aid)
	{
		$sql_del = "DELETE FROM zjh_admin WHERE a_id = $aid";
		return $this->db->query($sql_del);
	}
	
	//管理员权限检查
	public function chk_rights($rights_id)
	{
		if(strpos($this->rights_menu ,$rights_id) > -1){
			return true;
		}
		else{
			return false;
		}
	}
	
	//获取管理员列表
	public function get_adminlist($url, $displaypg = 10, $sqlwhere = '', $orderby = false)
	{
		//$sql_select = "SELECT * FROM zjh_admin $sqlwhere";
		$sql_select = "SELECT * FROM zjh_admin INNER JOIN zjh_admin_group ON zjh_admin.a_groupId = zjh_admin_group.g_id $sqlwhere";
		$total = $this->db->get_rows($sql_select);
		if($total > 0){
			if($this->page == ''){
				$this->page = site_exe::site_page();
			}
			$code = 0;
			$msg = 'ok';
			$data = $this->page->get_data_list_page($sql_select, $total, $displaypg, $url, $orderby);
		}
		else{
			$code = 10000;
			$msg = '没有记录';
			$data = '';
		}
		return array('code' => $code, 'msg' => $msg, 'total' => $total, 'data' => $data);
	}
	
	//退出登录
	public function out_login()
	{
		$userinfo = $this->auserid.'：'.$this->aname;
		unset($this->info);
		$this->aid = '';
		$this->aname = '';
		$this->auserid = '';
		$this->rights_menu = '';
		$this->info = '';
		$this->db = '';
		$this->cookie->kill_cookie('a_id');
		$this->session->kill_session('a_id', true);
		if(! $this->aid && ! $this->cookie->get_cookie('a_id')){
			return true;
		}
		else{
			return false;
		}
	}
	
	//以上管理员相关
	//以下管理员分组相关
	
	//获取管理员分组
	public function get_group()
	{
		$sql_select = "SELECT * FROM zjh_admin_group";
		$total = $this->db->get_rows($sql_select);
		if($total > 0){
			$code = 0;
			$msg = 'ok';
			$data = $this->db->get_rows_array($sql_select);
		}
		else{
			$code = 10000;
			$msg = '没有内容';
			$data = $this->db->get_rows_array($sql_select);
		}
		return array('code' => $code, 'msg' => $msg, 'data' => $data, 'total' => $total);
	}
	
	//删除管理员分组
	public function del_group($gid)
	{
		$sql_del = "DELETE FROM zjh_admin_group WHERE g_id = $gid";
		return $this->db->query($sql_del);
	}
	
	//更新管理员分组
	public function up_group($g_id, $g_name, $g_rights_menu, $g_description)
	{
		$sql_up = "UPDATE zjh_admin_group SET 
		g_name = '$g_name', 
		g_rights_menu = '$g_rights_menu', 
		g_description = '$g_description' 
		WHERE g_id = $g_id";
		if($this->db->query($sql_up)){
			$code = 0;
			$msg = '成功更新管理员分组';
		}
		else{
			$code = 10007;
			$msg = '更新管理员分组保存失败';
		}
		return array('code' => $code, 'msg' => $msg);
	}
	
	//添加管理员分组
	public function add_group($g_name, $g_rights_menu, $g_description)
	{
		$aid = '';
		if($g_name && $g_rights_menu){
			$sql_add = "INSERT INTO zjh_admin_group(g_name,g_rights_menu,g_description)VALUES('$g_name','$g_rights_menu','$g_description')";
			$this->db->query($sql_add);
			$g_id = $this->db->get_insert_id();
			if($g_id){
				$code = 0;
				$msg = '管理员分组添加成功';
			}
			else{
				$code = 10009;
				$msg = '添加管理员分组保存失败';
			}
		}
		else{
			$code = 10008;
			$msg = '添加管理员分组参数不整齐';
		}
		return array('code' => $code, 'msg' => $msg, 'g_id' => $g_id);
	}
	
	//取到单独一条管理员分组基本信息
	public function get_group_one($gid)
	{
		$sql_select = "SELECT * FROM zjh_admin_group WHERE g_id = $gid";
		
		$total = $this->db->get_rows($sql_select);
		if($total == 1){
			return $this->db->fetch_one_array($sql_select);
		}
		else{
			return false;
		}
	}
	
	
	//获取权限菜单
	public function get_admin_menu($where = '')
	{
		$sql_select = "SELECT m_id,m_parentId,m_name FROM zjh_admin_menu $where ORDER BY m_parentId,m_orderby";
		$total = $this->db->get_rows($sql_select);
		if($total > 0){
			$code = 0;
			$msg = 'ok';
			$data = $this->db->get_rows_array($sql_select);
		}
		else{
			$code = 10000;
			$msg = '没有内容';
			$data = '';
		}
		return array('code' => $code, 'msg' => $msg, 'total' => $total, 'data' => $data);
	}
}
?>