<?php
//留言类
class comment
{
	private $db = '';				//数据库OBJ
	private $page = '';				//pageOBJ
	private $member = '';			//memberOBJ
	
	//初始化
    public function __construct()
    {
        if(! $this->db){
			global $db;
			$this->db = $db;
        }
        if(! $this->member){
			global $member;
			$this->member = $member;
        }
	}
	
	public function comment()
	{
		$this->__construct();
	}
	
	//获取留言列表
	public function get_list($url, $displaypg = 10, $sqlwhere = '', $pagesqlwhere = '', $orderby = false)
	{
		$sql_select = "SELECT * FROM zjh_comment $sqlwhere";
		if(! $orderby) $orderby = "Id DESC";
		$total = $this->db->get_rows($sql_select);
		if($total > 0){
			if($this->page == ''){
				$this->page = site_exe::site_page();
			}
			$data = $this->page->get_data_list_page($sql_select, $total, $displaypg, $url, $orderby, $pagesqlwhere);
			$code = 0;
			$msg = 'ok';
		}
		else{
			$code = 10000;
			$msg = '没有记录';
			$data = '';
		}
		return array('code' => $code, 'msg' => $msg, 'total' => $total, 'data' => $data);
	}
	
	//删除留言
	public function del_comment($c_id, $delall = false)
	{
		if($delall){
			$sql_del = "DELETE FROM zjh_comment";
		}
		else{
			$sql_del = "DELETE FROM zjh_comment WHERE Id IN ($c_id)";
		}
		return $this->db->query($sql_del);
	}
	
	//更新留言
	public function up_comment($c_id, $topid, $comtype, $litpic, $title, $content, $content_hf, $username, $useremail, $usertel, $userqq, $useradd, $adddate, $visible)
	{
		$sql_up = "UPDATE zjh_comment SET 
		topid = $topid, 
		comtype = $comtype, 
		litpic = '$litpic', 
		title = '$title', 
		content = '$content', 
		content_hf = '$content_hf', 
		username = '$username', 
		useremail = '$useremail', 
		usertel = '$usertel', 
		userqq = '$userqq', 
		useradd = '$useradd', 
		adddate = '$adddate', 
		visible = '$visible' 
		WHERE Id = $c_id";
		if($this->db->query($sql_up)){
			$code = 0;
			$msg = '成功更新留言';
		}
		else{
			$code = 10052;
			$msg = '更新留言保存失败';
		}
		return array('code' => $code, 'msg' => $msg);
	}
	
	//添加留言
	public function add_comment($topid = 0, $comtype, $litpic, $title, $content, $content_hf, $userid, $username, $useremail, $usertel, $userqq, $useradd, $adddate)
	{
		$c_id = '';
		if($content && $adddate){
			global $cfg_site_com_view;
			$visible = $cfg_site_com_view;
			$sql_add = "INSERT INTO zjh_comment(topid, comtype, litpic, title, content, content_hf, userid, username, useremail, usertel, userqq, useradd, adddate, visible)VALUES($topid, $comtype, '$litpic', '$title', '$content', '$content_hf', $userid, '$username', '$useremail', '$usertel', '$userqq', '$useradd', '$adddate', $visible)";
			$this->db->query($sql_add);
			$c_id = $this->db->get_insert_id();
			if($c_id){
				$code = 0;
				$msg = '留言添加成功';
			}
			else{
				$code = 10054;
				$msg = '添加留言保存失败';
			}
		}
		else{
			$code = 10053;
			$msg = '添加留言参数不整齐';
		}
		return array('code' => $code, 'msg' => $msg, 'c_id' => $c_id);
	}
	
	//取到单独一条留言基本信息
	public function get_comment_one($c_id)
	{
		$sql_select = "SELECT * FROM zjh_comment WHERE Id = $c_id";
		$total = $this->db->get_rows($sql_select);
		if($total == 1){
			return $this->db->fetch_one_array($sql_select);
		}
		else{
			return false;
		}
	}
	
	//修改状态
	public function up_comment_visible($c_id, $visible)
	{
		$sql_up = "UPDATE zjh_comment SET 
		visible = $visible WHERE Id = $c_id";
		if($this->db->query($sql_up)){
			$code = 0;
			$msg = '成功更新留言';
		}
		else{
			$code = 10054;
			$msg = '更新留言保存失败';
		}
		return array('code' => $code, 'msg' => $msg);
	}
}
?>