<?php
//链接类
class links
{
	private $db = '';				//数据库OBJ
	private $page = '';				//pageOBJ
	private $admin = '';			//adminOBJ
	
	//初始化
    public function __construct()
    {
        if(! $this->db){
			global $db;
			$this->db = $db;
        }
        if(! $this->admin){
			global $admin;
			$this->admin = $admin;
        }
	}
	
	public function links()
	{
		$this->__construct();
	}
	
	//获取货币列表
	public function get_linkslist($url, $displaypg = 10, $sqlwhere = '', $orderby = false, $row = false)
	{
		$sql_select = "SELECT * FROM zjh_link $sqlwhere";
		$total = $this->db->get_rows($sql_select);
		if($total > 0){
			if($this->page == ''){
				$this->page = site_exe::site_page();
			}
			$code = 0;
			$msg = 'ok';
			$data = $this->page->get_data_list_page($sql_select, $total, $displaypg, $url, $orderby);
		}
		else{
			$code = 10000;
			$msg = '没有记录';
			$data = '';
		}
		return array('code' => $code, 'msg' => $msg, 'total' => $total, 'data' => $data);
	}
	
	//获取货币列表
	public function get_linksrows($rows = 0, $sqlwhere = '', $orderby = '', $isindex = false, $litpic = false)
	{
		if($isindex){
			if($sqlwhere) $sqlwhere .= " AND isindex = 1";
			else $sqlwhere = " WHERE isindex = 1";
		}
		if($litpic){
			if($sqlwhere) $sqlwhere .= " AND litpic != ''";
			else $sqlwhere = " WHERE litpic != ''";
		}
		$sql_select = "SELECT * FROM zjh_link $sqlwhere $orderby";
		$total = $this->db->get_rows($sql_select);
		if($total > 0){
			$code = 0;
			$msg = 'ok';
			$data = $this->db->get_rows_array($sql_select);
		}
		else{
			$code = 10000;
			$msg = '没有记录';
			$data = '';
		}
		return array('code' => $code, 'msg' => $msg, 'total' => $total, 'data' => $data);
	}
	
	//删除链接
	public function del_links($link_id)
	{
		$sql_del = "DELETE FROM zjh_link WHERE Id = $link_id";
		return $this->db->query($sql_del);
	}
	
	//更新链接
	public function up_links($link_id, $title, $description, $litpic, $url, $visible, $isindex)
	{
		$sql_up = "UPDATE zjh_link SET 
		title = '$title', 
		description = '$description', 
		url = '$url', 
		visible = $visible, 
		isindex = $isindex";
		if($litpic) $sql_up .= ",litpic = '$litpic'";
		$sql_up .= " WHERE Id = $link_id";
		if($this->db->query($sql_up)){
			$code = 0;
			$msg = '成功更新链接';
		}
		else{
			$code = 10013;
			$msg = '更新链接保存失败';
		}
		return array('code' => $code, 'msg' => $msg);
	}
	
	//添加链接
	public function add_links($title, $description, $litpic, $url, $visible, $isindex)
	{
		$c_id = '';
		if($title && $url){
			$sql_add = "INSERT INTO zjh_link(title,description,litpic,url,visible,isindex)VALUES('$title','$description','$litpic','$url',$visible,$isindex)";
			$this->db->query($sql_add);
			$link_id = $this->db->get_insert_id();
			if($link_id){
				$code = 0;
				$msg = '链接添加成功';
			}
			else{
				$code = 10015;
				$msg = '添加链接保存失败';
			}
		}
		else{
			$code = 10014;
			$msg = '添加链接参数不整齐';
		}
		return array('code' => $code, 'msg' => $msg, 'link_id' => $link_id);
	}
	
	//取到单独一条链接基本信息
	public function get_links_one($link_id)
	{
		$sql_select = "SELECT * FROM zjh_link WHERE Id = $link_id";
		$total = $this->db->get_rows($sql_select);
		if($total == 1){
			return $this->db->fetch_one_array($sql_select);
		}
		else{
			return false;
		}
	}
	
}
?>