<?php
class category extends Checklogin{
	
	function __construct(){
		parent::check_admin();
		$this->ob_tree=base::load_class("catetree");
		$this->mysql=$this->ob_tree->mysql;
	}
	
	function init(){
		$this->ob_tree->tree(0);
		template('category_list','admin');
	}
	
	public function add(){
		$parentid=isset($_GET['p'])?intval($_GET['p']):0;
		$model_arr=base::load_cache('cache_model','_model');
		$urlrule=base::load_cache("cache_urlrule","_urlrule");
		$url_list=get_array($urlrule,"class","list");
		$url_show=get_array($urlrule,"class","show");
		$this->ob_tree->tree(1);
		assign("model",$model_arr);
		assign("parentid",$parentid);
		assign("parentname",catname($parentid));
		assign("template_cate",get_tem_file("cate"));
		assign("template_list",get_tem_file("list"));
		assign("template_show",get_tem_file("show"));
		assign("url_list",$url_list);
		assign("url_show",$url_show);
		template('category_add','admin');
	}
	
	public function add_save(){
		$config=base::load_cache("cache_set_config","_config");
		$catname=safe_html($_POST['catname']);
		$catdir=safe_html($_POST['catdir']);
		$thumb=safe_html($_POST['thumb']);
		$is_link=intval($_POST['is_link']);
		$url=$_POST['url'];
		$model=safe_html($_POST['model']);
		$sort=intval($_POST['sort']);
		$is_show=intval($_POST['is_show']);
		$parentid=intval($_POST['parentid']);
		$is_target=intval($_POST['is_target']);
		$is_html=intval($_POST['is_html']);
		$template_cate=safe_html($_POST['template_cate']);
		$template_list=safe_html($_POST['template_list']);
		$template_show=safe_html($_POST['template_show']);
		$seo_title=safe_html($_POST['seo_title']);
		$seo_key=safe_html($_POST['seo_key']);
		$seo_des=safe_html($_POST['seo_des']);
		$url_list=intval($_POST['url_list']);
		$url_show=intval($_POST['url_show']);
		$pagesize=intval($_POST['pagesize']);
		$modelid=modelid($model);
		$power=addslashes(var_export($_POST['power'],true));
		
		if(empty($catname)||empty($catdir)||empty($model)||empty($pagesize)){
			showmsg(C('material_not_complete'),'-1');
		}
		
		if(!check_str($catdir,'/^[a-z0-9][a-z0-9]*$/')){
			showmsg(C('catdir').C('numbers_and_letters'),'-1');
		}
		
		if($is_html==1){
			if($config['createhtml']!=1){
				showmsg(C('config_html_error'),'index.php?m=xdcms&c=setting');
			}
		}
		
		$nums=$this->mysql->db_num("category","catdir='".$catdir."'");
		if($nums>0){
			showmsg(C('catdir_exist'),'-1');
		}
		
		$sql="insert into ".DB_PRE."category (catname,catdir,thumb,is_link,url,model,modelid,sort,is_show,is_target,is_html,template_cate,template_list,parentid,template_show,seo_title,seo_key,seo_des,power,url_list,url_show,pagesize) values ('".$catname."','".$catdir."','".$thumb."','".$is_link."','".$url."','".$model."','".$modelid."','".$sort."','".$is_show."','".$is_target."','".$is_html."','".$template_cate."','".$template_list."','".$parentid."','".$template_show."','".$seo_title."','".$seo_key."','".$seo_des."','".$power."','".$url_list."','".$url_show."','".$pagesize."')";
		$this->mysql->query($sql);
		$catid=$this->mysql->insert_id();
		
		if($is_link==0){//url
			$ob_url=base::load_class("url");
			$url=$ob_url->caturl($catid,$catdir,$is_html,0,$url_list);
			$this->mysql->db_update("category","`url`='".$url."'","`catid`=".$catid);
		}
		
		$this->category_cache();
		showmsg(C('add_success'),'-1');
	}
	
	public function edit(){
		$id=isset($_GET['id'])?intval($_GET['id']):0;
		$model_arr=base::load_cache('cache_model','_model');
		$category=base::load_cache('cache_category','_category');
		$urlrule=base::load_cache("cache_urlrule","_urlrule");
		$url_list=get_array($urlrule,"class","list");
		$url_show=get_array($urlrule,"class","show");
		$array=get_category($id);
		$this->ob_tree->tree(1);
		assign("model",$model_arr);
		assign("rs",$array);
		assign("catname",catname($array['parentid']));
		assign("template_cate",get_tem_file("cate"));
		assign("template_list",get_tem_file("list"));
		assign("template_show",get_tem_file("show"));
		assign("url_list",$url_list);
		assign("url_show",$url_show);
		
		template('category_edit','admin');
	}
	
	public function edit_save(){
		$config=base::load_cache("cache_set_config","_config");
		$catid=intval($_POST['catid']);
		$catname=safe_html($_POST['catname']);
		$catdir=safe_html($_POST['catdir']);
		$thumb=safe_html($_POST['thumb']);
		$is_link=intval($_POST['is_link']);
		$url=$_POST['url'];
		$sort=intval($_POST['sort']);
		$is_show=intval($_POST['is_show']);
		$parentid=intval($_POST['parentid']);
		$is_target=intval($_POST['is_target']);
		$is_html=intval($_POST['is_html']);
		$template_cate=safe_html($_POST['template_cate']);
		$template_list=safe_html($_POST['template_list']);
		$template_show=safe_html($_POST['template_show']);
		$url_list=intval($_POST['url_list']);
		$url_show=intval($_POST['url_show']);
		$seo_title=safe_html($_POST['seo_title']);
		$seo_key=safe_html($_POST['seo_key']);
		$seo_des=safe_html($_POST['seo_des']);
		$model=safe_html($_POST['model']);
		$pagesize=intval($_POST['pagesize']);
		$modelid=modelid($model);
		$power=addslashes(var_export($_POST['power'],true));
		
		if(empty($catname)||empty($catdir)||empty($catid)||empty($catid)){
			showmsg(C('material_not_complete'),'-1');
		}
		
		if(!check_str($catdir,'/^[a-z0-9][a-z0-9]*$/')){
			showmsg(C('catdir').C('numbers_and_letters'),'-1');
		}
		
		if($is_html==1){
			if($config['createhtml']!=1){
				showmsg(C('config_html_error'),'index.php?m=xdcms&c=setting');
			}
		}
		
		$nums=$this->mysql->db_num("category","catdir='".$catdir."' and catid!=".$catid);
		if($nums>0){
			showmsg(C('catdir_exist'),'-1');
		}
		
		//жĿǷݣģ
		$rs=$this->mysql->get_one("select catid,model from ".DB_PRE."category where `catid`=".$catid);
		if($rs['model']!=$model){
			$catnum=$this->mysql->db_num("content","catid=".$catid);
			if($catnum>0){
				showmsg(C('category_have_data'),'-1');
			}
		}
		
		if($is_link==0){   //url
			$ob_url=base::load_class("url");
			$url=$ob_url->caturl($catid,$catdir,$is_html,0,$url_list);
		}
		
		$this->mysql->db_update("category","`catname`='".$catname."',`catdir`='".$catdir."',`thumb`='".$thumb."',`is_link`='".$is_link."',`url`='".$url."',`sort`='".$sort."',`is_show`='".$is_show."',`is_target`='".$is_target."',`is_html`='".$is_html."',`parentid`='".$parentid."',`template_cate`='".$template_cate."',`template_list`='".$template_list."',`template_show`='".$template_show."',`url_list`='".$url_list."',`url_show`='".$url_show."',`seo_title`='".$seo_title."',`seo_key`='".$seo_key."',`seo_des`='".$seo_des."',`power`='".$power."',`model`='".$model."',`modelid`='".$modelid."',`pagesize`='".$pagesize."'","`catid`=".$catid);
		$this->category_cache();
		showmsg(C('update_success'),'index.php?m=xdcms&c=category');
	}
	
	public function sort_save(){
		$catid=$_POST['catid'];
		foreach($catid as $val){
			$sort=$_POST["sort{$val}"];
			if(is_numeric($sort)){
				$this->mysql->db_update("category","`sort`='".$sort."'","`catid`=".$val);
			}
		}
		$this->category_cache();
		showmsg(C('update_success'),'index.php?m=xdcms&c=category');
	}
	
	public function delete(){
		$id=isset($_GET['id'])?intval($_GET['id']):0;
		
		$num=$this->mysql->db_num("content","`catid`=".$id);
		if($num>0){
			showmsg(C('clear_data'),'-1');
		}
		unset($num);
		
		$num=$this->mysql->db_num("category","`parentid`=".$id);
		if($num>0){
			showmsg(C('delete_next_category'),'-1');
		}
		unset($num);
		
		$this->mysql->db_delete("category","`catid`=".$id);
		$this->category_cache();
		showmsg(C('delete_success'),'-1');
	}
	
	public function clear_data(){
		$id=isset($_GET['id'])?intval($_GET['id']):0;
		$num=$this->mysql->db_num("category","`parentid`=".$id);
		if($num>0){
			showmsg(C('clear_next_category'),'-1');
		}
		$rs=$this->mysql->get_one("select catid,model from ".DB_PRE."category where `catid`=".$id);
		$model=$rs['model'];
		unset($rs);
		$query=$this->mysql->query("select catid,contentid from ".DB_PRE."content where `catid`=".$id);
		while($rs=$this->mysql->fetch_rows($query)){
			$this->mysql->db_delete($model,"`contentid`=".$rs['contentid']);
		}
		$this->mysql->db_delete('content',"`catid`=".$id);
		showmsg(C('success'),'-1');
	}
	
	public function cache(){
		$this->category_cache();
		showmsg(C('update_success'),'-1');
	}
	
	public function category_cache(){
		$rs=$this->mysql->fetch_asc("select * from ".DB_PRE."category order by sort asc,catid asc");
		$s="<?php\n\$_category=".var_export($rs,true).";\n?>";
		$file=CACHE_SYS_PATH.'cache_category.php';
		creat_inc($file,$s);
		
		//ĿȨ޻
		$query=$this->mysql->query("select catid,power from ".DB_PRE."category");
		while($rs=$this->mysql->fetch_rows($query)){
			if(!empty($rs['power'])){
				$s="<?php\n\$_power=".html_decode($rs['power']).";\n?>";
				$file=CACHE_SYS_PATH.'cache_category_power_'.$rs['catid'].'.php';
				creat_inc($file,$s);
			}
		}
	}
}

?>