<?php
/**
 * Related Products
 */

global $product, $woocommerce_loop;

remove_action( 'woocommerce_before_shop_loop', 'woocommerce_catalog_ordering' );

$related = $product->get_related(); 

if ( sizeof($related) == 0 ) return;

$args = apply_filters('woocommerce_related_products_args', array(
	'post_type'				=> 'product',
	'ignore_sticky_posts'	=> 1,
	'no_found_rows' 		=> 1,
	'posts_per_page' 		=> $posts_per_page,
	'orderby' 				=> $orderby,
	'post__in' 				=> $related
) );

$products = new WP_Query( $args );

$woocommerce_loop['columns'] 	= $columns;

if ( $products->have_posts() ) : ?>

	<div class="related products">
	
		<!--<h2><?php _e('Related Products', 'woocommerce'); ?></h2-->
		
		<ul class="products <?php echo yiw_get_option( 'shop_products_style', 'ribbon' ); ?>">
			
			<?php while ( $products->have_posts() ) : $products->the_post(); ?>
		
				<?php woocommerce_get_template_part( 'content', 'product' ); ?>
	
			<?php endwhile; // end of the loop. ?>
				
		</ul>
		
	</div>
	
<?php endif; 

wp_reset_query();
