<?php
require_once 'include/common.inc.php';
require_once 'include/article.class.php';
require_once 'include/keywords.class.php';
session_start();
$name=$_GET["name"];
if(strpos($name,"http://")===0)
{
	header('HTTP/1.1 301 Moved Permanently');
	header("Location:".$name);
}
if(!preg_match("/^.{1,100}$/",$name))
{
	header("HTTP/1.1 404 Not Found");
	header("Status: 404 Not Found");
}

$uid = $_SESSION["adminid"];
$uid = (isset($uid) && is_numeric($uid)) ? $uid : 0;

$cururl = "http://".$_SERVER["HTTP_HOST"]. $_SERVER["REQUEST_URI"];
$article = null;
if($uid > 0)
{
	$article = $articledata->GetArticleByName($name,true);
}
else
{
	$article = $articledata->GetArticleByName($name,false);
}
if($article == null)
{
	header("HTTP/1.1 404 Not Found");
	header("Status: 404 Not Found");
}
$keywordsdata = new Keywords();
$keywordslist = $keywordsdata->GetKeywordsList();

$replacedarray = array();
$contentsource = $article->content;
$matchnum = 0;
if(count($keywordslist) > 0)
{
	foreach($keywordslist as $keywords)
	{	
		if(preg_match_all("/(<a[^>]+>.*?<\/a>)|(<img[^>]+>)|<strong>.*?<\/strong>|<h[1-6]>.*?<\/h[1-6]>/i",$contentsource,$matches,PREG_SET_ORDER))
		{	
			foreach($matches as $match)
			{
				$contentsource = str_replace($match[0],"<link>".$matchnum."</link>",$contentsource);
				$replacedarray[$matchnum] = $match[0];
				$matchnum++;
			}
		}
		if($keywords->url != $cururl)
		{
			$patterns = "/(?<!<link>)$keywords->name(?!<\/link>)/i";	
			$replacements = '<a href="'.$keywords->url.'">'.$keywords->name.'</a>';
			$contentsource = preg_replace($patterns,$replacements,$contentsource,1);
		}
		else
		{
			$patterns = "/(?<!<link>)$keywords->name(?!<\/link>)/i";
			$replacements = '<strong>'.$keywords->name.'</strong>';
			$contentsource = preg_replace($patterns,$replacements,$contentsource,1);
		}
	}
}
if(preg_match_all("/(?<=<link>)\d+(?=<\/link>)/",$contentsource,$matches,PREG_SET_ORDER))
{	
	foreach($matches as $match)
	{
		$contentsource = str_replace("<link>".$match[0]."</link>",$replacedarray[$match[0]],$contentsource);
	}
}

$article->content = $contentsource;

$tempinfo->assign("article",$article);

if(!$tempinfo->template_exists($article->templets))
{
    exit("没有找到合适的模板,请与管理员联系!");
}
$articledata->UpdateCount($article->aid);
$tempinfo->display($article->templets);

?>