<?php
require_once 'include/common.inc.php';
require_once 'include/product.class.php';
require_once 'include/keywords.class.php';
session_start();

$name=$_GET["name"];
if(strpos($name,"http://")===0)
{
	header('HTTP/1.1 301 Moved Permanently');
	header("Location:".$name);
}
if(!preg_match("/^.{1,100}$/",$name))
{
    header("HTTP/1.1 404 Not Found");
	header("Status: 404 Not Found");
}

$uid = $_SESSION["adminid"];
$uid = (isset($uid) && is_numeric($uid)) ? $uid : 0;
$product = null;
if($uid > 0)
{
	$product = $productdata->GetProductByName($name,true);
}
else
{
	$product = $productdata->GetProductByName($name,false);
}
if($product == null)
{
    header("HTTP/1.1 404 Not Found");
	header("Status: 404 Not Found");
}

$keywordsdata = new Keywords();
$keywordslist = $keywordsdata->GetKeywordsList();

$replacedarray = array();
$contentsource = $product->content;
$matchnum = 0;
if(count($keywordslist) > 0)
{
	foreach($keywordslist as $keywords)
	{	
		if(preg_match_all("/(<a[^>]+>.*?<\/a>)|(<img[^>]+>)|<strong>.*?<\/strong>|<h[1-6]>.*?<\/h[1-6]>/i",$contentsource,$matches,PREG_SET_ORDER))
		{	
			foreach($matches as $match)
			{
				$contentsource = str_replace($match[0],"<link>".$matchnum."</link>",$contentsource);
				$replacedarray[$matchnum] = $match[0];
				$matchnum++;
			}
		}
		if($keywords->url != $cururl)
		{
			$patterns = "/(?<!<link>)$keywords->name(?!<\/link>)/i";	
			$replacements = '<a href="'.$keywords->url.'">'.$keywords->name.'</a>';
			$contentsource = preg_replace($patterns,$replacements,$contentsource,1);
		}
		else
		{
			$patterns = "/(?<!<link>)$keywords->name(?!<\/link>)/i";
			$replacements = '<strong>'.$keywords->name.'</strong>';
			$contentsource = preg_replace($patterns,$replacements,$contentsource,1);
		}
	}
}
if(preg_match_all("/(?<=<link>)\d+(?=<\/link>)/",$contentsource,$matches,PREG_SET_ORDER))
{	
	foreach($matches as $match)
	{
		$contentsource = str_replace("<link>".$match[0]."</link>",$replacedarray[$match[0]],$contentsource);
	}
}

$product->content = $contentsource;

$tempinfo->assign("product",$product);

if(!$tempinfo->template_exists($product->templets))
{
    exit("没有找到合适的模板,请与管理员联系!");
}
$productdata->UpdateCount($product->pid);
$tempinfo->display($product->templets);
?>