<?php

/**
 * [SuperLin CMS] (C)2011-2099 Superlin.net
 * This is NOT a freeware, use is subject to license terms
 *
 * $Id: make_static.php 2012/9/10 LinJQ $
 */

!defined('PATH_ROOT') && exit('Forbidden');

class make_static
{
	/**
	 * makestatic:
	 * 0 - ɾ̬ҳ
	 * 1 - ֻɵҳģҳ
	 * 2 - ֻվҳҳģҳ
	 * 3 - ֻվҳҳģ顢ϸҳҳ
	 * 9 - վҳ
	 *
	 * statictype:
	 * 1 - .html, 2 - .htm, 3 - .shtml, 4 - .shtm, 0 - .php
	 */
	private static $instance;
    private static $makestatic = null; //ɾ̬ҳĿ
	private static $statictype = '.php'; //̬ҳ׺
	private static $statictypes = array(0=>'.php', 1=>'.html', 2=>'.htm', 3=>'.shtml', 4=>'.shtm', 5=>'.php');
	private static $staticfolder = null;

    public static function instance()
    {
        if (self::$instance === null)
        {
            self::$instance = new make_static();
			self::$makestatic = intval(config::get_one('makestatic'));
			self::$staticfolder = config::get_one('staticfolder');
			if ('/' == self::$staticfolder) self::$staticfolder = '';
			self::$statictype = self::statictype();
        }
        return self::$instance;
	}


	/**
     * ȡ̬ļչ
	 */
	public static function statictype()
	{
		$ftype = intval(config::get_one('statictype'));
		return self::$statictypes[$ftype];
	}


	/**
     * վҳ
	 * ··Ϊ /index.̬ҳչ
	 */
	public static function make_index()
	{
		self::instance();
		if (self::$makestatic != 9) return false;

		// ɸĿ¼µļ
		if ('.php' == self::$statictype)
		{
			$path = PATH_ROOT .'/default.php';
		}
		else
		{
			$path = PATH_ROOT .'/index'. self::$statictype;
		}
		$url = "/index.php?c=index";
		self::filewrite($path, $url, "wb+", 0);

		// ɾ̬ļ洢Ŀ¼µļ
		if ( (!empty(self::$staticfolder)) && ('.php' != self::$statictype) )
		{
			$path = PATH_ROOT . self::$staticfolder .'/index'. self::$statictype;
			self::filewrite($path, $url, "wb+", 0);
		}
	}


	/**
     * бҳ
	 *
	 * ҳ洢·Ϊ /̬ҳĿ¼/ǰĿ¼/index.̬ҳչ
	 * ఴ¼ҳ洢·Ϊ /̬ҳĿ¼/ǰĿ¼/index_X.̬ҳչ
	 * ఴݷҳ洢·Ϊ /̬ҳĿ¼/ǰĿ¼/YYYY.̬ҳչ
	 *
	 * @param string $method : write, del
	 * @param int $id
     */
	public static function article_category($method, $id)
	{
		self::instance();
		// ֤
		if (self::$makestatic != 9) return false;
		if (empty($method)) return false;

		// ȡҳϢ
		$id = intval($id);
		$rs = article_category::get_byid($id);
		if (!isset($rs['cate_id'])) return false;

		// Ŀ¼·
		$base_path = PATH_ROOT . self::$staticfolder .'/'. $rs['cate_ab'];
		$base_url = "/index.php?c=category&id={$id}";

		// ļ
		$method = strtolower($method);
		if ($method == 'write')
		{
			// ɷĬҳ
			$path = $base_path .'/index'. self::$statictype;
			self::filewrite($path, $base_url, "wb+", 0);

			// 1. ¼ҳʱɵļ
				// A: ȡܼ¼:
				$total = article_content::page_list($id, 1, 0, true);

				// B: ȡ÷ҳĿ
				if (empty($rs['page_num']) || $rs['page_num'] < 1) $rs['page_num'] = PAGE_ROWS;
				$pages = ceil($total/$rs['page_num']);

				// C: ѭɷҳҳ1ʼ
				for ($i = 0; $i < $pages; $i++)
				{
					$path = $base_path .'/index_'. ($i+1) . self::$statictype;
					$url = $base_url .'&start='. $i*$rs['page_num'];
					if (false == self::filewrite($path, $url, "wb+", 0)) break;
				}

			// 2. ݷҳʱɵļ
				// A: ȡʼ
				$startyear = intval(config::get_one('startyear'));
				$year = intval(date('Y'));
				if ($startyear < 1970 || $startyear > $year ) $startyear = $year;

				// B: ѭɸݷҳ
				for ($startyear; $startyear <= $year; $startyear++)
				{
					$path = $base_path .'/'. $startyear . self::$statictype;
					$url = $base_url .'&year='. $startyear;
					if (false == self::filewrite($path, $url, "wb+", 0)) break;
				}

			return true;
		}
		elseif ($method == 'del')
		{
			// ɾҳʱֱɾļ
			return file_helper::rm_recurse($base_path);
		}
		return false;
	}


	/**
     * ҳ
	 *
	 * ļ洢·Ϊ /̬ҳĿ¼/detail/YYYYMM/ID.̬ҳչ
	 *
	 * @param string $method : write, del
	 * @param int $id
     */
	public static function article_content($method, $id)
	{
		self::instance();
		// ֤
		if (self::$makestatic < 3) return false;
		if (empty($method)) return false;

		// ȡ
		$id = empty($id) ? 0 : intval($id);
		$rs = article_content::get_one($id);
		if (!isset($rs['article_id'])) return false;
		$create_time = (empty($rs['create_time'])) ? $rs['update_time'] : $rs['create_time'];

		// ļ·
		$path = PATH_ROOT . self::$staticfolder .'/detail/'. date('Ym', $create_time) .'/'. $id . self::$statictype;
		$url = "/index.php?c=article&id={$id}";

		// ļ
		$method = strtolower($method);
		switch($method)
		{
			case 'write' :
				return self::filewrite($path, $url, "wb+", 0);
				break;
			case 'del' :
				return file_helper::rm($path);
				break;
			default :
				return false;
				break;
		}
	}


	/**
     * ɵҳбҳ
	 *
	 * ļ洢·Ϊ /̬ҳĿ¼/ҳĿ¼/index.̬ҳչ
	 *
	 * @param string $method : write, del
	 * @param int $id
     */
	public static function page_category($method, $id)
	{
		self::instance();
		// ֤
		if (self::$makestatic < 1) return false;
		if (empty($method)) return false;

		// ȡҳϢ
		$rs = page_category::get_byid($id);
		if (!isset($rs['cate_id'])) return false;

		// ļ·
		$base_path = PATH_ROOT . self::$staticfolder .'/'. $rs['cate_ab'];
		$path = $base_path .'/index'. self::$statictype;
		$url = "/index.php?c=page_cate&id={$id}";

		// ļ
		$method = strtolower($method);
		switch($method)
		{
			case 'write' :
				return self::filewrite($path, $url, "wb+", 0);
				break;
			case 'del' :
				return file_helper::rm_recurse($base_path);
				break;
			default :
				return false;
				break;
		}
	}


	/**
     * ɵҳҳ
	 *
	 * ļ洢·Ϊ /̬ҳĿ¼/ҳĿ¼/ҳ.̬ҳչ
	 *
	 * @param string $method : write, del
	 * @param int $id
     */
	public static function page_content($method, $id)
	{
		self::instance();
		// ֤
		if (self::$makestatic < 1) return false;
		if (empty($method)) return false;

		// ȡҳϢ
		$rs = page_content::get_one($id);
		if (!isset($rs['page_id'])) return false;

		$cate = page_category::get_byid($rs['cate_id']);
		if (!isset($cate['cate_id'])) return false;

		// ļ·
		$path = PATH_ROOT . self::$staticfolder .'/'. $cate['cate_ab'] .'/'. $rs['page_name'] . self::$statictype;
		$url = "/index.php?c=page&id={$id}";

		// ļ
		$method = strtolower($method);
		switch($method)
		{
			case 'write' :
				return self::filewrite($path, $url, "wb+", 0);
				break;
			case 'del' :
				return file_helper::rm($path);
				break;
			default :
				return false;
				break;
		}
	}


	/**
     * Էҳ
	 *
	 * ļ洢·Ϊ /̬ҳĿ¼/feedback.̬ҳչ
	 *
	 * @param string $method : write, del
	 * @param int $id
     */
	public static function feedback($method)
	{
		self::instance();

		$path = PATH_ROOT . self::$staticfolder .'/feedback'. self::$statictype;
		$url = "/index.php?c=feedback";

		$method = strtolower($method);
		switch($method)
		{
			case 'write' :
				return self::filewrite($path, $url, "wb+", 0);
				break;
			case 'del' :
				return file_helper::rm($path);
				break;
			default :
				return false;
				break;
		}
	}


	/**
     * ɾ̬ļ
	 *
	 * @param string $output_path ·
	 * @param string $source_path Դַ
     */
	public static function filewrite($output_path, $source_path, $method = 'wb+', $iflock = 1, $check = 1, $chmod = 1)
	{
		$handle = fopen(HOST . $source_path, 'rb');
		$data = stream_get_contents($handle);
		fclose($handle);
		return file_helper::write($output_path, $data, $method, $iflock, $check, $chmod);
	}

}
