// Copyright (c) 2009, Baidu Inc. All rights reserved.
// 
// Licensed under the BSD License
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
// 
//      http:// tangram.baidu.com/license.html
// 
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS-IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.
 /**
 * @namespace T Tangramɰ
 * @name T
 * @version 1.6.0
*/

/**
 * baidu
 * @author: allstar, erik, meizz, berg
 */
var T,
    baidu = T = baidu || {version: "1.5.0"};
baidu.guid = "$BAIDU$";
baidu.$$ = window[baidu.guid] = window[baidu.guid] || {global:{}};

/**
 * ʹflashԴװһЩ
 * @namespace baidu.flash
 */
baidu.flash = baidu.flash || {};

/**
 * domķ
 * @namespace baidu.dom 
 */
baidu.dom = baidu.dom || {};


/**
 * ĵлȡָDOMԪ
 * @name baidu.dom.g
 * @function
 * @grammar baidu.dom.g(id)
 * @param {string|HTMLElement} id ԪصidDOMԪ.
 * @shortcut g,T.G
 * @meta standard
 * @see baidu.dom.q
 *
 * @return {HTMLElement|null} ȡԪأҲʱnull,Ϸֱӷز.
 */
baidu.dom.g = function(id) {
    if (!id) return null;
    if ('string' == typeof id || id instanceof String) {
        return document.getElementById(id);
    } else if (id.nodeName && (id.nodeType == 1 || id.nodeType == 9)) {
        return id;
    }
    return null;
};
baidu.g = baidu.G = baidu.dom.g;


/**
 * ķ
 * @namespace baidu.array
 */

baidu.array = baidu.array || {};


/**
 * Ԫ
 * @name baidu.array.each
 * @function
 * @grammar baidu.array.each(source, iterator[, thisObject])
 * @param {Array} source Ҫ
 * @param {Function} iterator ÿԪؽеõĺúһΪԪأڶΪֵfunction (item, index)
 * @param {Object} [thisObject] ʱthisָ룬ûд˲Ĭǵǰ
 * @remark
 * eachֶ֧Objectı,Objectıʹbaidu.object.each 
 * @shortcut each
 * @meta standard
 *             
 * @returns {Array} 
 */
 
baidu.each = baidu.array.forEach = baidu.array.each = function (source, iterator, thisObject) {
    var returnValue, item, i, len = source.length;
    
    if ('function' == typeof iterator) {
        for (i = 0; i < len; i++) {
            item = source[i];
            returnValue = iterator.call(thisObject || source, item, i);
    
            if (returnValue === false) {
                break;
            }
        }
    }
    return source;
};

/**
 * Բķװжϡģչ̳лԼԶ¼֧֡
 * @namespace baidu.lang
 */
baidu.lang = baidu.lang || {};


/**
 * жĿǷΪfunctionFunctionʵ
 * @name baidu.lang.isFunction
 * @function
 * @grammar baidu.lang.isFunction(source)
 * @param {Any} source Ŀ
 * @version 1.2
 * @see baidu.lang.isString,baidu.lang.isObject,baidu.lang.isNumber,baidu.lang.isArray,baidu.lang.isElement,baidu.lang.isBoolean,baidu.lang.isDate
 * @meta standard
 * @returns {boolean} жϽ
 */
baidu.lang.isFunction = function (source) {
    return '[object Function]' == Object.prototype.toString.call(source);
};

/**
 * жĿǷstringͻString
 * @name baidu.lang.isString
 * @function
 * @grammar baidu.lang.isString(source)
 * @param {Any} source Ŀ
 * @shortcut isString
 * @meta standard
 * @see baidu.lang.isObject,baidu.lang.isNumber,baidu.lang.isArray,baidu.lang.isElement,baidu.lang.isBoolean,baidu.lang.isDate
 *             
 * @returns {boolean} жϽ
 */
baidu.lang.isString = function (source) {
    return '[object String]' == Object.prototype.toString.call(source);
};
baidu.isString = baidu.lang.isString;


/**
 * жͺԵ
 * @namespace baidu.browser
 */
baidu.browser = baidu.browser || {};


/**
 * жǷΪopera
 * @property opera opera汾
 * @grammar baidu.browser.opera
 * @meta standard
 * @see baidu.browser.ie,baidu.browser.firefox,baidu.browser.safari,baidu.browser.chrome
 * @returns {Number} opera汾
 */

/**
 * opera 10ʼoperaַа汾ж
 * Browser identificationVersion + ֽа汾ʶ
 * operaֱ9.80
 */
baidu.browser.opera = /opera(\/| )(\d+(\.\d+)?)(.+?(version\/(\d+(\.\d+)?)))?/i.test(navigator.userAgent) ?  + ( RegExp["\x246"] || RegExp["\x242"] ) : undefined;


/**
 * ĿԪصָλòHTML
 * @name baidu.dom.insertHTML
 * @function
 * @grammar baidu.dom.insertHTML(element, position, html)
 * @param {HTMLElement|string} element ĿԪػĿԪصid
 * @param {string} position htmlλϢȡֵΪbeforeBegin,afterBegin,beforeEnd,afterEnd
 * @param {string} html Ҫhtml
 * @remark
 * 
 * positionСд<br>
 * ˼beforeBegin&lt;span&gt;afterBegin   this is span! beforeEnd&lt;/span&gt; afterEnd <br />
 * ⣬ʹñscriptǩHTMLַscriptǩӦĽűᱻִС
 * 
 * @shortcut insertHTML
 * @meta standard
 *             
 * @returns {HTMLElement} ĿԪ
 */
baidu.dom.insertHTML = function (element, position, html) {
    element = baidu.dom.g(element);
    var range,begin;
    if (element.insertAdjacentHTML && !baidu.browser.opera) {
        element.insertAdjacentHTML(position, html);
    } else {
        range = element.ownerDocument.createRange();
        position = position.toUpperCase();
        if (position == 'AFTERBEGIN' || position == 'BEFOREEND') {
            range.selectNodeContents(element);
            range.collapse(position == 'AFTERBEGIN');
        } else {
            begin = position == 'BEFOREBEGIN';
            range[begin ? 'setStartBefore' : 'setEndAfter'](element);
            range.collapse(begin);
        }
        range.insertNode(range.createContextualFragment(html));
    }
    return element;
};

baidu.insertHTML = baidu.dom.insertHTML;

/**
 * flashķflash󡢻ȡflashԼжflashİ汾
 * @namespace baidu.swf
 */
baidu.swf = baidu.swf || {};


/**
 * ֵ֧flash汾
 * @property version ֵ֧flash汾
 * @grammar baidu.swf.version
 * @return {String} 汾
 * @meta standard
 */
baidu.swf.version = (function () {
    var n = navigator;
    if (n.plugins && n.mimeTypes.length) {
        var plugin = n.plugins["Shockwave Flash"];
        if (plugin && plugin.description) {
            return plugin.description
                    .replace(/([a-zA-Z]|\s)+/, "")
                    .replace(/(\s)+r/, ".") + ".0";
        }
    } else if (window.ActiveXObject && !window.opera) {
        for (var i = 12; i >= 2; i--) {
            try {
                var c = new ActiveXObject('ShockwaveFlash.ShockwaveFlash.' + i);
                if (c) {
                    var version = c.GetVariable("$version");
                    return version.replace(/WIN/g,'').replace(/,/g,'.');
                }
            } catch(e) {}
        }
    }
})();

/**
 * ַķ
 * @namespace baidu.string
 */
baidu.string = baidu.string || {};


/**
 * Ŀַhtml
 * @name baidu.string.encodeHTML
 * @function
 * @grammar baidu.string.encodeHTML(source)
 * @param {string} source Ŀַ
 * @remark
 * ַ5&<>"'
 * @shortcut encodeHTML
 * @meta standard
 * @see baidu.string.decodeHTML
 *             
 * @returns {string} htmlַ
 */
baidu.string.encodeHTML = function (source) {
    return String(source)
                .replace(/&/g,'&amp;')
                .replace(/</g,'&lt;')
                .replace(/>/g,'&gt;')
                .replace(/"/g, "&quot;")
                .replace(/'/g, "&#39;");
};

baidu.encodeHTML = baidu.string.encodeHTML;

/**
 * flashhtmlַ
 * @name baidu.swf.createHTML
 * @function
 * @grammar baidu.swf.createHTML(options)
 * 
 * @param {Object} 	options 					flashѡ
 * @param {string} 	options.id 					Ҫflashıʶ
 * @param {string} 	options.url 				flashļurl
 * @param {String} 	options.errorMessage 		δװflash playerflash player汾Źʱʾ
 * @param {string} 	options.ver 				Ҫflash player汾
 * @param {string} 	options.width 				flashĿ
 * @param {string} 	options.height 				flashĸ߶
 * @param {string} 	options.align 				flashĶ뷽ʽֵmiddle/left/right/top/bottom
 * @param {string} 	options.base 				ڽswfļе·ĻĿ¼URL
 * @param {string} 	options.bgcolor 			swfļıɫ
 * @param {string} 	options.salign 				ŵswfļwidthheightöڵλáֵl/r/t/b/tl/tr/bl/br
 * @param {boolean} options.menu 				ǷʾҼ˵ֵtrue/false
 * @param {boolean} options.loop 				ŵһ֡ʱǷ²ţֵ true/false
 * @param {boolean} options.play 				flashǷʱͿʼšֵtrue/false
 * @param {string} 	options.quality 			flashŵĻʣֵlow/medium/high/autolow/autohigh/best
 * @param {string} 	options.scale 				flashӦõĿߡֵshowall/noborder/exactfit
 * @param {string} 	options.wmode 				flashʾģʽֵwindow/opaque/transparent
 * @param {string} 	options.allowscriptaccess 	flashҳͨȨޡֵalways/never/sameDomain
 * @param {string} 	options.allownetworking 	swfļʹõAPIֵall/internal/none
 * @param {boolean} options.allowfullscreen 	Ƿflashȫֵtrue/false
 * @param {boolean} options.seamlesstabbing 	ִ޷񣬴ӶʹûflashӦó򡣸òֻڰװFlash7߰汾Windowsʹáֵtrue/false
 * @param {boolean} options.devicefont 			þ̬ıǷ豸ֵ֡true/false
 * @param {boolean} options.swliveconnect 		һμflashʱǷӦJavaֵtrue/false
 * @param {Object} 	options.vars 				ҪݸflashĲ֧JSONstring͡
 * 
 * @see baidu.swf.create
 * @meta standard
 * @returns {string} flashhtmlַ
 */
baidu.swf.createHTML = function (options) {
    options = options || {};
    var version = baidu.swf.version, 
        needVersion = options['ver'] || '6.0.0', 
        vUnit1, vUnit2, i, k, len, item, tmpOpt = {},
        encodeHTML = baidu.string.encodeHTML;
    for (k in options) {
        tmpOpt[k] = options[k];
    }
    options = tmpOpt;
    if (version) {
        version = version.split('.');
        needVersion = needVersion.split('.');
        for (i = 0; i < 3; i++) {
            vUnit1 = parseInt(version[i], 10);
            vUnit2 = parseInt(needVersion[i], 10);
            if (vUnit2 < vUnit1) {
                break;
            } else if (vUnit2 > vUnit1) {
                return '';
            }
        }
    } else {
        return '';
    }
    
    var vars = options['vars'],
        objProperties = ['classid', 'codebase', 'id', 'width', 'height', 'align'];
    options['align'] = options['align'] || 'middle';
    options['classid'] = 'clsid:d27cdb6e-ae6d-11cf-96b8-444553540000';
    options['codebase'] = 'http://fpdownload.macromedia.com/pub/shockwave/cabs/flash/swflash.cab#version=6,0,0,0';
    options['movie'] = options['url'] || '';
    delete options['vars'];
    delete options['url'];
    if ('string' == typeof vars) {
        options['flashvars'] = vars;
    } else {
        var fvars = [];
        for (k in vars) {
            item = vars[k];
            fvars.push(k + "=" + encodeURIComponent(item));
        }
        options['flashvars'] = fvars.join('&');
    }
    var str = ['<object '];
    for (i = 0, len = objProperties.length; i < len; i++) {
        item = objProperties[i];
        str.push(' ', item, '="', encodeHTML(options[item]), '"');
    }
    str.push('>');
    var params = {
        'wmode'             : 1,
        'scale'             : 1,
        'quality'           : 1,
        'play'              : 1,
        'loop'              : 1,
        'menu'              : 1,
        'salign'            : 1,
        'bgcolor'           : 1,
        'base'              : 1,
        'allowscriptaccess' : 1,
        'allownetworking'   : 1,
        'allowfullscreen'   : 1,
        'seamlesstabbing'   : 1,
        'devicefont'        : 1,
        'swliveconnect'     : 1,
        'flashvars'         : 1,
        'movie'             : 1
    };
    
    for (k in options) {
        item = options[k];
        k = k.toLowerCase();
        if (params[k] && (item || item === false || item === 0)) {
            str.push('<param name="' + k + '" value="' + encodeHTML(item) + '" />');
        }
    }
    options['src']  = options['movie'];
    options['name'] = options['id'];
    delete options['id'];
    delete options['movie'];
    delete options['classid'];
    delete options['codebase'];
    options['type'] = 'application/x-shockwave-flash';
    options['pluginspage'] = 'http://www.macromedia.com/go/getflashplayer';
    str.push('<embed');
    var salign;
    for (k in options) {
        item = options[k];
        if (item || item === false || item === 0) {
            if ((new RegExp("^salign\x24", "i")).test(k)) {
                salign = item;
                continue;
            }
            
            str.push(' ', k, '="', encodeHTML(item), '"');
        }
    }
    
    if (salign) {
        str.push(' salign="', encodeHTML(salign), '"');
    }
    str.push('></embed></object>');
    
    return str.join('');
};


/**
 * ҳдһflash
 * @name baidu.swf.create
 * @function
 * @grammar baidu.swf.create(options[, container])
 * 
 * @param {Object} 	options 					flashѡ
 * @param {string} 	options.id 					Ҫflashıʶ
 * @param {string} 	options.url 				flashļurl
 * @param {String} 	options.errorMessage 		δװflash playerflash player汾Źʱʾ
 * @param {string} 	options.ver 				Ҫflash player汾
 * @param {string} 	options.width 				flashĿ
 * @param {string} 	options.height 				flashĸ߶
 * @param {string} 	options.align 				flashĶ뷽ʽֵmiddle/left/right/top/bottom
 * @param {string} 	options.base 				ڽswfļе·ĻĿ¼URL
 * @param {string} 	options.bgcolor 			swfļıɫ
 * @param {string} 	options.salign 				ŵswfļwidthheightöڵλáֵl/r/t/b/tl/tr/bl/br
 * @param {boolean} options.menu 				ǷʾҼ˵ֵtrue/false
 * @param {boolean} options.loop 				ŵһ֡ʱǷ²ţֵ true/false
 * @param {boolean} options.play 				flashǷʱͿʼšֵtrue/false
 * @param {string} 	options.quality 			flashŵĻʣֵlow/medium/high/autolow/autohigh/best
 * @param {string} 	options.scale 				flashӦõĿߡֵshowall/noborder/exactfit
 * @param {string} 	options.wmode 				flashʾģʽֵwindow/opaque/transparent
 * @param {string} 	options.allowscriptaccess 	flashҳͨȨޡֵalways/never/sameDomain
 * @param {string} 	options.allownetworking 	swfļʹõAPIֵall/internal/none
 * @param {boolean} options.allowfullscreen 	Ƿflashȫֵtrue/false
 * @param {boolean} options.seamlesstabbing 	ִ޷񣬴ӶʹûflashӦó򡣸òֻڰװFlash7߰汾Windowsʹáֵtrue/false
 * @param {boolean} options.devicefont 			þ̬ıǷ豸ֵ֡true/false
 * @param {boolean} options.swliveconnect 		һμflashʱǷӦJavaֵtrue/false
 * @param {Object} 	options.vars 				ҪݸflashĲ֧JSONstring͡
 * 
 * @param {HTMLElement|string} [container] 		flashĸԪأݸòʱڵǰλôflash
 * @meta standard
 * @see baidu.swf.createHTML,baidu.swf.getMovie
 */
baidu.swf.create = function (options, target) {
    options = options || {};
    var html = baidu.swf.createHTML(options) 
               || options['errorMessage'] 
               || '';
                
    if (target && 'string' == typeof target) {
        target = document.getElementById(target);
    }
    baidu.dom.insertHTML( target || document.body ,'beforeEnd',html );
};
/**
 * жǷΪie
 * @name baidu.browser.ie
 * @field
 * @grammar baidu.browser.ie
 * @returns {Number} IE汾
 */
baidu.browser.ie = baidu.ie = /msie (\d+\.\d+)/i.test(navigator.userAgent) ? (document.documentMode || + RegExp['\x241']) : undefined;

/**
 * Ƴе
 * @name baidu.array.remove
 * @function
 * @grammar baidu.array.remove(source, match)
 * @param {Array} source ҪƳ
 * @param {Any} match ҪƳ
 * @meta standard
 * @see baidu.array.removeAt
 *             
 * @returns {Array} Ƴ
 */
baidu.array.remove = function (source, match) {
    var len = source.length;
        
    while (len--) {
        if (len in source && source[len] === match) {
            source.splice(len, 1);
        }
    }
    return source;
};

/**
 * жĿǷArray
 * @name baidu.lang.isArray
 * @function
 * @grammar baidu.lang.isArray(source)
 * @param {Any} source Ŀ
 * @meta standard
 * @see baidu.lang.isString,baidu.lang.isObject,baidu.lang.isNumber,baidu.lang.isElement,baidu.lang.isBoolean,baidu.lang.isDate
 *             
 * @returns {boolean} жϽ
 */
baidu.lang.isArray = function (source) {
    return '[object Array]' == Object.prototype.toString.call(source);
};



/**
 * һתarray
 * @name baidu.lang.toArray
 * @function
 * @grammar baidu.lang.toArray(source)
 * @param {mix} source Ҫתarrayı
 * @version 1.3
 * @meta standard
 * @returns {array} תarray
 */
baidu.lang.toArray = function (source) {
    if (source === null || source === undefined)
        return [];
    if (baidu.lang.isArray(source))
        return source;
    if (typeof source.length !== 'number' || typeof source === 'string' || baidu.lang.isFunction(source)) {
        return [source];
    }
    if (source.item) {
        var l = source.length, array = new Array(l);
        while (l--)
            array[l] = source[l];
        return array;
    }

    return [].slice.call(source);
};

/**
 * flashʵ
 * @name baidu.swf.getMovie
 * @function
 * @grammar baidu.swf.getMovie(name)
 * @param {string} name flash
 * @see baidu.swf.create
 * @meta standard
 * @returns {HTMLElement} flashʵ
 */
baidu.swf.getMovie = function (name) {
	var movie = document[name], ret;
    return baidu.browser.ie == 9 ?
    	movie && movie.length ? 
    		(ret = baidu.array.remove(baidu.lang.toArray(movie),function(item){
    			return item.tagName.toLowerCase() != "embed";
    		})).length == 1 ? ret[0] : ret
    		: movie
    	: movie || window[name];
};


baidu.flash._Base = (function(){
   
    var prefix = 'bd__flash__';

    /**
     * һַ
     * @private
     * @return {String}
     */
    function _createString(){
        return  prefix + Math.floor(Math.random() * 2147483648).toString(36);
    };
   
    /**
     * flash״̬
     * @private
     * @param {Object} target flash
     * @return {Boolean}
     */
    function _checkReady(target){
        if(typeof target !== 'undefined' && typeof target.flashInit !== 'undefined' && target.flashInit()){
            return true;
        }else{
            return false;
        }
    };

    /**
     * ֮ǰѹջĺ
     * @private
     * @param {Array} callQueue ö
     * @param {Object} target flash
     * @return {Null}
     */
    function _callFn(callQueue, target){
        var result = null;
        
        callQueue = callQueue.reverse();
        baidu.each(callQueue, function(item){
            result = target.call(item.fnName, item.params);
            item.callBack(result);
        });
    };

    /**
     * Ϊ
     * @private
     * @param {String|Function} fun ߺ
     * @return {String}
     */
    function _createFunName(fun){
        var name = '';

        if(baidu.lang.isFunction(fun)){
            name = _createString();
            window[name] = function(){
                fun.apply(window, arguments);
            };

            return name;
        }else if(baidu.lang.isString){
            return fun;
        }
    };

    /**
     * flash
     * @private
     * @param {Object} options 
     * @return {Object} 
     */
    function _render(options){
        if(!options.id){
            options.id = _createString();
        }
        
        var container = options.container || '';
        delete(options.container);
        
        baidu.swf.create(options, container);
        
        return baidu.swf.getMovie(options.id);
    };

    return function(options, callBack){
        var me = this,
            autoRender = (typeof options.autoRender !== 'undefined' ? options.autoRender : true),
            createOptions = options.createOptions || {},
            target = null,
            isReady = false,
            callQueue = [],
            timeHandle = null,
            callBack = callBack || [];

        /**
         * flashļƵҳ
         * @public
         * @return {Null}
         */
        me.render = function(){
            target = _render(createOptions);
            
            if(callBack.length > 0){
                baidu.each(callBack, function(funName, index){
                    callBack[index] = _createFunName(options[funName] || new Function());
                });    
            }
            me.call('setJSFuncName', [callBack]);
        };

        /**
         * flash״̬
         * @return {Boolean}
         */
        me.isReady = function(){
            return isReady;
        };

        /**
         * flashӿڵͳһ
         * @param {String} fnName õĺ
         * @param {Array} params Ĳɵ,Ҫ贫
         * @param {Function} [callBack] 첽ú󽫷ֵΪĵûص޷ֵԲ˲
         * @return {Null}
        */
        me.call = function(fnName, params, callBack){
            if(!fnName) return null;
            callBack = callBack || new Function();
    
            var result = null;
    
            if(isReady){
                result = target.call(fnName, params);
                callBack(result);
            }else{
                callQueue.push({
                    fnName: fnName,
                    params: params,
                    callBack: callBack
                });
    
                (!timeHandle) && (timeHandle = setInterval(_check, 200));
            }
        };
    
        /**
         * Ϊ
         * @public
         * @param {String|Function} fun ߺ
         * @return {String}
         */
        me.createFunName = function(fun){
            return _createFunName(fun);    
        };

        /**
         * flashǷready е
         * @private
         * @return {Null}
         */
        function _check(){
            if(_checkReady(target)){
                clearInterval(timeHandle);
                timeHandle = null;
                _call();

                isReady = true;
            }               
        };

        /**
         * ֮ǰѹջĺ
         * @private
         * @return {Null}
         */
        function _call(){
            _callFn(callQueue, target);
            callQueue = [];
        }

        autoRender && me.render(); 
    };
})();



/**
 * flash based imageUploader
 * @class
 * @grammar baidu.flash.imageUploader(options)
 * @param {Object} createOptions flashʱҪĲbaidu.swf.createĵ
 * @config {Object} vars imageUploaderʱҪĲ
 * @config {Number} vars.gridWidth ÿһԤͼƬռĿȣӦΪflash
 * @config {Number} vars.gridHeight ÿһԤͼƬռĸ߶ȣӦΪflashߵ
 * @config {Number} vars.picWidth ԤͼƬĿ
 * @config {Number} vars.picHeight ԤͼƬĸ߶
 * @config {String} vars.uploadDataFieldName POSTͼƬݵkey,Ĭֵ'picdata'
 * @config {String} vars.picDescFieldName POSTͼƬkey,Ĭֵ'picDesc'
 * @config {Number} vars.maxSize ļ,λ'MB'
 * @config {Number} vars.compressSize ϴǰͼƬֵѹ
 * @config {Number} vars.maxNum:32 ϴٸļ
 * @config {Number} vars.compressLength ֵܽܵ߳ȱѹ
 * @config {String} vars.url ϴurlַ
 * @config {Number} vars.mode mode == 0ʱʹùmode == 1ʱflash, ĬֵΪ0
 * @see baidu.swf.createHTML
 * @param {String} backgroundUrl ͼƬ·
 * @param {String} listBacgroundkUrl ֿؼ
 * @param {String} buttonUrl ťͼƬ
 * @param {String|Function} selectFileCallback ѡļĻص
 * @param {String|Function} exceedFileCallbackļƵʱĻص
 * @param {String|Function} deleteFileCallback ɾļĻص
 * @param {String|Function} startUploadCallback ʼϴĳļʱĻص
 * @param {String|Function} uploadCompleteCallback ĳļϴɵĻص
 * @param {String|Function} uploadErrorCallback ĳļϴʧܵĻص
 * @param {String|Function} allCompleteCallback ȫϴʱĻص
 * @param {String|Function} changeFlashHeight ıFlashĸ߶ȣmode==1ʱ
 */ 
baidu.flash.imageUploader = baidu.flash.imageUploader || function(options){
   
    var me = this,
        options = options || {},
        _flash = new baidu.flash._Base(options, [
            'selectFileCallback', 
            'exceedFileCallback', 
            'deleteFileCallback', 
            'startUploadCallback',
            'uploadCompleteCallback',
            'uploadErrorCallback',
            'allCompleteCallback',
            'changeFlashHeight'
        ]);
    /**
     * ʼظϴͼƬ
     * @public
     * @return {Null}
     */
    me.upload = function(){
        _flash.call('upload');
    };

    /**
     * ͣϴͼƬ
     * @public
     * @return {Null}
     */
    me.pause = function(){
        _flash.call('pause');
    };
};

/**
 * ԭķ
 * @namespace baidu.object
 */
baidu.object = baidu.object || {};


/**
 * ԴԿĿ
 * @author erik
 * @name baidu.object.extend
 * @function
 * @grammar baidu.object.extend(target, source)
 * @param {Object} target Ŀ
 * @param {Object} source Դ
 * @see baidu.array.merge
 * @remark
 * 
1.ĿУԴkeyͬĳԱᱻǡ<br>
2.ԴprototypeԱ´
		
 * @shortcut extend
 * @meta standard
 *             
 * @returns {Object} Ŀ
 */
baidu.extend =
baidu.object.extend = function (target, source) {
    for (var p in source) {
        if (source.hasOwnProperty(p)) {
            target[p] = source[p];
        }
    }
    
    return target;
};





/**
 * flash based fileUploader
 * @class
 * @grammar baidu.flash.fileUploader(options)
 * @param {Object} options
 * @config {Object} createOptions flashʱҪĲbaidu.swf.createĵ
 * @config {String} createOptions.width
 * @config {String} createOptions.height
 * @config {Number} maxNum ѡļ
 * @config {Function|String} selectFile
 * @config {Function|String} exceedMaxSize
 * @config {Function|String} deleteFile
 * @config {Function|String} uploadStart
 * @config {Function|String} uploadComplete
 * @config {Function|String} uploadError
 * @config {Function|String} uploadProgress
 */
baidu.flash.fileUploader = baidu.flash.fileUploader || function(options){
    var me = this,
        options = options || {};
    
    options.createOptions = baidu.extend({
        wmod: 'transparent'
    },options.createOptions || {});
    
    var _flash = new baidu.flash._Base(options, [
        'selectFile',
        'exceedMaxSize',
        'deleteFile',
        'uploadStart',
        'uploadComplete',
        'uploadError', 
        'uploadProgress'
    ]);

    _flash.call('setMaxNum', options.maxNum ? [options.maxNum] : [1]);

    /**
     * õƶflashʱǷ
     * @public
     * @param {Boolean} isCursor
     * @return {Null}
     */
    me.setHandCursor = function(isCursor){
        _flash.call('setHandCursor', [isCursor || false]);
    };

    /**
     * Ӧ
     * @param {String|Function} fun
     */
    me.setMSFunName = function(fun){
        _flash.call('setMSFunName',[_flash.createFunName(fun)]);
    }; 

    /**
     * ִϴ
     * @param {String} url ϴurl
     * @param {String} fieldName ϴıֶ
     * @param {Object} postData ֵԣϴPOST
     * @param {Number|Array|null|-1} [index]ϴļ
     *                            Intֵϴļ
     *                            Arrayһδϴļ
     *                            -1/nullϴļ
     * @return {Null}
     */
    me.upload = function(url, fieldName, postData, index){

        if(typeof url !== 'string' || typeof fieldName !== 'string') return null;
        if(typeof index === 'undefined') index = -1;

        _flash.call('upload', [url, fieldName, postData, index]);
    };

    /**
     * ȡϴ
     * @public
     * @param {Number|-1} index
     */
    me.cancel = function(index){
        if(typeof index === 'undefined') index = -1;
        _flash.call('cancel', [index]);
    };

    /**
     * ɾļ
     * @public
     * @param {Number|Array} [index] Ҫɾindexȫɾ
     * @param {Function} callBack
     * @param 
     * */
    me.deleteFile = function(index, callBack){

        var callBackAll = function(list){
                callBack && callBack(list);
            };

        if(typeof index === 'undefined'){
            _flash.call('deleteFilesAll', [], callBackAll);
            return;
        };
        
        if(typeof index === 'Number') index = [index];
        index.sort(function(a,b){
            return b-a;
        });
        baidu.each(index, function(item){
            _flash.call('deleteFileBy', item, callBackAll);
        });
    };

    /**
     * ļ֧ͣmacType
     * @public
     * @param {Object|Array[Object]} type {description:String, extention:String}
     * @return {Null};
     */
    me.addFileType = function(type){
        var type = type || [[]];
        
        if(type instanceof Array) type = [type];
        else type = [[type]];
        _flash.call('addFileTypes', type);
    };
    
    /**
     * ļ֧ͣmacType
     * @public
     * @param {Object|Array[Object]} type {description:String, extention:String}
     * @return {Null};
     */
    me.setFileType = function(type){
        var type = type || [[]];
        
        if(type instanceof Array) type = [type];
        else type = [[type]];
        _flash.call('setFileTypes', type);
    };

    /**
     * ÿѡļ
     * @public
     * @param {Number} num
     * @return {Null}
     */
    me.setMaxNum = function(num){
        _flash.call('setMaxNum', [num]);
    };

    /**
     * ÿѡļСƣMΪλ
     * @public
     * @param {Number} num,0Ϊ
     * @return {Null}
     */
    me.setMaxSize = function(num){
        _flash.call('setMaxSize', [num]);
    };

    /**
     * @public
     */
    me.getFileAll = function(callBack){
        _flash.call('getFileAll', [], callBack);
    };

    /**
     * @public
     * @param {Number} index
     * @param {Function} [callBack]
     */
    me.getFileByIndex = function(index, callBack){
        _flash.call('getFileByIndex', [], callBack);
    };

    /**
     * @public
     * @param {Number} index
     * @param {function} [callBack]
     */
    me.getStatusByIndex = function(index, callBack){
        _flash.call('getStatusByIndex', [], callBack);
    };
};

/**
 * ʹö̬scriptǩԴɷ˵Ļص˵Ļص
 * @namespace baidu.sio
 */
baidu.sio = baidu.sio || {};

/**
 * 
 * @param {HTMLElement} src scriptڵ
 * @param {String} url scriptڵĵַ
 * @param {String} [charset] 
 */
baidu.sio._createScriptTag = function(scr, url, charset){
    scr.setAttribute('type', 'text/javascript');
    charset && scr.setAttribute('charset', charset);
    scr.setAttribute('src', url);
    document.getElementsByTagName('head')[0].appendChild(scr);
};

/**
 * ɾscriptԣɾscriptǩԽ޸ڴй©
 * 
 * @param {HTMLElement} src scriptڵ
 */
baidu.sio._removeScriptTag = function(scr){
    if (scr.clearAttributes) {
        scr.clearAttributes();
    } else {
        for (var attr in scr) {
            if (scr.hasOwnProperty(attr)) {
                delete scr[attr];
            }
        }
    }
    if(scr && scr.parentNode){
        scr.parentNode.removeChild(scr);
    }
    scr = null;
};


/**
 * ͨscriptǩݣ˴ص
 * @name baidu.sio.callByBrowser
 * @function
 * @grammar baidu.sio.callByBrowser(url, opt_callback, opt_options)
 * @param {string} url ݵurl
 * @param {Function|string} opt_callback ݼؽʱõĺ
 * @param {Object} opt_options ѡ
 * @config {String} [charset] scriptַ
 * @config {Integer} [timeOut] ʱʱ䣬ʱ佫Ӧ󣬲onfailure
 * @config {Function} [onfailure] timeOut趨Чﳬʱʱʱ
 * @remark
 * 1callByServerͬcallbackֻ֧Function֧ͣstring
 * 2һڵҳ棬callbackIE/operaҲᱻãʹҪonsuccessжǷȷء
 * @meta standard
 * @see baidu.sio.callByServer
 */
baidu.sio.callByBrowser = function (url, opt_callback, opt_options) {
    var scr = document.createElement("SCRIPT"),
        scriptLoaded = 0,
        options = opt_options || {},
        charset = options['charset'],
        callback = opt_callback || function(){},
        timeOut = options['timeOut'] || 0,
        timer;
    scr.onload = scr.onreadystatechange = function () {
        if (scriptLoaded) {
            return;
        }
        
        var readyState = scr.readyState;
        if ('undefined' == typeof readyState
            || readyState == "loaded"
            || readyState == "complete") {
            scriptLoaded = 1;
            try {
                callback();
                clearTimeout(timer);
            } finally {
                scr.onload = scr.onreadystatechange = null;
                baidu.sio._removeScriptTag(scr);
            }
        }
    };

    if( timeOut ){
        timer = setTimeout(function(){
            scr.onload = scr.onreadystatechange = null;
            baidu.sio._removeScriptTag(scr);
            options.onfailure && options.onfailure();
        }, timeOut);
    }
    
    baidu.sio._createScriptTag(scr, url, charset);
};

/**
 * ͨscriptǩݣɷ˴ص
 * @name baidu.sio.callByServer
 * @function
 * @grammar baidu.sio.callByServer(url, callback[, opt_options])
 * @param {string} url ݵurl.
 * @param {Function|string} callback ˵õĺûָURLѰoptions['queryField']Ϊcallbackķ.
 * @param {Object} opt_options ʱѡ.
 * @config {string} [charset] scriptַ
 * @config {string} [queryField] callbackֶĬΪcallback
 * @config {Integer} [timeOut] ʱʱ(λms)ʱ佫Ӧ󣬲onfailure
 * @config {Function} [onfailure] timeOut趨Чﳬʱʱʱ
 * @remark
 * urlѾkeyΪoptions['queryField']queryᱻ滻callbackвݻԶɵĺ
 * @meta standard
 * @see baidu.sio.callByBrowser
 */
baidu.sio.callByServer = /**@function*/function(url, callback, opt_options) {
    var scr = document.createElement('SCRIPT'),
        prefix = 'bd__cbs__',
        callbackName,
        callbackImpl,
        options = opt_options || {},
        charset = options['charset'],
        queryField = options['queryField'] || 'callback',
        timeOut = options['timeOut'] || 0,
        timer,
        reg = new RegExp('(\\?|&)' + queryField + '=([^&]*)'),
        matches;

    if (baidu.lang.isFunction(callback)) {
        callbackName = prefix + Math.floor(Math.random() * 2147483648).toString(36);
        window[callbackName] = getCallBack(0);
    } else if(baidu.lang.isString(callback)){
        callbackName = callback;
    } else {
        if (matches = reg.exec(url)) {
            callbackName = matches[2];
        }
    }

    if( timeOut ){
        timer = setTimeout(getCallBack(1), timeOut);
    }
    url = url.replace(reg, '\x241' + queryField + '=' + callbackName);
    
    if (url.search(reg) < 0) {
        url += (url.indexOf('?') < 0 ? '?' : '&') + queryField + '=' + callbackName;
    }
    baidu.sio._createScriptTag(scr, url, charset);

    /*
     * һwindowϣ߳ʱsetTimeoutУʱִ
     */
    function getCallBack(onTimeOut){
        /*global callbackName, callback, scr, options;*/
        return function(){
            try {
                if( onTimeOut ){
                    options.onfailure && options.onfailure();
                }else{
                    callback.apply(window, arguments);
                    clearTimeout(timer);
                }
                window[callbackName] = null;
                delete window[callbackName];
            } catch (exception) {
            } finally {
                baidu.sio._removeScriptTag(scr);
            }
        }
    }
};

/**
 * ͨһͼƬķʽ洢һ־
 * @function
 * @grammar baidu.sio.log(url)
 * @param {string} url Ҫ͵ĵַ.
 * @author: int08h,leeight
 */
baidu.sio.log = function(url) {
  var img = new Image(),
      key = 'tangram_sio_log_' + Math.floor(Math.random() *
            2147483648).toString(36);
  window[key] = img;

  img.onload = img.onerror = img.onabort = function() {
    img.onload = img.onerror = img.onabort = null;

    window[key] = null;
    img = null;
  };
  img.src = url;
};

