<?php
$sql= "
DROP TABLE IF EXISTS `{$prefix}user`;
CREATE TABLE IF NOT EXISTS `{$prefix}user` (
  `id` smallint(5) unsigned NOT NULL auto_increment,
  `account` varchar(64) NOT NULL,
  `nickname` varchar(50) NOT NULL,
  `password` char(32) NOT NULL,
  `bind_account` varchar(50) default NULL,
  `last_login_time` int(11) unsigned default '0',
  `last_login_ip` varchar(40) default NULL,
  `login_count` mediumint(8) unsigned default '0',
  `verify` varchar(32) default NULL,
  `tel` varchar(25) default NULL,
  `qq` varchar(25) default NULL,
  `email` varchar(50) default NULL,
  `truename` varchar(25) default NULL,
  `idcard` varchar(55) default NULL,
  `address` varchar(200) default NULL,
  `postcode` varchar(16) default NULL,
  `hint` varchar(60) default NULL,
  `answer` varchar(60) default NULL,
  `remark` varchar(255) default NULL,
  `create_time` int(11) unsigned default NULL,
  `update_time` int(11) unsigned default NULL,
  `status` tinyint(1) default '0',
  `type_id` tinyint(2) unsigned default '0',
  `info` text,
  PRIMARY KEY  (`id`),
  UNIQUE KEY `account` (`account`)
) ENGINE=MyISAM  DEFAULT CHARSET=utf8 AUTO_INCREMENT=56 ;

INSERT INTO `{$prefix}user` (`id`, `account`, `nickname`, `password`, `bind_account`, `last_login_time`, `last_login_ip`, `login_count`, `verify`, `tel`, `qq`, `email`, `truename`, `idcard`, `address`, `postcode`, `hint`, `answer`, `remark`, `create_time`, `update_time`, `status`, `type_id`, `info`) VALUES
(1, 'admin', '管理员', '21232f297a57a5a743894a0e4a801fc3', '', 1324454742, '127.0.0.1', 971, '8888', NULL, '', 'algerwo@hotmail.com', NULL, '', NULL, '', '', '', '备注信息编辑资料', 1222907803, 1316155208, 1, 0, '');


DROP TABLE IF EXISTS `{$prefix}tagged`;
CREATE TABLE IF NOT EXISTS `{$prefix}tagged` (
  `id` int(11) unsigned NOT NULL AUTO_INCREMENT,
  `userId` int(11) unsigned NOT NULL,
  `recordId` int(11) unsigned NOT NULL,
  `tagId` int(11) NOT NULL,
  `tagTime` int(11) NOT NULL,
  `module` varchar(25) NOT NULL,
  PRIMARY KEY (`id`),
  KEY `module` (`module`)
) ENGINE=MyISAM  DEFAULT CHARSET=utf8 AUTO_INCREMENT=60 ;


DROP TABLE IF EXISTS `{$prefix}tag`;
CREATE TABLE IF NOT EXISTS `{$prefix}tag` (
  `id` int(11) unsigned NOT NULL AUTO_INCREMENT,
  `name` varchar(255) NOT NULL,
  `count` mediumint(6) unsigned NOT NULL,
  `module` varchar(100) NOT NULL,
  PRIMARY KEY (`id`),
  KEY `name` (`name`),
  KEY `module` (`module`),
  KEY `count` (`count`)
) ENGINE=MyISAM  DEFAULT CHARSET=utf8 AUTO_INCREMENT=34 ;


DROP TABLE IF EXISTS `{$prefix}role_user`;
CREATE TABLE IF NOT EXISTS `{$prefix}role_user` (
  `role_id` mediumint(9) unsigned DEFAULT NULL,
  `user_id` char(32) DEFAULT NULL,
  KEY `group_id` (`role_id`),
  KEY `user_id` (`user_id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

INSERT INTO `{$prefix}role_user` (`role_id`, `user_id`) VALUES
(4, '27'),
(4, '26'),
(4, '30'),
(5, '31'),
(3, '22'),
(3, '1'),
(1, '4'),
(2, '2'),
(7, '2'),
(2, '3'),
(3, '35'),
(3, '41');


DROP TABLE IF EXISTS `{$prefix}role`;
CREATE TABLE IF NOT EXISTS `{$prefix}role` (
  `id` smallint(6) unsigned NOT NULL AUTO_INCREMENT,
  `name` varchar(20) NOT NULL,
  `pid` smallint(6) DEFAULT NULL,
  `status` tinyint(1) unsigned DEFAULT NULL,
  `remark` varchar(255) DEFAULT NULL,
  `ename` varchar(5) DEFAULT NULL,
  `create_time` int(11) unsigned NOT NULL,
  `update_time` int(11) unsigned NOT NULL,
  PRIMARY KEY (`id`),
  KEY `parentId` (`pid`),
  KEY `ename` (`ename`),
  KEY `status` (`status`)
) ENGINE=MyISAM  DEFAULT CHARSET=utf8 AUTO_INCREMENT=8 ;

INSERT INTO `{$prefix}role` (`id`, `name`, `pid`, `status`, `remark`, `ename`, `create_time`, `update_time`) VALUES
(1, '领导组', 0, 1, '', '', 1208784792, 1254325558),
(2, '员工组', 0, 1, '', '', 1215496283, 1254325566),
(7, '演示组', 0, 1, '', NULL, 1254325787, 0);


DROP TABLE IF EXISTS `{$prefix}product`;
CREATE TABLE IF NOT EXISTS `{$prefix}product` (
  `id` int(11) unsigned NOT NULL AUTO_INCREMENT,
  `userId` mediumint(5) unsigned NOT NULL DEFAULT '0',
  `procategoryId` mediumint(5) unsigned DEFAULT NULL,
  `title` varchar(200) NOT NULL,
  `savepath` varchar(55) NOT NULL,
  `attachpath` varchar(55) NOT NULL,
  `attachment` varchar(50) NOT NULL,
  `attachthumb` varchar(50) NOT NULL,
  `content` longtext,
  `cTime` int(11) unsigned NOT NULL DEFAULT '0',
  `mTime` int(11) unsigned NOT NULL DEFAULT '0',
  `status` tinyint(1) unsigned NOT NULL DEFAULT '0',
  `readCount` mediumint(5) unsigned NOT NULL DEFAULT '0',
  `commentCount` mediumint(5) unsigned NOT NULL DEFAULT '0',
  `tags` varchar(100) NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=MyISAM  DEFAULT CHARSET=utf8 AUTO_INCREMENT=24 ;


DROP TABLE IF EXISTS `{$prefix}procategory`;
CREATE TABLE IF NOT EXISTS `{$prefix}procategory` (
  `id` mediumint(5) unsigned NOT NULL AUTO_INCREMENT,
  `name` varchar(30) NOT NULL DEFAULT '',
  `title` varchar(50) NOT NULL DEFAULT '',
  `pid` int(11) DEFAULT NULL,
  `path` varchar(200) DEFAULT NULL,
  `remark` varchar(255) NOT NULL DEFAULT '',
  `status` tinyint(1) unsigned NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`)
) ENGINE=MyISAM  DEFAULT CHARSET=utf8 AUTO_INCREMENT=8 ;


DROP TABLE IF EXISTS `{$prefix}node`;
CREATE TABLE IF NOT EXISTS `{$prefix}node` (
  `id` smallint(6) unsigned NOT NULL AUTO_INCREMENT,
  `name` varchar(20) NOT NULL,
  `title` varchar(50) DEFAULT NULL,
  `status` tinyint(1) DEFAULT '0',
  `remark` varchar(255) DEFAULT NULL,
  `sort` smallint(6) unsigned DEFAULT NULL,
  `pid` smallint(6) unsigned NOT NULL,
  `level` tinyint(1) unsigned NOT NULL,
  `type` tinyint(1) NOT NULL DEFAULT '0',
  `group_id` tinyint(3) unsigned DEFAULT '0',
  PRIMARY KEY (`id`),
  KEY `level` (`level`),
  KEY `pid` (`pid`),
  KEY `status` (`status`),
  KEY `name` (`name`)
) ENGINE=MyISAM  DEFAULT CHARSET=utf8 AUTO_INCREMENT=93 ;


INSERT INTO `{$prefix}node` (`id`, `name`, `title`, `status`, `remark`, `sort`, `pid`, `level`, `type`, `group_id`) VALUES
(49, 'read', '查看', 1, '', NULL, 30, 3, 0, 0),
(40, 'Index', '默认模块', 1, '', 1, 1, 2, 0, 0),
(39, 'index', '列表', 1, '', NULL, 30, 3, 0, 0),
(37, 'resume', '恢复', 1, '', NULL, 30, 3, 0, 0),
(36, 'forbid', '禁用', 1, '', NULL, 30, 3, 0, 0),
(35, 'foreverdelete', '删除', 1, '', NULL, 30, 3, 0, 0),
(34, 'update', '更新', 1, '', NULL, 30, 3, 0, 0),
(33, 'edit', '编辑', 1, '', NULL, 30, 3, 0, 0),
(32, 'insert', '写入', 1, '', NULL, 30, 3, 0, 0),
(31, 'add', '新增', 1, '', NULL, 30, 3, 0, 0),
(30, 'Public', '公共模块', 1, '', 2, 1, 2, 0, 0),
(69, 'Messages', '留言管理', 1, '', 8, 1, 2, 0, 2),
(7, 'User', '后台用户', 1, '', 11, 1, 2, 0, 6),
(6, 'Role', '角色管理', 1, '', 10, 1, 2, 0, 6),
(2, 'Node', '节点管理', 1, '', 9, 1, 2, 0, 6),
(1, 'Rbac', 'Rbac后台管理', 1, '', 1, 0, 1, 0, 6),
(50, 'main', '空白首页', 1, '', NULL, 40, 3, 0, 0),
(83, 'Links', '友情链接管理', 1, '', 7, 1, 2, 0, 2),
(84, 'Product', '产品管理', 1, NULL, 5, 1, 2, 0, 2),
(85, 'Down', '文档下载', 1, '', 6, 1, 2, 0, 2),
(86, 'Article', '文章管理', 1, NULL, 3, 1, 2, 0, 2),
(87, 'Procategory', '产品目录', 1, '', 4, 1, 2, 0, 2),
(88, 'Category', '文章目录', 1, '', 2, 1, 2, 0, 2),
(89, 'FrameAdmin', '框架管理', 1, '框架管理', NULL, 0, 1, 0, 0),
(90, 'Aboutus', '公司介绍', 1, '公司介绍管理', 1, 1, 2, 0, 2);



DROP TABLE IF EXISTS `{$prefix}messages`;
CREATE TABLE IF NOT EXISTS `{$prefix}messages` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `yname` varchar(17) COLLATE utf8_unicode_ci NOT NULL,
  `tel` varchar(17) COLLATE utf8_unicode_ci DEFAULT NULL,
  `email` varchar(30) COLLATE utf8_unicode_ci DEFAULT NULL,
  `ip` varchar(20) COLLATE utf8_unicode_ci DEFAULT NULL,
  `title` varchar(150) COLLATE utf8_unicode_ci NOT NULL,
  `content` longtext COLLATE utf8_unicode_ci,
  `utime` varchar(30) COLLATE utf8_unicode_ci DEFAULT NULL,
  `hidden` tinyint(3) NOT NULL DEFAULT '0',
  `review` mediumtext COLLATE utf8_unicode_ci,
  `rtime` varchar(30) COLLATE utf8_unicode_ci DEFAULT NULL,
  `islock` tinyint(3) NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`)
) ENGINE=MyISAM  DEFAULT CHARSET=utf8 AUTO_INCREMENT=9 ;

DROP TABLE IF EXISTS `{$prefix}member_groups`;
CREATE TABLE IF NOT EXISTS `{$prefix}member_groups` (
  `id` mediumint(6) NOT NULL AUTO_INCREMENT,
  `groups_id` mediumint(5) NOT NULL,
  `member_id` mediumint(5) NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=MyISAM  DEFAULT CHARSET=utf8 AUTO_INCREMENT=61 ;


DROP TABLE IF EXISTS `{$prefix}member`;
CREATE TABLE IF NOT EXISTS `{$prefix}member` (
  `id` mediumint(6) NOT NULL AUTO_INCREMENT,
  `name` varchar(25) NOT NULL,
  `dept_id` smallint(3) NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=MyISAM  DEFAULT CHARSET=utf8 AUTO_INCREMENT=20 ;

DROP TABLE IF EXISTS `{$prefix}links`;
CREATE TABLE IF NOT EXISTS `{$prefix}links` (
  `id` int(11) unsigned NOT NULL AUTO_INCREMENT,
  `name` varchar(15) NOT NULL DEFAULT '',
  `categoryId` smallint(5) unsigned NOT NULL,
  `title` varchar(255) NOT NULL DEFAULT '',
  `content` longtext,
  `url` varchar(255) NOT NULL,
  `status` tinyint(1) unsigned NOT NULL DEFAULT '0',
  `readCount` mediumint(5) unsigned NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`)
) ENGINE=MyISAM  DEFAULT CHARSET=utf8 AUTO_INCREMENT=13 ;

DROP TABLE IF EXISTS `{$prefix}groups`;
CREATE TABLE IF NOT EXISTS `{$prefix}groups` (
  `id` mediumint(6) NOT NULL auto_increment,
  `name` varchar(50) NOT NULL,
  PRIMARY KEY  (`id`)
) ENGINE=MyISAM  DEFAULT CHARSET=utf8 AUTO_INCREMENT=4 ;

INSERT INTO `{$prefix}groups` (`id`, `name`) VALUES
(1, '项目组1'),
(2, '项目组2'),
(3, '项目组3');


DROP TABLE IF EXISTS `{$prefix}group`;
CREATE TABLE IF NOT EXISTS `{$prefix}group` (
  `id` smallint(3) unsigned NOT NULL auto_increment,
  `name` varchar(25) NOT NULL,
  `title` varchar(50) NOT NULL,
  `create_time` int(11) unsigned NOT NULL,
  `update_time` int(11) unsigned NOT NULL default '0',
  `status` tinyint(1) unsigned NOT NULL default '0',
  `sort` smallint(3) unsigned NOT NULL default '0',
  `show` tinyint(1) unsigned NOT NULL default '0',
  PRIMARY KEY  (`id`)
) ENGINE=MyISAM  DEFAULT CHARSET=utf8 AUTO_INCREMENT=7 ;

INSERT INTO `{$prefix}group` (`id`, `name`, `title`, `create_time`, `update_time`, `status`, `sort`, `show`) VALUES
(2, 'App', '应用中心', 1222841259, 0, 1, 0, 0),
(6, 'App', '系统管理', 1222841259, 0, 1, 0, 0);


DROP TABLE IF EXISTS `{$prefix}down`;
CREATE TABLE IF NOT EXISTS `{$prefix}down` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `title` varchar(255) NOT NULL,
  `content` text,
  `attachpath` varchar(200) NOT NULL,
  `savepath` varchar(66) NOT NULL,
  `attachment` varchar(50) NOT NULL,
  `attachthumb` varchar(50) NOT NULL,
  `uploadTime` int(11) NOT NULL,
  `downCount` mediumint(9) unsigned DEFAULT '0',
  `downloadTime` int(12) NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=MyISAM  DEFAULT CHARSET=utf8 AUTO_INCREMENT=23 ;

DROP TABLE IF EXISTS `{$prefix}comment`;
CREATE TABLE IF NOT EXISTS `{$prefix}comment` (
  `id` mediumint(5) unsigned NOT NULL AUTO_INCREMENT,
  `recordId` int(11) unsigned NOT NULL DEFAULT '0',
  `author` varchar(50) NOT NULL DEFAULT '',
  `email` varchar(255) NOT NULL DEFAULT '',
  `url` varchar(255) NOT NULL DEFAULT '',
  `ip` varchar(25) NOT NULL DEFAULT '',
  `content` text NOT NULL,
  `cTime` int(11) unsigned NOT NULL DEFAULT '0',
  `agent` varchar(255) DEFAULT NULL,
  `status` tinyint(1) unsigned NOT NULL DEFAULT '0',
  `module` varchar(50) NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=MyISAM  DEFAULT CHARSET=utf8 AUTO_INCREMENT=16 ;

DROP TABLE IF EXISTS `{$prefix}category`;
CREATE TABLE IF NOT EXISTS `{$prefix}category` (
  `id` mediumint(5) unsigned NOT NULL AUTO_INCREMENT,
  `name` varchar(30) NOT NULL DEFAULT '',
  `title` varchar(50) NOT NULL DEFAULT '',
  `pid` int(11) NOT NULL,
  `path` varchar(200) NOT NULL,
  `remark` varchar(255) NOT NULL DEFAULT '',
  `status` tinyint(1) unsigned NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`)
) ENGINE=MyISAM  DEFAULT CHARSET=utf8 AUTO_INCREMENT=17 ;

DROP TABLE IF EXISTS `{$prefix}blogcategory`;
CREATE TABLE IF NOT EXISTS `{$prefix}blogcategory` (
  `id` mediumint(5) unsigned NOT NULL AUTO_INCREMENT,
  `name` varchar(30) NOT NULL DEFAULT '',
  `title` varchar(50) NOT NULL DEFAULT '',
  `remark` varchar(255) NOT NULL DEFAULT '',
  `status` tinyint(1) unsigned NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`)
) ENGINE=MyISAM  DEFAULT CHARSET=utf8 AUTO_INCREMENT=11 ;

DROP TABLE IF EXISTS `{$prefix}blog`;
CREATE TABLE IF NOT EXISTS `{$prefix}blog` (
  `id` int(11) unsigned NOT NULL AUTO_INCREMENT,
  `name` varchar(15) NOT NULL DEFAULT '',
  `userId` mediumint(5) unsigned NOT NULL DEFAULT '0',
  `blogcategoryId` smallint(5) unsigned NOT NULL,
  `title` varchar(255) NOT NULL DEFAULT '',
  `content` longtext,
  `cTime` int(11) unsigned NOT NULL DEFAULT '0',
  `mTime` int(11) unsigned NOT NULL DEFAULT '0',
  `status` tinyint(1) unsigned NOT NULL DEFAULT '0',
  `readCount` mediumint(5) unsigned NOT NULL DEFAULT '0',
  `commentCount` mediumint(5) unsigned NOT NULL DEFAULT '0',
  `tags` varchar(100) NOT NULL,
  PRIMARY KEY (`id`)

) ENGINE=MyISAM  DEFAULT CHARSET=utf8 AUTO_INCREMENT=9 ;


DROP TABLE IF EXISTS `{$prefix}attach`;
CREATE TABLE IF NOT EXISTS `{$prefix}attach` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `name` varchar(255) NOT NULL,
  `type` varchar(255) DEFAULT NULL,
  `size` varchar(20) NOT NULL,
  `extension` varchar(20) NOT NULL,
  `savepath` varchar(255) NOT NULL,
  `savename` varchar(255) NOT NULL,
  `module` varchar(100) NOT NULL,
  `recordId` int(11) NOT NULL,
  `userId` int(11) unsigned DEFAULT NULL,
  `uploadTime` int(11) unsigned DEFAULT NULL,
  `downCount` mediumint(9) unsigned DEFAULT '0',
  `hash` varchar(32) NOT NULL,
  `verify` varchar(8) NOT NULL,
  `remark` varchar(255) DEFAULT NULL,
  `version` mediumint(6) unsigned NOT NULL DEFAULT '0',
  `updateTime` int(12) unsigned DEFAULT NULL,
  `downloadTime` int(11) unsigned NOT NULL,
  PRIMARY KEY (`id`),
  KEY `module` (`module`),
  KEY `recordId` (`recordId`),
  KEY `userId` (`userId`)
) ENGINE=MyISAM  DEFAULT CHARSET=utf8 AUTO_INCREMENT=30 ;



DROP TABLE IF EXISTS `{$prefix}article`;
CREATE TABLE IF NOT EXISTS `{$prefix}article` (
  `id` int(11) unsigned NOT NULL AUTO_INCREMENT,
  `name` varchar(15) NOT NULL DEFAULT '',
  `userId` mediumint(5) unsigned NOT NULL DEFAULT '0',
  `categoryId` smallint(5) unsigned NOT NULL,
  `title` varchar(255) NOT NULL DEFAULT '',
  `content` longtext,
  `cTime` int(11) unsigned NOT NULL DEFAULT '0',
  `mTime` int(11) unsigned NOT NULL DEFAULT '0',
  `status` tinyint(1) unsigned NOT NULL DEFAULT '0',
  `readCount` mediumint(5) unsigned NOT NULL DEFAULT '0',
  `commentCount` mediumint(5) unsigned NOT NULL DEFAULT '0',
  `tags` varchar(100) NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=MyISAM  DEFAULT CHARSET=utf8 AUTO_INCREMENT=10 ;



DROP TABLE IF EXISTS `{$prefix}access`;
CREATE TABLE IF NOT EXISTS `{$prefix}access` (
  `role_id` smallint(6) unsigned NOT NULL,
  `node_id` smallint(6) unsigned NOT NULL,
  `level` tinyint(1) NOT NULL,
  `pid` smallint(6) NOT NULL,
  `module` varchar(50) DEFAULT NULL,
  KEY `groupId` (`role_id`),
  KEY `nodeId` (`node_id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

INSERT INTO `{$prefix}access` (`role_id`, `node_id`, `level`, `pid`, `module`) VALUES
(2, 1, 1, 0, NULL),
(2, 40, 2, 1, NULL),
(2, 30, 2, 1, NULL),
(3, 1, 1, 0, NULL),
(2, 69, 2, 1, NULL),
(2, 50, 3, 40, NULL),
(3, 50, 3, 40, NULL),
(1, 50, 3, 40, NULL),
(3, 7, 2, 1, NULL),
(3, 39, 3, 30, NULL),
(2, 39, 3, 30, NULL),
(2, 49, 3, 30, NULL),
(4, 1, 1, 0, NULL),
(4, 2, 2, 1, NULL),
(4, 3, 2, 1, NULL),
(4, 4, 2, 1, NULL),
(4, 5, 2, 1, NULL),
(4, 6, 2, 1, NULL),
(4, 7, 2, 1, NULL),
(4, 11, 2, 1, NULL),
(5, 25, 1, 0, NULL),
(5, 51, 2, 25, NULL),
(1, 1, 1, 0, NULL),
(1, 39, 3, 30, NULL),
(1, 69, 2, 1, NULL),
(1, 30, 2, 1, NULL),
(1, 40, 2, 1, NULL),
(1, 49, 3, 30, NULL),
(3, 69, 2, 1, NULL),
(3, 30, 2, 1, NULL),
(3, 40, 2, 1, NULL),
(1, 37, 3, 30, NULL),
(1, 36, 3, 30, NULL),
(1, 35, 3, 30, NULL),
(1, 34, 3, 30, NULL),
(1, 33, 3, 30, NULL),
(1, 32, 3, 30, NULL),
(1, 31, 3, 30, NULL),
(2, 32, 3, 30, NULL),
(2, 31, 3, 30, NULL),
(7, 1, 1, 0, NULL),
(7, 2, 2, 1, NULL),
(7, 69, 2, 1, NULL),
(7, 30, 2, 1, NULL),
(7, 50, 3, 40, NULL),
(7, 39, 3, 30, NULL),
(7, 49, 3, 30, NULL),
(7, 40, 2, 1, NULL),
(7, 83, 2, 1, NULL),
(7, 84, 2, 1, NULL),
(7, 85, 2, 1, NULL),
(7, 86, 2, 1, NULL),
(7, 87, 2, 1, NULL),
(7, 89, 1, 0, NULL);



DROP TABLE IF EXISTS `{$prefix}aboutus`;
CREATE TABLE IF NOT EXISTS `{$prefix}aboutus` (
  `id` int(11) unsigned NOT NULL AUTO_INCREMENT,
  `name` varchar(15) NOT NULL DEFAULT '',
  `userId` mediumint(5) unsigned NOT NULL DEFAULT '0',
  `displayId` smallint(5) unsigned NOT NULL,
  `title` varchar(255) NOT NULL DEFAULT '',
  `content` longtext,
  `cTime` int(11) unsigned NOT NULL DEFAULT '0',
  `mTime` int(11) unsigned NOT NULL DEFAULT '0',
  `status` tinyint(1) unsigned NOT NULL DEFAULT '0',
  `readCount` mediumint(5) unsigned NOT NULL DEFAULT '0',
  `tags` varchar(100) NOT NULL,
  PRIMARY KEY  (`id`)
) ENGINE=MyISAM  DEFAULT CHARSET=utf8 AUTO_INCREMENT=12 ;


"
?>