
/**
 * 提供列表翻页、动态组合参数搜索、创建编辑区等功能
 * @author linliuwei
 */
var ListTable = new Object();
ListTable.url = _initUrl();
ListTable.params = _initParams(); //初始化参数

/**
 * 在列表中创建一个可编辑区
 * @param obj	表单元素
 * @param url   提交地址
 * @param params  数据，格式key=value用&符号分隔
 * 实例：ListTable.edit(this,'/demo/edit.htm','comId=114&memberId=');
 */
ListTable.edit = function (obj, url, params) {
	var tagName = obj.firstChild.tagName;
	if (tagName && tagName.toLowerCase() == "input") {
		return;
	}
	var nodeName = obj.nodeName;

	obj = $(obj);
	org = $.trim(obj.html().replace(/\n/g, "")); //保存原始的内容
	
	//创建一个输入框
	text = $("<input/>");
	text.val(org);
	if (nodeName.toLowerCase() == "span") {
		text.css("width", (obj.innerWidth() + 4) + "px");
		text.css("height", obj.innerHeight() + "px");
	}else{
		text.css("width", (obj.innerWidth() - 8) + "px");
		text.css("height", (obj.innerHeight() - 10) + "px");
	}
 	
	//清空原先的内容，将输入框加入到对象中
	obj.empty();
	obj.append(text);
	text.focus();
	text.bind("keypress", function (event) {
		if (event.keyCode == 13) {
			text.blur();
			return false;
		}
		if (event.keyCode == 27) {
			obj.html(org);
		}
	});
	text.bind("blur", function (event) {
		value = $.trim(text.val());
		if (value == org) {
			obj.html(org);
			return;
		}
		if (value.length > 0) {
			$.ajax({
				type:"post", 
				url:url, 
				cache:false, 
				data:params + value, 
				dataType:"json", 
				success:function (response) {
					if(response.tip == "editSuccess"){
						alert(response.msg);
						obj.html(value);
						var clazz=obj.attr("class");
						if(clazz != null && clazz != '' && clazz != undefined){
							$("."+clazz).html(value);//同时更改其它地方同样的信息
						}
					}else{
						alert(response.msg);
						obj.html(org);
					}
				}
			});
		} else {
			obj.html(org);
		}
	});
};

function _initUrl(){
	var url = location.href;
	url = url.lastIndexOf("?") == -1 ? url.substring((url.lastIndexOf("/")) + 1) : url.substring((url.lastIndexOf("/")) + 1, url.lastIndexOf("?"));
	if(url.lastIndexOf(".htm") != -1){
		url = url.substring(0, url.lastIndexOf("."));
		url += ".do";
	}
	//alert(url);
	return url;
}
function _initParams() {
	var startIndex = location.href.lastIndexOf("?");
	var endIndex = location.href.length;
	// 默认打开ajax选项
	var params = {ajax:true};
	if (startIndex != -1) {
		var tmps = location.href.substring(startIndex + 1, endIndex).split("&");
		$.each(tmps, function (i, n) {
			v = n.split("=");
			params[v[0]] = v[1];
		});
		if (!params.pageNo) {
			params.pageNo = 1;
		}
		if (!params.pageSize) {
			var ps = Util.getCookie(ListTable.pageSizeCookieKey);
			params.pageSize = ps == "" ? 15 : ps;
		}
	}
	return params;
}
 
$(function(){
	//在搜索框为空时清空参数
	if (document.getElementById("keyword")) {
		$("#keyword").bind("blur", function () {
			if ($.trim($("#keyword").val()) == "") {
				ListTable.params["keyword"] = "";
			}
		});
	}
	$("#listTable tr").live("mouseover", function(){
		if($(this).attr("name") && $(this).attr("name").indexOf("userSuggest") != -1){
			
		}else{
			 $(this).find("td").css("backgroundColor","#FFFAE3"); 
		}
	});
	
	$("#listTable tr").live("mouseout", function(){
		// 菜单固定项的底色不是白色
		if($(this).attr("name") && $(this).attr("name").indexOf("menuTrtrue") != -1){
			$(this).find("td").css("backgroundColor","#DDEFFF");
		}else{
			$(this).find("td").css("backgroundColor","#FFFFFF");
		}
	});
});