<?php

/**
 *    支付宝支付方式插件
 *
 *    @author    Garbin
 *    @usage    none
 */
class AlipayplatPayment extends BasePayment {
    /* 支付宝网关地址（新） */

    var $_gateway = 'https://mapi.alipay.com/gateway.do';
    var $_code = 'alipayplat';

    
    /**
     *    获取支付表单
     *
     *    @author    Garbin
     *    @param     array $order_info  待支付的订单信息，必须包含总费用及唯一外部交易号
     *    @return    array
     */
    function get_payform($order_info) {

        $this->_config['alipayplat_partner'] = '2088801541835115';
        $this->_config['alipayplat_key'] = 'o9i5594vj1y3ykdm9ropvnq2dreczpi0';

        /*
          306116666@qq.com
          合作者身份（PID）：
          2088311102150767
          安全校验码（Key）：(仅需选择一种与PID匹配使用)
          默认加密方式
          c58y7vj2exw5qf4v0eo7ebkqketye675


          支付宝平台商即时到帐
          1479903550@qq.com
          2088801541835115
          o9i5594vj1y3ykdm9ropvnq2dreczpi0
         * 
         * 
         */
        $sql = "SELECT * FROM ecm_order where order_sn=" . $this->_get_trade_sn($order_info);
        $rows = mysql_query($sql);
        $row = mysql_fetch_assoc($rows);
        $payment_id = $row["payment_id"];
        $sql = "SELECT * FROM ecm_payment where payment_id=" . $payment_id;
        $rows = mysql_query($sql);
        $row = mysql_fetch_assoc($rows);
        $json_string = $row["config"];
        $hello = explode('"', $json_string);
        $zhifubao = $hello[3];
        $zhifubao = $this->_config['alipayplat_account'];
        $fenzhang = $order_info['order_amount'] - $order_info['order_amount'] * 0.012;

        $fenzhang = number_format($fenzhang, "2");


        $params = array(
            /* 基本信息 */
            'service' => 'create_direct_pay_by_user',
            'partner' => $this->_config['alipayplat_partner'],
            '_input_charset' => CHARSET,
            'notify_url' => $this->_create_notify_url($order_info['order_id']),
            'return_url' => $this->_create_return_url($order_info['order_id']),
            /* 业务参数 */
            'subject' => $this->_get_subject($order_info),
            //订单ID由不属签名验证的一部分，所以有可能被客户自行修改，所以在接收网关通知时要验证指定的订单ID的外部交易号是否与网关传过来的一致
            'out_trade_no' => $this->_get_trade_sn($order_info),
            'price' => $order_info['order_amount'], //应付总价
            'quantity' => 1,
            'payment_type' => 1,
            /* 物流参数 */
//            'logistics_type'    => 'EXPRESS',
//            'logistics_fee'     => 0,
//            'logistics_payment' => 'BUYER_PAY_AFTER_RECEIVE',
            'royalty_type' => 10,
            'royalty_parameters' => $zhifubao . '^' . $fenzhang . '^fen',
            /* 买卖双方信息 */
//            'seller_email'      => $this->_config['alipayplat_account']
            'seller_email' => '1479903550@qq.com',
        );

        $params['sign'] = $this->_get_sign($params);
        $params['sign_type'] = 'MD5';

        return $this->_create_payform('GET', $params);
    }

    /**
     *    返回通知结果
     *
     *    @author    Garbin
     *    @param     array $order_info
     *    @param     bool  $strict
     *    @return    array
     */
    function verify_notify($order_info, $strict = false) {
        
        $this->_config['alipayplat_partner'] = '2088801541835115';
        $this->_config['alipayplat_key'] = 'o9i5594vj1y3ykdm9ropvnq2dreczpi0';
        
        
        if (empty($order_info)) {
            $this->_error('order_info_empty');

            return false;
        }

        /* 初始化所需数据 */
        $notify = $this->_get_notify();

        /* 验证来路是否可信 */
        if ($strict) {
            /* 严格验证 */
            $verify_result = $this->_query_notify($notify['notify_id']);
            if (!$verify_result) {
                /* 来路不可信 */
                $this->_error('notify_unauthentic');

                return false;
            }
        }

        /* 验证通知是否可信 */
        $sign_result = $this->_verify_sign($notify);
        if (!$sign_result) {
            /* 若本地签名与网关签名不一致，说明签名不可信 */
            $this->_error('sign_inconsistent');

            return false;
        }

        /* ----------通知验证结束---------- */

        /* ----------本地验证开始---------- */
        /* 验证与本地信息是否匹配 */
        /* 这里不只是付款通知，有可能是发货通知，确认收货通知 */

        if ($order_info['out_trade_sn'] != $notify['out_trade_no']) {
            /* 通知中的订单与欲改变的订单不一致 */
            $this->_error('order_inconsistent');

            return false;
        }
        if ($order_info['order_amount'] != $notify['total_fee']) {
            /* 支付的金额与实际金额不一致 */
            $this->_error('price_inconsistent');

            return false;
        }
        
        if($order_info['status'] != ORDER_SHIPPED){
            $this->_error('undefined_status');
                return false;
        }
        
        //至此，说明通知是可信的，订单也是对应的，可信的

        /* 按通知结果返回相应的结果 */
        switch ($notify['trade_status']) {
            case 'WAIT_SELLER_SEND_GOODS':      //买家已付款，等待卖家发货

                $order_status = ORDER_ACCEPTED;
                break;

            case 'WAIT_BUYER_CONFIRM_GOODS':    //卖家已发货，等待买家确认

                $order_status = ORDER_SHIPPED;
                break;

            case 'TRADE_FINISHED':              //交易结束
            case 'TRADE_SUCCESS':               // 交易成功
                if ($order_info['status'] == ORDER_PENDING) {
                    /* 如果是等待付款中，则说明是即时到账交易，这时将状态改为已付款 */
                    $order_status = ORDER_ACCEPTED;
                } else {
                    /* 说明是第三方担保交易，交易结束 */
                    $order_status = ORDER_FINISHED;
                }
                break;
            case 'TRADE_CLOSED':                //交易关闭
                $order_status = ORDER_CANCLED;
                break;

            default:
                $this->_error('undefined_status');
                return false;
                break;
        }

        switch ($notify['refund_status']) {
            case 'REFUND_SUCCESS':              //退款成功，取消订单
                $order_status = ORDER_CANCLED;
                break;
        }

        return array(
            'target' => $order_status,
        );
    }

    /**
     *    查询通知是否有效
     *
     *    @author    Garbin
     *    @param     string $notify_id
     *    @return    string
     */
    function _query_notify($notify_id) {
        /* 支付宝通知地址（新） */
        $query_url = "https://mapi.alipay.com/gateway.do?service=notify_verify&partner={$this->_config['alipayplat_partner']}&notify_id={$notify_id}";

        return (ecm_fopen($query_url, 60) === 'true');
    }

    /**
     *    获取签名字符串
     *
     *    @author    Garbin
     *    @param     array $params
     *    @return    string
     */
    function _get_sign($params) {
        /* 去除不参与签名的数据 */
        unset($params['sign'], $params['sign_type'], $params['order_id'], $params['app'], $params['act']);

        /* 排序 */
        ksort($params);
        reset($params);

        $sign = '';
        foreach ($params AS $key => $value) {
            $sign .= "{$key}={$value}&";
        }
        
        return md5(substr($sign, 0, -1) . $this->_config['alipayplat_key']);
    }

    /**
     *    验证签名是否可信
     *
     *    @author    Garbin
     *    @param     array $notify
     *    @return    bool
     */
    function _verify_sign($notify) {
        $local_sign = $this->_get_sign($notify);

        return ($local_sign == $notify['sign']);
    }

}

?>