<?php
/**
 * 欢迎使用
 *
 * AwMall微信商城系统!
 * 
 *
 * @版权  Copyright (c) 2014-2015 AwMall Inc. 
 * @官网  http://www.awcms.net/
 * @演示  http://awmall.awcms.net/
 * @作者  阿旺 QQ:532917920
 * @版本  Ver2.0  
 * @版号  201503024
**/

/**
 *    主题设置控制器
 *
 *    @author    Garbin
 *    @usage    none
 */
class WapthemeApp extends BackendApp
{
    /* 列表 */
    function index()
    {
        $themes = list_template('wapmall');
        $theme_list = array();
        foreach ($themes as $theme)
        {
            $theme_list[$theme] = list_style('wapmall', $theme);
        }
        $this->assign('curr_template_name', Conf::get('waptemplate_name'));
        $this->assign('curr_style_name', Conf::get('wapstyle_name'));
        $this->assign('theme_list', $theme_list);

        $this->display('waptheme.index.html');
    }
    function set()
    {
        $template_name = isset($_GET['template_name']) ? trim($_GET['template_name']) : null;
        $style_name = isset($_GET['style_name']) ? trim($_GET['style_name']) : null;
        if (!$template_name)
        {
            $this->show_warning('no_such_template');

            return;
        }
        if (!$style_name)
        {
            $this->show_warning('no_such_style');

            return;
        }
        $af_setting =& af('settings');
        $af_setting->setAll(array('waptemplate_name' => $template_name, 'wapstyle_name' => $style_name));

        $this->show_message('set_theme_successed');
    }
    function preview()
    {
        $template_name = isset($_POST['template_name']) ? trim($_POST['template_name']) : null;
        $style_name = isset($_POST['style_name']) ? trim($_POST['style_name']) : null;
        if (!$template_name)
        {
            $this->show_warning('no_such_template');

            return;
        }
        if (!$style_name)
        {
            $this->show_warning('no_such_style');

            return;
        }
        header('Location:' . SITE_URL . '/themes/wapmall/' .  $template_name . '/styles/' . $style_name . '/screenshot.jpg');
    }
}

?>