<?php
/* 快捷商城系统
 * 版本号：2.0
 * 官网：http://www.kjcms.cn
 * 2015-02-16
 */
class ctl_index extends mod_index{
	function act_default(){
		return $this->get_view();
	}
	function act_left() {
		$path = fun_get::get("path");
		$this->arr_list = cls_developer::get_list($path);
		return $this->get_view();
	}
	function act_file_open() {
		$path = fun_get::get("path");
		$file_cont = cls_developer::get_file_cont($path);
		return $file_cont;
	}
	function act_file_save() {
		$path = fun_get::get("path");
		$cont = fun_get::post("content");
		$arr = cls_developer::on_file_save($path , $cont);
		return fun_format::json($arr);
	}
	//取数据源表字段
	function act_datasource_fileds() {
		$table = fun_get::get("table");
		$fileds_list = cls_developer::get_fields($table);
		return fun_format::json($fileds_list);
	}
	function act_datasource_save() {
		$arr = $this->datasource_save();
		return fun_format::json($arr);
	}
	function act_datasource_del() {
		$arr = cls_developer::datasource_del(fun_get::get("dirname") , fun_get::get("typename") , fun_get::get("name"));
		return fun_format::json($arr);
	}
	function act_datasource(){
		$this->dirname = fun_get::get("dirname");
		$this->typename = fun_get::get("typename");
		$this->folder_all = cls_developer::get_datasource_folder($this->dirname);
		$this->foldername = '';
		if($this->typename == '') {
			$this->folder_list = $this->folder_all;
		} else {
			$this->foldername = $this->folder_all[$this->typename]['name'];
			$this->folder_list = array();
		}
		$this->arr_list = cls_developer::get_datasource_list($this->dirname , $this->typename);
		return $this->get_view();
	}
	function act_datasource_sys(){
		$this->dirname = fun_get::get("dirname");
		$this->arr_list = cls_developer::get_datasource_sys($this->dirname);
		return $this->get_view();
	}
	function act_datasource_sys_info(){
		$id = (int)fun_get::get("id");
		$this->sys_info = cls_developer::get_datasource_sys_info($id);
		return $this->get_view();
	}
	function act_datasource_info() {
		$this->dirname = fun_get::get("dirname");
		$this->typename = fun_get::get("typename");
		$this->name = fun_get::get("name");
		$this->table_list = cls_developer::get_tables();
		$datasource_info = cls_developer::get_datasource_info($this->dirname , $this->typename , $this->name);
		$arr_fields = $arr_fields_name = array();
		if(isset($datasource_info['seltable']) && !empty($datasource_info['seltable']) ) {
			$arr_fields = cls_developer::get_fields($datasource_info['seltable']);
			foreach($arr_fields as $item) {
				$arr_fields_name[$item['name']] = $item;
			}
		}
		$this->arr_fields = $arr_fields;
		$this->arr_fields_name = $arr_fields_name;
		$this->datasource_info = $datasource_info;
		$this->condition = array(
			"=" => "=" , 
			">" => ">" ,
			">=" => ">=",
			"<" => "<",
			"<=" => "<=",
			"in" => "包含",
			"not in" => "不包含",
			"left" => "左边等于",
			"right" => "右边等于",
			"like" => "匹配",
			"not like" => "不匹配",
		);
		$this->lefttag = '{';
		$this->righttag = '}';
		return $this->get_view();
	}
	function act_datasource_edit() {
		$this->dirname = fun_get::get("dirname");
		$this->typename = fun_get::get("typename");
		$this->name = fun_get::get("name");
		$this->table_list = cls_developer::get_tables();
		$datasource_info = cls_developer::get_datasource_info($this->dirname , $this->typename , $this->name);
		$arr_fields = $arr_fields_name = array();
		if(isset($datasource_info['seltable']) && !empty($datasource_info['seltable']) ) {
			$arr_fields = cls_developer::get_fields($datasource_info['seltable'],$this->table_list);
			foreach($arr_fields as $item) {
				$arr_fields_name[$item['name']] = $item;
			}
		}
		$this->arr_fields = $arr_fields;
		$this->arr_fields_name = $arr_fields_name;
		$this->datasource_info = $datasource_info;
		return $this->get_view();
	}
	function act_datasource_create() {
		$dirname = fun_get::get("dirname");
		$typename = fun_get::get("typename");
		$arr = cls_developer::datasource_create($dirname , $typename);
		return fun_format::json($arr);
	}
	function act_datasource_folder_save() {
		$arr = cls_developer::datasource_folder_create(fun_get::get("dirname") , fun_get::get("id"),fun_get::get("name"));
		return fun_format::json($arr);
	}
	function act_datasource_folder_del() {
		$arr = cls_developer::datasource_folder_del(fun_get::get("dirname") , fun_get::get("id"));
		return fun_format::json($arr);
	}
	function act_sys_config() {
		$this->arr_module = tab_sys_config::get_module();
		$this->module = fun_get::get("module");
		$str_module = $this->module;
		if(empty($str_module)) {
			list($key , $val) = each(array_slice($this->arr_module, 0,1));
			$this->module = $key;
		}
		$this->arr_list = $this->get_sys_config( $this->module );
		$this->lefttag = '{';
		$this->righttag = '}';
		return $this->get_view();
	}
	function act_rename() {
		$type = (int)fun_get::get("type");
		$oldname = fun_get::get("oldname");
		$newname = fun_get::get("newname");
		$dirname = fun_get::get("dirname");
		if($type == 1) {
			$arr = cls_developer::file_rename($dirname , $oldname , $newname);
		} else {
			$arr = cls_developer::folder_rename($dirname , $oldname , $newname);
		}
		return fun_format::json($arr);
	}

	function act_folder_create() {
		$name = fun_get::get("name");
		$arr = cls_developer::folder_create($name);
		return fun_format::json($arr);
	}
	function act_file_create() {
		$dirname = fun_get::get("dirname");
		$name = fun_get::get("name");
		$arr = cls_developer::file_create($dirname , $name);
		return fun_format::json($arr);
	}
	function act_folder_del() {
		$name = fun_get::get("name");
		$arr = cls_developer::folder_del($name);
		return fun_format::json($arr);
	}
	function act_file_del() {
		$dirname = fun_get::get("dirname");
		$name = fun_get::get("name");
		$arr = cls_developer::file_del($dirname , $name);
		return fun_format::json($arr);
	}
}